import{s as ut,n as mt,o as pt}from"../chunks/scheduler.8c3d61f6.js";import{S as ft,i as gt,g as i,s as n,r as u,A as ht,h as d,f as o,c as s,j as _,u as m,x as v,k as b,y as t,a as c,v as p,d as f,t as g,w as h}from"../chunks/index.da70eac4.js";import{D as $}from"../chunks/Docstring.6b390b9a.js";import{C as _t}from"../chunks/CodeBlock.00a903b3.js";import{H as ke,E as bt}from"../chunks/EditOnGithub.1e64e623.js";function vt(Qe){let T,le,ie,ce,D,ue,k,Ye='The 3D variational autoencoder (VAE) model with KL loss used in <a href="https://huggingface.co/Lightricks/LTX-Video" rel="nofollow">LTX</a> was introduced by Lightricks.',me,C,Je="The model can be loaded with the following code snippet.",pe,E,fe,M,ge,a,O,Ce,j,Be=`A VAE model with KL loss for encoding images into latents and decoding latent representations into images. Used in
<a href="https://huggingface.co/Lightricks/LTX-Video" rel="nofollow">LTX</a>.`,Ee,Q,et=`This model inherits from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,Me,Y,z,Oe,J,F,ze,x,U,Fe,B,tt=`Disable sliced VAE decoding. If <code>enable_slicing</code> was previously enabled, this method will go back to computing
decoding in one step.`,Ue,w,I,Ie,ee,ot=`Disable tiled VAE decoding. If <code>enable_tiling</code> was previously enabled, this method will go back to computing
decoding in one step.`,Pe,V,P,Ne,te,nt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,We,A,N,Ge,oe,st=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,He,X,W,Re,ne,rt="Decode a batch of images using a tiled decoder.",Ze,K,G,Se,se,at="Encode a batch of images using a tiled encoder.",he,H,_e,L,R,qe,re,it="Output of AutoencoderKL encoding method.",be,Z,ve,y,S,je,ae,dt="Output of decoding method.",$e,q,Te,de,Le;return D=new ke({props:{title:"AutoencoderKLLTXVideo",local:"autoencoderklltxvideo",headingTag:"h1"}}),E=new _t({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0xMVFhWaWRlbyUwQSUwQXZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyS0xMVFhWaWRlby5mcm9tX3ByZXRyYWluZWQoJTIyTGlnaHRyaWNrcyUyRkxUWC1WaWRlbyUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnZhZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMikudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLLTXVideo

vae = AutoencoderKLLTXVideo.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),M=new ke({props:{title:"AutoencoderKLLTXVideo",local:"diffusers.AutoencoderKLLTXVideo",headingTag:"h2"}}),O=new $({props:{name:"class diffusers.AutoencoderKLLTXVideo",anchor:"diffusers.AutoencoderKLLTXVideo",parameters:[{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 3"},{name:"latent_channels",val:": int = 128"},{name:"block_out_channels",val:": typing.Tuple[int, ...] = (128, 256, 512, 512)"},{name:"decoder_block_out_channels",val:": typing.Tuple[int, ...] = (128, 256, 512, 512)"},{name:"layers_per_block",val:": typing.Tuple[int, ...] = (4, 3, 3, 3, 4)"},{name:"decoder_layers_per_block",val:": typing.Tuple[int, ...] = (4, 3, 3, 3, 4)"},{name:"spatio_temporal_scaling",val:": typing.Tuple[bool, ...] = (True, True, True, False)"},{name:"decoder_spatio_temporal_scaling",val:": typing.Tuple[bool, ...] = (True, True, True, False)"},{name:"decoder_inject_noise",val:": typing.Tuple[bool, ...] = (False, False, False, False, False)"},{name:"upsample_residual",val:": typing.Tuple[bool, ...] = (False, False, False, False)"},{name:"upsample_factor",val:": typing.Tuple[int, ...] = (1, 1, 1, 1)"},{name:"timestep_conditioning",val:": bool = False"},{name:"patch_size",val:": int = 4"},{name:"patch_size_t",val:": int = 1"},{name:"resnet_norm_eps",val:": float = 1e-06"},{name:"scaling_factor",val:": float = 1.0"},{name:"encoder_causal",val:": bool = True"},{name:"decoder_causal",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.AutoencoderKLLTXVideo.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, defaults to <code>3</code>) &#x2014;
Number of input channels.`,name:"in_channels"},{anchor:"diffusers.AutoencoderKLLTXVideo.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, defaults to <code>3</code>) &#x2014;
Number of output channels.`,name:"out_channels"},{anchor:"diffusers.AutoencoderKLLTXVideo.latent_channels",description:`<strong>latent_channels</strong> (<code>int</code>, defaults to <code>128</code>) &#x2014;
Number of latent channels.`,name:"latent_channels"},{anchor:"diffusers.AutoencoderKLLTXVideo.block_out_channels",description:`<strong>block_out_channels</strong> (<code>Tuple[int, ...]</code>, defaults to <code>(128, 256, 512, 512)</code>) &#x2014;
The number of output channels for each block.`,name:"block_out_channels"},{anchor:"diffusers.AutoencoderKLLTXVideo.spatio_temporal_scaling",description:"<strong>spatio_temporal_scaling</strong> (<code>Tuple[bool, ...], defaults to </code>(True, True, True, False)` &#x2014;\nWhether a block should contain spatio-temporal downscaling or not.",name:"spatio_temporal_scaling"},{anchor:"diffusers.AutoencoderKLLTXVideo.layers_per_block",description:`<strong>layers_per_block</strong> (<code>Tuple[int, ...]</code>, defaults to <code>(4, 3, 3, 3, 4)</code>) &#x2014;
The number of layers per block.`,name:"layers_per_block"},{anchor:"diffusers.AutoencoderKLLTXVideo.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, defaults to <code>4</code>) &#x2014;
The size of spatial patches.`,name:"patch_size"},{anchor:"diffusers.AutoencoderKLLTXVideo.patch_size_t",description:`<strong>patch_size_t</strong> (<code>int</code>, defaults to <code>1</code>) &#x2014;
The size of temporal patches.`,name:"patch_size_t"},{anchor:"diffusers.AutoencoderKLLTXVideo.resnet_norm_eps",description:`<strong>resnet_norm_eps</strong> (<code>float</code>, defaults to <code>1e-6</code>) &#x2014;
Epsilon value for ResNet normalization layers.`,name:"resnet_norm_eps"},{anchor:"diffusers.AutoencoderKLLTXVideo.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://arxiv.org/abs/2112.10752" rel="nofollow">High-Resolution Image
Synthesis with Latent Diffusion Models</a> paper.`,name:"scaling_factor"},{anchor:"diffusers.AutoencoderKLLTXVideo.encoder_causal",description:`<strong>encoder_causal</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether the encoder should behave causally (future frames depend only on past frames) or not.`,name:"encoder_causal"},{anchor:"diffusers.AutoencoderKLLTXVideo.decoder_causal",description:`<strong>decoder_causal</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the decoder should behave causally (future frames depend only on past frames) or not.`,name:"decoder_causal"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L845"}}),z=new $({props:{name:"wrapper",anchor:"diffusers.AutoencoderKLLTXVideo.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/accelerate_utils.py#L43"}}),F=new $({props:{name:"wrapper",anchor:"diffusers.AutoencoderKLLTXVideo.encode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/accelerate_utils.py#L43"}}),U=new $({props:{name:"disable_slicing",anchor:"diffusers.AutoencoderKLLTXVideo.disable_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1025"}}),I=new $({props:{name:"disable_tiling",anchor:"diffusers.AutoencoderKLLTXVideo.disable_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1011"}}),P=new $({props:{name:"enable_slicing",anchor:"diffusers.AutoencoderKLLTXVideo.enable_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1018"}}),N=new $({props:{name:"enable_tiling",anchor:"diffusers.AutoencoderKLLTXVideo.enable_tiling",parameters:[{name:"tile_sample_min_height",val:": typing.Optional[int] = None"},{name:"tile_sample_min_width",val:": typing.Optional[int] = None"},{name:"tile_sample_min_num_frames",val:": typing.Optional[int] = None"},{name:"tile_sample_stride_height",val:": typing.Optional[float] = None"},{name:"tile_sample_stride_width",val:": typing.Optional[float] = None"},{name:"tile_sample_stride_num_frames",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.AutoencoderKLLTXVideo.enable_tiling.tile_sample_min_height",description:`<strong>tile_sample_min_height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum height required for a sample to be separated into tiles across the height dimension.`,name:"tile_sample_min_height"},{anchor:"diffusers.AutoencoderKLLTXVideo.enable_tiling.tile_sample_min_width",description:`<strong>tile_sample_min_width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum width required for a sample to be separated into tiles across the width dimension.`,name:"tile_sample_min_width"},{anchor:"diffusers.AutoencoderKLLTXVideo.enable_tiling.tile_sample_stride_height",description:`<strong>tile_sample_stride_height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum amount of overlap between two consecutive vertical tiles. This is to ensure that there are
no tiling artifacts produced across the height dimension.`,name:"tile_sample_stride_height"},{anchor:"diffusers.AutoencoderKLLTXVideo.enable_tiling.tile_sample_stride_width",description:`<strong>tile_sample_stride_width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The stride between two consecutive horizontal tiles. This is to ensure that there are no tiling
artifacts produced across the width dimension.`,name:"tile_sample_stride_width"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L977"}}),W=new $({props:{name:"tiled_decode",anchor:"diffusers.AutoencoderKLLTXVideo.tiled_decode",parameters:[{name:"z",val:": Tensor"},{name:"temb",val:": typing.Optional[torch.Tensor]"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.AutoencoderKLLTXVideo.tiled_decode.z",description:"<strong>z</strong> (<code>torch.Tensor</code>) &#x2014; Input batch of latent vectors.",name:"z"},{anchor:"diffusers.AutoencoderKLLTXVideo.tiled_decode.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~models.vae.DecoderOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1201",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If return_dict is True, a <code>~models.vae.DecoderOutput</code> is returned, otherwise a plain <code>tuple</code> is
returned.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~models.vae.DecoderOutput</code> or <code>tuple</code></p>
`}}),G=new $({props:{name:"tiled_encode",anchor:"diffusers.AutoencoderKLLTXVideo.tiled_encode",parameters:[{name:"x",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.AutoencoderKLLTXVideo.tiled_encode.x",description:"<strong>x</strong> (<code>torch.Tensor</code>) &#x2014; Input batch of videos.",name:"x"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_kl_ltx.py#L1150",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The latent representation of the encoded videos.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),H=new ke({props:{title:"AutoencoderKLOutput",local:"diffusers.models.modeling_outputs.AutoencoderKLOutput",headingTag:"h2"}}),R=new $({props:{name:"class diffusers.models.modeling_outputs.AutoencoderKLOutput",anchor:"diffusers.models.modeling_outputs.AutoencoderKLOutput",parameters:[{name:"latent_dist",val:": DiagonalGaussianDistribution"}],parametersDescription:[{anchor:"diffusers.models.modeling_outputs.AutoencoderKLOutput.latent_dist",description:`<strong>latent_dist</strong> (<code>DiagonalGaussianDistribution</code>) &#x2014;
Encoded outputs of <code>Encoder</code> represented as the mean and logvar of <code>DiagonalGaussianDistribution</code>.
<code>DiagonalGaussianDistribution</code> allows for sampling latents from the distribution.`,name:"latent_dist"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_outputs.py#L6"}}),Z=new ke({props:{title:"DecoderOutput",local:"diffusers.models.autoencoders.vae.DecoderOutput",headingTag:"h2"}}),S=new $({props:{name:"class diffusers.models.autoencoders.vae.DecoderOutput",anchor:"diffusers.models.autoencoders.vae.DecoderOutput",parameters:[{name:"sample",val:": Tensor"},{name:"commit_loss",val:": typing.Optional[torch.FloatTensor] = None"}],parametersDescription:[{anchor:"diffusers.models.autoencoders.vae.DecoderOutput.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
The decoded output sample from the last layer of the model.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/vae.py#L46"}}),q=new bt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/autoencoderkl_ltx_video.md"}}),{c(){T=i("meta"),le=n(),ie=i("p"),ce=n(),u(D.$$.fragment),ue=n(),k=i("p"),k.innerHTML=Ye,me=n(),C=i("p"),C.textContent=Je,pe=n(),u(E.$$.fragment),fe=n(),u(M.$$.fragment),ge=n(),a=i("div"),u(O.$$.fragment),Ce=n(),j=i("p"),j.innerHTML=Be,Ee=n(),Q=i("p"),Q.innerHTML=et,Me=n(),Y=i("div"),u(z.$$.fragment),Oe=n(),J=i("div"),u(F.$$.fragment),ze=n(),x=i("div"),u(U.$$.fragment),Fe=n(),B=i("p"),B.innerHTML=tt,Ue=n(),w=i("div"),u(I.$$.fragment),Ie=n(),ee=i("p"),ee.innerHTML=ot,Pe=n(),V=i("div"),u(P.$$.fragment),Ne=n(),te=i("p"),te.textContent=nt,We=n(),A=i("div"),u(N.$$.fragment),Ge=n(),oe=i("p"),oe.textContent=st,He=n(),X=i("div"),u(W.$$.fragment),Re=n(),ne=i("p"),ne.textContent=rt,Ze=n(),K=i("div"),u(G.$$.fragment),Se=n(),se=i("p"),se.textContent=at,he=n(),u(H.$$.fragment),_e=n(),L=i("div"),u(R.$$.fragment),qe=n(),re=i("p"),re.textContent=it,be=n(),u(Z.$$.fragment),ve=n(),y=i("div"),u(S.$$.fragment),je=n(),ae=i("p"),ae.textContent=dt,$e=n(),u(q.$$.fragment),Te=n(),de=i("p"),this.h()},l(e){const r=ht("svelte-u9bgzb",document.head);T=d(r,"META",{name:!0,content:!0}),r.forEach(o),le=s(e),ie=d(e,"P",{}),_(ie).forEach(o),ce=s(e),m(D.$$.fragment,e),ue=s(e),k=d(e,"P",{"data-svelte-h":!0}),v(k)!=="svelte-p2km9k"&&(k.innerHTML=Ye),me=s(e),C=d(e,"P",{"data-svelte-h":!0}),v(C)!=="svelte-1vuni30"&&(C.textContent=Je),pe=s(e),m(E.$$.fragment,e),fe=s(e),m(M.$$.fragment,e),ge=s(e),a=d(e,"DIV",{class:!0});var l=_(a);m(O.$$.fragment,l),Ce=s(l),j=d(l,"P",{"data-svelte-h":!0}),v(j)!=="svelte-3ppjd9"&&(j.innerHTML=Be),Ee=s(l),Q=d(l,"P",{"data-svelte-h":!0}),v(Q)!=="svelte-1hyu2ru"&&(Q.innerHTML=et),Me=s(l),Y=d(l,"DIV",{class:!0});var lt=_(Y);m(z.$$.fragment,lt),lt.forEach(o),Oe=s(l),J=d(l,"DIV",{class:!0});var ct=_(J);m(F.$$.fragment,ct),ct.forEach(o),ze=s(l),x=d(l,"DIV",{class:!0});var ye=_(x);m(U.$$.fragment,ye),Fe=s(ye),B=d(ye,"P",{"data-svelte-h":!0}),v(B)!=="svelte-189cc7b"&&(B.innerHTML=tt),ye.forEach(o),Ue=s(l),w=d(l,"DIV",{class:!0});var xe=_(w);m(I.$$.fragment,xe),Ie=s(xe),ee=d(xe,"P",{"data-svelte-h":!0}),v(ee)!=="svelte-1f366pl"&&(ee.innerHTML=ot),xe.forEach(o),Pe=s(l),V=d(l,"DIV",{class:!0});var we=_(V);m(P.$$.fragment,we),Ne=s(we),te=d(we,"P",{"data-svelte-h":!0}),v(te)!=="svelte-14bnrb6"&&(te.textContent=nt),we.forEach(o),We=s(l),A=d(l,"DIV",{class:!0});var Ve=_(A);m(N.$$.fragment,Ve),Ge=s(Ve),oe=d(Ve,"P",{"data-svelte-h":!0}),v(oe)!=="svelte-1xwrf7t"&&(oe.textContent=st),Ve.forEach(o),He=s(l),X=d(l,"DIV",{class:!0});var Ae=_(X);m(W.$$.fragment,Ae),Re=s(Ae),ne=d(Ae,"P",{"data-svelte-h":!0}),v(ne)!=="svelte-1vrxp2b"&&(ne.textContent=rt),Ae.forEach(o),Ze=s(l),K=d(l,"DIV",{class:!0});var Xe=_(K);m(G.$$.fragment,Xe),Se=s(Xe),se=d(Xe,"P",{"data-svelte-h":!0}),v(se)!=="svelte-1un5fcn"&&(se.textContent=at),Xe.forEach(o),l.forEach(o),he=s(e),m(H.$$.fragment,e),_e=s(e),L=d(e,"DIV",{class:!0});var Ke=_(L);m(R.$$.fragment,Ke),qe=s(Ke),re=d(Ke,"P",{"data-svelte-h":!0}),v(re)!=="svelte-1vsc7ag"&&(re.textContent=it),Ke.forEach(o),be=s(e),m(Z.$$.fragment,e),ve=s(e),y=d(e,"DIV",{class:!0});var De=_(y);m(S.$$.fragment,De),je=s(De),ae=d(De,"P",{"data-svelte-h":!0}),v(ae)!=="svelte-18u8upa"&&(ae.textContent=dt),De.forEach(o),$e=s(e),m(q.$$.fragment,e),Te=s(e),de=d(e,"P",{}),_(de).forEach(o),this.h()},h(){b(T,"name","hf:doc:metadata"),b(T,"content",$t),b(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,T),c(e,le,r),c(e,ie,r),c(e,ce,r),p(D,e,r),c(e,ue,r),c(e,k,r),c(e,me,r),c(e,C,r),c(e,pe,r),p(E,e,r),c(e,fe,r),p(M,e,r),c(e,ge,r),c(e,a,r),p(O,a,null),t(a,Ce),t(a,j),t(a,Ee),t(a,Q),t(a,Me),t(a,Y),p(z,Y,null),t(a,Oe),t(a,J),p(F,J,null),t(a,ze),t(a,x),p(U,x,null),t(x,Fe),t(x,B),t(a,Ue),t(a,w),p(I,w,null),t(w,Ie),t(w,ee),t(a,Pe),t(a,V),p(P,V,null),t(V,Ne),t(V,te),t(a,We),t(a,A),p(N,A,null),t(A,Ge),t(A,oe),t(a,He),t(a,X),p(W,X,null),t(X,Re),t(X,ne),t(a,Ze),t(a,K),p(G,K,null),t(K,Se),t(K,se),c(e,he,r),p(H,e,r),c(e,_e,r),c(e,L,r),p(R,L,null),t(L,qe),t(L,re),c(e,be,r),p(Z,e,r),c(e,ve,r),c(e,y,r),p(S,y,null),t(y,je),t(y,ae),c(e,$e,r),p(q,e,r),c(e,Te,r),c(e,de,r),Le=!0},p:mt,i(e){Le||(f(D.$$.fragment,e),f(E.$$.fragment,e),f(M.$$.fragment,e),f(O.$$.fragment,e),f(z.$$.fragment,e),f(F.$$.fragment,e),f(U.$$.fragment,e),f(I.$$.fragment,e),f(P.$$.fragment,e),f(N.$$.fragment,e),f(W.$$.fragment,e),f(G.$$.fragment,e),f(H.$$.fragment,e),f(R.$$.fragment,e),f(Z.$$.fragment,e),f(S.$$.fragment,e),f(q.$$.fragment,e),Le=!0)},o(e){g(D.$$.fragment,e),g(E.$$.fragment,e),g(M.$$.fragment,e),g(O.$$.fragment,e),g(z.$$.fragment,e),g(F.$$.fragment,e),g(U.$$.fragment,e),g(I.$$.fragment,e),g(P.$$.fragment,e),g(N.$$.fragment,e),g(W.$$.fragment,e),g(G.$$.fragment,e),g(H.$$.fragment,e),g(R.$$.fragment,e),g(Z.$$.fragment,e),g(S.$$.fragment,e),g(q.$$.fragment,e),Le=!1},d(e){e&&(o(le),o(ie),o(ce),o(ue),o(k),o(me),o(C),o(pe),o(fe),o(ge),o(a),o(he),o(_e),o(L),o(be),o(ve),o(y),o($e),o(Te),o(de)),o(T),h(D,e),h(E,e),h(M,e),h(O),h(z),h(F),h(U),h(I),h(P),h(N),h(W),h(G),h(H,e),h(R),h(Z,e),h(S),h(q,e)}}}const $t='{"title":"AutoencoderKLLTXVideo","local":"autoencoderklltxvideo","sections":[{"title":"AutoencoderKLLTXVideo","local":"diffusers.AutoencoderKLLTXVideo","sections":[],"depth":2},{"title":"AutoencoderKLOutput","local":"diffusers.models.modeling_outputs.AutoencoderKLOutput","sections":[],"depth":2},{"title":"DecoderOutput","local":"diffusers.models.autoencoders.vae.DecoderOutput","sections":[],"depth":2}],"depth":1}';function Tt(Qe){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends ft{constructor(T){super(),gt(this,T,Tt,vt,ut,{})}}export{At as component};
