import{s as Hm,n as Sm,o as Am}from"../chunks/scheduler.b108d059.js";import{S as Nm,i as Em,g as r,s as l,r as p,A as Rm,h as n,f as t,c as s,j as c,u,x as d,k as a,y as Bm,a as i,v as g,d as m,t as f,w as h}from"../chunks/index.008de539.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function Om(Bp){let L,vl,Pl,wl,b,yl,T,xl,P,Op="Classes, functions, and utilities for generation.",kl,$,jp="<strong>Todo</strong>",Cl,v,Gp="<li>Describe how to create a custom <code>GenerationConfig</code>.</li>",Ml,w,Fp='<li><a href="#module_utils/generation">utils/generation</a><ul><li><em>static</em><ul><li><a href="#module_utils/generation.LogitsProcessorList">.LogitsProcessorList</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_utils/generation.LogitsProcessorList_new"><code>new LogitsProcessorList()</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+push"><code>.push(item)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+extend"><code>.extend(items)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+_call"><code>._call(input_ids, batchedLogits)</code></a></li></ul></li> <li><a href="#module_utils/generation.LogitsProcessor">.LogitsProcessor</a> ⇐ <code>Callable</code><ul><li><em><a href="#module_utils/generation.LogitsProcessor+_call"><code>._call(input_ids, logits)</code></a></em></li></ul></li> <li><a href="#module_utils/generation.ForceTokensLogitsProcessor">.ForceTokensLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForceTokensLogitsProcessor_new"><code>new ForceTokensLogitsProcessor(forced_decoder_ids)</code></a></li> <li><a href="#module_utils/generation.ForceTokensLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor">.ForcedBOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedBOSTokenLogitsProcessor_new"><code>new ForcedBOSTokenLogitsProcessor(bos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor">.ForcedEOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedEOSTokenLogitsProcessor_new"><code>new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a></li></ul></li> <li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor">.SuppressTokensAtBeginLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.SuppressTokensAtBeginLogitsProcessor_new"><code>new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)</code></a></li> <li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor">.WhisperTimeStampLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.WhisperTimeStampLogitsProcessor_new"><code>new WhisperTimeStampLogitsProcessor(generate_config)</code></a></li> <li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor">.NoRepeatNGramLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.NoRepeatNGramLogitsProcessor_new"><code>new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)</code></a></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getNgrams"><code>.getNgrams(prevInputIds)</code></a> ⇒ <code>Map.&lt;string, Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getGeneratedNgrams"><code>.getGeneratedNgrams(bannedNgrams, prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+calcBannedNgramTokens"><code>.calcBannedNgramTokens(prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor">.RepetitionPenaltyLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.RepetitionPenaltyLogitsProcessor_new"><code>new RepetitionPenaltyLogitsProcessor(penalty)</code></a></li> <li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.MinLengthLogitsProcessor">.MinLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinLengthLogitsProcessor_new"><code>new MinLengthLogitsProcessor(min_length, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor">.MinNewTokensLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinNewTokensLengthLogitsProcessor_new"><code>new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.NoBadWordsLogitsProcessor">.NoBadWordsLogitsProcessor</a><ul><li><a href="#new_module_utils/generation.NoBadWordsLogitsProcessor_new"><code>new NoBadWordsLogitsProcessor(bad_words_ids, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.NoBadWordsLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.Sampler">.Sampler</a><ul><li><a href="#new_module_utils/generation.Sampler_new"><code>new Sampler(generation_config)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/generation.Sampler+_call"><code>._call(logits, index)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/generation.Sampler+sample"><code>.sample(logits, index)</code></a></li> <li><a href="#module_utils/generation.Sampler+getLogits"><code>.getLogits(logits, index)</code></a> ⇒ <code>Float32Array</code></li> <li><a href="#module_utils/generation.Sampler+randomSelect"><code>.randomSelect(probabilities)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/generation.Sampler.getSampler"><code>.getSampler(generation_config)</code></a> ⇒ <code>Sampler</code></li></ul></li></ul></li> <li><a href="#module_utils/generation.GenerationConfig"><code>.GenerationConfig</code></a> : <code>*</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/generation..GenerationConfig">~GenerationConfig</a><ul><li><a href="#new_module_utils/generation..GenerationConfig_new"><code>new GenerationConfig(kwargs)</code></a></li></ul></li> <li><a href="#module_utils/generation..GreedySampler">~GreedySampler</a> ⇐ <code>Sampler</code><ul><li><a href="#module_utils/generation..GreedySampler+sample"><code>.sample(logits, [index])</code></a> ⇒ <code>Array</code></li></ul></li> <li><a href="#module_utils/generation..MultinomialSampler">~MultinomialSampler</a> ⇐ <code>Sampler</code><ul><li><a href="#module_utils/generation..MultinomialSampler+sample"><code>.sample(logits, index)</code></a> ⇒ <code>Array</code></li></ul></li> <li><a href="#module_utils/generation..BeamSearchSampler">~BeamSearchSampler</a> ⇐ <code>Sampler</code><ul><li><a href="#module_utils/generation..BeamSearchSampler+sample"><code>.sample(logits, index)</code></a> ⇒ <code>Array</code></li></ul></li> <li><a href="#module_utils/generation..GenerationConfigType"><code>~GenerationConfigType</code></a> : <code>Object</code></li></ul></li></ul></li>',Hl,Sl,Al,y,Nl,x,El,k,Ip=`A class representing a list of logits processors. A logits processor is a function that modifies the logits
output of a language model. This class provides methods for adding new processors and applying all processors to a
batch of logits.`,Rl,C,qp='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',Bl,M,Dp='<li><a href="#module_utils/generation.LogitsProcessorList">.LogitsProcessorList</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_utils/generation.LogitsProcessorList_new"><code>new LogitsProcessorList()</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+push"><code>.push(item)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+extend"><code>.extend(items)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+_call"><code>._call(input_ids, batchedLogits)</code></a></li></ul></li>',Ol,jl,Gl,H,Fl,S,Il,A,Wp="Constructs a new instance of <code>LogitsProcessorList</code>.",ql,Dl,Wl,N,zl,E,Kl,R,zp="Adds a new logits processor to the list.",Ul,B,Kp='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.LogitsProcessorList"><code>LogitsProcessorList</code></a>',Jl,O,Up="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>LogitsProcessor</code></td><td><p>The logits processor function to add.</p></td></tr></tbody>",Ql,Vl,Xl,j,Yl,G,Zl,F,Jp="Adds multiple logits processors to the list.",es,I,Qp='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.LogitsProcessorList"><code>LogitsProcessorList</code></a>',ts,q,Vp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>items</td><td><code>Array.&lt;LogitsProcessor&gt;</code></td><td><p>The logits processor functions to add.</p></td></tr></tbody>",os,is,ls,D,ss,W,rs,z,Xp="Applies all logits processors in the list to a batch of logits, modifying them in-place.",ns,K,Yp='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.LogitsProcessorList"><code>LogitsProcessorList</code></a>',ds,U,Zp=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array.&lt;number&gt;</code></td><td><p>The input IDs for the language model.</p></td> </tr><tr><td>batchedLogits</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><p>A 2D array of logits, where each row corresponds to a single
                                               input sequence in the batch.</p></td></tr></tbody>`,as,cs,ps,J,us,Q,gs,V,eu="Base class for processing logits.",ms,X,tu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',fs,hs,_s,Y,Ls,Z,bs,ee,ou="Apply the processor to the input logits.",Ts,te,iu='<strong>Kind</strong>: instance abstract method of <a href="#module_utils/generation.LogitsProcessor"><code>LogitsProcessor</code></a><br/> <strong>Throws</strong>:',Ps,oe,lu="<li><code>Error</code> Throws an error if `_call` is not implemented in the subclass.</li>",$s,ie,su="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input ids.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits to process.</p></td></tr></tbody>",vs,ws,ys,le,xs,se,ks,re,ru="A logits processor that forces a specific token to be generated by the decoder.",Cs,ne,nu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Ms,de,du='<li><a href="#module_utils/generation.ForceTokensLogitsProcessor">.ForceTokensLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForceTokensLogitsProcessor_new"><code>new ForceTokensLogitsProcessor(forced_decoder_ids)</code></a></li> <li><a href="#module_utils/generation.ForceTokensLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li>',Hs,Ss,As,ae,Ns,ce,Es,pe,au="Constructs a new instance of <code>ForceTokensLogitsProcessor</code>.",Rs,ue,cu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>forced_decoder_ids</td><td><code>Array</code></td><td><p>The ids of tokens that should be forced.</p></td></tr></tbody>",Bs,Os,js,ge,Gs,me,Fs,fe,pu="Apply the processor to the input logits.",Is,he,uu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.ForceTokensLogitsProcessor"><code>ForceTokensLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The processed logits.',qs,_e,gu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input ids.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits to process.</p></td></tr></tbody>",Ds,Ws,zs,Le,Ks,be,Us,Te,mu="A LogitsProcessor that forces a BOS token at the beginning of the generated sequence.",Js,Pe,fu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Qs,$e,hu='<li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor">.ForcedBOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedBOSTokenLogitsProcessor_new"><code>new ForcedBOSTokenLogitsProcessor(bos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',Vs,Xs,Ys,ve,Zs,we,er,ye,_u="Create a ForcedBOSTokenLogitsProcessor.",tr,xe,Lu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>bos_token_id</td><td><code>number</code></td><td><p>The ID of the beginning-of-sequence token to be forced.</p></td></tr></tbody>",or,ir,lr,ke,sr,Ce,rr,Me,bu="Apply the BOS token forcing to the logits.",nr,He,Tu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor"><code>ForcedBOSTokenLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with BOS token forcing.',dr,Se,Pu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",ar,cr,pr,Ae,ur,Ne,gr,Ee,$u="A logits processor that forces end-of-sequence token probability to 1.",mr,Re,vu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',fr,Be,wu='<li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor">.ForcedEOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedEOSTokenLogitsProcessor_new"><code>new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a></li></ul></li>',hr,_r,Lr,Oe,br,je,Tr,Ge,yu="Create a ForcedEOSTokenLogitsProcessor.",Pr,Fe,xu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>max_length</td><td><code>number</code></td><td><p>Max length of the sequence.</p></td> </tr><tr><td>forced_eos_token_id</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><p>The ID of the end-of-sequence token to be forced.</p></td></tr></tbody>",$r,vr,wr,Ie,yr,qe,xr,De,ku="Apply the processor to input_ids and logits.",kr,We,Cu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor"><code>ForcedEOSTokenLogitsProcessor</code></a>',Cr,ze,Mu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array.&lt;number&gt;</code></td><td><p>The input ids.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits tensor.</p></td></tr></tbody>",Mr,Hr,Sr,Ke,Ar,Ue,Nr,Je,Hu=`A LogitsProcessor that suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by
<code>begin_suppress_tokens</code> at not sampled at the begining of the generation.`,Er,Qe,Su='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Rr,Ve,Au='<li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor">.SuppressTokensAtBeginLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.SuppressTokensAtBeginLogitsProcessor_new"><code>new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)</code></a></li> <li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',Br,Or,jr,Xe,Gr,Ye,Fr,Ze,Nu="Create a SuppressTokensAtBeginLogitsProcessor.",Ir,et,Eu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>begin_suppress_tokens</td><td><code>Array.&lt;number&gt;</code></td><td><p>The IDs of the tokens to suppress.</p></td> </tr><tr><td>begin_index</td><td><code>number</code></td><td><p>The number of tokens to generate before suppressing tokens.</p></td></tr></tbody>",qr,Dr,Wr,tt,zr,ot,Kr,it,Ru="Apply the BOS token forcing to the logits.",Ur,lt,Bu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor"><code>SuppressTokensAtBeginLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with BOS token forcing.',Jr,st,Ou="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",Qr,Vr,Xr,rt,Yr,nt,Zr,dt,ju="A LogitsProcessor that handles adding timestamps to generated text.",en,at,Gu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',tn,ct,Fu='<li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor">.WhisperTimeStampLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.WhisperTimeStampLogitsProcessor_new"><code>new WhisperTimeStampLogitsProcessor(generate_config)</code></a></li> <li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li>',on,ln,sn,pt,rn,ut,nn,gt,Iu="Constructs a new WhisperTimeStampLogitsProcessor.",dn,mt,qu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>generate_config</td><td><code>Object</code></td><td><p>The config object passed to the <code>generate()</code> method of a transformer model.</p></td> </tr><tr><td>generate_config.eos_token_id</td><td><code>number</code></td><td><p>The ID of the end-of-sequence token.</p></td> </tr><tr><td>generate_config.no_timestamps_token_id</td><td><code>number</code></td><td><p>The ID of the token used to indicate that a token should not have a timestamp.</p></td> </tr><tr><td>[generate_config.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><p>An array of two-element arrays representing decoder IDs that are forced to appear in the output. The second element of each array indicates whether the token is a timestamp.</p></td> </tr><tr><td>[generate_config.max_initial_timestamp_index]</td><td><code>number</code></td><td><p>The maximum index at which an initial timestamp can appear.</p></td></tr></tbody>",an,cn,pn,ft,un,ht,gn,_t,Du="Modify the logits to handle timestamp tokens.",mn,Lt,Wu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.WhisperTimeStampLogitsProcessor"><code>WhisperTimeStampLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The modified logits.',fn,bt,zu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input sequence of tokens.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits output by the model.</p></td></tr></tbody>",hn,_n,Ln,Tt,bn,Pt,Tn,$t,Ku="A logits processor that disallows ngrams of a certain size to be repeated.",Pn,vt,Uu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',$n,wt,Ju='<li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor">.NoRepeatNGramLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.NoRepeatNGramLogitsProcessor_new"><code>new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)</code></a></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getNgrams"><code>.getNgrams(prevInputIds)</code></a> ⇒ <code>Map.&lt;string, Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getGeneratedNgrams"><code>.getGeneratedNgrams(bannedNgrams, prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+calcBannedNgramTokens"><code>.calcBannedNgramTokens(prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',vn,wn,yn,yt,xn,xt,kn,kt,Qu="Create a NoRepeatNGramLogitsProcessor.",Cn,Ct,Vu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>no_repeat_ngram_size</td><td><code>number</code></td><td><p>The no-repeat-ngram size. All ngrams of this size can only occur once.</p></td></tr></tbody>",Mn,Hn,Sn,Mt,An,Ht,Nn,St,Xu="Generate n-grams from a sequence of token ids.",En,At,Yu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Map.&lt;string, Array&lt;number&gt;&gt;</code> - Map of generated n-grams',Rn,Nt,Zu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>prevInputIds</td><td><code>Array.&lt;number&gt;</code></td><td><p>List of previous input ids</p></td></tr></tbody>",Bn,On,jn,Et,Gn,Rt,Fn,Bt,eg="Generate n-grams from a sequence of token ids.",In,Ot,tg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - Map of generated n-grams',qn,jt,og="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>bannedNgrams</td><td><code>Map.&lt;string, Array&lt;number&gt;&gt;</code></td><td><p>Map of banned n-grams</p></td> </tr><tr><td>prevInputIds</td><td><code>Array.&lt;number&gt;</code></td><td><p>List of previous input ids</p></td></tr></tbody>",Dn,Wn,zn,Gt,Kn,Ft,Un,It,ig="Calculate banned n-gram tokens",Jn,qt,lg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - Map of generated n-grams',Qn,Dt,sg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>prevInputIds</td><td><code>Array.&lt;number&gt;</code></td><td><p>List of previous input ids</p></td></tr></tbody>",Vn,Xn,Yn,Wt,Zn,zt,ed,Kt,rg="Apply the no-repeat-ngram processor to the logits.",td,Ut,ng='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with no-repeat-ngram processing.',od,Jt,dg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",id,ld,sd,Qt,rd,Vt,nd,Xt,ag="A logits processor that penalises repeated output tokens.",dd,Yt,cg='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',ad,Zt,pg='<li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor">.RepetitionPenaltyLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.RepetitionPenaltyLogitsProcessor_new"><code>new RepetitionPenaltyLogitsProcessor(penalty)</code></a></li> <li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',cd,pd,ud,eo,gd,to,md,oo,ug="Create a RepetitionPenaltyLogitsProcessor.",fd,io,gg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>penalty</td><td><code>number</code></td><td><p>The penalty to apply for repeated tokens.</p></td></tr></tbody>",hd,_d,Ld,lo,bd,so,Td,ro,mg="Apply the repetition penalty to the logits.",Pd,no,fg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor"><code>RepetitionPenaltyLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with repetition penalty processing.',$d,ao,hg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",vd,wd,yd,co,xd,po,kd,uo,_g="A logits processor that enforces a minimum number of tokens.",Cd,go,Lg='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Md,mo,bg='<li><a href="#module_utils/generation.MinLengthLogitsProcessor">.MinLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinLengthLogitsProcessor_new"><code>new MinLengthLogitsProcessor(min_length, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',Hd,Sd,Ad,fo,Nd,ho,Ed,_o,Tg="Create a MinLengthLogitsProcessor.",Rd,Lo,Pg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min_length</td><td><code>number</code></td><td><p>The minimum length below which the score of <code>eos_token_id</code> is set to negative infinity.</p></td> </tr><tr><td>eos_token_id</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><p>The ID/IDs of the end-of-sequence token.</p></td></tr></tbody>",Bd,Od,jd,bo,Gd,To,Fd,Po,$g="Apply logit processor.",Id,$o,vg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.MinLengthLogitsProcessor"><code>MinLengthLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The processed logits.',qd,vo,wg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",Dd,Wd,zd,wo,Kd,yo,Ud,xo,yg="A logits processor that enforces a minimum number of new tokens.",Jd,ko,xg='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Qd,Co,kg='<li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor">.MinNewTokensLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinNewTokensLengthLogitsProcessor_new"><code>new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',Vd,Xd,Yd,Mo,Zd,Ho,ea,So,Cg="Create a MinNewTokensLengthLogitsProcessor.",ta,Ao,Mg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>prompt_length_to_skip</td><td><code>number</code></td><td><p>The input tokens length.</p></td> </tr><tr><td>min_new_tokens</td><td><code>number</code></td><td><p>The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to negative infinity.</p></td> </tr><tr><td>eos_token_id</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><p>The ID/IDs of the end-of-sequence token.</p></td></tr></tbody>",oa,ia,la,No,sa,Eo,ra,Ro,Hg="Apply logit processor.",na,Bo,Sg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor"><code>MinNewTokensLengthLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The processed logits.',da,Oo,Ag="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",aa,ca,pa,jo,ua,Go,ga,Fo,Ng='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a>',ma,Io,Eg='<li><a href="#module_utils/generation.NoBadWordsLogitsProcessor">.NoBadWordsLogitsProcessor</a><ul><li><a href="#new_module_utils/generation.NoBadWordsLogitsProcessor_new"><code>new NoBadWordsLogitsProcessor(bad_words_ids, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.NoBadWordsLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',fa,ha,_a,qo,La,Do,ba,Wo,Rg="Create a <code>NoBadWordsLogitsProcessor</code>.",Ta,zo,Bg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>bad_words_ids</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><p>List of list of token ids that are not allowed to be generated.</p></td> </tr><tr><td>eos_token_id</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><p>The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.</p></td></tr></tbody>",Pa,$a,va,Ko,wa,Uo,ya,Jo,Og="Apply logit processor.",xa,Qo,jg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoBadWordsLogitsProcessor"><code>NoBadWordsLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The processed logits.',ka,Vo,Gg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",Ca,Ma,Ha,Xo,Sa,Yo,Aa,Zo,Fg="Sampler is a base class for all sampling methods used for text generation.",Na,ei,Ig='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a>',Ea,ti,qg='<li><a href="#module_utils/generation.Sampler">.Sampler</a><ul><li><a href="#new_module_utils/generation.Sampler_new"><code>new Sampler(generation_config)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/generation.Sampler+_call"><code>._call(logits, index)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/generation.Sampler+sample"><code>.sample(logits, index)</code></a></li> <li><a href="#module_utils/generation.Sampler+getLogits"><code>.getLogits(logits, index)</code></a> ⇒ <code>Float32Array</code></li> <li><a href="#module_utils/generation.Sampler+randomSelect"><code>.randomSelect(probabilities)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/generation.Sampler.getSampler"><code>.getSampler(generation_config)</code></a> ⇒ <code>Sampler</code></li></ul></li></ul></li>',Ra,Ba,Oa,oi,ja,ii,Ga,li,Dg="Creates a new Sampler object with the specified generation config.",Fa,si,Wg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>generation_config</td><td><code>GenerationConfigType</code></td><td><p>The generation config.</p></td></tr></tbody>",Ia,qa,Da,ri,Wa,ni,za,di,zg="Executes the sampler, using the specified logits.",Ka,ai,Kg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a>',Ua,ci,Ug="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",Ja,Qa,Va,pi,Xa,ui,Ya,gi,Jg="Abstract method for sampling the logits.",Za,mi,Qg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a><br/> <strong>Throws</strong>:',ec,fi,Vg="<li><code>Error</code></li>",tc,hi,Xg="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",oc,ic,lc,_i,sc,Li,rc,bi,Yg="Returns the specified logits as an array, with temperature applied.",nc,Ti,Zg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a>',dc,Pi,em="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",ac,cc,pc,$i,uc,vi,gc,wi,tm="Selects an item randomly based on the specified probabilities.",mc,yi,om='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the selected item.',fc,xi,im="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>probabilities</td><td><code>Array</code></td><td><p>An array of probabilities to use for selection.</p></td></tr></tbody>",hc,_c,Lc,ki,bc,Ci,Tc,Mi,lm="Returns a Sampler object based on the specified options.",Pc,Hi,sm='<strong>Kind</strong>: static method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a><br/> <strong>Returns</strong>: <code>Sampler</code> - A Sampler object.',$c,Si,rm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>generation_config</td><td><code>GenerationConfigType</code></td><td><p>An object containing options for the sampler.</p></td></tr></tbody>",vc,wc,yc,Ai,xc,Ni,kc,Ei,nm="Class that holds a configuration for a generation task.",Cc,Ri,dm='<strong>Kind</strong>: static constant of <a href="#module_utils/generation"><code>utils/generation</code></a>',Mc,Hc,Sc,Bi,Ac,Oi,Nc,ji,am='<strong>Kind</strong>: inner class of <a href="#module_utils/generation"><code>utils/generation</code></a>',Ec,Rc,Bc,Gi,Oc,Fi,jc,Ii,cm="Create a new GenerationConfig object.",Gc,qi,pm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>kwargs</td><td><code>GenerationConfigType</code></td></tr></tbody>",Fc,Ic,qc,Di,Dc,Wi,Wc,zi,um="Class representing a Greedy Sampler.",zc,Ki,gm='<strong>Kind</strong>: inner class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Sampler</code>',Kc,Uc,Jc,Ui,Qc,Ji,Vc,Qi,mm="Sample the maximum probability of a given logits tensor.",Xc,Vi,fm='<strong>Kind</strong>: instance method of <a href="#module_utils/generation..GreedySampler"><code>GreedySampler</code></a><br/> <strong>Returns</strong>: <code>Array</code> - An array with a single tuple, containing the index of the maximum value and a meaningless score (since this is a greedy search).',Yc,Xi,hm="<thead><tr><th>Param</th><th>Type</th><th>Default</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td><td></td> </tr><tr><td>[index]</td><td><code>number</code></td><td><code>-1</code></td></tr></tbody>",Zc,ep,tp,Yi,op,Zi,ip,el,_m="Class representing a MultinomialSampler.",lp,tl,Lm='<strong>Kind</strong>: inner class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Sampler</code>',sp,rp,np,ol,dp,il,ap,ll,bm="Sample from the logits.",cp,sl,Tm='<strong>Kind</strong>: instance method of <a href="#module_utils/generation..MultinomialSampler"><code>MultinomialSampler</code></a>',pp,rl,Pm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",up,gp,mp,nl,fp,dl,hp,al,$m="Class representing a BeamSearchSampler.",_p,cl,vm='<strong>Kind</strong>: inner class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Sampler</code>',Lp,bp,Tp,pl,Pp,ul,$p,gl,wm="Sample from the logits.",vp,ml,ym='<strong>Kind</strong>: instance method of <a href="#module_utils/generation..BeamSearchSampler"><code>BeamSearchSampler</code></a>',wp,fl,xm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",yp,xp,kp,hl,Cp,_l,Mp,Ll,km="The default configuration parameters.",Hp,bl,Cm='<strong>Kind</strong>: inner typedef of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Properties</strong>',Sp,Tl,Mm='<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[max_length]</td><td><code>number</code></td><td><code>20</code></td><td><p>The maximum length the generated tokens can have. Corresponds to the length of the input prompt + <code>max_new_tokens</code>. Its effect is overridden by <code>max_new_tokens</code>, if also set.</p></td> </tr><tr><td>[max_new_tokens]</td><td><code>number</code></td><td><code></code></td><td><p>The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.</p></td> </tr><tr><td>[min_length]</td><td><code>number</code></td><td><code>0</code></td><td><p>The minimum length of the sequence to be generated. Corresponds to the length of the input prompt + <code>min_new_tokens</code>. Its effect is overridden by <code>min_new_tokens</code>, if also set.</p></td> </tr><tr><td>[min_new_tokens]</td><td><code>number</code></td><td><code></code></td><td><p>The minimum numbers of tokens to generate, ignoring the number of tokens in the prompt.</p></td> </tr><tr><td>[early_stopping]</td><td><code>boolean</code> | <code>&quot;never&quot;</code></td><td><code>false</code></td><td><p>Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:</p> <ul><li><code>true</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates;</li> <li><code>false</code>, where an heuristic is applied and the generation stops when is it very unlikely to find better candidates;</li> <li><code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical beam search algorithm).</li></ul></td> </tr><tr><td>[max_time]</td><td><code>number</code></td><td><code></code></td><td><p>The maximum amount of time you allow the computation to run for in seconds. Generation will still finish the current pass after allocated time has been passed.</p></td> </tr><tr><td>[do_sample]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to use sampling; use greedy decoding otherwise.</p></td> </tr><tr><td>[num_beams]</td><td><code>number</code></td><td><code>1</code></td><td><p>Number of beams for beam search. 1 means no beam search.</p></td> </tr><tr><td>[num_beam_groups]</td><td><code>number</code></td><td><code>1</code></td><td><p>Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams. See <a href="https://arxiv.org/pdf/1610.02424.pdf">this paper</a> for more details.</p></td> </tr><tr><td>[penalty_alpha]</td><td><code>number</code></td><td><code></code></td><td><p>The values balance the model confidence and the degeneration penalty in contrastive search decoding.</p></td> </tr><tr><td>[use_cache]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether or not the model should use the past last key/values attentions (if applicable to the model) to speed up decoding.</p></td> </tr><tr><td>[temperature]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>The value used to modulate the next token probabilities.</p></td> </tr><tr><td>[top_k]</td><td><code>number</code></td><td><code>50</code></td><td><p>The number of highest probability vocabulary tokens to keep for top-k-filtering.</p></td> </tr><tr><td>[top_p]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or higher are kept for generation.</p></td> </tr><tr><td>[typical_p]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Local typicality measures how similar the conditional probability of predicting a target token next is to the expected conditional probability of predicting a random token next, given the partial text already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf">this paper</a> for more details.</p></td> </tr><tr><td>[epsilon_cutoff]</td><td><code>number</code></td><td><code>0.0</code></td><td><p>If set to float strictly between 0 and 1, only tokens with a conditional probability greater than <code>epsilon_cutoff</code> will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191">Truncation Sampling as Language Model Desmoothing</a> for more details.</p></td> </tr><tr><td>[eta_cutoff]</td><td><code>number</code></td><td><code>0.0</code></td><td><p>Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly between 0 and 1, a token is only considered if it is greater than either <code>eta_cutoff</code> or <code>sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits)))</code>. The latter term is intuitively the expected next token probability, scaled by <code>sqrt(eta_cutoff)</code>. In the paper, suggested values range from 3e-4 to 2e-3, depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191">Truncation Sampling as Language Model Desmoothing</a> for more details.</p></td> </tr><tr><td>[diversity_penalty]</td><td><code>number</code></td><td><code>0.0</code></td><td><p>This value is subtracted from a beam&#39;s score if it generates a token same as any beam from other group at a particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.</p></td> </tr><tr><td>[repetition_penalty]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf">this paper</a> for more details.</p></td> </tr><tr><td>[encoder_repetition_penalty]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>The paramater for encoder_repetition_penalty. An exponential penalty on sequences that are not in the original input. 1.0 means no penalty.</p></td> </tr><tr><td>[length_penalty]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while <code>length_penalty</code> &lt; 0.0 encourages shorter sequences.</p></td> </tr><tr><td>[no_repeat_ngram_size]</td><td><code>number</code></td><td><code>0</code></td><td><p>If set to int &gt; 0, all ngrams of that size can only occur once.</p></td> </tr><tr><td>[bad_words_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>List of token ids that are not allowed to be generated. In order to get the token ids of the words that should not appear in the generated text, use <code>(await tokenizer(bad_words, {add_prefix_space: true, add_special_tokens: false})).input_ids</code>.</p></td> </tr><tr><td>[force_words_ids]</td><td><code>Array&lt;Array&lt;number&gt;&gt;</code> | <code>Array&lt;Array&lt;Array&lt;number&gt;&gt;&gt;</code></td><td><code></code></td><td><p>List of token ids that must be generated. If given a <code>number[][]</code>, this is treated as a simple list of words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>number[][][]</code>, this triggers a <a href="https://github.com/huggingface/transformers/issues/14081">disjunctive constraint</a>, where one can allow different forms of each word.</p></td> </tr><tr><td>[renormalize_logits]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to renormalize the logits after applying all the logits processors or warpers (including the custom ones). It&#39;s highly recommended to set this flag to <code>true</code> as the search algorithms suppose the score logits are normalized but some logit processors or warpers break the normalization.</p></td> </tr><tr><td>[constraints]</td><td><code>Array.&lt;Object&gt;</code></td><td><code></code></td><td><p>Custom constraints that can be added to the generation to ensure that the output will contain the use of certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.</p></td> </tr><tr><td>[forced_bos_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for multilingual models like mBART where the first generated token needs to be the target language token.</p></td> </tr><tr><td>[forced_eos_token_id]</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><code></code></td><td><p>The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.</p></td> </tr><tr><td>[remove_invalid_values]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash. Note that using <code>remove_invalid_values</code> can slow down generation.</p></td> </tr><tr><td>[exponential_decay_length_penalty]</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty starts and <code>decay_factor</code> represents the factor of exponential decay.</p></td> </tr><tr><td>[suppress_tokens]</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>A list of tokens that will be suppressed at generation. The <code>SupressTokens</code> logit processor will set their log probs to <code>-inf</code> so that they are not sampled.</p></td> </tr><tr><td>[begin_suppress_tokens]</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>A list of tokens that will be suppressed at the beginning of the generation. The <code>SupressBeginTokens</code> logit processor will set their log probs to <code>-inf</code> so that they are not sampled.</p></td> </tr><tr><td>[forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>A list of pairs of integers which indicates a mapping from generation indices to token indices that will be forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token of index 123.</p></td> </tr><tr><td>[num_return_sequences]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of independently computed returned sequences for each element in the batch.</p></td> </tr><tr><td>[output_attentions]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned tensors for more details.</p></td> </tr><tr><td>[output_hidden_states]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for more details.</p></td> </tr><tr><td>[output_scores]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.</p></td> </tr><tr><td>[return_dict_in_generate]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.</p></td> </tr><tr><td>[pad_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>The id of the <em>padding</em> token.</p></td> </tr><tr><td>[bos_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>The id of the <em>beginning-of-sequence</em> token.</p></td> </tr><tr><td>[eos_token_id]</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><code></code></td><td><p>The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.</p></td> </tr><tr><td>[encoder_no_repeat_ngram_size]</td><td><code>number</code></td><td><code>0</code></td><td><p>If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the <code>decoder_input_ids</code>.</p></td> </tr><tr><td>[decoder_start_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.</p></td> </tr><tr><td>[generation_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Additional generation kwargs will be forwarded to the <code>generate</code> function of the model. Kwargs that are not present in <code>generate</code>&#39;s signature will be used in the model forward pass.</p></td></tr></tbody>',Ap,Np,Ep,$l,Rp;return T=new _({props:{title:"utils/generation",local:"utilsgeneration",headingTag:"h1"}}),x=new _({props:{title:"utils/generation.LogitsProcessorList ⇐ <code> Callable </code>",local:"utilsgenerationlogitsprocessorlist--code-callable-code",headingTag:"h2"}}),S=new _({props:{title:"new LogitsProcessorList()",local:"new-logitsprocessorlist",headingTag:"h3"}}),E=new _({props:{title:"logitsProcessorList.push(item)",local:"logitsprocessorlistpushitem",headingTag:"h3"}}),G=new _({props:{title:"logitsProcessorList.extend(items)",local:"logitsprocessorlistextenditems",headingTag:"h3"}}),W=new _({props:{title:"logitsProcessorList._call(input_ids, batchedLogits)",local:"logitsprocessorlistcallinputids-batchedlogits",headingTag:"h3"}}),Q=new _({props:{title:"utils/generation.LogitsProcessor ⇐ <code> Callable </code>",local:"utilsgenerationlogitsprocessor--code-callable-code",headingTag:"h2"}}),Z=new _({props:{title:"logitsProcessor._call(input_ids, logits)",local:"logitsprocessorcallinputids-logits",headingTag:"h3"}}),se=new _({props:{title:"utils/generation.ForceTokensLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationforcetokenslogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),ce=new _({props:{title:"new ForceTokensLogitsProcessor(forced_decoder_ids)",local:"new-forcetokenslogitsprocessorforceddecoderids",headingTag:"h3"}}),me=new _({props:{title:"forceTokensLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>",local:"forcetokenslogitsprocessorcallinputids-logits--code-tensor-code",headingTag:"h3"}}),be=new _({props:{title:"utils/generation.ForcedBOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationforcedbostokenlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),we=new _({props:{title:"new ForcedBOSTokenLogitsProcessor(bos_token_id)",local:"new-forcedbostokenlogitsprocessorbostokenid",headingTag:"h3"}}),Ce=new _({props:{title:"forcedBOSTokenLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"forcedbostokenlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),Ne=new _({props:{title:"utils/generation.ForcedEOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationforcedeostokenlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),je=new _({props:{title:"new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)",local:"new-forcedeostokenlogitsprocessormaxlength-forcedeostokenid",headingTag:"h3"}}),qe=new _({props:{title:"forcedEOSTokenLogitsProcessor._call(input_ids, logits)",local:"forcedeostokenlogitsprocessorcallinputids-logits",headingTag:"h3"}}),Ue=new _({props:{title:"utils/generation.SuppressTokensAtBeginLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationsuppresstokensatbeginlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),Ye=new _({props:{title:"new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)",local:"new-suppresstokensatbeginlogitsprocessorbeginsuppresstokens-beginindex",headingTag:"h3"}}),ot=new _({props:{title:"suppressTokensAtBeginLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"suppresstokensatbeginlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),nt=new _({props:{title:"utils/generation.WhisperTimeStampLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationwhispertimestamplogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),ut=new _({props:{title:"new WhisperTimeStampLogitsProcessor(generate_config)",local:"new-whispertimestamplogitsprocessorgenerateconfig",headingTag:"h3"}}),ht=new _({props:{title:"whisperTimeStampLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>",local:"whispertimestamplogitsprocessorcallinputids-logits--code-tensor-code",headingTag:"h3"}}),Pt=new _({props:{title:"utils/generation.NoRepeatNGramLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationnorepeatngramlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),xt=new _({props:{title:"new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)",local:"new-norepeatngramlogitsprocessornorepeatngramsize",headingTag:"h3"}}),Ht=new _({props:{title:"noRepeatNGramLogitsProcessor.getNgrams(prevInputIds) ⇒ <code> Map. < string, Array < number > > </code>",local:"norepeatngramlogitsprocessorgetngramsprevinputids--code-map--string-array--number---code",headingTag:"h3"}}),Rt=new _({props:{title:"noRepeatNGramLogitsProcessor.getGeneratedNgrams(bannedNgrams, prevInputIds) ⇒ <code> Array. < number > </code>",local:"norepeatngramlogitsprocessorgetgeneratedngramsbannedngrams-previnputids--code-array--number--code",headingTag:"h3"}}),Ft=new _({props:{title:"noRepeatNGramLogitsProcessor.calcBannedNgramTokens(prevInputIds) ⇒ <code> Array. < number > </code>",local:"norepeatngramlogitsprocessorcalcbannedngramtokensprevinputids--code-array--number--code",headingTag:"h3"}}),zt=new _({props:{title:"noRepeatNGramLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"norepeatngramlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),Vt=new _({props:{title:"utils/generation.RepetitionPenaltyLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationrepetitionpenaltylogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),to=new _({props:{title:"new RepetitionPenaltyLogitsProcessor(penalty)",local:"new-repetitionpenaltylogitsprocessorpenalty",headingTag:"h3"}}),so=new _({props:{title:"repetitionPenaltyLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"repetitionpenaltylogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),po=new _({props:{title:"utils/generation.MinLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationminlengthlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),ho=new _({props:{title:"new MinLengthLogitsProcessor(min_length, eos_token_id)",local:"new-minlengthlogitsprocessorminlength-eostokenid",headingTag:"h3"}}),To=new _({props:{title:"minLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"minlengthlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),yo=new _({props:{title:"utils/generation.MinNewTokensLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationminnewtokenslengthlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),Ho=new _({props:{title:"new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)",local:"new-minnewtokenslengthlogitsprocessorpromptlengthtoskip-minnewtokens-eostokenid",headingTag:"h3"}}),Eo=new _({props:{title:"minNewTokensLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"minnewtokenslengthlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),Go=new _({props:{title:"utils/generation.NoBadWordsLogitsProcessor",local:"utilsgenerationnobadwordslogitsprocessor",headingTag:"h2"}}),Do=new _({props:{title:"new NoBadWordsLogitsProcessor(bad_words_ids, eos_token_id)",local:"new-nobadwordslogitsprocessorbadwordsids-eostokenid",headingTag:"h3"}}),Uo=new _({props:{title:"noBadWordsLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"nobadwordslogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),Yo=new _({props:{title:"utils/generation.Sampler",local:"utilsgenerationsampler",headingTag:"h2"}}),ii=new _({props:{title:"new Sampler(generation_config)",local:"new-samplergenerationconfig",headingTag:"h3"}}),ni=new _({props:{title:"sampler._call(logits, index) ⇒ <code> void </code>",local:"samplercalllogits-index--code-void-code",headingTag:"h3"}}),ui=new _({props:{title:"sampler.sample(logits, index)",local:"samplersamplelogits-index",headingTag:"h3"}}),Li=new _({props:{title:"sampler.getLogits(logits, index) ⇒ <code> Float32Array </code>",local:"samplergetlogitslogits-index--code-float32array-code",headingTag:"h3"}}),vi=new _({props:{title:"sampler.randomSelect(probabilities) ⇒ <code> number </code>",local:"samplerrandomselectprobabilities--code-number-code",headingTag:"h3"}}),Ci=new _({props:{title:"Sampler.getSampler(generation_config) ⇒ <code> Sampler </code>",local:"samplergetsamplergenerationconfig--code-sampler-code",headingTag:"h3"}}),Ni=new _({props:{title:"utils/generation.GenerationConfig : <code> * </code>",local:"utilsgenerationgenerationconfig--code--code",headingTag:"h2"}}),Oi=new _({props:{title:"utils/generation~GenerationConfig",local:"utilsgenerationgenerationconfig",headingTag:"h2"}}),Fi=new _({props:{title:"new GenerationConfig(kwargs)",local:"new-generationconfigkwargs",headingTag:"h3"}}),Wi=new _({props:{title:"utils/generation~GreedySampler ⇐ <code> Sampler </code>",local:"utilsgenerationgreedysampler--code-sampler-code",headingTag:"h2"}}),Ji=new _({props:{title:"greedySampler.sample(logits, [index]) ⇒ <code> Array </code>",local:"greedysamplersamplelogits-index--code-array-code",headingTag:"h3"}}),Zi=new _({props:{title:"utils/generation~MultinomialSampler ⇐ <code> Sampler </code>",local:"utilsgenerationmultinomialsampler--code-sampler-code",headingTag:"h2"}}),il=new _({props:{title:"multinomialSampler.sample(logits, index) ⇒ <code> Array </code>",local:"multinomialsamplersamplelogits-index--code-array-code",headingTag:"h3"}}),dl=new _({props:{title:"utils/generation~BeamSearchSampler ⇐ <code> Sampler </code>",local:"utilsgenerationbeamsearchsampler--code-sampler-code",headingTag:"h2"}}),ul=new _({props:{title:"beamSearchSampler.sample(logits, index) ⇒ <code> Array </code>",local:"beamsearchsamplersamplelogits-index--code-array-code",headingTag:"h3"}}),_l=new _({props:{title:"utils/generation~GenerationConfigType : <code> Object </code>",local:"utilsgenerationgenerationconfigtype--code-object-code",headingTag:"h2"}}),{c(){L=r("meta"),vl=l(),Pl=r("p"),wl=l(),b=r("a"),yl=l(),p(T.$$.fragment),xl=l(),P=r("p"),P.textContent=Op,kl=l(),$=r("p"),$.innerHTML=jp,Cl=l(),v=r("ul"),v.innerHTML=Gp,Ml=l(),w=r("ul"),w.innerHTML=Fp,Hl=l(),Sl=r("hr"),Al=l(),y=r("a"),Nl=l(),p(x.$$.fragment),El=l(),k=r("p"),k.textContent=Ip,Rl=l(),C=r("p"),C.innerHTML=qp,Bl=l(),M=r("ul"),M.innerHTML=Dp,Ol=l(),jl=r("hr"),Gl=l(),H=r("a"),Fl=l(),p(S.$$.fragment),Il=l(),A=r("p"),A.innerHTML=Wp,ql=l(),Dl=r("hr"),Wl=l(),N=r("a"),zl=l(),p(E.$$.fragment),Kl=l(),R=r("p"),R.textContent=zp,Ul=l(),B=r("p"),B.innerHTML=Kp,Jl=l(),O=r("table"),O.innerHTML=Up,Ql=l(),Vl=r("hr"),Xl=l(),j=r("a"),Yl=l(),p(G.$$.fragment),Zl=l(),F=r("p"),F.textContent=Jp,es=l(),I=r("p"),I.innerHTML=Qp,ts=l(),q=r("table"),q.innerHTML=Vp,os=l(),is=r("hr"),ls=l(),D=r("a"),ss=l(),p(W.$$.fragment),rs=l(),z=r("p"),z.textContent=Xp,ns=l(),K=r("p"),K.innerHTML=Yp,ds=l(),U=r("table"),U.innerHTML=Zp,as=l(),cs=r("hr"),ps=l(),J=r("a"),us=l(),p(Q.$$.fragment),gs=l(),V=r("p"),V.textContent=eu,ms=l(),X=r("p"),X.innerHTML=tu,fs=l(),hs=r("hr"),_s=l(),Y=r("a"),Ls=l(),p(Z.$$.fragment),bs=l(),ee=r("p"),ee.textContent=ou,Ts=l(),te=r("p"),te.innerHTML=iu,Ps=l(),oe=r("ul"),oe.innerHTML=lu,$s=l(),ie=r("table"),ie.innerHTML=su,vs=l(),ws=r("hr"),ys=l(),le=r("a"),xs=l(),p(se.$$.fragment),ks=l(),re=r("p"),re.textContent=ru,Cs=l(),ne=r("p"),ne.innerHTML=nu,Ms=l(),de=r("ul"),de.innerHTML=du,Hs=l(),Ss=r("hr"),As=l(),ae=r("a"),Ns=l(),p(ce.$$.fragment),Es=l(),pe=r("p"),pe.innerHTML=au,Rs=l(),ue=r("table"),ue.innerHTML=cu,Bs=l(),Os=r("hr"),js=l(),ge=r("a"),Gs=l(),p(me.$$.fragment),Fs=l(),fe=r("p"),fe.textContent=pu,Is=l(),he=r("p"),he.innerHTML=uu,qs=l(),_e=r("table"),_e.innerHTML=gu,Ds=l(),Ws=r("hr"),zs=l(),Le=r("a"),Ks=l(),p(be.$$.fragment),Us=l(),Te=r("p"),Te.textContent=mu,Js=l(),Pe=r("p"),Pe.innerHTML=fu,Qs=l(),$e=r("ul"),$e.innerHTML=hu,Vs=l(),Xs=r("hr"),Ys=l(),ve=r("a"),Zs=l(),p(we.$$.fragment),er=l(),ye=r("p"),ye.textContent=_u,tr=l(),xe=r("table"),xe.innerHTML=Lu,or=l(),ir=r("hr"),lr=l(),ke=r("a"),sr=l(),p(Ce.$$.fragment),rr=l(),Me=r("p"),Me.textContent=bu,nr=l(),He=r("p"),He.innerHTML=Tu,dr=l(),Se=r("table"),Se.innerHTML=Pu,ar=l(),cr=r("hr"),pr=l(),Ae=r("a"),ur=l(),p(Ne.$$.fragment),gr=l(),Ee=r("p"),Ee.textContent=$u,mr=l(),Re=r("p"),Re.innerHTML=vu,fr=l(),Be=r("ul"),Be.innerHTML=wu,hr=l(),_r=r("hr"),Lr=l(),Oe=r("a"),br=l(),p(je.$$.fragment),Tr=l(),Ge=r("p"),Ge.textContent=yu,Pr=l(),Fe=r("table"),Fe.innerHTML=xu,$r=l(),vr=r("hr"),wr=l(),Ie=r("a"),yr=l(),p(qe.$$.fragment),xr=l(),De=r("p"),De.textContent=ku,kr=l(),We=r("p"),We.innerHTML=Cu,Cr=l(),ze=r("table"),ze.innerHTML=Mu,Mr=l(),Hr=r("hr"),Sr=l(),Ke=r("a"),Ar=l(),p(Ue.$$.fragment),Nr=l(),Je=r("p"),Je.innerHTML=Hu,Er=l(),Qe=r("p"),Qe.innerHTML=Su,Rr=l(),Ve=r("ul"),Ve.innerHTML=Au,Br=l(),Or=r("hr"),jr=l(),Xe=r("a"),Gr=l(),p(Ye.$$.fragment),Fr=l(),Ze=r("p"),Ze.textContent=Nu,Ir=l(),et=r("table"),et.innerHTML=Eu,qr=l(),Dr=r("hr"),Wr=l(),tt=r("a"),zr=l(),p(ot.$$.fragment),Kr=l(),it=r("p"),it.textContent=Ru,Ur=l(),lt=r("p"),lt.innerHTML=Bu,Jr=l(),st=r("table"),st.innerHTML=Ou,Qr=l(),Vr=r("hr"),Xr=l(),rt=r("a"),Yr=l(),p(nt.$$.fragment),Zr=l(),dt=r("p"),dt.textContent=ju,en=l(),at=r("p"),at.innerHTML=Gu,tn=l(),ct=r("ul"),ct.innerHTML=Fu,on=l(),ln=r("hr"),sn=l(),pt=r("a"),rn=l(),p(ut.$$.fragment),nn=l(),gt=r("p"),gt.textContent=Iu,dn=l(),mt=r("table"),mt.innerHTML=qu,an=l(),cn=r("hr"),pn=l(),ft=r("a"),un=l(),p(ht.$$.fragment),gn=l(),_t=r("p"),_t.textContent=Du,mn=l(),Lt=r("p"),Lt.innerHTML=Wu,fn=l(),bt=r("table"),bt.innerHTML=zu,hn=l(),_n=r("hr"),Ln=l(),Tt=r("a"),bn=l(),p(Pt.$$.fragment),Tn=l(),$t=r("p"),$t.textContent=Ku,Pn=l(),vt=r("p"),vt.innerHTML=Uu,$n=l(),wt=r("ul"),wt.innerHTML=Ju,vn=l(),wn=r("hr"),yn=l(),yt=r("a"),xn=l(),p(xt.$$.fragment),kn=l(),kt=r("p"),kt.textContent=Qu,Cn=l(),Ct=r("table"),Ct.innerHTML=Vu,Mn=l(),Hn=r("hr"),Sn=l(),Mt=r("a"),An=l(),p(Ht.$$.fragment),Nn=l(),St=r("p"),St.textContent=Xu,En=l(),At=r("p"),At.innerHTML=Yu,Rn=l(),Nt=r("table"),Nt.innerHTML=Zu,Bn=l(),On=r("hr"),jn=l(),Et=r("a"),Gn=l(),p(Rt.$$.fragment),Fn=l(),Bt=r("p"),Bt.textContent=eg,In=l(),Ot=r("p"),Ot.innerHTML=tg,qn=l(),jt=r("table"),jt.innerHTML=og,Dn=l(),Wn=r("hr"),zn=l(),Gt=r("a"),Kn=l(),p(Ft.$$.fragment),Un=l(),It=r("p"),It.textContent=ig,Jn=l(),qt=r("p"),qt.innerHTML=lg,Qn=l(),Dt=r("table"),Dt.innerHTML=sg,Vn=l(),Xn=r("hr"),Yn=l(),Wt=r("a"),Zn=l(),p(zt.$$.fragment),ed=l(),Kt=r("p"),Kt.textContent=rg,td=l(),Ut=r("p"),Ut.innerHTML=ng,od=l(),Jt=r("table"),Jt.innerHTML=dg,id=l(),ld=r("hr"),sd=l(),Qt=r("a"),rd=l(),p(Vt.$$.fragment),nd=l(),Xt=r("p"),Xt.textContent=ag,dd=l(),Yt=r("p"),Yt.innerHTML=cg,ad=l(),Zt=r("ul"),Zt.innerHTML=pg,cd=l(),pd=r("hr"),ud=l(),eo=r("a"),gd=l(),p(to.$$.fragment),md=l(),oo=r("p"),oo.textContent=ug,fd=l(),io=r("table"),io.innerHTML=gg,hd=l(),_d=r("hr"),Ld=l(),lo=r("a"),bd=l(),p(so.$$.fragment),Td=l(),ro=r("p"),ro.textContent=mg,Pd=l(),no=r("p"),no.innerHTML=fg,$d=l(),ao=r("table"),ao.innerHTML=hg,vd=l(),wd=r("hr"),yd=l(),co=r("a"),xd=l(),p(po.$$.fragment),kd=l(),uo=r("p"),uo.textContent=_g,Cd=l(),go=r("p"),go.innerHTML=Lg,Md=l(),mo=r("ul"),mo.innerHTML=bg,Hd=l(),Sd=r("hr"),Ad=l(),fo=r("a"),Nd=l(),p(ho.$$.fragment),Ed=l(),_o=r("p"),_o.textContent=Tg,Rd=l(),Lo=r("table"),Lo.innerHTML=Pg,Bd=l(),Od=r("hr"),jd=l(),bo=r("a"),Gd=l(),p(To.$$.fragment),Fd=l(),Po=r("p"),Po.textContent=$g,Id=l(),$o=r("p"),$o.innerHTML=vg,qd=l(),vo=r("table"),vo.innerHTML=wg,Dd=l(),Wd=r("hr"),zd=l(),wo=r("a"),Kd=l(),p(yo.$$.fragment),Ud=l(),xo=r("p"),xo.textContent=yg,Jd=l(),ko=r("p"),ko.innerHTML=xg,Qd=l(),Co=r("ul"),Co.innerHTML=kg,Vd=l(),Xd=r("hr"),Yd=l(),Mo=r("a"),Zd=l(),p(Ho.$$.fragment),ea=l(),So=r("p"),So.textContent=Cg,ta=l(),Ao=r("table"),Ao.innerHTML=Mg,oa=l(),ia=r("hr"),la=l(),No=r("a"),sa=l(),p(Eo.$$.fragment),ra=l(),Ro=r("p"),Ro.textContent=Hg,na=l(),Bo=r("p"),Bo.innerHTML=Sg,da=l(),Oo=r("table"),Oo.innerHTML=Ag,aa=l(),ca=r("hr"),pa=l(),jo=r("a"),ua=l(),p(Go.$$.fragment),ga=l(),Fo=r("p"),Fo.innerHTML=Ng,ma=l(),Io=r("ul"),Io.innerHTML=Eg,fa=l(),ha=r("hr"),_a=l(),qo=r("a"),La=l(),p(Do.$$.fragment),ba=l(),Wo=r("p"),Wo.innerHTML=Rg,Ta=l(),zo=r("table"),zo.innerHTML=Bg,Pa=l(),$a=r("hr"),va=l(),Ko=r("a"),wa=l(),p(Uo.$$.fragment),ya=l(),Jo=r("p"),Jo.textContent=Og,xa=l(),Qo=r("p"),Qo.innerHTML=jg,ka=l(),Vo=r("table"),Vo.innerHTML=Gg,Ca=l(),Ma=r("hr"),Ha=l(),Xo=r("a"),Sa=l(),p(Yo.$$.fragment),Aa=l(),Zo=r("p"),Zo.textContent=Fg,Na=l(),ei=r("p"),ei.innerHTML=Ig,Ea=l(),ti=r("ul"),ti.innerHTML=qg,Ra=l(),Ba=r("hr"),Oa=l(),oi=r("a"),ja=l(),p(ii.$$.fragment),Ga=l(),li=r("p"),li.textContent=Dg,Fa=l(),si=r("table"),si.innerHTML=Wg,Ia=l(),qa=r("hr"),Da=l(),ri=r("a"),Wa=l(),p(ni.$$.fragment),za=l(),di=r("p"),di.textContent=zg,Ka=l(),ai=r("p"),ai.innerHTML=Kg,Ua=l(),ci=r("table"),ci.innerHTML=Ug,Ja=l(),Qa=r("hr"),Va=l(),pi=r("a"),Xa=l(),p(ui.$$.fragment),Ya=l(),gi=r("p"),gi.textContent=Jg,Za=l(),mi=r("p"),mi.innerHTML=Qg,ec=l(),fi=r("ul"),fi.innerHTML=Vg,tc=l(),hi=r("table"),hi.innerHTML=Xg,oc=l(),ic=r("hr"),lc=l(),_i=r("a"),sc=l(),p(Li.$$.fragment),rc=l(),bi=r("p"),bi.textContent=Yg,nc=l(),Ti=r("p"),Ti.innerHTML=Zg,dc=l(),Pi=r("table"),Pi.innerHTML=em,ac=l(),cc=r("hr"),pc=l(),$i=r("a"),uc=l(),p(vi.$$.fragment),gc=l(),wi=r("p"),wi.textContent=tm,mc=l(),yi=r("p"),yi.innerHTML=om,fc=l(),xi=r("table"),xi.innerHTML=im,hc=l(),_c=r("hr"),Lc=l(),ki=r("a"),bc=l(),p(Ci.$$.fragment),Tc=l(),Mi=r("p"),Mi.textContent=lm,Pc=l(),Hi=r("p"),Hi.innerHTML=sm,$c=l(),Si=r("table"),Si.innerHTML=rm,vc=l(),wc=r("hr"),yc=l(),Ai=r("a"),xc=l(),p(Ni.$$.fragment),kc=l(),Ei=r("p"),Ei.textContent=nm,Cc=l(),Ri=r("p"),Ri.innerHTML=dm,Mc=l(),Hc=r("hr"),Sc=l(),Bi=r("a"),Ac=l(),p(Oi.$$.fragment),Nc=l(),ji=r("p"),ji.innerHTML=am,Ec=l(),Rc=r("hr"),Bc=l(),Gi=r("a"),Oc=l(),p(Fi.$$.fragment),jc=l(),Ii=r("p"),Ii.textContent=cm,Gc=l(),qi=r("table"),qi.innerHTML=pm,Fc=l(),Ic=r("hr"),qc=l(),Di=r("a"),Dc=l(),p(Wi.$$.fragment),Wc=l(),zi=r("p"),zi.textContent=um,zc=l(),Ki=r("p"),Ki.innerHTML=gm,Kc=l(),Uc=r("hr"),Jc=l(),Ui=r("a"),Qc=l(),p(Ji.$$.fragment),Vc=l(),Qi=r("p"),Qi.textContent=mm,Xc=l(),Vi=r("p"),Vi.innerHTML=fm,Yc=l(),Xi=r("table"),Xi.innerHTML=hm,Zc=l(),ep=r("hr"),tp=l(),Yi=r("a"),op=l(),p(Zi.$$.fragment),ip=l(),el=r("p"),el.textContent=_m,lp=l(),tl=r("p"),tl.innerHTML=Lm,sp=l(),rp=r("hr"),np=l(),ol=r("a"),dp=l(),p(il.$$.fragment),ap=l(),ll=r("p"),ll.textContent=bm,cp=l(),sl=r("p"),sl.innerHTML=Tm,pp=l(),rl=r("table"),rl.innerHTML=Pm,up=l(),gp=r("hr"),mp=l(),nl=r("a"),fp=l(),p(dl.$$.fragment),hp=l(),al=r("p"),al.textContent=$m,_p=l(),cl=r("p"),cl.innerHTML=vm,Lp=l(),bp=r("hr"),Tp=l(),pl=r("a"),Pp=l(),p(ul.$$.fragment),$p=l(),gl=r("p"),gl.textContent=wm,vp=l(),ml=r("p"),ml.innerHTML=ym,wp=l(),fl=r("table"),fl.innerHTML=xm,yp=l(),xp=r("hr"),kp=l(),hl=r("a"),Cp=l(),p(_l.$$.fragment),Mp=l(),Ll=r("p"),Ll.textContent=km,Hp=l(),bl=r("p"),bl.innerHTML=Cm,Sp=l(),Tl=r("table"),Tl.innerHTML=Mm,Ap=l(),Np=r("hr"),Ep=l(),$l=r("p"),this.h()},l(e){const o=Rm("svelte-u9bgzb",document.head);L=n(o,"META",{name:!0,content:!0}),o.forEach(t),vl=s(e),Pl=n(e,"P",{}),c(Pl).forEach(t),wl=s(e),b=n(e,"A",{id:!0,class:!0}),c(b).forEach(t),yl=s(e),u(T.$$.fragment,e),xl=s(e),P=n(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-sqdsz9"&&(P.textContent=Op),kl=s(e),$=n(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-1dx7r99"&&($.innerHTML=jp),Cl=s(e),v=n(e,"UL",{"data-svelte-h":!0}),d(v)!=="svelte-145ffvq"&&(v.innerHTML=Gp),Ml=s(e),w=n(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-14jwj4n"&&(w.innerHTML=Fp),Hl=s(e),Sl=n(e,"HR",{}),Al=s(e),y=n(e,"A",{id:!0,class:!0}),c(y).forEach(t),Nl=s(e),u(x.$$.fragment,e),El=s(e),k=n(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-3s9f37"&&(k.textContent=Ip),Rl=s(e),C=n(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-2xq34v"&&(C.innerHTML=qp),Bl=s(e),M=n(e,"UL",{"data-svelte-h":!0}),d(M)!=="svelte-a0tc84"&&(M.innerHTML=Dp),Ol=s(e),jl=n(e,"HR",{}),Gl=s(e),H=n(e,"A",{id:!0,class:!0}),c(H).forEach(t),Fl=s(e),u(S.$$.fragment,e),Il=s(e),A=n(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-7qo2qs"&&(A.innerHTML=Wp),ql=s(e),Dl=n(e,"HR",{}),Wl=s(e),N=n(e,"A",{id:!0,class:!0}),c(N).forEach(t),zl=s(e),u(E.$$.fragment,e),Kl=s(e),R=n(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-y2lyqr"&&(R.textContent=zp),Ul=s(e),B=n(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-ye1us2"&&(B.innerHTML=Kp),Jl=s(e),O=n(e,"TABLE",{"data-svelte-h":!0}),d(O)!=="svelte-wth0th"&&(O.innerHTML=Up),Ql=s(e),Vl=n(e,"HR",{}),Xl=s(e),j=n(e,"A",{id:!0,class:!0}),c(j).forEach(t),Yl=s(e),u(G.$$.fragment,e),Zl=s(e),F=n(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-19ybhdd"&&(F.textContent=Jp),es=s(e),I=n(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-ye1us2"&&(I.innerHTML=Qp),ts=s(e),q=n(e,"TABLE",{"data-svelte-h":!0}),d(q)!=="svelte-qfvccr"&&(q.innerHTML=Vp),os=s(e),is=n(e,"HR",{}),ls=s(e),D=n(e,"A",{id:!0,class:!0}),c(D).forEach(t),ss=s(e),u(W.$$.fragment,e),rs=s(e),z=n(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1a5adsy"&&(z.textContent=Xp),ns=s(e),K=n(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-ye1us2"&&(K.innerHTML=Yp),ds=s(e),U=n(e,"TABLE",{"data-svelte-h":!0}),d(U)!=="svelte-afve8l"&&(U.innerHTML=Zp),as=s(e),cs=n(e,"HR",{}),ps=s(e),J=n(e,"A",{id:!0,class:!0}),c(J).forEach(t),us=s(e),u(Q.$$.fragment,e),gs=s(e),V=n(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1skhj6b"&&(V.textContent=eu),ms=s(e),X=n(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-2xq34v"&&(X.innerHTML=tu),fs=s(e),hs=n(e,"HR",{}),_s=s(e),Y=n(e,"A",{id:!0,class:!0}),c(Y).forEach(t),Ls=s(e),u(Z.$$.fragment,e),bs=s(e),ee=n(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-pof7bn"&&(ee.textContent=ou),Ts=s(e),te=n(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1v7ihvu"&&(te.innerHTML=iu),Ps=s(e),oe=n(e,"UL",{"data-svelte-h":!0}),d(oe)!=="svelte-1881dk3"&&(oe.innerHTML=lu),$s=s(e),ie=n(e,"TABLE",{"data-svelte-h":!0}),d(ie)!=="svelte-znwo1g"&&(ie.innerHTML=su),vs=s(e),ws=n(e,"HR",{}),ys=s(e),le=n(e,"A",{id:!0,class:!0}),c(le).forEach(t),xs=s(e),u(se.$$.fragment,e),ks=s(e),re=n(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1d43oth"&&(re.textContent=ru),Cs=s(e),ne=n(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-9hwh5b"&&(ne.innerHTML=nu),Ms=s(e),de=n(e,"UL",{"data-svelte-h":!0}),d(de)!=="svelte-8mww04"&&(de.innerHTML=du),Hs=s(e),Ss=n(e,"HR",{}),As=s(e),ae=n(e,"A",{id:!0,class:!0}),c(ae).forEach(t),Ns=s(e),u(ce.$$.fragment,e),Es=s(e),pe=n(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1shgsb3"&&(pe.innerHTML=au),Rs=s(e),ue=n(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-wcljf3"&&(ue.innerHTML=cu),Bs=s(e),Os=n(e,"HR",{}),js=s(e),ge=n(e,"A",{id:!0,class:!0}),c(ge).forEach(t),Gs=s(e),u(me.$$.fragment,e),Fs=s(e),fe=n(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-pof7bn"&&(fe.textContent=pu),Is=s(e),he=n(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1fawzos"&&(he.innerHTML=uu),qs=s(e),_e=n(e,"TABLE",{"data-svelte-h":!0}),d(_e)!=="svelte-znwo1g"&&(_e.innerHTML=gu),Ds=s(e),Ws=n(e,"HR",{}),zs=s(e),Le=n(e,"A",{id:!0,class:!0}),c(Le).forEach(t),Ks=s(e),u(be.$$.fragment,e),Us=s(e),Te=n(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-o4hur7"&&(Te.textContent=mu),Js=s(e),Pe=n(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-9hwh5b"&&(Pe.innerHTML=fu),Qs=s(e),$e=n(e,"UL",{"data-svelte-h":!0}),d($e)!=="svelte-1p5owii"&&($e.innerHTML=hu),Vs=s(e),Xs=n(e,"HR",{}),Ys=s(e),ve=n(e,"A",{id:!0,class:!0}),c(ve).forEach(t),Zs=s(e),u(we.$$.fragment,e),er=s(e),ye=n(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1gtxb4f"&&(ye.textContent=_u),tr=s(e),xe=n(e,"TABLE",{"data-svelte-h":!0}),d(xe)!=="svelte-5i4wcj"&&(xe.innerHTML=Lu),or=s(e),ir=n(e,"HR",{}),lr=s(e),ke=n(e,"A",{id:!0,class:!0}),c(ke).forEach(t),sr=s(e),u(Ce.$$.fragment,e),rr=s(e),Me=n(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-uhajj6"&&(Me.textContent=bu),nr=s(e),He=n(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1ljjg3x"&&(He.innerHTML=Tu),dr=s(e),Se=n(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-aks9lu"&&(Se.innerHTML=Pu),ar=s(e),cr=n(e,"HR",{}),pr=s(e),Ae=n(e,"A",{id:!0,class:!0}),c(Ae).forEach(t),ur=s(e),u(Ne.$$.fragment,e),gr=s(e),Ee=n(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-13qkt8b"&&(Ee.textContent=$u),mr=s(e),Re=n(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-9hwh5b"&&(Re.innerHTML=vu),fr=s(e),Be=n(e,"UL",{"data-svelte-h":!0}),d(Be)!=="svelte-1kyyz39"&&(Be.innerHTML=wu),hr=s(e),_r=n(e,"HR",{}),Lr=s(e),Oe=n(e,"A",{id:!0,class:!0}),c(Oe).forEach(t),br=s(e),u(je.$$.fragment,e),Tr=s(e),Ge=n(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-16ugs6s"&&(Ge.textContent=yu),Pr=s(e),Fe=n(e,"TABLE",{"data-svelte-h":!0}),d(Fe)!=="svelte-ahgedn"&&(Fe.innerHTML=xu),$r=s(e),vr=n(e,"HR",{}),wr=s(e),Ie=n(e,"A",{id:!0,class:!0}),c(Ie).forEach(t),yr=s(e),u(qe.$$.fragment,e),xr=s(e),De=n(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-2wlv12"&&(De.textContent=ku),kr=s(e),We=n(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-9znmwc"&&(We.innerHTML=Cu),Cr=s(e),ze=n(e,"TABLE",{"data-svelte-h":!0}),d(ze)!=="svelte-je9vmv"&&(ze.innerHTML=Mu),Mr=s(e),Hr=n(e,"HR",{}),Sr=s(e),Ke=n(e,"A",{id:!0,class:!0}),c(Ke).forEach(t),Ar=s(e),u(Ue.$$.fragment,e),Nr=s(e),Je=n(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-5s9hr2"&&(Je.innerHTML=Hu),Er=s(e),Qe=n(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-9hwh5b"&&(Qe.innerHTML=Su),Rr=s(e),Ve=n(e,"UL",{"data-svelte-h":!0}),d(Ve)!=="svelte-1otb2bz"&&(Ve.innerHTML=Au),Br=s(e),Or=n(e,"HR",{}),jr=s(e),Xe=n(e,"A",{id:!0,class:!0}),c(Xe).forEach(t),Gr=s(e),u(Ye.$$.fragment,e),Fr=s(e),Ze=n(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-459vk0"&&(Ze.textContent=Nu),Ir=s(e),et=n(e,"TABLE",{"data-svelte-h":!0}),d(et)!=="svelte-rmc35r"&&(et.innerHTML=Eu),qr=s(e),Dr=n(e,"HR",{}),Wr=s(e),tt=n(e,"A",{id:!0,class:!0}),c(tt).forEach(t),zr=s(e),u(ot.$$.fragment,e),Kr=s(e),it=n(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-uhajj6"&&(it.textContent=Ru),Ur=s(e),lt=n(e,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-ysooxp"&&(lt.innerHTML=Bu),Jr=s(e),st=n(e,"TABLE",{"data-svelte-h":!0}),d(st)!=="svelte-aks9lu"&&(st.innerHTML=Ou),Qr=s(e),Vr=n(e,"HR",{}),Xr=s(e),rt=n(e,"A",{id:!0,class:!0}),c(rt).forEach(t),Yr=s(e),u(nt.$$.fragment,e),Zr=s(e),dt=n(e,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-7cf1c8"&&(dt.textContent=ju),en=s(e),at=n(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-9hwh5b"&&(at.innerHTML=Gu),tn=s(e),ct=n(e,"UL",{"data-svelte-h":!0}),d(ct)!=="svelte-1df9ntq"&&(ct.innerHTML=Fu),on=s(e),ln=n(e,"HR",{}),sn=s(e),pt=n(e,"A",{id:!0,class:!0}),c(pt).forEach(t),rn=s(e),u(ut.$$.fragment,e),nn=s(e),gt=n(e,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-h97ofl"&&(gt.textContent=Iu),dn=s(e),mt=n(e,"TABLE",{"data-svelte-h":!0}),d(mt)!=="svelte-ouguny"&&(mt.innerHTML=qu),an=s(e),cn=n(e,"HR",{}),pn=s(e),ft=n(e,"A",{id:!0,class:!0}),c(ft).forEach(t),un=s(e),u(ht.$$.fragment,e),gn=s(e),_t=n(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-t6pj9i"&&(_t.textContent=Du),mn=s(e),Lt=n(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1ba862j"&&(Lt.innerHTML=Wu),fn=s(e),bt=n(e,"TABLE",{"data-svelte-h":!0}),d(bt)!=="svelte-1i9o6ca"&&(bt.innerHTML=zu),hn=s(e),_n=n(e,"HR",{}),Ln=s(e),Tt=n(e,"A",{id:!0,class:!0}),c(Tt).forEach(t),bn=s(e),u(Pt.$$.fragment,e),Tn=s(e),$t=n(e,"P",{"data-svelte-h":!0}),d($t)!=="svelte-1nbhk1j"&&($t.textContent=Ku),Pn=s(e),vt=n(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-9hwh5b"&&(vt.innerHTML=Uu),$n=s(e),wt=n(e,"UL",{"data-svelte-h":!0}),d(wt)!=="svelte-bbnk9b"&&(wt.innerHTML=Ju),vn=s(e),wn=n(e,"HR",{}),yn=s(e),yt=n(e,"A",{id:!0,class:!0}),c(yt).forEach(t),xn=s(e),u(xt.$$.fragment,e),kn=s(e),kt=n(e,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-ztp378"&&(kt.textContent=Qu),Cn=s(e),Ct=n(e,"TABLE",{"data-svelte-h":!0}),d(Ct)!=="svelte-1oeknti"&&(Ct.innerHTML=Vu),Mn=s(e),Hn=n(e,"HR",{}),Sn=s(e),Mt=n(e,"A",{id:!0,class:!0}),c(Mt).forEach(t),An=s(e),u(Ht.$$.fragment,e),Nn=s(e),St=n(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-kezmb4"&&(St.textContent=Xu),En=s(e),At=n(e,"P",{"data-svelte-h":!0}),d(At)!=="svelte-4618wm"&&(At.innerHTML=Yu),Rn=s(e),Nt=n(e,"TABLE",{"data-svelte-h":!0}),d(Nt)!=="svelte-7hcqif"&&(Nt.innerHTML=Zu),Bn=s(e),On=n(e,"HR",{}),jn=s(e),Et=n(e,"A",{id:!0,class:!0}),c(Et).forEach(t),Gn=s(e),u(Rt.$$.fragment,e),Fn=s(e),Bt=n(e,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-kezmb4"&&(Bt.textContent=eg),In=s(e),Ot=n(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-56j6v5"&&(Ot.innerHTML=tg),qn=s(e),jt=n(e,"TABLE",{"data-svelte-h":!0}),d(jt)!=="svelte-12kqlqq"&&(jt.innerHTML=og),Dn=s(e),Wn=n(e,"HR",{}),zn=s(e),Gt=n(e,"A",{id:!0,class:!0}),c(Gt).forEach(t),Kn=s(e),u(Ft.$$.fragment,e),Un=s(e),It=n(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-i6fmo8"&&(It.textContent=ig),Jn=s(e),qt=n(e,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-56j6v5"&&(qt.innerHTML=lg),Qn=s(e),Dt=n(e,"TABLE",{"data-svelte-h":!0}),d(Dt)!=="svelte-7hcqif"&&(Dt.innerHTML=sg),Vn=s(e),Xn=n(e,"HR",{}),Yn=s(e),Wt=n(e,"A",{id:!0,class:!0}),c(Wt).forEach(t),Zn=s(e),u(zt.$$.fragment,e),ed=s(e),Kt=n(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-ns64he"&&(Kt.textContent=rg),td=s(e),Ut=n(e,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-eb379u"&&(Ut.innerHTML=ng),od=s(e),Jt=n(e,"TABLE",{"data-svelte-h":!0}),d(Jt)!=="svelte-aks9lu"&&(Jt.innerHTML=dg),id=s(e),ld=n(e,"HR",{}),sd=s(e),Qt=n(e,"A",{id:!0,class:!0}),c(Qt).forEach(t),rd=s(e),u(Vt.$$.fragment,e),nd=s(e),Xt=n(e,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1swjk5j"&&(Xt.textContent=ag),dd=s(e),Yt=n(e,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-9hwh5b"&&(Yt.innerHTML=cg),ad=s(e),Zt=n(e,"UL",{"data-svelte-h":!0}),d(Zt)!=="svelte-8ptdd5"&&(Zt.innerHTML=pg),cd=s(e),pd=n(e,"HR",{}),ud=s(e),eo=n(e,"A",{id:!0,class:!0}),c(eo).forEach(t),gd=s(e),u(to.$$.fragment,e),md=s(e),oo=n(e,"P",{"data-svelte-h":!0}),d(oo)!=="svelte-1miwk7z"&&(oo.textContent=ug),fd=s(e),io=n(e,"TABLE",{"data-svelte-h":!0}),d(io)!=="svelte-qogrf9"&&(io.innerHTML=gg),hd=s(e),_d=n(e,"HR",{}),Ld=s(e),lo=n(e,"A",{id:!0,class:!0}),c(lo).forEach(t),bd=s(e),u(so.$$.fragment,e),Td=s(e),ro=n(e,"P",{"data-svelte-h":!0}),d(ro)!=="svelte-ttelh1"&&(ro.textContent=mg),Pd=s(e),no=n(e,"P",{"data-svelte-h":!0}),d(no)!=="svelte-1l9hzxj"&&(no.innerHTML=fg),$d=s(e),ao=n(e,"TABLE",{"data-svelte-h":!0}),d(ao)!=="svelte-aks9lu"&&(ao.innerHTML=hg),vd=s(e),wd=n(e,"HR",{}),yd=s(e),co=n(e,"A",{id:!0,class:!0}),c(co).forEach(t),xd=s(e),u(po.$$.fragment,e),kd=s(e),uo=n(e,"P",{"data-svelte-h":!0}),d(uo)!=="svelte-9c4wc0"&&(uo.textContent=_g),Cd=s(e),go=n(e,"P",{"data-svelte-h":!0}),d(go)!=="svelte-9hwh5b"&&(go.innerHTML=Lg),Md=s(e),mo=n(e,"UL",{"data-svelte-h":!0}),d(mo)!=="svelte-5gysvm"&&(mo.innerHTML=bg),Hd=s(e),Sd=n(e,"HR",{}),Ad=s(e),fo=n(e,"A",{id:!0,class:!0}),c(fo).forEach(t),Nd=s(e),u(ho.$$.fragment,e),Ed=s(e),_o=n(e,"P",{"data-svelte-h":!0}),d(_o)!=="svelte-1m5mw53"&&(_o.textContent=Tg),Rd=s(e),Lo=n(e,"TABLE",{"data-svelte-h":!0}),d(Lo)!=="svelte-1glhq7b"&&(Lo.innerHTML=Pg),Bd=s(e),Od=n(e,"HR",{}),jd=s(e),bo=n(e,"A",{id:!0,class:!0}),c(bo).forEach(t),Gd=s(e),u(To.$$.fragment,e),Fd=s(e),Po=n(e,"P",{"data-svelte-h":!0}),d(Po)!=="svelte-uo9cbt"&&(Po.textContent=$g),Id=s(e),$o=n(e,"P",{"data-svelte-h":!0}),d($o)!=="svelte-r6npgs"&&($o.innerHTML=vg),qd=s(e),vo=n(e,"TABLE",{"data-svelte-h":!0}),d(vo)!=="svelte-aks9lu"&&(vo.innerHTML=wg),Dd=s(e),Wd=n(e,"HR",{}),zd=s(e),wo=n(e,"A",{id:!0,class:!0}),c(wo).forEach(t),Kd=s(e),u(yo.$$.fragment,e),Ud=s(e),xo=n(e,"P",{"data-svelte-h":!0}),d(xo)!=="svelte-ozjzty"&&(xo.textContent=yg),Jd=s(e),ko=n(e,"P",{"data-svelte-h":!0}),d(ko)!=="svelte-9hwh5b"&&(ko.innerHTML=xg),Qd=s(e),Co=n(e,"UL",{"data-svelte-h":!0}),d(Co)!=="svelte-1ry7094"&&(Co.innerHTML=kg),Vd=s(e),Xd=n(e,"HR",{}),Yd=s(e),Mo=n(e,"A",{id:!0,class:!0}),c(Mo).forEach(t),Zd=s(e),u(Ho.$$.fragment,e),ea=s(e),So=n(e,"P",{"data-svelte-h":!0}),d(So)!=="svelte-6z34lb"&&(So.textContent=Cg),ta=s(e),Ao=n(e,"TABLE",{"data-svelte-h":!0}),d(Ao)!=="svelte-1hv5g9s"&&(Ao.innerHTML=Mg),oa=s(e),ia=n(e,"HR",{}),la=s(e),No=n(e,"A",{id:!0,class:!0}),c(No).forEach(t),sa=s(e),u(Eo.$$.fragment,e),ra=s(e),Ro=n(e,"P",{"data-svelte-h":!0}),d(Ro)!=="svelte-uo9cbt"&&(Ro.textContent=Hg),na=s(e),Bo=n(e,"P",{"data-svelte-h":!0}),d(Bo)!=="svelte-1o7er1i"&&(Bo.innerHTML=Sg),da=s(e),Oo=n(e,"TABLE",{"data-svelte-h":!0}),d(Oo)!=="svelte-aks9lu"&&(Oo.innerHTML=Ag),aa=s(e),ca=n(e,"HR",{}),pa=s(e),jo=n(e,"A",{id:!0,class:!0}),c(jo).forEach(t),ua=s(e),u(Go.$$.fragment,e),ga=s(e),Fo=n(e,"P",{"data-svelte-h":!0}),d(Fo)!=="svelte-8k9dr4"&&(Fo.innerHTML=Ng),ma=s(e),Io=n(e,"UL",{"data-svelte-h":!0}),d(Io)!=="svelte-3itsi1"&&(Io.innerHTML=Eg),fa=s(e),ha=n(e,"HR",{}),_a=s(e),qo=n(e,"A",{id:!0,class:!0}),c(qo).forEach(t),La=s(e),u(Do.$$.fragment,e),ba=s(e),Wo=n(e,"P",{"data-svelte-h":!0}),d(Wo)!=="svelte-1un5mwn"&&(Wo.innerHTML=Rg),Ta=s(e),zo=n(e,"TABLE",{"data-svelte-h":!0}),d(zo)!=="svelte-4hl4st"&&(zo.innerHTML=Bg),Pa=s(e),$a=n(e,"HR",{}),va=s(e),Ko=n(e,"A",{id:!0,class:!0}),c(Ko).forEach(t),wa=s(e),u(Uo.$$.fragment,e),ya=s(e),Jo=n(e,"P",{"data-svelte-h":!0}),d(Jo)!=="svelte-uo9cbt"&&(Jo.textContent=Og),xa=s(e),Qo=n(e,"P",{"data-svelte-h":!0}),d(Qo)!=="svelte-1kfi162"&&(Qo.innerHTML=jg),ka=s(e),Vo=n(e,"TABLE",{"data-svelte-h":!0}),d(Vo)!=="svelte-aks9lu"&&(Vo.innerHTML=Gg),Ca=s(e),Ma=n(e,"HR",{}),Ha=s(e),Xo=n(e,"A",{id:!0,class:!0}),c(Xo).forEach(t),Sa=s(e),u(Yo.$$.fragment,e),Aa=s(e),Zo=n(e,"P",{"data-svelte-h":!0}),d(Zo)!=="svelte-p0jtpm"&&(Zo.textContent=Fg),Na=s(e),ei=n(e,"P",{"data-svelte-h":!0}),d(ei)!=="svelte-8k9dr4"&&(ei.innerHTML=Ig),Ea=s(e),ti=n(e,"UL",{"data-svelte-h":!0}),d(ti)!=="svelte-bqzlxo"&&(ti.innerHTML=qg),Ra=s(e),Ba=n(e,"HR",{}),Oa=s(e),oi=n(e,"A",{id:!0,class:!0}),c(oi).forEach(t),ja=s(e),u(ii.$$.fragment,e),Ga=s(e),li=n(e,"P",{"data-svelte-h":!0}),d(li)!=="svelte-cx2gtq"&&(li.textContent=Dg),Fa=s(e),si=n(e,"TABLE",{"data-svelte-h":!0}),d(si)!=="svelte-1i3f47n"&&(si.innerHTML=Wg),Ia=s(e),qa=n(e,"HR",{}),Da=s(e),ri=n(e,"A",{id:!0,class:!0}),c(ri).forEach(t),Wa=s(e),u(ni.$$.fragment,e),za=s(e),di=n(e,"P",{"data-svelte-h":!0}),d(di)!=="svelte-18hhszu"&&(di.textContent=zg),Ka=s(e),ai=n(e,"P",{"data-svelte-h":!0}),d(ai)!=="svelte-1hkhr2u"&&(ai.innerHTML=Kg),Ua=s(e),ci=n(e,"TABLE",{"data-svelte-h":!0}),d(ci)!=="svelte-1ks6oyq"&&(ci.innerHTML=Ug),Ja=s(e),Qa=n(e,"HR",{}),Va=s(e),pi=n(e,"A",{id:!0,class:!0}),c(pi).forEach(t),Xa=s(e),u(ui.$$.fragment,e),Ya=s(e),gi=n(e,"P",{"data-svelte-h":!0}),d(gi)!=="svelte-mhsbvo"&&(gi.textContent=Jg),Za=s(e),mi=n(e,"P",{"data-svelte-h":!0}),d(mi)!=="svelte-mok1bi"&&(mi.innerHTML=Qg),ec=s(e),fi=n(e,"UL",{"data-svelte-h":!0}),d(fi)!=="svelte-1ijvx2"&&(fi.innerHTML=Vg),tc=s(e),hi=n(e,"TABLE",{"data-svelte-h":!0}),d(hi)!=="svelte-1ks6oyq"&&(hi.innerHTML=Xg),oc=s(e),ic=n(e,"HR",{}),lc=s(e),_i=n(e,"A",{id:!0,class:!0}),c(_i).forEach(t),sc=s(e),u(Li.$$.fragment,e),rc=s(e),bi=n(e,"P",{"data-svelte-h":!0}),d(bi)!=="svelte-1tthoub"&&(bi.textContent=Yg),nc=s(e),Ti=n(e,"P",{"data-svelte-h":!0}),d(Ti)!=="svelte-1hkhr2u"&&(Ti.innerHTML=Zg),dc=s(e),Pi=n(e,"TABLE",{"data-svelte-h":!0}),d(Pi)!=="svelte-1ks6oyq"&&(Pi.innerHTML=em),ac=s(e),cc=n(e,"HR",{}),pc=s(e),$i=n(e,"A",{id:!0,class:!0}),c($i).forEach(t),uc=s(e),u(vi.$$.fragment,e),gc=s(e),wi=n(e,"P",{"data-svelte-h":!0}),d(wi)!=="svelte-yywnzb"&&(wi.textContent=tm),mc=s(e),yi=n(e,"P",{"data-svelte-h":!0}),d(yi)!=="svelte-1o7ozs"&&(yi.innerHTML=om),fc=s(e),xi=n(e,"TABLE",{"data-svelte-h":!0}),d(xi)!=="svelte-415bxe"&&(xi.innerHTML=im),hc=s(e),_c=n(e,"HR",{}),Lc=s(e),ki=n(e,"A",{id:!0,class:!0}),c(ki).forEach(t),bc=s(e),u(Ci.$$.fragment,e),Tc=s(e),Mi=n(e,"P",{"data-svelte-h":!0}),d(Mi)!=="svelte-wl8u0w"&&(Mi.textContent=lm),Pc=s(e),Hi=n(e,"P",{"data-svelte-h":!0}),d(Hi)!=="svelte-18j5rpb"&&(Hi.innerHTML=sm),$c=s(e),Si=n(e,"TABLE",{"data-svelte-h":!0}),d(Si)!=="svelte-2theuy"&&(Si.innerHTML=rm),vc=s(e),wc=n(e,"HR",{}),yc=s(e),Ai=n(e,"A",{id:!0,class:!0}),c(Ai).forEach(t),xc=s(e),u(Ni.$$.fragment,e),kc=s(e),Ei=n(e,"P",{"data-svelte-h":!0}),d(Ei)!=="svelte-setd0x"&&(Ei.textContent=nm),Cc=s(e),Ri=n(e,"P",{"data-svelte-h":!0}),d(Ri)!=="svelte-zb4lr2"&&(Ri.innerHTML=dm),Mc=s(e),Hc=n(e,"HR",{}),Sc=s(e),Bi=n(e,"A",{id:!0,class:!0}),c(Bi).forEach(t),Ac=s(e),u(Oi.$$.fragment,e),Nc=s(e),ji=n(e,"P",{"data-svelte-h":!0}),d(ji)!=="svelte-1az0pao"&&(ji.innerHTML=am),Ec=s(e),Rc=n(e,"HR",{}),Bc=s(e),Gi=n(e,"A",{id:!0,class:!0}),c(Gi).forEach(t),Oc=s(e),u(Fi.$$.fragment,e),jc=s(e),Ii=n(e,"P",{"data-svelte-h":!0}),d(Ii)!=="svelte-1yobo9c"&&(Ii.textContent=cm),Gc=s(e),qi=n(e,"TABLE",{"data-svelte-h":!0}),d(qi)!=="svelte-1s66v"&&(qi.innerHTML=pm),Fc=s(e),Ic=n(e,"HR",{}),qc=s(e),Di=n(e,"A",{id:!0,class:!0}),c(Di).forEach(t),Dc=s(e),u(Wi.$$.fragment,e),Wc=s(e),zi=n(e,"P",{"data-svelte-h":!0}),d(zi)!=="svelte-1pvj197"&&(zi.textContent=um),zc=s(e),Ki=n(e,"P",{"data-svelte-h":!0}),d(Ki)!=="svelte-1cm4lld"&&(Ki.innerHTML=gm),Kc=s(e),Uc=n(e,"HR",{}),Jc=s(e),Ui=n(e,"A",{id:!0,class:!0}),c(Ui).forEach(t),Qc=s(e),u(Ji.$$.fragment,e),Vc=s(e),Qi=n(e,"P",{"data-svelte-h":!0}),d(Qi)!=="svelte-1acvd9s"&&(Qi.textContent=mm),Xc=s(e),Vi=n(e,"P",{"data-svelte-h":!0}),d(Vi)!=="svelte-dut2ci"&&(Vi.innerHTML=fm),Yc=s(e),Xi=n(e,"TABLE",{"data-svelte-h":!0}),d(Xi)!=="svelte-tzng1p"&&(Xi.innerHTML=hm),Zc=s(e),ep=n(e,"HR",{}),tp=s(e),Yi=n(e,"A",{id:!0,class:!0}),c(Yi).forEach(t),op=s(e),u(Zi.$$.fragment,e),ip=s(e),el=n(e,"P",{"data-svelte-h":!0}),d(el)!=="svelte-2u15u0"&&(el.textContent=_m),lp=s(e),tl=n(e,"P",{"data-svelte-h":!0}),d(tl)!=="svelte-1cm4lld"&&(tl.innerHTML=Lm),sp=s(e),rp=n(e,"HR",{}),np=s(e),ol=n(e,"A",{id:!0,class:!0}),c(ol).forEach(t),dp=s(e),u(il.$$.fragment,e),ap=s(e),ll=n(e,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-1uart2f"&&(ll.textContent=bm),cp=s(e),sl=n(e,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-6rm4k"&&(sl.innerHTML=Tm),pp=s(e),rl=n(e,"TABLE",{"data-svelte-h":!0}),d(rl)!=="svelte-1ks6oyq"&&(rl.innerHTML=Pm),up=s(e),gp=n(e,"HR",{}),mp=s(e),nl=n(e,"A",{id:!0,class:!0}),c(nl).forEach(t),fp=s(e),u(dl.$$.fragment,e),hp=s(e),al=n(e,"P",{"data-svelte-h":!0}),d(al)!=="svelte-tcl9v8"&&(al.textContent=$m),_p=s(e),cl=n(e,"P",{"data-svelte-h":!0}),d(cl)!=="svelte-1cm4lld"&&(cl.innerHTML=vm),Lp=s(e),bp=n(e,"HR",{}),Tp=s(e),pl=n(e,"A",{id:!0,class:!0}),c(pl).forEach(t),Pp=s(e),u(ul.$$.fragment,e),$p=s(e),gl=n(e,"P",{"data-svelte-h":!0}),d(gl)!=="svelte-1uart2f"&&(gl.textContent=wm),vp=s(e),ml=n(e,"P",{"data-svelte-h":!0}),d(ml)!=="svelte-18emm88"&&(ml.innerHTML=ym),wp=s(e),fl=n(e,"TABLE",{"data-svelte-h":!0}),d(fl)!=="svelte-1ks6oyq"&&(fl.innerHTML=xm),yp=s(e),xp=n(e,"HR",{}),kp=s(e),hl=n(e,"A",{id:!0,class:!0}),c(hl).forEach(t),Cp=s(e),u(_l.$$.fragment,e),Mp=s(e),Ll=n(e,"P",{"data-svelte-h":!0}),d(Ll)!=="svelte-2deze2"&&(Ll.textContent=km),Hp=s(e),bl=n(e,"P",{"data-svelte-h":!0}),d(bl)!=="svelte-1m0y5lv"&&(bl.innerHTML=Cm),Sp=s(e),Tl=n(e,"TABLE",{"data-svelte-h":!0}),d(Tl)!=="svelte-1tb03me"&&(Tl.innerHTML=Mm),Ap=s(e),Np=n(e,"HR",{}),Ep=s(e),$l=n(e,"P",{}),c($l).forEach(t),this.h()},h(){a(L,"name","hf:doc:metadata"),a(L,"content",jm),a(b,"id","module_utils/generation"),a(b,"class","group"),a(y,"id","module_utils/generation.LogitsProcessorList"),a(y,"class","group"),a(H,"id","new_module_utils/generation.LogitsProcessorList_new"),a(H,"class","group"),a(N,"id","module_utils/generation.LogitsProcessorList+push"),a(N,"class","group"),a(j,"id","module_utils/generation.LogitsProcessorList+extend"),a(j,"class","group"),a(D,"id","module_utils/generation.LogitsProcessorList+_call"),a(D,"class","group"),a(J,"id","module_utils/generation.LogitsProcessor"),a(J,"class","group"),a(Y,"id","module_utils/generation.LogitsProcessor+_call"),a(Y,"class","group"),a(le,"id","module_utils/generation.ForceTokensLogitsProcessor"),a(le,"class","group"),a(ae,"id","new_module_utils/generation.ForceTokensLogitsProcessor_new"),a(ae,"class","group"),a(ge,"id","module_utils/generation.ForceTokensLogitsProcessor+_call"),a(ge,"class","group"),a(Le,"id","module_utils/generation.ForcedBOSTokenLogitsProcessor"),a(Le,"class","group"),a(ve,"id","new_module_utils/generation.ForcedBOSTokenLogitsProcessor_new"),a(ve,"class","group"),a(ke,"id","module_utils/generation.ForcedBOSTokenLogitsProcessor+_call"),a(ke,"class","group"),a(Ae,"id","module_utils/generation.ForcedEOSTokenLogitsProcessor"),a(Ae,"class","group"),a(Oe,"id","new_module_utils/generation.ForcedEOSTokenLogitsProcessor_new"),a(Oe,"class","group"),a(Ie,"id","module_utils/generation.ForcedEOSTokenLogitsProcessor+_call"),a(Ie,"class","group"),a(Ke,"id","module_utils/generation.SuppressTokensAtBeginLogitsProcessor"),a(Ke,"class","group"),a(Xe,"id","new_module_utils/generation.SuppressTokensAtBeginLogitsProcessor_new"),a(Xe,"class","group"),a(tt,"id","module_utils/generation.SuppressTokensAtBeginLogitsProcessor+_call"),a(tt,"class","group"),a(rt,"id","module_utils/generation.WhisperTimeStampLogitsProcessor"),a(rt,"class","group"),a(pt,"id","new_module_utils/generation.WhisperTimeStampLogitsProcessor_new"),a(pt,"class","group"),a(ft,"id","module_utils/generation.WhisperTimeStampLogitsProcessor+_call"),a(ft,"class","group"),a(Tt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor"),a(Tt,"class","group"),a(yt,"id","new_module_utils/generation.NoRepeatNGramLogitsProcessor_new"),a(yt,"class","group"),a(Mt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+getNgrams"),a(Mt,"class","group"),a(Et,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+getGeneratedNgrams"),a(Et,"class","group"),a(Gt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+calcBannedNgramTokens"),a(Gt,"class","group"),a(Wt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+_call"),a(Wt,"class","group"),a(Qt,"id","module_utils/generation.RepetitionPenaltyLogitsProcessor"),a(Qt,"class","group"),a(eo,"id","new_module_utils/generation.RepetitionPenaltyLogitsProcessor_new"),a(eo,"class","group"),a(lo,"id","module_utils/generation.RepetitionPenaltyLogitsProcessor+_call"),a(lo,"class","group"),a(co,"id","module_utils/generation.MinLengthLogitsProcessor"),a(co,"class","group"),a(fo,"id","new_module_utils/generation.MinLengthLogitsProcessor_new"),a(fo,"class","group"),a(bo,"id","module_utils/generation.MinLengthLogitsProcessor+_call"),a(bo,"class","group"),a(wo,"id","module_utils/generation.MinNewTokensLengthLogitsProcessor"),a(wo,"class","group"),a(Mo,"id","new_module_utils/generation.MinNewTokensLengthLogitsProcessor_new"),a(Mo,"class","group"),a(No,"id","module_utils/generation.MinNewTokensLengthLogitsProcessor+_call"),a(No,"class","group"),a(jo,"id","module_utils/generation.NoBadWordsLogitsProcessor"),a(jo,"class","group"),a(qo,"id","new_module_utils/generation.NoBadWordsLogitsProcessor_new"),a(qo,"class","group"),a(Ko,"id","module_utils/generation.NoBadWordsLogitsProcessor+_call"),a(Ko,"class","group"),a(Xo,"id","module_utils/generation.Sampler"),a(Xo,"class","group"),a(oi,"id","new_module_utils/generation.Sampler_new"),a(oi,"class","group"),a(ri,"id","module_utils/generation.Sampler+_call"),a(ri,"class","group"),a(pi,"id","module_utils/generation.Sampler+sample"),a(pi,"class","group"),a(_i,"id","module_utils/generation.Sampler+getLogits"),a(_i,"class","group"),a($i,"id","module_utils/generation.Sampler+randomSelect"),a($i,"class","group"),a(ki,"id","module_utils/generation.Sampler.getSampler"),a(ki,"class","group"),a(Ai,"id","module_utils/generation.GenerationConfig"),a(Ai,"class","group"),a(Bi,"id","module_utils/generation..GenerationConfig"),a(Bi,"class","group"),a(Gi,"id","new_module_utils/generation..GenerationConfig_new"),a(Gi,"class","group"),a(Di,"id","module_utils/generation..GreedySampler"),a(Di,"class","group"),a(Ui,"id","module_utils/generation..GreedySampler+sample"),a(Ui,"class","group"),a(Yi,"id","module_utils/generation..MultinomialSampler"),a(Yi,"class","group"),a(ol,"id","module_utils/generation..MultinomialSampler+sample"),a(ol,"class","group"),a(nl,"id","module_utils/generation..BeamSearchSampler"),a(nl,"class","group"),a(pl,"id","module_utils/generation..BeamSearchSampler+sample"),a(pl,"class","group"),a(hl,"id","module_utils/generation..GenerationConfigType"),a(hl,"class","group")},m(e,o){Bm(document.head,L),i(e,vl,o),i(e,Pl,o),i(e,wl,o),i(e,b,o),i(e,yl,o),g(T,e,o),i(e,xl,o),i(e,P,o),i(e,kl,o),i(e,$,o),i(e,Cl,o),i(e,v,o),i(e,Ml,o),i(e,w,o),i(e,Hl,o),i(e,Sl,o),i(e,Al,o),i(e,y,o),i(e,Nl,o),g(x,e,o),i(e,El,o),i(e,k,o),i(e,Rl,o),i(e,C,o),i(e,Bl,o),i(e,M,o),i(e,Ol,o),i(e,jl,o),i(e,Gl,o),i(e,H,o),i(e,Fl,o),g(S,e,o),i(e,Il,o),i(e,A,o),i(e,ql,o),i(e,Dl,o),i(e,Wl,o),i(e,N,o),i(e,zl,o),g(E,e,o),i(e,Kl,o),i(e,R,o),i(e,Ul,o),i(e,B,o),i(e,Jl,o),i(e,O,o),i(e,Ql,o),i(e,Vl,o),i(e,Xl,o),i(e,j,o),i(e,Yl,o),g(G,e,o),i(e,Zl,o),i(e,F,o),i(e,es,o),i(e,I,o),i(e,ts,o),i(e,q,o),i(e,os,o),i(e,is,o),i(e,ls,o),i(e,D,o),i(e,ss,o),g(W,e,o),i(e,rs,o),i(e,z,o),i(e,ns,o),i(e,K,o),i(e,ds,o),i(e,U,o),i(e,as,o),i(e,cs,o),i(e,ps,o),i(e,J,o),i(e,us,o),g(Q,e,o),i(e,gs,o),i(e,V,o),i(e,ms,o),i(e,X,o),i(e,fs,o),i(e,hs,o),i(e,_s,o),i(e,Y,o),i(e,Ls,o),g(Z,e,o),i(e,bs,o),i(e,ee,o),i(e,Ts,o),i(e,te,o),i(e,Ps,o),i(e,oe,o),i(e,$s,o),i(e,ie,o),i(e,vs,o),i(e,ws,o),i(e,ys,o),i(e,le,o),i(e,xs,o),g(se,e,o),i(e,ks,o),i(e,re,o),i(e,Cs,o),i(e,ne,o),i(e,Ms,o),i(e,de,o),i(e,Hs,o),i(e,Ss,o),i(e,As,o),i(e,ae,o),i(e,Ns,o),g(ce,e,o),i(e,Es,o),i(e,pe,o),i(e,Rs,o),i(e,ue,o),i(e,Bs,o),i(e,Os,o),i(e,js,o),i(e,ge,o),i(e,Gs,o),g(me,e,o),i(e,Fs,o),i(e,fe,o),i(e,Is,o),i(e,he,o),i(e,qs,o),i(e,_e,o),i(e,Ds,o),i(e,Ws,o),i(e,zs,o),i(e,Le,o),i(e,Ks,o),g(be,e,o),i(e,Us,o),i(e,Te,o),i(e,Js,o),i(e,Pe,o),i(e,Qs,o),i(e,$e,o),i(e,Vs,o),i(e,Xs,o),i(e,Ys,o),i(e,ve,o),i(e,Zs,o),g(we,e,o),i(e,er,o),i(e,ye,o),i(e,tr,o),i(e,xe,o),i(e,or,o),i(e,ir,o),i(e,lr,o),i(e,ke,o),i(e,sr,o),g(Ce,e,o),i(e,rr,o),i(e,Me,o),i(e,nr,o),i(e,He,o),i(e,dr,o),i(e,Se,o),i(e,ar,o),i(e,cr,o),i(e,pr,o),i(e,Ae,o),i(e,ur,o),g(Ne,e,o),i(e,gr,o),i(e,Ee,o),i(e,mr,o),i(e,Re,o),i(e,fr,o),i(e,Be,o),i(e,hr,o),i(e,_r,o),i(e,Lr,o),i(e,Oe,o),i(e,br,o),g(je,e,o),i(e,Tr,o),i(e,Ge,o),i(e,Pr,o),i(e,Fe,o),i(e,$r,o),i(e,vr,o),i(e,wr,o),i(e,Ie,o),i(e,yr,o),g(qe,e,o),i(e,xr,o),i(e,De,o),i(e,kr,o),i(e,We,o),i(e,Cr,o),i(e,ze,o),i(e,Mr,o),i(e,Hr,o),i(e,Sr,o),i(e,Ke,o),i(e,Ar,o),g(Ue,e,o),i(e,Nr,o),i(e,Je,o),i(e,Er,o),i(e,Qe,o),i(e,Rr,o),i(e,Ve,o),i(e,Br,o),i(e,Or,o),i(e,jr,o),i(e,Xe,o),i(e,Gr,o),g(Ye,e,o),i(e,Fr,o),i(e,Ze,o),i(e,Ir,o),i(e,et,o),i(e,qr,o),i(e,Dr,o),i(e,Wr,o),i(e,tt,o),i(e,zr,o),g(ot,e,o),i(e,Kr,o),i(e,it,o),i(e,Ur,o),i(e,lt,o),i(e,Jr,o),i(e,st,o),i(e,Qr,o),i(e,Vr,o),i(e,Xr,o),i(e,rt,o),i(e,Yr,o),g(nt,e,o),i(e,Zr,o),i(e,dt,o),i(e,en,o),i(e,at,o),i(e,tn,o),i(e,ct,o),i(e,on,o),i(e,ln,o),i(e,sn,o),i(e,pt,o),i(e,rn,o),g(ut,e,o),i(e,nn,o),i(e,gt,o),i(e,dn,o),i(e,mt,o),i(e,an,o),i(e,cn,o),i(e,pn,o),i(e,ft,o),i(e,un,o),g(ht,e,o),i(e,gn,o),i(e,_t,o),i(e,mn,o),i(e,Lt,o),i(e,fn,o),i(e,bt,o),i(e,hn,o),i(e,_n,o),i(e,Ln,o),i(e,Tt,o),i(e,bn,o),g(Pt,e,o),i(e,Tn,o),i(e,$t,o),i(e,Pn,o),i(e,vt,o),i(e,$n,o),i(e,wt,o),i(e,vn,o),i(e,wn,o),i(e,yn,o),i(e,yt,o),i(e,xn,o),g(xt,e,o),i(e,kn,o),i(e,kt,o),i(e,Cn,o),i(e,Ct,o),i(e,Mn,o),i(e,Hn,o),i(e,Sn,o),i(e,Mt,o),i(e,An,o),g(Ht,e,o),i(e,Nn,o),i(e,St,o),i(e,En,o),i(e,At,o),i(e,Rn,o),i(e,Nt,o),i(e,Bn,o),i(e,On,o),i(e,jn,o),i(e,Et,o),i(e,Gn,o),g(Rt,e,o),i(e,Fn,o),i(e,Bt,o),i(e,In,o),i(e,Ot,o),i(e,qn,o),i(e,jt,o),i(e,Dn,o),i(e,Wn,o),i(e,zn,o),i(e,Gt,o),i(e,Kn,o),g(Ft,e,o),i(e,Un,o),i(e,It,o),i(e,Jn,o),i(e,qt,o),i(e,Qn,o),i(e,Dt,o),i(e,Vn,o),i(e,Xn,o),i(e,Yn,o),i(e,Wt,o),i(e,Zn,o),g(zt,e,o),i(e,ed,o),i(e,Kt,o),i(e,td,o),i(e,Ut,o),i(e,od,o),i(e,Jt,o),i(e,id,o),i(e,ld,o),i(e,sd,o),i(e,Qt,o),i(e,rd,o),g(Vt,e,o),i(e,nd,o),i(e,Xt,o),i(e,dd,o),i(e,Yt,o),i(e,ad,o),i(e,Zt,o),i(e,cd,o),i(e,pd,o),i(e,ud,o),i(e,eo,o),i(e,gd,o),g(to,e,o),i(e,md,o),i(e,oo,o),i(e,fd,o),i(e,io,o),i(e,hd,o),i(e,_d,o),i(e,Ld,o),i(e,lo,o),i(e,bd,o),g(so,e,o),i(e,Td,o),i(e,ro,o),i(e,Pd,o),i(e,no,o),i(e,$d,o),i(e,ao,o),i(e,vd,o),i(e,wd,o),i(e,yd,o),i(e,co,o),i(e,xd,o),g(po,e,o),i(e,kd,o),i(e,uo,o),i(e,Cd,o),i(e,go,o),i(e,Md,o),i(e,mo,o),i(e,Hd,o),i(e,Sd,o),i(e,Ad,o),i(e,fo,o),i(e,Nd,o),g(ho,e,o),i(e,Ed,o),i(e,_o,o),i(e,Rd,o),i(e,Lo,o),i(e,Bd,o),i(e,Od,o),i(e,jd,o),i(e,bo,o),i(e,Gd,o),g(To,e,o),i(e,Fd,o),i(e,Po,o),i(e,Id,o),i(e,$o,o),i(e,qd,o),i(e,vo,o),i(e,Dd,o),i(e,Wd,o),i(e,zd,o),i(e,wo,o),i(e,Kd,o),g(yo,e,o),i(e,Ud,o),i(e,xo,o),i(e,Jd,o),i(e,ko,o),i(e,Qd,o),i(e,Co,o),i(e,Vd,o),i(e,Xd,o),i(e,Yd,o),i(e,Mo,o),i(e,Zd,o),g(Ho,e,o),i(e,ea,o),i(e,So,o),i(e,ta,o),i(e,Ao,o),i(e,oa,o),i(e,ia,o),i(e,la,o),i(e,No,o),i(e,sa,o),g(Eo,e,o),i(e,ra,o),i(e,Ro,o),i(e,na,o),i(e,Bo,o),i(e,da,o),i(e,Oo,o),i(e,aa,o),i(e,ca,o),i(e,pa,o),i(e,jo,o),i(e,ua,o),g(Go,e,o),i(e,ga,o),i(e,Fo,o),i(e,ma,o),i(e,Io,o),i(e,fa,o),i(e,ha,o),i(e,_a,o),i(e,qo,o),i(e,La,o),g(Do,e,o),i(e,ba,o),i(e,Wo,o),i(e,Ta,o),i(e,zo,o),i(e,Pa,o),i(e,$a,o),i(e,va,o),i(e,Ko,o),i(e,wa,o),g(Uo,e,o),i(e,ya,o),i(e,Jo,o),i(e,xa,o),i(e,Qo,o),i(e,ka,o),i(e,Vo,o),i(e,Ca,o),i(e,Ma,o),i(e,Ha,o),i(e,Xo,o),i(e,Sa,o),g(Yo,e,o),i(e,Aa,o),i(e,Zo,o),i(e,Na,o),i(e,ei,o),i(e,Ea,o),i(e,ti,o),i(e,Ra,o),i(e,Ba,o),i(e,Oa,o),i(e,oi,o),i(e,ja,o),g(ii,e,o),i(e,Ga,o),i(e,li,o),i(e,Fa,o),i(e,si,o),i(e,Ia,o),i(e,qa,o),i(e,Da,o),i(e,ri,o),i(e,Wa,o),g(ni,e,o),i(e,za,o),i(e,di,o),i(e,Ka,o),i(e,ai,o),i(e,Ua,o),i(e,ci,o),i(e,Ja,o),i(e,Qa,o),i(e,Va,o),i(e,pi,o),i(e,Xa,o),g(ui,e,o),i(e,Ya,o),i(e,gi,o),i(e,Za,o),i(e,mi,o),i(e,ec,o),i(e,fi,o),i(e,tc,o),i(e,hi,o),i(e,oc,o),i(e,ic,o),i(e,lc,o),i(e,_i,o),i(e,sc,o),g(Li,e,o),i(e,rc,o),i(e,bi,o),i(e,nc,o),i(e,Ti,o),i(e,dc,o),i(e,Pi,o),i(e,ac,o),i(e,cc,o),i(e,pc,o),i(e,$i,o),i(e,uc,o),g(vi,e,o),i(e,gc,o),i(e,wi,o),i(e,mc,o),i(e,yi,o),i(e,fc,o),i(e,xi,o),i(e,hc,o),i(e,_c,o),i(e,Lc,o),i(e,ki,o),i(e,bc,o),g(Ci,e,o),i(e,Tc,o),i(e,Mi,o),i(e,Pc,o),i(e,Hi,o),i(e,$c,o),i(e,Si,o),i(e,vc,o),i(e,wc,o),i(e,yc,o),i(e,Ai,o),i(e,xc,o),g(Ni,e,o),i(e,kc,o),i(e,Ei,o),i(e,Cc,o),i(e,Ri,o),i(e,Mc,o),i(e,Hc,o),i(e,Sc,o),i(e,Bi,o),i(e,Ac,o),g(Oi,e,o),i(e,Nc,o),i(e,ji,o),i(e,Ec,o),i(e,Rc,o),i(e,Bc,o),i(e,Gi,o),i(e,Oc,o),g(Fi,e,o),i(e,jc,o),i(e,Ii,o),i(e,Gc,o),i(e,qi,o),i(e,Fc,o),i(e,Ic,o),i(e,qc,o),i(e,Di,o),i(e,Dc,o),g(Wi,e,o),i(e,Wc,o),i(e,zi,o),i(e,zc,o),i(e,Ki,o),i(e,Kc,o),i(e,Uc,o),i(e,Jc,o),i(e,Ui,o),i(e,Qc,o),g(Ji,e,o),i(e,Vc,o),i(e,Qi,o),i(e,Xc,o),i(e,Vi,o),i(e,Yc,o),i(e,Xi,o),i(e,Zc,o),i(e,ep,o),i(e,tp,o),i(e,Yi,o),i(e,op,o),g(Zi,e,o),i(e,ip,o),i(e,el,o),i(e,lp,o),i(e,tl,o),i(e,sp,o),i(e,rp,o),i(e,np,o),i(e,ol,o),i(e,dp,o),g(il,e,o),i(e,ap,o),i(e,ll,o),i(e,cp,o),i(e,sl,o),i(e,pp,o),i(e,rl,o),i(e,up,o),i(e,gp,o),i(e,mp,o),i(e,nl,o),i(e,fp,o),g(dl,e,o),i(e,hp,o),i(e,al,o),i(e,_p,o),i(e,cl,o),i(e,Lp,o),i(e,bp,o),i(e,Tp,o),i(e,pl,o),i(e,Pp,o),g(ul,e,o),i(e,$p,o),i(e,gl,o),i(e,vp,o),i(e,ml,o),i(e,wp,o),i(e,fl,o),i(e,yp,o),i(e,xp,o),i(e,kp,o),i(e,hl,o),i(e,Cp,o),g(_l,e,o),i(e,Mp,o),i(e,Ll,o),i(e,Hp,o),i(e,bl,o),i(e,Sp,o),i(e,Tl,o),i(e,Ap,o),i(e,Np,o),i(e,Ep,o),i(e,$l,o),Rp=!0},p:Sm,i(e){Rp||(m(T.$$.fragment,e),m(x.$$.fragment,e),m(S.$$.fragment,e),m(E.$$.fragment,e),m(G.$$.fragment,e),m(W.$$.fragment,e),m(Q.$$.fragment,e),m(Z.$$.fragment,e),m(se.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(be.$$.fragment,e),m(we.$$.fragment,e),m(Ce.$$.fragment,e),m(Ne.$$.fragment,e),m(je.$$.fragment,e),m(qe.$$.fragment,e),m(Ue.$$.fragment,e),m(Ye.$$.fragment,e),m(ot.$$.fragment,e),m(nt.$$.fragment,e),m(ut.$$.fragment,e),m(ht.$$.fragment,e),m(Pt.$$.fragment,e),m(xt.$$.fragment,e),m(Ht.$$.fragment,e),m(Rt.$$.fragment,e),m(Ft.$$.fragment,e),m(zt.$$.fragment,e),m(Vt.$$.fragment,e),m(to.$$.fragment,e),m(so.$$.fragment,e),m(po.$$.fragment,e),m(ho.$$.fragment,e),m(To.$$.fragment,e),m(yo.$$.fragment,e),m(Ho.$$.fragment,e),m(Eo.$$.fragment,e),m(Go.$$.fragment,e),m(Do.$$.fragment,e),m(Uo.$$.fragment,e),m(Yo.$$.fragment,e),m(ii.$$.fragment,e),m(ni.$$.fragment,e),m(ui.$$.fragment,e),m(Li.$$.fragment,e),m(vi.$$.fragment,e),m(Ci.$$.fragment,e),m(Ni.$$.fragment,e),m(Oi.$$.fragment,e),m(Fi.$$.fragment,e),m(Wi.$$.fragment,e),m(Ji.$$.fragment,e),m(Zi.$$.fragment,e),m(il.$$.fragment,e),m(dl.$$.fragment,e),m(ul.$$.fragment,e),m(_l.$$.fragment,e),Rp=!0)},o(e){f(T.$$.fragment,e),f(x.$$.fragment,e),f(S.$$.fragment,e),f(E.$$.fragment,e),f(G.$$.fragment,e),f(W.$$.fragment,e),f(Q.$$.fragment,e),f(Z.$$.fragment,e),f(se.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(be.$$.fragment,e),f(we.$$.fragment,e),f(Ce.$$.fragment,e),f(Ne.$$.fragment,e),f(je.$$.fragment,e),f(qe.$$.fragment,e),f(Ue.$$.fragment,e),f(Ye.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(ut.$$.fragment,e),f(ht.$$.fragment,e),f(Pt.$$.fragment,e),f(xt.$$.fragment,e),f(Ht.$$.fragment,e),f(Rt.$$.fragment,e),f(Ft.$$.fragment,e),f(zt.$$.fragment,e),f(Vt.$$.fragment,e),f(to.$$.fragment,e),f(so.$$.fragment,e),f(po.$$.fragment,e),f(ho.$$.fragment,e),f(To.$$.fragment,e),f(yo.$$.fragment,e),f(Ho.$$.fragment,e),f(Eo.$$.fragment,e),f(Go.$$.fragment,e),f(Do.$$.fragment,e),f(Uo.$$.fragment,e),f(Yo.$$.fragment,e),f(ii.$$.fragment,e),f(ni.$$.fragment,e),f(ui.$$.fragment,e),f(Li.$$.fragment,e),f(vi.$$.fragment,e),f(Ci.$$.fragment,e),f(Ni.$$.fragment,e),f(Oi.$$.fragment,e),f(Fi.$$.fragment,e),f(Wi.$$.fragment,e),f(Ji.$$.fragment,e),f(Zi.$$.fragment,e),f(il.$$.fragment,e),f(dl.$$.fragment,e),f(ul.$$.fragment,e),f(_l.$$.fragment,e),Rp=!1},d(e){e&&(t(vl),t(Pl),t(wl),t(b),t(yl),t(xl),t(P),t(kl),t($),t(Cl),t(v),t(Ml),t(w),t(Hl),t(Sl),t(Al),t(y),t(Nl),t(El),t(k),t(Rl),t(C),t(Bl),t(M),t(Ol),t(jl),t(Gl),t(H),t(Fl),t(Il),t(A),t(ql),t(Dl),t(Wl),t(N),t(zl),t(Kl),t(R),t(Ul),t(B),t(Jl),t(O),t(Ql),t(Vl),t(Xl),t(j),t(Yl),t(Zl),t(F),t(es),t(I),t(ts),t(q),t(os),t(is),t(ls),t(D),t(ss),t(rs),t(z),t(ns),t(K),t(ds),t(U),t(as),t(cs),t(ps),t(J),t(us),t(gs),t(V),t(ms),t(X),t(fs),t(hs),t(_s),t(Y),t(Ls),t(bs),t(ee),t(Ts),t(te),t(Ps),t(oe),t($s),t(ie),t(vs),t(ws),t(ys),t(le),t(xs),t(ks),t(re),t(Cs),t(ne),t(Ms),t(de),t(Hs),t(Ss),t(As),t(ae),t(Ns),t(Es),t(pe),t(Rs),t(ue),t(Bs),t(Os),t(js),t(ge),t(Gs),t(Fs),t(fe),t(Is),t(he),t(qs),t(_e),t(Ds),t(Ws),t(zs),t(Le),t(Ks),t(Us),t(Te),t(Js),t(Pe),t(Qs),t($e),t(Vs),t(Xs),t(Ys),t(ve),t(Zs),t(er),t(ye),t(tr),t(xe),t(or),t(ir),t(lr),t(ke),t(sr),t(rr),t(Me),t(nr),t(He),t(dr),t(Se),t(ar),t(cr),t(pr),t(Ae),t(ur),t(gr),t(Ee),t(mr),t(Re),t(fr),t(Be),t(hr),t(_r),t(Lr),t(Oe),t(br),t(Tr),t(Ge),t(Pr),t(Fe),t($r),t(vr),t(wr),t(Ie),t(yr),t(xr),t(De),t(kr),t(We),t(Cr),t(ze),t(Mr),t(Hr),t(Sr),t(Ke),t(Ar),t(Nr),t(Je),t(Er),t(Qe),t(Rr),t(Ve),t(Br),t(Or),t(jr),t(Xe),t(Gr),t(Fr),t(Ze),t(Ir),t(et),t(qr),t(Dr),t(Wr),t(tt),t(zr),t(Kr),t(it),t(Ur),t(lt),t(Jr),t(st),t(Qr),t(Vr),t(Xr),t(rt),t(Yr),t(Zr),t(dt),t(en),t(at),t(tn),t(ct),t(on),t(ln),t(sn),t(pt),t(rn),t(nn),t(gt),t(dn),t(mt),t(an),t(cn),t(pn),t(ft),t(un),t(gn),t(_t),t(mn),t(Lt),t(fn),t(bt),t(hn),t(_n),t(Ln),t(Tt),t(bn),t(Tn),t($t),t(Pn),t(vt),t($n),t(wt),t(vn),t(wn),t(yn),t(yt),t(xn),t(kn),t(kt),t(Cn),t(Ct),t(Mn),t(Hn),t(Sn),t(Mt),t(An),t(Nn),t(St),t(En),t(At),t(Rn),t(Nt),t(Bn),t(On),t(jn),t(Et),t(Gn),t(Fn),t(Bt),t(In),t(Ot),t(qn),t(jt),t(Dn),t(Wn),t(zn),t(Gt),t(Kn),t(Un),t(It),t(Jn),t(qt),t(Qn),t(Dt),t(Vn),t(Xn),t(Yn),t(Wt),t(Zn),t(ed),t(Kt),t(td),t(Ut),t(od),t(Jt),t(id),t(ld),t(sd),t(Qt),t(rd),t(nd),t(Xt),t(dd),t(Yt),t(ad),t(Zt),t(cd),t(pd),t(ud),t(eo),t(gd),t(md),t(oo),t(fd),t(io),t(hd),t(_d),t(Ld),t(lo),t(bd),t(Td),t(ro),t(Pd),t(no),t($d),t(ao),t(vd),t(wd),t(yd),t(co),t(xd),t(kd),t(uo),t(Cd),t(go),t(Md),t(mo),t(Hd),t(Sd),t(Ad),t(fo),t(Nd),t(Ed),t(_o),t(Rd),t(Lo),t(Bd),t(Od),t(jd),t(bo),t(Gd),t(Fd),t(Po),t(Id),t($o),t(qd),t(vo),t(Dd),t(Wd),t(zd),t(wo),t(Kd),t(Ud),t(xo),t(Jd),t(ko),t(Qd),t(Co),t(Vd),t(Xd),t(Yd),t(Mo),t(Zd),t(ea),t(So),t(ta),t(Ao),t(oa),t(ia),t(la),t(No),t(sa),t(ra),t(Ro),t(na),t(Bo),t(da),t(Oo),t(aa),t(ca),t(pa),t(jo),t(ua),t(ga),t(Fo),t(ma),t(Io),t(fa),t(ha),t(_a),t(qo),t(La),t(ba),t(Wo),t(Ta),t(zo),t(Pa),t($a),t(va),t(Ko),t(wa),t(ya),t(Jo),t(xa),t(Qo),t(ka),t(Vo),t(Ca),t(Ma),t(Ha),t(Xo),t(Sa),t(Aa),t(Zo),t(Na),t(ei),t(Ea),t(ti),t(Ra),t(Ba),t(Oa),t(oi),t(ja),t(Ga),t(li),t(Fa),t(si),t(Ia),t(qa),t(Da),t(ri),t(Wa),t(za),t(di),t(Ka),t(ai),t(Ua),t(ci),t(Ja),t(Qa),t(Va),t(pi),t(Xa),t(Ya),t(gi),t(Za),t(mi),t(ec),t(fi),t(tc),t(hi),t(oc),t(ic),t(lc),t(_i),t(sc),t(rc),t(bi),t(nc),t(Ti),t(dc),t(Pi),t(ac),t(cc),t(pc),t($i),t(uc),t(gc),t(wi),t(mc),t(yi),t(fc),t(xi),t(hc),t(_c),t(Lc),t(ki),t(bc),t(Tc),t(Mi),t(Pc),t(Hi),t($c),t(Si),t(vc),t(wc),t(yc),t(Ai),t(xc),t(kc),t(Ei),t(Cc),t(Ri),t(Mc),t(Hc),t(Sc),t(Bi),t(Ac),t(Nc),t(ji),t(Ec),t(Rc),t(Bc),t(Gi),t(Oc),t(jc),t(Ii),t(Gc),t(qi),t(Fc),t(Ic),t(qc),t(Di),t(Dc),t(Wc),t(zi),t(zc),t(Ki),t(Kc),t(Uc),t(Jc),t(Ui),t(Qc),t(Vc),t(Qi),t(Xc),t(Vi),t(Yc),t(Xi),t(Zc),t(ep),t(tp),t(Yi),t(op),t(ip),t(el),t(lp),t(tl),t(sp),t(rp),t(np),t(ol),t(dp),t(ap),t(ll),t(cp),t(sl),t(pp),t(rl),t(up),t(gp),t(mp),t(nl),t(fp),t(hp),t(al),t(_p),t(cl),t(Lp),t(bp),t(Tp),t(pl),t(Pp),t($p),t(gl),t(vp),t(ml),t(wp),t(fl),t(yp),t(xp),t(kp),t(hl),t(Cp),t(Mp),t(Ll),t(Hp),t(bl),t(Sp),t(Tl),t(Ap),t(Np),t(Ep),t($l)),t(L),h(T,e),h(x,e),h(S,e),h(E,e),h(G,e),h(W,e),h(Q,e),h(Z,e),h(se,e),h(ce,e),h(me,e),h(be,e),h(we,e),h(Ce,e),h(Ne,e),h(je,e),h(qe,e),h(Ue,e),h(Ye,e),h(ot,e),h(nt,e),h(ut,e),h(ht,e),h(Pt,e),h(xt,e),h(Ht,e),h(Rt,e),h(Ft,e),h(zt,e),h(Vt,e),h(to,e),h(so,e),h(po,e),h(ho,e),h(To,e),h(yo,e),h(Ho,e),h(Eo,e),h(Go,e),h(Do,e),h(Uo,e),h(Yo,e),h(ii,e),h(ni,e),h(ui,e),h(Li,e),h(vi,e),h(Ci,e),h(Ni,e),h(Oi,e),h(Fi,e),h(Wi,e),h(Ji,e),h(Zi,e),h(il,e),h(dl,e),h(ul,e),h(_l,e)}}}const jm='{"title":"utils/generation","local":"utilsgeneration","sections":[{"title":"utils/generation.LogitsProcessorList ⇐ <code> Callable </code>","local":"utilsgenerationlogitsprocessorlist--code-callable-code","sections":[{"title":"new LogitsProcessorList()","local":"new-logitsprocessorlist","sections":[],"depth":3},{"title":"logitsProcessorList.push(item)","local":"logitsprocessorlistpushitem","sections":[],"depth":3},{"title":"logitsProcessorList.extend(items)","local":"logitsprocessorlistextenditems","sections":[],"depth":3},{"title":"logitsProcessorList._call(input_ids, batchedLogits)","local":"logitsprocessorlistcallinputids-batchedlogits","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.LogitsProcessor ⇐ <code> Callable </code>","local":"utilsgenerationlogitsprocessor--code-callable-code","sections":[{"title":"logitsProcessor._call(input_ids, logits)","local":"logitsprocessorcallinputids-logits","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.ForceTokensLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationforcetokenslogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new ForceTokensLogitsProcessor(forced_decoder_ids)","local":"new-forcetokenslogitsprocessorforceddecoderids","sections":[],"depth":3},{"title":"forceTokensLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>","local":"forcetokenslogitsprocessorcallinputids-logits--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.ForcedBOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationforcedbostokenlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new ForcedBOSTokenLogitsProcessor(bos_token_id)","local":"new-forcedbostokenlogitsprocessorbostokenid","sections":[],"depth":3},{"title":"forcedBOSTokenLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"forcedbostokenlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.ForcedEOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationforcedeostokenlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)","local":"new-forcedeostokenlogitsprocessormaxlength-forcedeostokenid","sections":[],"depth":3},{"title":"forcedEOSTokenLogitsProcessor._call(input_ids, logits)","local":"forcedeostokenlogitsprocessorcallinputids-logits","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.SuppressTokensAtBeginLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationsuppresstokensatbeginlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)","local":"new-suppresstokensatbeginlogitsprocessorbeginsuppresstokens-beginindex","sections":[],"depth":3},{"title":"suppressTokensAtBeginLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"suppresstokensatbeginlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.WhisperTimeStampLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationwhispertimestamplogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new WhisperTimeStampLogitsProcessor(generate_config)","local":"new-whispertimestamplogitsprocessorgenerateconfig","sections":[],"depth":3},{"title":"whisperTimeStampLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>","local":"whispertimestamplogitsprocessorcallinputids-logits--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.NoRepeatNGramLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationnorepeatngramlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)","local":"new-norepeatngramlogitsprocessornorepeatngramsize","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor.getNgrams(prevInputIds) ⇒ <code> Map. < string, Array < number > > </code>","local":"norepeatngramlogitsprocessorgetngramsprevinputids--code-map--string-array--number---code","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor.getGeneratedNgrams(bannedNgrams, prevInputIds) ⇒ <code> Array. < number > </code>","local":"norepeatngramlogitsprocessorgetgeneratedngramsbannedngrams-previnputids--code-array--number--code","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor.calcBannedNgramTokens(prevInputIds) ⇒ <code> Array. < number > </code>","local":"norepeatngramlogitsprocessorcalcbannedngramtokensprevinputids--code-array--number--code","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"norepeatngramlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.RepetitionPenaltyLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationrepetitionpenaltylogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new RepetitionPenaltyLogitsProcessor(penalty)","local":"new-repetitionpenaltylogitsprocessorpenalty","sections":[],"depth":3},{"title":"repetitionPenaltyLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"repetitionpenaltylogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.MinLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationminlengthlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new MinLengthLogitsProcessor(min_length, eos_token_id)","local":"new-minlengthlogitsprocessorminlength-eostokenid","sections":[],"depth":3},{"title":"minLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"minlengthlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.MinNewTokensLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationminnewtokenslengthlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)","local":"new-minnewtokenslengthlogitsprocessorpromptlengthtoskip-minnewtokens-eostokenid","sections":[],"depth":3},{"title":"minNewTokensLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"minnewtokenslengthlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.NoBadWordsLogitsProcessor","local":"utilsgenerationnobadwordslogitsprocessor","sections":[{"title":"new NoBadWordsLogitsProcessor(bad_words_ids, eos_token_id)","local":"new-nobadwordslogitsprocessorbadwordsids-eostokenid","sections":[],"depth":3},{"title":"noBadWordsLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"nobadwordslogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.Sampler","local":"utilsgenerationsampler","sections":[{"title":"new Sampler(generation_config)","local":"new-samplergenerationconfig","sections":[],"depth":3},{"title":"sampler._call(logits, index) ⇒ <code> void </code>","local":"samplercalllogits-index--code-void-code","sections":[],"depth":3},{"title":"sampler.sample(logits, index)","local":"samplersamplelogits-index","sections":[],"depth":3},{"title":"sampler.getLogits(logits, index) ⇒ <code> Float32Array </code>","local":"samplergetlogitslogits-index--code-float32array-code","sections":[],"depth":3},{"title":"sampler.randomSelect(probabilities) ⇒ <code> number </code>","local":"samplerrandomselectprobabilities--code-number-code","sections":[],"depth":3},{"title":"Sampler.getSampler(generation_config) ⇒ <code> Sampler </code>","local":"samplergetsamplergenerationconfig--code-sampler-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.GenerationConfig : <code> * </code>","local":"utilsgenerationgenerationconfig--code--code","sections":[],"depth":2},{"title":"utils/generation~GenerationConfig","local":"utilsgenerationgenerationconfig","sections":[{"title":"new GenerationConfig(kwargs)","local":"new-generationconfigkwargs","sections":[],"depth":3}],"depth":2},{"title":"utils/generation~GreedySampler ⇐ <code> Sampler </code>","local":"utilsgenerationgreedysampler--code-sampler-code","sections":[{"title":"greedySampler.sample(logits, [index]) ⇒ <code> Array </code>","local":"greedysamplersamplelogits-index--code-array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation~MultinomialSampler ⇐ <code> Sampler </code>","local":"utilsgenerationmultinomialsampler--code-sampler-code","sections":[{"title":"multinomialSampler.sample(logits, index) ⇒ <code> Array </code>","local":"multinomialsamplersamplelogits-index--code-array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation~BeamSearchSampler ⇐ <code> Sampler </code>","local":"utilsgenerationbeamsearchsampler--code-sampler-code","sections":[{"title":"beamSearchSampler.sample(logits, index) ⇒ <code> Array </code>","local":"beamsearchsamplersamplelogits-index--code-array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation~GenerationConfigType : <code> Object </code>","local":"utilsgenerationgenerationconfigtype--code-object-code","sections":[],"depth":2}],"depth":1}';function Gm(Bp){return Am(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dm extends Nm{constructor(L){super(),Em(this,L,Gm,Om,Hm,{})}}export{Dm as component};
