import{s as xA,n as gA,o as CA}from"../chunks/scheduler.b108d059.js";import{S as IA,i as kA,g as a,s as n,r as c,A as AA,h as p,f as l,c as s,j as y,u as r,x as o,k as d,y as PA,a as i,v as m,d as u,t as M,w as T}from"../chunks/index.008de539.js";import{C as J}from"../chunks/CodeBlock.3968c746.js";import{H as h}from"../chunks/Heading.88bfeb84.js";function _A(eg){let f,ir,tr,nr,w,sr,j,ar,U,tg="Pipelines provide a high-level, easy to use, API for running machine learning models.",pr,b,lg="<strong>Example:</strong> Instantiate pipeline using the <code>pipeline</code> function.",or,x,dr,g,ig='<li><a href="#module_pipelines">pipelines</a><ul><li><em>static</em><ul><li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> : <code>DisposeType</code></li></ul></li> <li><a href="#module_pipelines.TextClassificationPipeline">.TextClassificationPipeline</a><ul><li><a href="#new_module_pipelines.TextClassificationPipeline_new"><code>new TextClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextClassificationPipeline+_call"><code>._call()</code></a> : <code>TextClassificationPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.TokenClassificationPipeline">.TokenClassificationPipeline</a><ul><li><a href="#new_module_pipelines.TokenClassificationPipeline_new"><code>new TokenClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.TokenClassificationPipeline+_call"><code>._call()</code></a> : <code>TokenClassificationPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.QuestionAnsweringPipeline">.QuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.QuestionAnsweringPipeline_new"><code>new QuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.QuestionAnsweringPipeline+_call"><code>._call()</code></a> : <code>QuestionAnsweringPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.FillMaskPipeline">.FillMaskPipeline</a><ul><li><a href="#new_module_pipelines.FillMaskPipeline_new"><code>new FillMaskPipeline(options)</code></a></li> <li><a href="#module_pipelines.FillMaskPipeline+_call"><code>._call()</code></a> : <code>FillMaskPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.Text2TextGenerationPipeline">.Text2TextGenerationPipeline</a><ul><li><a href="#new_module_pipelines.Text2TextGenerationPipeline_new"><code>new Text2TextGenerationPipeline(options)</code></a></li> <li><a href="#module_pipelines.Text2TextGenerationPipeline+_key"><code>._key</code></a> : <code>’generated_text’</code></li> <li><a href="#module_pipelines.Text2TextGenerationPipeline+_call"><code>._call()</code></a> : <code>Text2TextGenerationPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.SummarizationPipeline">.SummarizationPipeline</a><ul><li><a href="#new_module_pipelines.SummarizationPipeline_new"><code>new SummarizationPipeline(options)</code></a></li> <li><a href="#module_pipelines.SummarizationPipeline+_key"><code>._key</code></a> : <code>’summary_text’</code></li></ul></li> <li><a href="#module_pipelines.TranslationPipeline">.TranslationPipeline</a><ul><li><a href="#new_module_pipelines.TranslationPipeline_new"><code>new TranslationPipeline(options)</code></a></li> <li><a href="#module_pipelines.TranslationPipeline+_key"><code>._key</code></a> : <code>’translation_text’</code></li></ul></li> <li><a href="#module_pipelines.TextGenerationPipeline">.TextGenerationPipeline</a><ul><li><a href="#new_module_pipelines.TextGenerationPipeline_new"><code>new TextGenerationPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextGenerationPipeline+_call"><code>._call()</code></a> : <code>TextGenerationPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+model"><code>.model</code></a> : <code>any</code></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call()</code></a> : <code>ZeroShotClassificationPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.FeatureExtractionPipeline">.FeatureExtractionPipeline</a><ul><li><a href="#new_module_pipelines.FeatureExtractionPipeline_new"><code>new FeatureExtractionPipeline(options)</code></a></li> <li><a href="#module_pipelines.FeatureExtractionPipeline+_call"><code>._call()</code></a> : <code>FeatureExtractionPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.ImageFeatureExtractionPipeline">.ImageFeatureExtractionPipeline</a><ul><li><a href="#new_module_pipelines.ImageFeatureExtractionPipeline_new"><code>new ImageFeatureExtractionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageFeatureExtractionPipeline+_call"><code>._call()</code></a> : <code>ImageFeatureExtractionPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call()</code></a> : <code>AudioClassificationPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotAudioClassificationPipeline">.ZeroShotAudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotAudioClassificationPipeline_new"><code>new ZeroShotAudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotAudioClassificationPipeline+_call"><code>._call()</code></a> : <code>ZeroShotAudioClassificationPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call()</code></a> : <code>AutomaticSpeechRecognitionPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call()</code></a> : <code>ImageToTextPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call()</code></a> : <code>ImageClassificationPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call()</code></a> : <code>ImageSegmentationPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call()</code></a> : <code>ZeroShotImageClassificationPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call()</code></a> : <code>ObjectDetectionPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline">.ZeroShotObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotObjectDetectionPipeline_new"><code>new ZeroShotObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline+_call"><code>._call()</code></a> : <code>ZeroShotObjectDetectionPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call()</code></a> : <code>DocumentQuestionAnsweringPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call()</code></a> : <code>TextToAudioPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.ImageToImagePipeline">.ImageToImagePipeline</a><ul><li><a href="#new_module_pipelines.ImageToImagePipeline_new"><code>new ImageToImagePipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToImagePipeline+_call"><code>._call()</code></a> : <code>ImageToImagePipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.DepthEstimationPipeline">.DepthEstimationPipeline</a><ul><li><a href="#new_module_pipelines.DepthEstimationPipeline_new"><code>new DepthEstimationPipeline(options)</code></a></li> <li><a href="#module_pipelines.DepthEstimationPipeline+_call"><code>._call()</code></a> : <code>DepthEstimationPipelineCallback</code></li></ul></li> <li><a href="#module_pipelines.pipeline"><code>.pipeline(task, [model], [options])</code></a> ⇒ <code>*</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_pipelines..x%5B1%5D"><code>~x[1]</code></a> : <code>number</code></li> <li><a href="#module_pipelines..ImagePipelineInputs"><code>~ImagePipelineInputs</code></a> : <code>string</code> | <code>RawImage</code> | <code>URL</code></li> <li><a href="#module_pipelines..AudioPipelineInputs"><code>~AudioPipelineInputs</code></a> : <code>string</code> | <code>URL</code> | <code>Float32Array</code> | <code>Float64Array</code></li> <li><a href="#module_pipelines..BoundingBox"><code>~BoundingBox</code></a> : <code>Object</code></li> <li><a href="#module_pipelines..Disposable"><code>~Disposable</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines..TextPipelineConstructorArgs"><code>~TextPipelineConstructorArgs</code></a> : <code>Object</code></li> <li><a href="#module_pipelines..ImagePipelineConstructorArgs"><code>~ImagePipelineConstructorArgs</code></a> : <code>Object</code></li> <li><a href="#module_pipelines..TextImagePipelineConstructorArgs"><code>~TextImagePipelineConstructorArgs</code></a> : <code>Object</code></li> <li><a href="#module_pipelines..TextClassificationPipelineType"><code>~TextClassificationPipelineType</code></a> ⇒ <code>Promise.&lt;(TextClassificationOutput|Array&lt;TextClassificationOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..TokenClassificationPipelineType"><code>~TokenClassificationPipelineType</code></a> ⇒ <code>Promise.&lt;(TokenClassificationOutput|Array&lt;TokenClassificationOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..QuestionAnsweringPipelineType"><code>~QuestionAnsweringPipelineType</code></a> ⇒ <code>Promise.&lt;(QuestionAnsweringOutput|Array&lt;QuestionAnsweringOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..FillMaskPipelineType"><code>~FillMaskPipelineType</code></a> ⇒ <code>Promise.&lt;(FillMaskOutput|Array&lt;FillMaskOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..Text2TextGenerationPipelineType"><code>~Text2TextGenerationPipelineType</code></a> ⇒ <code>Promise.&lt;(Text2TextGenerationOutput|Array&lt;Text2TextGenerationOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..SummarizationPipelineType"><code>~SummarizationPipelineType</code></a> ⇒ <code>Promise.&lt;(SummarizationOutput|Array&lt;SummarizationOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..TranslationPipelineType"><code>~TranslationPipelineType</code></a> ⇒ <code>Promise.&lt;(TranslationOutput|Array&lt;TranslationOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..TextGenerationPipelineType"><code>~TextGenerationPipelineType</code></a> ⇒ <code>Promise.&lt;(TextGenerationOutput|Array&lt;TextGenerationOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..ZeroShotClassificationPipelineType"><code>~ZeroShotClassificationPipelineType</code></a> ⇒ <code>Promise.&lt;(ZeroShotClassificationOutput|Array&lt;ZeroShotClassificationOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..FeatureExtractionPipelineType"><code>~FeatureExtractionPipelineType</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_pipelines..ImageFeatureExtractionPipelineType"><code>~ImageFeatureExtractionPipelineType</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_pipelines..AudioClassificationPipelineType"><code>~AudioClassificationPipelineType</code></a> ⇒ <code>Promise.&lt;(AudioClassificationOutput|Array&lt;AudioClassificationOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..ZeroShotAudioClassificationPipelineType"><code>~ZeroShotAudioClassificationPipelineType</code></a> ⇒ <code>Promise.&lt;(Array&lt;ZeroShotAudioClassificationOutput&gt;|Array&lt;Array&lt;ZeroShotAudioClassificationOutput&gt;&gt;)&gt;</code></li> <li><a href="#module_pipelines..ChunkCallback"><code>~ChunkCallback</code></a> : <code>function</code></li> <li><a href="#module_pipelines..Chunk"><code>~Chunk</code></a> : <code>Object</code></li> <li><a href="#module_pipelines..AutomaticSpeechRecognitionPipelineType"><code>~AutomaticSpeechRecognitionPipelineType</code></a> ⇒ <code>Promise.&lt;(AutomaticSpeechRecognitionOutput|Array&lt;AutomaticSpeechRecognitionOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..ImageToTextPipelineType"><code>~ImageToTextPipelineType</code></a> ⇒ <code>Promise.&lt;(ImageToTextOutput|Array&lt;ImageToTextOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..ImageClassificationPipelineType"><code>~ImageClassificationPipelineType</code></a> ⇒ <code>Promise.&lt;(ImageClassificationOutput|Array&lt;ImageClassificationOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..ImageSegmentationPipelineType"><code>~ImageSegmentationPipelineType</code></a> ⇒ <code>Promise.&lt;Array&lt;ImageSegmentationPipelineOutput&gt;&gt;</code></li> <li><a href="#module_pipelines..ZeroShotImageClassificationPipelineType"><code>~ZeroShotImageClassificationPipelineType</code></a> ⇒ <code>Promise.&lt;(Array&lt;ZeroShotImageClassificationOutput&gt;|Array&lt;Array&lt;ZeroShotImageClassificationOutput&gt;&gt;)&gt;</code></li> <li><a href="#module_pipelines..ObjectDetectionPipelineType"><code>~ObjectDetectionPipelineType</code></a> ⇒ <code>Promise.&lt;(ObjectDetectionPipelineOutput|Array&lt;ObjectDetectionPipelineOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..ZeroShotObjectDetectionPipelineType"><code>~ZeroShotObjectDetectionPipelineType</code></a> ⇒ <code>Promise.&lt;(Array&lt;ZeroShotObjectDetectionOutput&gt;|Array&lt;Array&lt;ZeroShotObjectDetectionOutput&gt;&gt;)&gt;</code></li> <li><a href="#module_pipelines..DocumentQuestionAnsweringPipelineType"><code>~DocumentQuestionAnsweringPipelineType</code></a> ⇒ <code>Promise.&lt;(DocumentQuestionAnsweringOutput|Array&lt;DocumentQuestionAnsweringOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..TextToAudioPipelineConstructorArgs"><code>~TextToAudioPipelineConstructorArgs</code></a> : <code>Object</code></li> <li><a href="#module_pipelines..TextToAudioPipelineType"><code>~TextToAudioPipelineType</code></a> ⇒ <code>Promise.&lt;TextToAudioOutput&gt;</code></li> <li><a href="#module_pipelines..ImageToImagePipelineType"><code>~ImageToImagePipelineType</code></a> ⇒ <code>Promise.&lt;(RawImage|Array&lt;RawImage&gt;)&gt;</code></li> <li><a href="#module_pipelines..DepthEstimationPipelineType"><code>~DepthEstimationPipelineType</code></a> ⇒ <code>Promise.&lt;(DepthEstimationPipelineOutput|Array&lt;DepthEstimationPipelineOutput&gt;)&gt;</code></li> <li><a href="#module_pipelines..AllTasks"><code>~AllTasks</code></a> : <code>*</code></li></ul></li></ul></li>',cr,rr,mr,C,ur,I,Mr,k,ng=`The Pipeline class is the class from which all pipelines inherit.
Refer to this class for methods shared across different pipelines.`,Tr,A,sg='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',yr,P,ag='<li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> : <code>DisposeType</code></li></ul></li>',hr,Jr,fr,_,wr,$,jr,v,pg="Create a new Pipeline.",Ur,Q,og="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td></td><td><p>The model used by the pipeline.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><code></code></td><td><p>The tokenizer used by the pipeline (if any).</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><code></code></td><td><p>The processor used by the pipeline (if any).</p></td></tr></tbody>",br,xr,gr,G,Cr,H,Ir,Z,dg='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a>',kr,Ar,Pr,B,_r,E,$r,N,cg="Text classification pipeline using any <code>ModelForSequenceClassification</code>.",vr,Y,rg="<strong>Example:</strong> Sentiment-analysis w/ <code>Xenova/distilbert-base-uncased-finetuned-sst-2-english</code>.",Qr,R,Gr,z,mg="<strong>Example:</strong> Multilingual sentiment-analysis w/ <code>Xenova/bert-base-multilingual-uncased-sentiment</code> (and return top 5 classes).",Hr,L,Zr,S,ug="<strong>Example:</strong> Toxic comment classification w/ <code>Xenova/toxic-bert</code> (and return all classes).",Br,W,Er,X,Mg='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Nr,D,Tg='<li><a href="#module_pipelines.TextClassificationPipeline">.TextClassificationPipeline</a><ul><li><a href="#new_module_pipelines.TextClassificationPipeline_new"><code>new TextClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextClassificationPipeline+_call"><code>._call()</code></a> : <code>TextClassificationPipelineCallback</code></li></ul></li>',Yr,Rr,zr,F,Lr,V,Sr,O,yg="Create a new TextClassificationPipeline.",Wr,q,hg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",Xr,Dr,Fr,K,Vr,ee,Or,te,Jg='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextClassificationPipeline"><code>TextClassificationPipeline</code></a>',qr,Kr,em,le,tm,ie,lm,ne,fg="Named Entity Recognition pipeline using any <code>ModelForTokenClassification</code>.",im,se,wg="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code>.",nm,ae,sm,pe,jg="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code> (and return all labels).",am,oe,pm,de,Ug='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',om,ce,bg='<li><a href="#module_pipelines.TokenClassificationPipeline">.TokenClassificationPipeline</a><ul><li><a href="#new_module_pipelines.TokenClassificationPipeline_new"><code>new TokenClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.TokenClassificationPipeline+_call"><code>._call()</code></a> : <code>TokenClassificationPipelineCallback</code></li></ul></li>',dm,cm,rm,re,mm,me,um,ue,xg="Create a new TokenClassificationPipeline.",Mm,Me,gg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",Tm,ym,hm,Te,Jm,ye,fm,he,Cg='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TokenClassificationPipeline"><code>TokenClassificationPipeline</code></a>',wm,jm,Um,Je,bm,fe,xm,we,Ig="Question Answering pipeline using any <code>ModelForQuestionAnswering</code>.",gm,je,kg="<strong>Example:</strong> Run question answering with <code>Xenova/distilbert-base-uncased-distilled-squad</code>.",Cm,Ue,Im,be,Ag='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',km,xe,Pg='<li><a href="#module_pipelines.QuestionAnsweringPipeline">.QuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.QuestionAnsweringPipeline_new"><code>new QuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.QuestionAnsweringPipeline+_call"><code>._call()</code></a> : <code>QuestionAnsweringPipelineCallback</code></li></ul></li>',Am,Pm,_m,ge,$m,Ce,vm,Ie,_g="Create a new QuestionAnsweringPipeline.",Qm,ke,$g="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",Gm,Hm,Zm,Ae,Bm,Pe,Em,_e,vg='<strong>Kind</strong>: instance method of <a href="#module_pipelines.QuestionAnsweringPipeline"><code>QuestionAnsweringPipeline</code></a>',Nm,Ym,Rm,$e,zm,ve,Lm,Qe,Qg="Masked language modeling prediction pipeline using any <code>ModelWithLMHead</code>.",Sm,Ge,Gg="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-uncased</code>.",Wm,He,Xm,Ze,Hg="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-cased</code> (and return top result).",Dm,Be,Fm,Ee,Zg='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Vm,Ne,Bg='<li><a href="#module_pipelines.FillMaskPipeline">.FillMaskPipeline</a><ul><li><a href="#new_module_pipelines.FillMaskPipeline_new"><code>new FillMaskPipeline(options)</code></a></li> <li><a href="#module_pipelines.FillMaskPipeline+_call"><code>._call()</code></a> : <code>FillMaskPipelineCallback</code></li></ul></li>',Om,qm,Km,Ye,eu,Re,tu,ze,Eg="Create a new FillMaskPipeline.",lu,Le,Ng="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",iu,nu,su,Se,au,We,pu,Xe,Yg='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FillMaskPipeline"><code>FillMaskPipeline</code></a>',ou,du,cu,De,ru,Fe,mu,Ve,Rg="Text2TextGenerationPipeline class for generating text using a model that performs text-to-text generation tasks.",uu,Oe,zg="<strong>Example:</strong> Text-to-text generation w/ <code>Xenova/LaMini-Flan-T5-783M</code>.",Mu,qe,Tu,Ke,Lg='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',yu,et,Sg='<li><a href="#module_pipelines.Text2TextGenerationPipeline">.Text2TextGenerationPipeline</a><ul><li><a href="#new_module_pipelines.Text2TextGenerationPipeline_new"><code>new Text2TextGenerationPipeline(options)</code></a></li> <li><a href="#module_pipelines.Text2TextGenerationPipeline+_key"><code>._key</code></a> : <code>’generated_text’</code></li> <li><a href="#module_pipelines.Text2TextGenerationPipeline+_call"><code>._call()</code></a> : <code>Text2TextGenerationPipelineCallback</code></li></ul></li>',hu,Ju,fu,tt,wu,lt,ju,it,Wg="Create a new Text2TextGenerationPipeline.",Uu,nt,Xg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",bu,xu,gu,st,Cu,at,Iu,pt,Dg='<strong>Kind</strong>: instance property of <a href="#module_pipelines.Text2TextGenerationPipeline"><code>Text2TextGenerationPipeline</code></a>',ku,Au,Pu,ot,_u,dt,$u,ct,Fg='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Text2TextGenerationPipeline"><code>Text2TextGenerationPipeline</code></a>',vu,Qu,Gu,rt,Hu,mt,Zu,ut,Vg="A pipeline for summarization tasks, inheriting from Text2TextGenerationPipeline.",Bu,Mt,Og="<strong>Example:</strong> Summarization w/ <code>Xenova/distilbart-cnn-6-6</code>.",Eu,Tt,Nu,yt,qg='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Yu,ht,Kg='<li><a href="#module_pipelines.SummarizationPipeline">.SummarizationPipeline</a><ul><li><a href="#new_module_pipelines.SummarizationPipeline_new"><code>new SummarizationPipeline(options)</code></a></li> <li><a href="#module_pipelines.SummarizationPipeline+_key"><code>._key</code></a> : <code>’summary_text’</code></li></ul></li>',Ru,zu,Lu,Jt,Su,ft,Wu,wt,eC="Create a new SummarizationPipeline.",Xu,jt,tC="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",Du,Fu,Vu,Ut,Ou,bt,qu,xt,lC='<strong>Kind</strong>: instance property of <a href="#module_pipelines.SummarizationPipeline"><code>SummarizationPipeline</code></a>',Ku,eM,tM,gt,lM,Ct,iM,It,iC="Translates text from one language to another.",nM,kt,nC="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/nllb-200-distilled-600M</code>.",sM,At,sC=`See <a href="https://github.com/facebookresearch/flores/blob/main/flores200/README.md#languages-in-flores-200" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,aM,Pt,pM,_t,aC="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/m2m100_418M</code>.",oM,$t,pC=`See <a href="https://huggingface.co/facebook/m2m100_418M#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,dM,vt,cM,Qt,oC="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/mbart-large-50-many-to-many-mmt</code>.",rM,Gt,dC=`See <a href="https://huggingface.co/facebook/mbart-large-50-many-to-many-mmt#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,mM,Ht,uM,Zt,cC='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',MM,Bt,rC='<li><a href="#module_pipelines.TranslationPipeline">.TranslationPipeline</a><ul><li><a href="#new_module_pipelines.TranslationPipeline_new"><code>new TranslationPipeline(options)</code></a></li> <li><a href="#module_pipelines.TranslationPipeline+_key"><code>._key</code></a> : <code>’translation_text’</code></li></ul></li>',TM,yM,hM,Et,JM,Nt,fM,Yt,mC="Create a new TranslationPipeline.",wM,Rt,uC="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",jM,UM,bM,zt,xM,Lt,gM,St,MC='<strong>Kind</strong>: instance property of <a href="#module_pipelines.TranslationPipeline"><code>TranslationPipeline</code></a>',CM,IM,kM,Wt,AM,Xt,PM,Dt,TC=`Language generation pipeline using any <code>ModelWithLMHead</code> or <code>ModelForCausalLM</code>.
This pipeline predicts the words that will follow a specified text prompt.
NOTE: For the full list of generation parameters, see <a href="./utils/generation#module_utils/generation.GenerationConfig"><code>GenerationConfig</code></a>.`,_M,Ft,yC="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (default settings).",$M,Vt,vM,Ot,hC="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (custom settings).",QM,qt,GM,Kt,JC="<strong>Example:</strong> Run code generation with <code>Xenova/codegen-350M-mono</code>.",HM,el,ZM,tl,fC='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',BM,ll,wC='<li><a href="#module_pipelines.TextGenerationPipeline">.TextGenerationPipeline</a><ul><li><a href="#new_module_pipelines.TextGenerationPipeline_new"><code>new TextGenerationPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextGenerationPipeline+_call"><code>._call()</code></a> : <code>TextGenerationPipelineCallback</code></li></ul></li>',EM,NM,YM,il,RM,nl,zM,sl,jC="Create a new TextGenerationPipeline.",LM,al,UC="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",SM,WM,XM,pl,DM,ol,FM,dl,bC='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextGenerationPipeline"><code>TextGenerationPipeline</code></a>',VM,OM,qM,cl,KM,rl,eT,ml,xC=`NLI-based zero-shot classification pipeline using a <code>ModelForSequenceClassification</code>
trained on NLI (natural language inference) tasks. Equivalent of <code>text-classification</code>
pipelines, but these models don’t require a hardcoded number of potential classes, they
can be chosen at runtime. It usually means it’s slower but it is <strong>much</strong> more flexible.`,tT,ul,gC="<strong>Example:</strong> Zero shot classification with <code>Xenova/mobilebert-uncased-mnli</code>.",lT,Ml,iT,Tl,CC="<strong>Example:</strong> Zero shot classification with <code>Xenova/nli-deberta-v3-xsmall</code> (multi-label).",nT,yl,sT,hl,IC='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',aT,Jl,kC='<li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+model"><code>.model</code></a> : <code>any</code></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call()</code></a> : <code>ZeroShotClassificationPipelineCallback</code></li></ul></li>',pT,oT,dT,fl,cT,wl,rT,jl,AC="Create a new ZeroShotClassificationPipeline.",mT,Ul,PC="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",uT,MT,TT,bl,yT,xl,hT,gl,_C='<strong>Kind</strong>: instance property of <a href="#module_pipelines.ZeroShotClassificationPipeline"><code>ZeroShotClassificationPipeline</code></a>',JT,fT,wT,Cl,jT,Il,UT,kl,$C='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotClassificationPipeline"><code>ZeroShotClassificationPipeline</code></a>',bT,xT,gT,Al,CT,Pl,IT,_l,vC=`Feature extraction pipeline using no model head. This pipeline extracts the hidden
states from the base transformer, which can be used as features in downstream tasks.`,kT,$l,QC="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (without pooling/normalization).",AT,vl,PT,Ql,GC="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (with pooling/normalization).",_T,Gl,$T,Hl,HC="<strong>Example:</strong> Calculating embeddings with <code>sentence-transformers</code> models.",vT,Zl,QT,Bl,ZC="<strong>Example:</strong> Calculating binary embeddings with <code>sentence-transformers</code> models.",GT,El,HT,Nl,BC='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',ZT,Yl,EC='<li><a href="#module_pipelines.FeatureExtractionPipeline">.FeatureExtractionPipeline</a><ul><li><a href="#new_module_pipelines.FeatureExtractionPipeline_new"><code>new FeatureExtractionPipeline(options)</code></a></li> <li><a href="#module_pipelines.FeatureExtractionPipeline+_call"><code>._call()</code></a> : <code>FeatureExtractionPipelineCallback</code></li></ul></li>',BT,ET,NT,Rl,YT,zl,RT,Ll,NC="Create a new FeatureExtractionPipeline.",zT,Sl,YC="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",LT,ST,WT,Wl,XT,Xl,DT,Dl,RC='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FeatureExtractionPipeline"><code>FeatureExtractionPipeline</code></a>',FT,VT,OT,Fl,qT,Vl,KT,Ol,zC=`Image feature extraction pipeline using no model head. This pipeline extracts the hidden
states from the base transformer, which can be used as features in downstream tasks.`,ey,ql,LC="<strong>Example:</strong> Perform image feature extraction with <code>Xenova/vit-base-patch16-224-in21k</code>.",ty,Kl,ly,ei,SC="<strong>Example:</strong> Compute image embeddings with <code>Xenova/clip-vit-base-patch32</code>.",iy,ti,ny,li,WC='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',sy,ii,XC='<li><a href="#module_pipelines.ImageFeatureExtractionPipeline">.ImageFeatureExtractionPipeline</a><ul><li><a href="#new_module_pipelines.ImageFeatureExtractionPipeline_new"><code>new ImageFeatureExtractionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageFeatureExtractionPipeline+_call"><code>._call()</code></a> : <code>ImageFeatureExtractionPipelineCallback</code></li></ul></li>',ay,py,oy,ni,dy,si,cy,ai,DC="Create a new ImageFeatureExtractionPipeline.",ry,pi,FC="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>ImagePipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",my,uy,My,oi,Ty,di,yy,ci,VC='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageFeatureExtractionPipeline"><code>ImageFeatureExtractionPipeline</code></a>',hy,Jy,fy,ri,wy,mi,jy,ui,OC=`Audio classification pipeline using any <code>AutoModelForAudioClassification</code>.
This pipeline predicts the class of a raw waveform or an audio file.`,Uy,Mi,qC="<strong>Example:</strong> Perform audio classification with <code>Xenova/wav2vec2-large-xlsr-53-gender-recognition-librispeech</code>.",by,Ti,xy,yi,KC="<strong>Example:</strong> Perform audio classification with <code>Xenova/ast-finetuned-audioset-10-10-0.4593</code> and return top 4 results.",gy,hi,Cy,Ji,e0='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Iy,fi,t0='<li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call()</code></a> : <code>AudioClassificationPipelineCallback</code></li></ul></li>',ky,Ay,Py,wi,_y,ji,$y,Ui,l0="Create a new AudioClassificationPipeline.",vy,bi,i0="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>AudioPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",Qy,Gy,Hy,xi,Zy,gi,By,Ci,n0='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AudioClassificationPipeline"><code>AudioClassificationPipeline</code></a>',Ey,Ny,Yy,Ii,Ry,ki,zy,Ai,s0=`Zero shot audio classification pipeline using <code>ClapModel</code>. This pipeline predicts the class of an audio when you
provide an audio and a set of <code>candidate_labels</code>.`,Ly,Pi,a0="<strong>Example</strong>: Perform zero-shot audio classification with <code>Xenova/clap-htsat-unfused</code>.",Sy,_i,Wy,$i,p0='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Xy,vi,o0='<li><a href="#module_pipelines.ZeroShotAudioClassificationPipeline">.ZeroShotAudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotAudioClassificationPipeline_new"><code>new ZeroShotAudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotAudioClassificationPipeline+_call"><code>._call()</code></a> : <code>ZeroShotAudioClassificationPipelineCallback</code></li></ul></li>',Dy,Fy,Vy,Qi,Oy,Gi,qy,Hi,d0="Create a new ZeroShotAudioClassificationPipeline.",Ky,Zi,c0="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextAudioPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",eh,th,lh,Bi,ih,Ei,nh,Ni,r0='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotAudioClassificationPipeline"><code>ZeroShotAudioClassificationPipeline</code></a>',sh,ah,ph,Yi,oh,Ri,dh,zi,m0="Pipeline that aims at extracting spoken text contained within some audio.",ch,Li,u0="<strong>Example:</strong> Transcribe English.",rh,Si,mh,Wi,M0="<strong>Example:</strong> Transcribe English w/ timestamps.",uh,Xi,Mh,Di,T0="<strong>Example:</strong> Transcribe English w/ word-level timestamps.",Th,Fi,yh,Vi,y0="<strong>Example:</strong> Transcribe French.",hh,Oi,Jh,qi,h0="<strong>Example:</strong> Translate French to English.",fh,Ki,wh,en,J0="<strong>Example:</strong> Transcribe/translate audio longer than 30 seconds.",jh,tn,Uh,ln,f0='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',bh,nn,w0='<li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call()</code></a> : <code>AutomaticSpeechRecognitionPipelineCallback</code></li></ul></li>',xh,gh,Ch,sn,Ih,an,kh,pn,j0="Create a new AutomaticSpeechRecognitionPipeline.",Ah,on,U0="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextAudioPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",Ph,_h,$h,dn,vh,cn,Qh,rn,b0='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AutomaticSpeechRecognitionPipeline"><code>AutomaticSpeechRecognitionPipeline</code></a>',Gh,Hh,Zh,mn,Bh,un,Eh,Mn,x0="Image To Text pipeline using a <code>AutoModelForVision2Seq</code>. This pipeline predicts a caption for a given image.",Nh,Tn,g0="<strong>Example:</strong> Generate a caption for an image w/ <code>Xenova/vit-gpt2-image-captioning</code>.",Yh,yn,Rh,hn,C0="<strong>Example:</strong> Optical Character Recognition (OCR) w/ <code>Xenova/trocr-small-handwritten</code>.",zh,Jn,Lh,fn,I0='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Sh,wn,k0='<li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call()</code></a> : <code>ImageToTextPipelineCallback</code></li></ul></li>',Wh,Xh,Dh,jn,Fh,Un,Vh,bn,A0="Create a new ImageToTextPipeline.",Oh,xn,P0="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextImagePipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",qh,Kh,eJ,gn,tJ,Cn,lJ,In,_0='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageToTextPipeline"><code>ImageToTextPipeline</code></a>',iJ,nJ,sJ,kn,aJ,An,pJ,Pn,$0=`Image classification pipeline using any <code>AutoModelForImageClassification</code>.
This pipeline predicts the class of an image.`,oJ,_n,v0="<strong>Example:</strong> Classify an image.",dJ,$n,cJ,vn,Q0="<strong>Example:</strong> Classify an image and return top <code>n</code> classes.",rJ,Qn,mJ,Gn,G0="<strong>Example:</strong> Classify an image and return all classes.",uJ,Hn,MJ,Zn,H0='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',TJ,Bn,Z0='<li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call()</code></a> : <code>ImageClassificationPipelineCallback</code></li></ul></li>',yJ,hJ,JJ,En,fJ,Nn,wJ,Yn,B0="Create a new ImageClassificationPipeline.",jJ,Rn,E0="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>ImagePipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",UJ,bJ,xJ,zn,gJ,Ln,CJ,Sn,N0='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageClassificationPipeline"><code>ImageClassificationPipeline</code></a>',IJ,kJ,AJ,Wn,PJ,Xn,_J,Dn,Y0=`Image segmentation pipeline using any <code>AutoModelForXXXSegmentation</code>.
This pipeline predicts masks of objects and their classes.`,$J,Fn,R0="<strong>Example:</strong> Perform image segmentation with <code>Xenova/detr-resnet-50-panoptic</code>.",vJ,Vn,QJ,On,z0='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',GJ,qn,L0='<li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call()</code></a> : <code>ImageSegmentationPipelineCallback</code></li></ul></li>',HJ,ZJ,BJ,Kn,EJ,es,NJ,ts,S0="Create a new ImageSegmentationPipeline.",YJ,ls,W0="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>ImagePipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",RJ,zJ,LJ,is,SJ,ns,WJ,ss,X0='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageSegmentationPipeline"><code>ImageSegmentationPipeline</code></a>',XJ,DJ,FJ,as,VJ,ps,OJ,os,D0=`Zero shot image classification pipeline. This pipeline predicts the class of
an image when you provide an image and a set of <code>candidate_labels</code>.`,qJ,ds,F0="<strong>Example:</strong> Zero shot image classification w/ <code>Xenova/clip-vit-base-patch32</code>.",KJ,cs,ef,rs,V0='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',tf,ms,O0='<li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call()</code></a> : <code>ZeroShotImageClassificationPipelineCallback</code></li></ul></li>',lf,nf,sf,us,af,Ms,pf,Ts,q0="Create a new ZeroShotImageClassificationPipeline.",of,ys,K0="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextImagePipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",df,cf,rf,hs,mf,Js,uf,fs,eI='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotImageClassificationPipeline"><code>ZeroShotImageClassificationPipeline</code></a>',Mf,Tf,yf,ws,hf,js,Jf,Us,tI=`Object detection pipeline using any <code>AutoModelForObjectDetection</code>.
This pipeline predicts bounding boxes of objects and their classes.`,ff,bs,lI="<strong>Example:</strong> Run object-detection with <code>Xenova/detr-resnet-50</code>.",wf,xs,jf,gs,iI='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Uf,Cs,nI='<li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call()</code></a> : <code>ObjectDetectionPipelineCallback</code></li></ul></li>',bf,xf,gf,Is,Cf,ks,If,As,sI="Create a new ObjectDetectionPipeline.",kf,Ps,aI="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>ImagePipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",Af,Pf,_f,_s,$f,$s,vf,vs,pI='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ObjectDetectionPipeline"><code>ObjectDetectionPipeline</code></a>',Qf,Gf,Hf,Qs,Zf,Gs,Bf,Hs,oI=`Zero-shot object detection pipeline. This pipeline predicts bounding boxes of
objects when you provide an image and a set of <code>candidate_labels</code>.`,Ef,Zs,dI="<strong>Example:</strong> Zero-shot object detection w/ <code>Xenova/owlvit-base-patch32</code>.",Nf,Bs,Yf,Es,cI="<strong>Example:</strong> Zero-shot object detection w/ <code>Xenova/owlvit-base-patch32</code> (returning top 4 matches and setting a threshold).",Rf,Ns,zf,Ys,rI='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Lf,Rs,mI='<li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline">.ZeroShotObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotObjectDetectionPipeline_new"><code>new ZeroShotObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotObjectDetectionPipeline+_call"><code>._call()</code></a> : <code>ZeroShotObjectDetectionPipelineCallback</code></li></ul></li>',Sf,Wf,Xf,zs,Df,Ls,Ff,Ss,uI="Create a new ZeroShotObjectDetectionPipeline.",Vf,Ws,MI="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextImagePipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",Of,qf,Kf,Xs,ew,Ds,tw,Fs,TI='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotObjectDetectionPipeline"><code>ZeroShotObjectDetectionPipeline</code></a>',lw,iw,nw,Vs,sw,Os,aw,qs,yI=`Document Question Answering pipeline using any <code>AutoModelForDocumentQuestionAnswering</code>.
The inputs/outputs are similar to the (extractive) question answering pipeline; however,
the pipeline takes an image (and optional OCR’d words/boxes) as input instead of text context.`,pw,Ks,hI="<strong>Example:</strong> Answer questions about a document with <code>Xenova/donut-base-finetuned-docvqa</code>.",ow,ea,dw,ta,JI='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',cw,la,fI='<li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call()</code></a> : <code>DocumentQuestionAnsweringPipelineCallback</code></li></ul></li>',rw,mw,uw,ia,Mw,na,Tw,sa,wI="Create a new DocumentQuestionAnsweringPipeline.",yw,aa,jI="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextImagePipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",hw,Jw,fw,pa,ww,oa,jw,da,UI='<strong>Kind</strong>: instance method of <a href="#module_pipelines.DocumentQuestionAnsweringPipeline"><code>DocumentQuestionAnsweringPipeline</code></a>',Uw,bw,xw,ca,gw,ra,Cw,ma,bI=`Text-to-audio generation pipeline using any <code>AutoModelForTextToWaveform</code> or <code>AutoModelForTextToSpectrogram</code>.
This pipeline generates an audio file from an input text and optional other conditional inputs.`,Iw,ua,xI="<strong>Example:</strong> Generate audio from text with <code>Xenova/speecht5_tts</code>.",kw,Ma,Aw,Ta,gI="You can then save the audio to a .wav file with the <code>wavefile</code> package:",Pw,ya,_w,ha,CI='<strong>Example:</strong> Multilingual speech generation with <code>Xenova/mms-tts-fra</code>. See <a href="https://huggingface.co/models?pipeline_tag=text-to-speech&amp;other=vits&amp;sort=trending" rel="nofollow">here</a> for the full list of available languages (1107).',$w,Ja,vw,fa,II='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Qw,wa,kI='<li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call()</code></a> : <code>TextToAudioPipelineCallback</code></li></ul></li>',Gw,Hw,Zw,ja,Bw,Ua,Ew,ba,AI="Create a new TextToAudioPipeline.",Nw,xa,PI="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>TextToAudioPipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",Yw,Rw,zw,ga,Lw,Ca,Sw,Ia,_I='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextToAudioPipeline"><code>TextToAudioPipeline</code></a>',Ww,Xw,Dw,ka,Fw,Aa,Vw,Pa,$I="Image to Image pipeline using any <code>AutoModelForImageToImage</code>. This pipeline generates an image based on a previous image input.",Ow,_a,vI="<strong>Example:</strong> Super-resolution w/ <code>Xenova/swin2SR-classical-sr-x2-64</code>",qw,$a,Kw,va,QI='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',e2,Qa,GI='<li><a href="#module_pipelines.ImageToImagePipeline">.ImageToImagePipeline</a><ul><li><a href="#new_module_pipelines.ImageToImagePipeline_new"><code>new ImageToImagePipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToImagePipeline+_call"><code>._call()</code></a> : <code>ImageToImagePipelineCallback</code></li></ul></li>',t2,l2,i2,Ga,n2,Ha,s2,Za,HI="Create a new ImageToImagePipeline.",a2,Ba,ZI="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>ImagePipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",p2,o2,d2,Ea,c2,Na,r2,Ya,BI='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageToImagePipeline"><code>ImageToImagePipeline</code></a>',m2,u2,M2,Ra,T2,za,y2,La,EI="Depth estimation pipeline using any <code>AutoModelForDepthEstimation</code>. This pipeline predicts the depth of an image.",h2,Sa,NI="<strong>Example:</strong> Depth estimation w/ <code>Xenova/dpt-hybrid-midas</code>",J2,Wa,f2,Xa,YI='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',w2,Da,RI='<li><a href="#module_pipelines.DepthEstimationPipeline">.DepthEstimationPipeline</a><ul><li><a href="#new_module_pipelines.DepthEstimationPipeline_new"><code>new DepthEstimationPipeline(options)</code></a></li> <li><a href="#module_pipelines.DepthEstimationPipeline+_call"><code>._call()</code></a> : <code>DepthEstimationPipelineCallback</code></li></ul></li>',j2,U2,b2,Fa,x2,Va,g2,Oa,zI="Create a new DepthEstimationPipeline.",C2,qa,LI="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>ImagePipelineConstructorArgs</code></td><td><p>An object used to instantiate the pipeline.</p></td></tr></tbody>",I2,k2,A2,Ka,P2,ep,_2,tp,SI='<strong>Kind</strong>: instance method of <a href="#module_pipelines.DepthEstimationPipeline"><code>DepthEstimationPipeline</code></a>',$2,v2,Q2,lp,G2,ip,H2,np,WI="Utility factory method to build a <code>Pipeline</code> object.",Z2,sp,XI='<strong>Kind</strong>: static method of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>*</code> - A Pipeline object for the specified task.<br/> <strong>Throws</strong>:',B2,ap,DI="<li><code>Error</code> If an unsupported pipeline is requested.</li>",E2,pp,FI="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>task</td><td><code>T</code></td><td></td><td><p>The task defining which pipeline will be returned. Currently accepted tasks are:</p> <ul><li><code>&quot;audio-classification&quot;</code>: will return a <code>AudioClassificationPipeline</code>.</li> <li><code>&quot;automatic-speech-recognition&quot;</code>: will return a <code>AutomaticSpeechRecognitionPipeline</code>.</li> <li><code>&quot;depth-estimation&quot;</code>: will return a <code>DepthEstimationPipeline</code>.</li> <li><code>&quot;document-question-answering&quot;</code>: will return a <code>DocumentQuestionAnsweringPipeline</code>.</li> <li><code>&quot;feature-extraction&quot;</code>: will return a <code>FeatureExtractionPipeline</code>.</li> <li><code>&quot;fill-mask&quot;</code>: will return a <code>FillMaskPipeline</code>.</li> <li><code>&quot;image-classification&quot;</code>: will return a <code>ImageClassificationPipeline</code>.</li> <li><code>&quot;image-segmentation&quot;</code>: will return a <code>ImageSegmentationPipeline</code>.</li> <li><code>&quot;image-to-text&quot;</code>: will return a <code>ImageToTextPipeline</code>.</li> <li><code>&quot;object-detection&quot;</code>: will return a <code>ObjectDetectionPipeline</code>.</li> <li><code>&quot;question-answering&quot;</code>: will return a <code>QuestionAnsweringPipeline</code>.</li> <li><code>&quot;summarization&quot;</code>: will return a <code>SummarizationPipeline</code>.</li> <li><code>&quot;text2text-generation&quot;</code>: will return a <code>Text2TextGenerationPipeline</code>.</li> <li><code>&quot;text-classification&quot;</code> (alias &quot;sentiment-analysis&quot; available): will return a <code>TextClassificationPipeline</code>.</li> <li><code>&quot;text-generation&quot;</code>: will return a <code>TextGenerationPipeline</code>.</li> <li><code>&quot;token-classification&quot;</code> (alias &quot;ner&quot; available): will return a <code>TokenClassificationPipeline</code>.</li> <li><code>&quot;translation&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;translation_xx_to_yy&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;zero-shot-classification&quot;</code>: will return a <code>ZeroShotClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-audio-classification&quot;</code>: will return a <code>ZeroShotAudioClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-image-classification&quot;</code>: will return a <code>ZeroShotImageClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-object-detection&quot;</code>: will return a <code>ZeroShotObjectDetectionPipeline</code>.</li></ul></td> </tr><tr><td>[model]</td><td><code>string</code></td><td><code>null</code></td><td><p>The name of the pre-trained model to use. If not specified, the default model for the task will be used.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td></td><td><p>Optional parameters for the pipeline.</p></td></tr></tbody>",N2,Y2,R2,op,z2,dp,L2,cp,VI='<strong>Kind</strong>: inner property of <a href="#module_pipelines"><code>pipelines</code></a>',S2,W2,X2,rp,D2,mp,F2,up,OI='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',V2,O2,q2,Mp,K2,Tp,ej,yp,qI='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',tj,lj,ij,hp,nj,Jp,sj,fp,KI='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',aj,wp,e3="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>xmin</td><td><code>number</code></td><td><p>The minimum x coordinate of the bounding box.</p></td> </tr><tr><td>ymin</td><td><code>number</code></td><td><p>The minimum y coordinate of the bounding box.</p></td> </tr><tr><td>xmax</td><td><code>number</code></td><td><p>The maximum x coordinate of the bounding box.</p></td> </tr><tr><td>ymax</td><td><code>number</code></td><td><p>The maximum y coordinate of the bounding box.</p></td></tr></tbody>",pj,oj,dj,jp,cj,Up,rj,bp,t3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;void&gt;</code> - A promise that resolves when the item has been disposed.<br/> <strong>Properties</strong>',mj,xp,l3="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>dispose</td><td><code>DisposeType</code></td><td><p>A promise that resolves when the pipeline has been disposed.</p></td></tr></tbody>",uj,Mj,Tj,gp,yj,Cp,hj,Ip,i3="An object used to instantiate a text-based pipeline.",Jj,kp,n3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',fj,Ap,s3="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>task</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>model</td><td><code>PreTrainedModel</code></td><td><p>The model used by the pipeline.</p></td> </tr><tr><td>tokenizer</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer used by the pipeline.</p></td></tr></tbody>",wj,jj,Uj,Pp,bj,_p,xj,$p,a3="An object used to instantiate an audio-based pipeline.",gj,vp,p3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',Cj,Qp,o3="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>task</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>model</td><td><code>PreTrainedModel</code></td><td><p>The model used by the pipeline.</p></td> </tr><tr><td>processor</td><td><code>Processor</code></td><td><p>The processor used by the pipeline.</p></td></tr></tbody>",Ij,kj,Aj,Gp,Pj,Hp,_j,Zp,d3="An object used to instantiate a text- and audio-based pipeline.",$j,Bp,c3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',vj,Ep,r3="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>task</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>model</td><td><code>PreTrainedModel</code></td><td><p>The model used by the pipeline.</p></td> </tr><tr><td>tokenizer</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer used by the pipeline.</p></td> </tr><tr><td>processor</td><td><code>Processor</code></td><td><p>The processor used by the pipeline.</p></td></tr></tbody>",Qj,Gj,Hj,Np,Zj,Yp,Bj,Rp,m3="Parameters specific to text classification pipelines.",Ej,zp,u3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(TextClassificationOutput|Array&lt;TextClassificationOutput&gt;)&gt;</code> - An array or object containing the predicted labels and scores.',Nj,Lp,M3="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>The input text(s) to be classified.</p></td> </tr><tr><td>[options]</td><td><code>TextClassificationPipelineOptions</code></td><td><p>The options to use for text classification.</p></td></tr></tbody>",Yj,Sp,T3="<strong>Properties</strong>",Rj,Wp,y3="<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>label</td><td><code>string</code></td><td></td><td><p>The label predicted.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td></td><td><p>The corresponding probability.</p></td> </tr><tr><td>[topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",zj,Lj,Sj,Xp,Wj,Dp,Xj,Fp,h3="Parameters specific to token classification pipelines.",Dj,Vp,J3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(TokenClassificationOutput|Array&lt;TokenClassificationOutput&gt;)&gt;</code> - The result.',Fj,Op,f3="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>One or several texts (or one list of texts) for token classification.</p></td> </tr><tr><td>[options]</td><td><code>TokenClassificationPipelineOptions</code></td><td><p>The options to use for token classification.</p></td></tr></tbody>",Vj,qp,w3="<strong>Properties</strong>",Oj,Kp,j3="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>word</td><td><code>string</code></td><td><p>The token/word classified. This is obtained by decoding the selected tokens.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The corresponding probability for <code>entity</code>.</p></td> </tr><tr><td>entity</td><td><code>string</code></td><td><p>The entity predicted for that token/word.</p></td> </tr><tr><td>index</td><td><code>number</code></td><td><p>The index of the corresponding token in the sentence.</p></td> </tr><tr><td>[start]</td><td><code>number</code></td><td><p>The index of the start of the corresponding entity in the sentence.</p></td> </tr><tr><td>[end]</td><td><code>number</code></td><td><p>The index of the end of the corresponding entity in the sentence.</p></td> </tr><tr><td>[ignore_labels]</td><td><code>Array.&lt;string&gt;</code></td><td><p>A list of labels to ignore.</p></td></tr></tbody>",qj,Kj,eU,eo,tU,to,lU,lo,U3="Parameters specific to question answering pipelines.",iU,io,b3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(QuestionAnsweringOutput|Array&lt;QuestionAnsweringOutput&gt;)&gt;</code> - An array or object containing the predicted answers and scores.',nU,no,x3="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>question</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>One or several question(s) (must be used in conjunction with the <code>context</code> argument).</p></td> </tr><tr><td>context</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>One or several context(s) associated with the question(s) (must be used in conjunction with the <code>question</code> argument).</p></td> </tr><tr><td>[options]</td><td><code>QuestionAnsweringPipelineOptions</code></td><td><p>The options to use for question answering.</p></td></tr></tbody>",sU,so,g3="<strong>Properties</strong>",aU,ao,C3="<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>score</td><td><code>number</code></td><td></td><td><p>The probability associated to the answer.</p></td> </tr><tr><td>[start]</td><td><code>number</code></td><td></td><td><p>The character start index of the answer (in the tokenized version of the input).</p></td> </tr><tr><td>[end]</td><td><code>number</code></td><td></td><td><p>The character end index of the answer (in the tokenized version of the input).</p></td> </tr><tr><td>answer</td><td><code>string</code></td><td></td><td><p>The answer to the question.</p></td> </tr><tr><td>[topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top answer predictions to be returned.</p></td></tr></tbody>",pU,oU,dU,po,cU,oo,rU,co,I3="Parameters specific to fill mask pipelines.",mU,ro,k3=`<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FillMaskOutput|Array&lt;FillMaskOutput&gt;)&gt;</code> - An array of objects containing the score, predicted token, predicted token string,
and the sequence with the predicted token filled in, or an array of such arrays (one for each input text).
If only one input text is given, the output will be an array of objects.<br/> <strong>Throws</strong>:`,uU,mo,A3="<li><code>Error</code> When the mask token is not found in the input text.</li>",MU,uo,P3="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>One or several texts (or one list of prompts) with masked tokens.</p></td> </tr><tr><td>[options]</td><td><code>FillMaskPipelineOptions</code></td><td><p>The options to use for masked language modelling.</p></td></tr></tbody>",TU,Mo,_3="<strong>Properties</strong>",yU,To,$3="<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>sequence</td><td><code>string</code></td><td></td><td><p>The corresponding input with the mask token prediction.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td></td><td><p>The corresponding probability.</p></td> </tr><tr><td>token</td><td><code>number</code></td><td></td><td><p>The predicted token id (to replace the masked one).</p></td> </tr><tr><td>token_str</td><td><code>string</code></td><td></td><td><p>The predicted token (to replace the masked one).</p></td> </tr><tr><td>[topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>When passed, overrides the number of predictions to return.</p></td></tr></tbody>",hU,JU,fU,yo,wU,ho,jU,Jo,v3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',UU,fo,Q3="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>Input text for the encoder.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td><p>Additional keyword arguments to pass along to the generate method of the model.</p></td></tr></tbody>",bU,wo,G3="<strong>Properties</strong>",xU,jo,H3="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>generated_text</td><td><code>string</code></td><td><p>The generated text.</p></td></tr></tbody>",gU,CU,IU,Uo,kU,bo,AU,xo,Z3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',PU,go,B3="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>One or several articles (or one list of articles) to summarize.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td><p>Additional keyword arguments to pass along to the generate method of the model.</p></td></tr></tbody>",_U,Co,E3="<strong>Properties</strong>",$U,Io,N3="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>summary_text</td><td><code>string</code></td><td><p>The summary text.</p></td></tr></tbody>",vU,QU,GU,ko,HU,Ao,ZU,Po,Y3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',BU,_o,R3="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>Texts to be translated.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td><p>Additional keyword arguments to pass along to the generate method of the model.</p></td></tr></tbody>",EU,$o,z3="<strong>Properties</strong>",NU,vo,L3="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>translation_text</td><td><code>string</code></td><td><p>The translated text.</p></td></tr></tbody>",YU,RU,zU,Qo,LU,Go,SU,Ho,S3="Parameters specific to text-generation pipelines.",WU,Zo,W3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(TextGenerationOutput|Array&lt;TextGenerationOutput&gt;)&gt;</code> - An array or object containing the generated texts.',XU,Bo,X3="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code> | <code>Chat</code> | <code>Array&lt;Chat&gt;</code></td><td><p>One or several prompts (or one list of prompts) to complete.</p></td> </tr><tr><td>[options]</td><td><code>TextGenerationConfig</code></td><td><p>Additional keyword arguments to pass along to the generate method of the model.</p></td></tr></tbody>",DU,Eo,D3="<strong>Properties</strong>",FU,No,F3="<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>generated_text</td><td><code>string</code> | <code>Chat</code></td><td></td><td><p>The generated text.</p></td> </tr><tr><td>[add_special_tokens]</td><td><code>boolean</code></td><td></td><td><p>Whether or not to add special tokens when tokenizing the sequences.</p></td> </tr><tr><td>[return_full_text]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>If set to <code>false</code> only added text is returned, otherwise the full text is returned.</p></td></tr></tbody>",VU,OU,qU,Yo,KU,Ro,eb,zo,V3="Parameters specific to zero-shot classification pipelines.",tb,Lo,O3='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(ZeroShotClassificationOutput|Array&lt;ZeroShotClassificationOutput&gt;)&gt;</code> - An array or object containing the predicted labels and scores.',lb,So,q3=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>The sequence(s) to classify, will be truncated if the model input is too large.</p></td> </tr><tr><td>candidate_labels</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>The set of possible class labels to classify each sequence into.
Can be a single label, a string of comma-separated labels, or a list of labels.</p></td> </tr><tr><td>[options]</td><td><code>ZeroShotClassificationPipelineOptions</code></td><td><p>The options to use for zero-shot classification.</p></td></tr></tbody>`,ib,Wo,K3="<strong>Properties</strong>",nb,Xo,ek=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>sequence</td><td><code>string</code></td><td></td><td><p>The sequence for which this is the output.</p></td> </tr><tr><td>labels</td><td><code>Array.&lt;string&gt;</code></td><td></td><td><p>The labels sorted by order of likelihood.</p></td> </tr><tr><td>scores</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The probabilities for each of the labels.</p></td> </tr><tr><td>[hypothesis_template]</td><td><code>string</code></td><td><code>&quot;&quot;This example is {}.&quot;&quot;</code></td><td><p>The template used to turn each
candidate label into an NLI-style hypothesis. The candidate label will replace the &amp;#123;} placeholder.</p></td> </tr><tr><td>[multi_label]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not multiple candidate labels can be true.
If <code>false</code>, the scores are normalized such that the sum of the label likelihoods for each sequence
is 1. If <code>true</code>, the labels are considered independent and probabilities are normalized for each
candidate by doing a softmax of the entailment score vs. the contradiction score.</p></td></tr></tbody>`,sb,ab,pb,Do,ob,Fo,db,Vo,tk="Parameters specific to feature extraction pipelines.",cb,Oo,lk='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The features computed by the model.',rb,qo,ik="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>One or several texts (or one list of texts) to get the features of.</p></td> </tr><tr><td>[options]</td><td><code>FeatureExtractionPipelineOptions</code></td><td><p>The options to use for feature extraction.</p></td></tr></tbody>",mb,Ko,nk="<strong>Properties</strong>",ub,ed,sk="<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[pooling]</td><td><code>&#39;none&#39;</code> | <code>&#39;mean&#39;</code> | <code>&#39;cls&#39;</code></td><td><code>&quot;none&quot;</code></td><td><p>The pooling method to use.</p></td> </tr><tr><td>[normalize]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to normalize the embeddings in the last dimension.</p></td> </tr><tr><td>[quantize]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to quantize the embeddings.</p></td> </tr><tr><td>[precision]</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><code>&#39;binary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>",Mb,Tb,yb,td,hb,ld,Jb,id,ak="Parameters specific to image feature extraction pipelines.",fb,nd,pk='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The image features computed by the model.',wb,sd,ok="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>ImagePipelineInputs</code></td><td><p>One or several images (or one list of images) to get the features of.</p></td> </tr><tr><td>[options]</td><td><code>ImageFeatureExtractionPipelineOptions</code></td><td><p>The options to use for image feature extraction.</p></td></tr></tbody>",jb,ad,dk="<strong>Properties</strong>",Ub,pd,ck="<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[pool]</td><td><code>boolean</code></td><td><code></code></td><td><p>Whether or not to return the pooled output. If set to <code>false</code>, the model will return the raw hidden states.</p></td></tr></tbody>",bb,xb,gb,od,Cb,dd,Ib,cd,rk="Parameters specific to audio classification pipelines.",kb,rd,mk='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(AudioClassificationOutput|Array&lt;AudioClassificationOutput&gt;)&gt;</code> - An array or object containing the predicted labels and scores.',Ab,md,uk=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>AudioPipelineInputs</code></td><td><p>The input audio file(s) to be classified. The input is either:</p> <ul><li><code>string</code> or <code>URL</code> that is the filename/URL of the audio file, the file will be read at the processor&#39;s sampling rate
to get the waveform using the <a href="https://developer.mozilla.org/en-US/docs/Web/API/AudioContext"><code>AudioContext</code></a> API.
If <code>AudioContext</code> is not available, you should pass the raw waveform in as a Float32Array of shape <code>(n, )</code>.</li> <li><code>Float32Array</code> or <code>Float64Array</code> of shape <code>(n, )</code>, representing the raw audio at the correct sampling rate (no further check will be done).</li></ul></td> </tr><tr><td>[options]</td><td><code>AudioClassificationPipelineOptions</code></td><td><p>The options to use for audio classification.</p></td></tr></tbody>`,Pb,ud,Mk="<strong>Properties</strong>",_b,Md,Tk=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>label</td><td><code>string</code></td><td></td><td><p>The label predicted.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td></td><td><p>The corresponding probability.</p></td> </tr><tr><td>[topk]</td><td><code>number</code></td><td><code></code></td><td><p>The number of top labels that will be returned by the pipeline.
If the provided number is <code>null</code> or higher than the number of labels available in the model configuration,
it will default to the number of labels.</p></td></tr></tbody>`,$b,vb,Qb,Td,Gb,yd,Hb,hd,yk="Parameters specific to zero-shot audio classification pipelines.",Zb,Jd,hk='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;ZeroShotAudioClassificationOutput&gt;|Array&lt;Array&lt;ZeroShotAudioClassificationOutput&gt;&gt;)&gt;</code> - An array of objects containing the predicted labels and scores.',Bb,fd,Jk=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>AudioPipelineInputs</code></td><td><p>The input audio file(s) to be classified. The input is either:</p> <ul><li><code>string</code> or <code>URL</code> that is the filename/URL of the audio file, the file will be read at the processor&#39;s sampling rate
to get the waveform using the <a href="https://developer.mozilla.org/en-US/docs/Web/API/AudioContext"><code>AudioContext</code></a> API.
If <code>AudioContext</code> is not available, you should pass the raw waveform in as a Float32Array of shape <code>(n, )</code>.</li> <li><code>Float32Array</code> or <code>Float64Array</code> of shape <code>(n, )</code>, representing the raw audio at the correct sampling rate (no further check will be done).</li></ul></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td><p>The candidate labels for this audio.</p></td> </tr><tr><td>[options]</td><td><code>ZeroShotAudioClassificationPipelineOptions</code></td><td><p>The options to use for zero-shot audio classification.</p></td></tr></tbody>`,Eb,wd,fk="<strong>Properties</strong>",Nb,jd,wk=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>label</td><td><code>string</code></td><td></td><td><p>The label identified by the model. It is one of the suggested <code>candidate_label</code>.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td></td><td><p>The score attributed by the model for that label (between 0 and 1).</p></td> </tr><tr><td>[hypothesis_template]</td><td><code>string</code></td><td><code>&quot;&quot;This is a sound of {}.&quot;&quot;</code></td><td><p>The sentence used in conjunction with <code>candidate_labels</code>
to attempt the audio classification by replacing the placeholder with the candidate_labels.
Then likelihood is estimated by using <code>logits_per_audio</code>.</p></td></tr></tbody>`,Yb,Rb,zb,Ud,Lb,bd,Sb,xd,jk='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',Wb,gd,Uk="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>chunk</td><td><code>ChunkCallbackItem</code></td><td><p>The chunk to process.</p></td></tr></tbody>",Xb,Db,Fb,Cd,Vb,Id,Ob,kd,bk='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',qb,Ad,xk="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>timestamp</td><td><code>*</code></td><td><p>The start and end timestamp of the chunk in seconds.</p></td> </tr><tr><td>text</td><td><code>string</code></td><td><p>The recognized text.</p></td></tr></tbody>",Kb,ex,tx,Pd,lx,_d,ix,$d,gk="Parameters specific to automatic-speech-recognition pipelines.",nx,vd,Ck='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(AutomaticSpeechRecognitionOutput|Array&lt;AutomaticSpeechRecognitionOutput&gt;)&gt;</code> - An object containing the transcription text and optionally timestamps if <code>return_timestamps</code> is <code>true</code>.',sx,Qd,Ik=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>AudioPipelineInputs</code></td><td><p>The input audio file(s) to be transcribed. The input is either:</p> <ul><li><code>string</code> or <code>URL</code> that is the filename/URL of the audio file, the file will be read at the processor&#39;s sampling rate
to get the waveform using the <a href="https://developer.mozilla.org/en-US/docs/Web/API/AudioContext"><code>AudioContext</code></a> API.
If <code>AudioContext</code> is not available, you should pass the raw waveform in as a Float32Array of shape <code>(n, )</code>.</li> <li><code>Float32Array</code> or <code>Float64Array</code> of shape <code>(n, )</code>, representing the raw audio at the correct sampling rate (no further check will be done).</li></ul></td> </tr><tr><td>[options]</td><td><code>AutomaticSpeechRecognitionConfig</code></td><td><p>Additional keyword arguments to pass along to the generate method of the model.</p></td></tr></tbody>`,ax,Gd,kk="<strong>Properties</strong>",px,Hd,Ak=`<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The recognized text.</p></td> </tr><tr><td>[chunks]</td><td><code>Array.&lt;Chunk&gt;</code></td><td><p>When using <code>return_timestamps</code>, the <code>chunks</code> will become a list
containing all the various text chunks identified by the model.</p></td> </tr><tr><td>[kwargs.return_timestamps]</td><td><code>boolean</code> | <code>&#39;word&#39;</code></td><td><p>Whether to return timestamps or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.chunk_length_s]</td><td><code>number</code></td><td><p>The length of audio chunks to process in seconds. Default is 0 (no chunking).</p></td> </tr><tr><td>[kwargs.stride_length_s]</td><td><code>number</code></td><td><p>The length of overlap between consecutive audio chunks in seconds. If not provided, defaults to <code>chunk_length_s / 6</code>.</p></td> </tr><tr><td>[kwargs.chunk_callback]</td><td><code>ChunkCallback</code></td><td><p>Callback function to be called with each chunk processed.</p></td> </tr><tr><td>[kwargs.force_full_sequences]</td><td><code>boolean</code></td><td><p>Whether to force outputting full sequences or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.language]</td><td><code>string</code></td><td><p>The source language. Default is <code>null</code>, meaning it should be auto-detected. Use this to potentially improve performance if the source language is known.</p></td> </tr><tr><td>[kwargs.task]</td><td><code>string</code></td><td><p>The task to perform. Default is <code>null</code>, meaning it should be auto-detected.</p></td> </tr><tr><td>[kwargs.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><p>A list of pairs of integers which indicates a mapping from generation indices to token indices
that will be forced before sampling. For example, [[1, 123]] means the second generated token will always be a token of index 123.</p></td> </tr><tr><td>[num_frames]</td><td><code>number</code></td><td><p>The number of frames in the input audio.</p></td></tr></tbody>`,ox,dx,cx,Zd,rx,Bd,mx,Ed,Pk='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(ImageToTextOutput|Array&lt;ImageToTextOutput&gt;)&gt;</code> - An object (or array of objects) containing the generated text(s).',ux,Nd,_k="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>ImagePipelineInputs</code></td><td><p>The images to be captioned.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td><p>Additional keyword arguments to pass along to the generate method of the model.</p></td></tr></tbody>",Mx,Yd,$k="<strong>Properties</strong>",Tx,Rd,vk="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>generated_text</td><td><code>string</code></td><td><p>The generated text.</p></td></tr></tbody>",yx,hx,Jx,zd,fx,Ld,wx,Sd,Qk="Parameters specific to image classification pipelines.",jx,Wd,Gk='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(ImageClassificationOutput|Array&lt;ImageClassificationOutput&gt;)&gt;</code> - An array or object containing the predicted labels and scores.',Ux,Xd,Hk="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>ImagePipelineInputs</code></td><td><p>The input images(s) to be classified.</p></td> </tr><tr><td>[options]</td><td><code>ImageClassificationPipelineOptions</code></td><td><p>The options to use for image classification.</p></td></tr></tbody>",bx,Dd,Zk="<strong>Properties</strong>",xx,Fd,Bk="<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>label</td><td><code>string</code></td><td></td><td><p>The label identified by the model.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td></td><td><p>The score attributed by the model for that label.</p></td> </tr><tr><td>[topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top labels that will be returned by the pipeline.</p></td></tr></tbody>",gx,Cx,Ix,Vd,kx,Od,Ax,qd,Ek="Parameters specific to image segmentation pipelines.",Px,Kd,Nk='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Array&lt;ImageSegmentationPipelineOutput&gt;&gt;</code> - The annotated segments.',_x,ec,Yk="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>ImagePipelineInputs</code></td><td><p>The input images.</p></td> </tr><tr><td>[options]</td><td><code>ImageSegmentationPipelineOptions</code></td><td><p>The options to use for image segmentation.</p></td></tr></tbody>",$x,tc,Rk="<strong>Properties</strong>",vx,lc,zk=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>label</td><td><code>string</code></td><td></td><td><p>The label of the segment.</p></td> </tr><tr><td>score</td><td><code>number</code> | <code>null</code></td><td></td><td><p>The score of the segment.</p></td> </tr><tr><td>mask</td><td><code>RawImage</code></td><td></td><td><p>The mask of the segment.</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Probability threshold to filter out predicted masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>Mask overlap threshold to eliminate small, disconnected segments.</p></td> </tr><tr><td>[subtask]</td><td><code>null</code> | <code>string</code></td><td><code></code></td><td><p>Segmentation task to be performed. One of [<code>panoptic</code>, <code>instance</code>, and <code>semantic</code>],
depending on model capabilities. If not set, the pipeline will attempt to resolve (in that order).</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>List of label ids to fuse. If not set, do not fuse any labels.</p></td> </tr><tr><td>[target_sizes]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>List of target sizes for the input images. If not set, use the original image sizes.</p></td></tr></tbody>`,Qx,Gx,Hx,ic,Zx,nc,Bx,sc,Lk="Parameters specific to zero-shot image classification pipelines.",Ex,ac,Sk='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;ZeroShotImageClassificationOutput&gt;|Array&lt;Array&lt;ZeroShotImageClassificationOutput&gt;&gt;)&gt;</code> - An array of objects containing the predicted labels and scores.',Nx,pc,Wk="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>ImagePipelineInputs</code></td><td><p>The input images.</p></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td><p>The candidate labels for this image.</p></td> </tr><tr><td>[options]</td><td><code>ZeroShotImageClassificationPipelineOptions</code></td><td><p>The options to use for zero-shot image classification.</p></td></tr></tbody>",Yx,oc,Xk="<strong>Properties</strong>",Rx,dc,Dk=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>label</td><td><code>string</code></td><td></td><td><p>The label identified by the model. It is one of the suggested <code>candidate_label</code>.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td></td><td><p>The score attributed by the model for that label (between 0 and 1).</p></td> </tr><tr><td>[hypothesis_template]</td><td><code>string</code></td><td><code>&quot;&quot;This is a photo of {}&quot;&quot;</code></td><td><p>The sentence used in conjunction with <code>candidate_labels</code>
to attempt the image classification by replacing the placeholder with the candidate_labels.
Then likelihood is estimated by using <code>logits_per_image</code>.</p></td></tr></tbody>`,zx,Lx,Sx,cc,Wx,rc,Xx,mc,Fk="Parameters specific to object detection pipelines.",Dx,uc,Vk='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(ObjectDetectionPipelineOutput|Array&lt;ObjectDetectionPipelineOutput&gt;)&gt;</code> - A list of objects or a list of list of objects.',Fx,Mc,Ok="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>ImagePipelineInputs</code></td><td><p>The input images.</p></td> </tr><tr><td>[options]</td><td><code>ObjectDetectionPipelineOptions</code></td><td><p>The options to use for object detection.</p></td></tr></tbody>",Vx,Tc,qk="<strong>Properties</strong>",Ox,yc,Kk="<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>label</td><td><code>string</code></td><td></td><td><p>The class label identified by the model.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td></td><td><p>The score attributed by the model for that label.</p></td> </tr><tr><td>box</td><td><code>BoundingBox</code></td><td></td><td><p>The bounding box of detected object in image&#39;s original size, or as a percentage if <code>percentage</code> is set to true.</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.9</code></td><td><p>The threshold used to filter boxes by score.</p></td> </tr><tr><td>[percentage]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the boxes coordinates in percentage (true) or in pixels (false).</p></td></tr></tbody>",qx,Kx,e1,hc,t1,Jc,l1,fc,eA="Parameters specific to zero-shot object detection pipelines.",i1,wc,tA='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;ZeroShotObjectDetectionOutput&gt;|Array&lt;Array&lt;ZeroShotObjectDetectionOutput&gt;&gt;)&gt;</code> - An array of objects containing the predicted labels, scores, and bounding boxes.',n1,jc,lA="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>ImagePipelineInputs</code></td><td><p>The input images.</p></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td><p>What the model should recognize in the image.</p></td> </tr><tr><td>[options]</td><td><code>ZeroShotObjectDetectionPipelineOptions</code></td><td><p>The options to use for zero-shot object detection.</p></td></tr></tbody>",s1,Uc,iA="<strong>Properties</strong>",a1,bc,nA=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>label</td><td><code>string</code></td><td></td><td><p>Text query corresponding to the found object.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td></td><td><p>Score corresponding to the object (between 0 and 1).</p></td> </tr><tr><td>box</td><td><code>BoundingBox</code></td><td></td><td><p>Bounding box of the detected object in image&#39;s original size, or as a percentage if <code>percentage</code> is set to true.</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.1</code></td><td><p>The probability necessary to make a prediction.</p></td> </tr><tr><td>[topk]</td><td><code>number</code></td><td><code></code></td><td><p>The number of top predictions that will be returned by the pipeline.
If the provided number is <code>null</code> or higher than the number of predictions available, it will default
to the number of predictions.</p></td> </tr><tr><td>[percentage]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the boxes coordinates in percentage (true) or in pixels (false).</p></td></tr></tbody>`,p1,o1,d1,xc,c1,gc,r1,Cc,sA='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(DocumentQuestionAnsweringOutput|Array&lt;DocumentQuestionAnsweringOutput&gt;)&gt;</code> - An object (or array of objects) containing the answer(s).',m1,Ic,aA="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>ImageInput</code></td><td><p>The image of the document to use.</p></td> </tr><tr><td>question</td><td><code>string</code></td><td><p>A question to ask of the document.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td><p>Additional keyword arguments to pass along to the generate method of the model.</p></td></tr></tbody>",u1,kc,pA="<strong>Properties</strong>",M1,Ac,oA="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>answer</td><td><code>string</code></td><td><p>The generated text.</p></td></tr></tbody>",T1,y1,h1,Pc,J1,_c,f1,$c,dA='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',w1,vc,cA="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>[vocoder]</td><td><code>PreTrainedModel</code></td><td><p>The vocoder used by the pipeline (if the model uses one). If not provided, use the default HifiGan vocoder.</p></td></tr></tbody>",j1,U1,b1,Qc,x1,Gc,g1,Hc,rA="Parameters specific to text-to-audio pipelines.",C1,Zc,mA='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;TextToAudioOutput&gt;</code> - An object containing the generated audio and sampling rate.',I1,Bc,uA="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td><p>The text(s) to generate.</p></td> </tr><tr><td>options</td><td><code>TextToAudioPipelineOptions</code></td><td><p>Parameters passed to the model generation/forward method.</p></td></tr></tbody>",k1,Ec,MA="<strong>Properties</strong>",A1,Nc,TA="<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>Float32Array</code></td><td></td><td><p>The generated audio waveform.</p></td> </tr><tr><td>sampling_rate</td><td><code>number</code></td><td></td><td><p>The sampling rate of the generated audio waveform.</p></td> </tr><tr><td>[speaker_embeddings]</td><td><code>Tensor</code> | <code>Float32Array</code> | <code>string</code> | <code>URL</code></td><td><code></code></td><td><p>The speaker embeddings (if the model requires it).</p></td></tr></tbody>",P1,_1,$1,Yc,v1,Rc,Q1,zc,yA='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(RawImage|Array&lt;RawImage&gt;)&gt;</code> - The transformed image or list of images.',G1,Lc,hA="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>ImagePipelineInputs</code></td><td><p>The images to transform.</p></td></tr></tbody>",H1,Z1,B1,Sc,E1,Wc,N1,Xc,JA='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(DepthEstimationPipelineOutput|Array&lt;DepthEstimationPipelineOutput&gt;)&gt;</code> - An image or a list of images containing result(s).',Y1,Dc,fA="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>ImagePipelineInputs</code></td><td><p>The images to compute depth for.</p></td></tr></tbody>",R1,Fc,wA="<strong>Properties</strong>",z1,Vc,jA="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>predicted_depth</td><td><code>Tensor</code></td><td><p>The raw depth map predicted by the model.</p></td> </tr><tr><td>depth</td><td><code>RawImage</code></td><td><p>The processed depth map as an image (with the same size as the input image).</p></td></tr></tbody>",L1,S1,W1,Oc,X1,qc,D1,Kc,UA="All possible pipeline types.",F1,er,bA='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',V1,O1,q1,lr,K1;return j=new h({props:{title:"pipelines",local:"pipelines",headingTag:"h1"}}),x=new J({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFjb25zdCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdzZW50aW1lbnQtYW5hbHlzaXMnKSUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKCdJJTIwbG92ZSUyMHRyYW5zZm9ybWVycyEnKSUzQiUwQSUyRiUyRiUyMCU1QiU3QidsYWJlbCclM0ElMjAnUE9TSVRJVkUnJTJDJTIwJ3Njb3JlJyUzQSUyMDAuOTk5ODE3Njg2JTdEJTVE",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.999817686}]</span>`,wrap:!1}}),I=new h({props:{title:"pipelines.Pipeline ⇐ <code> Callable </code>",local:"pipelinespipeline--code-callable-code",headingTag:"h2"}}),$=new h({props:{title:"new Pipeline(options)",local:"new-pipelineoptions",headingTag:"h3"}}),H=new h({props:{title:"pipeline.dispose() : <code> DisposeType </code>",local:"pipelinedispose--code-disposetype-code",headingTag:"h3"}}),E=new h({props:{title:"pipelines.TextClassificationPipeline",local:"pipelinestextclassificationpipeline",headingTag:"h2"}}),R=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnc2VudGltZW50LWFuYWx5c2lzJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCcpJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzIScpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwbGFiZWwlM0ElMjAnUE9TSVRJVkUnJTJDJTIwc2NvcmUlM0ElMjAwLjk5OTc4ODc2MTEzODkxNiUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{ label: &#x27;POSITIVE&#x27;, score: 0.999788761138916 }]</span>`,wrap:!1}}),L=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnc2VudGltZW50LWFuYWx5c2lzJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtbXVsdGlsaW5ndWFsLXVuY2FzZWQtc2VudGltZW50JyklM0IlMEFjb25zdCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignTGUlMjBtZWlsbGV1ciUyMGZpbG0lMjBkZSUyMHRvdXMlMjBsZXMlMjB0ZW1wcy4nJTJDJTIwJTdCJTIwdG9wayUzQSUyMDUlMjAlN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnNSUyMHN0YXJzJyUyQyUyMHNjb3JlJTNBJTIwMC45NjEwNzU5NjE1ODk4MTMyJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnNCUyMHN0YXJzJyUyQyUyMHNjb3JlJTNBJTIwMC4wMzMyMzM1MTU5MTgyNTQ4NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJzMlMjBzdGFycyclMkMlMjBzY29yZSUzQSUyMDAuMDAzNjE1NTE4MTAwNTU5NzExNSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJzElMjBzdGFyJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDExMzI1OTY3NDk4MTIzNjQ2JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMiUyMHN0YXJzJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA5NDIzOTcxMDU5NzMyMTM5JTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-multilingual-uncased-sentiment&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Le meilleur film de tous les temps.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;5 stars&#x27;, score: 0.9610759615898132 },</span>
<span class="hljs-comment">//   { label: &#x27;4 stars&#x27;, score: 0.03323351591825485 },</span>
<span class="hljs-comment">//   { label: &#x27;3 stars&#x27;, score: 0.0036155181005597115 },</span>
<span class="hljs-comment">//   { label: &#x27;1 star&#x27;, score: 0.0011325967498123646 },</span>
<span class="hljs-comment">//   { label: &#x27;2 stars&#x27;, score: 0.0009423971059732139 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),W=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGdG94aWMtYmVydCcpJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ0klMjBoYXRlJTIweW91ISclMkMlMjAlN0IlMjB0b3BrJTNBJTIwbnVsbCUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCd0b3hpYyclMkMlMjBzY29yZSUzQSUyMDAuOTU5MzE0MDQ4MjkwMjUyNyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ2luc3VsdCclMkMlMjBzY29yZSUzQSUyMDAuMTYxODczMzQwNjA2Njg5NDUlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCdvYnNjZW5lJyUyQyUyMHNjb3JlJTNBJTIwMC4wMzQ1MjY4MDYzMjQ3MjAzOCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ2lkZW50aXR5X2hhdGUnJTJDJTIwc2NvcmUlM0ElMjAwLjAyMjMyNTA1NzUzNjM2MzYlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCd0aHJlYXQnJTJDJTIwc2NvcmUlM0ElMjAwLjAxOTE5NzA0MTE2ODgwODkzNyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3NldmVyZV90b3hpYyclMkMlMjBzY29yZSUzQSUyMDAuMDA1NjUxMDk5NjA3MzQ4NDQyJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/toxic-bert&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I hate you!&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-literal">null</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;toxic&#x27;, score: 0.9593140482902527 },</span>
<span class="hljs-comment">//   { label: &#x27;insult&#x27;, score: 0.16187334060668945 },</span>
<span class="hljs-comment">//   { label: &#x27;obscene&#x27;, score: 0.03452680632472038 },</span>
<span class="hljs-comment">//   { label: &#x27;identity_hate&#x27;, score: 0.0223250575363636 },</span>
<span class="hljs-comment">//   { label: &#x27;threat&#x27;, score: 0.019197041168808937 },</span>
<span class="hljs-comment">//   { label: &#x27;severe_toxic&#x27;, score: 0.005651099607348442 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),V=new h({props:{title:"new TextClassificationPipeline(options)",local:"new-textclassificationpipelineoptions",headingTag:"h3"}}),ee=new h({props:{title:"textClassificationPipeline._call() : <code> TextClassificationPipelineCallback </code>",local:"textclassificationpipelinecall--code-textclassificationpipelinecallback-code",headingTag:"h3"}}),ie=new h({props:{title:"pipelines.TokenClassificationPipeline",local:"pipelinestokenclassificationpipeline",headingTag:"h2"}}),ae=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndG9rZW4tY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1ORVInKSUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKCdNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMExvbmRvbicpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ0ItUEVSJyUyQyUyMHNjb3JlJTNBJTIwMC45OTgwMjAyOTEzMjg0MzAyJTJDJTIwaW5kZXglM0ElMjA0JTJDJTIwd29yZCUzQSUyMCdTYXJhaCclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnQi1MT0MnJTJDJTIwc2NvcmUlM0ElMjAwLjk5OTQ0NzQwNTMzODI4NzQlMkMlMjBpbmRleCUzQSUyMDklMkMlMjB3b3JkJTNBJTIwJ0xvbmRvbiclMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;My name is Sarah and I live in London&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9980202913284302, index: 4, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9994474053382874, index: 9, word: &#x27;London&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),oe=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndG9rZW4tY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1ORVInKSUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKCdTYXJhaCUyMGxpdmVzJTIwaW4lMjB0aGUlMjBVbml0ZWQlMjBTdGF0ZXMlMjBvZiUyMEFtZXJpY2EnJTJDJTIwJTdCJTIwaWdub3JlX2xhYmVscyUzQSUyMCU1QiU1RCUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnQi1QRVInJTJDJTIwc2NvcmUlM0ElMjAwLjk5NjY1ODc0MjQyNzgyNTklMkMlMjBpbmRleCUzQSUyMDElMkMlMjB3b3JkJTNBJTIwJ1NhcmFoJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdPJyUyQyUyMHNjb3JlJTNBJTIwMC45OTg3Mzg1ODY5MDI2MTg0JTJDJTIwaW5kZXglM0ElMjAyJTJDJTIwd29yZCUzQSUyMCdsaXZlcyclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnTyclMkMlMjBzY29yZSUzQSUyMDAuOTk5MDA3Mjg0NjQxMjY1OSUyQyUyMGluZGV4JTNBJTIwMyUyQyUyMHdvcmQlM0ElMjAnaW4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ08nJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODgyOTg0MTYxMzc2OTUlMkMlMjBpbmRleCUzQSUyMDQlMkMlMjB3b3JkJTNBJTIwJ3RoZSclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnQi1MT0MnJTJDJTIwc2NvcmUlM0ElMjAwLjk5OTU1MTA1NzgxNTU1MTglMkMlMjBpbmRleCUzQSUyMDUlMkMlMjB3b3JkJTNBJTIwJ1VuaXRlZCclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnSS1MT0MnJTJDJTIwc2NvcmUlM0ElMjAwLjk5OTAzOTUzMDc1NDA4OTQlMkMlMjBpbmRleCUzQSUyMDYlMkMlMjB3b3JkJTNBJTIwJ1N0YXRlcyclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnSS1MT0MnJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODY3MjQ4NTM1MTU2MjUlMkMlMjBpbmRleCUzQSUyMDclMkMlMjB3b3JkJTNBJTIwJ29mJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk3NTI5NDQ3MDc4NzA0OCUyQyUyMGluZGV4JTNBJTIwOCUyQyUyMHdvcmQlM0ElMjAnQW1lcmljYSclMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Sarah lives in the United States of America&#x27;</span>, { <span class="hljs-attr">ignore_labels</span>: [] });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9966587424278259, index: 1, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9987385869026184, index: 2, word: &#x27;lives&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9990072846412659, index: 3, word: &#x27;in&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9988298416137695, index: 4, word: &#x27;the&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9995510578155518, index: 5, word: &#x27;United&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9990395307540894, index: 6, word: &#x27;States&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9986724853515625, index: 7, word: &#x27;of&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9975294470787048, index: 8, word: &#x27;America&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),me=new h({props:{title:"new TokenClassificationPipeline(options)",local:"new-tokenclassificationpipelineoptions",headingTag:"h3"}}),ye=new h({props:{title:"tokenClassificationPipeline._call() : <code> TokenClassificationPipelineCallback </code>",local:"tokenclassificationpipelinecall--code-tokenclassificationpipelinecallback-code",headingTag:"h3"}}),fe=new h({props:{title:"pipelines.QuestionAnsweringPipeline",local:"pipelinesquestionansweringpipeline",headingTag:"h2"}}),Ue=new J({props:{code:"Y29uc3QlMjBhbnN3ZXJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3F1ZXN0aW9uLWFuc3dlcmluZyclMkMlMjAnWGVub3ZhJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZGlzdGlsbGVkLXNxdWFkJyklM0IlMEFjb25zdCUyMHF1ZXN0aW9uJTIwJTNEJTIwJ1dobyUyMHdhcyUyMEppbSUyMEhlbnNvbiUzRiclM0IlMEFjb25zdCUyMGNvbnRleHQlMjAlM0QlMjAnSmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQuJyUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBhbnN3ZXJlcihxdWVzdGlvbiUyQyUyMGNvbnRleHQpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwYW5zd2VyJTNBJTIwJTIyYSUyMG5pY2UlMjBwdXBwZXQlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjBzY29yZSUzQSUyMDAuNTc2ODkxMTUwMjUyNjc0MSUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">const</span> answerer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-distilled-squad&#x27;</span>);
<span class="hljs-keyword">const</span> question = <span class="hljs-string">&#x27;Who was Jim Henson?&#x27;</span>;
<span class="hljs-keyword">const</span> context = <span class="hljs-string">&#x27;Jim Henson was a nice puppet.&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">answerer</span>(question, context);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   answer: &quot;a nice puppet&quot;,</span>
<span class="hljs-comment">//   score: 0.5768911502526741</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ce=new h({props:{title:"new QuestionAnsweringPipeline(options)",local:"new-questionansweringpipelineoptions",headingTag:"h3"}}),Pe=new h({props:{title:"questionAnsweringPipeline._call() : <code> QuestionAnsweringPipelineCallback </code>",local:"questionansweringpipelinecall--code-questionansweringpipelinecallback-code",headingTag:"h3"}}),ve=new h({props:{title:"pipelines.FillMaskPipeline",local:"pipelinesfillmaskpipeline",headingTag:"h2"}}),He=new J({props:{code:"Y29uc3QlMjB1bm1hc2tlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ZpbGwtbWFzayclMkMlMjAnWGVub3ZhJTJGYmVydC1iYXNlLWNhc2VkJyklM0IlMEFjb25zdCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwdW5tYXNrZXIoJ1RoZSUyMGdvYWwlMjBvZiUyMGxpZmUlMjBpcyUyMCU1Qk1BU0slNUQuJyklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjB0b2tlbl9zdHIlM0ElMjAnc3Vydml2YWwnJTJDJTIwc2NvcmUlM0ElMjAwLjA2MTM3NDE5NDkyMDA2MzAyJTJDJTIwdG9rZW4lM0ElMjA4MTE1JTJDJTIwc2VxdWVuY2UlM0ElMjAnVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwc3Vydml2YWwuJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdsb3ZlJyUyQyUyMHNjb3JlJTNBJTIwMC4wMzkwMjQ1MDIwMzg5NTU2OSUyQyUyMHRva2VuJTNBJTIwMTU2NyUyQyUyMHNlcXVlbmNlJTNBJTIwJ1RoZSUyMGdvYWwlMjBvZiUyMGxpZmUlMjBpcyUyMGxvdmUuJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdoYXBwaW5lc3MnJTJDJTIwc2NvcmUlM0ElMjAwLjAzMjUzMTgzNTEzODc5Nzc2JTJDJTIwdG9rZW4lM0ElMjA5MjY2JTJDJTIwc2VxdWVuY2UlM0ElMjAnVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwaGFwcGluZXNzLiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjB0b2tlbl9zdHIlM0ElMjAnZnJlZWRvbSclMkMlMjBzY29yZSUzQSUyMDAuMDE4NzM2MzA2NTc3OTIwOTE0JTJDJTIwdG9rZW4lM0ElMjA0NDM4JTJDJTIwc2VxdWVuY2UlM0ElMjAnVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwZnJlZWRvbS4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2xpZmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAxODU5Nzk0NzQzMzU5MDg5JTJDJTIwdG9rZW4lM0ElMjAxMjk3JTJDJTIwc2VxdWVuY2UlM0ElMjAnVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwbGlmZS4nJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">const</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The goal of life is [MASK].&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { token_str: &#x27;survival&#x27;, score: 0.06137419492006302, token: 8115, sequence: &#x27;The goal of life is survival.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;love&#x27;, score: 0.03902450203895569, token: 1567, sequence: &#x27;The goal of life is love.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;happiness&#x27;, score: 0.03253183513879776, token: 9266, sequence: &#x27;The goal of life is happiness.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;freedom&#x27;, score: 0.018736306577920914, token: 4438, sequence: &#x27;The goal of life is freedom.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;life&#x27;, score: 0.01859794743359089, token: 1297, sequence: &#x27;The goal of life is life.&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Be=new J({props:{code:"Y29uc3QlMjB1bm1hc2tlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ZpbGwtbWFzayclMkMlMjAnWGVub3ZhJTJGYmVydC1iYXNlLWNhc2VkJyklM0IlMEFjb25zdCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwdW5tYXNrZXIoJ1RoZSUyME1pbGt5JTIwV2F5JTIwaXMlMjBhJTIwJTVCTUFTSyU1RCUyMGdhbGF4eS4nJTJDJTIwJTdCJTIwdG9wayUzQSUyMDElMjAlN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ3NwaXJhbCclMkMlMjBzY29yZSUzQSUyMDAuNjI5OTk4NzQzNTM0MDg4MSUyQyUyMHRva2VuJTNBJTIwMTQwNjElMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBNaWxreSUyMFdheSUyMGlzJTIwYSUyMHNwaXJhbCUyMGdhbGF4eS4nJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">const</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The Milky Way is a [MASK] galaxy.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">1</span> });
<span class="hljs-comment">// [{ token_str: &#x27;spiral&#x27;, score: 0.6299987435340881, token: 14061, sequence: &#x27;The Milky Way is a spiral galaxy.&#x27; }]</span>`,wrap:!1}}),Re=new h({props:{title:"new FillMaskPipeline(options)",local:"new-fillmaskpipelineoptions",headingTag:"h3"}}),We=new h({props:{title:"fillMaskPipeline._call() : <code> FillMaskPipelineCallback </code>",local:"fillmaskpipelinecall--code-fillmaskpipelinecallback-code",headingTag:"h3"}}),Fe=new h({props:{title:"pipelines.Text2TextGenerationPipeline",local:"pipelinestext2textgenerationpipeline",headingTag:"h2"}}),qe=new J({props:{code:"Y29uc3QlMjBnZW5lcmF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCd0ZXh0MnRleHQtZ2VuZXJhdGlvbiclMkMlMjAnWGVub3ZhJTJGTGFNaW5pLUZsYW4tVDUtNzgzTScpJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGdlbmVyYXRvcignaG93JTIwY2FuJTIwSSUyMGJlY29tZSUyMG1vcmUlMjBoZWFsdGh5JTNGJyUyQyUyMCU3QiUwQSUyMCUyMG1heF9uZXdfdG9rZW5zJTNBJTIwMTAwJTJDJTBBJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiU3QiUyMGdlbmVyYXRlZF90ZXh0JTNBJTIwJTIyVG8lMjBiZWNvbWUlMjBtb3JlJTIwaGVhbHRoeSUyQyUyMHlvdSUyMGNhbiUzQSUyMDEuJTIwRWF0JTIwYSUyMGJhbGFuY2VkJTIwZGlldCUyMHdpdGglMjBwbGVudHklMjBvZiUyMGZydWl0cyUyQyUyMHZlZ2V0YWJsZXMlMkMlMjB3aG9sZSUyMGdyYWlucyUyQyUyMGxlYW4lMjBwcm90ZWlucyUyQyUyMGFuZCUyMGhlYWx0aHklMjBmYXRzLiUyMDIuJTIwU3RheSUyMGh5ZHJhdGVkJTIwYnklMjBkcmlua2luZyUyMHBsZW50eSUyMG9mJTIwd2F0ZXIuJTIwMy4lMjBHZXQlMjBlbm91Z2glMjBzbGVlcCUyMGFuZCUyMG1hbmFnZSUyMHN0cmVzcyUyMGxldmVscy4lMjA0LiUyMEF2b2lkJTIwc21va2luZyUyMGFuZCUyMGV4Y2Vzc2l2ZSUyMGFsY29ob2wlMjBjb25zdW1wdGlvbi4lMjA1LiUyMFJlZ3VsYXJseSUyMGV4ZXJjaXNlJTIwYW5kJTIwbWFpbnRhaW4lMjBhJTIwaGVhbHRoeSUyMHdlaWdodC4lMjA2LiUyMFByYWN0aWNlJTIwZ29vZCUyMGh5Z2llbmUlMjBhbmQlMjBzYW5pdGF0aW9uLiUyMDcuJTIwU2VlayUyMG1lZGljYWwlMjBhdHRlbnRpb24lMjBpZiUyMHlvdSUyMGV4cGVyaWVuY2UlMjBhbnklMjBoZWFsdGglMjBpc3N1ZXMuJTIyJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">const</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text2text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/LaMini-Flan-T5-783M&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(<span class="hljs-string">&#x27;how can I become more healthy?&#x27;</span>, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ generated_text: &quot;To become more healthy, you can: 1. Eat a balanced diet with plenty of fruits, vegetables, whole grains, lean proteins, and healthy fats. 2. Stay hydrated by drinking plenty of water. 3. Get enough sleep and manage stress levels. 4. Avoid smoking and excessive alcohol consumption. 5. Regularly exercise and maintain a healthy weight. 6. Practice good hygiene and sanitation. 7. Seek medical attention if you experience any health issues.&quot; }]</span>`,wrap:!1}}),lt=new h({props:{title:"new Text2TextGenerationPipeline(options)",local:"new-text2textgenerationpipelineoptions",headingTag:"h3"}}),at=new h({props:{title:"text2TextGenerationPipeline._key : <code> ’ generated_text ’ </code>",local:"text2textgenerationpipelinekey--code--generatedtext--code",headingTag:"h3"}}),dt=new h({props:{title:"text2TextGenerationPipeline._call() : <code> Text2TextGenerationPipelineCallback </code>",local:"text2textgenerationpipelinecall--code-text2textgenerationpipelinecallback-code",headingTag:"h3"}}),mt=new h({props:{title:"pipelines.SummarizationPipeline",local:"pipelinessummarizationpipeline",headingTag:"h2"}}),Tt=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">const</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;summarization&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbart-cnn-6-6&#x27;</span>);
<span class="hljs-keyword">const</span> text = <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, &#x27;</span> +
  <span class="hljs-string">&#x27;and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. &#x27;</span> +
  <span class="hljs-string">&#x27;During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest &#x27;</span> +
  <span class="hljs-string">&#x27;man-made structure in the world, a title it held for 41 years until the Chrysler Building in New &#x27;</span> +
  <span class="hljs-string">&#x27;York City was finished in 1930. It was the first structure to reach a height of 300 metres. Due to &#x27;</span> +
  <span class="hljs-string">&#x27;the addition of a broadcasting aerial at the top of the tower in 1957, it is now taller than the &#x27;</span> +
  <span class="hljs-string">&#x27;Chrysler Building by 5.2 metres (17 ft). Excluding transmitters, the Eiffel Tower is the second &#x27;</span> +
  <span class="hljs-string">&#x27;tallest free-standing structure in France after the Millau Viaduct.&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ summary_text: &#x27; The Eiffel Tower is about the same height as an 81-storey building and the tallest structure in Paris. It is the second tallest free-standing structure in France after the Millau Viaduct.&#x27; }]</span>`,wrap:!1}}),ft=new h({props:{title:"new SummarizationPipeline(options)",local:"new-summarizationpipelineoptions",headingTag:"h3"}}),bt=new h({props:{title:"summarizationPipeline._key : <code> ’ summary_text ’ </code>",local:"summarizationpipelinekey--code--summarytext--code",headingTag:"h3"}}),Ct=new h({props:{title:"pipelines.TranslationPipeline",local:"pipelinestranslationpipeline",headingTag:"h2"}}),Pt=new J({props:{code:"Y29uc3QlMjB0cmFuc2xhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndHJhbnNsYXRpb24nJTJDJTIwJ1hlbm92YSUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJyklM0IlMEFjb25zdCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwdHJhbnNsYXRvcignJUUwJUE0JTlDJUUwJUE1JTgwJUUwJUE0JUI1JUUwJUE0JUE4JTIwJUUwJUE0JThGJUUwJUE0JTk1JTIwJUUwJUE0JTlBJUUwJUE1JTg5JUUwJUE0JTk1JUUwJUE0JUIyJUUwJUE1JTg3JUUwJUE0JTlGJTIwJUUwJUE0JUFDJUUwJUE1JTg5JUUwJUE0JTk1JUUwJUE1JThEJUUwJUE0JUI4JTIwJUUwJUE0JTk1JUUwJUE1JTgwJTIwJUUwJUE0JUE0JUUwJUE0JUIwJUUwJUE0JUI5JTIwJUUwJUE0JUI5JUUwJUE1JTg4JUUwJUE1JUE0JyUyQyUyMCU3QiUwQSUyMCUyMHNyY19sYW5nJTNBJTIwJ2hpbl9EZXZhJyUyQyUyMCUyRiUyRiUyMEhpbmRpJTBBJTIwJTIwdGd0X2xhbmclM0ElMjAnZnJhX0xhdG4nJTJDJTIwJTJGJTJGJTIwRnJlbmNoJTBBJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiU3QiUyMHRyYW5zbGF0aW9uX3RleHQlM0ElMjAnTGElMjB2aWUlMjBlc3QlMjBjb21tZSUyMHVuZSUyMGJvJUMzJUFFdGUlMjAlQzMlQTAlMjBjaG9jb2xhdC4nJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">const</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;जीवन एक चॉकलेट बॉक्स की तरह है।&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hin_Deva&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fra_Latn&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;La vie est comme une boîte à chocolat.&#x27; }]</span>`,wrap:!1}}),vt=new J({props:{code:"Y29uc3QlMjB0cmFuc2xhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndHJhbnNsYXRpb24nJTJDJTIwJ1hlbm92YSUyRm0ybTEwMF80MThNJyklM0IlMEFjb25zdCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwdHJhbnNsYXRvcignJUU3JTk0JTlGJUU2JUI0JUJCJUU1JUIwJUIxJUU1JTgzJThGJUU0JUI4JTgwJUU3JTlCJTkyJUU1JUI3JUE3JUU1JTg1JThCJUU1JThBJTlCJUUzJTgwJTgyJyUyQyUyMCU3QiUwQSUyMCUyMHNyY19sYW5nJTNBJTIwJ3poJyUyQyUyMCUyRiUyRiUyMENoaW5lc2UlMEElMjAlMjB0Z3RfbGFuZyUzQSUyMCdlbiclMkMlMjAlMkYlMkYlMjBFbmdsaXNoJTBBJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiU3QiUyMHRyYW5zbGF0aW9uX3RleHQlM0ElMjAnTGlmZSUyMGlzJTIwbGlrZSUyMGElMjBib3glMjBvZiUyMGNob2NvbGF0ZS4nJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">const</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/m2m100_418M&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;生活就像一盒巧克力。&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;zh&#x27;</span>, <span class="hljs-comment">// Chinese</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-comment">// English</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Life is like a box of chocolate.&#x27; }]</span>`,wrap:!1}}),Ht=new J({props:{code:"Y29uc3QlMjB0cmFuc2xhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndHJhbnNsYXRpb24nJTJDJTIwJ1hlbm92YSUyRm1iYXJ0LWxhcmdlLTUwLW1hbnktdG8tbWFueS1tbXQnKSUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTAlQTQlQjglRTAlQTQlODIlRTAlQTQlQUYlRTAlQTUlODElRTAlQTQlOTUlRTAlQTUlOEQlRTAlQTQlQTQlMjAlRTAlQTQlQjAlRTAlQTQlQkUlRTAlQTQlQjclRTAlQTUlOEQlRTAlQTQlOUYlRTAlQTUlOEQlRTAlQTQlQjAlMjAlRTAlQTQlOTUlRTAlQTUlODclMjAlRTAlQTQlQUElRTAlQTUlOEQlRTAlQTQlQjAlRTAlQTQlQUUlRTAlQTUlODElRTAlQTQlOTYlMjAlRTAlQTQlOTUlRTAlQTQlQkUlMjAlRTAlQTQlOTUlRTAlQTQlQjklRTAlQTQlQTglRTAlQTQlQkUlMjAlRTAlQTQlQjklRTAlQTUlODglMjAlRTAlQTQlOTUlRTAlQTQlQkYlMjAlRTAlQTQlQjglRTAlQTUlODAlRTAlQTQlQjAlRTAlQTQlQkYlRTAlQTQlQUYlRTAlQTQlQkUlMjAlRTAlQTQlQUUlRTAlQTUlODclRTAlQTQlODIlMjAlRTAlQTQlOTUlRTAlQTUlOEIlRTAlQTQlODglMjAlRTAlQTQlQjglRTAlQTUlODglRTAlQTQlQTglRTAlQTUlOEQlRTAlQTQlQUYlMjAlRTAlQTQlQjglRTAlQTQlQUUlRTAlQTQlQkUlRTAlQTQlQTclRTAlQTQlQkUlRTAlQTQlQTglMjAlRTAlQTQlQTglRTAlQTQlQjklRTAlQTUlODAlRTAlQTQlODIlMjAlRTAlQTQlQjklRTAlQTUlODgnJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnaGlfSU4nJTJDJTIwJTJGJTJGJTIwSGluZGklMEElMjAlMjB0Z3RfbGFuZyUzQSUyMCdmcl9YWCclMkMlMjAlMkYlMkYlMjBGcmVuY2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMZSUyMGNoZWYlMjBkZXMlMjBOYXRpb25zJTIwYWZmaXJtZSUyMHF1JTIwJ2lsJTIwbiUyMCd5JTIwYSUyMG1pbGl0YXJ5JTIwc29sdXRpb24lMjBpbiUyMFN5cmlhLiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">const</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mbart-large-50-many-to-many-mmt&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;संयुक्त राष्ट्र के प्रमुख का कहना है कि सीरिया में कोई सैन्य समाधान नहीं है&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hi_IN&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fr_XX&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Le chef des Nations affirme qu &#x27;il n &#x27;y a military solution in Syria.&#x27; }]</span>`,wrap:!1}}),Nt=new h({props:{title:"new TranslationPipeline(options)",local:"new-translationpipelineoptions",headingTag:"h3"}}),Lt=new h({props:{title:"translationPipeline._key : <code> ’ translation_text ’ </code>",local:"translationpipelinekey--code--translationtext--code",headingTag:"h3"}}),Xt=new h({props:{title:"pipelines.TextGenerationPipeline",local:"pipelinestextgenerationpipeline",headingTag:"h2"}}),Vt=new J({props:{code:"Y29uc3QlMjBnZW5lcmF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCd0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRmRpc3RpbGdwdDInKSUzQiUwQWNvbnN0JTIwdGV4dCUyMCUzRCUyMCdJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyclM0IlMEFjb25zdCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKHRleHQpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAlMjJJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyUyMGFuZCUyMEklMjBsb3ZlJTIwdG8lMjBwbGF5JTIwd2l0aCUyMHRoZSUyMG90aGVyJTIwZG9ncy4lMjIlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">const</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">const</span> text = <span class="hljs-string">&#x27;I enjoy walking with my cute dog,&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text);
<span class="hljs-comment">// [{ generated_text: &quot;I enjoy walking with my cute dog, and I love to play with the other dogs.&quot; }]</span>`,wrap:!1}}),qt=new J({props:{code:"Y29uc3QlMjBnZW5lcmF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCd0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRmRpc3RpbGdwdDInKSUzQiUwQWNvbnN0JTIwdGV4dCUyMCUzRCUyMCdPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMnJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGdlbmVyYXRvcih0ZXh0JTJDJTIwJTdCJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAyJTJDJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAxMCUyQyUwQSUyMCUyMHJlcGV0aXRpb25fcGVuYWx0eSUzQSUyMDEuNSUyQyUwQSUyMCUyMG5vX3JlcGVhdF9uZ3JhbV9zaXplJTNBJTIwMiUyQyUwQSUyMCUyMG51bV9iZWFtcyUzQSUyMDIlMkMlMEElMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzQSUyMDIlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIyZ2VuZXJhdGVkX3RleHQlMjIlM0ElMjAlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMlMjBhbiUyMGFidW5kYW5jZSUyMG9mJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMHRoZSUyMGhpc3RvcnklMjBhbmQlMjBhY3Rpdml0aWVzJTIwdGhhdCUyMiUwQSUyRiUyRiUyMCU3RCUyQyUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMmdlbmVyYXRlZF90ZXh0JTIyJTNBJTIwJTIyT25jZSUyMHVwb24lMjBhJTIwdGltZSUyQyUyMHRoZXJlJTIwd2FzJTIwYW4lMjBhYnVuZGFuY2UlMjBvZiUyMGluZm9ybWF0aW9uJTIwYWJvdXQlMjB0aGUlMjBtb3N0JTIwaW1wb3J0YW50JTIwYW5kJTIwaW5mbHVlbnRpYWwlMjIlMEElMkYlMkYlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">const</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">const</span> text = <span class="hljs-string">&#x27;Once upon a time, there was&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">10</span>,
  <span class="hljs-attr">repetition_penalty</span>: <span class="hljs-number">1.5</span>,
  <span class="hljs-attr">no_repeat_ngram_size</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_beams</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_return_sequences</span>: <span class="hljs-number">2</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the history and activities that&quot;</span>
<span class="hljs-comment">// }, {</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the most important and influential&quot;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),el=new J({props:{code:"Y29uc3QlMjBnZW5lcmF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCd0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRmNvZGVnZW4tMzUwTS1tb25vJyklM0IlMEFjb25zdCUyMHRleHQlMjAlM0QlMjAnZGVmJTIwZmliKG4pJTNBJyUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBnZW5lcmF0b3IodGV4dCUyQyUyMCU3QiUwQSUyMCUyMG1heF9uZXdfdG9rZW5zJTNBJTIwNDQlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTBBJTJGJTJGJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnZGVmJTIwZmliKG4pJTNBJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwaWYlMjBuJTIwJTNEJTNEJTIwMCUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMDAlNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjBlbGlmJTIwbiUyMCUzRCUzRCUyMDElM0ElNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAxJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwZWxzZSUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZpYihuLTEpJTIwJTJCJTIwZmliKG4tMiklNUNuJyUwQSUyRiUyRiUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">const</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/codegen-350M-mono&#x27;</span>);
<span class="hljs-keyword">const</span> text = <span class="hljs-string">&#x27;def fib(n):&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">44</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   generated_text: &#x27;def fib(n):\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    if n == 0:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 0\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    elif n == 1:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 1\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    else:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return fib(n-1) + fib(n-2)\\n&#x27;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),nl=new h({props:{title:"new TextGenerationPipeline(options)",local:"new-textgenerationpipelineoptions",headingTag:"h3"}}),ol=new h({props:{title:"textGenerationPipeline._call() : <code> TextGenerationPipelineCallback </code>",local:"textgenerationpipelinecall--code-textgenerationpipelinecallback-code",headingTag:"h3"}}),rl=new h({props:{title:"pipelines.ZeroShotClassificationPipeline",local:"pipelineszeroshotclassificationpipeline",headingTag:"h2"}}),Ml=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZtb2JpbGViZXJ0LXVuY2FzZWQtbW5saScpJTNCJTBBY29uc3QlMjB0ZXh0JTIwJTNEJTIwJ0xhc3QlMjB3ZWVrJTIwSSUyMHVwZ3JhZGVkJTIwbXklMjBpT1MlMjB2ZXJzaW9uJTIwYW5kJTIwZXZlciUyMHNpbmNlJTIwdGhlbiUyMG15JTIwcGhvbmUlMjBoYXMlMjBiZWVuJTIwb3ZlcmhlYXRpbmclMjB3aGVuZXZlciUyMEklMjB1c2UlMjB5b3VyJTIwYXBwLiclM0IlMEFjb25zdCUyMGxhYmVscyUyMCUzRCUyMCU1QiUyMCdtb2JpbGUnJTJDJTIwJ2JpbGxpbmcnJTJDJTIwJ3dlYnNpdGUnJTJDJTIwJ2FjY291bnQlMjBhY2Nlc3MnJTIwJTVEJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodGV4dCUyQyUyMGxhYmVscyklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBzZXF1ZW5jZSUzQSUyMCdMYXN0JTIwd2VlayUyMEklMjB1cGdyYWRlZCUyMG15JTIwaU9TJTIwdmVyc2lvbiUyMGFuZCUyMGV2ZXIlMjBzaW5jZSUyMHRoZW4lMjBteSUyMHBob25lJTIwaGFzJTIwYmVlbiUyMG92ZXJoZWF0aW5nJTIwd2hlbmV2ZXIlMjBJJTIwdXNlJTIweW91ciUyMGFwcC4nJTJDJTBBJTJGJTJGJTIwJTIwJTIwbGFiZWxzJTNBJTIwJTVCJTIwJ21vYmlsZSclMkMlMjAnd2Vic2l0ZSclMkMlMjAnYmlsbGluZyclMkMlMjAnYWNjb3VudCUyMGFjY2VzcyclMjAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjBzY29yZXMlM0ElMjAlNUIlMjAwLjU1NjIwOTEwNDA0ODIwMTglMkMlMjAwLjE4NDM2MjEzMDc4NjA4NTMlMkMlMjAwLjEzOTQyNjQ2NjM5MzM2Mzc2JTJDJTIwMC4xMjAwMDIyOTg3NzIzNDkyMyUyMCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mobilebert-uncased-mnli&#x27;</span>);
<span class="hljs-keyword">const</span> text = <span class="hljs-string">&#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;</span>;
<span class="hljs-keyword">const</span> labels = [ <span class="hljs-string">&#x27;mobile&#x27;</span>, <span class="hljs-string">&#x27;billing&#x27;</span>, <span class="hljs-string">&#x27;website&#x27;</span>, <span class="hljs-string">&#x27;account access&#x27;</span> ];
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;mobile&#x27;, &#x27;website&#x27;, &#x27;billing&#x27;, &#x27;account access&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.5562091040482018, 0.1843621307860853, 0.13942646639336376, 0.12000229877234923 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),yl=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZubGktZGViZXJ0YS12My14c21hbGwnKSUzQiUwQWNvbnN0JTIwdGV4dCUyMCUzRCUyMCdJJTIwaGF2ZSUyMGElMjBwcm9ibGVtJTIwd2l0aCUyMG15JTIwaXBob25lJTIwdGhhdCUyMG5lZWRzJTIwdG8lMjBiZSUyMHJlc29sdmVkJTIwYXNhcCEnJTNCJTBBY29uc3QlMjBsYWJlbHMlMjAlM0QlMjAlNUIlMjAndXJnZW50JyUyQyUyMCdub3QlMjB1cmdlbnQnJTJDJTIwJ3Bob25lJyUyQyUyMCd0YWJsZXQnJTJDJTIwJ2NvbXB1dGVyJyUyMCU1RCUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHRleHQlMkMlMjBsYWJlbHMlMkMlMjAlN0IlMjBtdWx0aV9sYWJlbCUzQSUyMHRydWUlMjAlN0QpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwc2VxdWVuY2UlM0ElMjAnSSUyMGhhdmUlMjBhJTIwcHJvYmxlbSUyMHdpdGglMjBteSUyMGlwaG9uZSUyMHRoYXQlMjBuZWVkcyUyMHRvJTIwYmUlMjByZXNvbHZlZCUyMGFzYXAhJyUyQyUwQSUyRiUyRiUyMCUyMCUyMGxhYmVscyUzQSUyMCU1QiUyMCd1cmdlbnQnJTJDJTIwJ3Bob25lJyUyQyUyMCdjb21wdXRlciclMkMlMjAndGFibGV0JyUyQyUyMCdub3QlMjB1cmdlbnQnJTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2NvcmVzJTNBJTIwJTVCJTIwMC45OTU4ODcwOTU2MzYwMjc1JTJDJTIwMC45OTIzOTYzNDAwNjk3MDM1JTJDJTIwMC4wMDIzMzM1Mzc5NDYxNjAyMzUlMkMlMjAwLjAwMTUxMzQxMzg1Njc1OTg3NjUlMkMlMjAwLjAwMTA2OTkzODQyMDgzNzcxNjMlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nli-deberta-v3-xsmall&#x27;</span>);
<span class="hljs-keyword">const</span> text = <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;</span>;
<span class="hljs-keyword">const</span> labels = [ <span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span> ];
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels, { <span class="hljs-attr">multi_label</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;urgent&#x27;, &#x27;phone&#x27;, &#x27;computer&#x27;, &#x27;tablet&#x27;, &#x27;not urgent&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.9958870956360275, 0.9923963400697035, 0.002333537946160235, 0.0015134138567598765, 0.0010699384208377163 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),wl=new h({props:{title:"new ZeroShotClassificationPipeline(options)",local:"new-zeroshotclassificationpipelineoptions",headingTag:"h3"}}),xl=new h({props:{title:"zeroShotClassificationPipeline.model : <code> any </code>",local:"zeroshotclassificationpipelinemodel--code-any-code",headingTag:"h3"}}),Il=new h({props:{title:"zeroShotClassificationPipeline._call() : <code> ZeroShotClassificationPipelineCallback </code>",local:"zeroshotclassificationpipelinecall--code-zeroshotclassificationpipelinecallback-code",headingTag:"h3"}}),Pl=new h({props:{title:"pipelines.FeatureExtractionPipeline",local:"pipelinesfeatureextractionpipeline",headingTag:"h2"}}),vl=new J({props:{code:"Y29uc3QlMjBleHRyYWN0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmZWF0dXJlLWV4dHJhY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS11bmNhc2VkJyUyQyUyMCU3QiUyMHJldmlzaW9uJTNBJTIwJ2RlZmF1bHQnJTIwJTdEKSUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBleHRyYWN0b3IoJ1RoaXMlMjBpcyUyMGElMjBzaW1wbGUlMjB0ZXN0LicpJTNCJTBBJTJGJTJGJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwdHlwZSUzQSUyMCdmbG9hdDMyJyUyQyUwQSUyRiUyRiUyMCUyMCUyMGRhdGElM0ElMjBGbG9hdDMyQXJyYXklMjAlNUIwLjA1OTM5OTI0NzE2OTQ5NDYzJTJDJTIwMC4wMjE2NTU5MzU3OTQxMTUwNjclMkMlMjAuLi4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjBkaW1zJTNBJTIwJTVCMSUyQyUyMDglMkMlMjA3NjglNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">const</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.05939924716949463, 0.021655935794115067, ...],</span>
<span class="hljs-comment">//   dims: [1, 8, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Gl=new J({props:{code:"Y29uc3QlMjBleHRyYWN0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmZWF0dXJlLWV4dHJhY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS11bmNhc2VkJyUyQyUyMCU3QiUyMHJldmlzaW9uJTNBJTIwJ2RlZmF1bHQnJTIwJTdEKSUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBleHRyYWN0b3IoJ1RoaXMlMjBpcyUyMGElMjBzaW1wbGUlMjB0ZXN0LiclMkMlMjAlN0IlMjBwb29saW5nJTNBJTIwJ21lYW4nJTJDJTIwbm9ybWFsaXplJTNBJTIwdHJ1ZSUyMCU3RCklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSUyMCU1QjAuMDMzNzM3Nzg5ODM5NTA2MTUlMkMlMjAtMC4wMTAxMDYwNzc0MTc3MzEyODUlMkMlMjAuLi4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjBkaW1zJTNBJTIwJTVCMSUyQyUyMDc2OCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">const</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.03373778983950615, -0.010106077417731285, ...],</span>
<span class="hljs-comment">//   dims: [1, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Zl=new J({props:{code:"Y29uc3QlMjBleHRyYWN0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmZWF0dXJlLWV4dHJhY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmFsbC1NaW5pTE0tTDYtdjInKSUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBleHRyYWN0b3IoJ1RoaXMlMjBpcyUyMGElMjBzaW1wbGUlMjB0ZXN0LiclMkMlMjAlN0IlMjBwb29saW5nJTNBJTIwJ21lYW4nJTJDJTIwbm9ybWFsaXplJTNBJTIwdHJ1ZSUyMCU3RCklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSUyMCU1QjAuMDkwOTQ5ODI1OTQyNTE2MzMlMkMlMjAtMC4wMTQ3NzQyNDYxNDEzMTQ1MDclMkMlMjAuLi4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjBkaW1zJTNBJTIwJTVCMSUyQyUyMDM4NCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">const</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.09094982594251633, -0.014774246141314507, ...],</span>
<span class="hljs-comment">//   dims: [1, 384]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),El=new J({props:{code:"Y29uc3QlMjBleHRyYWN0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmZWF0dXJlLWV4dHJhY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmFsbC1NaW5pTE0tTDYtdjInKSUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBleHRyYWN0b3IoJ1RoaXMlMjBpcyUyMGElMjBzaW1wbGUlMjB0ZXN0LiclMkMlMjAlN0IlMjBwb29saW5nJTNBJTIwJ21lYW4nJTJDJTIwcXVhbnRpemUlM0ElMjB0cnVlJTJDJTIwcHJlY2lzaW9uJTNBJTIwJ2JpbmFyeSclMjAlN0QpJTNCJTBBJTJGJTJGJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwdHlwZSUzQSUyMCdpbnQ4JyUyQyUwQSUyRiUyRiUyMCUyMCUyMGRhdGElM0ElMjBJbnQ4QXJyYXklQzIlQTAlNUI0OSUyQyUyMDEwOCUyQyUyMDI0JTJDJTIwLi4uJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGltcyUzQSUyMCU1QjElMkMlMjA0OCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">const</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>);
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">quantize</span>: <span class="hljs-literal">true</span>, <span class="hljs-attr">precision</span>: <span class="hljs-string">&#x27;binary&#x27;</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;int8&#x27;,</span>
<span class="hljs-comment">//   data: Int8Array [49, 108, 24, ...],</span>
<span class="hljs-comment">//   dims: [1, 48]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),zl=new h({props:{title:"new FeatureExtractionPipeline(options)",local:"new-featureextractionpipelineoptions",headingTag:"h3"}}),Xl=new h({props:{title:"featureExtractionPipeline._call() : <code> FeatureExtractionPipelineCallback </code>",local:"featureextractionpipelinecall--code-featureextractionpipelinecallback-code",headingTag:"h3"}}),Vl=new h({props:{title:"pipelines.ImageFeatureExtractionPipeline",local:"pipelinesimagefeatureextractionpipeline",headingTag:"h2"}}),Kl=new J({props:{code:"Y29uc3QlMjBpbWFnZV9mZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWZlYXR1cmUtZXh0cmFjdGlvbiclMkMlMjAnWGVub3ZhJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQtaW4yMWsnKSUzQiUwQWNvbnN0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmNhdHMucG5nJyUzQiUwQWNvbnN0JTIwZmVhdHVyZXMlMjAlM0QlMjBhd2FpdCUyMGltYWdlX2ZlYXR1cmVfZXh0cmFjdG9yKHVybCklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBkaW1zJTNBJTIwJTVCJTIwMSUyQyUyMDE5NyUyQyUyMDc2OCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5KDE1MTI5NiklMjAlNUIlMjAuLi4lMjAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjBzaXplJTNBJTIwMTUxMjk2JTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">const</span> image_feature_extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224-in21k&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png&#x27;</span>;
<span class="hljs-keyword">const</span> features = <span class="hljs-keyword">await</span> <span class="hljs-title function_">image_feature_extractor</span>(url);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   dims: [ 1, 197, 768 ],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array(151296) [ ... ],</span>
<span class="hljs-comment">//   size: 151296</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),ti=new J({props:{code:"Y29uc3QlMjBpbWFnZV9mZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWZlYXR1cmUtZXh0cmFjdGlvbiclMkMlMjAnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDMyJyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLnBuZyclM0IlMEFjb25zdCUyMGZlYXR1cmVzJTIwJTNEJTIwYXdhaXQlMjBpbWFnZV9mZWF0dXJlX2V4dHJhY3Rvcih1cmwpJTNCJTBBJTJGJTJGJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwZGltcyUzQSUyMCU1QiUyMDElMkMlMjA1MTIlMjAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSg1MTIpJTIwJTVCJTIwLi4uJTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2l6ZSUzQSUyMDUxMiUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">const</span> image_feature_extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/clip-vit-base-patch32&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png&#x27;</span>;
<span class="hljs-keyword">const</span> features = <span class="hljs-keyword">await</span> <span class="hljs-title function_">image_feature_extractor</span>(url);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   dims: [ 1, 512 ],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array(512) [ ... ],</span>
<span class="hljs-comment">//   size: 512</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),si=new h({props:{title:"new ImageFeatureExtractionPipeline(options)",local:"new-imagefeatureextractionpipelineoptions",headingTag:"h3"}}),di=new h({props:{title:"imageFeatureExtractionPipeline._call() : <code> ImageFeatureExtractionPipelineCallback </code>",local:"imagefeatureextractionpipelinecall--code-imagefeatureextractionpipelinecallback-code",headingTag:"h3"}}),mi=new h({props:{title:"pipelines.AudioClassificationPipeline",local:"pipelinesaudioclassificationpipeline",headingTag:"h2"}}),Ti=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXVkaW8tY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRndhdjJ2ZWMyLWxhcmdlLXhsc3ItNTMtZ2VuZGVyLXJlY29nbml0aW9uLWxpYnJpc3BlZWNoJyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGamZrLndhdiclM0IlMEFjb25zdCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuOTk4MTU0MjIyOTY1MjQwNSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ2ZlbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuMDAxODQ1NzQ3ODE0NTEzNzQzJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;audio-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/wav2vec2-large-xlsr-53-gender-recognition-librispeech&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;male&#x27;, score: 0.9981542229652405 },</span>
<span class="hljs-comment">//   { label: &#x27;female&#x27;, score: 0.001845747814513743 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),hi=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXVkaW8tY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRmFzdC1maW5ldHVuZWQtYXVkaW9zZXQtMTAtMTAtMC40NTkzJyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGY2F0X21lb3cud2F2JyUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjA0JTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ01lb3cnJTJDJTIwc2NvcmUlM0ElMjAwLjU2MTc4NzQyNjQ3MTcxMDIlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCdDYXQnJTJDJTIwc2NvcmUlM0ElMjAwLjIyMzY1Mzc2MzUzMjYzODU1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnRG9tZXN0aWMlMjBhbmltYWxzJTJDJTIwcGV0cyclMkMlMjBzY29yZSUzQSUyMDAuMTE0MTA2OTA4NDQwNTg5OSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ0FuaW1hbCclMkMlMjBzY29yZSUzQSUyMDAuMDg5ODU2OTIyNjI2NDk1MzYlMjAlN0QlMkMlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;audio-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/ast-finetuned-audioset-10-10-0.4593&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cat_meow.wav&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">4</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;Meow&#x27;, score: 0.5617874264717102 },</span>
<span class="hljs-comment">//   { label: &#x27;Cat&#x27;, score: 0.22365376353263855 },</span>
<span class="hljs-comment">//   { label: &#x27;Domestic animals, pets&#x27;, score: 0.1141069084405899 },</span>
<span class="hljs-comment">//   { label: &#x27;Animal&#x27;, score: 0.08985692262649536 },</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),ji=new h({props:{title:"new AudioClassificationPipeline(options)",local:"new-audioclassificationpipelineoptions",headingTag:"h3"}}),gi=new h({props:{title:"audioClassificationPipeline._call() : <code> AudioClassificationPipelineCallback </code>",local:"audioclassificationpipelinecall--code-audioclassificationpipelinecallback-code",headingTag:"h3"}}),ki=new h({props:{title:"pipelines.ZeroShotAudioClassificationPipeline",local:"pipelineszeroshotaudioclassificationpipeline",headingTag:"h2"}}),_i=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWF1ZGlvLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZjbGFwLWh0c2F0LXVuZnVzZWQnKSUzQiUwQWNvbnN0JTIwYXVkaW8lMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmRvZ19iYXJraW5nLndhdiclM0IlMEFjb25zdCUyMGNhbmRpZGF0ZV9sYWJlbHMlMjAlM0QlMjAlNUInZG9nJyUyQyUyMCd2YWNjdW0lMjBjbGVhbmVyJyU1RCUzQiUwQWNvbnN0JTIwc2NvcmVzJTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKGF1ZGlvJTJDJTIwY2FuZGlkYXRlX2xhYmVscyklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBzY29yZSUzQSUyMDAuOTk5Mzk5MjQ0Nzg1MzA4OCUyQyUyMGxhYmVsJTNBJTIwJ2RvZyclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBzY29yZSUzQSUyMDAuMDAwNjAwNzYwMzM2OTY1MzIyNSUyQyUyMGxhYmVsJTNBJTIwJ3ZhY2N1bSUyMGNsZWFuZXInJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-audio-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/clap-htsat-unfused&#x27;</span>);
<span class="hljs-keyword">const</span> audio = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/dog_barking.wav&#x27;</span>;
<span class="hljs-keyword">const</span> candidate_labels = [<span class="hljs-string">&#x27;dog&#x27;</span>, <span class="hljs-string">&#x27;vaccum cleaner&#x27;</span>];
<span class="hljs-keyword">const</span> scores = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(audio, candidate_labels);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { score: 0.9993992447853088, label: &#x27;dog&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0006007603369653225, label: &#x27;vaccum cleaner&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Gi=new h({props:{title:"new ZeroShotAudioClassificationPipeline(options)",local:"new-zeroshotaudioclassificationpipelineoptions",headingTag:"h3"}}),Ei=new h({props:{title:"zeroShotAudioClassificationPipeline._call() : <code> ZeroShotAudioClassificationPipelineCallback </code>",local:"zeroshotaudioclassificationpipelinecall--code-zeroshotaudioclassificationpipelinecallback-code",headingTag:"h3"}}),Ri=new h({props:{title:"pipelines.AutomaticSpeechRecognitionPipeline",local:"pipelinesautomaticspeechrecognitionpipeline",headingTag:"h2"}}),Si=new J({props:{code:"Y29uc3QlMjB0cmFuc2NyaWJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2F1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24nJTJDJTIwJ1hlbm92YSUyRndoaXNwZXItdGlueS5lbicpJTNCJTBBY29uc3QlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmpmay53YXYnJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url);
<span class="hljs-comment">// { text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot; }</span>`,wrap:!1}}),Xi=new J({props:{code:"Y29uc3QlMjB0cmFuc2NyaWJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2F1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24nJTJDJTIwJ1hlbm92YSUyRndoaXNwZXItdGlueS5lbicpJTNCJTBBY29uc3QlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmpmay53YXYnJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwdHJ1ZSUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTBBJTJGJTJGJTIwJTIwJTIwY2h1bmtzJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCMCUyQyUyMDglNUQlMkMlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTIyJTIwJTdEJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCOCUyQyUyMDExJTVEJTJDJTIwdGV4dCUzQSUyMCUyMiUyMGFzayUyMHdoYXQlMjB5b3UlMjBjYW4lMjBkbyUyMGZvciUyMHlvdXIlMjBjb3VudHJ5LiUyMiUyMCU3RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot;</span>
<span class="hljs-comment">//   chunks: [</span>
<span class="hljs-comment">//     { timestamp: [0, 8],  text: &quot; And so my fellow Americans ask not what your country can do for you&quot; }</span>
<span class="hljs-comment">//     { timestamp: [8, 11], text: &quot; ask what you can do for your country.&quot; }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Fi=new J({props:{code:"Y29uc3QlMjB0cmFuc2NyaWJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2F1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24nJTJDJTIwJ1hlbm92YSUyRndoaXNwZXItdGlueS5lbicpJTNCJTBBY29uc3QlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmpmay53YXYnJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwJ3dvcmQnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBBbmQlMjBzbyUyMG15JTIwZmVsbG93JTIwQW1lcmljYW5zJTIwYXNrJTIwbm90JTIwd2hhdCUyMHlvdXIlMjBjb3VudHJ5JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3UlMjBhc2slMjB3aGF0JTIweW91JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3VyJTIwY291bnRyeS4lMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJjaHVua3MlMjIlM0ElMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwQW5kJTIyJTJDJTIwJTIydGltZXN0YW1wJTIyJTNBJTIwJTVCMCUyQyUyMDAuNzglNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwc28lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIwLjc4JTJDJTIwMS4wNiU1RCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBteSUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjEuMDYlMkMlMjAxLjQ2JTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMGZvciUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjkuNzIlMkMlMjA5LjkyJTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMHlvdXIlMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUI5LjkyJTJDJTIwMTAuMjIlNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwY291bnRyeS4lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIxMC4yMiUyQyUyMDEzLjUlNUQlMjAlN0QlMEElMkYlMkYlMjAlMjAlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-string">&#x27;word&#x27;</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;text&quot;: &quot; And so my fellow Americans ask not what your country can do for you ask what you can do for your country.&quot;,</span>
<span class="hljs-comment">//   &quot;chunks&quot;: [</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; And&quot;, &quot;timestamp&quot;: [0, 0.78] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; so&quot;, &quot;timestamp&quot;: [0.78, 1.06] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; my&quot;, &quot;timestamp&quot;: [1.06, 1.46] },</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; for&quot;, &quot;timestamp&quot;: [9.72, 9.92] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; your&quot;, &quot;timestamp&quot;: [9.92, 10.22] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; country.&quot;, &quot;timestamp&quot;: [10.22, 13.5] }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Oi=new J({props:{code:"Y29uc3QlMjB0cmFuc2NyaWJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2F1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24nJTJDJTIwJ1hlbm92YSUyRndoaXNwZXItc21hbGwnKSUzQiUwQWNvbnN0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2NyaWJlJyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwSidhZG9yZSUyQyUyMGonYWltZSUyQyUyMGplJTIwbidhaW1lJTIwcGFzJTJDJTIwamUlMjBkJUMzJUE5dGVzdGUuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;transcribe&#x27;</span> });
<span class="hljs-comment">// { text: &quot; J&#x27;adore, j&#x27;aime, je n&#x27;aime pas, je déteste.&quot; }</span>`,wrap:!1}}),Ki=new J({props:{code:"Y29uc3QlMjB0cmFuc2NyaWJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2F1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24nJTJDJTIwJ1hlbm92YSUyRndoaXNwZXItc21hbGwnKSUzQiUwQWNvbnN0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2xhdGUnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBJJTIwbG92ZSUyQyUyMEklMjBsaWtlJTJDJTIwSSUyMGRvbid0JTIwbGlrZSUyQyUyMEklMjBoYXRlLiUyMiUyMCU3RA==",highlighted:`<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;translate&#x27;</span> });
<span class="hljs-comment">// { text: &quot; I love, I like, I don&#x27;t like, I hate.&quot; }</span>`,wrap:!1}}),tn=new J({props:{code:"Y29uc3QlMjB0cmFuc2NyaWJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2F1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24nJTJDJTIwJ1hlbm92YSUyRndoaXNwZXItdGlueS5lbicpJTNCJTBBY29uc3QlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRnRlZF82MC53YXYnJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMGNodW5rX2xlbmd0aF9zJTNBJTIwMzAlMkMlMjBzdHJpZGVfbGVuZ3RoX3MlM0ElMjA1JTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBTbyUyMGluJTIwY29sbGVnZSUyQyUyMEklMjB3YXMlMjBhJTIwZ292ZXJubWVudCUyMG1ham9yJTJDJTIwd2hpY2glMjBtZWFucyUyMCU1Qi4uLiU1RCUyMFNvJTIwSSdkJTIwc3RhcnQlMjBvZmYlMjBsaWdodCUyMGFuZCUyMEknZCUyMGJ1bXAlMjBpdCUyMHVwJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/ted_60.wav&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">chunk_length_s</span>: <span class="hljs-number">30</span>, <span class="hljs-attr">stride_length_s</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// { text: &quot; So in college, I was a government major, which means [...] So I&#x27;d start off light and I&#x27;d bump it up&quot; }</span>`,wrap:!1}}),an=new h({props:{title:"new AutomaticSpeechRecognitionPipeline(options)",local:"new-automaticspeechrecognitionpipelineoptions",headingTag:"h3"}}),cn=new h({props:{title:"automaticSpeechRecognitionPipeline._call() : <code> AutomaticSpeechRecognitionPipelineCallback </code>",local:"automaticspeechrecognitionpipelinecall--code-automaticspeechrecognitionpipelinecallback-code",headingTag:"h3"}}),un=new h({props:{title:"pipelines.ImageToTextPipeline",local:"pipelinesimagetotextpipeline",headingTag:"h2"}}),yn=new J({props:{code:"Y29uc3QlMjBjYXB0aW9uZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS10by10ZXh0JyUyQyUyMCdYZW5vdmElMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGY2F0cy5qcGcnJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNhcHRpb25lcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnYSUyMGNhdCUyMGxheWluZyUyMG9uJTIwYSUyMGNvdWNoJTIwd2l0aCUyMGFub3RoZXIlMjBjYXQnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">const</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-gpt2-image-captioning&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;a cat laying on a couch with another cat&#x27; }]</span>`,wrap:!1}}),Jn=new J({props:{code:"Y29uc3QlMjBjYXB0aW9uZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS10by10ZXh0JyUyQyUyMCdYZW5vdmElMkZ0cm9jci1zbWFsbC1oYW5kd3JpdHRlbicpJTNCJTBBY29uc3QlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmhhbmR3cml0aW5nLmpwZyclM0IlMEFjb25zdCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2FwdGlvbmVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBnZW5lcmF0ZWRfdGV4dCUzQSUyMCdNci4lMjBCcm93biUyMGNvbW1lbnRlZCUyMGljaWx5LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">const</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/trocr-small-handwritten&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/handwriting.jpg&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;Mr. Brown commented icily.&#x27; }]</span>`,wrap:!1}}),Un=new h({props:{title:"new ImageToTextPipeline(options)",local:"new-imagetotextpipelineoptions",headingTag:"h3"}}),Cn=new h({props:{title:"imageToTextPipeline._call() : <code> ImageToTextPipelineCallback </code>",local:"imagetotextpipelinecall--code-imagetotextpipelinecallback-code",headingTag:"h3"}}),An=new h({props:{title:"pipelines.ImageClassificationPipeline",local:"pipelinesimageclassificationpipeline",headingTag:"h2"}}),$n=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGdGlnZXIuanBnJyUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCd0aWdlciUyQyUyMFBhbnRoZXJhJTIwdGlncmlzJyUyQyUyMHNjb3JlJTNBJTIwMC42MzI2OTU3MzQ1MDA4ODUlMjAlN0QlMkMlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885 },</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Qn=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGdGlnZXIuanBnJyUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAzJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyUyMCU3RCUyQyUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">3</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885 },</span>
<span class="hljs-comment">//   { label: &#x27;tiger cat&#x27;, score: 0.3634825646877289 },</span>
<span class="hljs-comment">//   { label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707 },</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Hn=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGdGlnZXIuanBnJyUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAwJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ2phZ3VhciUyQyUyMHBhbnRoZXIlMkMlMjBQYW50aGVyYSUyMG9uY2ElMkMlMjBGZWxpcyUyMG9uY2EnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDM1NDY1NDk5OTY4MjY3OTc3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">0</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885 },</span>
<span class="hljs-comment">//   { label: &#x27;tiger cat&#x27;, score: 0.3634825646877289 },</span>
<span class="hljs-comment">//   { label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707 },</span>
<span class="hljs-comment">//   { label: &#x27;jaguar, panther, Panthera onca, Felis onca&#x27;, score: 0.00035465499968267977 },</span>
<span class="hljs-comment">//   ...</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Nn=new h({props:{title:"new ImageClassificationPipeline(options)",local:"new-imageclassificationpipelineoptions",headingTag:"h3"}}),Ln=new h({props:{title:"imageClassificationPipeline._call() : <code> ImageClassificationPipelineCallback </code>",local:"imageclassificationpipelinecall--code-imageclassificationpipelinecallback-code",headingTag:"h3"}}),Xn=new h({props:{title:"pipelines.ImageSegmentationPipeline",local:"pipelinesimagesegmentationpipeline",headingTag:"h2"}}),Vn=new J({props:{code:"Y29uc3QlMjBzZWdtZW50ZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS1zZWdtZW50YXRpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwLXBhbm9wdGljJyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGY2F0cy5qcGcnJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHNlZ21lbnRlcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAncmVtb3RlJyUyQyUyMHNjb3JlJTNBJTIwMC45OTg0NjQ5NDE5Nzg0NTQ2JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC45OTk0MzE2MTAxMDc0MjE5JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">const</span> segmenter = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-segmentation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50-panoptic&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">segmenter</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;remote&#x27;, score: 0.9984649419784546, mask: RawImage { ... } },</span>
<span class="hljs-comment">//   { label: &#x27;cat&#x27;, score: 0.9994316101074219, mask: RawImage { ... } }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),es=new h({props:{title:"new ImageSegmentationPipeline(options)",local:"new-imagesegmentationpipelineoptions",headingTag:"h3"}}),ns=new h({props:{title:"imageSegmentationPipeline._call() : <code> ImageSegmentationPipelineCallback </code>",local:"imagesegmentationpipelinecall--code-imagesegmentationpipelinecallback-code",headingTag:"h3"}}),ps=new h({props:{title:"pipelines.ZeroShotImageClassificationPipeline",local:"pipelineszeroshotimageclassificationpipeline",headingTag:"h2"}}),cs=new J({props:{code:"Y29uc3QlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZjbGlwLXZpdC1iYXNlLXBhdGNoMzInKSUzQiUwQWNvbnN0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodXJsJTJDJTIwJTVCJ3RpZ2VyJyUyQyUyMCdob3JzZSclMkMlMjAnZG9nJyU1RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBzY29yZSUzQSUyMDAuOTk5MzkxNzk0MjA0NzExOSUyQyUyMGxhYmVsJTNBJTIwJ3RpZ2VyJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHNjb3JlJTNBJTIwMC4wMDAzNTE5Mjk0ODQxNjgwNjc2JTJDJTIwbGFiZWwlM0ElMjAnaG9yc2UnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwc2NvcmUlM0ElMjAwLjAwMDI1NjI2OTg3OTE3MzQ4NzQlMkMlMjBsYWJlbCUzQSUyMCdkb2cnJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/clip-vit-base-patch32&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, [<span class="hljs-string">&#x27;tiger&#x27;</span>, <span class="hljs-string">&#x27;horse&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { score: 0.9993917942047119, label: &#x27;tiger&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0003519294841680676, label: &#x27;horse&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0002562698791734874, label: &#x27;dog&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Ms=new h({props:{title:"new ZeroShotImageClassificationPipeline(options)",local:"new-zeroshotimageclassificationpipelineoptions",headingTag:"h3"}}),Js=new h({props:{title:"zeroShotImageClassificationPipeline._call() : <code> ZeroShotImageClassificationPipelineCallback </code>",local:"zeroshotimageclassificationpipelinecall--code-zeroshotimageclassificationpipelinecallback-code",headingTag:"h3"}}),js=new h({props:{title:"pipelines.ObjectDetectionPipeline",local:"pipelinesobjectdetectionpipeline",headingTag:"h2"}}),xs=new J({props:{code:"Y29uc3QlMjBkZXRlY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ29iamVjdC1kZXRlY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwJyklM0IlMEFjb25zdCUyMGltZyUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGY2F0cy5qcGcnJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGRldGVjdG9yKGltZyUyQyUyMCU3QiUyMHRocmVzaG9sZCUzQSUyMDAuOSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMEElMkYlMkYlMjAlMjAlMjBzY29yZSUzQSUyMDAuOTk3NjM3MDkzMDY3MTY5MiUyQyUwQSUyRiUyRiUyMCUyMCUyMGxhYmVsJTNBJTIwJTIycmVtb3RlJTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwYm94JTNBJTIwJTdCJTIweG1pbiUzQSUyMDMxJTJDJTIweW1pbiUzQSUyMDY4JTJDJTIweG1heCUzQSUyMDE5MCUyQyUyMHltYXglM0ElMjAxMTglMjAlN0QlMEElMkYlMkYlMjAlN0QlMkMlMEElMkYlMkYlMjAuLi4lMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBzY29yZSUzQSUyMDAuOTk4NDA5MjExNjM1NTg5NiUyQyUwQSUyRiUyRiUyMCUyMCUyMGxhYmVsJTNBJTIwJTIyY2F0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwYm94JTNBJTIwJTdCJTIweG1pbiUzQSUyMDMzMSUyQyUyMHltaW4lM0ElMjAxOSUyQyUyMHhtYXglM0ElMjA2NDklMkMlMjB5bWF4JTNBJTIwMzcxJTIwJTdEJTBBJTJGJTJGJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">const</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50&#x27;</span>);
<span class="hljs-keyword">const</span> img = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(img, { <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.9</span> });
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   score: 0.9976370930671692,</span>
<span class="hljs-comment">//   label: &quot;remote&quot;,</span>
<span class="hljs-comment">//   box: { xmin: 31, ymin: 68, xmax: 190, ymax: 118 }</span>
<span class="hljs-comment">// },</span>
<span class="hljs-comment">// ...</span>
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   score: 0.9984092116355896,</span>
<span class="hljs-comment">//   label: &quot;cat&quot;,</span>
<span class="hljs-comment">//   box: { xmin: 331, ymin: 19, xmax: 649, ymax: 371 }</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),ks=new h({props:{title:"new ObjectDetectionPipeline(options)",local:"new-objectdetectionpipelineoptions",headingTag:"h3"}}),$s=new h({props:{title:"objectDetectionPipeline._call() : <code> ObjectDetectionPipelineCallback </code>",local:"objectdetectionpipelinecall--code-objectdetectionpipelinecallback-code",headingTag:"h3"}}),Gs=new h({props:{title:"pipelines.ZeroShotObjectDetectionPipeline",local:"pipelineszeroshotobjectdetectionpipeline",headingTag:"h2"}}),Bs=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">const</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/owlvit-base-patch32&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/astronaut.png&#x27;</span>;
<span class="hljs-keyword">const</span> candidate_labels = [<span class="hljs-string">&#x27;human face&#x27;</span>, <span class="hljs-string">&#x27;rocket&#x27;</span>, <span class="hljs-string">&#x27;helmet&#x27;</span>, <span class="hljs-string">&#x27;american flag&#x27;</span>];
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(url, candidate_labels);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.24392342567443848,</span>
<span class="hljs-comment">//     label: &#x27;human face&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 180, ymin: 67, xmax: 274, ymax: 175 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.15129457414150238,</span>
<span class="hljs-comment">//     label: &#x27;american flag&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 0, ymin: 4, xmax: 106, ymax: 513 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.13649864494800568,</span>
<span class="hljs-comment">//     label: &#x27;helmet&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 277, ymin: 337, xmax: 511, ymax: 511 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.10262022167444229,</span>
<span class="hljs-comment">//     label: &#x27;rocket&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 352, ymin: -1, xmax: 463, ymax: 287 }</span>
<span class="hljs-comment">//   }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Ns=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">const</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/owlvit-base-patch32&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/beach.png&#x27;</span>;
<span class="hljs-keyword">const</span> candidate_labels = [<span class="hljs-string">&#x27;hat&#x27;</span>, <span class="hljs-string">&#x27;book&#x27;</span>, <span class="hljs-string">&#x27;sunglasses&#x27;</span>, <span class="hljs-string">&#x27;camera&#x27;</span>];
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(url, candidate_labels, { <span class="hljs-attr">topk</span>: <span class="hljs-number">4</span>, <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.05</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.1606510728597641,</span>
<span class="hljs-comment">//     label: &#x27;sunglasses&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 347, ymin: 229, xmax: 429, ymax: 264 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.08935828506946564,</span>
<span class="hljs-comment">//     label: &#x27;hat&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 38, ymin: 174, xmax: 258, ymax: 364 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.08530698716640472,</span>
<span class="hljs-comment">//     label: &#x27;camera&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 187, ymin: 350, xmax: 260, ymax: 411 }</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   {</span>
<span class="hljs-comment">//     score: 0.08349756896495819,</span>
<span class="hljs-comment">//     label: &#x27;book&#x27;,</span>
<span class="hljs-comment">//     box: { xmin: 261, ymin: 280, xmax: 494, ymax: 425 }</span>
<span class="hljs-comment">//   }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Ls=new h({props:{title:"new ZeroShotObjectDetectionPipeline(options)",local:"new-zeroshotobjectdetectionpipelineoptions",headingTag:"h3"}}),Ds=new h({props:{title:"zeroShotObjectDetectionPipeline._call() : <code> ZeroShotObjectDetectionPipelineCallback </code>",local:"zeroshotobjectdetectionpipelinecall--code-zeroshotobjectdetectionpipelinecallback-code",headingTag:"h3"}}),Os=new h({props:{title:"pipelines.DocumentQuestionAnsweringPipeline",local:"pipelinesdocumentquestionansweringpipeline",headingTag:"h2"}}),ea=new J({props:{code:"Y29uc3QlMjBxYV9waXBlbGluZSUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2RvY3VtZW50LXF1ZXN0aW9uLWFuc3dlcmluZyclMkMlMjAnWGVub3ZhJTJGZG9udXQtYmFzZS1maW5ldHVuZWQtZG9jdnFhJyklM0IlMEFjb25zdCUyMGltYWdlJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZpbnZvaWNlLnBuZyclM0IlMEFjb25zdCUyMHF1ZXN0aW9uJTIwJTNEJTIwJ1doYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YnJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHFhX3BpcGVsaW5lKGltYWdlJTJDJTIwcXVlc3Rpb24pJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwYW5zd2VyJTNBJTIwJ3VzLTAwMSclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">const</span> qa_pipeline = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;document-question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/donut-base-finetuned-docvqa&#x27;</span>);
<span class="hljs-keyword">const</span> image = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/invoice.png&#x27;</span>;
<span class="hljs-keyword">const</span> question = <span class="hljs-string">&#x27;What is the invoice number?&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">qa_pipeline</span>(image, question);
<span class="hljs-comment">// [{ answer: &#x27;us-001&#x27; }]</span>`,wrap:!1}}),na=new h({props:{title:"new DocumentQuestionAnsweringPipeline(options)",local:"new-documentquestionansweringpipelineoptions",headingTag:"h3"}}),oa=new h({props:{title:"documentQuestionAnsweringPipeline._call() : <code> DocumentQuestionAnsweringPipelineCallback </code>",local:"documentquestionansweringpipelinecall--code-documentquestionansweringpipelinecallback-code",headingTag:"h3"}}),ra=new h({props:{title:"pipelines.TextToAudioPipeline",local:"pipelinestexttoaudiopipeline",headingTag:"h2"}}),Ma=new J({props:{code:"Y29uc3QlMjBzeW50aGVzaXplciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtdG8tc3BlZWNoJyUyQyUyMCdYZW5vdmElMkZzcGVlY2h0NV90dHMnJTJDJTIwJTdCJTIwcXVhbnRpemVkJTNBJTIwZmFsc2UlMjAlN0QpJTNCJTBBY29uc3QlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRnNwZWFrZXJfZW1iZWRkaW5ncy5iaW4nJTNCJTBBY29uc3QlMjBvdXQlMjAlM0QlMjBhd2FpdCUyMHN5bnRoZXNpemVyKCdIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJyUyQyUyMCU3QiUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBhdWRpbyUzQSUyMEZsb2F0MzJBcnJheSgyNjExMiklMjAlNUItMC4wMDAwNTY1NzMzNzg5Njk5MTUyMSUyQyUyMDAuMDAwMjA1ODM4NzQ3MjA2MTQ0MDMlMkMlMjAuLi4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjBzYW1wbGluZ19yYXRlJTNBJTIwMTYwMDAlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">const</span> synthesizer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-to-speech&#x27;</span>, <span class="hljs-string">&#x27;Xenova/speecht5_tts&#x27;</span>, { <span class="hljs-attr">quantized</span>: <span class="hljs-literal">false</span> });
<span class="hljs-keyword">const</span> speaker_embeddings = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/speaker_embeddings.bin&#x27;</span>;
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> <span class="hljs-title function_">synthesizer</span>(<span class="hljs-string">&#x27;Hello, my dog is cute&#x27;</span>, { speaker_embeddings });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   audio: Float32Array(26112) [-0.00005657337896991521, 0.00020583874720614403, ...],</span>
<span class="hljs-comment">//   sampling_rate: 16000</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),ya=new J({props:{code:"aW1wb3J0JTIwd2F2ZWZpbGUlMjBmcm9tJTIwJ3dhdmVmaWxlJyUzQiUwQWltcG9ydCUyMGZzJTIwZnJvbSUyMCdmcyclM0IlMEElMEFjb25zdCUyMHdhdiUyMCUzRCUyMG5ldyUyMHdhdmVmaWxlLldhdmVGaWxlKCklM0IlMEF3YXYuZnJvbVNjcmF0Y2goMSUyQyUyMG91dC5zYW1wbGluZ19yYXRlJTJDJTIwJzMyZiclMkMlMjBvdXQuYXVkaW8pJTNCJTBBZnMud3JpdGVGaWxlU3luYygnb3V0LndhdiclMkMlMjB3YXYudG9CdWZmZXIoKSklM0I=",highlighted:`<span class="hljs-keyword">import</span> wavefile <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;wavefile&#x27;</span>;
<span class="hljs-keyword">import</span> fs <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;fs&#x27;</span>;

<span class="hljs-keyword">const</span> wav = <span class="hljs-keyword">new</span> wavefile.<span class="hljs-title class_">WaveFile</span>();
wav.<span class="hljs-title function_">fromScratch</span>(<span class="hljs-number">1</span>, out.<span class="hljs-property">sampling_rate</span>, <span class="hljs-string">&#x27;32f&#x27;</span>, out.<span class="hljs-property">audio</span>);
fs.<span class="hljs-title function_">writeFileSync</span>(<span class="hljs-string">&#x27;out.wav&#x27;</span>, wav.<span class="hljs-title function_">toBuffer</span>());`,wrap:!1}}),Ja=new J({props:{code:"Y29uc3QlMjBzeW50aGVzaXplciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtdG8tc3BlZWNoJyUyQyUyMCdYZW5vdmElMkZtbXMtdHRzLWZyYScpJTNCJTBBY29uc3QlMjBvdXQlMjAlM0QlMjBhd2FpdCUyMHN5bnRoZXNpemVyKCdCb25qb3VyJyklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBhdWRpbyUzQSUyMEZsb2F0MzJBcnJheSgyMzgwOCklMjAlNUItMC4wMDAzNzY5MzAwNTI4ODAxOTc3NiUyQyUyMDAuMDAwMzMyNTg1MzYxMzIwNTI1NCUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0ElMjAxNjAwMCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">const</span> synthesizer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-to-speech&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mms-tts-fra&#x27;</span>);
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> <span class="hljs-title function_">synthesizer</span>(<span class="hljs-string">&#x27;Bonjour&#x27;</span>);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   audio: Float32Array(23808) [-0.00037693005288019776, 0.0003325853613205254, ...],</span>
<span class="hljs-comment">//   sampling_rate: 16000</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ua=new h({props:{title:"new TextToAudioPipeline(options)",local:"new-texttoaudiopipelineoptions",headingTag:"h3"}}),Ca=new h({props:{title:"textToAudioPipeline._call() : <code> TextToAudioPipelineCallback </code>",local:"texttoaudiopipelinecall--code-texttoaudiopipelinecallback-code",headingTag:"h3"}}),Aa=new h({props:{title:"pipelines.ImageToImagePipeline",local:"pipelinesimagetoimagepipeline",headingTag:"h2"}}),$a=new J({props:{code:"Y29uc3QlMjB1cHNjYWxlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLXRvLWltYWdlJyUyQyUyMCdYZW5vdmElMkZzd2luMlNSLWNsYXNzaWNhbC1zci14Mi02NCcpJTNCJTBBY29uc3QlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmJ1dHRlcmZseS5qcGcnJTNCJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHVwc2NhbGVyKHVybCklM0IlMEElMkYlMkYlMjBSYXdJbWFnZSUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMGRhdGElM0ElMjBVaW50OEFycmF5KDc4NjQzMiklMjAlNUIlMjA0MSUyQyUyMDMxJTJDJTIwMjQlMkMlMjAlMjA0MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHdpZHRoJTNBJTIwNTEyJTJDJTBBJTJGJTJGJTIwJTIwJTIwaGVpZ2h0JTNBJTIwNTEyJTJDJTBBJTJGJTJGJTIwJTIwJTIwY2hhbm5lbHMlM0ElMjAzJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">const</span> upscaler = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-image&#x27;</span>, <span class="hljs-string">&#x27;Xenova/swin2SR-classical-sr-x2-64&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/butterfly.jpg&#x27;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">upscaler</span>(url);
<span class="hljs-comment">// RawImage {</span>
<span class="hljs-comment">//   data: Uint8Array(786432) [ 41, 31, 24,  43, ... ],</span>
<span class="hljs-comment">//   width: 512,</span>
<span class="hljs-comment">//   height: 512,</span>
<span class="hljs-comment">//   channels: 3</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ha=new h({props:{title:"new ImageToImagePipeline(options)",local:"new-imagetoimagepipelineoptions",headingTag:"h3"}}),Na=new h({props:{title:"imageToImagePipeline._call() : <code> ImageToImagePipelineCallback </code>",local:"imagetoimagepipelinecall--code-imagetoimagepipelinecallback-code",headingTag:"h3"}}),za=new h({props:{title:"pipelines.DepthEstimationPipeline",local:"pipelinesdepthestimationpipeline",headingTag:"h2"}}),Wa=new J({props:{code:"Y29uc3QlMjBkZXB0aF9lc3RpbWF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdkZXB0aC1lc3RpbWF0aW9uJyUyQyUyMCdYZW5vdmElMkZkcHQtaHlicmlkLW1pZGFzJyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGY2F0cy5qcGcnJTNCJTBBY29uc3QlMjBvdXQlMjAlM0QlMjBhd2FpdCUyMGRlcHRoX2VzdGltYXRvcih1cmwpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTNBJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwZGltcyUzQSUyMCU1QiUyMDM4NCUyQyUyMDM4NCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5KDE0NzQ1NiklMjAlNUIlMjA1NDIuODU5MTMwODU5Mzc1JTJDJTIwNTQ1LjI4MzM4NjIzMDQ2ODglMkMlMjA1NDYuMTY0OTE2OTkyMTg3NSUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMHNpemUlM0ElMjAxNDc0NTYlMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjBkZXB0aCUzQSUyMFJhd0ltYWdlJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwZGF0YSUzQSUyMFVpbnQ4QXJyYXkoMzA3MjAwKSUyMCU1QiUyMDg2JTJDJTIwODYlMkMlMjA4NiUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMHdpZHRoJTNBJTIwNjQwJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwaGVpZ2h0JTNBJTIwNDgwJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwY2hhbm5lbHMlM0ElMjAxJTBBJTJGJTJGJTIwJTIwJTIwJTdEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">const</span> depth_estimator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;depth-estimation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/dpt-hybrid-midas&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> <span class="hljs-title function_">depth_estimator</span>(url);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   predicted_depth: Tensor {</span>
<span class="hljs-comment">//     dims: [ 384, 384 ],</span>
<span class="hljs-comment">//     type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//     data: Float32Array(147456) [ 542.859130859375, 545.2833862304688, 546.1649169921875, ... ],</span>
<span class="hljs-comment">//     size: 147456</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   depth: RawImage {</span>
<span class="hljs-comment">//     data: Uint8Array(307200) [ 86, 86, 86, ... ],</span>
<span class="hljs-comment">//     width: 640,</span>
<span class="hljs-comment">//     height: 480,</span>
<span class="hljs-comment">//     channels: 1</span>
<span class="hljs-comment">//   }</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Va=new h({props:{title:"new DepthEstimationPipeline(options)",local:"new-depthestimationpipelineoptions",headingTag:"h3"}}),ep=new h({props:{title:"depthEstimationPipeline._call() : <code> DepthEstimationPipelineCallback </code>",local:"depthestimationpipelinecall--code-depthestimationpipelinecallback-code",headingTag:"h3"}}),ip=new h({props:{title:"pipelines.pipeline(task, [model], [options]) ⇒ <code> * </code>",local:"pipelinespipelinetask-model-options--code--code",headingTag:"h2"}}),dp=new h({props:{title:"pipelines~x[1] : <code> number </code>",local:"pipelinesx1--code-number-code",headingTag:"h2"}}),mp=new h({props:{title:"pipelines~ImagePipelineInputs : <code> string </code> | <code> RawImage </code> | <code> URL </code>",local:"pipelinesimagepipelineinputs--code-string-code--code-rawimage-code--code-url-code",headingTag:"h2"}}),Tp=new h({props:{title:"pipelines~AudioPipelineInputs : <code> string </code> | <code> URL </code> | <code> Float32Array </code> | <code> Float64Array </code>",local:"pipelinesaudiopipelineinputs--code-string-code--code-url-code--code-float32array-code--code-float64array-code",headingTag:"h2"}}),Jp=new h({props:{title:"pipelines~BoundingBox : <code> Object </code>",local:"pipelinesboundingbox--code-object-code",headingTag:"h2"}}),Up=new h({props:{title:"pipelines~Disposable ⇒ <code> Promise. < void > </code>",local:"pipelinesdisposable--code-promise--void--code",headingTag:"h2"}}),Cp=new h({props:{title:"pipelines~TextPipelineConstructorArgs : <code> Object </code>",local:"pipelinestextpipelineconstructorargs--code-object-code",headingTag:"h2"}}),_p=new h({props:{title:"pipelines~ImagePipelineConstructorArgs : <code> Object </code>",local:"pipelinesimagepipelineconstructorargs--code-object-code",headingTag:"h2"}}),Hp=new h({props:{title:"pipelines~TextImagePipelineConstructorArgs : <code> Object </code>",local:"pipelinestextimagepipelineconstructorargs--code-object-code",headingTag:"h2"}}),Yp=new h({props:{title:"pipelines~TextClassificationPipelineType ⇒ <code> Promise. < (TextClassificationOutput|Array < TextClassificationOutput > ) > </code>",local:"pipelinestextclassificationpipelinetype--code-promise--textclassificationoutputarray--textclassificationoutput----code",headingTag:"h2"}}),Dp=new h({props:{title:"pipelines~TokenClassificationPipelineType ⇒ <code> Promise. < (TokenClassificationOutput|Array < TokenClassificationOutput > ) > </code>",local:"pipelinestokenclassificationpipelinetype--code-promise--tokenclassificationoutputarray--tokenclassificationoutput----code",headingTag:"h2"}}),to=new h({props:{title:"pipelines~QuestionAnsweringPipelineType ⇒ <code> Promise. < (QuestionAnsweringOutput|Array < QuestionAnsweringOutput > ) > </code>",local:"pipelinesquestionansweringpipelinetype--code-promise--questionansweringoutputarray--questionansweringoutput----code",headingTag:"h2"}}),oo=new h({props:{title:"pipelines~FillMaskPipelineType ⇒ <code> Promise. < (FillMaskOutput|Array < FillMaskOutput > ) > </code>",local:"pipelinesfillmaskpipelinetype--code-promise--fillmaskoutputarray--fillmaskoutput----code",headingTag:"h2"}}),ho=new h({props:{title:"pipelines~Text2TextGenerationPipelineType ⇒ <code> Promise. < (Text2TextGenerationOutput|Array < Text2TextGenerationOutput > ) > </code>",local:"pipelinestext2textgenerationpipelinetype--code-promise--text2textgenerationoutputarray--text2textgenerationoutput----code",headingTag:"h2"}}),bo=new h({props:{title:"pipelines~SummarizationPipelineType ⇒ <code> Promise. < (SummarizationOutput|Array < SummarizationOutput > ) > </code>",local:"pipelinessummarizationpipelinetype--code-promise--summarizationoutputarray--summarizationoutput----code",headingTag:"h2"}}),Ao=new h({props:{title:"pipelines~TranslationPipelineType ⇒ <code> Promise. < (TranslationOutput|Array < TranslationOutput > ) > </code>",local:"pipelinestranslationpipelinetype--code-promise--translationoutputarray--translationoutput----code",headingTag:"h2"}}),Go=new h({props:{title:"pipelines~TextGenerationPipelineType ⇒ <code> Promise. < (TextGenerationOutput|Array < TextGenerationOutput > ) > </code>",local:"pipelinestextgenerationpipelinetype--code-promise--textgenerationoutputarray--textgenerationoutput----code",headingTag:"h2"}}),Ro=new h({props:{title:"pipelines~ZeroShotClassificationPipelineType ⇒ <code> Promise. < (ZeroShotClassificationOutput|Array < ZeroShotClassificationOutput > ) > </code>",local:"pipelineszeroshotclassificationpipelinetype--code-promise--zeroshotclassificationoutputarray--zeroshotclassificationoutput----code",headingTag:"h2"}}),Fo=new h({props:{title:"pipelines~FeatureExtractionPipelineType ⇒ <code> Promise. < Tensor > </code>",local:"pipelinesfeatureextractionpipelinetype--code-promise--tensor--code",headingTag:"h2"}}),ld=new h({props:{title:"pipelines~ImageFeatureExtractionPipelineType ⇒ <code> Promise. < Tensor > </code>",local:"pipelinesimagefeatureextractionpipelinetype--code-promise--tensor--code",headingTag:"h2"}}),dd=new h({props:{title:"pipelines~AudioClassificationPipelineType ⇒ <code> Promise. < (AudioClassificationOutput|Array < AudioClassificationOutput > ) > </code>",local:"pipelinesaudioclassificationpipelinetype--code-promise--audioclassificationoutputarray--audioclassificationoutput----code",headingTag:"h2"}}),yd=new h({props:{title:"pipelines~ZeroShotAudioClassificationPipelineType ⇒ <code> Promise. < (Array < ZeroShotAudioClassificationOutput > |Array < Array < ZeroShotAudioClassificationOutput > > ) > </code>",local:"pipelineszeroshotaudioclassificationpipelinetype--code-promise--array--zeroshotaudioclassificationoutput--array--array--zeroshotaudioclassificationoutput-----code",headingTag:"h2"}}),bd=new h({props:{title:"pipelines~ChunkCallback : <code> function </code>",local:"pipelineschunkcallback--code-function-code",headingTag:"h2"}}),Id=new h({props:{title:"pipelines~Chunk : <code> Object </code>",local:"pipelineschunk--code-object-code",headingTag:"h2"}}),_d=new h({props:{title:"pipelines~AutomaticSpeechRecognitionPipelineType ⇒ <code> Promise. < (AutomaticSpeechRecognitionOutput|Array < AutomaticSpeechRecognitionOutput > ) > </code>",local:"pipelinesautomaticspeechrecognitionpipelinetype--code-promise--automaticspeechrecognitionoutputarray--automaticspeechrecognitionoutput----code",headingTag:"h2"}}),Bd=new h({props:{title:"pipelines~ImageToTextPipelineType ⇒ <code> Promise. < (ImageToTextOutput|Array < ImageToTextOutput > ) > </code>",local:"pipelinesimagetotextpipelinetype--code-promise--imagetotextoutputarray--imagetotextoutput----code",headingTag:"h2"}}),Ld=new h({props:{title:"pipelines~ImageClassificationPipelineType ⇒ <code> Promise. < (ImageClassificationOutput|Array < ImageClassificationOutput > ) > </code>",local:"pipelinesimageclassificationpipelinetype--code-promise--imageclassificationoutputarray--imageclassificationoutput----code",headingTag:"h2"}}),Od=new h({props:{title:"pipelines~ImageSegmentationPipelineType ⇒ <code> Promise. < Array < ImageSegmentationPipelineOutput > > </code>",local:"pipelinesimagesegmentationpipelinetype--code-promise--array--imagesegmentationpipelineoutput---code",headingTag:"h2"}}),nc=new h({props:{title:"pipelines~ZeroShotImageClassificationPipelineType ⇒ <code> Promise. < (Array < ZeroShotImageClassificationOutput > |Array < Array < ZeroShotImageClassificationOutput > > ) > </code>",local:"pipelineszeroshotimageclassificationpipelinetype--code-promise--array--zeroshotimageclassificationoutput--array--array--zeroshotimageclassificationoutput-----code",headingTag:"h2"}}),rc=new h({props:{title:"pipelines~ObjectDetectionPipelineType ⇒ <code> Promise. < (ObjectDetectionPipelineOutput|Array < ObjectDetectionPipelineOutput > ) > </code>",local:"pipelinesobjectdetectionpipelinetype--code-promise--objectdetectionpipelineoutputarray--objectdetectionpipelineoutput----code",headingTag:"h2"}}),Jc=new h({props:{title:"pipelines~ZeroShotObjectDetectionPipelineType ⇒ <code> Promise. < (Array < ZeroShotObjectDetectionOutput > |Array < Array < ZeroShotObjectDetectionOutput > > ) > </code>",local:"pipelineszeroshotobjectdetectionpipelinetype--code-promise--array--zeroshotobjectdetectionoutput--array--array--zeroshotobjectdetectionoutput-----code",headingTag:"h2"}}),gc=new h({props:{title:"pipelines~DocumentQuestionAnsweringPipelineType ⇒ <code> Promise. < (DocumentQuestionAnsweringOutput|Array < DocumentQuestionAnsweringOutput > ) > </code>",local:"pipelinesdocumentquestionansweringpipelinetype--code-promise--documentquestionansweringoutputarray--documentquestionansweringoutput----code",headingTag:"h2"}}),_c=new h({props:{title:"pipelines~TextToAudioPipelineConstructorArgs : <code> Object </code>",local:"pipelinestexttoaudiopipelineconstructorargs--code-object-code",headingTag:"h2"}}),Gc=new h({props:{title:"pipelines~TextToAudioPipelineType ⇒ <code> Promise. < TextToAudioOutput > </code>",local:"pipelinestexttoaudiopipelinetype--code-promise--texttoaudiooutput--code",headingTag:"h2"}}),Rc=new h({props:{title:"pipelines~ImageToImagePipelineType ⇒ <code> Promise. < (RawImage|Array < RawImage > ) > </code>",local:"pipelinesimagetoimagepipelinetype--code-promise--rawimagearray--rawimage----code",headingTag:"h2"}}),Wc=new h({props:{title:"pipelines~DepthEstimationPipelineType ⇒ <code> Promise. < (DepthEstimationPipelineOutput|Array < DepthEstimationPipelineOutput > ) > </code>",local:"pipelinesdepthestimationpipelinetype--code-promise--depthestimationpipelineoutputarray--depthestimationpipelineoutput----code",headingTag:"h2"}}),qc=new h({props:{title:"pipelines~AllTasks : <code> * </code>",local:"pipelinesalltasks--code--code",headingTag:"h2"}}),{c(){f=a("meta"),ir=n(),tr=a("p"),nr=n(),w=a("a"),sr=n(),c(j.$$.fragment),ar=n(),U=a("p"),U.textContent=tg,pr=n(),b=a("p"),b.innerHTML=lg,or=n(),c(x.$$.fragment),dr=n(),g=a("ul"),g.innerHTML=ig,cr=n(),rr=a("hr"),mr=n(),C=a("a"),ur=n(),c(I.$$.fragment),Mr=n(),k=a("p"),k.textContent=ng,Tr=n(),A=a("p"),A.innerHTML=sg,yr=n(),P=a("ul"),P.innerHTML=ag,hr=n(),Jr=a("hr"),fr=n(),_=a("a"),wr=n(),c($.$$.fragment),jr=n(),v=a("p"),v.textContent=pg,Ur=n(),Q=a("table"),Q.innerHTML=og,br=n(),xr=a("hr"),gr=n(),G=a("a"),Cr=n(),c(H.$$.fragment),Ir=n(),Z=a("p"),Z.innerHTML=dg,kr=n(),Ar=a("hr"),Pr=n(),B=a("a"),_r=n(),c(E.$$.fragment),$r=n(),N=a("p"),N.innerHTML=cg,vr=n(),Y=a("p"),Y.innerHTML=rg,Qr=n(),c(R.$$.fragment),Gr=n(),z=a("p"),z.innerHTML=mg,Hr=n(),c(L.$$.fragment),Zr=n(),S=a("p"),S.innerHTML=ug,Br=n(),c(W.$$.fragment),Er=n(),X=a("p"),X.innerHTML=Mg,Nr=n(),D=a("ul"),D.innerHTML=Tg,Yr=n(),Rr=a("hr"),zr=n(),F=a("a"),Lr=n(),c(V.$$.fragment),Sr=n(),O=a("p"),O.textContent=yg,Wr=n(),q=a("table"),q.innerHTML=hg,Xr=n(),Dr=a("hr"),Fr=n(),K=a("a"),Vr=n(),c(ee.$$.fragment),Or=n(),te=a("p"),te.innerHTML=Jg,qr=n(),Kr=a("hr"),em=n(),le=a("a"),tm=n(),c(ie.$$.fragment),lm=n(),ne=a("p"),ne.innerHTML=fg,im=n(),se=a("p"),se.innerHTML=wg,nm=n(),c(ae.$$.fragment),sm=n(),pe=a("p"),pe.innerHTML=jg,am=n(),c(oe.$$.fragment),pm=n(),de=a("p"),de.innerHTML=Ug,om=n(),ce=a("ul"),ce.innerHTML=bg,dm=n(),cm=a("hr"),rm=n(),re=a("a"),mm=n(),c(me.$$.fragment),um=n(),ue=a("p"),ue.textContent=xg,Mm=n(),Me=a("table"),Me.innerHTML=gg,Tm=n(),ym=a("hr"),hm=n(),Te=a("a"),Jm=n(),c(ye.$$.fragment),fm=n(),he=a("p"),he.innerHTML=Cg,wm=n(),jm=a("hr"),Um=n(),Je=a("a"),bm=n(),c(fe.$$.fragment),xm=n(),we=a("p"),we.innerHTML=Ig,gm=n(),je=a("p"),je.innerHTML=kg,Cm=n(),c(Ue.$$.fragment),Im=n(),be=a("p"),be.innerHTML=Ag,km=n(),xe=a("ul"),xe.innerHTML=Pg,Am=n(),Pm=a("hr"),_m=n(),ge=a("a"),$m=n(),c(Ce.$$.fragment),vm=n(),Ie=a("p"),Ie.textContent=_g,Qm=n(),ke=a("table"),ke.innerHTML=$g,Gm=n(),Hm=a("hr"),Zm=n(),Ae=a("a"),Bm=n(),c(Pe.$$.fragment),Em=n(),_e=a("p"),_e.innerHTML=vg,Nm=n(),Ym=a("hr"),Rm=n(),$e=a("a"),zm=n(),c(ve.$$.fragment),Lm=n(),Qe=a("p"),Qe.innerHTML=Qg,Sm=n(),Ge=a("p"),Ge.innerHTML=Gg,Wm=n(),c(He.$$.fragment),Xm=n(),Ze=a("p"),Ze.innerHTML=Hg,Dm=n(),c(Be.$$.fragment),Fm=n(),Ee=a("p"),Ee.innerHTML=Zg,Vm=n(),Ne=a("ul"),Ne.innerHTML=Bg,Om=n(),qm=a("hr"),Km=n(),Ye=a("a"),eu=n(),c(Re.$$.fragment),tu=n(),ze=a("p"),ze.textContent=Eg,lu=n(),Le=a("table"),Le.innerHTML=Ng,iu=n(),nu=a("hr"),su=n(),Se=a("a"),au=n(),c(We.$$.fragment),pu=n(),Xe=a("p"),Xe.innerHTML=Yg,ou=n(),du=a("hr"),cu=n(),De=a("a"),ru=n(),c(Fe.$$.fragment),mu=n(),Ve=a("p"),Ve.textContent=Rg,uu=n(),Oe=a("p"),Oe.innerHTML=zg,Mu=n(),c(qe.$$.fragment),Tu=n(),Ke=a("p"),Ke.innerHTML=Lg,yu=n(),et=a("ul"),et.innerHTML=Sg,hu=n(),Ju=a("hr"),fu=n(),tt=a("a"),wu=n(),c(lt.$$.fragment),ju=n(),it=a("p"),it.textContent=Wg,Uu=n(),nt=a("table"),nt.innerHTML=Xg,bu=n(),xu=a("hr"),gu=n(),st=a("a"),Cu=n(),c(at.$$.fragment),Iu=n(),pt=a("p"),pt.innerHTML=Dg,ku=n(),Au=a("hr"),Pu=n(),ot=a("a"),_u=n(),c(dt.$$.fragment),$u=n(),ct=a("p"),ct.innerHTML=Fg,vu=n(),Qu=a("hr"),Gu=n(),rt=a("a"),Hu=n(),c(mt.$$.fragment),Zu=n(),ut=a("p"),ut.textContent=Vg,Bu=n(),Mt=a("p"),Mt.innerHTML=Og,Eu=n(),c(Tt.$$.fragment),Nu=n(),yt=a("p"),yt.innerHTML=qg,Yu=n(),ht=a("ul"),ht.innerHTML=Kg,Ru=n(),zu=a("hr"),Lu=n(),Jt=a("a"),Su=n(),c(ft.$$.fragment),Wu=n(),wt=a("p"),wt.textContent=eC,Xu=n(),jt=a("table"),jt.innerHTML=tC,Du=n(),Fu=a("hr"),Vu=n(),Ut=a("a"),Ou=n(),c(bt.$$.fragment),qu=n(),xt=a("p"),xt.innerHTML=lC,Ku=n(),eM=a("hr"),tM=n(),gt=a("a"),lM=n(),c(Ct.$$.fragment),iM=n(),It=a("p"),It.textContent=iC,nM=n(),kt=a("p"),kt.innerHTML=nC,sM=n(),At=a("p"),At.innerHTML=sC,aM=n(),c(Pt.$$.fragment),pM=n(),_t=a("p"),_t.innerHTML=aC,oM=n(),$t=a("p"),$t.innerHTML=pC,dM=n(),c(vt.$$.fragment),cM=n(),Qt=a("p"),Qt.innerHTML=oC,rM=n(),Gt=a("p"),Gt.innerHTML=dC,mM=n(),c(Ht.$$.fragment),uM=n(),Zt=a("p"),Zt.innerHTML=cC,MM=n(),Bt=a("ul"),Bt.innerHTML=rC,TM=n(),yM=a("hr"),hM=n(),Et=a("a"),JM=n(),c(Nt.$$.fragment),fM=n(),Yt=a("p"),Yt.textContent=mC,wM=n(),Rt=a("table"),Rt.innerHTML=uC,jM=n(),UM=a("hr"),bM=n(),zt=a("a"),xM=n(),c(Lt.$$.fragment),gM=n(),St=a("p"),St.innerHTML=MC,CM=n(),IM=a("hr"),kM=n(),Wt=a("a"),AM=n(),c(Xt.$$.fragment),PM=n(),Dt=a("p"),Dt.innerHTML=TC,_M=n(),Ft=a("p"),Ft.innerHTML=yC,$M=n(),c(Vt.$$.fragment),vM=n(),Ot=a("p"),Ot.innerHTML=hC,QM=n(),c(qt.$$.fragment),GM=n(),Kt=a("p"),Kt.innerHTML=JC,HM=n(),c(el.$$.fragment),ZM=n(),tl=a("p"),tl.innerHTML=fC,BM=n(),ll=a("ul"),ll.innerHTML=wC,EM=n(),NM=a("hr"),YM=n(),il=a("a"),RM=n(),c(nl.$$.fragment),zM=n(),sl=a("p"),sl.textContent=jC,LM=n(),al=a("table"),al.innerHTML=UC,SM=n(),WM=a("hr"),XM=n(),pl=a("a"),DM=n(),c(ol.$$.fragment),FM=n(),dl=a("p"),dl.innerHTML=bC,VM=n(),OM=a("hr"),qM=n(),cl=a("a"),KM=n(),c(rl.$$.fragment),eT=n(),ml=a("p"),ml.innerHTML=xC,tT=n(),ul=a("p"),ul.innerHTML=gC,lT=n(),c(Ml.$$.fragment),iT=n(),Tl=a("p"),Tl.innerHTML=CC,nT=n(),c(yl.$$.fragment),sT=n(),hl=a("p"),hl.innerHTML=IC,aT=n(),Jl=a("ul"),Jl.innerHTML=kC,pT=n(),oT=a("hr"),dT=n(),fl=a("a"),cT=n(),c(wl.$$.fragment),rT=n(),jl=a("p"),jl.textContent=AC,mT=n(),Ul=a("table"),Ul.innerHTML=PC,uT=n(),MT=a("hr"),TT=n(),bl=a("a"),yT=n(),c(xl.$$.fragment),hT=n(),gl=a("p"),gl.innerHTML=_C,JT=n(),fT=a("hr"),wT=n(),Cl=a("a"),jT=n(),c(Il.$$.fragment),UT=n(),kl=a("p"),kl.innerHTML=$C,bT=n(),xT=a("hr"),gT=n(),Al=a("a"),CT=n(),c(Pl.$$.fragment),IT=n(),_l=a("p"),_l.textContent=vC,kT=n(),$l=a("p"),$l.innerHTML=QC,AT=n(),c(vl.$$.fragment),PT=n(),Ql=a("p"),Ql.innerHTML=GC,_T=n(),c(Gl.$$.fragment),$T=n(),Hl=a("p"),Hl.innerHTML=HC,vT=n(),c(Zl.$$.fragment),QT=n(),Bl=a("p"),Bl.innerHTML=ZC,GT=n(),c(El.$$.fragment),HT=n(),Nl=a("p"),Nl.innerHTML=BC,ZT=n(),Yl=a("ul"),Yl.innerHTML=EC,BT=n(),ET=a("hr"),NT=n(),Rl=a("a"),YT=n(),c(zl.$$.fragment),RT=n(),Ll=a("p"),Ll.textContent=NC,zT=n(),Sl=a("table"),Sl.innerHTML=YC,LT=n(),ST=a("hr"),WT=n(),Wl=a("a"),XT=n(),c(Xl.$$.fragment),DT=n(),Dl=a("p"),Dl.innerHTML=RC,FT=n(),VT=a("hr"),OT=n(),Fl=a("a"),qT=n(),c(Vl.$$.fragment),KT=n(),Ol=a("p"),Ol.textContent=zC,ey=n(),ql=a("p"),ql.innerHTML=LC,ty=n(),c(Kl.$$.fragment),ly=n(),ei=a("p"),ei.innerHTML=SC,iy=n(),c(ti.$$.fragment),ny=n(),li=a("p"),li.innerHTML=WC,sy=n(),ii=a("ul"),ii.innerHTML=XC,ay=n(),py=a("hr"),oy=n(),ni=a("a"),dy=n(),c(si.$$.fragment),cy=n(),ai=a("p"),ai.textContent=DC,ry=n(),pi=a("table"),pi.innerHTML=FC,my=n(),uy=a("hr"),My=n(),oi=a("a"),Ty=n(),c(di.$$.fragment),yy=n(),ci=a("p"),ci.innerHTML=VC,hy=n(),Jy=a("hr"),fy=n(),ri=a("a"),wy=n(),c(mi.$$.fragment),jy=n(),ui=a("p"),ui.innerHTML=OC,Uy=n(),Mi=a("p"),Mi.innerHTML=qC,by=n(),c(Ti.$$.fragment),xy=n(),yi=a("p"),yi.innerHTML=KC,gy=n(),c(hi.$$.fragment),Cy=n(),Ji=a("p"),Ji.innerHTML=e0,Iy=n(),fi=a("ul"),fi.innerHTML=t0,ky=n(),Ay=a("hr"),Py=n(),wi=a("a"),_y=n(),c(ji.$$.fragment),$y=n(),Ui=a("p"),Ui.textContent=l0,vy=n(),bi=a("table"),bi.innerHTML=i0,Qy=n(),Gy=a("hr"),Hy=n(),xi=a("a"),Zy=n(),c(gi.$$.fragment),By=n(),Ci=a("p"),Ci.innerHTML=n0,Ey=n(),Ny=a("hr"),Yy=n(),Ii=a("a"),Ry=n(),c(ki.$$.fragment),zy=n(),Ai=a("p"),Ai.innerHTML=s0,Ly=n(),Pi=a("p"),Pi.innerHTML=a0,Sy=n(),c(_i.$$.fragment),Wy=n(),$i=a("p"),$i.innerHTML=p0,Xy=n(),vi=a("ul"),vi.innerHTML=o0,Dy=n(),Fy=a("hr"),Vy=n(),Qi=a("a"),Oy=n(),c(Gi.$$.fragment),qy=n(),Hi=a("p"),Hi.textContent=d0,Ky=n(),Zi=a("table"),Zi.innerHTML=c0,eh=n(),th=a("hr"),lh=n(),Bi=a("a"),ih=n(),c(Ei.$$.fragment),nh=n(),Ni=a("p"),Ni.innerHTML=r0,sh=n(),ah=a("hr"),ph=n(),Yi=a("a"),oh=n(),c(Ri.$$.fragment),dh=n(),zi=a("p"),zi.textContent=m0,ch=n(),Li=a("p"),Li.innerHTML=u0,rh=n(),c(Si.$$.fragment),mh=n(),Wi=a("p"),Wi.innerHTML=M0,uh=n(),c(Xi.$$.fragment),Mh=n(),Di=a("p"),Di.innerHTML=T0,Th=n(),c(Fi.$$.fragment),yh=n(),Vi=a("p"),Vi.innerHTML=y0,hh=n(),c(Oi.$$.fragment),Jh=n(),qi=a("p"),qi.innerHTML=h0,fh=n(),c(Ki.$$.fragment),wh=n(),en=a("p"),en.innerHTML=J0,jh=n(),c(tn.$$.fragment),Uh=n(),ln=a("p"),ln.innerHTML=f0,bh=n(),nn=a("ul"),nn.innerHTML=w0,xh=n(),gh=a("hr"),Ch=n(),sn=a("a"),Ih=n(),c(an.$$.fragment),kh=n(),pn=a("p"),pn.textContent=j0,Ah=n(),on=a("table"),on.innerHTML=U0,Ph=n(),_h=a("hr"),$h=n(),dn=a("a"),vh=n(),c(cn.$$.fragment),Qh=n(),rn=a("p"),rn.innerHTML=b0,Gh=n(),Hh=a("hr"),Zh=n(),mn=a("a"),Bh=n(),c(un.$$.fragment),Eh=n(),Mn=a("p"),Mn.innerHTML=x0,Nh=n(),Tn=a("p"),Tn.innerHTML=g0,Yh=n(),c(yn.$$.fragment),Rh=n(),hn=a("p"),hn.innerHTML=C0,zh=n(),c(Jn.$$.fragment),Lh=n(),fn=a("p"),fn.innerHTML=I0,Sh=n(),wn=a("ul"),wn.innerHTML=k0,Wh=n(),Xh=a("hr"),Dh=n(),jn=a("a"),Fh=n(),c(Un.$$.fragment),Vh=n(),bn=a("p"),bn.textContent=A0,Oh=n(),xn=a("table"),xn.innerHTML=P0,qh=n(),Kh=a("hr"),eJ=n(),gn=a("a"),tJ=n(),c(Cn.$$.fragment),lJ=n(),In=a("p"),In.innerHTML=_0,iJ=n(),nJ=a("hr"),sJ=n(),kn=a("a"),aJ=n(),c(An.$$.fragment),pJ=n(),Pn=a("p"),Pn.innerHTML=$0,oJ=n(),_n=a("p"),_n.innerHTML=v0,dJ=n(),c($n.$$.fragment),cJ=n(),vn=a("p"),vn.innerHTML=Q0,rJ=n(),c(Qn.$$.fragment),mJ=n(),Gn=a("p"),Gn.innerHTML=G0,uJ=n(),c(Hn.$$.fragment),MJ=n(),Zn=a("p"),Zn.innerHTML=H0,TJ=n(),Bn=a("ul"),Bn.innerHTML=Z0,yJ=n(),hJ=a("hr"),JJ=n(),En=a("a"),fJ=n(),c(Nn.$$.fragment),wJ=n(),Yn=a("p"),Yn.textContent=B0,jJ=n(),Rn=a("table"),Rn.innerHTML=E0,UJ=n(),bJ=a("hr"),xJ=n(),zn=a("a"),gJ=n(),c(Ln.$$.fragment),CJ=n(),Sn=a("p"),Sn.innerHTML=N0,IJ=n(),kJ=a("hr"),AJ=n(),Wn=a("a"),PJ=n(),c(Xn.$$.fragment),_J=n(),Dn=a("p"),Dn.innerHTML=Y0,$J=n(),Fn=a("p"),Fn.innerHTML=R0,vJ=n(),c(Vn.$$.fragment),QJ=n(),On=a("p"),On.innerHTML=z0,GJ=n(),qn=a("ul"),qn.innerHTML=L0,HJ=n(),ZJ=a("hr"),BJ=n(),Kn=a("a"),EJ=n(),c(es.$$.fragment),NJ=n(),ts=a("p"),ts.textContent=S0,YJ=n(),ls=a("table"),ls.innerHTML=W0,RJ=n(),zJ=a("hr"),LJ=n(),is=a("a"),SJ=n(),c(ns.$$.fragment),WJ=n(),ss=a("p"),ss.innerHTML=X0,XJ=n(),DJ=a("hr"),FJ=n(),as=a("a"),VJ=n(),c(ps.$$.fragment),OJ=n(),os=a("p"),os.innerHTML=D0,qJ=n(),ds=a("p"),ds.innerHTML=F0,KJ=n(),c(cs.$$.fragment),ef=n(),rs=a("p"),rs.innerHTML=V0,tf=n(),ms=a("ul"),ms.innerHTML=O0,lf=n(),nf=a("hr"),sf=n(),us=a("a"),af=n(),c(Ms.$$.fragment),pf=n(),Ts=a("p"),Ts.textContent=q0,of=n(),ys=a("table"),ys.innerHTML=K0,df=n(),cf=a("hr"),rf=n(),hs=a("a"),mf=n(),c(Js.$$.fragment),uf=n(),fs=a("p"),fs.innerHTML=eI,Mf=n(),Tf=a("hr"),yf=n(),ws=a("a"),hf=n(),c(js.$$.fragment),Jf=n(),Us=a("p"),Us.innerHTML=tI,ff=n(),bs=a("p"),bs.innerHTML=lI,wf=n(),c(xs.$$.fragment),jf=n(),gs=a("p"),gs.innerHTML=iI,Uf=n(),Cs=a("ul"),Cs.innerHTML=nI,bf=n(),xf=a("hr"),gf=n(),Is=a("a"),Cf=n(),c(ks.$$.fragment),If=n(),As=a("p"),As.textContent=sI,kf=n(),Ps=a("table"),Ps.innerHTML=aI,Af=n(),Pf=a("hr"),_f=n(),_s=a("a"),$f=n(),c($s.$$.fragment),vf=n(),vs=a("p"),vs.innerHTML=pI,Qf=n(),Gf=a("hr"),Hf=n(),Qs=a("a"),Zf=n(),c(Gs.$$.fragment),Bf=n(),Hs=a("p"),Hs.innerHTML=oI,Ef=n(),Zs=a("p"),Zs.innerHTML=dI,Nf=n(),c(Bs.$$.fragment),Yf=n(),Es=a("p"),Es.innerHTML=cI,Rf=n(),c(Ns.$$.fragment),zf=n(),Ys=a("p"),Ys.innerHTML=rI,Lf=n(),Rs=a("ul"),Rs.innerHTML=mI,Sf=n(),Wf=a("hr"),Xf=n(),zs=a("a"),Df=n(),c(Ls.$$.fragment),Ff=n(),Ss=a("p"),Ss.textContent=uI,Vf=n(),Ws=a("table"),Ws.innerHTML=MI,Of=n(),qf=a("hr"),Kf=n(),Xs=a("a"),ew=n(),c(Ds.$$.fragment),tw=n(),Fs=a("p"),Fs.innerHTML=TI,lw=n(),iw=a("hr"),nw=n(),Vs=a("a"),sw=n(),c(Os.$$.fragment),aw=n(),qs=a("p"),qs.innerHTML=yI,pw=n(),Ks=a("p"),Ks.innerHTML=hI,ow=n(),c(ea.$$.fragment),dw=n(),ta=a("p"),ta.innerHTML=JI,cw=n(),la=a("ul"),la.innerHTML=fI,rw=n(),mw=a("hr"),uw=n(),ia=a("a"),Mw=n(),c(na.$$.fragment),Tw=n(),sa=a("p"),sa.textContent=wI,yw=n(),aa=a("table"),aa.innerHTML=jI,hw=n(),Jw=a("hr"),fw=n(),pa=a("a"),ww=n(),c(oa.$$.fragment),jw=n(),da=a("p"),da.innerHTML=UI,Uw=n(),bw=a("hr"),xw=n(),ca=a("a"),gw=n(),c(ra.$$.fragment),Cw=n(),ma=a("p"),ma.innerHTML=bI,Iw=n(),ua=a("p"),ua.innerHTML=xI,kw=n(),c(Ma.$$.fragment),Aw=n(),Ta=a("p"),Ta.innerHTML=gI,Pw=n(),c(ya.$$.fragment),_w=n(),ha=a("p"),ha.innerHTML=CI,$w=n(),c(Ja.$$.fragment),vw=n(),fa=a("p"),fa.innerHTML=II,Qw=n(),wa=a("ul"),wa.innerHTML=kI,Gw=n(),Hw=a("hr"),Zw=n(),ja=a("a"),Bw=n(),c(Ua.$$.fragment),Ew=n(),ba=a("p"),ba.textContent=AI,Nw=n(),xa=a("table"),xa.innerHTML=PI,Yw=n(),Rw=a("hr"),zw=n(),ga=a("a"),Lw=n(),c(Ca.$$.fragment),Sw=n(),Ia=a("p"),Ia.innerHTML=_I,Ww=n(),Xw=a("hr"),Dw=n(),ka=a("a"),Fw=n(),c(Aa.$$.fragment),Vw=n(),Pa=a("p"),Pa.innerHTML=$I,Ow=n(),_a=a("p"),_a.innerHTML=vI,qw=n(),c($a.$$.fragment),Kw=n(),va=a("p"),va.innerHTML=QI,e2=n(),Qa=a("ul"),Qa.innerHTML=GI,t2=n(),l2=a("hr"),i2=n(),Ga=a("a"),n2=n(),c(Ha.$$.fragment),s2=n(),Za=a("p"),Za.textContent=HI,a2=n(),Ba=a("table"),Ba.innerHTML=ZI,p2=n(),o2=a("hr"),d2=n(),Ea=a("a"),c2=n(),c(Na.$$.fragment),r2=n(),Ya=a("p"),Ya.innerHTML=BI,m2=n(),u2=a("hr"),M2=n(),Ra=a("a"),T2=n(),c(za.$$.fragment),y2=n(),La=a("p"),La.innerHTML=EI,h2=n(),Sa=a("p"),Sa.innerHTML=NI,J2=n(),c(Wa.$$.fragment),f2=n(),Xa=a("p"),Xa.innerHTML=YI,w2=n(),Da=a("ul"),Da.innerHTML=RI,j2=n(),U2=a("hr"),b2=n(),Fa=a("a"),x2=n(),c(Va.$$.fragment),g2=n(),Oa=a("p"),Oa.textContent=zI,C2=n(),qa=a("table"),qa.innerHTML=LI,I2=n(),k2=a("hr"),A2=n(),Ka=a("a"),P2=n(),c(ep.$$.fragment),_2=n(),tp=a("p"),tp.innerHTML=SI,$2=n(),v2=a("hr"),Q2=n(),lp=a("a"),G2=n(),c(ip.$$.fragment),H2=n(),np=a("p"),np.innerHTML=WI,Z2=n(),sp=a("p"),sp.innerHTML=XI,B2=n(),ap=a("ul"),ap.innerHTML=DI,E2=n(),pp=a("table"),pp.innerHTML=FI,N2=n(),Y2=a("hr"),R2=n(),op=a("a"),z2=n(),c(dp.$$.fragment),L2=n(),cp=a("p"),cp.innerHTML=VI,S2=n(),W2=a("hr"),X2=n(),rp=a("a"),D2=n(),c(mp.$$.fragment),F2=n(),up=a("p"),up.innerHTML=OI,V2=n(),O2=a("hr"),q2=n(),Mp=a("a"),K2=n(),c(Tp.$$.fragment),ej=n(),yp=a("p"),yp.innerHTML=qI,tj=n(),lj=a("hr"),ij=n(),hp=a("a"),nj=n(),c(Jp.$$.fragment),sj=n(),fp=a("p"),fp.innerHTML=KI,aj=n(),wp=a("table"),wp.innerHTML=e3,pj=n(),oj=a("hr"),dj=n(),jp=a("a"),cj=n(),c(Up.$$.fragment),rj=n(),bp=a("p"),bp.innerHTML=t3,mj=n(),xp=a("table"),xp.innerHTML=l3,uj=n(),Mj=a("hr"),Tj=n(),gp=a("a"),yj=n(),c(Cp.$$.fragment),hj=n(),Ip=a("p"),Ip.textContent=i3,Jj=n(),kp=a("p"),kp.innerHTML=n3,fj=n(),Ap=a("table"),Ap.innerHTML=s3,wj=n(),jj=a("hr"),Uj=n(),Pp=a("a"),bj=n(),c(_p.$$.fragment),xj=n(),$p=a("p"),$p.textContent=a3,gj=n(),vp=a("p"),vp.innerHTML=p3,Cj=n(),Qp=a("table"),Qp.innerHTML=o3,Ij=n(),kj=a("hr"),Aj=n(),Gp=a("a"),Pj=n(),c(Hp.$$.fragment),_j=n(),Zp=a("p"),Zp.textContent=d3,$j=n(),Bp=a("p"),Bp.innerHTML=c3,vj=n(),Ep=a("table"),Ep.innerHTML=r3,Qj=n(),Gj=a("hr"),Hj=n(),Np=a("a"),Zj=n(),c(Yp.$$.fragment),Bj=n(),Rp=a("p"),Rp.textContent=m3,Ej=n(),zp=a("p"),zp.innerHTML=u3,Nj=n(),Lp=a("table"),Lp.innerHTML=M3,Yj=n(),Sp=a("p"),Sp.innerHTML=T3,Rj=n(),Wp=a("table"),Wp.innerHTML=y3,zj=n(),Lj=a("hr"),Sj=n(),Xp=a("a"),Wj=n(),c(Dp.$$.fragment),Xj=n(),Fp=a("p"),Fp.textContent=h3,Dj=n(),Vp=a("p"),Vp.innerHTML=J3,Fj=n(),Op=a("table"),Op.innerHTML=f3,Vj=n(),qp=a("p"),qp.innerHTML=w3,Oj=n(),Kp=a("table"),Kp.innerHTML=j3,qj=n(),Kj=a("hr"),eU=n(),eo=a("a"),tU=n(),c(to.$$.fragment),lU=n(),lo=a("p"),lo.textContent=U3,iU=n(),io=a("p"),io.innerHTML=b3,nU=n(),no=a("table"),no.innerHTML=x3,sU=n(),so=a("p"),so.innerHTML=g3,aU=n(),ao=a("table"),ao.innerHTML=C3,pU=n(),oU=a("hr"),dU=n(),po=a("a"),cU=n(),c(oo.$$.fragment),rU=n(),co=a("p"),co.textContent=I3,mU=n(),ro=a("p"),ro.innerHTML=k3,uU=n(),mo=a("ul"),mo.innerHTML=A3,MU=n(),uo=a("table"),uo.innerHTML=P3,TU=n(),Mo=a("p"),Mo.innerHTML=_3,yU=n(),To=a("table"),To.innerHTML=$3,hU=n(),JU=a("hr"),fU=n(),yo=a("a"),wU=n(),c(ho.$$.fragment),jU=n(),Jo=a("p"),Jo.innerHTML=v3,UU=n(),fo=a("table"),fo.innerHTML=Q3,bU=n(),wo=a("p"),wo.innerHTML=G3,xU=n(),jo=a("table"),jo.innerHTML=H3,gU=n(),CU=a("hr"),IU=n(),Uo=a("a"),kU=n(),c(bo.$$.fragment),AU=n(),xo=a("p"),xo.innerHTML=Z3,PU=n(),go=a("table"),go.innerHTML=B3,_U=n(),Co=a("p"),Co.innerHTML=E3,$U=n(),Io=a("table"),Io.innerHTML=N3,vU=n(),QU=a("hr"),GU=n(),ko=a("a"),HU=n(),c(Ao.$$.fragment),ZU=n(),Po=a("p"),Po.innerHTML=Y3,BU=n(),_o=a("table"),_o.innerHTML=R3,EU=n(),$o=a("p"),$o.innerHTML=z3,NU=n(),vo=a("table"),vo.innerHTML=L3,YU=n(),RU=a("hr"),zU=n(),Qo=a("a"),LU=n(),c(Go.$$.fragment),SU=n(),Ho=a("p"),Ho.textContent=S3,WU=n(),Zo=a("p"),Zo.innerHTML=W3,XU=n(),Bo=a("table"),Bo.innerHTML=X3,DU=n(),Eo=a("p"),Eo.innerHTML=D3,FU=n(),No=a("table"),No.innerHTML=F3,VU=n(),OU=a("hr"),qU=n(),Yo=a("a"),KU=n(),c(Ro.$$.fragment),eb=n(),zo=a("p"),zo.textContent=V3,tb=n(),Lo=a("p"),Lo.innerHTML=O3,lb=n(),So=a("table"),So.innerHTML=q3,ib=n(),Wo=a("p"),Wo.innerHTML=K3,nb=n(),Xo=a("table"),Xo.innerHTML=ek,sb=n(),ab=a("hr"),pb=n(),Do=a("a"),ob=n(),c(Fo.$$.fragment),db=n(),Vo=a("p"),Vo.textContent=tk,cb=n(),Oo=a("p"),Oo.innerHTML=lk,rb=n(),qo=a("table"),qo.innerHTML=ik,mb=n(),Ko=a("p"),Ko.innerHTML=nk,ub=n(),ed=a("table"),ed.innerHTML=sk,Mb=n(),Tb=a("hr"),yb=n(),td=a("a"),hb=n(),c(ld.$$.fragment),Jb=n(),id=a("p"),id.textContent=ak,fb=n(),nd=a("p"),nd.innerHTML=pk,wb=n(),sd=a("table"),sd.innerHTML=ok,jb=n(),ad=a("p"),ad.innerHTML=dk,Ub=n(),pd=a("table"),pd.innerHTML=ck,bb=n(),xb=a("hr"),gb=n(),od=a("a"),Cb=n(),c(dd.$$.fragment),Ib=n(),cd=a("p"),cd.textContent=rk,kb=n(),rd=a("p"),rd.innerHTML=mk,Ab=n(),md=a("table"),md.innerHTML=uk,Pb=n(),ud=a("p"),ud.innerHTML=Mk,_b=n(),Md=a("table"),Md.innerHTML=Tk,$b=n(),vb=a("hr"),Qb=n(),Td=a("a"),Gb=n(),c(yd.$$.fragment),Hb=n(),hd=a("p"),hd.textContent=yk,Zb=n(),Jd=a("p"),Jd.innerHTML=hk,Bb=n(),fd=a("table"),fd.innerHTML=Jk,Eb=n(),wd=a("p"),wd.innerHTML=fk,Nb=n(),jd=a("table"),jd.innerHTML=wk,Yb=n(),Rb=a("hr"),zb=n(),Ud=a("a"),Lb=n(),c(bd.$$.fragment),Sb=n(),xd=a("p"),xd.innerHTML=jk,Wb=n(),gd=a("table"),gd.innerHTML=Uk,Xb=n(),Db=a("hr"),Fb=n(),Cd=a("a"),Vb=n(),c(Id.$$.fragment),Ob=n(),kd=a("p"),kd.innerHTML=bk,qb=n(),Ad=a("table"),Ad.innerHTML=xk,Kb=n(),ex=a("hr"),tx=n(),Pd=a("a"),lx=n(),c(_d.$$.fragment),ix=n(),$d=a("p"),$d.textContent=gk,nx=n(),vd=a("p"),vd.innerHTML=Ck,sx=n(),Qd=a("table"),Qd.innerHTML=Ik,ax=n(),Gd=a("p"),Gd.innerHTML=kk,px=n(),Hd=a("table"),Hd.innerHTML=Ak,ox=n(),dx=a("hr"),cx=n(),Zd=a("a"),rx=n(),c(Bd.$$.fragment),mx=n(),Ed=a("p"),Ed.innerHTML=Pk,ux=n(),Nd=a("table"),Nd.innerHTML=_k,Mx=n(),Yd=a("p"),Yd.innerHTML=$k,Tx=n(),Rd=a("table"),Rd.innerHTML=vk,yx=n(),hx=a("hr"),Jx=n(),zd=a("a"),fx=n(),c(Ld.$$.fragment),wx=n(),Sd=a("p"),Sd.textContent=Qk,jx=n(),Wd=a("p"),Wd.innerHTML=Gk,Ux=n(),Xd=a("table"),Xd.innerHTML=Hk,bx=n(),Dd=a("p"),Dd.innerHTML=Zk,xx=n(),Fd=a("table"),Fd.innerHTML=Bk,gx=n(),Cx=a("hr"),Ix=n(),Vd=a("a"),kx=n(),c(Od.$$.fragment),Ax=n(),qd=a("p"),qd.textContent=Ek,Px=n(),Kd=a("p"),Kd.innerHTML=Nk,_x=n(),ec=a("table"),ec.innerHTML=Yk,$x=n(),tc=a("p"),tc.innerHTML=Rk,vx=n(),lc=a("table"),lc.innerHTML=zk,Qx=n(),Gx=a("hr"),Hx=n(),ic=a("a"),Zx=n(),c(nc.$$.fragment),Bx=n(),sc=a("p"),sc.textContent=Lk,Ex=n(),ac=a("p"),ac.innerHTML=Sk,Nx=n(),pc=a("table"),pc.innerHTML=Wk,Yx=n(),oc=a("p"),oc.innerHTML=Xk,Rx=n(),dc=a("table"),dc.innerHTML=Dk,zx=n(),Lx=a("hr"),Sx=n(),cc=a("a"),Wx=n(),c(rc.$$.fragment),Xx=n(),mc=a("p"),mc.textContent=Fk,Dx=n(),uc=a("p"),uc.innerHTML=Vk,Fx=n(),Mc=a("table"),Mc.innerHTML=Ok,Vx=n(),Tc=a("p"),Tc.innerHTML=qk,Ox=n(),yc=a("table"),yc.innerHTML=Kk,qx=n(),Kx=a("hr"),e1=n(),hc=a("a"),t1=n(),c(Jc.$$.fragment),l1=n(),fc=a("p"),fc.textContent=eA,i1=n(),wc=a("p"),wc.innerHTML=tA,n1=n(),jc=a("table"),jc.innerHTML=lA,s1=n(),Uc=a("p"),Uc.innerHTML=iA,a1=n(),bc=a("table"),bc.innerHTML=nA,p1=n(),o1=a("hr"),d1=n(),xc=a("a"),c1=n(),c(gc.$$.fragment),r1=n(),Cc=a("p"),Cc.innerHTML=sA,m1=n(),Ic=a("table"),Ic.innerHTML=aA,u1=n(),kc=a("p"),kc.innerHTML=pA,M1=n(),Ac=a("table"),Ac.innerHTML=oA,T1=n(),y1=a("hr"),h1=n(),Pc=a("a"),J1=n(),c(_c.$$.fragment),f1=n(),$c=a("p"),$c.innerHTML=dA,w1=n(),vc=a("table"),vc.innerHTML=cA,j1=n(),U1=a("hr"),b1=n(),Qc=a("a"),x1=n(),c(Gc.$$.fragment),g1=n(),Hc=a("p"),Hc.textContent=rA,C1=n(),Zc=a("p"),Zc.innerHTML=mA,I1=n(),Bc=a("table"),Bc.innerHTML=uA,k1=n(),Ec=a("p"),Ec.innerHTML=MA,A1=n(),Nc=a("table"),Nc.innerHTML=TA,P1=n(),_1=a("hr"),$1=n(),Yc=a("a"),v1=n(),c(Rc.$$.fragment),Q1=n(),zc=a("p"),zc.innerHTML=yA,G1=n(),Lc=a("table"),Lc.innerHTML=hA,H1=n(),Z1=a("hr"),B1=n(),Sc=a("a"),E1=n(),c(Wc.$$.fragment),N1=n(),Xc=a("p"),Xc.innerHTML=JA,Y1=n(),Dc=a("table"),Dc.innerHTML=fA,R1=n(),Fc=a("p"),Fc.innerHTML=wA,z1=n(),Vc=a("table"),Vc.innerHTML=jA,L1=n(),S1=a("hr"),W1=n(),Oc=a("a"),X1=n(),c(qc.$$.fragment),D1=n(),Kc=a("p"),Kc.textContent=UA,F1=n(),er=a("p"),er.innerHTML=bA,V1=n(),O1=a("hr"),q1=n(),lr=a("p"),this.h()},l(e){const t=AA("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(l),ir=s(e),tr=p(e,"P",{}),y(tr).forEach(l),nr=s(e),w=p(e,"A",{id:!0,class:!0}),y(w).forEach(l),sr=s(e),r(j.$$.fragment,e),ar=s(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1inm2t9"&&(U.textContent=tg),pr=s(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1pjech"&&(b.innerHTML=lg),or=s(e),r(x.$$.fragment,e),dr=s(e),g=p(e,"UL",{"data-svelte-h":!0}),o(g)!=="svelte-1wg5j54"&&(g.innerHTML=ig),cr=s(e),rr=p(e,"HR",{}),mr=s(e),C=p(e,"A",{id:!0,class:!0}),y(C).forEach(l),ur=s(e),r(I.$$.fragment,e),Mr=s(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-16ix8v2"&&(k.textContent=ng),Tr=s(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1olpg2f"&&(A.innerHTML=sg),yr=s(e),P=p(e,"UL",{"data-svelte-h":!0}),o(P)!=="svelte-gpyczg"&&(P.innerHTML=ag),hr=s(e),Jr=p(e,"HR",{}),fr=s(e),_=p(e,"A",{id:!0,class:!0}),y(_).forEach(l),wr=s(e),r($.$$.fragment,e),jr=s(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-10jkwj"&&(v.textContent=pg),Ur=s(e),Q=p(e,"TABLE",{"data-svelte-h":!0}),o(Q)!=="svelte-z7lv5w"&&(Q.innerHTML=og),br=s(e),xr=p(e,"HR",{}),gr=s(e),G=p(e,"A",{id:!0,class:!0}),y(G).forEach(l),Cr=s(e),r(H.$$.fragment,e),Ir=s(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-hhwo7"&&(Z.innerHTML=dg),kr=s(e),Ar=p(e,"HR",{}),Pr=s(e),B=p(e,"A",{id:!0,class:!0}),y(B).forEach(l),_r=s(e),r(E.$$.fragment,e),$r=s(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1aega0x"&&(N.innerHTML=cg),vr=s(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-twv4w2"&&(Y.innerHTML=rg),Qr=s(e),r(R.$$.fragment,e),Gr=s(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-9l8wqs"&&(z.innerHTML=mg),Hr=s(e),r(L.$$.fragment,e),Zr=s(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-63pkoo"&&(S.innerHTML=ug),Br=s(e),r(W.$$.fragment,e),Er=s(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-s10qq4"&&(X.innerHTML=Mg),Nr=s(e),D=p(e,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-pm72j5"&&(D.innerHTML=Tg),Yr=s(e),Rr=p(e,"HR",{}),zr=s(e),F=p(e,"A",{id:!0,class:!0}),y(F).forEach(l),Lr=s(e),r(V.$$.fragment,e),Sr=s(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-i7tdq8"&&(O.textContent=yg),Wr=s(e),q=p(e,"TABLE",{"data-svelte-h":!0}),o(q)!=="svelte-1iu6wl4"&&(q.innerHTML=hg),Xr=s(e),Dr=p(e,"HR",{}),Fr=s(e),K=p(e,"A",{id:!0,class:!0}),y(K).forEach(l),Vr=s(e),r(ee.$$.fragment,e),Or=s(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-10suosj"&&(te.innerHTML=Jg),qr=s(e),Kr=p(e,"HR",{}),em=s(e),le=p(e,"A",{id:!0,class:!0}),y(le).forEach(l),tm=s(e),r(ie.$$.fragment,e),lm=s(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-199l8oj"&&(ne.innerHTML=fg),im=s(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-3ojewp"&&(se.innerHTML=wg),nm=s(e),r(ae.$$.fragment,e),sm=s(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1ln7q61"&&(pe.innerHTML=jg),am=s(e),r(oe.$$.fragment,e),pm=s(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-s10qq4"&&(de.innerHTML=Ug),om=s(e),ce=p(e,"UL",{"data-svelte-h":!0}),o(ce)!=="svelte-m3wy8r"&&(ce.innerHTML=bg),dm=s(e),cm=p(e,"HR",{}),rm=s(e),re=p(e,"A",{id:!0,class:!0}),y(re).forEach(l),mm=s(e),r(me.$$.fragment,e),um=s(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1qyf5iw"&&(ue.textContent=xg),Mm=s(e),Me=p(e,"TABLE",{"data-svelte-h":!0}),o(Me)!=="svelte-1iu6wl4"&&(Me.innerHTML=gg),Tm=s(e),ym=p(e,"HR",{}),hm=s(e),Te=p(e,"A",{id:!0,class:!0}),y(Te).forEach(l),Jm=s(e),r(ye.$$.fragment,e),fm=s(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1fnwy8z"&&(he.innerHTML=Cg),wm=s(e),jm=p(e,"HR",{}),Um=s(e),Je=p(e,"A",{id:!0,class:!0}),y(Je).forEach(l),bm=s(e),r(fe.$$.fragment,e),xm=s(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-14f3xkz"&&(we.innerHTML=Ig),gm=s(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-o2pgcr"&&(je.innerHTML=kg),Cm=s(e),r(Ue.$$.fragment,e),Im=s(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-s10qq4"&&(be.innerHTML=Ag),km=s(e),xe=p(e,"UL",{"data-svelte-h":!0}),o(xe)!=="svelte-ryq6lj"&&(xe.innerHTML=Pg),Am=s(e),Pm=p(e,"HR",{}),_m=s(e),ge=p(e,"A",{id:!0,class:!0}),y(ge).forEach(l),$m=s(e),r(Ce.$$.fragment,e),vm=s(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-neuqt1"&&(Ie.textContent=_g),Qm=s(e),ke=p(e,"TABLE",{"data-svelte-h":!0}),o(ke)!=="svelte-1iu6wl4"&&(ke.innerHTML=$g),Gm=s(e),Hm=p(e,"HR",{}),Zm=s(e),Ae=p(e,"A",{id:!0,class:!0}),y(Ae).forEach(l),Bm=s(e),r(Pe.$$.fragment,e),Em=s(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1xqr0u1"&&(_e.innerHTML=vg),Nm=s(e),Ym=p(e,"HR",{}),Rm=s(e),$e=p(e,"A",{id:!0,class:!0}),y($e).forEach(l),zm=s(e),r(ve.$$.fragment,e),Lm=s(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-nzjx48"&&(Qe.innerHTML=Qg),Sm=s(e),Ge=p(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1xict4f"&&(Ge.innerHTML=Gg),Wm=s(e),r(He.$$.fragment,e),Xm=s(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1sz7ava"&&(Ze.innerHTML=Hg),Dm=s(e),r(Be.$$.fragment,e),Fm=s(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-s10qq4"&&(Ee.innerHTML=Zg),Vm=s(e),Ne=p(e,"UL",{"data-svelte-h":!0}),o(Ne)!=="svelte-13j9xod"&&(Ne.innerHTML=Bg),Om=s(e),qm=p(e,"HR",{}),Km=s(e),Ye=p(e,"A",{id:!0,class:!0}),y(Ye).forEach(l),eu=s(e),r(Re.$$.fragment,e),tu=s(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1wfo17y"&&(ze.textContent=Eg),lu=s(e),Le=p(e,"TABLE",{"data-svelte-h":!0}),o(Le)!=="svelte-1iu6wl4"&&(Le.innerHTML=Ng),iu=s(e),nu=p(e,"HR",{}),su=s(e),Se=p(e,"A",{id:!0,class:!0}),y(Se).forEach(l),au=s(e),r(We.$$.fragment,e),pu=s(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-nplbor"&&(Xe.innerHTML=Yg),ou=s(e),du=p(e,"HR",{}),cu=s(e),De=p(e,"A",{id:!0,class:!0}),y(De).forEach(l),ru=s(e),r(Fe.$$.fragment,e),mu=s(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-e2spcq"&&(Ve.textContent=Rg),uu=s(e),Oe=p(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-j4hwgn"&&(Oe.innerHTML=zg),Mu=s(e),r(qe.$$.fragment,e),Tu=s(e),Ke=p(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-s10qq4"&&(Ke.innerHTML=Lg),yu=s(e),et=p(e,"UL",{"data-svelte-h":!0}),o(et)!=="svelte-11x3uau"&&(et.innerHTML=Sg),hu=s(e),Ju=p(e,"HR",{}),fu=s(e),tt=p(e,"A",{id:!0,class:!0}),y(tt).forEach(l),wu=s(e),r(lt.$$.fragment,e),ju=s(e),it=p(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1cz796d"&&(it.textContent=Wg),Uu=s(e),nt=p(e,"TABLE",{"data-svelte-h":!0}),o(nt)!=="svelte-1iu6wl4"&&(nt.innerHTML=Xg),bu=s(e),xu=p(e,"HR",{}),gu=s(e),st=p(e,"A",{id:!0,class:!0}),y(st).forEach(l),Cu=s(e),r(at.$$.fragment,e),Iu=s(e),pt=p(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1k77yex"&&(pt.innerHTML=Dg),ku=s(e),Au=p(e,"HR",{}),Pu=s(e),ot=p(e,"A",{id:!0,class:!0}),y(ot).forEach(l),_u=s(e),r(dt.$$.fragment,e),$u=s(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-1gl4q1t"&&(ct.innerHTML=Fg),vu=s(e),Qu=p(e,"HR",{}),Gu=s(e),rt=p(e,"A",{id:!0,class:!0}),y(rt).forEach(l),Hu=s(e),r(mt.$$.fragment,e),Zu=s(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1axdht2"&&(ut.textContent=Vg),Bu=s(e),Mt=p(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1416cqx"&&(Mt.innerHTML=Og),Eu=s(e),r(Tt.$$.fragment,e),Nu=s(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-s10qq4"&&(yt.innerHTML=qg),Yu=s(e),ht=p(e,"UL",{"data-svelte-h":!0}),o(ht)!=="svelte-p21410"&&(ht.innerHTML=Kg),Ru=s(e),zu=p(e,"HR",{}),Lu=s(e),Jt=p(e,"A",{id:!0,class:!0}),y(Jt).forEach(l),Su=s(e),r(ft.$$.fragment,e),Wu=s(e),wt=p(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-10um6eq"&&(wt.textContent=eC),Xu=s(e),jt=p(e,"TABLE",{"data-svelte-h":!0}),o(jt)!=="svelte-1iu6wl4"&&(jt.innerHTML=tC),Du=s(e),Fu=p(e,"HR",{}),Vu=s(e),Ut=p(e,"A",{id:!0,class:!0}),y(Ut).forEach(l),Ou=s(e),r(bt.$$.fragment,e),qu=s(e),xt=p(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-gx6clz"&&(xt.innerHTML=lC),Ku=s(e),eM=p(e,"HR",{}),tM=s(e),gt=p(e,"A",{id:!0,class:!0}),y(gt).forEach(l),lM=s(e),r(Ct.$$.fragment,e),iM=s(e),It=p(e,"P",{"data-svelte-h":!0}),o(It)!=="svelte-3abd20"&&(It.textContent=iC),nM=s(e),kt=p(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-1ut0vme"&&(kt.innerHTML=nC),sM=s(e),At=p(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-dr1wsd"&&(At.innerHTML=sC),aM=s(e),r(Pt.$$.fragment,e),pM=s(e),_t=p(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-mqh15a"&&(_t.innerHTML=aC),oM=s(e),$t=p(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-zf4dht"&&($t.innerHTML=pC),dM=s(e),r(vt.$$.fragment,e),cM=s(e),Qt=p(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1877ohf"&&(Qt.innerHTML=oC),rM=s(e),Gt=p(e,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1ox1juk"&&(Gt.innerHTML=dC),mM=s(e),r(Ht.$$.fragment,e),uM=s(e),Zt=p(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-s10qq4"&&(Zt.innerHTML=cC),MM=s(e),Bt=p(e,"UL",{"data-svelte-h":!0}),o(Bt)!=="svelte-e4lxrd"&&(Bt.innerHTML=rC),TM=s(e),yM=p(e,"HR",{}),hM=s(e),Et=p(e,"A",{id:!0,class:!0}),y(Et).forEach(l),JM=s(e),r(Nt.$$.fragment,e),fM=s(e),Yt=p(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-6vg3da"&&(Yt.textContent=mC),wM=s(e),Rt=p(e,"TABLE",{"data-svelte-h":!0}),o(Rt)!=="svelte-1iu6wl4"&&(Rt.innerHTML=uC),jM=s(e),UM=p(e,"HR",{}),bM=s(e),zt=p(e,"A",{id:!0,class:!0}),y(zt).forEach(l),xM=s(e),r(Lt.$$.fragment,e),gM=s(e),St=p(e,"P",{"data-svelte-h":!0}),o(St)!=="svelte-btu0vj"&&(St.innerHTML=MC),CM=s(e),IM=p(e,"HR",{}),kM=s(e),Wt=p(e,"A",{id:!0,class:!0}),y(Wt).forEach(l),AM=s(e),r(Xt.$$.fragment,e),PM=s(e),Dt=p(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-1yek3op"&&(Dt.innerHTML=TC),_M=s(e),Ft=p(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-11p32pq"&&(Ft.innerHTML=yC),$M=s(e),r(Vt.$$.fragment,e),vM=s(e),Ot=p(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-1uqom1e"&&(Ot.innerHTML=hC),QM=s(e),r(qt.$$.fragment,e),GM=s(e),Kt=p(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-1a7k67n"&&(Kt.innerHTML=JC),HM=s(e),r(el.$$.fragment,e),ZM=s(e),tl=p(e,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-s10qq4"&&(tl.innerHTML=fC),BM=s(e),ll=p(e,"UL",{"data-svelte-h":!0}),o(ll)!=="svelte-62eu9p"&&(ll.innerHTML=wC),EM=s(e),NM=p(e,"HR",{}),YM=s(e),il=p(e,"A",{id:!0,class:!0}),y(il).forEach(l),RM=s(e),r(nl.$$.fragment,e),zM=s(e),sl=p(e,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-xkrmr2"&&(sl.textContent=jC),LM=s(e),al=p(e,"TABLE",{"data-svelte-h":!0}),o(al)!=="svelte-1iu6wl4"&&(al.innerHTML=UC),SM=s(e),WM=p(e,"HR",{}),XM=s(e),pl=p(e,"A",{id:!0,class:!0}),y(pl).forEach(l),DM=s(e),r(ol.$$.fragment,e),FM=s(e),dl=p(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-mbcfab"&&(dl.innerHTML=bC),VM=s(e),OM=p(e,"HR",{}),qM=s(e),cl=p(e,"A",{id:!0,class:!0}),y(cl).forEach(l),KM=s(e),r(rl.$$.fragment,e),eT=s(e),ml=p(e,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-104v5zf"&&(ml.innerHTML=xC),tT=s(e),ul=p(e,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-17n9q32"&&(ul.innerHTML=gC),lT=s(e),r(Ml.$$.fragment,e),iT=s(e),Tl=p(e,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-v99qry"&&(Tl.innerHTML=CC),nT=s(e),r(yl.$$.fragment,e),sT=s(e),hl=p(e,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-s10qq4"&&(hl.innerHTML=IC),aT=s(e),Jl=p(e,"UL",{"data-svelte-h":!0}),o(Jl)!=="svelte-19ik76h"&&(Jl.innerHTML=kC),pT=s(e),oT=p(e,"HR",{}),dT=s(e),fl=p(e,"A",{id:!0,class:!0}),y(fl).forEach(l),cT=s(e),r(wl.$$.fragment,e),rT=s(e),jl=p(e,"P",{"data-svelte-h":!0}),o(jl)!=="svelte-1n1xlcl"&&(jl.textContent=AC),mT=s(e),Ul=p(e,"TABLE",{"data-svelte-h":!0}),o(Ul)!=="svelte-1iu6wl4"&&(Ul.innerHTML=PC),uT=s(e),MT=p(e,"HR",{}),TT=s(e),bl=p(e,"A",{id:!0,class:!0}),y(bl).forEach(l),yT=s(e),r(xl.$$.fragment,e),hT=s(e),gl=p(e,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-u37gsd"&&(gl.innerHTML=_C),JT=s(e),fT=p(e,"HR",{}),wT=s(e),Cl=p(e,"A",{id:!0,class:!0}),y(Cl).forEach(l),jT=s(e),r(Il.$$.fragment,e),UT=s(e),kl=p(e,"P",{"data-svelte-h":!0}),o(kl)!=="svelte-1ud8h4r"&&(kl.innerHTML=$C),bT=s(e),xT=p(e,"HR",{}),gT=s(e),Al=p(e,"A",{id:!0,class:!0}),y(Al).forEach(l),CT=s(e),r(Pl.$$.fragment,e),IT=s(e),_l=p(e,"P",{"data-svelte-h":!0}),o(_l)!=="svelte-tzucv0"&&(_l.textContent=vC),kT=s(e),$l=p(e,"P",{"data-svelte-h":!0}),o($l)!=="svelte-zrdgvs"&&($l.innerHTML=QC),AT=s(e),r(vl.$$.fragment,e),PT=s(e),Ql=p(e,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-et9i9m"&&(Ql.innerHTML=GC),_T=s(e),r(Gl.$$.fragment,e),$T=s(e),Hl=p(e,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-162t9ct"&&(Hl.innerHTML=HC),vT=s(e),r(Zl.$$.fragment,e),QT=s(e),Bl=p(e,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-1kus3j4"&&(Bl.innerHTML=ZC),GT=s(e),r(El.$$.fragment,e),HT=s(e),Nl=p(e,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-s10qq4"&&(Nl.innerHTML=BC),ZT=s(e),Yl=p(e,"UL",{"data-svelte-h":!0}),o(Yl)!=="svelte-10y93z3"&&(Yl.innerHTML=EC),BT=s(e),ET=p(e,"HR",{}),NT=s(e),Rl=p(e,"A",{id:!0,class:!0}),y(Rl).forEach(l),YT=s(e),r(zl.$$.fragment,e),RT=s(e),Ll=p(e,"P",{"data-svelte-h":!0}),o(Ll)!=="svelte-8oqlmq"&&(Ll.textContent=NC),zT=s(e),Sl=p(e,"TABLE",{"data-svelte-h":!0}),o(Sl)!=="svelte-1iu6wl4"&&(Sl.innerHTML=YC),LT=s(e),ST=p(e,"HR",{}),WT=s(e),Wl=p(e,"A",{id:!0,class:!0}),y(Wl).forEach(l),XT=s(e),r(Xl.$$.fragment,e),DT=s(e),Dl=p(e,"P",{"data-svelte-h":!0}),o(Dl)!=="svelte-s9g0sr"&&(Dl.innerHTML=RC),FT=s(e),VT=p(e,"HR",{}),OT=s(e),Fl=p(e,"A",{id:!0,class:!0}),y(Fl).forEach(l),qT=s(e),r(Vl.$$.fragment,e),KT=s(e),Ol=p(e,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-z5i7j9"&&(Ol.textContent=zC),ey=s(e),ql=p(e,"P",{"data-svelte-h":!0}),o(ql)!=="svelte-n063y1"&&(ql.innerHTML=LC),ty=s(e),r(Kl.$$.fragment,e),ly=s(e),ei=p(e,"P",{"data-svelte-h":!0}),o(ei)!=="svelte-49jj6i"&&(ei.innerHTML=SC),iy=s(e),r(ti.$$.fragment,e),ny=s(e),li=p(e,"P",{"data-svelte-h":!0}),o(li)!=="svelte-s10qq4"&&(li.innerHTML=WC),sy=s(e),ii=p(e,"UL",{"data-svelte-h":!0}),o(ii)!=="svelte-1x41tbl"&&(ii.innerHTML=XC),ay=s(e),py=p(e,"HR",{}),oy=s(e),ni=p(e,"A",{id:!0,class:!0}),y(ni).forEach(l),dy=s(e),r(si.$$.fragment,e),cy=s(e),ai=p(e,"P",{"data-svelte-h":!0}),o(ai)!=="svelte-1vowjv7"&&(ai.textContent=DC),ry=s(e),pi=p(e,"TABLE",{"data-svelte-h":!0}),o(pi)!=="svelte-uwryka"&&(pi.innerHTML=FC),my=s(e),uy=p(e,"HR",{}),My=s(e),oi=p(e,"A",{id:!0,class:!0}),y(oi).forEach(l),Ty=s(e),r(di.$$.fragment,e),yy=s(e),ci=p(e,"P",{"data-svelte-h":!0}),o(ci)!=="svelte-1m120x7"&&(ci.innerHTML=VC),hy=s(e),Jy=p(e,"HR",{}),fy=s(e),ri=p(e,"A",{id:!0,class:!0}),y(ri).forEach(l),wy=s(e),r(mi.$$.fragment,e),jy=s(e),ui=p(e,"P",{"data-svelte-h":!0}),o(ui)!=="svelte-9xhkxa"&&(ui.innerHTML=OC),Uy=s(e),Mi=p(e,"P",{"data-svelte-h":!0}),o(Mi)!=="svelte-11cz03b"&&(Mi.innerHTML=qC),by=s(e),r(Ti.$$.fragment,e),xy=s(e),yi=p(e,"P",{"data-svelte-h":!0}),o(yi)!=="svelte-1mkx6vp"&&(yi.innerHTML=KC),gy=s(e),r(hi.$$.fragment,e),Cy=s(e),Ji=p(e,"P",{"data-svelte-h":!0}),o(Ji)!=="svelte-s10qq4"&&(Ji.innerHTML=e0),Iy=s(e),fi=p(e,"UL",{"data-svelte-h":!0}),o(fi)!=="svelte-7knu0l"&&(fi.innerHTML=t0),ky=s(e),Ay=p(e,"HR",{}),Py=s(e),wi=p(e,"A",{id:!0,class:!0}),y(wi).forEach(l),_y=s(e),r(ji.$$.fragment,e),$y=s(e),Ui=p(e,"P",{"data-svelte-h":!0}),o(Ui)!=="svelte-1enract"&&(Ui.textContent=l0),vy=s(e),bi=p(e,"TABLE",{"data-svelte-h":!0}),o(bi)!=="svelte-1u0ywjh"&&(bi.innerHTML=i0),Qy=s(e),Gy=p(e,"HR",{}),Hy=s(e),xi=p(e,"A",{id:!0,class:!0}),y(xi).forEach(l),Zy=s(e),r(gi.$$.fragment,e),By=s(e),Ci=p(e,"P",{"data-svelte-h":!0}),o(Ci)!=="svelte-di1dc5"&&(Ci.innerHTML=n0),Ey=s(e),Ny=p(e,"HR",{}),Yy=s(e),Ii=p(e,"A",{id:!0,class:!0}),y(Ii).forEach(l),Ry=s(e),r(ki.$$.fragment,e),zy=s(e),Ai=p(e,"P",{"data-svelte-h":!0}),o(Ai)!=="svelte-tmg4zt"&&(Ai.innerHTML=s0),Ly=s(e),Pi=p(e,"P",{"data-svelte-h":!0}),o(Pi)!=="svelte-em947q"&&(Pi.innerHTML=a0),Sy=s(e),r(_i.$$.fragment,e),Wy=s(e),$i=p(e,"P",{"data-svelte-h":!0}),o($i)!=="svelte-s10qq4"&&($i.innerHTML=p0),Xy=s(e),vi=p(e,"UL",{"data-svelte-h":!0}),o(vi)!=="svelte-1qhhd61"&&(vi.innerHTML=o0),Dy=s(e),Fy=p(e,"HR",{}),Vy=s(e),Qi=p(e,"A",{id:!0,class:!0}),y(Qi).forEach(l),Oy=s(e),r(Gi.$$.fragment,e),qy=s(e),Hi=p(e,"P",{"data-svelte-h":!0}),o(Hi)!=="svelte-1edlvjn"&&(Hi.textContent=d0),Ky=s(e),Zi=p(e,"TABLE",{"data-svelte-h":!0}),o(Zi)!=="svelte-t7irm8"&&(Zi.innerHTML=c0),eh=s(e),th=p(e,"HR",{}),lh=s(e),Bi=p(e,"A",{id:!0,class:!0}),y(Bi).forEach(l),ih=s(e),r(Ei.$$.fragment,e),nh=s(e),Ni=p(e,"P",{"data-svelte-h":!0}),o(Ni)!=="svelte-1cetnsf"&&(Ni.innerHTML=r0),sh=s(e),ah=p(e,"HR",{}),ph=s(e),Yi=p(e,"A",{id:!0,class:!0}),y(Yi).forEach(l),oh=s(e),r(Ri.$$.fragment,e),dh=s(e),zi=p(e,"P",{"data-svelte-h":!0}),o(zi)!=="svelte-vm8asa"&&(zi.textContent=m0),ch=s(e),Li=p(e,"P",{"data-svelte-h":!0}),o(Li)!=="svelte-p9nqmy"&&(Li.innerHTML=u0),rh=s(e),r(Si.$$.fragment,e),mh=s(e),Wi=p(e,"P",{"data-svelte-h":!0}),o(Wi)!=="svelte-1xb4yln"&&(Wi.innerHTML=M0),uh=s(e),r(Xi.$$.fragment,e),Mh=s(e),Di=p(e,"P",{"data-svelte-h":!0}),o(Di)!=="svelte-aly754"&&(Di.innerHTML=T0),Th=s(e),r(Fi.$$.fragment,e),yh=s(e),Vi=p(e,"P",{"data-svelte-h":!0}),o(Vi)!=="svelte-127z1r2"&&(Vi.innerHTML=y0),hh=s(e),r(Oi.$$.fragment,e),Jh=s(e),qi=p(e,"P",{"data-svelte-h":!0}),o(qi)!=="svelte-5ad2vc"&&(qi.innerHTML=h0),fh=s(e),r(Ki.$$.fragment,e),wh=s(e),en=p(e,"P",{"data-svelte-h":!0}),o(en)!=="svelte-1ybp4y9"&&(en.innerHTML=J0),jh=s(e),r(tn.$$.fragment,e),Uh=s(e),ln=p(e,"P",{"data-svelte-h":!0}),o(ln)!=="svelte-s10qq4"&&(ln.innerHTML=f0),bh=s(e),nn=p(e,"UL",{"data-svelte-h":!0}),o(nn)!=="svelte-257cyp"&&(nn.innerHTML=w0),xh=s(e),gh=p(e,"HR",{}),Ch=s(e),sn=p(e,"A",{id:!0,class:!0}),y(sn).forEach(l),Ih=s(e),r(an.$$.fragment,e),kh=s(e),pn=p(e,"P",{"data-svelte-h":!0}),o(pn)!=="svelte-1kkefov"&&(pn.textContent=j0),Ah=s(e),on=p(e,"TABLE",{"data-svelte-h":!0}),o(on)!=="svelte-t7irm8"&&(on.innerHTML=U0),Ph=s(e),_h=p(e,"HR",{}),$h=s(e),dn=p(e,"A",{id:!0,class:!0}),y(dn).forEach(l),vh=s(e),r(cn.$$.fragment,e),Qh=s(e),rn=p(e,"P",{"data-svelte-h":!0}),o(rn)!=="svelte-i1526d"&&(rn.innerHTML=b0),Gh=s(e),Hh=p(e,"HR",{}),Zh=s(e),mn=p(e,"A",{id:!0,class:!0}),y(mn).forEach(l),Bh=s(e),r(un.$$.fragment,e),Eh=s(e),Mn=p(e,"P",{"data-svelte-h":!0}),o(Mn)!=="svelte-yuzbfo"&&(Mn.innerHTML=x0),Nh=s(e),Tn=p(e,"P",{"data-svelte-h":!0}),o(Tn)!=="svelte-gwolyd"&&(Tn.innerHTML=g0),Yh=s(e),r(yn.$$.fragment,e),Rh=s(e),hn=p(e,"P",{"data-svelte-h":!0}),o(hn)!=="svelte-vvjehq"&&(hn.innerHTML=C0),zh=s(e),r(Jn.$$.fragment,e),Lh=s(e),fn=p(e,"P",{"data-svelte-h":!0}),o(fn)!=="svelte-s10qq4"&&(fn.innerHTML=I0),Sh=s(e),wn=p(e,"UL",{"data-svelte-h":!0}),o(wn)!=="svelte-14lg7tf"&&(wn.innerHTML=k0),Wh=s(e),Xh=p(e,"HR",{}),Dh=s(e),jn=p(e,"A",{id:!0,class:!0}),y(jn).forEach(l),Fh=s(e),r(Un.$$.fragment,e),Vh=s(e),bn=p(e,"P",{"data-svelte-h":!0}),o(bn)!=="svelte-10qze5e"&&(bn.textContent=A0),Oh=s(e),xn=p(e,"TABLE",{"data-svelte-h":!0}),o(xn)!=="svelte-1r7ciun"&&(xn.innerHTML=P0),qh=s(e),Kh=p(e,"HR",{}),eJ=s(e),gn=p(e,"A",{id:!0,class:!0}),y(gn).forEach(l),tJ=s(e),r(Cn.$$.fragment,e),lJ=s(e),In=p(e,"P",{"data-svelte-h":!0}),o(In)!=="svelte-tnura3"&&(In.innerHTML=_0),iJ=s(e),nJ=p(e,"HR",{}),sJ=s(e),kn=p(e,"A",{id:!0,class:!0}),y(kn).forEach(l),aJ=s(e),r(An.$$.fragment,e),pJ=s(e),Pn=p(e,"P",{"data-svelte-h":!0}),o(Pn)!=="svelte-w5osnc"&&(Pn.innerHTML=$0),oJ=s(e),_n=p(e,"P",{"data-svelte-h":!0}),o(_n)!=="svelte-1h4310j"&&(_n.innerHTML=v0),dJ=s(e),r($n.$$.fragment,e),cJ=s(e),vn=p(e,"P",{"data-svelte-h":!0}),o(vn)!=="svelte-xv6hak"&&(vn.innerHTML=Q0),rJ=s(e),r(Qn.$$.fragment,e),mJ=s(e),Gn=p(e,"P",{"data-svelte-h":!0}),o(Gn)!=="svelte-1ids6l"&&(Gn.innerHTML=G0),uJ=s(e),r(Hn.$$.fragment,e),MJ=s(e),Zn=p(e,"P",{"data-svelte-h":!0}),o(Zn)!=="svelte-s10qq4"&&(Zn.innerHTML=H0),TJ=s(e),Bn=p(e,"UL",{"data-svelte-h":!0}),o(Bn)!=="svelte-1xz2p9v"&&(Bn.innerHTML=Z0),yJ=s(e),hJ=p(e,"HR",{}),JJ=s(e),En=p(e,"A",{id:!0,class:!0}),y(En).forEach(l),fJ=s(e),r(Nn.$$.fragment,e),wJ=s(e),Yn=p(e,"P",{"data-svelte-h":!0}),o(Yn)!=="svelte-71b02w"&&(Yn.textContent=B0),jJ=s(e),Rn=p(e,"TABLE",{"data-svelte-h":!0}),o(Rn)!=="svelte-uwryka"&&(Rn.innerHTML=E0),UJ=s(e),bJ=p(e,"HR",{}),xJ=s(e),zn=p(e,"A",{id:!0,class:!0}),y(zn).forEach(l),gJ=s(e),r(Ln.$$.fragment,e),CJ=s(e),Sn=p(e,"P",{"data-svelte-h":!0}),o(Sn)!=="svelte-1jslpvf"&&(Sn.innerHTML=N0),IJ=s(e),kJ=p(e,"HR",{}),AJ=s(e),Wn=p(e,"A",{id:!0,class:!0}),y(Wn).forEach(l),PJ=s(e),r(Xn.$$.fragment,e),_J=s(e),Dn=p(e,"P",{"data-svelte-h":!0}),o(Dn)!=="svelte-1rwi35s"&&(Dn.innerHTML=Y0),$J=s(e),Fn=p(e,"P",{"data-svelte-h":!0}),o(Fn)!=="svelte-1tpbwb6"&&(Fn.innerHTML=R0),vJ=s(e),r(Vn.$$.fragment,e),QJ=s(e),On=p(e,"P",{"data-svelte-h":!0}),o(On)!=="svelte-s10qq4"&&(On.innerHTML=z0),GJ=s(e),qn=p(e,"UL",{"data-svelte-h":!0}),o(qn)!=="svelte-1rarq13"&&(qn.innerHTML=L0),HJ=s(e),ZJ=p(e,"HR",{}),BJ=s(e),Kn=p(e,"A",{id:!0,class:!0}),y(Kn).forEach(l),EJ=s(e),r(es.$$.fragment,e),NJ=s(e),ts=p(e,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-1ctgtyq"&&(ts.textContent=S0),YJ=s(e),ls=p(e,"TABLE",{"data-svelte-h":!0}),o(ls)!=="svelte-uwryka"&&(ls.innerHTML=W0),RJ=s(e),zJ=p(e,"HR",{}),LJ=s(e),is=p(e,"A",{id:!0,class:!0}),y(is).forEach(l),SJ=s(e),r(ns.$$.fragment,e),WJ=s(e),ss=p(e,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1ql34f7"&&(ss.innerHTML=X0),XJ=s(e),DJ=p(e,"HR",{}),FJ=s(e),as=p(e,"A",{id:!0,class:!0}),y(as).forEach(l),VJ=s(e),r(ps.$$.fragment,e),OJ=s(e),os=p(e,"P",{"data-svelte-h":!0}),o(os)!=="svelte-20dgme"&&(os.innerHTML=D0),qJ=s(e),ds=p(e,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-eob2i5"&&(ds.innerHTML=F0),KJ=s(e),r(cs.$$.fragment,e),ef=s(e),rs=p(e,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-s10qq4"&&(rs.innerHTML=V0),tf=s(e),ms=p(e,"UL",{"data-svelte-h":!0}),o(ms)!=="svelte-ej6a5r"&&(ms.innerHTML=O0),lf=s(e),nf=p(e,"HR",{}),sf=s(e),us=p(e,"A",{id:!0,class:!0}),y(us).forEach(l),af=s(e),r(Ms.$$.fragment,e),pf=s(e),Ts=p(e,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-3wys82"&&(Ts.textContent=q0),of=s(e),ys=p(e,"TABLE",{"data-svelte-h":!0}),o(ys)!=="svelte-1r7ciun"&&(ys.innerHTML=K0),df=s(e),cf=p(e,"HR",{}),rf=s(e),hs=p(e,"A",{id:!0,class:!0}),y(hs).forEach(l),mf=s(e),r(Js.$$.fragment,e),uf=s(e),fs=p(e,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-2y0z4b"&&(fs.innerHTML=eI),Mf=s(e),Tf=p(e,"HR",{}),yf=s(e),ws=p(e,"A",{id:!0,class:!0}),y(ws).forEach(l),hf=s(e),r(js.$$.fragment,e),Jf=s(e),Us=p(e,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-11wm84h"&&(Us.innerHTML=tI),ff=s(e),bs=p(e,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-tf175f"&&(bs.innerHTML=lI),wf=s(e),r(xs.$$.fragment,e),jf=s(e),gs=p(e,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-s10qq4"&&(gs.innerHTML=iI),Uf=s(e),Cs=p(e,"UL",{"data-svelte-h":!0}),o(Cs)!=="svelte-b3ue47"&&(Cs.innerHTML=nI),bf=s(e),xf=p(e,"HR",{}),gf=s(e),Is=p(e,"A",{id:!0,class:!0}),y(Is).forEach(l),Cf=s(e),r(ks.$$.fragment,e),If=s(e),As=p(e,"P",{"data-svelte-h":!0}),o(As)!=="svelte-1la8w69"&&(As.textContent=sI),kf=s(e),Ps=p(e,"TABLE",{"data-svelte-h":!0}),o(Ps)!=="svelte-uwryka"&&(Ps.innerHTML=aI),Af=s(e),Pf=p(e,"HR",{}),_f=s(e),_s=p(e,"A",{id:!0,class:!0}),y(_s).forEach(l),$f=s(e),r($s.$$.fragment,e),vf=s(e),vs=p(e,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-i9mudt"&&(vs.innerHTML=pI),Qf=s(e),Gf=p(e,"HR",{}),Hf=s(e),Qs=p(e,"A",{id:!0,class:!0}),y(Qs).forEach(l),Zf=s(e),r(Gs.$$.fragment,e),Bf=s(e),Hs=p(e,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-1hdoc64"&&(Hs.innerHTML=oI),Ef=s(e),Zs=p(e,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-yw3rra"&&(Zs.innerHTML=dI),Nf=s(e),r(Bs.$$.fragment,e),Yf=s(e),Es=p(e,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-1kny7rm"&&(Es.innerHTML=cI),Rf=s(e),r(Ns.$$.fragment,e),zf=s(e),Ys=p(e,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-s10qq4"&&(Ys.innerHTML=rI),Lf=s(e),Rs=p(e,"UL",{"data-svelte-h":!0}),o(Rs)!=="svelte-1sje1nx"&&(Rs.innerHTML=mI),Sf=s(e),Wf=p(e,"HR",{}),Xf=s(e),zs=p(e,"A",{id:!0,class:!0}),y(zs).forEach(l),Df=s(e),r(Ls.$$.fragment,e),Ff=s(e),Ss=p(e,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-t69287"&&(Ss.textContent=uI),Vf=s(e),Ws=p(e,"TABLE",{"data-svelte-h":!0}),o(Ws)!=="svelte-1r7ciun"&&(Ws.innerHTML=MI),Of=s(e),qf=p(e,"HR",{}),Kf=s(e),Xs=p(e,"A",{id:!0,class:!0}),y(Xs).forEach(l),ew=s(e),r(Ds.$$.fragment,e),tw=s(e),Fs=p(e,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-voaoyf"&&(Fs.innerHTML=TI),lw=s(e),iw=p(e,"HR",{}),nw=s(e),Vs=p(e,"A",{id:!0,class:!0}),y(Vs).forEach(l),sw=s(e),r(Os.$$.fragment,e),aw=s(e),qs=p(e,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-iv1c6p"&&(qs.innerHTML=yI),pw=s(e),Ks=p(e,"P",{"data-svelte-h":!0}),o(Ks)!=="svelte-1mtx2cy"&&(Ks.innerHTML=hI),ow=s(e),r(ea.$$.fragment,e),dw=s(e),ta=p(e,"P",{"data-svelte-h":!0}),o(ta)!=="svelte-s10qq4"&&(ta.innerHTML=JI),cw=s(e),la=p(e,"UL",{"data-svelte-h":!0}),o(la)!=="svelte-1vh9slr"&&(la.innerHTML=fI),rw=s(e),mw=p(e,"HR",{}),uw=s(e),ia=p(e,"A",{id:!0,class:!0}),y(ia).forEach(l),Mw=s(e),r(na.$$.fragment,e),Tw=s(e),sa=p(e,"P",{"data-svelte-h":!0}),o(sa)!=="svelte-at8fug"&&(sa.textContent=wI),yw=s(e),aa=p(e,"TABLE",{"data-svelte-h":!0}),o(aa)!=="svelte-1r7ciun"&&(aa.innerHTML=jI),hw=s(e),Jw=p(e,"HR",{}),fw=s(e),pa=p(e,"A",{id:!0,class:!0}),y(pa).forEach(l),ww=s(e),r(oa.$$.fragment,e),jw=s(e),da=p(e,"P",{"data-svelte-h":!0}),o(da)!=="svelte-pvyv43"&&(da.innerHTML=UI),Uw=s(e),bw=p(e,"HR",{}),xw=s(e),ca=p(e,"A",{id:!0,class:!0}),y(ca).forEach(l),gw=s(e),r(ra.$$.fragment,e),Cw=s(e),ma=p(e,"P",{"data-svelte-h":!0}),o(ma)!=="svelte-1nzvfes"&&(ma.innerHTML=bI),Iw=s(e),ua=p(e,"P",{"data-svelte-h":!0}),o(ua)!=="svelte-1qq0cp9"&&(ua.innerHTML=xI),kw=s(e),r(Ma.$$.fragment,e),Aw=s(e),Ta=p(e,"P",{"data-svelte-h":!0}),o(Ta)!=="svelte-1mslt41"&&(Ta.innerHTML=gI),Pw=s(e),r(ya.$$.fragment,e),_w=s(e),ha=p(e,"P",{"data-svelte-h":!0}),o(ha)!=="svelte-dehksg"&&(ha.innerHTML=CI),$w=s(e),r(Ja.$$.fragment,e),vw=s(e),fa=p(e,"P",{"data-svelte-h":!0}),o(fa)!=="svelte-s10qq4"&&(fa.innerHTML=II),Qw=s(e),wa=p(e,"UL",{"data-svelte-h":!0}),o(wa)!=="svelte-1jpp8cv"&&(wa.innerHTML=kI),Gw=s(e),Hw=p(e,"HR",{}),Zw=s(e),ja=p(e,"A",{id:!0,class:!0}),y(ja).forEach(l),Bw=s(e),r(Ua.$$.fragment,e),Ew=s(e),ba=p(e,"P",{"data-svelte-h":!0}),o(ba)!=="svelte-ipwl63"&&(ba.textContent=AI),Nw=s(e),xa=p(e,"TABLE",{"data-svelte-h":!0}),o(xa)!=="svelte-asell3"&&(xa.innerHTML=PI),Yw=s(e),Rw=p(e,"HR",{}),zw=s(e),ga=p(e,"A",{id:!0,class:!0}),y(ga).forEach(l),Lw=s(e),r(Ca.$$.fragment,e),Sw=s(e),Ia=p(e,"P",{"data-svelte-h":!0}),o(Ia)!=="svelte-1e762tl"&&(Ia.innerHTML=_I),Ww=s(e),Xw=p(e,"HR",{}),Dw=s(e),ka=p(e,"A",{id:!0,class:!0}),y(ka).forEach(l),Fw=s(e),r(Aa.$$.fragment,e),Vw=s(e),Pa=p(e,"P",{"data-svelte-h":!0}),o(Pa)!=="svelte-1y1a6n"&&(Pa.innerHTML=$I),Ow=s(e),_a=p(e,"P",{"data-svelte-h":!0}),o(_a)!=="svelte-el75jg"&&(_a.innerHTML=vI),qw=s(e),r($a.$$.fragment,e),Kw=s(e),va=p(e,"P",{"data-svelte-h":!0}),o(va)!=="svelte-s10qq4"&&(va.innerHTML=QI),e2=s(e),Qa=p(e,"UL",{"data-svelte-h":!0}),o(Qa)!=="svelte-1hvigd"&&(Qa.innerHTML=GI),t2=s(e),l2=p(e,"HR",{}),i2=s(e),Ga=p(e,"A",{id:!0,class:!0}),y(Ga).forEach(l),n2=s(e),r(Ha.$$.fragment,e),s2=s(e),Za=p(e,"P",{"data-svelte-h":!0}),o(Za)!=="svelte-dhr5hm"&&(Za.textContent=HI),a2=s(e),Ba=p(e,"TABLE",{"data-svelte-h":!0}),o(Ba)!=="svelte-uwryka"&&(Ba.innerHTML=ZI),p2=s(e),o2=p(e,"HR",{}),d2=s(e),Ea=p(e,"A",{id:!0,class:!0}),y(Ea).forEach(l),c2=s(e),r(Na.$$.fragment,e),r2=s(e),Ya=p(e,"P",{"data-svelte-h":!0}),o(Ya)!=="svelte-diiw1n"&&(Ya.innerHTML=BI),m2=s(e),u2=p(e,"HR",{}),M2=s(e),Ra=p(e,"A",{id:!0,class:!0}),y(Ra).forEach(l),T2=s(e),r(za.$$.fragment,e),y2=s(e),La=p(e,"P",{"data-svelte-h":!0}),o(La)!=="svelte-cmozej"&&(La.innerHTML=EI),h2=s(e),Sa=p(e,"P",{"data-svelte-h":!0}),o(Sa)!=="svelte-10zf5uq"&&(Sa.innerHTML=NI),J2=s(e),r(Wa.$$.fragment,e),f2=s(e),Xa=p(e,"P",{"data-svelte-h":!0}),o(Xa)!=="svelte-s10qq4"&&(Xa.innerHTML=YI),w2=s(e),Da=p(e,"UL",{"data-svelte-h":!0}),o(Da)!=="svelte-l45353"&&(Da.innerHTML=RI),j2=s(e),U2=p(e,"HR",{}),b2=s(e),Fa=p(e,"A",{id:!0,class:!0}),y(Fa).forEach(l),x2=s(e),r(Va.$$.fragment,e),g2=s(e),Oa=p(e,"P",{"data-svelte-h":!0}),o(Oa)!=="svelte-h6i1s9"&&(Oa.textContent=zI),C2=s(e),qa=p(e,"TABLE",{"data-svelte-h":!0}),o(qa)!=="svelte-uwryka"&&(qa.innerHTML=LI),I2=s(e),k2=p(e,"HR",{}),A2=s(e),Ka=p(e,"A",{id:!0,class:!0}),y(Ka).forEach(l),P2=s(e),r(ep.$$.fragment,e),_2=s(e),tp=p(e,"P",{"data-svelte-h":!0}),o(tp)!=="svelte-k6swrx"&&(tp.innerHTML=SI),$2=s(e),v2=p(e,"HR",{}),Q2=s(e),lp=p(e,"A",{id:!0,class:!0}),y(lp).forEach(l),G2=s(e),r(ip.$$.fragment,e),H2=s(e),np=p(e,"P",{"data-svelte-h":!0}),o(np)!=="svelte-1drpefn"&&(np.innerHTML=WI),Z2=s(e),sp=p(e,"P",{"data-svelte-h":!0}),o(sp)!=="svelte-gbcntq"&&(sp.innerHTML=XI),B2=s(e),ap=p(e,"UL",{"data-svelte-h":!0}),o(ap)!=="svelte-wk6owh"&&(ap.innerHTML=DI),E2=s(e),pp=p(e,"TABLE",{"data-svelte-h":!0}),o(pp)!=="svelte-1j0rydw"&&(pp.innerHTML=FI),N2=s(e),Y2=p(e,"HR",{}),R2=s(e),op=p(e,"A",{id:!0,class:!0}),y(op).forEach(l),z2=s(e),r(dp.$$.fragment,e),L2=s(e),cp=p(e,"P",{"data-svelte-h":!0}),o(cp)!=="svelte-cmqb57"&&(cp.innerHTML=VI),S2=s(e),W2=p(e,"HR",{}),X2=s(e),rp=p(e,"A",{id:!0,class:!0}),y(rp).forEach(l),D2=s(e),r(mp.$$.fragment,e),F2=s(e),up=p(e,"P",{"data-svelte-h":!0}),o(up)!=="svelte-1axcw5l"&&(up.innerHTML=OI),V2=s(e),O2=p(e,"HR",{}),q2=s(e),Mp=p(e,"A",{id:!0,class:!0}),y(Mp).forEach(l),K2=s(e),r(Tp.$$.fragment,e),ej=s(e),yp=p(e,"P",{"data-svelte-h":!0}),o(yp)!=="svelte-1axcw5l"&&(yp.innerHTML=qI),tj=s(e),lj=p(e,"HR",{}),ij=s(e),hp=p(e,"A",{id:!0,class:!0}),y(hp).forEach(l),nj=s(e),r(Jp.$$.fragment,e),sj=s(e),fp=p(e,"P",{"data-svelte-h":!0}),o(fp)!=="svelte-ptv3i7"&&(fp.innerHTML=KI),aj=s(e),wp=p(e,"TABLE",{"data-svelte-h":!0}),o(wp)!=="svelte-1ggz2h3"&&(wp.innerHTML=e3),pj=s(e),oj=p(e,"HR",{}),dj=s(e),jp=p(e,"A",{id:!0,class:!0}),y(jp).forEach(l),cj=s(e),r(Up.$$.fragment,e),rj=s(e),bp=p(e,"P",{"data-svelte-h":!0}),o(bp)!=="svelte-1u62ns5"&&(bp.innerHTML=t3),mj=s(e),xp=p(e,"TABLE",{"data-svelte-h":!0}),o(xp)!=="svelte-rk1slv"&&(xp.innerHTML=l3),uj=s(e),Mj=p(e,"HR",{}),Tj=s(e),gp=p(e,"A",{id:!0,class:!0}),y(gp).forEach(l),yj=s(e),r(Cp.$$.fragment,e),hj=s(e),Ip=p(e,"P",{"data-svelte-h":!0}),o(Ip)!=="svelte-34syj8"&&(Ip.textContent=i3),Jj=s(e),kp=p(e,"P",{"data-svelte-h":!0}),o(kp)!=="svelte-ptv3i7"&&(kp.innerHTML=n3),fj=s(e),Ap=p(e,"TABLE",{"data-svelte-h":!0}),o(Ap)!=="svelte-1fvmgx7"&&(Ap.innerHTML=s3),wj=s(e),jj=p(e,"HR",{}),Uj=s(e),Pp=p(e,"A",{id:!0,class:!0}),y(Pp).forEach(l),bj=s(e),r(_p.$$.fragment,e),xj=s(e),$p=p(e,"P",{"data-svelte-h":!0}),o($p)!=="svelte-1mr04yh"&&($p.textContent=a3),gj=s(e),vp=p(e,"P",{"data-svelte-h":!0}),o(vp)!=="svelte-ptv3i7"&&(vp.innerHTML=p3),Cj=s(e),Qp=p(e,"TABLE",{"data-svelte-h":!0}),o(Qp)!=="svelte-1agpzvo"&&(Qp.innerHTML=o3),Ij=s(e),kj=p(e,"HR",{}),Aj=s(e),Gp=p(e,"A",{id:!0,class:!0}),y(Gp).forEach(l),Pj=s(e),r(Hp.$$.fragment,e),_j=s(e),Zp=p(e,"P",{"data-svelte-h":!0}),o(Zp)!=="svelte-6hgc2w"&&(Zp.textContent=d3),$j=s(e),Bp=p(e,"P",{"data-svelte-h":!0}),o(Bp)!=="svelte-ptv3i7"&&(Bp.innerHTML=c3),vj=s(e),Ep=p(e,"TABLE",{"data-svelte-h":!0}),o(Ep)!=="svelte-10ghpzh"&&(Ep.innerHTML=r3),Qj=s(e),Gj=p(e,"HR",{}),Hj=s(e),Np=p(e,"A",{id:!0,class:!0}),y(Np).forEach(l),Zj=s(e),r(Yp.$$.fragment,e),Bj=s(e),Rp=p(e,"P",{"data-svelte-h":!0}),o(Rp)!=="svelte-5irp67"&&(Rp.textContent=m3),Ej=s(e),zp=p(e,"P",{"data-svelte-h":!0}),o(zp)!=="svelte-1q1ef1c"&&(zp.innerHTML=u3),Nj=s(e),Lp=p(e,"TABLE",{"data-svelte-h":!0}),o(Lp)!=="svelte-1n7bxpl"&&(Lp.innerHTML=M3),Yj=s(e),Sp=p(e,"P",{"data-svelte-h":!0}),o(Sp)!=="svelte-drbxoe"&&(Sp.innerHTML=T3),Rj=s(e),Wp=p(e,"TABLE",{"data-svelte-h":!0}),o(Wp)!=="svelte-rqr0sw"&&(Wp.innerHTML=y3),zj=s(e),Lj=p(e,"HR",{}),Sj=s(e),Xp=p(e,"A",{id:!0,class:!0}),y(Xp).forEach(l),Wj=s(e),r(Dp.$$.fragment,e),Xj=s(e),Fp=p(e,"P",{"data-svelte-h":!0}),o(Fp)!=="svelte-e99ya5"&&(Fp.textContent=h3),Dj=s(e),Vp=p(e,"P",{"data-svelte-h":!0}),o(Vp)!=="svelte-1bsoqra"&&(Vp.innerHTML=J3),Fj=s(e),Op=p(e,"TABLE",{"data-svelte-h":!0}),o(Op)!=="svelte-wkggw2"&&(Op.innerHTML=f3),Vj=s(e),qp=p(e,"P",{"data-svelte-h":!0}),o(qp)!=="svelte-drbxoe"&&(qp.innerHTML=w3),Oj=s(e),Kp=p(e,"TABLE",{"data-svelte-h":!0}),o(Kp)!=="svelte-11kx8qp"&&(Kp.innerHTML=j3),qj=s(e),Kj=p(e,"HR",{}),eU=s(e),eo=p(e,"A",{id:!0,class:!0}),y(eo).forEach(l),tU=s(e),r(to.$$.fragment,e),lU=s(e),lo=p(e,"P",{"data-svelte-h":!0}),o(lo)!=="svelte-1vedd0s"&&(lo.textContent=U3),iU=s(e),io=p(e,"P",{"data-svelte-h":!0}),o(io)!=="svelte-2lvzw0"&&(io.innerHTML=b3),nU=s(e),no=p(e,"TABLE",{"data-svelte-h":!0}),o(no)!=="svelte-1bpmr33"&&(no.innerHTML=x3),sU=s(e),so=p(e,"P",{"data-svelte-h":!0}),o(so)!=="svelte-drbxoe"&&(so.innerHTML=g3),aU=s(e),ao=p(e,"TABLE",{"data-svelte-h":!0}),o(ao)!=="svelte-1c9t63r"&&(ao.innerHTML=C3),pU=s(e),oU=p(e,"HR",{}),dU=s(e),po=p(e,"A",{id:!0,class:!0}),y(po).forEach(l),cU=s(e),r(oo.$$.fragment,e),rU=s(e),co=p(e,"P",{"data-svelte-h":!0}),o(co)!=="svelte-c20v7t"&&(co.textContent=I3),mU=s(e),ro=p(e,"P",{"data-svelte-h":!0}),o(ro)!=="svelte-hjcayz"&&(ro.innerHTML=k3),uU=s(e),mo=p(e,"UL",{"data-svelte-h":!0}),o(mo)!=="svelte-wmzf9w"&&(mo.innerHTML=A3),MU=s(e),uo=p(e,"TABLE",{"data-svelte-h":!0}),o(uo)!=="svelte-10st3qn"&&(uo.innerHTML=P3),TU=s(e),Mo=p(e,"P",{"data-svelte-h":!0}),o(Mo)!=="svelte-drbxoe"&&(Mo.innerHTML=_3),yU=s(e),To=p(e,"TABLE",{"data-svelte-h":!0}),o(To)!=="svelte-448kgs"&&(To.innerHTML=$3),hU=s(e),JU=p(e,"HR",{}),fU=s(e),yo=p(e,"A",{id:!0,class:!0}),y(yo).forEach(l),wU=s(e),r(ho.$$.fragment,e),jU=s(e),Jo=p(e,"P",{"data-svelte-h":!0}),o(Jo)!=="svelte-1axcw5l"&&(Jo.innerHTML=v3),UU=s(e),fo=p(e,"TABLE",{"data-svelte-h":!0}),o(fo)!=="svelte-wdzz5f"&&(fo.innerHTML=Q3),bU=s(e),wo=p(e,"P",{"data-svelte-h":!0}),o(wo)!=="svelte-drbxoe"&&(wo.innerHTML=G3),xU=s(e),jo=p(e,"TABLE",{"data-svelte-h":!0}),o(jo)!=="svelte-jpm10y"&&(jo.innerHTML=H3),gU=s(e),CU=p(e,"HR",{}),IU=s(e),Uo=p(e,"A",{id:!0,class:!0}),y(Uo).forEach(l),kU=s(e),r(bo.$$.fragment,e),AU=s(e),xo=p(e,"P",{"data-svelte-h":!0}),o(xo)!=="svelte-1axcw5l"&&(xo.innerHTML=Z3),PU=s(e),go=p(e,"TABLE",{"data-svelte-h":!0}),o(go)!=="svelte-um34lc"&&(go.innerHTML=B3),_U=s(e),Co=p(e,"P",{"data-svelte-h":!0}),o(Co)!=="svelte-drbxoe"&&(Co.innerHTML=E3),$U=s(e),Io=p(e,"TABLE",{"data-svelte-h":!0}),o(Io)!=="svelte-12o7o6m"&&(Io.innerHTML=N3),vU=s(e),QU=p(e,"HR",{}),GU=s(e),ko=p(e,"A",{id:!0,class:!0}),y(ko).forEach(l),HU=s(e),r(Ao.$$.fragment,e),ZU=s(e),Po=p(e,"P",{"data-svelte-h":!0}),o(Po)!=="svelte-1axcw5l"&&(Po.innerHTML=Y3),BU=s(e),_o=p(e,"TABLE",{"data-svelte-h":!0}),o(_o)!=="svelte-2zn3c2"&&(_o.innerHTML=R3),EU=s(e),$o=p(e,"P",{"data-svelte-h":!0}),o($o)!=="svelte-drbxoe"&&($o.innerHTML=z3),NU=s(e),vo=p(e,"TABLE",{"data-svelte-h":!0}),o(vo)!=="svelte-14fnfzf"&&(vo.innerHTML=L3),YU=s(e),RU=p(e,"HR",{}),zU=s(e),Qo=p(e,"A",{id:!0,class:!0}),y(Qo).forEach(l),LU=s(e),r(Go.$$.fragment,e),SU=s(e),Ho=p(e,"P",{"data-svelte-h":!0}),o(Ho)!=="svelte-1iiqv80"&&(Ho.textContent=S3),WU=s(e),Zo=p(e,"P",{"data-svelte-h":!0}),o(Zo)!=="svelte-127plg"&&(Zo.innerHTML=W3),XU=s(e),Bo=p(e,"TABLE",{"data-svelte-h":!0}),o(Bo)!=="svelte-1hs09x"&&(Bo.innerHTML=X3),DU=s(e),Eo=p(e,"P",{"data-svelte-h":!0}),o(Eo)!=="svelte-drbxoe"&&(Eo.innerHTML=D3),FU=s(e),No=p(e,"TABLE",{"data-svelte-h":!0}),o(No)!=="svelte-fwioke"&&(No.innerHTML=F3),VU=s(e),OU=p(e,"HR",{}),qU=s(e),Yo=p(e,"A",{id:!0,class:!0}),y(Yo).forEach(l),KU=s(e),r(Ro.$$.fragment,e),eb=s(e),zo=p(e,"P",{"data-svelte-h":!0}),o(zo)!=="svelte-14robr1"&&(zo.textContent=V3),tb=s(e),Lo=p(e,"P",{"data-svelte-h":!0}),o(Lo)!=="svelte-v0oyxa"&&(Lo.innerHTML=O3),lb=s(e),So=p(e,"TABLE",{"data-svelte-h":!0}),o(So)!=="svelte-1esamuv"&&(So.innerHTML=q3),ib=s(e),Wo=p(e,"P",{"data-svelte-h":!0}),o(Wo)!=="svelte-drbxoe"&&(Wo.innerHTML=K3),nb=s(e),Xo=p(e,"TABLE",{"data-svelte-h":!0}),o(Xo)!=="svelte-105ib2i"&&(Xo.innerHTML=ek),sb=s(e),ab=p(e,"HR",{}),pb=s(e),Do=p(e,"A",{id:!0,class:!0}),y(Do).forEach(l),ob=s(e),r(Fo.$$.fragment,e),db=s(e),Vo=p(e,"P",{"data-svelte-h":!0}),o(Vo)!=="svelte-1g7now9"&&(Vo.textContent=tk),cb=s(e),Oo=p(e,"P",{"data-svelte-h":!0}),o(Oo)!=="svelte-nyyx9j"&&(Oo.innerHTML=lk),rb=s(e),qo=p(e,"TABLE",{"data-svelte-h":!0}),o(qo)!=="svelte-1e229ag"&&(qo.innerHTML=ik),mb=s(e),Ko=p(e,"P",{"data-svelte-h":!0}),o(Ko)!=="svelte-drbxoe"&&(Ko.innerHTML=nk),ub=s(e),ed=p(e,"TABLE",{"data-svelte-h":!0}),o(ed)!=="svelte-k6x8ku"&&(ed.innerHTML=sk),Mb=s(e),Tb=p(e,"HR",{}),yb=s(e),td=p(e,"A",{id:!0,class:!0}),y(td).forEach(l),hb=s(e),r(ld.$$.fragment,e),Jb=s(e),id=p(e,"P",{"data-svelte-h":!0}),o(id)!=="svelte-1j7a9hq"&&(id.textContent=ak),fb=s(e),nd=p(e,"P",{"data-svelte-h":!0}),o(nd)!=="svelte-dxlreg"&&(nd.innerHTML=pk),wb=s(e),sd=p(e,"TABLE",{"data-svelte-h":!0}),o(sd)!=="svelte-1ij1nih"&&(sd.innerHTML=ok),jb=s(e),ad=p(e,"P",{"data-svelte-h":!0}),o(ad)!=="svelte-drbxoe"&&(ad.innerHTML=dk),Ub=s(e),pd=p(e,"TABLE",{"data-svelte-h":!0}),o(pd)!=="svelte-4g6d9h"&&(pd.innerHTML=ck),bb=s(e),xb=p(e,"HR",{}),gb=s(e),od=p(e,"A",{id:!0,class:!0}),y(od).forEach(l),Cb=s(e),r(dd.$$.fragment,e),Ib=s(e),cd=p(e,"P",{"data-svelte-h":!0}),o(cd)!=="svelte-zg073o"&&(cd.textContent=rk),kb=s(e),rd=p(e,"P",{"data-svelte-h":!0}),o(rd)!=="svelte-1p0pjr6"&&(rd.innerHTML=mk),Ab=s(e),md=p(e,"TABLE",{"data-svelte-h":!0}),o(md)!=="svelte-1fnbyk"&&(md.innerHTML=uk),Pb=s(e),ud=p(e,"P",{"data-svelte-h":!0}),o(ud)!=="svelte-drbxoe"&&(ud.innerHTML=Mk),_b=s(e),Md=p(e,"TABLE",{"data-svelte-h":!0}),o(Md)!=="svelte-hzkuju"&&(Md.innerHTML=Tk),$b=s(e),vb=p(e,"HR",{}),Qb=s(e),Td=p(e,"A",{id:!0,class:!0}),y(Td).forEach(l),Gb=s(e),r(yd.$$.fragment,e),Hb=s(e),hd=p(e,"P",{"data-svelte-h":!0}),o(hd)!=="svelte-uiu8uf"&&(hd.textContent=yk),Zb=s(e),Jd=p(e,"P",{"data-svelte-h":!0}),o(Jd)!=="svelte-1rznspb"&&(Jd.innerHTML=hk),Bb=s(e),fd=p(e,"TABLE",{"data-svelte-h":!0}),o(fd)!=="svelte-1t7i0jv"&&(fd.innerHTML=Jk),Eb=s(e),wd=p(e,"P",{"data-svelte-h":!0}),o(wd)!=="svelte-drbxoe"&&(wd.innerHTML=fk),Nb=s(e),jd=p(e,"TABLE",{"data-svelte-h":!0}),o(jd)!=="svelte-1vg0xo5"&&(jd.innerHTML=wk),Yb=s(e),Rb=p(e,"HR",{}),zb=s(e),Ud=p(e,"A",{id:!0,class:!0}),y(Ud).forEach(l),Lb=s(e),r(bd.$$.fragment,e),Sb=s(e),xd=p(e,"P",{"data-svelte-h":!0}),o(xd)!=="svelte-1axcw5l"&&(xd.innerHTML=jk),Wb=s(e),gd=p(e,"TABLE",{"data-svelte-h":!0}),o(gd)!=="svelte-1dq41av"&&(gd.innerHTML=Uk),Xb=s(e),Db=p(e,"HR",{}),Fb=s(e),Cd=p(e,"A",{id:!0,class:!0}),y(Cd).forEach(l),Vb=s(e),r(Id.$$.fragment,e),Ob=s(e),kd=p(e,"P",{"data-svelte-h":!0}),o(kd)!=="svelte-ptv3i7"&&(kd.innerHTML=bk),qb=s(e),Ad=p(e,"TABLE",{"data-svelte-h":!0}),o(Ad)!=="svelte-iwz8lt"&&(Ad.innerHTML=xk),Kb=s(e),ex=p(e,"HR",{}),tx=s(e),Pd=p(e,"A",{id:!0,class:!0}),y(Pd).forEach(l),lx=s(e),r(_d.$$.fragment,e),ix=s(e),$d=p(e,"P",{"data-svelte-h":!0}),o($d)!=="svelte-2ut6tw"&&($d.textContent=gk),nx=s(e),vd=p(e,"P",{"data-svelte-h":!0}),o(vd)!=="svelte-1mwkilo"&&(vd.innerHTML=Ck),sx=s(e),Qd=p(e,"TABLE",{"data-svelte-h":!0}),o(Qd)!=="svelte-zqs65k"&&(Qd.innerHTML=Ik),ax=s(e),Gd=p(e,"P",{"data-svelte-h":!0}),o(Gd)!=="svelte-drbxoe"&&(Gd.innerHTML=kk),px=s(e),Hd=p(e,"TABLE",{"data-svelte-h":!0}),o(Hd)!=="svelte-9x0kw5"&&(Hd.innerHTML=Ak),ox=s(e),dx=p(e,"HR",{}),cx=s(e),Zd=p(e,"A",{id:!0,class:!0}),y(Zd).forEach(l),rx=s(e),r(Bd.$$.fragment,e),mx=s(e),Ed=p(e,"P",{"data-svelte-h":!0}),o(Ed)!=="svelte-d49qij"&&(Ed.innerHTML=Pk),ux=s(e),Nd=p(e,"TABLE",{"data-svelte-h":!0}),o(Nd)!=="svelte-ygxxf5"&&(Nd.innerHTML=_k),Mx=s(e),Yd=p(e,"P",{"data-svelte-h":!0}),o(Yd)!=="svelte-drbxoe"&&(Yd.innerHTML=$k),Tx=s(e),Rd=p(e,"TABLE",{"data-svelte-h":!0}),o(Rd)!=="svelte-jpm10y"&&(Rd.innerHTML=vk),yx=s(e),hx=p(e,"HR",{}),Jx=s(e),zd=p(e,"A",{id:!0,class:!0}),y(zd).forEach(l),fx=s(e),r(Ld.$$.fragment,e),wx=s(e),Sd=p(e,"P",{"data-svelte-h":!0}),o(Sd)!=="svelte-10azskl"&&(Sd.textContent=Qk),jx=s(e),Wd=p(e,"P",{"data-svelte-h":!0}),o(Wd)!=="svelte-1bdsbsy"&&(Wd.innerHTML=Gk),Ux=s(e),Xd=p(e,"TABLE",{"data-svelte-h":!0}),o(Xd)!=="svelte-1rcn5yv"&&(Xd.innerHTML=Hk),bx=s(e),Dd=p(e,"P",{"data-svelte-h":!0}),o(Dd)!=="svelte-drbxoe"&&(Dd.innerHTML=Zk),xx=s(e),Fd=p(e,"TABLE",{"data-svelte-h":!0}),o(Fd)!=="svelte-1yeqa7q"&&(Fd.innerHTML=Bk),gx=s(e),Cx=p(e,"HR",{}),Ix=s(e),Vd=p(e,"A",{id:!0,class:!0}),y(Vd).forEach(l),kx=s(e),r(Od.$$.fragment,e),Ax=s(e),qd=p(e,"P",{"data-svelte-h":!0}),o(qd)!=="svelte-1jdk7q7"&&(qd.textContent=Ek),Px=s(e),Kd=p(e,"P",{"data-svelte-h":!0}),o(Kd)!=="svelte-17rpkxy"&&(Kd.innerHTML=Nk),_x=s(e),ec=p(e,"TABLE",{"data-svelte-h":!0}),o(ec)!=="svelte-12zqzt2"&&(ec.innerHTML=Yk),$x=s(e),tc=p(e,"P",{"data-svelte-h":!0}),o(tc)!=="svelte-drbxoe"&&(tc.innerHTML=Rk),vx=s(e),lc=p(e,"TABLE",{"data-svelte-h":!0}),o(lc)!=="svelte-1d2sb6a"&&(lc.innerHTML=zk),Qx=s(e),Gx=p(e,"HR",{}),Hx=s(e),ic=p(e,"A",{id:!0,class:!0}),y(ic).forEach(l),Zx=s(e),r(nc.$$.fragment,e),Bx=s(e),sc=p(e,"P",{"data-svelte-h":!0}),o(sc)!=="svelte-61xmb6"&&(sc.textContent=Lk),Ex=s(e),ac=p(e,"P",{"data-svelte-h":!0}),o(ac)!=="svelte-1c819p5"&&(ac.innerHTML=Sk),Nx=s(e),pc=p(e,"TABLE",{"data-svelte-h":!0}),o(pc)!=="svelte-1ql6xpw"&&(pc.innerHTML=Wk),Yx=s(e),oc=p(e,"P",{"data-svelte-h":!0}),o(oc)!=="svelte-drbxoe"&&(oc.innerHTML=Xk),Rx=s(e),dc=p(e,"TABLE",{"data-svelte-h":!0}),o(dc)!=="svelte-14miuwu"&&(dc.innerHTML=Dk),zx=s(e),Lx=p(e,"HR",{}),Sx=s(e),cc=p(e,"A",{id:!0,class:!0}),y(cc).forEach(l),Wx=s(e),r(rc.$$.fragment,e),Xx=s(e),mc=p(e,"P",{"data-svelte-h":!0}),o(mc)!=="svelte-4x8tbi"&&(mc.textContent=Fk),Dx=s(e),uc=p(e,"P",{"data-svelte-h":!0}),o(uc)!=="svelte-148mxfe"&&(uc.innerHTML=Vk),Fx=s(e),Mc=p(e,"TABLE",{"data-svelte-h":!0}),o(Mc)!=="svelte-nx9uxw"&&(Mc.innerHTML=Ok),Vx=s(e),Tc=p(e,"P",{"data-svelte-h":!0}),o(Tc)!=="svelte-drbxoe"&&(Tc.innerHTML=qk),Ox=s(e),yc=p(e,"TABLE",{"data-svelte-h":!0}),o(yc)!=="svelte-20m6rc"&&(yc.innerHTML=Kk),qx=s(e),Kx=p(e,"HR",{}),e1=s(e),hc=p(e,"A",{id:!0,class:!0}),y(hc).forEach(l),t1=s(e),r(Jc.$$.fragment,e),l1=s(e),fc=p(e,"P",{"data-svelte-h":!0}),o(fc)!=="svelte-ficm91"&&(fc.textContent=eA),i1=s(e),wc=p(e,"P",{"data-svelte-h":!0}),o(wc)!=="svelte-1886dy0"&&(wc.innerHTML=tA),n1=s(e),jc=p(e,"TABLE",{"data-svelte-h":!0}),o(jc)!=="svelte-hp09xx"&&(jc.innerHTML=lA),s1=s(e),Uc=p(e,"P",{"data-svelte-h":!0}),o(Uc)!=="svelte-drbxoe"&&(Uc.innerHTML=iA),a1=s(e),bc=p(e,"TABLE",{"data-svelte-h":!0}),o(bc)!=="svelte-1oa56ji"&&(bc.innerHTML=nA),p1=s(e),o1=p(e,"HR",{}),d1=s(e),xc=p(e,"A",{id:!0,class:!0}),y(xc).forEach(l),c1=s(e),r(gc.$$.fragment,e),r1=s(e),Cc=p(e,"P",{"data-svelte-h":!0}),o(Cc)!=="svelte-towoux"&&(Cc.innerHTML=sA),m1=s(e),Ic=p(e,"TABLE",{"data-svelte-h":!0}),o(Ic)!=="svelte-196k7qb"&&(Ic.innerHTML=aA),u1=s(e),kc=p(e,"P",{"data-svelte-h":!0}),o(kc)!=="svelte-drbxoe"&&(kc.innerHTML=pA),M1=s(e),Ac=p(e,"TABLE",{"data-svelte-h":!0}),o(Ac)!=="svelte-14s1ibx"&&(Ac.innerHTML=oA),T1=s(e),y1=p(e,"HR",{}),h1=s(e),Pc=p(e,"A",{id:!0,class:!0}),y(Pc).forEach(l),J1=s(e),r(_c.$$.fragment,e),f1=s(e),$c=p(e,"P",{"data-svelte-h":!0}),o($c)!=="svelte-ptv3i7"&&($c.innerHTML=dA),w1=s(e),vc=p(e,"TABLE",{"data-svelte-h":!0}),o(vc)!=="svelte-10h9uf2"&&(vc.innerHTML=cA),j1=s(e),U1=p(e,"HR",{}),b1=s(e),Qc=p(e,"A",{id:!0,class:!0}),y(Qc).forEach(l),x1=s(e),r(Gc.$$.fragment,e),g1=s(e),Hc=p(e,"P",{"data-svelte-h":!0}),o(Hc)!=="svelte-e3q3ck"&&(Hc.textContent=rA),C1=s(e),Zc=p(e,"P",{"data-svelte-h":!0}),o(Zc)!=="svelte-djs0r5"&&(Zc.innerHTML=mA),I1=s(e),Bc=p(e,"TABLE",{"data-svelte-h":!0}),o(Bc)!=="svelte-1tcwp3s"&&(Bc.innerHTML=uA),k1=s(e),Ec=p(e,"P",{"data-svelte-h":!0}),o(Ec)!=="svelte-drbxoe"&&(Ec.innerHTML=MA),A1=s(e),Nc=p(e,"TABLE",{"data-svelte-h":!0}),o(Nc)!=="svelte-zr1e6w"&&(Nc.innerHTML=TA),P1=s(e),_1=p(e,"HR",{}),$1=s(e),Yc=p(e,"A",{id:!0,class:!0}),y(Yc).forEach(l),v1=s(e),r(Rc.$$.fragment,e),Q1=s(e),zc=p(e,"P",{"data-svelte-h":!0}),o(zc)!=="svelte-qri2bt"&&(zc.innerHTML=yA),G1=s(e),Lc=p(e,"TABLE",{"data-svelte-h":!0}),o(Lc)!=="svelte-1a5japr"&&(Lc.innerHTML=hA),H1=s(e),Z1=p(e,"HR",{}),B1=s(e),Sc=p(e,"A",{id:!0,class:!0}),y(Sc).forEach(l),E1=s(e),r(Wc.$$.fragment,e),N1=s(e),Xc=p(e,"P",{"data-svelte-h":!0}),o(Xc)!=="svelte-1h3fxm6"&&(Xc.innerHTML=JA),Y1=s(e),Dc=p(e,"TABLE",{"data-svelte-h":!0}),o(Dc)!=="svelte-15hpala"&&(Dc.innerHTML=fA),R1=s(e),Fc=p(e,"P",{"data-svelte-h":!0}),o(Fc)!=="svelte-drbxoe"&&(Fc.innerHTML=wA),z1=s(e),Vc=p(e,"TABLE",{"data-svelte-h":!0}),o(Vc)!=="svelte-6tjavy"&&(Vc.innerHTML=jA),L1=s(e),S1=p(e,"HR",{}),W1=s(e),Oc=p(e,"A",{id:!0,class:!0}),y(Oc).forEach(l),X1=s(e),r(qc.$$.fragment,e),D1=s(e),Kc=p(e,"P",{"data-svelte-h":!0}),o(Kc)!=="svelte-1r368bj"&&(Kc.textContent=UA),F1=s(e),er=p(e,"P",{"data-svelte-h":!0}),o(er)!=="svelte-1axcw5l"&&(er.innerHTML=bA),V1=s(e),O1=p(e,"HR",{}),q1=s(e),lr=p(e,"P",{}),y(lr).forEach(l),this.h()},h(){d(f,"name","hf:doc:metadata"),d(f,"content",$A),d(w,"id","module_pipelines"),d(w,"class","group"),d(C,"id","module_pipelines.Pipeline"),d(C,"class","group"),d(_,"id","new_module_pipelines.Pipeline_new"),d(_,"class","group"),d(G,"id","module_pipelines.Pipeline+dispose"),d(G,"class","group"),d(B,"id","module_pipelines.TextClassificationPipeline"),d(B,"class","group"),d(F,"id","new_module_pipelines.TextClassificationPipeline_new"),d(F,"class","group"),d(K,"id","module_pipelines.TextClassificationPipeline+_call"),d(K,"class","group"),d(le,"id","module_pipelines.TokenClassificationPipeline"),d(le,"class","group"),d(re,"id","new_module_pipelines.TokenClassificationPipeline_new"),d(re,"class","group"),d(Te,"id","module_pipelines.TokenClassificationPipeline+_call"),d(Te,"class","group"),d(Je,"id","module_pipelines.QuestionAnsweringPipeline"),d(Je,"class","group"),d(ge,"id","new_module_pipelines.QuestionAnsweringPipeline_new"),d(ge,"class","group"),d(Ae,"id","module_pipelines.QuestionAnsweringPipeline+_call"),d(Ae,"class","group"),d($e,"id","module_pipelines.FillMaskPipeline"),d($e,"class","group"),d(Ye,"id","new_module_pipelines.FillMaskPipeline_new"),d(Ye,"class","group"),d(Se,"id","module_pipelines.FillMaskPipeline+_call"),d(Se,"class","group"),d(De,"id","module_pipelines.Text2TextGenerationPipeline"),d(De,"class","group"),d(tt,"id","new_module_pipelines.Text2TextGenerationPipeline_new"),d(tt,"class","group"),d(st,"id","module_pipelines.Text2TextGenerationPipeline+_key"),d(st,"class","group"),d(ot,"id","module_pipelines.Text2TextGenerationPipeline+_call"),d(ot,"class","group"),d(rt,"id","module_pipelines.SummarizationPipeline"),d(rt,"class","group"),d(Jt,"id","new_module_pipelines.SummarizationPipeline_new"),d(Jt,"class","group"),d(Ut,"id","module_pipelines.SummarizationPipeline+_key"),d(Ut,"class","group"),d(gt,"id","module_pipelines.TranslationPipeline"),d(gt,"class","group"),d(Et,"id","new_module_pipelines.TranslationPipeline_new"),d(Et,"class","group"),d(zt,"id","module_pipelines.TranslationPipeline+_key"),d(zt,"class","group"),d(Wt,"id","module_pipelines.TextGenerationPipeline"),d(Wt,"class","group"),d(il,"id","new_module_pipelines.TextGenerationPipeline_new"),d(il,"class","group"),d(pl,"id","module_pipelines.TextGenerationPipeline+_call"),d(pl,"class","group"),d(cl,"id","module_pipelines.ZeroShotClassificationPipeline"),d(cl,"class","group"),d(fl,"id","new_module_pipelines.ZeroShotClassificationPipeline_new"),d(fl,"class","group"),d(bl,"id","module_pipelines.ZeroShotClassificationPipeline+model"),d(bl,"class","group"),d(Cl,"id","module_pipelines.ZeroShotClassificationPipeline+_call"),d(Cl,"class","group"),d(Al,"id","module_pipelines.FeatureExtractionPipeline"),d(Al,"class","group"),d(Rl,"id","new_module_pipelines.FeatureExtractionPipeline_new"),d(Rl,"class","group"),d(Wl,"id","module_pipelines.FeatureExtractionPipeline+_call"),d(Wl,"class","group"),d(Fl,"id","module_pipelines.ImageFeatureExtractionPipeline"),d(Fl,"class","group"),d(ni,"id","new_module_pipelines.ImageFeatureExtractionPipeline_new"),d(ni,"class","group"),d(oi,"id","module_pipelines.ImageFeatureExtractionPipeline+_call"),d(oi,"class","group"),d(ri,"id","module_pipelines.AudioClassificationPipeline"),d(ri,"class","group"),d(wi,"id","new_module_pipelines.AudioClassificationPipeline_new"),d(wi,"class","group"),d(xi,"id","module_pipelines.AudioClassificationPipeline+_call"),d(xi,"class","group"),d(Ii,"id","module_pipelines.ZeroShotAudioClassificationPipeline"),d(Ii,"class","group"),d(Qi,"id","new_module_pipelines.ZeroShotAudioClassificationPipeline_new"),d(Qi,"class","group"),d(Bi,"id","module_pipelines.ZeroShotAudioClassificationPipeline+_call"),d(Bi,"class","group"),d(Yi,"id","module_pipelines.AutomaticSpeechRecognitionPipeline"),d(Yi,"class","group"),d(sn,"id","new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"),d(sn,"class","group"),d(dn,"id","module_pipelines.AutomaticSpeechRecognitionPipeline+_call"),d(dn,"class","group"),d(mn,"id","module_pipelines.ImageToTextPipeline"),d(mn,"class","group"),d(jn,"id","new_module_pipelines.ImageToTextPipeline_new"),d(jn,"class","group"),d(gn,"id","module_pipelines.ImageToTextPipeline+_call"),d(gn,"class","group"),d(kn,"id","module_pipelines.ImageClassificationPipeline"),d(kn,"class","group"),d(En,"id","new_module_pipelines.ImageClassificationPipeline_new"),d(En,"class","group"),d(zn,"id","module_pipelines.ImageClassificationPipeline+_call"),d(zn,"class","group"),d(Wn,"id","module_pipelines.ImageSegmentationPipeline"),d(Wn,"class","group"),d(Kn,"id","new_module_pipelines.ImageSegmentationPipeline_new"),d(Kn,"class","group"),d(is,"id","module_pipelines.ImageSegmentationPipeline+_call"),d(is,"class","group"),d(as,"id","module_pipelines.ZeroShotImageClassificationPipeline"),d(as,"class","group"),d(us,"id","new_module_pipelines.ZeroShotImageClassificationPipeline_new"),d(us,"class","group"),d(hs,"id","module_pipelines.ZeroShotImageClassificationPipeline+_call"),d(hs,"class","group"),d(ws,"id","module_pipelines.ObjectDetectionPipeline"),d(ws,"class","group"),d(Is,"id","new_module_pipelines.ObjectDetectionPipeline_new"),d(Is,"class","group"),d(_s,"id","module_pipelines.ObjectDetectionPipeline+_call"),d(_s,"class","group"),d(Qs,"id","module_pipelines.ZeroShotObjectDetectionPipeline"),d(Qs,"class","group"),d(zs,"id","new_module_pipelines.ZeroShotObjectDetectionPipeline_new"),d(zs,"class","group"),d(Xs,"id","module_pipelines.ZeroShotObjectDetectionPipeline+_call"),d(Xs,"class","group"),d(Vs,"id","module_pipelines.DocumentQuestionAnsweringPipeline"),d(Vs,"class","group"),d(ia,"id","new_module_pipelines.DocumentQuestionAnsweringPipeline_new"),d(ia,"class","group"),d(pa,"id","module_pipelines.DocumentQuestionAnsweringPipeline+_call"),d(pa,"class","group"),d(ca,"id","module_pipelines.TextToAudioPipeline"),d(ca,"class","group"),d(ja,"id","new_module_pipelines.TextToAudioPipeline_new"),d(ja,"class","group"),d(ga,"id","module_pipelines.TextToAudioPipeline+_call"),d(ga,"class","group"),d(ka,"id","module_pipelines.ImageToImagePipeline"),d(ka,"class","group"),d(Ga,"id","new_module_pipelines.ImageToImagePipeline_new"),d(Ga,"class","group"),d(Ea,"id","module_pipelines.ImageToImagePipeline+_call"),d(Ea,"class","group"),d(Ra,"id","module_pipelines.DepthEstimationPipeline"),d(Ra,"class","group"),d(Fa,"id","new_module_pipelines.DepthEstimationPipeline_new"),d(Fa,"class","group"),d(Ka,"id","module_pipelines.DepthEstimationPipeline+_call"),d(Ka,"class","group"),d(lp,"id","module_pipelines.pipeline"),d(lp,"class","group"),d(op,"id","module_pipelines..x[1]"),d(op,"class","group"),d(rp,"id","module_pipelines..ImagePipelineInputs"),d(rp,"class","group"),d(Mp,"id","module_pipelines..AudioPipelineInputs"),d(Mp,"class","group"),d(hp,"id","module_pipelines..BoundingBox"),d(hp,"class","group"),d(jp,"id","module_pipelines..Disposable"),d(jp,"class","group"),d(gp,"id","module_pipelines..TextPipelineConstructorArgs"),d(gp,"class","group"),d(Pp,"id","module_pipelines..ImagePipelineConstructorArgs"),d(Pp,"class","group"),d(Gp,"id","module_pipelines..TextImagePipelineConstructorArgs"),d(Gp,"class","group"),d(Np,"id","module_pipelines..TextClassificationPipelineType"),d(Np,"class","group"),d(Xp,"id","module_pipelines..TokenClassificationPipelineType"),d(Xp,"class","group"),d(eo,"id","module_pipelines..QuestionAnsweringPipelineType"),d(eo,"class","group"),d(po,"id","module_pipelines..FillMaskPipelineType"),d(po,"class","group"),d(yo,"id","module_pipelines..Text2TextGenerationPipelineType"),d(yo,"class","group"),d(Uo,"id","module_pipelines..SummarizationPipelineType"),d(Uo,"class","group"),d(ko,"id","module_pipelines..TranslationPipelineType"),d(ko,"class","group"),d(Qo,"id","module_pipelines..TextGenerationPipelineType"),d(Qo,"class","group"),d(Yo,"id","module_pipelines..ZeroShotClassificationPipelineType"),d(Yo,"class","group"),d(Do,"id","module_pipelines..FeatureExtractionPipelineType"),d(Do,"class","group"),d(td,"id","module_pipelines..ImageFeatureExtractionPipelineType"),d(td,"class","group"),d(od,"id","module_pipelines..AudioClassificationPipelineType"),d(od,"class","group"),d(Td,"id","module_pipelines..ZeroShotAudioClassificationPipelineType"),d(Td,"class","group"),d(Ud,"id","module_pipelines..ChunkCallback"),d(Ud,"class","group"),d(Cd,"id","module_pipelines..Chunk"),d(Cd,"class","group"),d(Pd,"id","module_pipelines..AutomaticSpeechRecognitionPipelineType"),d(Pd,"class","group"),d(Zd,"id","module_pipelines..ImageToTextPipelineType"),d(Zd,"class","group"),d(zd,"id","module_pipelines..ImageClassificationPipelineType"),d(zd,"class","group"),d(Vd,"id","module_pipelines..ImageSegmentationPipelineType"),d(Vd,"class","group"),d(ic,"id","module_pipelines..ZeroShotImageClassificationPipelineType"),d(ic,"class","group"),d(cc,"id","module_pipelines..ObjectDetectionPipelineType"),d(cc,"class","group"),d(hc,"id","module_pipelines..ZeroShotObjectDetectionPipelineType"),d(hc,"class","group"),d(xc,"id","module_pipelines..DocumentQuestionAnsweringPipelineType"),d(xc,"class","group"),d(Pc,"id","module_pipelines..TextToAudioPipelineConstructorArgs"),d(Pc,"class","group"),d(Qc,"id","module_pipelines..TextToAudioPipelineType"),d(Qc,"class","group"),d(Yc,"id","module_pipelines..ImageToImagePipelineType"),d(Yc,"class","group"),d(Sc,"id","module_pipelines..DepthEstimationPipelineType"),d(Sc,"class","group"),d(Oc,"id","module_pipelines..AllTasks"),d(Oc,"class","group")},m(e,t){PA(document.head,f),i(e,ir,t),i(e,tr,t),i(e,nr,t),i(e,w,t),i(e,sr,t),m(j,e,t),i(e,ar,t),i(e,U,t),i(e,pr,t),i(e,b,t),i(e,or,t),m(x,e,t),i(e,dr,t),i(e,g,t),i(e,cr,t),i(e,rr,t),i(e,mr,t),i(e,C,t),i(e,ur,t),m(I,e,t),i(e,Mr,t),i(e,k,t),i(e,Tr,t),i(e,A,t),i(e,yr,t),i(e,P,t),i(e,hr,t),i(e,Jr,t),i(e,fr,t),i(e,_,t),i(e,wr,t),m($,e,t),i(e,jr,t),i(e,v,t),i(e,Ur,t),i(e,Q,t),i(e,br,t),i(e,xr,t),i(e,gr,t),i(e,G,t),i(e,Cr,t),m(H,e,t),i(e,Ir,t),i(e,Z,t),i(e,kr,t),i(e,Ar,t),i(e,Pr,t),i(e,B,t),i(e,_r,t),m(E,e,t),i(e,$r,t),i(e,N,t),i(e,vr,t),i(e,Y,t),i(e,Qr,t),m(R,e,t),i(e,Gr,t),i(e,z,t),i(e,Hr,t),m(L,e,t),i(e,Zr,t),i(e,S,t),i(e,Br,t),m(W,e,t),i(e,Er,t),i(e,X,t),i(e,Nr,t),i(e,D,t),i(e,Yr,t),i(e,Rr,t),i(e,zr,t),i(e,F,t),i(e,Lr,t),m(V,e,t),i(e,Sr,t),i(e,O,t),i(e,Wr,t),i(e,q,t),i(e,Xr,t),i(e,Dr,t),i(e,Fr,t),i(e,K,t),i(e,Vr,t),m(ee,e,t),i(e,Or,t),i(e,te,t),i(e,qr,t),i(e,Kr,t),i(e,em,t),i(e,le,t),i(e,tm,t),m(ie,e,t),i(e,lm,t),i(e,ne,t),i(e,im,t),i(e,se,t),i(e,nm,t),m(ae,e,t),i(e,sm,t),i(e,pe,t),i(e,am,t),m(oe,e,t),i(e,pm,t),i(e,de,t),i(e,om,t),i(e,ce,t),i(e,dm,t),i(e,cm,t),i(e,rm,t),i(e,re,t),i(e,mm,t),m(me,e,t),i(e,um,t),i(e,ue,t),i(e,Mm,t),i(e,Me,t),i(e,Tm,t),i(e,ym,t),i(e,hm,t),i(e,Te,t),i(e,Jm,t),m(ye,e,t),i(e,fm,t),i(e,he,t),i(e,wm,t),i(e,jm,t),i(e,Um,t),i(e,Je,t),i(e,bm,t),m(fe,e,t),i(e,xm,t),i(e,we,t),i(e,gm,t),i(e,je,t),i(e,Cm,t),m(Ue,e,t),i(e,Im,t),i(e,be,t),i(e,km,t),i(e,xe,t),i(e,Am,t),i(e,Pm,t),i(e,_m,t),i(e,ge,t),i(e,$m,t),m(Ce,e,t),i(e,vm,t),i(e,Ie,t),i(e,Qm,t),i(e,ke,t),i(e,Gm,t),i(e,Hm,t),i(e,Zm,t),i(e,Ae,t),i(e,Bm,t),m(Pe,e,t),i(e,Em,t),i(e,_e,t),i(e,Nm,t),i(e,Ym,t),i(e,Rm,t),i(e,$e,t),i(e,zm,t),m(ve,e,t),i(e,Lm,t),i(e,Qe,t),i(e,Sm,t),i(e,Ge,t),i(e,Wm,t),m(He,e,t),i(e,Xm,t),i(e,Ze,t),i(e,Dm,t),m(Be,e,t),i(e,Fm,t),i(e,Ee,t),i(e,Vm,t),i(e,Ne,t),i(e,Om,t),i(e,qm,t),i(e,Km,t),i(e,Ye,t),i(e,eu,t),m(Re,e,t),i(e,tu,t),i(e,ze,t),i(e,lu,t),i(e,Le,t),i(e,iu,t),i(e,nu,t),i(e,su,t),i(e,Se,t),i(e,au,t),m(We,e,t),i(e,pu,t),i(e,Xe,t),i(e,ou,t),i(e,du,t),i(e,cu,t),i(e,De,t),i(e,ru,t),m(Fe,e,t),i(e,mu,t),i(e,Ve,t),i(e,uu,t),i(e,Oe,t),i(e,Mu,t),m(qe,e,t),i(e,Tu,t),i(e,Ke,t),i(e,yu,t),i(e,et,t),i(e,hu,t),i(e,Ju,t),i(e,fu,t),i(e,tt,t),i(e,wu,t),m(lt,e,t),i(e,ju,t),i(e,it,t),i(e,Uu,t),i(e,nt,t),i(e,bu,t),i(e,xu,t),i(e,gu,t),i(e,st,t),i(e,Cu,t),m(at,e,t),i(e,Iu,t),i(e,pt,t),i(e,ku,t),i(e,Au,t),i(e,Pu,t),i(e,ot,t),i(e,_u,t),m(dt,e,t),i(e,$u,t),i(e,ct,t),i(e,vu,t),i(e,Qu,t),i(e,Gu,t),i(e,rt,t),i(e,Hu,t),m(mt,e,t),i(e,Zu,t),i(e,ut,t),i(e,Bu,t),i(e,Mt,t),i(e,Eu,t),m(Tt,e,t),i(e,Nu,t),i(e,yt,t),i(e,Yu,t),i(e,ht,t),i(e,Ru,t),i(e,zu,t),i(e,Lu,t),i(e,Jt,t),i(e,Su,t),m(ft,e,t),i(e,Wu,t),i(e,wt,t),i(e,Xu,t),i(e,jt,t),i(e,Du,t),i(e,Fu,t),i(e,Vu,t),i(e,Ut,t),i(e,Ou,t),m(bt,e,t),i(e,qu,t),i(e,xt,t),i(e,Ku,t),i(e,eM,t),i(e,tM,t),i(e,gt,t),i(e,lM,t),m(Ct,e,t),i(e,iM,t),i(e,It,t),i(e,nM,t),i(e,kt,t),i(e,sM,t),i(e,At,t),i(e,aM,t),m(Pt,e,t),i(e,pM,t),i(e,_t,t),i(e,oM,t),i(e,$t,t),i(e,dM,t),m(vt,e,t),i(e,cM,t),i(e,Qt,t),i(e,rM,t),i(e,Gt,t),i(e,mM,t),m(Ht,e,t),i(e,uM,t),i(e,Zt,t),i(e,MM,t),i(e,Bt,t),i(e,TM,t),i(e,yM,t),i(e,hM,t),i(e,Et,t),i(e,JM,t),m(Nt,e,t),i(e,fM,t),i(e,Yt,t),i(e,wM,t),i(e,Rt,t),i(e,jM,t),i(e,UM,t),i(e,bM,t),i(e,zt,t),i(e,xM,t),m(Lt,e,t),i(e,gM,t),i(e,St,t),i(e,CM,t),i(e,IM,t),i(e,kM,t),i(e,Wt,t),i(e,AM,t),m(Xt,e,t),i(e,PM,t),i(e,Dt,t),i(e,_M,t),i(e,Ft,t),i(e,$M,t),m(Vt,e,t),i(e,vM,t),i(e,Ot,t),i(e,QM,t),m(qt,e,t),i(e,GM,t),i(e,Kt,t),i(e,HM,t),m(el,e,t),i(e,ZM,t),i(e,tl,t),i(e,BM,t),i(e,ll,t),i(e,EM,t),i(e,NM,t),i(e,YM,t),i(e,il,t),i(e,RM,t),m(nl,e,t),i(e,zM,t),i(e,sl,t),i(e,LM,t),i(e,al,t),i(e,SM,t),i(e,WM,t),i(e,XM,t),i(e,pl,t),i(e,DM,t),m(ol,e,t),i(e,FM,t),i(e,dl,t),i(e,VM,t),i(e,OM,t),i(e,qM,t),i(e,cl,t),i(e,KM,t),m(rl,e,t),i(e,eT,t),i(e,ml,t),i(e,tT,t),i(e,ul,t),i(e,lT,t),m(Ml,e,t),i(e,iT,t),i(e,Tl,t),i(e,nT,t),m(yl,e,t),i(e,sT,t),i(e,hl,t),i(e,aT,t),i(e,Jl,t),i(e,pT,t),i(e,oT,t),i(e,dT,t),i(e,fl,t),i(e,cT,t),m(wl,e,t),i(e,rT,t),i(e,jl,t),i(e,mT,t),i(e,Ul,t),i(e,uT,t),i(e,MT,t),i(e,TT,t),i(e,bl,t),i(e,yT,t),m(xl,e,t),i(e,hT,t),i(e,gl,t),i(e,JT,t),i(e,fT,t),i(e,wT,t),i(e,Cl,t),i(e,jT,t),m(Il,e,t),i(e,UT,t),i(e,kl,t),i(e,bT,t),i(e,xT,t),i(e,gT,t),i(e,Al,t),i(e,CT,t),m(Pl,e,t),i(e,IT,t),i(e,_l,t),i(e,kT,t),i(e,$l,t),i(e,AT,t),m(vl,e,t),i(e,PT,t),i(e,Ql,t),i(e,_T,t),m(Gl,e,t),i(e,$T,t),i(e,Hl,t),i(e,vT,t),m(Zl,e,t),i(e,QT,t),i(e,Bl,t),i(e,GT,t),m(El,e,t),i(e,HT,t),i(e,Nl,t),i(e,ZT,t),i(e,Yl,t),i(e,BT,t),i(e,ET,t),i(e,NT,t),i(e,Rl,t),i(e,YT,t),m(zl,e,t),i(e,RT,t),i(e,Ll,t),i(e,zT,t),i(e,Sl,t),i(e,LT,t),i(e,ST,t),i(e,WT,t),i(e,Wl,t),i(e,XT,t),m(Xl,e,t),i(e,DT,t),i(e,Dl,t),i(e,FT,t),i(e,VT,t),i(e,OT,t),i(e,Fl,t),i(e,qT,t),m(Vl,e,t),i(e,KT,t),i(e,Ol,t),i(e,ey,t),i(e,ql,t),i(e,ty,t),m(Kl,e,t),i(e,ly,t),i(e,ei,t),i(e,iy,t),m(ti,e,t),i(e,ny,t),i(e,li,t),i(e,sy,t),i(e,ii,t),i(e,ay,t),i(e,py,t),i(e,oy,t),i(e,ni,t),i(e,dy,t),m(si,e,t),i(e,cy,t),i(e,ai,t),i(e,ry,t),i(e,pi,t),i(e,my,t),i(e,uy,t),i(e,My,t),i(e,oi,t),i(e,Ty,t),m(di,e,t),i(e,yy,t),i(e,ci,t),i(e,hy,t),i(e,Jy,t),i(e,fy,t),i(e,ri,t),i(e,wy,t),m(mi,e,t),i(e,jy,t),i(e,ui,t),i(e,Uy,t),i(e,Mi,t),i(e,by,t),m(Ti,e,t),i(e,xy,t),i(e,yi,t),i(e,gy,t),m(hi,e,t),i(e,Cy,t),i(e,Ji,t),i(e,Iy,t),i(e,fi,t),i(e,ky,t),i(e,Ay,t),i(e,Py,t),i(e,wi,t),i(e,_y,t),m(ji,e,t),i(e,$y,t),i(e,Ui,t),i(e,vy,t),i(e,bi,t),i(e,Qy,t),i(e,Gy,t),i(e,Hy,t),i(e,xi,t),i(e,Zy,t),m(gi,e,t),i(e,By,t),i(e,Ci,t),i(e,Ey,t),i(e,Ny,t),i(e,Yy,t),i(e,Ii,t),i(e,Ry,t),m(ki,e,t),i(e,zy,t),i(e,Ai,t),i(e,Ly,t),i(e,Pi,t),i(e,Sy,t),m(_i,e,t),i(e,Wy,t),i(e,$i,t),i(e,Xy,t),i(e,vi,t),i(e,Dy,t),i(e,Fy,t),i(e,Vy,t),i(e,Qi,t),i(e,Oy,t),m(Gi,e,t),i(e,qy,t),i(e,Hi,t),i(e,Ky,t),i(e,Zi,t),i(e,eh,t),i(e,th,t),i(e,lh,t),i(e,Bi,t),i(e,ih,t),m(Ei,e,t),i(e,nh,t),i(e,Ni,t),i(e,sh,t),i(e,ah,t),i(e,ph,t),i(e,Yi,t),i(e,oh,t),m(Ri,e,t),i(e,dh,t),i(e,zi,t),i(e,ch,t),i(e,Li,t),i(e,rh,t),m(Si,e,t),i(e,mh,t),i(e,Wi,t),i(e,uh,t),m(Xi,e,t),i(e,Mh,t),i(e,Di,t),i(e,Th,t),m(Fi,e,t),i(e,yh,t),i(e,Vi,t),i(e,hh,t),m(Oi,e,t),i(e,Jh,t),i(e,qi,t),i(e,fh,t),m(Ki,e,t),i(e,wh,t),i(e,en,t),i(e,jh,t),m(tn,e,t),i(e,Uh,t),i(e,ln,t),i(e,bh,t),i(e,nn,t),i(e,xh,t),i(e,gh,t),i(e,Ch,t),i(e,sn,t),i(e,Ih,t),m(an,e,t),i(e,kh,t),i(e,pn,t),i(e,Ah,t),i(e,on,t),i(e,Ph,t),i(e,_h,t),i(e,$h,t),i(e,dn,t),i(e,vh,t),m(cn,e,t),i(e,Qh,t),i(e,rn,t),i(e,Gh,t),i(e,Hh,t),i(e,Zh,t),i(e,mn,t),i(e,Bh,t),m(un,e,t),i(e,Eh,t),i(e,Mn,t),i(e,Nh,t),i(e,Tn,t),i(e,Yh,t),m(yn,e,t),i(e,Rh,t),i(e,hn,t),i(e,zh,t),m(Jn,e,t),i(e,Lh,t),i(e,fn,t),i(e,Sh,t),i(e,wn,t),i(e,Wh,t),i(e,Xh,t),i(e,Dh,t),i(e,jn,t),i(e,Fh,t),m(Un,e,t),i(e,Vh,t),i(e,bn,t),i(e,Oh,t),i(e,xn,t),i(e,qh,t),i(e,Kh,t),i(e,eJ,t),i(e,gn,t),i(e,tJ,t),m(Cn,e,t),i(e,lJ,t),i(e,In,t),i(e,iJ,t),i(e,nJ,t),i(e,sJ,t),i(e,kn,t),i(e,aJ,t),m(An,e,t),i(e,pJ,t),i(e,Pn,t),i(e,oJ,t),i(e,_n,t),i(e,dJ,t),m($n,e,t),i(e,cJ,t),i(e,vn,t),i(e,rJ,t),m(Qn,e,t),i(e,mJ,t),i(e,Gn,t),i(e,uJ,t),m(Hn,e,t),i(e,MJ,t),i(e,Zn,t),i(e,TJ,t),i(e,Bn,t),i(e,yJ,t),i(e,hJ,t),i(e,JJ,t),i(e,En,t),i(e,fJ,t),m(Nn,e,t),i(e,wJ,t),i(e,Yn,t),i(e,jJ,t),i(e,Rn,t),i(e,UJ,t),i(e,bJ,t),i(e,xJ,t),i(e,zn,t),i(e,gJ,t),m(Ln,e,t),i(e,CJ,t),i(e,Sn,t),i(e,IJ,t),i(e,kJ,t),i(e,AJ,t),i(e,Wn,t),i(e,PJ,t),m(Xn,e,t),i(e,_J,t),i(e,Dn,t),i(e,$J,t),i(e,Fn,t),i(e,vJ,t),m(Vn,e,t),i(e,QJ,t),i(e,On,t),i(e,GJ,t),i(e,qn,t),i(e,HJ,t),i(e,ZJ,t),i(e,BJ,t),i(e,Kn,t),i(e,EJ,t),m(es,e,t),i(e,NJ,t),i(e,ts,t),i(e,YJ,t),i(e,ls,t),i(e,RJ,t),i(e,zJ,t),i(e,LJ,t),i(e,is,t),i(e,SJ,t),m(ns,e,t),i(e,WJ,t),i(e,ss,t),i(e,XJ,t),i(e,DJ,t),i(e,FJ,t),i(e,as,t),i(e,VJ,t),m(ps,e,t),i(e,OJ,t),i(e,os,t),i(e,qJ,t),i(e,ds,t),i(e,KJ,t),m(cs,e,t),i(e,ef,t),i(e,rs,t),i(e,tf,t),i(e,ms,t),i(e,lf,t),i(e,nf,t),i(e,sf,t),i(e,us,t),i(e,af,t),m(Ms,e,t),i(e,pf,t),i(e,Ts,t),i(e,of,t),i(e,ys,t),i(e,df,t),i(e,cf,t),i(e,rf,t),i(e,hs,t),i(e,mf,t),m(Js,e,t),i(e,uf,t),i(e,fs,t),i(e,Mf,t),i(e,Tf,t),i(e,yf,t),i(e,ws,t),i(e,hf,t),m(js,e,t),i(e,Jf,t),i(e,Us,t),i(e,ff,t),i(e,bs,t),i(e,wf,t),m(xs,e,t),i(e,jf,t),i(e,gs,t),i(e,Uf,t),i(e,Cs,t),i(e,bf,t),i(e,xf,t),i(e,gf,t),i(e,Is,t),i(e,Cf,t),m(ks,e,t),i(e,If,t),i(e,As,t),i(e,kf,t),i(e,Ps,t),i(e,Af,t),i(e,Pf,t),i(e,_f,t),i(e,_s,t),i(e,$f,t),m($s,e,t),i(e,vf,t),i(e,vs,t),i(e,Qf,t),i(e,Gf,t),i(e,Hf,t),i(e,Qs,t),i(e,Zf,t),m(Gs,e,t),i(e,Bf,t),i(e,Hs,t),i(e,Ef,t),i(e,Zs,t),i(e,Nf,t),m(Bs,e,t),i(e,Yf,t),i(e,Es,t),i(e,Rf,t),m(Ns,e,t),i(e,zf,t),i(e,Ys,t),i(e,Lf,t),i(e,Rs,t),i(e,Sf,t),i(e,Wf,t),i(e,Xf,t),i(e,zs,t),i(e,Df,t),m(Ls,e,t),i(e,Ff,t),i(e,Ss,t),i(e,Vf,t),i(e,Ws,t),i(e,Of,t),i(e,qf,t),i(e,Kf,t),i(e,Xs,t),i(e,ew,t),m(Ds,e,t),i(e,tw,t),i(e,Fs,t),i(e,lw,t),i(e,iw,t),i(e,nw,t),i(e,Vs,t),i(e,sw,t),m(Os,e,t),i(e,aw,t),i(e,qs,t),i(e,pw,t),i(e,Ks,t),i(e,ow,t),m(ea,e,t),i(e,dw,t),i(e,ta,t),i(e,cw,t),i(e,la,t),i(e,rw,t),i(e,mw,t),i(e,uw,t),i(e,ia,t),i(e,Mw,t),m(na,e,t),i(e,Tw,t),i(e,sa,t),i(e,yw,t),i(e,aa,t),i(e,hw,t),i(e,Jw,t),i(e,fw,t),i(e,pa,t),i(e,ww,t),m(oa,e,t),i(e,jw,t),i(e,da,t),i(e,Uw,t),i(e,bw,t),i(e,xw,t),i(e,ca,t),i(e,gw,t),m(ra,e,t),i(e,Cw,t),i(e,ma,t),i(e,Iw,t),i(e,ua,t),i(e,kw,t),m(Ma,e,t),i(e,Aw,t),i(e,Ta,t),i(e,Pw,t),m(ya,e,t),i(e,_w,t),i(e,ha,t),i(e,$w,t),m(Ja,e,t),i(e,vw,t),i(e,fa,t),i(e,Qw,t),i(e,wa,t),i(e,Gw,t),i(e,Hw,t),i(e,Zw,t),i(e,ja,t),i(e,Bw,t),m(Ua,e,t),i(e,Ew,t),i(e,ba,t),i(e,Nw,t),i(e,xa,t),i(e,Yw,t),i(e,Rw,t),i(e,zw,t),i(e,ga,t),i(e,Lw,t),m(Ca,e,t),i(e,Sw,t),i(e,Ia,t),i(e,Ww,t),i(e,Xw,t),i(e,Dw,t),i(e,ka,t),i(e,Fw,t),m(Aa,e,t),i(e,Vw,t),i(e,Pa,t),i(e,Ow,t),i(e,_a,t),i(e,qw,t),m($a,e,t),i(e,Kw,t),i(e,va,t),i(e,e2,t),i(e,Qa,t),i(e,t2,t),i(e,l2,t),i(e,i2,t),i(e,Ga,t),i(e,n2,t),m(Ha,e,t),i(e,s2,t),i(e,Za,t),i(e,a2,t),i(e,Ba,t),i(e,p2,t),i(e,o2,t),i(e,d2,t),i(e,Ea,t),i(e,c2,t),m(Na,e,t),i(e,r2,t),i(e,Ya,t),i(e,m2,t),i(e,u2,t),i(e,M2,t),i(e,Ra,t),i(e,T2,t),m(za,e,t),i(e,y2,t),i(e,La,t),i(e,h2,t),i(e,Sa,t),i(e,J2,t),m(Wa,e,t),i(e,f2,t),i(e,Xa,t),i(e,w2,t),i(e,Da,t),i(e,j2,t),i(e,U2,t),i(e,b2,t),i(e,Fa,t),i(e,x2,t),m(Va,e,t),i(e,g2,t),i(e,Oa,t),i(e,C2,t),i(e,qa,t),i(e,I2,t),i(e,k2,t),i(e,A2,t),i(e,Ka,t),i(e,P2,t),m(ep,e,t),i(e,_2,t),i(e,tp,t),i(e,$2,t),i(e,v2,t),i(e,Q2,t),i(e,lp,t),i(e,G2,t),m(ip,e,t),i(e,H2,t),i(e,np,t),i(e,Z2,t),i(e,sp,t),i(e,B2,t),i(e,ap,t),i(e,E2,t),i(e,pp,t),i(e,N2,t),i(e,Y2,t),i(e,R2,t),i(e,op,t),i(e,z2,t),m(dp,e,t),i(e,L2,t),i(e,cp,t),i(e,S2,t),i(e,W2,t),i(e,X2,t),i(e,rp,t),i(e,D2,t),m(mp,e,t),i(e,F2,t),i(e,up,t),i(e,V2,t),i(e,O2,t),i(e,q2,t),i(e,Mp,t),i(e,K2,t),m(Tp,e,t),i(e,ej,t),i(e,yp,t),i(e,tj,t),i(e,lj,t),i(e,ij,t),i(e,hp,t),i(e,nj,t),m(Jp,e,t),i(e,sj,t),i(e,fp,t),i(e,aj,t),i(e,wp,t),i(e,pj,t),i(e,oj,t),i(e,dj,t),i(e,jp,t),i(e,cj,t),m(Up,e,t),i(e,rj,t),i(e,bp,t),i(e,mj,t),i(e,xp,t),i(e,uj,t),i(e,Mj,t),i(e,Tj,t),i(e,gp,t),i(e,yj,t),m(Cp,e,t),i(e,hj,t),i(e,Ip,t),i(e,Jj,t),i(e,kp,t),i(e,fj,t),i(e,Ap,t),i(e,wj,t),i(e,jj,t),i(e,Uj,t),i(e,Pp,t),i(e,bj,t),m(_p,e,t),i(e,xj,t),i(e,$p,t),i(e,gj,t),i(e,vp,t),i(e,Cj,t),i(e,Qp,t),i(e,Ij,t),i(e,kj,t),i(e,Aj,t),i(e,Gp,t),i(e,Pj,t),m(Hp,e,t),i(e,_j,t),i(e,Zp,t),i(e,$j,t),i(e,Bp,t),i(e,vj,t),i(e,Ep,t),i(e,Qj,t),i(e,Gj,t),i(e,Hj,t),i(e,Np,t),i(e,Zj,t),m(Yp,e,t),i(e,Bj,t),i(e,Rp,t),i(e,Ej,t),i(e,zp,t),i(e,Nj,t),i(e,Lp,t),i(e,Yj,t),i(e,Sp,t),i(e,Rj,t),i(e,Wp,t),i(e,zj,t),i(e,Lj,t),i(e,Sj,t),i(e,Xp,t),i(e,Wj,t),m(Dp,e,t),i(e,Xj,t),i(e,Fp,t),i(e,Dj,t),i(e,Vp,t),i(e,Fj,t),i(e,Op,t),i(e,Vj,t),i(e,qp,t),i(e,Oj,t),i(e,Kp,t),i(e,qj,t),i(e,Kj,t),i(e,eU,t),i(e,eo,t),i(e,tU,t),m(to,e,t),i(e,lU,t),i(e,lo,t),i(e,iU,t),i(e,io,t),i(e,nU,t),i(e,no,t),i(e,sU,t),i(e,so,t),i(e,aU,t),i(e,ao,t),i(e,pU,t),i(e,oU,t),i(e,dU,t),i(e,po,t),i(e,cU,t),m(oo,e,t),i(e,rU,t),i(e,co,t),i(e,mU,t),i(e,ro,t),i(e,uU,t),i(e,mo,t),i(e,MU,t),i(e,uo,t),i(e,TU,t),i(e,Mo,t),i(e,yU,t),i(e,To,t),i(e,hU,t),i(e,JU,t),i(e,fU,t),i(e,yo,t),i(e,wU,t),m(ho,e,t),i(e,jU,t),i(e,Jo,t),i(e,UU,t),i(e,fo,t),i(e,bU,t),i(e,wo,t),i(e,xU,t),i(e,jo,t),i(e,gU,t),i(e,CU,t),i(e,IU,t),i(e,Uo,t),i(e,kU,t),m(bo,e,t),i(e,AU,t),i(e,xo,t),i(e,PU,t),i(e,go,t),i(e,_U,t),i(e,Co,t),i(e,$U,t),i(e,Io,t),i(e,vU,t),i(e,QU,t),i(e,GU,t),i(e,ko,t),i(e,HU,t),m(Ao,e,t),i(e,ZU,t),i(e,Po,t),i(e,BU,t),i(e,_o,t),i(e,EU,t),i(e,$o,t),i(e,NU,t),i(e,vo,t),i(e,YU,t),i(e,RU,t),i(e,zU,t),i(e,Qo,t),i(e,LU,t),m(Go,e,t),i(e,SU,t),i(e,Ho,t),i(e,WU,t),i(e,Zo,t),i(e,XU,t),i(e,Bo,t),i(e,DU,t),i(e,Eo,t),i(e,FU,t),i(e,No,t),i(e,VU,t),i(e,OU,t),i(e,qU,t),i(e,Yo,t),i(e,KU,t),m(Ro,e,t),i(e,eb,t),i(e,zo,t),i(e,tb,t),i(e,Lo,t),i(e,lb,t),i(e,So,t),i(e,ib,t),i(e,Wo,t),i(e,nb,t),i(e,Xo,t),i(e,sb,t),i(e,ab,t),i(e,pb,t),i(e,Do,t),i(e,ob,t),m(Fo,e,t),i(e,db,t),i(e,Vo,t),i(e,cb,t),i(e,Oo,t),i(e,rb,t),i(e,qo,t),i(e,mb,t),i(e,Ko,t),i(e,ub,t),i(e,ed,t),i(e,Mb,t),i(e,Tb,t),i(e,yb,t),i(e,td,t),i(e,hb,t),m(ld,e,t),i(e,Jb,t),i(e,id,t),i(e,fb,t),i(e,nd,t),i(e,wb,t),i(e,sd,t),i(e,jb,t),i(e,ad,t),i(e,Ub,t),i(e,pd,t),i(e,bb,t),i(e,xb,t),i(e,gb,t),i(e,od,t),i(e,Cb,t),m(dd,e,t),i(e,Ib,t),i(e,cd,t),i(e,kb,t),i(e,rd,t),i(e,Ab,t),i(e,md,t),i(e,Pb,t),i(e,ud,t),i(e,_b,t),i(e,Md,t),i(e,$b,t),i(e,vb,t),i(e,Qb,t),i(e,Td,t),i(e,Gb,t),m(yd,e,t),i(e,Hb,t),i(e,hd,t),i(e,Zb,t),i(e,Jd,t),i(e,Bb,t),i(e,fd,t),i(e,Eb,t),i(e,wd,t),i(e,Nb,t),i(e,jd,t),i(e,Yb,t),i(e,Rb,t),i(e,zb,t),i(e,Ud,t),i(e,Lb,t),m(bd,e,t),i(e,Sb,t),i(e,xd,t),i(e,Wb,t),i(e,gd,t),i(e,Xb,t),i(e,Db,t),i(e,Fb,t),i(e,Cd,t),i(e,Vb,t),m(Id,e,t),i(e,Ob,t),i(e,kd,t),i(e,qb,t),i(e,Ad,t),i(e,Kb,t),i(e,ex,t),i(e,tx,t),i(e,Pd,t),i(e,lx,t),m(_d,e,t),i(e,ix,t),i(e,$d,t),i(e,nx,t),i(e,vd,t),i(e,sx,t),i(e,Qd,t),i(e,ax,t),i(e,Gd,t),i(e,px,t),i(e,Hd,t),i(e,ox,t),i(e,dx,t),i(e,cx,t),i(e,Zd,t),i(e,rx,t),m(Bd,e,t),i(e,mx,t),i(e,Ed,t),i(e,ux,t),i(e,Nd,t),i(e,Mx,t),i(e,Yd,t),i(e,Tx,t),i(e,Rd,t),i(e,yx,t),i(e,hx,t),i(e,Jx,t),i(e,zd,t),i(e,fx,t),m(Ld,e,t),i(e,wx,t),i(e,Sd,t),i(e,jx,t),i(e,Wd,t),i(e,Ux,t),i(e,Xd,t),i(e,bx,t),i(e,Dd,t),i(e,xx,t),i(e,Fd,t),i(e,gx,t),i(e,Cx,t),i(e,Ix,t),i(e,Vd,t),i(e,kx,t),m(Od,e,t),i(e,Ax,t),i(e,qd,t),i(e,Px,t),i(e,Kd,t),i(e,_x,t),i(e,ec,t),i(e,$x,t),i(e,tc,t),i(e,vx,t),i(e,lc,t),i(e,Qx,t),i(e,Gx,t),i(e,Hx,t),i(e,ic,t),i(e,Zx,t),m(nc,e,t),i(e,Bx,t),i(e,sc,t),i(e,Ex,t),i(e,ac,t),i(e,Nx,t),i(e,pc,t),i(e,Yx,t),i(e,oc,t),i(e,Rx,t),i(e,dc,t),i(e,zx,t),i(e,Lx,t),i(e,Sx,t),i(e,cc,t),i(e,Wx,t),m(rc,e,t),i(e,Xx,t),i(e,mc,t),i(e,Dx,t),i(e,uc,t),i(e,Fx,t),i(e,Mc,t),i(e,Vx,t),i(e,Tc,t),i(e,Ox,t),i(e,yc,t),i(e,qx,t),i(e,Kx,t),i(e,e1,t),i(e,hc,t),i(e,t1,t),m(Jc,e,t),i(e,l1,t),i(e,fc,t),i(e,i1,t),i(e,wc,t),i(e,n1,t),i(e,jc,t),i(e,s1,t),i(e,Uc,t),i(e,a1,t),i(e,bc,t),i(e,p1,t),i(e,o1,t),i(e,d1,t),i(e,xc,t),i(e,c1,t),m(gc,e,t),i(e,r1,t),i(e,Cc,t),i(e,m1,t),i(e,Ic,t),i(e,u1,t),i(e,kc,t),i(e,M1,t),i(e,Ac,t),i(e,T1,t),i(e,y1,t),i(e,h1,t),i(e,Pc,t),i(e,J1,t),m(_c,e,t),i(e,f1,t),i(e,$c,t),i(e,w1,t),i(e,vc,t),i(e,j1,t),i(e,U1,t),i(e,b1,t),i(e,Qc,t),i(e,x1,t),m(Gc,e,t),i(e,g1,t),i(e,Hc,t),i(e,C1,t),i(e,Zc,t),i(e,I1,t),i(e,Bc,t),i(e,k1,t),i(e,Ec,t),i(e,A1,t),i(e,Nc,t),i(e,P1,t),i(e,_1,t),i(e,$1,t),i(e,Yc,t),i(e,v1,t),m(Rc,e,t),i(e,Q1,t),i(e,zc,t),i(e,G1,t),i(e,Lc,t),i(e,H1,t),i(e,Z1,t),i(e,B1,t),i(e,Sc,t),i(e,E1,t),m(Wc,e,t),i(e,N1,t),i(e,Xc,t),i(e,Y1,t),i(e,Dc,t),i(e,R1,t),i(e,Fc,t),i(e,z1,t),i(e,Vc,t),i(e,L1,t),i(e,S1,t),i(e,W1,t),i(e,Oc,t),i(e,X1,t),m(qc,e,t),i(e,D1,t),i(e,Kc,t),i(e,F1,t),i(e,er,t),i(e,V1,t),i(e,O1,t),i(e,q1,t),i(e,lr,t),K1=!0},p:gA,i(e){K1||(u(j.$$.fragment,e),u(x.$$.fragment,e),u(I.$$.fragment,e),u($.$$.fragment,e),u(H.$$.fragment,e),u(E.$$.fragment,e),u(R.$$.fragment,e),u(L.$$.fragment,e),u(W.$$.fragment,e),u(V.$$.fragment,e),u(ee.$$.fragment,e),u(ie.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(ye.$$.fragment,e),u(fe.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),u(Pe.$$.fragment,e),u(ve.$$.fragment,e),u(He.$$.fragment,e),u(Be.$$.fragment,e),u(Re.$$.fragment,e),u(We.$$.fragment,e),u(Fe.$$.fragment,e),u(qe.$$.fragment,e),u(lt.$$.fragment,e),u(at.$$.fragment,e),u(dt.$$.fragment,e),u(mt.$$.fragment,e),u(Tt.$$.fragment,e),u(ft.$$.fragment,e),u(bt.$$.fragment,e),u(Ct.$$.fragment,e),u(Pt.$$.fragment,e),u(vt.$$.fragment,e),u(Ht.$$.fragment,e),u(Nt.$$.fragment,e),u(Lt.$$.fragment,e),u(Xt.$$.fragment,e),u(Vt.$$.fragment,e),u(qt.$$.fragment,e),u(el.$$.fragment,e),u(nl.$$.fragment,e),u(ol.$$.fragment,e),u(rl.$$.fragment,e),u(Ml.$$.fragment,e),u(yl.$$.fragment,e),u(wl.$$.fragment,e),u(xl.$$.fragment,e),u(Il.$$.fragment,e),u(Pl.$$.fragment,e),u(vl.$$.fragment,e),u(Gl.$$.fragment,e),u(Zl.$$.fragment,e),u(El.$$.fragment,e),u(zl.$$.fragment,e),u(Xl.$$.fragment,e),u(Vl.$$.fragment,e),u(Kl.$$.fragment,e),u(ti.$$.fragment,e),u(si.$$.fragment,e),u(di.$$.fragment,e),u(mi.$$.fragment,e),u(Ti.$$.fragment,e),u(hi.$$.fragment,e),u(ji.$$.fragment,e),u(gi.$$.fragment,e),u(ki.$$.fragment,e),u(_i.$$.fragment,e),u(Gi.$$.fragment,e),u(Ei.$$.fragment,e),u(Ri.$$.fragment,e),u(Si.$$.fragment,e),u(Xi.$$.fragment,e),u(Fi.$$.fragment,e),u(Oi.$$.fragment,e),u(Ki.$$.fragment,e),u(tn.$$.fragment,e),u(an.$$.fragment,e),u(cn.$$.fragment,e),u(un.$$.fragment,e),u(yn.$$.fragment,e),u(Jn.$$.fragment,e),u(Un.$$.fragment,e),u(Cn.$$.fragment,e),u(An.$$.fragment,e),u($n.$$.fragment,e),u(Qn.$$.fragment,e),u(Hn.$$.fragment,e),u(Nn.$$.fragment,e),u(Ln.$$.fragment,e),u(Xn.$$.fragment,e),u(Vn.$$.fragment,e),u(es.$$.fragment,e),u(ns.$$.fragment,e),u(ps.$$.fragment,e),u(cs.$$.fragment,e),u(Ms.$$.fragment,e),u(Js.$$.fragment,e),u(js.$$.fragment,e),u(xs.$$.fragment,e),u(ks.$$.fragment,e),u($s.$$.fragment,e),u(Gs.$$.fragment,e),u(Bs.$$.fragment,e),u(Ns.$$.fragment,e),u(Ls.$$.fragment,e),u(Ds.$$.fragment,e),u(Os.$$.fragment,e),u(ea.$$.fragment,e),u(na.$$.fragment,e),u(oa.$$.fragment,e),u(ra.$$.fragment,e),u(Ma.$$.fragment,e),u(ya.$$.fragment,e),u(Ja.$$.fragment,e),u(Ua.$$.fragment,e),u(Ca.$$.fragment,e),u(Aa.$$.fragment,e),u($a.$$.fragment,e),u(Ha.$$.fragment,e),u(Na.$$.fragment,e),u(za.$$.fragment,e),u(Wa.$$.fragment,e),u(Va.$$.fragment,e),u(ep.$$.fragment,e),u(ip.$$.fragment,e),u(dp.$$.fragment,e),u(mp.$$.fragment,e),u(Tp.$$.fragment,e),u(Jp.$$.fragment,e),u(Up.$$.fragment,e),u(Cp.$$.fragment,e),u(_p.$$.fragment,e),u(Hp.$$.fragment,e),u(Yp.$$.fragment,e),u(Dp.$$.fragment,e),u(to.$$.fragment,e),u(oo.$$.fragment,e),u(ho.$$.fragment,e),u(bo.$$.fragment,e),u(Ao.$$.fragment,e),u(Go.$$.fragment,e),u(Ro.$$.fragment,e),u(Fo.$$.fragment,e),u(ld.$$.fragment,e),u(dd.$$.fragment,e),u(yd.$$.fragment,e),u(bd.$$.fragment,e),u(Id.$$.fragment,e),u(_d.$$.fragment,e),u(Bd.$$.fragment,e),u(Ld.$$.fragment,e),u(Od.$$.fragment,e),u(nc.$$.fragment,e),u(rc.$$.fragment,e),u(Jc.$$.fragment,e),u(gc.$$.fragment,e),u(_c.$$.fragment,e),u(Gc.$$.fragment,e),u(Rc.$$.fragment,e),u(Wc.$$.fragment,e),u(qc.$$.fragment,e),K1=!0)},o(e){M(j.$$.fragment,e),M(x.$$.fragment,e),M(I.$$.fragment,e),M($.$$.fragment,e),M(H.$$.fragment,e),M(E.$$.fragment,e),M(R.$$.fragment,e),M(L.$$.fragment,e),M(W.$$.fragment,e),M(V.$$.fragment,e),M(ee.$$.fragment,e),M(ie.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(me.$$.fragment,e),M(ye.$$.fragment,e),M(fe.$$.fragment,e),M(Ue.$$.fragment,e),M(Ce.$$.fragment,e),M(Pe.$$.fragment,e),M(ve.$$.fragment,e),M(He.$$.fragment,e),M(Be.$$.fragment,e),M(Re.$$.fragment,e),M(We.$$.fragment,e),M(Fe.$$.fragment,e),M(qe.$$.fragment,e),M(lt.$$.fragment,e),M(at.$$.fragment,e),M(dt.$$.fragment,e),M(mt.$$.fragment,e),M(Tt.$$.fragment,e),M(ft.$$.fragment,e),M(bt.$$.fragment,e),M(Ct.$$.fragment,e),M(Pt.$$.fragment,e),M(vt.$$.fragment,e),M(Ht.$$.fragment,e),M(Nt.$$.fragment,e),M(Lt.$$.fragment,e),M(Xt.$$.fragment,e),M(Vt.$$.fragment,e),M(qt.$$.fragment,e),M(el.$$.fragment,e),M(nl.$$.fragment,e),M(ol.$$.fragment,e),M(rl.$$.fragment,e),M(Ml.$$.fragment,e),M(yl.$$.fragment,e),M(wl.$$.fragment,e),M(xl.$$.fragment,e),M(Il.$$.fragment,e),M(Pl.$$.fragment,e),M(vl.$$.fragment,e),M(Gl.$$.fragment,e),M(Zl.$$.fragment,e),M(El.$$.fragment,e),M(zl.$$.fragment,e),M(Xl.$$.fragment,e),M(Vl.$$.fragment,e),M(Kl.$$.fragment,e),M(ti.$$.fragment,e),M(si.$$.fragment,e),M(di.$$.fragment,e),M(mi.$$.fragment,e),M(Ti.$$.fragment,e),M(hi.$$.fragment,e),M(ji.$$.fragment,e),M(gi.$$.fragment,e),M(ki.$$.fragment,e),M(_i.$$.fragment,e),M(Gi.$$.fragment,e),M(Ei.$$.fragment,e),M(Ri.$$.fragment,e),M(Si.$$.fragment,e),M(Xi.$$.fragment,e),M(Fi.$$.fragment,e),M(Oi.$$.fragment,e),M(Ki.$$.fragment,e),M(tn.$$.fragment,e),M(an.$$.fragment,e),M(cn.$$.fragment,e),M(un.$$.fragment,e),M(yn.$$.fragment,e),M(Jn.$$.fragment,e),M(Un.$$.fragment,e),M(Cn.$$.fragment,e),M(An.$$.fragment,e),M($n.$$.fragment,e),M(Qn.$$.fragment,e),M(Hn.$$.fragment,e),M(Nn.$$.fragment,e),M(Ln.$$.fragment,e),M(Xn.$$.fragment,e),M(Vn.$$.fragment,e),M(es.$$.fragment,e),M(ns.$$.fragment,e),M(ps.$$.fragment,e),M(cs.$$.fragment,e),M(Ms.$$.fragment,e),M(Js.$$.fragment,e),M(js.$$.fragment,e),M(xs.$$.fragment,e),M(ks.$$.fragment,e),M($s.$$.fragment,e),M(Gs.$$.fragment,e),M(Bs.$$.fragment,e),M(Ns.$$.fragment,e),M(Ls.$$.fragment,e),M(Ds.$$.fragment,e),M(Os.$$.fragment,e),M(ea.$$.fragment,e),M(na.$$.fragment,e),M(oa.$$.fragment,e),M(ra.$$.fragment,e),M(Ma.$$.fragment,e),M(ya.$$.fragment,e),M(Ja.$$.fragment,e),M(Ua.$$.fragment,e),M(Ca.$$.fragment,e),M(Aa.$$.fragment,e),M($a.$$.fragment,e),M(Ha.$$.fragment,e),M(Na.$$.fragment,e),M(za.$$.fragment,e),M(Wa.$$.fragment,e),M(Va.$$.fragment,e),M(ep.$$.fragment,e),M(ip.$$.fragment,e),M(dp.$$.fragment,e),M(mp.$$.fragment,e),M(Tp.$$.fragment,e),M(Jp.$$.fragment,e),M(Up.$$.fragment,e),M(Cp.$$.fragment,e),M(_p.$$.fragment,e),M(Hp.$$.fragment,e),M(Yp.$$.fragment,e),M(Dp.$$.fragment,e),M(to.$$.fragment,e),M(oo.$$.fragment,e),M(ho.$$.fragment,e),M(bo.$$.fragment,e),M(Ao.$$.fragment,e),M(Go.$$.fragment,e),M(Ro.$$.fragment,e),M(Fo.$$.fragment,e),M(ld.$$.fragment,e),M(dd.$$.fragment,e),M(yd.$$.fragment,e),M(bd.$$.fragment,e),M(Id.$$.fragment,e),M(_d.$$.fragment,e),M(Bd.$$.fragment,e),M(Ld.$$.fragment,e),M(Od.$$.fragment,e),M(nc.$$.fragment,e),M(rc.$$.fragment,e),M(Jc.$$.fragment,e),M(gc.$$.fragment,e),M(_c.$$.fragment,e),M(Gc.$$.fragment,e),M(Rc.$$.fragment,e),M(Wc.$$.fragment,e),M(qc.$$.fragment,e),K1=!1},d(e){e&&(l(ir),l(tr),l(nr),l(w),l(sr),l(ar),l(U),l(pr),l(b),l(or),l(dr),l(g),l(cr),l(rr),l(mr),l(C),l(ur),l(Mr),l(k),l(Tr),l(A),l(yr),l(P),l(hr),l(Jr),l(fr),l(_),l(wr),l(jr),l(v),l(Ur),l(Q),l(br),l(xr),l(gr),l(G),l(Cr),l(Ir),l(Z),l(kr),l(Ar),l(Pr),l(B),l(_r),l($r),l(N),l(vr),l(Y),l(Qr),l(Gr),l(z),l(Hr),l(Zr),l(S),l(Br),l(Er),l(X),l(Nr),l(D),l(Yr),l(Rr),l(zr),l(F),l(Lr),l(Sr),l(O),l(Wr),l(q),l(Xr),l(Dr),l(Fr),l(K),l(Vr),l(Or),l(te),l(qr),l(Kr),l(em),l(le),l(tm),l(lm),l(ne),l(im),l(se),l(nm),l(sm),l(pe),l(am),l(pm),l(de),l(om),l(ce),l(dm),l(cm),l(rm),l(re),l(mm),l(um),l(ue),l(Mm),l(Me),l(Tm),l(ym),l(hm),l(Te),l(Jm),l(fm),l(he),l(wm),l(jm),l(Um),l(Je),l(bm),l(xm),l(we),l(gm),l(je),l(Cm),l(Im),l(be),l(km),l(xe),l(Am),l(Pm),l(_m),l(ge),l($m),l(vm),l(Ie),l(Qm),l(ke),l(Gm),l(Hm),l(Zm),l(Ae),l(Bm),l(Em),l(_e),l(Nm),l(Ym),l(Rm),l($e),l(zm),l(Lm),l(Qe),l(Sm),l(Ge),l(Wm),l(Xm),l(Ze),l(Dm),l(Fm),l(Ee),l(Vm),l(Ne),l(Om),l(qm),l(Km),l(Ye),l(eu),l(tu),l(ze),l(lu),l(Le),l(iu),l(nu),l(su),l(Se),l(au),l(pu),l(Xe),l(ou),l(du),l(cu),l(De),l(ru),l(mu),l(Ve),l(uu),l(Oe),l(Mu),l(Tu),l(Ke),l(yu),l(et),l(hu),l(Ju),l(fu),l(tt),l(wu),l(ju),l(it),l(Uu),l(nt),l(bu),l(xu),l(gu),l(st),l(Cu),l(Iu),l(pt),l(ku),l(Au),l(Pu),l(ot),l(_u),l($u),l(ct),l(vu),l(Qu),l(Gu),l(rt),l(Hu),l(Zu),l(ut),l(Bu),l(Mt),l(Eu),l(Nu),l(yt),l(Yu),l(ht),l(Ru),l(zu),l(Lu),l(Jt),l(Su),l(Wu),l(wt),l(Xu),l(jt),l(Du),l(Fu),l(Vu),l(Ut),l(Ou),l(qu),l(xt),l(Ku),l(eM),l(tM),l(gt),l(lM),l(iM),l(It),l(nM),l(kt),l(sM),l(At),l(aM),l(pM),l(_t),l(oM),l($t),l(dM),l(cM),l(Qt),l(rM),l(Gt),l(mM),l(uM),l(Zt),l(MM),l(Bt),l(TM),l(yM),l(hM),l(Et),l(JM),l(fM),l(Yt),l(wM),l(Rt),l(jM),l(UM),l(bM),l(zt),l(xM),l(gM),l(St),l(CM),l(IM),l(kM),l(Wt),l(AM),l(PM),l(Dt),l(_M),l(Ft),l($M),l(vM),l(Ot),l(QM),l(GM),l(Kt),l(HM),l(ZM),l(tl),l(BM),l(ll),l(EM),l(NM),l(YM),l(il),l(RM),l(zM),l(sl),l(LM),l(al),l(SM),l(WM),l(XM),l(pl),l(DM),l(FM),l(dl),l(VM),l(OM),l(qM),l(cl),l(KM),l(eT),l(ml),l(tT),l(ul),l(lT),l(iT),l(Tl),l(nT),l(sT),l(hl),l(aT),l(Jl),l(pT),l(oT),l(dT),l(fl),l(cT),l(rT),l(jl),l(mT),l(Ul),l(uT),l(MT),l(TT),l(bl),l(yT),l(hT),l(gl),l(JT),l(fT),l(wT),l(Cl),l(jT),l(UT),l(kl),l(bT),l(xT),l(gT),l(Al),l(CT),l(IT),l(_l),l(kT),l($l),l(AT),l(PT),l(Ql),l(_T),l($T),l(Hl),l(vT),l(QT),l(Bl),l(GT),l(HT),l(Nl),l(ZT),l(Yl),l(BT),l(ET),l(NT),l(Rl),l(YT),l(RT),l(Ll),l(zT),l(Sl),l(LT),l(ST),l(WT),l(Wl),l(XT),l(DT),l(Dl),l(FT),l(VT),l(OT),l(Fl),l(qT),l(KT),l(Ol),l(ey),l(ql),l(ty),l(ly),l(ei),l(iy),l(ny),l(li),l(sy),l(ii),l(ay),l(py),l(oy),l(ni),l(dy),l(cy),l(ai),l(ry),l(pi),l(my),l(uy),l(My),l(oi),l(Ty),l(yy),l(ci),l(hy),l(Jy),l(fy),l(ri),l(wy),l(jy),l(ui),l(Uy),l(Mi),l(by),l(xy),l(yi),l(gy),l(Cy),l(Ji),l(Iy),l(fi),l(ky),l(Ay),l(Py),l(wi),l(_y),l($y),l(Ui),l(vy),l(bi),l(Qy),l(Gy),l(Hy),l(xi),l(Zy),l(By),l(Ci),l(Ey),l(Ny),l(Yy),l(Ii),l(Ry),l(zy),l(Ai),l(Ly),l(Pi),l(Sy),l(Wy),l($i),l(Xy),l(vi),l(Dy),l(Fy),l(Vy),l(Qi),l(Oy),l(qy),l(Hi),l(Ky),l(Zi),l(eh),l(th),l(lh),l(Bi),l(ih),l(nh),l(Ni),l(sh),l(ah),l(ph),l(Yi),l(oh),l(dh),l(zi),l(ch),l(Li),l(rh),l(mh),l(Wi),l(uh),l(Mh),l(Di),l(Th),l(yh),l(Vi),l(hh),l(Jh),l(qi),l(fh),l(wh),l(en),l(jh),l(Uh),l(ln),l(bh),l(nn),l(xh),l(gh),l(Ch),l(sn),l(Ih),l(kh),l(pn),l(Ah),l(on),l(Ph),l(_h),l($h),l(dn),l(vh),l(Qh),l(rn),l(Gh),l(Hh),l(Zh),l(mn),l(Bh),l(Eh),l(Mn),l(Nh),l(Tn),l(Yh),l(Rh),l(hn),l(zh),l(Lh),l(fn),l(Sh),l(wn),l(Wh),l(Xh),l(Dh),l(jn),l(Fh),l(Vh),l(bn),l(Oh),l(xn),l(qh),l(Kh),l(eJ),l(gn),l(tJ),l(lJ),l(In),l(iJ),l(nJ),l(sJ),l(kn),l(aJ),l(pJ),l(Pn),l(oJ),l(_n),l(dJ),l(cJ),l(vn),l(rJ),l(mJ),l(Gn),l(uJ),l(MJ),l(Zn),l(TJ),l(Bn),l(yJ),l(hJ),l(JJ),l(En),l(fJ),l(wJ),l(Yn),l(jJ),l(Rn),l(UJ),l(bJ),l(xJ),l(zn),l(gJ),l(CJ),l(Sn),l(IJ),l(kJ),l(AJ),l(Wn),l(PJ),l(_J),l(Dn),l($J),l(Fn),l(vJ),l(QJ),l(On),l(GJ),l(qn),l(HJ),l(ZJ),l(BJ),l(Kn),l(EJ),l(NJ),l(ts),l(YJ),l(ls),l(RJ),l(zJ),l(LJ),l(is),l(SJ),l(WJ),l(ss),l(XJ),l(DJ),l(FJ),l(as),l(VJ),l(OJ),l(os),l(qJ),l(ds),l(KJ),l(ef),l(rs),l(tf),l(ms),l(lf),l(nf),l(sf),l(us),l(af),l(pf),l(Ts),l(of),l(ys),l(df),l(cf),l(rf),l(hs),l(mf),l(uf),l(fs),l(Mf),l(Tf),l(yf),l(ws),l(hf),l(Jf),l(Us),l(ff),l(bs),l(wf),l(jf),l(gs),l(Uf),l(Cs),l(bf),l(xf),l(gf),l(Is),l(Cf),l(If),l(As),l(kf),l(Ps),l(Af),l(Pf),l(_f),l(_s),l($f),l(vf),l(vs),l(Qf),l(Gf),l(Hf),l(Qs),l(Zf),l(Bf),l(Hs),l(Ef),l(Zs),l(Nf),l(Yf),l(Es),l(Rf),l(zf),l(Ys),l(Lf),l(Rs),l(Sf),l(Wf),l(Xf),l(zs),l(Df),l(Ff),l(Ss),l(Vf),l(Ws),l(Of),l(qf),l(Kf),l(Xs),l(ew),l(tw),l(Fs),l(lw),l(iw),l(nw),l(Vs),l(sw),l(aw),l(qs),l(pw),l(Ks),l(ow),l(dw),l(ta),l(cw),l(la),l(rw),l(mw),l(uw),l(ia),l(Mw),l(Tw),l(sa),l(yw),l(aa),l(hw),l(Jw),l(fw),l(pa),l(ww),l(jw),l(da),l(Uw),l(bw),l(xw),l(ca),l(gw),l(Cw),l(ma),l(Iw),l(ua),l(kw),l(Aw),l(Ta),l(Pw),l(_w),l(ha),l($w),l(vw),l(fa),l(Qw),l(wa),l(Gw),l(Hw),l(Zw),l(ja),l(Bw),l(Ew),l(ba),l(Nw),l(xa),l(Yw),l(Rw),l(zw),l(ga),l(Lw),l(Sw),l(Ia),l(Ww),l(Xw),l(Dw),l(ka),l(Fw),l(Vw),l(Pa),l(Ow),l(_a),l(qw),l(Kw),l(va),l(e2),l(Qa),l(t2),l(l2),l(i2),l(Ga),l(n2),l(s2),l(Za),l(a2),l(Ba),l(p2),l(o2),l(d2),l(Ea),l(c2),l(r2),l(Ya),l(m2),l(u2),l(M2),l(Ra),l(T2),l(y2),l(La),l(h2),l(Sa),l(J2),l(f2),l(Xa),l(w2),l(Da),l(j2),l(U2),l(b2),l(Fa),l(x2),l(g2),l(Oa),l(C2),l(qa),l(I2),l(k2),l(A2),l(Ka),l(P2),l(_2),l(tp),l($2),l(v2),l(Q2),l(lp),l(G2),l(H2),l(np),l(Z2),l(sp),l(B2),l(ap),l(E2),l(pp),l(N2),l(Y2),l(R2),l(op),l(z2),l(L2),l(cp),l(S2),l(W2),l(X2),l(rp),l(D2),l(F2),l(up),l(V2),l(O2),l(q2),l(Mp),l(K2),l(ej),l(yp),l(tj),l(lj),l(ij),l(hp),l(nj),l(sj),l(fp),l(aj),l(wp),l(pj),l(oj),l(dj),l(jp),l(cj),l(rj),l(bp),l(mj),l(xp),l(uj),l(Mj),l(Tj),l(gp),l(yj),l(hj),l(Ip),l(Jj),l(kp),l(fj),l(Ap),l(wj),l(jj),l(Uj),l(Pp),l(bj),l(xj),l($p),l(gj),l(vp),l(Cj),l(Qp),l(Ij),l(kj),l(Aj),l(Gp),l(Pj),l(_j),l(Zp),l($j),l(Bp),l(vj),l(Ep),l(Qj),l(Gj),l(Hj),l(Np),l(Zj),l(Bj),l(Rp),l(Ej),l(zp),l(Nj),l(Lp),l(Yj),l(Sp),l(Rj),l(Wp),l(zj),l(Lj),l(Sj),l(Xp),l(Wj),l(Xj),l(Fp),l(Dj),l(Vp),l(Fj),l(Op),l(Vj),l(qp),l(Oj),l(Kp),l(qj),l(Kj),l(eU),l(eo),l(tU),l(lU),l(lo),l(iU),l(io),l(nU),l(no),l(sU),l(so),l(aU),l(ao),l(pU),l(oU),l(dU),l(po),l(cU),l(rU),l(co),l(mU),l(ro),l(uU),l(mo),l(MU),l(uo),l(TU),l(Mo),l(yU),l(To),l(hU),l(JU),l(fU),l(yo),l(wU),l(jU),l(Jo),l(UU),l(fo),l(bU),l(wo),l(xU),l(jo),l(gU),l(CU),l(IU),l(Uo),l(kU),l(AU),l(xo),l(PU),l(go),l(_U),l(Co),l($U),l(Io),l(vU),l(QU),l(GU),l(ko),l(HU),l(ZU),l(Po),l(BU),l(_o),l(EU),l($o),l(NU),l(vo),l(YU),l(RU),l(zU),l(Qo),l(LU),l(SU),l(Ho),l(WU),l(Zo),l(XU),l(Bo),l(DU),l(Eo),l(FU),l(No),l(VU),l(OU),l(qU),l(Yo),l(KU),l(eb),l(zo),l(tb),l(Lo),l(lb),l(So),l(ib),l(Wo),l(nb),l(Xo),l(sb),l(ab),l(pb),l(Do),l(ob),l(db),l(Vo),l(cb),l(Oo),l(rb),l(qo),l(mb),l(Ko),l(ub),l(ed),l(Mb),l(Tb),l(yb),l(td),l(hb),l(Jb),l(id),l(fb),l(nd),l(wb),l(sd),l(jb),l(ad),l(Ub),l(pd),l(bb),l(xb),l(gb),l(od),l(Cb),l(Ib),l(cd),l(kb),l(rd),l(Ab),l(md),l(Pb),l(ud),l(_b),l(Md),l($b),l(vb),l(Qb),l(Td),l(Gb),l(Hb),l(hd),l(Zb),l(Jd),l(Bb),l(fd),l(Eb),l(wd),l(Nb),l(jd),l(Yb),l(Rb),l(zb),l(Ud),l(Lb),l(Sb),l(xd),l(Wb),l(gd),l(Xb),l(Db),l(Fb),l(Cd),l(Vb),l(Ob),l(kd),l(qb),l(Ad),l(Kb),l(ex),l(tx),l(Pd),l(lx),l(ix),l($d),l(nx),l(vd),l(sx),l(Qd),l(ax),l(Gd),l(px),l(Hd),l(ox),l(dx),l(cx),l(Zd),l(rx),l(mx),l(Ed),l(ux),l(Nd),l(Mx),l(Yd),l(Tx),l(Rd),l(yx),l(hx),l(Jx),l(zd),l(fx),l(wx),l(Sd),l(jx),l(Wd),l(Ux),l(Xd),l(bx),l(Dd),l(xx),l(Fd),l(gx),l(Cx),l(Ix),l(Vd),l(kx),l(Ax),l(qd),l(Px),l(Kd),l(_x),l(ec),l($x),l(tc),l(vx),l(lc),l(Qx),l(Gx),l(Hx),l(ic),l(Zx),l(Bx),l(sc),l(Ex),l(ac),l(Nx),l(pc),l(Yx),l(oc),l(Rx),l(dc),l(zx),l(Lx),l(Sx),l(cc),l(Wx),l(Xx),l(mc),l(Dx),l(uc),l(Fx),l(Mc),l(Vx),l(Tc),l(Ox),l(yc),l(qx),l(Kx),l(e1),l(hc),l(t1),l(l1),l(fc),l(i1),l(wc),l(n1),l(jc),l(s1),l(Uc),l(a1),l(bc),l(p1),l(o1),l(d1),l(xc),l(c1),l(r1),l(Cc),l(m1),l(Ic),l(u1),l(kc),l(M1),l(Ac),l(T1),l(y1),l(h1),l(Pc),l(J1),l(f1),l($c),l(w1),l(vc),l(j1),l(U1),l(b1),l(Qc),l(x1),l(g1),l(Hc),l(C1),l(Zc),l(I1),l(Bc),l(k1),l(Ec),l(A1),l(Nc),l(P1),l(_1),l($1),l(Yc),l(v1),l(Q1),l(zc),l(G1),l(Lc),l(H1),l(Z1),l(B1),l(Sc),l(E1),l(N1),l(Xc),l(Y1),l(Dc),l(R1),l(Fc),l(z1),l(Vc),l(L1),l(S1),l(W1),l(Oc),l(X1),l(D1),l(Kc),l(F1),l(er),l(V1),l(O1),l(q1),l(lr)),l(f),T(j,e),T(x,e),T(I,e),T($,e),T(H,e),T(E,e),T(R,e),T(L,e),T(W,e),T(V,e),T(ee,e),T(ie,e),T(ae,e),T(oe,e),T(me,e),T(ye,e),T(fe,e),T(Ue,e),T(Ce,e),T(Pe,e),T(ve,e),T(He,e),T(Be,e),T(Re,e),T(We,e),T(Fe,e),T(qe,e),T(lt,e),T(at,e),T(dt,e),T(mt,e),T(Tt,e),T(ft,e),T(bt,e),T(Ct,e),T(Pt,e),T(vt,e),T(Ht,e),T(Nt,e),T(Lt,e),T(Xt,e),T(Vt,e),T(qt,e),T(el,e),T(nl,e),T(ol,e),T(rl,e),T(Ml,e),T(yl,e),T(wl,e),T(xl,e),T(Il,e),T(Pl,e),T(vl,e),T(Gl,e),T(Zl,e),T(El,e),T(zl,e),T(Xl,e),T(Vl,e),T(Kl,e),T(ti,e),T(si,e),T(di,e),T(mi,e),T(Ti,e),T(hi,e),T(ji,e),T(gi,e),T(ki,e),T(_i,e),T(Gi,e),T(Ei,e),T(Ri,e),T(Si,e),T(Xi,e),T(Fi,e),T(Oi,e),T(Ki,e),T(tn,e),T(an,e),T(cn,e),T(un,e),T(yn,e),T(Jn,e),T(Un,e),T(Cn,e),T(An,e),T($n,e),T(Qn,e),T(Hn,e),T(Nn,e),T(Ln,e),T(Xn,e),T(Vn,e),T(es,e),T(ns,e),T(ps,e),T(cs,e),T(Ms,e),T(Js,e),T(js,e),T(xs,e),T(ks,e),T($s,e),T(Gs,e),T(Bs,e),T(Ns,e),T(Ls,e),T(Ds,e),T(Os,e),T(ea,e),T(na,e),T(oa,e),T(ra,e),T(Ma,e),T(ya,e),T(Ja,e),T(Ua,e),T(Ca,e),T(Aa,e),T($a,e),T(Ha,e),T(Na,e),T(za,e),T(Wa,e),T(Va,e),T(ep,e),T(ip,e),T(dp,e),T(mp,e),T(Tp,e),T(Jp,e),T(Up,e),T(Cp,e),T(_p,e),T(Hp,e),T(Yp,e),T(Dp,e),T(to,e),T(oo,e),T(ho,e),T(bo,e),T(Ao,e),T(Go,e),T(Ro,e),T(Fo,e),T(ld,e),T(dd,e),T(yd,e),T(bd,e),T(Id,e),T(_d,e),T(Bd,e),T(Ld,e),T(Od,e),T(nc,e),T(rc,e),T(Jc,e),T(gc,e),T(_c,e),T(Gc,e),T(Rc,e),T(Wc,e),T(qc,e)}}}const $A='{"title":"pipelines","local":"pipelines","sections":[{"title":"pipelines.Pipeline ⇐ <code> Callable </code>","local":"pipelinespipeline--code-callable-code","sections":[{"title":"new Pipeline(options)","local":"new-pipelineoptions","sections":[],"depth":3},{"title":"pipeline.dispose() : <code> DisposeType </code>","local":"pipelinedispose--code-disposetype-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextClassificationPipeline","local":"pipelinestextclassificationpipeline","sections":[{"title":"new TextClassificationPipeline(options)","local":"new-textclassificationpipelineoptions","sections":[],"depth":3},{"title":"textClassificationPipeline._call() : <code> TextClassificationPipelineCallback </code>","local":"textclassificationpipelinecall--code-textclassificationpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TokenClassificationPipeline","local":"pipelinestokenclassificationpipeline","sections":[{"title":"new TokenClassificationPipeline(options)","local":"new-tokenclassificationpipelineoptions","sections":[],"depth":3},{"title":"tokenClassificationPipeline._call() : <code> TokenClassificationPipelineCallback </code>","local":"tokenclassificationpipelinecall--code-tokenclassificationpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.QuestionAnsweringPipeline","local":"pipelinesquestionansweringpipeline","sections":[{"title":"new QuestionAnsweringPipeline(options)","local":"new-questionansweringpipelineoptions","sections":[],"depth":3},{"title":"questionAnsweringPipeline._call() : <code> QuestionAnsweringPipelineCallback </code>","local":"questionansweringpipelinecall--code-questionansweringpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FillMaskPipeline","local":"pipelinesfillmaskpipeline","sections":[{"title":"new FillMaskPipeline(options)","local":"new-fillmaskpipelineoptions","sections":[],"depth":3},{"title":"fillMaskPipeline._call() : <code> FillMaskPipelineCallback </code>","local":"fillmaskpipelinecall--code-fillmaskpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.Text2TextGenerationPipeline","local":"pipelinestext2textgenerationpipeline","sections":[{"title":"new Text2TextGenerationPipeline(options)","local":"new-text2textgenerationpipelineoptions","sections":[],"depth":3},{"title":"text2TextGenerationPipeline._key : <code> ’ generated_text ’ </code>","local":"text2textgenerationpipelinekey--code--generatedtext--code","sections":[],"depth":3},{"title":"text2TextGenerationPipeline._call() : <code> Text2TextGenerationPipelineCallback </code>","local":"text2textgenerationpipelinecall--code-text2textgenerationpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.SummarizationPipeline","local":"pipelinessummarizationpipeline","sections":[{"title":"new SummarizationPipeline(options)","local":"new-summarizationpipelineoptions","sections":[],"depth":3},{"title":"summarizationPipeline._key : <code> ’ summary_text ’ </code>","local":"summarizationpipelinekey--code--summarytext--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TranslationPipeline","local":"pipelinestranslationpipeline","sections":[{"title":"new TranslationPipeline(options)","local":"new-translationpipelineoptions","sections":[],"depth":3},{"title":"translationPipeline._key : <code> ’ translation_text ’ </code>","local":"translationpipelinekey--code--translationtext--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextGenerationPipeline","local":"pipelinestextgenerationpipeline","sections":[{"title":"new TextGenerationPipeline(options)","local":"new-textgenerationpipelineoptions","sections":[],"depth":3},{"title":"textGenerationPipeline._call() : <code> TextGenerationPipelineCallback </code>","local":"textgenerationpipelinecall--code-textgenerationpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotClassificationPipeline","local":"pipelineszeroshotclassificationpipeline","sections":[{"title":"new ZeroShotClassificationPipeline(options)","local":"new-zeroshotclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotClassificationPipeline.model : <code> any </code>","local":"zeroshotclassificationpipelinemodel--code-any-code","sections":[],"depth":3},{"title":"zeroShotClassificationPipeline._call() : <code> ZeroShotClassificationPipelineCallback </code>","local":"zeroshotclassificationpipelinecall--code-zeroshotclassificationpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FeatureExtractionPipeline","local":"pipelinesfeatureextractionpipeline","sections":[{"title":"new FeatureExtractionPipeline(options)","local":"new-featureextractionpipelineoptions","sections":[],"depth":3},{"title":"featureExtractionPipeline._call() : <code> FeatureExtractionPipelineCallback </code>","local":"featureextractionpipelinecall--code-featureextractionpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageFeatureExtractionPipeline","local":"pipelinesimagefeatureextractionpipeline","sections":[{"title":"new ImageFeatureExtractionPipeline(options)","local":"new-imagefeatureextractionpipelineoptions","sections":[],"depth":3},{"title":"imageFeatureExtractionPipeline._call() : <code> ImageFeatureExtractionPipelineCallback </code>","local":"imagefeatureextractionpipelinecall--code-imagefeatureextractionpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AudioClassificationPipeline","local":"pipelinesaudioclassificationpipeline","sections":[{"title":"new AudioClassificationPipeline(options)","local":"new-audioclassificationpipelineoptions","sections":[],"depth":3},{"title":"audioClassificationPipeline._call() : <code> AudioClassificationPipelineCallback </code>","local":"audioclassificationpipelinecall--code-audioclassificationpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotAudioClassificationPipeline","local":"pipelineszeroshotaudioclassificationpipeline","sections":[{"title":"new ZeroShotAudioClassificationPipeline(options)","local":"new-zeroshotaudioclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotAudioClassificationPipeline._call() : <code> ZeroShotAudioClassificationPipelineCallback </code>","local":"zeroshotaudioclassificationpipelinecall--code-zeroshotaudioclassificationpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AutomaticSpeechRecognitionPipeline","local":"pipelinesautomaticspeechrecognitionpipeline","sections":[{"title":"new AutomaticSpeechRecognitionPipeline(options)","local":"new-automaticspeechrecognitionpipelineoptions","sections":[],"depth":3},{"title":"automaticSpeechRecognitionPipeline._call() : <code> AutomaticSpeechRecognitionPipelineCallback </code>","local":"automaticspeechrecognitionpipelinecall--code-automaticspeechrecognitionpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageToTextPipeline","local":"pipelinesimagetotextpipeline","sections":[{"title":"new ImageToTextPipeline(options)","local":"new-imagetotextpipelineoptions","sections":[],"depth":3},{"title":"imageToTextPipeline._call() : <code> ImageToTextPipelineCallback </code>","local":"imagetotextpipelinecall--code-imagetotextpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageClassificationPipeline","local":"pipelinesimageclassificationpipeline","sections":[{"title":"new ImageClassificationPipeline(options)","local":"new-imageclassificationpipelineoptions","sections":[],"depth":3},{"title":"imageClassificationPipeline._call() : <code> ImageClassificationPipelineCallback </code>","local":"imageclassificationpipelinecall--code-imageclassificationpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageSegmentationPipeline","local":"pipelinesimagesegmentationpipeline","sections":[{"title":"new ImageSegmentationPipeline(options)","local":"new-imagesegmentationpipelineoptions","sections":[],"depth":3},{"title":"imageSegmentationPipeline._call() : <code> ImageSegmentationPipelineCallback </code>","local":"imagesegmentationpipelinecall--code-imagesegmentationpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotImageClassificationPipeline","local":"pipelineszeroshotimageclassificationpipeline","sections":[{"title":"new ZeroShotImageClassificationPipeline(options)","local":"new-zeroshotimageclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotImageClassificationPipeline._call() : <code> ZeroShotImageClassificationPipelineCallback </code>","local":"zeroshotimageclassificationpipelinecall--code-zeroshotimageclassificationpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ObjectDetectionPipeline","local":"pipelinesobjectdetectionpipeline","sections":[{"title":"new ObjectDetectionPipeline(options)","local":"new-objectdetectionpipelineoptions","sections":[],"depth":3},{"title":"objectDetectionPipeline._call() : <code> ObjectDetectionPipelineCallback </code>","local":"objectdetectionpipelinecall--code-objectdetectionpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotObjectDetectionPipeline","local":"pipelineszeroshotobjectdetectionpipeline","sections":[{"title":"new ZeroShotObjectDetectionPipeline(options)","local":"new-zeroshotobjectdetectionpipelineoptions","sections":[],"depth":3},{"title":"zeroShotObjectDetectionPipeline._call() : <code> ZeroShotObjectDetectionPipelineCallback </code>","local":"zeroshotobjectdetectionpipelinecall--code-zeroshotobjectdetectionpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.DocumentQuestionAnsweringPipeline","local":"pipelinesdocumentquestionansweringpipeline","sections":[{"title":"new DocumentQuestionAnsweringPipeline(options)","local":"new-documentquestionansweringpipelineoptions","sections":[],"depth":3},{"title":"documentQuestionAnsweringPipeline._call() : <code> DocumentQuestionAnsweringPipelineCallback </code>","local":"documentquestionansweringpipelinecall--code-documentquestionansweringpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextToAudioPipeline","local":"pipelinestexttoaudiopipeline","sections":[{"title":"new TextToAudioPipeline(options)","local":"new-texttoaudiopipelineoptions","sections":[],"depth":3},{"title":"textToAudioPipeline._call() : <code> TextToAudioPipelineCallback </code>","local":"texttoaudiopipelinecall--code-texttoaudiopipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageToImagePipeline","local":"pipelinesimagetoimagepipeline","sections":[{"title":"new ImageToImagePipeline(options)","local":"new-imagetoimagepipelineoptions","sections":[],"depth":3},{"title":"imageToImagePipeline._call() : <code> ImageToImagePipelineCallback </code>","local":"imagetoimagepipelinecall--code-imagetoimagepipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.DepthEstimationPipeline","local":"pipelinesdepthestimationpipeline","sections":[{"title":"new DepthEstimationPipeline(options)","local":"new-depthestimationpipelineoptions","sections":[],"depth":3},{"title":"depthEstimationPipeline._call() : <code> DepthEstimationPipelineCallback </code>","local":"depthestimationpipelinecall--code-depthestimationpipelinecallback-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.pipeline(task, [model], [options]) ⇒ <code> * </code>","local":"pipelinespipelinetask-model-options--code--code","sections":[],"depth":2},{"title":"pipelines~x[1] : <code> number </code>","local":"pipelinesx1--code-number-code","sections":[],"depth":2},{"title":"pipelines~ImagePipelineInputs : <code> string </code> | <code> RawImage </code> | <code> URL </code>","local":"pipelinesimagepipelineinputs--code-string-code--code-rawimage-code--code-url-code","sections":[],"depth":2},{"title":"pipelines~AudioPipelineInputs : <code> string </code> | <code> URL </code> | <code> Float32Array </code> | <code> Float64Array </code>","local":"pipelinesaudiopipelineinputs--code-string-code--code-url-code--code-float32array-code--code-float64array-code","sections":[],"depth":2},{"title":"pipelines~BoundingBox : <code> Object </code>","local":"pipelinesboundingbox--code-object-code","sections":[],"depth":2},{"title":"pipelines~Disposable ⇒ <code> Promise. < void > </code>","local":"pipelinesdisposable--code-promise--void--code","sections":[],"depth":2},{"title":"pipelines~TextPipelineConstructorArgs : <code> Object </code>","local":"pipelinestextpipelineconstructorargs--code-object-code","sections":[],"depth":2},{"title":"pipelines~ImagePipelineConstructorArgs : <code> Object </code>","local":"pipelinesimagepipelineconstructorargs--code-object-code","sections":[],"depth":2},{"title":"pipelines~TextImagePipelineConstructorArgs : <code> Object </code>","local":"pipelinestextimagepipelineconstructorargs--code-object-code","sections":[],"depth":2},{"title":"pipelines~TextClassificationPipelineType ⇒ <code> Promise. < (TextClassificationOutput|Array < TextClassificationOutput > ) > </code>","local":"pipelinestextclassificationpipelinetype--code-promise--textclassificationoutputarray--textclassificationoutput----code","sections":[],"depth":2},{"title":"pipelines~TokenClassificationPipelineType ⇒ <code> Promise. < (TokenClassificationOutput|Array < TokenClassificationOutput > ) > </code>","local":"pipelinestokenclassificationpipelinetype--code-promise--tokenclassificationoutputarray--tokenclassificationoutput----code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringPipelineType ⇒ <code> Promise. < (QuestionAnsweringOutput|Array < QuestionAnsweringOutput > ) > </code>","local":"pipelinesquestionansweringpipelinetype--code-promise--questionansweringoutputarray--questionansweringoutput----code","sections":[],"depth":2},{"title":"pipelines~FillMaskPipelineType ⇒ <code> Promise. < (FillMaskOutput|Array < FillMaskOutput > ) > </code>","local":"pipelinesfillmaskpipelinetype--code-promise--fillmaskoutputarray--fillmaskoutput----code","sections":[],"depth":2},{"title":"pipelines~Text2TextGenerationPipelineType ⇒ <code> Promise. < (Text2TextGenerationOutput|Array < Text2TextGenerationOutput > ) > </code>","local":"pipelinestext2textgenerationpipelinetype--code-promise--text2textgenerationoutputarray--text2textgenerationoutput----code","sections":[],"depth":2},{"title":"pipelines~SummarizationPipelineType ⇒ <code> Promise. < (SummarizationOutput|Array < SummarizationOutput > ) > </code>","local":"pipelinessummarizationpipelinetype--code-promise--summarizationoutputarray--summarizationoutput----code","sections":[],"depth":2},{"title":"pipelines~TranslationPipelineType ⇒ <code> Promise. < (TranslationOutput|Array < TranslationOutput > ) > </code>","local":"pipelinestranslationpipelinetype--code-promise--translationoutputarray--translationoutput----code","sections":[],"depth":2},{"title":"pipelines~TextGenerationPipelineType ⇒ <code> Promise. < (TextGenerationOutput|Array < TextGenerationOutput > ) > </code>","local":"pipelinestextgenerationpipelinetype--code-promise--textgenerationoutputarray--textgenerationoutput----code","sections":[],"depth":2},{"title":"pipelines~ZeroShotClassificationPipelineType ⇒ <code> Promise. < (ZeroShotClassificationOutput|Array < ZeroShotClassificationOutput > ) > </code>","local":"pipelineszeroshotclassificationpipelinetype--code-promise--zeroshotclassificationoutputarray--zeroshotclassificationoutput----code","sections":[],"depth":2},{"title":"pipelines~FeatureExtractionPipelineType ⇒ <code> Promise. < Tensor > </code>","local":"pipelinesfeatureextractionpipelinetype--code-promise--tensor--code","sections":[],"depth":2},{"title":"pipelines~ImageFeatureExtractionPipelineType ⇒ <code> Promise. < Tensor > </code>","local":"pipelinesimagefeatureextractionpipelinetype--code-promise--tensor--code","sections":[],"depth":2},{"title":"pipelines~AudioClassificationPipelineType ⇒ <code> Promise. < (AudioClassificationOutput|Array < AudioClassificationOutput > ) > </code>","local":"pipelinesaudioclassificationpipelinetype--code-promise--audioclassificationoutputarray--audioclassificationoutput----code","sections":[],"depth":2},{"title":"pipelines~ZeroShotAudioClassificationPipelineType ⇒ <code> Promise. < (Array < ZeroShotAudioClassificationOutput > |Array < Array < ZeroShotAudioClassificationOutput > > ) > </code>","local":"pipelineszeroshotaudioclassificationpipelinetype--code-promise--array--zeroshotaudioclassificationoutput--array--array--zeroshotaudioclassificationoutput-----code","sections":[],"depth":2},{"title":"pipelines~ChunkCallback : <code> function </code>","local":"pipelineschunkcallback--code-function-code","sections":[],"depth":2},{"title":"pipelines~Chunk : <code> Object </code>","local":"pipelineschunk--code-object-code","sections":[],"depth":2},{"title":"pipelines~AutomaticSpeechRecognitionPipelineType ⇒ <code> Promise. < (AutomaticSpeechRecognitionOutput|Array < AutomaticSpeechRecognitionOutput > ) > </code>","local":"pipelinesautomaticspeechrecognitionpipelinetype--code-promise--automaticspeechrecognitionoutputarray--automaticspeechrecognitionoutput----code","sections":[],"depth":2},{"title":"pipelines~ImageToTextPipelineType ⇒ <code> Promise. < (ImageToTextOutput|Array < ImageToTextOutput > ) > </code>","local":"pipelinesimagetotextpipelinetype--code-promise--imagetotextoutputarray--imagetotextoutput----code","sections":[],"depth":2},{"title":"pipelines~ImageClassificationPipelineType ⇒ <code> Promise. < (ImageClassificationOutput|Array < ImageClassificationOutput > ) > </code>","local":"pipelinesimageclassificationpipelinetype--code-promise--imageclassificationoutputarray--imageclassificationoutput----code","sections":[],"depth":2},{"title":"pipelines~ImageSegmentationPipelineType ⇒ <code> Promise. < Array < ImageSegmentationPipelineOutput > > </code>","local":"pipelinesimagesegmentationpipelinetype--code-promise--array--imagesegmentationpipelineoutput---code","sections":[],"depth":2},{"title":"pipelines~ZeroShotImageClassificationPipelineType ⇒ <code> Promise. < (Array < ZeroShotImageClassificationOutput > |Array < Array < ZeroShotImageClassificationOutput > > ) > </code>","local":"pipelineszeroshotimageclassificationpipelinetype--code-promise--array--zeroshotimageclassificationoutput--array--array--zeroshotimageclassificationoutput-----code","sections":[],"depth":2},{"title":"pipelines~ObjectDetectionPipelineType ⇒ <code> Promise. < (ObjectDetectionPipelineOutput|Array < ObjectDetectionPipelineOutput > ) > </code>","local":"pipelinesobjectdetectionpipelinetype--code-promise--objectdetectionpipelineoutputarray--objectdetectionpipelineoutput----code","sections":[],"depth":2},{"title":"pipelines~ZeroShotObjectDetectionPipelineType ⇒ <code> Promise. < (Array < ZeroShotObjectDetectionOutput > |Array < Array < ZeroShotObjectDetectionOutput > > ) > </code>","local":"pipelineszeroshotobjectdetectionpipelinetype--code-promise--array--zeroshotobjectdetectionoutput--array--array--zeroshotobjectdetectionoutput-----code","sections":[],"depth":2},{"title":"pipelines~DocumentQuestionAnsweringPipelineType ⇒ <code> Promise. < (DocumentQuestionAnsweringOutput|Array < DocumentQuestionAnsweringOutput > ) > </code>","local":"pipelinesdocumentquestionansweringpipelinetype--code-promise--documentquestionansweringoutputarray--documentquestionansweringoutput----code","sections":[],"depth":2},{"title":"pipelines~TextToAudioPipelineConstructorArgs : <code> Object </code>","local":"pipelinestexttoaudiopipelineconstructorargs--code-object-code","sections":[],"depth":2},{"title":"pipelines~TextToAudioPipelineType ⇒ <code> Promise. < TextToAudioOutput > </code>","local":"pipelinestexttoaudiopipelinetype--code-promise--texttoaudiooutput--code","sections":[],"depth":2},{"title":"pipelines~ImageToImagePipelineType ⇒ <code> Promise. < (RawImage|Array < RawImage > ) > </code>","local":"pipelinesimagetoimagepipelinetype--code-promise--rawimagearray--rawimage----code","sections":[],"depth":2},{"title":"pipelines~DepthEstimationPipelineType ⇒ <code> Promise. < (DepthEstimationPipelineOutput|Array < DepthEstimationPipelineOutput > ) > </code>","local":"pipelinesdepthestimationpipelinetype--code-promise--depthestimationpipelineoutputarray--depthestimationpipelineoutput----code","sections":[],"depth":2},{"title":"pipelines~AllTasks : <code> * </code>","local":"pipelinesalltasks--code--code","sections":[],"depth":2}],"depth":1}';function vA(eg){return CA(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class BA extends IA{constructor(f){super(),kA(this,f,vA,_A,xA,{})}}export{BA as component};
