import{s as wd,o as Cd,n as I}from"../chunks/scheduler.6062bdaf.js";import{S as vd,i as Jd,g as u,s as l,r as m,A as Ud,h as g,f as p,c as i,j as C,u as h,x as T,k as v,y as o,a as j,v as f,d as b,t as _,w as y}from"../chunks/index.4bca734e.js";import{T as q}from"../chunks/Tip.b9ac1f03.js";import{D as k}from"../chunks/Docstring.ed07512f.js";import{C as E}from"../chunks/CodeBlock.fa01571c.js";import{E as Z}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as et}from"../chunks/Heading.723dceba.js";function kd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Ed($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBYXVkaW9fb3V0cHV0JTIwJTNEJTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBZm9yJTIwaSUyQyUyMGl0ZW0lMjBpbiUyMGVudW1lcmF0ZShhdWRpb19vdXRwdXQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oZiUyMm91dHB1dF8lN0JpJTdELmZsYWMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Zd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function qd($){let n,d=`If the model is served by a server supporting chat-completion, the method will directly call the server’s
<code>/v1/chat/completions</code> endpoint. If the server does not support chat-completion, the method will render the
chat template client-side based on the information fetched from the Hub API. In this case, you will need to
have <code>minijinja</code> template engine installed. Run <code>pip install &quot;huggingface_hub[inference]&quot;</code> or <code>pip install minijinja</code>
to install it.`;return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ew44g7"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Wd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFjbGllbnQuY2hhdF9jb21wbGV0aW9uKG1lc3NhZ2VzJTJDJTIwbWF4X3Rva2VucyUzRDEwMCklMEElMEFmb3IlMjB0b2tlbiUyMGluJTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMCUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputChoice(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputChoiceMessage(
                content=<span class="hljs-string">&#x27;The capital of France is Paris. The official name of the city is &quot;Ville de Paris&quot; (City of Paris) and the name of the country&#x27;</span>s governing body, which <span class="hljs-keyword">is</span> located <span class="hljs-keyword">in</span> Paris, <span class="hljs-keyword">is</span> <span class="hljs-string">&quot;La République française&quot;</span> (The French Republic). 
hat helps! Let me know <span class="hljs-keyword">if</span> you need <span class="hljs-built_in">any</span> further information.<span class="hljs-string">&#x27;
            )
        )
    ],
    created=1710498360
)

&gt;&gt;&gt; for token in client.chat_completion(messages, max_tokens=10, stream=True):
...     print(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=&#x27;</span>The<span class="hljs-string">&#x27;, role=&#x27;</span>assistant<span class="hljs-string">&#x27;), index=0, finish_reason=None)], created=1710498504)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=&#x27;</span> capital<span class="hljs-string">&#x27;, role=&#x27;</span>assistant<span class="hljs-string">&#x27;), index=0, finish_reason=None)], created=1710498504)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=&#x27;</span> may<span class="hljs-string">&#x27;, role=&#x27;</span>assistant<span class="hljs-string">&#x27;), index=0, finish_reason=None)], created=1710498504)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=None, role=None), index=0, finish_reason=&#x27;</span>length<span class="hljs-string">&#x27;)], created=1710498504)</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Nd($){let n,d=`<a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">InferenceClient.conversational()</a> API is deprecated and will be removed in a future release. Please use
<a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> instead.`;return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1p9u0ze"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Gd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUyMkhpJTJDJTIwd2hvJTIwYXJlJTIweW91JTNGJTIyKSUwQW91dHB1dCUwQWNsaWVudC5jb252ZXJzYXRpb25hbCglMEElMjAlMjAlMjAlMjAlMjJXb3clMkMlMjB0aGF0J3MlMjBzY2FyeSElMjIlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfcmVzcG9uc2VzJTNEb3V0cHV0JTVCJTIyY29udmVyc2F0aW9uJTIyJTVEJTVCJTIyZ2VuZXJhdGVkX3Jlc3BvbnNlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhc3RfdXNlcl9pbnB1dHMlM0RvdXRwdXQlNUIlMjJjb252ZXJzYXRpb24lMjIlNUQlNUIlMjJwYXN0X3VzZXJfaW5wdXRzJTIyJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = client.conversational(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>, <span class="hljs-string">&#x27;conversation&#x27;</span>: {<span class="hljs-string">&#x27;generated_responses&#x27;</span>: [<span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>], <span class="hljs-string">&#x27;past_user_inputs&#x27;</span>: [<span class="hljs-string">&#x27;Hi, who are you?&#x27;</span>]}, <span class="hljs-string">&#x27;warnings&#x27;</span>: [<span class="hljs-string">&#x27;Setting \`pad_token_id\` to \`eos_token_id\`:50256 for open-end generation.&#x27;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.conversational(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Wow, that&#x27;s scary!&quot;</span>,
<span class="hljs-meta">... </span>    generated_responses=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;generated_responses&quot;</span>],
<span class="hljs-meta">... </span>    past_user_inputs=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;past_user_inputs&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Vd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(score=<span class="hljs-number">0.42515629529953003</span>, answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, start=<span class="hljs-number">16</span>, end=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Ad($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Yd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Dd($){let n,d=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-6te4uk"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Bd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_model_status(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Hd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(score=<span class="hljs-number">0.9779096841812134</span>, label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Sd($){let n,d="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Qd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKSUzQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>):
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Rd($){let n,d="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Fd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Pd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFjbGllbnQuaW1hZ2VfdG9fdGV4dCglMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Xd($){let n,d=`This endpoint is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-osot58"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Ld($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBbW9kZWxzJTIwJTNEJTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFjbGllbnQubGlzdF9kZXBsb3llZF9tb2RlbHMoJTIydGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function zd($){let n,d="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Od($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMiklM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>):
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Kd($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(score=<span class="hljs-number">0.9326562285423279</span>, start=<span class="hljs-number">11</span>, end=<span class="hljs-number">16</span>, answer=<span class="hljs-string">&#x27;Clara&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function em($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function nm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function tm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcXVlcnklMjAlM0QlMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMEF0YWJsZSUyMCUzRCUyMCU3QiUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlN0QlMEFjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function sm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMkMlMEElN0QlMEFjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function am($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJIZWlnaHQlMjIlM0ElMjAlNUIlMjIxMS41MiUyMiUyQyUyMCUyMjEyLjQ4JTIyJTJDJTIwJTIyMTIuMzc3OCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDElMjIlM0ElMjAlNUIlMjIyMy4yJTIyJTJDJTIwJTIyMjQlMjIlMkMlMjAlMjIyMy45JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMiUyMiUzQSUyMCU1QiUyMjI1LjQlMjIlMkMlMjAlMjIyNi4zJTIyJTJDJTIwJTIyMjYuNSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDMlMjIlM0ElMjAlNUIlMjIzMCUyMiUyQyUyMCUyMjMxLjIlMjIlMkMlMjAlMjIzMS4xJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyU3BlY2llcyUyMiUzQSUyMCU1QiUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMldpZHRoJTIyJTNBJTIwJTVCJTIyNC4wMiUyMiUyQyUyMCUyMjQuMzA1NiUyMiUyQyUyMCUyMjQuNjk2MSUyMiU1RCUyQyUwQSU3RCUwQWNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function om($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function rm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBodWdnaW5nZmFjZV9odWIlMjBsaWJyYXJ5JTIwaXMlMjAlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyKSUwQSUwQWZvciUyMHRva2VuJTIwaW4lMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMlRoZSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxpYnJhcnklMjBpcyUyMCUyMiUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTIlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKSUwQSUwQWNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTIyVGhlJTIwaHVnZ2luZ2ZhY2VfaHViJTIwbGlicmFyeSUyMGlzJTIwJTIyJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMiUyQyUyMGRldGFpbHMlM0RUcnVlKSUwQSUwQWZvciUyMGRldGFpbHMlMjBpbiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTIyVGhlJTIwaHVnZ2luZ2ZhY2VfaHViJTIwbGlicmFyeSUyMGlzJTIwJTIyJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMiUyQyUyMGRldGFpbHMlM0RUcnVlJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludChkZXRhaWxzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function lm($){let n,d="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function im($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybG93JTIwcmVzb2x1dGlvbiUyQyUyMGJsdXJyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmJldHRlcl9hc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function cm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBYXVkaW8lMjAlM0QlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function pm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function um($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWNsaWVudC50cmFuc2xhdGlvbiglMjJNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiUyMiUyQyUyMG1vZGVsJTNEJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1mciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function gm($){let n,d="Specifying languages:",a,t,r;return t=new E({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mhcj6c"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function dm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function mm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGV4dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBJTIwbmV3JTIwbW9kZWwlMjBvZmZlcnMlMjBhbiUyMGV4cGxhbmF0aW9uJTIwZm9yJTIwaG93JTIwdGhlJTIwR2FsaWxlYW4lMjBzYXRlbGxpdGVzJTIwZm9ybWVkJTIwYXJvdW5kJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0ncyUyMiUwQSUyMCUyMCUyMCUyMCUyMmxhcmdlc3QlMjB3b3JsZC4lMjBLb25zdGFudGluJTIwQmF0eWdpbiUyMGRpZCUyMG5vdCUyMHNldCUyMG91dCUyMHRvJTIwc29sdmUlMjBvbmUlMjBvZiUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjBtb3N0JTIwcHV6emxpbmclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjBteXN0ZXJpZXMlMjB3aGVuJTIwaGUlMjB3ZW50JTIwZm9yJTIwYSUyMHJ1biUyMHVwJTIwYSUyMGhpbGwlMjBpbiUyME5pY2UlMkMlMjBGcmFuY2UuJTIyJTBBKSUwQWxhYmVscyUyMCUzRCUyMCU1QiUyMnNwYWNlJTIwJTI2JTIwY29zbW9zJTIyJTJDJTIwJTIyc2NpZW50aWZpYyUyMGRpc2NvdmVyeSUyMiUyQyUyMCUyMm1pY3JvYmlvbG9neSUyMiUyQyUyMCUyMnJvYm90cyUyMiUyQyUyMCUyMmFyY2hlb2xvZ3klMjIlNUQlMEFjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function hm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function fm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function bm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF1ZGlvX291dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBYXN5bmMlMjBmb3IlMjBpJTJDJTIwaXRlbSUyMGluJTIwZW51bWVyYXRlKGF1ZGlvX291dHB1dCklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbihmJTIyb3V0cHV0XyU3QmklN0QuZmxhYyUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = <span class="hljs-keyword">await</span> client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function _m($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function ym($){let n,d=`If the model is served by a server supporting chat-completion, the method will directly call the server’s
<code>/v1/chat/completions</code> endpoint. If the server does not support chat-completion, the method will render the
chat template client-side based on the information fetched from the Hub API. In this case, you will need to
have <code>minijinja</code> template engine installed. Run <code>pip install &quot;huggingface_hub[inference]&quot;</code> or <code>pip install minijinja</code>
to install it.`;return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ew44g7"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function xm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIpJTBBYXdhaXQlMjBjbGllbnQuY2hhdF9jb21wbGV0aW9uKG1lc3NhZ2VzJTJDJTIwbWF4X3Rva2VucyUzRDEwMCklMEElMEFhc3luYyUyMGZvciUyMHRva2VuJTIwaW4lMjBhd2FpdCUyMGNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputChoice(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputChoiceMessage(
                content=<span class="hljs-string">&#x27;The capital of France is Paris. The official name of the city is &quot;Ville de Paris&quot; (City of Paris) and the name of the country&#x27;</span>s governing body, which <span class="hljs-keyword">is</span> located <span class="hljs-keyword">in</span> Paris, <span class="hljs-keyword">is</span> <span class="hljs-string">&quot;La République française&quot;</span> (The French Republic). 
hat helps! Let me know <span class="hljs-keyword">if</span> you need <span class="hljs-built_in">any</span> further information.<span class="hljs-string">&#x27;
            )
        )
    ],
    created=1710498360
)

&gt;&gt;&gt; async for token in await client.chat_completion(messages, max_tokens=10, stream=True):
...     print(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=&#x27;</span>The<span class="hljs-string">&#x27;, role=&#x27;</span>assistant<span class="hljs-string">&#x27;), index=0, finish_reason=None)], created=1710498504)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=&#x27;</span> capital<span class="hljs-string">&#x27;, role=&#x27;</span>assistant<span class="hljs-string">&#x27;), index=0, finish_reason=None)], created=1710498504)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=&#x27;</span> may<span class="hljs-string">&#x27;, role=&#x27;</span>assistant<span class="hljs-string">&#x27;), index=0, finish_reason=None)], created=1710498504)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=None, role=None), index=0, finish_reason=&#x27;</span>length<span class="hljs-string">&#x27;)], created=1710498504)</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function jm($){let n,d=`<a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">InferenceClient.conversational()</a> API is deprecated and will be removed in a future release. Please use
<a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> instead.`;return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1p9u0ze"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Tm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQW91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUyMkhpJTJDJTIwd2hvJTIwYXJlJTIweW91JTNGJTIyKSUwQW91dHB1dCUwQWF3YWl0JTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUwQSUyMCUyMCUyMCUyMCUyMldvdyUyQyUyMHRoYXQncyUyMHNjYXJ5ISUyMiUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9yZXNwb25zZXMlM0RvdXRwdXQlNUIlMjJjb252ZXJzYXRpb24lMjIlNUQlNUIlMjJnZW5lcmF0ZWRfcmVzcG9uc2VzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFzdF91c2VyX2lucHV0cyUzRG91dHB1dCU1QiUyMmNvbnZlcnNhdGlvbiUyMiU1RCU1QiUyMnBhc3RfdXNlcl9pbnB1dHMlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = <span class="hljs-keyword">await</span> client.conversational(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>, <span class="hljs-string">&#x27;conversation&#x27;</span>: {<span class="hljs-string">&#x27;generated_responses&#x27;</span>: [<span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>], <span class="hljs-string">&#x27;past_user_inputs&#x27;</span>: [<span class="hljs-string">&#x27;Hi, who are you?&#x27;</span>]}, <span class="hljs-string">&#x27;warnings&#x27;</span>: [<span class="hljs-string">&#x27;Setting \`pad_token_id\` to \`eos_token_id\`:50256 async for open-end generation.&#x27;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.conversational(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Wow, that&#x27;s scary!&quot;</span>,
<span class="hljs-meta">... </span>    generated_responses=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;generated_responses&quot;</span>],
<span class="hljs-meta">... </span>    past_user_inputs=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;past_user_inputs&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function $m($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(score=<span class="hljs-number">0.42515629529953003</span>, answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, start=<span class="hljs-number">16</span>, end=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Im($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Mm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function wm($){let n,d=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-6te4uk"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Cm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_model_status(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function vm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(score=<span class="hljs-number">0.9779096841812134</span>, label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Jm($){let n,d="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Um($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKSUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>):
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function km($){let n,d="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Em($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Zm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFhd2FpdCUyMGNsaWVudC5pbWFnZV90b190ZXh0KCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function qm($){let n,d=`This endpoint is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-osot58"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Wm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQW1vZGVscyUyMCUzRCUyMGF3YWl0JTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFhd2FpdCUyMGNsaWVudC5saXN0X2RlcGxveWVkX21vZGVscyglMjJ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async contextthon</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = <span class="hljs-keyword">await</span> client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Nm($){let n,d="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Gm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMiklM0E=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>):
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Vm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(score=<span class="hljs-number">0.9326562285423279</span>, start=<span class="hljs-number">11</span>, end=<span class="hljs-number">16</span>, answer=<span class="hljs-string">&#x27;Clara&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Am($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Ym($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Dm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXF1ZXJ5JTIwJTNEJTIwJTIySG93JTIwbWFueSUyMHN0YXJzJTIwZG9lcyUyMHRoZSUyMHRyYW5zZm9ybWVycyUyMHJlcG9zaXRvcnklMjBoYXZlJTNGJTIyJTBBdGFibGUlMjAlM0QlMjAlN0IlMjJSZXBvc2l0b3J5JTIyJTNBJTIwJTVCJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyRGF0YXNldHMlMjIlMkMlMjAlMjJUb2tlbml6ZXJzJTIyJTVEJTJDJTIwJTIyU3RhcnMlMjIlM0ElMjAlNUIlMjIzNjU0MiUyMiUyQyUyMCUyMjQ1MTIlMjIlMkMlMjAlMjIzOTM0JTIyJTVEJTdEJTBBYXdhaXQlMjBjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Bm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZml4ZWRfYWNpZGl0eSUyMiUzQSUyMCU1QiUyMjcuNCUyMiUyQyUyMCUyMjcuOCUyMiUyQyUyMCUyMjEwLjMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2b2xhdGlsZV9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyMC43JTIyJTJDJTIwJTIyMC44OCUyMiUyQyUyMCUyMjAuMzIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaXRyaWNfYWNpZCUyMiUzQSUyMCU1QiUyMjAlMjIlMkMlMjAlMjIwJTIyJTJDJTIwJTIyMC40NSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlc2lkdWFsX3N1Z2FyJTIyJTNBJTIwJTVCJTIyMS45JTIyJTJDJTIwJTIyMi42JTIyJTJDJTIwJTIyNi40JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hsb3JpZGVzJTIyJTNBJTIwJTVCJTIyMC4wNzYlMjIlMkMlMjAlMjIwLjA5OCUyMiUyQyUyMCUyMjAuMDczJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnJlZV9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjExJTIyJTJDJTIwJTIyMjUlMjIlMkMlMjAlMjI1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydG90YWxfc3VsZnVyX2Rpb3hpZGUlMjIlM0ElMjAlNUIlMjIzNCUyMiUyQyUyMCUyMjY3JTIyJTJDJTIwJTIyMTMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZW5zaXR5JTIyJTNBJTIwJTVCJTIyMC45OTc4JTIyJTJDJTIwJTIyMC45OTY4JTIyJTJDJTIwJTIyMC45OTc2JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycEglMjIlM0ElMjAlNUIlMjIzLjUxJTIyJTJDJTIwJTIyMy4yJTIyJTJDJTIwJTIyMy4yMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnN1bHBoYXRlcyUyMiUzQSUyMCU1QiUyMjAuNTYlMjIlMkMlMjAlMjIwLjY4JTIyJTJDJTIwJTIyMC44MiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmFsY29ob2wlMjIlM0ElMjAlNUIlMjI5LjQlMjIlMkMlMjAlMjI5LjglMjIlMkMlMjAlMjIxMi42JTIyJTVEJTJDJTBBJTdEJTBBYXdhaXQlMjBjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Hm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIySGVpZ2h0JTIyJTNBJTIwJTVCJTIyMTEuNTIlMjIlMkMlMjAlMjIxMi40OCUyMiUyQyUyMCUyMjEyLjM3NzglMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgxJTIyJTNBJTIwJTVCJTIyMjMuMiUyMiUyQyUyMCUyMjI0JTIyJTJDJTIwJTIyMjMuOSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDIlMjIlM0ElMjAlNUIlMjIyNS40JTIyJTJDJTIwJTIyMjYuMyUyMiUyQyUyMCUyMjI2LjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgzJTIyJTNBJTIwJTVCJTIyMzAlMjIlMkMlMjAlMjIzMS4yJTIyJTJDJTIwJTIyMzEuMSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMlNwZWNpZXMlMjIlM0ElMjAlNUIlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJXaWR0aCUyMiUzQSUyMCU1QiUyMjQuMDIlMjIlMkMlMjAlMjI0LjMwNTYlMjIlMkMlMjAlMjI0LjY5NjElMjIlNUQlMkMlMEElN0QlMEFhd2FpdCUyMGNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Sm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Qm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBodWdnaW5nZmFjZV9odWIlMjBsaWJyYXJ5JTIwaXMlMjAlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBodWdnaW5nZmFjZV9odWIlMjBsaWJyYXJ5JTIwaXMlMjAlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiklMEElMEFhd2FpdCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTIyVGhlJTIwaHVnZ2luZ2ZhY2VfaHViJTIwbGlicmFyeSUyMGlzJTIwJTIyJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMiUyQyUyMGRldGFpbHMlM0RUcnVlKSUwQSUwQWFzeW5jJTIwZm9yJTIwZGV0YWlscyUyMGluJTIwYXdhaXQlMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMlRoZSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxpYnJhcnklMjBpcyUyMCUyMiUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTIlMkMlMjBkZXRhaWxzJTNEVHJ1ZSUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZGV0YWlscyk=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful async for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Rm($){let n,d="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=d},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=d)},m(a,t){j(a,n,t)},p:I,d(a){a&&p(n)}}}function Fm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJsb3clMjByZXNvbHV0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYmV0dGVyX2FzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Pm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF1ZGlvJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-keyword">await</span> client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Xm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Lm($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyJTJDJTIwbW9kZWwlM0QlMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWZyJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function zm($){let n,d="Specifying languages:",a,t,r;return t=new E({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mhcj6c"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Om($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function Km($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG5ldyUyMG1vZGVsJTIwb2ZmZXJzJTIwYW4lMjBleHBsYW5hdGlvbiUyMGFzeW5jJTIwZm9yJTIwaG93JTIwdGhlJTIwR2FsaWxlYW4lMjBzYXRlbGxpdGVzJTIwZm9ybWVkJTIwYXJvdW5kJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0ncyUyMiUwQSUyMCUyMCUyMCUyMCUyMmxhcmdlc3QlMjB3b3JsZC4lMjBLb25zdGFudGluJTIwQmF0eWdpbiUyMGRpZCUyMG5vdCUyMHNldCUyMG91dCUyMHRvJTIwc29sdmUlMjBvbmUlMjBvZiUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjBtb3N0JTIwcHV6emxpbmclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjBteXN0ZXJpZXMlMjB3aGVuJTIwaGUlMjB3ZW50JTIwYXN5bmMlMjBmb3IlMjBhJTIwcnVuJTIwdXAlMjBhJTIwaGlsbCUyMGluJTIwTmljZSUyQyUyMEZyYW5jZS4lMjIlMEEpJTBBbGFiZWxzJTIwJTNEJTIwJTVCJTIyc3BhY2UlMjAlMjYlMjBjb3Ntb3MlMjIlMkMlMjAlMjJzY2llbnRpZmljJTIwZGlzY292ZXJ5JTIyJTJDJTIwJTIybWljcm9iaW9sb2d5JTIyJTJDJTIwJTIycm9ib3RzJTIyJTJDJTIwJTIyYXJjaGVvbG9neSUyMiU1RCUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzKSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation async for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went async for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function eh($){let n,d="Example:",a,t,r;return t=new E({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function nh($){let n,d="Example:",a,t,r;return t=new E({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.inference_api <span class="hljs-keyword">import</span> InferenceApi

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask-fill example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Question Answering example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>,
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9326569437980652</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Clara&#x27;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Zero-shot example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>: [<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Overriding configured task</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Text-to-image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(<span class="hljs-string">&quot;cat&quot;</span>)
&lt;PIL.PngImagePlugin.PngImageFile image (...)&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Return as raw response to parse the output yourself</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;mio/amadeus&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = inference(<span class="hljs-string">&quot;hello world&quot;</span>, raw_response=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.headers
{<span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;audio/flac&quot;</span>, ...}
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes from server</span>
<span class="hljs-string">b&#x27;(...)&#x27;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=d,a=l(),m(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=d),a=i(e),h(t.$$.fragment,e)},m(e,c){j(e,n,c),j(e,a,c),f(t,e,c),r=!0},p:I,i(e){r||(b(t.$$.fragment,e),r=!0)},o(e){_(t.$$.fragment,e),r=!1},d(e){e&&(p(n),p(a)),y(t,e)}}}function th($){let n,d,a,t,r,e,c,Gu=`Inference is the process of using a trained model to make predictions on new data. As this process can be compute-intensive,
running on a dedicated server can be an interesting option. The <code>huggingface_hub</code> library provides an easy way to call a
service that runs inference for hosted models. There are several services you can connect to:`,el,Es,Vu=`<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>: a service that allows you to run accelerated inference
on Hugging Face’s infrastructure for free. This service is a fast way to get started, test different models, and
prototype AI products.</li> <li><a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production.
Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li>`,nl,Zs,Au=`These services can be called with the <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. Please refer to <a href="../guides/inference">this guide</a>
for more information on how to use it.`,tl,qs,sl,M,Ws,$l,To,Yu="Initialize a new Inference Client.",Il,$o,Du=`<a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API or self-hosted Inference Endpoints.`,Ml,Ce,Ns,wl,Io,Bu="Perform audio classification on the provided audio content.",Cl,nt,vl,ve,Gs,Jl,Mo,Hu="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",Ul,tt,kl,Je,Vs,El,wo,Su="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",Zl,st,ql,X,As,Wl,Co,Qu="A method for completing conversations using a specified language model.",Nl,at,Gl,ot,Vl,L,Ys,Al,vo,Ru="Generate conversational responses based on the given input text (i.e. chat with the API).",Yl,rt,Dl,lt,Bl,Ue,Ds,Hl,Jo,Fu="Answer questions on document images.",Sl,it,Ql,ke,Bs,Rl,Uo,Pu="Generate embeddings for a given text.",Fl,ct,Pl,Ee,Hs,Xl,ko,Xu="Fill in a hole with a missing word (token to be precise).",Ll,pt,zl,z,Ss,Ol,Eo,Lu="Get the status of a model hosted on the Inference API.",Kl,ut,ei,gt,ni,dt,Qs,ti,Zo,zu="Get the model Hugging Face recommends for the input task.",si,Ze,Rs,ai,qo,Ou="Perform image classification on the given image using the specified model.",oi,mt,ri,O,Fs,li,Wo,Ku="Perform image segmentation on the given image using the specified model.",ii,ht,ci,ft,pi,K,Ps,ui,No,eg="Perform image-to-image translation using a specified model.",gi,bt,di,_t,mi,ee,Xs,hi,Go,ng="Takes an input image and return text.",fi,Vo,tg=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,bi,yt,_i,N,Ls,yi,Ao,sg="List models currently deployed on the Inference API service.",xi,Yo,ag=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,ji,xt,Ti,jt,$i,ne,zs,Ii,Do,og="Perform object detection on the given image using the specified model.",Mi,Tt,wi,$t,Ci,It,Os,vi,Bo,rg="Make a POST request to the inference server.",Ji,qe,Ks,Ui,Ho,lg="Retrieve the answer to a question from a given text.",ki,Mt,Ei,We,ea,Zi,So,ig="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",qi,wt,Wi,Ne,na,Ni,Qo,cg="Generate a summary of a given text using a specified model.",Gi,Ct,Vi,Ge,ta,Ai,Ro,pg="Retrieve the answer to a question from information given in a table.",Yi,vt,Di,Ve,sa,Bi,Fo,ug="Classifying a target category (a group) based on a set of attributes.",Hi,Jt,Si,Ae,aa,Qi,Po,gg="Predicting a numerical target value given a set of attributes/features in a table.",Ri,Ut,Fi,Ye,oa,Pi,Xo,dg="Perform text classification (e.g. sentiment-analysis) on the given text.",Xi,kt,Li,G,ra,zi,Lo,mg="Given a prompt, generate the following text.",Oi,zo,hg=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,Ki,Oo,fg='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',ec,Et,nc,te,la,tc,Ko,bg="Generate an image based on a given text using a specified model.",sc,Zt,ac,qt,oc,De,ia,rc,er,_g="Synthesize an audio of a voice pronouncing a given text.",lc,Wt,ic,Be,ca,cc,nr,yg=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,pc,Nt,uc,V,pa,gc,tr,xg="Convert text from one language to another.",dc,sr,jg=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.
You can find this information in the model card.`,mc,Gt,hc,Vt,fc,He,ua,bc,ar,Tg="Answering open-ended questions based on an image.",_c,At,yc,Se,ga,xc,or,$g="Provide as input a text and a set of candidate labels to classify the input text.",jc,Yt,Tc,Qe,da,$c,rr,Ig="Provide input image and text labels to predict text labels for the image.",Ic,Dt,al,ma,ol,ha,Mg=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>.
To use it, you can either install <code>aiohttp</code> directly or use the <code>[inference]</code> extra:`,rl,fa,ll,w,ba,Mc,lr,wg="Initialize a new Inference Client.",wc,ir,Cg=`<a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API or self-hosted Inference Endpoints.`,Cc,Re,_a,vc,cr,vg="Perform audio classification on the provided audio content.",Jc,Bt,Uc,Fe,ya,kc,pr,Jg="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",Ec,Ht,Zc,Pe,xa,qc,ur,Ug="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",Wc,St,Nc,se,ja,Gc,gr,kg="A method for completing conversations using a specified language model.",Vc,Qt,Ac,Rt,Yc,ae,Ta,Dc,dr,Eg="Generate conversational responses based on the given input text (i.e. chat with the API).",Bc,Ft,Hc,Pt,Sc,Xe,$a,Qc,mr,Zg="Answer questions on document images.",Rc,Xt,Fc,Le,Ia,Pc,hr,qg="Generate embeddings for a given text.",Xc,Lt,Lc,ze,Ma,zc,fr,Wg="Fill in a hole with a missing word (token to be precise).",Oc,zt,Kc,oe,wa,ep,br,Ng="Get the status of a model hosted on the Inference API.",np,Ot,tp,Kt,sp,es,Ca,ap,_r,Gg="Get the model Hugging Face recommends for the input task.",op,Oe,va,rp,yr,Vg="Perform image classification on the given image using the specified model.",lp,ns,ip,re,Ja,cp,xr,Ag="Perform image segmentation on the given image using the specified model.",pp,ts,up,ss,gp,le,Ua,dp,jr,Yg="Perform image-to-image translation using a specified model.",mp,as,hp,os,fp,ie,ka,bp,Tr,Dg="Takes an input image and return text.",_p,$r,Bg=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,yp,rs,xp,A,Ea,jp,Ir,Hg="List models currently deployed on the Inference API service.",Tp,Mr,Sg=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,$p,ls,Ip,is,Mp,ce,Za,wp,wr,Qg="Perform object detection on the given image using the specified model.",Cp,cs,vp,ps,Jp,us,qa,Up,Cr,Rg="Make a POST request to the inference server.",kp,Ke,Wa,Ep,vr,Fg="Retrieve the answer to a question from a given text.",Zp,gs,qp,en,Na,Wp,Jr,Pg="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",Np,ds,Gp,nn,Ga,Vp,Ur,Xg="Generate a summary of a given text using a specified model.",Ap,ms,Yp,tn,Va,Dp,kr,Lg="Retrieve the answer to a question from information given in a table.",Bp,hs,Hp,sn,Aa,Sp,Er,zg="Classifying a target category (a group) based on a set of attributes.",Qp,fs,Rp,an,Ya,Fp,Zr,Og="Predicting a numerical target value given a set of attributes/features in a table.",Pp,bs,Xp,on,Da,Lp,qr,Kg="Perform text classification (e.g. sentiment-analysis) on the given text.",zp,_s,Op,Y,Ba,Kp,Wr,ed="Given a prompt, generate the following text.",eu,Nr,nd=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,nu,Gr,td='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',tu,ys,su,pe,Ha,au,Vr,sd="Generate an image based on a given text using a specified model.",ou,xs,ru,js,lu,rn,Sa,iu,Ar,ad="Synthesize an audio of a voice pronouncing a given text.",cu,Ts,pu,ln,Qa,uu,Yr,od=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,gu,$s,du,D,Ra,mu,Dr,rd="Convert text from one language to another.",hu,Br,ld=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.
You can find this information in the model card.`,fu,Is,bu,Ms,_u,cn,Fa,yu,Hr,id="Answering open-ended questions based on an image.",xu,ws,ju,pn,Pa,Tu,Sr,cd="Provide as input a text and a set of candidate labels to classify the input text.",$u,Cs,Iu,un,Xa,Mu,Qr,pd="Provide input image and text labels to predict text labels for the image.",wu,vs,il,La,cl,gn,za,Cu,Rr,ud="Error raised when a model is unavailable or the request times out.",pl,Oa,ul,Ka,gd="For most tasks, the return value has a built-in type (string, list, image…). Here is a list for the more complex types.",gl,eo,dl,dn,no,vu,Fr,dd='Dictionary containing the “conversation” part of a <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">conversational()</a> task.',ml,to,hl,mn,so,Ju,Pr,md='Dictionary containing the output of a  <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">conversational()</a> task.',fl,ao,bl,hn,oo,Uu,Xr,hd="This Dataclass represents the the model status in the Hugging Face Inference API.",_l,ro,yl,lo,fd=`<code>InferenceAPI</code> is the legacy way to call the Inference API. The interface is more simplistic and requires knowing
the input parameters and output format for each task. It also lacks the ability to connect to other services like
Inference Endpoints or AWS SageMaker. <code>InferenceAPI</code> will soon be deprecated so we recommend using <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
whenever possible. Check out <a href="../guides/inference#legacy-inferenceapi-client">this guide</a> to learn how to switch from
<code>InferenceAPI</code> to <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> in your scripts.`,xl,W,io,ku,Lr,bd="Client to configure requests and make calls to the HuggingFace Inference API.",Eu,Js,Zu,Us,co,qu,zr,_d="Inits headers and API call information.",Wu,ks,po,Nu,Or,yd="Make a call to the Inference API.",jl,Kr,Tl;return r=new et({props:{title:"Inference",local:"inference",headingTag:"h1"}}),qs=new et({props:{title:"Inference Client",local:"huggingface_hub.InferenceClient",headingTag:"h2"}}),Ws=new k({props:{name:"class huggingface_hub.InferenceClient",anchor:"huggingface_hub.InferenceClient",parameters:[{name:"model",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"timeout",val:": Optional = None"},{name:"headers",val:": Optional = None"},{name:"cookies",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>bigcode/starcoder</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.`,name:"token"},{anchor:"huggingface_hub.InferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.InferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.InferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L122"}}),Ns=new k({props:{name:"audio_classification",anchor:"huggingface_hub.InferenceClient.audio_classification",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L291",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),nt=new Z({props:{anchor:"huggingface_hub.InferenceClient.audio_classification.example",$$slots:{default:[kd]},$$scope:{ctx:$}}}),Gs=new k({props:{name:"audio_to_audio",anchor:"huggingface_hub.InferenceClient.audio_to_audio",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L333",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),tt=new Z({props:{anchor:"huggingface_hub.InferenceClient.audio_to_audio.example",$$slots:{default:[Ed]},$$scope:{ctx:$}}}),Vs=new k({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L376",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),st=new Z({props:{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.example",$$slots:{default:[Zd]},$$scope:{ctx:$}}}),As=new k({props:{name:"chat_completion",anchor:"huggingface_hub.InferenceClient.chat_completion",parameters:[{name:"messages",val:": List"},{name:"model",val:": Optional = None"},{name:"stream",val:": bool = False"},{name:"max_tokens",val:": int = 20"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Union = None"},{name:"temperature",val:": float = 1.0"},{name:"top_p",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List[Union[<code>SystemMessage</code>, <code>UserMessage</code>, <code>AssistantMessage</code>]]) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.InferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, optional) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, optional) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 20.`,name:"max_tokens"},{anchor:"huggingface_hub.InferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, optional) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, optional) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, optional) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, optional) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, optional) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L454",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[ChatCompletionOutput, Iterable[ChatCompletionStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),at=new q({props:{$$slots:{default:[qd]},$$scope:{ctx:$}}}),ot=new Z({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example",$$slots:{default:[Wd]},$$scope:{ctx:$}}}),Ys=new k({props:{name:"conversational",anchor:"huggingface_hub.InferenceClient.conversational",parameters:[{name:"text",val:": str"},{name:"generated_responses",val:": Optional = None"},{name:"past_user_inputs",val:": Optional = None"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.conversational.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The last input from the user in the conversation.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.conversational.generated_responses",description:`<strong>generated_responses</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the model. Defaults to None.`,name:"generated_responses"},{anchor:"huggingface_hub.InferenceClient.conversational.past_user_inputs",description:`<strong>past_user_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the user. Should be the same length as
<code>generated_responses</code>. Defaults to None.`,name:"past_user_inputs"},{anchor:"huggingface_hub.InferenceClient.conversational.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for the conversational task. Defaults to None. For more details about the available
parameters, please refer to <a href="https://huggingface.co/docs/api-inference/detailed_parameters#conversational-task" rel="nofollow">this page</a>`,name:"parameters"},{anchor:"huggingface_hub.InferenceClient.conversational.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L665",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated conversational output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),rt=new q({props:{warning:!0,$$slots:{default:[Nd]},$$scope:{ctx:$}}}),lt=new Z({props:{anchor:"huggingface_hub.InferenceClient.conversational.example",$$slots:{default:[Gd]},$$scope:{ctx:$}}}),Ds=new k({props:{name:"document_question_answering",anchor:"huggingface_hub.InferenceClient.document_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L738",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),it=new Z({props:{anchor:"huggingface_hub.InferenceClient.document_question_answering.example",$$slots:{default:[Vd]},$$scope:{ctx:$}}}),Bs=new k({props:{name:"feature_extraction",anchor:"huggingface_hub.InferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.feature_extraction.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L779",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ct=new Z({props:{anchor:"huggingface_hub.InferenceClient.feature_extraction.example",$$slots:{default:[Ad]},$$scope:{ctx:$}}}),Hs=new k({props:{name:"fill_mask",anchor:"huggingface_hub.InferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.InferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L815",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),pt=new Z({props:{anchor:"huggingface_hub.InferenceClient.fill_mask.example",$$slots:{default:[Yd]},$$scope:{ctx:$}}}),Ss=new k({props:{name:"get_model_status",anchor:"huggingface_hub.InferenceClient.get_model_status",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L2303",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),ut=new q({props:{$$slots:{default:[Dd]},$$scope:{ctx:$}}}),gt=new Z({props:{anchor:"huggingface_hub.InferenceClient.get_model_status.example",$$slots:{default:[Bd]},$$scope:{ctx:$}}}),Qs=new k({props:{name:"get_recommended_model",anchor:"huggingface_hub.InferenceClient.get_recommended_model",parameters:[{name:"task",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_recommended_model.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The Hugging Face task to get which model Hugging Face recommends.
All available tasks can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L2279",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Name of the model recommended for the input task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If Hugging Face has no recommendation for the input task.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Rs=new k({props:{name:"image_classification",anchor:"huggingface_hub.InferenceClient.image_classification",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L851",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),mt=new Z({props:{anchor:"huggingface_hub.InferenceClient.image_classification.example",$$slots:{default:[Hd]},$$scope:{ctx:$}}}),Fs=new k({props:{name:"image_segmentation",anchor:"huggingface_hub.InferenceClient.image_segmentation",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L887",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ht=new q({props:{warning:!0,$$slots:{default:[Sd]},$$scope:{ctx:$}}}),ft=new Z({props:{anchor:"huggingface_hub.InferenceClient.image_segmentation.example",$$slots:{default:[Qd]},$$scope:{ctx:$}}}),Ps=new k({props:{name:"image_to_image",anchor:"huggingface_hub.InferenceClient.image_to_image",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Optional = None"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A negative prompt to guide the translation process.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.image_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L932",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),bt=new q({props:{warning:!0,$$slots:{default:[Rd]},$$scope:{ctx:$}}}),_t=new Z({props:{anchor:"huggingface_hub.InferenceClient.image_to_image.example",$$slots:{default:[Fd]},$$scope:{ctx:$}}}),Xs=new k({props:{name:"image_to_text",anchor:"huggingface_hub.InferenceClient.image_to_text",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1016",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),yt=new Z({props:{anchor:"huggingface_hub.InferenceClient.image_to_text.example",$$slots:{default:[Pd]},$$scope:{ctx:$}}}),Ls=new k({props:{name:"list_deployed_models",anchor:"huggingface_hub.InferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1052",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),xt=new q({props:{$$slots:{default:[Xd]},$$scope:{ctx:$}}}),jt=new Z({props:{anchor:"huggingface_hub.InferenceClient.list_deployed_models.example",$$slots:{default:[Ld]},$$scope:{ctx:$}}}),zs=new k({props:{name:"object_detection",anchor:"huggingface_hub.InferenceClient.object_detection",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1127",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),Tt=new q({props:{warning:!0,$$slots:{default:[zd]},$$scope:{ctx:$}}}),$t=new Z({props:{anchor:"huggingface_hub.InferenceClient.object_detection.example",$$slots:{default:[Od]},$$scope:{ctx:$}}}),Os=new k({props:{name:"post",anchor:"huggingface_hub.InferenceClient.post",parameters:[{name:"json",val:": Union = None"},{name:"data",val:": Union = None"},{name:"model",val:": Optional = None"},{name:"task",val:": Optional = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.InferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.InferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. All available tasks can be found
<a href="https://huggingface.co/tasks" rel="nofollow">here</a>. Used only to default to a recommended model if <code>model</code> is not
provided. At least <code>model</code> or <code>task</code> must be provided. Defaults to None.`,name:"task"},{anchor:"huggingface_hub.InferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L199",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ks=new k({props:{name:"question_answering",anchor:"huggingface_hub.InferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.InferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1172",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an question answering output containing the score, start index, end index, and answer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Mt=new Z({props:{anchor:"huggingface_hub.InferenceClient.question_answering.example",$$slots:{default:[Kd]},$$scope:{ctx:$}}}),ea=new k({props:{name:"sentence_similarity",anchor:"huggingface_hub.InferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1213",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),wt=new Z({props:{anchor:"huggingface_hub.InferenceClient.sentence_similarity.example",$$slots:{default:[em]},$$scope:{ctx:$}}}),na=new k({props:{name:"summarization",anchor:"huggingface_hub.InferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.InferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1260",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ct=new Z({props:{anchor:"huggingface_hub.InferenceClient.summarization.example",$$slots:{default:[nm]},$$scope:{ctx:$}}}),ta=new k({props:{name:"table_question_answering",anchor:"huggingface_hub.InferenceClient.table_question_answering",parameters:[{name:"table",val:": Dict"},{name:"query",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1303",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),vt=new Z({props:{anchor:"huggingface_hub.InferenceClient.table_question_answering.example",$$slots:{default:[tm]},$$scope:{ctx:$}}}),sa=new k({props:{name:"tabular_classification",anchor:"huggingface_hub.InferenceClient.tabular_classification",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1348",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Jt=new Z({props:{anchor:"huggingface_hub.InferenceClient.tabular_classification.example",$$slots:{default:[sm]},$$scope:{ctx:$}}}),aa=new k({props:{name:"tabular_regression",anchor:"huggingface_hub.InferenceClient.tabular_regression",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1393",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ut=new Z({props:{anchor:"huggingface_hub.InferenceClient.tabular_regression.example",$$slots:{default:[am]},$$scope:{ctx:$}}}),oa=new k({props:{name:"text_classification",anchor:"huggingface_hub.InferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1433",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),kt=new Z({props:{anchor:"huggingface_hub.InferenceClient.text_classification.example",$$slots:{default:[om]},$$scope:{ctx:$}}}),ra=new k({props:{name:"text_generation",anchor:"huggingface_hub.InferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": Optional = None"},{name:"do_sample",val:": bool = False"},{name:"max_new_tokens",val:": int = 20"},{name:"best_of",val:": Optional = None"},{name:"repetition_penalty",val:": Optional = None"},{name:"return_full_text",val:": bool = False"},{name:"seed",val:": Optional = None"},{name:"stop_sequences",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"watermark",val:": bool = False"},{name:"decoder_input_details",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.InferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>) &#x2014;
Maximum number of generated tokens`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs`,name:"best_of"},{anchor:"huggingface_hub.InferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.InferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>) &#x2014;
Stop generating tokens if a member of <code>stop_sequences</code> is generated`,name:"stop_sequences"},{anchor:"huggingface_hub.InferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.truncate",description:`<strong>truncate</strong> (<code>int</code>) &#x2014;
Truncate inputs tokens to the given size`,name:"truncate"},{anchor:"huggingface_hub.InferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.watermark",description:`<strong>watermark</strong> (<code>bool</code>) &#x2014;
Watermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>`,name:"watermark"},{anchor:"huggingface_hub.InferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1583",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Et=new Z({props:{anchor:"huggingface_hub.InferenceClient.text_generation.example",$$slots:{default:[rm]},$$scope:{ctx:$}}}),la=new k({props:{name:"text_to_image",anchor:"huggingface_hub.InferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional negative prompt for the image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1848",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Zt=new q({props:{warning:!0,$$slots:{default:[lm]},$$scope:{ctx:$}}}),qt=new Z({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example",$$slots:{default:[im]},$$scope:{ctx:$}}}),ia=new k({props:{name:"text_to_speech",anchor:"huggingface_hub.InferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1928",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Wt=new Z({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example",$$slots:{default:[cm]},$$scope:{ctx:$}}}),ca=new k({props:{name:"token_classification",anchor:"huggingface_hub.InferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L1960",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Nt=new Z({props:{anchor:"huggingface_hub.InferenceClient.token_classification.example",$$slots:{default:[pm]},$$scope:{ctx:$}}}),pa=new k({props:{name:"translation",anchor:"huggingface_hub.InferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"src_lang",val:": Optional = None"},{name:"tgt_lang",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Source language of the translation task, i.e. input language. Cannot be passed without <code>tgt_lang</code>.`,name:"src_lang"},{anchor:"huggingface_hub.InferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language of the translation task, i.e. output language. Cannot be passed without <code>src_lang</code>.`,name:"tgt_lang"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L2015",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),Gt=new Z({props:{anchor:"huggingface_hub.InferenceClient.translation.example",$$slots:{default:[um]},$$scope:{ctx:$}}}),Vt=new Z({props:{anchor:"huggingface_hub.InferenceClient.translation.example-2",$$slots:{default:[gm]},$$scope:{ctx:$}}}),ua=new k({props:{name:"visual_question_answering",anchor:"huggingface_hub.InferenceClient.visual_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L2080",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),At=new Z({props:{anchor:"huggingface_hub.InferenceClient.visual_question_answering.example",$$slots:{default:[dm]},$$scope:{ctx:$}}}),ga=new k({props:{name:"zero_shot_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"labels",val:": List"},{name:"multi_label",val:": bool = False"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>) &#x2014;
Boolean that is set to True if classes can overlap.`,name:"multi_label"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L2127",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Yt=new Z({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example",$$slots:{default:[mm]},$$scope:{ctx:$}}}),da=new k({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": Union"},{name:"labels",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_client.py#L2202",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Dt=new Z({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.example",$$slots:{default:[hm]},$$scope:{ctx:$}}}),ma=new et({props:{title:"Async Inference Client",local:"huggingface_hub.AsyncInferenceClient",headingTag:"h2"}}),fa=new E({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),ba=new k({props:{name:"class huggingface_hub.AsyncInferenceClient",anchor:"huggingface_hub.AsyncInferenceClient",parameters:[{name:"model",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"timeout",val:": Optional = None"},{name:"headers",val:": Optional = None"},{name:"cookies",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>bigcode/starcoder</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.`,name:"token"},{anchor:"huggingface_hub.AsyncInferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.AsyncInferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.AsyncInferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L107"}}),_a=new k({props:{name:"audio_classification",anchor:"huggingface_hub.AsyncInferenceClient.audio_classification",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L287",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Bt=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.example",$$slots:{default:[fm]},$$scope:{ctx:$}}}),ya=new k({props:{name:"audio_to_audio",anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L330",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ht=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.example",$$slots:{default:[bm]},$$scope:{ctx:$}}}),xa=new k({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L374",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),St=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.example",$$slots:{default:[_m]},$$scope:{ctx:$}}}),ja=new k({props:{name:"chat_completion",anchor:"huggingface_hub.AsyncInferenceClient.chat_completion",parameters:[{name:"messages",val:": List"},{name:"model",val:": Optional = None"},{name:"stream",val:": bool = False"},{name:"max_tokens",val:": int = 20"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Union = None"},{name:"temperature",val:": float = 1.0"},{name:"top_p",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List[Union[<code>SystemMessage</code>, <code>UserMessage</code>, <code>AssistantMessage</code>]]) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, optional) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, optional) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 20.`,name:"max_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, optional) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, optional) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, optional) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, optional) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, optional) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L453",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[ChatCompletionOutput, Iterable[ChatCompletionStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Qt=new q({props:{$$slots:{default:[ym]},$$scope:{ctx:$}}}),Rt=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example",$$slots:{default:[xm]},$$scope:{ctx:$}}}),Ta=new k({props:{name:"conversational",anchor:"huggingface_hub.AsyncInferenceClient.conversational",parameters:[{name:"text",val:": str"},{name:"generated_responses",val:": Optional = None"},{name:"past_user_inputs",val:": Optional = None"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.conversational.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The last input from the user in the conversation.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.generated_responses",description:`<strong>generated_responses</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the model. Defaults to None.`,name:"generated_responses"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.past_user_inputs",description:`<strong>past_user_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the user. Should be the same length as
<code>generated_responses</code>. Defaults to None.`,name:"past_user_inputs"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for the conversational task. Defaults to None. For more details about the available
parameters, please refer to <a href="https://huggingface.co/docs/api-inference/detailed_parameters#conversational-task" rel="nofollow">this page</a>`,name:"parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L665",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated conversational output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ft=new q({props:{warning:!0,$$slots:{default:[jm]},$$scope:{ctx:$}}}),Pt=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.conversational.example",$$slots:{default:[Tm]},$$scope:{ctx:$}}}),$a=new k({props:{name:"document_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L739",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Xt=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.example",$$slots:{default:[$m]},$$scope:{ctx:$}}}),Ia=new k({props:{name:"feature_extraction",anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L781",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Lt=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.example",$$slots:{default:[Im]},$$scope:{ctx:$}}}),Ma=new k({props:{name:"fill_mask",anchor:"huggingface_hub.AsyncInferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L818",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),zt=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.example",$$slots:{default:[Mm]},$$scope:{ctx:$}}}),wa=new k({props:{name:"get_model_status",anchor:"huggingface_hub.AsyncInferenceClient.get_model_status",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L2336",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),Ot=new q({props:{$$slots:{default:[wm]},$$scope:{ctx:$}}}),Kt=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.example",$$slots:{default:[Cm]},$$scope:{ctx:$}}}),Ca=new k({props:{name:"get_recommended_model",anchor:"huggingface_hub.AsyncInferenceClient.get_recommended_model",parameters:[{name:"task",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_recommended_model.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The Hugging Face task to get which model Hugging Face recommends.
All available tasks can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L2312",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Name of the model recommended for the input task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If Hugging Face has no recommendation for the input task.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),va=new k({props:{name:"image_classification",anchor:"huggingface_hub.AsyncInferenceClient.image_classification",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L855",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ns=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.example",$$slots:{default:[vm]},$$scope:{ctx:$}}}),Ja=new k({props:{name:"image_segmentation",anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L892",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ts=new q({props:{warning:!0,$$slots:{default:[Jm]},$$scope:{ctx:$}}}),ss=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.example",$$slots:{default:[Um]},$$scope:{ctx:$}}}),Ua=new k({props:{name:"image_to_image",anchor:"huggingface_hub.AsyncInferenceClient.image_to_image",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Optional = None"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A negative prompt to guide the translation process.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L938",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),as=new q({props:{warning:!0,$$slots:{default:[km]},$$scope:{ctx:$}}}),os=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.example",$$slots:{default:[Em]},$$scope:{ctx:$}}}),ka=new k({props:{name:"image_to_text",anchor:"huggingface_hub.AsyncInferenceClient.image_to_text",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1023",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),rs=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.example",$$slots:{default:[Zm]},$$scope:{ctx:$}}}),Ea=new k({props:{name:"list_deployed_models",anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1060",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),ls=new q({props:{$$slots:{default:[qm]},$$scope:{ctx:$}}}),is=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.example",$$slots:{default:[Wm]},$$scope:{ctx:$}}}),Za=new k({props:{name:"object_detection",anchor:"huggingface_hub.AsyncInferenceClient.object_detection",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1141",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),cs=new q({props:{warning:!0,$$slots:{default:[Nm]},$$scope:{ctx:$}}}),ps=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.example",$$slots:{default:[Gm]},$$scope:{ctx:$}}}),qa=new k({props:{name:"post",anchor:"huggingface_hub.AsyncInferenceClient.post",parameters:[{name:"json",val:": Union = None"},{name:"data",val:": Union = None"},{name:"model",val:": Optional = None"},{name:"task",val:": Optional = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.AsyncInferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.AsyncInferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. All available tasks can be found
<a href="https://huggingface.co/tasks" rel="nofollow">here</a>. Used only to default to a recommended model if <code>model</code> is not
provided. At least <code>model</code> or <code>task</code> must be provided. Defaults to None.`,name:"task"},{anchor:"huggingface_hub.AsyncInferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L184",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Wa=new k({props:{name:"question_answering",anchor:"huggingface_hub.AsyncInferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1187",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an question answering output containing the score, start index, end index, and answer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),gs=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.example",$$slots:{default:[Vm]},$$scope:{ctx:$}}}),Na=new k({props:{name:"sentence_similarity",anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ds=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.example",$$slots:{default:[Am]},$$scope:{ctx:$}}}),Ga=new k({props:{name:"summarization",anchor:"huggingface_hub.AsyncInferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1277",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ms=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.summarization.example",$$slots:{default:[Ym]},$$scope:{ctx:$}}}),Va=new k({props:{name:"table_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering",parameters:[{name:"table",val:": Dict"},{name:"query",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1321",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),hs=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.example",$$slots:{default:[Dm]},$$scope:{ctx:$}}}),Aa=new k({props:{name:"tabular_classification",anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1367",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),fs=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.example",$$slots:{default:[Bm]},$$scope:{ctx:$}}}),Ya=new k({props:{name:"tabular_regression",anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1413",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),bs=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.example",$$slots:{default:[Hm]},$$scope:{ctx:$}}}),Da=new k({props:{name:"text_classification",anchor:"huggingface_hub.AsyncInferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1454",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),_s=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.example",$$slots:{default:[Sm]},$$scope:{ctx:$}}}),Ba=new k({props:{name:"text_generation",anchor:"huggingface_hub.AsyncInferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": Optional = None"},{name:"do_sample",val:": bool = False"},{name:"max_new_tokens",val:": int = 20"},{name:"best_of",val:": Optional = None"},{name:"repetition_penalty",val:": Optional = None"},{name:"return_full_text",val:": bool = False"},{name:"seed",val:": Optional = None"},{name:"stop_sequences",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"watermark",val:": bool = False"},{name:"decoder_input_details",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>) &#x2014;
Maximum number of generated tokens`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs`,name:"best_of"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>) &#x2014;
Stop generating tokens if a member of <code>stop_sequences</code> is generated`,name:"stop_sequences"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.truncate",description:`<strong>truncate</strong> (<code>int</code>) &#x2014;
Truncate inputs tokens to the given size`,name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.watermark",description:`<strong>watermark</strong> (<code>bool</code>) &#x2014;
Watermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>`,name:"watermark"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1607",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ys=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.example",$$slots:{default:[Qm]},$$scope:{ctx:$}}}),Ha=new k({props:{name:"text_to_image",anchor:"huggingface_hub.AsyncInferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional negative prompt for the image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1874",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),xs=new q({props:{warning:!0,$$slots:{default:[Rm]},$$scope:{ctx:$}}}),js=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example",$$slots:{default:[Fm]},$$scope:{ctx:$}}}),Sa=new k({props:{name:"text_to_speech",anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1955",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ts=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example",$$slots:{default:[Pm]},$$scope:{ctx:$}}}),Qa=new k({props:{name:"token_classification",anchor:"huggingface_hub.AsyncInferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L1988",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),$s=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.example",$$slots:{default:[Xm]},$$scope:{ctx:$}}}),Ra=new k({props:{name:"translation",anchor:"huggingface_hub.AsyncInferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"src_lang",val:": Optional = None"},{name:"tgt_lang",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Source language of the translation task, i.e. input language. Cannot be passed without <code>tgt_lang</code>.`,name:"src_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language of the translation task, i.e. output language. Cannot be passed without <code>src_lang</code>.`,name:"tgt_lang"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L2044",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),Is=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example",$$slots:{default:[Lm]},$$scope:{ctx:$}}}),Ms=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example-2",$$slots:{default:[zm]},$$scope:{ctx:$}}}),Fa=new k({props:{name:"visual_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L2110",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),ws=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.example",$$slots:{default:[Om]},$$scope:{ctx:$}}}),Pa=new k({props:{name:"zero_shot_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"labels",val:": List"},{name:"multi_label",val:": bool = False"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>) &#x2014;
Boolean that is set to True if classes can overlap.`,name:"multi_label"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L2158",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Cs=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example",$$slots:{default:[Km]},$$scope:{ctx:$}}}),Xa=new k({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": Union"},{name:"labels",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_generated/_async_client.py#L2234",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),vs=new Z({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.example",$$slots:{default:[eh]},$$scope:{ctx:$}}}),La=new et({props:{title:"InferenceTimeoutError",local:"huggingface_hub.InferenceTimeoutError",headingTag:"h2"}}),za=new k({props:{name:"class huggingface_hub.InferenceTimeoutError",anchor:"huggingface_hub.InferenceTimeoutError",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/errors.py#L9"}}),Oa=new et({props:{title:"Return types",local:"return-types",headingTag:"h2"}}),eo=new et({props:{title:"ConversationalOutputConversation",local:"huggingface_hub.inference._types.ConversationalOutputConversation",headingTag:"h3"}}),no=new k({props:{name:"class huggingface_hub.inference._types.ConversationalOutputConversation",anchor:"huggingface_hub.inference._types.ConversationalOutputConversation",parameters:"",parametersDescription:[{anchor:"huggingface_hub.inference._types.ConversationalOutputConversation.generated_responses",description:`<strong>generated_responses</strong> (<code>List[str]</code>) &#x2014;
A list of the responses from the model.`,name:"generated_responses"},{anchor:"huggingface_hub.inference._types.ConversationalOutputConversation.past_user_inputs",description:`<strong>past_user_inputs</strong> (<code>List[str]</code>) &#x2014;
A list of the inputs from the user. Must be the same length as <code>generated_responses</code>.`,name:"past_user_inputs"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_types.py#L24"}}),to=new et({props:{title:"ConversationalOutput",local:"huggingface_hub.inference._types.ConversationalOutput",headingTag:"h3"}}),so=new k({props:{name:"class huggingface_hub.inference._types.ConversationalOutput",anchor:"huggingface_hub.inference._types.ConversationalOutput",parameters:"",parametersDescription:[{anchor:"huggingface_hub.inference._types.ConversationalOutput.generated_text",description:`<strong>generated_text</strong> (<code>str</code>) &#x2014;
The last response from the model.`,name:"generated_text"},{anchor:"huggingface_hub.inference._types.ConversationalOutput.conversation",description:`<strong>conversation</strong> (<code>ConversationalOutputConversation</code>) &#x2014;
The past conversation.`,name:"conversation"},{anchor:"huggingface_hub.inference._types.ConversationalOutput.warnings",description:`<strong>warnings</strong> (<code>List[str]</code>) &#x2014;
A list of warnings associated with the process.`,name:"warnings"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_types.py#L38"}}),ao=new et({props:{title:"ModelStatus",local:"huggingface_hub.inference._common.ModelStatus",headingTag:"h3"}}),oo=new k({props:{name:"class huggingface_hub.inference._common.ModelStatus",anchor:"huggingface_hub.inference._common.ModelStatus",parameters:[{name:"loaded",val:": bool"},{name:"state",val:": str"},{name:"compute_type",val:": Dict"},{name:"framework",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.inference._common.ModelStatus.loaded",description:`<strong>loaded</strong> (<code>bool</code>) &#x2014;
If the model is currently loaded into Hugging Face&#x2019;s InferenceAPI. Models
are loaded on-demand, leading to the user&#x2019;s first request taking longer.
If a model is loaded, you can be assured that it is in a healthy state.`,name:"loaded"},{anchor:"huggingface_hub.inference._common.ModelStatus.state",description:`<strong>state</strong> (<code>str</code>) &#x2014;
The current state of the model. This can be &#x2018;Loaded&#x2019;, &#x2018;Loadable&#x2019;, &#x2018;TooBig&#x2019;.
If a model&#x2019;s state is &#x2018;Loadable&#x2019;, it&#x2019;s not too big and has a supported
backend. Loadable models are automatically loaded when the user first
requests inference on the endpoint. This means it is transparent for the
user to load a model, except that the first call takes longer to complete.`,name:"state"},{anchor:"huggingface_hub.inference._common.ModelStatus.compute_type",description:`<strong>compute_type</strong> (<code>Dict</code>) &#x2014;
Information about the compute resource the model is using or will use, such as &#x2018;gpu&#x2019; type and number of
replicas.`,name:"compute_type"},{anchor:"huggingface_hub.inference._common.ModelStatus.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The name of the framework that the model was built with, such as &#x2018;transformers&#x2019;
or &#x2018;text-generation-inference&#x2019;.`,name:"framework"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference/_common.py#L88"}}),ro=new et({props:{title:"InferenceAPI",local:"huggingface_hub.InferenceApi",headingTag:"h2"}}),io=new k({props:{name:"class huggingface_hub.InferenceApi",anchor:"huggingface_hub.InferenceApi",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"gpu",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference_api.py#L46"}}),Js=new Z({props:{anchor:"huggingface_hub.InferenceApi.example",$$slots:{default:[nh]},$$scope:{ctx:$}}}),co=new k({props:{name:"__init__",anchor:"huggingface_hub.InferenceApi.__init__",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"gpu",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__init__.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
Id of repository (e.g. <em>user/bert-base-uncased</em>).`,name:"repo_id"},{anchor:"huggingface_hub.InferenceApi.__init__.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>, defaults <code>None</code>) &#x2014;
Whether to force a task instead of using task specified in the
repository.`,name:"task"},{anchor:"huggingface_hub.InferenceApi.__init__.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API token to use as HTTP bearer authorization. This is not
the authentication token. You can find the token in
<a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>. Alternatively, you can
find both your organizations and personal API tokens using
<em>HfApi().whoami(token)</em>.`,name:"token"},{anchor:"huggingface_hub.InferenceApi.__init__.gpu",description:`<strong>gpu</strong> (<em>bool</em>, <em>optional</em>, defaults <em>False</em>) &#x2014;
Whether to use GPU instead of CPU for inference(requires Startup
plan at least).`,name:"gpu"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference_api.py#L93"}}),po=new k({props:{name:"__call__",anchor:"huggingface_hub.InferenceApi.__call__",parameters:[{name:"inputs",val:": Union = None"},{name:"params",val:": Optional = None"},{name:"data",val:": Optional = None"},{name:"raw_response",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>Dict</code> or <code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Inputs for the prediction.`,name:"inputs"},{anchor:"huggingface_hub.InferenceApi.__call__.params",description:`<strong>params</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional parameters for the models. Will be sent as <code>parameters</code> in the
payload.`,name:"params"},{anchor:"huggingface_hub.InferenceApi.__call__.data",description:`<strong>data</strong> (<code>bytes</code>, <em>optional</em>) &#x2014;
Bytes content of the request. In this case, leave <code>inputs</code> and <code>params</code> empty.`,name:"data"},{anchor:"huggingface_hub.InferenceApi.__call__.raw_response",description:`<strong>raw_response</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the raw <code>Response</code> object is returned. You can parse its content
as preferred. By default, the content is parsed into a more practical format
(json dictionary or PIL Image for example).`,name:"raw_response"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/inference_api.py#L158"}}),{c(){n=u("meta"),d=l(),a=u("p"),t=l(),m(r.$$.fragment),e=l(),c=u("p"),c.innerHTML=Gu,el=l(),Es=u("ul"),Es.innerHTML=Vu,nl=l(),Zs=u("p"),Zs.innerHTML=Au,tl=l(),m(qs.$$.fragment),sl=l(),M=u("div"),m(Ws.$$.fragment),$l=l(),To=u("p"),To.textContent=Yu,Il=l(),$o=u("p"),$o.innerHTML=Du,Ml=l(),Ce=u("div"),m(Ns.$$.fragment),wl=l(),Io=u("p"),Io.textContent=Bu,Cl=l(),m(nt.$$.fragment),vl=l(),ve=u("div"),m(Gs.$$.fragment),Jl=l(),Mo=u("p"),Mo.textContent=Hu,Ul=l(),m(tt.$$.fragment),kl=l(),Je=u("div"),m(Vs.$$.fragment),El=l(),wo=u("p"),wo.textContent=Su,Zl=l(),m(st.$$.fragment),ql=l(),X=u("div"),m(As.$$.fragment),Wl=l(),Co=u("p"),Co.textContent=Qu,Nl=l(),m(at.$$.fragment),Gl=l(),m(ot.$$.fragment),Vl=l(),L=u("div"),m(Ys.$$.fragment),Al=l(),vo=u("p"),vo.textContent=Ru,Yl=l(),m(rt.$$.fragment),Dl=l(),m(lt.$$.fragment),Bl=l(),Ue=u("div"),m(Ds.$$.fragment),Hl=l(),Jo=u("p"),Jo.textContent=Fu,Sl=l(),m(it.$$.fragment),Ql=l(),ke=u("div"),m(Bs.$$.fragment),Rl=l(),Uo=u("p"),Uo.textContent=Pu,Fl=l(),m(ct.$$.fragment),Pl=l(),Ee=u("div"),m(Hs.$$.fragment),Xl=l(),ko=u("p"),ko.textContent=Xu,Ll=l(),m(pt.$$.fragment),zl=l(),z=u("div"),m(Ss.$$.fragment),Ol=l(),Eo=u("p"),Eo.textContent=Lu,Kl=l(),m(ut.$$.fragment),ei=l(),m(gt.$$.fragment),ni=l(),dt=u("div"),m(Qs.$$.fragment),ti=l(),Zo=u("p"),Zo.textContent=zu,si=l(),Ze=u("div"),m(Rs.$$.fragment),ai=l(),qo=u("p"),qo.textContent=Ou,oi=l(),m(mt.$$.fragment),ri=l(),O=u("div"),m(Fs.$$.fragment),li=l(),Wo=u("p"),Wo.textContent=Ku,ii=l(),m(ht.$$.fragment),ci=l(),m(ft.$$.fragment),pi=l(),K=u("div"),m(Ps.$$.fragment),ui=l(),No=u("p"),No.textContent=eg,gi=l(),m(bt.$$.fragment),di=l(),m(_t.$$.fragment),mi=l(),ee=u("div"),m(Xs.$$.fragment),hi=l(),Go=u("p"),Go.textContent=ng,fi=l(),Vo=u("p"),Vo.textContent=tg,bi=l(),m(yt.$$.fragment),_i=l(),N=u("div"),m(Ls.$$.fragment),yi=l(),Ao=u("p"),Ao.textContent=sg,xi=l(),Yo=u("p"),Yo.innerHTML=ag,ji=l(),m(xt.$$.fragment),Ti=l(),m(jt.$$.fragment),$i=l(),ne=u("div"),m(zs.$$.fragment),Ii=l(),Do=u("p"),Do.textContent=og,Mi=l(),m(Tt.$$.fragment),wi=l(),m($t.$$.fragment),Ci=l(),It=u("div"),m(Os.$$.fragment),vi=l(),Bo=u("p"),Bo.textContent=rg,Ji=l(),qe=u("div"),m(Ks.$$.fragment),Ui=l(),Ho=u("p"),Ho.textContent=lg,ki=l(),m(Mt.$$.fragment),Ei=l(),We=u("div"),m(ea.$$.fragment),Zi=l(),So=u("p"),So.textContent=ig,qi=l(),m(wt.$$.fragment),Wi=l(),Ne=u("div"),m(na.$$.fragment),Ni=l(),Qo=u("p"),Qo.textContent=cg,Gi=l(),m(Ct.$$.fragment),Vi=l(),Ge=u("div"),m(ta.$$.fragment),Ai=l(),Ro=u("p"),Ro.textContent=pg,Yi=l(),m(vt.$$.fragment),Di=l(),Ve=u("div"),m(sa.$$.fragment),Bi=l(),Fo=u("p"),Fo.textContent=ug,Hi=l(),m(Jt.$$.fragment),Si=l(),Ae=u("div"),m(aa.$$.fragment),Qi=l(),Po=u("p"),Po.textContent=gg,Ri=l(),m(Ut.$$.fragment),Fi=l(),Ye=u("div"),m(oa.$$.fragment),Pi=l(),Xo=u("p"),Xo.textContent=dg,Xi=l(),m(kt.$$.fragment),Li=l(),G=u("div"),m(ra.$$.fragment),zi=l(),Lo=u("p"),Lo.textContent=mg,Oi=l(),zo=u("p"),zo.innerHTML=hg,Ki=l(),Oo=u("p"),Oo.innerHTML=fg,ec=l(),m(Et.$$.fragment),nc=l(),te=u("div"),m(la.$$.fragment),tc=l(),Ko=u("p"),Ko.textContent=bg,sc=l(),m(Zt.$$.fragment),ac=l(),m(qt.$$.fragment),oc=l(),De=u("div"),m(ia.$$.fragment),rc=l(),er=u("p"),er.textContent=_g,lc=l(),m(Wt.$$.fragment),ic=l(),Be=u("div"),m(ca.$$.fragment),cc=l(),nr=u("p"),nr.textContent=yg,pc=l(),m(Nt.$$.fragment),uc=l(),V=u("div"),m(pa.$$.fragment),gc=l(),tr=u("p"),tr.textContent=xg,dc=l(),sr=u("p"),sr.innerHTML=jg,mc=l(),m(Gt.$$.fragment),hc=l(),m(Vt.$$.fragment),fc=l(),He=u("div"),m(ua.$$.fragment),bc=l(),ar=u("p"),ar.textContent=Tg,_c=l(),m(At.$$.fragment),yc=l(),Se=u("div"),m(ga.$$.fragment),xc=l(),or=u("p"),or.textContent=$g,jc=l(),m(Yt.$$.fragment),Tc=l(),Qe=u("div"),m(da.$$.fragment),$c=l(),rr=u("p"),rr.textContent=Ig,Ic=l(),m(Dt.$$.fragment),al=l(),m(ma.$$.fragment),ol=l(),ha=u("p"),ha.innerHTML=Mg,rl=l(),m(fa.$$.fragment),ll=l(),w=u("div"),m(ba.$$.fragment),Mc=l(),lr=u("p"),lr.textContent=wg,wc=l(),ir=u("p"),ir.innerHTML=Cg,Cc=l(),Re=u("div"),m(_a.$$.fragment),vc=l(),cr=u("p"),cr.textContent=vg,Jc=l(),m(Bt.$$.fragment),Uc=l(),Fe=u("div"),m(ya.$$.fragment),kc=l(),pr=u("p"),pr.textContent=Jg,Ec=l(),m(Ht.$$.fragment),Zc=l(),Pe=u("div"),m(xa.$$.fragment),qc=l(),ur=u("p"),ur.textContent=Ug,Wc=l(),m(St.$$.fragment),Nc=l(),se=u("div"),m(ja.$$.fragment),Gc=l(),gr=u("p"),gr.textContent=kg,Vc=l(),m(Qt.$$.fragment),Ac=l(),m(Rt.$$.fragment),Yc=l(),ae=u("div"),m(Ta.$$.fragment),Dc=l(),dr=u("p"),dr.textContent=Eg,Bc=l(),m(Ft.$$.fragment),Hc=l(),m(Pt.$$.fragment),Sc=l(),Xe=u("div"),m($a.$$.fragment),Qc=l(),mr=u("p"),mr.textContent=Zg,Rc=l(),m(Xt.$$.fragment),Fc=l(),Le=u("div"),m(Ia.$$.fragment),Pc=l(),hr=u("p"),hr.textContent=qg,Xc=l(),m(Lt.$$.fragment),Lc=l(),ze=u("div"),m(Ma.$$.fragment),zc=l(),fr=u("p"),fr.textContent=Wg,Oc=l(),m(zt.$$.fragment),Kc=l(),oe=u("div"),m(wa.$$.fragment),ep=l(),br=u("p"),br.textContent=Ng,np=l(),m(Ot.$$.fragment),tp=l(),m(Kt.$$.fragment),sp=l(),es=u("div"),m(Ca.$$.fragment),ap=l(),_r=u("p"),_r.textContent=Gg,op=l(),Oe=u("div"),m(va.$$.fragment),rp=l(),yr=u("p"),yr.textContent=Vg,lp=l(),m(ns.$$.fragment),ip=l(),re=u("div"),m(Ja.$$.fragment),cp=l(),xr=u("p"),xr.textContent=Ag,pp=l(),m(ts.$$.fragment),up=l(),m(ss.$$.fragment),gp=l(),le=u("div"),m(Ua.$$.fragment),dp=l(),jr=u("p"),jr.textContent=Yg,mp=l(),m(as.$$.fragment),hp=l(),m(os.$$.fragment),fp=l(),ie=u("div"),m(ka.$$.fragment),bp=l(),Tr=u("p"),Tr.textContent=Dg,_p=l(),$r=u("p"),$r.textContent=Bg,yp=l(),m(rs.$$.fragment),xp=l(),A=u("div"),m(Ea.$$.fragment),jp=l(),Ir=u("p"),Ir.textContent=Hg,Tp=l(),Mr=u("p"),Mr.innerHTML=Sg,$p=l(),m(ls.$$.fragment),Ip=l(),m(is.$$.fragment),Mp=l(),ce=u("div"),m(Za.$$.fragment),wp=l(),wr=u("p"),wr.textContent=Qg,Cp=l(),m(cs.$$.fragment),vp=l(),m(ps.$$.fragment),Jp=l(),us=u("div"),m(qa.$$.fragment),Up=l(),Cr=u("p"),Cr.textContent=Rg,kp=l(),Ke=u("div"),m(Wa.$$.fragment),Ep=l(),vr=u("p"),vr.textContent=Fg,Zp=l(),m(gs.$$.fragment),qp=l(),en=u("div"),m(Na.$$.fragment),Wp=l(),Jr=u("p"),Jr.textContent=Pg,Np=l(),m(ds.$$.fragment),Gp=l(),nn=u("div"),m(Ga.$$.fragment),Vp=l(),Ur=u("p"),Ur.textContent=Xg,Ap=l(),m(ms.$$.fragment),Yp=l(),tn=u("div"),m(Va.$$.fragment),Dp=l(),kr=u("p"),kr.textContent=Lg,Bp=l(),m(hs.$$.fragment),Hp=l(),sn=u("div"),m(Aa.$$.fragment),Sp=l(),Er=u("p"),Er.textContent=zg,Qp=l(),m(fs.$$.fragment),Rp=l(),an=u("div"),m(Ya.$$.fragment),Fp=l(),Zr=u("p"),Zr.textContent=Og,Pp=l(),m(bs.$$.fragment),Xp=l(),on=u("div"),m(Da.$$.fragment),Lp=l(),qr=u("p"),qr.textContent=Kg,zp=l(),m(_s.$$.fragment),Op=l(),Y=u("div"),m(Ba.$$.fragment),Kp=l(),Wr=u("p"),Wr.textContent=ed,eu=l(),Nr=u("p"),Nr.innerHTML=nd,nu=l(),Gr=u("p"),Gr.innerHTML=td,tu=l(),m(ys.$$.fragment),su=l(),pe=u("div"),m(Ha.$$.fragment),au=l(),Vr=u("p"),Vr.textContent=sd,ou=l(),m(xs.$$.fragment),ru=l(),m(js.$$.fragment),lu=l(),rn=u("div"),m(Sa.$$.fragment),iu=l(),Ar=u("p"),Ar.textContent=ad,cu=l(),m(Ts.$$.fragment),pu=l(),ln=u("div"),m(Qa.$$.fragment),uu=l(),Yr=u("p"),Yr.textContent=od,gu=l(),m($s.$$.fragment),du=l(),D=u("div"),m(Ra.$$.fragment),mu=l(),Dr=u("p"),Dr.textContent=rd,hu=l(),Br=u("p"),Br.innerHTML=ld,fu=l(),m(Is.$$.fragment),bu=l(),m(Ms.$$.fragment),_u=l(),cn=u("div"),m(Fa.$$.fragment),yu=l(),Hr=u("p"),Hr.textContent=id,xu=l(),m(ws.$$.fragment),ju=l(),pn=u("div"),m(Pa.$$.fragment),Tu=l(),Sr=u("p"),Sr.textContent=cd,$u=l(),m(Cs.$$.fragment),Iu=l(),un=u("div"),m(Xa.$$.fragment),Mu=l(),Qr=u("p"),Qr.textContent=pd,wu=l(),m(vs.$$.fragment),il=l(),m(La.$$.fragment),cl=l(),gn=u("div"),m(za.$$.fragment),Cu=l(),Rr=u("p"),Rr.textContent=ud,pl=l(),m(Oa.$$.fragment),ul=l(),Ka=u("p"),Ka.textContent=gd,gl=l(),m(eo.$$.fragment),dl=l(),dn=u("div"),m(no.$$.fragment),vu=l(),Fr=u("p"),Fr.innerHTML=dd,ml=l(),m(to.$$.fragment),hl=l(),mn=u("div"),m(so.$$.fragment),Ju=l(),Pr=u("p"),Pr.innerHTML=md,fl=l(),m(ao.$$.fragment),bl=l(),hn=u("div"),m(oo.$$.fragment),Uu=l(),Xr=u("p"),Xr.textContent=hd,_l=l(),m(ro.$$.fragment),yl=l(),lo=u("p"),lo.innerHTML=fd,xl=l(),W=u("div"),m(io.$$.fragment),ku=l(),Lr=u("p"),Lr.textContent=bd,Eu=l(),m(Js.$$.fragment),Zu=l(),Us=u("div"),m(co.$$.fragment),qu=l(),zr=u("p"),zr.textContent=_d,Wu=l(),ks=u("div"),m(po.$$.fragment),Nu=l(),Or=u("p"),Or.textContent=yd,jl=l(),Kr=u("p"),this.h()},l(s){const x=Ud("svelte-u9bgzb",document.head);n=g(x,"META",{name:!0,content:!0}),x.forEach(p),d=i(s),a=g(s,"P",{}),C(a).forEach(p),t=i(s),h(r.$$.fragment,s),e=i(s),c=g(s,"P",{"data-svelte-h":!0}),T(c)!=="svelte-411gzg"&&(c.innerHTML=Gu),el=i(s),Es=g(s,"UL",{"data-svelte-h":!0}),T(Es)!=="svelte-1qqordt"&&(Es.innerHTML=Vu),nl=i(s),Zs=g(s,"P",{"data-svelte-h":!0}),T(Zs)!=="svelte-1m90vjw"&&(Zs.innerHTML=Au),tl=i(s),h(qs.$$.fragment,s),sl=i(s),M=g(s,"DIV",{class:!0});var J=C(M);h(Ws.$$.fragment,J),$l=i(J),To=g(J,"P",{"data-svelte-h":!0}),T(To)!=="svelte-1p4u01l"&&(To.textContent=Yu),Il=i(J),$o=g(J,"P",{"data-svelte-h":!0}),T($o)!=="svelte-1l1230x"&&($o.innerHTML=Du),Ml=i(J),Ce=g(J,"DIV",{class:!0});var fn=C(Ce);h(Ns.$$.fragment,fn),wl=i(fn),Io=g(fn,"P",{"data-svelte-h":!0}),T(Io)!=="svelte-1hs5qib"&&(Io.textContent=Bu),Cl=i(fn),h(nt.$$.fragment,fn),fn.forEach(p),vl=i(J),ve=g(J,"DIV",{class:!0});var bn=C(ve);h(Gs.$$.fragment,bn),Jl=i(bn),Mo=g(bn,"P",{"data-svelte-h":!0}),T(Mo)!=="svelte-z9e742"&&(Mo.textContent=Hu),Ul=i(bn),h(tt.$$.fragment,bn),bn.forEach(p),kl=i(J),Je=g(J,"DIV",{class:!0});var _n=C(Je);h(Vs.$$.fragment,_n),El=i(_n),wo=g(_n,"P",{"data-svelte-h":!0}),T(wo)!=="svelte-lahnll"&&(wo.textContent=Su),Zl=i(_n),h(st.$$.fragment,_n),_n.forEach(p),ql=i(J),X=g(J,"DIV",{class:!0});var ue=C(X);h(As.$$.fragment,ue),Wl=i(ue),Co=g(ue,"P",{"data-svelte-h":!0}),T(Co)!=="svelte-5o70yf"&&(Co.textContent=Qu),Nl=i(ue),h(at.$$.fragment,ue),Gl=i(ue),h(ot.$$.fragment,ue),ue.forEach(p),Vl=i(J),L=g(J,"DIV",{class:!0});var ge=C(L);h(Ys.$$.fragment,ge),Al=i(ge),vo=g(ge,"P",{"data-svelte-h":!0}),T(vo)!=="svelte-2dk21c"&&(vo.textContent=Ru),Yl=i(ge),h(rt.$$.fragment,ge),Dl=i(ge),h(lt.$$.fragment,ge),ge.forEach(p),Bl=i(J),Ue=g(J,"DIV",{class:!0});var yn=C(Ue);h(Ds.$$.fragment,yn),Hl=i(yn),Jo=g(yn,"P",{"data-svelte-h":!0}),T(Jo)!=="svelte-qs8cmr"&&(Jo.textContent=Fu),Sl=i(yn),h(it.$$.fragment,yn),yn.forEach(p),Ql=i(J),ke=g(J,"DIV",{class:!0});var xn=C(ke);h(Bs.$$.fragment,xn),Rl=i(xn),Uo=g(xn,"P",{"data-svelte-h":!0}),T(Uo)!=="svelte-1axtrg9"&&(Uo.textContent=Pu),Fl=i(xn),h(ct.$$.fragment,xn),xn.forEach(p),Pl=i(J),Ee=g(J,"DIV",{class:!0});var jn=C(Ee);h(Hs.$$.fragment,jn),Xl=i(jn),ko=g(jn,"P",{"data-svelte-h":!0}),T(ko)!=="svelte-1lnjtsz"&&(ko.textContent=Xu),Ll=i(jn),h(pt.$$.fragment,jn),jn.forEach(p),zl=i(J),z=g(J,"DIV",{class:!0});var de=C(z);h(Ss.$$.fragment,de),Ol=i(de),Eo=g(de,"P",{"data-svelte-h":!0}),T(Eo)!=="svelte-1htupoc"&&(Eo.textContent=Lu),Kl=i(de),h(ut.$$.fragment,de),ei=i(de),h(gt.$$.fragment,de),de.forEach(p),ni=i(J),dt=g(J,"DIV",{class:!0});var uo=C(dt);h(Qs.$$.fragment,uo),ti=i(uo),Zo=g(uo,"P",{"data-svelte-h":!0}),T(Zo)!=="svelte-1qi4mtg"&&(Zo.textContent=zu),uo.forEach(p),si=i(J),Ze=g(J,"DIV",{class:!0});var Tn=C(Ze);h(Rs.$$.fragment,Tn),ai=i(Tn),qo=g(Tn,"P",{"data-svelte-h":!0}),T(qo)!=="svelte-u63854"&&(qo.textContent=Ou),oi=i(Tn),h(mt.$$.fragment,Tn),Tn.forEach(p),ri=i(J),O=g(J,"DIV",{class:!0});var me=C(O);h(Fs.$$.fragment,me),li=i(me),Wo=g(me,"P",{"data-svelte-h":!0}),T(Wo)!=="svelte-k6f11e"&&(Wo.textContent=Ku),ii=i(me),h(ht.$$.fragment,me),ci=i(me),h(ft.$$.fragment,me),me.forEach(p),pi=i(J),K=g(J,"DIV",{class:!0});var he=C(K);h(Ps.$$.fragment,he),ui=i(he),No=g(he,"P",{"data-svelte-h":!0}),T(No)!=="svelte-7cx5l1"&&(No.textContent=eg),gi=i(he),h(bt.$$.fragment,he),di=i(he),h(_t.$$.fragment,he),he.forEach(p),mi=i(J),ee=g(J,"DIV",{class:!0});var fe=C(ee);h(Xs.$$.fragment,fe),hi=i(fe),Go=g(fe,"P",{"data-svelte-h":!0}),T(Go)!=="svelte-1tnfouk"&&(Go.textContent=ng),fi=i(fe),Vo=g(fe,"P",{"data-svelte-h":!0}),T(Vo)!=="svelte-qrqo93"&&(Vo.textContent=tg),bi=i(fe),h(yt.$$.fragment,fe),fe.forEach(p),_i=i(J),N=g(J,"DIV",{class:!0});var B=C(N);h(Ls.$$.fragment,B),yi=i(B),Ao=g(B,"P",{"data-svelte-h":!0}),T(Ao)!=="svelte-15v8qnq"&&(Ao.textContent=sg),xi=i(B),Yo=g(B,"P",{"data-svelte-h":!0}),T(Yo)!=="svelte-1k36r1q"&&(Yo.innerHTML=ag),ji=i(B),h(xt.$$.fragment,B),Ti=i(B),h(jt.$$.fragment,B),B.forEach(p),$i=i(J),ne=g(J,"DIV",{class:!0});var be=C(ne);h(zs.$$.fragment,be),Ii=i(be),Do=g(be,"P",{"data-svelte-h":!0}),T(Do)!=="svelte-fzfwfh"&&(Do.textContent=og),Mi=i(be),h(Tt.$$.fragment,be),wi=i(be),h($t.$$.fragment,be),be.forEach(p),Ci=i(J),It=g(J,"DIV",{class:!0});var go=C(It);h(Os.$$.fragment,go),vi=i(go),Bo=g(go,"P",{"data-svelte-h":!0}),T(Bo)!=="svelte-14tnsya"&&(Bo.textContent=rg),go.forEach(p),Ji=i(J),qe=g(J,"DIV",{class:!0});var $n=C(qe);h(Ks.$$.fragment,$n),Ui=i($n),Ho=g($n,"P",{"data-svelte-h":!0}),T(Ho)!=="svelte-1mibg86"&&(Ho.textContent=lg),ki=i($n),h(Mt.$$.fragment,$n),$n.forEach(p),Ei=i(J),We=g(J,"DIV",{class:!0});var In=C(We);h(ea.$$.fragment,In),Zi=i(In),So=g(In,"P",{"data-svelte-h":!0}),T(So)!=="svelte-1nuhgbh"&&(So.textContent=ig),qi=i(In),h(wt.$$.fragment,In),In.forEach(p),Wi=i(J),Ne=g(J,"DIV",{class:!0});var Mn=C(Ne);h(na.$$.fragment,Mn),Ni=i(Mn),Qo=g(Mn,"P",{"data-svelte-h":!0}),T(Qo)!=="svelte-1uepm2o"&&(Qo.textContent=cg),Gi=i(Mn),h(Ct.$$.fragment,Mn),Mn.forEach(p),Vi=i(J),Ge=g(J,"DIV",{class:!0});var wn=C(Ge);h(ta.$$.fragment,wn),Ai=i(wn),Ro=g(wn,"P",{"data-svelte-h":!0}),T(Ro)!=="svelte-77a94i"&&(Ro.textContent=pg),Yi=i(wn),h(vt.$$.fragment,wn),wn.forEach(p),Di=i(J),Ve=g(J,"DIV",{class:!0});var Cn=C(Ve);h(sa.$$.fragment,Cn),Bi=i(Cn),Fo=g(Cn,"P",{"data-svelte-h":!0}),T(Fo)!=="svelte-61sxmo"&&(Fo.textContent=ug),Hi=i(Cn),h(Jt.$$.fragment,Cn),Cn.forEach(p),Si=i(J),Ae=g(J,"DIV",{class:!0});var vn=C(Ae);h(aa.$$.fragment,vn),Qi=i(vn),Po=g(vn,"P",{"data-svelte-h":!0}),T(Po)!=="svelte-hzldyu"&&(Po.textContent=gg),Ri=i(vn),h(Ut.$$.fragment,vn),vn.forEach(p),Fi=i(J),Ye=g(J,"DIV",{class:!0});var Jn=C(Ye);h(oa.$$.fragment,Jn),Pi=i(Jn),Xo=g(Jn,"P",{"data-svelte-h":!0}),T(Xo)!=="svelte-b4yzyj"&&(Xo.textContent=dg),Xi=i(Jn),h(kt.$$.fragment,Jn),Jn.forEach(p),Li=i(J),G=g(J,"DIV",{class:!0});var H=C(G);h(ra.$$.fragment,H),zi=i(H),Lo=g(H,"P",{"data-svelte-h":!0}),T(Lo)!=="svelte-qakvx8"&&(Lo.textContent=mg),Oi=i(H),zo=g(H,"P",{"data-svelte-h":!0}),T(zo)!=="svelte-1irx2op"&&(zo.innerHTML=hg),Ki=i(H),Oo=g(H,"P",{"data-svelte-h":!0}),T(Oo)!=="svelte-140zl9b"&&(Oo.innerHTML=fg),ec=i(H),h(Et.$$.fragment,H),H.forEach(p),nc=i(J),te=g(J,"DIV",{class:!0});var _e=C(te);h(la.$$.fragment,_e),tc=i(_e),Ko=g(_e,"P",{"data-svelte-h":!0}),T(Ko)!=="svelte-9lmcnw"&&(Ko.textContent=bg),sc=i(_e),h(Zt.$$.fragment,_e),ac=i(_e),h(qt.$$.fragment,_e),_e.forEach(p),oc=i(J),De=g(J,"DIV",{class:!0});var Un=C(De);h(ia.$$.fragment,Un),rc=i(Un),er=g(Un,"P",{"data-svelte-h":!0}),T(er)!=="svelte-12mjzdy"&&(er.textContent=_g),lc=i(Un),h(Wt.$$.fragment,Un),Un.forEach(p),ic=i(J),Be=g(J,"DIV",{class:!0});var kn=C(Be);h(ca.$$.fragment,kn),cc=i(kn),nr=g(kn,"P",{"data-svelte-h":!0}),T(nr)!=="svelte-1araal"&&(nr.textContent=yg),pc=i(kn),h(Nt.$$.fragment,kn),kn.forEach(p),uc=i(J),V=g(J,"DIV",{class:!0});var S=C(V);h(pa.$$.fragment,S),gc=i(S),tr=g(S,"P",{"data-svelte-h":!0}),T(tr)!=="svelte-1v3lqck"&&(tr.textContent=xg),dc=i(S),sr=g(S,"P",{"data-svelte-h":!0}),T(sr)!=="svelte-19inetw"&&(sr.innerHTML=jg),mc=i(S),h(Gt.$$.fragment,S),hc=i(S),h(Vt.$$.fragment,S),S.forEach(p),fc=i(J),He=g(J,"DIV",{class:!0});var En=C(He);h(ua.$$.fragment,En),bc=i(En),ar=g(En,"P",{"data-svelte-h":!0}),T(ar)!=="svelte-1jbp6ey"&&(ar.textContent=Tg),_c=i(En),h(At.$$.fragment,En),En.forEach(p),yc=i(J),Se=g(J,"DIV",{class:!0});var Zn=C(Se);h(ga.$$.fragment,Zn),xc=i(Zn),or=g(Zn,"P",{"data-svelte-h":!0}),T(or)!=="svelte-1c9xuqj"&&(or.textContent=$g),jc=i(Zn),h(Yt.$$.fragment,Zn),Zn.forEach(p),Tc=i(J),Qe=g(J,"DIV",{class:!0});var qn=C(Qe);h(da.$$.fragment,qn),$c=i(qn),rr=g(qn,"P",{"data-svelte-h":!0}),T(rr)!=="svelte-108ipf8"&&(rr.textContent=Ig),Ic=i(qn),h(Dt.$$.fragment,qn),qn.forEach(p),J.forEach(p),al=i(s),h(ma.$$.fragment,s),ol=i(s),ha=g(s,"P",{"data-svelte-h":!0}),T(ha)!=="svelte-nn0rvx"&&(ha.innerHTML=Mg),rl=i(s),h(fa.$$.fragment,s),ll=i(s),w=g(s,"DIV",{class:!0});var U=C(w);h(ba.$$.fragment,U),Mc=i(U),lr=g(U,"P",{"data-svelte-h":!0}),T(lr)!=="svelte-1p4u01l"&&(lr.textContent=wg),wc=i(U),ir=g(U,"P",{"data-svelte-h":!0}),T(ir)!=="svelte-1l1230x"&&(ir.innerHTML=Cg),Cc=i(U),Re=g(U,"DIV",{class:!0});var Wn=C(Re);h(_a.$$.fragment,Wn),vc=i(Wn),cr=g(Wn,"P",{"data-svelte-h":!0}),T(cr)!=="svelte-1hs5qib"&&(cr.textContent=vg),Jc=i(Wn),h(Bt.$$.fragment,Wn),Wn.forEach(p),Uc=i(U),Fe=g(U,"DIV",{class:!0});var Nn=C(Fe);h(ya.$$.fragment,Nn),kc=i(Nn),pr=g(Nn,"P",{"data-svelte-h":!0}),T(pr)!=="svelte-z9e742"&&(pr.textContent=Jg),Ec=i(Nn),h(Ht.$$.fragment,Nn),Nn.forEach(p),Zc=i(U),Pe=g(U,"DIV",{class:!0});var Gn=C(Pe);h(xa.$$.fragment,Gn),qc=i(Gn),ur=g(Gn,"P",{"data-svelte-h":!0}),T(ur)!=="svelte-lahnll"&&(ur.textContent=Ug),Wc=i(Gn),h(St.$$.fragment,Gn),Gn.forEach(p),Nc=i(U),se=g(U,"DIV",{class:!0});var ye=C(se);h(ja.$$.fragment,ye),Gc=i(ye),gr=g(ye,"P",{"data-svelte-h":!0}),T(gr)!=="svelte-5o70yf"&&(gr.textContent=kg),Vc=i(ye),h(Qt.$$.fragment,ye),Ac=i(ye),h(Rt.$$.fragment,ye),ye.forEach(p),Yc=i(U),ae=g(U,"DIV",{class:!0});var xe=C(ae);h(Ta.$$.fragment,xe),Dc=i(xe),dr=g(xe,"P",{"data-svelte-h":!0}),T(dr)!=="svelte-2dk21c"&&(dr.textContent=Eg),Bc=i(xe),h(Ft.$$.fragment,xe),Hc=i(xe),h(Pt.$$.fragment,xe),xe.forEach(p),Sc=i(U),Xe=g(U,"DIV",{class:!0});var Vn=C(Xe);h($a.$$.fragment,Vn),Qc=i(Vn),mr=g(Vn,"P",{"data-svelte-h":!0}),T(mr)!=="svelte-qs8cmr"&&(mr.textContent=Zg),Rc=i(Vn),h(Xt.$$.fragment,Vn),Vn.forEach(p),Fc=i(U),Le=g(U,"DIV",{class:!0});var An=C(Le);h(Ia.$$.fragment,An),Pc=i(An),hr=g(An,"P",{"data-svelte-h":!0}),T(hr)!=="svelte-1axtrg9"&&(hr.textContent=qg),Xc=i(An),h(Lt.$$.fragment,An),An.forEach(p),Lc=i(U),ze=g(U,"DIV",{class:!0});var Yn=C(ze);h(Ma.$$.fragment,Yn),zc=i(Yn),fr=g(Yn,"P",{"data-svelte-h":!0}),T(fr)!=="svelte-1lnjtsz"&&(fr.textContent=Wg),Oc=i(Yn),h(zt.$$.fragment,Yn),Yn.forEach(p),Kc=i(U),oe=g(U,"DIV",{class:!0});var je=C(oe);h(wa.$$.fragment,je),ep=i(je),br=g(je,"P",{"data-svelte-h":!0}),T(br)!=="svelte-1htupoc"&&(br.textContent=Ng),np=i(je),h(Ot.$$.fragment,je),tp=i(je),h(Kt.$$.fragment,je),je.forEach(p),sp=i(U),es=g(U,"DIV",{class:!0});var mo=C(es);h(Ca.$$.fragment,mo),ap=i(mo),_r=g(mo,"P",{"data-svelte-h":!0}),T(_r)!=="svelte-1qi4mtg"&&(_r.textContent=Gg),mo.forEach(p),op=i(U),Oe=g(U,"DIV",{class:!0});var Dn=C(Oe);h(va.$$.fragment,Dn),rp=i(Dn),yr=g(Dn,"P",{"data-svelte-h":!0}),T(yr)!=="svelte-u63854"&&(yr.textContent=Vg),lp=i(Dn),h(ns.$$.fragment,Dn),Dn.forEach(p),ip=i(U),re=g(U,"DIV",{class:!0});var Te=C(re);h(Ja.$$.fragment,Te),cp=i(Te),xr=g(Te,"P",{"data-svelte-h":!0}),T(xr)!=="svelte-k6f11e"&&(xr.textContent=Ag),pp=i(Te),h(ts.$$.fragment,Te),up=i(Te),h(ss.$$.fragment,Te),Te.forEach(p),gp=i(U),le=g(U,"DIV",{class:!0});var $e=C(le);h(Ua.$$.fragment,$e),dp=i($e),jr=g($e,"P",{"data-svelte-h":!0}),T(jr)!=="svelte-7cx5l1"&&(jr.textContent=Yg),mp=i($e),h(as.$$.fragment,$e),hp=i($e),h(os.$$.fragment,$e),$e.forEach(p),fp=i(U),ie=g(U,"DIV",{class:!0});var Ie=C(ie);h(ka.$$.fragment,Ie),bp=i(Ie),Tr=g(Ie,"P",{"data-svelte-h":!0}),T(Tr)!=="svelte-1tnfouk"&&(Tr.textContent=Dg),_p=i(Ie),$r=g(Ie,"P",{"data-svelte-h":!0}),T($r)!=="svelte-qrqo93"&&($r.textContent=Bg),yp=i(Ie),h(rs.$$.fragment,Ie),Ie.forEach(p),xp=i(U),A=g(U,"DIV",{class:!0});var Q=C(A);h(Ea.$$.fragment,Q),jp=i(Q),Ir=g(Q,"P",{"data-svelte-h":!0}),T(Ir)!=="svelte-15v8qnq"&&(Ir.textContent=Hg),Tp=i(Q),Mr=g(Q,"P",{"data-svelte-h":!0}),T(Mr)!=="svelte-1k36r1q"&&(Mr.innerHTML=Sg),$p=i(Q),h(ls.$$.fragment,Q),Ip=i(Q),h(is.$$.fragment,Q),Q.forEach(p),Mp=i(U),ce=g(U,"DIV",{class:!0});var Me=C(ce);h(Za.$$.fragment,Me),wp=i(Me),wr=g(Me,"P",{"data-svelte-h":!0}),T(wr)!=="svelte-fzfwfh"&&(wr.textContent=Qg),Cp=i(Me),h(cs.$$.fragment,Me),vp=i(Me),h(ps.$$.fragment,Me),Me.forEach(p),Jp=i(U),us=g(U,"DIV",{class:!0});var ho=C(us);h(qa.$$.fragment,ho),Up=i(ho),Cr=g(ho,"P",{"data-svelte-h":!0}),T(Cr)!=="svelte-14tnsya"&&(Cr.textContent=Rg),ho.forEach(p),kp=i(U),Ke=g(U,"DIV",{class:!0});var Bn=C(Ke);h(Wa.$$.fragment,Bn),Ep=i(Bn),vr=g(Bn,"P",{"data-svelte-h":!0}),T(vr)!=="svelte-1mibg86"&&(vr.textContent=Fg),Zp=i(Bn),h(gs.$$.fragment,Bn),Bn.forEach(p),qp=i(U),en=g(U,"DIV",{class:!0});var Hn=C(en);h(Na.$$.fragment,Hn),Wp=i(Hn),Jr=g(Hn,"P",{"data-svelte-h":!0}),T(Jr)!=="svelte-1nuhgbh"&&(Jr.textContent=Pg),Np=i(Hn),h(ds.$$.fragment,Hn),Hn.forEach(p),Gp=i(U),nn=g(U,"DIV",{class:!0});var Sn=C(nn);h(Ga.$$.fragment,Sn),Vp=i(Sn),Ur=g(Sn,"P",{"data-svelte-h":!0}),T(Ur)!=="svelte-1uepm2o"&&(Ur.textContent=Xg),Ap=i(Sn),h(ms.$$.fragment,Sn),Sn.forEach(p),Yp=i(U),tn=g(U,"DIV",{class:!0});var Qn=C(tn);h(Va.$$.fragment,Qn),Dp=i(Qn),kr=g(Qn,"P",{"data-svelte-h":!0}),T(kr)!=="svelte-77a94i"&&(kr.textContent=Lg),Bp=i(Qn),h(hs.$$.fragment,Qn),Qn.forEach(p),Hp=i(U),sn=g(U,"DIV",{class:!0});var Rn=C(sn);h(Aa.$$.fragment,Rn),Sp=i(Rn),Er=g(Rn,"P",{"data-svelte-h":!0}),T(Er)!=="svelte-61sxmo"&&(Er.textContent=zg),Qp=i(Rn),h(fs.$$.fragment,Rn),Rn.forEach(p),Rp=i(U),an=g(U,"DIV",{class:!0});var Fn=C(an);h(Ya.$$.fragment,Fn),Fp=i(Fn),Zr=g(Fn,"P",{"data-svelte-h":!0}),T(Zr)!=="svelte-hzldyu"&&(Zr.textContent=Og),Pp=i(Fn),h(bs.$$.fragment,Fn),Fn.forEach(p),Xp=i(U),on=g(U,"DIV",{class:!0});var Pn=C(on);h(Da.$$.fragment,Pn),Lp=i(Pn),qr=g(Pn,"P",{"data-svelte-h":!0}),T(qr)!=="svelte-b4yzyj"&&(qr.textContent=Kg),zp=i(Pn),h(_s.$$.fragment,Pn),Pn.forEach(p),Op=i(U),Y=g(U,"DIV",{class:!0});var R=C(Y);h(Ba.$$.fragment,R),Kp=i(R),Wr=g(R,"P",{"data-svelte-h":!0}),T(Wr)!=="svelte-qakvx8"&&(Wr.textContent=ed),eu=i(R),Nr=g(R,"P",{"data-svelte-h":!0}),T(Nr)!=="svelte-1irx2op"&&(Nr.innerHTML=nd),nu=i(R),Gr=g(R,"P",{"data-svelte-h":!0}),T(Gr)!=="svelte-140zl9b"&&(Gr.innerHTML=td),tu=i(R),h(ys.$$.fragment,R),R.forEach(p),su=i(U),pe=g(U,"DIV",{class:!0});var we=C(pe);h(Ha.$$.fragment,we),au=i(we),Vr=g(we,"P",{"data-svelte-h":!0}),T(Vr)!=="svelte-9lmcnw"&&(Vr.textContent=sd),ou=i(we),h(xs.$$.fragment,we),ru=i(we),h(js.$$.fragment,we),we.forEach(p),lu=i(U),rn=g(U,"DIV",{class:!0});var Xn=C(rn);h(Sa.$$.fragment,Xn),iu=i(Xn),Ar=g(Xn,"P",{"data-svelte-h":!0}),T(Ar)!=="svelte-12mjzdy"&&(Ar.textContent=ad),cu=i(Xn),h(Ts.$$.fragment,Xn),Xn.forEach(p),pu=i(U),ln=g(U,"DIV",{class:!0});var Ln=C(ln);h(Qa.$$.fragment,Ln),uu=i(Ln),Yr=g(Ln,"P",{"data-svelte-h":!0}),T(Yr)!=="svelte-1araal"&&(Yr.textContent=od),gu=i(Ln),h($s.$$.fragment,Ln),Ln.forEach(p),du=i(U),D=g(U,"DIV",{class:!0});var F=C(D);h(Ra.$$.fragment,F),mu=i(F),Dr=g(F,"P",{"data-svelte-h":!0}),T(Dr)!=="svelte-1v3lqck"&&(Dr.textContent=rd),hu=i(F),Br=g(F,"P",{"data-svelte-h":!0}),T(Br)!=="svelte-19inetw"&&(Br.innerHTML=ld),fu=i(F),h(Is.$$.fragment,F),bu=i(F),h(Ms.$$.fragment,F),F.forEach(p),_u=i(U),cn=g(U,"DIV",{class:!0});var zn=C(cn);h(Fa.$$.fragment,zn),yu=i(zn),Hr=g(zn,"P",{"data-svelte-h":!0}),T(Hr)!=="svelte-1jbp6ey"&&(Hr.textContent=id),xu=i(zn),h(ws.$$.fragment,zn),zn.forEach(p),ju=i(U),pn=g(U,"DIV",{class:!0});var On=C(pn);h(Pa.$$.fragment,On),Tu=i(On),Sr=g(On,"P",{"data-svelte-h":!0}),T(Sr)!=="svelte-1c9xuqj"&&(Sr.textContent=cd),$u=i(On),h(Cs.$$.fragment,On),On.forEach(p),Iu=i(U),un=g(U,"DIV",{class:!0});var Kn=C(un);h(Xa.$$.fragment,Kn),Mu=i(Kn),Qr=g(Kn,"P",{"data-svelte-h":!0}),T(Qr)!=="svelte-108ipf8"&&(Qr.textContent=pd),wu=i(Kn),h(vs.$$.fragment,Kn),Kn.forEach(p),U.forEach(p),il=i(s),h(La.$$.fragment,s),cl=i(s),gn=g(s,"DIV",{class:!0});var fo=C(gn);h(za.$$.fragment,fo),Cu=i(fo),Rr=g(fo,"P",{"data-svelte-h":!0}),T(Rr)!=="svelte-2793d9"&&(Rr.textContent=ud),fo.forEach(p),pl=i(s),h(Oa.$$.fragment,s),ul=i(s),Ka=g(s,"P",{"data-svelte-h":!0}),T(Ka)!=="svelte-ibwsmj"&&(Ka.textContent=gd),gl=i(s),h(eo.$$.fragment,s),dl=i(s),dn=g(s,"DIV",{class:!0});var bo=C(dn);h(no.$$.fragment,bo),vu=i(bo),Fr=g(bo,"P",{"data-svelte-h":!0}),T(Fr)!=="svelte-16sxdnb"&&(Fr.innerHTML=dd),bo.forEach(p),ml=i(s),h(to.$$.fragment,s),hl=i(s),mn=g(s,"DIV",{class:!0});var _o=C(mn);h(so.$$.fragment,_o),Ju=i(_o),Pr=g(_o,"P",{"data-svelte-h":!0}),T(Pr)!=="svelte-1dasynn"&&(Pr.innerHTML=md),_o.forEach(p),fl=i(s),h(ao.$$.fragment,s),bl=i(s),hn=g(s,"DIV",{class:!0});var yo=C(hn);h(oo.$$.fragment,yo),Uu=i(yo),Xr=g(yo,"P",{"data-svelte-h":!0}),T(Xr)!=="svelte-18ffdgx"&&(Xr.textContent=hd),yo.forEach(p),_l=i(s),h(ro.$$.fragment,s),yl=i(s),lo=g(s,"P",{"data-svelte-h":!0}),T(lo)!=="svelte-vlt846"&&(lo.innerHTML=fd),xl=i(s),W=g(s,"DIV",{class:!0});var P=C(W);h(io.$$.fragment,P),ku=i(P),Lr=g(P,"P",{"data-svelte-h":!0}),T(Lr)!=="svelte-xkrgz1"&&(Lr.textContent=bd),Eu=i(P),h(Js.$$.fragment,P),Zu=i(P),Us=g(P,"DIV",{class:!0});var xo=C(Us);h(co.$$.fragment,xo),qu=i(xo),zr=g(xo,"P",{"data-svelte-h":!0}),T(zr)!=="svelte-1ruvvxs"&&(zr.textContent=_d),xo.forEach(p),Wu=i(P),ks=g(P,"DIV",{class:!0});var jo=C(ks);h(po.$$.fragment,jo),Nu=i(jo),Or=g(jo,"P",{"data-svelte-h":!0}),T(Or)!=="svelte-ss15d2"&&(Or.textContent=yd),jo.forEach(p),P.forEach(p),jl=i(s),Kr=g(s,"P",{}),C(Kr).forEach(p),this.h()},h(){v(n,"name","hf:doc:metadata"),v(n,"content",sh),v(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(es,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,x){o(document.head,n),j(s,d,x),j(s,a,x),j(s,t,x),f(r,s,x),j(s,e,x),j(s,c,x),j(s,el,x),j(s,Es,x),j(s,nl,x),j(s,Zs,x),j(s,tl,x),f(qs,s,x),j(s,sl,x),j(s,M,x),f(Ws,M,null),o(M,$l),o(M,To),o(M,Il),o(M,$o),o(M,Ml),o(M,Ce),f(Ns,Ce,null),o(Ce,wl),o(Ce,Io),o(Ce,Cl),f(nt,Ce,null),o(M,vl),o(M,ve),f(Gs,ve,null),o(ve,Jl),o(ve,Mo),o(ve,Ul),f(tt,ve,null),o(M,kl),o(M,Je),f(Vs,Je,null),o(Je,El),o(Je,wo),o(Je,Zl),f(st,Je,null),o(M,ql),o(M,X),f(As,X,null),o(X,Wl),o(X,Co),o(X,Nl),f(at,X,null),o(X,Gl),f(ot,X,null),o(M,Vl),o(M,L),f(Ys,L,null),o(L,Al),o(L,vo),o(L,Yl),f(rt,L,null),o(L,Dl),f(lt,L,null),o(M,Bl),o(M,Ue),f(Ds,Ue,null),o(Ue,Hl),o(Ue,Jo),o(Ue,Sl),f(it,Ue,null),o(M,Ql),o(M,ke),f(Bs,ke,null),o(ke,Rl),o(ke,Uo),o(ke,Fl),f(ct,ke,null),o(M,Pl),o(M,Ee),f(Hs,Ee,null),o(Ee,Xl),o(Ee,ko),o(Ee,Ll),f(pt,Ee,null),o(M,zl),o(M,z),f(Ss,z,null),o(z,Ol),o(z,Eo),o(z,Kl),f(ut,z,null),o(z,ei),f(gt,z,null),o(M,ni),o(M,dt),f(Qs,dt,null),o(dt,ti),o(dt,Zo),o(M,si),o(M,Ze),f(Rs,Ze,null),o(Ze,ai),o(Ze,qo),o(Ze,oi),f(mt,Ze,null),o(M,ri),o(M,O),f(Fs,O,null),o(O,li),o(O,Wo),o(O,ii),f(ht,O,null),o(O,ci),f(ft,O,null),o(M,pi),o(M,K),f(Ps,K,null),o(K,ui),o(K,No),o(K,gi),f(bt,K,null),o(K,di),f(_t,K,null),o(M,mi),o(M,ee),f(Xs,ee,null),o(ee,hi),o(ee,Go),o(ee,fi),o(ee,Vo),o(ee,bi),f(yt,ee,null),o(M,_i),o(M,N),f(Ls,N,null),o(N,yi),o(N,Ao),o(N,xi),o(N,Yo),o(N,ji),f(xt,N,null),o(N,Ti),f(jt,N,null),o(M,$i),o(M,ne),f(zs,ne,null),o(ne,Ii),o(ne,Do),o(ne,Mi),f(Tt,ne,null),o(ne,wi),f($t,ne,null),o(M,Ci),o(M,It),f(Os,It,null),o(It,vi),o(It,Bo),o(M,Ji),o(M,qe),f(Ks,qe,null),o(qe,Ui),o(qe,Ho),o(qe,ki),f(Mt,qe,null),o(M,Ei),o(M,We),f(ea,We,null),o(We,Zi),o(We,So),o(We,qi),f(wt,We,null),o(M,Wi),o(M,Ne),f(na,Ne,null),o(Ne,Ni),o(Ne,Qo),o(Ne,Gi),f(Ct,Ne,null),o(M,Vi),o(M,Ge),f(ta,Ge,null),o(Ge,Ai),o(Ge,Ro),o(Ge,Yi),f(vt,Ge,null),o(M,Di),o(M,Ve),f(sa,Ve,null),o(Ve,Bi),o(Ve,Fo),o(Ve,Hi),f(Jt,Ve,null),o(M,Si),o(M,Ae),f(aa,Ae,null),o(Ae,Qi),o(Ae,Po),o(Ae,Ri),f(Ut,Ae,null),o(M,Fi),o(M,Ye),f(oa,Ye,null),o(Ye,Pi),o(Ye,Xo),o(Ye,Xi),f(kt,Ye,null),o(M,Li),o(M,G),f(ra,G,null),o(G,zi),o(G,Lo),o(G,Oi),o(G,zo),o(G,Ki),o(G,Oo),o(G,ec),f(Et,G,null),o(M,nc),o(M,te),f(la,te,null),o(te,tc),o(te,Ko),o(te,sc),f(Zt,te,null),o(te,ac),f(qt,te,null),o(M,oc),o(M,De),f(ia,De,null),o(De,rc),o(De,er),o(De,lc),f(Wt,De,null),o(M,ic),o(M,Be),f(ca,Be,null),o(Be,cc),o(Be,nr),o(Be,pc),f(Nt,Be,null),o(M,uc),o(M,V),f(pa,V,null),o(V,gc),o(V,tr),o(V,dc),o(V,sr),o(V,mc),f(Gt,V,null),o(V,hc),f(Vt,V,null),o(M,fc),o(M,He),f(ua,He,null),o(He,bc),o(He,ar),o(He,_c),f(At,He,null),o(M,yc),o(M,Se),f(ga,Se,null),o(Se,xc),o(Se,or),o(Se,jc),f(Yt,Se,null),o(M,Tc),o(M,Qe),f(da,Qe,null),o(Qe,$c),o(Qe,rr),o(Qe,Ic),f(Dt,Qe,null),j(s,al,x),f(ma,s,x),j(s,ol,x),j(s,ha,x),j(s,rl,x),f(fa,s,x),j(s,ll,x),j(s,w,x),f(ba,w,null),o(w,Mc),o(w,lr),o(w,wc),o(w,ir),o(w,Cc),o(w,Re),f(_a,Re,null),o(Re,vc),o(Re,cr),o(Re,Jc),f(Bt,Re,null),o(w,Uc),o(w,Fe),f(ya,Fe,null),o(Fe,kc),o(Fe,pr),o(Fe,Ec),f(Ht,Fe,null),o(w,Zc),o(w,Pe),f(xa,Pe,null),o(Pe,qc),o(Pe,ur),o(Pe,Wc),f(St,Pe,null),o(w,Nc),o(w,se),f(ja,se,null),o(se,Gc),o(se,gr),o(se,Vc),f(Qt,se,null),o(se,Ac),f(Rt,se,null),o(w,Yc),o(w,ae),f(Ta,ae,null),o(ae,Dc),o(ae,dr),o(ae,Bc),f(Ft,ae,null),o(ae,Hc),f(Pt,ae,null),o(w,Sc),o(w,Xe),f($a,Xe,null),o(Xe,Qc),o(Xe,mr),o(Xe,Rc),f(Xt,Xe,null),o(w,Fc),o(w,Le),f(Ia,Le,null),o(Le,Pc),o(Le,hr),o(Le,Xc),f(Lt,Le,null),o(w,Lc),o(w,ze),f(Ma,ze,null),o(ze,zc),o(ze,fr),o(ze,Oc),f(zt,ze,null),o(w,Kc),o(w,oe),f(wa,oe,null),o(oe,ep),o(oe,br),o(oe,np),f(Ot,oe,null),o(oe,tp),f(Kt,oe,null),o(w,sp),o(w,es),f(Ca,es,null),o(es,ap),o(es,_r),o(w,op),o(w,Oe),f(va,Oe,null),o(Oe,rp),o(Oe,yr),o(Oe,lp),f(ns,Oe,null),o(w,ip),o(w,re),f(Ja,re,null),o(re,cp),o(re,xr),o(re,pp),f(ts,re,null),o(re,up),f(ss,re,null),o(w,gp),o(w,le),f(Ua,le,null),o(le,dp),o(le,jr),o(le,mp),f(as,le,null),o(le,hp),f(os,le,null),o(w,fp),o(w,ie),f(ka,ie,null),o(ie,bp),o(ie,Tr),o(ie,_p),o(ie,$r),o(ie,yp),f(rs,ie,null),o(w,xp),o(w,A),f(Ea,A,null),o(A,jp),o(A,Ir),o(A,Tp),o(A,Mr),o(A,$p),f(ls,A,null),o(A,Ip),f(is,A,null),o(w,Mp),o(w,ce),f(Za,ce,null),o(ce,wp),o(ce,wr),o(ce,Cp),f(cs,ce,null),o(ce,vp),f(ps,ce,null),o(w,Jp),o(w,us),f(qa,us,null),o(us,Up),o(us,Cr),o(w,kp),o(w,Ke),f(Wa,Ke,null),o(Ke,Ep),o(Ke,vr),o(Ke,Zp),f(gs,Ke,null),o(w,qp),o(w,en),f(Na,en,null),o(en,Wp),o(en,Jr),o(en,Np),f(ds,en,null),o(w,Gp),o(w,nn),f(Ga,nn,null),o(nn,Vp),o(nn,Ur),o(nn,Ap),f(ms,nn,null),o(w,Yp),o(w,tn),f(Va,tn,null),o(tn,Dp),o(tn,kr),o(tn,Bp),f(hs,tn,null),o(w,Hp),o(w,sn),f(Aa,sn,null),o(sn,Sp),o(sn,Er),o(sn,Qp),f(fs,sn,null),o(w,Rp),o(w,an),f(Ya,an,null),o(an,Fp),o(an,Zr),o(an,Pp),f(bs,an,null),o(w,Xp),o(w,on),f(Da,on,null),o(on,Lp),o(on,qr),o(on,zp),f(_s,on,null),o(w,Op),o(w,Y),f(Ba,Y,null),o(Y,Kp),o(Y,Wr),o(Y,eu),o(Y,Nr),o(Y,nu),o(Y,Gr),o(Y,tu),f(ys,Y,null),o(w,su),o(w,pe),f(Ha,pe,null),o(pe,au),o(pe,Vr),o(pe,ou),f(xs,pe,null),o(pe,ru),f(js,pe,null),o(w,lu),o(w,rn),f(Sa,rn,null),o(rn,iu),o(rn,Ar),o(rn,cu),f(Ts,rn,null),o(w,pu),o(w,ln),f(Qa,ln,null),o(ln,uu),o(ln,Yr),o(ln,gu),f($s,ln,null),o(w,du),o(w,D),f(Ra,D,null),o(D,mu),o(D,Dr),o(D,hu),o(D,Br),o(D,fu),f(Is,D,null),o(D,bu),f(Ms,D,null),o(w,_u),o(w,cn),f(Fa,cn,null),o(cn,yu),o(cn,Hr),o(cn,xu),f(ws,cn,null),o(w,ju),o(w,pn),f(Pa,pn,null),o(pn,Tu),o(pn,Sr),o(pn,$u),f(Cs,pn,null),o(w,Iu),o(w,un),f(Xa,un,null),o(un,Mu),o(un,Qr),o(un,wu),f(vs,un,null),j(s,il,x),f(La,s,x),j(s,cl,x),j(s,gn,x),f(za,gn,null),o(gn,Cu),o(gn,Rr),j(s,pl,x),f(Oa,s,x),j(s,ul,x),j(s,Ka,x),j(s,gl,x),f(eo,s,x),j(s,dl,x),j(s,dn,x),f(no,dn,null),o(dn,vu),o(dn,Fr),j(s,ml,x),f(to,s,x),j(s,hl,x),j(s,mn,x),f(so,mn,null),o(mn,Ju),o(mn,Pr),j(s,fl,x),f(ao,s,x),j(s,bl,x),j(s,hn,x),f(oo,hn,null),o(hn,Uu),o(hn,Xr),j(s,_l,x),f(ro,s,x),j(s,yl,x),j(s,lo,x),j(s,xl,x),j(s,W,x),f(io,W,null),o(W,ku),o(W,Lr),o(W,Eu),f(Js,W,null),o(W,Zu),o(W,Us),f(co,Us,null),o(Us,qu),o(Us,zr),o(W,Wu),o(W,ks),f(po,ks,null),o(ks,Nu),o(ks,Or),j(s,jl,x),j(s,Kr,x),Tl=!0},p(s,[x]){const J={};x&2&&(J.$$scope={dirty:x,ctx:s}),nt.$set(J);const fn={};x&2&&(fn.$$scope={dirty:x,ctx:s}),tt.$set(fn);const bn={};x&2&&(bn.$$scope={dirty:x,ctx:s}),st.$set(bn);const _n={};x&2&&(_n.$$scope={dirty:x,ctx:s}),at.$set(_n);const ue={};x&2&&(ue.$$scope={dirty:x,ctx:s}),ot.$set(ue);const ge={};x&2&&(ge.$$scope={dirty:x,ctx:s}),rt.$set(ge);const yn={};x&2&&(yn.$$scope={dirty:x,ctx:s}),lt.$set(yn);const xn={};x&2&&(xn.$$scope={dirty:x,ctx:s}),it.$set(xn);const jn={};x&2&&(jn.$$scope={dirty:x,ctx:s}),ct.$set(jn);const de={};x&2&&(de.$$scope={dirty:x,ctx:s}),pt.$set(de);const uo={};x&2&&(uo.$$scope={dirty:x,ctx:s}),ut.$set(uo);const Tn={};x&2&&(Tn.$$scope={dirty:x,ctx:s}),gt.$set(Tn);const me={};x&2&&(me.$$scope={dirty:x,ctx:s}),mt.$set(me);const he={};x&2&&(he.$$scope={dirty:x,ctx:s}),ht.$set(he);const fe={};x&2&&(fe.$$scope={dirty:x,ctx:s}),ft.$set(fe);const B={};x&2&&(B.$$scope={dirty:x,ctx:s}),bt.$set(B);const be={};x&2&&(be.$$scope={dirty:x,ctx:s}),_t.$set(be);const go={};x&2&&(go.$$scope={dirty:x,ctx:s}),yt.$set(go);const $n={};x&2&&($n.$$scope={dirty:x,ctx:s}),xt.$set($n);const In={};x&2&&(In.$$scope={dirty:x,ctx:s}),jt.$set(In);const Mn={};x&2&&(Mn.$$scope={dirty:x,ctx:s}),Tt.$set(Mn);const wn={};x&2&&(wn.$$scope={dirty:x,ctx:s}),$t.$set(wn);const Cn={};x&2&&(Cn.$$scope={dirty:x,ctx:s}),Mt.$set(Cn);const vn={};x&2&&(vn.$$scope={dirty:x,ctx:s}),wt.$set(vn);const Jn={};x&2&&(Jn.$$scope={dirty:x,ctx:s}),Ct.$set(Jn);const H={};x&2&&(H.$$scope={dirty:x,ctx:s}),vt.$set(H);const _e={};x&2&&(_e.$$scope={dirty:x,ctx:s}),Jt.$set(_e);const Un={};x&2&&(Un.$$scope={dirty:x,ctx:s}),Ut.$set(Un);const kn={};x&2&&(kn.$$scope={dirty:x,ctx:s}),kt.$set(kn);const S={};x&2&&(S.$$scope={dirty:x,ctx:s}),Et.$set(S);const En={};x&2&&(En.$$scope={dirty:x,ctx:s}),Zt.$set(En);const Zn={};x&2&&(Zn.$$scope={dirty:x,ctx:s}),qt.$set(Zn);const qn={};x&2&&(qn.$$scope={dirty:x,ctx:s}),Wt.$set(qn);const U={};x&2&&(U.$$scope={dirty:x,ctx:s}),Nt.$set(U);const Wn={};x&2&&(Wn.$$scope={dirty:x,ctx:s}),Gt.$set(Wn);const Nn={};x&2&&(Nn.$$scope={dirty:x,ctx:s}),Vt.$set(Nn);const Gn={};x&2&&(Gn.$$scope={dirty:x,ctx:s}),At.$set(Gn);const ye={};x&2&&(ye.$$scope={dirty:x,ctx:s}),Yt.$set(ye);const xe={};x&2&&(xe.$$scope={dirty:x,ctx:s}),Dt.$set(xe);const Vn={};x&2&&(Vn.$$scope={dirty:x,ctx:s}),Bt.$set(Vn);const An={};x&2&&(An.$$scope={dirty:x,ctx:s}),Ht.$set(An);const Yn={};x&2&&(Yn.$$scope={dirty:x,ctx:s}),St.$set(Yn);const je={};x&2&&(je.$$scope={dirty:x,ctx:s}),Qt.$set(je);const mo={};x&2&&(mo.$$scope={dirty:x,ctx:s}),Rt.$set(mo);const Dn={};x&2&&(Dn.$$scope={dirty:x,ctx:s}),Ft.$set(Dn);const Te={};x&2&&(Te.$$scope={dirty:x,ctx:s}),Pt.$set(Te);const $e={};x&2&&($e.$$scope={dirty:x,ctx:s}),Xt.$set($e);const Ie={};x&2&&(Ie.$$scope={dirty:x,ctx:s}),Lt.$set(Ie);const Q={};x&2&&(Q.$$scope={dirty:x,ctx:s}),zt.$set(Q);const Me={};x&2&&(Me.$$scope={dirty:x,ctx:s}),Ot.$set(Me);const ho={};x&2&&(ho.$$scope={dirty:x,ctx:s}),Kt.$set(ho);const Bn={};x&2&&(Bn.$$scope={dirty:x,ctx:s}),ns.$set(Bn);const Hn={};x&2&&(Hn.$$scope={dirty:x,ctx:s}),ts.$set(Hn);const Sn={};x&2&&(Sn.$$scope={dirty:x,ctx:s}),ss.$set(Sn);const Qn={};x&2&&(Qn.$$scope={dirty:x,ctx:s}),as.$set(Qn);const Rn={};x&2&&(Rn.$$scope={dirty:x,ctx:s}),os.$set(Rn);const Fn={};x&2&&(Fn.$$scope={dirty:x,ctx:s}),rs.$set(Fn);const Pn={};x&2&&(Pn.$$scope={dirty:x,ctx:s}),ls.$set(Pn);const R={};x&2&&(R.$$scope={dirty:x,ctx:s}),is.$set(R);const we={};x&2&&(we.$$scope={dirty:x,ctx:s}),cs.$set(we);const Xn={};x&2&&(Xn.$$scope={dirty:x,ctx:s}),ps.$set(Xn);const Ln={};x&2&&(Ln.$$scope={dirty:x,ctx:s}),gs.$set(Ln);const F={};x&2&&(F.$$scope={dirty:x,ctx:s}),ds.$set(F);const zn={};x&2&&(zn.$$scope={dirty:x,ctx:s}),ms.$set(zn);const On={};x&2&&(On.$$scope={dirty:x,ctx:s}),hs.$set(On);const Kn={};x&2&&(Kn.$$scope={dirty:x,ctx:s}),fs.$set(Kn);const fo={};x&2&&(fo.$$scope={dirty:x,ctx:s}),bs.$set(fo);const bo={};x&2&&(bo.$$scope={dirty:x,ctx:s}),_s.$set(bo);const _o={};x&2&&(_o.$$scope={dirty:x,ctx:s}),ys.$set(_o);const yo={};x&2&&(yo.$$scope={dirty:x,ctx:s}),xs.$set(yo);const P={};x&2&&(P.$$scope={dirty:x,ctx:s}),js.$set(P);const xo={};x&2&&(xo.$$scope={dirty:x,ctx:s}),Ts.$set(xo);const jo={};x&2&&(jo.$$scope={dirty:x,ctx:s}),$s.$set(jo);const xd={};x&2&&(xd.$$scope={dirty:x,ctx:s}),Is.$set(xd);const jd={};x&2&&(jd.$$scope={dirty:x,ctx:s}),Ms.$set(jd);const Td={};x&2&&(Td.$$scope={dirty:x,ctx:s}),ws.$set(Td);const $d={};x&2&&($d.$$scope={dirty:x,ctx:s}),Cs.$set($d);const Id={};x&2&&(Id.$$scope={dirty:x,ctx:s}),vs.$set(Id);const Md={};x&2&&(Md.$$scope={dirty:x,ctx:s}),Js.$set(Md)},i(s){Tl||(b(r.$$.fragment,s),b(qs.$$.fragment,s),b(Ws.$$.fragment,s),b(Ns.$$.fragment,s),b(nt.$$.fragment,s),b(Gs.$$.fragment,s),b(tt.$$.fragment,s),b(Vs.$$.fragment,s),b(st.$$.fragment,s),b(As.$$.fragment,s),b(at.$$.fragment,s),b(ot.$$.fragment,s),b(Ys.$$.fragment,s),b(rt.$$.fragment,s),b(lt.$$.fragment,s),b(Ds.$$.fragment,s),b(it.$$.fragment,s),b(Bs.$$.fragment,s),b(ct.$$.fragment,s),b(Hs.$$.fragment,s),b(pt.$$.fragment,s),b(Ss.$$.fragment,s),b(ut.$$.fragment,s),b(gt.$$.fragment,s),b(Qs.$$.fragment,s),b(Rs.$$.fragment,s),b(mt.$$.fragment,s),b(Fs.$$.fragment,s),b(ht.$$.fragment,s),b(ft.$$.fragment,s),b(Ps.$$.fragment,s),b(bt.$$.fragment,s),b(_t.$$.fragment,s),b(Xs.$$.fragment,s),b(yt.$$.fragment,s),b(Ls.$$.fragment,s),b(xt.$$.fragment,s),b(jt.$$.fragment,s),b(zs.$$.fragment,s),b(Tt.$$.fragment,s),b($t.$$.fragment,s),b(Os.$$.fragment,s),b(Ks.$$.fragment,s),b(Mt.$$.fragment,s),b(ea.$$.fragment,s),b(wt.$$.fragment,s),b(na.$$.fragment,s),b(Ct.$$.fragment,s),b(ta.$$.fragment,s),b(vt.$$.fragment,s),b(sa.$$.fragment,s),b(Jt.$$.fragment,s),b(aa.$$.fragment,s),b(Ut.$$.fragment,s),b(oa.$$.fragment,s),b(kt.$$.fragment,s),b(ra.$$.fragment,s),b(Et.$$.fragment,s),b(la.$$.fragment,s),b(Zt.$$.fragment,s),b(qt.$$.fragment,s),b(ia.$$.fragment,s),b(Wt.$$.fragment,s),b(ca.$$.fragment,s),b(Nt.$$.fragment,s),b(pa.$$.fragment,s),b(Gt.$$.fragment,s),b(Vt.$$.fragment,s),b(ua.$$.fragment,s),b(At.$$.fragment,s),b(ga.$$.fragment,s),b(Yt.$$.fragment,s),b(da.$$.fragment,s),b(Dt.$$.fragment,s),b(ma.$$.fragment,s),b(fa.$$.fragment,s),b(ba.$$.fragment,s),b(_a.$$.fragment,s),b(Bt.$$.fragment,s),b(ya.$$.fragment,s),b(Ht.$$.fragment,s),b(xa.$$.fragment,s),b(St.$$.fragment,s),b(ja.$$.fragment,s),b(Qt.$$.fragment,s),b(Rt.$$.fragment,s),b(Ta.$$.fragment,s),b(Ft.$$.fragment,s),b(Pt.$$.fragment,s),b($a.$$.fragment,s),b(Xt.$$.fragment,s),b(Ia.$$.fragment,s),b(Lt.$$.fragment,s),b(Ma.$$.fragment,s),b(zt.$$.fragment,s),b(wa.$$.fragment,s),b(Ot.$$.fragment,s),b(Kt.$$.fragment,s),b(Ca.$$.fragment,s),b(va.$$.fragment,s),b(ns.$$.fragment,s),b(Ja.$$.fragment,s),b(ts.$$.fragment,s),b(ss.$$.fragment,s),b(Ua.$$.fragment,s),b(as.$$.fragment,s),b(os.$$.fragment,s),b(ka.$$.fragment,s),b(rs.$$.fragment,s),b(Ea.$$.fragment,s),b(ls.$$.fragment,s),b(is.$$.fragment,s),b(Za.$$.fragment,s),b(cs.$$.fragment,s),b(ps.$$.fragment,s),b(qa.$$.fragment,s),b(Wa.$$.fragment,s),b(gs.$$.fragment,s),b(Na.$$.fragment,s),b(ds.$$.fragment,s),b(Ga.$$.fragment,s),b(ms.$$.fragment,s),b(Va.$$.fragment,s),b(hs.$$.fragment,s),b(Aa.$$.fragment,s),b(fs.$$.fragment,s),b(Ya.$$.fragment,s),b(bs.$$.fragment,s),b(Da.$$.fragment,s),b(_s.$$.fragment,s),b(Ba.$$.fragment,s),b(ys.$$.fragment,s),b(Ha.$$.fragment,s),b(xs.$$.fragment,s),b(js.$$.fragment,s),b(Sa.$$.fragment,s),b(Ts.$$.fragment,s),b(Qa.$$.fragment,s),b($s.$$.fragment,s),b(Ra.$$.fragment,s),b(Is.$$.fragment,s),b(Ms.$$.fragment,s),b(Fa.$$.fragment,s),b(ws.$$.fragment,s),b(Pa.$$.fragment,s),b(Cs.$$.fragment,s),b(Xa.$$.fragment,s),b(vs.$$.fragment,s),b(La.$$.fragment,s),b(za.$$.fragment,s),b(Oa.$$.fragment,s),b(eo.$$.fragment,s),b(no.$$.fragment,s),b(to.$$.fragment,s),b(so.$$.fragment,s),b(ao.$$.fragment,s),b(oo.$$.fragment,s),b(ro.$$.fragment,s),b(io.$$.fragment,s),b(Js.$$.fragment,s),b(co.$$.fragment,s),b(po.$$.fragment,s),Tl=!0)},o(s){_(r.$$.fragment,s),_(qs.$$.fragment,s),_(Ws.$$.fragment,s),_(Ns.$$.fragment,s),_(nt.$$.fragment,s),_(Gs.$$.fragment,s),_(tt.$$.fragment,s),_(Vs.$$.fragment,s),_(st.$$.fragment,s),_(As.$$.fragment,s),_(at.$$.fragment,s),_(ot.$$.fragment,s),_(Ys.$$.fragment,s),_(rt.$$.fragment,s),_(lt.$$.fragment,s),_(Ds.$$.fragment,s),_(it.$$.fragment,s),_(Bs.$$.fragment,s),_(ct.$$.fragment,s),_(Hs.$$.fragment,s),_(pt.$$.fragment,s),_(Ss.$$.fragment,s),_(ut.$$.fragment,s),_(gt.$$.fragment,s),_(Qs.$$.fragment,s),_(Rs.$$.fragment,s),_(mt.$$.fragment,s),_(Fs.$$.fragment,s),_(ht.$$.fragment,s),_(ft.$$.fragment,s),_(Ps.$$.fragment,s),_(bt.$$.fragment,s),_(_t.$$.fragment,s),_(Xs.$$.fragment,s),_(yt.$$.fragment,s),_(Ls.$$.fragment,s),_(xt.$$.fragment,s),_(jt.$$.fragment,s),_(zs.$$.fragment,s),_(Tt.$$.fragment,s),_($t.$$.fragment,s),_(Os.$$.fragment,s),_(Ks.$$.fragment,s),_(Mt.$$.fragment,s),_(ea.$$.fragment,s),_(wt.$$.fragment,s),_(na.$$.fragment,s),_(Ct.$$.fragment,s),_(ta.$$.fragment,s),_(vt.$$.fragment,s),_(sa.$$.fragment,s),_(Jt.$$.fragment,s),_(aa.$$.fragment,s),_(Ut.$$.fragment,s),_(oa.$$.fragment,s),_(kt.$$.fragment,s),_(ra.$$.fragment,s),_(Et.$$.fragment,s),_(la.$$.fragment,s),_(Zt.$$.fragment,s),_(qt.$$.fragment,s),_(ia.$$.fragment,s),_(Wt.$$.fragment,s),_(ca.$$.fragment,s),_(Nt.$$.fragment,s),_(pa.$$.fragment,s),_(Gt.$$.fragment,s),_(Vt.$$.fragment,s),_(ua.$$.fragment,s),_(At.$$.fragment,s),_(ga.$$.fragment,s),_(Yt.$$.fragment,s),_(da.$$.fragment,s),_(Dt.$$.fragment,s),_(ma.$$.fragment,s),_(fa.$$.fragment,s),_(ba.$$.fragment,s),_(_a.$$.fragment,s),_(Bt.$$.fragment,s),_(ya.$$.fragment,s),_(Ht.$$.fragment,s),_(xa.$$.fragment,s),_(St.$$.fragment,s),_(ja.$$.fragment,s),_(Qt.$$.fragment,s),_(Rt.$$.fragment,s),_(Ta.$$.fragment,s),_(Ft.$$.fragment,s),_(Pt.$$.fragment,s),_($a.$$.fragment,s),_(Xt.$$.fragment,s),_(Ia.$$.fragment,s),_(Lt.$$.fragment,s),_(Ma.$$.fragment,s),_(zt.$$.fragment,s),_(wa.$$.fragment,s),_(Ot.$$.fragment,s),_(Kt.$$.fragment,s),_(Ca.$$.fragment,s),_(va.$$.fragment,s),_(ns.$$.fragment,s),_(Ja.$$.fragment,s),_(ts.$$.fragment,s),_(ss.$$.fragment,s),_(Ua.$$.fragment,s),_(as.$$.fragment,s),_(os.$$.fragment,s),_(ka.$$.fragment,s),_(rs.$$.fragment,s),_(Ea.$$.fragment,s),_(ls.$$.fragment,s),_(is.$$.fragment,s),_(Za.$$.fragment,s),_(cs.$$.fragment,s),_(ps.$$.fragment,s),_(qa.$$.fragment,s),_(Wa.$$.fragment,s),_(gs.$$.fragment,s),_(Na.$$.fragment,s),_(ds.$$.fragment,s),_(Ga.$$.fragment,s),_(ms.$$.fragment,s),_(Va.$$.fragment,s),_(hs.$$.fragment,s),_(Aa.$$.fragment,s),_(fs.$$.fragment,s),_(Ya.$$.fragment,s),_(bs.$$.fragment,s),_(Da.$$.fragment,s),_(_s.$$.fragment,s),_(Ba.$$.fragment,s),_(ys.$$.fragment,s),_(Ha.$$.fragment,s),_(xs.$$.fragment,s),_(js.$$.fragment,s),_(Sa.$$.fragment,s),_(Ts.$$.fragment,s),_(Qa.$$.fragment,s),_($s.$$.fragment,s),_(Ra.$$.fragment,s),_(Is.$$.fragment,s),_(Ms.$$.fragment,s),_(Fa.$$.fragment,s),_(ws.$$.fragment,s),_(Pa.$$.fragment,s),_(Cs.$$.fragment,s),_(Xa.$$.fragment,s),_(vs.$$.fragment,s),_(La.$$.fragment,s),_(za.$$.fragment,s),_(Oa.$$.fragment,s),_(eo.$$.fragment,s),_(no.$$.fragment,s),_(to.$$.fragment,s),_(so.$$.fragment,s),_(ao.$$.fragment,s),_(oo.$$.fragment,s),_(ro.$$.fragment,s),_(io.$$.fragment,s),_(Js.$$.fragment,s),_(co.$$.fragment,s),_(po.$$.fragment,s),Tl=!1},d(s){s&&(p(d),p(a),p(t),p(e),p(c),p(el),p(Es),p(nl),p(Zs),p(tl),p(sl),p(M),p(al),p(ol),p(ha),p(rl),p(ll),p(w),p(il),p(cl),p(gn),p(pl),p(ul),p(Ka),p(gl),p(dl),p(dn),p(ml),p(hl),p(mn),p(fl),p(bl),p(hn),p(_l),p(yl),p(lo),p(xl),p(W),p(jl),p(Kr)),p(n),y(r,s),y(qs,s),y(Ws),y(Ns),y(nt),y(Gs),y(tt),y(Vs),y(st),y(As),y(at),y(ot),y(Ys),y(rt),y(lt),y(Ds),y(it),y(Bs),y(ct),y(Hs),y(pt),y(Ss),y(ut),y(gt),y(Qs),y(Rs),y(mt),y(Fs),y(ht),y(ft),y(Ps),y(bt),y(_t),y(Xs),y(yt),y(Ls),y(xt),y(jt),y(zs),y(Tt),y($t),y(Os),y(Ks),y(Mt),y(ea),y(wt),y(na),y(Ct),y(ta),y(vt),y(sa),y(Jt),y(aa),y(Ut),y(oa),y(kt),y(ra),y(Et),y(la),y(Zt),y(qt),y(ia),y(Wt),y(ca),y(Nt),y(pa),y(Gt),y(Vt),y(ua),y(At),y(ga),y(Yt),y(da),y(Dt),y(ma,s),y(fa,s),y(ba),y(_a),y(Bt),y(ya),y(Ht),y(xa),y(St),y(ja),y(Qt),y(Rt),y(Ta),y(Ft),y(Pt),y($a),y(Xt),y(Ia),y(Lt),y(Ma),y(zt),y(wa),y(Ot),y(Kt),y(Ca),y(va),y(ns),y(Ja),y(ts),y(ss),y(Ua),y(as),y(os),y(ka),y(rs),y(Ea),y(ls),y(is),y(Za),y(cs),y(ps),y(qa),y(Wa),y(gs),y(Na),y(ds),y(Ga),y(ms),y(Va),y(hs),y(Aa),y(fs),y(Ya),y(bs),y(Da),y(_s),y(Ba),y(ys),y(Ha),y(xs),y(js),y(Sa),y(Ts),y(Qa),y($s),y(Ra),y(Is),y(Ms),y(Fa),y(ws),y(Pa),y(Cs),y(Xa),y(vs),y(La,s),y(za),y(Oa,s),y(eo,s),y(no),y(to,s),y(so),y(ao,s),y(oo),y(ro,s),y(io),y(Js),y(co),y(po)}}}const sh='{"title":"Inference","local":"inference","sections":[{"title":"Inference Client","local":"huggingface_hub.InferenceClient","sections":[],"depth":2},{"title":"Async Inference Client","local":"huggingface_hub.AsyncInferenceClient","sections":[],"depth":2},{"title":"InferenceTimeoutError","local":"huggingface_hub.InferenceTimeoutError","sections":[],"depth":2},{"title":"Return types","local":"return-types","sections":[{"title":"ConversationalOutputConversation","local":"huggingface_hub.inference._types.ConversationalOutputConversation","sections":[],"depth":3},{"title":"ConversationalOutput","local":"huggingface_hub.inference._types.ConversationalOutput","sections":[],"depth":3},{"title":"ModelStatus","local":"huggingface_hub.inference._common.ModelStatus","sections":[],"depth":3}],"depth":2},{"title":"InferenceAPI","local":"huggingface_hub.InferenceApi","sections":[],"depth":2}],"depth":1}';function ah($){return Cd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gh extends vd{constructor(n){super(),Jd(this,n,ah,th,wd,{})}}export{gh as component};
