import{s as zt,o as Yt,n as Ht}from"../chunks/scheduler.c57aa7ef.js";import{S as At,i as qt,g as f,s,r as i,A as xt,h,f as a,c as n,j as Qt,u as o,x as c,k as Xt,y as Et,a as l,v as r,d as p,t as d,w as m}from"../chunks/index.c50cb18e.js";import{T as Ft}from"../chunks/Tip.9268b0ca.js";import{C as y}from"../chunks/CodeBlock.34f0a53d.js";import{H as T}from"../chunks/Heading.c7d7e0e7.js";function Nt(we){let u,M='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){u=f("p"),u.innerHTML=M},l(w){u=h(w,"P",{"data-svelte-h":!0}),c(u)!=="svelte-1nbpolx"&&(u.innerHTML=M)},m(w,g){l(w,u,g)},p:Ht,d(w){w&&a(u)}}}function St(we){let u,M='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){u=f("p"),u.innerHTML=M},l(w){u=h(w,"P",{"data-svelte-h":!0}),c(u)!=="svelte-19y7vpj"&&(u.innerHTML=M)},m(w,g){l(w,u,g)},p:Ht,d(w){w&&a(u)}}}function Pt(we){let u,M,w,g,$,Me,Z,ut='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Te,_,ct="This guide explores in more detail other options and features for using LoRA.",ge,k,be,v,wt='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',Je,j,yt='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',$e,R,Ze,W,Mt="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",_e,B,ke,U,ve,L,Tt='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. If you’re using LoftQ, <em>do not</em> quantize the base model. You should set up a <code>LoftQConfig</code> instead:',je,I,Re,b,We,C,Be,G,gt='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Ue,V,Le,Q,Ie,X,bt='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',Ce,F,Ge,H,Ve,z,Jt='<li>DoRA only supports linear layers at the momement.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Qe,Y,Xe,A,$t='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Fe,q,He,x,ze,E,Zt='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Ye,N,Ae,S,_t='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adpaters.',qe,P,kt=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
(adapter_config.json)[https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json] shows a sample LoRA adapter config applying this method for fine-tuning.`,xe,D,Ee,K,vt='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',Ne,O,Se,ee,jt='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',Pe,te,De,ae,Rt='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',Ke,le,Wt="First load the base model:",Oe,se,et,ne,Bt="Then we load the first adapter:",tt,ie,at,oe,Ut="Then load a different adapter and merge it with the first one:",lt,re,st,J,nt,pe,Lt="Now, perform inference:",it,de,ot,me,rt,fe,It='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',pt,he,dt,ue,Ct='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',mt,ce,ft,ye,ht;return $=new T({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),k=new T({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),R=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),B=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),U=new T({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),I=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb2Z0UUNvbmZpZyUyQyUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoLi4uKSUyMCUyMCUyMyUyMGRvbid0JTIwcXVhbnRpemUlMjBoZXJlJTBBbG9mdHFfY29uZmlnJTIwJTNEJTIwTG9mdFFDb25maWcobG9mdHFfYml0cyUzRDQlMkMlMjAuLi4pJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2V0JTIwNGJpdCUyMHF1YW50aXphdGlvbiUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjBpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmxvZnRxJTIyJTJDJTIwbG9mdHFfY29uZmlnJTNEbG9mdHFfY29uZmlnKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwbG9yYV9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoftQConfig, LoraConfig, get_peft_model

base_model = AutoModelForCausalLM.from_pretrained(...)  <span class="hljs-comment"># don&#x27;t quantize here</span>
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>, ...)           <span class="hljs-comment"># set 4bit quantization</span>
lora_config = LoraConfig(..., init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>, loftq_config=loftq_config)
peft_model = get_peft_model(base_model, lora_config)`,wrap:!1}}),b=new Ft({props:{$$slots:{default:[Nt]},$$scope:{ctx:we}}}),C=new T({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),V=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),Q=new T({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),F=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),H=new T({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),Y=new T({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),q=new y({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),x=new T({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),N=new y({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),D=new T({props:{title:"Merge adapters",local:"merge-adapters",headingTag:"h2"}}),O=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),te=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),se=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),ie=new y({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),re=new y({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),J=new Ft({props:{$$slots:{default:[St]},$$scope:{ctx:we}}}),de=new y({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),me=new T({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),he=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),ce=new y({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),{c(){u=f("meta"),M=s(),w=f("p"),g=s(),i($.$$.fragment),Me=s(),Z=f("p"),Z.innerHTML=ut,Te=s(),_=f("p"),_.textContent=ct,ge=s(),i(k.$$.fragment),be=s(),v=f("p"),v.innerHTML=wt,Je=s(),j=f("p"),j.innerHTML=yt,$e=s(),i(R.$$.fragment),Ze=s(),W=f("p"),W.innerHTML=Mt,_e=s(),i(B.$$.fragment),ke=s(),i(U.$$.fragment),ve=s(),L=f("p"),L.innerHTML=Tt,je=s(),i(I.$$.fragment),Re=s(),i(b.$$.fragment),We=s(),i(C.$$.fragment),Be=s(),G=f("p"),G.innerHTML=gt,Ue=s(),i(V.$$.fragment),Le=s(),i(Q.$$.fragment),Ie=s(),X=f("p"),X.innerHTML=bt,Ce=s(),i(F.$$.fragment),Ge=s(),i(H.$$.fragment),Ve=s(),z=f("ul"),z.innerHTML=Jt,Qe=s(),i(Y.$$.fragment),Xe=s(),A=f("p"),A.innerHTML=$t,Fe=s(),i(q.$$.fragment),He=s(),i(x.$$.fragment),ze=s(),E=f("p"),E.innerHTML=Zt,Ye=s(),i(N.$$.fragment),Ae=s(),S=f("p"),S.innerHTML=_t,qe=s(),P=f("p"),P.innerHTML=kt,xe=s(),i(D.$$.fragment),Ee=s(),K=f("p"),K.innerHTML=vt,Ne=s(),i(O.$$.fragment),Se=s(),ee=f("p"),ee.innerHTML=jt,Pe=s(),i(te.$$.fragment),De=s(),ae=f("p"),ae.innerHTML=Rt,Ke=s(),le=f("p"),le.textContent=Wt,Oe=s(),i(se.$$.fragment),et=s(),ne=f("p"),ne.textContent=Bt,tt=s(),i(ie.$$.fragment),at=s(),oe=f("p"),oe.textContent=Ut,lt=s(),i(re.$$.fragment),st=s(),i(J.$$.fragment),nt=s(),pe=f("p"),pe.textContent=Lt,it=s(),i(de.$$.fragment),ot=s(),i(me.$$.fragment),rt=s(),fe=f("p"),fe.innerHTML=It,pt=s(),i(he.$$.fragment),dt=s(),ue=f("p"),ue.innerHTML=Ct,mt=s(),i(ce.$$.fragment),ft=s(),ye=f("p"),this.h()},l(e){const t=xt("svelte-u9bgzb",document.head);u=h(t,"META",{name:!0,content:!0}),t.forEach(a),M=n(e),w=h(e,"P",{}),Qt(w).forEach(a),g=n(e),o($.$$.fragment,e),Me=n(e),Z=h(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-38uxl6"&&(Z.innerHTML=ut),Te=n(e),_=h(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-ovsn32"&&(_.textContent=ct),ge=n(e),o(k.$$.fragment,e),be=n(e),v=h(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-j883mf"&&(v.innerHTML=wt),Je=n(e),j=h(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1fujb7a"&&(j.innerHTML=yt),$e=n(e),o(R.$$.fragment,e),Ze=n(e),W=h(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-mwvui1"&&(W.innerHTML=Mt),_e=n(e),o(B.$$.fragment,e),ke=n(e),o(U.$$.fragment,e),ve=n(e),L=h(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1khsfzg"&&(L.innerHTML=Tt),je=n(e),o(I.$$.fragment,e),Re=n(e),o(b.$$.fragment,e),We=n(e),o(C.$$.fragment,e),Be=n(e),G=h(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-omuw13"&&(G.innerHTML=gt),Ue=n(e),o(V.$$.fragment,e),Le=n(e),o(Q.$$.fragment,e),Ie=n(e),X=h(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1ukfkwt"&&(X.innerHTML=bt),Ce=n(e),o(F.$$.fragment,e),Ge=n(e),o(H.$$.fragment,e),Ve=n(e),z=h(e,"UL",{"data-svelte-h":!0}),c(z)!=="svelte-cmsowz"&&(z.innerHTML=Jt),Qe=n(e),o(Y.$$.fragment,e),Xe=n(e),A=h(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-15vxux2"&&(A.innerHTML=$t),Fe=n(e),o(q.$$.fragment,e),He=n(e),o(x.$$.fragment,e),ze=n(e),E=h(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1mosto0"&&(E.innerHTML=Zt),Ye=n(e),o(N.$$.fragment,e),Ae=n(e),S=h(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1safyei"&&(S.innerHTML=_t),qe=n(e),P=h(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-18i3sjb"&&(P.innerHTML=kt),xe=n(e),o(D.$$.fragment,e),Ee=n(e),K=h(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1c3h9aa"&&(K.innerHTML=vt),Ne=n(e),o(O.$$.fragment,e),Se=n(e),ee=h(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-m3cr6r"&&(ee.innerHTML=jt),Pe=n(e),o(te.$$.fragment,e),De=n(e),ae=h(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-kbqhpl"&&(ae.innerHTML=Rt),Ke=n(e),le=h(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1mwdwt1"&&(le.textContent=Wt),Oe=n(e),o(se.$$.fragment,e),et=n(e),ne=h(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-nuhu05"&&(ne.textContent=Bt),tt=n(e),o(ie.$$.fragment,e),at=n(e),oe=h(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-1n53hd9"&&(oe.textContent=Ut),lt=n(e),o(re.$$.fragment,e),st=n(e),o(J.$$.fragment,e),nt=n(e),pe=h(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-qwbdkg"&&(pe.textContent=Lt),it=n(e),o(de.$$.fragment,e),ot=n(e),o(me.$$.fragment,e),rt=n(e),fe=h(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-ke62q2"&&(fe.innerHTML=It),pt=n(e),o(he.$$.fragment,e),dt=n(e),ue=h(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-cvmoj6"&&(ue.innerHTML=Ct),mt=n(e),o(ce.$$.fragment,e),ft=n(e),ye=h(e,"P",{}),Qt(ye).forEach(a),this.h()},h(){Xt(u,"name","hf:doc:metadata"),Xt(u,"content",Dt)},m(e,t){Et(document.head,u),l(e,M,t),l(e,w,t),l(e,g,t),r($,e,t),l(e,Me,t),l(e,Z,t),l(e,Te,t),l(e,_,t),l(e,ge,t),r(k,e,t),l(e,be,t),l(e,v,t),l(e,Je,t),l(e,j,t),l(e,$e,t),r(R,e,t),l(e,Ze,t),l(e,W,t),l(e,_e,t),r(B,e,t),l(e,ke,t),r(U,e,t),l(e,ve,t),l(e,L,t),l(e,je,t),r(I,e,t),l(e,Re,t),r(b,e,t),l(e,We,t),r(C,e,t),l(e,Be,t),l(e,G,t),l(e,Ue,t),r(V,e,t),l(e,Le,t),r(Q,e,t),l(e,Ie,t),l(e,X,t),l(e,Ce,t),r(F,e,t),l(e,Ge,t),r(H,e,t),l(e,Ve,t),l(e,z,t),l(e,Qe,t),r(Y,e,t),l(e,Xe,t),l(e,A,t),l(e,Fe,t),r(q,e,t),l(e,He,t),r(x,e,t),l(e,ze,t),l(e,E,t),l(e,Ye,t),r(N,e,t),l(e,Ae,t),l(e,S,t),l(e,qe,t),l(e,P,t),l(e,xe,t),r(D,e,t),l(e,Ee,t),l(e,K,t),l(e,Ne,t),r(O,e,t),l(e,Se,t),l(e,ee,t),l(e,Pe,t),r(te,e,t),l(e,De,t),l(e,ae,t),l(e,Ke,t),l(e,le,t),l(e,Oe,t),r(se,e,t),l(e,et,t),l(e,ne,t),l(e,tt,t),r(ie,e,t),l(e,at,t),l(e,oe,t),l(e,lt,t),r(re,e,t),l(e,st,t),r(J,e,t),l(e,nt,t),l(e,pe,t),l(e,it,t),r(de,e,t),l(e,ot,t),r(me,e,t),l(e,rt,t),l(e,fe,t),l(e,pt,t),r(he,e,t),l(e,dt,t),l(e,ue,t),l(e,mt,t),r(ce,e,t),l(e,ft,t),l(e,ye,t),ht=!0},p(e,[t]){const Gt={};t&2&&(Gt.$$scope={dirty:t,ctx:e}),b.$set(Gt);const Vt={};t&2&&(Vt.$$scope={dirty:t,ctx:e}),J.$set(Vt)},i(e){ht||(p($.$$.fragment,e),p(k.$$.fragment,e),p(R.$$.fragment,e),p(B.$$.fragment,e),p(U.$$.fragment,e),p(I.$$.fragment,e),p(b.$$.fragment,e),p(C.$$.fragment,e),p(V.$$.fragment,e),p(Q.$$.fragment,e),p(F.$$.fragment,e),p(H.$$.fragment,e),p(Y.$$.fragment,e),p(q.$$.fragment,e),p(x.$$.fragment,e),p(N.$$.fragment,e),p(D.$$.fragment,e),p(O.$$.fragment,e),p(te.$$.fragment,e),p(se.$$.fragment,e),p(ie.$$.fragment,e),p(re.$$.fragment,e),p(J.$$.fragment,e),p(de.$$.fragment,e),p(me.$$.fragment,e),p(he.$$.fragment,e),p(ce.$$.fragment,e),ht=!0)},o(e){d($.$$.fragment,e),d(k.$$.fragment,e),d(R.$$.fragment,e),d(B.$$.fragment,e),d(U.$$.fragment,e),d(I.$$.fragment,e),d(b.$$.fragment,e),d(C.$$.fragment,e),d(V.$$.fragment,e),d(Q.$$.fragment,e),d(F.$$.fragment,e),d(H.$$.fragment,e),d(Y.$$.fragment,e),d(q.$$.fragment,e),d(x.$$.fragment,e),d(N.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(J.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(he.$$.fragment,e),d(ce.$$.fragment,e),ht=!1},d(e){e&&(a(M),a(w),a(g),a(Me),a(Z),a(Te),a(_),a(ge),a(be),a(v),a(Je),a(j),a($e),a(Ze),a(W),a(_e),a(ke),a(ve),a(L),a(je),a(Re),a(We),a(Be),a(G),a(Ue),a(Le),a(Ie),a(X),a(Ce),a(Ge),a(Ve),a(z),a(Qe),a(Xe),a(A),a(Fe),a(He),a(ze),a(E),a(Ye),a(Ae),a(S),a(qe),a(P),a(xe),a(Ee),a(K),a(Ne),a(Se),a(ee),a(Pe),a(De),a(ae),a(Ke),a(le),a(Oe),a(et),a(ne),a(tt),a(at),a(oe),a(lt),a(st),a(nt),a(pe),a(it),a(ot),a(rt),a(fe),a(pt),a(dt),a(ue),a(mt),a(ft),a(ye)),a(u),m($,e),m(k,e),m(R,e),m(B,e),m(U,e),m(I,e),m(b,e),m(C,e),m(V,e),m(Q,e),m(F,e),m(H,e),m(Y,e),m(q,e),m(x,e),m(N,e),m(D,e),m(O,e),m(te,e),m(se,e),m(ie,e),m(re,e),m(J,e),m(de,e),m(me,e),m(he,e),m(ce,e)}}}const Dt='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"LoftQ","local":"loftq","sections":[],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge adapters","local":"merge-adapters","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2}],"depth":1}';function Kt(we){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sa extends At{constructor(u){super(),qt(this,u,Kt,Pt,zt,{})}}export{sa as component};
