import{s as Nl,o as Vl,n as Xl}from"../chunks/scheduler.182ea377.js";import{S as Bl,i as El,g as s,s as a,r as p,A as Yl,h as o,f as l,c as i,j as Cl,u as c,x as r,k as xl,y as Fl,a as n,v as u,d as m,t as d,w as f}from"../chunks/index.abf12888.js";import{T as Il}from"../chunks/Tip.230e2334.js";import{C as g}from"../chunks/CodeBlock.57fe6e13.js";import{H as b}from"../chunks/Heading.16916d63.js";function Sl(xt){let h,y="To successfully run the latest versions of the example scripts, we highly recommend <strong>installing from source</strong> and keeping the installation up to date. We update the example scripts frequently and install example-specific requirements.";return{c(){h=s("p"),h.innerHTML=y},l(M){h=o(M,"P",{"data-svelte-h":!0}),r(h)!=="svelte-i634tn"&&(h.innerHTML=y)},m(M,U){n(M,h,U)},p:Xl,d(M){M&&l(h)}}}function kl(xt){let h,y='See <a href="https://huggingface.co/docs/accelerate/usage_guides/deepspeed" rel="nofollow">documentation</a> for more DeepSpeed configuration options.';return{c(){h=s("p"),h.innerHTML=y},l(M){h=o(M,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1i2ijui"&&(h.innerHTML=y)},m(M,U){n(M,h,U)},p:Xl,d(M){M&&l(h)}}}function Ql(xt){let h,y,M,U,J,Xt,_,qe='<a href="https://arxiv.org/abs/2302.05543" rel="nofollow">Adding Conditional Control to Text-to-Image Diffusion Models</a> (ControlNet) by Lvmin Zhang and Maneesh Agrawala.',Nt,Z,De='This example is based on the <a href="https://github.com/lllyasviel/ControlNet/blob/main/docs/train.md" rel="nofollow">training example in the original ControlNet repository</a>. It trains a ControlNet to fill circles using a <a href="https://huggingface.co/datasets/fusing/fill50k" rel="nofollow">small synthetic dataset</a>.',Vt,j,Bt,v,Ae="Before running the scripts, make sure to install the library’s training dependencies.",Et,T,Yt,W,Pe="To do this, execute the following steps in a new virtual environment:",Ft,R,St,$,Oe='Then navigate into the <a href="https://github.com/huggingface/diffusers/tree/main/examples/controlnet" rel="nofollow">example folder</a>',kt,G,Qt,C,Ke="Now run:",Lt,x,Ht,I,tl='And initialize an <a href="https://github.com/huggingface/accelerate/" rel="nofollow">🤗Accelerate</a> environment with:',zt,X,qt,N,el="Or for a default 🤗Accelerate configuration without answering questions about your environment:",Dt,V,At,B,ll="Or if your environment doesn’t support an interactive shell like a notebook:",Pt,E,Ot,Y,Kt,F,nl='The original dataset is hosted in the ControlNet <a href="https://huggingface.co/lllyasviel/ControlNet/blob/main/training/fill50k.zip" rel="nofollow">repo</a>, but we re-uploaded it <a href="https://huggingface.co/datasets/fusing/fill50k" rel="nofollow">here</a> to be compatible with 🤗 Datasets so that it can handle the data loading within the training script.',te,S,al='Our training examples use <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> because that is what the original set of ControlNet models was trained on. However, ControlNet can be trained to augment any compatible Stable Diffusion model (such as <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow"><code>CompVis/stable-diffusion-v1-4</code></a>) or <a href="https://huggingface.co/stabilityai/stable-diffusion-2-1" rel="nofollow"><code>stabilityai/stable-diffusion-2-1</code></a>.',ee,k,il='To use your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide.',le,Q,ne,L,sl="Download the following images to condition our training with:",ae,H,ie,z,ol='Specify the <code>MODEL_NAME</code> environment variable (either a Hub model repository id or a path to the directory containing the model weights) and pass it to the <a href="https://huggingface.co/docs/diffusers/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path" rel="nofollow"><code>pretrained_model_name_or_path</code></a> argument.',se,q,rl="The training script creates and saves a <code>diffusion_pytorch_model.bin</code> file in your repository.",oe,D,re,A,pl="This default configuration requires ~38GB VRAM.",pe,P,cl=`By default, the training script logs outputs to tensorboard. Pass <code>--report_to wandb</code> to use Weights &amp;
Biases.`,ce,O,ul="Gradient accumulation with a smaller batch size can be used to reduce training requirements to ~20 GB VRAM.",ue,K,me,tt,de,et,ml=`<code>accelerate</code> allows for seamless multi-GPU training. Follow the instructions <a href="https://huggingface.co/docs/accelerate/basic_tutorials/launch" rel="nofollow">here</a>
for running distributed training with <code>accelerate</code>. Here is an example command:`,fe,lt,he,nt,Me,at,ge,it,dl='<thead><tr><th></th> <th align="center"></th></tr></thead> <tbody><tr><td></td> <td align="center">red circle with blue background</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_1.png" alt="conditioning image"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/red_circle_with_blue_background_300_steps.png" alt="red circle with blue background"/></td></tr> <tr><td></td> <td align="center">cyan circle with brown floral background</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_2.png" alt="conditioning image"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/cyan_circle_with_brown_floral_background_300_steps.png" alt="cyan circle with brown floral background"/></td></tr></tbody>',be,st,ye,ot,fl='<thead><tr><th></th> <th align="center"></th></tr></thead> <tbody><tr><td></td> <td align="center">red circle with blue background</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_1.png" alt="conditioning image"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/red_circle_with_blue_background_6000_steps.png" alt="red circle with blue background"/></td></tr> <tr><td></td> <td align="center">cyan circle with brown floral background</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_2.png" alt="conditioning image"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/cyan_circle_with_brown_floral_background_6000_steps.png" alt="cyan circle with brown floral background"/></td></tr></tbody>',Ue,rt,Te,pt,hl="Enable the following optimizations to train on a 16GB GPU:",we,ct,Ml='<li>Gradient checkpointing</li> <li>bitsandbyte’s 8-bit optimizer (take a look at the [installation]((<a href="https://github.com/TimDettmers/bitsandbytes#requirements--installation" rel="nofollow">https://github.com/TimDettmers/bitsandbytes#requirements—installation</a>) instructions if you don’t already have it installed)</li>',Je,ut,gl="Now you can launch the training script:",_e,mt,Ze,dt,je,ft,bl="Enable the following optimizations to train on a 12GB GPU:",ve,ht,yl='<li>Gradient checkpointing</li> <li>bitsandbyte’s 8-bit optimizer (take a look at the [installation]((<a href="https://github.com/TimDettmers/bitsandbytes#requirements--installation" rel="nofollow">https://github.com/TimDettmers/bitsandbytes#requirements—installation</a>) instructions if you don’t already have it installed)</li> <li>xFormers (take a look at the <a href="https://huggingface.co/docs/diffusers/training/optimization/xformers" rel="nofollow">installation</a> instructions if you don’t already have it installed)</li> <li>set gradients to <code>None</code></li>',We,Mt,Re,gt,Ul="When using <code>enable_xformers_memory_efficient_attention</code>, please make sure to install <code>xformers</code> by <code>pip install xformers</code>.",$e,bt,Ge,yt,Tl=`We have not exhaustively tested DeepSpeed support for ControlNet. While the configuration does
save memory, we have not confirmed whether the configuration trains successfully. You will very likely
have to make changes to the config to have a successful training run.`,Ce,Ut,wl="Enable the following optimizations to train on a 8GB GPU:",xe,Tt,Jl='<li>Gradient checkpointing</li> <li>bitsandbyte’s 8-bit optimizer (take a look at the [installation]((<a href="https://github.com/TimDettmers/bitsandbytes#requirements--installation" rel="nofollow">https://github.com/TimDettmers/bitsandbytes#requirements—installation</a>) instructions if you don’t already have it installed)</li> <li>xFormers (take a look at the <a href="https://huggingface.co/docs/diffusers/training/optimization/xformers" rel="nofollow">installation</a> instructions if you don’t already have it installed)</li> <li>set gradients to <code>None</code></li> <li>DeepSpeed stage 2 with parameter and optimizer offloading</li> <li>fp16 mixed precision</li>',Ie,wt,_l=`<a href="https://www.deepspeed.ai/" rel="nofollow">DeepSpeed</a> can offload tensors from VRAM to either
CPU or NVME. This requires significantly more RAM (about 25 GB).`,Xe,Jt,Zl="You’ll have to configure your environment with <code>accelerate config</code> to enable DeepSpeed stage 2.",Ne,_t,jl="The configuration file should look like this:",Ve,Zt,Be,w,Ee,jt,vl=`Changing the default Adam optimizer to DeepSpeed’s Adam
<code>deepspeed.ops.adam.DeepSpeedCPUAdam</code> gives a substantial speedup but
it requires a CUDA toolchain with the same version as PyTorch. 8-bit optimizer
does not seem to be compatible with DeepSpeed at the moment.`,Ye,vt,Fe,Wt,Se,Rt,Wl=`The trained model can be run with the <a href="/docs/diffusers/v0.22.2/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a>.
Set <code>base_model_path</code> and <code>controlnet_path</code> to the values <code>--pretrained_model_name_or_path</code> and
<code>--output_dir</code> were respectively set to in the training script.`,ke,$t,Qe,Gt,Le,Ct,Rl='Training with <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a> is also supported via the <code>train_controlnet_sdxl.py</code> script. Please refer to the docs <a href="https://github.com/huggingface/diffusers/blob/main/examples/controlnet/README_sdxl.md" rel="nofollow">here</a>.',He,It,ze;return J=new b({props:{title:"ControlNet",local:"controlnet",headingTag:"h1"}}),j=new b({props:{title:"Installing the dependencies",local:"installing-the-dependencies",headingTag:"h2"}}),T=new Il({props:{warning:!0,$$slots:{default:[Sl]},$$scope:{ctx:xt}}}),R=new g({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC1lJTIwLg==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install -e .`,wrap:!1}}),G=new g({props:{code:"Y2QlMjBleGFtcGxlcyUyRmNvbnRyb2xuZXQ=",highlighted:'<span class="hljs-built_in">cd</span> examples/controlnet',wrap:!1}}),x=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:"pip install -r requirements.txt",wrap:!1}}),X=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),V=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),E=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),Y=new b({props:{title:"Circle filling dataset",local:"circle-filling-dataset",headingTag:"h2"}}),Q=new b({props:{title:"Training",local:"training",headingTag:"h2"}}),H=new g({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNvbnRyb2xuZXRfdHJhaW5pbmclMkZjb25kaXRpb25pbmdfaW1hZ2VfMS5wbmclMEElMEF3Z2V0JTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY29udHJvbG5ldF90cmFpbmluZyUyRmNvbmRpdGlvbmluZ19pbWFnZV8yLnBuZw==",highlighted:`wget https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_1.png

wget https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_2.png`,wrap:!1}}),D=new g({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aCUyMHRvJTIwc2F2ZSUyMG1vZGVsJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2NvbnRyb2xuZXQucHklMjAlNUMlMEElMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfRElSJTIwJTVDJTBBJTIwLS1vdXRwdXRfZGlyJTNEJTI0T1VUUFVUX0RJUiUyMCU1QyUwQSUyMC0tZGF0YXNldF9uYW1lJTNEZnVzaW5nJTJGZmlsbDUwayUyMCU1QyUwQSUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCU1QyUwQSUyMC0tbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMjAlNUMlMEElMjAtLXZhbGlkYXRpb25faW1hZ2UlMjAlMjIuJTJGY29uZGl0aW9uaW5nX2ltYWdlXzEucG5nJTIyJTIwJTIyLiUyRmNvbmRpdGlvbmluZ19pbWFnZV8yLnBuZyUyMiUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9wcm9tcHQlMjAlMjJyZWQlMjBjaXJjbGUlMjB3aXRoJTIwYmx1ZSUyMGJhY2tncm91bmQlMjIlMjAlMjJjeWFuJTIwY2lyY2xlJTIwd2l0aCUyMGJyb3duJTIwZmxvcmFsJTIwYmFja2dyb3VuZCUyMiUyMCU1QyUwQSUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMjAlNUMlMEElMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path to save model&quot;</span>

accelerate launch train_controlnet.py \\
 --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_DIR</span> \\
 --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
 --dataset_name=fusing/fill50k \\
 --resolution=512 \\
 --learning_rate=1e-5 \\
 --validation_image <span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span> <span class="hljs-string">&quot;./conditioning_image_2.png&quot;</span> \\
 --validation_prompt <span class="hljs-string">&quot;red circle with blue background&quot;</span> <span class="hljs-string">&quot;cyan circle with brown floral background&quot;</span> \\
 --train_batch_size=4 \\
 --push_to_hub`,wrap:!1}}),K=new g({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aCUyMHRvJTIwc2F2ZSUyMG1vZGVsJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2NvbnRyb2xuZXQucHklMjAlNUMlMEElMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfRElSJTIwJTVDJTBBJTIwLS1vdXRwdXRfZGlyJTNEJTI0T1VUUFVUX0RJUiUyMCU1QyUwQSUyMC0tZGF0YXNldF9uYW1lJTNEZnVzaW5nJTJGZmlsbDUwayUyMCU1QyUwQSUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCU1QyUwQSUyMC0tbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMjAlNUMlMEElMjAtLXZhbGlkYXRpb25faW1hZ2UlMjAlMjIuJTJGY29uZGl0aW9uaW5nX2ltYWdlXzEucG5nJTIyJTIwJTIyLiUyRmNvbmRpdGlvbmluZ19pbWFnZV8yLnBuZyUyMiUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9wcm9tcHQlMjAlMjJyZWQlMjBjaXJjbGUlMjB3aXRoJTIwYmx1ZSUyMGJhY2tncm91bmQlMjIlMjAlMjJjeWFuJTIwY2lyY2xlJTIwd2l0aCUyMGJyb3duJTIwZmxvcmFsJTIwYmFja2dyb3VuZCUyMiUyMCU1QyUwQSUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path to save model&quot;</span>

accelerate launch train_controlnet.py \\
 --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_DIR</span> \\
 --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
 --dataset_name=fusing/fill50k \\
 --resolution=512 \\
 --learning_rate=1e-5 \\
 --validation_image <span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span> <span class="hljs-string">&quot;./conditioning_image_2.png&quot;</span> \\
 --validation_prompt <span class="hljs-string">&quot;red circle with blue background&quot;</span> <span class="hljs-string">&quot;cyan circle with brown floral background&quot;</span> \\
 --train_batch_size=1 \\
 --gradient_accumulation_steps=4 \\
  --push_to_hub`,wrap:!1}}),tt=new b({props:{title:"Training with multiple GPUs",local:"training-with-multiple-gpus",headingTag:"h2"}}),lt=new g({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aCUyMHRvJTIwc2F2ZSUyMG1vZGVsJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMC0tbXVsdGlfZ3B1JTIwdHJhaW5fY29udHJvbG5ldC5weSUyMCU1QyUwQSUyMC0tcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjRNT0RFTF9ESVIlMjAlNUMlMEElMjAtLW91dHB1dF9kaXIlM0QlMjRPVVRQVVRfRElSJTIwJTVDJTBBJTIwLS1kYXRhc2V0X25hbWUlM0RmdXNpbmclMkZmaWxsNTBrJTIwJTVDJTBBJTIwLS1yZXNvbHV0aW9uJTNENTEyJTIwJTVDJTBBJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtNSUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9pbWFnZSUyMCUyMi4lMkZjb25kaXRpb25pbmdfaW1hZ2VfMS5wbmclMjIlMjAlMjIuJTJGY29uZGl0aW9uaW5nX2ltYWdlXzIucG5nJTIyJTIwJTVDJTBBJTIwLS12YWxpZGF0aW9uX3Byb21wdCUyMCUyMnJlZCUyMGNpcmNsZSUyMHdpdGglMjBibHVlJTIwYmFja2dyb3VuZCUyMiUyMCUyMmN5YW4lMjBjaXJjbGUlMjB3aXRoJTIwYnJvd24lMjBmbG9yYWwlMjBiYWNrZ3JvdW5kJTIyJTIwJTVDJTBBJTIwLS10cmFpbl9iYXRjaF9zaXplJTNENCUyMCU1QyUwQSUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMCU1QyUwQSUyMC0tdHJhY2tlcl9wcm9qZWN0X25hbWUlM0QlMjJjb250cm9sbmV0LWRlbW8lMjIlMjAlNUMlMEElMjAtLXJlcG9ydF90byUzRHdhbmRiJTIwJTVDJTBBJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path to save model&quot;</span>

accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> --multi_gpu train_controlnet.py \\
 --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_DIR</span> \\
 --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
 --dataset_name=fusing/fill50k \\
 --resolution=512 \\
 --learning_rate=1e-5 \\
 --validation_image <span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span> <span class="hljs-string">&quot;./conditioning_image_2.png&quot;</span> \\
 --validation_prompt <span class="hljs-string">&quot;red circle with blue background&quot;</span> <span class="hljs-string">&quot;cyan circle with brown floral background&quot;</span> \\
 --train_batch_size=4 \\
 --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> \\
 --tracker_project_name=<span class="hljs-string">&quot;controlnet-demo&quot;</span> \\
 --report_to=wandb \\
  --push_to_hub`,wrap:!1}}),nt=new b({props:{title:"Example results",local:"example-results",headingTag:"h2"}}),at=new b({props:{title:"After 300 steps with batch size 8",local:"after-300-steps-with-batch-size-8",headingTag:"h4"}}),st=new b({props:{title:"After 6000 steps with batch size 8:",local:"after-6000-steps-with-batch-size-8",headingTag:"h4"}}),rt=new b({props:{title:"Training on a 16 GB GPU",local:"training-on-a-16-gb-gpu",headingTag:"h2"}}),mt=new g({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aCUyMHRvJTIwc2F2ZSUyMG1vZGVsJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2NvbnRyb2xuZXQucHklMjAlNUMlMEElMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfRElSJTIwJTVDJTBBJTIwLS1vdXRwdXRfZGlyJTNEJTI0T1VUUFVUX0RJUiUyMCU1QyUwQSUyMC0tZGF0YXNldF9uYW1lJTNEZnVzaW5nJTJGZmlsbDUwayUyMCU1QyUwQSUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCU1QyUwQSUyMC0tbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMjAlNUMlMEElMjAtLXZhbGlkYXRpb25faW1hZ2UlMjAlMjIuJTJGY29uZGl0aW9uaW5nX2ltYWdlXzEucG5nJTIyJTIwJTIyLiUyRmNvbmRpdGlvbmluZ19pbWFnZV8yLnBuZyUyMiUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9wcm9tcHQlMjAlMjJyZWQlMjBjaXJjbGUlMjB3aXRoJTIwYmx1ZSUyMGJhY2tncm91bmQlMjIlMjAlMjJjeWFuJTIwY2lyY2xlJTIwd2l0aCUyMGJyb3duJTIwZmxvcmFsJTIwYmFja2dyb3VuZCUyMiUyMCU1QyUwQSUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAtLXVzZV84Yml0X2FkYW0lMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path to save model&quot;</span>

accelerate launch train_controlnet.py \\
 --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_DIR</span> \\
 --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
 --dataset_name=fusing/fill50k \\
 --resolution=512 \\
 --learning_rate=1e-5 \\
 --validation_image <span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span> <span class="hljs-string">&quot;./conditioning_image_2.png&quot;</span> \\
 --validation_prompt <span class="hljs-string">&quot;red circle with blue background&quot;</span> <span class="hljs-string">&quot;cyan circle with brown floral background&quot;</span> \\
 --train_batch_size=1 \\
 --gradient_accumulation_steps=4 \\
 --gradient_checkpointing \\
 --use_8bit_adam \\
  --push_to_hub`,wrap:!1}}),dt=new b({props:{title:"Training on a 12 GB GPU",local:"training-on-a-12-gb-gpu",headingTag:"h2"}}),Mt=new g({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aCUyMHRvJTIwc2F2ZSUyMG1vZGVsJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2NvbnRyb2xuZXQucHklMjAlNUMlMEElMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfRElSJTIwJTVDJTBBJTIwLS1vdXRwdXRfZGlyJTNEJTI0T1VUUFVUX0RJUiUyMCU1QyUwQSUyMC0tZGF0YXNldF9uYW1lJTNEZnVzaW5nJTJGZmlsbDUwayUyMCU1QyUwQSUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCU1QyUwQSUyMC0tbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMjAlNUMlMEElMjAtLXZhbGlkYXRpb25faW1hZ2UlMjAlMjIuJTJGY29uZGl0aW9uaW5nX2ltYWdlXzEucG5nJTIyJTIwJTIyLiUyRmNvbmRpdGlvbmluZ19pbWFnZV8yLnBuZyUyMiUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9wcm9tcHQlMjAlMjJyZWQlMjBjaXJjbGUlMjB3aXRoJTIwYmx1ZSUyMGJhY2tncm91bmQlMjIlMjAlMjJjeWFuJTIwY2lyY2xlJTIwd2l0aCUyMGJyb3duJTIwZmxvcmFsJTIwYmFja2dyb3VuZCUyMiUyMCU1QyUwQSUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAtLXVzZV84Yml0X2FkYW0lMjAlNUMlMEElMjAtLWVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbiUyMCU1QyUwQSUyMC0tc2V0X2dyYWRzX3RvX25vbmUlMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path to save model&quot;</span>

accelerate launch train_controlnet.py \\
 --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_DIR</span> \\
 --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
 --dataset_name=fusing/fill50k \\
 --resolution=512 \\
 --learning_rate=1e-5 \\
 --validation_image <span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span> <span class="hljs-string">&quot;./conditioning_image_2.png&quot;</span> \\
 --validation_prompt <span class="hljs-string">&quot;red circle with blue background&quot;</span> <span class="hljs-string">&quot;cyan circle with brown floral background&quot;</span> \\
 --train_batch_size=1 \\
 --gradient_accumulation_steps=4 \\
 --gradient_checkpointing \\
 --use_8bit_adam \\
 --enable_xformers_memory_efficient_attention \\
 --set_grads_to_none \\
  --push_to_hub`,wrap:!1}}),bt=new b({props:{title:"Training on an 8 GB GPU",local:"training-on-an-8-gb-gpu",headingTag:"h2"}}),Zt=new g({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNBJTIwNCUwQSUyMCUyMG9mZmxvYWRfb3B0aW1pemVyX2RldmljZSUzQSUyMGNwdSUwQSUyMCUyMG9mZmxvYWRfcGFyYW1fZGV2aWNlJTNBJTIwY3B1JTBBJTIwJTIwemVybzNfaW5pdF9mbGFnJTNBJTIwZmFsc2UlMEElMjAlMjB6ZXJvX3N0YWdlJTNBJTIwMiUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQ=",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">deepspeed_config:</span>
  <span class="hljs-attr">gradient_accumulation_steps:</span> <span class="hljs-number">4</span>
  <span class="hljs-attr">offload_optimizer_device:</span> <span class="hljs-string">cpu</span>
  <span class="hljs-attr">offload_param_device:</span> <span class="hljs-string">cpu</span>
  <span class="hljs-attr">zero3_init_flag:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">zero_stage:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">DEEPSPEED</span>`,wrap:!1}}),w=new Il({props:{$$slots:{default:[kl]},$$scope:{ctx:xt}}}),vt=new g({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aCUyMHRvJTIwc2F2ZSUyMG1vZGVsJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2NvbnRyb2xuZXQucHklMjAlNUMlMEElMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfRElSJTIwJTVDJTBBJTIwLS1vdXRwdXRfZGlyJTNEJTI0T1VUUFVUX0RJUiUyMCU1QyUwQSUyMC0tZGF0YXNldF9uYW1lJTNEZnVzaW5nJTJGZmlsbDUwayUyMCU1QyUwQSUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9pbWFnZSUyMCUyMi4lMkZjb25kaXRpb25pbmdfaW1hZ2VfMS5wbmclMjIlMjAlMjIuJTJGY29uZGl0aW9uaW5nX2ltYWdlXzIucG5nJTIyJTIwJTVDJTBBJTIwLS12YWxpZGF0aW9uX3Byb21wdCUyMCUyMnJlZCUyMGNpcmNsZSUyMHdpdGglMjBibHVlJTIwYmFja2dyb3VuZCUyMiUyMCUyMmN5YW4lMjBjaXJjbGUlMjB3aXRoJTIwYnJvd24lMjBmbG9yYWwlMjBiYWNrZ3JvdW5kJTIyJTIwJTVDJTBBJTIwLS10cmFpbl9iYXRjaF9zaXplJTNEMSUyMCU1QyUwQSUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNENCUyMCU1QyUwQSUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMCU1QyUwQSUyMC0tZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uJTIwJTVDJTBBJTIwLS1zZXRfZ3JhZHNfdG9fbm9uZSUyMCU1QyUwQSUyMC0tbWl4ZWRfcHJlY2lzaW9uJTIwZnAxNiUyMCU1QyUwQSUyMC0tcHVzaF90b19odWI=",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path to save model&quot;</span>

accelerate launch train_controlnet.py \\
 --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_DIR</span> \\
 --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
 --dataset_name=fusing/fill50k \\
 --resolution=512 \\
 --validation_image <span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span> <span class="hljs-string">&quot;./conditioning_image_2.png&quot;</span> \\
 --validation_prompt <span class="hljs-string">&quot;red circle with blue background&quot;</span> <span class="hljs-string">&quot;cyan circle with brown floral background&quot;</span> \\
 --train_batch_size=1 \\
 --gradient_accumulation_steps=4 \\
 --gradient_checkpointing \\
 --enable_xformers_memory_efficient_attention \\
 --set_grads_to_none \\
 --mixed_precision fp16 \\
 --push_to_hub`,wrap:!1}}),Wt=new b({props:{title:"Inference",local:"inference",headingTag:"h2"}}),$t=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUyQyUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWxfcGF0aCUyMCUzRCUyMCUyMnBhdGglMjB0byUyMG1vZGVsJTIyJTBBY29udHJvbG5ldF9wYXRoJTIwJTNEJTIwJTIycGF0aCUyMHRvJTIwY29udHJvbG5ldCUyMiUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNvbnRyb2xuZXRfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwYmFzZV9tb2RlbF9wYXRoJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQSUwQSUyMyUyMHNwZWVkJTIwdXAlMjBkaWZmdXNpb24lMjBwcm9jZXNzJTIwd2l0aCUyMGZhc3RlciUyMHNjaGVkdWxlciUyMGFuZCUyMG1lbW9yeSUyMG9wdGltaXphdGlvbiUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhmb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMEFwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQWNvbnRyb2xfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMi4lMkZjb25kaXRpb25pbmdfaW1hZ2VfMS5wbmclMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIycGFsZSUyMGdvbGRlbiUyMHJvZCUyMGNpcmNsZSUyMHdpdGglMjBvbGQlMjBsYWNlJTIwYmFja2dyb3VuZCUyMiUwQSUwQSUyMyUyMGdlbmVyYXRlJTIwaW1hZ2UlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBpbWFnZSUzRGNvbnRyb2xfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEElMEFpbWFnZS5zYXZlKCUyMi4lMkZvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

base_model_path = <span class="hljs-string">&quot;path to model&quot;</span>
controlnet_path = <span class="hljs-string">&quot;path to controlnet&quot;</span>

controlnet = ControlNetModel.from_pretrained(controlnet_path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    base_model_path, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># speed up diffusion process with faster scheduler and memory optimization</span>
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-comment"># remove following line if xformers is not installed</span>
pipe.enable_xformers_memory_efficient_attention()

pipe.enable_model_cpu_offload()

control_image = load_image(<span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span>)
prompt = <span class="hljs-string">&quot;pale golden rod circle with old lace background&quot;</span>

<span class="hljs-comment"># generate image</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(prompt, num_inference_steps=<span class="hljs-number">20</span>, generator=generator, image=control_image).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;./output.png&quot;</span>)`,wrap:!1}}),Gt=new b({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),{c(){h=s("meta"),y=a(),M=s("p"),U=a(),p(J.$$.fragment),Xt=a(),_=s("p"),_.innerHTML=qe,Nt=a(),Z=s("p"),Z.innerHTML=De,Vt=a(),p(j.$$.fragment),Bt=a(),v=s("p"),v.textContent=Ae,Et=a(),p(T.$$.fragment),Yt=a(),W=s("p"),W.textContent=Pe,Ft=a(),p(R.$$.fragment),St=a(),$=s("p"),$.innerHTML=Oe,kt=a(),p(G.$$.fragment),Qt=a(),C=s("p"),C.textContent=Ke,Lt=a(),p(x.$$.fragment),Ht=a(),I=s("p"),I.innerHTML=tl,zt=a(),p(X.$$.fragment),qt=a(),N=s("p"),N.textContent=el,Dt=a(),p(V.$$.fragment),At=a(),B=s("p"),B.textContent=ll,Pt=a(),p(E.$$.fragment),Ot=a(),p(Y.$$.fragment),Kt=a(),F=s("p"),F.innerHTML=nl,te=a(),S=s("p"),S.innerHTML=al,ee=a(),k=s("p"),k.innerHTML=il,le=a(),p(Q.$$.fragment),ne=a(),L=s("p"),L.textContent=sl,ae=a(),p(H.$$.fragment),ie=a(),z=s("p"),z.innerHTML=ol,se=a(),q=s("p"),q.innerHTML=rl,oe=a(),p(D.$$.fragment),re=a(),A=s("p"),A.textContent=pl,pe=a(),P=s("p"),P.innerHTML=cl,ce=a(),O=s("p"),O.textContent=ul,ue=a(),p(K.$$.fragment),me=a(),p(tt.$$.fragment),de=a(),et=s("p"),et.innerHTML=ml,fe=a(),p(lt.$$.fragment),he=a(),p(nt.$$.fragment),Me=a(),p(at.$$.fragment),ge=a(),it=s("table"),it.innerHTML=dl,be=a(),p(st.$$.fragment),ye=a(),ot=s("table"),ot.innerHTML=fl,Ue=a(),p(rt.$$.fragment),Te=a(),pt=s("p"),pt.textContent=hl,we=a(),ct=s("ul"),ct.innerHTML=Ml,Je=a(),ut=s("p"),ut.textContent=gl,_e=a(),p(mt.$$.fragment),Ze=a(),p(dt.$$.fragment),je=a(),ft=s("p"),ft.textContent=bl,ve=a(),ht=s("ul"),ht.innerHTML=yl,We=a(),p(Mt.$$.fragment),Re=a(),gt=s("p"),gt.innerHTML=Ul,$e=a(),p(bt.$$.fragment),Ge=a(),yt=s("p"),yt.textContent=Tl,Ce=a(),Ut=s("p"),Ut.textContent=wl,xe=a(),Tt=s("ul"),Tt.innerHTML=Jl,Ie=a(),wt=s("p"),wt.innerHTML=_l,Xe=a(),Jt=s("p"),Jt.innerHTML=Zl,Ne=a(),_t=s("p"),_t.textContent=jl,Ve=a(),p(Zt.$$.fragment),Be=a(),p(w.$$.fragment),Ee=a(),jt=s("p"),jt.innerHTML=vl,Ye=a(),p(vt.$$.fragment),Fe=a(),p(Wt.$$.fragment),Se=a(),Rt=s("p"),Rt.innerHTML=Wl,ke=a(),p($t.$$.fragment),Qe=a(),p(Gt.$$.fragment),Le=a(),Ct=s("p"),Ct.innerHTML=Rl,He=a(),It=s("p"),this.h()},l(t){const e=Yl("svelte-u9bgzb",document.head);h=o(e,"META",{name:!0,content:!0}),e.forEach(l),y=i(t),M=o(t,"P",{}),Cl(M).forEach(l),U=i(t),c(J.$$.fragment,t),Xt=i(t),_=o(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-vqe38f"&&(_.innerHTML=qe),Nt=i(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-h8xjkl"&&(Z.innerHTML=De),Vt=i(t),c(j.$$.fragment,t),Bt=i(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-13r6xyj"&&(v.textContent=Ae),Et=i(t),c(T.$$.fragment,t),Yt=i(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-avpba0"&&(W.textContent=Pe),Ft=i(t),c(R.$$.fragment,t),St=i(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-uwesou"&&($.innerHTML=Oe),kt=i(t),c(G.$$.fragment,t),Qt=i(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-17vzo3f"&&(C.textContent=Ke),Lt=i(t),c(x.$$.fragment,t),Ht=i(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1apictl"&&(I.innerHTML=tl),zt=i(t),c(X.$$.fragment,t),qt=i(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ow8iv6"&&(N.textContent=el),Dt=i(t),c(V.$$.fragment,t),At=i(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1asek1h"&&(B.textContent=ll),Pt=i(t),c(E.$$.fragment,t),Ot=i(t),c(Y.$$.fragment,t),Kt=i(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-tk7tt3"&&(F.innerHTML=nl),te=i(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-itxq4h"&&(S.innerHTML=al),ee=i(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-19a7h78"&&(k.innerHTML=il),le=i(t),c(Q.$$.fragment,t),ne=i(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-hvzp9c"&&(L.textContent=sl),ae=i(t),c(H.$$.fragment,t),ie=i(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-sj32mn"&&(z.innerHTML=ol),se=i(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-l3tgq2"&&(q.innerHTML=rl),oe=i(t),c(D.$$.fragment,t),re=i(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-j8njrp"&&(A.textContent=pl),pe=i(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-3pyfnn"&&(P.innerHTML=cl),ce=i(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1uie82a"&&(O.textContent=ul),ue=i(t),c(K.$$.fragment,t),me=i(t),c(tt.$$.fragment,t),de=i(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1tkye3l"&&(et.innerHTML=ml),fe=i(t),c(lt.$$.fragment,t),he=i(t),c(nt.$$.fragment,t),Me=i(t),c(at.$$.fragment,t),ge=i(t),it=o(t,"TABLE",{"data-svelte-h":!0}),r(it)!=="svelte-626s6m"&&(it.innerHTML=dl),be=i(t),c(st.$$.fragment,t),ye=i(t),ot=o(t,"TABLE",{"data-svelte-h":!0}),r(ot)!=="svelte-15uqe2y"&&(ot.innerHTML=fl),Ue=i(t),c(rt.$$.fragment,t),Te=i(t),pt=o(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-srwe1s"&&(pt.textContent=hl),we=i(t),ct=o(t,"UL",{"data-svelte-h":!0}),r(ct)!=="svelte-1ud41h2"&&(ct.innerHTML=Ml),Je=i(t),ut=o(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-xz1hns"&&(ut.textContent=gl),_e=i(t),c(mt.$$.fragment,t),Ze=i(t),c(dt.$$.fragment,t),je=i(t),ft=o(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-gjmxa4"&&(ft.textContent=bl),ve=i(t),ht=o(t,"UL",{"data-svelte-h":!0}),r(ht)!=="svelte-fhxfez"&&(ht.innerHTML=yl),We=i(t),c(Mt.$$.fragment,t),Re=i(t),gt=o(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-8c8k6u"&&(gt.innerHTML=Ul),$e=i(t),c(bt.$$.fragment,t),Ge=i(t),yt=o(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-178qs1f"&&(yt.textContent=Tl),Ce=i(t),Ut=o(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-mrrfah"&&(Ut.textContent=wl),xe=i(t),Tt=o(t,"UL",{"data-svelte-h":!0}),r(Tt)!=="svelte-1u1ac16"&&(Tt.innerHTML=Jl),Ie=i(t),wt=o(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-17z57jf"&&(wt.innerHTML=_l),Xe=i(t),Jt=o(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-nyyim6"&&(Jt.innerHTML=Zl),Ne=i(t),_t=o(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-120hras"&&(_t.textContent=jl),Ve=i(t),c(Zt.$$.fragment,t),Be=i(t),c(w.$$.fragment,t),Ee=i(t),jt=o(t,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1x09dzx"&&(jt.innerHTML=vl),Ye=i(t),c(vt.$$.fragment,t),Fe=i(t),c(Wt.$$.fragment,t),Se=i(t),Rt=o(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-21zqpa"&&(Rt.innerHTML=Wl),ke=i(t),c($t.$$.fragment,t),Qe=i(t),c(Gt.$$.fragment,t),Le=i(t),Ct=o(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1jon7xv"&&(Ct.innerHTML=Rl),He=i(t),It=o(t,"P",{}),Cl(It).forEach(l),this.h()},h(){xl(h,"name","hf:doc:metadata"),xl(h,"content",Ll)},m(t,e){Fl(document.head,h),n(t,y,e),n(t,M,e),n(t,U,e),u(J,t,e),n(t,Xt,e),n(t,_,e),n(t,Nt,e),n(t,Z,e),n(t,Vt,e),u(j,t,e),n(t,Bt,e),n(t,v,e),n(t,Et,e),u(T,t,e),n(t,Yt,e),n(t,W,e),n(t,Ft,e),u(R,t,e),n(t,St,e),n(t,$,e),n(t,kt,e),u(G,t,e),n(t,Qt,e),n(t,C,e),n(t,Lt,e),u(x,t,e),n(t,Ht,e),n(t,I,e),n(t,zt,e),u(X,t,e),n(t,qt,e),n(t,N,e),n(t,Dt,e),u(V,t,e),n(t,At,e),n(t,B,e),n(t,Pt,e),u(E,t,e),n(t,Ot,e),u(Y,t,e),n(t,Kt,e),n(t,F,e),n(t,te,e),n(t,S,e),n(t,ee,e),n(t,k,e),n(t,le,e),u(Q,t,e),n(t,ne,e),n(t,L,e),n(t,ae,e),u(H,t,e),n(t,ie,e),n(t,z,e),n(t,se,e),n(t,q,e),n(t,oe,e),u(D,t,e),n(t,re,e),n(t,A,e),n(t,pe,e),n(t,P,e),n(t,ce,e),n(t,O,e),n(t,ue,e),u(K,t,e),n(t,me,e),u(tt,t,e),n(t,de,e),n(t,et,e),n(t,fe,e),u(lt,t,e),n(t,he,e),u(nt,t,e),n(t,Me,e),u(at,t,e),n(t,ge,e),n(t,it,e),n(t,be,e),u(st,t,e),n(t,ye,e),n(t,ot,e),n(t,Ue,e),u(rt,t,e),n(t,Te,e),n(t,pt,e),n(t,we,e),n(t,ct,e),n(t,Je,e),n(t,ut,e),n(t,_e,e),u(mt,t,e),n(t,Ze,e),u(dt,t,e),n(t,je,e),n(t,ft,e),n(t,ve,e),n(t,ht,e),n(t,We,e),u(Mt,t,e),n(t,Re,e),n(t,gt,e),n(t,$e,e),u(bt,t,e),n(t,Ge,e),n(t,yt,e),n(t,Ce,e),n(t,Ut,e),n(t,xe,e),n(t,Tt,e),n(t,Ie,e),n(t,wt,e),n(t,Xe,e),n(t,Jt,e),n(t,Ne,e),n(t,_t,e),n(t,Ve,e),u(Zt,t,e),n(t,Be,e),u(w,t,e),n(t,Ee,e),n(t,jt,e),n(t,Ye,e),u(vt,t,e),n(t,Fe,e),u(Wt,t,e),n(t,Se,e),n(t,Rt,e),n(t,ke,e),u($t,t,e),n(t,Qe,e),u(Gt,t,e),n(t,Le,e),n(t,Ct,e),n(t,He,e),n(t,It,e),ze=!0},p(t,[e]){const $l={};e&2&&($l.$$scope={dirty:e,ctx:t}),T.$set($l);const Gl={};e&2&&(Gl.$$scope={dirty:e,ctx:t}),w.$set(Gl)},i(t){ze||(m(J.$$.fragment,t),m(j.$$.fragment,t),m(T.$$.fragment,t),m(R.$$.fragment,t),m(G.$$.fragment,t),m(x.$$.fragment,t),m(X.$$.fragment,t),m(V.$$.fragment,t),m(E.$$.fragment,t),m(Y.$$.fragment,t),m(Q.$$.fragment,t),m(H.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(tt.$$.fragment,t),m(lt.$$.fragment,t),m(nt.$$.fragment,t),m(at.$$.fragment,t),m(st.$$.fragment,t),m(rt.$$.fragment,t),m(mt.$$.fragment,t),m(dt.$$.fragment,t),m(Mt.$$.fragment,t),m(bt.$$.fragment,t),m(Zt.$$.fragment,t),m(w.$$.fragment,t),m(vt.$$.fragment,t),m(Wt.$$.fragment,t),m($t.$$.fragment,t),m(Gt.$$.fragment,t),ze=!0)},o(t){d(J.$$.fragment,t),d(j.$$.fragment,t),d(T.$$.fragment,t),d(R.$$.fragment,t),d(G.$$.fragment,t),d(x.$$.fragment,t),d(X.$$.fragment,t),d(V.$$.fragment,t),d(E.$$.fragment,t),d(Y.$$.fragment,t),d(Q.$$.fragment,t),d(H.$$.fragment,t),d(D.$$.fragment,t),d(K.$$.fragment,t),d(tt.$$.fragment,t),d(lt.$$.fragment,t),d(nt.$$.fragment,t),d(at.$$.fragment,t),d(st.$$.fragment,t),d(rt.$$.fragment,t),d(mt.$$.fragment,t),d(dt.$$.fragment,t),d(Mt.$$.fragment,t),d(bt.$$.fragment,t),d(Zt.$$.fragment,t),d(w.$$.fragment,t),d(vt.$$.fragment,t),d(Wt.$$.fragment,t),d($t.$$.fragment,t),d(Gt.$$.fragment,t),ze=!1},d(t){t&&(l(y),l(M),l(U),l(Xt),l(_),l(Nt),l(Z),l(Vt),l(Bt),l(v),l(Et),l(Yt),l(W),l(Ft),l(St),l($),l(kt),l(Qt),l(C),l(Lt),l(Ht),l(I),l(zt),l(qt),l(N),l(Dt),l(At),l(B),l(Pt),l(Ot),l(Kt),l(F),l(te),l(S),l(ee),l(k),l(le),l(ne),l(L),l(ae),l(ie),l(z),l(se),l(q),l(oe),l(re),l(A),l(pe),l(P),l(ce),l(O),l(ue),l(me),l(de),l(et),l(fe),l(he),l(Me),l(ge),l(it),l(be),l(ye),l(ot),l(Ue),l(Te),l(pt),l(we),l(ct),l(Je),l(ut),l(_e),l(Ze),l(je),l(ft),l(ve),l(ht),l(We),l(Re),l(gt),l($e),l(Ge),l(yt),l(Ce),l(Ut),l(xe),l(Tt),l(Ie),l(wt),l(Xe),l(Jt),l(Ne),l(_t),l(Ve),l(Be),l(Ee),l(jt),l(Ye),l(Fe),l(Se),l(Rt),l(ke),l(Qe),l(Le),l(Ct),l(He),l(It)),l(h),f(J,t),f(j,t),f(T,t),f(R,t),f(G,t),f(x,t),f(X,t),f(V,t),f(E,t),f(Y,t),f(Q,t),f(H,t),f(D,t),f(K,t),f(tt,t),f(lt,t),f(nt,t),f(at,t),f(st,t),f(rt,t),f(mt,t),f(dt,t),f(Mt,t),f(bt,t),f(Zt,t),f(w,t),f(vt,t),f(Wt,t),f($t,t),f(Gt,t)}}}const Ll='{"title":"ControlNet","local":"controlnet","sections":[{"title":"Installing the dependencies","local":"installing-the-dependencies","sections":[],"depth":2},{"title":"Circle filling dataset","local":"circle-filling-dataset","sections":[],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"Training with multiple GPUs","local":"training-with-multiple-gpus","sections":[],"depth":2},{"title":"Example results","local":"example-results","sections":[{"title":"After 300 steps with batch size 8","local":"after-300-steps-with-batch-size-8","sections":[],"depth":4},{"title":"After 6000 steps with batch size 8:","local":"after-6000-steps-with-batch-size-8","sections":[],"depth":4}],"depth":2},{"title":"Training on a 16 GB GPU","local":"training-on-a-16-gb-gpu","sections":[],"depth":2},{"title":"Training on a 12 GB GPU","local":"training-on-a-12-gb-gpu","sections":[],"depth":2},{"title":"Training on an 8 GB GPU","local":"training-on-an-8-gb-gpu","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2}],"depth":1}';function Hl(xt){return Vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends Bl{constructor(h){super(),El(this,h,Hl,Ql,Nl,{})}}export{Ol as component};
