import{s as dl,n as wl,o as gl}from"../chunks/scheduler.39a43cde.js";import{S as Ul,i as $l,g as p,s as n,r as o,A as jl,h as i,f as l,c as a,j as cl,u,x as m,k as hl,y as Cl,a as s,v as b,d as r,t as M,w as y}from"../chunks/index.23ec2204.js";import{D as Gl,C as f}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as gt}from"../chunks/Heading.c42e7061.js";function xl(ke){let J,jt,Ut,Ct,T,Gt,c,xt,h,Ie='<em>作者: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a></em>',Bt,d,Re='本 notebook 展示了如何使用 <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a> 模型和 LangChain 快速构建一个针对项目 GitHub issues 的简单 RAG。',vt,w,He="<strong>什么是 RAG</strong>",Zt,g,Xe="RAG 是一个很流行的方法，用来解决强大的 LLM 不知道具体内容的问题，因为具体内容不在其训练数据中，或者当它看到它之前时产生幻觉。这样的具体内容可能是专有的、敏感的，或者，就像这个例子中一样，是最近的和更新的。",_t,U,We="如果你的数据集是静态的和不需要定期更新的，那么你可能会考虑微调一个大模型。但在大多数情况下，微调模型花费巨大并且重复去微调的话(比如，处理数据漂移的时候)，可能会导致“模型偏移”。这种情况模型行为的变换就不是设计的那样了。",kt,$,Ve="<strong>RAG (检索增强生成)</strong> 并不需要模型微调。相反， RAG 通过提供检索到的额外的相关内容喂给 LLM 以此来获得更好的回答。",It,j,Ne="这里是一个简单说明：",Rt,C,Fe='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/rag-diagram.png" alt="RAG diagram"/>',Ht,G,Se="<li><p>额外的数据通过独立的嵌入模型会被转化为嵌入向量，这些向量会储存在向量数据库里。嵌入模型通常都比较小，因此在常规偏差上更新嵌入向量相比于微调模型会更快，便宜，和简单。</p></li> <li><p>与此同时，由于不需要微调，给了你极大的自由度去切换选择你自己的更强的 LLM，或者对于更快速的推理去切换更小的蒸馏模型。</p></li>",Xt,x,Le="让我们用开源的 LLM ，嵌入模型，和 LangChain 快速构建一个针对项目 GitHub issues 的简单 RAG。",Wt,B,ze="首先安装相关依赖：",Vt,v,Nt,Z,Ft,_,St,k,Lt,I,Ee='在这个例子中，我们会从<a href="https://github.com/huggingface/peft" rel="nofollow">PEFT 库的仓库</a>加载所有的 issues（包括现在开放的和已经关闭的）。',zt,R,Qe='首先，你需要获取一个 <a href="https://github.com/settings/tokens?type=beta" rel="nofollow">GitHub 个人权限 token</a> 来访问 GitHub API。',Et,H,Qt,X,Ye='下一步，我们将会加载  <a href="https://github.com/huggingface/peft" rel="nofollow">huggingface/peft</a> 仓库中所有的 issues:',Yt,W,qe="<li>默认情况下， PR 也被认定为 issues，这里我们要设置 <code>include_prs=False</code> 来排除 PR。</li> <li>设置 <code>state = &quot;all&quot;</code> 意味着我们会把开放和已经关闭的 issues 都加载了。</li>",qt,V,At,N,Ae="个人仓库的 issues 内容可能会长于一个嵌入模型可以最为输入处理的长度。如果我们想要嵌入所有可用的内容，我们需要把文档分割成适当大小的块。",Pt,F,Pe="最普通直接的切块方法就是定义一个固定的块大小，以及判断块之间是否加入重叠。保存一些块之间的重叠允许我们去保存一些语义上下文。",Dt,S,De="其他方法通常更复杂，会考虑到文档的结构和上下文。例如，人们可能希望根据句子或段落来分割文档，然而，固定大小的分块在大多数常见情况下都表现得很好，所以我们将在这里采用这种方法。",Kt,L,Ot,z,te,E,Ke="现在所有的文档都设置成立合适的大小，我们可以用他们的嵌入创建一个数据集了。",ee,Q,Oe='为了创建文档块嵌入，我们将会使用 <code>HuggingFaceEmbeddings</code> 和 <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a> 嵌入模型。在 Hub 上有许多其他的嵌入模型可用，你也可以查看 <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">Massive Text Embedding Benchmark (MTEB) Leaderboard</a> 关注表现最好的模型。',le,Y,tl="为了创建向量数据库，我们将会使用 <code>FAISS</code> 库。这个库提供高效的相似度搜索和稠密向量的聚类，正是我们需要的。FAISS 目前是大规模数据集上 NN 搜索最常用的库之一。",se,q,el="我们通过 LangChain 的 API 来获取嵌入模型和 FAISS 向量数据库。",ne,A,ae,P,ll="我们需要一种方式，来返回给定无结构的查询所需要的文档。针对这个，我们会使用 <code>as_retriever</code> 方法，使用 <code>db</code> 作为支柱：",pe,D,sl="<li><code>search_type=&quot;similarity&quot;</code> 意味着我们会执行查询和文档之间的相似度搜索</li> <li><code>search_kwargs={&#39;k&#39;: 4}</code> 指示我们指定返回的最高的 4 个结果</li>",ie,K,me,O,nl="向量数据库和检索器现在设置好了，下一步我们需要设置好链中的下一块 - 模型。",oe,tt,ue,et,al='针对本例，我们选择 <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>, 一个小而强大的模型。',be,lt,pl='随着每周都会出好多模型，你可能会想要替换这个模型到最新的最好的模型。最好的方式是查看 <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>。',re,st,il="为了推理更快，我们将加载模型的量化版本：",Me,nt,ye,at,fe,pt,ml="最后，我们有了所有的需要设置的 LLM 链的部分。",Je,it,ol="首先，使用加载的模型和他的tokenizer创建一个文本生成的流水线(pipeline)",Te,mt,ul="下一步，创建一个提示模板-这个应该遵循模型的格式，所以如果你替换了模型检查点，确保使用合适的格式。",ce,ot,he,ut,bl="注意：你也可以使用 <code>tokenizer.apply_chat_template</code> 转换列表消息为合适聊天格式的字符串（字典也行  <code>{&#39;role&#39;: &#39;user&#39;, &#39;content&#39;: &#39;(...)&#39;}</code>）",de,bt,rl="最后，我们需要将 LLM 链与检索器(retriever)结合起来创建一个 RAG 链。我们将原始问题以及检索到的文档上下文传递到最后生成步骤：",we,rt,ge,Mt,Ue,yt,Ml="让我们看看对于特定领域库的问题不同的 RAG 的生成的回答。",$e,ft,je,Jt,yl="首先，让我们看看仅仅通过模型自身不加检索内容能得到什么答案:",Ce,Tt,Ge,ct,fl=`可以看到，模型将这个问题解释为关于物理电脑适配器的问题，而在 PEFT 的背景下，“适配器”指的是 LoRA 适配器。
让我们看看添加 GitHub issues 的上下文是否有助于模型给出更相关的答案：`,xe,ht,Be,dt,Jl="我们可以看到，加入检索的信息后，同一个模型能够对于特定库的问题给出更准确、更相关的答案。",ve,wt,Tl="值得注意的是，将多个适配器结合用于推理的功能已经被添加到库中，人们可以在文档中找到这些信息，因此在下一个迭代的RAG中，包含文档嵌入可能是有价值的。",Ze,$t,_e;return T=new Gl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_zephyr_langchain.ipynb"}]}}),c=new gt({props:{title:"用 Hugging Face Zephyr 和 LangChain 针对 Github issues 构建简单的 RAG",local:"用-hugging-face-zephyr-和-langchain-针对-github-issues-构建简单的-rag",headingTag:"h1"}}),v=new f({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHRyYW5zZm9ybWVycyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdQ==",highlighted:"!pip install -q torch transformers accelerate bitsandbytes transformers sentence-transformers faiss-gpu",wrap:!1}}),Z=new f({props:{code:"JTIzJTIwSWYlMjBydW5uaW5nJTIwaW4lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMG1heSUyMG5lZWQlMjB0byUyMHJ1biUyMHRoaXMlMjBjZWxsJTIwdG8lMjBtYWtlJTIwc3VyZSUyMHlvdSdyZSUyMHVzaW5nJTIwVVRGLTglMjBsb2NhbGUlMjB0byUyMGluc3RhbGwlMjBMYW5nQ2hhaW4lMEFpbXBvcnQlMjBsb2NhbGUlMEElMEFsb2NhbGUuZ2V0cHJlZmVycmVkZW5jb2RpbmclMjAlM0QlMjBsYW1iZGElM0ElMjAlMjJVVEYtOCUyMg==",highlighted:`<span class="hljs-comment"># If running in Google Colab, you may need to run this cell to make sure you&#x27;re using UTF-8 locale to install LangChain</span>
<span class="hljs-keyword">import</span> locale

locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>`,wrap:!1}}),_=new f({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGxhbmdjaGFpbg==",highlighted:"!pip install -q langchain",wrap:!1}}),k=new gt({props:{title:"准备数据",local:"准备数据",headingTag:"h2"}}),H=new f({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBJTBBQUNDRVNTX1RPS0VOJTIwJTNEJTIwZ2V0cGFzcyglMjJZT1VSX0dJVEhVQl9QRVJTT05BTF9UT0tFTiUyMik=",highlighted:`<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass

ACCESS_TOKEN = getpass(<span class="hljs-string">&quot;YOUR_GITHUB_PERSONAL_TOKEN&quot;</span>)`,wrap:!1}}),V=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2N1bWVudF9sb2FkZXJzJTIwaW1wb3J0JTIwR2l0SHViSXNzdWVzTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwR2l0SHViSXNzdWVzTG9hZGVyKHJlcG8lM0QlMjJodWdnaW5nZmFjZSUyRnBlZnQlMjIlMkMlMjBhY2Nlc3NfdG9rZW4lM0RBQ0NFU1NfVE9LRU4lMkMlMjBpbmNsdWRlX3BycyUzREZhbHNlJTJDJTIwc3RhdGUlM0QlMjJhbGwlMjIpJTBBJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.document_loaders <span class="hljs-keyword">import</span> GitHubIssuesLoader

loader = GitHubIssuesLoader(repo=<span class="hljs-string">&quot;huggingface/peft&quot;</span>, access_token=ACCESS_TOKEN, include_prs=<span class="hljs-literal">False</span>, state=<span class="hljs-string">&quot;all&quot;</span>)

docs = loader.load()`,wrap:!1}}),L=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBc3BsaXR0ZXIlMjAlM0QlMjBDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUxMiUyQyUyMGNodW5rX292ZXJsYXAlM0QzMCklMEElMEFjaHVua2VkX2RvY3MlMjAlM0QlMjBzcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> CharacterTextSplitter

splitter = CharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">30</span>)

chunked_docs = splitter.split_documents(docs)`,wrap:!1}}),z=new gt({props:{title:"创建嵌入和检索器",local:"创建嵌入和检索器",headingTag:"h2"}}),A=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW4uZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQSUwQWRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoY2h1bmtlZF9kb2NzJTJDJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLWJhc2UtZW4tdjEuNSUyMikp",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

db = FAISS.from_documents(chunked_docs, HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>))`,wrap:!1}}),K=new f({props:{code:"cmV0cmlldmVyJTIwJTNEJTIwZGIuYXNfcmV0cmlldmVyKHNlYXJjaF90eXBlJTNEJTIyc2ltaWxhcml0eSUyMiUyQyUyMHNlYXJjaF9rd2FyZ3MlM0QlN0IlMjJrJTIyJTNBJTIwNCU3RCk=",highlighted:'retriever = db.as_retriever(search_type=<span class="hljs-string">&quot;similarity&quot;</span>, search_kwargs={<span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">4</span>})',wrap:!1}}),tt=new gt({props:{title:"加载量化模型",local:"加载量化模型",headingTag:"h2"}}),nt=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiUwQSUwQWJuYl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9jb25maWcpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>, bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)`,wrap:!1}}),at=new gt({props:{title:"设置 LLM 链",local:"设置-llm-链",headingTag:"h2"}}),ot=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5sbG1zJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VQaXBlbGluZSUwQWZyb20lMjBsYW5nY2hhaW4ucHJvbXB0cyUyMGltcG9ydCUyMFByb21wdFRlbXBsYXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm91dHB1dF9wYXJzZXJzJTIwaW1wb3J0JTIwU3RyT3V0cHV0UGFyc2VyJTBBJTBBdGV4dF9nZW5lcmF0aW9uX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDAwJTJDJTBBKSUwQSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlUGlwZWxpbmUocGlwZWxpbmUlM0R0ZXh0X2dlbmVyYXRpb25fcGlwZWxpbmUpJTBBJTBBcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIyJTIyJTBBJTNDJTdDc3lzdGVtJTdDJTNFJTBBQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb24lMjBiYXNlZCUyMG9uJTIweW91ciUyMGtub3dsZWRnZS4lMjBVc2UlMjB0aGUlMjBmb2xsb3dpbmclMjBjb250ZXh0JTIwdG8lMjBoZWxwJTNBJTBBJTBBJTdCY29udGV4dCU3RCUwQSUwQSUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBJTdCcXVlc3Rpb24lN0QlMEElM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBJTBBJTIwJTIyJTIyJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwaW5wdXRfdmFyaWFibGVzJTNEJTVCJTIyY29udGV4dCUyMiUyQyUyMCUyMnF1ZXN0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0Rwcm9tcHRfdGVtcGxhdGUlMkMlMEEpJTBBJTBBbGxtX2NoYWluJTIwJTNEJTIwcHJvbXB0JTIwJTdDJTIwbGxtJTIwJTdDJTIwU3RyT3V0cHV0UGFyc2VyKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">400</span>,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
&lt;|system|&gt;
Answer the question based on your knowledge. Use the following context to help:

{context}

&lt;/s&gt;
&lt;|user|&gt;
{question}
&lt;/s&gt;
&lt;|assistant|&gt;

 &quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)

llm_chain = prompt | llm | StrOutputParser()`,wrap:!1}}),rt=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLnJ1bm5hYmxlcyUyMGltcG9ydCUyMFJ1bm5hYmxlUGFzc3Rocm91Z2glMEElMEFyZXRyaWV2ZXIlMjAlM0QlMjBkYi5hc19yZXRyaWV2ZXIoKSUwQSUwQXJhZ19jaGFpbiUyMCUzRCUyMCU3QiUyMmNvbnRleHQlMjIlM0ElMjByZXRyaWV2ZXIlMkMlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMFJ1bm5hYmxlUGFzc3Rocm91Z2goKSU3RCUyMCU3QyUyMGxsbV9jaGFpbg==",highlighted:`<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough

retriever = db.as_retriever()

rag_chain = {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()} | llm_chain`,wrap:!1}}),Mt=new gt({props:{title:"比较结果",local:"比较结果",headingTag:"h2"}}),ft=new f({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJIb3clMjBkbyUyMHlvdSUyMGNvbWJpbmUlMjBtdWx0aXBsZSUyMGFkYXB0ZXJzJTNGJTIy",highlighted:'question = <span class="hljs-string">&quot;How do you combine multiple adapters?&quot;</span>',wrap:!1}}),Tt=new f({props:{code:"bGxtX2NoYWluLmludm9rZSglN0IlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiU3RCk=",highlighted:'llm_chain.invoke({<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>: question})',wrap:!1}}),ht=new f({props:{code:"cmFnX2NoYWluLmludm9rZShxdWVzdGlvbik=",highlighted:"rag_chain.invoke(question)",wrap:!1}}),{c(){J=p("meta"),jt=n(),Ut=p("p"),Ct=n(),o(T.$$.fragment),Gt=n(),o(c.$$.fragment),xt=n(),h=p("p"),h.innerHTML=Ie,Bt=n(),d=p("p"),d.innerHTML=Re,vt=n(),w=p("p"),w.innerHTML=He,Zt=n(),g=p("p"),g.textContent=Xe,_t=n(),U=p("p"),U.textContent=We,kt=n(),$=p("p"),$.innerHTML=Ve,It=n(),j=p("p"),j.textContent=Ne,Rt=n(),C=p("p"),C.innerHTML=Fe,Ht=n(),G=p("ul"),G.innerHTML=Se,Xt=n(),x=p("p"),x.textContent=Le,Wt=n(),B=p("p"),B.textContent=ze,Vt=n(),o(v.$$.fragment),Nt=n(),o(Z.$$.fragment),Ft=n(),o(_.$$.fragment),St=n(),o(k.$$.fragment),Lt=n(),I=p("p"),I.innerHTML=Ee,zt=n(),R=p("p"),R.innerHTML=Qe,Et=n(),o(H.$$.fragment),Qt=n(),X=p("p"),X.innerHTML=Ye,Yt=n(),W=p("ul"),W.innerHTML=qe,qt=n(),o(V.$$.fragment),At=n(),N=p("p"),N.textContent=Ae,Pt=n(),F=p("p"),F.textContent=Pe,Dt=n(),S=p("p"),S.textContent=De,Kt=n(),o(L.$$.fragment),Ot=n(),o(z.$$.fragment),te=n(),E=p("p"),E.textContent=Ke,ee=n(),Q=p("p"),Q.innerHTML=Oe,le=n(),Y=p("p"),Y.innerHTML=tl,se=n(),q=p("p"),q.textContent=el,ne=n(),o(A.$$.fragment),ae=n(),P=p("p"),P.innerHTML=ll,pe=n(),D=p("ul"),D.innerHTML=sl,ie=n(),o(K.$$.fragment),me=n(),O=p("p"),O.textContent=nl,oe=n(),o(tt.$$.fragment),ue=n(),et=p("p"),et.innerHTML=al,be=n(),lt=p("p"),lt.innerHTML=pl,re=n(),st=p("p"),st.textContent=il,Me=n(),o(nt.$$.fragment),ye=n(),o(at.$$.fragment),fe=n(),pt=p("p"),pt.textContent=ml,Je=n(),it=p("p"),it.textContent=ol,Te=n(),mt=p("p"),mt.textContent=ul,ce=n(),o(ot.$$.fragment),he=n(),ut=p("p"),ut.innerHTML=bl,de=n(),bt=p("p"),bt.textContent=rl,we=n(),o(rt.$$.fragment),ge=n(),o(Mt.$$.fragment),Ue=n(),yt=p("p"),yt.textContent=Ml,$e=n(),o(ft.$$.fragment),je=n(),Jt=p("p"),Jt.textContent=yl,Ce=n(),o(Tt.$$.fragment),Ge=n(),ct=p("p"),ct.textContent=fl,xe=n(),o(ht.$$.fragment),Be=n(),dt=p("p"),dt.textContent=Jl,ve=n(),wt=p("p"),wt.textContent=Tl,Ze=n(),$t=p("p"),this.h()},l(t){const e=jl("svelte-u9bgzb",document.head);J=i(e,"META",{name:!0,content:!0}),e.forEach(l),jt=a(t),Ut=i(t,"P",{}),cl(Ut).forEach(l),Ct=a(t),u(T.$$.fragment,t),Gt=a(t),u(c.$$.fragment,t),xt=a(t),h=i(t,"P",{"data-svelte-h":!0}),m(h)!=="svelte-1dsumsc"&&(h.innerHTML=Ie),Bt=a(t),d=i(t,"P",{"data-svelte-h":!0}),m(d)!=="svelte-1nxrv0b"&&(d.innerHTML=Re),vt=a(t),w=i(t,"P",{"data-svelte-h":!0}),m(w)!=="svelte-15ot3ve"&&(w.innerHTML=He),Zt=a(t),g=i(t,"P",{"data-svelte-h":!0}),m(g)!=="svelte-11u8woo"&&(g.textContent=Xe),_t=a(t),U=i(t,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1fwpup0"&&(U.textContent=We),kt=a(t),$=i(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-2xs5eo"&&($.innerHTML=Ve),It=a(t),j=i(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-2l10hj"&&(j.textContent=Ne),Rt=a(t),C=i(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1c1z86r"&&(C.innerHTML=Fe),Ht=a(t),G=i(t,"UL",{"data-svelte-h":!0}),m(G)!=="svelte-1cd3ng1"&&(G.innerHTML=Se),Xt=a(t),x=i(t,"P",{"data-svelte-h":!0}),m(x)!=="svelte-nhx78j"&&(x.textContent=Le),Wt=a(t),B=i(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-10677r8"&&(B.textContent=ze),Vt=a(t),u(v.$$.fragment,t),Nt=a(t),u(Z.$$.fragment,t),Ft=a(t),u(_.$$.fragment,t),St=a(t),u(k.$$.fragment,t),Lt=a(t),I=i(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1f0miko"&&(I.innerHTML=Ee),zt=a(t),R=i(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1fd32v"&&(R.innerHTML=Qe),Et=a(t),u(H.$$.fragment,t),Qt=a(t),X=i(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1hkyu0j"&&(X.innerHTML=Ye),Yt=a(t),W=i(t,"UL",{"data-svelte-h":!0}),m(W)!=="svelte-1a0rln0"&&(W.innerHTML=qe),qt=a(t),u(V.$$.fragment,t),At=a(t),N=i(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-ryc3lv"&&(N.textContent=Ae),Pt=a(t),F=i(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-s0tphm"&&(F.textContent=Pe),Dt=a(t),S=i(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1ir96rw"&&(S.textContent=De),Kt=a(t),u(L.$$.fragment,t),Ot=a(t),u(z.$$.fragment,t),te=a(t),E=i(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-frdo0o"&&(E.textContent=Ke),ee=a(t),Q=i(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1cfgvps"&&(Q.innerHTML=Oe),le=a(t),Y=i(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-x85d74"&&(Y.innerHTML=tl),se=a(t),q=i(t,"P",{"data-svelte-h":!0}),m(q)!=="svelte-9ffz7p"&&(q.textContent=el),ne=a(t),u(A.$$.fragment,t),ae=a(t),P=i(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-xex2hi"&&(P.innerHTML=ll),pe=a(t),D=i(t,"UL",{"data-svelte-h":!0}),m(D)!=="svelte-4jbas3"&&(D.innerHTML=sl),ie=a(t),u(K.$$.fragment,t),me=a(t),O=i(t,"P",{"data-svelte-h":!0}),m(O)!=="svelte-5nilxz"&&(O.textContent=nl),oe=a(t),u(tt.$$.fragment,t),ue=a(t),et=i(t,"P",{"data-svelte-h":!0}),m(et)!=="svelte-df64rt"&&(et.innerHTML=al),be=a(t),lt=i(t,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-1yhmn0n"&&(lt.innerHTML=pl),re=a(t),st=i(t,"P",{"data-svelte-h":!0}),m(st)!=="svelte-jk1sm8"&&(st.textContent=il),Me=a(t),u(nt.$$.fragment,t),ye=a(t),u(at.$$.fragment,t),fe=a(t),pt=i(t,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-oeo873"&&(pt.textContent=ml),Je=a(t),it=i(t,"P",{"data-svelte-h":!0}),m(it)!=="svelte-if5n97"&&(it.textContent=ol),Te=a(t),mt=i(t,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-1a017u5"&&(mt.textContent=ul),ce=a(t),u(ot.$$.fragment,t),he=a(t),ut=i(t,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-kibc99"&&(ut.innerHTML=bl),de=a(t),bt=i(t,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-18onexw"&&(bt.textContent=rl),we=a(t),u(rt.$$.fragment,t),ge=a(t),u(Mt.$$.fragment,t),Ue=a(t),yt=i(t,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-1hik170"&&(yt.textContent=Ml),$e=a(t),u(ft.$$.fragment,t),je=a(t),Jt=i(t,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-gn3i6x"&&(Jt.textContent=yl),Ce=a(t),u(Tt.$$.fragment,t),Ge=a(t),ct=i(t,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-15qdncx"&&(ct.textContent=fl),xe=a(t),u(ht.$$.fragment,t),Be=a(t),dt=i(t,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-11ic9g3"&&(dt.textContent=Jl),ve=a(t),wt=i(t,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-gcl5gb"&&(wt.textContent=Tl),Ze=a(t),$t=i(t,"P",{}),cl($t).forEach(l),this.h()},h(){hl(J,"name","hf:doc:metadata"),hl(J,"content",Bl)},m(t,e){Cl(document.head,J),s(t,jt,e),s(t,Ut,e),s(t,Ct,e),b(T,t,e),s(t,Gt,e),b(c,t,e),s(t,xt,e),s(t,h,e),s(t,Bt,e),s(t,d,e),s(t,vt,e),s(t,w,e),s(t,Zt,e),s(t,g,e),s(t,_t,e),s(t,U,e),s(t,kt,e),s(t,$,e),s(t,It,e),s(t,j,e),s(t,Rt,e),s(t,C,e),s(t,Ht,e),s(t,G,e),s(t,Xt,e),s(t,x,e),s(t,Wt,e),s(t,B,e),s(t,Vt,e),b(v,t,e),s(t,Nt,e),b(Z,t,e),s(t,Ft,e),b(_,t,e),s(t,St,e),b(k,t,e),s(t,Lt,e),s(t,I,e),s(t,zt,e),s(t,R,e),s(t,Et,e),b(H,t,e),s(t,Qt,e),s(t,X,e),s(t,Yt,e),s(t,W,e),s(t,qt,e),b(V,t,e),s(t,At,e),s(t,N,e),s(t,Pt,e),s(t,F,e),s(t,Dt,e),s(t,S,e),s(t,Kt,e),b(L,t,e),s(t,Ot,e),b(z,t,e),s(t,te,e),s(t,E,e),s(t,ee,e),s(t,Q,e),s(t,le,e),s(t,Y,e),s(t,se,e),s(t,q,e),s(t,ne,e),b(A,t,e),s(t,ae,e),s(t,P,e),s(t,pe,e),s(t,D,e),s(t,ie,e),b(K,t,e),s(t,me,e),s(t,O,e),s(t,oe,e),b(tt,t,e),s(t,ue,e),s(t,et,e),s(t,be,e),s(t,lt,e),s(t,re,e),s(t,st,e),s(t,Me,e),b(nt,t,e),s(t,ye,e),b(at,t,e),s(t,fe,e),s(t,pt,e),s(t,Je,e),s(t,it,e),s(t,Te,e),s(t,mt,e),s(t,ce,e),b(ot,t,e),s(t,he,e),s(t,ut,e),s(t,de,e),s(t,bt,e),s(t,we,e),b(rt,t,e),s(t,ge,e),b(Mt,t,e),s(t,Ue,e),s(t,yt,e),s(t,$e,e),b(ft,t,e),s(t,je,e),s(t,Jt,e),s(t,Ce,e),b(Tt,t,e),s(t,Ge,e),s(t,ct,e),s(t,xe,e),b(ht,t,e),s(t,Be,e),s(t,dt,e),s(t,ve,e),s(t,wt,e),s(t,Ze,e),s(t,$t,e),_e=!0},p:wl,i(t){_e||(r(T.$$.fragment,t),r(c.$$.fragment,t),r(v.$$.fragment,t),r(Z.$$.fragment,t),r(_.$$.fragment,t),r(k.$$.fragment,t),r(H.$$.fragment,t),r(V.$$.fragment,t),r(L.$$.fragment,t),r(z.$$.fragment,t),r(A.$$.fragment,t),r(K.$$.fragment,t),r(tt.$$.fragment,t),r(nt.$$.fragment,t),r(at.$$.fragment,t),r(ot.$$.fragment,t),r(rt.$$.fragment,t),r(Mt.$$.fragment,t),r(ft.$$.fragment,t),r(Tt.$$.fragment,t),r(ht.$$.fragment,t),_e=!0)},o(t){M(T.$$.fragment,t),M(c.$$.fragment,t),M(v.$$.fragment,t),M(Z.$$.fragment,t),M(_.$$.fragment,t),M(k.$$.fragment,t),M(H.$$.fragment,t),M(V.$$.fragment,t),M(L.$$.fragment,t),M(z.$$.fragment,t),M(A.$$.fragment,t),M(K.$$.fragment,t),M(tt.$$.fragment,t),M(nt.$$.fragment,t),M(at.$$.fragment,t),M(ot.$$.fragment,t),M(rt.$$.fragment,t),M(Mt.$$.fragment,t),M(ft.$$.fragment,t),M(Tt.$$.fragment,t),M(ht.$$.fragment,t),_e=!1},d(t){t&&(l(jt),l(Ut),l(Ct),l(Gt),l(xt),l(h),l(Bt),l(d),l(vt),l(w),l(Zt),l(g),l(_t),l(U),l(kt),l($),l(It),l(j),l(Rt),l(C),l(Ht),l(G),l(Xt),l(x),l(Wt),l(B),l(Vt),l(Nt),l(Ft),l(St),l(Lt),l(I),l(zt),l(R),l(Et),l(Qt),l(X),l(Yt),l(W),l(qt),l(At),l(N),l(Pt),l(F),l(Dt),l(S),l(Kt),l(Ot),l(te),l(E),l(ee),l(Q),l(le),l(Y),l(se),l(q),l(ne),l(ae),l(P),l(pe),l(D),l(ie),l(me),l(O),l(oe),l(ue),l(et),l(be),l(lt),l(re),l(st),l(Me),l(ye),l(fe),l(pt),l(Je),l(it),l(Te),l(mt),l(ce),l(he),l(ut),l(de),l(bt),l(we),l(ge),l(Ue),l(yt),l($e),l(je),l(Jt),l(Ce),l(Ge),l(ct),l(xe),l(Be),l(dt),l(ve),l(wt),l(Ze),l($t)),l(J),y(T,t),y(c,t),y(v,t),y(Z,t),y(_,t),y(k,t),y(H,t),y(V,t),y(L,t),y(z,t),y(A,t),y(K,t),y(tt,t),y(nt,t),y(at,t),y(ot,t),y(rt,t),y(Mt,t),y(ft,t),y(Tt,t),y(ht,t)}}}const Bl='{"title":"用 Hugging Face Zephyr 和 LangChain 针对 Github issues 构建简单的 RAG","local":"用-hugging-face-zephyr-和-langchain-针对-github-issues-构建简单的-rag","sections":[{"title":"准备数据","local":"准备数据","sections":[],"depth":2},{"title":"创建嵌入和检索器","local":"创建嵌入和检索器","sections":[],"depth":2},{"title":"加载量化模型","local":"加载量化模型","sections":[],"depth":2},{"title":"设置 LLM 链","local":"设置-llm-链","sections":[],"depth":2},{"title":"比较结果","local":"比较结果","sections":[],"depth":2}],"depth":1}';function vl(ke){return gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends Ul{constructor(J){super(),$l(this,J,vl,xl,dl,{})}}export{Rl as component};
