import{s as ut,n as yt,o as ft}from"../chunks/scheduler.db6b1edd.js";import{S as bt,i as Mt,g as i,s,r as c,A as xt,h as o,f as a,c as n,j as gt,u as h,x as p,k as at,y as Jt,a as l,v as m,d as g,t as u,w as y}from"../chunks/index.ef84021a.js";import{C as lt}from"../chunks/CodeBlock.786162a6.js";import{D as wt}from"../chunks/DocNotebookDropdown.84370fbf.js";import{H as et}from"../chunks/Heading.87f70b00.js";function jt(st){let r,H,G,z,f,A,b,F,M,nt="In the Quickstart, you were introduced to various endpoints for interacting with datasets on the Hub. One of the most useful ones is the <code>/parquet</code> endpoint, which allows you to get a dataset stored on the Hub and analyze it. This is a great way to explore the dataset, and get a better understanding of it’s contents.",Y,x,it="To demonstrate, this guide will show you an end-to-end example of how to retrieve a dataset from the Hub and do some basic data analysis with the Pandas library.",B,J,X,w,ot='The <a href="https://huggingface.co/datasets" rel="nofollow">Hub</a> is home to more than 40,000 datasets across a wide variety of tasks, sizes, and languages. For this example, you’ll use the <a href="https://huggingface.co/datasets/codeparrot/codecomplex" rel="nofollow"><code>codeparrot/codecomplex</code></a> dataset, but feel free to explore and find another dataset that interests you! The dataset contains Java code from programming competitions, and the time complexity of the code is labeled by a group of algorithm experts.',N,j,rt="Let’s say you’re interested in the average length of the submitted code as it relates to the time complexity. Here’s how you can get started.",V,T,pt="Use the <code>/parquet</code> endpoint to convert the dataset to a Parquet file and return the URL to it:",I,v,S,C,W,$,dt="With the URL, you can read the Parquet file into a Pandas DataFrame:",q,U,P,Z,ct='<thead><tr><th align="right">src</th> <th align="right">complexity</th> <th align="right">problem</th> <th align="right">from</th></tr></thead> <tbody><tr><td align="right">import java.io.*;\\nimport java.math.BigInteger…</td> <td align="right">quadratic</td> <td align="right">1179_B. Tolik and His Uncle</td> <td align="right">CODEFORCES</td></tr> <tr><td align="right">import java.util.Scanner;\\n \\npublic class pil…</td> <td align="right">linear</td> <td align="right">1197_B. Pillars</td> <td align="right">CODEFORCES</td></tr> <tr><td align="right">import java.io.BufferedReader;\\nimport java.io…</td> <td align="right">linear</td> <td align="right">1059_C. Sequence Transformation</td> <td align="right">CODEFORCES</td></tr> <tr><td align="right">import java.util.<em>;\\n\\nimport java.io.</em>;\\npubl…</td> <td align="right">linear</td> <td align="right">1011_A. Stages</td> <td align="right">CODEFORCES</td></tr> <tr><td align="right">import java.io.OutputStream;\\nimport java.io.I…</td> <td align="right">linear</td> <td align="right">1190_C. Tokitsukaze and Duel</td> <td align="right">CODEFORCES</td></tr></tbody>',Q,k,L,_,ht="Pandas is a powerful library for data analysis; group the dataset by time complexity, apply a function to calculate the average length of the code snippet, and plot the results:",D,R,O,d,mt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets-server/codecomplex.png"/>',K,E,tt;return f=new et({props:{title:"Analyze a dataset on the Hub",local:"analyze-a-dataset-on-the-hub",headingTag:"h1"}}),b=new wt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/datasets-server_doc/en/analyze_data.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/datasets-server_doc/en/pytorch/analyze_data.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/datasets-server_doc/en/tensorflow/analyze_data.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/datasets-server_doc/en/analyze_data.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/datasets-server_doc/en/pytorch/analyze_data.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/datasets-server_doc/en/tensorflow/analyze_data.ipynb"}]}}),J=new et({props:{title:"Get a dataset",local:"get-a-dataset",headingTag:"h2"}}),v=new lt({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFBUElfVVJMJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZkYXRhc2V0cy1zZXJ2ZXIuaHVnZ2luZ2ZhY2UuY28lMkZwYXJxdWV0JTNGZGF0YXNldCUzRGNvZGVwYXJyb3QlMkZjb2RlY29tcGxleCUyMiUwQWRlZiUyMHF1ZXJ5KCklM0ElMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldChBUElfVVJMKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNlLmpzb24oKSUwQWRhdGElMjAlM0QlMjBxdWVyeSgpJTBBcHJpbnQoZGF0YSklMEElN0IncGFycXVldF9maWxlcyclM0ElMjAlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0InZGF0YXNldCclM0ElMjAnY29kZXBhcnJvdCUyRmNvZGVjb21wbGV4JyUyQyUyMCdjb25maWcnJTNBJTIwJ2RlZmF1bHQnJTJDJTIwJ3NwbGl0JyUzQSUyMCd0cmFpbiclMkMlMjAndXJsJyUzQSUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZjb2RlcGFycm90JTJGY29kZWNvbXBsZXglMkZyZXNvbHZlJTJGcmVmcyUyNTJGY29udmVydCUyNTJGcGFycXVldCUyRmRlZmF1bHQlMkZ0cmFpbiUyRjAwMDAucGFycXVldCclMkMlMjAnZmlsZW5hbWUnJTNBJTIwJzAwMDAucGFycXVldCclMkMlMjAnc2l6ZSclM0ElMjA0MTE1OTA4JTdEJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTIwJTBBJTIwJ3BlbmRpbmcnJTNBJTIwJTVCJTVEJTJDJTIwJ2ZhaWxlZCclM0ElMjAlNUIlNUQlMkMlMjAncGFydGlhbCUzQSUyMGZhbHNlJTBBJTdE",highlighted:`<span class="hljs-keyword">import</span> requests
API_URL = <span class="hljs-string">&quot;https://datasets-server.huggingface.co/parquet?dataset=codeparrot/codecomplex&quot;</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>():
    response = requests.get(API_URL)
    <span class="hljs-keyword">return</span> response.json()
data = query()
<span class="hljs-built_in">print</span>(data)
{<span class="hljs-string">&#x27;parquet_files&#x27;</span>: 
    [
        {<span class="hljs-string">&#x27;dataset&#x27;</span>: <span class="hljs-string">&#x27;codeparrot/codecomplex&#x27;</span>, <span class="hljs-string">&#x27;config&#x27;</span>: <span class="hljs-string">&#x27;default&#x27;</span>, <span class="hljs-string">&#x27;split&#x27;</span>: <span class="hljs-string">&#x27;train&#x27;</span>, <span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;https://huggingface.co/datasets/codeparrot/codecomplex/resolve/refs%2Fconvert%2Fparquet/default/train/0000.parquet&#x27;</span>, <span class="hljs-string">&#x27;filename&#x27;</span>: <span class="hljs-string">&#x27;0000.parquet&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>: <span class="hljs-number">4115908</span>}
    ], 
 <span class="hljs-string">&#x27;pending&#x27;</span>: [], <span class="hljs-string">&#x27;failed&#x27;</span>: [], <span class="hljs-string">&#x27;partial: false
}</span>`,wrap:!1}}),C=new et({props:{title:"Read dataset with Pandas",local:"read-dataset-with-pandas",headingTag:"h2"}}),U=new lt({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmNvZGVwYXJyb3QlMkZjb2RlY29tcGxleCUyRnJlc29sdmUlMkZyZWZzJTI1MkZjb252ZXJ0JTI1MkZwYXJxdWV0JTJGZGVmYXVsdCUyRnRyYWluJTJGMDAwMC5wYXJxdWV0JTIyJTBBZGYlMjAlM0QlMjBwZC5yZWFkX3BhcnF1ZXQodXJsKSUwQWRmLmhlYWQoNSk=",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/codeparrot/codecomplex/resolve/refs%2Fconvert%2Fparquet/default/train/0000.parquet&quot;</span>
df = pd.read_parquet(url)
df.head(<span class="hljs-number">5</span>)`,wrap:!1}}),k=new et({props:{title:"Calculate mean code length by time complexity",local:"calculate-mean-code-length-by-time-complexity",headingTag:"h2"}}),R=new lt({props:{code:"ZGYuZ3JvdXBieSgnY29tcGxleGl0eScpJTVCJ3NyYyclNUQuYXBwbHkobGFtYmRhJTIweCUzQSUyMHguc3RyLmxlbigpLm1lYW4oKSkuc29ydF92YWx1ZXMoYXNjZW5kaW5nJTNERmFsc2UpLnBsb3QuYmFyaChjb2xvciUzRCUyMm9yYW5nZSUyMik=",highlighted:'df.groupby(<span class="hljs-string">&#x27;complexity&#x27;</span>)[<span class="hljs-string">&#x27;src&#x27;</span>].apply(<span class="hljs-keyword">lambda</span> x: x.<span class="hljs-built_in">str</span>.<span class="hljs-built_in">len</span>().mean()).sort_values(ascending=<span class="hljs-literal">False</span>).plot.barh(color=<span class="hljs-string">&quot;orange&quot;</span>)',wrap:!1}}),{c(){r=i("meta"),H=s(),G=i("p"),z=s(),c(f.$$.fragment),A=s(),c(b.$$.fragment),F=s(),M=i("p"),M.innerHTML=nt,Y=s(),x=i("p"),x.textContent=it,B=s(),c(J.$$.fragment),X=s(),w=i("p"),w.innerHTML=ot,N=s(),j=i("p"),j.textContent=rt,V=s(),T=i("p"),T.innerHTML=pt,I=s(),c(v.$$.fragment),S=s(),c(C.$$.fragment),W=s(),$=i("p"),$.textContent=dt,q=s(),c(U.$$.fragment),P=s(),Z=i("table"),Z.innerHTML=ct,Q=s(),c(k.$$.fragment),L=s(),_=i("p"),_.textContent=ht,D=s(),c(R.$$.fragment),O=s(),d=i("div"),d.innerHTML=mt,K=s(),E=i("p"),this.h()},l(t){const e=xt("svelte-u9bgzb",document.head);r=o(e,"META",{name:!0,content:!0}),e.forEach(a),H=n(t),G=o(t,"P",{}),gt(G).forEach(a),z=n(t),h(f.$$.fragment,t),A=n(t),h(b.$$.fragment,t),F=n(t),M=o(t,"P",{"data-svelte-h":!0}),p(M)!=="svelte-1azbnlv"&&(M.innerHTML=nt),Y=n(t),x=o(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-ex80rz"&&(x.textContent=it),B=n(t),h(J.$$.fragment,t),X=n(t),w=o(t,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1h57uot"&&(w.innerHTML=ot),N=n(t),j=o(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-nzg195"&&(j.textContent=rt),V=n(t),T=o(t,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1e6p8nz"&&(T.innerHTML=pt),I=n(t),h(v.$$.fragment,t),S=n(t),h(C.$$.fragment,t),W=n(t),$=o(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-10uozo5"&&($.textContent=dt),q=n(t),h(U.$$.fragment,t),P=n(t),Z=o(t,"TABLE",{"data-svelte-h":!0}),p(Z)!=="svelte-lqg1es"&&(Z.innerHTML=ct),Q=n(t),h(k.$$.fragment,t),L=n(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-eoewpk"&&(_.textContent=ht),D=n(t),h(R.$$.fragment,t),O=n(t),d=o(t,"DIV",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-3dvwc"&&(d.innerHTML=mt),K=n(t),E=o(t,"P",{}),gt(E).forEach(a),this.h()},h(){at(r,"name","hf:doc:metadata"),at(r,"content",Tt),at(d,"class","flex justify-center")},m(t,e){Jt(document.head,r),l(t,H,e),l(t,G,e),l(t,z,e),m(f,t,e),l(t,A,e),m(b,t,e),l(t,F,e),l(t,M,e),l(t,Y,e),l(t,x,e),l(t,B,e),m(J,t,e),l(t,X,e),l(t,w,e),l(t,N,e),l(t,j,e),l(t,V,e),l(t,T,e),l(t,I,e),m(v,t,e),l(t,S,e),m(C,t,e),l(t,W,e),l(t,$,e),l(t,q,e),m(U,t,e),l(t,P,e),l(t,Z,e),l(t,Q,e),m(k,t,e),l(t,L,e),l(t,_,e),l(t,D,e),m(R,t,e),l(t,O,e),l(t,d,e),l(t,K,e),l(t,E,e),tt=!0},p:yt,i(t){tt||(g(f.$$.fragment,t),g(b.$$.fragment,t),g(J.$$.fragment,t),g(v.$$.fragment,t),g(C.$$.fragment,t),g(U.$$.fragment,t),g(k.$$.fragment,t),g(R.$$.fragment,t),tt=!0)},o(t){u(f.$$.fragment,t),u(b.$$.fragment,t),u(J.$$.fragment,t),u(v.$$.fragment,t),u(C.$$.fragment,t),u(U.$$.fragment,t),u(k.$$.fragment,t),u(R.$$.fragment,t),tt=!1},d(t){t&&(a(H),a(G),a(z),a(A),a(F),a(M),a(Y),a(x),a(B),a(X),a(w),a(N),a(j),a(V),a(T),a(I),a(S),a(W),a($),a(q),a(P),a(Z),a(Q),a(L),a(_),a(D),a(O),a(d),a(K),a(E)),a(r),y(f,t),y(b,t),y(J,t),y(v,t),y(C,t),y(U,t),y(k,t),y(R,t)}}}const Tt='{"title":"Analyze a dataset on the Hub","local":"analyze-a-dataset-on-the-hub","sections":[{"title":"Get a dataset","local":"get-a-dataset","sections":[],"depth":2},{"title":"Read dataset with Pandas","local":"read-dataset-with-pandas","sections":[],"depth":2},{"title":"Calculate mean code length by time complexity","local":"calculate-mean-code-length-by-time-complexity","sections":[],"depth":2}],"depth":1}';function vt(st){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends bt{constructor(r){super(),Mt(this,r,vt,jt,ut,{})}}export{_t as component};
