import{s as cl,o as ml,n as Wi}from"../chunks/scheduler.182ea377.js";import{S as hl,i as gl,g as h,s as n,r as a,A as ul,h as g,f as l,c as o,j as Se,u as r,x as y,k as Ie,y as w,a as t,v as f,d,t as p,w as c,m as dl,n as pl}from"../chunks/index.abf12888.js";import{T as Ci}from"../chunks/Tip.230e2334.js";import{D as vi}from"../chunks/Docstring.81ce6c10.js";import{C as T}from"../chunks/CodeBlock.57fe6e13.js";import{E as fl}from"../chunks/ExampleCodeBlock.6db7157e.js";import{H as J,E as bl}from"../chunks/EditOnGithub.9b8e78e4.js";function yl(U){let s,u='To learn more about how to load single file weights, see the <a href="../../using-diffusers/other-formats">Load different Stable Diffusion formats</a> loading guide.';return{c(){s=h("p"),s.innerHTML=u},l(m){s=g(m,"P",{"data-svelte-h":!0}),y(s)!=="svelte-1d80t6b"&&(s.innerHTML=u)},m(m,b){t(m,s,b)},p:Wi,d(m){m&&l(s)}}}function _l(U){let s;return{c(){s=dl("Disabling symlinking means that the `huggingface_hub` caching mechanism has no way to determine whether a file has already been downloaded to the local directory. This means that the `hf_hub_download` and `snapshot_download` functions will download files to the local directory each time they are executed. If you are disabling symlinking, it is recommended that you separate the model download and loading steps to avoid downloading the same file multiple times.")},l(u){s=pl(u,"Disabling symlinking means that the `huggingface_hub` caching mechanism has no way to determine whether a file has already been downloaded to the local directory. This means that the `hf_hub_download` and `snapshot_download` functions will download files to the local directory each time they are executed. If you are disabling symlinking, it is recommended that you separate the model download and loading steps to avoid downloading the same file multiple times.")},m(u,m){t(u,s,m)},d(u){u&&l(s)}}}function Ml(U){let s,u,m="This is not as reliable as providing a path to a local config repo and might lead to errors when configuring the pipeline. To avoid this, please run the pipeline with <code>local_files_only=False</code> once to download the appropriate pipeline config files to the local cache.";return{c(){s=dl("When using `original_config` with local_files_only=True`, Diffusers will attempt to infer the components based on the type signatures of pipeline class, rather than attempting to fetch the pipeline config from the Hugging Face Hub. This is to prevent backwards breaking changes in existing code that might not be able to connect to the internet to fetch the necessary pipeline config files.\n"),u=h("p"),u.innerHTML=m},l(b){s=pl(b,"When using `original_config` with local_files_only=True`, Diffusers will attempt to infer the components based on the type signatures of pipeline class, rather than attempting to fetch the pipeline config from the Hugging Face Hub. This is to prevent backwards breaking changes in existing code that might not be able to connect to the internet to fetch the necessary pipeline config files.\n"),u=g(b,"P",{"data-svelte-h":!0}),y(u)!=="svelte-1esmfzh"&&(u.innerHTML=m)},m(b,M){t(b,s,M),t(b,u,M)},p:Wi,d(b){b&&(l(s),l(u))}}}function wl(U){let s,u="Examples:",m,b,M;return b=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyKSUwQSUwQSUyMyUyMEVuYWJsZSUyMGZsb2F0MTYlMjBhbmQlMjBtb3ZlJTIwdG8lMjBHUFUlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGYmxvYiUyRm1haW4lMkZ2MS01LXBydW5lZC1lbWFvbmx5LmNrcHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly.ckpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){s=h("p"),s.textContent=u,m=n(),a(b.$$.fragment)},l(_){s=g(_,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=u),m=o(_),r(b.$$.fragment,_)},m(_,$){t(_,s,$),t(_,m,$),f(b,_,$),M=!0},p:Wi,i(_){M||(d(b.$$.fragment,_),M=!0)},o(_){p(b.$$.fragment,_),M=!1},d(_){_&&(l(s),l(m)),c(b,_)}}}function Jl(U){let s,u;return s=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZUNhc2NhZGVVTmV0JTBBJTBBY2twdF9wYXRoJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWNhc2NhZGUlMkZibG9iJTJGbWFpbiUyRnN0YWdlX2JfbGl0ZS5zYWZldGVuc29ycyUyMiUwQW1vZGVsJTIwJTNEJTIwU3RhYmxlQ2FzY2FkZVVOZXQuZnJvbV9zaW5nbGVfZmlsZShja3B0X3BhdGgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableCascadeUNet

<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-cascade/blob/main/stage_b_lite.safetensors&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = StableCascadeUNet.from_single_file(ckpt_path)`,wrap:!1}}),{c(){a(s.$$.fragment)},l(m){r(s.$$.fragment,m)},m(m,b){f(s,m,b),u=!0},p:Wi,i(m){u||(d(s.$$.fragment,m),u=!0)},o(m){p(s.$$.fragment,m),u=!1},d(m){c(s,m)}}}function Tl(U){let s,u,m,b,M,_,$,Li="The <code>from_single_file</code> method allows you to load supported pipelines using a single checkpoint file as opposed to the folder format used by Diffusers. This is useful if you are working with many of the Stable Diffusion Web UI’s (such as A1111) that extensively rely on a single file to distribute all the components of a diffusion model.",Be,N,Ei="The <code>from_single_file</code> method also supports loading models in their originally distributed format. This means that supported models that have been finetuned with other services can be loaded directly into supported Diffusers model objects and pipelines.",Ye,X,Ne,C,Hi='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline">StableDiffusionInpaintPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetImg2ImgPipeline">StableDiffusionControlNetImg2ImgPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetInpaintPipeline">StableDiffusionControlNetInpaintPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.StableDiffusionUpscalePipeline">StableDiffusionUpscalePipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline">StableDiffusionXLImg2ImgPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline">StableDiffusionXLInpaintPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/pix2pix#diffusers.StableDiffusionXLInstructPix2PixPipeline">StableDiffusionXLInstructPix2PixPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/k_diffusion#diffusers.StableDiffusionXLKDiffusionPipeline">StableDiffusionXLKDiffusionPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline">LatentConsistencyModelPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelImg2ImgPipeline">LatentConsistencyModelImg2ImgPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnetxs#diffusers.StableDiffusionControlNetXSPipeline">StableDiffusionControlNetXSPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnetxs_sdxl#diffusers.StableDiffusionXLControlNetXSPipeline">StableDiffusionXLControlNetXSPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/ledits_pp#diffusers.LEditsPPPipelineStableDiffusion">LEditsPPPipelineStableDiffusion</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/ledits_pp#diffusers.LEditsPPPipelineStableDiffusionXL">LEditsPPPipelineStableDiffusionXL</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/pia#diffusers.PIAPipeline">PIAPipeline</a></li>',Xe,L,Ce,E,Vi='<li><a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a></li> <li><code>StableCascadeUNet</code></li> <li><a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a></li> <li><a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a></li>',Le,H,Ee,V,He,D,Ve,P,De,q,Di="Swap components of the pipeline by passing them directly to the <code>from_single_file</code> method. e.g If you would like use a different scheduler than the pipeline default.",Pe,Q,qe,z,Qe,A,ze,O,Ae,K,Oe,ee,Pi="Under the hood, <code>from_single_file</code> will try to determine a model repository to use to configure the components of the pipeline. You can also pass in a repository id to the <code>config</code> argument of the <code>from_single_file</code> method to explicitly set the repository to use.",Ke,ie,ei,le,ii,te,qi="Override the default model or pipeline configuration options when using <code>from_single_file</code> by passing in the relevant arguments directly to the <code>from_single_file</code> method. Any argument that is supported by the model or pipeline class can be configured in this way:",li,ne,ti,oe,ni,se,Qi='In the example above, since we explicitly passed <code>repo_id=&quot;segmind/SSD-1B&quot;</code>, it will use this <a href="https://huggingface.co/segmind/SSD-1B/blob/main/unet/config.json" rel="nofollow">configuration file</a> from the “unet” subfolder in <code>&quot;segmind/SSD-1B&quot;</code> to configure the unet component included in the checkpoint; Similarly, it will use the <code>config.json</code> file from <code>&quot;vae&quot;</code> subfolder to configure the vae model, <code>config.json</code> file from text_encoder folder to configure text_encoder and so on.',oi,ae,zi="Note that most of the time you do not need to explicitly a <code>config</code> argument, <code>from_single_file</code> will automatically map the checkpoint to a repo id (we will discuss this in more details in next section). However, this can be useful in cases where model components might have been changed from what was originally distributed or in cases where a checkpoint file might not have the necessary metadata to correctly determine the configuration to use for the pipeline.",si,S,ai,re,ri,fe,Ai='As of <code>diffusers&gt;=0.28.0</code> the <code>from_single_file</code> method will attempt to configure a pipeline or model by first inferring the model type from the checkpoint file and then using the model type to determine the appropriate model repo configuration to use from the Hugging Face Hub. For example, any single file checkpoint based on the Stable Diffusion XL base model will use the <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow"><code>stabilityai/stable-diffusion-xl-base-1.0</code></a> model repo to configure the pipeline.',fi,de,Oi="If you are working in an environment with restricted internet access, it is recommended to download the config files and checkpoints for the model to your preferred directory and pass the local paths to the <code>pretrained_model_link_or_path</code> and <code>config</code> arguments of the <code>from_single_file</code> method.",di,pe,pi,ce,Ki='By default this will download the checkpoints and config files to the <a href="https://huggingface.co/docs/huggingface_hub/en/guides/manage-cache" rel="nofollow">Hugging Face Hub cache directory</a>. You can also specify a local directory to download the files to by passing the <code>local_dir</code> argument to the <code>hf_hub_download</code> and <code>snapshot_download</code> functions.',ci,me,mi,he,hi,ge,el="By default the <code>from_single_file</code> method relies on the <code>huggingface_hub</code> caching mechanism to fetch and store checkpoints and config files for models and pipelines. If you are working with a file system that does not support symlinking, it is recommended that you first download the checkpoint file to a local directory and disable symlinking by passing the <code>local_dir_use_symlink=False</code> argument to the <code>hf_hub_download</code> and <code>snapshot_download</code> functions.",gi,ue,ui,be,il="Then pass the local paths to the <code>pretrained_model_link_or_path</code> and <code>config</code> arguments of the <code>from_single_file</code> method.",bi,ye,yi,I,_i,_e,Mi,Me,ll="If you would like to configure the parameters of the model components in the pipeline using the orignal YAML configuration file, you can pass a local path or url to the original configuration file to the <code>original_config</code> argument of the <code>from_single_file</code> method.",wi,we,Ji,Je,tl="In the example above, the <code>original_config</code> file is only used to configure the parameters of the individual model components of the pipeline. For example it will be used to configure parameters such as the <code>in_channels</code> of the <code>vae</code> model and <code>unet</code> model. It is not used to determine the type of component objects in the pipeline.",Ti,R,Ui,Te,$i,Z,Ue,Fi,ke,nl='Load model weights saved in the <code>.ckpt</code> format into a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',Si,j,$e,Ii,ve,ol=`Instantiate a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,Ri,B,Zi,Ze,xi,x,xe,Bi,We,sl="Load pretrained weights saved in the <code>.ckpt</code> or <code>.safetensors</code> format into a model.",Yi,G,je,Ni,Fe,al=`Instantiate a model from pretrained weights saved in the original <code>.ckpt</code> or <code>.safetensors</code> format. The model
is set in evaluation mode (<code>model.eval()</code>) by default.`,Xi,Y,ji,Ge,Gi,Re,ki;return M=new J({props:{title:"Loading Pipelines and Models via from_single_file",local:"loading-pipelines-and-models-via-fromsinglefile",headingTag:"h1"}}),X=new J({props:{title:"Pipelines that currently support from_single_file loading",local:"pipelines-that-currently-support-fromsinglefile-loading",headingTag:"h2"}}),L=new J({props:{title:"Models that currently support from_single_file loading",local:"models-that-currently-support-fromsinglefile-loading",headingTag:"h2"}}),H=new J({props:{title:"Usage Examples",local:"usage-examples",headingTag:"h2"}}),V=new J({props:{title:"Loading a Pipeline using from_single_file",local:"loading-a-pipeline-using-fromsinglefile",headingTag:"h2"}}),D=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTJGYmxvYiUyRm1haW4lMkZzZF94bF9iYXNlXzEuMF8wLjl2YWUuc2FmZXRlbnNvcnMlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKGNrcHRfcGF0aCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0_0.9vae.safetensors&quot;</span>
pipe = StableDiffusionXLPipeline.from_single_file(ckpt_path)`,wrap:!1}}),P=new J({props:{title:"Setting components in a Pipeline using from_single_file",local:"setting-components-in-a-pipeline-using-fromsinglefile",headingTag:"h2"}}),Q=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBJTBBY2twdF9wYXRoJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyRmJsb2IlMkZtYWluJTJGc2RfeGxfYmFzZV8xLjBfMC45dmFlLnNhZmV0ZW5zb3JzJTIyJTBBJTBBc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlcigpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZShja3B0X3BhdGglMkMlMjBzY2hlZHVsZXIlM0RzY2hlZHVsZXIpJTBB",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, DDIMScheduler

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0_0.9vae.safetensors&quot;</span>

scheduler = DDIMScheduler()
pipe = StableDiffusionXLPipeline.from_single_file(ckpt_path, scheduler=scheduler)
`,wrap:!1}}),z=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTBBJTBBY2twdF9wYXRoJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGYmxvYiUyRm1haW4lMkZ2MS01LXBydW5lZC1lbWFvbmx5LnNhZmV0ZW5zb3JzJTIyJTBBJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGYmxvYiUyRm1haW4lMkZ2MS01LXBydW5lZC1lbWFvbmx5LnNhZmV0ZW5zb3JzJTIyKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKGNrcHRfcGF0aCUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0KSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, ControlNetModel

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.safetensors&quot;</span>

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.safetensors&quot;</span>)
pipe = StableDiffusionPipeline.from_single_file(ckpt_path, controlnet=controlnet)
`,wrap:!1}}),A=new J({props:{title:"Loading a Model using from_single_file",local:"loading-a-model-using-fromsinglefile",headingTag:"h2"}}),O=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZUNhc2NhZGVVTmV0JTBBJTBBY2twdF9wYXRoJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWNhc2NhZGUlMkZibG9iJTJGbWFpbiUyRnN0YWdlX2JfbGl0ZS5zYWZldGVuc29ycyUyMiUwQW1vZGVsJTIwJTNEJTIwU3RhYmxlQ2FzY2FkZVVOZXQuZnJvbV9zaW5nbGVfZmlsZShja3B0X3BhdGgpJTBB",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableCascadeUNet

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-cascade/blob/main/stage_b_lite.safetensors&quot;</span>
model = StableCascadeUNet.from_single_file(ckpt_path)
`,wrap:!1}}),K=new J({props:{title:"Using a Diffusers model repository to configure single file loading",local:"using-a-diffusers-model-repository-to-configure-single-file-loading",headingTag:"h2"}}),ie=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc2VnbWluZCUyRlNTRC0xQiUyRmJsb2IlMkZtYWluJTJGU1NELTFCLnNhZmV0ZW5zb3JzJTIyJTBBcmVwb19pZCUyMCUzRCUyMCUyMnNlZ21pbmQlMkZTU0QtMUIlMjIlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKGNrcHRfcGF0aCUyQyUyMGNvbmZpZyUzRHJlcG9faWQpJTBB",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/segmind/SSD-1B/blob/main/SSD-1B.safetensors&quot;</span>
repo_id = <span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>

pipe = StableDiffusionXLPipeline.from_single_file(ckpt_path, config=repo_id)
`,wrap:!1}}),le=new J({props:{title:"Override configuration options when using single file loading",local:"override-configuration-options-when-using-single-file-loading",headingTag:"h2"}}),ne=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZjb3N4bCUyRmJsb2IlMkZtYWluJTJGY29zeGxfZWRpdC5zYWZldGVuc29ycyUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEluc3RydWN0UGl4MlBpeFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoY2twdF9wYXRoJTJDJTIwY29uZmlnJTNEJTIyZGlmZnVzZXJzJTJGc2R4bC1pbnN0cnVjdHBpeDJwaXgtNzY4JTIyJTJDJTIwaXNfY29zeGxfZWRpdCUzRFRydWUpJTBB",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLInstructPix2PixPipeline

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/cosxl/blob/main/cosxl_edit.safetensors&quot;</span>
pipe = StableDiffusionXLInstructPix2PixPipeline.from_single_file(ckpt_path, config=<span class="hljs-string">&quot;diffusers/sdxl-instructpix2pix-768&quot;</span>, is_cosxl_edit=<span class="hljs-literal">True</span>)
`,wrap:!1}}),oe=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBY2twdF9wYXRoJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyRmJsb2IlMkZtYWluJTJGc2RfeGxfYmFzZV8xLjBfMC45dmFlLnNhZmV0ZW5zb3JzJTIyJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3NpbmdsZV9maWxlKGNrcHRfcGF0aCUyQyUyMHVwY2FzdF9hdHRlbnRpb24lM0RUcnVlKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0_0.9vae.safetensors&quot;</span>
model = UNet2DConditionModel.from_single_file(ckpt_path, upcast_attention=<span class="hljs-literal">True</span>)
`,wrap:!1}}),S=new Ci({props:{$$slots:{default:[yl]},$$scope:{ctx:U}}}),re=new J({props:{title:"Working with local files",local:"working-with-local-files",headingTag:"h2"}}),pe=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUyQyUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBbXlfbG9jYWxfY2hlY2twb2ludF9wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJzZWdtaW5kJTJGU1NELTFCJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJTU0QtMUIuc2FmZXRlbnNvcnMlMjIlMEEpJTBBJTBBbXlfbG9jYWxfY29uZmlnX3BhdGglMjAlM0QlMjBzbmFwc2hvdF9kb3dubG9hZCglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIyc2VnbWluZCUyRlNTRC0xQiUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsbG93ZWRfcGF0dGVybnMlM0QlNUIlMjIqLmpzb24lMjIlMkMlMjAlMjIqKiUyRiouanNvbiUyMiUyQyUyMCUyMioudHh0JTIyJTJDJTIwJTIyKiolMkYqLnR4dCUyMiU1RCUwQSklMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKG15X2xvY2FsX2NoZWNrcG9pbnRfcGF0aCUyQyUyMGNvbmZpZyUzRG15X2xvY2FsX2NvbmZpZ19wYXRoJTJDJTIwbG9jYWxfZmlsZXNfb25seSUzRFRydWUpJTBB",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download, snapshot_download

my_local_checkpoint_path = hf_hub_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    filename=<span class="hljs-string">&quot;SSD-1B.safetensors&quot;</span>
)

my_local_config_path = snapshot_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    allowed_patterns=[<span class="hljs-string">&quot;*.json&quot;</span>, <span class="hljs-string">&quot;**/*.json&quot;</span>, <span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-string">&quot;**/*.txt&quot;</span>]
)

pipe = StableDiffusionXLPipeline.from_single_file(my_local_checkpoint_path, config=my_local_config_path, local_files_only=<span class="hljs-literal">True</span>)
`,wrap:!1}}),me=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUyQyUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBbXlfbG9jYWxfY2hlY2twb2ludF9wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJzZWdtaW5kJTJGU1NELTFCJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJTU0QtMUIuc2FmZXRlbnNvcnMlMjIlMEElMjAlMjAlMjAlMjBsb2NhbF9kaXIlM0QlMjJteV9sb2NhbF9jaGVja3BvaW50cyUyMiUwQSklMEElMEFteV9sb2NhbF9jb25maWdfcGF0aCUyMCUzRCUyMHNuYXBzaG90X2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJzZWdtaW5kJTJGU1NELTFCJTIyJTJDJTBBJTIwJTIwJTIwJTIwYWxsb3dlZF9wYXR0ZXJucyUzRCU1QiUyMiouanNvbiUyMiUyQyUyMCUyMioqJTJGKi5qc29uJTIyJTJDJTIwJTIyKi50eHQlMjIlMkMlMjAlMjIqKiUyRioudHh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwbG9jYWxfZGlyJTNEJTIybXlfbG9jYWxfY29uZmlnJTIyJTBBKSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUobXlfbG9jYWxfY2hlY2twb2ludF9wYXRoJTJDJTIwY29uZmlnJTNEbXlfbG9jYWxfY29uZmlnX3BhdGglMkMlMjBsb2NhbF9maWxlc19vbmx5JTNEVHJ1ZSklMEE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download, snapshot_download

my_local_checkpoint_path = hf_hub_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    filename=<span class="hljs-string">&quot;SSD-1B.safetensors&quot;</span>
    local_dir=<span class="hljs-string">&quot;my_local_checkpoints&quot;</span>
)

my_local_config_path = snapshot_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    allowed_patterns=[<span class="hljs-string">&quot;*.json&quot;</span>, <span class="hljs-string">&quot;**/*.json&quot;</span>, <span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-string">&quot;**/*.txt&quot;</span>]
    local_dir=<span class="hljs-string">&quot;my_local_config&quot;</span>
)

pipe = StableDiffusionXLPipeline.from_single_file(my_local_checkpoint_path, config=my_local_config_path, local_files_only=<span class="hljs-literal">True</span>)
`,wrap:!1}}),he=new J({props:{title:"Working with local files on file systems that do not support symlinking",local:"working-with-local-files-on-file-systems-that-do-not-support-symlinking",headingTag:"h2"}}),ue=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUyQyUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBbXlfbG9jYWxfY2hlY2twb2ludF9wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJzZWdtaW5kJTJGU1NELTFCJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJTU0QtMUIuc2FmZXRlbnNvcnMlMjIlMEElMjAlMjAlMjAlMjBsb2NhbF9kaXIlM0QlMjJteV9sb2NhbF9jaGVja3BvaW50cyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvY2FsX2Rpcl91c2Vfc3ltbGlua3MlM0RGYWxzZSUwQSklMEFwcmludCglMjJNeSUyMGxvY2FsJTIwY2hlY2twb2ludCUzQSUyMCUyMiUyQyUyMG15X2xvY2FsX2NoZWNrcG9pbnRfcGF0aCklMEElMEFteV9sb2NhbF9jb25maWdfcGF0aCUyMCUzRCUyMHNuYXBzaG90X2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJzZWdtaW5kJTJGU1NELTFCJTIyJTJDJTBBJTIwJTIwJTIwJTIwYWxsb3dlZF9wYXR0ZXJucyUzRCU1QiUyMiouanNvbiUyMiUyQyUyMCUyMioqJTJGKi5qc29uJTIyJTJDJTIwJTIyKi50eHQlMjIlMkMlMjAlMjIqKiUyRioudHh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwbG9jYWxfZGlyX3VzZV9zeW1saW5rcyUzREZhbHNlJTJDJTBBKSUwQXByaW50KCUyMk15JTIwbG9jYWwlMjBjb25maWclM0ElMjAlMjIlMkMlMjBteV9sb2NhbF9jb25maWdfcGF0aCklMEE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download, snapshot_download

my_local_checkpoint_path = hf_hub_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    filename=<span class="hljs-string">&quot;SSD-1B.safetensors&quot;</span>
    local_dir=<span class="hljs-string">&quot;my_local_checkpoints&quot;</span>,
    local_dir_use_symlinks=<span class="hljs-literal">False</span>
)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;My local checkpoint: &quot;</span>, my_local_checkpoint_path)

my_local_config_path = snapshot_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    allowed_patterns=[<span class="hljs-string">&quot;*.json&quot;</span>, <span class="hljs-string">&quot;**/*.json&quot;</span>, <span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-string">&quot;**/*.txt&quot;</span>]
    local_dir_use_symlinks=<span class="hljs-literal">False</span>,
)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;My local config: &quot;</span>, my_local_config_path)
`,wrap:!1}}),ye=new T({props:{code:"cGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZShteV9sb2NhbF9jaGVja3BvaW50X3BhdGglMkMlMjBjb25maWclM0RteV9sb2NhbF9jb25maWdfcGF0aCUyQyUyMGxvY2FsX2ZpbGVzX29ubHklM0RUcnVlKSUwQQ==",highlighted:`pipe = StableDiffusionXLPipeline.from_single_file(my_local_checkpoint_path, config=my_local_config_path, local_files_only=<span class="hljs-literal">True</span>)
`,wrap:!1}}),I=new Ci({props:{$$slots:{default:[_l]},$$scope:{ctx:U}}}),_e=new J({props:{title:"Using the original configuration file of a model",local:"using-the-original-configuration-file-of-a-model",headingTag:"h2"}}),we=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTJGYmxvYiUyRm1haW4lMkZzZF94bF9iYXNlXzEuMF8wLjl2YWUuc2FmZXRlbnNvcnMlMjIlMEFyZXBvX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBb3JpZ2luYWxfY29uZmlnJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGU3RhYmlsaXR5LUFJJTJGZ2VuZXJhdGl2ZS1tb2RlbHMlMkZtYWluJTJGY29uZmlncyUyRmluZmVyZW5jZSUyRnNkX3hsX2Jhc2UueWFtbCUyMiUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoY2twdF9wYXRoJTJDJTIwb3JpZ2luYWxfY29uZmlnJTNEb3JpZ2luYWxfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0_0.9vae.safetensors&quot;</span>
repo_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
original_config = <span class="hljs-string">&quot;https://raw.githubusercontent.com/Stability-AI/generative-models/main/configs/inference/sd_xl_base.yaml&quot;</span>

pipe = StableDiffusionXLPipeline.from_single_file(ckpt_path, original_config=original_config)`,wrap:!1}}),R=new Ci({props:{$$slots:{default:[Ml]},$$scope:{ctx:U}}}),Te=new J({props:{title:"FromSingleFileMixin",local:"diffusers.loaders.FromSingleFileMixin",headingTag:"h2"}}),Ue=new vi({props:{name:"class diffusers.loaders.FromSingleFileMixin",anchor:"diffusers.loaders.FromSingleFileMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L253"}}),$e=new vi({props:{name:"from_single_file",anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible. Will be removed in v1
of Diffusers.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The path to the original config file that was used to train the model. If not provided, the config file
will be inferred from the checkpoint file.`,name:"original_config_file"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.config",description:`<strong>config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing the pipeline
component configs in Diffusers format.</li>
</ul>`,name:"config"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L258"}}),B=new fl({props:{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.example",$$slots:{default:[wl]},$$scope:{ctx:U}}}),Ze=new J({props:{title:"FromOriginalModelMixin",local:"diffusers.loaders.FromOriginalModelMixin",headingTag:"h2"}}),xe=new vi({props:{name:"class diffusers.loaders.FromOriginalModelMixin",anchor:"diffusers.loaders.FromOriginalModelMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file_model.py#L81"}}),je=new vi({props:{name:"from_single_file",anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path_or_dict",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.pretrained_model_link_or_path_or_dict",description:`<strong>pretrained_model_link_or_path_or_dict</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.safetensors</code> or <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.safetensors&quot;</code>) on the Hub.</li>
<li>A path to a local <em>file</em> containing the weights of the component model.</li>
<li>A state dict containing the component model weights.</li>
</ul>`,name:"pretrained_model_link_or_path_or_dict"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.config",description:`<strong>config</strong> (<code>str</code>, <em>optional</em>) &#x2014;<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline hosted
on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing the pipeline component
configs in Diffusers format.</li>
</ul>`,name:"config"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.original_config",description:`<strong>original_config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Dict or path to a yaml file containing the configuration for the model in its original format.
If a dict is provided, it will be used to initialize the model configuration.`,name:"original_config"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to True, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file_model.py#L86"}}),Y=new fl({props:{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.example",$$slots:{default:[Jl]},$$scope:{ctx:U}}}),Ge=new bl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/loaders/single_file.md"}}),{c(){s=h("meta"),u=n(),m=h("p"),b=n(),a(M.$$.fragment),_=n(),$=h("p"),$.innerHTML=Li,Be=n(),N=h("p"),N.innerHTML=Ei,Ye=n(),a(X.$$.fragment),Ne=n(),C=h("ul"),C.innerHTML=Hi,Xe=n(),a(L.$$.fragment),Ce=n(),E=h("ul"),E.innerHTML=Vi,Le=n(),a(H.$$.fragment),Ee=n(),a(V.$$.fragment),He=n(),a(D.$$.fragment),Ve=n(),a(P.$$.fragment),De=n(),q=h("p"),q.innerHTML=Di,Pe=n(),a(Q.$$.fragment),qe=n(),a(z.$$.fragment),Qe=n(),a(A.$$.fragment),ze=n(),a(O.$$.fragment),Ae=n(),a(K.$$.fragment),Oe=n(),ee=h("p"),ee.innerHTML=Pi,Ke=n(),a(ie.$$.fragment),ei=n(),a(le.$$.fragment),ii=n(),te=h("p"),te.innerHTML=qi,li=n(),a(ne.$$.fragment),ti=n(),a(oe.$$.fragment),ni=n(),se=h("p"),se.innerHTML=Qi,oi=n(),ae=h("p"),ae.innerHTML=zi,si=n(),a(S.$$.fragment),ai=n(),a(re.$$.fragment),ri=n(),fe=h("p"),fe.innerHTML=Ai,fi=n(),de=h("p"),de.innerHTML=Oi,di=n(),a(pe.$$.fragment),pi=n(),ce=h("p"),ce.innerHTML=Ki,ci=n(),a(me.$$.fragment),mi=n(),a(he.$$.fragment),hi=n(),ge=h("p"),ge.innerHTML=el,gi=n(),a(ue.$$.fragment),ui=n(),be=h("p"),be.innerHTML=il,bi=n(),a(ye.$$.fragment),yi=n(),a(I.$$.fragment),_i=n(),a(_e.$$.fragment),Mi=n(),Me=h("p"),Me.innerHTML=ll,wi=n(),a(we.$$.fragment),Ji=n(),Je=h("p"),Je.innerHTML=tl,Ti=n(),a(R.$$.fragment),Ui=n(),a(Te.$$.fragment),$i=n(),Z=h("div"),a(Ue.$$.fragment),Fi=n(),ke=h("p"),ke.innerHTML=nl,Si=n(),j=h("div"),a($e.$$.fragment),Ii=n(),ve=h("p"),ve.innerHTML=ol,Ri=n(),a(B.$$.fragment),Zi=n(),a(Ze.$$.fragment),xi=n(),x=h("div"),a(xe.$$.fragment),Bi=n(),We=h("p"),We.innerHTML=sl,Yi=n(),G=h("div"),a(je.$$.fragment),Ni=n(),Fe=h("p"),Fe.innerHTML=al,Xi=n(),a(Y.$$.fragment),ji=n(),a(Ge.$$.fragment),Gi=n(),Re=h("p"),this.h()},l(e){const i=ul("svelte-u9bgzb",document.head);s=g(i,"META",{name:!0,content:!0}),i.forEach(l),u=o(e),m=g(e,"P",{}),Se(m).forEach(l),b=o(e),r(M.$$.fragment,e),_=o(e),$=g(e,"P",{"data-svelte-h":!0}),y($)!=="svelte-1xg58b1"&&($.innerHTML=Li),Be=o(e),N=g(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-10w87av"&&(N.innerHTML=Ei),Ye=o(e),r(X.$$.fragment,e),Ne=o(e),C=g(e,"UL",{"data-svelte-h":!0}),y(C)!=="svelte-1wsech9"&&(C.innerHTML=Hi),Xe=o(e),r(L.$$.fragment,e),Ce=o(e),E=g(e,"UL",{"data-svelte-h":!0}),y(E)!=="svelte-1sr1e43"&&(E.innerHTML=Vi),Le=o(e),r(H.$$.fragment,e),Ee=o(e),r(V.$$.fragment,e),He=o(e),r(D.$$.fragment,e),Ve=o(e),r(P.$$.fragment,e),De=o(e),q=g(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-omtx4g"&&(q.innerHTML=Di),Pe=o(e),r(Q.$$.fragment,e),qe=o(e),r(z.$$.fragment,e),Qe=o(e),r(A.$$.fragment,e),ze=o(e),r(O.$$.fragment,e),Ae=o(e),r(K.$$.fragment,e),Oe=o(e),ee=g(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-xqij3k"&&(ee.innerHTML=Pi),Ke=o(e),r(ie.$$.fragment,e),ei=o(e),r(le.$$.fragment,e),ii=o(e),te=g(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-fy61mj"&&(te.innerHTML=qi),li=o(e),r(ne.$$.fragment,e),ti=o(e),r(oe.$$.fragment,e),ni=o(e),se=g(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-lyl89j"&&(se.innerHTML=Qi),oi=o(e),ae=g(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-nn49xl"&&(ae.innerHTML=zi),si=o(e),r(S.$$.fragment,e),ai=o(e),r(re.$$.fragment,e),ri=o(e),fe=g(e,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-1dfmdxu"&&(fe.innerHTML=Ai),fi=o(e),de=g(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-qc9t22"&&(de.innerHTML=Oi),di=o(e),r(pe.$$.fragment,e),pi=o(e),ce=g(e,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-delnnw"&&(ce.innerHTML=Ki),ci=o(e),r(me.$$.fragment,e),mi=o(e),r(he.$$.fragment,e),hi=o(e),ge=g(e,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-1nvseog"&&(ge.innerHTML=el),gi=o(e),r(ue.$$.fragment,e),ui=o(e),be=g(e,"P",{"data-svelte-h":!0}),y(be)!=="svelte-1wi9kuq"&&(be.innerHTML=il),bi=o(e),r(ye.$$.fragment,e),yi=o(e),r(I.$$.fragment,e),_i=o(e),r(_e.$$.fragment,e),Mi=o(e),Me=g(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-uwqwbp"&&(Me.innerHTML=ll),wi=o(e),r(we.$$.fragment,e),Ji=o(e),Je=g(e,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-rtgmpr"&&(Je.innerHTML=tl),Ti=o(e),r(R.$$.fragment,e),Ui=o(e),r(Te.$$.fragment,e),$i=o(e),Z=g(e,"DIV",{class:!0});var k=Se(Z);r(Ue.$$.fragment,k),Fi=o(k),ke=g(k,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-11v9qjy"&&(ke.innerHTML=nl),Si=o(k),j=g(k,"DIV",{class:!0});var v=Se(j);r($e.$$.fragment,v),Ii=o(v),ve=g(v,"P",{"data-svelte-h":!0}),y(ve)!=="svelte-pmqrln"&&(ve.innerHTML=ol),Ri=o(v),r(B.$$.fragment,v),v.forEach(l),k.forEach(l),Zi=o(e),r(Ze.$$.fragment,e),xi=o(e),x=g(e,"DIV",{class:!0});var W=Se(x);r(xe.$$.fragment,W),Bi=o(W),We=g(W,"P",{"data-svelte-h":!0}),y(We)!=="svelte-1angwv3"&&(We.innerHTML=sl),Yi=o(W),G=g(W,"DIV",{class:!0});var F=Se(G);r(je.$$.fragment,F),Ni=o(F),Fe=g(F,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-vw4n4o"&&(Fe.innerHTML=al),Xi=o(F),r(Y.$$.fragment,F),F.forEach(l),W.forEach(l),ji=o(e),r(Ge.$$.fragment,e),Gi=o(e),Re=g(e,"P",{}),Se(Re).forEach(l),this.h()},h(){Ie(s,"name","hf:doc:metadata"),Ie(s,"content",Ul),Ie(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ie(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ie(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ie(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){w(document.head,s),t(e,u,i),t(e,m,i),t(e,b,i),f(M,e,i),t(e,_,i),t(e,$,i),t(e,Be,i),t(e,N,i),t(e,Ye,i),f(X,e,i),t(e,Ne,i),t(e,C,i),t(e,Xe,i),f(L,e,i),t(e,Ce,i),t(e,E,i),t(e,Le,i),f(H,e,i),t(e,Ee,i),f(V,e,i),t(e,He,i),f(D,e,i),t(e,Ve,i),f(P,e,i),t(e,De,i),t(e,q,i),t(e,Pe,i),f(Q,e,i),t(e,qe,i),f(z,e,i),t(e,Qe,i),f(A,e,i),t(e,ze,i),f(O,e,i),t(e,Ae,i),f(K,e,i),t(e,Oe,i),t(e,ee,i),t(e,Ke,i),f(ie,e,i),t(e,ei,i),f(le,e,i),t(e,ii,i),t(e,te,i),t(e,li,i),f(ne,e,i),t(e,ti,i),f(oe,e,i),t(e,ni,i),t(e,se,i),t(e,oi,i),t(e,ae,i),t(e,si,i),f(S,e,i),t(e,ai,i),f(re,e,i),t(e,ri,i),t(e,fe,i),t(e,fi,i),t(e,de,i),t(e,di,i),f(pe,e,i),t(e,pi,i),t(e,ce,i),t(e,ci,i),f(me,e,i),t(e,mi,i),f(he,e,i),t(e,hi,i),t(e,ge,i),t(e,gi,i),f(ue,e,i),t(e,ui,i),t(e,be,i),t(e,bi,i),f(ye,e,i),t(e,yi,i),f(I,e,i),t(e,_i,i),f(_e,e,i),t(e,Mi,i),t(e,Me,i),t(e,wi,i),f(we,e,i),t(e,Ji,i),t(e,Je,i),t(e,Ti,i),f(R,e,i),t(e,Ui,i),f(Te,e,i),t(e,$i,i),t(e,Z,i),f(Ue,Z,null),w(Z,Fi),w(Z,ke),w(Z,Si),w(Z,j),f($e,j,null),w(j,Ii),w(j,ve),w(j,Ri),f(B,j,null),t(e,Zi,i),f(Ze,e,i),t(e,xi,i),t(e,x,i),f(xe,x,null),w(x,Bi),w(x,We),w(x,Yi),w(x,G),f(je,G,null),w(G,Ni),w(G,Fe),w(G,Xi),f(Y,G,null),t(e,ji,i),f(Ge,e,i),t(e,Gi,i),t(e,Re,i),ki=!0},p(e,[i]){const k={};i&2&&(k.$$scope={dirty:i,ctx:e}),S.$set(k);const v={};i&2&&(v.$$scope={dirty:i,ctx:e}),I.$set(v);const W={};i&2&&(W.$$scope={dirty:i,ctx:e}),R.$set(W);const F={};i&2&&(F.$$scope={dirty:i,ctx:e}),B.$set(F);const rl={};i&2&&(rl.$$scope={dirty:i,ctx:e}),Y.$set(rl)},i(e){ki||(d(M.$$.fragment,e),d(X.$$.fragment,e),d(L.$$.fragment,e),d(H.$$.fragment,e),d(V.$$.fragment,e),d(D.$$.fragment,e),d(P.$$.fragment,e),d(Q.$$.fragment,e),d(z.$$.fragment,e),d(A.$$.fragment,e),d(O.$$.fragment,e),d(K.$$.fragment,e),d(ie.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(S.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(he.$$.fragment,e),d(ue.$$.fragment,e),d(ye.$$.fragment,e),d(I.$$.fragment,e),d(_e.$$.fragment,e),d(we.$$.fragment,e),d(R.$$.fragment,e),d(Te.$$.fragment,e),d(Ue.$$.fragment,e),d($e.$$.fragment,e),d(B.$$.fragment,e),d(Ze.$$.fragment,e),d(xe.$$.fragment,e),d(je.$$.fragment,e),d(Y.$$.fragment,e),d(Ge.$$.fragment,e),ki=!0)},o(e){p(M.$$.fragment,e),p(X.$$.fragment,e),p(L.$$.fragment,e),p(H.$$.fragment,e),p(V.$$.fragment,e),p(D.$$.fragment,e),p(P.$$.fragment,e),p(Q.$$.fragment,e),p(z.$$.fragment,e),p(A.$$.fragment,e),p(O.$$.fragment,e),p(K.$$.fragment,e),p(ie.$$.fragment,e),p(le.$$.fragment,e),p(ne.$$.fragment,e),p(oe.$$.fragment,e),p(S.$$.fragment,e),p(re.$$.fragment,e),p(pe.$$.fragment,e),p(me.$$.fragment,e),p(he.$$.fragment,e),p(ue.$$.fragment,e),p(ye.$$.fragment,e),p(I.$$.fragment,e),p(_e.$$.fragment,e),p(we.$$.fragment,e),p(R.$$.fragment,e),p(Te.$$.fragment,e),p(Ue.$$.fragment,e),p($e.$$.fragment,e),p(B.$$.fragment,e),p(Ze.$$.fragment,e),p(xe.$$.fragment,e),p(je.$$.fragment,e),p(Y.$$.fragment,e),p(Ge.$$.fragment,e),ki=!1},d(e){e&&(l(u),l(m),l(b),l(_),l($),l(Be),l(N),l(Ye),l(Ne),l(C),l(Xe),l(Ce),l(E),l(Le),l(Ee),l(He),l(Ve),l(De),l(q),l(Pe),l(qe),l(Qe),l(ze),l(Ae),l(Oe),l(ee),l(Ke),l(ei),l(ii),l(te),l(li),l(ti),l(ni),l(se),l(oi),l(ae),l(si),l(ai),l(ri),l(fe),l(fi),l(de),l(di),l(pi),l(ce),l(ci),l(mi),l(hi),l(ge),l(gi),l(ui),l(be),l(bi),l(yi),l(_i),l(Mi),l(Me),l(wi),l(Ji),l(Je),l(Ti),l(Ui),l($i),l(Z),l(Zi),l(xi),l(x),l(ji),l(Gi),l(Re)),l(s),c(M,e),c(X,e),c(L,e),c(H,e),c(V,e),c(D,e),c(P,e),c(Q,e),c(z,e),c(A,e),c(O,e),c(K,e),c(ie,e),c(le,e),c(ne,e),c(oe,e),c(S,e),c(re,e),c(pe,e),c(me,e),c(he,e),c(ue,e),c(ye,e),c(I,e),c(_e,e),c(we,e),c(R,e),c(Te,e),c(Ue),c($e),c(B),c(Ze,e),c(xe),c(je),c(Y),c(Ge,e)}}}const Ul='{"title":"Loading Pipelines and Models via from_single_file","local":"loading-pipelines-and-models-via-fromsinglefile","sections":[{"title":"Pipelines that currently support from_single_file loading","local":"pipelines-that-currently-support-fromsinglefile-loading","sections":[],"depth":2},{"title":"Models that currently support from_single_file loading","local":"models-that-currently-support-fromsinglefile-loading","sections":[],"depth":2},{"title":"Usage Examples","local":"usage-examples","sections":[],"depth":2},{"title":"Loading a Pipeline using from_single_file","local":"loading-a-pipeline-using-fromsinglefile","sections":[],"depth":2},{"title":"Setting components in a Pipeline using from_single_file","local":"setting-components-in-a-pipeline-using-fromsinglefile","sections":[],"depth":2},{"title":"Loading a Model using from_single_file","local":"loading-a-model-using-fromsinglefile","sections":[],"depth":2},{"title":"Using a Diffusers model repository to configure single file loading","local":"using-a-diffusers-model-repository-to-configure-single-file-loading","sections":[],"depth":2},{"title":"Override configuration options when using single file loading","local":"override-configuration-options-when-using-single-file-loading","sections":[],"depth":2},{"title":"Working with local files","local":"working-with-local-files","sections":[],"depth":2},{"title":"Working with local files on file systems that do not support symlinking","local":"working-with-local-files-on-file-systems-that-do-not-support-symlinking","sections":[],"depth":2},{"title":"Using the original configuration file of a model","local":"using-the-original-configuration-file-of-a-model","sections":[],"depth":2},{"title":"FromSingleFileMixin","local":"diffusers.loaders.FromSingleFileMixin","sections":[],"depth":2},{"title":"FromOriginalModelMixin","local":"diffusers.loaders.FromOriginalModelMixin","sections":[],"depth":2}],"depth":1}';function $l(U){return ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fl extends hl{constructor(s){super(),gl(this,s,$l,Tl,cl,{})}}export{Fl as component};
