import{s as Vt,y as zt,n as Gt,o as Pt}from"../chunks/scheduler.d6170356.js";import{S as Et,i as qt,g as n,s as a,r as O,A as Ft,h as o,f as l,c as i,j as Wt,u as ee,x as r,k as c,y as Rt,a as s,v as te,d as le,t as se,w as ae}from"../chunks/index.fcd4cc08.js";import{C as Bt}from"../chunks/CodeBlock.7b16bdef.js";import{H as oe}from"../chunks/Heading.8660bd0e.js";function Qt(Oe){let u,re,ie,ce,T,ue,v,et='To upload models to the Hub, you’ll need to create an account at <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a>. Models on the Hub are <a href="./repositories">Git-based repositories</a>, which give you versioning, branches, discoverability and sharing features, integration with dozens of libraries, and more! You have control over what you want to upload to your repository, which could include checkpoints, configs, and any other files.',de,_,tt='You can link repositories with an individual user, such as <a href="https://huggingface.co/osanseviero/fashion_brands_patterns" rel="nofollow">osanseviero/fashion_brands_patterns</a>, or with an organization, such as <a href="https://huggingface.co/facebook/bart-large-xsum" rel="nofollow">facebook/bart-large-xsum</a>. Organizations can collect models related to a company, community, or library! If you choose an organization, the model will be featured on the organization’s page, and every member of the organization will have the ability to contribute to the repository. You can create a new organization <a href="https://huggingface.co/organizations/new" rel="nofollow">here</a>.',he,J,lt="There are several ways to upload models to the Hub, described below.",me,j,st='<li>In case your model comes from a library that has <a href="#upload-from-a-library-with-built-in-support">built-in support</a>, one can use the existing methods.</li> <li>In case your model is a custom PyTorch model, the recommended way is to leverage the <a href="#using-the-huggingface_hub-client-library">huggingface_hub</a> Python library as it allows to add <code>from_pretrained</code>, <code>push_to_hub</code> and <a href="https://huggingface.co/docs/hub/models-download-stats" rel="nofollow">automated download metrics</a> capabilities to your models, just like models in the Transformers, Diffusers and Timm libraries.</li> <li>In addition to programmatic uploads, you can always use the <a href="#using-the-web-interface">web interface</a>.</li>',pe,k,at='Once your model is uploaded, we suggest adding a <a href="./model-cards">Model Card</a> to your repo to document your model.',fe,U,ge,C,it='To create a brand new model repository, visit <a href="http://huggingface.co/new" rel="nofollow">huggingface.co/new</a>. Then follow these steps:',be,H,nt="<li>In the “Files and versions” tab, select “Add File” and specify “Upload File”:</li>",ye,d,ot='<img class="block dark:hidden" width="300" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/add-file.png"/> <img class="hidden dark:block" width="300" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/add-file-dark.png"/>',we,h,rt="<li>From there, select a file from your computer to upload and leave a helpful commit message to know what you are uploading:</li>",Me,m,ct='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/commit-file.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/commit-file-dark.png"/>',Te,p,ut="<li><p>Afterwards, click <strong>Commit changes</strong> to upload your model to the Hub!</p></li> <li><p>Inspect files and history</p></li>",ve,x,dt="You can check your repository with all the recently added files!",_e,f,ht='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_with_files.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_with_files-dark.png"/>',Je,I,mt="The UI allows you to explore the model files and commits and to see the diff introduced by each commit:",je,g,pt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/explore_history.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/explore_history-dark.gif"/>',ke,b,ft="<li>Add metadata</li>",Ue,L,gt="You can add metadata to your model card. You can specify:",Ce,Z,bt="<li>the type of task this model is for, enabling widgets and the Inference API.</li> <li>the used library (<code>transformers</code>, <code>spaCy</code>, etc.)</li> <li>the language</li> <li>the dataset</li> <li>metrics</li> <li>license</li> <li>a lot more!</li>",He,$,yt='Read more about model tags <a href="./model-cards#model-card-metadata">here</a>.',xe,y,wt="<li>Add TensorBoard traces</li>",Ie,W,Mt='Any repository that contains TensorBoard traces (filenames that contain <code>tfevents</code>) is categorized with the <a href="https://huggingface.co/models?filter=tensorboard" rel="nofollow"><code>TensorBoard</code> tag</a>. As a convention, we suggest that you save traces under the <code>runs/</code> subfolder. The “Training metrics” tab then makes it easy to review charts of the logged variables, like the loss or the accuracy.',Le,w,Tt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/tensorboard.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/tensorboard-dark.png"/>',Ze,B,vt='Models trained with 🤗 Transformers will generate <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.TensorBoardCallback" rel="nofollow">TensorBoard traces</a> by default if <a href="https://pypi.org/project/tensorboard/" rel="nofollow"><code>tensorboard</code></a> is installed.',$e,V,We,z,_t='First check if your model is from a library that has built-in support to push to/load from the Hub, like Transformers, Diffusers, Timm, Asteroid, etc.: <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">https://huggingface.co/docs/hub/models-libraries</a>. Below we’ll show how easy this is for a library like Transformers:',Be,G,Ve,P,ze,E,Jt='In case your model is a (custom) PyTorch model, you can leverage the <code>PyTorchModelHubMixin</code> <a href="https://huggingface.co/docs/huggingface_hub/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin" rel="nofollow">class</a> available in the <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> Python library. It is a minimal class which adds <code>from_pretrained</code> and <code>push_to_hub</code> capabilities to any <code>nn.Module</code>, along with download metrics.',Ge,q,jt="Here is how to use it (assuming you have run <code>pip install huggingface_hub</code>):",Pe,F,Ee,R,kt="As can be seen, the only thing required is to define all hyperparameters regarding the model architecture (such as hidden size, number of classes, dropout probability, etc.) in a Python dictionary often called the <code>config</code>. Next, you can define a class which takes the <code>config</code> as keyword argument in its init.",qe,Q,Ut="This comes with automated download metrics, meaning that you’ll be able to see how many times the model is downloaded, the same way they are available for models integrated natively in the Transformers, Diffusers or Timm libraries. With this mixin class, each separate checkpoint is stored on the Hub in a single repository consisting of 2 files:",Fe,S,Ct='<li>a <code>pytorch_model.bin</code> or <code>model.safetensors</code> file containing the weights</li> <li>a <code>config.json</code> file which is a serialized version of the model configuration. This class is used for counting download metrics: everytime a user calls <code>from_pretrained</code> to load a <code>config.json</code>, the count goes up by one. See <a href="https://huggingface.co/docs/hub/models-download-stats" rel="nofollow">this guide</a> regarding automated download metrics.</li>',Re,A,Ht="It’s recommended to add a model card to each checkpoint so that people can read what the model is about, have a link to the paper, etc.",Qe,M,xt,Se,Y,It="Example [repository](https://huggingface.co/LiheYoung/depth_anything_vitl14) that leverages PyTorchModelHubMixin. Downloads are shown on the right.",Ae,X,Lt='Visit <a href="https://huggingface.co/docs/huggingface_hub/guides/integrations" rel="nofollow">the huggingface_hub’s documentation</a> to learn more.',Ye,N,Zt='Alternatively, one can also simply programmatically upload files or folders to the hub: <a href="https://huggingface.co/docs/huggingface_hub/guides/upload" rel="nofollow">https://huggingface.co/docs/huggingface_hub/guides/upload</a>.',Xe,D,Ne,K,$t='Finally, since model repos are just Git repositories, you can also use Git to push your model files to the Hub. Follow the guide on <a href="repositories-getting-started#adding-files-to-a-repository-terminalterminal">Getting Started with Repositories</a> to learn about using the <code>git</code> CLI to commit and push your models.',De,ne,Ke;return T=new oe({props:{title:"Uploading models",local:"uploading-models",headingTag:"h1"}}),U=new oe({props:{title:"Using the web interface",local:"using-the-web-interface",headingTag:"h2"}}),V=new oe({props:{title:"Upload from a library with built-in support",local:"upload-from-a-library-with-built-in-support",headingTag:"h2"}}),G=new Bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRDb25maWclMkMlMjBCZXJ0TW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBCZXJ0Q29uZmlnKCklMEFtb2RlbCUyMCUzRCUyMEJlcnRNb2RlbChjb25maWcpJTBBJTBBbW9kZWwucHVzaF90b19odWIoJTIybmllbHNyJTJGbXktYXdlc29tZS1iZXJ0LW1vZGVsJTIyKSUwQSUwQSUyMyUyMHJlbG9hZCUwQW1vZGVsJTIwJTNEJTIwQmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJuaWVsc3IlMkZteS1hd2Vzb21lLWJlcnQtbW9kZWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertConfig, BertModel

config = BertConfig()
model = BertModel(config)

model.push_to_hub(<span class="hljs-string">&quot;nielsr/my-awesome-bert-model&quot;</span>)

<span class="hljs-comment"># reload</span>
model = BertModel.from_pretrained(<span class="hljs-string">&quot;nielsr/my-awesome-bert-model&quot;</span>)`,wrap:!1}}),P=new oe({props:{title:"Upload a PyTorch model using huggingface_hub",local:"upload-a-pytorch-model-using-huggingfacehub",headingTag:"h2"}}),F=new Bt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEElMEFjbGFzcyUyME15TW9kZWwobm4uTW9kdWxlJTJDJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyMGRpY3QpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5wYXJhbSUyMCUzRCUyMG5uLlBhcmFtZXRlcih0b3JjaC5yYW5kKGNvbmZpZyU1QiUyMm51bV9jaGFubmVscyUyMiU1RCUyQyUyMGNvbmZpZyU1QiUyMmhpZGRlbl9zaXplJTIyJTVEKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxpbmVhciUyMCUzRCUyMG5uLkxpbmVhcihjb25maWclNUIlMjJoaWRkZW5fc2l6ZSUyMiU1RCUyQyUyMGNvbmZpZyU1QiUyMm51bV9jbGFzc2VzJTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5saW5lYXIoeCUyMCUyQiUyMHNlbGYucGFyYW0pJTBBJTBBJTIzJTIwY3JlYXRlJTIwbW9kZWwlMEFjb25maWclMjAlM0QlMjAlN0IlMjJudW1fY2hhbm5lbHMlMjIlM0ElMjAzJTJDJTIwJTIyaGlkZGVuX3NpemUlMjIlM0ElMjAzMiUyQyUyMCUyMm51bV9jbGFzc2VzJTIyJTNBJTIwMTAlN0QlMEFtb2RlbCUyMCUzRCUyME15TW9kZWwoY29uZmlnJTNEY29uZmlnKSUwQSUwQSUyMyUyMHNhdmUlMjBsb2NhbGx5JTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIlMkMlMjBjb25maWclM0Rjb25maWcpJTBBJTBBJTIzJTIwcHVzaCUyMHRvJTIwdGhlJTIwaHViJTBBbW9kZWwucHVzaF90b19odWIoJTIybXktYXdlc29tZS1tb2RlbCUyMiUyQyUyMGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjByZWxvYWQlMEFtb2RlbCUyMCUzRCUyME15TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnVzZXJuYW1lJTJGbXktYXdlc29tZS1tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: <span class="hljs-built_in">dict</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.param = nn.Parameter(torch.rand(config[<span class="hljs-string">&quot;num_channels&quot;</span>], config[<span class="hljs-string">&quot;hidden_size&quot;</span>]))
        self.linear = nn.Linear(config[<span class="hljs-string">&quot;hidden_size&quot;</span>], config[<span class="hljs-string">&quot;num_classes&quot;</span>])

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> self.linear(x + self.param)

<span class="hljs-comment"># create model</span>
config = {<span class="hljs-string">&quot;num_channels&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;hidden_size&quot;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&quot;num_classes&quot;</span>: <span class="hljs-number">10</span>}
model = MyModel(config=config)

<span class="hljs-comment"># save locally</span>
model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>, config=config)

<span class="hljs-comment"># push to the hub</span>
model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>, config=config)

<span class="hljs-comment"># reload</span>
model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)`,wrap:!1}}),D=new oe({props:{title:"Using Git",local:"using-git",headingTag:"h2"}}),{c(){u=n("meta"),re=a(),ie=n("p"),ce=a(),O(T.$$.fragment),ue=a(),v=n("p"),v.innerHTML=et,de=a(),_=n("p"),_.innerHTML=tt,he=a(),J=n("p"),J.textContent=lt,me=a(),j=n("ul"),j.innerHTML=st,pe=a(),k=n("p"),k.innerHTML=at,fe=a(),O(U.$$.fragment),ge=a(),C=n("p"),C.innerHTML=it,be=a(),H=n("ol"),H.innerHTML=nt,ye=a(),d=n("div"),d.innerHTML=ot,we=a(),h=n("ol"),h.innerHTML=rt,Me=a(),m=n("div"),m.innerHTML=ct,Te=a(),p=n("ol"),p.innerHTML=ut,ve=a(),x=n("p"),x.textContent=dt,_e=a(),f=n("div"),f.innerHTML=ht,Je=a(),I=n("p"),I.textContent=mt,je=a(),g=n("div"),g.innerHTML=pt,ke=a(),b=n("ol"),b.innerHTML=ft,Ue=a(),L=n("p"),L.textContent=gt,Ce=a(),Z=n("ul"),Z.innerHTML=bt,He=a(),$=n("p"),$.innerHTML=yt,xe=a(),y=n("ol"),y.innerHTML=wt,Ie=a(),W=n("p"),W.innerHTML=Mt,Le=a(),w=n("div"),w.innerHTML=Tt,Ze=a(),B=n("p"),B.innerHTML=vt,$e=a(),O(V.$$.fragment),We=a(),z=n("p"),z.innerHTML=_t,Be=a(),O(G.$$.fragment),Ve=a(),O(P.$$.fragment),ze=a(),E=n("p"),E.innerHTML=Jt,Ge=a(),q=n("p"),q.innerHTML=jt,Pe=a(),O(F.$$.fragment),Ee=a(),R=n("p"),R.innerHTML=kt,qe=a(),Q=n("p"),Q.textContent=Ut,Fe=a(),S=n("ul"),S.innerHTML=Ct,Re=a(),A=n("p"),A.textContent=Ht,Qe=a(),M=n("img"),Se=a(),Y=n("small"),Y.textContent=It,Ae=a(),X=n("p"),X.innerHTML=Lt,Ye=a(),N=n("p"),N.innerHTML=Zt,Xe=a(),O(D.$$.fragment),Ne=a(),K=n("p"),K.innerHTML=$t,De=a(),ne=n("p"),this.h()},l(e){const t=Ft("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),re=i(e),ie=o(e,"P",{}),Wt(ie).forEach(l),ce=i(e),ee(T.$$.fragment,e),ue=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1k1s32s"&&(v.innerHTML=et),de=i(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1yho9nm"&&(_.innerHTML=tt),he=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1k3bfvj"&&(J.textContent=lt),me=i(e),j=o(e,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-1q90hd4"&&(j.innerHTML=st),pe=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1js1v2d"&&(k.innerHTML=at),fe=i(e),ee(U.$$.fragment,e),ge=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-x37mbe"&&(C.innerHTML=it),be=i(e),H=o(e,"OL",{"data-svelte-h":!0}),r(H)!=="svelte-m7dyke"&&(H.innerHTML=nt),ye=i(e),d=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(d)!=="svelte-1kwaicp"&&(d.innerHTML=ot),we=i(e),h=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(h)!=="svelte-bnx7wi"&&(h.innerHTML=rt),Me=i(e),m=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(m)!=="svelte-1yhipjn"&&(m.innerHTML=ct),Te=i(e),p=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(p)!=="svelte-1g8w05a"&&(p.innerHTML=ut),ve=i(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-197c7zs"&&(x.textContent=dt),_e=i(e),f=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-1vobd2z"&&(f.innerHTML=ht),Je=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-9fow57"&&(I.textContent=mt),je=i(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-cdui6d"&&(g.innerHTML=pt),ke=i(e),b=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(b)!=="svelte-j2g6d3"&&(b.innerHTML=ft),Ue=i(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-gkc8cy"&&(L.textContent=gt),Ce=i(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-tl31d8"&&(Z.innerHTML=bt),He=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-6zfhus"&&($.innerHTML=yt),xe=i(e),y=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-1r5hl08"&&(y.innerHTML=wt),Ie=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-duz775"&&(W.innerHTML=Mt),Le=i(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-rlnnzb"&&(w.innerHTML=Tt),Ze=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-hpisbu"&&(B.innerHTML=vt),$e=i(e),ee(V.$$.fragment,e),We=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-mz82tu"&&(z.innerHTML=_t),Be=i(e),ee(G.$$.fragment,e),Ve=i(e),ee(P.$$.fragment,e),ze=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1pq7dxk"&&(E.innerHTML=Jt),Ge=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-uwt68k"&&(q.innerHTML=jt),Pe=i(e),ee(F.$$.fragment,e),Ee=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-12czlwt"&&(R.innerHTML=kt),qe=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1f1zsla"&&(Q.textContent=Ut),Fe=i(e),S=o(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-m0rjhi"&&(S.innerHTML=Ct),Re=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1j0lu4s"&&(A.textContent=Ht),Qe=i(e),M=o(e,"IMG",{src:!0,alt:!0,width:!0}),Se=i(e),Y=o(e,"SMALL",{"data-svelte-h":!0}),r(Y)!=="svelte-15aw9vk"&&(Y.textContent=It),Ae=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1e814df"&&(X.innerHTML=Lt),Ye=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1x88idh"&&(N.innerHTML=Zt),Xe=i(e),ee(D.$$.fragment,e),Ne=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-9t8mwt"&&(K.innerHTML=$t),De=i(e),ne=o(e,"P",{}),Wt(ne).forEach(l),this.h()},h(){c(u,"name","hf:doc:metadata"),c(u,"content",St),c(d,"class","flex justify-center"),c(h,"start","2"),c(m,"class","flex justify-center"),c(p,"start","3"),c(f,"class","flex justify-center"),c(g,"class","flex justify-center"),c(b,"start","5"),c(y,"start","6"),c(w,"class","flex justify-center"),zt(M.src,xt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/mixin_example_bis.png")||c(M,"src",xt),c(M,"alt","drawing"),c(M,"width","600")},m(e,t){Rt(document.head,u),s(e,re,t),s(e,ie,t),s(e,ce,t),te(T,e,t),s(e,ue,t),s(e,v,t),s(e,de,t),s(e,_,t),s(e,he,t),s(e,J,t),s(e,me,t),s(e,j,t),s(e,pe,t),s(e,k,t),s(e,fe,t),te(U,e,t),s(e,ge,t),s(e,C,t),s(e,be,t),s(e,H,t),s(e,ye,t),s(e,d,t),s(e,we,t),s(e,h,t),s(e,Me,t),s(e,m,t),s(e,Te,t),s(e,p,t),s(e,ve,t),s(e,x,t),s(e,_e,t),s(e,f,t),s(e,Je,t),s(e,I,t),s(e,je,t),s(e,g,t),s(e,ke,t),s(e,b,t),s(e,Ue,t),s(e,L,t),s(e,Ce,t),s(e,Z,t),s(e,He,t),s(e,$,t),s(e,xe,t),s(e,y,t),s(e,Ie,t),s(e,W,t),s(e,Le,t),s(e,w,t),s(e,Ze,t),s(e,B,t),s(e,$e,t),te(V,e,t),s(e,We,t),s(e,z,t),s(e,Be,t),te(G,e,t),s(e,Ve,t),te(P,e,t),s(e,ze,t),s(e,E,t),s(e,Ge,t),s(e,q,t),s(e,Pe,t),te(F,e,t),s(e,Ee,t),s(e,R,t),s(e,qe,t),s(e,Q,t),s(e,Fe,t),s(e,S,t),s(e,Re,t),s(e,A,t),s(e,Qe,t),s(e,M,t),s(e,Se,t),s(e,Y,t),s(e,Ae,t),s(e,X,t),s(e,Ye,t),s(e,N,t),s(e,Xe,t),te(D,e,t),s(e,Ne,t),s(e,K,t),s(e,De,t),s(e,ne,t),Ke=!0},p:Gt,i(e){Ke||(le(T.$$.fragment,e),le(U.$$.fragment,e),le(V.$$.fragment,e),le(G.$$.fragment,e),le(P.$$.fragment,e),le(F.$$.fragment,e),le(D.$$.fragment,e),Ke=!0)},o(e){se(T.$$.fragment,e),se(U.$$.fragment,e),se(V.$$.fragment,e),se(G.$$.fragment,e),se(P.$$.fragment,e),se(F.$$.fragment,e),se(D.$$.fragment,e),Ke=!1},d(e){e&&(l(re),l(ie),l(ce),l(ue),l(v),l(de),l(_),l(he),l(J),l(me),l(j),l(pe),l(k),l(fe),l(ge),l(C),l(be),l(H),l(ye),l(d),l(we),l(h),l(Me),l(m),l(Te),l(p),l(ve),l(x),l(_e),l(f),l(Je),l(I),l(je),l(g),l(ke),l(b),l(Ue),l(L),l(Ce),l(Z),l(He),l($),l(xe),l(y),l(Ie),l(W),l(Le),l(w),l(Ze),l(B),l($e),l(We),l(z),l(Be),l(Ve),l(ze),l(E),l(Ge),l(q),l(Pe),l(Ee),l(R),l(qe),l(Q),l(Fe),l(S),l(Re),l(A),l(Qe),l(M),l(Se),l(Y),l(Ae),l(X),l(Ye),l(N),l(Xe),l(Ne),l(K),l(De),l(ne)),l(u),ae(T,e),ae(U,e),ae(V,e),ae(G,e),ae(P,e),ae(F,e),ae(D,e)}}}const St='{"title":"Uploading models","local":"uploading-models","sections":[{"title":"Using the web interface","local":"using-the-web-interface","sections":[],"depth":2},{"title":"Upload from a library with built-in support","local":"upload-from-a-library-with-built-in-support","sections":[],"depth":2},{"title":"Upload a PyTorch model using huggingface_hub","local":"upload-a-pytorch-model-using-huggingfacehub","sections":[],"depth":2},{"title":"Using Git","local":"using-git","sections":[],"depth":2}],"depth":1}';function At(Oe){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends Et{constructor(u){super(),qt(this,u,At,Qt,Vt,{})}}export{Kt as component};
