import{s as Ce,n as Je,o as Ue}from"../chunks/scheduler.d6170356.js";import{S as Ie,i as je,g as i,s,r,A as _e,h as o,f as l,c as a,j as $e,u as c,x as p,k as pe,y as xe,a as n,v as u,d as g,t as h,w as f}from"../chunks/index.fcd4cc08.js";import{C as me}from"../chunks/CodeBlock.7b16bdef.js";import{H as P}from"../chunks/Heading.8660bd0e.js";function Le(re){let m,X,Y,E,w,S,b,ce='<a href="https://github.com/mlfoundations/open_clip" rel="nofollow">OpenCLIP</a> is an open-source implementation of OpenAI’s CLIP.',Q,y,G,T,ue='You can find OpenCLIP models by filtering at the left of the <a href="https://huggingface.co/models?library=open_clip&amp;sort=trending" rel="nofollow">models page</a>.',z,$,ge='OpenCLIP models hosted on the Hub have a model card with useful information about the models. Thanks to OpenCLIP Hugging Face Hub integration, you can load OpenCLIP models with a few lines of code. You can also deploy these models using <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoints</a>.',B,C,R,J,he=`To get started, you can follow the <a href="https://github.com/mlfoundations/open_clip#usage" rel="nofollow">OpenCLIP installation guide</a>.
You can also use the following one-line install through pip:`,A,U,N,I,F,j,fe="All OpenCLIP models can easily be loaded from the Hub:",O,_,K,x,de='Once loaded, you can encode the image and text to do <a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">zero-shot image classification</a>:',q,L,D,Z,Me="It outputs the probability of each possible class:",ee,k,te,W,we="If you want to load a specific OpenCLIP model, you can click <code>Use in OpenCLIP</code> in the model card and you will be given a working snippet!",le,d,be='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/openclip_repo_light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/openclip_repo.png"/>',ne,M,ye='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/openclip_snippet_light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/openclip_snippet.png"/>',se,v,ae,H,Te='<li>OpenCLIP <a href="https://github.com/mlfoundations/open_clip" rel="nofollow">repository</a></li> <li>OpenCLIP <a href="https://github.com/mlfoundations/open_clip/tree/main/docs" rel="nofollow">docs</a></li> <li>OpenCLIP <a href="https://huggingface.co/models?library=open_clip&amp;sort=trending" rel="nofollow">models in the Hub</a></li>',ie,V,oe;return w=new P({props:{title:"Using OpenCLIP at Hugging Face",local:"using-openclip-at-hugging-face",headingTag:"h1"}}),y=new P({props:{title:"Exploring OpenCLIP on the Hub",local:"exploring-openclip-on-the-hub",headingTag:"h2"}}),C=new P({props:{title:"Installation",local:"installation",headingTag:"h2"}}),U=new me({props:{code:"JTI0JTIwcGlwJTIwaW5zdGFsbCUyMG9wZW5fY2xpcF90b3JjaA==",highlighted:'$ pip <span class="hljs-keyword">install</span> open_clip_torch',wrap:!1}}),I=new P({props:{title:"Using existing models",local:"using-existing-models",headingTag:"h2"}}),_=new me({props:{code:"aW1wb3J0JTIwb3Blbl9jbGlwJTBBJTBBbW9kZWwlMkMlMjBwcmVwcm9jZXNzJTIwJTNEJTIwb3Blbl9jbGlwLmNyZWF0ZV9tb2RlbF9mcm9tX3ByZXRyYWluZWQoJ2hmLWh1YiUzQWxhaW9uJTJGQ0xJUC1WaVQtZy0xNC1sYWlvbjJCLXMxMkItYjQySycpJTBBdG9rZW5pemVyJTIwJTNEJTIwb3Blbl9jbGlwLmdldF90b2tlbml6ZXIoJ2hmLWh1YiUzQWxhaW9uJTJGQ0xJUC1WaVQtZy0xNC1sYWlvbjJCLXMxMkItYjQySycp",highlighted:`<span class="hljs-keyword">import</span> open_clip

model, preprocess = open_clip.create_model_from_pretrained(<span class="hljs-string">&#x27;hf-hub:laion/CLIP-ViT-g-14-laion2B-s12B-b42K&#x27;</span>)
tokenizer = open_clip.get_tokenizer(<span class="hljs-string">&#x27;hf-hub:laion/CLIP-ViT-g-14-laion2B-s12B-b42K&#x27;</span>)`,wrap:!1}}),L=new me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEF1cmwlMjAlM0QlMjAnaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyclMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbWFnZSUyMCUzRCUyMHByZXByb2Nlc3MoaW1hZ2UpLnVuc3F1ZWV6ZSgwKSUwQXRleHQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyYSUyMGRpYWdyYW0lMjIlMkMlMjAlMjJhJTIwZG9nJTIyJTJDJTIwJTIyYSUyMGNhdCUyMiU1RCklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTJDJTIwdG9yY2guY3VkYS5hbXAuYXV0b2Nhc3QoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX2ZlYXR1cmVzJTIwJTNEJTIwbW9kZWwuZW5jb2RlX2ltYWdlKGltYWdlKSUwQSUyMCUyMCUyMCUyMHRleHRfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5lbmNvZGVfdGV4dCh0ZXh0KSUwQSUyMCUyMCUyMCUyMGltYWdlX2ZlYXR1cmVzJTIwJTJGJTNEJTIwaW1hZ2VfZmVhdHVyZXMubm9ybShkaW0lM0QtMSUyQyUyMGtlZXBkaW0lM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHRleHRfZmVhdHVyZXMlMjAlMkYlM0QlMjB0ZXh0X2ZlYXR1cmVzLm5vcm0oZGltJTNELTElMkMlMjBrZWVwZGltJTNEVHJ1ZSklMEElMEElMjAlMjAlMjAlMjB0ZXh0X3Byb2JzJTIwJTNEJTIwKDEwMC4wJTIwKiUyMGltYWdlX2ZlYXR1cmVzJTIwJTQwJTIwdGV4dF9mZWF0dXJlcy5UKS5zb2Z0bWF4KGRpbSUzRC0xKSUwQSUwQXByaW50KCUyMkxhYmVsJTIwcHJvYnMlM0ElMjIlMkMlMjB0ZXh0X3Byb2JzKSUyMA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image = preprocess(image).unsqueeze(<span class="hljs-number">0</span>)
text = tokenizer([<span class="hljs-string">&quot;a diagram&quot;</span>, <span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>])

<span class="hljs-keyword">with</span> torch.no_grad(), torch.cuda.amp.autocast():
    image_features = model.encode_image(image)
    text_features = model.encode_text(text)
    image_features /= image_features.norm(dim=-<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)
    text_features /= text_features.norm(dim=-<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)

    text_probs = (<span class="hljs-number">100.0</span> * image_features @ text_features.T).softmax(dim=-<span class="hljs-number">1</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Label probs:&quot;</span>, text_probs) `,wrap:!1}}),k=new me({props:{code:"TGFiZWwlMjBwcm9icyUzQSUyMHRlbnNvciglNUIlNUIwLjAwMjAlMkMlMjAwLjAwMzQlMkMlMjAwLjk5NDYlNUQlNUQp",highlighted:"Label probs: tensor([[0.0020, 0.0034, 0.9946]])",wrap:!1}}),v=new P({props:{title:"Additional resources",local:"additional-resources",headingTag:"h2"}}),{c(){m=i("meta"),X=s(),Y=i("p"),E=s(),r(w.$$.fragment),S=s(),b=i("p"),b.innerHTML=ce,Q=s(),r(y.$$.fragment),G=s(),T=i("p"),T.innerHTML=ue,z=s(),$=i("p"),$.innerHTML=ge,B=s(),r(C.$$.fragment),R=s(),J=i("p"),J.innerHTML=he,A=s(),r(U.$$.fragment),N=s(),r(I.$$.fragment),F=s(),j=i("p"),j.textContent=fe,O=s(),r(_.$$.fragment),K=s(),x=i("p"),x.innerHTML=de,q=s(),r(L.$$.fragment),D=s(),Z=i("p"),Z.textContent=Me,ee=s(),r(k.$$.fragment),te=s(),W=i("p"),W.innerHTML=we,le=s(),d=i("div"),d.innerHTML=be,ne=s(),M=i("div"),M.innerHTML=ye,se=s(),r(v.$$.fragment),ae=s(),H=i("ul"),H.innerHTML=Te,ie=s(),V=i("p"),this.h()},l(e){const t=_e("svelte-u9bgzb",document.head);m=o(t,"META",{name:!0,content:!0}),t.forEach(l),X=a(e),Y=o(e,"P",{}),$e(Y).forEach(l),E=a(e),c(w.$$.fragment,e),S=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1gvreai"&&(b.innerHTML=ce),Q=a(e),c(y.$$.fragment,e),G=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-5du578"&&(T.innerHTML=ue),z=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1s055da"&&($.innerHTML=ge),B=a(e),c(C.$$.fragment,e),R=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-8hku74"&&(J.innerHTML=he),A=a(e),c(U.$$.fragment,e),N=a(e),c(I.$$.fragment,e),F=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-c4y4yi"&&(j.textContent=fe),O=a(e),c(_.$$.fragment,e),K=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-bfy175"&&(x.innerHTML=de),q=a(e),c(L.$$.fragment,e),D=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-162gbom"&&(Z.textContent=Me),ee=a(e),c(k.$$.fragment,e),te=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1vnus6m"&&(W.innerHTML=we),le=a(e),d=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-qq7za1"&&(d.innerHTML=be),ne=a(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-1btvat9"&&(M.innerHTML=ye),se=a(e),c(v.$$.fragment,e),ae=a(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-hsv1q9"&&(H.innerHTML=Te),ie=a(e),V=o(e,"P",{}),$e(V).forEach(l),this.h()},h(){pe(m,"name","hf:doc:metadata"),pe(m,"content",Ze),pe(d,"class","flex justify-center"),pe(M,"class","flex justify-center")},m(e,t){xe(document.head,m),n(e,X,t),n(e,Y,t),n(e,E,t),u(w,e,t),n(e,S,t),n(e,b,t),n(e,Q,t),u(y,e,t),n(e,G,t),n(e,T,t),n(e,z,t),n(e,$,t),n(e,B,t),u(C,e,t),n(e,R,t),n(e,J,t),n(e,A,t),u(U,e,t),n(e,N,t),u(I,e,t),n(e,F,t),n(e,j,t),n(e,O,t),u(_,e,t),n(e,K,t),n(e,x,t),n(e,q,t),u(L,e,t),n(e,D,t),n(e,Z,t),n(e,ee,t),u(k,e,t),n(e,te,t),n(e,W,t),n(e,le,t),n(e,d,t),n(e,ne,t),n(e,M,t),n(e,se,t),u(v,e,t),n(e,ae,t),n(e,H,t),n(e,ie,t),n(e,V,t),oe=!0},p:Je,i(e){oe||(g(w.$$.fragment,e),g(y.$$.fragment,e),g(C.$$.fragment,e),g(U.$$.fragment,e),g(I.$$.fragment,e),g(_.$$.fragment,e),g(L.$$.fragment,e),g(k.$$.fragment,e),g(v.$$.fragment,e),oe=!0)},o(e){h(w.$$.fragment,e),h(y.$$.fragment,e),h(C.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h(_.$$.fragment,e),h(L.$$.fragment,e),h(k.$$.fragment,e),h(v.$$.fragment,e),oe=!1},d(e){e&&(l(X),l(Y),l(E),l(S),l(b),l(Q),l(G),l(T),l(z),l($),l(B),l(R),l(J),l(A),l(N),l(F),l(j),l(O),l(K),l(x),l(q),l(D),l(Z),l(ee),l(te),l(W),l(le),l(d),l(ne),l(M),l(se),l(ae),l(H),l(ie),l(V)),l(m),f(w,e),f(y,e),f(C,e),f(U,e),f(I,e),f(_,e),f(L,e),f(k,e),f(v,e)}}}const Ze='{"title":"Using OpenCLIP at Hugging Face","local":"using-openclip-at-hugging-face","sections":[{"title":"Exploring OpenCLIP on the Hub","local":"exploring-openclip-on-the-hub","sections":[],"depth":2},{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Using existing models","local":"using-existing-models","sections":[],"depth":2},{"title":"Additional resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function ke(re){return Ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ve extends Ie{constructor(m){super(),je(this,m,ke,Le,Ce,{})}}export{Ve as component};
