import{s as Pt,o as It,n as xe}from"../chunks/scheduler.182ea377.js";import{S as Jt,i as jt,g as p,s as a,r as v,A as kt,h as c,f as l,c as o,j as P,u as w,x as _,k as I,y as s,a as g,v as $,d as y,t as x,w as M}from"../chunks/index.abf12888.js";import{T as pt}from"../chunks/Tip.230e2334.js";import{D as C}from"../chunks/Docstring.93f6f462.js";import{C as ft}from"../chunks/CodeBlock.57fe6e13.js";import{E as ct}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as dt}from"../chunks/Heading.16916d63.js";function Ct(T){let n,b='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',r,i,u='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=p("p"),n.innerHTML=b,r=a(),i=p("p"),i.innerHTML=u},l(t){n=c(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1j961ct"&&(n.innerHTML=b),r=o(t),i=c(t,"P",{"data-svelte-h":!0}),_(i)!=="svelte-z4pn9c"&&(i.innerHTML=u)},m(t,h){g(t,n,h),g(t,r,h),g(t,i,h)},p:xe,d(t){t&&(l(n),l(r),l(i))}}}function Zt(T){let n,b="Examples:",r,i,u;return i=new ft({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBJTIzJTIwbG9hZCUyMG1vZGVsJTIwYW5kJTIwc2NoZWR1bGVyJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teDQtdXBzY2FsZXIlMjIlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGxldCdzJTIwZG93bmxvYWQlMjBhbiUyMCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnNkMi11cHNjYWxlJTJGbG93X3Jlc19jYXQucG5nJTIyJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWxvd19yZXNfaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFsb3dfcmVzX2ltZyUyMCUzRCUyMGxvd19yZXNfaW1nLnJlc2l6ZSgoMTI4JTJDJTIwMTI4KSklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwd2hpdGUlMjBjYXQlMjIlMEElMEF1cHNjYWxlZF9pbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEbG93X3Jlc19pbWcpLmltYWdlcyU1QjAlNUQlMEF1cHNjYWxlZF9pbWFnZS5zYXZlKCUyMnVwc2FtcGxlZF9jYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionUpscalePipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model and scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionUpscalePipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, revision=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s download an  image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd2-upscale/low_res_cat.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_img = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_img = low_res_img.resize((<span class="hljs-number">128</span>, <span class="hljs-number">128</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a white cat&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image = pipeline(prompt=prompt, image=low_res_img).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image.save(<span class="hljs-string">&quot;upsampled_cat.png&quot;</span>)`,wrap:!1}}),{c(){n=p("p"),n.textContent=b,r=a(),v(i.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-kvfsh7"&&(n.textContent=b),r=o(t),w(i.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),$(i,t,h),u=!0},p:xe,i(t){u||(y(i.$$.fragment,t),u=!0)},o(t){x(i.$$.fragment,t),u=!1},d(t){t&&(l(n),l(r)),M(i,t)}}}function Wt(T){let n,b=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=p("p"),n.innerHTML=b},l(r){n=c(r,"P",{"data-svelte-h":!0}),_(n)!=="svelte-ackzsn"&&(n.innerHTML=b)},m(r,i){g(r,n,i)},p:xe,d(r){r&&l(n)}}}function Gt(T){let n,b="Examples:",r,i,u;return i=new ft({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=p("p"),n.textContent=b,r=a(),v(i.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-kvfsh7"&&(n.textContent=b),r=o(t),w(i.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),$(i,t,h),u=!0},p:xe,i(t){u||(y(i.$$.fragment,t),u=!0)},o(t){x(i.$$.fragment,t),u=!1},d(t){t&&(l(n),l(r)),M(i,t)}}}function Lt(T){let n,b=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=p("p"),n.textContent=b},l(r){n=c(r,"P",{"data-svelte-h":!0}),_(n)!=="svelte-17p1lpg"&&(n.textContent=b)},m(r,i){g(r,n,i)},p:xe,d(r){r&&l(n)}}}function Nt(T){let n,b="Examples:",r,i,u;return i=new ft({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=p("p"),n.textContent=b,r=a(),v(i.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-kvfsh7"&&(n.textContent=b),r=o(t),w(i.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),$(i,t,h),u=!0},p:xe,i(t){u||(y(i.$$.fragment,t),u=!0)},o(t){x(i.$$.fragment,t),u=!1},d(t){t&&(l(n),l(r)),M(i,t)}}}function Bt(T){let n,b,r,i,u,t,h,mt='The Stable Diffusion upscaler diffusion model was created by the researchers and engineers from <a href="https://github.com/CompVis" rel="nofollow">CompVis</a>, <a href="https://stability.ai/" rel="nofollow">Stability AI</a>, and <a href="https://laion.ai/" rel="nofollow">LAION</a>. It is used to enhance the resolution of input images by a factor of 4.',Te,G,Ue,Q,Se,f,A,Ze,re,ut="Pipeline for text-guided image super-resolution using Stable Diffusion 2.",We,pe,gt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ge,ce,ht="The pipeline also inherits the following loading methods:",Le,de,_t='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',Ne,k,Y,Be,fe,bt="The call function to the pipeline for generation.",Fe,L,Xe,U,q,Ee,me,vt=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Re,N,Ve,B,ze,F,O,He,ue,wt=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Qe,S,K,Ae,ge,$t=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Ye,X,qe,E,Oe,R,ee,Ke,he,yt='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',et,V,te,tt,_e,xt="Disables the FreeU mechanism if enabled.",nt,D,ne,st,be,Mt='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',at,ve,Tt="The suffixes after the scaling factors represent the stages where they are being applied.",ot,we,Ut=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,it,z,se,lt,$e,St="Encodes the prompt into text encoder hidden states.",De,ae,Pe,Z,oe,rt,ye,Dt="Output class for Stable Diffusion pipelines.",Ie,Me,Je;return u=new dt({props:{title:"Super-resolution",local:"super-resolution",headingTag:"h1"}}),G=new pt({props:{$$slots:{default:[Ct]},$$scope:{ctx:T}}}),Q=new dt({props:{title:"StableDiffusionUpscalePipeline",local:"diffusers.StableDiffusionUpscalePipeline",headingTag:"h2"}}),A=new C({props:{name:"class diffusers.StableDiffusionUpscalePipeline",anchor:"diffusers.StableDiffusionUpscalePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"low_res_scheduler",val:": DDPMScheduler"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": Optional = None"},{name:"feature_extractor",val:": Optional = None"},{name:"watermarker",val:": Optional = None"},{name:"max_noise_level",val:": int = 350"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionUpscalePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionUpscalePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionUpscalePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionUpscalePipeline.low_res_scheduler",description:`<strong>low_res_scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler used to add initial noise to the low resolution conditioning image. It must be an instance of
<a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>.`,name:"low_res_scheduler"},{anchor:"diffusers.StableDiffusionUpscalePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L70"}}),Y=new C({props:{name:"__call__",anchor:"diffusers.StableDiffusionUpscalePipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"num_inference_steps",val:": int = 75"},{name:"guidance_scale",val:": float = 9.0"},{name:"noise_level",val:": int = 20"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": int = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be upscaled.`,name:"image"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L561",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),L=new ct({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.__call__.example",$$slots:{default:[Zt]},$$scope:{ctx:T}}}),q=new C({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2052"}}),N=new pt({props:{warning:!0,$$slots:{default:[Wt]},$$scope:{ctx:T}}}),B=new ct({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_attention_slicing.example",$$slots:{default:[Gt]},$$scope:{ctx:T}}}),O=new C({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2092"}}),K=new C({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1991"}}),X=new pt({props:{warning:!0,$$slots:{default:[Lt]},$$scope:{ctx:T}}}),E=new ct({props:{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Nt]},$$scope:{ctx:T}}}),ee=new C({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2026"}}),te=new C({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionUpscalePipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L557"}}),ne=new C({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionUpscalePipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L534"}}),se=new C({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionUpscalePipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_upscale.py#L205"}}),ae=new dt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),oe=new C({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),{c(){n=p("meta"),b=a(),r=p("p"),i=a(),v(u.$$.fragment),t=a(),h=p("p"),h.innerHTML=mt,Te=a(),v(G.$$.fragment),Ue=a(),v(Q.$$.fragment),Se=a(),f=p("div"),v(A.$$.fragment),Ze=a(),re=p("p"),re.textContent=ut,We=a(),pe=p("p"),pe.innerHTML=gt,Ge=a(),ce=p("p"),ce.textContent=ht,Le=a(),de=p("ul"),de.innerHTML=_t,Ne=a(),k=p("div"),v(Y.$$.fragment),Be=a(),fe=p("p"),fe.textContent=bt,Fe=a(),v(L.$$.fragment),Xe=a(),U=p("div"),v(q.$$.fragment),Ee=a(),me=p("p"),me.textContent=vt,Re=a(),v(N.$$.fragment),Ve=a(),v(B.$$.fragment),ze=a(),F=p("div"),v(O.$$.fragment),He=a(),ue=p("p"),ue.innerHTML=wt,Qe=a(),S=p("div"),v(K.$$.fragment),Ae=a(),ge=p("p"),ge.innerHTML=$t,Ye=a(),v(X.$$.fragment),qe=a(),v(E.$$.fragment),Oe=a(),R=p("div"),v(ee.$$.fragment),Ke=a(),he=p("p"),he.innerHTML=yt,et=a(),V=p("div"),v(te.$$.fragment),tt=a(),_e=p("p"),_e.textContent=xt,nt=a(),D=p("div"),v(ne.$$.fragment),st=a(),be=p("p"),be.innerHTML=Mt,at=a(),ve=p("p"),ve.textContent=Tt,ot=a(),we=p("p"),we.innerHTML=Ut,it=a(),z=p("div"),v(se.$$.fragment),lt=a(),$e=p("p"),$e.textContent=St,De=a(),v(ae.$$.fragment),Pe=a(),Z=p("div"),v(oe.$$.fragment),rt=a(),ye=p("p"),ye.textContent=Dt,Ie=a(),Me=p("p"),this.h()},l(e){const d=kt("svelte-u9bgzb",document.head);n=c(d,"META",{name:!0,content:!0}),d.forEach(l),b=o(e),r=c(e,"P",{}),P(r).forEach(l),i=o(e),w(u.$$.fragment,e),t=o(e),h=c(e,"P",{"data-svelte-h":!0}),_(h)!=="svelte-1rmru20"&&(h.innerHTML=mt),Te=o(e),w(G.$$.fragment,e),Ue=o(e),w(Q.$$.fragment,e),Se=o(e),f=c(e,"DIV",{class:!0});var m=P(f);w(A.$$.fragment,m),Ze=o(m),re=c(m,"P",{"data-svelte-h":!0}),_(re)!=="svelte-gmgvzq"&&(re.textContent=ut),We=o(m),pe=c(m,"P",{"data-svelte-h":!0}),_(pe)!=="svelte-496sm0"&&(pe.innerHTML=gt),Ge=o(m),ce=c(m,"P",{"data-svelte-h":!0}),_(ce)!=="svelte-14s6m4u"&&(ce.textContent=ht),Le=o(m),de=c(m,"UL",{"data-svelte-h":!0}),_(de)!=="svelte-iou1i9"&&(de.innerHTML=_t),Ne=o(m),k=c(m,"DIV",{class:!0});var W=P(k);w(Y.$$.fragment,W),Be=o(W),fe=c(W,"P",{"data-svelte-h":!0}),_(fe)!=="svelte-50j04k"&&(fe.textContent=bt),Fe=o(W),w(L.$$.fragment,W),W.forEach(l),Xe=o(m),U=c(m,"DIV",{class:!0});var J=P(U);w(q.$$.fragment,J),Ee=o(J),me=c(J,"P",{"data-svelte-h":!0}),_(me)!=="svelte-10jaql7"&&(me.textContent=vt),Re=o(J),w(N.$$.fragment,J),Ve=o(J),w(B.$$.fragment,J),J.forEach(l),ze=o(m),F=c(m,"DIV",{class:!0});var ie=P(F);w(O.$$.fragment,ie),He=o(ie),ue=c(ie,"P",{"data-svelte-h":!0}),_(ue)!=="svelte-1lh0nh5"&&(ue.innerHTML=wt),ie.forEach(l),Qe=o(m),S=c(m,"DIV",{class:!0});var j=P(S);w(K.$$.fragment,j),Ae=o(j),ge=c(j,"P",{"data-svelte-h":!0}),_(ge)!=="svelte-e03q3e"&&(ge.innerHTML=$t),Ye=o(j),w(X.$$.fragment,j),qe=o(j),w(E.$$.fragment,j),j.forEach(l),Oe=o(m),R=c(m,"DIV",{class:!0});var le=P(R);w(ee.$$.fragment,le),Ke=o(le),he=c(le,"P",{"data-svelte-h":!0}),_(he)!=="svelte-1vfte1e"&&(he.innerHTML=yt),le.forEach(l),et=o(m),V=c(m,"DIV",{class:!0});var je=P(V);w(te.$$.fragment,je),tt=o(je),_e=c(je,"P",{"data-svelte-h":!0}),_(_e)!=="svelte-psupw6"&&(_e.textContent=xt),je.forEach(l),nt=o(m),D=c(m,"DIV",{class:!0});var H=P(D);w(ne.$$.fragment,H),st=o(H),be=c(H,"P",{"data-svelte-h":!0}),_(be)!=="svelte-1f3tmq1"&&(be.innerHTML=Mt),at=o(H),ve=c(H,"P",{"data-svelte-h":!0}),_(ve)!=="svelte-xjijlp"&&(ve.textContent=Tt),ot=o(H),we=c(H,"P",{"data-svelte-h":!0}),_(we)!=="svelte-hy0nzs"&&(we.innerHTML=Ut),H.forEach(l),it=o(m),z=c(m,"DIV",{class:!0});var ke=P(z);w(se.$$.fragment,ke),lt=o(ke),$e=c(ke,"P",{"data-svelte-h":!0}),_($e)!=="svelte-16q0ax1"&&($e.textContent=St),ke.forEach(l),m.forEach(l),De=o(e),w(ae.$$.fragment,e),Pe=o(e),Z=c(e,"DIV",{class:!0});var Ce=P(Z);w(oe.$$.fragment,Ce),rt=o(Ce),ye=c(Ce,"P",{"data-svelte-h":!0}),_(ye)!=="svelte-1qpjiuf"&&(ye.textContent=Dt),Ce.forEach(l),Ie=o(e),Me=c(e,"P",{}),P(Me).forEach(l),this.h()},h(){I(n,"name","hf:doc:metadata"),I(n,"content",Ft),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){s(document.head,n),g(e,b,d),g(e,r,d),g(e,i,d),$(u,e,d),g(e,t,d),g(e,h,d),g(e,Te,d),$(G,e,d),g(e,Ue,d),$(Q,e,d),g(e,Se,d),g(e,f,d),$(A,f,null),s(f,Ze),s(f,re),s(f,We),s(f,pe),s(f,Ge),s(f,ce),s(f,Le),s(f,de),s(f,Ne),s(f,k),$(Y,k,null),s(k,Be),s(k,fe),s(k,Fe),$(L,k,null),s(f,Xe),s(f,U),$(q,U,null),s(U,Ee),s(U,me),s(U,Re),$(N,U,null),s(U,Ve),$(B,U,null),s(f,ze),s(f,F),$(O,F,null),s(F,He),s(F,ue),s(f,Qe),s(f,S),$(K,S,null),s(S,Ae),s(S,ge),s(S,Ye),$(X,S,null),s(S,qe),$(E,S,null),s(f,Oe),s(f,R),$(ee,R,null),s(R,Ke),s(R,he),s(f,et),s(f,V),$(te,V,null),s(V,tt),s(V,_e),s(f,nt),s(f,D),$(ne,D,null),s(D,st),s(D,be),s(D,at),s(D,ve),s(D,ot),s(D,we),s(f,it),s(f,z),$(se,z,null),s(z,lt),s(z,$e),g(e,De,d),$(ae,e,d),g(e,Pe,d),g(e,Z,d),$(oe,Z,null),s(Z,rt),s(Z,ye),g(e,Ie,d),g(e,Me,d),Je=!0},p(e,[d]){const m={};d&2&&(m.$$scope={dirty:d,ctx:e}),G.$set(m);const W={};d&2&&(W.$$scope={dirty:d,ctx:e}),L.$set(W);const J={};d&2&&(J.$$scope={dirty:d,ctx:e}),N.$set(J);const ie={};d&2&&(ie.$$scope={dirty:d,ctx:e}),B.$set(ie);const j={};d&2&&(j.$$scope={dirty:d,ctx:e}),X.$set(j);const le={};d&2&&(le.$$scope={dirty:d,ctx:e}),E.$set(le)},i(e){Je||(y(u.$$.fragment,e),y(G.$$.fragment,e),y(Q.$$.fragment,e),y(A.$$.fragment,e),y(Y.$$.fragment,e),y(L.$$.fragment,e),y(q.$$.fragment,e),y(N.$$.fragment,e),y(B.$$.fragment,e),y(O.$$.fragment,e),y(K.$$.fragment,e),y(X.$$.fragment,e),y(E.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),Je=!0)},o(e){x(u.$$.fragment,e),x(G.$$.fragment,e),x(Q.$$.fragment,e),x(A.$$.fragment,e),x(Y.$$.fragment,e),x(L.$$.fragment,e),x(q.$$.fragment,e),x(N.$$.fragment,e),x(B.$$.fragment,e),x(O.$$.fragment,e),x(K.$$.fragment,e),x(X.$$.fragment,e),x(E.$$.fragment,e),x(ee.$$.fragment,e),x(te.$$.fragment,e),x(ne.$$.fragment,e),x(se.$$.fragment,e),x(ae.$$.fragment,e),x(oe.$$.fragment,e),Je=!1},d(e){e&&(l(b),l(r),l(i),l(t),l(h),l(Te),l(Ue),l(Se),l(f),l(De),l(Pe),l(Z),l(Ie),l(Me)),l(n),M(u,e),M(G,e),M(Q,e),M(A),M(Y),M(L),M(q),M(N),M(B),M(O),M(K),M(X),M(E),M(ee),M(te),M(ne),M(se),M(ae,e),M(oe)}}}const Ft='{"title":"Super-resolution","local":"super-resolution","sections":[{"title":"StableDiffusionUpscalePipeline","local":"diffusers.StableDiffusionUpscalePipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Xt(T){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends Jt{constructor(n){super(),jt(this,n,Xt,Bt,Pt,{})}}export{Yt as component};
