import{s as Rn,o as Fn,n as mo}from"../chunks/scheduler.182ea377.js";import{S as Hn,i as Yn,g as a,s,r as c,A as An,h as r,f as o,c as i,j as M,u as m,x as d,k as V,y as t,a as l,v as f,d as u,t as g,w as h}from"../chunks/index.abf12888.js";import{T as En}from"../chunks/Tip.230e2334.js";import{D as Z}from"../chunks/Docstring.93f6f462.js";import{C as Ye}from"../chunks/CodeBlock.57fe6e13.js";import{E as Nn}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as He}from"../chunks/Heading.16916d63.js";function Qn(S){let p,J="🧪 This pipeline is for research purposes only.";return{c(){p=a("p"),p.textContent=J},l(v){p=r(v,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1oxhjjd"&&(p.textContent=J)},m(v,x){l(v,p,x)},p:mo,d(v){v&&o(p)}}}function qn(S){let p,J='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){p=a("p"),p.innerHTML=J},l(v){p=r(v,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1wmc0l4"&&(p.innerHTML=J)},m(v,x){l(v,p,x)},p:mo,d(v){v&&o(p)}}}function On(S){let p,J="Examples:",v,x,$;return x=new Ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9TRFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQSUwQXBpcGUlMjAlM0QlMjBUZXh0VG9WaWRlb1NEUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRhbW8tdmlsYWIlMkZ0ZXh0LXRvLXZpZGVvLW1zLTEuN2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyU3BpZGVybWFuJTIwaXMlMjBzdXJmaW5nJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoSDPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = TextToVideoSDPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt).frames
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`,wrap:!1}}),{c(){p=a("p"),p.textContent=J,v=s(),c(x.$$.fragment)},l(_){p=r(_,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=J),v=i(_),m(x.$$.fragment,_)},m(_,D){l(_,p,D),l(_,v,D),f(x,_,D),$=!0},p:mo,i(_){$||(u(x.$$.fragment,_),$=!0)},o(_){g(x.$$.fragment,_),$=!1},d(_){_&&(o(p),o(v)),h(x,_)}}}function Kn(S){let p,J="Examples:",v,x,$;return x=new Ye({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;spiderman running in the desert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">40</span>, height=<span class="hljs-number">320</span>, width=<span class="hljs-number">576</span>, num_frames=<span class="hljs-number">24</span>).frames
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># safe low-res video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_576_spiderman.mp4&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s offload the text-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and load the image-to-image model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16, revision=<span class="hljs-string">&quot;refs/pr/15&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The VAE consumes A LOT of memory, let&#x27;s make sure we run it in sliced mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_slicing()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now let&#x27;s upscale it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and denoise it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_video(video_frames, output_video_path=<span class="hljs-string">&quot;./video_1024_spiderman.mp4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path`,wrap:!1}}),{c(){p=a("p"),p.textContent=J,v=s(),c(x.$$.fragment)},l(_){p=r(_,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=J),v=i(_),m(x.$$.fragment,_)},m(_,D){l(_,p,D),l(_,v,D),f(x,_,D),$=!0},p:mo,i(_){$||(u(x.$$.fragment,_),$=!0)},o(_){g(x.$$.fragment,_),$=!1},d(_){_&&(o(p),o(v)),h(x,_)}}}function es(S){let p,J,v,x,$,_,D,xt,ee,on='<a href="https://arxiv.org/abs/2308.06571" rel="nofollow">ModelScope Text-to-Video Technical Report</a> is by Jiuniu Wang, Hangjie Yuan, Dayou Chen, Yingya Zhang, Xiang Wang, Shiwei Zhang.',wt,te,nn="The abstract from the paper is:",Mt,oe,sn='<em>This paper introduces ModelScopeT2V, a text-to-video synthesis model that evolves from a text-to-image synthesis model (i.e., Stable Diffusion). ModelScopeT2V incorporates spatio-temporal blocks to ensure consistent frame generation and smooth movement transitions. The model could adapt to varying frame numbers during training and inference, rendering it suitable for both image-text and video-text datasets. ModelScopeT2V brings together three components (i.e., VQGAN, a text encoder, and a denoising UNet), totally comprising 1.7 billion parameters, in which 0.5 billion parameters are dedicated to temporal capabilities. The model demonstrates superior performance over state-of-the-art methods across three evaluation metrics. The code and an online demo are available at <a href="https://modelscope.cn/models/damo/text-to-video-synthesis/summary" rel="nofollow">https://modelscope.cn/models/damo/text-to-video-synthesis/summary</a>.</em>',Vt,ne,an='You can find additional information about Text-to-Video on the <a href="https://modelscope.cn/models/damo/text-to-video-synthesis/summary" rel="nofollow">project page</a>, <a href="https://github.com/modelscope/modelscope/" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/damo-vilab/modelscope-text-to-video-synthesis" rel="nofollow">demo</a>. Official checkpoints can be found at <a href="https://huggingface.co/damo-vilab" rel="nofollow">damo-vilab</a> and <a href="https://huggingface.co/cerspense" rel="nofollow">cerspense</a>.',Zt,se,$t,ie,Jt,ae,rn="Let’s start by generating a short video with the default length of 16 frames (2s at 8 fps):",Dt,re,kt,le,ln=`Diffusers supports different optimization techniques to improve the latency
and memory footprint of a pipeline. Since videos are often more memory-heavy than images,
we can enable CPU offloading and VAE slicing to keep the memory footprint at bay.`,jt,de,dn="Let’s generate a video of 8 seconds (64 frames) on the same GPU using CPU offloading and VAE slicing:",St,pe,Ct,ce,pn="It just takes <strong>7 GBs of GPU memory</strong> to generate the 64 video frames using PyTorch 2.0, “fp16” precision and the techniques mentioned above.",Ut,me,cn="We can also use a different scheduler easily, using the same method we’d use for Stable Diffusion:",Pt,fe,Gt,ue,mn="Here are some sample outputs:",It,ge,fn=`<tbody><tr><td><center>An astronaut riding a horse.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astr.gif" alt="An astronaut riding a horse." style="width: 300px;"/></center></td> <td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/vader.gif" alt="Darth vader surfing in waves." style="width: 300px;"/></center></td></tr></tbody>`,Wt,he,Bt,_e,un=`Zeroscope are watermark-free model and have been trained on specific sizes such as <code>576x320</code> and <code>1024x576</code>.
One should first generate a video using the lower resolution checkpoint <a href="https://huggingface.co/cerspense/zeroscope_v2_576w" rel="nofollow"><code>cerspense/zeroscope_v2_576w</code></a> with <a href="/docs/diffusers/v0.24.0/en/api/pipelines/text_to_video#diffusers.TextToVideoSDPipeline">TextToVideoSDPipeline</a>,
which can then be upscaled using <a href="/docs/diffusers/v0.24.0/en/api/pipelines/text_to_video#diffusers.VideoToVideoSDPipeline">VideoToVideoSDPipeline</a> and <a href="https://huggingface.co/cerspense/zeroscope_v2_XL" rel="nofollow"><code>cerspense/zeroscope_v2_XL</code></a>.`,Xt,ve,Lt,be,gn="Now the video can be upscaled:",zt,Te,Et,ye,hn="Here are some sample outputs:",Nt,xe,_n=`<tbody><tr><td><center>Darth vader surfing in waves.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/darthvader_cerpense.gif" alt="Darth vader surfing in waves." style="width: 576px;"/></center></td></tr></tbody>`,Rt,I,Ft,we,Ht,b,Me,fo,Ae,vn="Pipeline for text-to-video generation.",uo,Qe,bn=`This model inherits from <a href="/docs/diffusers/v0.24.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,go,C,Ve,ho,qe,Tn="The call function to the pipeline for generation.",_o,W,vo,B,Ze,bo,Oe,yn="Disables the FreeU mechanism if enabled.",To,X,$e,yo,Ke,xn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,xo,L,Je,wo,et,wn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Mo,k,De,Vo,tt,Mn='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Zo,ot,Vn="The suffixes after the scaling factors represent the stages where they are being applied.",$o,nt,Zn=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Jo,z,ke,Do,st,$n=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ko,E,je,jo,it,Jn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,So,N,Se,Co,at,Dn="Encodes the prompt into text encoder hidden states.",Yt,Ce,At,T,Ue,Uo,rt,kn="Pipeline for text-guided video-to-video generation.",Po,lt,jn=`This model inherits from <a href="/docs/diffusers/v0.24.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Go,U,Pe,Io,dt,Sn="The call function to the pipeline for generation.",Wo,R,Bo,F,Ge,Xo,pt,Cn="Disables the FreeU mechanism if enabled.",Lo,H,Ie,zo,ct,Un=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Eo,Y,We,No,mt,Pn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ro,j,Be,Fo,ft,Gn='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Ho,ut,In="The suffixes after the scaling factors represent the stages where they are being applied.",Yo,gt,Wn=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Ao,A,Xe,Qo,ht,Bn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,qo,Q,Le,Oo,_t,Xn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Ko,q,ze,en,vt,Ln="Encodes the prompt into text encoder hidden states.",Qt,Ee,qt,P,Ne,tn,bt,zn="Output class for text-to-video pipelines.",Ot,yt,Kt;return $=new En({props:{warning:!0,$$slots:{default:[Qn]},$$scope:{ctx:S}}}),D=new He({props:{title:"Text-to-video",local:"text-to-video",headingTag:"h1"}}),se=new He({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ie=new He({props:{title:"text-to-video-ms-1.7b",local:"text-to-video-ms-17b",headingTag:"h3"}}),re=new Ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCkuZnJhbWVzJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGV4cG9ydF90b192aWRlbyh2aWRlb19mcmFtZXMpJTBBdmlkZW9fcGF0aA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),pe=new Ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMG1lbW9yeSUyMG9wdGltaXphdGlvbiUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJEYXJ0aCUyMFZhZGVyJTIwc3VyZmluZyUyMGElMjB3YXZlJTIyJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1fZnJhbWVzJTNENjQpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">64</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),fe=new Ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJkYW1vLXZpbGFiJTJGdGV4dC10by12aWRlby1tcy0xLjdiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTcGlkZXJtYW4lMjBpcyUyMHN1cmZpbmclMjIlMEF2aWRlb19mcmFtZXMlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuZnJhbWVzJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGV4cG9ydF90b192aWRlbyh2aWRlb19mcmFtZXMpJTBBdmlkZW9fcGF0aA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;damo-vilab/text-to-video-ms-1.7b&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;Spiderman is surfing&quot;</span>
video_frames = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),he=new He({props:{title:"cerspense/zeroscope_v2_576w & cerspense/zeroscope_v2_XL",local:"cerspensezeroscopev2576w--cerspensezeroscopev2xl",headingTag:"h3"}}),ve=new Ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfNTc2dyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwbWVtb3J5JTIwb3B0aW1pemF0aW9uJTBBcGlwZS51bmV0LmVuYWJsZV9mb3J3YXJkX2NodW5raW5nKGNodW5rX3NpemUlM0QxJTJDJTIwZGltJTNEMSklMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRGFydGglMjBWYWRlciUyMHN1cmZpbmclMjBhJTIwd2F2ZSUyMiUwQXZpZGVvX2ZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2ZyYW1lcyUzRDI0KS5mcmFtZXMlMEF2aWRlb19wYXRoJTIwJTNEJTIwZXhwb3J0X3RvX3ZpZGVvKHZpZGVvX2ZyYW1lcyklMEF2aWRlb19wYXRo",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_576w&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

prompt = <span class="hljs-string">&quot;Darth Vader surfing a wave&quot;</span>
video_frames = pipe(prompt, num_frames=<span class="hljs-number">24</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),Te=new Ye({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJjZXJzcGVuc2UlMkZ6ZXJvc2NvcGVfdjJfWEwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEElMjMlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEFwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoY2h1bmtfc2l6ZSUzRDElMkMlMjBkaW0lM0QxKSUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEF2aWRlbyUyMCUzRCUyMCU1QkltYWdlLmZyb21hcnJheShmcmFtZSkucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMjBmb3IlMjBmcmFtZSUyMGluJTIwdmlkZW9fZnJhbWVzJTVEJTBBJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjB2aWRlbyUzRHZpZGVvJTJDJTIwc3RyZW5ndGglM0QwLjYpLmZyYW1lcyUwQXZpZGVvX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fdmlkZW8odmlkZW9fZnJhbWVzKSUwQXZpZGVvX3BhdGg=",highlighted:`pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;cerspense/zeroscope_v2_XL&quot;</span>, torch_dtype=torch.float16)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># memory optimization</span>
pipe.unet.enable_forward_chunking(chunk_size=<span class="hljs-number">1</span>, dim=<span class="hljs-number">1</span>)
pipe.enable_vae_slicing()

video = [Image.fromarray(frame).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video_frames]

video_frames = pipe(prompt, video=video, strength=<span class="hljs-number">0.6</span>).frames
video_path = export_to_video(video_frames)
video_path`,wrap:!1}}),I=new En({props:{$$slots:{default:[qn]},$$scope:{ctx:S}}}),we=new He({props:{title:"TextToVideoSDPipeline",local:"diffusers.TextToVideoSDPipeline",headingTag:"h2"}}),Me=new Z({props:{name:"class diffusers.TextToVideoSDPipeline",anchor:"diffusers.TextToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.24.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.TextToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.TextToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.35.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.TextToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.24.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.24.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.TextToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.24.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.24.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.24.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.24.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L79"}}),Ve=new Z({props:{name:"__call__",anchor:"diffusers.TextToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": int = 16"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.24.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.24.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.TextToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L516",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.24.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.24.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),W=new Nn({props:{anchor:"diffusers.TextToVideoSDPipeline.__call__.example",$$slots:{default:[On]},$$scope:{ctx:S}}}),Ze=new Z({props:{name:"disable_freeu",anchor:"diffusers.TextToVideoSDPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L512"}}),$e=new Z({props:{name:"disable_vae_slicing",anchor:"diffusers.TextToVideoSDPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L130"}}),Je=new Z({props:{name:"disable_vae_tiling",anchor:"diffusers.TextToVideoSDPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L147"}}),De=new Z({props:{name:"enable_freeu",anchor:"diffusers.TextToVideoSDPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.TextToVideoSDPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L489"}}),ke=new Z({props:{name:"enable_vae_slicing",anchor:"diffusers.TextToVideoSDPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L122"}}),je=new Z({props:{name:"enable_vae_tiling",anchor:"diffusers.TextToVideoSDPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L138"}}),Se=new Z({props:{name:"encode_prompt",anchor:"diffusers.TextToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.TextToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth.py#L188"}}),Ce=new He({props:{title:"VideoToVideoSDPipeline",local:"diffusers.VideoToVideoSDPipeline",headingTag:"h2"}}),Ue=new Z({props:{name:"class diffusers.VideoToVideoSDPipeline",anchor:"diffusers.VideoToVideoSDPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet3DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.24.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.VideoToVideoSDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.VideoToVideoSDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.35.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.VideoToVideoSDPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.24.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.24.0/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.VideoToVideoSDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.24.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.24.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.24.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.24.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L155"}}),Pe=new Z({props:{name:"__call__",anchor:"diffusers.VideoToVideoSDPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"video",val:": typing.Union[typing.List[numpy.ndarray], torch.FloatTensor] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 15.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.video",description:`<strong>video</strong> (<code>List[np.ndarray]</code> or <code>torch.FloatTensor</code>) &#x2014;
<code>video</code> frames or tensor representing a video batch to be used as the starting point for the process.
Can also accept video latents as <code>image</code>, if passing latents directly, it will not be encoded again.`,name:"video"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>video</code>. Must be between 0 and 1. <code>video</code> is used as a
starting point, adding more noise to it the larger the <code>strength</code>. The number of denoising steps
depends on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the
denoising process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of
1 essentially ignores <code>video</code>.`,name:"strength"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in video generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.24.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.24.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.VideoToVideoSDPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L621",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.24.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.24.0/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),R=new Nn({props:{anchor:"diffusers.VideoToVideoSDPipeline.__call__.example",$$slots:{default:[Kn]},$$scope:{ctx:S}}}),Ge=new Z({props:{name:"disable_freeu",anchor:"diffusers.VideoToVideoSDPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L617"}}),Ie=new Z({props:{name:"disable_vae_slicing",anchor:"diffusers.VideoToVideoSDPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L206"}}),We=new Z({props:{name:"disable_vae_tiling",anchor:"diffusers.VideoToVideoSDPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L223"}}),Be=new Z({props:{name:"enable_freeu",anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.VideoToVideoSDPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L594"}}),Xe=new Z({props:{name:"enable_vae_slicing",anchor:"diffusers.VideoToVideoSDPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L198"}}),Le=new Z({props:{name:"enable_vae_tiling",anchor:"diffusers.VideoToVideoSDPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L214"}}),ze=new Z({props:{name:"encode_prompt",anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.VideoToVideoSDPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_synth_img2img.py#L264"}}),Ee=new He({props:{title:"TextToVideoSDPipelineOutput",local:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",headingTag:"h2"}}),Ne=new Z({props:{name:"class diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput",parameters:[{name:"frames",val:": typing.Union[typing.List[numpy.ndarray], torch.FloatTensor]"}],parametersDescription:[{anchor:"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput.frames",description:`<strong>frames</strong> (<code>List[np.ndarray]</code> or <code>torch.FloatTensor</code>) &#x2014;
List of denoised frames (essentially images) as NumPy arrays of shape <code>(height, width, num_channels)</code> or as
a <code>torch</code> tensor. The length of the list denotes the video length (the number of frames).`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/v0.24.0/src/diffusers/pipelines/text_to_video_synthesis/pipeline_output.py#L13"}}),{c(){p=a("meta"),J=s(),v=a("p"),x=s(),c($.$$.fragment),_=s(),c(D.$$.fragment),xt=s(),ee=a("p"),ee.innerHTML=on,wt=s(),te=a("p"),te.textContent=nn,Mt=s(),oe=a("p"),oe.innerHTML=sn,Vt=s(),ne=a("p"),ne.innerHTML=an,Zt=s(),c(se.$$.fragment),$t=s(),c(ie.$$.fragment),Jt=s(),ae=a("p"),ae.textContent=rn,Dt=s(),c(re.$$.fragment),kt=s(),le=a("p"),le.textContent=ln,jt=s(),de=a("p"),de.textContent=dn,St=s(),c(pe.$$.fragment),Ct=s(),ce=a("p"),ce.innerHTML=pn,Ut=s(),me=a("p"),me.textContent=cn,Pt=s(),c(fe.$$.fragment),Gt=s(),ue=a("p"),ue.textContent=mn,It=s(),ge=a("table"),ge.innerHTML=fn,Wt=s(),c(he.$$.fragment),Bt=s(),_e=a("p"),_e.innerHTML=un,Xt=s(),c(ve.$$.fragment),Lt=s(),be=a("p"),be.textContent=gn,zt=s(),c(Te.$$.fragment),Et=s(),ye=a("p"),ye.textContent=hn,Nt=s(),xe=a("table"),xe.innerHTML=_n,Rt=s(),c(I.$$.fragment),Ft=s(),c(we.$$.fragment),Ht=s(),b=a("div"),c(Me.$$.fragment),fo=s(),Ae=a("p"),Ae.textContent=vn,uo=s(),Qe=a("p"),Qe.innerHTML=bn,go=s(),C=a("div"),c(Ve.$$.fragment),ho=s(),qe=a("p"),qe.textContent=Tn,_o=s(),c(W.$$.fragment),vo=s(),B=a("div"),c(Ze.$$.fragment),bo=s(),Oe=a("p"),Oe.textContent=yn,To=s(),X=a("div"),c($e.$$.fragment),yo=s(),Ke=a("p"),Ke.innerHTML=xn,xo=s(),L=a("div"),c(Je.$$.fragment),wo=s(),et=a("p"),et.innerHTML=wn,Mo=s(),k=a("div"),c(De.$$.fragment),Vo=s(),tt=a("p"),tt.innerHTML=Mn,Zo=s(),ot=a("p"),ot.textContent=Vn,$o=s(),nt=a("p"),nt.innerHTML=Zn,Jo=s(),z=a("div"),c(ke.$$.fragment),Do=s(),st=a("p"),st.textContent=$n,ko=s(),E=a("div"),c(je.$$.fragment),jo=s(),it=a("p"),it.textContent=Jn,So=s(),N=a("div"),c(Se.$$.fragment),Co=s(),at=a("p"),at.textContent=Dn,Yt=s(),c(Ce.$$.fragment),At=s(),T=a("div"),c(Ue.$$.fragment),Uo=s(),rt=a("p"),rt.textContent=kn,Po=s(),lt=a("p"),lt.innerHTML=jn,Go=s(),U=a("div"),c(Pe.$$.fragment),Io=s(),dt=a("p"),dt.textContent=Sn,Wo=s(),c(R.$$.fragment),Bo=s(),F=a("div"),c(Ge.$$.fragment),Xo=s(),pt=a("p"),pt.textContent=Cn,Lo=s(),H=a("div"),c(Ie.$$.fragment),zo=s(),ct=a("p"),ct.innerHTML=Un,Eo=s(),Y=a("div"),c(We.$$.fragment),No=s(),mt=a("p"),mt.innerHTML=Pn,Ro=s(),j=a("div"),c(Be.$$.fragment),Fo=s(),ft=a("p"),ft.innerHTML=Gn,Ho=s(),ut=a("p"),ut.textContent=In,Yo=s(),gt=a("p"),gt.innerHTML=Wn,Ao=s(),A=a("div"),c(Xe.$$.fragment),Qo=s(),ht=a("p"),ht.textContent=Bn,qo=s(),Q=a("div"),c(Le.$$.fragment),Oo=s(),_t=a("p"),_t.textContent=Xn,Ko=s(),q=a("div"),c(ze.$$.fragment),en=s(),vt=a("p"),vt.textContent=Ln,Qt=s(),c(Ee.$$.fragment),qt=s(),P=a("div"),c(Ne.$$.fragment),tn=s(),bt=a("p"),bt.textContent=zn,Ot=s(),yt=a("p"),this.h()},l(e){const n=An("svelte-u9bgzb",document.head);p=r(n,"META",{name:!0,content:!0}),n.forEach(o),J=i(e),v=r(e,"P",{}),M(v).forEach(o),x=i(e),m($.$$.fragment,e),_=i(e),m(D.$$.fragment,e),xt=i(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-17trsey"&&(ee.innerHTML=on),wt=i(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1cwsb16"&&(te.textContent=nn),Mt=i(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1ovx0um"&&(oe.innerHTML=sn),Vt=i(e),ne=r(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-9292p9"&&(ne.innerHTML=an),Zt=i(e),m(se.$$.fragment,e),$t=i(e),m(ie.$$.fragment,e),Jt=i(e),ae=r(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-a4ktac"&&(ae.textContent=rn),Dt=i(e),m(re.$$.fragment,e),kt=i(e),le=r(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1gwbshq"&&(le.textContent=ln),jt=i(e),de=r(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-yoc5w4"&&(de.textContent=dn),St=i(e),m(pe.$$.fragment,e),Ct=i(e),ce=r(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-m9rmsr"&&(ce.innerHTML=pn),Ut=i(e),me=r(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1yxs7ur"&&(me.textContent=cn),Pt=i(e),m(fe.$$.fragment,e),Gt=i(e),ue=r(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1pxzje"&&(ue.textContent=mn),It=i(e),ge=r(e,"TABLE",{"data-svelte-h":!0}),d(ge)!=="svelte-5s26g4"&&(ge.innerHTML=fn),Wt=i(e),m(he.$$.fragment,e),Bt=i(e),_e=r(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-5yissm"&&(_e.innerHTML=un),Xt=i(e),m(ve.$$.fragment,e),Lt=i(e),be=r(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-4ywac8"&&(be.textContent=gn),zt=i(e),m(Te.$$.fragment,e),Et=i(e),ye=r(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1pxzje"&&(ye.textContent=hn),Nt=i(e),xe=r(e,"TABLE",{"data-svelte-h":!0}),d(xe)!=="svelte-9iw63g"&&(xe.innerHTML=_n),Rt=i(e),m(I.$$.fragment,e),Ft=i(e),m(we.$$.fragment,e),Ht=i(e),b=r(e,"DIV",{class:!0});var y=M(b);m(Me.$$.fragment,y),fo=i(y),Ae=r(y,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-19ipoo4"&&(Ae.textContent=vn),uo=i(y),Qe=r(y,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-kecqr7"&&(Qe.innerHTML=bn),go=i(y),C=r(y,"DIV",{class:!0});var G=M(C);m(Ve.$$.fragment,G),ho=i(G),qe=r(G,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-50j04k"&&(qe.textContent=Tn),_o=i(G),m(W.$$.fragment,G),G.forEach(o),vo=i(y),B=r(y,"DIV",{class:!0});var Re=M(B);m(Ze.$$.fragment,Re),bo=i(Re),Oe=r(Re,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-psupw6"&&(Oe.textContent=yn),Re.forEach(o),To=i(y),X=r(y,"DIV",{class:!0});var Fe=M(X);m($e.$$.fragment,Fe),yo=i(Fe),Ke=r(Fe,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1s3c06i"&&(Ke.innerHTML=xn),Fe.forEach(o),xo=i(y),L=r(y,"DIV",{class:!0});var eo=M(L);m(Je.$$.fragment,eo),wo=i(eo),et=r(eo,"P",{"data-svelte-h":!0}),d(et)!=="svelte-pkn4ui"&&(et.innerHTML=wn),eo.forEach(o),Mo=i(y),k=r(y,"DIV",{class:!0});var O=M(k);m(De.$$.fragment,O),Vo=i(O),tt=r(O,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1f3tmq1"&&(tt.innerHTML=Mn),Zo=i(O),ot=r(O,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-xjijlp"&&(ot.textContent=Vn),$o=i(O),nt=r(O,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-hy0nzs"&&(nt.innerHTML=Zn),O.forEach(o),Jo=i(y),z=r(y,"DIV",{class:!0});var to=M(z);m(ke.$$.fragment,to),Do=i(to),st=r(to,"P",{"data-svelte-h":!0}),d(st)!=="svelte-14bnrb6"&&(st.textContent=$n),to.forEach(o),ko=i(y),E=r(y,"DIV",{class:!0});var oo=M(E);m(je.$$.fragment,oo),jo=i(oo),it=r(oo,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1xwrf7t"&&(it.textContent=Jn),oo.forEach(o),So=i(y),N=r(y,"DIV",{class:!0});var no=M(N);m(Se.$$.fragment,no),Co=i(no),at=r(no,"P",{"data-svelte-h":!0}),d(at)!=="svelte-16q0ax1"&&(at.textContent=Dn),no.forEach(o),y.forEach(o),Yt=i(e),m(Ce.$$.fragment,e),At=i(e),T=r(e,"DIV",{class:!0});var w=M(T);m(Ue.$$.fragment,w),Uo=i(w),rt=r(w,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1oyadpc"&&(rt.textContent=kn),Po=i(w),lt=r(w,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-kecqr7"&&(lt.innerHTML=jn),Go=i(w),U=r(w,"DIV",{class:!0});var Tt=M(U);m(Pe.$$.fragment,Tt),Io=i(Tt),dt=r(Tt,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-50j04k"&&(dt.textContent=Sn),Wo=i(Tt),m(R.$$.fragment,Tt),Tt.forEach(o),Bo=i(w),F=r(w,"DIV",{class:!0});var so=M(F);m(Ge.$$.fragment,so),Xo=i(so),pt=r(so,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-psupw6"&&(pt.textContent=Cn),so.forEach(o),Lo=i(w),H=r(w,"DIV",{class:!0});var io=M(H);m(Ie.$$.fragment,io),zo=i(io),ct=r(io,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1s3c06i"&&(ct.innerHTML=Un),io.forEach(o),Eo=i(w),Y=r(w,"DIV",{class:!0});var ao=M(Y);m(We.$$.fragment,ao),No=i(ao),mt=r(ao,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-pkn4ui"&&(mt.innerHTML=Pn),ao.forEach(o),Ro=i(w),j=r(w,"DIV",{class:!0});var K=M(j);m(Be.$$.fragment,K),Fo=i(K),ft=r(K,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1f3tmq1"&&(ft.innerHTML=Gn),Ho=i(K),ut=r(K,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-xjijlp"&&(ut.textContent=In),Yo=i(K),gt=r(K,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-hy0nzs"&&(gt.innerHTML=Wn),K.forEach(o),Ao=i(w),A=r(w,"DIV",{class:!0});var ro=M(A);m(Xe.$$.fragment,ro),Qo=i(ro),ht=r(ro,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-14bnrb6"&&(ht.textContent=Bn),ro.forEach(o),qo=i(w),Q=r(w,"DIV",{class:!0});var lo=M(Q);m(Le.$$.fragment,lo),Oo=i(lo),_t=r(lo,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-1xwrf7t"&&(_t.textContent=Xn),lo.forEach(o),Ko=i(w),q=r(w,"DIV",{class:!0});var po=M(q);m(ze.$$.fragment,po),en=i(po),vt=r(po,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-16q0ax1"&&(vt.textContent=Ln),po.forEach(o),w.forEach(o),Qt=i(e),m(Ee.$$.fragment,e),qt=i(e),P=r(e,"DIV",{class:!0});var co=M(P);m(Ne.$$.fragment,co),tn=i(co),bt=r(co,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-1uuckb2"&&(bt.textContent=zn),co.forEach(o),Ot=i(e),yt=r(e,"P",{}),M(yt).forEach(o),this.h()},h(){V(p,"name","hf:doc:metadata"),V(p,"content",ts),V(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){t(document.head,p),l(e,J,n),l(e,v,n),l(e,x,n),f($,e,n),l(e,_,n),f(D,e,n),l(e,xt,n),l(e,ee,n),l(e,wt,n),l(e,te,n),l(e,Mt,n),l(e,oe,n),l(e,Vt,n),l(e,ne,n),l(e,Zt,n),f(se,e,n),l(e,$t,n),f(ie,e,n),l(e,Jt,n),l(e,ae,n),l(e,Dt,n),f(re,e,n),l(e,kt,n),l(e,le,n),l(e,jt,n),l(e,de,n),l(e,St,n),f(pe,e,n),l(e,Ct,n),l(e,ce,n),l(e,Ut,n),l(e,me,n),l(e,Pt,n),f(fe,e,n),l(e,Gt,n),l(e,ue,n),l(e,It,n),l(e,ge,n),l(e,Wt,n),f(he,e,n),l(e,Bt,n),l(e,_e,n),l(e,Xt,n),f(ve,e,n),l(e,Lt,n),l(e,be,n),l(e,zt,n),f(Te,e,n),l(e,Et,n),l(e,ye,n),l(e,Nt,n),l(e,xe,n),l(e,Rt,n),f(I,e,n),l(e,Ft,n),f(we,e,n),l(e,Ht,n),l(e,b,n),f(Me,b,null),t(b,fo),t(b,Ae),t(b,uo),t(b,Qe),t(b,go),t(b,C),f(Ve,C,null),t(C,ho),t(C,qe),t(C,_o),f(W,C,null),t(b,vo),t(b,B),f(Ze,B,null),t(B,bo),t(B,Oe),t(b,To),t(b,X),f($e,X,null),t(X,yo),t(X,Ke),t(b,xo),t(b,L),f(Je,L,null),t(L,wo),t(L,et),t(b,Mo),t(b,k),f(De,k,null),t(k,Vo),t(k,tt),t(k,Zo),t(k,ot),t(k,$o),t(k,nt),t(b,Jo),t(b,z),f(ke,z,null),t(z,Do),t(z,st),t(b,ko),t(b,E),f(je,E,null),t(E,jo),t(E,it),t(b,So),t(b,N),f(Se,N,null),t(N,Co),t(N,at),l(e,Yt,n),f(Ce,e,n),l(e,At,n),l(e,T,n),f(Ue,T,null),t(T,Uo),t(T,rt),t(T,Po),t(T,lt),t(T,Go),t(T,U),f(Pe,U,null),t(U,Io),t(U,dt),t(U,Wo),f(R,U,null),t(T,Bo),t(T,F),f(Ge,F,null),t(F,Xo),t(F,pt),t(T,Lo),t(T,H),f(Ie,H,null),t(H,zo),t(H,ct),t(T,Eo),t(T,Y),f(We,Y,null),t(Y,No),t(Y,mt),t(T,Ro),t(T,j),f(Be,j,null),t(j,Fo),t(j,ft),t(j,Ho),t(j,ut),t(j,Yo),t(j,gt),t(T,Ao),t(T,A),f(Xe,A,null),t(A,Qo),t(A,ht),t(T,qo),t(T,Q),f(Le,Q,null),t(Q,Oo),t(Q,_t),t(T,Ko),t(T,q),f(ze,q,null),t(q,en),t(q,vt),l(e,Qt,n),f(Ee,e,n),l(e,qt,n),l(e,P,n),f(Ne,P,null),t(P,tn),t(P,bt),l(e,Ot,n),l(e,yt,n),Kt=!0},p(e,[n]){const y={};n&2&&(y.$$scope={dirty:n,ctx:e}),$.$set(y);const G={};n&2&&(G.$$scope={dirty:n,ctx:e}),I.$set(G);const Re={};n&2&&(Re.$$scope={dirty:n,ctx:e}),W.$set(Re);const Fe={};n&2&&(Fe.$$scope={dirty:n,ctx:e}),R.$set(Fe)},i(e){Kt||(u($.$$.fragment,e),u(D.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(ve.$$.fragment,e),u(Te.$$.fragment,e),u(I.$$.fragment,e),u(we.$$.fragment,e),u(Me.$$.fragment,e),u(Ve.$$.fragment,e),u(W.$$.fragment,e),u(Ze.$$.fragment,e),u($e.$$.fragment,e),u(Je.$$.fragment,e),u(De.$$.fragment,e),u(ke.$$.fragment,e),u(je.$$.fragment,e),u(Se.$$.fragment,e),u(Ce.$$.fragment,e),u(Ue.$$.fragment,e),u(Pe.$$.fragment,e),u(R.$$.fragment,e),u(Ge.$$.fragment,e),u(Ie.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u(Xe.$$.fragment,e),u(Le.$$.fragment,e),u(ze.$$.fragment,e),u(Ee.$$.fragment,e),u(Ne.$$.fragment,e),Kt=!0)},o(e){g($.$$.fragment,e),g(D.$$.fragment,e),g(se.$$.fragment,e),g(ie.$$.fragment,e),g(re.$$.fragment,e),g(pe.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g(I.$$.fragment,e),g(we.$$.fragment,e),g(Me.$$.fragment,e),g(Ve.$$.fragment,e),g(W.$$.fragment,e),g(Ze.$$.fragment,e),g($e.$$.fragment,e),g(Je.$$.fragment,e),g(De.$$.fragment,e),g(ke.$$.fragment,e),g(je.$$.fragment,e),g(Se.$$.fragment,e),g(Ce.$$.fragment,e),g(Ue.$$.fragment,e),g(Pe.$$.fragment,e),g(R.$$.fragment,e),g(Ge.$$.fragment,e),g(Ie.$$.fragment,e),g(We.$$.fragment,e),g(Be.$$.fragment,e),g(Xe.$$.fragment,e),g(Le.$$.fragment,e),g(ze.$$.fragment,e),g(Ee.$$.fragment,e),g(Ne.$$.fragment,e),Kt=!1},d(e){e&&(o(J),o(v),o(x),o(_),o(xt),o(ee),o(wt),o(te),o(Mt),o(oe),o(Vt),o(ne),o(Zt),o($t),o(Jt),o(ae),o(Dt),o(kt),o(le),o(jt),o(de),o(St),o(Ct),o(ce),o(Ut),o(me),o(Pt),o(Gt),o(ue),o(It),o(ge),o(Wt),o(Bt),o(_e),o(Xt),o(Lt),o(be),o(zt),o(Et),o(ye),o(Nt),o(xe),o(Rt),o(Ft),o(Ht),o(b),o(Yt),o(At),o(T),o(Qt),o(qt),o(P),o(Ot),o(yt)),o(p),h($,e),h(D,e),h(se,e),h(ie,e),h(re,e),h(pe,e),h(fe,e),h(he,e),h(ve,e),h(Te,e),h(I,e),h(we,e),h(Me),h(Ve),h(W),h(Ze),h($e),h(Je),h(De),h(ke),h(je),h(Se),h(Ce,e),h(Ue),h(Pe),h(R),h(Ge),h(Ie),h(We),h(Be),h(Xe),h(Le),h(ze),h(Ee,e),h(Ne)}}}const ts='{"title":"Text-to-video","local":"text-to-video","sections":[{"title":"Usage example","local":"usage-example","sections":[{"title":"text-to-video-ms-1.7b","local":"text-to-video-ms-17b","sections":[],"depth":3},{"title":"cerspense/zeroscope_v2_576w & cerspense/zeroscope_v2_XL","local":"cerspensezeroscopev2576w--cerspensezeroscopev2xl","sections":[],"depth":3}],"depth":2},{"title":"TextToVideoSDPipeline","local":"diffusers.TextToVideoSDPipeline","sections":[],"depth":2},{"title":"VideoToVideoSDPipeline","local":"diffusers.VideoToVideoSDPipeline","sections":[],"depth":2},{"title":"TextToVideoSDPipelineOutput","local":"diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput","sections":[],"depth":2}],"depth":1}';function os(S){return Fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ps extends Hn{constructor(p){super(),Yn(this,p,os,es,Rn,{})}}export{ps as component};
