import{s as bi,o as _i,n as wi}from"../chunks/scheduler.53228c21.js";import{S as Ti,i as Ji,e as l,s as a,c as o,h as Ui,a as r,d as n,b as s,f as Ae,g as p,j as u,k as T,l as y,m as i,n as d,t as c,o as m,p as f}from"../chunks/index.100fac89.js";import{C as Zi}from"../chunks/CopyLLMTxtMenu.4f0519ef.js";import{D as lt}from"../chunks/Docstring.d02a9fa5.js";import{C as b}from"../chunks/CodeBlock.d30a6509.js";import{E as ji}from"../chunks/ExampleCodeBlock.38517eb4.js";import{H as g,E as Ii}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.62dbb7c4.js";function Bi(ot){let M,X="Examples:",j,J,U;return J=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkMy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusion3Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3.png&quot;</span>)`,wrap:!1}}),{c(){M=l("p"),M.textContent=X,j=a(),o(J.$$.fragment)},l(h){M=r(h,"P",{"data-svelte-h":!0}),u(M)!=="svelte-kvfsh7"&&(M.textContent=X),j=s(h),p(J.$$.fragment,h)},m(h,Z){i(h,M,Z),i(h,j,Z),d(J,h,Z),U=!0},p:wi,i(h){U||(c(J.$$.fragment,h),U=!0)},o(h){m(J.$$.fragment,h),U=!1},d(h){h&&(n(M),n(j)),f(J,h)}}}function vi(ot){let M,X,j,J,U,h,Z,rt,v,Rn='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/> <img alt="MPS" src="https://img.shields.io/badge/MPS-000000?style=flat&amp;logo=apple&amp;logoColor=white%22"/>',pt,Y,Xn='Stable Diffusion 3 (SD3) was proposed in <a href="https://huggingface.co/papers/2403.03206" rel="nofollow">Scaling Rectified Flow Transformers for High-Resolution Image Synthesis</a> by Patrick Esser, Sumith Kulal, Andreas Blattmann, Rahim Entezari, Jonas Muller, Harry Saini, Yam Levi, Dominik Lorenz, Axel Sauer, Frederic Boesel, Dustin Podell, Tim Dockhorn, Zion English, Kyle Lacey, Alex Goodwin, Yannik Marek, and Robin Rombach.',dt,$,Yn="The abstract from the paper is:",ct,V,$n="<em>Diffusion models create data from noise by inverting the forward paths of data towards noise and have emerged as a powerful generative modeling technique for high-dimensional, perceptual data such as images and videos. Rectified flow is a recent generative model formulation that connects data and noise in a straight line. Despite its better theoretical properties and conceptual simplicity, it is not yet decisively established as standard practice. In this work, we improve existing noise sampling techniques for training rectified flow models by biasing them towards perceptually relevant scales. Through a large-scale study, we demonstrate the superior performance of this approach compared to established diffusion formulations for high-resolution text-to-image synthesis. Additionally, we present a novel transformer-based architecture for text-to-image generation that uses separate weights for the two modalities and enables a bidirectional flow of information between image and text tokens, improving text comprehension typography, and human preference ratings. We demonstrate that this architecture follows predictable scaling trends and correlates lower validation loss to improved text-to-image synthesis as measured by various metrics and human evaluations.</em>",mt,z,ft,N,Vn='<em>As the model is gated, before using it with diffusers you first need to go to the <a href="https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers" rel="nofollow">Stable Diffusion 3 Medium Hugging Face page</a>, fill in the form and accept the gate. Once you are in, you need to login so that your system knows you’ve accepted the gate.</em>',ut,E,zn="Use the command below to log in:",gt,Q,ht,W,Nn="<p>The SD3 pipeline uses three text encoders to generate an image. Model offloading is necessary in order for it to run on most commodity hardware. Please use the <code>torch.float16</code> data type for additional memory savings.</p>",yt,D,Mt,F,En="<strong>Note:</strong> Stable Diffusion 3.5 can also be run using the SD3 pipeline, and all mentioned optimizations and techniques apply to it as well. In total there are three official models in the SD3 family:",bt,H,Qn='<li><a href="https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers" rel="nofollow"><code>stabilityai/stable-diffusion-3-medium-diffusers</code></a></li> <li><a href="https://huggingface.co/stabilityai/stable-diffusion-3-5-large" rel="nofollow"><code>stabilityai/stable-diffusion-3.5-large</code></a></li> <li><a href="https://huggingface.co/stabilityai/stable-diffusion-3-5-large-turbo" rel="nofollow"><code>stabilityai/stable-diffusion-3.5-large-turbo</code></a></li>',_t,L,wt,P,Dn="An IP-Adapter lets you prompt SD3 with images, in addition to the text prompt. This is especially useful when describing complex concepts that are difficult to articulate through text alone and you have reference images. To load and use an IP-Adapter, you need:",Tt,q,Fn="<li><code>image_encoder</code>: Pre-trained vision model used to obtain image features, usually a CLIP image encoder.</li> <li><code>feature_extractor</code>: Image processor that prepares the input image for the chosen <code>image_encoder</code>.</li> <li><code>ip_adapter_id</code>: Checkpoint containing parameters of image cross attention layers and image projection.</li>",Jt,A,Hn="IP-Adapters are trained for a specific model architecture, so they also work in finetuned variations of the base model. You can use the <code>~SD3IPAdapterMixin.set_ip_adapter_scale</code> function to adjust how strongly the output aligns with the image prompt. The higher the value, the more closely the model follows the image prompt. A default value of 0.5 is typically a good balance, ensuring the model considers both the text and image prompts equally.",Ut,K,Zt,G,Ln='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sd3_ip_adapter_example.png"/> <figcaption class="mt-2 text-sm text-center text-gray-500">IP-Adapter examples with prompt &quot;a cat&quot;</figcaption>',jt,k,Pn='<p>Check out <a href="../../../using-diffusers/ip_adapter">IP-Adapter</a> to learn more about how IP-Adapters work.</p>',It,O,Bt,ee,qn="SD3 uses three text encoders, one of which is the very large T5-XXL model. This makes it challenging to run the model on GPUs with less than 24GB of VRAM, even when using <code>fp16</code> precision. The following section outlines a few memory optimizations in Diffusers that make it easier to run SD3 on low resource hardware.",vt,te,Wt,ne,An="The most basic memory optimization available in Diffusers allows you to offload the components of the model to CPU during inference in order to save memory, while seeing a slight increase in inference latency. Model offloading will only move a model component onto the GPU when it needs to be executed, while keeping the remaining components on the CPU.",Gt,ie,kt,ae,Ct,se,Kn="Removing the memory-intensive 4.7B parameter T5-XXL text encoder during inference can significantly decrease the memory requirements for SD3 with only a slight loss in performance.",xt,le,St,oe,Rt,re,On="We can leverage the <code>bitsandbytes</code> library to load and quantize the T5-XXL text encoder to 8-bit precision. This allows you to keep using all three text encoders while only slightly impacting performance.",Xt,pe,ei="First install the <code>bitsandbytes</code> library.",Yt,de,$t,ce,ti="Then load the T5-XXL model using the <code>BitsAndBytesConfig</code>.",Vt,me,zt,fe,ni='You can find the end-to-end script <a href="https://gist.github.com/sayakpaul/82acb5976509851f2db1a83456e504f1" rel="nofollow">here</a>.',Nt,ue,Et,ge,Qt,he,ii="Using compiled components in the SD3 pipeline can speed up inference by as much as 4X. The following code snippet demonstrates how to compile the Transformer and VAE components of the SD3 pipeline.",Dt,ye,Ft,Me,ai='Check out the full script <a href="https://gist.github.com/sayakpaul/508d89d7aad4f454900813da5d42ca97" rel="nofollow">here</a>.',Ht,be,Lt,_e,si="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",Pt,we,li='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3Pipeline">StableDiffusion3Pipeline</a> for inference with bitsandbytes.',qt,Te,At,Je,Kt,Ue,oi="By default, the T5 Text Encoder prompt uses a maximum sequence length of <code>256</code>. This can be adjusted by setting the <code>max_sequence_length</code> to accept fewer or more tokens. Keep in mind that longer sequences require additional resources and result in longer generation times, such as during batch inference.",Ot,Ze,en,je,tn,Ie,ri="You can send a different prompt to the CLIP Text Encoders and the T5 Text Encoder to prevent the prompt from being truncated by the CLIP Text Encoders and to improve generation.",nn,C,pi="<p>The prompt with the CLIP Text Encoders is still truncated to the 77 token limit.</p>",an,Be,sn,ve,ln,We,di='Tiny AutoEncoder for Stable Diffusion (TAESD3) is a tiny distilled version of Stable Diffusion 3’s VAE by <a href="https://github.com/madebyollin/taesd" rel="nofollow">Ollin Boer Bohan</a> that can decode <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3Pipeline">StableDiffusion3Pipeline</a> latents almost instantly.',on,Ge,ci="To use with Stable Diffusion 3:",rn,ke,pn,Ce,dn,xe,mi="The <code>SD3Transformer2DModel</code> and <code>StableDiffusion3Pipeline</code> classes support loading the original checkpoints via the <code>from_single_file</code> method. This method allows you to load the original checkpoint files that were used to train the models.",cn,Se,mn,Re,fn,Xe,un,Ye,gn,$e,hn,Ve,yn,x,fi="<p>The following example loads a checkpoint stored in a 8-bit floating point format which requires PyTorch 2.3 or later.</p>",Mn,ze,bn,Ne,_n,Ee,wn,Qe,Tn,_,De,In,I,Fe,Bn,Ke,ui="Function invoked when calling the pipeline for generation.",vn,S,Wn,R,He,Gn,Oe,gi="Encodes the given image into a feature representation using a pre-trained image encoder.",kn,et,Le,Cn,B,Pe,xn,tt,hi="Prepares image embeddings for use in the IP-Adapter.",Sn,nt,yi="Either <code>ip_adapter_image</code> or <code>ip_adapter_image_embeds</code> must be passed.",Jn,qe,Un,st,Zn;return U=new Zi({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),Z=new g({props:{title:"Stable Diffusion 3",local:"stable-diffusion-3",headingTag:"h1"}}),z=new g({props:{title:"Usage Example",local:"usage-example",headingTag:"h2"}}),Q=new b({props:{code:"aGYlMjBhdXRoJTIwbG9naW4=",highlighted:"hf auth login",wrap:!1}}),D=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),L=new g({props:{title:"Image Prompting with IP-Adapters",local:"image-prompting-with-ip-adapters",headingTag:"h2"}}),K=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNpZ2xpcFZpc2lvbk1vZGVsJTJDJTIwU2lnbGlwSW1hZ2VQcm9jZXNzb3IlMEElMEFpbWFnZV9lbmNvZGVyX2lkJTIwJTNEJTIwJTIyZ29vZ2xlJTJGc2lnbGlwLXNvNDAwbS1wYXRjaDE0LTM4NCUyMiUwQWlwX2FkYXB0ZXJfaWQlMjAlM0QlMjAlMjJJbnN0YW50WCUyRlNEMy41LUxhcmdlLUlQLUFkYXB0ZXIlMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMFNpZ2xpcEltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyX2lkJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQWltYWdlX2VuY29kZXIlMjAlM0QlMjBTaWdsaXBWaXNpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW5jb2Rlcl9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIwJTIyY3VkYSUyMiklMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy41LWxhcmdlJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2VuY29kZXIlM0RpbWFnZV9lbmNvZGVyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGUubG9hZF9pcF9hZGFwdGVyKGlwX2FkYXB0ZXJfaWQpJTBBcGlwZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYpJTBBJTBBcmVmX2ltZyUyMCUzRCUyMEltYWdlLm9wZW4oJTIyaW1hZ2UuanBnJTIyKS5jb252ZXJ0KCdSR0InKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMGNhdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmxvd3JlcyUyQyUyMGxvdyUyMHF1YWxpdHklMkMlMjB3b3JzdCUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDUuMCUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RyZWZfaW1nJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjJyZXN1bHQuanBnJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SiglipVisionModel, SiglipImageProcessor

image_encoder_id = <span class="hljs-string">&quot;google/siglip-so400m-patch14-384&quot;</span>
ip_adapter_id = <span class="hljs-string">&quot;InstantX/SD3.5-Large-IP-Adapter&quot;</span>

feature_extractor = SiglipImageProcessor.from_pretrained(
    image_encoder_id,
    torch_dtype=torch.float16
)
image_encoder = SiglipVisionModel.from_pretrained(
    image_encoder_id,
    torch_dtype=torch.float16
).to( <span class="hljs-string">&quot;cuda&quot;</span>)

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3.5-large&quot;</span>,
    torch_dtype=torch.float16,
    feature_extractor=feature_extractor,
    image_encoder=image_encoder,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_ip_adapter(ip_adapter_id)
pipe.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)

ref_img = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;image.jpg&quot;</span>).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)

image = pipe(
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1024</span>,
    prompt=<span class="hljs-string">&quot;a cat&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;lowres, low quality, worst quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">24</span>,
    guidance_scale=<span class="hljs-number">5.0</span>,
    ip_adapter_image=ref_img
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;result.jpg&quot;</span>)`,wrap:!1}}),O=new g({props:{title:"Memory Optimisations for SD3",local:"memory-optimisations-for-sd3",headingTag:"h2"}}),te=new g({props:{title:"Running Inference with Model Offloading",local:"running-inference-with-model-offloading",headingTag:"h3"}}),ie=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),ae=new g({props:{title:"Dropping the T5 Text Encoder during Inference",local:"dropping-the-t5-text-encoder-during-inference",headingTag:"h3"}}),le=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLW5vLVQ1LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    text_encoder_3=<span class="hljs-literal">None</span>,
    tokenizer_3=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-no-T5.png&quot;</span>)`,wrap:!1}}),oe=new g({props:{title:"Using a Quantized Version of the T5 Text Encoder",local:"using-a-quantized-version-of-the-t5-text-encoder",headingTag:"h3"}}),de=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes",wrap:!1}}),me=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8zJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfMyUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENy4wJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjJzZDNfaGVsbG9fd29ybGQtOGJpdC1UNS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>
text_encoder = T5EncoderModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;text_encoder_3&quot;</span>,
    quantization_config=quantization_config,
)
pipe = StableDiffusion3Pipeline.from_pretrained(
    model_id,
    text_encoder_3=text_encoder,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    torch_dtype=torch.float16
)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-8bit-T5.png&quot;</span>)`,wrap:!1}}),ue=new g({props:{title:"Performance Optimizations for SD3",local:"performance-optimizations-for-sd3",headingTag:"h2"}}),ge=new g({props:{title:"Using Torch Compile to Speed Up Inference",local:"using-torch-compile-to-speed-up-inference",headingTag:"h3"}}),ye=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBdG9yY2guc2V0X2Zsb2F0MzJfbWF0bXVsX3ByZWNpc2lvbiglMjJoaWdoJTIyKSUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0tZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2V0X3Byb2dyZXNzX2Jhcl9jb25maWcoZGlzYWJsZSUzRFRydWUpJTBBJTBBcGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEFwaXBlLnZhZS50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEElMEFwaXBlLnRyYW5zZm9ybWVyJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBcGlwZS52YWUuZGVjb2RlJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnZhZS5kZWNvZGUlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBXYXJtJTIwVXAlMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMF8lMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDEpKSUwQSUwQSUyMyUyMFJ1biUyMEluZmVyZW5jZSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZCgxKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

torch.set_float32_matmul_precision(<span class="hljs-string">&quot;high&quot;</span>)

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)

pipe.transformer.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)

pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Warm Up</span>
prompt = <span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    _ = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>))

<span class="hljs-comment"># Run Inference</span>
image = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>)).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),be=new g({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),Te=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMkMlMjBTRDNUcmFuc2Zvcm1lcjJETW9kZWwlMkMlMjBTdGFibGVEaWZmdXNpb24zUGlwZWxpbmUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBCaXRzQW5kQnl0ZXNDb25maWclMkMlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSUwQXRleHRfZW5jb2Rlcl84Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLjUtbGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMyUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBdHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMuNS1sYXJnZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMuNS1sYXJnZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2Rlcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTJDJTBBKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjB0aW55JTIwYXN0cm9uYXV0JTIwaGF0Y2hpbmclMjBmcm9tJTIwYW4lMjBlZ2clMjBvbiUyMHRoZSUyMG1vb24lMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy4wKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzZDMucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, SD3Transformer2DModel, StableDiffusion3Pipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, T5EncoderModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3.5-large&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_3&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = SD3Transformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3.5-large&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3.5-large&quot;</span>,
    text_encoder=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon&quot;</span>
image = pipeline(prompt, num_inference_steps=<span class="hljs-number">28</span>, guidance_scale=<span class="hljs-number">7.0</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sd3.png&quot;</span>)`,wrap:!1}}),Je=new g({props:{title:"Using Long Prompts with the T5 Text Encoder",local:"using-long-prompts-with-the-t5-text-encoder",headingTag:"h2"}}),Ze=new b({props:{code:"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",highlighted:`prompt = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. It features the distinctive, bulky body shape of a hippo. However, instead of the usual grey skin, the creature’s body resembles a golden-brown, crispy waffle fresh off the griddle. The skin is textured with the familiar grid pattern of a waffle, each square filled with a glistening sheen of syrup. The environment combines the natural habitat of a hippo with elements of a breakfast table setting, a river of warm, melted butter, with oversized utensils or plates peeking out from the lush, pancake-like foliage in the background, a towering pepper mill standing in for a tree.  As the sun rises in this fantastical world, it casts a warm, buttery glow over the scene. The creature, content in its butter river, lets out a yawn. Nearby, a flock of birds take flight&quot;</span>

image = pipe(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    guidance_scale=<span class="hljs-number">4.5</span>,
    max_sequence_length=<span class="hljs-number">512</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),je=new g({props:{title:"Sending a different prompt to the T5 Text Encoder",local:"sending-a-different-prompt-to-the-t5-text-encoder",headingTag:"h3"}}),Be=new b({props:{code:"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",highlighted:`prompt = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. A river of warm, melted butter, pancake-like foliage in the background, a towering pepper mill standing in for a tree.&quot;</span>

prompt_3 = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. It features the distinctive, bulky body shape of a hippo. However, instead of the usual grey skin, the creature’s body resembles a golden-brown, crispy waffle fresh off the griddle. The skin is textured with the familiar grid pattern of a waffle, each square filled with a glistening sheen of syrup. The environment combines the natural habitat of a hippo with elements of a breakfast table setting, a river of warm, melted butter, with oversized utensils or plates peeking out from the lush, pancake-like foliage in the background, a towering pepper mill standing in for a tree.  As the sun rises in this fantastical world, it casts a warm, buttery glow over the scene. The creature, content in its butter river, lets out a yawn. Nearby, a flock of birds take flight&quot;</span>

image = pipe(
    prompt=prompt,
    prompt_3=prompt_3,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    guidance_scale=<span class="hljs-number">4.5</span>,
    max_sequence_length=<span class="hljs-number">512</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ve=new g({props:{title:"Tiny AutoEncoder for Stable Diffusion 3",local:"tiny-autoencoder-for-stable-diffusion-3",headingTag:"h2"}}),ke=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTJDJTIwQXV0b2VuY29kZXJUaW55JTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyVGlueS5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZ0YWVzZDMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJzbGljZSUyMG9mJTIwZGVsaWNpb3VzJTIwTmV3JTIwWW9yay1zdHlsZSUyMGJlcnJ5JTIwY2hlZXNlY2FrZSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoZWVzZWNha2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline, AutoencoderTiny

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
)
pipe.vae = AutoencoderTiny.from_pretrained(<span class="hljs-string">&quot;madebyollin/taesd3&quot;</span>, torch_dtype=torch.float16)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;slice of delicious New York-style berry cheesecake&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cheesecake.png&quot;</span>)`,wrap:!1}}),Ce=new g({props:{title:"Loading the original checkpoints via from_single_file",local:"loading-the-original-checkpoints-via-fromsinglefile",headingTag:"h2"}}),Se=new g({props:{title:"Loading the original checkpoints for the SD3Transformer2DModel",local:"loading-the-original-checkpoints-for-the-sd3transformer2dmodel",headingTag:"h2"}}),Re=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwU0QzVHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fc2luZ2xlX2ZpbGUoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bSUyRmJsb2IlMkZtYWluJTJGc2QzX21lZGl1bS5zYWZldGVuc29ycyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel

model = SD3Transformer2DModel.from_single_file(<span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium.safetensors&quot;</span>)`,wrap:!1}}),Xe=new g({props:{title:"Loading the single checkpoint for the StableDiffusion3Pipeline",local:"loading-the-single-checkpoint-for-the-stablediffusion3pipeline",headingTag:"h2"}}),Ye=new g({props:{title:"Loading the single file checkpoint without T5",local:"loading-the-single-file-checkpoint-without-t5",headingTag:"h3"}}),$e=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0lMkZibG9iJTJGbWFpbiUyRnNkM19tZWRpdW1faW5jbF9jbGlwcy5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8zJTNETm9uZSUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBwaWN0dXJlJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSgnc2QzLXNpbmdsZS1maWxlLnBuZycp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium_incl_clips.safetensors&quot;</span>,
    torch_dtype=torch.float16,
    text_encoder_3=<span class="hljs-literal">None</span>
)
pipe.enable_model_cpu_offload()

image = pipe(<span class="hljs-string">&quot;a picture of a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;sd3-single-file.png&#x27;</span>)`,wrap:!1}}),Ve=new g({props:{title:"Loading the single file checkpoint with T5",local:"loading-the-single-file-checkpoint-with-t5",headingTag:"h3"}}),ze=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0lMkZibG9iJTJGbWFpbiUyRnNkM19tZWRpdW1faW5jbF9jbGlwc190NXh4bGZwOC5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBwaWN0dXJlJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSgnc2QzLXNpbmdsZS1maWxlLXQ1LWZwOC5wbmcnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium_incl_clips_t5xxlfp8.safetensors&quot;</span>,
    torch_dtype=torch.float16,
)
pipe.enable_model_cpu_offload()

image = pipe(<span class="hljs-string">&quot;a picture of a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;sd3-single-file-t5-fp8.png&#x27;</span>)`,wrap:!1}}),Ne=new g({props:{title:"Loading the single file checkpoint for the Stable Diffusion 3.5 Transformer Model",local:"loading-the-single-file-checkpoint-for-the-stable-diffusion-35-transformer-model",headingTag:"h3"}}),Ee=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU0QzVHJhbnNmb3JtZXIyRE1vZGVsJTJDJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBTRDNUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMuNS1sYXJnZS10dXJibyUyRmJsb2IlMkZtYWluJTJGc2QzLjVfbGFyZ2Uuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb24zUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLjUtbGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkMzUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel, StableDiffusion3Pipeline

transformer = SD3Transformer2DModel.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3.5-large-turbo/blob/main/sd3.5_large.safetensors&quot;</span>,
    torch_dtype=torch.bfloat16,
)
pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3.5-large&quot;</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16,
)
pipe.enable_model_cpu_offload()
image = pipe(<span class="hljs-string">&quot;a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sd35.png&quot;</span>)`,wrap:!1}}),Qe=new g({props:{title:"StableDiffusion3Pipeline",local:"diffusers.StableDiffusion3Pipeline",headingTag:"h2"}}),De=new lt({props:{name:"class diffusers.StableDiffusion3Pipeline",anchor:"diffusers.StableDiffusion3Pipeline",parameters:[{name:"transformer",val:": SD3Transformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"text_encoder_3",val:": T5EncoderModel"},{name:"tokenizer_3",val:": T5TokenizerFast"},{name:"image_encoder",val:": SiglipVisionModel = None"},{name:"feature_extractor",val:": SiglipImageProcessor = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.StableDiffusion3Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableDiffusion3Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant,
with an additional added projection layer that is initialized with a diagonal matrix with the <code>hidden_size</code>
as its dimension.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_3",description:`<strong>text_encoder_3</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion 3 uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder_3"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_3",description:`<strong>tokenizer_3</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer_3"},{anchor:"diffusers.StableDiffusion3Pipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>SiglipVisionModel</code>, <em>optional</em>) &#x2014;
Pre-trained Vision Model for IP Adapter.`,name:"image_encoder"},{anchor:"diffusers.StableDiffusion3Pipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>SiglipImageProcessor</code>, <em>optional</em>) &#x2014;
Image processor for IP Adapter.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L148"}}),Fe=new lt({props:{name:"__call__",anchor:"diffusers.StableDiffusion3Pipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"},{name:"skip_guidance_layers",val:": typing.List[int] = None"},{name:"skip_layer_guidance_scale",val:": float = 2.8"},{name:"skip_layer_guidance_stop",val:": float = 0.2"},{name:"skip_layer_guidance_start",val:": float = 0.01"},{name:"mu",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. Should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to
<code>True</code>. If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_guidance_layers",description:`<strong>skip_guidance_layers</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of integers that specify layers to skip during guidance. If not provided, all layers will be
used for guidance. If provided, the guidance will only be applied to the layers specified in the list.
Recommended value by StabiltyAI for Stable Diffusion 3.5 Medium is [7, 8, 9].`,name:"skip_guidance_layers"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_layer_guidance_scale",description:`<strong>skip_layer_guidance_scale</strong> (<code>int</code>, <em>optional</em>) &#x2014; The scale of the guidance for the layers specified in
<code>skip_guidance_layers</code>. The guidance will be applied to the layers specified in <code>skip_guidance_layers</code>
with a scale of <code>skip_layer_guidance_scale</code>. The guidance will be applied to the rest of the layers
with a scale of <code>1</code>.`,name:"skip_layer_guidance_scale"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_layer_guidance_stop",description:`<strong>skip_layer_guidance_stop</strong> (<code>int</code>, <em>optional</em>) &#x2014; The step at which the guidance for the layers specified in
<code>skip_guidance_layers</code> will stop. The guidance will be applied to the layers specified in
<code>skip_guidance_layers</code> until the fraction specified in <code>skip_layer_guidance_stop</code>. Recommended value by
StabiltyAI for Stable Diffusion 3.5 Medium is 0.2.`,name:"skip_layer_guidance_stop"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_layer_guidance_start",description:`<strong>skip_layer_guidance_start</strong> (<code>int</code>, <em>optional</em>) &#x2014; The step at which the guidance for the layers specified in
<code>skip_guidance_layers</code> will start. The guidance will be applied to the layers specified in
<code>skip_guidance_layers</code> from the fraction specified in <code>skip_layer_guidance_start</code>. Recommended value by
StabiltyAI for Stable Diffusion 3.5 Medium is 0.01.`,name:"skip_layer_guidance_start"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.mu",description:"<strong>mu</strong> (<code>float</code>, <em>optional</em>) &#x2014; <code>mu</code> value used for <code>dynamic_shifting</code>.",name:"mu"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L772",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> or <code>tuple</code></p>
`}}),S=new ji({props:{anchor:"diffusers.StableDiffusion3Pipeline.__call__.example",$$slots:{default:[Bi]},$$scope:{ctx:ot}}}),He=new lt({props:{name:"encode_image",anchor:"diffusers.StableDiffusion3Pipeline.encode_image",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"device",val:": device"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.encode_image.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
Input image to be encoded.`,name:"image"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_image.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
Torch device.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L696",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The encoded image feature representation.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Le=new lt({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_3",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"max_sequence_length",val:": int = 256"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L344"}}),Pe=new lt({props:{name:"prepare_ip_adapter_image_embeds",anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds",parameters:[{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
The input image to extract features from for IP-Adapter.`,name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Precomputed image embeddings.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
Torch device.`,name:"device"},{anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
Number of images that should be generated per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, defaults to True) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L716"}}),qe=new Ii({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_diffusion/stable_diffusion_3.md"}}),{c(){M=l("meta"),X=a(),j=l("p"),J=a(),o(U.$$.fragment),h=a(),o(Z.$$.fragment),rt=a(),v=l("div"),v.innerHTML=Rn,pt=a(),Y=l("p"),Y.innerHTML=Xn,dt=a(),$=l("p"),$.textContent=Yn,ct=a(),V=l("p"),V.innerHTML=$n,mt=a(),o(z.$$.fragment),ft=a(),N=l("p"),N.innerHTML=Vn,ut=a(),E=l("p"),E.textContent=zn,gt=a(),o(Q.$$.fragment),ht=a(),W=l("blockquote"),W.innerHTML=Nn,yt=a(),o(D.$$.fragment),Mt=a(),F=l("p"),F.innerHTML=En,bt=a(),H=l("ul"),H.innerHTML=Qn,_t=a(),o(L.$$.fragment),wt=a(),P=l("p"),P.textContent=Dn,Tt=a(),q=l("ul"),q.innerHTML=Fn,Jt=a(),A=l("p"),A.innerHTML=Hn,Ut=a(),o(K.$$.fragment),Zt=a(),G=l("div"),G.innerHTML=Ln,jt=a(),k=l("blockquote"),k.innerHTML=Pn,It=a(),o(O.$$.fragment),Bt=a(),ee=l("p"),ee.innerHTML=qn,vt=a(),o(te.$$.fragment),Wt=a(),ne=l("p"),ne.textContent=An,Gt=a(),o(ie.$$.fragment),kt=a(),o(ae.$$.fragment),Ct=a(),se=l("p"),se.textContent=Kn,xt=a(),o(le.$$.fragment),St=a(),o(oe.$$.fragment),Rt=a(),re=l("p"),re.innerHTML=On,Xt=a(),pe=l("p"),pe.innerHTML=ei,Yt=a(),o(de.$$.fragment),$t=a(),ce=l("p"),ce.innerHTML=ti,Vt=a(),o(me.$$.fragment),zt=a(),fe=l("p"),fe.innerHTML=ni,Nt=a(),o(ue.$$.fragment),Et=a(),o(ge.$$.fragment),Qt=a(),he=l("p"),he.textContent=ii,Dt=a(),o(ye.$$.fragment),Ft=a(),Me=l("p"),Me.innerHTML=ai,Ht=a(),o(be.$$.fragment),Lt=a(),_e=l("p"),_e.textContent=si,Pt=a(),we=l("p"),we.innerHTML=li,qt=a(),o(Te.$$.fragment),At=a(),o(Je.$$.fragment),Kt=a(),Ue=l("p"),Ue.innerHTML=oi,Ot=a(),o(Ze.$$.fragment),en=a(),o(je.$$.fragment),tn=a(),Ie=l("p"),Ie.textContent=ri,nn=a(),C=l("blockquote"),C.innerHTML=pi,an=a(),o(Be.$$.fragment),sn=a(),o(ve.$$.fragment),ln=a(),We=l("p"),We.innerHTML=di,on=a(),Ge=l("p"),Ge.textContent=ci,rn=a(),o(ke.$$.fragment),pn=a(),o(Ce.$$.fragment),dn=a(),xe=l("p"),xe.innerHTML=mi,cn=a(),o(Se.$$.fragment),mn=a(),o(Re.$$.fragment),fn=a(),o(Xe.$$.fragment),un=a(),o(Ye.$$.fragment),gn=a(),o($e.$$.fragment),hn=a(),o(Ve.$$.fragment),yn=a(),x=l("blockquote"),x.innerHTML=fi,Mn=a(),o(ze.$$.fragment),bn=a(),o(Ne.$$.fragment),_n=a(),o(Ee.$$.fragment),wn=a(),o(Qe.$$.fragment),Tn=a(),_=l("div"),o(De.$$.fragment),In=a(),I=l("div"),o(Fe.$$.fragment),Bn=a(),Ke=l("p"),Ke.textContent=ui,vn=a(),o(S.$$.fragment),Wn=a(),R=l("div"),o(He.$$.fragment),Gn=a(),Oe=l("p"),Oe.textContent=gi,kn=a(),et=l("div"),o(Le.$$.fragment),Cn=a(),B=l("div"),o(Pe.$$.fragment),xn=a(),tt=l("p"),tt.textContent=hi,Sn=a(),nt=l("p"),nt.innerHTML=yi,Jn=a(),o(qe.$$.fragment),Un=a(),st=l("p"),this.h()},l(e){const t=Ui("svelte-u9bgzb",document.head);M=r(t,"META",{name:!0,content:!0}),t.forEach(n),X=s(e),j=r(e,"P",{}),Ae(j).forEach(n),J=s(e),p(U.$$.fragment,e),h=s(e),p(Z.$$.fragment,e),rt=s(e),v=r(e,"DIV",{class:!0,"data-svelte-h":!0}),u(v)!=="svelte-1elo7hh"&&(v.innerHTML=Rn),pt=s(e),Y=r(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1e472ng"&&(Y.innerHTML=Xn),dt=s(e),$=r(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1cwsb16"&&($.textContent=Yn),ct=s(e),V=r(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-vkvbjo"&&(V.innerHTML=$n),mt=s(e),p(z.$$.fragment,e),ft=s(e),N=r(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-mtsbjp"&&(N.innerHTML=Vn),ut=s(e),E=r(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-12sg8l0"&&(E.textContent=zn),gt=s(e),p(Q.$$.fragment,e),ht=s(e),W=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(W)!=="svelte-cgl6s3"&&(W.innerHTML=Nn),yt=s(e),p(D.$$.fragment,e),Mt=s(e),F=r(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-16uzmu4"&&(F.innerHTML=En),bt=s(e),H=r(e,"UL",{"data-svelte-h":!0}),u(H)!=="svelte-1wxish5"&&(H.innerHTML=Qn),_t=s(e),p(L.$$.fragment,e),wt=s(e),P=r(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-n8z787"&&(P.textContent=Dn),Tt=s(e),q=r(e,"UL",{"data-svelte-h":!0}),u(q)!=="svelte-79yrba"&&(q.innerHTML=Fn),Jt=s(e),A=r(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-19sl6jj"&&(A.innerHTML=Hn),Ut=s(e),p(K.$$.fragment,e),Zt=s(e),G=r(e,"DIV",{class:!0,"data-svelte-h":!0}),u(G)!=="svelte-lfioke"&&(G.innerHTML=Ln),jt=s(e),k=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(k)!=="svelte-sib9lk"&&(k.innerHTML=Pn),It=s(e),p(O.$$.fragment,e),Bt=s(e),ee=r(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-19ncv5l"&&(ee.innerHTML=qn),vt=s(e),p(te.$$.fragment,e),Wt=s(e),ne=r(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-uyrglw"&&(ne.textContent=An),Gt=s(e),p(ie.$$.fragment,e),kt=s(e),p(ae.$$.fragment,e),Ct=s(e),se=r(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-k4awn"&&(se.textContent=Kn),xt=s(e),p(le.$$.fragment,e),St=s(e),p(oe.$$.fragment,e),Rt=s(e),re=r(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-vcvc4f"&&(re.innerHTML=On),Xt=s(e),pe=r(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-1t2mxsa"&&(pe.innerHTML=ei),Yt=s(e),p(de.$$.fragment,e),$t=s(e),ce=r(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-1pykif5"&&(ce.innerHTML=ti),Vt=s(e),p(me.$$.fragment,e),zt=s(e),fe=r(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-bsz29z"&&(fe.innerHTML=ni),Nt=s(e),p(ue.$$.fragment,e),Et=s(e),p(ge.$$.fragment,e),Qt=s(e),he=r(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-x56fi6"&&(he.textContent=ii),Dt=s(e),p(ye.$$.fragment,e),Ft=s(e),Me=r(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-d39h5a"&&(Me.innerHTML=ai),Ht=s(e),p(be.$$.fragment,e),Lt=s(e),_e=r(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-1ou2pxc"&&(_e.textContent=si),Pt=s(e),we=r(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-16qw33x"&&(we.innerHTML=li),qt=s(e),p(Te.$$.fragment,e),At=s(e),p(Je.$$.fragment,e),Kt=s(e),Ue=r(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-ejr28n"&&(Ue.innerHTML=oi),Ot=s(e),p(Ze.$$.fragment,e),en=s(e),p(je.$$.fragment,e),tn=s(e),Ie=r(e,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-1ey7u3k"&&(Ie.textContent=ri),nn=s(e),C=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(C)!=="svelte-9gfywt"&&(C.innerHTML=pi),an=s(e),p(Be.$$.fragment,e),sn=s(e),p(ve.$$.fragment,e),ln=s(e),We=r(e,"P",{"data-svelte-h":!0}),u(We)!=="svelte-fy6n6i"&&(We.innerHTML=di),on=s(e),Ge=r(e,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-cj7nlj"&&(Ge.textContent=ci),rn=s(e),p(ke.$$.fragment,e),pn=s(e),p(Ce.$$.fragment,e),dn=s(e),xe=r(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-1pvw0yz"&&(xe.innerHTML=mi),cn=s(e),p(Se.$$.fragment,e),mn=s(e),p(Re.$$.fragment,e),fn=s(e),p(Xe.$$.fragment,e),un=s(e),p(Ye.$$.fragment,e),gn=s(e),p($e.$$.fragment,e),hn=s(e),p(Ve.$$.fragment,e),yn=s(e),x=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(x)!=="svelte-18c9zr1"&&(x.innerHTML=fi),Mn=s(e),p(ze.$$.fragment,e),bn=s(e),p(Ne.$$.fragment,e),_n=s(e),p(Ee.$$.fragment,e),wn=s(e),p(Qe.$$.fragment,e),Tn=s(e),_=r(e,"DIV",{class:!0});var w=Ae(_);p(De.$$.fragment,w),In=s(w),I=r(w,"DIV",{class:!0});var it=Ae(I);p(Fe.$$.fragment,it),Bn=s(it),Ke=r(it,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-v78lg8"&&(Ke.textContent=ui),vn=s(it),p(S.$$.fragment,it),it.forEach(n),Wn=s(w),R=r(w,"DIV",{class:!0});var jn=Ae(R);p(He.$$.fragment,jn),Gn=s(jn),Oe=r(jn,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-vi6ux7"&&(Oe.textContent=gi),jn.forEach(n),kn=s(w),et=r(w,"DIV",{class:!0});var Mi=Ae(et);p(Le.$$.fragment,Mi),Mi.forEach(n),Cn=s(w),B=r(w,"DIV",{class:!0});var at=Ae(B);p(Pe.$$.fragment,at),xn=s(at),tt=r(at,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-fimzys"&&(tt.textContent=hi),Sn=s(at),nt=r(at,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-gkgg1h"&&(nt.innerHTML=yi),at.forEach(n),w.forEach(n),Jn=s(e),p(qe.$$.fragment,e),Un=s(e),st=r(e,"P",{}),Ae(st).forEach(n),this.h()},h(){T(M,"name","hf:doc:metadata"),T(M,"content",Wi),T(v,"class","flex flex-wrap space-x-1"),T(W,"class","tip"),T(G,"class","justify-center"),T(k,"class","tip"),T(C,"class","tip"),T(x,"class","tip"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){y(document.head,M),i(e,X,t),i(e,j,t),i(e,J,t),d(U,e,t),i(e,h,t),d(Z,e,t),i(e,rt,t),i(e,v,t),i(e,pt,t),i(e,Y,t),i(e,dt,t),i(e,$,t),i(e,ct,t),i(e,V,t),i(e,mt,t),d(z,e,t),i(e,ft,t),i(e,N,t),i(e,ut,t),i(e,E,t),i(e,gt,t),d(Q,e,t),i(e,ht,t),i(e,W,t),i(e,yt,t),d(D,e,t),i(e,Mt,t),i(e,F,t),i(e,bt,t),i(e,H,t),i(e,_t,t),d(L,e,t),i(e,wt,t),i(e,P,t),i(e,Tt,t),i(e,q,t),i(e,Jt,t),i(e,A,t),i(e,Ut,t),d(K,e,t),i(e,Zt,t),i(e,G,t),i(e,jt,t),i(e,k,t),i(e,It,t),d(O,e,t),i(e,Bt,t),i(e,ee,t),i(e,vt,t),d(te,e,t),i(e,Wt,t),i(e,ne,t),i(e,Gt,t),d(ie,e,t),i(e,kt,t),d(ae,e,t),i(e,Ct,t),i(e,se,t),i(e,xt,t),d(le,e,t),i(e,St,t),d(oe,e,t),i(e,Rt,t),i(e,re,t),i(e,Xt,t),i(e,pe,t),i(e,Yt,t),d(de,e,t),i(e,$t,t),i(e,ce,t),i(e,Vt,t),d(me,e,t),i(e,zt,t),i(e,fe,t),i(e,Nt,t),d(ue,e,t),i(e,Et,t),d(ge,e,t),i(e,Qt,t),i(e,he,t),i(e,Dt,t),d(ye,e,t),i(e,Ft,t),i(e,Me,t),i(e,Ht,t),d(be,e,t),i(e,Lt,t),i(e,_e,t),i(e,Pt,t),i(e,we,t),i(e,qt,t),d(Te,e,t),i(e,At,t),d(Je,e,t),i(e,Kt,t),i(e,Ue,t),i(e,Ot,t),d(Ze,e,t),i(e,en,t),d(je,e,t),i(e,tn,t),i(e,Ie,t),i(e,nn,t),i(e,C,t),i(e,an,t),d(Be,e,t),i(e,sn,t),d(ve,e,t),i(e,ln,t),i(e,We,t),i(e,on,t),i(e,Ge,t),i(e,rn,t),d(ke,e,t),i(e,pn,t),d(Ce,e,t),i(e,dn,t),i(e,xe,t),i(e,cn,t),d(Se,e,t),i(e,mn,t),d(Re,e,t),i(e,fn,t),d(Xe,e,t),i(e,un,t),d(Ye,e,t),i(e,gn,t),d($e,e,t),i(e,hn,t),d(Ve,e,t),i(e,yn,t),i(e,x,t),i(e,Mn,t),d(ze,e,t),i(e,bn,t),d(Ne,e,t),i(e,_n,t),d(Ee,e,t),i(e,wn,t),d(Qe,e,t),i(e,Tn,t),i(e,_,t),d(De,_,null),y(_,In),y(_,I),d(Fe,I,null),y(I,Bn),y(I,Ke),y(I,vn),d(S,I,null),y(_,Wn),y(_,R),d(He,R,null),y(R,Gn),y(R,Oe),y(_,kn),y(_,et),d(Le,et,null),y(_,Cn),y(_,B),d(Pe,B,null),y(B,xn),y(B,tt),y(B,Sn),y(B,nt),i(e,Jn,t),d(qe,e,t),i(e,Un,t),i(e,st,t),Zn=!0},p(e,[t]){const w={};t&2&&(w.$$scope={dirty:t,ctx:e}),S.$set(w)},i(e){Zn||(c(U.$$.fragment,e),c(Z.$$.fragment,e),c(z.$$.fragment,e),c(Q.$$.fragment,e),c(D.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(ie.$$.fragment,e),c(ae.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(ue.$$.fragment,e),c(ge.$$.fragment,e),c(ye.$$.fragment,e),c(be.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),c(Ze.$$.fragment,e),c(je.$$.fragment,e),c(Be.$$.fragment,e),c(ve.$$.fragment,e),c(ke.$$.fragment,e),c(Ce.$$.fragment,e),c(Se.$$.fragment,e),c(Re.$$.fragment,e),c(Xe.$$.fragment,e),c(Ye.$$.fragment,e),c($e.$$.fragment,e),c(Ve.$$.fragment,e),c(ze.$$.fragment,e),c(Ne.$$.fragment,e),c(Ee.$$.fragment,e),c(Qe.$$.fragment,e),c(De.$$.fragment,e),c(Fe.$$.fragment,e),c(S.$$.fragment,e),c(He.$$.fragment,e),c(Le.$$.fragment,e),c(Pe.$$.fragment,e),c(qe.$$.fragment,e),Zn=!0)},o(e){m(U.$$.fragment,e),m(Z.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(D.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ie.$$.fragment,e),m(ae.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(ge.$$.fragment,e),m(ye.$$.fragment,e),m(be.$$.fragment,e),m(Te.$$.fragment,e),m(Je.$$.fragment,e),m(Ze.$$.fragment,e),m(je.$$.fragment,e),m(Be.$$.fragment,e),m(ve.$$.fragment,e),m(ke.$$.fragment,e),m(Ce.$$.fragment,e),m(Se.$$.fragment,e),m(Re.$$.fragment,e),m(Xe.$$.fragment,e),m(Ye.$$.fragment,e),m($e.$$.fragment,e),m(Ve.$$.fragment,e),m(ze.$$.fragment,e),m(Ne.$$.fragment,e),m(Ee.$$.fragment,e),m(Qe.$$.fragment,e),m(De.$$.fragment,e),m(Fe.$$.fragment,e),m(S.$$.fragment,e),m(He.$$.fragment,e),m(Le.$$.fragment,e),m(Pe.$$.fragment,e),m(qe.$$.fragment,e),Zn=!1},d(e){e&&(n(X),n(j),n(J),n(h),n(rt),n(v),n(pt),n(Y),n(dt),n($),n(ct),n(V),n(mt),n(ft),n(N),n(ut),n(E),n(gt),n(ht),n(W),n(yt),n(Mt),n(F),n(bt),n(H),n(_t),n(wt),n(P),n(Tt),n(q),n(Jt),n(A),n(Ut),n(Zt),n(G),n(jt),n(k),n(It),n(Bt),n(ee),n(vt),n(Wt),n(ne),n(Gt),n(kt),n(Ct),n(se),n(xt),n(St),n(Rt),n(re),n(Xt),n(pe),n(Yt),n($t),n(ce),n(Vt),n(zt),n(fe),n(Nt),n(Et),n(Qt),n(he),n(Dt),n(Ft),n(Me),n(Ht),n(Lt),n(_e),n(Pt),n(we),n(qt),n(At),n(Kt),n(Ue),n(Ot),n(en),n(tn),n(Ie),n(nn),n(C),n(an),n(sn),n(ln),n(We),n(on),n(Ge),n(rn),n(pn),n(dn),n(xe),n(cn),n(mn),n(fn),n(un),n(gn),n(hn),n(yn),n(x),n(Mn),n(bn),n(_n),n(wn),n(Tn),n(_),n(Jn),n(Un),n(st)),n(M),f(U,e),f(Z,e),f(z,e),f(Q,e),f(D,e),f(L,e),f(K,e),f(O,e),f(te,e),f(ie,e),f(ae,e),f(le,e),f(oe,e),f(de,e),f(me,e),f(ue,e),f(ge,e),f(ye,e),f(be,e),f(Te,e),f(Je,e),f(Ze,e),f(je,e),f(Be,e),f(ve,e),f(ke,e),f(Ce,e),f(Se,e),f(Re,e),f(Xe,e),f(Ye,e),f($e,e),f(Ve,e),f(ze,e),f(Ne,e),f(Ee,e),f(Qe,e),f(De),f(Fe),f(S),f(He),f(Le),f(Pe),f(qe,e)}}}const Wi='{"title":"Stable Diffusion 3","local":"stable-diffusion-3","sections":[{"title":"Usage Example","local":"usage-example","sections":[],"depth":2},{"title":"Image Prompting with IP-Adapters","local":"image-prompting-with-ip-adapters","sections":[],"depth":2},{"title":"Memory Optimisations for SD3","local":"memory-optimisations-for-sd3","sections":[{"title":"Running Inference with Model Offloading","local":"running-inference-with-model-offloading","sections":[],"depth":3},{"title":"Dropping the T5 Text Encoder during Inference","local":"dropping-the-t5-text-encoder-during-inference","sections":[],"depth":3},{"title":"Using a Quantized Version of the T5 Text Encoder","local":"using-a-quantized-version-of-the-t5-text-encoder","sections":[],"depth":3}],"depth":2},{"title":"Performance Optimizations for SD3","local":"performance-optimizations-for-sd3","sections":[{"title":"Using Torch Compile to Speed Up Inference","local":"using-torch-compile-to-speed-up-inference","sections":[],"depth":3}],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"Using Long Prompts with the T5 Text Encoder","local":"using-long-prompts-with-the-t5-text-encoder","sections":[{"title":"Sending a different prompt to the T5 Text Encoder","local":"sending-a-different-prompt-to-the-t5-text-encoder","sections":[],"depth":3}],"depth":2},{"title":"Tiny AutoEncoder for Stable Diffusion 3","local":"tiny-autoencoder-for-stable-diffusion-3","sections":[],"depth":2},{"title":"Loading the original checkpoints via from_single_file","local":"loading-the-original-checkpoints-via-fromsinglefile","sections":[],"depth":2},{"title":"Loading the original checkpoints for the SD3Transformer2DModel","local":"loading-the-original-checkpoints-for-the-sd3transformer2dmodel","sections":[],"depth":2},{"title":"Loading the single checkpoint for the StableDiffusion3Pipeline","local":"loading-the-single-checkpoint-for-the-stablediffusion3pipeline","sections":[{"title":"Loading the single file checkpoint without T5","local":"loading-the-single-file-checkpoint-without-t5","sections":[],"depth":3},{"title":"Loading the single file checkpoint with T5","local":"loading-the-single-file-checkpoint-with-t5","sections":[],"depth":3},{"title":"Loading the single file checkpoint for the Stable Diffusion 3.5 Transformer Model","local":"loading-the-single-file-checkpoint-for-the-stable-diffusion-35-transformer-model","sections":[],"depth":3}],"depth":2},{"title":"StableDiffusion3Pipeline","local":"diffusers.StableDiffusion3Pipeline","sections":[],"depth":2}],"depth":1}';function Gi(ot){return _i(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $i extends Ti{constructor(M){super(),Ji(this,M,Gi,vi,bi,{})}}export{$i as component};
