import{s as vt,n as $t,o as Yt}from"../chunks/scheduler.53228c21.js";import{S as Nt,i as Qt,e as a,s as i,c as M,h as Et,a as o,d as t,b as n,f as St,g as d,j as p,k as Ft,l as Lt,m as s,n as c,t as r,o as f,p as m}from"../chunks/index.100fac89.js";import{C as Dt}from"../chunks/CopyLLMTxtMenu.4f0519ef.js";import{C as u}from"../chunks/CodeBlock.d30a6509.js";import{H as y,E as At}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.62dbb7c4.js";function zt(Ol){let J,Ve,Be,Se,U,Fe,T,ve,b,et='Modular Diffusers is a framework for quickly building flexible and customizable pipelines. At the core of Modular Diffusers are <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> that can be combined with other blocks to adapt to new workflows. The blocks are converted into a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>, a friendly user-facing interface developers can use.',$e,w,lt='This doc will show you how to implement a <a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a> pipeline with the modular framework.',Ye,Z,Ne,h,tt='<a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> are <em>definitions</em> that specify the components, inputs, outputs, and computation logic for a single step in a pipeline. There are four types of blocks.',Qe,I,st='<li><a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> is the most basic block for a single step.</li> <li><code>SequentialPipelineBlocks</code> is a multi-block that composes other blocks linearly. The outputs of one block are the inputs to the next block.</li> <li><code>LoopSequentialPipelineBlocks</code> is a multi-block that runs iteratively and is designed for iterative workflows.</li> <li><code>AutoPipelineBlocks</code> is a collection of blocks for different workflows and it selects which block to run based on the input. It is designed to conveniently package multiple workflows into a single pipeline.</li>',Ee,j,it='<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a> is an image-to-image workflow. Start with the <code>IMAGE2IMAGE_BLOCKS</code> preset, a collection of <code>ModularPipelineBlocks</code> for image-to-image generation.',Le,C,De,G,Ae,R,nt="Modular Diffusers uses <em>state</em> to communicate data between blocks. There are two types of states.",ze,k,at="<li><code>PipelineState</code> is a global state that can be used to track all inputs and outputs across all blocks.</li> <li><code>BlockState</code> is a local view of relevant variables from <code>PipelineState</code> for an individual block.</li>",xe,_,He,W,ot='<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a> differs from standard image-to-image in its <code>prepare_latents</code> and <code>denoise</code> blocks. All the other blocks can be reused, but you’ll need to modify these two.',qe,X,pt="Create placeholder <code>ModularPipelineBlocks</code> for <code>prepare_latents</code> and <code>denoise</code> by copying and modifying the existing ones.",Pe,B,Mt="Print the <code>denoise</code> block to see that it is composed of <code>LoopSequentialPipelineBlocks</code> with three sub-blocks, <code>before_denoiser</code>, <code>denoiser</code>, and <code>after_denoiser</code>. Only the <code>before_denoiser</code> sub-block needs to be modified to prepare the latent input for the denoiser based on the change map.",Ke,g,Oe,V,dt="Replace the <code>StableDiffusionXLLoopBeforeDenoiser</code> sub-block with the new <code>SDXLDiffDiffLoopBeforeDenoiser</code> block.",el,S,ll,F,tl,v,ct="The <code>prepare_latents</code> block requires the following changes.",sl,$,rt="<li>a processor to process the change map</li> <li>a new <code>inputs</code> to accept the user-provided change map, <code>timestep</code> for precomputing all the latents and <code>num_inference_steps</code> to create the mask for updating the image regions</li> <li>update the computation in the <code>__call__</code> method for processing the change map and creating the masks, and storing it in the <code>BlockState</code></li>",il,Y,nl,N,al,Q,ft="The <code>before_denoiser</code> sub-block requires the following changes.",ol,E,mt="<li>a new <code>inputs</code> to accept a <code>denoising_start</code> parameter,  <code>original_latents</code> and <code>diffdiff_masks</code> from the <code>prepare_latents</code> block</li> <li>update the computation in the <code>__call__</code> method for applying Differential Diffusion</li>",pl,L,Ml,D,dl,A,ut='You should have all the blocks you need at this point to create a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>.',cl,z,yt="Copy the existing <code>IMAGE2IMAGE_BLOCKS</code> preset and for the <code>set_timesteps</code> block, use the <code>set_timesteps</code> from the <code>TEXT2IMAGE_BLOCKS</code> because Differential Diffusion doesn’t require a <code>strength</code> parameter.",rl,x,Jt="Set the <code>prepare_latents</code> and <code>denoise</code> blocks to the <code>SDXLDiffDiffPrepareLatentsStep</code> and <code>SDXLDiffDiffDenoiseStep</code> blocks you just modified.",fl,H,Ut="Call <code>SequentialPipelineBlocks.from_blocks_dict</code> on the blocks to create a <code>SequentialPipelineBlocks</code>.",ml,q,ul,P,yl,K,Tt='Convert the <code>SequentialPipelineBlocks</code> into a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> with the <code>ModularPipeline.init_pipeline</code> method. This initializes the expected components to load from a <code>modular_model_index.json</code> file. Explicitly load the components by calling <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_components">ModularPipeline.load_components()</a>.',Jl,O,bt='It is a good idea to initialize the <code>ComponentManager</code> with the pipeline to help manage the different components. Once you call <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_components">load_components()</a>, the components are registered to the <code>ComponentManager</code> and can be shared between workflows. The example below uses the <code>collection</code> argument to assign the components a <code>&quot;diffdiff&quot;</code> label for better organization.',Ul,ee,Tl,le,bl,te,wt='Other workflows can be added to the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> to support additional features without rewriting the entire pipeline from scratch.',wl,se,Zt="This section demonstrates how to add an IP-Adapter or ControlNet.",Zl,ie,hl,ne,ht="Stable Diffusion XL already has a preset IP-Adapter block that you can use and doesn’t require any changes to the existing Differential Diffusion pipeline.",Il,ae,jl,oe,It='Use the <code>sub_blocks.insert</code> method to insert it into the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>. The example below inserts the <code>ip_adapter_block</code> at position <code>0</code>. Print the pipeline to see that the <code>ip_adapter_block</code> is added and it requires an <code>ip_adapter_image</code>. This also added two components to the pipeline, the <code>image_encoder</code> and <code>feature_extractor</code>.',Cl,pe,Gl,Me,jt='Call <code>~ModularPipeline.init_pipeline</code> to initialize a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> and use <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_components">load_components()</a> to load the model components. Load and set the IP-Adapter to run the pipeline.',Rl,de,kl,ce,_l,re,Ct="Stable Diffusion XL already has a preset ControlNet block that can readily be used.",Wl,fe,Xl,me,Gt="However, it requires modifying the <code>denoise</code> block because that’s where the ControlNet injects the control information into the UNet.",Bl,ue,Rt="Modify the <code>denoise</code> block by replacing the <code>StableDiffusionXLLoopDenoiser</code> sub-block with the <code>StableDiffusionXLControlNetLoopDenoiser</code>.",gl,ye,Vl,Je,kt='Insert the <code>controlnet_input</code> block and replace the <code>denoise</code> block with the new <code>controlnet_denoise_block</code>. Initialize a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> and <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_components">load_components()</a> into it.',Sl,Ue,Fl,Te,vl,be,_t='The Differential Diffusion, IP-Adapter, and ControlNet workflows can be bundled into a single <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> by using <code>AutoPipelineBlocks</code>. This allows automatically selecting which sub-blocks to run based on the inputs like <code>control_image</code> or <code>ip_adapter_image</code>. If none of these inputs are passed, then it defaults to the Differential Diffusion.',$l,we,Wt="Use <code>block_trigger_inputs</code> to only run the <code>SDXLDiffDiffControlNetDenoiseStep</code> block if a <code>control_image</code> input is provided. Otherwise, the <code>SDXLDiffDiffDenoiseStep</code> is used.",Yl,Ze,Nl,he,Xt="Add the <code>ip_adapter</code> and <code>controlnet_input</code> blocks.",Ql,Ie,El,je,Bt='Call <code>SequentialPipelineBlocks.from_blocks_dict</code> to create a <code>SequentialPipelineBlocks</code> and create a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> and load in the model components to run.',Ll,Ce,Dl,Ge,Al,Re,gt='Add your <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> to the Hub with <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.save_pretrained">save_pretrained()</a> and set <code>push_to_hub</code> argument to <code>True</code>.',zl,ke,xl,_e,Vt='Other users can load the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> with <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.from_pretrained">from_pretrained()</a>.',Hl,We,ql,Xe,Pl,ge,Kl;return U=new Dt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new y({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),Z=new y({props:{title:"ModularPipelineBlocks",local:"modularpipelineblocks",headingTag:"h2"}}),C=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwSU1BR0UySU1BR0VfQkxPQ0tTJTBBSU1BR0UySU1BR0VfQkxPQ0tTJTIwJTNEJTIwSW5zZXJ0YWJsZURpY3QoJTVCJTBBJTIwJTIwJTIwJTIwKCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMVGV4dEVuY29kZXJTdGVwKSUyQyUwQSUyMCUyMCUyMCUyMCglMjJpbWFnZV9lbmNvZGVyJTIyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExWYWVFbmNvZGVyU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyaW5wdXQlMjIlMkMlMjBTdGFibGVEaWZmdXNpb25YTElucHV0U3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyc2V0X3RpbWVzdGVwcyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1NldFRpbWVzdGVwc1N0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMnByZXBhcmVfbGF0ZW50cyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIycHJlcGFyZV9hZGRfY29uZCUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVBZGRpdGlvbmFsQ29uZGl0aW9uaW5nU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyZGVub2lzZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZVN0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMmRlY29kZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVjb2RlU3RlcCklMEElNUQp",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> IMAGE2IMAGE_BLOCKS
IMAGE2IMAGE_BLOCKS = InsertableDict([
    (<span class="hljs-string">&quot;text_encoder&quot;</span>, StableDiffusionXLTextEncoderStep),
    (<span class="hljs-string">&quot;image_encoder&quot;</span>, StableDiffusionXLVaeEncoderStep),
    (<span class="hljs-string">&quot;input&quot;</span>, StableDiffusionXLInputStep),
    (<span class="hljs-string">&quot;set_timesteps&quot;</span>, StableDiffusionXLImg2ImgSetTimestepsStep),
    (<span class="hljs-string">&quot;prepare_latents&quot;</span>, StableDiffusionXLImg2ImgPrepareLatentsStep),
    (<span class="hljs-string">&quot;prepare_add_cond&quot;</span>, StableDiffusionXLImg2ImgPrepareAdditionalConditioningStep),
    (<span class="hljs-string">&quot;denoise&quot;</span>, StableDiffusionXLDenoiseStep),
    (<span class="hljs-string">&quot;decode&quot;</span>, StableDiffusionXLDecodeStep)
])`,wrap:!1}}),G=new y({props:{title:"Pipeline and block states",local:"pipeline-and-block-states",headingTag:"h2"}}),_=new y({props:{title:"Customizing blocks",local:"customizing-blocks",headingTag:"h2"}}),g=new u({props:{code:"ZGVub2lzZV9ibG9ja3MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEKCklMEFwcmludChkZW5vaXNlX2Jsb2Nrcyk=",highlighted:`denoise_blocks = IMAGE2IMAGE_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>]()
<span class="hljs-built_in">print</span>(denoise_blocks)`,wrap:!1}}),S=new u({props:{code:"JTIzJTIwQ29weSUyMGV4aXN0aW5nJTIwYmxvY2tzJTIwYXMlMjBwbGFjZWhvbGRlcnMlMEFjbGFzcyUyMFNEWExEaWZmRGlmZlByZXBhcmVMYXRlbnRzU3RlcChNb2R1bGFyUGlwZWxpbmVCbG9ja3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ29waWVkJTIwZnJvbSUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCUyMC0lMjB3aWxsJTIwbW9kaWZ5JTIwbGF0ZXIlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjBzYW1lJTIwaW1wbGVtZW50YXRpb24lMjBhcyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCUwQSUwQWNsYXNzJTIwU0RYTERpZmZEaWZmRGVub2lzZVN0ZXAoU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlTG9vcFdyYXBwZXIpJTNBJTBBJTIwJTIwJTIwJTIwYmxvY2tfY2xhc3NlcyUyMCUzRCUyMCU1QlNEWExEaWZmRGlmZkxvb3BCZWZvcmVEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMTG9vcERlbm9pc2VyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExMb29wQWZ0ZXJEZW5vaXNlciU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX25hbWVzJTIwJTNEJTIwJTVCJTIyYmVmb3JlX2Rlbm9pc2VyJTIyJTJDJTIwJTIyZGVub2lzZXIlMjIlMkMlMjAlMjJhZnRlcl9kZW5vaXNlciUyMiU1RA==",highlighted:`<span class="hljs-comment"># Copy existing blocks as placeholders</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffPrepareLatentsStep</span>(<span class="hljs-title class_ inherited__">ModularPipelineBlocks</span>):
    <span class="hljs-string">&quot;&quot;&quot;Copied from StableDiffusionXLImg2ImgPrepareLatentsStep - will modify later&quot;&quot;&quot;</span>
    <span class="hljs-comment"># ... same implementation as StableDiffusionXLImg2ImgPrepareLatentsStep</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLLoopDenoiser, StableDiffusionXLLoopAfterDenoiser]
    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]`,wrap:!1}}),F=new y({props:{title:"prepare_latents",local:"preparelatents",headingTag:"h3"}}),Y=new u({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAoTW9kdWxhclBpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwZXhwZWN0ZWRfY29tcG9uZW50cyhzZWxmKSUyMC0lM0UlMjBMaXN0JTVCQ29tcG9uZW50U3BlYyU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMENvbXBvbmVudFNwZWMoJTIydmFlJTIyJTJDJTIwQXV0b2VuY29kZXJLTCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb21wb25lbnRTcGVjKCUyMnNjaGVkdWxlciUyMiUyQyUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIpJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQ29tcG9uZW50U3BlYyglMjJtYXNrX3Byb2Nlc3NvciUyMiUyQyUyMFZhZUltYWdlUHJvY2Vzc29yJTJDJTIwY29uZmlnJTNERnJvemVuRGljdCglN0IlMjJkb19ub3JtYWxpemUlMjIlM0ElMjBGYWxzZSUyQyUyMCUyMmRvX2NvbnZlcnRfZ3JheXNjYWxlJTIyJTNBJTIwVHJ1ZSU3RCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBpbnB1dHMoc2VsZiklMjAtJTNFJTIwTGlzdCU1QlR1cGxlJTVCc3RyJTJDJTIwQW55JTVEJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSW5wdXRQYXJhbSglMjJnZW5lcmF0b3IlMjIpJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSW5wdXRQYXJhbSglMjJkaWZmZGlmZl9tYXAlMjIlMkMlMjByZXF1aXJlZCUzRFRydWUpJTJDJTBBLSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMElucHV0UGFyYW0oJTIybGF0ZW50X3RpbWVzdGVwJTIyJTJDJTIwcmVxdWlyZWQlM0RUcnVlJTJDJTIwdHlwZV9oaW50JTNEdG9yY2guVGVuc29yKSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMElucHV0UGFyYW0oJTIydGltZXN0ZXBzJTIyJTJDJTIwdHlwZV9oaW50JTNEdG9yY2guVGVuc29yKSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMElucHV0UGFyYW0oJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUyQyUyMHR5cGVfaGludCUzRGludCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjAlNDBwcm9wZXJ0eSUwQSUyMCUyMCUyMCUyMGRlZiUyMGludGVybWVkaWF0ZV9vdXRwdXRzKHNlbGYpJTIwLSUzRSUyMExpc3QlNUJPdXRwdXRQYXJhbSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME91dHB1dFBhcmFtKCUyMm9yaWdpbmFsX2xhdGVudHMlMjIlMkMlMjB0eXBlX2hpbnQlM0R0b3JjaC5UZW5zb3IpJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwT3V0cHV0UGFyYW0oJTIyZGlmZmRpZmZfbWFza3MlMjIlMkMlMjB0eXBlX2hpbnQlM0R0b3JjaC5UZW5zb3IpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZSUzQSUyMFBpcGVsaW5lU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTIwZXhpc3RpbmclMjBsb2dpYyUyMC4uLiUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBjaGFuZ2UlMjBtYXAlMjBhbmQlMjBjcmVhdGUlMjBtYXNrcyUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpZmZkaWZmX21hcCUyMCUzRCUyMGNvbXBvbmVudHMubWFza19wcm9jZXNzb3IucHJlcHJvY2VzcyhibG9ja19zdGF0ZS5kaWZmZGlmZl9tYXAlMkMlMjBoZWlnaHQlM0RsYXRlbnRfaGVpZ2h0JTJDJTIwd2lkdGglM0RsYXRlbnRfd2lkdGgpJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGhyZXNob2xkcyUyMCUzRCUyMHRvcmNoLmFyYW5nZShibG9ja19zdGF0ZS5udW1faW5mZXJlbmNlX3N0ZXBzJTJDJTIwZHR5cGUlM0RkaWZmZGlmZl9tYXAuZHR5cGUpJTIwJTJGJTIwYmxvY2tfc3RhdGUubnVtX2luZmVyZW5jZV9zdGVwcyUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX3N0YXRlLmRpZmZkaWZmX21hc2tzJTIwJTNEJTIwZGlmZmRpZmZfbWFwJTIwJTNFJTIwKHRocmVzaG9sZHMlMjAlMkIlMjAoYmxvY2tfc3RhdGUuZGVub2lzaW5nX3N0YXJ0JTIwb3IlMjAwKSklMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19zdGF0ZS5vcmlnaW5hbF9sYXRlbnRzJTIwJTNEJTIwYmxvY2tfc3RhdGUubGF0ZW50cw==",highlighted:`class SDXLDiffDiffPrepareLatentsStep(ModularPipelineBlocks):
    @property
    def expected_components(self) -&gt; List[ComponentSpec]:
        return [
            ComponentSpec(&quot;vae&quot;, AutoencoderKL),
            ComponentSpec(&quot;scheduler&quot;, EulerDiscreteScheduler),
<span class="hljs-addition">+           ComponentSpec(&quot;mask_processor&quot;, VaeImageProcessor, config=FrozenDict({&quot;do_normalize&quot;: False, &quot;do_convert_grayscale&quot;: True}))</span>
        ]
    @property
    def inputs(self) -&gt; List[Tuple[str, Any]]:
        return [
            InputParam(&quot;generator&quot;),
<span class="hljs-addition">+           InputParam(&quot;diffdiff_map&quot;, required=True),</span>
<span class="hljs-deletion">-           InputParam(&quot;latent_timestep&quot;, required=True, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;timesteps&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;num_inference_steps&quot;, type_hint=int),</span>
        ]

    @property
    def intermediate_outputs(self) -&gt; List[OutputParam]:
        return [
<span class="hljs-addition">+           OutputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           OutputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]
    def __call__(self, components, state: PipelineState):
        # ... existing logic ...
<span class="hljs-addition">+       # Process change map and create masks</span>
<span class="hljs-addition">+       diffdiff_map = components.mask_processor.preprocess(block_state.diffdiff_map, height=latent_height, width=latent_width)</span>
<span class="hljs-addition">+       thresholds = torch.arange(block_state.num_inference_steps, dtype=diffdiff_map.dtype) / block_state.num_inference_steps</span>
<span class="hljs-addition">+       block_state.diffdiff_masks = diffdiff_map &gt; (thresholds + (block_state.denoising_start or 0))</span>
<span class="hljs-addition">+       block_state.original_latents = block_state.latents</span>`,wrap:!1}}),N=new y({props:{title:"denoise",local:"denoise",headingTag:"h3"}}),L=new u({props:{code:"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",highlighted:`class SDXLDiffDiffLoopBeforeDenoiser(ModularPipelineBlocks):
    @property
    def description(self) -&gt; str:
        return (
            &quot;Step within the denoising loop for differential diffusion that prepare the latent input for the denoiser&quot;
        )

    @property
    def inputs(self) -&gt; List[str]:
        return [
            InputParam(&quot;latents&quot;, required=True, type_hint=torch.Tensor),
<span class="hljs-addition">+           InputParam(&quot;denoising_start&quot;),</span>
<span class="hljs-addition">+           InputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]

    def __call__(self, components, block_state, i, t):
<span class="hljs-addition">+       # Apply differential diffusion logic</span>
<span class="hljs-addition">+       if i == 0 and block_state.denoising_start is None:</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[:1]</span>
<span class="hljs-addition">+       else:</span>
<span class="hljs-addition">+           block_state.mask = block_state.diffdiff_masks[i].unsqueeze(0).unsqueeze(1)</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[i] * block_state.mask + block_state.latents * (1 - block_state.mask)</span>

        # ... rest of existing logic ...`,wrap:!1}}),D=new y({props:{title:"Assembling the blocks",local:"assembling-the-blocks",headingTag:"h2"}}),q=new u({props:{code:"RElGRkRJRkZfQkxPQ0tTJTIwJTNEJTIwSU1BR0UySU1BR0VfQkxPQ0tTLmNvcHkoKSUwQURJRkZESUZGX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEJTIwJTNEJTIwU0RYTERpZmZEaWZmRGVub2lzZVN0ZXAlMEElMEFkZF9ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9CTE9DS1MpJTBBcHJpbnQoZGRfYmxvY2tzKQ==",highlighted:`DIFFDIFF_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffDenoiseStep

dd_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_BLOCKS)
<span class="hljs-built_in">print</span>(dd_blocks)`,wrap:!1}}),P=new y({props:{title:"ModularPipeline",local:"modularpipeline",headingTag:"h2"}}),ee=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMENvbXBvbmVudHNNYW5hZ2VyJTBBJTBBY29tcG9uZW50cyUyMCUzRCUyMENvbXBvbmVudE1hbmFnZXIoKSUwQSUwQWRkX3BpcGVsaW5lJTIwJTNEJTIwZGRfYmxvY2tzLmluaXRfcGlwZWxpbmUoJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRfZGVmYXVsdF9jb21wb25lbmV0cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGRfcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> ComponentsManager

components = ComponentManager()

dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, components_manager=components, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_default_componenets(torch_dtype=torch.float16)
dd_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),le=new y({props:{title:"Adding workflows",local:"adding-workflows",headingTag:"h2"}}),ie=new y({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h3"}}),ae=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLmVuY29kZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvSVBBZGFwdGVyU3RlcCUwQSUwQWlwX2FkYXB0ZXJfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9JUEFkYXB0ZXJTdGVwKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.encoders <span class="hljs-keyword">import</span> StableDiffusionXLAutoIPAdapterStep

ip_adapter_block = StableDiffusionXLAutoIPAdapterStep()`,wrap:!1}}),pe=new u({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmlwX2FkYXB0ZXIlMjIlMkMlMjBpcF9hZGFwdGVyX2Jsb2NrJTJDJTIwMCk=",highlighted:'dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, ip_adapter_block, <span class="hljs-number">0</span>)',wrap:!1}}),de=new u({props:{code:"ZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9ibG9ja3MuaW5pdF9waXBlbGluZSglMjJZaVlpWHUlMkZtb2R1bGFyLWRlbW8tYXV0byUyMiUyQyUyMGNvbGxlY3Rpb24lM0QlMjJkaWZmZGlmZiUyMiklMEFkZF9waXBlbGluZS5sb2FkX2NvbXBvbmVudHModG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWRkX3BpcGVsaW5lLmxvYWRlci5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRlci5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYpJTBBZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9waXBlbGluZS50byhkZXZpY2UpJTBBJTBBaXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZkaWZmX29yYW5nZS5qcGVnJTIyKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGMjAyNDAzMjkyMTExMjlfNDAyNDkxMTkzMC5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGT3p6eUdUJTJGdGVzdGluZy1yZXNvdXJjZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZlcmVudGlhbCUyRmdyYWRpZW50X21hc2sucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBncmVlbiUyMHBlYXIlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJibHVycnklMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZCg0MiklMEElMEFpbWFnZSUyMCUzRCUyMGRkX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpcF9hZGFwdGVyX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZGlmZmRpZmZfbWFwJTNEbWFzayUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXQlM0QlMjJpbWFnZXMlMjIlMEEpJTVCMCU1RA==",highlighted:`dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)
dd_pipeline.loader.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
dd_pipeline.loader.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)
dd_pipeline = dd_pipeline.to(device)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_orange.jpeg&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>)

prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

image = dd_pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    ip_adapter_image=ip_adapter_image,
    diffdiff_map=mask,
    image=image,
    output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]`,wrap:!1}}),ce=new y({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),fe=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLm1vZHVsYXJfYmxvY2tzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvQ29udHJvbE5ldElucHV0U3RlcCUwQSUwQWNvbnRyb2xfaW5wdXRfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9Db250cm9sTmV0SW5wdXRTdGVwKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.modular_blocks <span class="hljs-keyword">import</span> StableDiffusionXLAutoControlNetInputStep

control_input_block = StableDiffusionXLAutoControlNetInputStep()`,wrap:!1}}),ye=new u({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAoU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlTG9vcFdyYXBwZXIpJTNBJTBBJTIwJTIwJTIwJTIwYmxvY2tfY2xhc3NlcyUyMCUzRCUyMCU1QlNEWExEaWZmRGlmZkxvb3BCZWZvcmVEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldExvb3BEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZUxvb3BBZnRlckRlbm9pc2VyJTVEJTBBJTIwJTIwJTIwJTIwYmxvY2tfbmFtZXMlMjAlM0QlMjAlNUIlMjJiZWZvcmVfZGVub2lzZXIlMjIlMkMlMjAlMjJkZW5vaXNlciUyMiUyQyUyMCUyMmFmdGVyX2Rlbm9pc2VyJTIyJTVEJTBBJTBBY29udHJvbG5ldF9kZW5vaXNlX2Jsb2NrJTIwJTNEJTIwU0RYTERpZmZEaWZmQ29udHJvbE5ldERlbm9pc2VTdGVwKCk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffControlNetDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLControlNetLoopDenoiser, StableDiffusionXLDenoiseLoopAfterDenoiser]
    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]

controlnet_denoise_block = SDXLDiffDiffControlNetDenoiseStep()`,wrap:!1}}),Ue=new u({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmNvbnRyb2xuZXRfaW5wdXQlMjIlMkMlMjBjb250cm9sX2lucHV0X2Jsb2NrJTJDJTIwNyklMEFkZF9ibG9ja3Muc3ViX2Jsb2NrcyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBjb250cm9sbmV0X2Rlbm9pc2VfYmxvY2slMEElMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2Jsb2Nrcy5pbml0X3BpcGVsaW5lKCUyMllpWWlYdSUyRm1vZHVsYXItZGVtby1hdXRvJTIyJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9waXBlbGluZS50byhkZXZpY2UpJTBBJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZkaWZmX3RvbWF0b19jYW5ueS5qcGVnJTIyKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGMjAyNDAzMjkyMTExMjlfNDAyNDkxMTkzMC5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGT3p6eUdUJTJGdGVzdGluZy1yZXNvdXJjZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZlcmVudGlhbCUyRmdyYWRpZW50X21hc2sucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBncmVlbiUyMHBlYXIlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJibHVycnklMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZCg0MiklMEElMEFpbWFnZSUyMCUzRCUyMGRkX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBkaWZmZGlmZl9tYXAlM0RtYXNrJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dCUzRCUyMmltYWdlcyUyMiUwQSklNUIwJTVE",highlighted:`dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>, control_input_block, <span class="hljs-number">7</span>)
dd_blocks.sub_blocks[<span class="hljs-string">&quot;denoise&quot;</span>] = controlnet_denoise_block

dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)
dd_pipeline = dd_pipeline.to(device)

control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_tomato_canny.jpeg&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>)

prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

image = dd_pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    control_image=control_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
    diffdiff_map=mask,
    image=image,
    output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]`,wrap:!1}}),Te=new y({props:{title:"AutoPipelineBlocks",local:"autopipelineblocks",headingTag:"h3"}}),Ze=new u({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAoQXV0b1BpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMGJsb2NrX2NsYXNzZXMlMjAlM0QlMjAlNUJTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAlMkMlMjBTRFhMRGlmZkRpZmZEZW5vaXNlU3RlcCU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX25hbWVzJTIwJTNEJTIwJTVCJTIyY29udHJvbG5ldF9kZW5vaXNlJTIyJTJDJTIwJTIyZGVub2lzZSUyMiU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX3RyaWdnZXJfaW5wdXRzJTIwJTNEJTIwJTVCJTIyY29udHJvbG5ldF9jb25kJTIyJTJDJTIwTm9uZSU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffAutoDenoiseStep</span>(<span class="hljs-title class_ inherited__">AutoPipelineBlocks</span>):
    block_classes = [SDXLDiffDiffControlNetDenoiseStep, SDXLDiffDiffDenoiseStep]
    block_names = [<span class="hljs-string">&quot;controlnet_denoise&quot;</span>, <span class="hljs-string">&quot;denoise&quot;</span>]
    block_trigger_inputs = [<span class="hljs-string">&quot;controlnet_cond&quot;</span>, <span class="hljs-literal">None</span>]`,wrap:!1}}),Ie=new u({props:{code:"RElGRkRJRkZfQVVUT19CTE9DS1MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MuY29weSgpJTBBRElGRkRJRkZfQVVUT19CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUy5pbnNlcnQoJTIyaXBfYWRhcHRlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQXV0b0lQQWRhcHRlclN0ZXAlMkMlMjAwKSUwQURJRkZESUZGX0FVVE9fQkxPQ0tTLmluc2VydCglMjJjb250cm9sbmV0X2lucHV0JTIyJTJDU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0QXV0b0lucHV0JTJDJTIwNyk=",highlighted:`DIFFDIFF_AUTO_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffAutoDenoiseStep
DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, StableDiffusionXLAutoIPAdapterStep, <span class="hljs-number">0</span>)
DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>,StableDiffusionXLControlNetAutoInput, <span class="hljs-number">7</span>)`,wrap:!1}}),Ce=new u({props:{code:"ZGRfYXV0b19ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9BVVRPX0JMT0NLUyklMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2F1dG9fYmxvY2tzLmluaXRfcGlwZWxpbmUoJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMkMlMjBjb2xsZWN0aW9uJTNEJTIyZGlmZmRpZmYlMjIpJTBBZGRfcGlwZWxpbmUubG9hZF9jb21wb25lbnRzKHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNik=",highlighted:`dd_auto_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_AUTO_BLOCKS)
dd_pipeline = dd_auto_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)`,wrap:!1}}),Ge=new y({props:{title:"Share",local:"share",headingTag:"h2"}}),ke=new u({props:{code:"ZGRfcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMllpWWlYdSUyRnRlc3RfbW9kdWxhcl9kb2MlMjIlMkMlMjBwdXNoX3RvX2h1YiUzRFRydWUp",highlighted:'dd_pipeline.save_pretrained(<span class="hljs-string">&quot;YiYiXu/test_modular_doc&quot;</span>, push_to_hub=<span class="hljs-literal">True</span>)',wrap:!1}}),We=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwTW9kdWxhclBpcGVsaW5lJTJDJTIwQ29tcG9uZW50c01hbmFnZXIlMEElMEFjb21wb25lbnRzJTIwJTNEJTIwQ29tcG9uZW50c01hbmFnZXIoKSUwQSUwQWRpZmZkaWZmX3BpcGVsaW5lJTIwJTNEJTIwTW9kdWxhclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJZaVlpWHUlMkZtb2R1bGFyLWRpZmZkaWZmLTA3MDQlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRpZmZkaWZmX3BpcGVsaW5lLmxvYWRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> ModularPipeline, ComponentsManager

components = ComponentsManager()

diffdiff_pipeline = ModularPipeline.from_pretrained(<span class="hljs-string">&quot;YiYiXu/modular-diffdiff-0704&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, components_manager=components, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
diffdiff_pipeline.load_components(torch_dtype=torch.float16)`,wrap:!1}}),Xe=new At({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/quickstart.md"}}),{c(){J=a("meta"),Ve=i(),Be=a("p"),Se=i(),M(U.$$.fragment),Fe=i(),M(T.$$.fragment),ve=i(),b=a("p"),b.innerHTML=et,$e=i(),w=a("p"),w.innerHTML=lt,Ye=i(),M(Z.$$.fragment),Ne=i(),h=a("p"),h.innerHTML=tt,Qe=i(),I=a("ul"),I.innerHTML=st,Ee=i(),j=a("p"),j.innerHTML=it,Le=i(),M(C.$$.fragment),De=i(),M(G.$$.fragment),Ae=i(),R=a("p"),R.innerHTML=nt,ze=i(),k=a("ul"),k.innerHTML=at,xe=i(),M(_.$$.fragment),He=i(),W=a("p"),W.innerHTML=ot,qe=i(),X=a("p"),X.innerHTML=pt,Pe=i(),B=a("p"),B.innerHTML=Mt,Ke=i(),M(g.$$.fragment),Oe=i(),V=a("p"),V.innerHTML=dt,el=i(),M(S.$$.fragment),ll=i(),M(F.$$.fragment),tl=i(),v=a("p"),v.innerHTML=ct,sl=i(),$=a("ul"),$.innerHTML=rt,il=i(),M(Y.$$.fragment),nl=i(),M(N.$$.fragment),al=i(),Q=a("p"),Q.innerHTML=ft,ol=i(),E=a("ul"),E.innerHTML=mt,pl=i(),M(L.$$.fragment),Ml=i(),M(D.$$.fragment),dl=i(),A=a("p"),A.innerHTML=ut,cl=i(),z=a("p"),z.innerHTML=yt,rl=i(),x=a("p"),x.innerHTML=Jt,fl=i(),H=a("p"),H.innerHTML=Ut,ml=i(),M(q.$$.fragment),ul=i(),M(P.$$.fragment),yl=i(),K=a("p"),K.innerHTML=Tt,Jl=i(),O=a("p"),O.innerHTML=bt,Ul=i(),M(ee.$$.fragment),Tl=i(),M(le.$$.fragment),bl=i(),te=a("p"),te.innerHTML=wt,wl=i(),se=a("p"),se.textContent=Zt,Zl=i(),M(ie.$$.fragment),hl=i(),ne=a("p"),ne.textContent=ht,Il=i(),M(ae.$$.fragment),jl=i(),oe=a("p"),oe.innerHTML=It,Cl=i(),M(pe.$$.fragment),Gl=i(),Me=a("p"),Me.innerHTML=jt,Rl=i(),M(de.$$.fragment),kl=i(),M(ce.$$.fragment),_l=i(),re=a("p"),re.textContent=Ct,Wl=i(),M(fe.$$.fragment),Xl=i(),me=a("p"),me.innerHTML=Gt,Bl=i(),ue=a("p"),ue.innerHTML=Rt,gl=i(),M(ye.$$.fragment),Vl=i(),Je=a("p"),Je.innerHTML=kt,Sl=i(),M(Ue.$$.fragment),Fl=i(),M(Te.$$.fragment),vl=i(),be=a("p"),be.innerHTML=_t,$l=i(),we=a("p"),we.innerHTML=Wt,Yl=i(),M(Ze.$$.fragment),Nl=i(),he=a("p"),he.innerHTML=Xt,Ql=i(),M(Ie.$$.fragment),El=i(),je=a("p"),je.innerHTML=Bt,Ll=i(),M(Ce.$$.fragment),Dl=i(),M(Ge.$$.fragment),Al=i(),Re=a("p"),Re.innerHTML=gt,zl=i(),M(ke.$$.fragment),xl=i(),_e=a("p"),_e.innerHTML=Vt,Hl=i(),M(We.$$.fragment),ql=i(),M(Xe.$$.fragment),Pl=i(),ge=a("p"),this.h()},l(e){const l=Et("svelte-u9bgzb",document.head);J=o(l,"META",{name:!0,content:!0}),l.forEach(t),Ve=n(e),Be=o(e,"P",{}),St(Be).forEach(t),Se=n(e),d(U.$$.fragment,e),Fe=n(e),d(T.$$.fragment,e),ve=n(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-nfr4qm"&&(b.innerHTML=et),$e=n(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-14bi1ah"&&(w.innerHTML=lt),Ye=n(e),d(Z.$$.fragment,e),Ne=n(e),h=o(e,"P",{"data-svelte-h":!0}),p(h)!=="svelte-lxy6vq"&&(h.innerHTML=tt),Qe=n(e),I=o(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-2w7id0"&&(I.innerHTML=st),Ee=n(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-7tdtn5"&&(j.innerHTML=it),Le=n(e),d(C.$$.fragment,e),De=n(e),d(G.$$.fragment,e),Ae=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1hrx77z"&&(R.innerHTML=nt),ze=n(e),k=o(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-hgqjo0"&&(k.innerHTML=at),xe=n(e),d(_.$$.fragment,e),He=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-16tz7j4"&&(W.innerHTML=ot),qe=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-pmw538"&&(X.innerHTML=pt),Pe=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1qke84t"&&(B.innerHTML=Mt),Ke=n(e),d(g.$$.fragment,e),Oe=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-g4vtz4"&&(V.innerHTML=dt),el=n(e),d(S.$$.fragment,e),ll=n(e),d(F.$$.fragment,e),tl=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1hnij81"&&(v.innerHTML=ct),sl=n(e),$=o(e,"UL",{"data-svelte-h":!0}),p($)!=="svelte-wu0sp3"&&($.innerHTML=rt),il=n(e),d(Y.$$.fragment,e),nl=n(e),d(N.$$.fragment,e),al=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1lriej4"&&(Q.innerHTML=ft),ol=n(e),E=o(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-k274di"&&(E.innerHTML=mt),pl=n(e),d(L.$$.fragment,e),Ml=n(e),d(D.$$.fragment,e),dl=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-rx5cas"&&(A.innerHTML=ut),cl=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-bcrjsa"&&(z.innerHTML=yt),rl=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1qdwaia"&&(x.innerHTML=Jt),fl=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-c6bj14"&&(H.innerHTML=Ut),ml=n(e),d(q.$$.fragment,e),ul=n(e),d(P.$$.fragment,e),yl=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1yr6nun"&&(K.innerHTML=Tt),Jl=n(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-wfwts7"&&(O.innerHTML=bt),Ul=n(e),d(ee.$$.fragment,e),Tl=n(e),d(le.$$.fragment,e),bl=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-rh0ns8"&&(te.innerHTML=wt),wl=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-denp3n"&&(se.textContent=Zt),Zl=n(e),d(ie.$$.fragment,e),hl=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1mrw5mx"&&(ne.textContent=ht),Il=n(e),d(ae.$$.fragment,e),jl=n(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1lami1t"&&(oe.innerHTML=It),Cl=n(e),d(pe.$$.fragment,e),Gl=n(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1wpybzc"&&(Me.innerHTML=jt),Rl=n(e),d(de.$$.fragment,e),kl=n(e),d(ce.$$.fragment,e),_l=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-wr3jw6"&&(re.textContent=Ct),Wl=n(e),d(fe.$$.fragment,e),Xl=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-czmnsx"&&(me.innerHTML=Gt),Bl=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-mbulqa"&&(ue.innerHTML=Rt),gl=n(e),d(ye.$$.fragment,e),Vl=n(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-19e8srk"&&(Je.innerHTML=kt),Sl=n(e),d(Ue.$$.fragment,e),Fl=n(e),d(Te.$$.fragment,e),vl=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-12xk6i1"&&(be.innerHTML=_t),$l=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-rehsh7"&&(we.innerHTML=Wt),Yl=n(e),d(Ze.$$.fragment,e),Nl=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-o3hbbv"&&(he.innerHTML=Xt),Ql=n(e),d(Ie.$$.fragment,e),El=n(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-88pyw4"&&(je.innerHTML=Bt),Ll=n(e),d(Ce.$$.fragment,e),Dl=n(e),d(Ge.$$.fragment,e),Al=n(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-8sp303"&&(Re.innerHTML=gt),zl=n(e),d(ke.$$.fragment,e),xl=n(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1ceh4ne"&&(_e.innerHTML=Vt),Hl=n(e),d(We.$$.fragment,e),ql=n(e),d(Xe.$$.fragment,e),Pl=n(e),ge=o(e,"P",{}),St(ge).forEach(t),this.h()},h(){Ft(J,"name","hf:doc:metadata"),Ft(J,"content",xt)},m(e,l){Lt(document.head,J),s(e,Ve,l),s(e,Be,l),s(e,Se,l),c(U,e,l),s(e,Fe,l),c(T,e,l),s(e,ve,l),s(e,b,l),s(e,$e,l),s(e,w,l),s(e,Ye,l),c(Z,e,l),s(e,Ne,l),s(e,h,l),s(e,Qe,l),s(e,I,l),s(e,Ee,l),s(e,j,l),s(e,Le,l),c(C,e,l),s(e,De,l),c(G,e,l),s(e,Ae,l),s(e,R,l),s(e,ze,l),s(e,k,l),s(e,xe,l),c(_,e,l),s(e,He,l),s(e,W,l),s(e,qe,l),s(e,X,l),s(e,Pe,l),s(e,B,l),s(e,Ke,l),c(g,e,l),s(e,Oe,l),s(e,V,l),s(e,el,l),c(S,e,l),s(e,ll,l),c(F,e,l),s(e,tl,l),s(e,v,l),s(e,sl,l),s(e,$,l),s(e,il,l),c(Y,e,l),s(e,nl,l),c(N,e,l),s(e,al,l),s(e,Q,l),s(e,ol,l),s(e,E,l),s(e,pl,l),c(L,e,l),s(e,Ml,l),c(D,e,l),s(e,dl,l),s(e,A,l),s(e,cl,l),s(e,z,l),s(e,rl,l),s(e,x,l),s(e,fl,l),s(e,H,l),s(e,ml,l),c(q,e,l),s(e,ul,l),c(P,e,l),s(e,yl,l),s(e,K,l),s(e,Jl,l),s(e,O,l),s(e,Ul,l),c(ee,e,l),s(e,Tl,l),c(le,e,l),s(e,bl,l),s(e,te,l),s(e,wl,l),s(e,se,l),s(e,Zl,l),c(ie,e,l),s(e,hl,l),s(e,ne,l),s(e,Il,l),c(ae,e,l),s(e,jl,l),s(e,oe,l),s(e,Cl,l),c(pe,e,l),s(e,Gl,l),s(e,Me,l),s(e,Rl,l),c(de,e,l),s(e,kl,l),c(ce,e,l),s(e,_l,l),s(e,re,l),s(e,Wl,l),c(fe,e,l),s(e,Xl,l),s(e,me,l),s(e,Bl,l),s(e,ue,l),s(e,gl,l),c(ye,e,l),s(e,Vl,l),s(e,Je,l),s(e,Sl,l),c(Ue,e,l),s(e,Fl,l),c(Te,e,l),s(e,vl,l),s(e,be,l),s(e,$l,l),s(e,we,l),s(e,Yl,l),c(Ze,e,l),s(e,Nl,l),s(e,he,l),s(e,Ql,l),c(Ie,e,l),s(e,El,l),s(e,je,l),s(e,Ll,l),c(Ce,e,l),s(e,Dl,l),c(Ge,e,l),s(e,Al,l),s(e,Re,l),s(e,zl,l),c(ke,e,l),s(e,xl,l),s(e,_e,l),s(e,Hl,l),c(We,e,l),s(e,ql,l),c(Xe,e,l),s(e,Pl,l),s(e,ge,l),Kl=!0},p:$t,i(e){Kl||(r(U.$$.fragment,e),r(T.$$.fragment,e),r(Z.$$.fragment,e),r(C.$$.fragment,e),r(G.$$.fragment,e),r(_.$$.fragment,e),r(g.$$.fragment,e),r(S.$$.fragment,e),r(F.$$.fragment,e),r(Y.$$.fragment,e),r(N.$$.fragment,e),r(L.$$.fragment,e),r(D.$$.fragment,e),r(q.$$.fragment,e),r(P.$$.fragment,e),r(ee.$$.fragment,e),r(le.$$.fragment,e),r(ie.$$.fragment,e),r(ae.$$.fragment,e),r(pe.$$.fragment,e),r(de.$$.fragment,e),r(ce.$$.fragment,e),r(fe.$$.fragment,e),r(ye.$$.fragment,e),r(Ue.$$.fragment,e),r(Te.$$.fragment,e),r(Ze.$$.fragment,e),r(Ie.$$.fragment,e),r(Ce.$$.fragment,e),r(Ge.$$.fragment,e),r(ke.$$.fragment,e),r(We.$$.fragment,e),r(Xe.$$.fragment,e),Kl=!0)},o(e){f(U.$$.fragment,e),f(T.$$.fragment,e),f(Z.$$.fragment,e),f(C.$$.fragment,e),f(G.$$.fragment,e),f(_.$$.fragment,e),f(g.$$.fragment,e),f(S.$$.fragment,e),f(F.$$.fragment,e),f(Y.$$.fragment,e),f(N.$$.fragment,e),f(L.$$.fragment,e),f(D.$$.fragment,e),f(q.$$.fragment,e),f(P.$$.fragment,e),f(ee.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(ae.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(fe.$$.fragment,e),f(ye.$$.fragment,e),f(Ue.$$.fragment,e),f(Te.$$.fragment,e),f(Ze.$$.fragment,e),f(Ie.$$.fragment,e),f(Ce.$$.fragment,e),f(Ge.$$.fragment,e),f(ke.$$.fragment,e),f(We.$$.fragment,e),f(Xe.$$.fragment,e),Kl=!1},d(e){e&&(t(Ve),t(Be),t(Se),t(Fe),t(ve),t(b),t($e),t(w),t(Ye),t(Ne),t(h),t(Qe),t(I),t(Ee),t(j),t(Le),t(De),t(Ae),t(R),t(ze),t(k),t(xe),t(He),t(W),t(qe),t(X),t(Pe),t(B),t(Ke),t(Oe),t(V),t(el),t(ll),t(tl),t(v),t(sl),t($),t(il),t(nl),t(al),t(Q),t(ol),t(E),t(pl),t(Ml),t(dl),t(A),t(cl),t(z),t(rl),t(x),t(fl),t(H),t(ml),t(ul),t(yl),t(K),t(Jl),t(O),t(Ul),t(Tl),t(bl),t(te),t(wl),t(se),t(Zl),t(hl),t(ne),t(Il),t(jl),t(oe),t(Cl),t(Gl),t(Me),t(Rl),t(kl),t(_l),t(re),t(Wl),t(Xl),t(me),t(Bl),t(ue),t(gl),t(Vl),t(Je),t(Sl),t(Fl),t(vl),t(be),t($l),t(we),t(Yl),t(Nl),t(he),t(Ql),t(El),t(je),t(Ll),t(Dl),t(Al),t(Re),t(zl),t(xl),t(_e),t(Hl),t(ql),t(Pl),t(ge)),t(J),m(U,e),m(T,e),m(Z,e),m(C,e),m(G,e),m(_,e),m(g,e),m(S,e),m(F,e),m(Y,e),m(N,e),m(L,e),m(D,e),m(q,e),m(P,e),m(ee,e),m(le,e),m(ie,e),m(ae,e),m(pe,e),m(de,e),m(ce,e),m(fe,e),m(ye,e),m(Ue,e),m(Te,e),m(Ze,e),m(Ie,e),m(Ce,e),m(Ge,e),m(ke,e),m(We,e),m(Xe,e)}}}const xt='{"title":"Quickstart","local":"quickstart","sections":[{"title":"ModularPipelineBlocks","local":"modularpipelineblocks","sections":[],"depth":2},{"title":"Pipeline and block states","local":"pipeline-and-block-states","sections":[],"depth":2},{"title":"Customizing blocks","local":"customizing-blocks","sections":[{"title":"prepare_latents","local":"preparelatents","sections":[],"depth":3},{"title":"denoise","local":"denoise","sections":[],"depth":3}],"depth":2},{"title":"Assembling the blocks","local":"assembling-the-blocks","sections":[],"depth":2},{"title":"ModularPipeline","local":"modularpipeline","sections":[],"depth":2},{"title":"Adding workflows","local":"adding-workflows","sections":[{"title":"IP-Adapter","local":"ip-adapter","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3},{"title":"AutoPipelineBlocks","local":"autopipelineblocks","sections":[],"depth":3}],"depth":2},{"title":"Share","local":"share","sections":[],"depth":2}],"depth":1}';function Ht(Ol){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ls extends Nt{constructor(J){super(),Qt(this,J,Ht,zt,vt,{})}}export{ls as component};
