import{s as ue,n as he,o as fe}from"../chunks/scheduler.53228c21.js";import{S as ye,i as Me,e as s,s as n,c as p,h as we,a as i,d as l,b as o,f as ce,g as m,j as r,k as Vt,l as be,m as a,n as d,t as c,o as u,p as h}from"../chunks/index.100fac89.js";import{C as Je}from"../chunks/CopyLLMTxtMenu.4f0519ef.js";import{C as w}from"../chunks/CodeBlock.d30a6509.js";import{H as tt,E as Te}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.62dbb7c4.js";function ge(Ht){let f,at,et,nt,b,ot,J,st,T,Yt='<a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> provides high-performance dtypes and optimizations based on quantization and sparsity for inference and training PyTorch models. It is supported for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',it,g,Nt="Make sure Pytorch 2.5+ and torchao are installed with the command below.",rt,U,pt,j,At='Each quantization dtype is available as a separate instance of a <a href="https://docs.pytorch.org/ao/main/api_ref_quantization.html#inference-apis-for-quantize" rel="nofollow">AOBaseConfig</a> class. This provides more flexible configuration options by exposing more available arguments.',mt,Z,Lt='Pass the <code>AOBaseConfig</code> of a quantization dtype, like <a href="https://docs.pytorch.org/ao/main/generated/torchao.quantization.Int4WeightOnlyConfig" rel="nofollow">Int4WeightOnlyConfig</a> to <a href="/docs/diffusers/main/en/api/quantization#diffusers.TorchAoConfig">TorchAoConfig</a> in <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a>.',dt,v,ct,W,St="For simple use cases, you could also provide a string identifier in <code>TorchAo</code> as shown below.",ut,_,ht,q,ft,I,Pt='torchao supports <a href="../optimization/fp16#torchcompile">torch.compile</a> which can speed up inference with one line of code.',yt,B,Mt,G,Dt='Refer to this <a href="https://github.com/huggingface/diffusers/pull/10009#issue-2688781450" rel="nofollow">table</a> for inference speed and memory usage benchmarks with Flux and CogVideoX. More benchmarks on various hardware are also available in the torchao <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">repository</a>.',wt,y,Kt="<p>The FP8 post-training quantization schemes in torchao are effective for GPUs with compute capability of at least 8.9 (RTX-4090, Hopper, etc.). FP8 often provides the best speed, memory, and quality trade-off when generating images and videos. We recommend combining FP8 and torch.compile if your GPU is compatible.</p>",bt,C,Jt,z,Ot='torchao provides <a href="https://docs.pytorch.org/ao/stable/generated/torchao.quantization.autoquant.html#torchao.quantization.autoquant" rel="nofollow">autoquant</a> an automatic quantization API. Autoquantization chooses the best quantization strategy by comparing the performance of each strategy on chosen input types and shapes. This is only supported in Diffusers for individual models at the moment.',Tt,X,gt,$,Ut,k,te="torchao supports weight-only quantization and weight and dynamic-activation quantization for int8, float3-float8, and uint1-uint7.",jt,F,ee="Weight-only quantization stores the model weights in a specific low-bit data type but performs computation with a higher-precision data type, like <code>bfloat16</code>. This lowers the memory requirements from model weights but retains the memory peaks for activation computation.",Zt,x,le="Dynamic activation quantization stores the model weights in a low-bit dtype, while also quantizing the activations on-the-fly to save additional memory. This lowers the memory requirements from model weights, while also lowering the memory overhead from activation computations. However, this may come at a quality tradeoff at times, so it is recommended to test different models thoroughly.",vt,R,ae="The quantization methods supported are as follows:",Wt,Q,ne="<thead><tr><th><strong>Category</strong></th> <th><strong>Full Function Names</strong></th> <th><strong>Shorthands</strong></th></tr></thead> <tbody><tr><td><strong>Integer quantization</strong></td> <td><code>int4_weight_only</code>, <code>int8_dynamic_activation_int4_weight</code>, <code>int8_weight_only</code>, <code>int8_dynamic_activation_int8_weight</code></td> <td><code>int4wo</code>, <code>int4dq</code>, <code>int8wo</code>, <code>int8dq</code></td></tr> <tr><td><strong>Floating point 8-bit quantization</strong></td> <td><code>float8_weight_only</code>, <code>float8_dynamic_activation_float8_weight</code>, <code>float8_static_activation_float8_weight</code></td> <td><code>float8wo</code>, <code>float8wo_e5m2</code>, <code>float8wo_e4m3</code>, <code>float8dq</code>, <code>float8dq_e4m3</code>, <code>float8dq_e4m3_tensor</code>, <code>float8dq_e4m3_row</code></td></tr> <tr><td><strong>Floating point X-bit quantization</strong></td> <td><code>fpx_weight_only</code></td> <td><code>fpX_eAwB</code> where <code>X</code> is the number of bits (1-7), <code>A</code> is exponent bits, and <code>B</code> is mantissa bits. Constraint: <code>X == A + B + 1</code></td></tr> <tr><td><strong>Unsigned Integer quantization</strong></td> <td><code>uintx_weight_only</code></td> <td><code>uint1wo</code>, <code>uint2wo</code>, <code>uint3wo</code>, <code>uint4wo</code>, <code>uint5wo</code>, <code>uint6wo</code>, <code>uint7wo</code></td></tr></tbody>",_t,E,oe="Some quantization methods are aliases (for example, <code>int8wo</code> is the commonly used shorthand for <code>int8_weight_only</code>). This allows using the quantization methods described in the torchao docs as-is, while also making it convenient to remember their shorthand notations.",qt,V,se='Refer to the <a href="https://docs.pytorch.org/ao/stable/index.html" rel="nofollow">official torchao documentation</a> for a better understanding of the available quantization methods and the exhaustive list of configuration options available.',It,H,Bt,Y,ie='To serialize a quantized model in a given dtype, first load the model with the desired quantization dtype and then save it using the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a> method.',Gt,N,Ct,A,re='To load a serialized quantized model, use the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method.',zt,L,Xt,S,pe="If you are using <code>torch&lt;=2.6.0</code>, some quantization methods, such as <code>uint4wo</code>, cannot be loaded directly and may result in an <code>UnpicklingError</code> when trying to load the models, but work as expected when saving them. In order to work around this, one can load the state dict manually into the model. Note, however, that this requires using <code>weights_only=False</code> in <code>torch.load</code>, so it should be run only if the weights were obtained from a trustable source.",$t,P,kt,M,me='<p>The <a href="/docs/diffusers/main/en/api/models/auto_model#diffusers.AutoModel">AutoModel</a> API is supported for PyTorch &gt;= 2.6 as shown in the examples below.</p>',Ft,D,xt,K,de='<li><a href="https://docs.pytorch.org/ao/stable/index.html" rel="nofollow">TorchAO Quantization API</a></li> <li><a href="https://github.com/sayakpaul/diffusers-torchao" rel="nofollow">Diffusers-TorchAO examples</a></li>',Rt,O,Qt,lt,Et;return b=new Je({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new tt({props:{title:"torchao",local:"torchao",headingTag:"h1"}}),U=new w({props:{code:"dXYlMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjB0b3JjaCUyMHRvcmNoYW8=",highlighted:"uv pip install -U torch torchao",wrap:!1}}),v=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUyQyUyMFRvcmNoQW9Db25maWclMEFmcm9tJTIwdG9yY2hhby5xdWFudGl6YXRpb24lMjBpbXBvcnQlMjBJbnQ4V2VpZ2h0T25seUNvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X21hcHBpbmclM0QlN0IlMjJ0cmFuc2Zvcm1lciUyMiUzQSUyMFRvcmNoQW9Db25maWcoSW50OFdlaWdodE9ubHlDb25maWcoZ3JvdXBfc2l6ZSUzRDEyOCkpKSU3RCUwQSklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudHphdGlvbl9jb25maWclM0RwaXBlbGluZV9xdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, PipelineQuantizationConfig, TorchAoConfig
<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> Int8WeightOnlyConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={<span class="hljs-string">&quot;transformer&quot;</span>: TorchAoConfig(Int8WeightOnlyConfig(group_size=<span class="hljs-number">128</span>)))}
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantzation_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),_=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUyQyUyMFRvcmNoQW9Db25maWclMEElMEFwaXBlbGluZV9xdWFudF9jb25maWclMjAlM0QlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBxdWFudF9tYXBwaW5nJTNEJTdCJTIydHJhbnNmb3JtZXIlMjIlM0ElMjBUb3JjaEFvQ29uZmlnKCUyMmludDh3byUyMiklN0QlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnR6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, PipelineQuantizationConfig, TorchAoConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={<span class="hljs-string">&quot;transformer&quot;</span>: TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)}
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantzation_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),q=new tt({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),B=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUyQyUyMFRvcmNoQW9Db25maWclMEFmcm9tJTIwdG9yY2hhby5xdWFudGl6YXRpb24lMjBpbXBvcnQlMjBJbnQ0V2VpZ2h0T25seUNvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X21hcHBpbmclM0QlN0IlMjJ0cmFuc2Zvcm1lciUyMiUzQSUyMFRvcmNoQW9Db25maWcoSW50NFdlaWdodE9ubHlDb25maWcoZ3JvdXBfc2l6ZSUzRDEyOCkpKSU3RCUwQSklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudHphdGlvbl9jb25maWclM0RwaXBlbGluZV9xdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBJTBBcGlwZWxpbmUudHJhbnNmb3JtZXIuY29tcGlsZSh0cmFuc2Zvcm1lciUyQyUyMG1vZGUlM0QlMjJtYXgtYXV0b3R1bmUlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, PipelineQuantizationConfig, TorchAoConfig
<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> Int4WeightOnlyConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={<span class="hljs-string">&quot;transformer&quot;</span>: TorchAoConfig(Int4WeightOnlyConfig(group_size=<span class="hljs-number">128</span>)))}
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantzation_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)

pipeline.transformer.<span class="hljs-built_in">compile</span>(transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),C=new tt({props:{title:"autoquant",local:"autoquant",headingTag:"h2"}}),X=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwdG9yY2hhby5xdWFudGl6YXRpb24lMjBpbXBvcnQlMjBhdXRvcXVhbnQlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwcGlwZWxpbmUlMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1zY2huZWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTBBKSUwQSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwYXV0b3F1YW50KHBpcGVsaW5lLnRyYW5zZm9ybWVyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> autoquant

<span class="hljs-comment"># Load the pipeline</span>
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)

transformer = autoquant(pipeline.transformer)`,wrap:!1}}),$=new tt({props:{title:"Supported quantization types",local:"supported-quantization-types",headingTag:"h2"}}),H=new tt({props:{title:"Serializing and Deserializing quantized models",local:"serializing-and-deserializing-quantized-models",headingTag:"h2"}}),N=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwVG9yY2hBb0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBUb3JjaEFvQ29uZmlnKCUyMmludDh3byUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGbHV4LjEtRGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBdHJhbnNmb3JtZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfaW50OHdvJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNERmFsc2Up",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, TorchAoConfig

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)
transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=torch.bfloat16,
)
transformer.save_pretrained(<span class="hljs-string">&quot;/path/to/flux_int8wo&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>)`,wrap:!1}}),L=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTJDJTIwQXV0b01vZGVsJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfaW50OHdvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzREZhbHNlKSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRmx1eC4xLURldiUyMiUyQyUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy4wKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, AutoModel

transformer = AutoModel.from_pretrained(<span class="hljs-string">&quot;/path/to/flux_int8wo&quot;</span>, torch_dtype=torch.bfloat16, use_safetensors=<span class="hljs-literal">False</span>)
pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>, transformer=transformer, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>, guidance_scale=<span class="hljs-number">7.0</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),P=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMGluaXRfZW1wdHlfd2VpZ2h0cyUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBGbHV4UGlwZWxpbmUlMkMlMjBBdXRvTW9kZWwlMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBJTIzJTIwU2VyaWFsaXplJTIwdGhlJTIwbW9kZWwlMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGbHV4LjEtRGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEVG9yY2hBb0NvbmZpZyglMjJ1aW50NHdvJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBdHJhbnNmb3JtZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyMiUyQyUyMHNhZmVfc2VyaWFsaXphdGlvbiUzREZhbHNlJTJDJTIwbWF4X3NoYXJkX3NpemUlM0QlMjI1MEdCJTIyKSUwQSUyMyUyMC4uLiUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBtb2RlbCUwQXN0YXRlX2RpY3QlMjAlM0QlMjB0b3JjaC5sb2FkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyRmRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMHdlaWdodHNfb25seSUzREZhbHNlJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3B1JTIyKSUwQXdpdGglMjBpbml0X2VtcHR5X3dlaWdodHMoKSUzQSUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fY29uZmlnKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyRmNvbmZpZy5qc29uJTIyKSUwQXRyYW5zZm9ybWVyLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTJDJTIwc3RyaWN0JTNEVHJ1ZSUyQyUyMGFzc2lnbiUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, AutoModel, TorchAoConfig

<span class="hljs-comment"># Serialize the model</span>
transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=TorchAoConfig(<span class="hljs-string">&quot;uint4wo&quot;</span>),
    torch_dtype=torch.bfloat16,
)
transformer.save_pretrained(<span class="hljs-string">&quot;/path/to/flux_uint4wo&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>, max_shard_size=<span class="hljs-string">&quot;50GB&quot;</span>)
<span class="hljs-comment"># ...</span>

<span class="hljs-comment"># Load the model</span>
state_dict = torch.load(<span class="hljs-string">&quot;/path/to/flux_uint4wo/diffusion_pytorch_model.bin&quot;</span>, weights_only=<span class="hljs-literal">False</span>, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-keyword">with</span> init_empty_weights():
    transformer = AutoModel.from_config(<span class="hljs-string">&quot;/path/to/flux_uint4wo/config.json&quot;</span>)
transformer.load_state_dict(state_dict, strict=<span class="hljs-literal">True</span>, assign=<span class="hljs-literal">True</span>)`,wrap:!1}}),D=new tt({props:{title:"Resources",local:"resources",headingTag:"h2"}}),O=new Te({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){f=s("meta"),at=n(),et=s("p"),nt=n(),p(b.$$.fragment),ot=n(),p(J.$$.fragment),st=n(),T=s("p"),T.innerHTML=Yt,it=n(),g=s("p"),g.textContent=Nt,rt=n(),p(U.$$.fragment),pt=n(),j=s("p"),j.innerHTML=At,mt=n(),Z=s("p"),Z.innerHTML=Lt,dt=n(),p(v.$$.fragment),ct=n(),W=s("p"),W.innerHTML=St,ut=n(),p(_.$$.fragment),ht=n(),p(q.$$.fragment),ft=n(),I=s("p"),I.innerHTML=Pt,yt=n(),p(B.$$.fragment),Mt=n(),G=s("p"),G.innerHTML=Dt,wt=n(),y=s("blockquote"),y.innerHTML=Kt,bt=n(),p(C.$$.fragment),Jt=n(),z=s("p"),z.innerHTML=Ot,Tt=n(),p(X.$$.fragment),gt=n(),p($.$$.fragment),Ut=n(),k=s("p"),k.textContent=te,jt=n(),F=s("p"),F.innerHTML=ee,Zt=n(),x=s("p"),x.textContent=le,vt=n(),R=s("p"),R.textContent=ae,Wt=n(),Q=s("table"),Q.innerHTML=ne,_t=n(),E=s("p"),E.innerHTML=oe,qt=n(),V=s("p"),V.innerHTML=se,It=n(),p(H.$$.fragment),Bt=n(),Y=s("p"),Y.innerHTML=ie,Gt=n(),p(N.$$.fragment),Ct=n(),A=s("p"),A.innerHTML=re,zt=n(),p(L.$$.fragment),Xt=n(),S=s("p"),S.innerHTML=pe,$t=n(),p(P.$$.fragment),kt=n(),M=s("blockquote"),M.innerHTML=me,Ft=n(),p(D.$$.fragment),xt=n(),K=s("ul"),K.innerHTML=de,Rt=n(),p(O.$$.fragment),Qt=n(),lt=s("p"),this.h()},l(t){const e=we("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(l),at=o(t),et=i(t,"P",{}),ce(et).forEach(l),nt=o(t),m(b.$$.fragment,t),ot=o(t),m(J.$$.fragment,t),st=o(t),T=i(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1ucx4sz"&&(T.innerHTML=Yt),it=o(t),g=i(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-fmrzpk"&&(g.textContent=Nt),rt=o(t),m(U.$$.fragment,t),pt=o(t),j=i(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1nzolae"&&(j.innerHTML=At),mt=o(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-tqekst"&&(Z.innerHTML=Lt),dt=o(t),m(v.$$.fragment,t),ct=o(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1i1n0wg"&&(W.innerHTML=St),ut=o(t),m(_.$$.fragment,t),ht=o(t),m(q.$$.fragment,t),ft=o(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1re1mrg"&&(I.innerHTML=Pt),yt=o(t),m(B.$$.fragment,t),Mt=o(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-139k18a"&&(G.innerHTML=Dt),wt=o(t),y=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1xstrmi"&&(y.innerHTML=Kt),bt=o(t),m(C.$$.fragment,t),Jt=o(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1sxhdyw"&&(z.innerHTML=Ot),Tt=o(t),m(X.$$.fragment,t),gt=o(t),m($.$$.fragment,t),Ut=o(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1dy3rwb"&&(k.textContent=te),jt=o(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-17x1tdo"&&(F.innerHTML=ee),Zt=o(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1nbmql6"&&(x.textContent=le),vt=o(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-4xexxq"&&(R.textContent=ae),Wt=o(t),Q=i(t,"TABLE",{"data-svelte-h":!0}),r(Q)!=="svelte-1y0n94l"&&(Q.innerHTML=ne),_t=o(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1r64eqr"&&(E.innerHTML=oe),qt=o(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-6zfuzk"&&(V.innerHTML=se),It=o(t),m(H.$$.fragment,t),Bt=o(t),Y=i(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-x34suv"&&(Y.innerHTML=ie),Gt=o(t),m(N.$$.fragment,t),Ct=o(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1km1qu3"&&(A.innerHTML=re),zt=o(t),m(L.$$.fragment,t),Xt=o(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1m61wn7"&&(S.innerHTML=pe),$t=o(t),m(P.$$.fragment,t),kt=o(t),M=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-9pvxk5"&&(M.innerHTML=me),Ft=o(t),m(D.$$.fragment,t),xt=o(t),K=i(t,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-ok3vq4"&&(K.innerHTML=de),Rt=o(t),m(O.$$.fragment,t),Qt=o(t),lt=i(t,"P",{}),ce(lt).forEach(l),this.h()},h(){Vt(f,"name","hf:doc:metadata"),Vt(f,"content",Ue),Vt(y,"class","tip"),Vt(M,"class","tip")},m(t,e){be(document.head,f),a(t,at,e),a(t,et,e),a(t,nt,e),d(b,t,e),a(t,ot,e),d(J,t,e),a(t,st,e),a(t,T,e),a(t,it,e),a(t,g,e),a(t,rt,e),d(U,t,e),a(t,pt,e),a(t,j,e),a(t,mt,e),a(t,Z,e),a(t,dt,e),d(v,t,e),a(t,ct,e),a(t,W,e),a(t,ut,e),d(_,t,e),a(t,ht,e),d(q,t,e),a(t,ft,e),a(t,I,e),a(t,yt,e),d(B,t,e),a(t,Mt,e),a(t,G,e),a(t,wt,e),a(t,y,e),a(t,bt,e),d(C,t,e),a(t,Jt,e),a(t,z,e),a(t,Tt,e),d(X,t,e),a(t,gt,e),d($,t,e),a(t,Ut,e),a(t,k,e),a(t,jt,e),a(t,F,e),a(t,Zt,e),a(t,x,e),a(t,vt,e),a(t,R,e),a(t,Wt,e),a(t,Q,e),a(t,_t,e),a(t,E,e),a(t,qt,e),a(t,V,e),a(t,It,e),d(H,t,e),a(t,Bt,e),a(t,Y,e),a(t,Gt,e),d(N,t,e),a(t,Ct,e),a(t,A,e),a(t,zt,e),d(L,t,e),a(t,Xt,e),a(t,S,e),a(t,$t,e),d(P,t,e),a(t,kt,e),a(t,M,e),a(t,Ft,e),d(D,t,e),a(t,xt,e),a(t,K,e),a(t,Rt,e),d(O,t,e),a(t,Qt,e),a(t,lt,e),Et=!0},p:he,i(t){Et||(c(b.$$.fragment,t),c(J.$$.fragment,t),c(U.$$.fragment,t),c(v.$$.fragment,t),c(_.$$.fragment,t),c(q.$$.fragment,t),c(B.$$.fragment,t),c(C.$$.fragment,t),c(X.$$.fragment,t),c($.$$.fragment,t),c(H.$$.fragment,t),c(N.$$.fragment,t),c(L.$$.fragment,t),c(P.$$.fragment,t),c(D.$$.fragment,t),c(O.$$.fragment,t),Et=!0)},o(t){u(b.$$.fragment,t),u(J.$$.fragment,t),u(U.$$.fragment,t),u(v.$$.fragment,t),u(_.$$.fragment,t),u(q.$$.fragment,t),u(B.$$.fragment,t),u(C.$$.fragment,t),u(X.$$.fragment,t),u($.$$.fragment,t),u(H.$$.fragment,t),u(N.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),u(D.$$.fragment,t),u(O.$$.fragment,t),Et=!1},d(t){t&&(l(at),l(et),l(nt),l(ot),l(st),l(T),l(it),l(g),l(rt),l(pt),l(j),l(mt),l(Z),l(dt),l(ct),l(W),l(ut),l(ht),l(ft),l(I),l(yt),l(Mt),l(G),l(wt),l(y),l(bt),l(Jt),l(z),l(Tt),l(gt),l(Ut),l(k),l(jt),l(F),l(Zt),l(x),l(vt),l(R),l(Wt),l(Q),l(_t),l(E),l(qt),l(V),l(It),l(Bt),l(Y),l(Gt),l(Ct),l(A),l(zt),l(Xt),l(S),l($t),l(kt),l(M),l(Ft),l(xt),l(K),l(Rt),l(Qt),l(lt)),l(f),h(b,t),h(J,t),h(U,t),h(v,t),h(_,t),h(q,t),h(B,t),h(C,t),h(X,t),h($,t),h(H,t),h(N,t),h(L,t),h(P,t),h(D,t),h(O,t)}}}const Ue='{"title":"torchao","local":"torchao","sections":[{"title":"torch.compile","local":"torchcompile","sections":[],"depth":2},{"title":"autoquant","local":"autoquant","sections":[],"depth":2},{"title":"Supported quantization types","local":"supported-quantization-types","sections":[],"depth":2},{"title":"Serializing and Deserializing quantized models","local":"serializing-and-deserializing-quantized-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function je(Ht){return fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ie extends ye{constructor(f){super(),Me(this,f,je,ge,ue,{})}}export{Ie as component};
