import{s as Ve,n as He,o as Qe}from"../chunks/scheduler.53228c21.js";import{S as Le,i as Ne,e as n,s as a,c as p,h as Ee,a as o,d as l,b as i,f as Ie,g as m,j as f,k as je,l as qe,m as s,n as r,t as u,o as c,p as d}from"../chunks/index.100fac89.js";import{C as ze}from"../chunks/CopyLLMTxtMenu.4f0519ef.js";import{C as L}from"../chunks/CodeBlock.d30a6509.js";import{D as De}from"../chunks/DocNotebookDropdown.1a28089c.js";import{H as q,E as Ae}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.62dbb7c4.js";function Pe($e){let b,z,N,D,y,A,M,P,w,K,J,We=`SDXL Turbo is an adversarial time-distilled <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a> (SDXL) model capable
of running inference in as little as 1 step.`,O,U,Ge="This guide will show you how to use SDXL-Turbo for text-to-image and image-to-image.",ee,Z,ve="Before you begin, make sure you have the following libraries installed:",te,T,le,j,se,$,xe='Model weights may be stored in separate subfolders on the Hub or locally, in which case, you should use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method:',ae,W,ie,G,_e='You can also use the <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> method to load a model checkpoint stored in a single file format (<code>.ckpt</code> or <code>.safetensors</code>) from the Hub or locally. For this loading method, you need to set <code>timestep_spacing=&quot;trailing&quot;</code> (feel free to experiment with the other scheduler config values to get better results):',ne,v,oe,x,pe,_,ke="For text-to-image, pass a text prompt. By default, SDXL Turbo generates a 512x512 image, and that resolution gives the best results. You can try setting the <code>height</code> and <code>width</code> parameters to 768x768 or 1024x1024, but you should expect quality degradations when doing so.",me,k,Be=`Make sure to set <code>guidance_scale</code> to 0.0 to disable, as the model was trained without it. A single inference step is enough to generate high quality images.
Increasing the number of steps to 2, 3 or 4 should improve image quality.`,re,B,ue,g,Xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sdxl-turbo-text2img.png" alt="generated image of a racoon in a robe"/>',ce,X,de,Y,Ye=`For image-to-image generation, make sure that <code>num_inference_steps * strength</code> is larger or equal to 1.
The image-to-image pipeline will run for <code>int(num_inference_steps * strength)</code> steps, e.g. <code>0.5 * 2.0 = 1</code> step in
our example below.`,fe,F,be,h,Fe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sdxl-turbo-img2img.png" alt="Image-to-image generation sample using SDXL Turbo"/>',ge,R,he,S,Re="<li>Compile the UNet if you are using PyTorch version 2.0 or higher. The first inference run will be very slow, but subsequent ones will be much faster.</li>",ye,C,Me,I,Se="<li>When using the default VAE, keep it in <code>float32</code> to avoid costly <code>dtype</code> conversions before and after each generation. You only need to do this one before your first generation:</li>",we,V,Je,H,Ce='As an alternative, you can also use a <a href="https://huggingface.co/madebyollin/sdxl-vae-fp16-fix" rel="nofollow">16-bit VAE</a> created by community member <a href="https://huggingface.co/madebyollin" rel="nofollow"><code>@madebyollin</code></a> that does not need to be upcasted to <code>float32</code>.',Ue,Q,Ze,E,Te;return y=new ze({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),M=new q({props:{title:"Stable Diffusion XL Turbo",local:"stable-diffusion-xl-turbo",headingTag:"h1"}}),w=new De({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl_turbo.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl_turbo.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl_turbo.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl_turbo.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl_turbo.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl_turbo.ipynb"}]}}),T=new L({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRl",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate</span>`,wrap:!1}}),j=new q({props:{title:"Load model checkpoints",local:"load-model-checkpoints",headingTag:"h2"}}),W=new L({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/sdxl-turbo&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),v=new L({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTJGYmxvYiUyRm1haW4lMkZzZF94bF90dXJib18xLjBfZnAxNi5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQXBpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWclMkMlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIydHJhaWxpbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, EulerAncestralDiscreteScheduler
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/sdxl-turbo/blob/main/sd_xl_turbo_1.0_fp16.safetensors&quot;</span>,
    torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = EulerAncestralDiscreteScheduler.from_config(pipeline.scheduler.config, timestep_spacing=<span class="hljs-string">&quot;trailing&quot;</span>)`,wrap:!1}}),x=new q({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),B=new L({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lX3RleHQyaW1hZ2UlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkeGwtdHVyYm8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZV90ZXh0MmltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjaW5lbWF0aWMlMjBzaG90JTIwb2YlMjBhJTIwYmFieSUyMHJhY29vbiUyMHdlYXJpbmclMjBhbiUyMGludHJpY2F0ZSUyMGl0YWxpYW4lMjBwcmllc3QlMjByb2JlLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2image = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/sdxl-turbo&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline_text2image = pipeline_text2image.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cinematic shot of a baby racoon wearing an intricate italian priest robe.&quot;</span>

image = pipeline_text2image(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),X=new q({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),F=new L({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMjMlMjB1c2UlMjBmcm9tX3BpcGUlMjB0byUyMGF2b2lkJTIwY29uc3VtaW5nJTIwYWRkaXRpb25hbCUyMG1lbW9yeSUyMHdoZW4lMjBsb2FkaW5nJTIwYSUyMGNoZWNrcG9pbnQlMEFwaXBlbGluZV9pbWFnZTJpbWFnZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltYWdlKS50byglMjJjdWRhJTIyKSUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNhdC5wbmclMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMHdpemFyZCUyQyUyMGdhbmRhbGYlMkMlMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGRldGFpbGVkJTJDJTIwZmFudGFzeSUyQyUyMGN1dGUlMkMlMjBhZG9yYWJsZSUyQyUyMFBpeGFyJTJDJTIwRGlzbmV5JTJDJTIwOGslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lX2ltYWdlMmltYWdlKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC41JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwLjAlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMikuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># use from_pipe to avoid consuming additional memory when loading a checkpoint</span>
pipeline_image2image = AutoPipelineForImage2Image.from_pipe(pipeline_text2image).to(<span class="hljs-string">&quot;cuda&quot;</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>

image = pipeline_image2image(prompt, image=init_image, strength=<span class="hljs-number">0.5</span>, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">2</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),R=new q({props:{title:"Speed-up SDXL Turbo even more",local:"speed-up-sdxl-turbo-even-more",headingTag:"h2"}}),C=new L({props:{code:"cGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:'pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)',wrap:!1}}),V=new L({props:{code:"cGlwZS51cGNhc3RfdmFlKCk=",highlighted:"pipe.upcast_vae()",wrap:!1}}),Q=new Ae({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/sdxl_turbo.md"}}),{c(){b=n("meta"),z=a(),N=n("p"),D=a(),p(y.$$.fragment),A=a(),p(M.$$.fragment),P=a(),p(w.$$.fragment),K=a(),J=n("p"),J.innerHTML=We,O=a(),U=n("p"),U.textContent=Ge,ee=a(),Z=n("p"),Z.textContent=ve,te=a(),p(T.$$.fragment),le=a(),p(j.$$.fragment),se=a(),$=n("p"),$.innerHTML=xe,ae=a(),p(W.$$.fragment),ie=a(),G=n("p"),G.innerHTML=_e,ne=a(),p(v.$$.fragment),oe=a(),p(x.$$.fragment),pe=a(),_=n("p"),_.innerHTML=ke,me=a(),k=n("p"),k.innerHTML=Be,re=a(),p(B.$$.fragment),ue=a(),g=n("div"),g.innerHTML=Xe,ce=a(),p(X.$$.fragment),de=a(),Y=n("p"),Y.innerHTML=Ye,fe=a(),p(F.$$.fragment),be=a(),h=n("div"),h.innerHTML=Fe,ge=a(),p(R.$$.fragment),he=a(),S=n("ul"),S.innerHTML=Re,ye=a(),p(C.$$.fragment),Me=a(),I=n("ul"),I.innerHTML=Se,we=a(),p(V.$$.fragment),Je=a(),H=n("p"),H.innerHTML=Ce,Ue=a(),p(Q.$$.fragment),Ze=a(),E=n("p"),this.h()},l(e){const t=Ee("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),z=i(e),N=o(e,"P",{}),Ie(N).forEach(l),D=i(e),m(y.$$.fragment,e),A=i(e),m(M.$$.fragment,e),P=i(e),m(w.$$.fragment,e),K=i(e),J=o(e,"P",{"data-svelte-h":!0}),f(J)!=="svelte-1465uj8"&&(J.innerHTML=We),O=i(e),U=o(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-851pbc"&&(U.textContent=Ge),ee=i(e),Z=o(e,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-cwruts"&&(Z.textContent=ve),te=i(e),m(T.$$.fragment,e),le=i(e),m(j.$$.fragment,e),se=i(e),$=o(e,"P",{"data-svelte-h":!0}),f($)!=="svelte-hva56b"&&($.innerHTML=xe),ae=i(e),m(W.$$.fragment,e),ie=i(e),G=o(e,"P",{"data-svelte-h":!0}),f(G)!=="svelte-w1f5rc"&&(G.innerHTML=_e),ne=i(e),m(v.$$.fragment,e),oe=i(e),m(x.$$.fragment,e),pe=i(e),_=o(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-1urqyhr"&&(_.innerHTML=ke),me=i(e),k=o(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-d70s1"&&(k.innerHTML=Be),re=i(e),m(B.$$.fragment,e),ue=i(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),f(g)!=="svelte-1lx4ppg"&&(g.innerHTML=Xe),ce=i(e),m(X.$$.fragment,e),de=i(e),Y=o(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-1rvgn5v"&&(Y.innerHTML=Ye),fe=i(e),m(F.$$.fragment,e),be=i(e),h=o(e,"DIV",{class:!0,"data-svelte-h":!0}),f(h)!=="svelte-ovbosa"&&(h.innerHTML=Fe),ge=i(e),m(R.$$.fragment,e),he=i(e),S=o(e,"UL",{"data-svelte-h":!0}),f(S)!=="svelte-1k6q17l"&&(S.innerHTML=Re),ye=i(e),m(C.$$.fragment,e),Me=i(e),I=o(e,"UL",{"data-svelte-h":!0}),f(I)!=="svelte-jn62ws"&&(I.innerHTML=Se),we=i(e),m(V.$$.fragment,e),Je=i(e),H=o(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-1pt3hz0"&&(H.innerHTML=Ce),Ue=i(e),m(Q.$$.fragment,e),Ze=i(e),E=o(e,"P",{}),Ie(E).forEach(l),this.h()},h(){je(b,"name","hf:doc:metadata"),je(b,"content",Ke),je(g,"class","flex justify-center"),je(h,"class","flex justify-center")},m(e,t){qe(document.head,b),s(e,z,t),s(e,N,t),s(e,D,t),r(y,e,t),s(e,A,t),r(M,e,t),s(e,P,t),r(w,e,t),s(e,K,t),s(e,J,t),s(e,O,t),s(e,U,t),s(e,ee,t),s(e,Z,t),s(e,te,t),r(T,e,t),s(e,le,t),r(j,e,t),s(e,se,t),s(e,$,t),s(e,ae,t),r(W,e,t),s(e,ie,t),s(e,G,t),s(e,ne,t),r(v,e,t),s(e,oe,t),r(x,e,t),s(e,pe,t),s(e,_,t),s(e,me,t),s(e,k,t),s(e,re,t),r(B,e,t),s(e,ue,t),s(e,g,t),s(e,ce,t),r(X,e,t),s(e,de,t),s(e,Y,t),s(e,fe,t),r(F,e,t),s(e,be,t),s(e,h,t),s(e,ge,t),r(R,e,t),s(e,he,t),s(e,S,t),s(e,ye,t),r(C,e,t),s(e,Me,t),s(e,I,t),s(e,we,t),r(V,e,t),s(e,Je,t),s(e,H,t),s(e,Ue,t),r(Q,e,t),s(e,Ze,t),s(e,E,t),Te=!0},p:He,i(e){Te||(u(y.$$.fragment,e),u(M.$$.fragment,e),u(w.$$.fragment,e),u(T.$$.fragment,e),u(j.$$.fragment,e),u(W.$$.fragment,e),u(v.$$.fragment,e),u(x.$$.fragment,e),u(B.$$.fragment,e),u(X.$$.fragment,e),u(F.$$.fragment,e),u(R.$$.fragment,e),u(C.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),Te=!0)},o(e){c(y.$$.fragment,e),c(M.$$.fragment,e),c(w.$$.fragment,e),c(T.$$.fragment,e),c(j.$$.fragment,e),c(W.$$.fragment,e),c(v.$$.fragment,e),c(x.$$.fragment,e),c(B.$$.fragment,e),c(X.$$.fragment,e),c(F.$$.fragment,e),c(R.$$.fragment,e),c(C.$$.fragment,e),c(V.$$.fragment,e),c(Q.$$.fragment,e),Te=!1},d(e){e&&(l(z),l(N),l(D),l(A),l(P),l(K),l(J),l(O),l(U),l(ee),l(Z),l(te),l(le),l(se),l($),l(ae),l(ie),l(G),l(ne),l(oe),l(pe),l(_),l(me),l(k),l(re),l(ue),l(g),l(ce),l(de),l(Y),l(fe),l(be),l(h),l(ge),l(he),l(S),l(ye),l(Me),l(I),l(we),l(Je),l(H),l(Ue),l(Ze),l(E)),l(b),d(y,e),d(M,e),d(w,e),d(T,e),d(j,e),d(W,e),d(v,e),d(x,e),d(B,e),d(X,e),d(F,e),d(R,e),d(C,e),d(V,e),d(Q,e)}}}const Ke='{"title":"Stable Diffusion XL Turbo","local":"stable-diffusion-xl-turbo","sections":[{"title":"Load model checkpoints","local":"load-model-checkpoints","sections":[],"depth":2},{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Speed-up SDXL Turbo even more","local":"speed-up-sdxl-turbo-even-more","sections":[],"depth":2}],"depth":1}';function Oe($e){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nt extends Le{constructor(b){super(),Ne(this,b,Oe,Pe,Ve,{})}}export{nt as component};
