import{s as Fe,n as Ie,o as Be}from"../chunks/scheduler.23542ac5.js";import{S as Ne,i as Se,e as a,s as n,c as m,h as Ye,a as o,d as l,b as i,f as Re,g as d,j as p,k as ye,l as Ee,m as s,n as c,t as r,o as f,p as u}from"../chunks/index.9b1f405b.js";import{C as ze,H as Je,E as De}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.58e5b542.js";import{C as E}from"../chunks/CodeBlock.05225bbb.js";import{D as Le}from"../chunks/DocNotebookDropdown.25b28ba9.js";function He(we){let b,z,S,D,h,L,M,H,Z,q,J,Te='<a href="https://huggingface.co/papers/2311.15127" rel="nofollow">Stable Video Diffusion (SVD)</a>은 입력 이미지에 맞춰 2~4초 분량의 고해상도(576x1024) 비디오를 생성할 수 있는 강력한 image-to-video 생성 모델입니다.',P,y,ve="이 가이드에서는 SVD를 사용하여 이미지에서 짧은 동영상을 생성하는 방법을 설명합니다.",K,w,Ve="시작하기 전에 다음 라이브러리가 설치되어 있는지 확인하세요:",A,T,O,v,Ue='이 모델에는 <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid" rel="nofollow">SVD</a>와 <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid-xt" rel="nofollow">SVD-XT</a> 두 가지 종류가 있습니다. SVD 체크포인트는 14개의 프레임을 생성하도록 학습되었고, SVD-XT 체크포인트는 25개의 프레임을 생성하도록 파인튜닝되었습니다.',ee,V,Ce="이 가이드에서는 SVD-XT 체크포인트를 사용합니다.",te,U,le,g,ke='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;source image of a rocket&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;generated video from source image&quot;</figcaption></div>',se,C,ne,k,_e='UNet을 <a href="../optimization/torch2.0#torchcompile">컴파일</a>하면 메모리 사용량이 살짝 증가하지만, 20~25%의 속도 향상을 얻을 수 있습니다.',ie,_,ae,W,oe,$,We="비디오 생성은 기본적으로 배치 크기가 큰 text-to-image 생성과 유사하게 ‘num_frames’를 한 번에 생성하기 때문에 메모리 사용량이 매우 높습니다. 메모리 사용량을 줄이기 위해 추론 속도와 메모리 사용량을 절충하는 여러 가지 옵션이 있습니다:",pe,j,$e="<li>모델 오프로링 활성화: 파이프라인의 각 구성 요소가 더 이상 필요하지 않을 때 CPU로 오프로드됩니다.</li> <li>Feed-forward chunking 활성화: feed-forward 레이어가 배치 크기가 큰 단일 feed-forward를 실행하는 대신 루프로 반복해서 실행됩니다.</li> <li><code>decode_chunk_size</code> 감소: VAE가 프레임들을 한꺼번에 디코딩하는 대신 chunk 단위로 디코딩합니다. <code>decode_chunk_size=1</code>을 설정하면 한 번에 한 프레임씩 디코딩하고 최소한의 메모리만 사용하지만(GPU 메모리에 따라 이 값을 조정하는 것이 좋습니다), 동영상에 약간의 깜박임이 발생할 수 있습니다.</li>",me,X,de,G,je="이러한 모든 방법들을 사용하면 메모리 사용량이 8GAM VRAM보다 적을 것입니다.",ce,x,re,Q,Xe="Stable Diffusion Video는 또한 이미지 conditoning 외에도 micro-conditioning을 허용하므로 생성된 비디오를 더 잘 제어할 수 있습니다:",fe,R,Ge="<li><code>fps</code>: 생성된 비디오의 초당 프레임 수입니다.</li> <li><code>motion_bucket_id</code>: 생성된 동영상에 사용할 모션 버킷 아이디입니다. 생성된 동영상의 모션을 제어하는 데 사용할 수 있습니다. 모션 버킷 아이디를 늘리면 생성되는 동영상의 모션이 증가합니다.</li> <li><code>noise_aug_strength</code>: Conditioning 이미지에 추가되는 노이즈의 양입니다. 값이 클수록 비디오가 conditioning 이미지와 덜 유사해집니다. 이 값을 높이면 생성된 비디오의 움직임도 증가합니다.</li>",ue,F,xe="예를 들어, 모션이 더 많은 동영상을 생성하려면 <code>motion_bucket_id</code> 및 <code>noise_aug_strength</code> micro-conditioning 파라미터를 사용합니다:",be,I,ge,B,Qe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket_with_conditions.gif"/>',he,N,Me,Y,Ze;return h=new ze({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),M=new Je({props:{title:"Stable Video Diffusion",local:"stable-video-diffusion",headingTag:"h1"}}),Z=new Le({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/svd.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/svd.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/svd.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/svd.ipynb"}]}}),T=new E({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMC1VJTIwZGlmZnVzZXJzJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZQ==",highlighted:"!pip install -q -U diffusers transformers accelerate",wrap:!1}}),U=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMENvbmRpdGlvbmluZyUyMCVFQyU5RCVCNCVFQiVBRiVCOCVFQyVBNyU4MCUyMCVFQiVCNiU4OCVFQiU5RiVBQyVFQyU5OCVBNCVFQSVCOCVCMCUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5mcmFtZXMlNUIwJTVEJTBBJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMmdlbmVyYXRlZC5tcDQlMjIlMkMlMjBmcHMlM0Q3KQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Conditioning 이미지 불러오기</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),C=new Je({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),_=new E({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTJCJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.to(&quot;cuda&quot;)</span>
<span class="hljs-addition">+ pipe.unet = torch.compile(pipe.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>`,wrap:!1}}),W=new Je({props:{title:"메모리 사용량 줄이기",local:"메모리-사용량-줄이기",headingTag:"h2"}}),X=new E({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEEtJTIwZnJhbWVzJTIwJTNEJTIwcGlwZShpbWFnZSUyQyUyMGRlY29kZV9jaHVua19zaXplJTNEOCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuZnJhbWVzJTVCMCU1RCUwQSUyQiUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoKSUwQSUyQiUyMGZyYW1lcyUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBkZWNvZGVfY2h1bmtfc2l6ZSUzRDIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1fZnJhbWVzJTNEMjUpLmZyYW1lcyU1QjAlNUQ=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-deletion">- frames = pipe(image, decode_chunk_size=8, generator=generator).frames[0]</span>
<span class="hljs-addition">+ pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.unet.enable_forward_chunking()</span>
<span class="hljs-addition">+ frames = pipe(image, decode_chunk_size=2, generator=generator, num_frames=25).frames[0]</span>`,wrap:!1}}),x=new Je({props:{title:"Micro-conditioning",local:"micro-conditioning",headingTag:"h2"}}),I=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMENvbmRpdGlvbmluZyUyMCVFQyU5RCVCNCVFQiVBRiVCOCVFQyVBNyU4MCUyMCVFQiVCNiU4OCVFQiU5RiVBQyVFQyU5OCVBNCVFQSVCOCVCMCUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbW90aW9uX2J1Y2tldF9pZCUzRDE4MCUyQyUyMG5vaXNlX2F1Z19zdHJlbmd0aCUzRDAuMSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyhmcmFtZXMlMkMlMjAlMjJnZW5lcmF0ZWQubXA0JTIyJTJDJTIwZnBzJTNENyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Conditioning 이미지 불러오기</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator, motion_bucket_id=<span class="hljs-number">180</span>, noise_aug_strength=<span class="hljs-number">0.1</span>).frames[<span class="hljs-number">0</span>]
export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),N=new De({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ko/using-diffusers/svd.md"}}),{c(){b=a("meta"),z=n(),S=a("p"),D=n(),m(h.$$.fragment),L=n(),m(M.$$.fragment),H=n(),m(Z.$$.fragment),q=n(),J=a("p"),J.innerHTML=Te,P=n(),y=a("p"),y.textContent=ve,K=n(),w=a("p"),w.textContent=Ve,A=n(),m(T.$$.fragment),O=n(),v=a("p"),v.innerHTML=Ue,ee=n(),V=a("p"),V.textContent=Ce,te=n(),m(U.$$.fragment),le=n(),g=a("div"),g.innerHTML=ke,se=n(),m(C.$$.fragment),ne=n(),k=a("p"),k.innerHTML=_e,ie=n(),m(_.$$.fragment),ae=n(),m(W.$$.fragment),oe=n(),$=a("p"),$.textContent=We,pe=n(),j=a("ul"),j.innerHTML=$e,me=n(),m(X.$$.fragment),de=n(),G=a("p"),G.textContent=je,ce=n(),m(x.$$.fragment),re=n(),Q=a("p"),Q.textContent=Xe,fe=n(),R=a("ul"),R.innerHTML=Ge,ue=n(),F=a("p"),F.innerHTML=xe,be=n(),m(I.$$.fragment),ge=n(),B=a("p"),B.innerHTML=Qe,he=n(),m(N.$$.fragment),Me=n(),Y=a("p"),this.h()},l(e){const t=Ye("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),z=i(e),S=o(e,"P",{}),Re(S).forEach(l),D=i(e),d(h.$$.fragment,e),L=i(e),d(M.$$.fragment,e),H=i(e),d(Z.$$.fragment,e),q=i(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1echk5x"&&(J.innerHTML=Te),P=i(e),y=o(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-qrtvxi"&&(y.textContent=ve),K=i(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1dydg7a"&&(w.textContent=Ve),A=i(e),d(T.$$.fragment,e),O=i(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-15oqpnn"&&(v.innerHTML=Ue),ee=i(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1stbntq"&&(V.textContent=Ce),te=i(e),d(U.$$.fragment,e),le=i(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(g)!=="svelte-25rdw"&&(g.innerHTML=ke),se=i(e),d(C.$$.fragment,e),ne=i(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1d7iwu3"&&(k.innerHTML=_e),ie=i(e),d(_.$$.fragment,e),ae=i(e),d(W.$$.fragment,e),oe=i(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-ic28rl"&&($.textContent=We),pe=i(e),j=o(e,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-lce2t7"&&(j.innerHTML=$e),me=i(e),d(X.$$.fragment,e),de=i(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1v9bzrn"&&(G.textContent=je),ce=i(e),d(x.$$.fragment,e),re=i(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-12yo38n"&&(Q.textContent=Xe),fe=i(e),R=o(e,"UL",{"data-svelte-h":!0}),p(R)!=="svelte-18zyz4a"&&(R.innerHTML=Ge),ue=i(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1sx9h8v"&&(F.innerHTML=xe),be=i(e),d(I.$$.fragment,e),ge=i(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-19qaph4"&&(B.innerHTML=Qe),he=i(e),d(N.$$.fragment,e),Me=i(e),Y=o(e,"P",{}),Re(Y).forEach(l),this.h()},h(){ye(b,"name","hf:doc:metadata"),ye(b,"content",qe),ye(g,"class","flex gap-4")},m(e,t){Ee(document.head,b),s(e,z,t),s(e,S,t),s(e,D,t),c(h,e,t),s(e,L,t),c(M,e,t),s(e,H,t),c(Z,e,t),s(e,q,t),s(e,J,t),s(e,P,t),s(e,y,t),s(e,K,t),s(e,w,t),s(e,A,t),c(T,e,t),s(e,O,t),s(e,v,t),s(e,ee,t),s(e,V,t),s(e,te,t),c(U,e,t),s(e,le,t),s(e,g,t),s(e,se,t),c(C,e,t),s(e,ne,t),s(e,k,t),s(e,ie,t),c(_,e,t),s(e,ae,t),c(W,e,t),s(e,oe,t),s(e,$,t),s(e,pe,t),s(e,j,t),s(e,me,t),c(X,e,t),s(e,de,t),s(e,G,t),s(e,ce,t),c(x,e,t),s(e,re,t),s(e,Q,t),s(e,fe,t),s(e,R,t),s(e,ue,t),s(e,F,t),s(e,be,t),c(I,e,t),s(e,ge,t),s(e,B,t),s(e,he,t),c(N,e,t),s(e,Me,t),s(e,Y,t),Ze=!0},p:Ie,i(e){Ze||(r(h.$$.fragment,e),r(M.$$.fragment,e),r(Z.$$.fragment,e),r(T.$$.fragment,e),r(U.$$.fragment,e),r(C.$$.fragment,e),r(_.$$.fragment,e),r(W.$$.fragment,e),r(X.$$.fragment,e),r(x.$$.fragment,e),r(I.$$.fragment,e),r(N.$$.fragment,e),Ze=!0)},o(e){f(h.$$.fragment,e),f(M.$$.fragment,e),f(Z.$$.fragment,e),f(T.$$.fragment,e),f(U.$$.fragment,e),f(C.$$.fragment,e),f(_.$$.fragment,e),f(W.$$.fragment,e),f(X.$$.fragment,e),f(x.$$.fragment,e),f(I.$$.fragment,e),f(N.$$.fragment,e),Ze=!1},d(e){e&&(l(z),l(S),l(D),l(L),l(H),l(q),l(J),l(P),l(y),l(K),l(w),l(A),l(O),l(v),l(ee),l(V),l(te),l(le),l(g),l(se),l(ne),l(k),l(ie),l(ae),l(oe),l($),l(pe),l(j),l(me),l(de),l(G),l(ce),l(re),l(Q),l(fe),l(R),l(ue),l(F),l(be),l(ge),l(B),l(he),l(Me),l(Y)),l(b),u(h,e),u(M,e),u(Z,e),u(T,e),u(U,e),u(C,e),u(_,e),u(W,e),u(X,e),u(x,e),u(I,e),u(N,e)}}}const qe='{"title":"Stable Video Diffusion","local":"stable-video-diffusion","sections":[{"title":"torch.compile","local":"torchcompile","sections":[],"depth":2},{"title":"메모리 사용량 줄이기","local":"메모리-사용량-줄이기","sections":[],"depth":2},{"title":"Micro-conditioning","local":"micro-conditioning","sections":[],"depth":2}],"depth":1}';function Pe(we){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lt extends Ne{constructor(b){super(),Se(this,b,Pe,He,Fe,{})}}export{lt as component};
