import{s as wt,o as Jt,n as le}from"../chunks/scheduler.824d5328.js";import{S as Tt,i as kt,e as f,s as r,c as y,h as bt,a as g,d as s,b as o,f as Z,g as M,j as T,k as E,l as i,m as p,n as d,t as u,o as h,p as U}from"../chunks/index.7835f2bc.js";import{D as L,E as ee}from"../chunks/ExampleCodeBlock.e60c65cd.js";import{C as te}from"../chunks/CodeBlock.31787362.js";import{H as j,E as jt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.c5b3ce0d.js";function $t(k){let n,J="Example:",m,a,c;return a=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMHVzZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1YiUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwTW9kZSUyQyUyMGtlcm5lbGl6ZSUwQSUwQSU0MHVzZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1YiglMjJNeUN1c3RvbUxheWVyJTIyKSUwQWNsYXNzJTIwTXlDdXN0b21MYXllcihubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGhpZGRlbl9zaXplKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBoaWRkZW5fc2l6ZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHglM0ElMjB0b3JjaC5UZW5zb3IpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwb3JpZ2luYWwlMjBpbXBsZW1lbnRhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEFtb2RlbCUyMCUzRCUyME15Q3VzdG9tTGF5ZXIoNzY4KSUwQSUwQSUyMyUyMFRoZSUyMGxheWVyJTIwY2FuJTIwbm93JTIwYmUlMjBrZXJuZWxpemVkJTNBJTBBJTIzJTIwbW9kZWwlMjAlM0QlMjBrZXJuZWxpemUobW9kZWwlMkMlMjBtb2RlJTNETW9kZS5UUkFJTklORyUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Mode, kernelize

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;MyCustomLayer&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomLayer</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.hidden_size = hidden_size

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>):
        <span class="hljs-comment"># original implementation</span>
        <span class="hljs-keyword">return</span> x

model = MyCustomLayer(<span class="hljs-number">768</span>)

<span class="hljs-comment"># The layer can now be kernelized:</span>
<span class="hljs-comment"># model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE, device=&quot;cuda&quot;)</span>`,wrap:!1}}),{c(){n=f("p"),n.textContent=J,m=r(),y(a.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(a.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(a,l,w),c=!0},p:le,i(l){c||(u(a.$$.fragment,l),c=!0)},o(l){h(a.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),U(a,l)}}}function Ct(k){let n,J="Example:",m,a,c;return a=new te({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjByZXBsYWNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViJTBBaW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBJTBBcmVwbGFjZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1Yihubi5MYXllck5vcm0lMkMlMjAlMjJMYXllck5vcm0lMjIp",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> replace_kernel_forward_from_hub
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

replace_kernel_forward_from_hub(nn.LayerNorm, <span class="hljs-string">&quot;LayerNorm&quot;</span>)`,wrap:!1}}),{c(){n=f("p"),n.textContent=J,m=r(),y(a.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(a.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(a,l,w),c=!0},p:le,i(l){c||(u(a.$$.fragment,l),c=!0)},o(l){h(a.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),U(a,l)}}}function _t(k){let n,J="Example:",m,a,c;return a=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwdG9yY2gubm4lMjBpbXBvcnQlMjBmdW5jdGlvbmFsJTIwYXMlMjBGJTBBJTBBZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjB1c2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIlMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMHVzZV9rZXJuZWxfbWFwcGluZyUyQyUyMExheWVyUmVwb3NpdG9yeSUyQyUyMERldmljZSUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwTW9kZSUyQyUyMGtlcm5lbGl6ZSUwQSUwQSUyMyUyMERlZmluZSUyMGElMjBtYXBwaW5nJTBBbWFwcGluZyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMlNpbHVBbmRNdWwlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjdWRhJTIyJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlN0QlMEElN0QlMEElMEElNDB1c2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIoJTIyU2lsdUFuZE11bCUyMiklMEFjbGFzcyUyMFNpbHVBbmRNdWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHglM0ElMjB0b3JjaC5UZW5zb3IpJTIwLSUzRSUyMHRvcmNoLlRlbnNvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGQlMjAlM0QlMjB4LnNoYXBlJTVCLTElNUQlMjAlMkYlMkYlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zaWx1KHglNUIuLi4lMkMlMjAlM0FkJTVEKSUyMColMjB4JTVCLi4uJTJDJTIwZCUzQSU1RCUwQSUwQW1vZGVsJTIwJTNEJTIwU2lsdUFuZE11bCgpJTBBJTBBJTIzJTIwVXNlJTIwdGhlJTIwbWFwcGluZyUyMGZvciUyMHRoZSUyMGR1cmF0aW9uJTIwb2YlMjB0aGUlMjBjb250ZXh0LiUwQXdpdGglMjB1c2Vfa2VybmVsX21hcHBpbmcobWFwcGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBrZXJuZWxpemUlMjB1c2VzJTIwdGhlJTIwdGVtcG9yYXJ5JTIwbWFwcGluZyUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwa2VybmVsaXplKG1vZGVsJTJDJTIwbW9kZSUzRE1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyME91dHNpZGUlMjB0aGUlMjBjb250ZXh0JTJDJTIwb3JpZ2luYWwlMjBtYXBwaW5ncyUyMGFyZSUyMHJlc3RvcmVk",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> torch.nn <span class="hljs-keyword">import</span> functional <span class="hljs-keyword">as</span> F

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_mapping, LayerRepository, Device
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Mode, kernelize

<span class="hljs-comment"># Define a mapping</span>
mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>) -&gt; torch.Tensor:
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(x[..., :d]) * x[..., d:]

model = SiluAndMul()

<span class="hljs-comment"># Use the mapping for the duration of the context.</span>
<span class="hljs-keyword">with</span> use_kernel_mapping(mapping):
    <span class="hljs-comment"># kernelize uses the temporary mapping</span>
    model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE, device=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Outside the context, original mappings are restored</span>`,wrap:!1}}),{c(){n=f("p"),n.textContent=J,m=r(),y(a.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(a.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(a,l,w),c=!0},p:le,i(l){c||(u(a.$$.fragment,l),c=!0)},o(l){h(a.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),U(a,l)}}}function It(k){let n,J="Example:",m,a,c;return a=new te({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LayerRepository, register_kernel_mapping, Mode

<span class="hljs-comment"># Simple mapping for a single kernel per device</span>
kernel_layer_mapping = {
    <span class="hljs-string">&quot;LlamaRMSNorm&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;RmsNorm&quot;</span>,
            revision=<span class="hljs-string">&quot;layers&quot;</span>,
        ),
    },
}
register_kernel_mapping(kernel_layer_mapping)

<span class="hljs-comment"># Advanced mapping with mode-specific kernels</span>
advanced_mapping = {
    <span class="hljs-string">&quot;MultiHeadAttention&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;username/training-kernels&quot;</span>,
                layer_name=<span class="hljs-string">&quot;TrainingAttention&quot;</span>
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;username/inference-kernels&quot;</span>,
                layer_name=<span class="hljs-string">&quot;FastAttention&quot;</span>
            ),
        }
    }
}
register_kernel_mapping(advanced_mapping)`,wrap:!1}}),{c(){n=f("p"),n.textContent=J,m=r(),y(a.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(a.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(a,l,w),c=!0},p:le,i(l){c||(u(a.$$.fragment,l),c=!0)},o(l){h(a.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),U(a,l)}}}function vt(k){let n,J="Example:",m,a,c;return a=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMGtlcm5lbGl6ZSUyQyUyME1vZGUlMkMlMjByZWdpc3Rlcl9rZXJuZWxfbWFwcGluZyUyQyUyMExheWVyUmVwb3NpdG9yeSUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViJTBBJTBBJTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4JTNBJTIwdG9yY2guVGVuc29yKSUyMC0lM0UlMjB0b3JjaC5UZW5zb3IlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkJTIwJTNEJTIweC5zaGFwZSU1Qi0xJTVEJTIwJTJGJTJGJTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEYuc2lsdSh4JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIweCU1Qi4uLiUyQyUyMGQlM0ElNUQlMEElMEFtYXBwaW5nJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyU2lsdUFuZE11bCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmN1ZGElMjIlM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RCUwQXJlZ2lzdGVyX2tlcm5lbF9tYXBwaW5nKG1hcHBpbmcpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYW5kJTIwa2VybmVsaXplJTIwYSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBubi5TZXF1ZW50aWFsKCUwQSUyMCUyMCUyMCUyMG5uLkxpbmVhcigxMDI0JTJDJTIwMjA0OCUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIpJTJDJTBBJTIwJTIwJTIwJTIwU2lsdUFuZE11bCgpJTJDJTBBKSUwQSUwQSUyMyUyMEtlcm5lbGl6ZSUyMGZvciUyMGluZmVyZW5jZSUwQWtlcm5lbGl6ZWRfbW9kZWwlMjAlM0QlMjBrZXJuZWxpemUobW9kZWwlMkMlMjBtb2RlJTNETW9kZS5UUkFJTklORyUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> kernelize, Mode, register_kernel_mapping, LayerRepository
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>) -&gt; torch.Tensor:
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(x[..., :d]) * x[..., d:]

mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}
register_kernel_mapping(mapping)

<span class="hljs-comment"># Create and kernelize a model</span>
model = nn.Sequential(
    nn.Linear(<span class="hljs-number">1024</span>, <span class="hljs-number">2048</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>),
    SiluAndMul(),
)

<span class="hljs-comment"># Kernelize for inference</span>
kernelized_model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),{c(){n=f("p"),n.textContent=J,m=r(),y(a.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(a.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(a,l,w),c=!0},p:le,i(l){c||(u(a.$$.fragment,l),c=!0)},o(l){h(a.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),U(a,l)}}}function xt(k){let n,J="Example:",m,a,c;return a=new te({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBEZXZpY2UlMkMlMjBDVURBUHJvcGVydGllcyUwQSUwQSUyMyUyMEJhc2ljJTIwQ1VEQSUyMGRldmljZSUwQWN1ZGFfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyMENVREElMjBkZXZpY2UlMjB3aXRoJTIwc3BlY2lmaWMlMjBjYXBhYmlsaXR5JTIwcmVxdWlyZW1lbnRzJTBBY3VkYV9kZXZpY2Vfd2l0aF9wcm9wcyUyMCUzRCUyMERldmljZSglMEElMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyhtaW5fY2FwYWJpbGl0eSUzRDc1JTJDJTIwbWF4X2NhcGFiaWxpdHklM0Q5MCklMEEpJTBBJTBBJTIzJTIwTVBTJTIwZGV2aWNlJTIwZm9yJTIwQXBwbGUlMjBTaWxpY29uJTBBbXBzX2RldmljZSUyMCUzRCUyMERldmljZSh0eXBlJTNEJTIybXBzJTIyKSUwQSUwQSUyMyUyMFhQVSUyMGRldmljZSUyMChlLmcuJTJDJTIwSW50ZWwoUiklMjBEYXRhJTIwQ2VudGVyJTIwR1BVJTIwTWF4JTIwMTU1MCklMEF4cHVfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJ4cHUlMjIpJTBBJTBBJTIzJTIwTlBVJTIwZGV2aWNlJTIwKEh1YXdlaSUyMEFzY2VuZCklMEFucHVfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJucHUlMjIp",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Device, CUDAProperties

<span class="hljs-comment"># Basic CUDA device</span>
cuda_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># CUDA device with specific capability requirements</span>
cuda_device_with_props = Device(
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
    properties=CUDAProperties(min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">90</span>)
)

<span class="hljs-comment"># MPS device for Apple Silicon</span>
mps_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;mps&quot;</span>)

<span class="hljs-comment"># XPU device (e.g., Intel(R) Data Center GPU Max 1550)</span>
xpu_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;xpu&quot;</span>)

<span class="hljs-comment"># NPU device (Huawei Ascend)</span>
npu_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;npu&quot;</span>)`,wrap:!1}}),{c(){n=f("p"),n.textContent=J,m=r(),y(a.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(a.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(a,l,w),c=!0},p:le,i(l){c||(u(a.$$.fragment,l),c=!0)},o(l){h(a.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),U(a,l)}}}function Bt(k){let n,J="Example:",m,a,c;return a=new te({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBMYXllclJlcG9zaXRvcnklMEElMEElMjMlMjBSZWZlcmVuY2UlMjBhJTIwc3BlY2lmaWMlMjBsYXllciUyMGJ5JTIwcmV2aXNpb24lMEFsYXllcl9yZXBvJTIwJTNEJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSklMEElMEElMjMlMjBSZWZlcmVuY2UlMjBhJTIwbGF5ZXIlMjBieSUyMHZlcnNpb24lMjBjb25zdHJhaW50JTBBbGF5ZXJfcmVwb192ZXJzaW9uZWQlMjAlM0QlMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdmVyc2lvbiUzRCUyMiUzRSUzRDAuMC4zJTJDJTNDMC4xJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LayerRepository

<span class="hljs-comment"># Reference a specific layer by revision</span>
layer_repo = LayerRepository(
    repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
)

<span class="hljs-comment"># Reference a layer by version constraint</span>
layer_repo_versioned = LayerRepository(
    repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
    version=<span class="hljs-string">&quot;&gt;=0.0.3,&lt;0.1&quot;</span>
)`,wrap:!1}}),{c(){n=f("p"),n.textContent=J,m=r(),y(a.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(a.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(a,l,w),c=!0},p:le,i(l){c||(u(a.$$.fragment,l),c=!0)},o(l){h(a.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),U(a,l)}}}function Zt(k){let n,J="Example:",m,a,c;return a=new te({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBMb2NhbExheWVyUmVwb3NpdG9yeSUwQSUwQSUyMyUyMFJlZmVyZW5jZSUyMGElMjBzcGVjaWZpYyUyMGxheWVyJTIwYnklMjByZXZpc2lvbiUwQWxheWVyX3JlcG8lMjAlM0QlMjBMb2NhbExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjByZXBvX3BhdGglM0RQYXRoKCUyMiUyRmhvbWUlMkZkYW5pZWwlMkZrZXJuZWxzJTJGYWN0aXZhdGlvbiUyMiklMkMlMEElMjAlMjAlMjAlMjBwYWNrYWdlX25hbWUlM0QlMjJhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LocalLayerRepository

<span class="hljs-comment"># Reference a specific layer by revision</span>
layer_repo = LocalLayerRepository(
    repo_path=Path(<span class="hljs-string">&quot;/home/daniel/kernels/activation&quot;</span>),
    package_name=<span class="hljs-string">&quot;activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
)`,wrap:!1}}),{c(){n=f("p"),n.textContent=J,m=r(),y(a.$$.fragment)},l(l){n=g(l,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=J),m=o(l),M(a.$$.fragment,l)},m(l,w){p(l,n,w),p(l,m,w),d(a,l,w),c=!0},p:le,i(l){c||(u(a.$$.fragment,l),c=!0)},o(l){h(a.$$.fragment,l),c=!1},d(l){l&&(s(n),s(m)),U(a,l)}}}function Et(k){let n,J,m,a,c,l,w,Oe,ne,el,$,se,jl,Ie,et="Decorator factory that makes a layer extensible using the specified layer name.",$l,ve,lt=`This is a decorator factory that returns a decorator which prepares a layer class to use kernels from the
Hugging Face Hub.`,Cl,z,ll,ae,tl,C,re,_l,xe,tt="Function that prepares a layer class to use kernels from the Hugging Face Hub.",Il,Be,nt=`It is recommended to use <a href="/docs/kernels/main/en/api/layers#kernels.use_kernel_forward_from_hub">use_kernel_forward_from_hub()</a> decorator instead.
This function should only be used as a last resort to extend third-party layers,
it is inherently fragile since the member variables and <code>forward</code> signature
of usch a layer can change.`,vl,F,nl,oe,sl,pe,al,_,ie,xl,Ze,st="Context manager that sets a kernel mapping for the duration of the context.",Bl,Ee,at=`This function allows temporary kernel mappings to be applied within a specific context, enabling different
kernel configurations for different parts of your code.`,Zl,D,rl,ce,ol,I,me,El,Re,rt="Register a global mapping between layer names and their corresponding kernel implementations.",Rl,We,ot=`This function allows you to register a mapping between a layer name and the corresponding kernel(s) to use,
depending on the device and mode. This should be used in conjunction with <a href="/docs/kernels/main/en/api/layers#kernels.kernelize">kernelize()</a>.`,Wl,Y,pl,ye,il,Me,cl,v,de,Gl,Ge,pt="Replace layer forward methods with optimized kernel implementations.",Xl,Xe,it=`This function iterates over all modules in the model and replaces the <code>forward</code> method of extensible layers
for which kernels are registered using <a href="/docs/kernels/main/en/api/layers#kernels.register_kernel_mapping">register_kernel_mapping()</a> or <a href="/docs/kernels/main/en/api/layers#kernels.use_kernel_mapping">use_kernel_mapping()</a>.`,Sl,H,ml,ue,yl,he,Ml,b,Ue,Al,Se,ct="Represents a compute device with optional properties.",Vl,Ae,mt=`This class encapsulates device information including device type and optional device-specific properties
like CUDA capabilities.`,Ql,q,Nl,P,fe,Ll,Ve,yt="Create an appropriate repository set for this device type.",dl,ge,ul,x,we,zl,Qe,Mt="Kernelize mode",Fl,Ne,dt=`The <code>Mode</code> flag is used by <a href="/docs/kernels/main/en/api/layers#kernels.kernelize">kernelize()</a> to select kernels for the given mode. Mappings can be registered for
specific modes.`,Dl,Le,ut=`Note:
Different modes can be combined. For instance, <code>INFERENCE | TORCH_COMPILE</code> should be used for layers that
are used for inference <em>with</em> <code>torch.compile</code>.`,hl,Je,Ul,R,Te,Yl,ze,ht="Repository and name of a layer for kernel mapping.",Hl,K,fl,ke,gl,W,be,ql,Fe,Ut="Repository from a local directory for kernel mapping.",Pl,O,wl,je,Jl,G,$e,Kl,De,ft="Repository and name of a layer.",Ol,Ye,gt=`In contrast to <code>LayerRepository</code>, this class uses repositories that
are locked inside a project.`,Tl,Ce,kl,Ke,bl;return c=new j({props:{title:"Layers API Reference",local:"layers-api-reference",headingTag:"h1"}}),w=new j({props:{title:"Making layers kernel-aware",local:"making-layers-kernel-aware",headingTag:"h2"}}),ne=new j({props:{title:"use_kernel_forward_from_hub",local:"kernels.use_kernel_forward_from_hub",headingTag:"h3"}}),se=new L({props:{name:"kernels.use_kernel_forward_from_hub",anchor:"kernels.use_kernel_forward_from_hub",parameters:[{name:"layer_name",val:": str"}],parametersDescription:[{anchor:"kernels.use_kernel_forward_from_hub.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer to use for kernel lookup in registered mappings.`,name:"layer_name"}],source:"https://github.com/huggingface/kernels/blob/main/src/kernels/layer.py#L988",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A decorator function that can be applied to layer classes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Callable</code></p>
`}}),z=new ee({props:{anchor:"kernels.use_kernel_forward_from_hub.example",$$slots:{default:[$t]},$$scope:{ctx:k}}}),ae=new j({props:{title:"replace_kernel_forward_from_hub",local:"kernels.replace_kernel_forward_from_hub",headingTag:"h3"}}),re=new L({props:{name:"kernels.replace_kernel_forward_from_hub",anchor:"kernels.replace_kernel_forward_from_hub",parameters:[{name:"layer_name",val:": str"}],source:"https://github.com/huggingface/kernels/blob/main/src/kernels/layer.py#L753"}}),F=new ee({props:{anchor:"kernels.replace_kernel_forward_from_hub.example",$$slots:{default:[Ct]},$$scope:{ctx:k}}}),oe=new j({props:{title:"Registering kernel mappings",local:"registering-kernel-mappings",headingTag:"h2"}}),pe=new j({props:{title:"use_kernel_mapping",local:"kernels.use_kernel_mapping",headingTag:"h3"}}),ie=new L({props:{name:"kernels.use_kernel_mapping",anchor:"kernels.use_kernel_mapping",parameters:[{name:"mapping",val:": Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]"},{name:"inherit_mapping",val:": bool = True"}],parametersDescription:[{anchor:"kernels.use_kernel_mapping.mapping",description:`<strong>mapping</strong> (<code>Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]</code>) &#x2014;
The kernel mapping to apply. Maps layer names to device-specific kernel configurations.`,name:"mapping"},{anchor:"kernels.use_kernel_mapping.inherit_mapping",description:`<strong>inherit_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When <code>True</code>, the current mapping will be extended by <code>mapping</code> inside the context. When <code>False</code>,
only <code>mapping</code> is used inside the context.`,name:"inherit_mapping"}],source:"https://github.com/huggingface/kernels/blob/main/src/kernels/layer.py#L596",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Context manager that handles the temporary kernel mapping.</p>
`}}),D=new ee({props:{anchor:"kernels.use_kernel_mapping.example",$$slots:{default:[_t]},$$scope:{ctx:k}}}),ce=new j({props:{title:"register_kernel_mapping",local:"kernels.register_kernel_mapping",headingTag:"h3"}}),me=new L({props:{name:"kernels.register_kernel_mapping",anchor:"kernels.register_kernel_mapping",parameters:[{name:"mapping",val:": Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]"},{name:"inherit_mapping",val:": bool = True"}],parametersDescription:[{anchor:"kernels.register_kernel_mapping.mapping",description:`<strong>mapping</strong> (<code>Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]</code>) &#x2014;
The kernel mapping to register globally. Maps layer names to device-specific kernels.
The mapping can specify different kernels for different modes (training, inference, etc.).`,name:"mapping"},{anchor:"kernels.register_kernel_mapping.inherit_mapping",description:`<strong>inherit_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When <code>True</code>, the current mapping will be extended by <code>mapping</code>. When <code>False</code>, the existing mappings
are erased before adding <code>mapping</code>.`,name:"inherit_mapping"}],source:"https://github.com/huggingface/kernels/blob/main/src/kernels/layer.py#L675"}}),Y=new ee({props:{anchor:"kernels.register_kernel_mapping.example",$$slots:{default:[It]},$$scope:{ctx:k}}}),ye=new j({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),Me=new j({props:{title:"kernelize",local:"kernels.kernelize",headingTag:"h3"}}),de=new L({props:{name:"kernels.kernelize",anchor:"kernels.kernelize",parameters:[{name:"model",val:": 'nn.Module'"},{name:"mode",val:": Mode"},{name:"device",val:": Optional[Union[str, 'torch.device']] = None"},{name:"use_fallback",val:": bool = True"}],parametersDescription:[{anchor:"kernels.kernelize.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The PyTorch model to kernelize.`,name:"model"},{anchor:"kernels.kernelize.mode",description:`<strong>mode</strong> (<a href="/docs/kernels/main/en/api/layers#kernels.Mode">Mode</a>) &#x2014; The mode that the kernel is going to be used in. For example,
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> kernelizes the model for training with
<code>torch.compile</code>.`,name:"mode"},{anchor:"kernels.kernelize.device",description:`<strong>device</strong> (<code>Union[str, torch.device]</code>, <em>optional</em>) &#x2014;
The device type to load kernels for. Supported device types are: &#x201C;cuda&#x201D;, &#x201C;mps&#x201D;, &#x201C;npu&#x201D;, &#x201C;rocm&#x201D;, &#x201C;xpu&#x201D;.
The device type will be inferred from the model parameters when not provided.`,name:"device"},{anchor:"kernels.kernelize.use_fallback",description:`<strong>use_fallback</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the original forward method of modules when no compatible kernel could be found.
If set to <code>False</code>, an exception will be raised in such cases.`,name:"use_fallback"}],source:"https://github.com/huggingface/kernels/blob/main/src/kernels/layer.py#L822",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The kernelized model with optimized kernel implementations.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>nn.Module</code></p>
`}}),H=new ee({props:{anchor:"kernels.kernelize.example",$$slots:{default:[vt]},$$scope:{ctx:k}}}),ue=new j({props:{title:"Classes",local:"classes",headingTag:"h2"}}),he=new j({props:{title:"Device",local:"kernels.Device",headingTag:"h3"}}),Ue=new L({props:{name:"class kernels.Device",anchor:"kernels.Device",parameters:[{name:"type",val:": str"},{name:"properties",val:": Optional[CUDAProperties] = None"}],parametersDescription:[{anchor:"kernels.Device.type",description:`<strong>type</strong> (<code>str</code>) &#x2014;
The device type (e.g., &#x201C;cuda&#x201D;, &#x201C;mps&#x201D;, &#x201C;npu&#x201D;, &#x201C;rocm&#x201D;, &#x201C;xpu&#x201D;).`,name:"type"},{anchor:"kernels.Device.properties",description:`<strong>properties</strong> (<code>CUDAProperties</code>, <em>optional</em>) &#x2014;
Device-specific properties. Currently only <code>CUDAProperties</code> is supported for CUDA devices.`,name:"properties"}],source:"https://github.com/huggingface/kernels/blob/main/src/kernels/layer.py#L81"}}),q=new ee({props:{anchor:"kernels.Device.example",$$slots:{default:[xt]},$$scope:{ctx:k}}}),fe=new L({props:{name:"create_repo",anchor:"kernels.Device.create_repo",parameters:[],source:"https://github.com/huggingface/kernels/blob/main/src/kernels/layer.py#L126"}}),ge=new j({props:{title:"Mode",local:"kernels.Mode",headingTag:"h3"}}),we=new L({props:{name:"class kernels.Mode",anchor:"kernels.Mode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],parametersDescription:[{anchor:"kernels.Mode.INFERENCE",description:"<strong>INFERENCE</strong> &#x2014; The kernel is used for inference.",name:"INFERENCE"},{anchor:"kernels.Mode.TRAINING",description:"<strong>TRAINING</strong> &#x2014; The kernel is used for training.",name:"TRAINING"},{anchor:"kernels.Mode.TORCH_COMPILE",description:"<strong>TORCH_COMPILE</strong> &#x2014; The kernel is used with <code>torch.compile</code>.",name:"TORCH_COMPILE"},{anchor:"kernels.Mode.FALLBACK",description:"<strong>FALLBACK</strong> &#x2014; In a kernel mapping, this kernel is used when no other mode matches.",name:"FALLBACK"}],source:"https://github.com/huggingface/kernels/blob/main/src/kernels/layer.py#L43"}}),Je=new j({props:{title:"LayerRepository",local:"kernels.LayerRepository",headingTag:"h3"}}),Te=new L({props:{name:"class kernels.LayerRepository",anchor:"kernels.LayerRepository",parameters:[{name:"repo_id",val:": str"},{name:"layer_name",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"version",val:": Optional[str] = None"}],parametersDescription:[{anchor:"kernels.LayerRepository.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The Hub repository containing the layer.`,name:"repo_id"},{anchor:"kernels.LayerRepository.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer within the kernel repository.`,name:"layer_name"},{anchor:"kernels.LayerRepository.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision (branch, tag, or commit) to download. Cannot be used together with <code>version</code>.`,name:"revision"},{anchor:"kernels.LayerRepository.version",description:`<strong>version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The kernel version to download. This can be a Python version specifier, such as <code>&quot;&gt;=1.0.0,&lt;2.0.0&quot;</code>.
Cannot be used together with <code>revision</code>.`,name:"version"}],source:"https://github.com/huggingface/kernels/blob/main/src/kernels/layer.py#L247"}}),K=new ee({props:{anchor:"kernels.LayerRepository.example",$$slots:{default:[Bt]},$$scope:{ctx:k}}}),ke=new j({props:{title:"LocalLayerRepository",local:"kernels.LocalLayerRepository",headingTag:"h3"}}),be=new L({props:{name:"class kernels.LocalLayerRepository",anchor:"kernels.LocalLayerRepository",parameters:[{name:"repo_path",val:": Path"},{name:"package_name",val:": str"},{name:"layer_name",val:": str"}],parametersDescription:[{anchor:"kernels.LocalLayerRepository.repo_path",description:`<strong>repo_path</strong> (<code>Path</code>) &#x2014;
The local repository containing the layer.`,name:"repo_path"},{anchor:"kernels.LocalLayerRepository.package_name",description:`<strong>package_name</strong> (<code>str</code>) &#x2014;
Package name of the kernel.`,name:"package_name"},{anchor:"kernels.LocalLayerRepository.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer within the kernel repository.`,name:"layer_name"}],source:"https://github.com/huggingface/kernels/blob/main/src/kernels/layer.py#L327"}}),O=new ee({props:{anchor:"kernels.LocalLayerRepository.example",$$slots:{default:[Zt]},$$scope:{ctx:k}}}),je=new j({props:{title:"LockedLayerRepository",local:"kernels.LockedLayerRepository",headingTag:"h3"}}),$e=new L({props:{name:"class kernels.LockedLayerRepository",anchor:"kernels.LockedLayerRepository",parameters:[{name:"repo_id",val:": str"},{name:"lockfile",val:": Optional[Path] = None"},{name:"layer_name",val:": str"}],source:"https://github.com/huggingface/kernels/blob/main/src/kernels/layer.py#L383"}}),Ce=new jt({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/api/layers.md"}}),{c(){n=f("meta"),J=r(),m=f("p"),a=r(),y(c.$$.fragment),l=r(),y(w.$$.fragment),Oe=r(),y(ne.$$.fragment),el=r(),$=f("div"),y(se.$$.fragment),jl=r(),Ie=f("p"),Ie.textContent=et,$l=r(),ve=f("p"),ve.textContent=lt,Cl=r(),y(z.$$.fragment),ll=r(),y(ae.$$.fragment),tl=r(),C=f("div"),y(re.$$.fragment),_l=r(),xe=f("p"),xe.textContent=tt,Il=r(),Be=f("p"),Be.innerHTML=nt,vl=r(),y(F.$$.fragment),nl=r(),y(oe.$$.fragment),sl=r(),y(pe.$$.fragment),al=r(),_=f("div"),y(ie.$$.fragment),xl=r(),Ze=f("p"),Ze.textContent=st,Bl=r(),Ee=f("p"),Ee.textContent=at,Zl=r(),y(D.$$.fragment),rl=r(),y(ce.$$.fragment),ol=r(),I=f("div"),y(me.$$.fragment),El=r(),Re=f("p"),Re.textContent=rt,Rl=r(),We=f("p"),We.innerHTML=ot,Wl=r(),y(Y.$$.fragment),pl=r(),y(ye.$$.fragment),il=r(),y(Me.$$.fragment),cl=r(),v=f("div"),y(de.$$.fragment),Gl=r(),Ge=f("p"),Ge.textContent=pt,Xl=r(),Xe=f("p"),Xe.innerHTML=it,Sl=r(),y(H.$$.fragment),ml=r(),y(ue.$$.fragment),yl=r(),y(he.$$.fragment),Ml=r(),b=f("div"),y(Ue.$$.fragment),Al=r(),Se=f("p"),Se.textContent=ct,Vl=r(),Ae=f("p"),Ae.textContent=mt,Ql=r(),y(q.$$.fragment),Nl=r(),P=f("div"),y(fe.$$.fragment),Ll=r(),Ve=f("p"),Ve.textContent=yt,dl=r(),y(ge.$$.fragment),ul=r(),x=f("div"),y(we.$$.fragment),zl=r(),Qe=f("p"),Qe.textContent=Mt,Fl=r(),Ne=f("p"),Ne.innerHTML=dt,Dl=r(),Le=f("p"),Le.innerHTML=ut,hl=r(),y(Je.$$.fragment),Ul=r(),R=f("div"),y(Te.$$.fragment),Yl=r(),ze=f("p"),ze.textContent=ht,Hl=r(),y(K.$$.fragment),fl=r(),y(ke.$$.fragment),gl=r(),W=f("div"),y(be.$$.fragment),ql=r(),Fe=f("p"),Fe.textContent=Ut,Pl=r(),y(O.$$.fragment),wl=r(),y(je.$$.fragment),Jl=r(),G=f("div"),y($e.$$.fragment),Kl=r(),De=f("p"),De.textContent=ft,Ol=r(),Ye=f("p"),Ye.innerHTML=gt,Tl=r(),y(Ce.$$.fragment),kl=r(),Ke=f("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);n=g(t,"META",{name:!0,content:!0}),t.forEach(s),J=o(e),m=g(e,"P",{}),Z(m).forEach(s),a=o(e),M(c.$$.fragment,e),l=o(e),M(w.$$.fragment,e),Oe=o(e),M(ne.$$.fragment,e),el=o(e),$=g(e,"DIV",{class:!0});var X=Z($);M(se.$$.fragment,X),jl=o(X),Ie=g(X,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-17ebw3h"&&(Ie.textContent=et),$l=o(X),ve=g(X,"P",{"data-svelte-h":!0}),T(ve)!=="svelte-wgdatn"&&(ve.textContent=lt),Cl=o(X),M(z.$$.fragment,X),X.forEach(s),ll=o(e),M(ae.$$.fragment,e),tl=o(e),C=g(e,"DIV",{class:!0});var S=Z(C);M(re.$$.fragment,S),_l=o(S),xe=g(S,"P",{"data-svelte-h":!0}),T(xe)!=="svelte-17bjf1v"&&(xe.textContent=tt),Il=o(S),Be=g(S,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-17zt1wx"&&(Be.innerHTML=nt),vl=o(S),M(F.$$.fragment,S),S.forEach(s),nl=o(e),M(oe.$$.fragment,e),sl=o(e),M(pe.$$.fragment,e),al=o(e),_=g(e,"DIV",{class:!0});var A=Z(_);M(ie.$$.fragment,A),xl=o(A),Ze=g(A,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-4v5vcp"&&(Ze.textContent=st),Bl=o(A),Ee=g(A,"P",{"data-svelte-h":!0}),T(Ee)!=="svelte-124m5et"&&(Ee.textContent=at),Zl=o(A),M(D.$$.fragment,A),A.forEach(s),rl=o(e),M(ce.$$.fragment,e),ol=o(e),I=g(e,"DIV",{class:!0});var V=Z(I);M(me.$$.fragment,V),El=o(V),Re=g(V,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-h5yso0"&&(Re.textContent=rt),Rl=o(V),We=g(V,"P",{"data-svelte-h":!0}),T(We)!=="svelte-wk1xob"&&(We.innerHTML=ot),Wl=o(V),M(Y.$$.fragment,V),V.forEach(s),pl=o(e),M(ye.$$.fragment,e),il=o(e),M(Me.$$.fragment,e),cl=o(e),v=g(e,"DIV",{class:!0});var Q=Z(v);M(de.$$.fragment,Q),Gl=o(Q),Ge=g(Q,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-11gfrdt"&&(Ge.textContent=pt),Xl=o(Q),Xe=g(Q,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-d4cjbf"&&(Xe.innerHTML=it),Sl=o(Q),M(H.$$.fragment,Q),Q.forEach(s),ml=o(e),M(ue.$$.fragment,e),yl=o(e),M(he.$$.fragment,e),Ml=o(e),b=g(e,"DIV",{class:!0});var B=Z(b);M(Ue.$$.fragment,B),Al=o(B),Se=g(B,"P",{"data-svelte-h":!0}),T(Se)!=="svelte-19eu2wi"&&(Se.textContent=ct),Vl=o(B),Ae=g(B,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-9t0i4c"&&(Ae.textContent=mt),Ql=o(B),M(q.$$.fragment,B),Nl=o(B),P=g(B,"DIV",{class:!0});var _e=Z(P);M(fe.$$.fragment,_e),Ll=o(_e),Ve=g(_e,"P",{"data-svelte-h":!0}),T(Ve)!=="svelte-1naj9x1"&&(Ve.textContent=yt),_e.forEach(s),B.forEach(s),dl=o(e),M(ge.$$.fragment,e),ul=o(e),x=g(e,"DIV",{class:!0});var N=Z(x);M(we.$$.fragment,N),zl=o(N),Qe=g(N,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-wlnf64"&&(Qe.textContent=Mt),Fl=o(N),Ne=g(N,"P",{"data-svelte-h":!0}),T(Ne)!=="svelte-fr29on"&&(Ne.innerHTML=dt),Dl=o(N),Le=g(N,"P",{"data-svelte-h":!0}),T(Le)!=="svelte-x58jtu"&&(Le.innerHTML=ut),N.forEach(s),hl=o(e),M(Je.$$.fragment,e),Ul=o(e),R=g(e,"DIV",{class:!0});var He=Z(R);M(Te.$$.fragment,He),Yl=o(He),ze=g(He,"P",{"data-svelte-h":!0}),T(ze)!=="svelte-1foq575"&&(ze.textContent=ht),Hl=o(He),M(K.$$.fragment,He),He.forEach(s),fl=o(e),M(ke.$$.fragment,e),gl=o(e),W=g(e,"DIV",{class:!0});var qe=Z(W);M(be.$$.fragment,qe),ql=o(qe),Fe=g(qe,"P",{"data-svelte-h":!0}),T(Fe)!=="svelte-17opoc3"&&(Fe.textContent=Ut),Pl=o(qe),M(O.$$.fragment,qe),qe.forEach(s),wl=o(e),M(je.$$.fragment,e),Jl=o(e),G=g(e,"DIV",{class:!0});var Pe=Z(G);M($e.$$.fragment,Pe),Kl=o(Pe),De=g(Pe,"P",{"data-svelte-h":!0}),T(De)!=="svelte-10njn0v"&&(De.textContent=ft),Ol=o(Pe),Ye=g(Pe,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-1u9ojx1"&&(Ye.innerHTML=gt),Pe.forEach(s),Tl=o(e),M(Ce.$$.fragment,e),kl=o(e),Ke=g(e,"P",{}),Z(Ke).forEach(s),this.h()},h(){E(n,"name","hf:doc:metadata"),E(n,"content",Rt),E($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,n),p(e,J,t),p(e,m,t),p(e,a,t),d(c,e,t),p(e,l,t),d(w,e,t),p(e,Oe,t),d(ne,e,t),p(e,el,t),p(e,$,t),d(se,$,null),i($,jl),i($,Ie),i($,$l),i($,ve),i($,Cl),d(z,$,null),p(e,ll,t),d(ae,e,t),p(e,tl,t),p(e,C,t),d(re,C,null),i(C,_l),i(C,xe),i(C,Il),i(C,Be),i(C,vl),d(F,C,null),p(e,nl,t),d(oe,e,t),p(e,sl,t),d(pe,e,t),p(e,al,t),p(e,_,t),d(ie,_,null),i(_,xl),i(_,Ze),i(_,Bl),i(_,Ee),i(_,Zl),d(D,_,null),p(e,rl,t),d(ce,e,t),p(e,ol,t),p(e,I,t),d(me,I,null),i(I,El),i(I,Re),i(I,Rl),i(I,We),i(I,Wl),d(Y,I,null),p(e,pl,t),d(ye,e,t),p(e,il,t),d(Me,e,t),p(e,cl,t),p(e,v,t),d(de,v,null),i(v,Gl),i(v,Ge),i(v,Xl),i(v,Xe),i(v,Sl),d(H,v,null),p(e,ml,t),d(ue,e,t),p(e,yl,t),d(he,e,t),p(e,Ml,t),p(e,b,t),d(Ue,b,null),i(b,Al),i(b,Se),i(b,Vl),i(b,Ae),i(b,Ql),d(q,b,null),i(b,Nl),i(b,P),d(fe,P,null),i(P,Ll),i(P,Ve),p(e,dl,t),d(ge,e,t),p(e,ul,t),p(e,x,t),d(we,x,null),i(x,zl),i(x,Qe),i(x,Fl),i(x,Ne),i(x,Dl),i(x,Le),p(e,hl,t),d(Je,e,t),p(e,Ul,t),p(e,R,t),d(Te,R,null),i(R,Yl),i(R,ze),i(R,Hl),d(K,R,null),p(e,fl,t),d(ke,e,t),p(e,gl,t),p(e,W,t),d(be,W,null),i(W,ql),i(W,Fe),i(W,Pl),d(O,W,null),p(e,wl,t),d(je,e,t),p(e,Jl,t),p(e,G,t),d($e,G,null),i(G,Kl),i(G,De),i(G,Ol),i(G,Ye),p(e,Tl,t),d(Ce,e,t),p(e,kl,t),p(e,Ke,t),bl=!0},p(e,[t]){const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),z.$set(X);const S={};t&2&&(S.$$scope={dirty:t,ctx:e}),F.$set(S);const A={};t&2&&(A.$$scope={dirty:t,ctx:e}),D.$set(A);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),Y.$set(V);const Q={};t&2&&(Q.$$scope={dirty:t,ctx:e}),H.$set(Q);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),q.$set(B);const _e={};t&2&&(_e.$$scope={dirty:t,ctx:e}),K.$set(_e);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),O.$set(N)},i(e){bl||(u(c.$$.fragment,e),u(w.$$.fragment,e),u(ne.$$.fragment,e),u(se.$$.fragment,e),u(z.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(F.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(ie.$$.fragment,e),u(D.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(Y.$$.fragment,e),u(ye.$$.fragment,e),u(Me.$$.fragment,e),u(de.$$.fragment,e),u(H.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(Ue.$$.fragment,e),u(q.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(K.$$.fragment,e),u(ke.$$.fragment,e),u(be.$$.fragment,e),u(O.$$.fragment,e),u(je.$$.fragment,e),u($e.$$.fragment,e),u(Ce.$$.fragment,e),bl=!0)},o(e){h(c.$$.fragment,e),h(w.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(z.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(F.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(ie.$$.fragment,e),h(D.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(Y.$$.fragment,e),h(ye.$$.fragment,e),h(Me.$$.fragment,e),h(de.$$.fragment,e),h(H.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(Ue.$$.fragment,e),h(q.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(Te.$$.fragment,e),h(K.$$.fragment,e),h(ke.$$.fragment,e),h(be.$$.fragment,e),h(O.$$.fragment,e),h(je.$$.fragment,e),h($e.$$.fragment,e),h(Ce.$$.fragment,e),bl=!1},d(e){e&&(s(J),s(m),s(a),s(l),s(Oe),s(el),s($),s(ll),s(tl),s(C),s(nl),s(sl),s(al),s(_),s(rl),s(ol),s(I),s(pl),s(il),s(cl),s(v),s(ml),s(yl),s(Ml),s(b),s(dl),s(ul),s(x),s(hl),s(Ul),s(R),s(fl),s(gl),s(W),s(wl),s(Jl),s(G),s(Tl),s(kl),s(Ke)),s(n),U(c,e),U(w,e),U(ne,e),U(se),U(z),U(ae,e),U(re),U(F),U(oe,e),U(pe,e),U(ie),U(D),U(ce,e),U(me),U(Y),U(ye,e),U(Me,e),U(de),U(H),U(ue,e),U(he,e),U(Ue),U(q),U(fe),U(ge,e),U(we),U(Je,e),U(Te),U(K),U(ke,e),U(be),U(O),U(je,e),U($e),U(Ce,e)}}}const Rt='{"title":"Layers API Reference","local":"layers-api-reference","sections":[{"title":"Making layers kernel-aware","local":"making-layers-kernel-aware","sections":[{"title":"use_kernel_forward_from_hub","local":"kernels.use_kernel_forward_from_hub","sections":[],"depth":3},{"title":"replace_kernel_forward_from_hub","local":"kernels.replace_kernel_forward_from_hub","sections":[],"depth":3}],"depth":2},{"title":"Registering kernel mappings","local":"registering-kernel-mappings","sections":[{"title":"use_kernel_mapping","local":"kernels.use_kernel_mapping","sections":[],"depth":3},{"title":"register_kernel_mapping","local":"kernels.register_kernel_mapping","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"kernelize","local":"kernels.kernelize","sections":[],"depth":3}],"depth":2},{"title":"Classes","local":"classes","sections":[{"title":"Device","local":"kernels.Device","sections":[],"depth":3},{"title":"Mode","local":"kernels.Mode","sections":[],"depth":3},{"title":"LayerRepository","local":"kernels.LayerRepository","sections":[],"depth":3},{"title":"LocalLayerRepository","local":"kernels.LocalLayerRepository","sections":[],"depth":3},{"title":"LockedLayerRepository","local":"kernels.LockedLayerRepository","sections":[],"depth":3}],"depth":2}],"depth":1}';function Wt(k){return Jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends Tt{constructor(n){super(),kt(this,n,Wt,Et,wt,{})}}export{Qt as component};
