import{s as Ws,o as vs,n as Oe}from"../chunks/scheduler.182ea377.js";import{S as Cs,i as Is,g as i,s as n,r,A as Gs,h as o,f as t,c as a,j as js,u as c,x as p,k as U,y as Bs,a as s,v as d,d as M,t as u,w as y}from"../chunks/index.abf12888.js";import{T as Ke}from"../chunks/Tip.230e2334.js";import{C as g}from"../chunks/CodeBlock.57fe6e13.js";import{H as qe,E as ks}from"../chunks/EditOnGithub.9b8e78e4.js";function _s(Z){let m,b='Check out Section 3.5 of the <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">ControlNet</a> paper v1 for a list of ControlNet implementations on various conditioning inputs. You can find the official Stable Diffusion ControlNet conditioned models on <a href="https://huggingface.co/lllyasviel" rel="nofollow">lllyasviel</a>’s Hub profile, and more <a href="https://huggingface.co/models?other=stable-diffusion&amp;other=controlnet" rel="nofollow">community-trained</a> ones on the Hub.',J,f,T='For Stable Diffusion XL (SDXL) ControlNet models, you can find them on the 🤗 <a href="https://huggingface.co/diffusers" rel="nofollow">Diffusers</a> Hub organization, or you can browse <a href="https://huggingface.co/models?other=stable-diffusion-xl&amp;other=controlnet" rel="nofollow">community-trained</a> ones on the Hub.';return{c(){m=i("p"),m.innerHTML=b,J=n(),f=i("p"),f.innerHTML=T},l(h){m=o(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1scaly9"&&(m.innerHTML=b),J=a(h),f=o(h,"P",{"data-svelte-h":!0}),p(f)!=="svelte-2pe81s"&&(f.innerHTML=T)},m(h,w){s(h,m,w),s(h,J,w),s(h,f,w)},p:Oe,d(h){h&&(t(m),t(J),t(f))}}}function Ns(Z){let m,b="Guess mode does not have any impact on prompt conditioning and you can still provide a prompt if you want.";return{c(){m=i("p"),m.textContent=b},l(J){m=o(J,"P",{"data-svelte-h":!0}),p(m)!=="svelte-14ez4w"&&(m.textContent=b)},m(J,f){s(J,m,f)},p:Oe,d(J){J&&t(m)}}}function Xs(Z){let m,b='The <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale" rel="nofollow"><code>controlnet_conditioning_scale</code></a> parameter determines how much weight to assign to the conditioning inputs. A value of 0.5 is recommended for good generalization, but feel free to experiment with this number!';return{c(){m=i("p"),m.innerHTML=b},l(J){m=o(J,"P",{"data-svelte-h":!0}),p(m)!=="svelte-52h992"&&(m.innerHTML=b)},m(J,f){s(J,m,f)},p:Oe,d(J){J&&t(m)}}}function Ys(Z){let m,b=`You can use a refiner model with <code>StableDiffusionXLControlNetPipeline</code> to improve image quality, just like you can with a regular <code>StableDiffusionXLPipeline</code>.
See the <a href="./sdxl#refine-image-quality">Refine image quality</a> section to learn how to use the refiner model.
Make sure to use <code>StableDiffusionXLControlNetPipeline</code> and pass <code>image</code> and <code>controlnet_conditioning_scale</code>.`,J,f,T;return f=new g({props:{code:"YmFzZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lKC4uLiklMEFpbWFnZSUyMCUzRCUyMGJhc2UoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGNhbm55X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQwJTJDJTBBJTIwJTIwJTIwJTIwZGVub2lzaW5nX2VuZCUzRDAuOCUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyJTJDJTBBKS5pbWFnZXMlMEElMjMlMjByZXN0JTIwZXhhY3RseSUyMGFzJTIwd2l0aCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmU=",highlighted:`base = StableDiffusionXLControlNetPipeline(...)
image = base(
    prompt=prompt,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
    image=canny_image,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images
<span class="hljs-comment"># rest exactly as with StableDiffusionXLPipeline</span>`,wrap:!1}}),{c(){m=i("p"),m.innerHTML=b,J=n(),r(f.$$.fragment)},l(h){m=o(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-vlhoer"&&(m.innerHTML=b),J=a(h),c(f.$$.fragment,h)},m(h,w){s(h,m,w),s(h,J,w),d(f,h,w),T=!0},p:Oe,i(h){T||(M(f.$$.fragment,h),T=!0)},o(h){u(f.$$.fragment,h),T=!1},d(h){h&&(t(m),t(J)),y(f,h)}}}function xs(Z){let m,b='Replace the SDXL model with a model like <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> to use multiple conditioning inputs with Stable Diffusion models.';return{c(){m=i("p"),m.innerHTML=b},l(J){m=o(J,"P",{"data-svelte-h":!0}),p(m)!=="svelte-lnumtz"&&(m.innerHTML=b)},m(J,f){s(J,m,f)},p:Oe,d(J){J&&t(m)}}}function Rs(Z){let m,b,J,f,T,h,w,vt="ControlNet is a type of model for controlling image diffusion models by conditioning the model with an additional input image. There are many types of conditioning inputs (canny edge, user sketching, human pose, depth, and more) you can use to control a diffusion model. This is hugely useful because it affords you greater control over image generation, making it easier to generate specific images without experimenting with different text prompts or denoising values as much.",el,j,ll,V,Ct="A ControlNet model has two sets of weights (or blocks) connected by a zero-convolution layer:",tl,Q,It="<li>a <em>locked copy</em> keeps everything a large pretrained diffusion model has learned</li> <li>a <em>trainable copy</em> is trained on the additional conditioning input</li>",sl,S,Gt="Since the locked copy preserves the pretrained model, training and implementing a ControlNet on a new conditioning input is as fast as finetuning any other model because you aren’t training the model from scratch.",nl,$,Bt="This guide will show you how to use ControlNet for text-to-image, image-to-image, inpainting, and more! There are many types of ControlNet conditioning inputs to choose from, but in this guide we’ll only focus on several of them. Feel free to experiment with other conditioning inputs!",al,H,kt="Before you begin, make sure you have the following libraries installed:",il,z,ol,L,pl,A,_t="For text-to-image, you normally pass a text prompt to the model. But with ControlNet, you can specify an additional conditioning input. Let’s condition the model with a canny image, a white outline of an image on a black background. This way, the ControlNet can use the canny image as a control to guide the model to generate an image with the same outline.",ml,D,Nt='Load an image and use the <a href="https://github.com/opencv/opencv-python" rel="nofollow">opencv-python</a> library to extract the canny image:',rl,q,cl,W,Xt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/vermeer_canny_edged.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',dl,P,Yt='Next, load a ControlNet model conditioned on canny edge detection and pass it to the <a href="/docs/diffusers/v0.28.2/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a>. Use the faster <a href="/docs/diffusers/v0.28.2/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',Ml,K,ul,O,xt="Now pass your prompt and canny image to the pipeline:",yl,ee,Jl,v,Rt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-text2img.png"/>',hl,le,fl,te,Et="For image-to-image, you’d typically pass an initial image and a prompt to the pipeline to generate a new image. With ControlNet, you can pass an additional conditioning input to guide the model. Let’s condition the model with a depth map, an image which contains spatial information. This way, the ControlNet can use the depth map as a control to guide the model to generate an image that preserves spatial information.",gl,se,Ft='You’ll use the <a href="/docs/diffusers/v0.28.2/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetImg2ImgPipeline">StableDiffusionControlNetImg2ImgPipeline</a> for this task, which is different from the <a href="/docs/diffusers/v0.28.2/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> because it allows you to pass an initial image as the starting point for the image generation process.',bl,ne,Vt='Load an image and use the <code>depth-estimation</code> <a href="https://huggingface.co/docs/transformers/v4.41.2/en/main_classes/pipelines#transformers.Pipeline" rel="nofollow">Pipeline</a> from 🤗 Transformers to extract the depth map of an image:',Tl,ae,wl,ie,Qt='Next, load a ControlNet model conditioned on depth maps and pass it to the <a href="/docs/diffusers/v0.28.2/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetImg2ImgPipeline">StableDiffusionControlNetImg2ImgPipeline</a>. Use the faster <a href="/docs/diffusers/v0.28.2/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',Ul,oe,Zl,pe,St="Now pass your prompt, initial image, and depth map to the pipeline:",jl,me,Wl,C,$t='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img-2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',vl,re,Cl,ce,Ht="For inpainting, you need an initial image, a mask image, and a prompt describing what to replace the mask with. ControlNet models allow you to add another control image to condition a model with. Let’s condition the model with an inpainting mask. This way, the ControlNet can use the inpainting mask as a control to guide the model to generate an image within the mask area.",Il,de,zt="Load an initial image and a mask image:",Gl,Me,Bl,ue,Lt="Create a function to prepare the control image from the initial and mask images. This’ll create a tensor to mark the pixels in <code>init_image</code> as masked if the corresponding pixel in <code>mask_image</code> is over a certain threshold.",kl,ye,_l,I,At='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-mask.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask image</figcaption></div>',Nl,Je,Dt='Load a ControlNet model conditioned on inpainting and pass it to the <a href="/docs/diffusers/v0.28.2/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetInpaintPipeline">StableDiffusionControlNetInpaintPipeline</a>. Use the faster <a href="/docs/diffusers/v0.28.2/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',Xl,he,Yl,fe,qt="Now pass your prompt, initial image, mask image, and control image to the pipeline:",xl,ge,Rl,G,Pt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-result.png"/>',El,be,Fl,Te,Kt='<a href="https://github.com/lllyasviel/ControlNet/discussions/188" rel="nofollow">Guess mode</a> does not require supplying a prompt to a ControlNet at all! This forces the ControlNet encoder to do it’s best to “guess” the contents of the input control map (depth map, pose estimation, canny edge, etc.).',Vl,we,Ot="Guess mode adjusts the scale of the output residuals from a ControlNet by a fixed ratio depending on the block depth. The shallowest <code>DownBlock</code> corresponds to 0.1, and as the blocks get deeper, the scale increases exponentially such that the scale of the <code>MidBlock</code> output becomes 1.0.",Ql,B,Sl,Ue,es='Set <code>guess_mode=True</code> in the pipeline, and it is <a href="https://github.com/lllyasviel/ControlNet#guess-mode--non-prompt-mode" rel="nofollow">recommended</a> to set the <code>guidance_scale</code> value between 3.0 and 5.0.',$l,Ze,Hl,k,ls='<div><img class="rounded-xl" src="https://huggingface.co/takuma104/controlnet_dev/resolve/main/gen_compare_guess_mode/output_images/diffusers/output_bird_canny_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">regular mode with prompt</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/takuma104/controlnet_dev/resolve/main/gen_compare_guess_mode/output_images/diffusers/output_bird_canny_0_gm.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guess mode without prompt</figcaption></div>',zl,je,Ll,We,ts='There aren’t too many ControlNet models compatible with Stable Diffusion XL (SDXL) at the moment, but we’ve trained two full-sized ControlNet models for SDXL conditioned on canny edge detection and depth maps. We’re also experimenting with creating smaller versions of these SDXL-compatible ControlNet models so it is easier to run on resource-constrained hardware. You can find these checkpoints on the <a href="https://huggingface.co/diffusers" rel="nofollow">🤗 Diffusers Hub organization</a>!',Al,ve,ss="Let’s use a SDXL ControlNet conditioned on canny images to generate an image. Start by loading an image and prepare the canny image:",Dl,Ce,ql,_,ns='<div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hf-logo-canny.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',Pl,Ie,as='Load a SDXL ControlNet model conditioned on canny edge detection and pass it to the <a href="/docs/diffusers/v0.28.2/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a>. You can also enable model offloading to reduce memory usage.',Kl,Ge,Ol,Be,is="Now pass your prompt (and optionally a negative prompt if you’re using one) and canny image to the pipeline:",et,N,lt,ke,tt,X,os='<img class="rounded-xl" src="https://huggingface.co/diffusers/controlnet-canny-sdxl-1.0/resolve/main/out_hug_lab_7.png"/>',st,_e,ps='You can use <a href="/docs/diffusers/v0.28.2/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a> in guess mode as well by setting the parameter to <code>True</code>:',nt,Ne,at,Y,it,Xe,ot,x,pt,Ye,ms="You can compose multiple ControlNet conditionings from different image inputs to create a <em>MultiControlNet</em>. To get better results, it is often helpful to:",mt,xe,rs='<li>mask conditionings such that they don’t overlap (for example, mask the area of a canny image where the pose conditioning is located)</li> <li>experiment with the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale" rel="nofollow"><code>controlnet_conditioning_scale</code></a> parameter to determine how much weight to assign to each conditioning input</li>',rt,Re,cs="In this example, you’ll combine a canny image and a human pose estimation image to generate a new image.",ct,Ee,ds="Prepare the canny image conditioning:",dt,Fe,Mt,R,Ms='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/controlnet/landscape_canny_masked.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',ut,Ve,us='For human pose estimation, install <a href="https://github.com/patrickvonplaten/controlnet_aux" rel="nofollow">controlnet_aux</a>:',yt,Qe,Jt,Se,ys="Prepare the human pose estimation conditioning:",ht,$e,ft,E,Js='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/person.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/controlnet/person_pose.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">human pose image</figcaption></div>',gt,He,hs='Load a list of ControlNet models that correspond to each conditioning, and pass them to the <a href="/docs/diffusers/v0.28.2/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a>. Use the faster <a href="/docs/diffusers/v0.28.2/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to reduce memory usage.',bt,ze,Tt,Le,fs="Now you can pass your prompt (an optional negative prompt if you’re using one), canny image, and pose image to the pipeline:",wt,Ae,Ut,F,gs='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/multicontrolnet.png"/>',Zt,De,jt,Pe,Wt;return T=new qe({props:{title:"ControlNet",local:"controlnet",headingTag:"h1"}}),j=new Ke({props:{$$slots:{default:[_s]},$$scope:{ctx:Z}}}),z=new g({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwb3BlbmN2LXB5dGhvbg==",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate opencv-python</span>`,wrap:!1}}),L=new qe({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),q=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBjdjIlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZoZi5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wdXRfaW1hZ2VfdmVybWVlci5wbmclMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBucC5hcnJheShvcmlnaW5hbF9pbWFnZSklMEElMEFsb3dfdGhyZXNob2xkJTIwJTNEJTIwMTAwJTBBaGlnaF90aHJlc2hvbGQlMjAlM0QlMjAyMDAlMEElMEFpbWFnZSUyMCUzRCUyMGN2Mi5DYW5ueShpbWFnZSUyQyUyMGxvd190aHJlc2hvbGQlMkMlMjBoaWdoX3RocmVzaG9sZCklMEFpbWFnZSUyMCUzRCUyMGltYWdlJTVCJTNBJTJDJTIwJTNBJTJDJTIwTm9uZSU1RCUwQWltYWdlJTIwJTNEJTIwbnAuY29uY2F0ZW5hdGUoJTVCaW1hZ2UlMkMlMjBpbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwYXhpcyUzRDIpJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoaW1hZ2Up",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)`,wrap:!1}}),K=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUyQyUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),ee=new g({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJ0aGUlMjBtb25hJTIwbGlzYSUyMiUyQyUyMGltYWdlJTNEY2FubnlfaW1hZ2UlMEEpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`output = pipe(
    <span class="hljs-string">&quot;the mona lisa&quot;</span>, image=canny_image
).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),le=new qe({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),ae=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWltZzJpbWcuanBnJTIyJTBBKSUwQSUwQWRlZiUyMGdldF9kZXB0aF9tYXAoaW1hZ2UlMkMlMjBkZXB0aF9lc3RpbWF0b3IpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoaW1hZ2UpJTVCJTIyZGVwdGglMjIlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEElMjAlMjAlMjAlMjBkZXRlY3RlZF9tYXAlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KGltYWdlKS5mbG9hdCgpJTIwJTJGJTIwMjU1LjAlMEElMjAlMjAlMjAlMjBkZXB0aF9tYXAlMjAlM0QlMjBkZXRlY3RlZF9tYXAucGVybXV0ZSgyJTJDJTIwMCUyQyUyMDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGVwdGhfbWFwJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiklMEFkZXB0aF9tYXAlMjAlM0QlMjBnZXRfZGVwdGhfbWFwKGltYWdlJTJDJTIwZGVwdGhfZXN0aW1hdG9yKS51bnNxdWVlemUoMCkuaGFsZigpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img.jpg&quot;</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_depth_map</span>(<span class="hljs-params">image, depth_estimator</span>):
    image = depth_estimator(image)[<span class="hljs-string">&quot;depth&quot;</span>]
    image = np.array(image)
    image = image[:, :, <span class="hljs-literal">None</span>]
    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
    detected_map = torch.from_numpy(image).<span class="hljs-built_in">float</span>() / <span class="hljs-number">255.0</span>
    depth_map = detected_map.permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> depth_map

depth_estimator = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>)
depth_map = get_depth_map(image, depth_estimator).unsqueeze(<span class="hljs-number">0</span>).half().to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),oe=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRJbWcySW1nUGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRmNvbnRyb2xfdjExZjFwX3NkMTVfZGVwdGglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0SW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEElMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetImg2ImgPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),me=new g({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJsZWdvJTIwYmF0bWFuJTIwYW5kJTIwcm9iaW4lMjIlMkMlMjBpbWFnZSUzRGltYWdlJTJDJTIwY29udHJvbF9pbWFnZSUzRGRlcHRoX21hcCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`output = pipe(
    <span class="hljs-string">&quot;lego batman and robin&quot;</span>, image=image, control_image=depth_map,
).images[<span class="hljs-number">0</span>]
make_image_grid([image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),re=new qe({props:{title:"Inpainting",local:"inpainting",headingTag:"h2"}}),Me=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWlucGFpbnQuanBnJTIyJTBBKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWlucGFpbnQtbWFzay5qcGclMjIlMEEpJTBBbWFza19pbWFnZSUyMCUzRCUyMG1hc2tfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint.jpg&quot;</span>
)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

mask_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-mask.jpg&quot;</span>
)
mask_image = mask_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
make_image_grid([init_image, mask_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ye=new g({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBtYWtlX2lucGFpbnRfY29uZGl0aW9uKGltYWdlJTJDJTIwaW1hZ2VfbWFzayklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSkuYXN0eXBlKG5wLmZsb2F0MzIpJTIwJTJGJTIwMjU1LjAlMEElMjAlMjAlMjAlMjBpbWFnZV9tYXNrJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2VfbWFzay5jb252ZXJ0KCUyMkwlMjIpKS5hc3R5cGUobnAuZmxvYXQzMiklMjAlMkYlMjAyNTUuMCUwQSUwQSUyMCUyMCUyMCUyMGFzc2VydCUyMGltYWdlLnNoYXBlJTVCMCUzQTElNUQlMjAlM0QlM0QlMjBpbWFnZV9tYXNrLnNoYXBlJTVCMCUzQTElNUQlMEElMjAlMjAlMjAlMjBpbWFnZSU1QmltYWdlX21hc2slMjAlM0UlMjAwLjUlNUQlMjAlM0QlMjAtMS4wJTIwJTIwJTIzJTIwc2V0JTIwYXMlMjBtYXNrZWQlMjBwaXhlbCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbnAuZXhwYW5kX2RpbXMoaW1hZ2UlMkMlMjAwKS50cmFuc3Bvc2UoMCUyQyUyMDMlMkMlMjAxJTJDJTIwMiklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRvcmNoLmZyb21fbnVtcHkoaW1hZ2UpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwbWFrZV9pbnBhaW50X2NvbmRpdGlvbihpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_inpaint_condition</span>(<span class="hljs-params">image, image_mask</span>):
    image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>
    image_mask = np.array(image_mask.convert(<span class="hljs-string">&quot;L&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>

    <span class="hljs-keyword">assert</span> image.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>] == image_mask.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>]
    image[image_mask &gt; <span class="hljs-number">0.5</span>] = -<span class="hljs-number">1.0</span>  <span class="hljs-comment"># set as masked pixel</span>
    image = np.expand_dims(image, <span class="hljs-number">0</span>).transpose(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
    image = torch.from_numpy(image)
    <span class="hljs-keyword">return</span> image

control_image = make_inpaint_condition(init_image, mask_image)`,wrap:!1}}),he=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRJbnBhaW50UGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMXBfc2QxNV9pbnBhaW50JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldElucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetInpaintPipeline, ControlNetModel, UniPCMultistepScheduler

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_inpaint&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),ge=new g({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJjb3JnaSUyMGZhY2UlMjB3aXRoJTIwbGFyZ2UlMjBlYXJzJTJDJTIwZGV0YWlsZWQlMkMlMjBwaXhhciUyQyUyMGFuaW1hdGVkJTJDJTIwZGlzbmV5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwZXRhJTNEMS4wJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTNEY29udHJvbF9pbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`output = pipe(
    <span class="hljs-string">&quot;corgi face with large ears, detailed, pixar, animated, disney&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    eta=<span class="hljs-number">1.0</span>,
    image=init_image,
    mask_image=mask_image,
    control_image=control_image,
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),be=new qe({props:{title:"Guess mode",local:"guess-mode",headingTag:"h2"}}),B=new Ke({props:{$$slots:{default:[Ns]},$$scope:{ctx:Z}}}),Ze=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBjdjIlMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3JpZ2luYWxfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZ0YWt1bWExMDQlMkZjb250cm9sbmV0X2RldiUyRnJlc29sdmUlMkZtYWluJTJGYmlyZF81MTJ4NTEyLnBuZyUyMiklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIyJTIyJTJDJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSUyQyUyMGd1ZXNzX21vZGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjApLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> cv2

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

original_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/takuma104/controlnet_dev/resolve/main/bird_512x512.png&quot;</span>)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

image = pipe(<span class="hljs-string">&quot;&quot;</span>, image=canny_image, guess_mode=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3.0</span>).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),je=new qe({props:{title:"ControlNet with Stable Diffusion XL",local:"controlnet-with-stable-diffusion-xl",headingTag:"h2"}}),Ce=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTJDJTIwQXV0b2VuY29kZXJLTCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnNkX2NvbnRyb2xuZXQlMkZoZi1sb2dvLnBuZyUyMiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)
make_image_grid([original_image, canny_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Ge=new g({props:{code:"Y29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBdmFlJTIwJTNEJTIwQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZzZHhsLXZhZS1mcDE2LWZpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUwQSUyMCUyMCUyMCUyMHZhZSUzRHZhZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>
)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    controlnet=controlnet,
    vae=vae,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>
)
pipe.enable_model_cpu_offload()`,wrap:!1}}),N=new Ke({props:{$$slots:{default:[Xs]},$$scope:{ctx:Z}}}),ke=new g({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYWVyaWFsJTIwdmlldyUyQyUyMGElMjBmdXR1cmlzdGljJTIwcmVzZWFyY2glMjBjb21wbGV4JTIwaW4lMjBhJTIwYnJpZ2h0JTIwZm9nZ3klMjBqdW5nbGUlMkMlMjBoYXJkJTIwbGlnaHRpbmclMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAnbG93JTIwcXVhbGl0eSUyQyUyMGJhZCUyMHF1YWxpdHklMkMlMjBza2V0Y2hlcyclMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTNEMC41JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1Qm9yaWdpbmFsX2ltYWdlJTJDJTIwY2FubnlfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&#x27;low quality, bad quality, sketches&#x27;</span>

image = pipe(
    prompt,
    negative_prompt=negative_prompt,
    image=canny_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),Ne=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)

controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, vae=vae, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipe.enable_model_cpu_offload()

image = np.array(original_image)
image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

image = pipe(
    prompt, negative_prompt=negative_prompt, controlnet_conditioning_scale=<span class="hljs-number">0.5</span>, image=canny_image, guess_mode=<span class="hljs-literal">True</span>,
).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),Y=new Ke({props:{$$slots:{default:[Ys]},$$scope:{ctx:Z}}}),Xe=new qe({props:{title:"MultiControlNet",local:"multicontrolnet",headingTag:"h2"}}),x=new Ke({props:{$$slots:{default:[xs]},$$scope:{ctx:Z}}}),Fe=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBjdjIlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGbGFuZHNjYXBlLnBuZyUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQSUwQSUyMyUyMHplcm8lMjBvdXQlMjBtaWRkbGUlMjBjb2x1bW5zJTIwb2YlMjBpbWFnZSUyMHdoZXJlJTIwcG9zZSUyMHdpbGwlMjBiZSUyMG92ZXJsYWlkJTBBemVyb19zdGFydCUyMCUzRCUyMGltYWdlLnNoYXBlJTVCMSU1RCUyMCUyRiUyRiUyMDQlMEF6ZXJvX2VuZCUyMCUzRCUyMHplcm9fc3RhcnQlMjAlMkIlMjBpbWFnZS5zaGFwZSU1QjElNUQlMjAlMkYlMkYlMjAyJTBBaW1hZ2UlNUIlM0ElMkMlMjB6ZXJvX3N0YXJ0JTNBemVyb19lbmQlNUQlMjAlM0QlMjAwJTBBJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEFpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQWNhbm55X2ltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJvcmlnaW5hbF9pbWFnZSUyQyUyMGNhbm55X2ltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> cv2

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png&quot;</span>
)
image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)

<span class="hljs-comment"># zero out middle columns of image where pose will be overlaid</span>
zero_start = image.shape[<span class="hljs-number">1</span>] // <span class="hljs-number">4</span>
zero_end = zero_start + image.shape[<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
image[:, zero_start:zero_end] = <span class="hljs-number">0</span>

image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)
make_image_grid([original_image, canny_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Qe=new g({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyeSUyMGluJTIwQ29sYWIlMEElMjMhcGlwJTIwaW5zdGFsbCUyMC1xJTIwY29udHJvbG5ldC1hdXg=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary library in Colab</span>
<span class="hljs-comment">#!pip install -q controlnet-aux</span>`,wrap:!1}}),$e=new g({props:{code:"ZnJvbSUyMGNvbnRyb2xuZXRfYXV4JTIwaW1wb3J0JTIwT3BlbnBvc2VEZXRlY3RvciUwQSUwQW9wZW5wb3NlJTIwJTNEJTIwT3BlbnBvc2VEZXRlY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRkNvbnRyb2xOZXQlMjIpJTBBb3JpZ2luYWxfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnBlcnNvbi5wbmclMjIlMEEpJTBBb3BlbnBvc2VfaW1hZ2UlMjAlM0QlMjBvcGVucG9zZShvcmlnaW5hbF9pbWFnZSklMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBvcGVucG9zZV9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> OpenposeDetector

openpose = OpenposeDetector.from_pretrained(<span class="hljs-string">&quot;lllyasviel/ControlNet&quot;</span>)
original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/person.png&quot;</span>
)
openpose_image = openpose(original_image)
make_image_grid([original_image, openpose_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ze=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTJDJTIwQXV0b2VuY29kZXJLTCUyQyUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGhpYmF1ZCUyRmNvbnRyb2xuZXQtb3BlbnBvc2Utc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMkZjb250cm9sbmV0LWNhbm55LXNkeGwtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSUyMCUyMCUyMCUyMCklMkMlMEElNUQlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJtYWRlYnlvbGxpbiUyRnNkeGwtdmFlLWZwMTYtZml4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0cyUyQyUyMHZhZSUzRHZhZSUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnets = [
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;thibaud/controlnet-openpose-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
    ),
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
    ),
]

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnets, vae=vae, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),Ae=new g({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGdpYW50JTIwc3RhbmRpbmclMjBpbiUyMGElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwYmVzdCUyMHF1YWxpdHklMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgxKSUwQSUwQWltYWdlcyUyMCUzRCUyMCU1Qm9wZW5wb3NlX2ltYWdlLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSUyQyUyMGNhbm55X2ltYWdlLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSU1RCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZXMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QzJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0QlNUIxLjAlMkMlMjAwLjglNUQlMkMlMEEpLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJvcmlnaW5hbF9pbWFnZSUyQyUyMGNhbm55X2ltYWdlJTJDJTIwb3BlbnBvc2VfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMlNUIwJTVELnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMkMlMjBpbWFnZXMlNUIxJTVELnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMkMlMjBpbWFnZXMlNUIyJTVELnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklNUQlMkMlMjByb3dzJTNEMiUyQyUyMGNvbHMlM0QzKQ==",highlighted:`prompt = <span class="hljs-string">&quot;a giant standing in a fantasy landscape, best quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">1</span>)

images = [openpose_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>)), canny_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))]

images = pipe(
    prompt,
    image=images,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    negative_prompt=negative_prompt,
    num_images_per_prompt=<span class="hljs-number">3</span>,
    controlnet_conditioning_scale=[<span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>],
).images
make_image_grid([original_image, canny_image, openpose_image,
                images[<span class="hljs-number">0</span>].resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>)), images[<span class="hljs-number">1</span>].resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>)), images[<span class="hljs-number">2</span>].resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),De=new ks({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/controlnet.md"}}),{c(){m=i("meta"),b=n(),J=i("p"),f=n(),r(T.$$.fragment),h=n(),w=i("p"),w.textContent=vt,el=n(),r(j.$$.fragment),ll=n(),V=i("p"),V.textContent=Ct,tl=n(),Q=i("ul"),Q.innerHTML=It,sl=n(),S=i("p"),S.textContent=Gt,nl=n(),$=i("p"),$.textContent=Bt,al=n(),H=i("p"),H.textContent=kt,il=n(),r(z.$$.fragment),ol=n(),r(L.$$.fragment),pl=n(),A=i("p"),A.textContent=_t,ml=n(),D=i("p"),D.innerHTML=Nt,rl=n(),r(q.$$.fragment),cl=n(),W=i("div"),W.innerHTML=Xt,dl=n(),P=i("p"),P.innerHTML=Yt,Ml=n(),r(K.$$.fragment),ul=n(),O=i("p"),O.textContent=xt,yl=n(),r(ee.$$.fragment),Jl=n(),v=i("div"),v.innerHTML=Rt,hl=n(),r(le.$$.fragment),fl=n(),te=i("p"),te.textContent=Et,gl=n(),se=i("p"),se.innerHTML=Ft,bl=n(),ne=i("p"),ne.innerHTML=Vt,Tl=n(),r(ae.$$.fragment),wl=n(),ie=i("p"),ie.innerHTML=Qt,Ul=n(),r(oe.$$.fragment),Zl=n(),pe=i("p"),pe.textContent=St,jl=n(),r(me.$$.fragment),Wl=n(),C=i("div"),C.innerHTML=$t,vl=n(),r(re.$$.fragment),Cl=n(),ce=i("p"),ce.textContent=Ht,Il=n(),de=i("p"),de.textContent=zt,Gl=n(),r(Me.$$.fragment),Bl=n(),ue=i("p"),ue.innerHTML=Lt,kl=n(),r(ye.$$.fragment),_l=n(),I=i("div"),I.innerHTML=At,Nl=n(),Je=i("p"),Je.innerHTML=Dt,Xl=n(),r(he.$$.fragment),Yl=n(),fe=i("p"),fe.textContent=qt,xl=n(),r(ge.$$.fragment),Rl=n(),G=i("div"),G.innerHTML=Pt,El=n(),r(be.$$.fragment),Fl=n(),Te=i("p"),Te.innerHTML=Kt,Vl=n(),we=i("p"),we.innerHTML=Ot,Ql=n(),r(B.$$.fragment),Sl=n(),Ue=i("p"),Ue.innerHTML=es,$l=n(),r(Ze.$$.fragment),Hl=n(),k=i("div"),k.innerHTML=ls,zl=n(),r(je.$$.fragment),Ll=n(),We=i("p"),We.innerHTML=ts,Al=n(),ve=i("p"),ve.textContent=ss,Dl=n(),r(Ce.$$.fragment),ql=n(),_=i("div"),_.innerHTML=ns,Pl=n(),Ie=i("p"),Ie.innerHTML=as,Kl=n(),r(Ge.$$.fragment),Ol=n(),Be=i("p"),Be.textContent=is,et=n(),r(N.$$.fragment),lt=n(),r(ke.$$.fragment),tt=n(),X=i("div"),X.innerHTML=os,st=n(),_e=i("p"),_e.innerHTML=ps,nt=n(),r(Ne.$$.fragment),at=n(),r(Y.$$.fragment),it=n(),r(Xe.$$.fragment),ot=n(),r(x.$$.fragment),pt=n(),Ye=i("p"),Ye.innerHTML=ms,mt=n(),xe=i("ol"),xe.innerHTML=rs,rt=n(),Re=i("p"),Re.textContent=cs,ct=n(),Ee=i("p"),Ee.textContent=ds,dt=n(),r(Fe.$$.fragment),Mt=n(),R=i("div"),R.innerHTML=Ms,ut=n(),Ve=i("p"),Ve.innerHTML=us,yt=n(),r(Qe.$$.fragment),Jt=n(),Se=i("p"),Se.textContent=ys,ht=n(),r($e.$$.fragment),ft=n(),E=i("div"),E.innerHTML=Js,gt=n(),He=i("p"),He.innerHTML=hs,bt=n(),r(ze.$$.fragment),Tt=n(),Le=i("p"),Le.textContent=fs,wt=n(),r(Ae.$$.fragment),Ut=n(),F=i("div"),F.innerHTML=gs,Zt=n(),r(De.$$.fragment),jt=n(),Pe=i("p"),this.h()},l(e){const l=Gs("svelte-u9bgzb",document.head);m=o(l,"META",{name:!0,content:!0}),l.forEach(t),b=a(e),J=o(e,"P",{}),js(J).forEach(t),f=a(e),c(T.$$.fragment,e),h=a(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1ersfq7"&&(w.textContent=vt),el=a(e),c(j.$$.fragment,e),ll=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-r7ehkq"&&(V.textContent=Ct),tl=a(e),Q=o(e,"UL",{"data-svelte-h":!0}),p(Q)!=="svelte-1jzb95l"&&(Q.innerHTML=It),sl=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-10jstxp"&&(S.textContent=Gt),nl=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1rkzg2g"&&($.textContent=Bt),al=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-cwruts"&&(H.textContent=kt),il=a(e),c(z.$$.fragment,e),ol=a(e),c(L.$$.fragment,e),pl=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1cb54q2"&&(A.textContent=_t),ml=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-9znxu8"&&(D.innerHTML=Nt),rl=a(e),c(q.$$.fragment,e),cl=a(e),W=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-1jr9xr4"&&(W.innerHTML=Xt),dl=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-jrmwss"&&(P.innerHTML=Yt),Ml=a(e),c(K.$$.fragment,e),ul=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-17x9oax"&&(O.textContent=xt),yl=a(e),c(ee.$$.fragment,e),Jl=a(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-3r1z1k"&&(v.innerHTML=Rt),hl=a(e),c(le.$$.fragment,e),fl=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-g01jh2"&&(te.textContent=Et),gl=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1rtmh9u"&&(se.innerHTML=Ft),bl=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1xj73ji"&&(ne.innerHTML=Vt),Tl=a(e),c(ae.$$.fragment,e),wl=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1ky74tf"&&(ie.innerHTML=Qt),Ul=a(e),c(oe.$$.fragment,e),Zl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-wyr53z"&&(pe.textContent=St),jl=a(e),c(me.$$.fragment,e),Wl=a(e),C=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(C)!=="svelte-8qhhvs"&&(C.innerHTML=$t),vl=a(e),c(re.$$.fragment,e),Cl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1i60bwf"&&(ce.textContent=Ht),Il=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-175mm0t"&&(de.textContent=zt),Gl=a(e),c(Me.$$.fragment,e),Bl=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-4efl8b"&&(ue.innerHTML=Lt),kl=a(e),c(ye.$$.fragment,e),_l=a(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-grxw51"&&(I.innerHTML=At),Nl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1ehrnc1"&&(Je.innerHTML=Dt),Xl=a(e),c(he.$$.fragment,e),Yl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-118t2qr"&&(fe.textContent=qt),xl=a(e),c(ge.$$.fragment,e),Rl=a(e),G=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-1qk6bz9"&&(G.innerHTML=Pt),El=a(e),c(be.$$.fragment,e),Fl=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-w08m5a"&&(Te.innerHTML=Kt),Vl=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-vnjl1j"&&(we.innerHTML=Ot),Ql=a(e),c(B.$$.fragment,e),Sl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-vqtz65"&&(Ue.innerHTML=es),$l=a(e),c(Ze.$$.fragment,e),Hl=a(e),k=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(k)!=="svelte-1hf21gv"&&(k.innerHTML=ls),zl=a(e),c(je.$$.fragment,e),Ll=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1jgtfzx"&&(We.innerHTML=ts),Al=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-7i5g8g"&&(ve.textContent=ss),Dl=a(e),c(Ce.$$.fragment,e),ql=a(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(_)!=="svelte-j8n5na"&&(_.innerHTML=ns),Pl=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-120t6mc"&&(Ie.innerHTML=as),Kl=a(e),c(Ge.$$.fragment,e),Ol=a(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-172pcgi"&&(Be.textContent=is),et=a(e),c(N.$$.fragment,e),lt=a(e),c(ke.$$.fragment,e),tt=a(e),X=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(X)!=="svelte-8vwtkd"&&(X.innerHTML=os),st=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1us4ne8"&&(_e.innerHTML=ps),nt=a(e),c(Ne.$$.fragment,e),at=a(e),c(Y.$$.fragment,e),it=a(e),c(Xe.$$.fragment,e),ot=a(e),c(x.$$.fragment,e),pt=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1engdvd"&&(Ye.innerHTML=ms),mt=a(e),xe=o(e,"OL",{"data-svelte-h":!0}),p(xe)!=="svelte-18sf1v5"&&(xe.innerHTML=rs),rt=a(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1gpdoop"&&(Re.textContent=cs),ct=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1k4sivd"&&(Ee.textContent=ds),dt=a(e),c(Fe.$$.fragment,e),Mt=a(e),R=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(R)!=="svelte-1cl87j5"&&(R.innerHTML=Ms),ut=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-2v63o"&&(Ve.innerHTML=us),yt=a(e),c(Qe.$$.fragment,e),Jt=a(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-bab8ey"&&(Se.textContent=ys),ht=a(e),c($e.$$.fragment,e),ft=a(e),E=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(E)!=="svelte-1og8gmm"&&(E.innerHTML=Js),gt=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-vj8ihz"&&(He.innerHTML=hs),bt=a(e),c(ze.$$.fragment,e),Tt=a(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-d5aph9"&&(Le.textContent=fs),wt=a(e),c(Ae.$$.fragment,e),Ut=a(e),F=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(F)!=="svelte-1qlyggw"&&(F.innerHTML=gs),Zt=a(e),c(De.$$.fragment,e),jt=a(e),Pe=o(e,"P",{}),js(Pe).forEach(t),this.h()},h(){U(m,"name","hf:doc:metadata"),U(m,"content",Es),U(W,"class","flex gap-4"),U(v,"class","flex justify-center"),U(C,"class","flex gap-4"),U(I,"class","flex gap-4"),U(G,"class","flex justify-center"),U(k,"class","flex gap-4"),U(_,"class","flex gap-4"),U(X,"class","flex justify-center"),U(R,"class","flex gap-4"),U(E,"class","flex gap-4"),U(F,"class","flex justify-center")},m(e,l){Bs(document.head,m),s(e,b,l),s(e,J,l),s(e,f,l),d(T,e,l),s(e,h,l),s(e,w,l),s(e,el,l),d(j,e,l),s(e,ll,l),s(e,V,l),s(e,tl,l),s(e,Q,l),s(e,sl,l),s(e,S,l),s(e,nl,l),s(e,$,l),s(e,al,l),s(e,H,l),s(e,il,l),d(z,e,l),s(e,ol,l),d(L,e,l),s(e,pl,l),s(e,A,l),s(e,ml,l),s(e,D,l),s(e,rl,l),d(q,e,l),s(e,cl,l),s(e,W,l),s(e,dl,l),s(e,P,l),s(e,Ml,l),d(K,e,l),s(e,ul,l),s(e,O,l),s(e,yl,l),d(ee,e,l),s(e,Jl,l),s(e,v,l),s(e,hl,l),d(le,e,l),s(e,fl,l),s(e,te,l),s(e,gl,l),s(e,se,l),s(e,bl,l),s(e,ne,l),s(e,Tl,l),d(ae,e,l),s(e,wl,l),s(e,ie,l),s(e,Ul,l),d(oe,e,l),s(e,Zl,l),s(e,pe,l),s(e,jl,l),d(me,e,l),s(e,Wl,l),s(e,C,l),s(e,vl,l),d(re,e,l),s(e,Cl,l),s(e,ce,l),s(e,Il,l),s(e,de,l),s(e,Gl,l),d(Me,e,l),s(e,Bl,l),s(e,ue,l),s(e,kl,l),d(ye,e,l),s(e,_l,l),s(e,I,l),s(e,Nl,l),s(e,Je,l),s(e,Xl,l),d(he,e,l),s(e,Yl,l),s(e,fe,l),s(e,xl,l),d(ge,e,l),s(e,Rl,l),s(e,G,l),s(e,El,l),d(be,e,l),s(e,Fl,l),s(e,Te,l),s(e,Vl,l),s(e,we,l),s(e,Ql,l),d(B,e,l),s(e,Sl,l),s(e,Ue,l),s(e,$l,l),d(Ze,e,l),s(e,Hl,l),s(e,k,l),s(e,zl,l),d(je,e,l),s(e,Ll,l),s(e,We,l),s(e,Al,l),s(e,ve,l),s(e,Dl,l),d(Ce,e,l),s(e,ql,l),s(e,_,l),s(e,Pl,l),s(e,Ie,l),s(e,Kl,l),d(Ge,e,l),s(e,Ol,l),s(e,Be,l),s(e,et,l),d(N,e,l),s(e,lt,l),d(ke,e,l),s(e,tt,l),s(e,X,l),s(e,st,l),s(e,_e,l),s(e,nt,l),d(Ne,e,l),s(e,at,l),d(Y,e,l),s(e,it,l),d(Xe,e,l),s(e,ot,l),d(x,e,l),s(e,pt,l),s(e,Ye,l),s(e,mt,l),s(e,xe,l),s(e,rt,l),s(e,Re,l),s(e,ct,l),s(e,Ee,l),s(e,dt,l),d(Fe,e,l),s(e,Mt,l),s(e,R,l),s(e,ut,l),s(e,Ve,l),s(e,yt,l),d(Qe,e,l),s(e,Jt,l),s(e,Se,l),s(e,ht,l),d($e,e,l),s(e,ft,l),s(e,E,l),s(e,gt,l),s(e,He,l),s(e,bt,l),d(ze,e,l),s(e,Tt,l),s(e,Le,l),s(e,wt,l),d(Ae,e,l),s(e,Ut,l),s(e,F,l),s(e,Zt,l),d(De,e,l),s(e,jt,l),s(e,Pe,l),Wt=!0},p(e,[l]){const bs={};l&2&&(bs.$$scope={dirty:l,ctx:e}),j.$set(bs);const Ts={};l&2&&(Ts.$$scope={dirty:l,ctx:e}),B.$set(Ts);const ws={};l&2&&(ws.$$scope={dirty:l,ctx:e}),N.$set(ws);const Us={};l&2&&(Us.$$scope={dirty:l,ctx:e}),Y.$set(Us);const Zs={};l&2&&(Zs.$$scope={dirty:l,ctx:e}),x.$set(Zs)},i(e){Wt||(M(T.$$.fragment,e),M(j.$$.fragment,e),M(z.$$.fragment,e),M(L.$$.fragment,e),M(q.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(me.$$.fragment,e),M(re.$$.fragment,e),M(Me.$$.fragment,e),M(ye.$$.fragment,e),M(he.$$.fragment,e),M(ge.$$.fragment,e),M(be.$$.fragment,e),M(B.$$.fragment,e),M(Ze.$$.fragment,e),M(je.$$.fragment,e),M(Ce.$$.fragment,e),M(Ge.$$.fragment,e),M(N.$$.fragment,e),M(ke.$$.fragment,e),M(Ne.$$.fragment,e),M(Y.$$.fragment,e),M(Xe.$$.fragment,e),M(x.$$.fragment,e),M(Fe.$$.fragment,e),M(Qe.$$.fragment,e),M($e.$$.fragment,e),M(ze.$$.fragment,e),M(Ae.$$.fragment,e),M(De.$$.fragment,e),Wt=!0)},o(e){u(T.$$.fragment,e),u(j.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(re.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(be.$$.fragment,e),u(B.$$.fragment,e),u(Ze.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(Ge.$$.fragment,e),u(N.$$.fragment,e),u(ke.$$.fragment,e),u(Ne.$$.fragment,e),u(Y.$$.fragment,e),u(Xe.$$.fragment,e),u(x.$$.fragment,e),u(Fe.$$.fragment,e),u(Qe.$$.fragment,e),u($e.$$.fragment,e),u(ze.$$.fragment,e),u(Ae.$$.fragment,e),u(De.$$.fragment,e),Wt=!1},d(e){e&&(t(b),t(J),t(f),t(h),t(w),t(el),t(ll),t(V),t(tl),t(Q),t(sl),t(S),t(nl),t($),t(al),t(H),t(il),t(ol),t(pl),t(A),t(ml),t(D),t(rl),t(cl),t(W),t(dl),t(P),t(Ml),t(ul),t(O),t(yl),t(Jl),t(v),t(hl),t(fl),t(te),t(gl),t(se),t(bl),t(ne),t(Tl),t(wl),t(ie),t(Ul),t(Zl),t(pe),t(jl),t(Wl),t(C),t(vl),t(Cl),t(ce),t(Il),t(de),t(Gl),t(Bl),t(ue),t(kl),t(_l),t(I),t(Nl),t(Je),t(Xl),t(Yl),t(fe),t(xl),t(Rl),t(G),t(El),t(Fl),t(Te),t(Vl),t(we),t(Ql),t(Sl),t(Ue),t($l),t(Hl),t(k),t(zl),t(Ll),t(We),t(Al),t(ve),t(Dl),t(ql),t(_),t(Pl),t(Ie),t(Kl),t(Ol),t(Be),t(et),t(lt),t(tt),t(X),t(st),t(_e),t(nt),t(at),t(it),t(ot),t(pt),t(Ye),t(mt),t(xe),t(rt),t(Re),t(ct),t(Ee),t(dt),t(Mt),t(R),t(ut),t(Ve),t(yt),t(Jt),t(Se),t(ht),t(ft),t(E),t(gt),t(He),t(bt),t(Tt),t(Le),t(wt),t(Ut),t(F),t(Zt),t(jt),t(Pe)),t(m),y(T,e),y(j,e),y(z,e),y(L,e),y(q,e),y(K,e),y(ee,e),y(le,e),y(ae,e),y(oe,e),y(me,e),y(re,e),y(Me,e),y(ye,e),y(he,e),y(ge,e),y(be,e),y(B,e),y(Ze,e),y(je,e),y(Ce,e),y(Ge,e),y(N,e),y(ke,e),y(Ne,e),y(Y,e),y(Xe,e),y(x,e),y(Fe,e),y(Qe,e),y($e,e),y(ze,e),y(Ae,e),y(De,e)}}}const Es='{"title":"ControlNet","local":"controlnet","sections":[{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Inpainting","local":"inpainting","sections":[],"depth":2},{"title":"Guess mode","local":"guess-mode","sections":[],"depth":2},{"title":"ControlNet with Stable Diffusion XL","local":"controlnet-with-stable-diffusion-xl","sections":[],"depth":2},{"title":"MultiControlNet","local":"multicontrolnet","sections":[],"depth":2}],"depth":1}';function Fs(Z){return vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends Cs{constructor(m){super(),Is(this,m,Fs,Rs,Ws,{})}}export{zs as component};
