import{s as te,n as ae,o as ne}from"../chunks/scheduler.65852ee5.js";import{S as Me,i as pe,g as M,s as a,r as i,A as oe,h as p,f as e,c as n,j as le,u as y,x as o,k as se,y as ie,a as t,v as c,d as J,t as r,w as T}from"../chunks/index.aa74147d.js";import{D as ye,C as u}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as ee,E as ce}from"../chunks/EditOnGithub.4eda6a96.js";function Je(ds){let U,wl,ul,dl,w,jl,d,ml,j,js='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',hl,m,ms='<p>This tutorial is advanced. You should have notions from <a href="advanced_rag">this other cookbook</a> first!</p>',Il,h,hs="<p>Reminder: Retrieval-Augmented-Generation (RAG) is “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”. It has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.</p>",bl,I,Is="But vanilla RAG has limitations, most importantly these two:",gl,b,bs="<li>It <strong>performs only one retrieval step</strong>: if the results are bad, the generation in turn will be bad.</li> <li><strong>Semantic similarity is computed with the <em>user query</em> as a reference</strong>, which might be suboptimal: for instance, the user query will often be a question and the document containing the true answer will be in affirmative voice, so its similarity score will be downgraded compared to other source documents in the interrogative form, leading to a risk of missing the relevant information.</li>",Zl,g,gs="But we can alleviate these problems by making a <strong>RAG agent: very simply, an agent armed with a retriever tool!</strong>",Cl,Z,Zs="This agent will: ✅ Formulate the query itself and ✅ Critique to re-retrieve if needed.",Bl,C,Cs="So it should naively recover some advanced RAG techniques!",fl,B,Bs='<li>Instead of directly using the user query as the reference in semantic search, the agent formulates itself a reference sentence that can be closer to the targeted documents, as in <a href="https://huggingface.co/papers/2212.10496" rel="nofollow">HyDE</a></li> <li>The agent can the generated snippets and re-retrieve if needed, as in <a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">Self-Query</a></li>',Gl,f,fs="Let’s build this system. 🛠️",Nl,G,Gs="Run the line below to install required dependencies:",Vl,N,Wl,V,Ns="We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",vl,W,Rl,v,Vs="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever.",Ql,R,Ws=`We use <a href="https://python.langchain.com/" rel="nofollow">LangChain</a> for its excellent vector database utilities.
For the embedding model, we use <a href="https://huggingface.co/thenlper/gte-small" rel="nofollow">thenlper/gte-small</a> since it performed well in our <code>RAG_evaluation</code> cookbook.`,kl,Q,Xl,k,vs=`Splitting documents...
`,El,X,Rs="Now the database is ready: let’s build our agentic RAG system!",ql,E,Qs="👉 We only need a <code>RetrieverTool</code> that our agent can leverage to retrieve information from the knowledge base.",Yl,q,ks='Since we need to add a vectordb as an attribute of the tool, we cannot simply use the <a href="https://huggingface.co/docs/transformers/main/en/agents#create-a-new-tool" rel="nofollow">simple tool constructor</a> with a <code>@tool</code> decorator: so we will follow the advanced setup highlighted in the <a href="https://huggingface.co/docs/transformers/main/en/agents_advanced#directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub" rel="nofollow">advanced agents documentation</a>.',_l,Y,Hl,_,Xs="Now it’s straightforward to create an agent that leverages this tool!",Sl,H,Es="The agent will need these arguments upon initialization:",Al,S,qs="<li><em><code>tools</code></em>: a list of tools that the agent will be able to call.</li> <li><em><code>llm_engine</code></em>: the LLM that powers the agent.</li>",xl,A,Ys='Our <code>llm_engine</code> must be a callable that takes as input a list of <a href="https://huggingface.co/docs/transformers/main/chat_templating" rel="nofollow">messages</a> and returns text. It also needs to accept a <code>stop_sequences</code> argument that indicates when to stop its generation. For convenience, we directly use the <code>HfEngine</code> class provided in the package to get a LLM engine that calls our <a href="https://huggingface.co/docs/api-inference/en/index" rel="nofollow">Inference API</a>.',zl,x,_s='And we use <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus" rel="nofollow">CohereForAI/c4ai-command-r-plus</a> as the llm engine because:',Fl,z,Hs="<li>It has a long 128k context, which is helpful for processing long source documents</li> <li>It is served for free at all times on HF’s Inference API!</li>",$l,F,Ll,$,Ss="Since we initialized the agent as a <code>ReactJsonAgent</code>, it has been automatically given a default system prompt that tells the LLM engine to process step-by-step and generate tool calls as JSON blobs (you could replace this prompt template with your own as needed).",Kl,L,As="Then when its <code>.run()</code> method is launched, the agent takes care of calling the LLM engine, parsing the tool call JSON blobs and executing these tool calls, all in a loop that ends only when the final answer is provided.",Dl,K,Pl,D,xs="Final output:\nTo push a model to the Hub, use `model.push_to_hub()`.\n",Ol,P,ls,O,zs="Does the agent setup make a better RAG system? Well, let’s comapre it to a standard RAG system using LLM Judge!",ss,ll,Fs='We will use <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-70B-Instruct</a> for evaluation since it’s one of the strongest OS models we tested for LLM judge use cases.',es,sl,ts,el,$s="Before running the test let’s make the agent less verbose.",as,tl,ns,al,Ms,nl,ps,Ml,Ls='The evaluation prompt follows some of the best principles shown in <a href="llm_judge">our llm_judge cookbook</a>: it follows a small integer Likert scale, has clear criteria, and a description for each score.',os,pl,is,ol,ys,il,cs,yl,Ks=`Average score for agentic RAG: 78.5%
`,Js,cl,Ds="<strong>Let us recap: the Agent setup improves scores by 8.5% compared to a standard RAG!</strong> (from 70.0% to 78.5%)",rs,Jl,Ps="This is a great improvement, with a very simple setup 🚀",Ts,rl,Os="(For a baseline, using Llama-3-70B without the knowledge base got 36%)",us,Tl,Us,Ul,ws;return w=new ye({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agent_rag.ipynb"}]}}),d=new ee({props:{title:"Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀",local:"agentic-rag-turbocharge-your-rag-with-query-reformulation-and-self-query-",headingTag:"h1"}}),N=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwYW5kYXMlMjBsYW5nY2hhaW4lMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZmFpc3MtY3B1JTIwJTIydHJhbnNmb3JtZXJzJTVCYWdlbnRzJTVEJTIyJTIwLS11cGdyYWRlJTIwLXE=",highlighted:'!pip install pandas langchain langchain-community sentence-transformers faiss-cpu <span class="hljs-string">&quot;transformers[agents]&quot;</span> --upgrade -q',wrap:!1}}),W=new u({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Q=new u({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwbGFuZ2NoYWluLmRvY3N0b3JlLmRvY3VtZW50JTIwaW1wb3J0JTIwRG9jdW1lbnQlMEFmcm9tJTIwbGFuZ2NoYWluLnRleHRfc3BsaXR0ZXIlMjBpbXBvcnQlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIlMEFmcm9tJTIwbGFuZ2NoYWluLnZlY3RvcnN0b3JlcyUyMGltcG9ydCUyMEZBSVNTJTBBZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkuZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LnZlY3RvcnN0b3Jlcy51dGlscyUyMGltcG9ydCUyMERpc3RhbmNlU3RyYXRlZ3klMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBdGV4dF9zcGxpdHRlciUyMCUzRCUyMFJlY3Vyc2l2ZUNoYXJhY3RlclRleHRTcGxpdHRlci5mcm9tX2h1Z2dpbmdmYWNlX3Rva2VuaXplciglMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0aGVubHBlciUyRmd0ZS1zbWFsbCUyMiklMkMlMEElMjAlMjAlMjAlMjBjaHVua19zaXplJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwY2h1bmtfb3ZlcmxhcCUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwYWRkX3N0YXJ0X2luZGV4JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHN0cmlwX3doaXRlc3BhY2UlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwc2VwYXJhdG9ycyUzRCU1QiUyMiU1Q24lNUNuJTIyJTJDJTIwJTIyJTVDbiUyMiUyQyUyMCUyMi4lMjIlMkMlMjAlMjIlMjAlMjIlMkMlMjAlMjIlMjIlNUQlMkMlMEEpJTBBJTBBJTIzJTIwU3BsaXQlMjBkb2NzJTIwYW5kJTIwa2VlcCUyMG9ubHklMjB1bmlxdWUlMjBvbmVzJTBBcHJpbnQoJTIyU3BsaXR0aW5nJTIwZG9jdW1lbnRzLi4uJTIyKSUwQWRvY3NfcHJvY2Vzc2VkJTIwJTNEJTIwJTVCJTVEJTBBdW5pcXVlX3RleHRzJTIwJTNEJTIwJTdCJTdEJTBBZm9yJTIwZG9jJTIwaW4lMjB0cWRtKHNvdXJjZV9kb2NzKSUzQSUwQSUyMCUyMCUyMCUyMG5ld19kb2NzJTIwJTNEJTIwdGV4dF9zcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoJTVCZG9jJTVEKSUwQSUyMCUyMCUyMCUyMGZvciUyMG5ld19kb2MlMjBpbiUyMG5ld19kb2NzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBuZXdfZG9jLnBhZ2VfY29udGVudCUyMG5vdCUyMGluJTIwdW5pcXVlX3RleHRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdW5pcXVlX3RleHRzJTVCbmV3X2RvYy5wYWdlX2NvbnRlbnQlNUQlMjAlM0QlMjBUcnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9jc19wcm9jZXNzZWQuYXBwZW5kKG5ld19kb2MpJTBBJTBBcHJpbnQoJTIyRW1iZWRkaW5nJTIwZG9jdW1lbnRzLi4uJTIwVGhpcyUyMHNob3VsZCUyMHRha2UlMjBhJTIwZmV3JTIwbWludXRlcyUyMCg1JTIwbWludXRlcyUyMG9uJTIwTWFjQm9vayUyMHdpdGglMjBNMSUyMFBybyklMjIpJTBBZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QlMjJ0aGVubHBlciUyRmd0ZS1zbWFsbCUyMiklMEF2ZWN0b3JkYiUyMCUzRCUyMEZBSVNTLmZyb21fZG9jdW1lbnRzKCUwQSUyMCUyMCUyMCUyMGRvY3VtZW50cyUzRGRvY3NfcHJvY2Vzc2VkJTJDJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nJTNEZW1iZWRkaW5nX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZGlzdGFuY2Vfc3RyYXRlZ3klM0REaXN0YW5jZVN0cmF0ZWd5LkNPU0lORSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy

<span class="hljs-meta">&gt;&gt;&gt; </span>source_docs = [
<span class="hljs-meta">... </span>    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
<span class="hljs-meta">... </span>    AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>),
<span class="hljs-meta">... </span>    chunk_size=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    chunk_overlap=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    add_start_index=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    strip_whitespace=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Split docs and keep only unique ones</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Splitting documents...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>docs_processed = []
<span class="hljs-meta">&gt;&gt;&gt; </span>unique_texts = {}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(source_docs):
<span class="hljs-meta">... </span>    new_docs = text_splitter.split_documents([doc])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> new_doc <span class="hljs-keyword">in</span> new_docs:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> new_doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
<span class="hljs-meta">... </span>            unique_texts[new_doc.page_content] = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>            docs_processed.append(new_doc)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Embedding documents... This should take a few minutes (5 minutes on MacBook with M1 Pro)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vectordb = FAISS.from_documents(
<span class="hljs-meta">... </span>    documents=docs_processed,
<span class="hljs-meta">... </span>    embedding=embedding_model,
<span class="hljs-meta">... </span>    distance_strategy=DistanceStrategy.COSINE,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Y=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Using semantic similarity, retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.vectordb.similarity_search(
            query,
            k=<span class="hljs-number">7</span>,
        )

        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [<span class="hljs-string">f&quot;===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)]
        )`,wrap:!1}}),F=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkFwaUVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtNzBCLUluc3RydWN0JTIyKSUwQSUwQXJldHJpZXZlcl90b29sJTIwJTNEJTIwUmV0cmlldmVyVG9vbCh2ZWN0b3JkYiklMEFhZ2VudCUyMCUzRCUyMFJlYWN0SnNvbkFnZW50KHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSUyQyUyMG1heF9pdGVyYXRpb25zJTNENCUyQyUyMHZlcmJvc2UlM0QyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfApiEngine, ReactJsonAgent

llm_engine = HfApiEngine(<span class="hljs-string">&quot;meta-llama/Llama-3.1-70B-Instruct&quot;</span>)

retriever_tool = RetrieverTool(vectordb)
agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, max_iterations=<span class="hljs-number">4</span>, verbose=<span class="hljs-number">2</span>)`,wrap:!1}}),K=new u({props:{code:"YWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMkhvdyUyMGNhbiUyMEklMjBwdXNoJTIwYSUyMG1vZGVsJTIwdG8lMjB0aGUlMjBIdWIlM0YlMjIpJTBBJTBBcHJpbnQoJTIyRmluYWwlMjBvdXRwdXQlM0ElMjIpJTBBcHJpbnQoYWdlbnRfb3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;How can I push a model to the Hub?&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),P=new ee({props:{title:"Agentic RAG vs. standard RAG",local:"agentic-rag-vs-standard-rag",headingTag:"h2"}}),sl=new u({props:{code:"ZXZhbF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jX3FhX2V2YWwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:'eval_dataset = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc_qa_eval&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)',wrap:!1}}),tl=new u({props:{code:"aW1wb3J0JTIwbG9nZ2luZyUwQSUwQWFnZW50LmxvZ2dlci5zZXRMZXZlbChsb2dnaW5nLldBUk5JTkcp",highlighted:`<span class="hljs-keyword">import</span> logging

agent.logger.setLevel(logging.WARNING)`,wrap:!1}}),al=new u({props:{code:"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",highlighted:`outputs_agentic_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]

    enhanced_question = <span class="hljs-string">f&quot;&quot;&quot;Using the information contained in your knowledge base, which you can access with the &#x27;retriever&#x27; tool,
give a comprehensive answer to the question below.
Respond only to the question asked, response should be concise and relevant to the question.
If you cannot find information, do not give up and try calling your retriever again with different arguments!
Make sure to have covered the question completely by calling the retriever tool several times with semantically different queries.
Your queries should not be questions but affirmative form sentences: e.g. rather than &quot;How do I load a model from the Hub in bf16?&quot;, query should be &quot;load a model from the Hub bf16 weights&quot;.

Question:
<span class="hljs-subst">{question}</span>&quot;&quot;&quot;</span>
    answer = agent.run(enhanced_question)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_agentic_rag.append(results_agentic)`,wrap:!1}}),nl=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQXJlYWRlcl9sbG0lMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTIyQ29oZXJlRm9yQUklMkZjNGFpLWNvbW1hbmQtci1wbHVzJTIyKSUwQSUwQW91dHB1dHNfc3RhbmRhcmRfcmFnJTIwJTNEJTIwJTVCJTVEJTBBJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwdHFkbShldmFsX2RhdGFzZXQpJTNBJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lMjAlM0QlMjBleGFtcGxlJTVCJTIycXVlc3Rpb24lMjIlNUQlMEElMjAlMjAlMjAlMjBjb250ZXh0JTIwJTNEJTIwcmV0cmlldmVyX3Rvb2wocXVlc3Rpb24pJTBBJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwZiUyMiUyMiUyMkdpdmVuJTIwdGhlJTIwcXVlc3Rpb24lMjBhbmQlMjBzdXBwb3J0aW5nJTIwZG9jdW1lbnRzJTIwYmVsb3clMkMlMjBnaXZlJTIwYSUyMGNvbXByZWhlbnNpdmUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLiUwQVJlc3BvbmQlMjBvbmx5JTIwdG8lMjB0aGUlMjBxdWVzdGlvbiUyMGFza2VkJTJDJTIwcmVzcG9uc2UlMjBzaG91bGQlMjBiZSUyMGNvbmNpc2UlMjBhbmQlMjByZWxldmFudCUyMHRvJTIwdGhlJTIwcXVlc3Rpb24uJTBBUHJvdmlkZSUyMHRoZSUyMG51bWJlciUyMG9mJTIwdGhlJTIwc291cmNlJTIwZG9jdW1lbnQlMjB3aGVuJTIwcmVsZXZhbnQuJTBBSWYlMjB5b3UlMjBjYW5ub3QlMjBmaW5kJTIwaW5mb3JtYXRpb24lMkMlMjBkbyUyMG5vdCUyMGdpdmUlMjB1cCUyMGFuZCUyMHRyeSUyMGNhbGxpbmclMjB5b3VyJTIwcmV0cmlldmVyJTIwYWdhaW4lMjB3aXRoJTIwZGlmZmVyZW50JTIwYXJndW1lbnRzISUwQSUwQVF1ZXN0aW9uJTNBJTBBJTdCcXVlc3Rpb24lN0QlMEElMEElN0Jjb250ZXh0JTdEJTBBJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBwcm9tcHQlN0QlNUQlMEElMjAlMjAlMjAlMjBhbnN3ZXIlMjAlM0QlMjByZWFkZXJfbGxtLmNoYXRfY29tcGxldGlvbihtZXNzYWdlcykuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50JTBBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJRdWVzdGlvbiUzQSUyMCU3QnF1ZXN0aW9uJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJBbnN3ZXIlM0ElMjAlN0JhbnN3ZXIlN0QlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZidUcnVlJTIwYW5zd2VyJTNBJTIwJTdCZXhhbXBsZSU1QiUyMmFuc3dlciUyMiU1RCU3RCcpJTBBJTBBJTIwJTIwJTIwJTIwcmVzdWx0c19hZ2VudGljJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRydWVfYW5zd2VyJTIyJTNBJTIwZXhhbXBsZSU1QiUyMmFuc3dlciUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNvdXJjZV9kb2MlMjIlM0ElMjBleGFtcGxlJTVCJTIyc291cmNlX2RvYyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYXRlZF9hbnN3ZXIlMjIlM0ElMjBhbnN3ZXIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjBvdXRwdXRzX3N0YW5kYXJkX3JhZy5hcHBlbmQocmVzdWx0c19hZ2VudGljKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

reader_llm = InferenceClient(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-plus&quot;</span>)

outputs_standard_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]
    context = retriever_tool(question)

    prompt = <span class="hljs-string">f&quot;&quot;&quot;Given the question and supporting documents below, give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If you cannot find information, do not give up and try calling your retriever again with different arguments!

Question:
<span class="hljs-subst">{question}</span>

<span class="hljs-subst">{context}</span>
&quot;&quot;&quot;</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
    answer = reader_llm.chat_completion(messages).choices[<span class="hljs-number">0</span>].message.content

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_standard_rag.append(results_agentic)`,wrap:!1}}),pl=new u({props:{code:"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",highlighted:`EVALUATION_PROMPT = <span class="hljs-string">&quot;&quot;&quot;You are a fair evaluator language model.

You will be given an instruction, a response to evaluate, a reference answer that gets a score of 3, and a score rubric representing a evaluation criteria are given.
1. Write a detailed feedback that assess the quality of the response strictly based on the given score rubric, not evaluating in general.
2. After writing a feedback, write a score that is an integer between 1 and 3. You should refer to the score rubric.
3. The output format should look as follows: \\&quot;Feedback: {{write a feedback for criteria}} [RESULT] {{an integer number between 1 and 3}}\\&quot;
4. Please do not generate any other opening, closing, and explanations. Be sure to include [RESULT] in your output.
5. Do not score conciseness: a correct answer that covers the question should receive max score, even if it contains additional useless information.

The instruction to evaluate:
{instruction}

Response to evaluate:
{response}

Reference Answer (Score 3):
{reference_answer}

Score Rubrics:
[Is the response complete, accurate, and factual based on the reference answer?]
Score 1: The response is completely incomplete, inaccurate, and/or not factual.
Score 2: The response is somewhat complete, accurate, and/or factual.
Score 3: The response is completely complete, accurate, and/or factual.

Feedback:&quot;&quot;&quot;</span>`,wrap:!1}}),ol=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWV2YWx1YXRpb25fY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

evaluation_client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)`,wrap:!1}}),il=new u({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> <span class="hljs-built_in">type</span>, outputs <span class="hljs-keyword">in</span> [
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;agentic&quot;</span>, outputs_agentic_rag),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;standard&quot;</span>, outputs_standard_rag),
<span class="hljs-meta">... </span>]:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> experiment <span class="hljs-keyword">in</span> tqdm(outputs):
<span class="hljs-meta">... </span>        eval_prompt = EVALUATION_PROMPT.<span class="hljs-built_in">format</span>(
<span class="hljs-meta">... </span>            instruction=experiment[<span class="hljs-string">&quot;question&quot;</span>],
<span class="hljs-meta">... </span>            response=experiment[<span class="hljs-string">&quot;generated_answer&quot;</span>],
<span class="hljs-meta">... </span>            reference_answer=experiment[<span class="hljs-string">&quot;true_answer&quot;</span>],
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        messages = [
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a fair evaluator language model.&quot;</span>},
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: eval_prompt},
<span class="hljs-meta">... </span>        ]

<span class="hljs-meta">... </span>        eval_result = evaluation_client.text_generation(eval_prompt, max_new_tokens=<span class="hljs-number">1000</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>            feedback, score = [item.strip() <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> eval_result.split(<span class="hljs-string">&quot;[RESULT]&quot;</span>)]
<span class="hljs-meta">... </span>            experiment[<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>] = score
<span class="hljs-meta">... </span>            experiment[<span class="hljs-string">&quot;eval_feedback_LLM_judge&quot;</span>] = feedback
<span class="hljs-meta">... </span>        <span class="hljs-keyword">except</span>:
<span class="hljs-meta">... </span>            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Parsing failed - output was: <span class="hljs-subst">{eval_result}</span>&quot;</span>)

<span class="hljs-meta">... </span>    results = pd.DataFrame.from_dict(outputs)
<span class="hljs-meta">... </span>    results = results.loc[~results[<span class="hljs-string">&quot;generated_answer&quot;</span>].<span class="hljs-built_in">str</span>.contains(<span class="hljs-string">&quot;Error&quot;</span>)]
<span class="hljs-meta">... </span>    results[<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = results[<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>].fillna(<span class="hljs-number">1</span>).apply(<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">int</span>(x))
<span class="hljs-meta">... </span>    results[<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = (results[<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] - <span class="hljs-number">1</span>) / <span class="hljs-number">2</span>

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Average score for <span class="hljs-subst">{<span class="hljs-built_in">type</span>}</span> RAG: <span class="hljs-subst">{results[<span class="hljs-string">&#x27;eval_score_LLM_judge_int&#x27;</span>].mean()*<span class="hljs-number">100</span>:<span class="hljs-number">.1</span>f}</span>%&quot;</span>)`,wrap:!1}}),Tl=new ce({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_rag.md"}}),{c(){U=M("meta"),wl=a(),ul=M("p"),dl=a(),i(w.$$.fragment),jl=a(),i(d.$$.fragment),ml=a(),j=M("p"),j.innerHTML=js,hl=a(),m=M("blockquote"),m.innerHTML=ms,Il=a(),h=M("blockquote"),h.innerHTML=hs,bl=a(),I=M("p"),I.textContent=Is,gl=a(),b=M("ul"),b.innerHTML=bs,Zl=a(),g=M("p"),g.innerHTML=gs,Cl=a(),Z=M("p"),Z.textContent=Zs,Bl=a(),C=M("p"),C.textContent=Cs,fl=a(),B=M("ul"),B.innerHTML=Bs,Gl=a(),f=M("p"),f.textContent=fs,Nl=a(),G=M("p"),G.textContent=Gs,Vl=a(),i(N.$$.fragment),Wl=a(),V=M("p"),V.innerHTML=Ns,vl=a(),i(W.$$.fragment),Rl=a(),v=M("p"),v.textContent=Vs,Ql=a(),R=M("p"),R.innerHTML=Ws,kl=a(),i(Q.$$.fragment),Xl=a(),k=M("pre"),k.textContent=vs,El=a(),X=M("p"),X.textContent=Rs,ql=a(),E=M("p"),E.innerHTML=Qs,Yl=a(),q=M("p"),q.innerHTML=ks,_l=a(),i(Y.$$.fragment),Hl=a(),_=M("p"),_.textContent=Xs,Sl=a(),H=M("p"),H.textContent=Es,Al=a(),S=M("ul"),S.innerHTML=qs,xl=a(),A=M("p"),A.innerHTML=Ys,zl=a(),x=M("p"),x.innerHTML=_s,Fl=a(),z=M("ul"),z.innerHTML=Hs,$l=a(),i(F.$$.fragment),Ll=a(),$=M("p"),$.innerHTML=Ss,Kl=a(),L=M("p"),L.innerHTML=As,Dl=a(),i(K.$$.fragment),Pl=a(),D=M("pre"),D.textContent=xs,Ol=a(),i(P.$$.fragment),ls=a(),O=M("p"),O.textContent=zs,ss=a(),ll=M("p"),ll.innerHTML=Fs,es=a(),i(sl.$$.fragment),ts=a(),el=M("p"),el.textContent=$s,as=a(),i(tl.$$.fragment),ns=a(),i(al.$$.fragment),Ms=a(),i(nl.$$.fragment),ps=a(),Ml=M("p"),Ml.innerHTML=Ls,os=a(),i(pl.$$.fragment),is=a(),i(ol.$$.fragment),ys=a(),i(il.$$.fragment),cs=a(),yl=M("pre"),yl.textContent=Ks,Js=a(),cl=M("p"),cl.innerHTML=Ds,rs=a(),Jl=M("p"),Jl.textContent=Ps,Ts=a(),rl=M("p"),rl.textContent=Os,us=a(),i(Tl.$$.fragment),Us=a(),Ul=M("p"),this.h()},l(l){const s=oe("svelte-u9bgzb",document.head);U=p(s,"META",{name:!0,content:!0}),s.forEach(e),wl=n(l),ul=p(l,"P",{}),le(ul).forEach(e),dl=n(l),y(w.$$.fragment,l),jl=n(l),y(d.$$.fragment,l),ml=n(l),j=p(l,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1xlqnsv"&&(j.innerHTML=js),hl=n(l),m=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(m)!=="svelte-ut7thx"&&(m.innerHTML=ms),Il=n(l),h=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(h)!=="svelte-1uj6u2q"&&(h.innerHTML=hs),bl=n(l),I=p(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-le6dse"&&(I.textContent=Is),gl=n(l),b=p(l,"UL",{"data-svelte-h":!0}),o(b)!=="svelte-1tet28w"&&(b.innerHTML=bs),Zl=n(l),g=p(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-zgftoz"&&(g.innerHTML=gs),Cl=n(l),Z=p(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1oxrjf8"&&(Z.textContent=Zs),Bl=n(l),C=p(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-i3m4dm"&&(C.textContent=Cs),fl=n(l),B=p(l,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-16julm3"&&(B.innerHTML=Bs),Gl=n(l),f=p(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-18mh92s"&&(f.textContent=fs),Nl=n(l),G=p(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-16cuoal"&&(G.textContent=Gs),Vl=n(l),y(N.$$.fragment,l),Wl=n(l),V=p(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-zy8yuo"&&(V.innerHTML=Ns),vl=n(l),y(W.$$.fragment,l),Rl=n(l),v=p(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-11htfoc"&&(v.textContent=Vs),Ql=n(l),R=p(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-pr8fqf"&&(R.innerHTML=Ws),kl=n(l),y(Q.$$.fragment,l),Xl=n(l),k=p(l,"PRE",{"data-svelte-h":!0}),o(k)!=="svelte-bkjqrc"&&(k.textContent=vs),El=n(l),X=p(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1tpog71"&&(X.textContent=Rs),ql=n(l),E=p(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-675szm"&&(E.innerHTML=Qs),Yl=n(l),q=p(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-yb70ev"&&(q.innerHTML=ks),_l=n(l),y(Y.$$.fragment,l),Hl=n(l),_=p(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1ma3u1b"&&(_.textContent=Xs),Sl=n(l),H=p(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-14g5yev"&&(H.textContent=Es),Al=n(l),S=p(l,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-1pv35c6"&&(S.innerHTML=qs),xl=n(l),A=p(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-kqzwq2"&&(A.innerHTML=Ys),zl=n(l),x=p(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-z1y5zp"&&(x.innerHTML=_s),Fl=n(l),z=p(l,"UL",{"data-svelte-h":!0}),o(z)!=="svelte-38rh7n"&&(z.innerHTML=Hs),$l=n(l),y(F.$$.fragment,l),Ll=n(l),$=p(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-1dmyh52"&&($.innerHTML=Ss),Kl=n(l),L=p(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-143bxk3"&&(L.innerHTML=As),Dl=n(l),y(K.$$.fragment,l),Pl=n(l),D=p(l,"PRE",{"data-svelte-h":!0}),o(D)!=="svelte-1ez4a40"&&(D.textContent=xs),Ol=n(l),y(P.$$.fragment,l),ls=n(l),O=p(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-ch3cxl"&&(O.textContent=zs),ss=n(l),ll=p(l,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-yr66ap"&&(ll.innerHTML=Fs),es=n(l),y(sl.$$.fragment,l),ts=n(l),el=p(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-708yv1"&&(el.textContent=$s),as=n(l),y(tl.$$.fragment,l),ns=n(l),y(al.$$.fragment,l),Ms=n(l),y(nl.$$.fragment,l),ps=n(l),Ml=p(l,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-lt6qr6"&&(Ml.innerHTML=Ls),os=n(l),y(pl.$$.fragment,l),is=n(l),y(ol.$$.fragment,l),ys=n(l),y(il.$$.fragment,l),cs=n(l),yl=p(l,"PRE",{"data-svelte-h":!0}),o(yl)!=="svelte-mnmczc"&&(yl.textContent=Ks),Js=n(l),cl=p(l,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-19t4l39"&&(cl.innerHTML=Ds),rs=n(l),Jl=p(l,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-1fi7cw9"&&(Jl.textContent=Ps),Ts=n(l),rl=p(l,"P",{"data-svelte-h":!0}),o(rl)!=="svelte-1y4e8t1"&&(rl.textContent=Os),us=n(l),y(Tl.$$.fragment,l),Us=n(l),Ul=p(l,"P",{}),le(Ul).forEach(e),this.h()},h(){se(U,"name","hf:doc:metadata"),se(U,"content",re)},m(l,s){ie(document.head,U),t(l,wl,s),t(l,ul,s),t(l,dl,s),c(w,l,s),t(l,jl,s),c(d,l,s),t(l,ml,s),t(l,j,s),t(l,hl,s),t(l,m,s),t(l,Il,s),t(l,h,s),t(l,bl,s),t(l,I,s),t(l,gl,s),t(l,b,s),t(l,Zl,s),t(l,g,s),t(l,Cl,s),t(l,Z,s),t(l,Bl,s),t(l,C,s),t(l,fl,s),t(l,B,s),t(l,Gl,s),t(l,f,s),t(l,Nl,s),t(l,G,s),t(l,Vl,s),c(N,l,s),t(l,Wl,s),t(l,V,s),t(l,vl,s),c(W,l,s),t(l,Rl,s),t(l,v,s),t(l,Ql,s),t(l,R,s),t(l,kl,s),c(Q,l,s),t(l,Xl,s),t(l,k,s),t(l,El,s),t(l,X,s),t(l,ql,s),t(l,E,s),t(l,Yl,s),t(l,q,s),t(l,_l,s),c(Y,l,s),t(l,Hl,s),t(l,_,s),t(l,Sl,s),t(l,H,s),t(l,Al,s),t(l,S,s),t(l,xl,s),t(l,A,s),t(l,zl,s),t(l,x,s),t(l,Fl,s),t(l,z,s),t(l,$l,s),c(F,l,s),t(l,Ll,s),t(l,$,s),t(l,Kl,s),t(l,L,s),t(l,Dl,s),c(K,l,s),t(l,Pl,s),t(l,D,s),t(l,Ol,s),c(P,l,s),t(l,ls,s),t(l,O,s),t(l,ss,s),t(l,ll,s),t(l,es,s),c(sl,l,s),t(l,ts,s),t(l,el,s),t(l,as,s),c(tl,l,s),t(l,ns,s),c(al,l,s),t(l,Ms,s),c(nl,l,s),t(l,ps,s),t(l,Ml,s),t(l,os,s),c(pl,l,s),t(l,is,s),c(ol,l,s),t(l,ys,s),c(il,l,s),t(l,cs,s),t(l,yl,s),t(l,Js,s),t(l,cl,s),t(l,rs,s),t(l,Jl,s),t(l,Ts,s),t(l,rl,s),t(l,us,s),c(Tl,l,s),t(l,Us,s),t(l,Ul,s),ws=!0},p:ae,i(l){ws||(J(w.$$.fragment,l),J(d.$$.fragment,l),J(N.$$.fragment,l),J(W.$$.fragment,l),J(Q.$$.fragment,l),J(Y.$$.fragment,l),J(F.$$.fragment,l),J(K.$$.fragment,l),J(P.$$.fragment,l),J(sl.$$.fragment,l),J(tl.$$.fragment,l),J(al.$$.fragment,l),J(nl.$$.fragment,l),J(pl.$$.fragment,l),J(ol.$$.fragment,l),J(il.$$.fragment,l),J(Tl.$$.fragment,l),ws=!0)},o(l){r(w.$$.fragment,l),r(d.$$.fragment,l),r(N.$$.fragment,l),r(W.$$.fragment,l),r(Q.$$.fragment,l),r(Y.$$.fragment,l),r(F.$$.fragment,l),r(K.$$.fragment,l),r(P.$$.fragment,l),r(sl.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(nl.$$.fragment,l),r(pl.$$.fragment,l),r(ol.$$.fragment,l),r(il.$$.fragment,l),r(Tl.$$.fragment,l),ws=!1},d(l){l&&(e(wl),e(ul),e(dl),e(jl),e(ml),e(j),e(hl),e(m),e(Il),e(h),e(bl),e(I),e(gl),e(b),e(Zl),e(g),e(Cl),e(Z),e(Bl),e(C),e(fl),e(B),e(Gl),e(f),e(Nl),e(G),e(Vl),e(Wl),e(V),e(vl),e(Rl),e(v),e(Ql),e(R),e(kl),e(Xl),e(k),e(El),e(X),e(ql),e(E),e(Yl),e(q),e(_l),e(Hl),e(_),e(Sl),e(H),e(Al),e(S),e(xl),e(A),e(zl),e(x),e(Fl),e(z),e($l),e(Ll),e($),e(Kl),e(L),e(Dl),e(Pl),e(D),e(Ol),e(ls),e(O),e(ss),e(ll),e(es),e(ts),e(el),e(as),e(ns),e(Ms),e(ps),e(Ml),e(os),e(is),e(ys),e(cs),e(yl),e(Js),e(cl),e(rs),e(Jl),e(Ts),e(rl),e(us),e(Us),e(Ul)),e(U),T(w,l),T(d,l),T(N,l),T(W,l),T(Q,l),T(Y,l),T(F,l),T(K,l),T(P,l),T(sl,l),T(tl,l),T(al,l),T(nl,l),T(pl,l),T(ol,l),T(il,l),T(Tl,l)}}}const re='{"title":"Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀","local":"agentic-rag-turbocharge-your-rag-with-query-reformulation-and-self-query-","sections":[{"title":"Agentic RAG vs. standard RAG","local":"agentic-rag-vs-standard-rag","sections":[],"depth":2}],"depth":1}';function Te(ds){return ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class je extends Me{constructor(U){super(),pe(this,U,Te,Je,te,{})}}export{je as component};
