import{s as Tn,f as pn,n as wn,o as cn}from"../chunks/scheduler.39a43cde.js";import{S as un,i as rn,g as M,s as n,r as i,A as dn,h as y,f as e,c as a,j as jn,u as o,x as U,k as os,y as mn,a as t,v as J,d as p,t as j,w as T}from"../chunks/index.23ec2204.js";import{D as hn,C as w}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as c}from"../chunks/Heading.c42e7061.js";function In(Ut){let u,js,Js,Ts,d,ws,m,cs,h,it='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',us,I,ot="This notebook demonstrates how you can evaluate your RAG (Retrieval Augmented Generation), by building a synthetic evaluation dataset and using LLM-as-a-judge to compute the accuracy of your system.",rs,b,Jt='For an introduction to RAG, you can check <a href="rag_zephyr_langchain">this other cookbook</a>!',ds,C,pt="RAG systems are complex: here a RAG diagram, where we noted in blue all possibilities for system enhancement:",ms,Z,jt,hs,G,Tt=`Implementing any of these improvements can bring a huge performance boost; but changing anything is useless if you cannot monitor the impact of your changes on the system’s performance!
So let’s see how to evaluate our RAG system.`,Is,B,bs,g,wt="Since there are so many moving parts to tune with a big impact on performance, benchmarking the RAG system is crucial.",Cs,V,ct="For our evaluation pipeline, we will need:",Zs,f,ut="<li>An evaluation dataset with question - answer couples (QA couples)</li> <li>An evaluator to compute the accuracy of our system on the above evaluation dataset.</li>",Gs,W,rt="➡️ It turns out, we can use LLMs to help us all along the way!",Bs,A,dt='<li>The evaluation dataset will be synthetically generated by an LLM 🤖, and questions will be filtered out by other LLMs 🤖</li> <li>An <a href="https://huggingface.co/papers/2306.05685" rel="nofollow">LLM-as-a-judge</a> agent 🤖 will then perform the evaluation on this synthetic dataset.</li>',gs,R,mt="<strong>Let’s dig into it and start building our evaluation pipeline!</strong> First, we install the required model dependancies.",Vs,Q,fs,v,Ws,X,As,k,Rs,N,Qs,E,vs,_,ht="We first build a synthetic dataset of questions and associated contexts. The method is to get elements from our knowledge base, and ask an LLM to generate questions based on these documents.",Xs,q,It="Then we setup other LLM agents to act as quality filters for the generated QA couples: each of them will act as the filter for a specific flaw.",ks,F,Ns,S,Es,Y,_s,z,bt='We use <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">Mixtral</a> for QA couple generation because it it has excellent performance in leaderboards such as <a href="https://huggingface.co/spaces/lmsys/chatbot-arena-leaderboard" rel="nofollow">Chatbot Arena</a>.',qs,x,Fs,H,Ss,$,Ys,L,Ct=`Now let’s generate our QA couples.
For this example, we generate only 10 QA couples and will load the rest from the Hub.`,zs,D,Zt="But for your specific knowledge base, given that you want to get at least ~100 test samples, and accounting for the fact that we will filter out around half of these with our critique agents later on, you should generate much more, in the >200 samples.",xs,K,Hs,P,$s,O,Ls,ll,Gt="The questions generated by the previous agent can have many flaws: we should do a quality check before validating these questions.",Ds,sl,Bt='We thus build critique agents that will rate each question on several criteria, given in <a href="https://huggingface.co/papers/2312.10003" rel="nofollow">this paper</a>:',Ks,el,gt="<li><strong>Groundedness:</strong> can the question be answered from the given context?</li> <li><strong>Relevance:</strong> is the question relevant to users? For instance, <code>&quot;What is the date when transformers 4.29.1 was released?&quot;</code> is not relevant for ML practicioners.</li>",Ps,tl,Vt=`One last failure case we’ve noticed is when a function is tailored for the particular setting where the question was generated, but undecipherable by itself, like <code>&quot;What is the name of the function used in this guide?&quot;</code>.
We also build a critique agent for this criteria:`,Os,nl,ft="<li><strong>Stand-alone</strong>: is the question understandable free of any context, for someone with domain knowledge/Internet access? The opposite of this would be <code>What is the function used in this article?</code> for a question generated from a specific blog article.</li>",le,al,Wt="We systematically score functions with all these agents, and whenever the score is too low for any one of the agents, we eliminate the question from our eval dataset.",se,Ml,At="💡 <strong><em>When asking the agents to output a score, we first ask them to produce its rationale. This will help us verify scores, but most importantly, asking it to first output rationale gives the model more tokens to think and elaborate an answer before summarizing it into a single score token.</em></strong>",ee,yl,Rt="We now build and run these critique agents.",te,Ul,ne,il,ae,ol,Qt="Now let us filter out bad questions based on our critique agent scores:",Me,Jl,ye,pl,vt=`Evaluation dataset before filtering:
`,Ue,jl,Xt="Now our synthetic evaluation dataset is complete! We can evaluate different RAG systems on this evaluation dataset.",ie,Tl,kt="We have generated only a few QA couples here to reduce time and cost. But let’s kick start the next part by loading a pre-generated dataset:",oe,wl,Je,cl,pe,ul,je,rl,Nt="<li>In this part, <strong>we split the documents from our knowledge base into smaller chunks</strong>: these will be the snippets that are picked by the Retriever, to then be ingested by the Reader LLM as supporting elements for its answer.</li> <li>The goal is to build semantically relevant snippets: not too small to be sufficient for supporting an answer, and not too large too avoid diluting individual ideas.</li>",Te,dl,Et="Many options exist for text splitting:",we,ml,_t="<li>split every <code>n</code> words / characters, but this has the risk of cutting in half paragraphs or even sentences</li> <li>split after <code>n</code> words / character, but only on sentence boundaries</li> <li><strong>recursive split</strong> tries to preserve even more of the document structure, by processing it tree-like way, splitting first on the largest units (chapters) then recursively splitting on smaller units (paragraphs, sentences).</li>",ce,hl,qt='To learn more about chunking, I recommend you read <a href="https://github.com/FullStackRetrieval-com/RetrievalTutorials/blob/main/5_Levels_Of_Text_Splitting.ipynb" rel="nofollow">this great notebook</a> by Greg Kamradt.',ue,Il,Ft='<a href="https://huggingface.co/spaces/m-ric/chunk_visualizer" rel="nofollow">This space</a> lets you visualize how different splitting options affect the chunks you get.',re,bl,St="<p>In the following, we use Langchain’s <code>RecursiveCharacterTextSplitter</code>.</p>",de,Cl,Yt="💡 <em>To measure chunk length in our Text Splitter, our length function will not be the count of characters, but the count of tokens in the tokenized text: indeed, for subsequent embedder that processes token, measuring length in tokens is more relevant and empirically performs better.</em>",me,Zl,he,Gl,Ie,Bl,be,gl,zt="The <strong>retriever acts like an internal search engine</strong>: given the user query, it returns the most relevant documents from your knowledge base.",Ce,Vl,xt='<p>For the knowledge base, we use Langchain vector databases since <strong>it offers a convenient <a href="https://github.com/facebookresearch/faiss" rel="nofollow">FAISS</a> index and allows us to keep document metadata throughout the processing</strong>.</p>',Ze,fl,Ht="🛠️ <strong>Options included:</strong>",Ge,Wl,$t='<li>Tune the chunking method:<ul><li>Size of the chunks</li> <li>Method: split on different separators, use <a href="https://python.langchain.com/docs/modules/data_connection/document_transformers/semantic-chunker" rel="nofollow">semantic chunking</a>…</li></ul></li> <li>Change the embedding model</li>',Be,Al,ge,Rl,Ve,Ql,Lt="In this part, the <strong>LLM Reader reads the retrieved documents to formulate its answer.</strong>",fe,vl,Dt="🛠️ Here we tried the following options to improve results:",We,Xl,Kt="<li>Switch reranking on/off</li> <li>Change the reader model</li>",Ae,kl,Re,Nl,Qe,El,ve,_l,Xe,ql,Pt="The RAG system and the evaluation datasets are now ready. The last step is to judge the RAG system’s output on this evlauation dataset.",ke,Fl,Ot="To this end, <strong>we setup a judge agent</strong>. ⚖️🤖",Ne,Sl,ln='Out of <a href="https://docs.ragas.io/en/latest/concepts/metrics/index.html" rel="nofollow">the different RAG evaluation metrics</a>, we choose to focus only on faithfulness since it the best end-to-end metric of our system’s performance.',Ee,Yl,sn='<p>We use GPT4 as a judge for its empirically good performance, but you could try with other models such as <a href="https://huggingface.co/kaist-ai/prometheus-13b-v1.0" rel="nofollow">kaist-ai/prometheus-13b-v1.0</a> or <a href="https://huggingface.co/BAAI/JudgeLM-33B-v1.0" rel="nofollow">BAAI/JudgeLM-33B-v1.0</a>.</p>',_e,zl,en='💡 <em>In the evaluation prompt, we give a detailed description each metric on the scale 1-5, as is done in <a href="https://huggingface.co/kaist-ai/prometheus-13b-v1.0" rel="nofollow">Prometheus’s prompt template</a>: this helps the model ground its metric precisely. If instead you give the judge LLM a vague scale to work with, the outputs will not be consistent enough between different examples.</em>',qe,xl,tn="💡 <em>Again, prompting the LLM to output rationale before giving its final score gives it more tokens to help it formalize and elaborate a judgement.</em>",Fe,Hl,Se,$l,Ye,Ll,ze,Dl,nn="🚀 Let’s run the tests and evaluate answers!👇",xe,Kl,He,Pl,$e,Ol,Le,ls,De,ss,Ke,es,Pe,ts,an=`Let us load the results that I obtained by tweaking the different options available in this notebook.
For more detail on why these options could work on not, see the notebook on <a href="advanced_rag">advanced_RAG</a>.`,Oe,ns,Mn="As you can see in the graph below, some tweaks do not bring any improvement, some give huge performance boosts.",lt,as,yn="➡️ <strong><em>There is no single good recipe: you should try several different directions when tuning your RAG systems.</em></strong>",st,Ms,et,ys,tt,r,Un,nt,Us,on="As you can see, these had varying impact on performance. In particular, tuning the chunk size is both easy and very impactful.",at,is,Jn="But this is our case: your results could be very different: now that you have a robust evaluation pipeline, you can set on to explore other options! 🗺️",Mt,ps,yt;return d=new hn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_evaluation.ipynb"}]}}),m=new c({props:{title:"RAG Evaluation",local:"rag-evaluation",headingTag:"h1"}}),B=new c({props:{title:"Evaluating RAG performance",local:"evaluating-rag-performance",headingTag:"h3"}}),Q=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwdHJhbnNmb3JtZXJzJTIwbGFuZ2NoYWluJTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZmFpc3MtZ3B1JTIwb3BlbnB5eGwlMjBvcGVuYWk=",highlighted:"!pip install -q torch transformers transformers langchain sentence-transformers faiss-gpu openpyxl openai",wrap:!1}}),v=new w({props:{code:"JTI1cmVsb2FkX2V4dCUyMGF1dG9yZWxvYWQlMEElMjVhdXRvcmVsb2FkJTIwMiUwQSUyNXJlbG9hZF9leHQlMjBkb3RlbnYlMEElMjVkb3RlbnY=",highlighted:`%reload_ext autoreload
%autoreload <span class="hljs-number">2</span>
%reload_ext dotenv
%dotenv`,wrap:!1}}),X=new w({props:{code:"ZnJvbSUyMHRxZG0ubm90ZWJvb2slMjBpbXBvcnQlMjB0cWRtJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBPcHRpb25hbCUyQyUyMExpc3QlMkMlMjBUdXBsZSUwQWZyb20lMjBsYW5nY2hhaW5fY29yZS5sYW5ndWFnZV9tb2RlbHMlMjBpbXBvcnQlMjBCYXNlQ2hhdE1vZGVsJTBBaW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMGRhdGFzZXRzJTBBJTBBcGQuc2V0X29wdGlvbiglMjJkaXNwbGF5Lm1heF9jb2x3aWR0aCUyMiUyQyUyME5vbmUp",highlighted:`<span class="hljs-keyword">from</span> tqdm.notebook <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Tuple</span>
<span class="hljs-keyword">from</span> langchain_core.language_models <span class="hljs-keyword">import</span> BaseChatModel
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> datasets

pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)`,wrap:!1}}),k=new c({props:{title:"Load your knowledge base",local:"load-your-knowledge-base",headingTag:"h3"}}),N=new w({props:{code:"ZHMlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIybS1yaWMlMkZodWdnaW5nZmFjZV9kb2MlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:'ds = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)',wrap:!1}}),E=new c({props:{title:"1. Build a synthetic dataset for evaluation",local:"1-build-a-synthetic-dataset-for-evaluation",headingTag:"h1"}}),F=new c({props:{title:"1.1. Prepare source documents",local:"11-prepare-source-documents",headingTag:"h3"}}),S=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTIwYXMlMjBMYW5nY2hhaW5Eb2N1bWVudCUwQSUwQWxhbmdjaGFpbl9kb2NzJTIwJTNEJTIwJTVCTGFuZ2NoYWluRG9jdW1lbnQocGFnZV9jb250ZW50JTNEZG9jJTVCJTIydGV4dCUyMiU1RCUyQyUyMG1ldGFkYXRhJTNEJTdCJTIyc291cmNlJTIyJTNBJTIwZG9jJTVCJTIyc291cmNlJTIyJTVEJTdEKSUyMGZvciUyMGRvYyUyMGluJTIwdHFkbShkcyklNUQlMEElMEElMEF0ZXh0X3NwbGl0dGVyJTIwJTNEJTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyKCUwQSUyMCUyMCUyMCUyMGNodW5rX3NpemUlM0QyMDAwJTJDJTBBJTIwJTIwJTIwJTIwY2h1bmtfb3ZlcmxhcCUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMGFkZF9zdGFydF9pbmRleCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzZXBhcmF0b3JzJTNEJTVCJTIyJTVDbiU1Q24lMjIlMkMlMjAlMjIlNUNuJTIyJTJDJTIwJTIyLiUyMiUyQyUyMCUyMiUyMCUyMiUyQyUyMCUyMiUyMiU1RCUyQyUwQSklMEElMEFkb2NzX3Byb2Nlc3NlZCUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMGRvYyUyMGluJTIwbGFuZ2NoYWluX2RvY3MlM0ElMEElMjAlMjAlMjAlMjBkb2NzX3Byb2Nlc3NlZCUyMCUyQiUzRCUyMHRleHRfc3BsaXR0ZXIuc3BsaXRfZG9jdW1lbnRzKCU1QmRvYyU1RCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document <span class="hljs-keyword">as</span> LangchainDocument

langchain_docs = [LangchainDocument(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(ds)]


text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">2000</span>,
    chunk_overlap=<span class="hljs-number">200</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)

docs_processed = []
<span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> langchain_docs:
    docs_processed += text_splitter.split_documents([doc])`,wrap:!1}}),Y=new c({props:{title:"1.2. Setup agents for question generation",local:"12-setup-agents-for-question-generation",headingTag:"h3"}}),x=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkubGxtcyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlSHViJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTBBJTBBbGxtJTIwJTNEJTIwSHVnZ2luZ0ZhY2VIdWIoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMEElMjAlMjAlMjAlMjB0YXNrJTNEJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfa3dhcmdzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjA1MTIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3BfayUyMiUzQSUyMDMwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXBldGl0aW9uX3BlbmFsdHklMjIlM0ElMjAxLjAzJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_community.llms <span class="hljs-keyword">import</span> HuggingFaceHub

repo_id = <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>

llm = HuggingFaceHub(
    repo_id=repo_id,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    model_kwargs={
        <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>,
        <span class="hljs-string">&quot;top_k&quot;</span>: <span class="hljs-number">30</span>,
        <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.1</span>,
        <span class="hljs-string">&quot;repetition_penalty&quot;</span>: <span class="hljs-number">1.03</span>,
    },
)`,wrap:!1}}),H=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkuY2hhdF9tb2RlbHMlMjBpbXBvcnQlMjBDaGF0SHVnZ2luZ0ZhY2UlMEElMEFjaGF0X21vZGVsJTIwJTNEJTIwQ2hhdEh1Z2dpbmdGYWNlKGxsbSUzRGxsbSk=",highlighted:`<span class="hljs-keyword">from</span> langchain_community.chat_models <span class="hljs-keyword">import</span> ChatHuggingFace

chat_model = ChatHuggingFace(llm=llm)`,wrap:!1}}),$=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5wcm9tcHRzJTIwaW1wb3J0JTIwQ2hhdFByb21wdFRlbXBsYXRlJTBBJTBBUUFfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFZb3VyJTIwdGFzayUyMGlzJTIwdG8lMjB3cml0ZSUyMGElMjBmYWN0b2lkJTIwcXVlc3Rpb24lMjBhbmQlMjBhbiUyMGFuc3dlciUyMGdpdmVuJTIwYSUyMGNvbnRleHQuJTBBWW91ciUyMGZhY3RvaWQlMjBxdWVzdGlvbiUyMHNob3VsZCUyMGJlJTIwYW5zd2VyYWJsZSUyMHdpdGglMjBhJTIwc3BlY2lmaWMlMkMlMjBjb25jaXNlJTIwcGllY2UlMjBvZiUyMGZhY3R1YWwlMjBpbmZvcm1hdGlvbiUyMGZyb20lMjB0aGUlMjBjb250ZXh0LiUwQVlvdXIlMjBmYWN0b2lkJTIwcXVlc3Rpb24lMjBzaG91bGQlMjBiZSUyMGZvcm11bGF0ZWQlMjBpbiUyMHRoZSUyMHNhbWUlMjBzdHlsZSUyMGFzJTIwcXVlc3Rpb25zJTIwdXNlcnMlMjBjb3VsZCUyMGFzayUyMGluJTIwYSUyMHNlYXJjaCUyMGVuZ2luZS4lMEFUaGlzJTIwbWVhbnMlMjB0aGF0JTIweW91ciUyMGZhY3RvaWQlMjBxdWVzdGlvbiUyME1VU1QlMjBOT1QlMjBtZW50aW9uJTIwc29tZXRoaW5nJTIwbGlrZSUyMCUyMmFjY29yZGluZyUyMHRvJTIwdGhlJTIwcGFzc2FnZSUyMiUyMG9yJTIwJTIyY29udGV4dCUyMi4lMEElMEFQcm92aWRlJTIweW91ciUyMGFuc3dlciUyMGFzJTIwZm9sbG93cyUzQSUwQSUwQU91dHB1dCUzQSUzQSUzQSUwQUZhY3RvaWQlMjBxdWVzdGlvbiUzQSUyMCh5b3VyJTIwZmFjdG9pZCUyMHF1ZXN0aW9uKSUwQUFuc3dlciUzQSUyMCh5b3VyJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjBmYWN0b2lkJTIwcXVlc3Rpb24pJTBBJTBBTm93JTIwaGVyZSUyMGlzJTIwdGhlJTIwY29udGV4dC4lMEElMEFDb250ZXh0JTNBJTIwJTdCY29udGV4dCU3RCU1Q24lMEFPdXRwdXQlM0ElM0ElM0ElMjIlMjIlMjIlMEElMEFRQV9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMENoYXRQcm9tcHRUZW1wbGF0ZS5mcm9tX3RlbXBsYXRlKFFBX2dlbmVyYXRpb25fcHJvbXB0KSUwQVFBX2dlbmVyYXRpb25fYWdlbnQlMjAlM0QlMjBRQV9nZW5lcmF0aW9uX3Byb21wdCUyMCU3QyUyMGNoYXRfbW9kZWw=",highlighted:`<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> ChatPromptTemplate

QA_generation_prompt = <span class="hljs-string">&quot;&quot;&quot;
Your task is to write a factoid question and an answer given a context.
Your factoid question should be answerable with a specific, concise piece of factual information from the context.
Your factoid question should be formulated in the same style as questions users could ask in a search engine.
This means that your factoid question MUST NOT mention something like &quot;according to the passage&quot; or &quot;context&quot;.

Provide your answer as follows:

Output:::
Factoid question: (your factoid question)
Answer: (your answer to the factoid question)

Now here is the context.

Context: {context}\\n
Output:::&quot;&quot;&quot;</span>

QA_generation_prompt = ChatPromptTemplate.from_template(QA_generation_prompt)
QA_generation_agent = QA_generation_prompt | chat_model`,wrap:!1}}),K=new w({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBJTBBTl9HRU5FUkFUSU9OUyUyMCUzRCUyMDEwJTIwJTIwJTIzJTIwV2UlMjBpbnRlbnRpb25hbGx5JTIwZ2VuZXJhdGUlMjBvbmx5JTIwMTAlMjBRQSUyMGNvdXBsZXMlMjBoZXJlJTIwZm9yJTIwY29zdCUyMGFuZCUyMHRpbWUlMjBjb25zaWRlcmF0aW9ucyUwQSUwQXByaW50KGYlMjJHZW5lcmF0aW5nJTIwJTdCTl9HRU5FUkFUSU9OUyU3RCUyMFFBJTIwY291cGxlcy4uLiUyMiklMEFvdXRwdXRzJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwY29udGV4dCUyMGluJTIwdHFkbShyYW5kb20uc2FtcGxlKGxhbmdjaGFpbl9kb2NzJTJDJTIwTl9HRU5FUkFUSU9OUykpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2VuZXJhdGUlMjBRQSUyMGNvdXBsZSUwQSUyMCUyMCUyMCUyMG91dHB1dF9RQV9jb3VwbGUlMjAlM0QlMjBRQV9nZW5lcmF0aW9uX2FnZW50Lmludm9rZSglN0IlMjJjb250ZXh0JTIyJTNBJTIwY29udGV4dC5wYWdlX2NvbnRlbnQlN0QpLmNvbnRlbnQlMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVzdGlvbiUyMCUzRCUyMG91dHB1dF9RQV9jb3VwbGUuc3BsaXQoJTIyRmFjdG9pZCUyMHF1ZXN0aW9uJTNBJTIwJTIyKSU1QjElNUQuc3BsaXQoJTIyQW5zd2VyJTNBJTIwJTIyKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbnN3ZXIlMjAlM0QlMjBvdXRwdXRfUUFfY291cGxlLnNwbGl0KCUyMkFuc3dlciUzQSUyMCUyMiklNUIxJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cy5hcHBlbmQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMGNvbnRleHQucGFnZV9jb250ZW50JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFuc3dlciUyMiUzQSUyMGFuc3dlciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNvdXJjZV9kb2MlMjIlM0ElMjBjb250ZXh0Lm1ldGFkYXRhJTVCJTIyc291cmNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVl",highlighted:`<span class="hljs-keyword">import</span> random

N_GENERATIONS = <span class="hljs-number">10</span>  <span class="hljs-comment"># We intentionally generate only 10 QA couples here for cost and time considerations</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generating <span class="hljs-subst">{N_GENERATIONS}</span> QA couples...&quot;</span>)
outputs = []
<span class="hljs-keyword">for</span> context <span class="hljs-keyword">in</span> tqdm(random.sample(langchain_docs, N_GENERATIONS)):
    <span class="hljs-comment"># Generate QA couple</span>
    output_QA_couple = QA_generation_agent.invoke({<span class="hljs-string">&quot;context&quot;</span>: context.page_content}).content
    <span class="hljs-keyword">try</span>:
        question = output_QA_couple.split(<span class="hljs-string">&quot;Factoid question: &quot;</span>)[<span class="hljs-number">1</span>].split(<span class="hljs-string">&quot;Answer: &quot;</span>)[<span class="hljs-number">0</span>]
        answer = output_QA_couple.split(<span class="hljs-string">&quot;Answer: &quot;</span>)[<span class="hljs-number">1</span>]
        outputs.append(
            {
                <span class="hljs-string">&quot;context&quot;</span>: context.page_content,
                <span class="hljs-string">&quot;question&quot;</span>: question,
                <span class="hljs-string">&quot;answer&quot;</span>: answer,
                <span class="hljs-string">&quot;source_doc&quot;</span>: context.metadata[<span class="hljs-string">&quot;source&quot;</span>],
            }
        )
    <span class="hljs-keyword">except</span>:
        <span class="hljs-keyword">continue</span>`,wrap:!1}}),P=new w({props:{code:"ZGlzcGxheShwZC5EYXRhRnJhbWUob3V0cHV0cykuaGVhZCgxKSk=",highlighted:'display(pd.DataFrame(outputs).head(<span class="hljs-number">1</span>))',wrap:!1}}),O=new c({props:{title:"1.3. Setup critique agents",local:"13-setup-critique-agents",headingTag:"h3"}}),Ul=new w({props:{code:"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",highlighted:`question_groundedness_critique_prompt = <span class="hljs-string">&quot;&quot;&quot;
You will be given a context and a question.
Your task is to provide a &#x27;total rating&#x27; scoring how well one can answer the given question unambiguously with the given context.
Give your answer on a scale of 1 to 5, where 1 means that the question is not answerable at all given the context, and 5 means that the question is clearly and unambiguously answerable with the context.

Provide your answer as follows:

Answer:::
Evaluation: (your rationale for the rating)
Total rating: (your rating)

Now here are the question and context.

Question: {question}\\n
Context: {context}\\n
Answer::: &quot;&quot;&quot;</span>

question_relevance_critique_prompt = <span class="hljs-string">&quot;&quot;&quot;
You will be given a question.
Your task is to provide a &#x27;total rating&#x27; representing how useful this question can be to machine learning developers building NLP applications with the Hugging Face ecosystem.
Give your answer on a scale of 1 to 5, where 1 means that the question is not useful at all, and 5 means that the question is extremely useful.

Provide your answer as follows:

Answer:::
Evaluation: (your rationale for the rating)
Total rating: (your rating)

Now here is the question.

Question: {question}\\n
Answer::: &quot;&quot;&quot;</span>

question_standalone_critique_prompt = <span class="hljs-string">&quot;&quot;&quot;
You will be given a question.
Your task is to provide a &#x27;total rating&#x27; representing how context-independant this question is.
Give your answer on a scale of 1 to 5, where 1 means that the question only makes sense in a specific context, and 5 means that the question makes sense by itself.
For instance, if the question refers to a particular setting, like &#x27;in the context&#x27; or &#x27;in the document&#x27;, the rating must be 1.
The questions can contain obscure technical nouns or acronyms like Gradio, Hub, Hugging Face or Space and still be a 5: it must simply be clear to an operator with access to documentation what the question is about.

Provide your answer as follows:

Answer:::
Evaluation: (your rationale for the rating)
Total rating: (your rating)

Now here is the question.

Question: {question}\\n
Answer::: &quot;&quot;&quot;</span>

question_groundedness_critique_prompt = ChatPromptTemplate.from_template(question_groundedness_critique_prompt)
question_groundedness_critique_agent = question_groundedness_critique_prompt | chat_model

question_relevance_critique_prompt = ChatPromptTemplate.from_template(question_relevance_critique_prompt)
question_relevance_critique_agent = question_relevance_critique_prompt | chat_model

question_standalone_critique_prompt = ChatPromptTemplate.from_template(question_standalone_critique_prompt)
question_standalone_critique_agent = question_standalone_critique_prompt | chat_model`,wrap:!1}}),il=new w({props:{code:"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",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Generating critique for each QA couple...&quot;</span>)
<span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> tqdm(outputs):
    <span class="hljs-comment"># Critique the generated QA couple</span>
    question_groundedness_evaluation = question_groundedness_critique_agent.invoke(
        {<span class="hljs-string">&quot;context&quot;</span>: output[<span class="hljs-string">&quot;context&quot;</span>], <span class="hljs-string">&quot;question&quot;</span>: output[<span class="hljs-string">&quot;question&quot;</span>]}
    ).content
    question_relevance_evaluation = question_relevance_critique_agent.invoke({<span class="hljs-string">&quot;question&quot;</span>: output[<span class="hljs-string">&quot;question&quot;</span>]}).content
    question_standalone_evaluation = question_standalone_critique_agent.invoke(
        {<span class="hljs-string">&quot;question&quot;</span>: output[<span class="hljs-string">&quot;question&quot;</span>]}
    ).content

    <span class="hljs-keyword">try</span>:
        groundedness_score = <span class="hljs-built_in">int</span>(question_groundedness_evaluation.split(<span class="hljs-string">&quot;Total rating: &quot;</span>)[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>])
        groundedness_eval = question_groundedness_evaluation.split(<span class="hljs-string">&quot;Total rating: &quot;</span>)[<span class="hljs-number">0</span>].split(<span class="hljs-string">&quot;Evaluation: &quot;</span>)[<span class="hljs-number">1</span>]
        relevance_score = <span class="hljs-built_in">int</span>(question_relevance_evaluation.split(<span class="hljs-string">&quot;Total rating: &quot;</span>)[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>])
        relevance_eval = question_relevance_evaluation.split(<span class="hljs-string">&quot;Total rating: &quot;</span>)[<span class="hljs-number">0</span>].split(<span class="hljs-string">&quot;Evaluation: &quot;</span>)[<span class="hljs-number">1</span>]
        standalone_score = <span class="hljs-built_in">int</span>(question_standalone_evaluation.split(<span class="hljs-string">&quot;Total rating: &quot;</span>)[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>])
        standalone_eval = question_standalone_evaluation.split(<span class="hljs-string">&quot;Total rating: &quot;</span>)[<span class="hljs-number">0</span>].split(<span class="hljs-string">&quot;Evaluation: &quot;</span>)[<span class="hljs-number">1</span>]
        output.update(
            {
                <span class="hljs-string">&quot;groundedness_score&quot;</span>: groundedness_score,
                <span class="hljs-string">&quot;groundedness_eval&quot;</span>: groundedness_eval,
                <span class="hljs-string">&quot;relevance_score&quot;</span>: relevance_score,
                <span class="hljs-string">&quot;relevance_eval&quot;</span>: relevance_eval,
                <span class="hljs-string">&quot;standalone_score&quot;</span>: standalone_score,
                <span class="hljs-string">&quot;standalone_eval&quot;</span>: standalone_eval,
            }
        )
    <span class="hljs-keyword">except</span>:
        <span class="hljs-keyword">continue</span>`,wrap:!1}}),Jl=new w({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXBkLnNldF9vcHRpb24oJTIyZGlzcGxheS5tYXhfY29sd2lkdGglMjIlMkMlMjBOb25lKSUwQSUwQWdlbmVyYXRlZF9xdWVzdGlvbnMlMjAlM0QlMjBwZC5EYXRhRnJhbWUuZnJvbV9kaWN0KG91dHB1dHMpJTBBJTBBcHJpbnQoJTIyRXZhbHVhdGlvbiUyMGRhdGFzZXQlMjBiZWZvcmUlMjBmaWx0ZXJpbmclM0ElMjIpJTBBZGlzcGxheShnZW5lcmF0ZWRfcXVlc3Rpb25zJTVCJTVCJTIycXVlc3Rpb24lMjIlMkMlMjAlMjJhbnN3ZXIlMjIlMkMlMjAlMjJncm91bmRlZG5lc3Nfc2NvcmUlMjIlMkMlMjAlMjJyZWxldmFuY2Vfc2NvcmUlMjIlMkMlMjAlMjJzdGFuZGFsb25lX3Njb3JlJTIyJTVEJTVEKSUwQWdlbmVyYXRlZF9xdWVzdGlvbnMlMjAlM0QlMjBnZW5lcmF0ZWRfcXVlc3Rpb25zLmxvYyU1QiUwQSUyMCUyMCUyMCUyMChnZW5lcmF0ZWRfcXVlc3Rpb25zJTVCJTIyZ3JvdW5kZWRuZXNzX3Njb3JlJTIyJTVEJTIwJTNFJTNEJTIwNCklMEElMjAlMjAlMjAlMjAlMjYlMjAoZ2VuZXJhdGVkX3F1ZXN0aW9ucyU1QiUyMnJlbGV2YW5jZV9zY29yZSUyMiU1RCUyMCUzRSUzRCUyMDQpJTBBJTIwJTIwJTIwJTIwJTI2JTIwKGdlbmVyYXRlZF9xdWVzdGlvbnMlNUIlMjJzdGFuZGFsb25lX3Njb3JlJTIyJTVEJTIwJTNFJTNEJTIwNCklMEElNUQlMEFwcmludCglMjIlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMjIpJTBBcHJpbnQoJTIyRmluYWwlMjBldmFsdWF0aW9uJTIwZGF0YXNldCUzQSUyMiklMEFkaXNwbGF5KGdlbmVyYXRlZF9xdWVzdGlvbnMlNUIlNUIlMjJxdWVzdGlvbiUyMiUyQyUyMCUyMmFuc3dlciUyMiUyQyUyMCUyMmdyb3VuZGVkbmVzc19zY29yZSUyMiUyQyUyMCUyMnJlbGV2YW5jZV9zY29yZSUyMiUyQyUyMCUyMnN0YW5kYWxvbmVfc2NvcmUlMjIlNUQlNUQpJTBBJTBBZXZhbF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMuRGF0YXNldC5mcm9tX3BhbmRhcyhnZW5lcmF0ZWRfcXVlc3Rpb25zJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHByZXNlcnZlX2luZGV4JTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_questions = pd.DataFrame.from_dict(outputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Evaluation dataset before filtering:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>display(generated_questions[[<span class="hljs-string">&quot;question&quot;</span>, <span class="hljs-string">&quot;answer&quot;</span>, <span class="hljs-string">&quot;groundedness_score&quot;</span>, <span class="hljs-string">&quot;relevance_score&quot;</span>, <span class="hljs-string">&quot;standalone_score&quot;</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_questions = generated_questions.loc[
<span class="hljs-meta">... </span>    (generated_questions[<span class="hljs-string">&quot;groundedness_score&quot;</span>] &gt;= <span class="hljs-number">4</span>)
<span class="hljs-meta">... </span>    &amp; (generated_questions[<span class="hljs-string">&quot;relevance_score&quot;</span>] &gt;= <span class="hljs-number">4</span>)
<span class="hljs-meta">... </span>    &amp; (generated_questions[<span class="hljs-string">&quot;standalone_score&quot;</span>] &gt;= <span class="hljs-number">4</span>)
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;============================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final evaluation dataset:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>display(generated_questions[[<span class="hljs-string">&quot;question&quot;</span>, <span class="hljs-string">&quot;answer&quot;</span>, <span class="hljs-string">&quot;groundedness_score&quot;</span>, <span class="hljs-string">&quot;relevance_score&quot;</span>, <span class="hljs-string">&quot;standalone_score&quot;</span>]])

<span class="hljs-meta">&gt;&gt;&gt; </span>eval_dataset = datasets.Dataset.from_pandas(generated_questions, split=<span class="hljs-string">&quot;train&quot;</span>, preserve_index=<span class="hljs-literal">False</span>)`,wrap:!1}}),wl=new w({props:{code:"ZXZhbF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jX3FhX2V2YWwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:'eval_dataset = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc_qa_eval&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)',wrap:!1}}),cl=new c({props:{title:"2. Build our RAG System",local:"2-build-our-rag-system",headingTag:"h1"}}),ul=new c({props:{title:"2.1. Preprocessing documents to build our vector database",local:"21-preprocessing-documents-to-build-our-vector-database",headingTag:"h3"}}),Zl=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTIwYXMlMjBMYW5nY2hhaW5Eb2N1bWVudCUwQSUwQVJBV19LTk9XTEVER0VfQkFTRSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMExhbmdjaGFpbkRvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMHRxZG0oZHMpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document <span class="hljs-keyword">as</span> LangchainDocument

RAW_KNOWLEDGE_BASE = [
    LangchainDocument(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(ds)
]`,wrap:!1}}),Gl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer


<span class="hljs-keyword">def</span> <span class="hljs-title function_">split_documents</span>(<span class="hljs-params">
    chunk_size: <span class="hljs-built_in">int</span>,
    knowledge_base: <span class="hljs-type">List</span>[LangchainDocument],
    tokenizer_name: <span class="hljs-built_in">str</span>,
</span>) -&gt; <span class="hljs-type">List</span>[LangchainDocument]:
    <span class="hljs-string">&quot;&quot;&quot;
    Split documents into chunks of size \`chunk_size\` characters and return a list of documents.
    &quot;&quot;&quot;</span>
    text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
        AutoTokenizer.from_pretrained(tokenizer_name),
        chunk_size=chunk_size,
        chunk_overlap=<span class="hljs-built_in">int</span>(chunk_size / <span class="hljs-number">10</span>),
        add_start_index=<span class="hljs-literal">True</span>,
        strip_whitespace=<span class="hljs-literal">True</span>,
        separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
    )

    docs_processed = []
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base:
        docs_processed += text_splitter.split_documents([doc])

    <span class="hljs-comment"># Remove duplicates</span>
    unique_texts = {}
    docs_processed_unique = []
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed:
        <span class="hljs-keyword">if</span> doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
            unique_texts[doc.page_content] = <span class="hljs-literal">True</span>
            docs_processed_unique.append(doc)

    <span class="hljs-keyword">return</span> docs_processed_unique`,wrap:!1}}),Bl=new c({props:{title:"2.2. Retriever - embeddings 🗂️",local:"22-retriever---embeddings-",headingTag:"h3"}}),Al=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy
<span class="hljs-keyword">import</span> os


<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_embeddings</span>(<span class="hljs-params">
    langchain_docs: <span class="hljs-type">List</span>[LangchainDocument],
    chunk_size: <span class="hljs-built_in">int</span>,
    embedding_model_name: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = <span class="hljs-string">&quot;thenlper/gte-small&quot;</span>,
</span>) -&gt; FAISS:
    <span class="hljs-string">&quot;&quot;&quot;
    Creates a FAISS index from the given embedding model and documents. Loads the index directly if it already exists.

    Args:
        langchain_docs: list of documents
        chunk_size: size of the chunks to split the documents into
        embedding_model_name: name of the embedding model to use

    Returns:
        FAISS index
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># load embedding_model</span>
    embedding_model = HuggingFaceEmbeddings(
        model_name=embedding_model_name,
        multi_process=<span class="hljs-literal">True</span>,
        model_kwargs={<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cuda&quot;</span>},
        encode_kwargs={<span class="hljs-string">&quot;normalize_embeddings&quot;</span>: <span class="hljs-literal">True</span>},  <span class="hljs-comment"># set True to compute cosine similarity</span>
    )

    <span class="hljs-comment"># Check if embeddings already exist on disk</span>
    index_name = <span class="hljs-string">f&quot;index_chunk:<span class="hljs-subst">{chunk_size}</span>_embeddings:<span class="hljs-subst">{embedding_model_name.replace(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-string">&#x27;~&#x27;</span>)}</span>&quot;</span>
    index_folder_path = <span class="hljs-string">f&quot;./data/indexes/<span class="hljs-subst">{index_name}</span>/&quot;</span>
    <span class="hljs-keyword">if</span> os.path.isdir(index_folder_path):
        <span class="hljs-keyword">return</span> FAISS.load_local(
            index_folder_path,
            embedding_model,
            distance_strategy=DistanceStrategy.COSINE,
        )

    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Index not found, generating it...&quot;</span>)
        docs_processed = split_documents(
            chunk_size,
            langchain_docs,
            embedding_model_name,
        )
        knowledge_index = FAISS.from_documents(
            docs_processed, embedding_model, distance_strategy=DistanceStrategy.COSINE
        )
        knowledge_index.save_local(index_folder_path)
        <span class="hljs-keyword">return</span> knowledge_index`,wrap:!1}}),Rl=new c({props:{title:"2.3. Reader - LLM 💬",local:"23-reader---llm-",headingTag:"h3"}}),kl=new w({props:{code:"UkFHX1BST01QVF9URU1QTEFURSUyMCUzRCUyMCUyMiUyMiUyMiUwQSUzQyU3Q3N5c3RlbSU3QyUzRSUwQVVzaW5nJTIwdGhlJTIwaW5mb3JtYXRpb24lMjBjb250YWluZWQlMjBpbiUyMHRoZSUyMGNvbnRleHQlMkMlMEFnaXZlJTIwYSUyMGNvbXByZWhlbnNpdmUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLiUwQVJlc3BvbmQlMjBvbmx5JTIwdG8lMjB0aGUlMjBxdWVzdGlvbiUyMGFza2VkJTJDJTIwcmVzcG9uc2UlMjBzaG91bGQlMjBiZSUyMGNvbmNpc2UlMjBhbmQlMjByZWxldmFudCUyMHRvJTIwdGhlJTIwcXVlc3Rpb24uJTBBUHJvdmlkZSUyMHRoZSUyMG51bWJlciUyMG9mJTIwdGhlJTIwc291cmNlJTIwZG9jdW1lbnQlMjB3aGVuJTIwcmVsZXZhbnQuJTBBSWYlMjB0aGUlMjBhbnN3ZXIlMjBjYW5ub3QlMjBiZSUyMGRlZHVjZWQlMjBmcm9tJTIwdGhlJTIwY29udGV4dCUyQyUyMGRvJTIwbm90JTIwZ2l2ZSUyMGFuJTIwYW5zd2VyLiUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBQ29udGV4dCUzQSUwQSU3QmNvbnRleHQlN0QlMEEtLS0lMEFOb3clMjBoZXJlJTIwaXMlMjB0aGUlMjBxdWVzdGlvbiUyMHlvdSUyMG5lZWQlMjB0byUyMGFuc3dlci4lMEElMEFRdWVzdGlvbiUzQSUyMCU3QnF1ZXN0aW9uJTdEJTBBJTNDJTJGcyUzRSUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`RAG_PROMPT_TEMPLATE = <span class="hljs-string">&quot;&quot;&quot;
&lt;|system|&gt;
Using the information contained in the context,
give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If the answer cannot be deduced from the context, do not give an answer.&lt;/s&gt;
&lt;|user|&gt;
Context:
{context}
---
Now here is the question you need to answer.

Question: {question}
&lt;/s&gt;
&lt;|assistant|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),Nl=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkubGxtcyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlSHViJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiUwQVJFQURFUl9NT0RFTF9OQU1FJTIwJTNEJTIwJTIyemVwaHlyLTdiLWJldGElMjIlMEElMEFSRUFERVJfTExNJTIwJTNEJTIwSHVnZ2luZ0ZhY2VIdWIoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMEElMjAlMjAlMjAlMjB0YXNrJTNEJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfa3dhcmdzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjA1MTIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3BfayUyMiUzQSUyMDMwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXBldGl0aW9uX3BlbmFsdHklMjIlM0ElMjAxLjAzJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_community.llms <span class="hljs-keyword">import</span> HuggingFaceHub

repo_id = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
READER_MODEL_NAME = <span class="hljs-string">&quot;zephyr-7b-beta&quot;</span>

READER_LLM = HuggingFaceHub(
    repo_id=repo_id,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    model_kwargs={
        <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>,
        <span class="hljs-string">&quot;top_k&quot;</span>: <span class="hljs-number">30</span>,
        <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.1</span>,
        <span class="hljs-string">&quot;repetition_penalty&quot;</span>: <span class="hljs-number">1.03</span>,
    },
)`,wrap:!1}}),El=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> ragatouille <span class="hljs-keyword">import</span> RAGPretrainedModel
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore
<span class="hljs-keyword">from</span> langchain_core.language_models.llms <span class="hljs-keyword">import</span> LLM


<span class="hljs-keyword">def</span> <span class="hljs-title function_">answer_with_rag</span>(<span class="hljs-params">
    question: <span class="hljs-built_in">str</span>,
    llm: LLM,
    knowledge_index: VectorStore,
    reranker: <span class="hljs-type">Optional</span>[RAGPretrainedModel] = <span class="hljs-literal">None</span>,
    num_retrieved_docs: <span class="hljs-built_in">int</span> = <span class="hljs-number">30</span>,
    num_docs_final: <span class="hljs-built_in">int</span> = <span class="hljs-number">7</span>,
</span>) -&gt; <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">List</span>[LangchainDocument]]:
    <span class="hljs-string">&quot;&quot;&quot;Answer a question using RAG with the given knowledge index.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Gather documents with retriever</span>
    relevant_docs = knowledge_index.similarity_search(query=question, k=num_retrieved_docs)
    relevant_docs = [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]  <span class="hljs-comment"># keep only the text</span>

    <span class="hljs-comment"># Optionally rerank results</span>
    <span class="hljs-keyword">if</span> reranker:
        relevant_docs = reranker.rerank(question, relevant_docs, k=num_docs_final)
        relevant_docs = [doc[<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]

    relevant_docs = relevant_docs[:num_docs_final]

    <span class="hljs-comment"># Build the final prompt</span>
    context = <span class="hljs-string">&quot;\\nExtracted documents:\\n&quot;</span>
    context += <span class="hljs-string">&quot;&quot;</span>.join([<span class="hljs-string">f&quot;Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span>:::\\n&quot;</span> + doc <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(relevant_docs)])

    final_prompt = RAG_PROMPT_TEMPLATE.<span class="hljs-built_in">format</span>(question=question, context=context)

    <span class="hljs-comment"># Redact an answer</span>
    answer = llm(final_prompt)

    <span class="hljs-keyword">return</span> answer, relevant_docs`,wrap:!1}}),_l=new c({props:{title:"3. Benchmarking the RAG system",local:"3-benchmarking-the-rag-system",headingTag:"h1"}}),Hl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_rag_tests</span>(<span class="hljs-params">
    eval_dataset: datasets.Dataset,
    llm: BaseChatModel,
    knowledge_index: VectorStore,
    output_file: <span class="hljs-built_in">str</span>,
    reranker: <span class="hljs-type">Optional</span>[RAGPretrainedModel] = <span class="hljs-literal">None</span>,
    verbose: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">True</span>,
    test_settings: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = <span class="hljs-literal">None</span>,  <span class="hljs-comment"># To document the test settings used</span>
</span>):
    <span class="hljs-string">&quot;&quot;&quot;Runs RAG tests on the given dataset and saves the results to the given output file.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:  <span class="hljs-comment"># load previous generations if they exist</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(output_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            outputs = json.load(f)
    <span class="hljs-keyword">except</span>:
        outputs = []

    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
        question = example[<span class="hljs-string">&quot;question&quot;</span>]
        <span class="hljs-keyword">if</span> question <span class="hljs-keyword">in</span> [output[<span class="hljs-string">&quot;question&quot;</span>] <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> outputs]:
            <span class="hljs-keyword">continue</span>

        answer, relevant_docs = answer_with_rag(question, llm, knowledge_index, reranker=reranker)
        <span class="hljs-keyword">if</span> verbose:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)
        result = {
            <span class="hljs-string">&quot;question&quot;</span>: question,
            <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
            <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
            <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
            <span class="hljs-string">&quot;retrieved_docs&quot;</span>: [doc <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs],
        }
        <span class="hljs-keyword">if</span> test_settings:
            result[<span class="hljs-string">&quot;test_settings&quot;</span>] = test_settings
        outputs.append(result)

        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(output_file, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
            json.dump(outputs, f)`,wrap:!1}}),$l=new w({props:{code:"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",highlighted:`EVALUATION_PROMPT = <span class="hljs-string">&quot;&quot;&quot;###Task Description:
An instruction (might include an Input inside it), a response to evaluate, a reference answer that gets a score of 5, and a score rubric representing a evaluation criteria are given.
1. Write a detailed feedback that assess the quality of the response strictly based on the given score rubric, not evaluating in general.
2. After writing a feedback, write a score that is an integer between 1 and 5. You should refer to the score rubric.
3. The output format should look as follows: \\&quot;Feedback: {{write a feedback for criteria}} [RESULT] {{an integer number between 1 and 5}}\\&quot;
4. Please do not generate any other opening, closing, and explanations. Be sure to include [RESULT] in your output.

###The instruction to evaluate:
{instruction}

###Response to evaluate:
{response}

###Reference Answer (Score 5):
{reference_answer}

###Score Rubrics:
[Is the response correct, accurate, and factual based on the reference answer?]
Score 1: The response is completely incorrect, inaccurate, and/or not factual.
Score 2: The response is mostly incorrect, inaccurate, and/or not factual.
Score 3: The response is somewhat correct, accurate, and/or factual.
Score 4: The response is mostly correct, accurate, and factual.
Score 5: The response is completely correct, accurate, and factual.

###Feedback:&quot;&quot;&quot;</span>

<span class="hljs-keyword">from</span> langchain.prompts.chat <span class="hljs-keyword">import</span> (
    ChatPromptTemplate,
    HumanMessagePromptTemplate,
)
<span class="hljs-keyword">from</span> langchain.schema <span class="hljs-keyword">import</span> SystemMessage


evaluation_prompt_template = ChatPromptTemplate.from_messages(
    [
        SystemMessage(content=<span class="hljs-string">&quot;You are a fair evaluator language model.&quot;</span>),
        HumanMessagePromptTemplate.from_template(EVALUATION_PROMPT),
    ]
)`,wrap:!1}}),Ll=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.chat_models <span class="hljs-keyword">import</span> ChatOpenAI

eval_chat_model = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4-1106-preview&quot;</span>, temperature=<span class="hljs-number">0</span>)
evaluator_name = <span class="hljs-string">&quot;GPT4&quot;</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate_answers</span>(<span class="hljs-params">
    answer_path: <span class="hljs-built_in">str</span>,
    eval_chat_model: BaseChatModel,
    evaluator_name: <span class="hljs-built_in">str</span>,
    evaluation_prompt_template: ChatPromptTemplate,
</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;Evaluates generated answers. Modifies the given answer file in place for better checkpointing.&quot;&quot;&quot;</span>
    answers = []
    <span class="hljs-keyword">if</span> os.path.isfile(answer_path):  <span class="hljs-comment"># load previous generations if they exist</span>
        answers = json.load(<span class="hljs-built_in">open</span>(answer_path, <span class="hljs-string">&quot;r&quot;</span>))

    <span class="hljs-keyword">for</span> experiment <span class="hljs-keyword">in</span> tqdm(answers):
        <span class="hljs-keyword">if</span> <span class="hljs-string">f&quot;eval_score_<span class="hljs-subst">{evaluator_name}</span>&quot;</span> <span class="hljs-keyword">in</span> experiment:
            <span class="hljs-keyword">continue</span>

        eval_prompt = evaluation_prompt_template.format_messages(
            instruction=experiment[<span class="hljs-string">&quot;question&quot;</span>],
            response=experiment[<span class="hljs-string">&quot;generated_answer&quot;</span>],
            reference_answer=experiment[<span class="hljs-string">&quot;true_answer&quot;</span>],
        )
        eval_result = eval_chat_model.invoke(eval_prompt)
        feedback, score = [item.strip() <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> eval_result.content.split(<span class="hljs-string">&quot;[RESULT]&quot;</span>)]
        experiment[<span class="hljs-string">f&quot;eval_score_<span class="hljs-subst">{evaluator_name}</span>&quot;</span>] = score
        experiment[<span class="hljs-string">f&quot;eval_feedback_<span class="hljs-subst">{evaluator_name}</span>&quot;</span>] = feedback

        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(answer_path, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
            json.dump(answers, f)`,wrap:!1}}),Kl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(<span class="hljs-string">&quot;./output&quot;</span>):
    os.mkdir(<span class="hljs-string">&quot;./output&quot;</span>)

<span class="hljs-keyword">for</span> chunk_size <span class="hljs-keyword">in</span> [<span class="hljs-number">200</span>]:  <span class="hljs-comment"># Add other chunk sizes (in tokens) as needed</span>
    <span class="hljs-keyword">for</span> embeddings <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>]:  <span class="hljs-comment"># Add other embeddings as needed</span>
        <span class="hljs-keyword">for</span> rerank <span class="hljs-keyword">in</span> [<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>]:
            settings_name = <span class="hljs-string">f&quot;chunk:<span class="hljs-subst">{chunk_size}</span>_embeddings:<span class="hljs-subst">{embeddings.replace(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-string">&#x27;~&#x27;</span>)}</span>_rerank:<span class="hljs-subst">{rerank}</span>_reader-model:<span class="hljs-subst">{READER_MODEL_NAME}</span>&quot;</span>
            output_file_name = <span class="hljs-string">f&quot;./output/rag_<span class="hljs-subst">{settings_name}</span>.json&quot;</span>

            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Running evaluation for <span class="hljs-subst">{settings_name}</span>:&quot;</span>)

            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading knowledge base embeddings...&quot;</span>)
            knowledge_index = load_embeddings(
                RAW_KNOWLEDGE_BASE,
                chunk_size=chunk_size,
                embedding_model_name=embeddings,
            )

            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running RAG...&quot;</span>)
            reranker = RAGPretrainedModel.from_pretrained(<span class="hljs-string">&quot;colbert-ir/colbertv2.0&quot;</span>) <span class="hljs-keyword">if</span> rerank <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
            run_rag_tests(
                eval_dataset=eval_dataset,
                llm=READER_LLM,
                knowledge_index=knowledge_index,
                output_file=output_file_name,
                reranker=reranker,
                verbose=<span class="hljs-literal">False</span>,
                test_settings=settings_name,
            )

            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running evaluation...&quot;</span>)
            evaluate_answers(
                output_file_name,
                eval_chat_model,
                evaluator_name,
                evaluation_prompt_template,
            )`,wrap:!1}}),Pl=new c({props:{title:"Inspect results",local:"inspect-results",headingTag:"h3"}}),Ol=new w({props:{code:"aW1wb3J0JTIwZ2xvYiUwQSUwQW91dHB1dHMlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBmaWxlJTIwaW4lMjBnbG9iLmdsb2IoJTIyLiUyRm91dHB1dCUyRiouanNvbiUyMiklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBwZC5EYXRhRnJhbWUoanNvbi5sb2FkKG9wZW4oZmlsZSUyQyUyMCUyMnIlMjIpKSklMEElMjAlMjAlMjAlMjBvdXRwdXQlNUIlMjJzZXR0aW5ncyUyMiU1RCUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBvdXRwdXRzLmFwcGVuZChvdXRwdXQpJTBBcmVzdWx0JTIwJTNEJTIwcGQuY29uY2F0KG91dHB1dHMp",highlighted:`<span class="hljs-keyword">import</span> glob

outputs = []
<span class="hljs-keyword">for</span> file <span class="hljs-keyword">in</span> glob.glob(<span class="hljs-string">&quot;./output/*.json&quot;</span>):
    output = pd.DataFrame(json.load(<span class="hljs-built_in">open</span>(file, <span class="hljs-string">&quot;r&quot;</span>)))
    output[<span class="hljs-string">&quot;settings&quot;</span>] = file
    outputs.append(output)
result = pd.concat(outputs)`,wrap:!1}}),ls=new w({props:{code:"cmVzdWx0JTVCJTIyZXZhbF9zY29yZV9HUFQ0JTIyJTVEJTIwJTNEJTIwcmVzdWx0JTVCJTIyZXZhbF9zY29yZV9HUFQ0JTIyJTVELmFwcGx5KGxhbWJkYSUyMHglM0ElMjBpbnQoeCklMjBpZiUyMGlzaW5zdGFuY2UoeCUyQyUyMHN0ciklMjBlbHNlJTIwMSklMEFyZXN1bHQlNUIlMjJldmFsX3Njb3JlX0dQVDQlMjIlNUQlMjAlM0QlMjAocmVzdWx0JTVCJTIyZXZhbF9zY29yZV9HUFQ0JTIyJTVEJTIwLSUyMDEpJTIwJTJGJTIwNA==",highlighted:`result[<span class="hljs-string">&quot;eval_score_GPT4&quot;</span>] = result[<span class="hljs-string">&quot;eval_score_GPT4&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">int</span>(x) <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(x, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">else</span> <span class="hljs-number">1</span>)
result[<span class="hljs-string">&quot;eval_score_GPT4&quot;</span>] = (result[<span class="hljs-string">&quot;eval_score_GPT4&quot;</span>] - <span class="hljs-number">1</span>) / <span class="hljs-number">4</span>`,wrap:!1}}),ss=new w({props:{code:"YXZlcmFnZV9zY29yZXMlMjAlM0QlMjByZXN1bHQuZ3JvdXBieSglMjJzZXR0aW5ncyUyMiklNUIlMjJldmFsX3Njb3JlX0dQVDQlMjIlNUQubWVhbigpJTBBYXZlcmFnZV9zY29yZXMuc29ydF92YWx1ZXMoKQ==",highlighted:`average_scores = result.groupby(<span class="hljs-string">&quot;settings&quot;</span>)[<span class="hljs-string">&quot;eval_score_GPT4&quot;</span>].mean()
average_scores.sort_values()`,wrap:!1}}),es=new c({props:{title:"Example results",local:"example-results",headingTag:"h2"}}),Ms=new w({props:{code:"aW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBJTBBc2NvcmVzJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGcmFnX3Njb3Jlc19jb29rYm9vayUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBc2NvcmVzJTIwJTNEJTIwcGQuU2VyaWVzKHNjb3JlcyU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwaW5kZXglM0RzY29yZXMlNUIlMjJzZXR0aW5ncyUyMiU1RCk=",highlighted:`<span class="hljs-keyword">import</span> plotly.express <span class="hljs-keyword">as</span> px

scores = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/rag_scores_cookbook&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
scores = pd.Series(scores[<span class="hljs-string">&quot;score&quot;</span>], index=scores[<span class="hljs-string">&quot;settings&quot;</span>])`,wrap:!1}}),ys=new w({props:{code:"ZmlnJTIwJTNEJTIwcHguYmFyKCUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyQyUwQSUyMCUyMCUyMCUyMGNvbG9yJTNEc2NvcmVzJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmFsdWUlMjIlM0ElMjAlMjJBY2N1cmFjeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNldHRpbmdzJTIyJTNBJTIwJTIyQ29uZmlndXJhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGNvbG9yX2NvbnRpbnVvdXNfc2NhbGUlM0QlMjJibHVlcmVkJTIyJTJDJTBBKSUwQWZpZy51cGRhdGVfbGF5b3V0KHclMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q2MDAlMkMlMEElMjAlMjAlMjAlMjBiYXJtb2RlJTNEJTIyZ3JvdXAlMjIlMkMlMEElMjAlMjAlMjAlMjB5YXhpc19yYW5nZSUzRCU1QjAlMkMlMjAxMDAlNUQlMkMlMEElMjAlMjAlMjAlMjB0aXRsZSUzRCUyMiUzQ2IlM0VBY2N1cmFjeSUyMG9mJTIwZGlmZmVyZW50JTIwUkFHJTIwY29uZmlndXJhdGlvbnMlM0MlMkZiJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIweGF4aXNfdGl0bGUlM0QlMjJSQUclMjBzZXR0aW5ncyUyMiUyQyUwQSUyMCUyMCUyMCUyMGZvbnQlM0RkaWN0KHNpemUlM0QxNSklMkMlMEEpJTBBZmlnLmxheW91dC55YXhpcy50aWNrc3VmZml4JTIwJTNEJTIwJTIyJTI1JTIyJTBBZmlnLnVwZGF0ZV9jb2xvcmF4ZXMoc2hvd3NjYWxlJTNERmFsc2UpJTBBZmlnLnVwZGF0ZV90cmFjZXModGV4dHRlbXBsYXRlJTNEJTIyJTI1JTdCeSUzQS4xZiU3RCUyMiUyQyUyMHRleHRwb3NpdGlvbiUzRCUyMm91dHNpZGUlMjIpJTBBZmlnLnNob3coKQ==",highlighted:`fig = px.bar(
    scores,
    color=scores,
    labels={
        <span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;Accuracy&quot;</span>,
        <span class="hljs-string">&quot;settings&quot;</span>: <span class="hljs-string">&quot;Configuration&quot;</span>,
    },
    color_continuous_scale=<span class="hljs-string">&quot;bluered&quot;</span>,
)
fig.update_layout(w
    width=<span class="hljs-number">1000</span>,
    height=<span class="hljs-number">600</span>,
    barmode=<span class="hljs-string">&quot;group&quot;</span>,
    yaxis_range=[<span class="hljs-number">0</span>, <span class="hljs-number">100</span>],
    title=<span class="hljs-string">&quot;&lt;b&gt;Accuracy of different RAG configurations&lt;/b&gt;&quot;</span>,
    xaxis_title=<span class="hljs-string">&quot;RAG settings&quot;</span>,
    font=<span class="hljs-built_in">dict</span>(size=<span class="hljs-number">15</span>),
)
fig.layout.yaxis.ticksuffix = <span class="hljs-string">&quot;%&quot;</span>
fig.update_coloraxes(showscale=<span class="hljs-literal">False</span>)
fig.update_traces(texttemplate=<span class="hljs-string">&quot;%{y:.1f}&quot;</span>, textposition=<span class="hljs-string">&quot;outside&quot;</span>)
fig.show()`,wrap:!1}}),{c(){u=M("meta"),js=n(),Js=M("p"),Ts=n(),i(d.$$.fragment),ws=n(),i(m.$$.fragment),cs=n(),h=M("p"),h.innerHTML=it,us=n(),I=M("p"),I.textContent=ot,rs=n(),b=M("p"),b.innerHTML=Jt,ds=n(),C=M("p"),C.textContent=pt,ms=n(),Z=M("img"),hs=n(),G=M("p"),G.textContent=Tt,Is=n(),i(B.$$.fragment),bs=n(),g=M("p"),g.textContent=wt,Cs=n(),V=M("p"),V.textContent=ct,Zs=n(),f=M("ol"),f.innerHTML=ut,Gs=n(),W=M("p"),W.textContent=rt,Bs=n(),A=M("ol"),A.innerHTML=dt,gs=n(),R=M("p"),R.innerHTML=mt,Vs=n(),i(Q.$$.fragment),fs=n(),i(v.$$.fragment),Ws=n(),i(X.$$.fragment),As=n(),i(k.$$.fragment),Rs=n(),i(N.$$.fragment),Qs=n(),i(E.$$.fragment),vs=n(),_=M("p"),_.textContent=ht,Xs=n(),q=M("p"),q.textContent=It,ks=n(),i(F.$$.fragment),Ns=n(),i(S.$$.fragment),Es=n(),i(Y.$$.fragment),_s=n(),z=M("p"),z.innerHTML=bt,qs=n(),i(x.$$.fragment),Fs=n(),i(H.$$.fragment),Ss=n(),i($.$$.fragment),Ys=n(),L=M("p"),L.textContent=Ct,zs=n(),D=M("p"),D.textContent=Zt,xs=n(),i(K.$$.fragment),Hs=n(),i(P.$$.fragment),$s=n(),i(O.$$.fragment),Ls=n(),ll=M("p"),ll.textContent=Gt,Ds=n(),sl=M("p"),sl.innerHTML=Bt,Ks=n(),el=M("ul"),el.innerHTML=gt,Ps=n(),tl=M("p"),tl.innerHTML=Vt,Os=n(),nl=M("ul"),nl.innerHTML=ft,le=n(),al=M("p"),al.textContent=Wt,se=n(),Ml=M("p"),Ml.innerHTML=At,ee=n(),yl=M("p"),yl.textContent=Rt,te=n(),i(Ul.$$.fragment),ne=n(),i(il.$$.fragment),ae=n(),ol=M("p"),ol.textContent=Qt,Me=n(),i(Jl.$$.fragment),ye=n(),pl=M("pre"),pl.textContent=vt,Ue=n(),jl=M("p"),jl.textContent=Xt,ie=n(),Tl=M("p"),Tl.textContent=kt,oe=n(),i(wl.$$.fragment),Je=n(),i(cl.$$.fragment),pe=n(),i(ul.$$.fragment),je=n(),rl=M("ul"),rl.innerHTML=Nt,Te=n(),dl=M("p"),dl.textContent=Et,we=n(),ml=M("ul"),ml.innerHTML=_t,ce=n(),hl=M("p"),hl.innerHTML=qt,ue=n(),Il=M("p"),Il.innerHTML=Ft,re=n(),bl=M("blockquote"),bl.innerHTML=St,de=n(),Cl=M("p"),Cl.innerHTML=Yt,me=n(),i(Zl.$$.fragment),he=n(),i(Gl.$$.fragment),Ie=n(),i(Bl.$$.fragment),be=n(),gl=M("p"),gl.innerHTML=zt,Ce=n(),Vl=M("blockquote"),Vl.innerHTML=xt,Ze=n(),fl=M("p"),fl.innerHTML=Ht,Ge=n(),Wl=M("ul"),Wl.innerHTML=$t,Be=n(),i(Al.$$.fragment),ge=n(),i(Rl.$$.fragment),Ve=n(),Ql=M("p"),Ql.innerHTML=Lt,fe=n(),vl=M("p"),vl.textContent=Dt,We=n(),Xl=M("ul"),Xl.innerHTML=Kt,Ae=n(),i(kl.$$.fragment),Re=n(),i(Nl.$$.fragment),Qe=n(),i(El.$$.fragment),ve=n(),i(_l.$$.fragment),Xe=n(),ql=M("p"),ql.textContent=Pt,ke=n(),Fl=M("p"),Fl.innerHTML=Ot,Ne=n(),Sl=M("p"),Sl.innerHTML=ln,Ee=n(),Yl=M("blockquote"),Yl.innerHTML=sn,_e=n(),zl=M("p"),zl.innerHTML=en,qe=n(),xl=M("p"),xl.innerHTML=tn,Fe=n(),i(Hl.$$.fragment),Se=n(),i($l.$$.fragment),Ye=n(),i(Ll.$$.fragment),ze=n(),Dl=M("p"),Dl.textContent=nn,xe=n(),i(Kl.$$.fragment),He=n(),i(Pl.$$.fragment),$e=n(),i(Ol.$$.fragment),Le=n(),i(ls.$$.fragment),De=n(),i(ss.$$.fragment),Ke=n(),i(es.$$.fragment),Pe=n(),ts=M("p"),ts.innerHTML=an,Oe=n(),ns=M("p"),ns.textContent=Mn,lt=n(),as=M("p"),as.innerHTML=yn,st=n(),i(Ms.$$.fragment),et=n(),i(ys.$$.fragment),tt=n(),r=M("img"),nt=n(),Us=M("p"),Us.textContent=on,at=n(),is=M("p"),is.textContent=Jn,Mt=n(),ps=M("p"),this.h()},l(l){const s=dn("svelte-u9bgzb",document.head);u=y(s,"META",{name:!0,content:!0}),s.forEach(e),js=a(l),Js=y(l,"P",{}),jn(Js).forEach(e),Ts=a(l),o(d.$$.fragment,l),ws=a(l),o(m.$$.fragment,l),cs=a(l),h=y(l,"P",{"data-svelte-h":!0}),U(h)!=="svelte-1xlqnsv"&&(h.innerHTML=it),us=a(l),I=y(l,"P",{"data-svelte-h":!0}),U(I)!=="svelte-2xiv25"&&(I.textContent=ot),rs=a(l),b=y(l,"P",{"data-svelte-h":!0}),U(b)!=="svelte-1460hpm"&&(b.innerHTML=Jt),ds=a(l),C=y(l,"P",{"data-svelte-h":!0}),U(C)!=="svelte-9eyhtm"&&(C.textContent=pt),ms=a(l),Z=y(l,"IMG",{src:!0,height:!0}),hs=a(l),G=y(l,"P",{"data-svelte-h":!0}),U(G)!=="svelte-1wwknqm"&&(G.textContent=Tt),Is=a(l),o(B.$$.fragment,l),bs=a(l),g=y(l,"P",{"data-svelte-h":!0}),U(g)!=="svelte-vv8zeo"&&(g.textContent=wt),Cs=a(l),V=y(l,"P",{"data-svelte-h":!0}),U(V)!=="svelte-baonz3"&&(V.textContent=ct),Zs=a(l),f=y(l,"OL",{"data-svelte-h":!0}),U(f)!=="svelte-12qpxq2"&&(f.innerHTML=ut),Gs=a(l),W=y(l,"P",{"data-svelte-h":!0}),U(W)!=="svelte-gq3s7j"&&(W.textContent=rt),Bs=a(l),A=y(l,"OL",{"data-svelte-h":!0}),U(A)!=="svelte-qbxvp7"&&(A.innerHTML=dt),gs=a(l),R=y(l,"P",{"data-svelte-h":!0}),U(R)!=="svelte-15hqrk"&&(R.innerHTML=mt),Vs=a(l),o(Q.$$.fragment,l),fs=a(l),o(v.$$.fragment,l),Ws=a(l),o(X.$$.fragment,l),As=a(l),o(k.$$.fragment,l),Rs=a(l),o(N.$$.fragment,l),Qs=a(l),o(E.$$.fragment,l),vs=a(l),_=y(l,"P",{"data-svelte-h":!0}),U(_)!=="svelte-1wbiyhw"&&(_.textContent=ht),Xs=a(l),q=y(l,"P",{"data-svelte-h":!0}),U(q)!=="svelte-1o0ze03"&&(q.textContent=It),ks=a(l),o(F.$$.fragment,l),Ns=a(l),o(S.$$.fragment,l),Es=a(l),o(Y.$$.fragment,l),_s=a(l),z=y(l,"P",{"data-svelte-h":!0}),U(z)!=="svelte-162gsjg"&&(z.innerHTML=bt),qs=a(l),o(x.$$.fragment,l),Fs=a(l),o(H.$$.fragment,l),Ss=a(l),o($.$$.fragment,l),Ys=a(l),L=y(l,"P",{"data-svelte-h":!0}),U(L)!=="svelte-1v7z1mr"&&(L.textContent=Ct),zs=a(l),D=y(l,"P",{"data-svelte-h":!0}),U(D)!=="svelte-jsmlwo"&&(D.textContent=Zt),xs=a(l),o(K.$$.fragment,l),Hs=a(l),o(P.$$.fragment,l),$s=a(l),o(O.$$.fragment,l),Ls=a(l),ll=y(l,"P",{"data-svelte-h":!0}),U(ll)!=="svelte-xa68th"&&(ll.textContent=Gt),Ds=a(l),sl=y(l,"P",{"data-svelte-h":!0}),U(sl)!=="svelte-1rn1tpr"&&(sl.innerHTML=Bt),Ks=a(l),el=y(l,"UL",{"data-svelte-h":!0}),U(el)!=="svelte-mge22a"&&(el.innerHTML=gt),Ps=a(l),tl=y(l,"P",{"data-svelte-h":!0}),U(tl)!=="svelte-1a9sdbs"&&(tl.innerHTML=Vt),Os=a(l),nl=y(l,"UL",{"data-svelte-h":!0}),U(nl)!=="svelte-17ofou1"&&(nl.innerHTML=ft),le=a(l),al=y(l,"P",{"data-svelte-h":!0}),U(al)!=="svelte-1bu41t1"&&(al.textContent=Wt),se=a(l),Ml=y(l,"P",{"data-svelte-h":!0}),U(Ml)!=="svelte-v7jbl8"&&(Ml.innerHTML=At),ee=a(l),yl=y(l,"P",{"data-svelte-h":!0}),U(yl)!=="svelte-1kwgyx1"&&(yl.textContent=Rt),te=a(l),o(Ul.$$.fragment,l),ne=a(l),o(il.$$.fragment,l),ae=a(l),ol=y(l,"P",{"data-svelte-h":!0}),U(ol)!=="svelte-yms2wp"&&(ol.textContent=Qt),Me=a(l),o(Jl.$$.fragment,l),ye=a(l),pl=y(l,"PRE",{"data-svelte-h":!0}),U(pl)!=="svelte-1k8l62p"&&(pl.textContent=vt),Ue=a(l),jl=y(l,"P",{"data-svelte-h":!0}),U(jl)!=="svelte-1asqnia"&&(jl.textContent=Xt),ie=a(l),Tl=y(l,"P",{"data-svelte-h":!0}),U(Tl)!=="svelte-alkdir"&&(Tl.textContent=kt),oe=a(l),o(wl.$$.fragment,l),Je=a(l),o(cl.$$.fragment,l),pe=a(l),o(ul.$$.fragment,l),je=a(l),rl=y(l,"UL",{"data-svelte-h":!0}),U(rl)!=="svelte-1fnij86"&&(rl.innerHTML=Nt),Te=a(l),dl=y(l,"P",{"data-svelte-h":!0}),U(dl)!=="svelte-53zzzq"&&(dl.textContent=Et),we=a(l),ml=y(l,"UL",{"data-svelte-h":!0}),U(ml)!=="svelte-1g19xro"&&(ml.innerHTML=_t),ce=a(l),hl=y(l,"P",{"data-svelte-h":!0}),U(hl)!=="svelte-1yo17of"&&(hl.innerHTML=qt),ue=a(l),Il=y(l,"P",{"data-svelte-h":!0}),U(Il)!=="svelte-1hitev5"&&(Il.innerHTML=Ft),re=a(l),bl=y(l,"BLOCKQUOTE",{"data-svelte-h":!0}),U(bl)!=="svelte-w4wn00"&&(bl.innerHTML=St),de=a(l),Cl=y(l,"P",{"data-svelte-h":!0}),U(Cl)!=="svelte-1toh8cv"&&(Cl.innerHTML=Yt),me=a(l),o(Zl.$$.fragment,l),he=a(l),o(Gl.$$.fragment,l),Ie=a(l),o(Bl.$$.fragment,l),be=a(l),gl=y(l,"P",{"data-svelte-h":!0}),U(gl)!=="svelte-xymbek"&&(gl.innerHTML=zt),Ce=a(l),Vl=y(l,"BLOCKQUOTE",{"data-svelte-h":!0}),U(Vl)!=="svelte-1k8ukvt"&&(Vl.innerHTML=xt),Ze=a(l),fl=y(l,"P",{"data-svelte-h":!0}),U(fl)!=="svelte-1hqptzf"&&(fl.innerHTML=Ht),Ge=a(l),Wl=y(l,"UL",{"data-svelte-h":!0}),U(Wl)!=="svelte-1w0jpt6"&&(Wl.innerHTML=$t),Be=a(l),o(Al.$$.fragment,l),ge=a(l),o(Rl.$$.fragment,l),Ve=a(l),Ql=y(l,"P",{"data-svelte-h":!0}),U(Ql)!=="svelte-1m0x0qs"&&(Ql.innerHTML=Lt),fe=a(l),vl=y(l,"P",{"data-svelte-h":!0}),U(vl)!=="svelte-1e3sl85"&&(vl.textContent=Dt),We=a(l),Xl=y(l,"UL",{"data-svelte-h":!0}),U(Xl)!=="svelte-1scj3jf"&&(Xl.innerHTML=Kt),Ae=a(l),o(kl.$$.fragment,l),Re=a(l),o(Nl.$$.fragment,l),Qe=a(l),o(El.$$.fragment,l),ve=a(l),o(_l.$$.fragment,l),Xe=a(l),ql=y(l,"P",{"data-svelte-h":!0}),U(ql)!=="svelte-z2wcut"&&(ql.textContent=Pt),ke=a(l),Fl=y(l,"P",{"data-svelte-h":!0}),U(Fl)!=="svelte-1tiikby"&&(Fl.innerHTML=Ot),Ne=a(l),Sl=y(l,"P",{"data-svelte-h":!0}),U(Sl)!=="svelte-13s04hx"&&(Sl.innerHTML=ln),Ee=a(l),Yl=y(l,"BLOCKQUOTE",{"data-svelte-h":!0}),U(Yl)!=="svelte-jkfwyy"&&(Yl.innerHTML=sn),_e=a(l),zl=y(l,"P",{"data-svelte-h":!0}),U(zl)!=="svelte-qutlt3"&&(zl.innerHTML=en),qe=a(l),xl=y(l,"P",{"data-svelte-h":!0}),U(xl)!=="svelte-1sle7mx"&&(xl.innerHTML=tn),Fe=a(l),o(Hl.$$.fragment,l),Se=a(l),o($l.$$.fragment,l),Ye=a(l),o(Ll.$$.fragment,l),ze=a(l),Dl=y(l,"P",{"data-svelte-h":!0}),U(Dl)!=="svelte-ieknxj"&&(Dl.textContent=nn),xe=a(l),o(Kl.$$.fragment,l),He=a(l),o(Pl.$$.fragment,l),$e=a(l),o(Ol.$$.fragment,l),Le=a(l),o(ls.$$.fragment,l),De=a(l),o(ss.$$.fragment,l),Ke=a(l),o(es.$$.fragment,l),Pe=a(l),ts=y(l,"P",{"data-svelte-h":!0}),U(ts)!=="svelte-5h9xp6"&&(ts.innerHTML=an),Oe=a(l),ns=y(l,"P",{"data-svelte-h":!0}),U(ns)!=="svelte-6vrle6"&&(ns.textContent=Mn),lt=a(l),as=y(l,"P",{"data-svelte-h":!0}),U(as)!=="svelte-1l99caq"&&(as.innerHTML=yn),st=a(l),o(Ms.$$.fragment,l),et=a(l),o(ys.$$.fragment,l),tt=a(l),r=y(l,"IMG",{src:!0,height:!0,width:!0}),nt=a(l),Us=y(l,"P",{"data-svelte-h":!0}),U(Us)!=="svelte-i71q2k"&&(Us.textContent=on),at=a(l),is=y(l,"P",{"data-svelte-h":!0}),U(is)!=="svelte-5zkqt2"&&(is.textContent=Jn),Mt=a(l),ps=y(l,"P",{}),jn(ps).forEach(e),this.h()},h(){os(u,"name","hf:doc:metadata"),os(u,"content",bn),pn(Z.src,jt="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/RAG_workflow.png")||os(Z,"src",jt),os(Z,"height","700"),pn(r.src,Un="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/RAG_settings_accuracy.png")||os(r,"src",Un),os(r,"height","500"),os(r,"width","800")},m(l,s){mn(document.head,u),t(l,js,s),t(l,Js,s),t(l,Ts,s),J(d,l,s),t(l,ws,s),J(m,l,s),t(l,cs,s),t(l,h,s),t(l,us,s),t(l,I,s),t(l,rs,s),t(l,b,s),t(l,ds,s),t(l,C,s),t(l,ms,s),t(l,Z,s),t(l,hs,s),t(l,G,s),t(l,Is,s),J(B,l,s),t(l,bs,s),t(l,g,s),t(l,Cs,s),t(l,V,s),t(l,Zs,s),t(l,f,s),t(l,Gs,s),t(l,W,s),t(l,Bs,s),t(l,A,s),t(l,gs,s),t(l,R,s),t(l,Vs,s),J(Q,l,s),t(l,fs,s),J(v,l,s),t(l,Ws,s),J(X,l,s),t(l,As,s),J(k,l,s),t(l,Rs,s),J(N,l,s),t(l,Qs,s),J(E,l,s),t(l,vs,s),t(l,_,s),t(l,Xs,s),t(l,q,s),t(l,ks,s),J(F,l,s),t(l,Ns,s),J(S,l,s),t(l,Es,s),J(Y,l,s),t(l,_s,s),t(l,z,s),t(l,qs,s),J(x,l,s),t(l,Fs,s),J(H,l,s),t(l,Ss,s),J($,l,s),t(l,Ys,s),t(l,L,s),t(l,zs,s),t(l,D,s),t(l,xs,s),J(K,l,s),t(l,Hs,s),J(P,l,s),t(l,$s,s),J(O,l,s),t(l,Ls,s),t(l,ll,s),t(l,Ds,s),t(l,sl,s),t(l,Ks,s),t(l,el,s),t(l,Ps,s),t(l,tl,s),t(l,Os,s),t(l,nl,s),t(l,le,s),t(l,al,s),t(l,se,s),t(l,Ml,s),t(l,ee,s),t(l,yl,s),t(l,te,s),J(Ul,l,s),t(l,ne,s),J(il,l,s),t(l,ae,s),t(l,ol,s),t(l,Me,s),J(Jl,l,s),t(l,ye,s),t(l,pl,s),t(l,Ue,s),t(l,jl,s),t(l,ie,s),t(l,Tl,s),t(l,oe,s),J(wl,l,s),t(l,Je,s),J(cl,l,s),t(l,pe,s),J(ul,l,s),t(l,je,s),t(l,rl,s),t(l,Te,s),t(l,dl,s),t(l,we,s),t(l,ml,s),t(l,ce,s),t(l,hl,s),t(l,ue,s),t(l,Il,s),t(l,re,s),t(l,bl,s),t(l,de,s),t(l,Cl,s),t(l,me,s),J(Zl,l,s),t(l,he,s),J(Gl,l,s),t(l,Ie,s),J(Bl,l,s),t(l,be,s),t(l,gl,s),t(l,Ce,s),t(l,Vl,s),t(l,Ze,s),t(l,fl,s),t(l,Ge,s),t(l,Wl,s),t(l,Be,s),J(Al,l,s),t(l,ge,s),J(Rl,l,s),t(l,Ve,s),t(l,Ql,s),t(l,fe,s),t(l,vl,s),t(l,We,s),t(l,Xl,s),t(l,Ae,s),J(kl,l,s),t(l,Re,s),J(Nl,l,s),t(l,Qe,s),J(El,l,s),t(l,ve,s),J(_l,l,s),t(l,Xe,s),t(l,ql,s),t(l,ke,s),t(l,Fl,s),t(l,Ne,s),t(l,Sl,s),t(l,Ee,s),t(l,Yl,s),t(l,_e,s),t(l,zl,s),t(l,qe,s),t(l,xl,s),t(l,Fe,s),J(Hl,l,s),t(l,Se,s),J($l,l,s),t(l,Ye,s),J(Ll,l,s),t(l,ze,s),t(l,Dl,s),t(l,xe,s),J(Kl,l,s),t(l,He,s),J(Pl,l,s),t(l,$e,s),J(Ol,l,s),t(l,Le,s),J(ls,l,s),t(l,De,s),J(ss,l,s),t(l,Ke,s),J(es,l,s),t(l,Pe,s),t(l,ts,s),t(l,Oe,s),t(l,ns,s),t(l,lt,s),t(l,as,s),t(l,st,s),J(Ms,l,s),t(l,et,s),J(ys,l,s),t(l,tt,s),t(l,r,s),t(l,nt,s),t(l,Us,s),t(l,at,s),t(l,is,s),t(l,Mt,s),t(l,ps,s),yt=!0},p:wn,i(l){yt||(p(d.$$.fragment,l),p(m.$$.fragment,l),p(B.$$.fragment,l),p(Q.$$.fragment,l),p(v.$$.fragment,l),p(X.$$.fragment,l),p(k.$$.fragment,l),p(N.$$.fragment,l),p(E.$$.fragment,l),p(F.$$.fragment,l),p(S.$$.fragment,l),p(Y.$$.fragment,l),p(x.$$.fragment,l),p(H.$$.fragment,l),p($.$$.fragment,l),p(K.$$.fragment,l),p(P.$$.fragment,l),p(O.$$.fragment,l),p(Ul.$$.fragment,l),p(il.$$.fragment,l),p(Jl.$$.fragment,l),p(wl.$$.fragment,l),p(cl.$$.fragment,l),p(ul.$$.fragment,l),p(Zl.$$.fragment,l),p(Gl.$$.fragment,l),p(Bl.$$.fragment,l),p(Al.$$.fragment,l),p(Rl.$$.fragment,l),p(kl.$$.fragment,l),p(Nl.$$.fragment,l),p(El.$$.fragment,l),p(_l.$$.fragment,l),p(Hl.$$.fragment,l),p($l.$$.fragment,l),p(Ll.$$.fragment,l),p(Kl.$$.fragment,l),p(Pl.$$.fragment,l),p(Ol.$$.fragment,l),p(ls.$$.fragment,l),p(ss.$$.fragment,l),p(es.$$.fragment,l),p(Ms.$$.fragment,l),p(ys.$$.fragment,l),yt=!0)},o(l){j(d.$$.fragment,l),j(m.$$.fragment,l),j(B.$$.fragment,l),j(Q.$$.fragment,l),j(v.$$.fragment,l),j(X.$$.fragment,l),j(k.$$.fragment,l),j(N.$$.fragment,l),j(E.$$.fragment,l),j(F.$$.fragment,l),j(S.$$.fragment,l),j(Y.$$.fragment,l),j(x.$$.fragment,l),j(H.$$.fragment,l),j($.$$.fragment,l),j(K.$$.fragment,l),j(P.$$.fragment,l),j(O.$$.fragment,l),j(Ul.$$.fragment,l),j(il.$$.fragment,l),j(Jl.$$.fragment,l),j(wl.$$.fragment,l),j(cl.$$.fragment,l),j(ul.$$.fragment,l),j(Zl.$$.fragment,l),j(Gl.$$.fragment,l),j(Bl.$$.fragment,l),j(Al.$$.fragment,l),j(Rl.$$.fragment,l),j(kl.$$.fragment,l),j(Nl.$$.fragment,l),j(El.$$.fragment,l),j(_l.$$.fragment,l),j(Hl.$$.fragment,l),j($l.$$.fragment,l),j(Ll.$$.fragment,l),j(Kl.$$.fragment,l),j(Pl.$$.fragment,l),j(Ol.$$.fragment,l),j(ls.$$.fragment,l),j(ss.$$.fragment,l),j(es.$$.fragment,l),j(Ms.$$.fragment,l),j(ys.$$.fragment,l),yt=!1},d(l){l&&(e(js),e(Js),e(Ts),e(ws),e(cs),e(h),e(us),e(I),e(rs),e(b),e(ds),e(C),e(ms),e(Z),e(hs),e(G),e(Is),e(bs),e(g),e(Cs),e(V),e(Zs),e(f),e(Gs),e(W),e(Bs),e(A),e(gs),e(R),e(Vs),e(fs),e(Ws),e(As),e(Rs),e(Qs),e(vs),e(_),e(Xs),e(q),e(ks),e(Ns),e(Es),e(_s),e(z),e(qs),e(Fs),e(Ss),e(Ys),e(L),e(zs),e(D),e(xs),e(Hs),e($s),e(Ls),e(ll),e(Ds),e(sl),e(Ks),e(el),e(Ps),e(tl),e(Os),e(nl),e(le),e(al),e(se),e(Ml),e(ee),e(yl),e(te),e(ne),e(ae),e(ol),e(Me),e(ye),e(pl),e(Ue),e(jl),e(ie),e(Tl),e(oe),e(Je),e(pe),e(je),e(rl),e(Te),e(dl),e(we),e(ml),e(ce),e(hl),e(ue),e(Il),e(re),e(bl),e(de),e(Cl),e(me),e(he),e(Ie),e(be),e(gl),e(Ce),e(Vl),e(Ze),e(fl),e(Ge),e(Wl),e(Be),e(ge),e(Ve),e(Ql),e(fe),e(vl),e(We),e(Xl),e(Ae),e(Re),e(Qe),e(ve),e(Xe),e(ql),e(ke),e(Fl),e(Ne),e(Sl),e(Ee),e(Yl),e(_e),e(zl),e(qe),e(xl),e(Fe),e(Se),e(Ye),e(ze),e(Dl),e(xe),e(He),e($e),e(Le),e(De),e(Ke),e(Pe),e(ts),e(Oe),e(ns),e(lt),e(as),e(st),e(et),e(tt),e(r),e(nt),e(Us),e(at),e(is),e(Mt),e(ps)),e(u),T(d,l),T(m,l),T(B,l),T(Q,l),T(v,l),T(X,l),T(k,l),T(N,l),T(E,l),T(F,l),T(S,l),T(Y,l),T(x,l),T(H,l),T($,l),T(K,l),T(P,l),T(O,l),T(Ul,l),T(il,l),T(Jl,l),T(wl,l),T(cl,l),T(ul,l),T(Zl,l),T(Gl,l),T(Bl,l),T(Al,l),T(Rl,l),T(kl,l),T(Nl,l),T(El,l),T(_l,l),T(Hl,l),T($l,l),T(Ll,l),T(Kl,l),T(Pl,l),T(Ol,l),T(ls,l),T(ss,l),T(es,l),T(Ms,l),T(ys,l)}}}const bn='{"title":"RAG Evaluation","local":"rag-evaluation","sections":[{"title":"Evaluating RAG performance","local":"evaluating-rag-performance","sections":[],"depth":3},{"title":"Load your knowledge base","local":"load-your-knowledge-base","sections":[],"depth":3}],"depth":1}';function Cn(Ut){return cn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vn extends un{constructor(u){super(),rn(this,u,Cn,In,Tn,{})}}export{Vn as component};
