import{s as Vl,n as Xl,o as Gl}from"../chunks/scheduler.7bc62968.js";import{S as Dl,i as Fl,g as i,s as n,r as p,A as Ll,h as o,f as t,c as a,j as Ql,u as r,x as M,k as Yl,y as Kl,a as s,v as w,d as m,t as c,w as y}from"../chunks/index.2f8492b0.js";import{C as ml}from"../chunks/CodeBlock.4e96d6f7.js";import{H as T}from"../chunks/Heading.14fb2476.js";function Pl(cl){let u,ye,me,Te,h,ue,J,yl="MobileNet is a type of neural network architecture designed for mobile devices. It was developed by Google’s research team and first introduced in 2017. The primary goal of MobileNet is to provide high-performance, low-latency image classification and object detection on smartphones, tablets, and other resource-constrained devices.",he,j,Tl="MobileNet achieves this by using depthwise separable convolutions, which are a more efficient alternative to standard convolutions. Depthwise separable convolutions break down the computation into two separate steps: depthwise convolution followed by pointwise convolution. This results in a significant reduction of parameters and computational complexity, allowing MobileNet to run efficiently on mobile devices.",Je,U,je,f,ul="By replacing regular convolutional layers with these depthwise separable convolutions and pointwise convolutions, MobileNet achieves high accuracy while minimizing computational overhead, making it well-suited for mobile devices and other resource-limited platforms. There are two types of convolutions used in MobileNet:",Ue,C,fe,b,hl="In traditional convolutional layers, each filter applies its weight across all input channels simultaneously. Depthwise separable convolutions break this down into two steps: depthwise convolution followed by pointwise convolution.",Ce,d,Jl="This step performs a convolution separately for each channel (a single color or feature) in the input image using a small filter (usually 3x3). The output of this step is the same size as the input but with fewer channels.",be,I,de,v,jl="This type of convolution applies a single filter (usually 1x1) across all channels in both input and output layers. It has fewer parameters than regular convolution and can be seen as an alternative to fully connected layers, making it suitable for mobile devices that have limited computational resources.",Ie,x,Ul="After depthwise convolution, this step combines the filtered outputs from previous steps using another 1x1 convolutional layer. This operation effectively aggregates the features learned by the depthwise convolutions into a smaller set of features, reducing the overall complexity while retaining important information.",ve,g,xe,A,fl="To better understand, let’s simplify it and explain:",ge,B,Ae,$,Cl="Imagine you have a big, thick filter (like a sponge with many layers). This filter is applied over the entire image. It processes all parts of the image and all its features (like colors) at once. This requires a lot of work (computation) and a big filter (memory).",Be,k,$e,Z,bl="MobileNet does this process basic. It splits the big filter into two smaller, simpler steps:",ke,E,dl=`<li><strong>Step 1 - Depthwise Convolution:</strong> First, it uses a thin filter (like a single layer of a sponge) for each feature of the image
separately (like processing each color individually). This is less work because each filter is small and simple.</li> <li><strong>Step 2 - Pointwise Convolution:</strong> Then, it uses another small filter (just a tiny dot) to mix these features back together. This step is like taking a summary of what the first filters found.</li>`,Ze,N,Ee,_,Il="MobileNet uses these two smaller steps instead of one big step, it’s like doing a lighter version of the work needed in regular convolutions. It’s more efficient, especially on devices that aren’t very powerful, like smartphones.",Ne,S,vl="With smaller filters, MobileNet doesn’t need as much memory. It’s like needing a smaller box to store all your tools, making it easier to fit into smaller devices.",_e,H,Se,W,He,R,xl="<li>Normal convolutions use a larger kernel (like 3x3 or 5x5) to look at a group of pixels in the image at once. It’s like observing a small patch of a picture to understand a part of the scene.</li> <li>These convolutions are good at understanding features like edges, corners, and textures by analyzing how pixels are arranged next to each other.</li>",We,z,Re,Q,gl="<li>A 1x1 convolution, looks at one pixel at a time. It doesn’t try to understand the arrangement of neighboring pixels.</li> <li>Even though it’s looking at one pixel, it considers all the information from different channels (like the RGB channels in a color image). It combines these channels to create a new version of that pixel.</li> <li>The 1x1 convolution can either increase or decrease the number of channels. This means it can simplify the information (by reducing channels) or create more complex information (by increasing channels).</li>",ze,Y,Qe,V,Al="<li><strong>Area of Focus:</strong> Normal convolutions analyze a set of pixels together to understand patterns, whereas 1x1 convolutions focus on individual pixels, combining the information from different channels.</li> <li><strong>Purpose:</strong> Normal convolutions are used for detecting patterns and features in an image. In contrast, 1x1 convolutions are mainly used to alter the channel depth, helping in adjusting the complexity of the information for subsequent layers in a neural network for efficiency in weak devices.</li>",Ye,X,Bl="MobileNet also employs techniques like channel-wise linear bottleneck layers, which improve model accuracy while reducing the number of parameters. The architecture is designed with optimizations for various hardware platforms, including CPUs, GPUs, and even specialized hardware such as Google’s Tensor Processing Units (TPUs).",Ve,G,Xe,D,$l="Channel-wise linear bottleneck layers help to further reduce the number of parameters and computational cost while maintaining high accuracy in image classification tasks.",Ge,F,kl="A channel-wise linear bottleneck layer consists of three main operations applied sequentially:",De,L,Zl="<li><strong>Depthwise convolution:</strong> This step performs a convolution separately for each channel (a single color or feature) in the input image using a small filter (usually 3x3). The output of this step is the same size as the input but with fewer channels.</li> <li><strong>Batch normalization:</strong> This operation normalizes the activation values across each channel, helping to stabilize the training process and improve generalization performance.</li> <li><strong>Activation function:</strong> Typically, a ReLU (Rectified Linear Unit) activation function is used after batch normalization to introduce non-linearity in the network.</li>",Fe,K,Le,P,El="Some problems may occur during training. We will explain them first, then we explain what ReLU does to this problems.",Ke,q,Pe,O,Nl="In deep neural networks, especially during backpropagation, the vanishing gradient problem can occur. This happens when gradients (which are used to update the network’s weights) become very small as they are passed back through the network’s layers. If these gradients become too small, they “vanish,” making it hard for the network to learn and adjust its weights effectively.",qe,ee,_l="ReLU has a linear, non-saturating form for positive values (where it simply outputs the input if it’s positive), it ensures that the gradients do not become too small, allowing for faster learning and more effective weight adjustments in the network.",Oe,le,el,te,Sl="Without non-linearity, a neural network, no matter how many layers it has, would function as a linear model, incapable of learning complex patterns.",ll,se,Hl="Non-linear functions like ReLU enable neural networks to capture and learn complex relationships in the data.",tl,ne,sl,ae,Wl="You can use Hugging Face transformers to infer with a variation of transformers models like below:",nl,ie,al,oe,il,Me,ol,pe,Rl="You can find an example implementation of MobileNet for PyTorch below:",Ml,re,pl,we,zl='You can also find a pretrained MobileNet model checkpoint on this HuggingFace <a href="https://huggingface.co/google/mobilenet_v2_1.0_224" rel="nofollow">link</a>.',rl,ce,wl;return h=new T({props:{title:"MobileNet",local:"mobilenet",headingTag:"h1"}}),U=new T({props:{title:"Convolution Types on MobileNet",local:"convolution-types-on-mobilenet",headingTag:"h2"}}),C=new T({props:{title:"Depthwise Seperable Convolutions",local:"depthwise-seperable-convolutions",headingTag:"h3"}}),I=new T({props:{title:"Pointwise Seperable Convolutions",local:"pointwise-seperable-convolutions",headingTag:"h3"}}),g=new T({props:{title:"Why Do We Use These Convolutions Instead of Regular Convolutions?",local:"why-do-we-use-these-convolutions-instead-of-regular-convolutions",headingTag:"h3"}}),B=new T({props:{title:"Regular Convolutions, a big, All-in-one Filter",local:"regular-convolutions-a-big-all-in-one-filter",headingTag:"h4"}}),k=new T({props:{title:"Depthwise Separable Convolutions - Two-Step, Lighter Process:",local:"depthwise-separable-convolutions---two-step-lighter-process",headingTag:"h4"}}),N=new T({props:{title:"What are these steps about?",local:"what-are-these-steps-about",headingTag:"h4"}}),H=new T({props:{title:"How Do 1x1 Convolutions Work Compared to Normal Convolutions?",local:"how-do-1x1-convolutions-work-compared-to-normal-convolutions",headingTag:"h3"}}),W=new T({props:{title:"Normal Convolutions",local:"normal-convolutions",headingTag:"h4"}}),z=new T({props:{title:"1x1 Convolutions",local:"1x1-convolutions",headingTag:"h4"}}),Y=new T({props:{title:"Key Differences",local:"key-differences",headingTag:"h4"}}),G=new T({props:{title:"Channel-wise Linear Bottleneck Layers",local:"channel-wise-linear-bottleneck-layers",headingTag:"h3"}}),K=new T({props:{title:"What does ReLU do?",local:"what-does-relu-do",headingTag:"h3"}}),q=new T({props:{title:"Vanishing Gradient Problem",local:"vanishing-gradient-problem",headingTag:"h4"}}),le=new T({props:{title:"Non-Linearity",local:"non-linearity",headingTag:"h4"}}),ne=new T({props:{title:"Inference",local:"inference",headingTag:"h3"}}),ie=new ml({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEElMjMlMjBpbml0aWFsaXplJTIwcHJvY2Vzc29yJTIwYW5kJTIwbW9kZWwlMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm1vYmlsZW5ldF92Ml8xLjBfMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbW9iaWxlbmV0X3YyXzEuMF8yMjQlMjIpJTBBJTBBJTIzJTIwcHJlcHJvY2VzcyUyMHRoZSUyMGlucHV0cyUwQWlucHV0cyUyMCUzRCUyMHByZXByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZ2V0JTIwdGhlJTIwb3V0cHV0JTIwYW5kJTIwdGhlJTIwY2xhc3MlMjBsYWJlbHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWR4JTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQoJTIyUHJlZGljdGVkJTIwY2xhc3MlM0ElMjIlMkMlMjBtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWR4JTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForImageClassification
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># initialize processor and model</span>
preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/mobilenet_v2_1.0_224&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google/mobilenet_v2_1.0_224&quot;</span>)

<span class="hljs-comment"># preprocess the inputs</span>
inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># get the output and the class labels</span>
outputs = model(**inputs)
logits = outputs.logits

predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`,wrap:!1}}),oe=new ml({props:{code:"UHJlZGljdGVkJTIwY2xhc3MlM0ElMjB0YWJieSUyQyUyMHRhYmJ5JTIwY2F0",highlighted:'Predicted <span class="hljs-keyword">class</span>: <span class="hljs-symbol">tabby, <span class="hljs-symbol">tabby</span></span> <span class="hljs-symbol">cat</span>',wrap:!1}}),Me=new T({props:{title:"Example Implementation using PyTorch",local:"example-implementation-using-pytorch",headingTag:"h3"}}),re=new ml({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DepthwiseSeparableConv</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, out_channels, stride</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.depthwise = nn.Conv2d(
            in_channels,
            in_channels,
            kernel_size=<span class="hljs-number">3</span>,
            stride=stride,
            padding=<span class="hljs-number">1</span>,
            groups=in_channels,
        )
        self.pointwise = nn.Conv2d(
            in_channels, out_channels, kernel_size=<span class="hljs-number">1</span>, stride=<span class="hljs-number">1</span>, padding=<span class="hljs-number">0</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.depthwise(x)
        x = self.pointwise(x)
        <span class="hljs-keyword">return</span> x


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MobileNet</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_classes=<span class="hljs-number">1000</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.conv1 = nn.Conv2d(<span class="hljs-number">3</span>, <span class="hljs-number">32</span>, kernel_size=<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment"># MobileNet body</span>
        self.dw_conv2 = DepthwiseSeparableConv(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">1</span>)
        self.dw_conv3 = DepthwiseSeparableConv(<span class="hljs-number">64</span>, <span class="hljs-number">128</span>, <span class="hljs-number">2</span>)
        self.dw_conv4 = DepthwiseSeparableConv(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">1</span>)
        self.dw_conv5 = DepthwiseSeparableConv(<span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">2</span>)
        self.dw_conv6 = DepthwiseSeparableConv(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, <span class="hljs-number">1</span>)
        self.dw_conv7 = DepthwiseSeparableConv(<span class="hljs-number">256</span>, <span class="hljs-number">512</span>, <span class="hljs-number">2</span>)

        <span class="hljs-comment"># 5 depthwise separable convolutions with stride 1</span>
        self.dw_conv8 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv9 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv10 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv11 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)
        self.dw_conv12 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">1</span>)

        self.dw_conv13 = DepthwiseSeparableConv(<span class="hljs-number">512</span>, <span class="hljs-number">1024</span>, <span class="hljs-number">2</span>)
        self.dw_conv14 = DepthwiseSeparableConv(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>, <span class="hljs-number">1</span>)

        self.avg_pool = nn.AdaptiveAvgPool2d(<span class="hljs-number">1</span>)
        self.fc = nn.Linear(<span class="hljs-number">1024</span>, num_classes)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.conv1(x)
        x = F.relu(x)

        x = self.dw_conv2(x)
        x = F.relu(x)
        x = self.dw_conv3(x)
        x = F.relu(x)
        x = self.dw_conv4(x)
        x = F.relu(x)
        x = self.dw_conv5(x)
        x = F.relu(x)
        x = self.dw_conv6(x)
        x = F.relu(x)
        x = self.dw_conv7(x)
        x = F.relu(x)

        x = self.dw_conv8(x)
        x = F.relu(x)
        x = self.dw_conv9(x)
        x = F.relu(x)
        x = self.dw_conv10(x)
        x = F.relu(x)
        x = self.dw_conv11(x)
        x = F.relu(x)
        x = self.dw_conv12(x)
        x = F.relu(x)

        x = self.dw_conv13(x)
        x = F.relu(x)
        x = self.dw_conv14(x)
        x = F.relu(x)

        x = self.avg_pool(x)
        x = x.view(x.size(<span class="hljs-number">0</span>), -<span class="hljs-number">1</span>)
        x = self.fc(x)

        <span class="hljs-keyword">return</span> x


<span class="hljs-comment"># Create the model</span>
mobilenet = MobileNet(num_classes=<span class="hljs-number">1000</span>)
<span class="hljs-built_in">print</span>(mobilenet)`,wrap:!1}}),{c(){u=i("meta"),ye=n(),me=i("p"),Te=n(),p(h.$$.fragment),ue=n(),J=i("p"),J.textContent=yl,he=n(),j=i("p"),j.textContent=Tl,Je=n(),p(U.$$.fragment),je=n(),f=i("p"),f.textContent=ul,Ue=n(),p(C.$$.fragment),fe=n(),b=i("p"),b.textContent=hl,Ce=n(),d=i("p"),d.textContent=Jl,be=n(),p(I.$$.fragment),de=n(),v=i("p"),v.textContent=jl,Ie=n(),x=i("p"),x.textContent=Ul,ve=n(),p(g.$$.fragment),xe=n(),A=i("p"),A.textContent=fl,ge=n(),p(B.$$.fragment),Ae=n(),$=i("p"),$.textContent=Cl,Be=n(),p(k.$$.fragment),$e=n(),Z=i("p"),Z.textContent=bl,ke=n(),E=i("ul"),E.innerHTML=dl,Ze=n(),p(N.$$.fragment),Ee=n(),_=i("p"),_.textContent=Il,Ne=n(),S=i("p"),S.textContent=vl,_e=n(),p(H.$$.fragment),Se=n(),p(W.$$.fragment),He=n(),R=i("ul"),R.innerHTML=xl,We=n(),p(z.$$.fragment),Re=n(),Q=i("ul"),Q.innerHTML=gl,ze=n(),p(Y.$$.fragment),Qe=n(),V=i("ul"),V.innerHTML=Al,Ye=n(),X=i("p"),X.textContent=Bl,Ve=n(),p(G.$$.fragment),Xe=n(),D=i("p"),D.textContent=$l,Ge=n(),F=i("p"),F.textContent=kl,De=n(),L=i("ol"),L.innerHTML=Zl,Fe=n(),p(K.$$.fragment),Le=n(),P=i("p"),P.textContent=El,Ke=n(),p(q.$$.fragment),Pe=n(),O=i("p"),O.textContent=Nl,qe=n(),ee=i("p"),ee.textContent=_l,Oe=n(),p(le.$$.fragment),el=n(),te=i("p"),te.textContent=Sl,ll=n(),se=i("p"),se.textContent=Hl,tl=n(),p(ne.$$.fragment),sl=n(),ae=i("p"),ae.textContent=Wl,nl=n(),p(ie.$$.fragment),al=n(),p(oe.$$.fragment),il=n(),p(Me.$$.fragment),ol=n(),pe=i("p"),pe.textContent=Rl,Ml=n(),p(re.$$.fragment),pl=n(),we=i("p"),we.innerHTML=zl,rl=n(),ce=i("p"),this.h()},l(e){const l=Ll("svelte-u9bgzb",document.head);u=o(l,"META",{name:!0,content:!0}),l.forEach(t),ye=a(e),me=o(e,"P",{}),Ql(me).forEach(t),Te=a(e),r(h.$$.fragment,e),ue=a(e),J=o(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-sijmec"&&(J.textContent=yl),he=a(e),j=o(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-174b0qn"&&(j.textContent=Tl),Je=a(e),r(U.$$.fragment,e),je=a(e),f=o(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1wb1rsu"&&(f.textContent=ul),Ue=a(e),r(C.$$.fragment,e),fe=a(e),b=o(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-ponep"&&(b.textContent=hl),Ce=a(e),d=o(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-161c9o7"&&(d.textContent=Jl),be=a(e),r(I.$$.fragment,e),de=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-2y0hnt"&&(v.textContent=jl),Ie=a(e),x=o(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1phmdq0"&&(x.textContent=Ul),ve=a(e),r(g.$$.fragment,e),xe=a(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-7o9nvi"&&(A.textContent=fl),ge=a(e),r(B.$$.fragment,e),Ae=a(e),$=o(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1aqrp0c"&&($.textContent=Cl),Be=a(e),r(k.$$.fragment,e),$e=a(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1n7p8h5"&&(Z.textContent=bl),ke=a(e),E=o(e,"UL",{"data-svelte-h":!0}),M(E)!=="svelte-1erfm5m"&&(E.innerHTML=dl),Ze=a(e),r(N.$$.fragment,e),Ee=a(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-ucrnk0"&&(_.textContent=Il),Ne=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1q9jr09"&&(S.textContent=vl),_e=a(e),r(H.$$.fragment,e),Se=a(e),r(W.$$.fragment,e),He=a(e),R=o(e,"UL",{"data-svelte-h":!0}),M(R)!=="svelte-141ia0e"&&(R.innerHTML=xl),We=a(e),r(z.$$.fragment,e),Re=a(e),Q=o(e,"UL",{"data-svelte-h":!0}),M(Q)!=="svelte-1fof3jx"&&(Q.innerHTML=gl),ze=a(e),r(Y.$$.fragment,e),Qe=a(e),V=o(e,"UL",{"data-svelte-h":!0}),M(V)!=="svelte-20uax5"&&(V.innerHTML=Al),Ye=a(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1wb1jef"&&(X.textContent=Bl),Ve=a(e),r(G.$$.fragment,e),Xe=a(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-3ec6p4"&&(D.textContent=$l),Ge=a(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1jsp81n"&&(F.textContent=kl),De=a(e),L=o(e,"OL",{"data-svelte-h":!0}),M(L)!=="svelte-123p5si"&&(L.innerHTML=Zl),Fe=a(e),r(K.$$.fragment,e),Le=a(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-iz02dd"&&(P.textContent=El),Ke=a(e),r(q.$$.fragment,e),Pe=a(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1kof70t"&&(O.textContent=Nl),qe=a(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1t9atje"&&(ee.textContent=_l),Oe=a(e),r(le.$$.fragment,e),el=a(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-17n9xro"&&(te.textContent=Sl),ll=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1cfo99"&&(se.textContent=Hl),tl=a(e),r(ne.$$.fragment,e),sl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-gwdx3y"&&(ae.textContent=Wl),nl=a(e),r(ie.$$.fragment,e),al=a(e),r(oe.$$.fragment,e),il=a(e),r(Me.$$.fragment,e),ol=a(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-10vxwno"&&(pe.textContent=Rl),Ml=a(e),r(re.$$.fragment,e),pl=a(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1fc7bef"&&(we.innerHTML=zl),rl=a(e),ce=o(e,"P",{}),Ql(ce).forEach(t),this.h()},h(){Yl(u,"name","hf:doc:metadata"),Yl(u,"content",ql)},m(e,l){Kl(document.head,u),s(e,ye,l),s(e,me,l),s(e,Te,l),w(h,e,l),s(e,ue,l),s(e,J,l),s(e,he,l),s(e,j,l),s(e,Je,l),w(U,e,l),s(e,je,l),s(e,f,l),s(e,Ue,l),w(C,e,l),s(e,fe,l),s(e,b,l),s(e,Ce,l),s(e,d,l),s(e,be,l),w(I,e,l),s(e,de,l),s(e,v,l),s(e,Ie,l),s(e,x,l),s(e,ve,l),w(g,e,l),s(e,xe,l),s(e,A,l),s(e,ge,l),w(B,e,l),s(e,Ae,l),s(e,$,l),s(e,Be,l),w(k,e,l),s(e,$e,l),s(e,Z,l),s(e,ke,l),s(e,E,l),s(e,Ze,l),w(N,e,l),s(e,Ee,l),s(e,_,l),s(e,Ne,l),s(e,S,l),s(e,_e,l),w(H,e,l),s(e,Se,l),w(W,e,l),s(e,He,l),s(e,R,l),s(e,We,l),w(z,e,l),s(e,Re,l),s(e,Q,l),s(e,ze,l),w(Y,e,l),s(e,Qe,l),s(e,V,l),s(e,Ye,l),s(e,X,l),s(e,Ve,l),w(G,e,l),s(e,Xe,l),s(e,D,l),s(e,Ge,l),s(e,F,l),s(e,De,l),s(e,L,l),s(e,Fe,l),w(K,e,l),s(e,Le,l),s(e,P,l),s(e,Ke,l),w(q,e,l),s(e,Pe,l),s(e,O,l),s(e,qe,l),s(e,ee,l),s(e,Oe,l),w(le,e,l),s(e,el,l),s(e,te,l),s(e,ll,l),s(e,se,l),s(e,tl,l),w(ne,e,l),s(e,sl,l),s(e,ae,l),s(e,nl,l),w(ie,e,l),s(e,al,l),w(oe,e,l),s(e,il,l),w(Me,e,l),s(e,ol,l),s(e,pe,l),s(e,Ml,l),w(re,e,l),s(e,pl,l),s(e,we,l),s(e,rl,l),s(e,ce,l),wl=!0},p:Xl,i(e){wl||(m(h.$$.fragment,e),m(U.$$.fragment,e),m(C.$$.fragment,e),m(I.$$.fragment,e),m(g.$$.fragment,e),m(B.$$.fragment,e),m(k.$$.fragment,e),m(N.$$.fragment,e),m(H.$$.fragment,e),m(W.$$.fragment,e),m(z.$$.fragment,e),m(Y.$$.fragment,e),m(G.$$.fragment,e),m(K.$$.fragment,e),m(q.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(Me.$$.fragment,e),m(re.$$.fragment,e),wl=!0)},o(e){c(h.$$.fragment,e),c(U.$$.fragment,e),c(C.$$.fragment,e),c(I.$$.fragment,e),c(g.$$.fragment,e),c(B.$$.fragment,e),c(k.$$.fragment,e),c(N.$$.fragment,e),c(H.$$.fragment,e),c(W.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),c(G.$$.fragment,e),c(K.$$.fragment,e),c(q.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(re.$$.fragment,e),wl=!1},d(e){e&&(t(ye),t(me),t(Te),t(ue),t(J),t(he),t(j),t(Je),t(je),t(f),t(Ue),t(fe),t(b),t(Ce),t(d),t(be),t(de),t(v),t(Ie),t(x),t(ve),t(xe),t(A),t(ge),t(Ae),t($),t(Be),t($e),t(Z),t(ke),t(E),t(Ze),t(Ee),t(_),t(Ne),t(S),t(_e),t(Se),t(He),t(R),t(We),t(Re),t(Q),t(ze),t(Qe),t(V),t(Ye),t(X),t(Ve),t(Xe),t(D),t(Ge),t(F),t(De),t(L),t(Fe),t(Le),t(P),t(Ke),t(Pe),t(O),t(qe),t(ee),t(Oe),t(el),t(te),t(ll),t(se),t(tl),t(sl),t(ae),t(nl),t(al),t(il),t(ol),t(pe),t(Ml),t(pl),t(we),t(rl),t(ce)),t(u),y(h,e),y(U,e),y(C,e),y(I,e),y(g,e),y(B,e),y(k,e),y(N,e),y(H,e),y(W,e),y(z,e),y(Y,e),y(G,e),y(K,e),y(q,e),y(le,e),y(ne,e),y(ie,e),y(oe,e),y(Me,e),y(re,e)}}}const ql='{"title":"MobileNet","local":"mobilenet","sections":[{"title":"Convolution Types on MobileNet","local":"convolution-types-on-mobilenet","sections":[{"title":"Depthwise Seperable Convolutions","local":"depthwise-seperable-convolutions","sections":[],"depth":3},{"title":"Pointwise Seperable Convolutions","local":"pointwise-seperable-convolutions","sections":[],"depth":3},{"title":"Why Do We Use These Convolutions Instead of Regular Convolutions?","local":"why-do-we-use-these-convolutions-instead-of-regular-convolutions","sections":[{"title":"Regular Convolutions, a big, All-in-one Filter","local":"regular-convolutions-a-big-all-in-one-filter","sections":[],"depth":4},{"title":"Depthwise Separable Convolutions - Two-Step, Lighter Process:","local":"depthwise-separable-convolutions---two-step-lighter-process","sections":[],"depth":4},{"title":"What are these steps about?","local":"what-are-these-steps-about","sections":[],"depth":4}],"depth":3},{"title":"How Do 1x1 Convolutions Work Compared to Normal Convolutions?","local":"how-do-1x1-convolutions-work-compared-to-normal-convolutions","sections":[{"title":"Normal Convolutions","local":"normal-convolutions","sections":[],"depth":4},{"title":"1x1 Convolutions","local":"1x1-convolutions","sections":[],"depth":4},{"title":"Key Differences","local":"key-differences","sections":[],"depth":4}],"depth":3},{"title":"Channel-wise Linear Bottleneck Layers","local":"channel-wise-linear-bottleneck-layers","sections":[],"depth":3},{"title":"What does ReLU do?","local":"what-does-relu-do","sections":[{"title":"Vanishing Gradient Problem","local":"vanishing-gradient-problem","sections":[],"depth":4},{"title":"Non-Linearity","local":"non-linearity","sections":[],"depth":4}],"depth":3},{"title":"Inference","local":"inference","sections":[],"depth":3},{"title":"Example Implementation using PyTorch","local":"example-implementation-using-pytorch","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ol(cl){return Gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nt extends Dl{constructor(u){super(),Fl(this,u,Ol,Pl,Vl,{})}}export{nt as component};
