import{s as L,n as H,o as Y}from"../chunks/scheduler.7bc62968.js";import{S as F,i as K,g as o,s as t,r as p,A as P,h as C,f as e,c as a,j as $,u as A,x as v,k as _,y as O,a as n,v as c,d as u,t as m,w as d}from"../chunks/index.2f8492b0.js";import{C as q}from"../chunks/CodeBlock.4e96d6f7.js";import{H as k}from"../chunks/Heading.14fb2476.js";function ll(D){let s,B,h,f,y,G,J,g,T,z="The VGG architecture was developed in 2014 by Karen Simonyan and Andrew Zisserman from the Visual Geometry Group -and hence named VGG- at Oxford University. The model demonstrated significant improvements over the past models at that time- to be specific 2014 Imagenet challange also known as ILSVRC.",Q,U,Z,i,X="<li>Inputs are 224X224 images.</li> <li>Convolution kernel shape is (3,3) and max pooling window shape is (2,2).</li> <li>Number of channels for each convolutional layer 64 -&gt; 128 -&gt; 256 -&gt; 512 -&gt; 512.</li> <li>VGG16 has 16 hidden layers (13 convolutional layers and 3 fully connected layers).</li> <li>VGG19 has 19 hidden layers (16 convolutional layers and 3 fully connected layers).</li>",x,w,E,j,W="<li>VGG (16 or 19 layers) was relatively deeper than other SOTA networks at the time. AlexNet, the winning model for ILSVRC 2012 only has 8 layers.</li> <li>Multiple small (3X3) receptive field filters with ReLU activation instead of one large (7X7 or 11X11) filter lead to better learning of complex features. Smaller filters also mean fewer parameters per layer, with additional nonlinearity introduced in between.</li> <li>Multiscale training and inference. Each image was trained in multiple rounds with varying scales to ensure similar characteristics were captured at different sizes.</li> <li>Consistency and simplicity of the VGG network make it easier to scale or modify for future improvements.</li>",V,I,S,r,R,b,N;return y=new k({props:{title:"Very Deep Convolutional Networks for Large Scale Image Recognition (2014)",local:"very-deep-convolutional-networks-for-large-scale-image-recognition-2014",headingTag:"h1"}}),J=new k({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),U=new k({props:{title:"VGG Network Architechture",local:"vgg-network-architechture",headingTag:"h2"}}),w=new k({props:{title:"Key Comparisons",local:"key-comparisons",headingTag:"h2"}}),I=new k({props:{title:"PyTorch Example",local:"pytorch-example",headingTag:"h2"}}),r=new q({props:{code:"aW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBJTBBY2xhc3MlMjBWR0cxOShubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG51bV9jbGFzc2VzJTNEMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcihWR0cxOSUyQyUyMHNlbGYpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBGZWF0dXJlJTIwZXh0cmFjdGlvbiUyMGxheWVycyUzQSUyMENvbnZvbHV0aW9uYWwlMjBhbmQlMjBwb29saW5nJTIwbGF5ZXJzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5mZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMG5uLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uQ29udjJkKDMlMkMlMjA2NCUyQyUyMGtlcm5lbF9zaXplJTNEMyUyQyUyMHBhZGRpbmclM0QxKSUyQyUyMCUyMCUyMyUyMDMlMjBpbnB1dCUyMGNoYW5uZWxzJTJDJTIwNjQlMjBvdXRwdXQlMjBjaGFubmVscyUyQyUyMDN4MyUyMGtlcm5lbCUyQyUyMDElMjBwYWRkaW5nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uUmVMVSgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uQ29udjJkKDY0JTJDJTIwNjQlMkMlMjBrZXJuZWxfc2l6ZSUzRDMlMkMlMjBwYWRkaW5nJTNEMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5NYXhQb29sMmQoa2VybmVsX3NpemUlM0QyJTJDJTIwc3RyaWRlJTNEMiklMkMlMjAlMjAlMjMlMjBNYXglMjBwb29saW5nJTIwd2l0aCUyMDJ4MiUyMGtlcm5lbCUyMGFuZCUyMHN0cmlkZSUyMDIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5Db252MmQoNjQlMkMlMjAxMjglMkMlMjBrZXJuZWxfc2l6ZSUzRDMlMkMlMjBwYWRkaW5nJTNEMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5Db252MmQoMTI4JTJDJTIwMTI4JTJDJTIwa2VybmVsX3NpemUlM0QzJTJDJTIwcGFkZGluZyUzRDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uUmVMVSgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTWF4UG9vbDJkKGtlcm5lbF9zaXplJTNEMiUyQyUyMHN0cmlkZSUzRDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uQ29udjJkKDEyOCUyQyUyMDI1NiUyQyUyMGtlcm5lbF9zaXplJTNEMyUyQyUyMHBhZGRpbmclM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLkNvbnYyZCgyNTYlMkMlMjAyNTYlMkMlMjBrZXJuZWxfc2l6ZSUzRDMlMkMlMjBwYWRkaW5nJTNEMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5Db252MmQoMjU2JTJDJTIwMjU2JTJDJTIwa2VybmVsX3NpemUlM0QzJTJDJTIwcGFkZGluZyUzRDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uUmVMVSgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uQ29udjJkKDI1NiUyQyUyMDI1NiUyQyUyMGtlcm5lbF9zaXplJTNEMyUyQyUyMHBhZGRpbmclM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLk1heFBvb2wyZChrZXJuZWxfc2l6ZSUzRDIlMkMlMjBzdHJpZGUlM0QyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLkNvbnYyZCgyNTYlMkMlMjA1MTIlMkMlMjBrZXJuZWxfc2l6ZSUzRDMlMkMlMjBwYWRkaW5nJTNEMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5Db252MmQoNTEyJTJDJTIwNTEyJTJDJTIwa2VybmVsX3NpemUlM0QzJTJDJTIwcGFkZGluZyUzRDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uUmVMVSgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uQ29udjJkKDUxMiUyQyUyMDUxMiUyQyUyMGtlcm5lbF9zaXplJTNEMyUyQyUyMHBhZGRpbmclM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLkNvbnYyZCg1MTIlMkMlMjA1MTIlMkMlMjBrZXJuZWxfc2l6ZSUzRDMlMkMlMjBwYWRkaW5nJTNEMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5NYXhQb29sMmQoa2VybmVsX3NpemUlM0QyJTJDJTIwc3RyaWRlJTNEMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRnVsbHklMjBjb25uZWN0ZWQlMjBsYXllcnMlMjBmb3IlMjBjbGFzc2lmaWNhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2xhc3NpZmllciUyMCUzRCUyMG5uLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTGluZWFyKDUxMiUyMColMjA3JTIwKiUyMDclMkMlMjA0MDk2KSUyQyUyMCUyMCUyMyUyMDUxMiUyMGNoYW5uZWxzJTJDJTIwN3g3JTIwc3BhdGlhbCUyMGRpbWVuc2lvbnMlMjBhZnRlciUyMG1heCUyMHBvb2xpbmclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5Ecm9wb3V0KDAuNSklMkMlMjAlMjAlMjMlMjBEcm9wb3V0JTIwbGF5ZXIlMjB3aXRoJTIwMC41JTIwZHJvcG91dCUyMHByb2JhYmlsaXR5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTGluZWFyKDQwOTYlMkMlMjA0MDk2KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLkRyb3BvdXQoMC41KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLkxpbmVhcig0MDk2JTJDJTIwbnVtX2NsYXNzZXMpJTJDJTIwJTIwJTIzJTIwT3V0cHV0JTIwbGF5ZXIlMjB3aXRoJTIwJ251bV9jbGFzc2VzJyUyMG91dHB1dCUyMHVuaXRzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYuZmVhdHVyZV9leHRyYWN0b3IoeCklMjAlMjAlMjMlMjBQYXNzJTIwaW5wdXQlMjB0aHJvdWdoJTIwdGhlJTIwZmVhdHVyZSUyMGV4dHJhY3RvciUyMGxheWVycyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjB4LnZpZXcoeC5zaXplKDApJTJDJTIwLTEpJTIwJTIwJTIzJTIwRmxhdHRlbiUyMHRoZSUyMG91dHB1dCUyMGZvciUyMHRoZSUyMGZ1bGx5JTIwY29ubmVjdGVkJTIwbGF5ZXJzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYuY2xhc3NpZmllcih4KSUyMCUyMCUyMyUyMFBhc3MlMjBmbGF0dGVuZWQlMjBvdXRwdXQlMjB0aHJvdWdoJTIwdGhlJTIwY2xhc3NpZmllciUyMGxheWVycyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMjBpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEElMjA=",highlighted:`import torch.nn as nn

class VGG19(nn.Module):
    def __init__(self, <span class="hljs-attribute">num_classes</span>=1000):
        super(VGG19, self).__init__()
        
        # Feature extraction layers: Convolutional <span class="hljs-keyword">and</span> pooling layers
        self.feature_extractor = nn.Sequential(
            nn.Conv2d(3, 64, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),  # 3 input channels, 64 output channels, 3x3 kernel, 1 padding
            nn.ReLU(),
            nn.Conv2d(64, 64, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),
            nn.ReLU(),
            nn.MaxPool2d(<span class="hljs-attribute">kernel_size</span>=2, <span class="hljs-attribute">stride</span>=2),  # Max pooling with 2x2 kernel <span class="hljs-keyword">and</span> stride 2
            
            nn.Conv2d(64, 128, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),
            nn.ReLU(),
            nn.Conv2d(128, 128, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),
            nn.ReLU(),
            nn.MaxPool2d(<span class="hljs-attribute">kernel_size</span>=2, <span class="hljs-attribute">stride</span>=2),
            
            nn.Conv2d(128, 256, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),
            nn.ReLU(),
            nn.Conv2d(256, 256, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),
            nn.ReLU(),
            nn.Conv2d(256, 256, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),
            nn.ReLU(),
            nn.Conv2d(256, 256, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),
            nn.ReLU(),
            nn.MaxPool2d(<span class="hljs-attribute">kernel_size</span>=2, <span class="hljs-attribute">stride</span>=2),
            
            nn.Conv2d(256, 512, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),
            nn.ReLU(),
            nn.Conv2d(512, 512, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),
            nn.ReLU(),
            nn.Conv2d(512, 512, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),
            nn.ReLU(),
            nn.Conv2d(512, 512, <span class="hljs-attribute">kernel_size</span>=3, <span class="hljs-attribute">padding</span>=1),
            nn.ReLU(),
            nn.MaxPool2d(<span class="hljs-attribute">kernel_size</span>=2, <span class="hljs-attribute">stride</span>=2),
        )

        # Fully connected layers <span class="hljs-keyword">for</span> classification
        self.classifier = nn.Sequential(
            nn.Linear(512 * 7 * 7, 4096),  # 512 channels, 7x7 spatial dimensions after max pooling
            nn.ReLU(),
            nn.Dropout(0.5),  # Dropout layer with 0.5 dropout probability
            nn.Linear(4096, 4096),
            nn.ReLU(),
            nn.Dropout(0.5),
            nn.Linear(4096, num_classes),  # Output layer with <span class="hljs-string">&#x27;num_classes&#x27;</span> output units
        )

    def forward(self, x):
        x = self.feature_extractor(x)  # Pass input through the feature extractor layers
        x = x.view(x.size(0), -1)  # Flatten the output <span class="hljs-keyword">for</span> the fully connected layers
        x = self.classifier(x)  # Pass flattened output through the classifier layers
        return x
 import torch.nn as nn

 `,wrap:!1}}),{c(){s=o("meta"),B=t(),h=o("p"),f=t(),p(y.$$.fragment),G=t(),p(J.$$.fragment),g=t(),T=o("p"),T.textContent=z,Q=t(),p(U.$$.fragment),Z=t(),i=o("ul"),i.innerHTML=X,x=t(),p(w.$$.fragment),E=t(),j=o("ul"),j.innerHTML=W,V=t(),p(I.$$.fragment),S=t(),p(r.$$.fragment),R=t(),b=o("p"),this.h()},l(l){const M=P("svelte-u9bgzb",document.head);s=C(M,"META",{name:!0,content:!0}),M.forEach(e),B=a(l),h=C(l,"P",{}),$(h).forEach(e),f=a(l),A(y.$$.fragment,l),G=a(l),A(J.$$.fragment,l),g=a(l),T=C(l,"P",{"data-svelte-h":!0}),v(T)!=="svelte-13pxk3z"&&(T.textContent=z),Q=a(l),A(U.$$.fragment,l),Z=a(l),i=C(l,"UL",{"data-svelte-h":!0}),v(i)!=="svelte-seg2ud"&&(i.innerHTML=X),x=a(l),A(w.$$.fragment,l),E=a(l),j=C(l,"UL",{"data-svelte-h":!0}),v(j)!=="svelte-qri0w"&&(j.innerHTML=W),V=a(l),A(I.$$.fragment,l),S=a(l),A(r.$$.fragment,l),R=a(l),b=C(l,"P",{}),$(b).forEach(e),this.h()},h(){_(s,"name","hf:doc:metadata"),_(s,"content",Ml)},m(l,M){O(document.head,s),n(l,B,M),n(l,h,M),n(l,f,M),c(y,l,M),n(l,G,M),c(J,l,M),n(l,g,M),n(l,T,M),n(l,Q,M),c(U,l,M),n(l,Z,M),n(l,i,M),n(l,x,M),c(w,l,M),n(l,E,M),n(l,j,M),n(l,V,M),c(I,l,M),n(l,S,M),c(r,l,M),n(l,R,M),n(l,b,M),N=!0},p:H,i(l){N||(u(y.$$.fragment,l),u(J.$$.fragment,l),u(U.$$.fragment,l),u(w.$$.fragment,l),u(I.$$.fragment,l),u(r.$$.fragment,l),N=!0)},o(l){m(y.$$.fragment,l),m(J.$$.fragment,l),m(U.$$.fragment,l),m(w.$$.fragment,l),m(I.$$.fragment,l),m(r.$$.fragment,l),N=!1},d(l){l&&(e(B),e(h),e(f),e(G),e(g),e(T),e(Q),e(Z),e(i),e(x),e(E),e(j),e(V),e(S),e(R),e(b)),e(s),d(y,l),d(J,l),d(U,l),d(w,l),d(I,l),d(r,l)}}}const Ml='{"title":"Very Deep Convolutional Networks for Large Scale Image Recognition (2014)","local":"very-deep-convolutional-networks-for-large-scale-image-recognition-2014","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"VGG Network Architechture","local":"vgg-network-architechture","sections":[],"depth":2},{"title":"Key Comparisons","local":"key-comparisons","sections":[],"depth":2},{"title":"PyTorch Example","local":"pytorch-example","sections":[],"depth":2}],"depth":1}';function el(D){return Y(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yl extends F{constructor(s){super(),K(this,s,el,ll,L,{})}}export{yl as component};
