import{s as lt,f as it,n as ot,o as rt}from"../chunks/scheduler.7bc62968.js";import{S as mt,i as pt,g as i,s as a,r as m,A as Mt,h as o,f as s,c as l,j as nt,u as p,x as r,k as L,y as ct,a as n,v as M,d as c,t as y,w as u}from"../chunks/index.2f8492b0.js";import{C as at}from"../chunks/CodeBlock.4e96d6f7.js";import{H as d}from"../chunks/Heading.14fb2476.js";function yt(_e){let U,D,P,ee,w,te,h,Ge,se,J,ne,T,$e="OneFormer is a groundbreaking approach to image segmentation, a computer vision task that involves dividing an image into meaningful segments. Traditional methods used separate models and architectures for different segmentation tasks, like identifying objects (instance segmentation) or labeling regions (semantic segmentation). More recent attempts aimed to unify these tasks using shared architectures but still required separate training for each task.",ae,f,Se="Enter OneFormer, a universal image segmentation framework designed to overcome these challenges. It introduces a unique multi-task approach, allowing a single model to handle semantic, instance, and panoptic segmentation tasks without the need for separate training on each. The key innovation lies in a task-conditioned joint training strategy, where the model is guided by a task input, making it dynamic and adaptive to different tasks during both training and inference.",le,g,Ee="This breakthrough not only simplifies the training process but also outperforms existing models across various datasets. OneFormer achieves this by using panoptic annotations, unifying the ground truth information needed for all tasks. Additionally, the framework introduces query-text contrastive learning to better distinguish between tasks and improve overall performance.",ie,j,oe,C,Fe='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/oneformer.svg" alt="Oneformer Method"/> <em>Image taken from OneFormer paper</em>',re,I,Ne="To understand OneFormer’s significance, let’s look into the background of image segmentation. In image processing, segmentation involves dividing an image into different parts, which is crucial for tasks like recognizing objects and understanding the content of a scene. Traditionally, two main types of segmentation tasks were semantic segmentation, where pixels are labeled with categories like “road” or “sky,” and instance segmentation, which identifies objects with well-defined boundaries.",me,b,Qe="Over time, researchers proposed panoptic segmentation as a way to unify semantic and instance segmentation tasks. However, even with these advancements, there were challenges. Existing models designed for panoptic segmentation still required separate training for each task, making them semi-universal at best.",pe,k,Xe="This is where OneFormer comes in as a game-changer. It introduces a novel approach – a multi-task universal architecture. The idea is to train this framework only once, using a single universal architecture, a lone model, and just one dataset. The magic happens as OneFormer outperforms specialized frameworks across semantic, instance, and panoptic segmentation tasks. This breakthrough is not just about improving accuracy; it’s about making image segmentation more universal and efficient. With OneFormer, the need for extensive resources and separate training for different tasks becomes a thing of the past.",Me,v,ce,B,ze='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/text_gen.svg" alt="Task Conditioned Joint Training"/>',ye,Z,He="Now, let’s break down the key features of OneFormer that make it stand out:",ue,W,de,A,Ve="OneFormer uses a clever trick called “Task-Dynamic Mask” to better understand and tackle different types of image segmentation tasks. So, when the model encounters an image, it uses this “Task-Dynamic Mask” to decide whether to pay attention to the overall scene, identify specific objects with clear boundaries, or do a combination of both.",Ue,R,he,x,qe="One of the groundbreaking features of OneFormer is its task-conditioned joint training strategy. Instead of training separately for semantic, instance, and panoptic segmentation, OneFormer uniformly samples the task during training. This strategy enables the model to learn and generalize across different segmentation tasks simultaneously. By conditioning the architecture on the specific task through the task token, OneFormer unifies the training process, reducing the need for task-specific architectures, models, and datasets. This innovative approach significantly streamlines the training pipeline and resource requirements.",we,_,Je,G,Ye="Lastly, let’s talk about “Query-Text Contrastive Loss.” Think of it as a way for OneFormer to teach itself about the differences between tasks and classes. In the training process, the model compares the features it extracts from the image (queries) with the corresponding text descriptions (like “a photo with a car”). This helps the model understand the unique characteristics of each task and reduces confusion between different classes. OneFormer’s “Task-Dynamic Mask” allows it to be versatile like a multitasking assistant, and the “Query-Text Contrastive Loss” helps it learn the specifics of each task by comparing visual features with textual descriptions.",Te,$,Oe="By combining these core concepts, OneFormer becomes a smart and efficient tool for image segmentation, making the process more universal and accessible.",fe,S,ge,E,Le='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/plots.svg" alt="result comperison"/> <em>Image taken from OneFormer paper</em>',je,F,Pe="In conclusion, the OneFormer framework represents a groundbreaking approach in the field of image segmentation, aiming to simplify and unify the task across various domains. Unlike traditional methods that rely on specialized architectures for each segmentation task, OneFormer introduces a novel multi-task universal architecture that requires only a single model, trained once on a universal dataset, to outperform existing frameworks. Additionally, the incorporation of query-text contrastive loss during training enhances the model’s ability to learn inter-task and inter-class differences. OneFormer utilizes transformer-based architectures, inspired by recent successes in computer vision, and introduces task-guided queries to improve task sensitivity. The results are impressive, as OneFormer surpasses state-of-the-art models across semantic, instance, and panoptic segmentation tasks on benchmark datasets like ADE20k, Cityscapes, and COCO. The framework’s performance is further enhanced with new ConvNeXt and DiNAT backbones.",Ce,N,Ke="In summary, OneFormer represents a significant step towards universal and accessible image segmentation. By introducing a single model capable of handling diverse segmentation tasks, the framework streamlines the segmentation process and reduces resource requirements.",Ie,Q,be,X,De="Let’s see an example use of the model. Dinat backbone requires Natten library, which may take a while to install.",ke,z,ve,H,et="We can see an inference code below depending on different segmentation types.",Be,V,Ze,q,tt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/oneformer_semantic.png" alt="semantic segmentation"/>',We,Y,Ae,O,st='<li><a href="https://arxiv.org/pdf/2211.06220.pdf" rel="nofollow">OneFormer Paper</a></li> <li><a href="https://huggingface.co/shi-labs/oneformer_ade20k_dinat_large" rel="nofollow">HuggingFace OneFormer model</a></li>',Re,K,xe;return w=new d({props:{title:"OneFormer: One Transformer to Rule Universal Image Segmentation",local:"oneformer-one-transformer-to-rule-universal-image-segmentation",headingTag:"h1"}}),J=new d({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),j=new d({props:{title:"Background of OneFormer",local:"background-of-oneformer",headingTag:"h2"}}),v=new d({props:{title:"Core Concepts of OneFormer",local:"core-concepts-of-oneformer",headingTag:"h2"}}),W=new d({props:{title:"Task-Dynamic Mask",local:"task-dynamic-mask",headingTag:"h3"}}),R=new d({props:{title:"Task-Conditioned Joint Training",local:"task-conditioned-joint-training",headingTag:"h3"}}),_=new d({props:{title:"Query-Text Contrastive Loss",local:"query-text-contrastive-loss",headingTag:"h3"}}),S=new d({props:{title:"Concluison",local:"concluison",headingTag:"h2"}}),Q=new d({props:{title:"Example use of model",local:"example-use-of-model",headingTag:"h2"}}),z=new at({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMG5hdHRlbiUyMA==",highlighted:"!pip install -q natten ",wrap:!1}}),V=new at({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerForUniversalSegmentation
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_segmentation</span>(<span class="hljs-params">image, task_type</span>):
    <span class="hljs-string">&quot;&quot;&quot;Performs image segmentation based on the given task type.

    Args:
        image (PIL.Image): The input image.
        task_type (str): The type of segmentation to perform (&#x27;semantic&#x27;, &#x27;instance&#x27;, or &#x27;panoptic&#x27;).

    Returns:
        PIL.Image: The segmented image.

    Raises:
        ValueError: If the task type is invalid.
    &quot;&quot;&quot;</span>

    processor = OneFormerProcessor.from_pretrained(
        <span class="hljs-string">&quot;shi-labs/oneformer_ade20k_dinat_large&quot;</span>
    )  <span class="hljs-comment"># Load once here</span>
    model = OneFormerForUniversalSegmentation.from_pretrained(
        <span class="hljs-string">&quot;shi-labs/oneformer_ade20k_dinat_large&quot;</span>
    )

    <span class="hljs-keyword">if</span> task_type == <span class="hljs-string">&quot;semantic&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_semantic_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>]

    <span class="hljs-keyword">elif</span> task_type == <span class="hljs-string">&quot;instance&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;instance&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_instance_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]

    <span class="hljs-keyword">elif</span> task_type == <span class="hljs-string">&quot;panoptic&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;panoptic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_panoptic_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]

    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">raise</span> ValueError(
            <span class="hljs-string">&quot;Invalid task type. Choose from &#x27;semantic&#x27;, &#x27;instance&#x27;, or &#x27;panoptic&#x27;&quot;</span>
        )

    <span class="hljs-keyword">return</span> predicted_map


<span class="hljs-keyword">def</span> <span class="hljs-title function_">show_image_comparison</span>(<span class="hljs-params">image, predicted_map, segmentation_title</span>):
    <span class="hljs-string">&quot;&quot;&quot;Displays the original image and the segmented image side-by-side.

    Args:
        image (PIL.Image): The original image.
        predicted_map (PIL.Image): The segmented image.
        segmentation_title (str): The title for the segmented image.
    &quot;&quot;&quot;</span>

    plt.figure(figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">6</span>))
    plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">1</span>)
    plt.imshow(image)
    plt.title(<span class="hljs-string">&quot;Original Image&quot;</span>)
    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
    plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)
    plt.imshow(predicted_map)
    plt.title(segmentation_title + <span class="hljs-string">&quot; Segmentation&quot;</span>)
    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
    plt.show()


url = <span class="hljs-string">&quot;https://huggingface.co/datasets/shi-labs/oneformer_demo/resolve/main/ade20k.jpeg&quot;</span>
response = requests.get(url, stream=<span class="hljs-literal">True</span>)
response.raise_for_status()  <span class="hljs-comment"># Check for HTTP errors</span>
image = Image.<span class="hljs-built_in">open</span>(response.raw)

task_to_run = <span class="hljs-string">&quot;semantic&quot;</span>
predicted_map = run_segmentation(image, task_to_run)
show_image_comparison(image, predicted_map, task_to_run)`,wrap:!1}}),Y=new d({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){U=i("meta"),D=a(),P=i("p"),ee=a(),m(w.$$.fragment),te=a(),h=i("img"),se=a(),m(J.$$.fragment),ne=a(),T=i("p"),T.textContent=$e,ae=a(),f=i("p"),f.textContent=Se,le=a(),g=i("p"),g.textContent=Ee,ie=a(),m(j.$$.fragment),oe=a(),C=i("p"),C.innerHTML=Fe,re=a(),I=i("p"),I.textContent=Ne,me=a(),b=i("p"),b.textContent=Qe,pe=a(),k=i("p"),k.textContent=Xe,Me=a(),m(v.$$.fragment),ce=a(),B=i("p"),B.innerHTML=ze,ye=a(),Z=i("p"),Z.textContent=He,ue=a(),m(W.$$.fragment),de=a(),A=i("p"),A.textContent=Ve,Ue=a(),m(R.$$.fragment),he=a(),x=i("p"),x.textContent=qe,we=a(),m(_.$$.fragment),Je=a(),G=i("p"),G.textContent=Ye,Te=a(),$=i("p"),$.textContent=Oe,fe=a(),m(S.$$.fragment),ge=a(),E=i("p"),E.innerHTML=Le,je=a(),F=i("p"),F.textContent=Pe,Ce=a(),N=i("p"),N.textContent=Ke,Ie=a(),m(Q.$$.fragment),be=a(),X=i("p"),X.textContent=De,ke=a(),m(z.$$.fragment),ve=a(),H=i("p"),H.textContent=et,Be=a(),m(V.$$.fragment),Ze=a(),q=i("p"),q.innerHTML=tt,We=a(),m(Y.$$.fragment),Ae=a(),O=i("ul"),O.innerHTML=st,Re=a(),K=i("p"),this.h()},l(e){const t=Mt("svelte-u9bgzb",document.head);U=o(t,"META",{name:!0,content:!0}),t.forEach(s),D=l(e),P=o(e,"P",{}),nt(P).forEach(s),ee=l(e),p(w.$$.fragment,e),te=l(e),h=o(e,"IMG",{align:!0,width:!0,height:!0,src:!0}),se=l(e),p(J.$$.fragment,e),ne=l(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1hf6o1y"&&(T.textContent=$e),ae=l(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1ty30hf"&&(f.textContent=Se),le=l(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1lma2v6"&&(g.textContent=Ee),ie=l(e),p(j.$$.fragment,e),oe=l(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-10j1l9u"&&(C.innerHTML=Fe),re=l(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ucc15p"&&(I.textContent=Ne),me=l(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-n6259b"&&(b.textContent=Qe),pe=l(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1ujmywj"&&(k.textContent=Xe),Me=l(e),p(v.$$.fragment,e),ce=l(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-m45fcy"&&(B.innerHTML=ze),ye=l(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-rk7g5b"&&(Z.textContent=He),ue=l(e),p(W.$$.fragment,e),de=l(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-iru73r"&&(A.textContent=Ve),Ue=l(e),p(R.$$.fragment,e),he=l(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-fq7603"&&(x.textContent=qe),we=l(e),p(_.$$.fragment,e),Je=l(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1iagkck"&&(G.textContent=Ye),Te=l(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-xjljcp"&&($.textContent=Oe),fe=l(e),p(S.$$.fragment,e),ge=l(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-s6hco9"&&(E.innerHTML=Le),je=l(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-glyvcc"&&(F.textContent=Pe),Ce=l(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1fzjv2z"&&(N.textContent=Ke),Ie=l(e),p(Q.$$.fragment,e),be=l(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-3lq6h2"&&(X.textContent=De),ke=l(e),p(z.$$.fragment,e),ve=l(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-14sbb7i"&&(H.textContent=et),Be=l(e),p(V.$$.fragment,e),Ze=l(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ihn2fs"&&(q.innerHTML=tt),We=l(e),p(Y.$$.fragment,e),Ae=l(e),O=o(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-gdx474"&&(O.innerHTML=st),Re=l(e),K=o(e,"P",{}),nt(K).forEach(s),this.h()},h(){L(U,"name","hf:doc:metadata"),L(U,"content",ut),L(h,"align","center"),L(h,"width","1050"),L(h,"height","303"),it(h.src,Ge="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/teaser.svg")||L(h,"src",Ge)},m(e,t){ct(document.head,U),n(e,D,t),n(e,P,t),n(e,ee,t),M(w,e,t),n(e,te,t),n(e,h,t),n(e,se,t),M(J,e,t),n(e,ne,t),n(e,T,t),n(e,ae,t),n(e,f,t),n(e,le,t),n(e,g,t),n(e,ie,t),M(j,e,t),n(e,oe,t),n(e,C,t),n(e,re,t),n(e,I,t),n(e,me,t),n(e,b,t),n(e,pe,t),n(e,k,t),n(e,Me,t),M(v,e,t),n(e,ce,t),n(e,B,t),n(e,ye,t),n(e,Z,t),n(e,ue,t),M(W,e,t),n(e,de,t),n(e,A,t),n(e,Ue,t),M(R,e,t),n(e,he,t),n(e,x,t),n(e,we,t),M(_,e,t),n(e,Je,t),n(e,G,t),n(e,Te,t),n(e,$,t),n(e,fe,t),M(S,e,t),n(e,ge,t),n(e,E,t),n(e,je,t),n(e,F,t),n(e,Ce,t),n(e,N,t),n(e,Ie,t),M(Q,e,t),n(e,be,t),n(e,X,t),n(e,ke,t),M(z,e,t),n(e,ve,t),n(e,H,t),n(e,Be,t),M(V,e,t),n(e,Ze,t),n(e,q,t),n(e,We,t),M(Y,e,t),n(e,Ae,t),n(e,O,t),n(e,Re,t),n(e,K,t),xe=!0},p:ot,i(e){xe||(c(w.$$.fragment,e),c(J.$$.fragment,e),c(j.$$.fragment,e),c(v.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(_.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(z.$$.fragment,e),c(V.$$.fragment,e),c(Y.$$.fragment,e),xe=!0)},o(e){y(w.$$.fragment,e),y(J.$$.fragment,e),y(j.$$.fragment,e),y(v.$$.fragment,e),y(W.$$.fragment,e),y(R.$$.fragment,e),y(_.$$.fragment,e),y(S.$$.fragment,e),y(Q.$$.fragment,e),y(z.$$.fragment,e),y(V.$$.fragment,e),y(Y.$$.fragment,e),xe=!1},d(e){e&&(s(D),s(P),s(ee),s(te),s(h),s(se),s(ne),s(T),s(ae),s(f),s(le),s(g),s(ie),s(oe),s(C),s(re),s(I),s(me),s(b),s(pe),s(k),s(Me),s(ce),s(B),s(ye),s(Z),s(ue),s(de),s(A),s(Ue),s(he),s(x),s(we),s(Je),s(G),s(Te),s($),s(fe),s(ge),s(E),s(je),s(F),s(Ce),s(N),s(Ie),s(be),s(X),s(ke),s(ve),s(H),s(Be),s(Ze),s(q),s(We),s(Ae),s(O),s(Re),s(K)),s(U),u(w,e),u(J,e),u(j,e),u(v,e),u(W,e),u(R,e),u(_,e),u(S,e),u(Q,e),u(z,e),u(V,e),u(Y,e)}}}const ut='{"title":"OneFormer: One Transformer to Rule Universal Image Segmentation","local":"oneformer-one-transformer-to-rule-universal-image-segmentation","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Background of OneFormer","local":"background-of-oneformer","sections":[],"depth":2},{"title":"Core Concepts of OneFormer","local":"core-concepts-of-oneformer","sections":[{"title":"Task-Dynamic Mask","local":"task-dynamic-mask","sections":[],"depth":3},{"title":"Task-Conditioned Joint Training","local":"task-conditioned-joint-training","sections":[],"depth":3},{"title":"Query-Text Contrastive Loss","local":"query-text-contrastive-loss","sections":[],"depth":3}],"depth":2},{"title":"Concluison","local":"concluison","sections":[],"depth":2},{"title":"Example use of model","local":"example-use-of-model","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function dt(_e){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tt extends mt{constructor(U){super(),pt(this,U,dt,yt,lt,{})}}export{Tt as component};
