import{s as ni,n as ii,o as mi}from"../chunks/scheduler.7bc62968.js";import{S as li,i as pi,g as m,s as n,r as y,m as c,H as o,A as ri,h as l,f as s,c as i,j as d,u as w,x as r,n as g,B as h,k as T,y as p,a as e,v as x,d as _,t as b,w as z}from"../chunks/index.2f8492b0.js";import{H as M}from"../chunks/Heading.14fb2476.js";function oi(Pe){let P,ls,ss,ps,E,rs,j,He="This section explains how stereo vision works and how it can be used to find the 3-dimensional structure of surrounding objects. Stereo vision involves capturing two or more images of the same scene from varying positions and viewpoints. These images can be obtained using multiple cameras or by repositioning the same camera.",os,S,hs,W,De="Let’s understand the problem statement of finding the 3D structure of objects by understanding the geometry of image formation. As shown in Figure 1, we have a point P in 3D with x, y, z coordinates. Point P gets projected to the camera’s image plane via the pinhole. This can also be viewed as projecting a 3D point to a 2D image plane.",cs,F,Ie="Now, let’s say we are given this 2D image and the location of the pixel coordinates of point P in this image. We want to find the 3D coordinates of point P. Is this possible? Is point P unique, or are there other 3D points that also map to the same pixel coordinates as point P? Answer is that all 3D points that lie on the line joining point P, and the pinhole will map to the same pixel coordinates in the 2D image plane.",gs,X,Re="We aim to solve the problem of determining the 3D structure of objects. In our problem statement, we can represent an object in 3D as a set of 3D points. Finding the 3D coordinates of each of these points helps us determine the 3D structure of the object.",ds,K,Oe='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/image_formation_single_camera.png?download=true" alt="Figure 1: Image formation using single camera"/>',fs,U,qe="Figure 1: Image formation using single camera",us,Y,vs,B,Ae="Let’s assume we are given the following information:",ys,N,Ee="<li>Single image of a scene point P</li> <li>Pixel coordinates of point P in the image</li> <li>Position and orientation of the camera used to capture the image. For simplicity, we can also place an XYZ coordinate system at the location of the pinhole, with the z-axis perpendicular to the image place and the x-axis, and y-axis parallel to the image plane like in Figure 1.</li> <li>Internal parameters of the camera, such as focal length and location of principal point. The principal point is where the optical axis intersects the image plane. Its location in the image plane is usually denoted as (Ox,Oy).</li>",ws,V,je="With the information provided above, we can find a 3D line that originates from the pixel coordinates of point P (the projection of point P in the image plane), passes through the pinhole, and extends to infinity. Based on the principles of image formation geometry, we can conclude that point P must exist somewhere along this line.",xs,Z,Se="<li>Initially (without an image) point P could have been present anywhere in the 3D space.</li> <li>Using a single image, we reduced possible locations of point P to a single line in 3D.</li> <li>Now, let’s consider whether we can further narrow down the potential locations to pinpoint the precise location of point P on this 3D line.</li> <li>Imagine moving the camera to a different position. Let the coordinate system remain fixed at the previous position. The 3D line we found also remains the same and point P still lies somewhere on this line.</li> <li>From this new location of the camera, capture another image of the same scene point P. Once more, utilizing the pixel coordinates of point P within this new image and considering the updated location of the camera pinhole, find the 3D line on which point P must lie.</li> <li>Now we have 2 lines in 3D and point P lies somewhere on both of these lines. So, point P must lie on the intersection of these 2 lines.</li>",_s,G,We="Given 2 lines in 3D, there are are three possibilities for their intersection:",bs,J,Fe="<li>Intersect at exactly 1 point</li> <li>Intersect at infinite number of points</li> <li>Do not intersect</li>",zs,Q,Xe="If both images (with original and new camera positions) contain point P, we can conclude that the 3D lines must intersect at least once and that the intersection point is point P. Furthermore, we can envision infinite points where both lines intersect only if the two lines are collinear. This is achievable if the pinhole at the new camera position lies somewhere on the original 3D line. For all other positions and orientations of the new camera location, the two 3D lines must intersect precisely at one point, where point P lies.",Ms,aa,Ke="Therefore, using 2 images of the same scene point P, known positions and orientations of the camera locations, and known internal parameters of the camera, we can precisely find where point P lies in the 3D space.",Ls,sa,ks,ta,Ue="Since there are many different positions and orientations for the camera locations which can be selected, we can select a location that makes the math simpler, less complex, and reduces computational processing when running on a computer or an embedded device. One configuration that is popular and generally used is shown in Figure 2. We use 2 cameras in this configuration, which is equivalent to a single camera for capturing 2 images from 2 different locations.",Cs,ea,Ye='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/image_formation_simple_stereo.jpg?download=true" alt="Figure 2: Image formation using 2 cameras"/>',$s,na,Be="Figure 2: Image formation using 2 cameras",Ts,ia,Ne="<li>Origin of the coordinate system is placed at the pinhole of the first camera which is usually the left camera.</li> <li>Z axis of the coordinate system is defined perpendicular to the image plane.</li> <li>X and Y axis of the coordinate system are defined parallel to the image plane.</li> <li>We also have X and Y directions in a 2D image. X is the horizontal direction and Y is the vertical direction. We will refer to these directions in the image plane as u and v respectively. Therefore, pixel coordinates of a point are defined using (u,v) values.</li> <li>X axis of the coordinate system is defined as the u direction / horizontal direction in the image plane.</li> <li>Similarly Y axis of the coordinate system is defined as the v direction / vertical direction in the image plane.</li> <li>Second camera (more precisely the pinhole of the second camera) is placed at a distance b called baseline in the positive x direction to the right of the first camera. Therefore, x,y,z coordinates of pinhole of second camera are (b,0,0)</li> <li>Image plane of the second camera is oriented parallel to the image plane of the first camera.</li> <li>u and v directions in the image plane of second/right camera are aligned with the u and v directions in the image plane of the first/left camera</li> <li>Both left and right cameras are assumed to have the same intrinsic parameters like focal length and location of principal point</li>",Ps,ma,Ve="With the above configuration in place, we have the below equations which map a point in 3D to the image plane in 2D.",Hs,D,I,he,Ds,Dn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo>∗</mo><mfrac><mi>x</mi><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><annotation encoding="application/x-tex">u\\_left = f\\_x * \\frac{x}{z} + O\\_x</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0404em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6954em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.394em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span></span></span></span>',Is,Rs,In='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo>∗</mo><mfrac><mi>y</mi><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>y</mi></mrow><annotation encoding="application/x-tex">v\\_left = f\\_y * \\frac{y}{z} + O\\_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0925em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7475em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.4461em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span></span></span>',ce,R,ge,Os,Rn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo>∗</mo><mfrac><mrow><mi>x</mi><mo>−</mo><mi>b</mi></mrow><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><annotation encoding="application/x-tex">u\\_right = f\\_x * \\frac{x-b}{z} + O\\_x</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.2251em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8801em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.394em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">b</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span></span></span></span>',qs,As,On='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo>∗</mo><mfrac><mi>y</mi><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>y</mi></mrow><annotation encoding="application/x-tex">v\\_right = f\\_y * \\frac{y}{z} + O\\_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0925em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7475em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.4461em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span></span></span>',Es,v,de,O,js,qn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>u</mi><mi>l</mi></msub><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal">u</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',Ss,Ws,An='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>v</mi><mi>l</mi></msub><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',Fs,Xs,En='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>u</mi><mi>r</mi></msub><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal">u</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',Ks,Us,jn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>v</mi><mi>r</mi></msub><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',Ys,Bs,Sn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>f</mi><mi>X</mi></msub></mrow><annotation encoding="application/x-tex">f_X</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:-0.1076em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.07847em;">X</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Ns,Vs,Wn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>f</mi><mi>y</mi></msub></mrow><annotation encoding="application/x-tex">f_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9805em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.1076em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',Zs,Gs,q,H,fe,Js,Fn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mn>0</mn><mi>X</mi></msub></mrow><annotation encoding="application/x-tex">0_X</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7944em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord">0</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.07847em;">X</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Qs,at,Xn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mn>0</mn><mi>y</mi></msub></mrow><annotation encoding="application/x-tex">0_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9305em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord">0</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',st,ue,Ka,Ze="b is called the baseline and refers to the distance between the left and right cameras. Same units are used for both b and x,y,z coordinates (any unit like cm, feet, etc can be used)",tt,la,Ge="We have 4 equations above and 3 unknowns - x, y and z coordinates of a 3D point P. Intrinsic camera parameters - focal lengths and principal point are assumed to be known. Equations 1.2 and 2.2 indicate that the v coordinate value in the left and right images is the same.",et,pa,ve,nt,Kn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>=</mo><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_left = v\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',it,ra,Je="Using equations 1.1, 1.2 and 2.1 we can derive the x,y,z coordinates of point P.",mt,L,ye,lt,Un='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>x</mi><mo>=</mo><mfrac><mrow><mi>b</mi><mo>∗</mo><mo stretchy="false">(</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo stretchy="false">)</mo></mrow><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow></mfrac></mrow><annotation encoding="application/x-tex">x = \\frac{b * (u\\_left - O\\_x)}{u\\_left - u\\_right}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal">x</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.614em;vertical-align:-0.562em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.052em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span><span class="mord mathnormal mtight">i</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span><span class="mord mathnormal mtight">h</span><span class="mord mathnormal mtight">t</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.527em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mbin mtight">∗</span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">O</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight">x</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.562em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',pt,rt,Yn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>y</mi><mo>=</mo><mfrac><mrow><mi>b</mi><mo>∗</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo>∗</mo><mo stretchy="false">(</mo><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo stretchy="false">)</mo></mrow><mrow><mi>f</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo>∗</mo><mo stretchy="false">(</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi><mo stretchy="false">)</mo></mrow></mfrac></mrow><annotation encoding="application/x-tex">y = \\frac{b * f\\_x * (v\\_left - O\\_y)}{ f\\_y * (u\\_left - u\\_right)}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.614em;vertical-align:-0.562em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.052em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span><span class="mbin mtight">∗</span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span><span class="mord mathnormal mtight">i</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span><span class="mord mathnormal mtight">h</span><span class="mord mathnormal mtight">t</span><span class="mclose mtight">)</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.527em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mbin mtight">∗</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight">x</span><span class="mbin mtight">∗</span><span class="mopen mtight">(</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">v</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">O</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.562em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',ot,ht,Bn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>z</mi><mo>=</mo><mfrac><mrow><mi>b</mi><mo>∗</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow></mfrac></mrow><annotation encoding="application/x-tex">z = \\frac{b * f\\_x}{u\\_left - u\\_right}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal" style="margin-right:0.04398em;">z</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.5751em;vertical-align:-0.562em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.0131em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span><span class="mord mathnormal mtight">i</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span><span class="mord mathnormal mtight">h</span><span class="mord mathnormal mtight">t</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.527em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mbin mtight">∗</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.562em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',ct,oa,Qe="Note that the x and y values above concern the left camera since the origin of the coordinate system is aligned with the left camera. The above equations show that we can find 3D coordinates of a point P using its 2 images captured from 2 different camera locations. z value is also referred to as the depth value. Using this technique, we can find the depth values for different pixels within an image and their real-world x and y coordinates. We can also find real-world distances between different points in an image.",gt,ha,dt,ca,ft,ga,an="We’ll work through an example, capture some images, and perform some calculations to find out if our above assumptions and math work out! For capturing the images we’ll use a hardware known as OAK-D Lite (OAK stands for OpenCV AI Kit). This device has 3 cameras - left and right mono (black and white) and a center color cameras. We’ll use the left and right mono cameras for our experiment. A regular smartphone camera could also be used, but OAK-D lite has some advantages listed below.",ut,da,sn="<li>Intrinsic camera parameters like focal length and location of principal point are known for an OAK-D Lite since the device comes pre-calibrated, and these parameters can be read from the device using its Python API. For a smartphone camera, intrinsic parameters need to be determined and could be found by performing camera calibration or sometimes present in the metadata of the image captured using the smartphone.</li> <li>One of the main assumptions above is that the position and orientation of the left and right cameras are known. Using a smartphone camera, it may be difficult to determine this information or additional calibration may be required.  On the other hand, for an OAK-D Lite device, the position and orientation of the left and right cameras are fixed, known, pre-calibrated, and very similar to the geometry of the simplified solution mentioned above. Although some post-processing/image rectification detailed below on the raw images is still required.</li>",vt,fa,yt,ua,tn="The left and right cameras in OAK-D Lite are oriented similarly to the geometry of the simplified solution detailed above. The baseline distance between the left and right cameras is 7.5cm. Left and right images of a scene captured using this device are shown below. The figure also shows these images stacked horizontally with a red line drawn at a constant height (i.e. at a constant v value ). We’ll refer to the horizontal x-axis as u and the vertical y-axis as v.",wt,va,en=`Raw Left Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_left_frame.jpg?download=true" alt="Raw Left Image"/>`,xt,ya,nn=`Raw Right Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_right_frame.jpg?download=true" alt="Raw Right Image"/>`,_t,wa,mn=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_stacked_frames.jpg?download=true" alt="Raw Stacked Left and Right Images "/>
Raw Stacked Left and Right Images`,bt,xa,ln="Let’s focus on a single point - the top left corner of the laptop. As per equation 3 above,\\(v_left = v_right\\) for the same point in the left and right images. However, notice that the red line, which is at a constant v value, touches the top-left corner of the laptop in the left image but misses this point by a few pixels in the right image. There are two main reasons for this discrepancy:",zt,_a,pn="<li>The intrinsic parameters for the left and right cameras are different. The principal point for the left camera is at (319.13, 233.86), whereas it is (298.85, 245.52) for the right camera. The focal length for the left camera is 450.9, whereas it is 452.9 for the right camera. The values of fx are equal to fy for both the left and right cameras. These intrinsic parameters were read from the device using it’s python API and could be different for different OAK-D Lite devices.</li> <li>Left and right camera orientations differ slightly from the geometry of the simplified solution detailed above.</li>",Mt,ba,Lt,za,rn='We can perform image rectification/post-processing to correct for differences in intrinsic parameters and orientations of the left and right cameras. This process involves performing 3x3 matrix transformations. In the OAK-D Lite API, a stereo node performs these calculations and outputs the rectified left and right images. Details and source code can be viewed <a href="https://github.com/luxonis/depthai-experiments/blob/master/gen2-stereo-on-host/main.py" rel="nofollow">here</a>. In this specific implementation, correction for intrinsic parameters is performed using intrinsic camera matrices, and correction for orientation is performed using rotation matrices(part of calibration parameters) for the left and right cameras. The rectified left image is transformed as if the left camera had the same intrinsic parameters as the right one. Therefore, in all our following calculations, we’ll use the intrinsic parameters for the right camera i.e. focal length of 452.9 and principal point at (298.85, 245.52). In the rectified and stacked images below, notice that the red line at constant v touches the top-left corner of the laptop in both the left and right images.',kt,Ma,on=`Rectified Left Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_left_frame.jpg?download=true" alt="Rectified Left Image"/>`,Ct,La,hn=`Rectified Right Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_right_frame.jpg?download=true" alt="Rectified Right Image"/>`,$t,ka,cn=`Rectified and Stacked Left and Right Images
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_stacked_frames.jpg?download=true" alt="Rectified and Stacked Left and Right Images"/>`,Tt,C,we,Pt,Nn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_left - u\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',Ht,Dt,Vn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_left - u\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',It,Rt,Ca,gn=`Rectified and Overlapped Left and Right Images
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_overlapping_frames.jpg?download=true" alt="Rectified and Overlapped Left and Right Images"/>`,Ot,$a,qt,Ta,dn="Let’s find the 3D coordinates for some points in the scene. A few points are selected and manually annotated with their (u,v) values, as shown in the figures below. Instead of manual annotations, we can also use template-based matching, feature detection algorithms like SIFT, etc for finding corresponding points in left and right images.",At,Pa,fn=`Annotated Left Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/annotated_left_img.jpg?download=true" alt="Annotated Left Image"/>`,Et,Ha,un=`Annotated Right Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/annotated_right_img.jpg?download=true" alt="Annotated Right Image"/>`,jt,Da,St,Ia,vn="Twelve points are selected in the scene, and their (u,v) values in the left and right images are tabulated below. Using equations 4, 5, and 6, (x,y,z) coordinates for these points are also calculated and tabulated below. X and Y coordinates concerning the left camera, and the origin is at the left camera’s pinhole (or optical center of the lens). Therefore, 3D points left and above the pinhole have negative X and Y values, respectively.",Wt,A,ts,f,Ra,yn="point",xe,Ua,Ft,Zn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>u</mi><mi>l</mi></msub><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal">u</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',_e,Ya,Xt,Gn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>v</mi><mi>l</mi></msub><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',be,Ba,Kt,Jn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>u</mi><mi>r</mi></msub><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal">u</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',ze,Na,Ut,Qn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>v</mi><mi>r</mi></msub><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',Me,Oa,wn="depth/z(cm)",Le,Va,Yt,ai='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>w</mi></msub><mi>r</mi><msub><mi>t</mi><mi>l</mi></msub><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">x_wrt_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02691em;">w</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord"><span class="mord mathnormal">t</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',ke,Za,Bt,si='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>y</mi><mi>w</mi></msub><mi>r</mi><msub><mi>t</mi><mi>l</mi></msub><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">y_wrt_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02691em;">w</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord"><span class="mord mathnormal">t</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',Ce,Ga,xn='<tr><td align="center">pt1</td> <td align="center">138</td> <td align="center">219</td> <td align="center">102</td> <td align="center">219</td> <td align="center">94.36</td> <td align="center">-33.51</td> <td align="center">-5.53</td></tr> <tr><td align="center">pt2</td> <td align="center">264</td> <td align="center">216</td> <td align="center">234</td> <td align="center">217</td> <td align="center">113.23</td> <td align="center">-8.72</td> <td align="center">-7.38</td></tr> <tr><td align="center">pt3</td> <td align="center">137</td> <td align="center">320</td> <td align="center">101</td> <td align="center">321</td> <td align="center">94.36</td> <td align="center">-33.72</td> <td align="center">15.52</td></tr> <tr><td align="center">pt4</td> <td align="center">263</td> <td align="center">303</td> <td align="center">233</td> <td align="center">302</td> <td align="center">113.23</td> <td align="center">-8.97</td> <td align="center">14.37</td></tr> <tr><td align="center">pt5</td> <td align="center">307</td> <td align="center">211</td> <td align="center">280</td> <td align="center">211</td> <td align="center">125.81</td> <td align="center">2.26</td> <td align="center">-9.59</td></tr> <tr><td align="center">pt6</td> <td align="center">367</td> <td align="center">212</td> <td align="center">339</td> <td align="center">212</td> <td align="center">121.32</td> <td align="center">18.25</td> <td align="center">-8.98</td></tr> <tr><td align="center">pt7</td> <td align="center">305</td> <td align="center">298</td> <td align="center">278</td> <td align="center">298</td> <td align="center">125.81</td> <td align="center">1.71</td> <td align="center">14.58</td></tr> <tr><td align="center">pt8</td> <td align="center">365</td> <td align="center">299</td> <td align="center">338</td> <td align="center">299</td> <td align="center">125.81</td> <td align="center">18.37</td> <td align="center">14.86</td></tr> <tr><td align="center">pt9</td> <td align="center">466</td> <td align="center">225</td> <td align="center">415</td> <td align="center">225</td> <td align="center">66.61</td> <td align="center">24.58</td> <td align="center">-3.02</td></tr> <tr><td align="center">pt10</td> <td align="center">581</td> <td align="center">225</td> <td align="center">530</td> <td align="center">226</td> <td align="center">66.61</td> <td align="center">41.49</td> <td align="center">-3.02</td></tr> <tr><td align="center">pt11</td> <td align="center">464</td> <td align="center">387</td> <td align="center">413</td> <td align="center">388</td> <td align="center">66.61</td> <td align="center">24.29</td> <td align="center">20.81</td></tr> <tr><td align="center">pt12</td> <td align="center">579</td> <td align="center">388</td> <td align="center">528</td> <td align="center">390</td> <td align="center">66.61</td> <td align="center">41.2</td> <td align="center">20.95</td></tr>',Nt,qa,Vt,$,$e,Zt,ti=`<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>d</mi><mi>i</mi><mi>s</mi><mi>t</mi><mi>a</mi><mi>n</mi><mi>c</mi><mi>e</mi><mo>=</mo><msqrt><mrow><mo stretchy="false">(</mo><mi>x</mi><mi mathvariant="normal">_</mi><mn>2</mn><mo>−</mo><mi>x</mi><mi mathvariant="normal">_</mi><mn>1</mn><msup><mo stretchy="false">)</mo><mn>2</mn></msup><mo>+</mo><mo stretchy="false">(</mo><mi>y</mi><mi mathvariant="normal">_</mi><mn>2</mn><mo>−</mo><mi>y</mi><mi mathvariant="normal">_</mi><mn>1</mn><msup><mo stretchy="false">)</mo><mn>2</mn></msup><mo>+</mo><mo stretchy="false">(</mo><mi>z</mi><mi mathvariant="normal">_</mi><mn>2</mn><mo>−</mo><mi>z</mi><mi mathvariant="normal">_</mi><mn>1</mn><msup><mo stretchy="false">)</mo><mn>2</mn></msup></mrow></msqrt></mrow><annotation encoding="application/x-tex">distance = \\sqrt{(x\\_2 - x\\_1)^2 + (y\\_2 - y\\_1)^2 + (z\\_2 - z\\_1)^2}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">d</span><span class="mord mathnormal">i</span><span class="mord mathnormal">s</span><span class="mord mathnormal">t</span><span class="mord mathnormal">an</span><span class="mord mathnormal">ce</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.24em;vertical-align:-0.335em;"></span><span class="mord sqrt"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.905em;"><span class="svg-align" style="top:-3.2em;"><span class="pstrut" style="height:3.2em;"></span><span class="mord" style="padding-left:1em;"><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mord">_2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal">x</span><span class="mord">_1</span><span class="mclose"><span class="mclose">)</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7401em;"><span style="top:-2.989em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mord">_2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mord">_1</span><span class="mclose"><span class="mclose">)</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7401em;"><span style="top:-2.989em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.04398em;">z</span><span class="mord">_2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal" style="margin-right:0.04398em;">z</span><span class="mord">_1</span><span class="mclose"><span class="mclose">)</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7401em;"><span style="top:-2.989em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span><span style="top:-2.865em;"><span class="pstrut" style="height:3.2em;"></span><span class="hide-tail" style="min-width:1.02em;height:1.28em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='1.28em' viewBox='0 0 400000 1296' preserveAspectRatio='xMinYMin slice'><path d='M263,681c0.7,0,18,39.7,52,119
c34,79.3,68.167,158.7,102.5,238c34.3,79.3,51.8,119.3,52.5,120
c340,-704.7,510.7,-1060.3,512,-1067
l0 -0
c4.7,-7.3,11,-11,19,-11
H40000v40H1012.3
s-271.3,567,-271.3,567c-38.7,80.7,-84,175,-136,283c-52,108,-89.167,185.3,-111.5,232
c-22.3,46.7,-33.8,70.3,-34.5,71c-4.7,4.7,-12.3,7,-23,7s-12,-1,-12,-1
s-109,-253,-109,-253c-72.7,-168,-109.3,-252,-110,-252c-10.7,8,-22,16.7,-34,26
c-22,17.3,-33.3,26,-34,26s-26,-26,-26,-26s76,-59,76,-59s76,-60,76,-60z
M1001 80h400000v40h-400000z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.335em;"><span></span></span></span></span></span></span></span></span>`,Gt,Jt,ei='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><mfrac><mrow><mo stretchy="false">(</mo><mi>a</mi><mi>c</mi><mi>t</mi><mi>u</mi><mi>a</mi><mi>l</mi><mo>−</mo><mi>m</mi><mi>e</mi><mi>a</mi><mi>s</mi><mi>u</mi><mi>r</mi><mi>e</mi><mi>d</mi><mo stretchy="false">)</mo><mo>∗</mo><mn>100</mn></mrow><mrow><mi>a</mi><mi>c</mi><mi>t</mi><mi>u</mi><mi>a</mi><mi>l</mi></mrow></mfrac></mrow><annotation encoding="application/x-tex">( \\frac{(actual-measured) * 100}{actual}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.355em;vertical-align:-0.345em;"></span><span class="mopen">(</span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.01em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight">c</span><span class="mord mathnormal mtight">t</span><span class="mord mathnormal mtight">u</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.485em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mopen mtight">(</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight">c</span><span class="mord mathnormal mtight">t</span><span class="mord mathnormal mtight">u</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">m</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight">s</span><span class="mord mathnormal mtight">u</span><span class="mord mathnormal mtight">re</span><span class="mord mathnormal mtight">d</span><span class="mclose mtight">)</span><span class="mbin mtight">∗</span><span class="mord mtight">100</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',Qt,ae,Aa,_n='<thead><tr><th align="center">dimension</th> <th align="center">calculated(cm)</th> <th align="center">actual(cm)</th> <th align="center">% error</th></tr></thead> <tbody><tr><td align="center">d1(1-2)</td> <td align="center">31.2</td> <td align="center">31.2</td> <td align="center">0</td></tr> <tr><td align="center">d2(1-3)</td> <td align="center">21.1</td> <td align="center">21.3</td> <td align="center">0.94</td></tr> <tr><td align="center">d3(5-6)</td> <td align="center">16.6</td> <td align="center">16.7</td> <td align="center">0.6</td></tr> <tr><td align="center">d4(5-7)</td> <td align="center">24.2</td> <td align="center">24</td> <td align="center">0.83</td></tr> <tr><td align="center">d5(9-10)</td> <td align="center">16.9</td> <td align="center">16.7</td> <td align="center">1.2</td></tr> <tr><td align="center">d6(9-11)</td> <td align="center">23.8</td> <td align="center">24</td> <td align="center">0.83</td></tr></tbody>',se,Ea,bn=`Calculated Dimension Results
![Calculated Dimension Results] (<a href="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/calculated_dim_results.png?download=true" rel="nofollow">https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/calculated_dim_results.png?download=true</a>)`,te,ja,ee,Sa,zn="<li>In summary, we learned how stereo vision works, the equations used to find the real-world coordinates (x, y, z) of a point P given its two images captured from different viewpoints, and compared theoretical values with experimental results.</li> <li>We assumed that the intrinsic parameters - focal length and principal point of the cameras - are known, along with their position and orientation information. This is also referred to as calibrated stereo vision.</li> <li>Interestingly, it is also possible to find the 3D coordinates of a point, P, if the position and orientation of the cameras are unknown. In fact, the position and orientation of the cameras with respect to each other can be found using the images themselves. This is referred to as uncalibrated stereo vision!</li>",ne,Wa,ie,Fa,Mn='<li>3D Reconstruction - Multiple Viewpoints <a href="https://www.coursera.org/learn/3d-reconstruction-multiple-viewpoints" rel="nofollow">Coursera</a></li> <li>Stereo Vision and Depth Estimation using OpenCV AI Kit <a href="https://learnopencv.com/stereo-vision-and-depth-estimation-using-opencv-ai-kit/" rel="nofollow">LearnOpenCV</a></li> <li>OAK-D Lite <a href="https://docs.luxonis.com/projects/hardware/en/latest/pages/DM9095/" rel="nofollow">Luxonics</a></li>',me,es,le;return E=new M({props:{title:"Introduction",local:"introduction",headingTag:"h1"}}),S=new M({props:{title:"Problem Statement",local:"problem-statement",headingTag:"h2"}}),Y=new M({props:{title:"Solution",local:"solution",headingTag:"h2"}}),sa=new M({props:{title:"Simplified Solution",local:"simplified-solution",headingTag:"h2"}}),ha=new M({props:{title:"Demo",local:"demo",headingTag:"h2"}}),ca=new M({props:{title:"Setup",local:"setup",headingTag:"h3"}}),fa=new M({props:{title:"Raw Left and Right Images",local:"raw-left-and-right-images",headingTag:"h3"}}),ba=new M({props:{title:"Rectified Left and Right Images",local:"rectified-left-and-right-images",headingTag:"h3"}}),$a=new M({props:{title:"Annotated Left and Right Rectified Images",local:"annotated-left-and-right-rectified-images",headingTag:"h3"}}),Da=new M({props:{title:"3D Coordinate Calculations",local:"3d-coordinate-calculations",headingTag:"h3"}}),qa=new M({props:{title:"Dimension Calculations and Accuracy",local:"dimension-calculations-and-accuracy",headingTag:"h3"}}),ja=new M({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Wa=new M({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){P=m("meta"),ls=n(),ss=m("p"),ps=n(),y(E.$$.fragment),rs=n(),j=m("p"),j.textContent=He,os=n(),y(S.$$.fragment),hs=n(),W=m("p"),W.textContent=De,cs=n(),F=m("p"),F.textContent=Ie,gs=n(),X=m("p"),X.textContent=Re,ds=n(),K=m("p"),K.innerHTML=Oe,fs=n(),U=m("p"),U.textContent=qe,us=n(),y(Y.$$.fragment),vs=n(),B=m("p"),B.textContent=Ae,ys=n(),N=m("ol"),N.innerHTML=Ee,ws=n(),V=m("p"),V.textContent=je,xs=n(),Z=m("ol"),Z.innerHTML=Se,_s=n(),G=m("p"),G.textContent=We,bs=n(),J=m("ol"),J.innerHTML=Fe,zs=n(),Q=m("p"),Q.textContent=Xe,Ms=n(),aa=m("p"),aa.textContent=Ke,Ls=n(),y(sa.$$.fragment),ks=n(),ta=m("p"),ta.textContent=Ue,Cs=n(),ea=m("p"),ea.innerHTML=Ye,$s=n(),na=m("p"),na.textContent=Be,Ts=n(),ia=m("ol"),ia.innerHTML=Ne,Ps=n(),ma=m("p"),ma.textContent=Ve,Hs=n(),D=m("ol"),I=m("li"),he=c(`Left camera
1.`),Ds=new o(!1),Is=c(`
2.`),Rs=new o(!1),ce=n(),R=m("li"),ge=c(`Right camera
1.`),Os=new o(!1),qs=c(`
2.`),As=new o(!1),Es=n(),v=m("p"),de=c(`Different symbols used in above equations are defined below:
`),O=m("em"),js=new o(!1),Ss=c(","),Ws=new o(!1),Fs=c(` refer to pixel coordinates of point P in the left image
`),Xs=new o(!1),Ks=c(","),Us=new o(!1),Ys=c(` refer to pixel coordinates of point P in the right image
*`),Bs=new o(!1),Ns=c(" refers to the focal length (in pixels) in x direction and"),Vs=new o(!1),Zs=c(" refers to the focal length (in pixels) in y direction. Actually, there is only 1 focal length for a camera which is the distance between the pinhole (/ optical center of the lens) to the image plane. However, pixels may be rectangular and not perfect squares, resulting in different fx and fy values when we represent f in terms of pixels."),Gs=n(),q=m("ul"),H=m("li"),fe=c(`x,y,z are 3D coordinates of the point P (any unit like cm, feet, etc can be used)
*`),Js=new o(!1),Qs=c(" and"),at=new o(!1),st=c(" refer to pixel coordinates of the principal point"),ue=n(),Ka=m("li"),Ka.textContent=Ze,tt=n(),la=m("p"),la.textContent=Ge,et=n(),pa=m("p"),ve=c("3."),nt=new o(!1),it=n(),ra=m("p"),ra.textContent=Je,mt=n(),L=m("p"),ye=c("4."),lt=new o(!1),pt=c(`
5.`),rt=new o(!1),ot=c(`
6.`),ht=new o(!1),ct=n(),oa=m("p"),oa.textContent=Qe,gt=n(),y(ha.$$.fragment),dt=n(),y(ca.$$.fragment),ft=n(),ga=m("p"),ga.textContent=an,ut=n(),da=m("ul"),da.innerHTML=sn,vt=n(),y(fa.$$.fragment),yt=n(),ua=m("p"),ua.textContent=tn,wt=n(),va=m("p"),va.innerHTML=en,xt=n(),ya=m("p"),ya.innerHTML=nn,_t=n(),wa=m("p"),wa.innerHTML=mn,bt=n(),xa=m("p"),xa.textContent=ln,zt=n(),_a=m("ul"),_a.innerHTML=pn,Mt=n(),y(ba.$$.fragment),Lt=n(),za=m("p"),za.innerHTML=rn,kt=n(),Ma=m("p"),Ma.innerHTML=on,Ct=n(),La=m("p"),La.innerHTML=hn,$t=n(),ka=m("p"),ka.innerHTML=cn,Tt=n(),C=m("p"),we=c("Let’s also overlap the rectified left and right images to see the difference. We can see that the v values for different points remain mostly constant in the left and right images. However, the u values change, and this difference in the u values helps us find the depth information for different points in the scene, as shown in Equation 6 above. This difference in ‘u’ values"),Pt=new o(!1),Ht=c(" is called disparity, and we can notice that the disparity for points near the camera is greater compared to points further away. Depth z and disparity"),Dt=new o(!1),It=c(" are inversely proportional, as shown in equation 6."),Rt=n(),Ca=m("p"),Ca.innerHTML=gn,Ot=n(),y($a.$$.fragment),qt=n(),Ta=m("p"),Ta.textContent=dn,At=n(),Pa=m("p"),Pa.innerHTML=fn,Et=n(),Ha=m("p"),Ha.innerHTML=un,jt=n(),y(Da.$$.fragment),St=n(),Ia=m("p"),Ia.textContent=vn,Wt=n(),A=m("table"),ts=m("thead"),f=m("tr"),Ra=m("th"),Ra.textContent=yn,xe=n(),Ua=m("th"),Ft=new o(!1),_e=n(),Ya=m("th"),Xt=new o(!1),be=n(),Ba=m("th"),Kt=new o(!1),ze=n(),Na=m("th"),Ut=new o(!1),Me=n(),Oa=m("th"),Oa.textContent=wn,Le=n(),Va=m("th"),Yt=new o(!1),ke=n(),Za=m("th"),Bt=new o(!1),Ce=n(),Ga=m("tbody"),Ga.innerHTML=xn,Nt=n(),y(qa.$$.fragment),Vt=n(),$=m("p"),$e=c("We can also compute 3D distances between different points using their (x,y,z) values using the formulae"),Zt=new o(!1),Gt=c(". Computed distances between some of the points are tabulated below along with their actual measured values. Percentage error"),Jt=new o(!1),Qt=c(") is also computed and tabulated. Notice that the calculated and actual values match very well with a percentage error of 1.2% or less."),ae=n(),Aa=m("table"),Aa.innerHTML=_n,se=n(),Ea=m("p"),Ea.innerHTML=bn,te=n(),y(ja.$$.fragment),ee=n(),Sa=m("ol"),Sa.innerHTML=zn,ne=n(),y(Wa.$$.fragment),ie=n(),Fa=m("ol"),Fa.innerHTML=Mn,me=n(),es=m("p"),this.h()},l(a){const t=ri("svelte-u9bgzb",document.head);P=l(t,"META",{name:!0,content:!0}),t.forEach(s),ls=i(a),ss=l(a,"P",{}),d(ss).forEach(s),ps=i(a),w(E.$$.fragment,a),rs=i(a),j=l(a,"P",{"data-svelte-h":!0}),r(j)!=="svelte-dalhkv"&&(j.textContent=He),os=i(a),w(S.$$.fragment,a),hs=i(a),W=l(a,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1uco4qc"&&(W.textContent=De),cs=i(a),F=l(a,"P",{"data-svelte-h":!0}),r(F)!=="svelte-kimr6l"&&(F.textContent=Ie),gs=i(a),X=l(a,"P",{"data-svelte-h":!0}),r(X)!=="svelte-q94rlb"&&(X.textContent=Re),ds=i(a),K=l(a,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1vrgbq7"&&(K.innerHTML=Oe),fs=i(a),U=l(a,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1wa9vwi"&&(U.textContent=qe),us=i(a),w(Y.$$.fragment,a),vs=i(a),B=l(a,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1nrdwlc"&&(B.textContent=Ae),ys=i(a),N=l(a,"OL",{"data-svelte-h":!0}),r(N)!=="svelte-1thy4kf"&&(N.innerHTML=Ee),ws=i(a),V=l(a,"P",{"data-svelte-h":!0}),r(V)!=="svelte-16e7hw4"&&(V.textContent=je),xs=i(a),Z=l(a,"OL",{"data-svelte-h":!0}),r(Z)!=="svelte-t58y5k"&&(Z.innerHTML=Se),_s=i(a),G=l(a,"P",{"data-svelte-h":!0}),r(G)!=="svelte-iezcon"&&(G.textContent=We),bs=i(a),J=l(a,"OL",{"data-svelte-h":!0}),r(J)!=="svelte-2e63hu"&&(J.innerHTML=Fe),zs=i(a),Q=l(a,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-zaapl6"&&(Q.textContent=Xe),Ms=i(a),aa=l(a,"P",{"data-svelte-h":!0}),r(aa)!=="svelte-1t8agog"&&(aa.textContent=Ke),Ls=i(a),w(sa.$$.fragment,a),ks=i(a),ta=l(a,"P",{"data-svelte-h":!0}),r(ta)!=="svelte-qw6123"&&(ta.textContent=Ue),Cs=i(a),ea=l(a,"P",{"data-svelte-h":!0}),r(ea)!=="svelte-k5jegy"&&(ea.innerHTML=Ye),$s=i(a),na=l(a,"P",{"data-svelte-h":!0}),r(na)!=="svelte-1tyi8k4"&&(na.textContent=Be),Ts=i(a),ia=l(a,"OL",{"data-svelte-h":!0}),r(ia)!=="svelte-9ofcil"&&(ia.innerHTML=Ne),Ps=i(a),ma=l(a,"P",{"data-svelte-h":!0}),r(ma)!=="svelte-1tijo6x"&&(ma.textContent=Ve),Hs=i(a),D=l(a,"OL",{});var pe=d(D);I=l(pe,"LI",{});var ns=d(I);he=g(ns,`Left camera
1.`),Ds=h(ns,!1),Is=g(ns,`
2.`),Rs=h(ns,!1),ns.forEach(s),ce=i(pe),R=l(pe,"LI",{});var is=d(R);ge=g(is,`Right camera
1.`),Os=h(is,!1),qs=g(is,`
2.`),As=h(is,!1),is.forEach(s),pe.forEach(s),Es=i(a),v=l(a,"P",{});var k=d(v);de=g(k,`Different symbols used in above equations are defined below:
`),O=l(k,"EM",{});var ms=d(O);js=h(ms,!1),Ss=g(ms,","),Ws=h(ms,!1),Fs=g(ms,` refer to pixel coordinates of point P in the left image
`),ms.forEach(s),Xs=h(k,!1),Ks=g(k,","),Us=h(k,!1),Ys=g(k,` refer to pixel coordinates of point P in the right image
*`),Bs=h(k,!1),Ns=g(k," refers to the focal length (in pixels) in x direction and"),Vs=h(k,!1),Zs=g(k," refers to the focal length (in pixels) in y direction. Actually, there is only 1 focal length for a camera which is the distance between the pinhole (/ optical center of the lens) to the image plane. However, pixels may be rectangular and not perfect squares, resulting in different fx and fy values when we represent f in terms of pixels."),k.forEach(s),Gs=i(a),q=l(a,"UL",{});var re=d(q);H=l(re,"LI",{});var Ja=d(H);fe=g(Ja,`x,y,z are 3D coordinates of the point P (any unit like cm, feet, etc can be used)
*`),Js=h(Ja,!1),Qs=g(Ja," and"),at=h(Ja,!1),st=g(Ja," refer to pixel coordinates of the principal point"),Ja.forEach(s),ue=i(re),Ka=l(re,"LI",{"data-svelte-h":!0}),r(Ka)!=="svelte-n1ohdm"&&(Ka.textContent=Ze),re.forEach(s),tt=i(a),la=l(a,"P",{"data-svelte-h":!0}),r(la)!=="svelte-uxu6gh"&&(la.textContent=Ge),et=i(a),pa=l(a,"P",{});var Te=d(pa);ve=g(Te,"3."),nt=h(Te,!1),Te.forEach(s),it=i(a),ra=l(a,"P",{"data-svelte-h":!0}),r(ra)!=="svelte-1q7g05j"&&(ra.textContent=Je),mt=i(a),L=l(a,"P",{});var Xa=d(L);ye=g(Xa,"4."),lt=h(Xa,!1),pt=g(Xa,`
5.`),rt=h(Xa,!1),ot=g(Xa,`
6.`),ht=h(Xa,!1),Xa.forEach(s),ct=i(a),oa=l(a,"P",{"data-svelte-h":!0}),r(oa)!=="svelte-6ra58q"&&(oa.textContent=Qe),gt=i(a),w(ha.$$.fragment,a),dt=i(a),w(ca.$$.fragment,a),ft=i(a),ga=l(a,"P",{"data-svelte-h":!0}),r(ga)!=="svelte-1d7pwai"&&(ga.textContent=an),ut=i(a),da=l(a,"UL",{"data-svelte-h":!0}),r(da)!=="svelte-woii1q"&&(da.innerHTML=sn),vt=i(a),w(fa.$$.fragment,a),yt=i(a),ua=l(a,"P",{"data-svelte-h":!0}),r(ua)!=="svelte-1p5cc63"&&(ua.textContent=tn),wt=i(a),va=l(a,"P",{"data-svelte-h":!0}),r(va)!=="svelte-1gg0qex"&&(va.innerHTML=en),xt=i(a),ya=l(a,"P",{"data-svelte-h":!0}),r(ya)!=="svelte-vckj40"&&(ya.innerHTML=nn),_t=i(a),wa=l(a,"P",{"data-svelte-h":!0}),r(wa)!=="svelte-1i90nqk"&&(wa.innerHTML=mn),bt=i(a),xa=l(a,"P",{"data-svelte-h":!0}),r(xa)!=="svelte-122es9i"&&(xa.textContent=ln),zt=i(a),_a=l(a,"UL",{"data-svelte-h":!0}),r(_a)!=="svelte-1dzlzv2"&&(_a.innerHTML=pn),Mt=i(a),w(ba.$$.fragment,a),Lt=i(a),za=l(a,"P",{"data-svelte-h":!0}),r(za)!=="svelte-7ct0rj"&&(za.innerHTML=rn),kt=i(a),Ma=l(a,"P",{"data-svelte-h":!0}),r(Ma)!=="svelte-1ck938e"&&(Ma.innerHTML=on),Ct=i(a),La=l(a,"P",{"data-svelte-h":!0}),r(La)!=="svelte-pcxnrd"&&(La.innerHTML=hn),$t=i(a),ka=l(a,"P",{"data-svelte-h":!0}),r(ka)!=="svelte-4x8yv3"&&(ka.innerHTML=cn),Tt=i(a),C=l(a,"P",{});var Qa=d(C);we=g(Qa,"Let’s also overlap the rectified left and right images to see the difference. We can see that the v values for different points remain mostly constant in the left and right images. However, the u values change, and this difference in the u values helps us find the depth information for different points in the scene, as shown in Equation 6 above. This difference in ‘u’ values"),Pt=h(Qa,!1),Ht=g(Qa," is called disparity, and we can notice that the disparity for points near the camera is greater compared to points further away. Depth z and disparity"),Dt=h(Qa,!1),It=g(Qa," are inversely proportional, as shown in equation 6."),Qa.forEach(s),Rt=i(a),Ca=l(a,"P",{"data-svelte-h":!0}),r(Ca)!=="svelte-14rdbyn"&&(Ca.innerHTML=gn),Ot=i(a),w($a.$$.fragment,a),qt=i(a),Ta=l(a,"P",{"data-svelte-h":!0}),r(Ta)!=="svelte-1qtzgo8"&&(Ta.textContent=dn),At=i(a),Pa=l(a,"P",{"data-svelte-h":!0}),r(Pa)!=="svelte-1c4jor3"&&(Pa.innerHTML=fn),Et=i(a),Ha=l(a,"P",{"data-svelte-h":!0}),r(Ha)!=="svelte-1ydw2mm"&&(Ha.innerHTML=un),jt=i(a),w(Da.$$.fragment,a),St=i(a),Ia=l(a,"P",{"data-svelte-h":!0}),r(Ia)!=="svelte-g4rd26"&&(Ia.textContent=vn),Wt=i(a),A=l(a,"TABLE",{});var oe=d(A);ts=l(oe,"THEAD",{});var Ln=d(ts);f=l(Ln,"TR",{});var u=d(f);Ra=l(u,"TH",{align:!0,"data-svelte-h":!0}),r(Ra)!=="svelte-7qkg13"&&(Ra.textContent=yn),xe=i(u),Ua=l(u,"TH",{align:!0});var kn=d(Ua);Ft=h(kn,!1),kn.forEach(s),_e=i(u),Ya=l(u,"TH",{align:!0});var Cn=d(Ya);Xt=h(Cn,!1),Cn.forEach(s),be=i(u),Ba=l(u,"TH",{align:!0});var $n=d(Ba);Kt=h($n,!1),$n.forEach(s),ze=i(u),Na=l(u,"TH",{align:!0});var Tn=d(Na);Ut=h(Tn,!1),Tn.forEach(s),Me=i(u),Oa=l(u,"TH",{align:!0,"data-svelte-h":!0}),r(Oa)!=="svelte-ybkm9u"&&(Oa.textContent=wn),Le=i(u),Va=l(u,"TH",{align:!0});var Pn=d(Va);Yt=h(Pn,!1),Pn.forEach(s),ke=i(u),Za=l(u,"TH",{align:!0});var Hn=d(Za);Bt=h(Hn,!1),Hn.forEach(s),u.forEach(s),Ln.forEach(s),Ce=i(oe),Ga=l(oe,"TBODY",{"data-svelte-h":!0}),r(Ga)!=="svelte-1rt6yz"&&(Ga.innerHTML=xn),oe.forEach(s),Nt=i(a),w(qa.$$.fragment,a),Vt=i(a),$=l(a,"P",{});var as=d($);$e=g(as,"We can also compute 3D distances between different points using their (x,y,z) values using the formulae"),Zt=h(as,!1),Gt=g(as,". Computed distances between some of the points are tabulated below along with their actual measured values. Percentage error"),Jt=h(as,!1),Qt=g(as,") is also computed and tabulated. Notice that the calculated and actual values match very well with a percentage error of 1.2% or less."),as.forEach(s),ae=i(a),Aa=l(a,"TABLE",{"data-svelte-h":!0}),r(Aa)!=="svelte-1mrocde"&&(Aa.innerHTML=_n),se=i(a),Ea=l(a,"P",{"data-svelte-h":!0}),r(Ea)!=="svelte-b396qj"&&(Ea.innerHTML=bn),te=i(a),w(ja.$$.fragment,a),ee=i(a),Sa=l(a,"OL",{"data-svelte-h":!0}),r(Sa)!=="svelte-8n4kzy"&&(Sa.innerHTML=zn),ne=i(a),w(Wa.$$.fragment,a),ie=i(a),Fa=l(a,"OL",{"data-svelte-h":!0}),r(Fa)!=="svelte-vggie1"&&(Fa.innerHTML=Mn),me=i(a),es=l(a,"P",{}),d(es).forEach(s),this.h()},h(){T(P,"name","hf:doc:metadata"),T(P,"content",hi),Ds.a=Is,Rs.a=null,Os.a=qs,As.a=null,js.a=Ss,Ws.a=Fs,Xs.a=Ks,Us.a=Ys,Bs.a=Ns,Vs.a=Zs,Js.a=Qs,at.a=st,nt.a=null,lt.a=pt,rt.a=ot,ht.a=null,Pt.a=Ht,Dt.a=It,T(Ra,"align","center"),Ft.a=null,T(Ua,"align","center"),Xt.a=null,T(Ya,"align","center"),Kt.a=null,T(Ba,"align","center"),Ut.a=null,T(Na,"align","center"),T(Oa,"align","center"),Yt.a=null,T(Va,"align","center"),Bt.a=null,T(Za,"align","center"),Zt.a=Gt,Jt.a=Qt},m(a,t){p(document.head,P),e(a,ls,t),e(a,ss,t),e(a,ps,t),x(E,a,t),e(a,rs,t),e(a,j,t),e(a,os,t),x(S,a,t),e(a,hs,t),e(a,W,t),e(a,cs,t),e(a,F,t),e(a,gs,t),e(a,X,t),e(a,ds,t),e(a,K,t),e(a,fs,t),e(a,U,t),e(a,us,t),x(Y,a,t),e(a,vs,t),e(a,B,t),e(a,ys,t),e(a,N,t),e(a,ws,t),e(a,V,t),e(a,xs,t),e(a,Z,t),e(a,_s,t),e(a,G,t),e(a,bs,t),e(a,J,t),e(a,zs,t),e(a,Q,t),e(a,Ms,t),e(a,aa,t),e(a,Ls,t),x(sa,a,t),e(a,ks,t),e(a,ta,t),e(a,Cs,t),e(a,ea,t),e(a,$s,t),e(a,na,t),e(a,Ts,t),e(a,ia,t),e(a,Ps,t),e(a,ma,t),e(a,Hs,t),e(a,D,t),p(D,I),p(I,he),Ds.m(Dn,I),p(I,Is),Rs.m(In,I),p(D,ce),p(D,R),p(R,ge),Os.m(Rn,R),p(R,qs),As.m(On,R),e(a,Es,t),e(a,v,t),p(v,de),p(v,O),js.m(qn,O),p(O,Ss),Ws.m(An,O),p(O,Fs),Xs.m(En,v),p(v,Ks),Us.m(jn,v),p(v,Ys),Bs.m(Sn,v),p(v,Ns),Vs.m(Wn,v),p(v,Zs),e(a,Gs,t),e(a,q,t),p(q,H),p(H,fe),Js.m(Fn,H),p(H,Qs),at.m(Xn,H),p(H,st),p(q,ue),p(q,Ka),e(a,tt,t),e(a,la,t),e(a,et,t),e(a,pa,t),p(pa,ve),nt.m(Kn,pa),e(a,it,t),e(a,ra,t),e(a,mt,t),e(a,L,t),p(L,ye),lt.m(Un,L),p(L,pt),rt.m(Yn,L),p(L,ot),ht.m(Bn,L),e(a,ct,t),e(a,oa,t),e(a,gt,t),x(ha,a,t),e(a,dt,t),x(ca,a,t),e(a,ft,t),e(a,ga,t),e(a,ut,t),e(a,da,t),e(a,vt,t),x(fa,a,t),e(a,yt,t),e(a,ua,t),e(a,wt,t),e(a,va,t),e(a,xt,t),e(a,ya,t),e(a,_t,t),e(a,wa,t),e(a,bt,t),e(a,xa,t),e(a,zt,t),e(a,_a,t),e(a,Mt,t),x(ba,a,t),e(a,Lt,t),e(a,za,t),e(a,kt,t),e(a,Ma,t),e(a,Ct,t),e(a,La,t),e(a,$t,t),e(a,ka,t),e(a,Tt,t),e(a,C,t),p(C,we),Pt.m(Nn,C),p(C,Ht),Dt.m(Vn,C),p(C,It),e(a,Rt,t),e(a,Ca,t),e(a,Ot,t),x($a,a,t),e(a,qt,t),e(a,Ta,t),e(a,At,t),e(a,Pa,t),e(a,Et,t),e(a,Ha,t),e(a,jt,t),x(Da,a,t),e(a,St,t),e(a,Ia,t),e(a,Wt,t),e(a,A,t),p(A,ts),p(ts,f),p(f,Ra),p(f,xe),p(f,Ua),Ft.m(Zn,Ua),p(f,_e),p(f,Ya),Xt.m(Gn,Ya),p(f,be),p(f,Ba),Kt.m(Jn,Ba),p(f,ze),p(f,Na),Ut.m(Qn,Na),p(f,Me),p(f,Oa),p(f,Le),p(f,Va),Yt.m(ai,Va),p(f,ke),p(f,Za),Bt.m(si,Za),p(A,Ce),p(A,Ga),e(a,Nt,t),x(qa,a,t),e(a,Vt,t),e(a,$,t),p($,$e),Zt.m(ti,$),p($,Gt),Jt.m(ei,$),p($,Qt),e(a,ae,t),e(a,Aa,t),e(a,se,t),e(a,Ea,t),e(a,te,t),x(ja,a,t),e(a,ee,t),e(a,Sa,t),e(a,ne,t),x(Wa,a,t),e(a,ie,t),e(a,Fa,t),e(a,me,t),e(a,es,t),le=!0},p:ii,i(a){le||(_(E.$$.fragment,a),_(S.$$.fragment,a),_(Y.$$.fragment,a),_(sa.$$.fragment,a),_(ha.$$.fragment,a),_(ca.$$.fragment,a),_(fa.$$.fragment,a),_(ba.$$.fragment,a),_($a.$$.fragment,a),_(Da.$$.fragment,a),_(qa.$$.fragment,a),_(ja.$$.fragment,a),_(Wa.$$.fragment,a),le=!0)},o(a){b(E.$$.fragment,a),b(S.$$.fragment,a),b(Y.$$.fragment,a),b(sa.$$.fragment,a),b(ha.$$.fragment,a),b(ca.$$.fragment,a),b(fa.$$.fragment,a),b(ba.$$.fragment,a),b($a.$$.fragment,a),b(Da.$$.fragment,a),b(qa.$$.fragment,a),b(ja.$$.fragment,a),b(Wa.$$.fragment,a),le=!1},d(a){a&&(s(ls),s(ss),s(ps),s(rs),s(j),s(os),s(hs),s(W),s(cs),s(F),s(gs),s(X),s(ds),s(K),s(fs),s(U),s(us),s(vs),s(B),s(ys),s(N),s(ws),s(V),s(xs),s(Z),s(_s),s(G),s(bs),s(J),s(zs),s(Q),s(Ms),s(aa),s(Ls),s(ks),s(ta),s(Cs),s(ea),s($s),s(na),s(Ts),s(ia),s(Ps),s(ma),s(Hs),s(D),s(Es),s(v),s(Gs),s(q),s(tt),s(la),s(et),s(pa),s(it),s(ra),s(mt),s(L),s(ct),s(oa),s(gt),s(dt),s(ft),s(ga),s(ut),s(da),s(vt),s(yt),s(ua),s(wt),s(va),s(xt),s(ya),s(_t),s(wa),s(bt),s(xa),s(zt),s(_a),s(Mt),s(Lt),s(za),s(kt),s(Ma),s(Ct),s(La),s($t),s(ka),s(Tt),s(C),s(Rt),s(Ca),s(Ot),s(qt),s(Ta),s(At),s(Pa),s(Et),s(Ha),s(jt),s(St),s(Ia),s(Wt),s(A),s(Nt),s(Vt),s($),s(ae),s(Aa),s(se),s(Ea),s(te),s(ee),s(Sa),s(ne),s(ie),s(Fa),s(me),s(es)),s(P),z(E,a),z(S,a),z(Y,a),z(sa,a),z(ha,a),z(ca,a),z(fa,a),z(ba,a),z($a,a),z(Da,a),z(qa,a),z(ja,a),z(Wa,a)}}}const hi='{"title":"Introduction","local":"introduction","sections":[{"title":"Problem Statement","local":"problem-statement","sections":[],"depth":2},{"title":"Solution","local":"solution","sections":[],"depth":2},{"title":"Simplified Solution","local":"simplified-solution","sections":[],"depth":2},{"title":"Demo","local":"demo","sections":[{"title":"Setup","local":"setup","sections":[],"depth":3},{"title":"Raw Left and Right Images","local":"raw-left-and-right-images","sections":[],"depth":3},{"title":"Rectified Left and Right Images","local":"rectified-left-and-right-images","sections":[],"depth":3},{"title":"Annotated Left and Right Rectified Images","local":"annotated-left-and-right-rectified-images","sections":[],"depth":3},{"title":"3D Coordinate Calculations","local":"3d-coordinate-calculations","sections":[],"depth":3},{"title":"Dimension Calculations and Accuracy","local":"dimension-calculations-and-accuracy","sections":[],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function ci(Pe){return mi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ui extends li{constructor(P){super(),pi(this,P,ci,oi,ni,{})}}export{ui as component};
