import{s as ql,n as Xl,o as Ll}from"../chunks/scheduler.39a43cde.js";import{S as Nl,i as Yl,g as i,s as a,r as d,A as zl,h as r,f as s,c as n,j as Rl,u as p,x as o,k as Hs,y as Ql,a as l,v as u,d as m,t as c,w as h}from"../chunks/index.23ec2204.js";import{D as El,C as b}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as f}from"../chunks/Heading.c42e7061.js";function Al(Vs){let y,et,Ke,tt,M,st,g,lt,T,Rs='Authored by: <a href="https://huggingface.co/aravindputrevu" rel="nofollow">Aravind Putrevu</a>',at,x,qs='In this 5-minute quickstart tutorial, we use Cleanlab to detect various issues in an intent classification dataset composed of (text) customer service requests at an online bank. We consider a subset of the <a href="https://arxiv.org/abs/2106.04564" rel="nofollow">Banking77-OOS Dataset</a> containing 1,000 customer service requests which are classified into 10 categories based on their intent (you can run this same code on any text classification dataset). <a href="https://github.com/cleanlab/cleanlab" rel="nofollow">Cleanlab</a> automatically identifies bad examples in our dataset, including mislabeled data, out-of-scope examples (outliers), or otherwise ambiguous examples. Consider filtering or correcting such bad examples before you dive deep into modeling your data!',nt,$,Xs="<strong>Overview of what we’ll do in this tutorial:</strong>",it,v,Ls="<li><p>Use a pretrained transformer model to extract the text embeddings from the customer service requests</p></li> <li><p>Train a simple Logistic Regression model on the text embeddings to compute out-of-sample predicted probabilities</p></li> <li><p>Run Cleanlab’s <code>Datalab</code> audit with these predictions and embeddings in order to identify problems like: label issues, outliers, and near duplicates in the dataset.</p></li>",rt,J,ot,j,Ns="Already have (out-of-sample) <code>pred_probs</code> from a model trained on an existing set of labels? Maybe you have some numeric <code>features</code> as well? Run the code below to find any potential label errors in your dataset.",dt,_,Ys="<strong>Note:</strong> If running on Colab, may want to use GPU (select: Runtime &gt; Change runtime type &gt; Hardware accelerator &gt; GPU)",pt,C,ut,U,mt,W,zs="You can use <code>pip</code> to install all packages required for this tutorial as follows:",ct,Z,ht,k,bt,G,ft,F,yt,I,wt,B,Mt,H,Qs=`This dataset has 7 classes.
Classes: &#123;32, 34, 36, 11, 13, 46, 17}
`,gt,V,Es="Let’s view the i-th example in the dataset:",Tt,R,xt,q,As=`Example Label: 11
Example Text: What can I do if my card still hasn't arrived after 2 weeks?
`,$t,X,Ds="The data is stored as two numpy arrays:",vt,L,Ps="<li><code>raw_texts</code> stores the customer service requests utterances in text format</li> <li><code>labels</code> stores the intent categories (labels) for each example</li>",Jt,w,Ss=`Bringing Your Own Data (BYOD)?
<p>You can easily replace the above with your own text dataset, and continue with the rest of the tutorial.</p>`,jt,N,Ks="Next we convert the text strings into vectors better suited as inputs for our ML models.",_t,Y,Os='We will use numeric representations from a pretrained Transformer model as embeddings of our text. The <a href="https://huggingface.co/docs/hub/sentence-transformers" rel="nofollow">Sentence Transformers</a> library offers simple methods to compute these embeddings for text data. Here, we load the pretrained <code>electra-small-discriminator</code> model, and then run our data through network to extract a vector embedding of each example.',Ct,z,Ut,Q,el="Our subsequent ML model will directly operate on elements of <code>text_embeddings</code> in order to classify the customer service requests.",Wt,E,Zt,A,tl="A typical way to leverage pretrained networks for a particular classification task is to add a linear output layer and fine-tune the network parameters on the new data. However this can be computationally intensive. Alternatively, we can freeze the pretrained weights of the network and only train the output layer without having to rely on GPU(s). Here we do this conveniently by fitting a scikit-learn linear model on top of the extracted embeddings.",kt,D,sl="To identify label issues, cleanlab requires a probabilistic prediction from your model for each datapoint. However these predictions will be <em>overfit</em> (and thus unreliable) for datapoints the model was previously trained on. cleanlab is intended to only be used with <strong>out-of-sample</strong> predicted class probabilities, i.e. on datapoints held-out from the model during the training.",Gt,P,ll=`Here we obtain out-of-sample predicted class probabilities for every example in our dataset using a Logistic Regression model with cross-validation.
Make sure that the columns of your <code>pred_probs</code> are properly ordered with respect to the ordering of classes, which for Datalab is: lexicographically sorted by class name.`,Ft,S,It,K,Bt,O,al="Given feature embeddings and the (out-of-sample) predicted class probabilities obtained from any model you have, cleanlab can quickly help you identify low-quality examples in your dataset.",Ht,ee,nl="Here, we use Cleanlab’s <code>Datalab</code> to find issues in our data. Datalab offers several ways of loading the data; we’ll simply wrap the training features and noisy labels in a dictionary.",Vt,te,Rt,se,il="All that is need to audit your data is to call <code>find_issues()</code>. We pass in the predicted probabilities and the feature embeddings obtained above, but you do not necessarily need to provide all of this information depending on which types of issues you are interested in. The more inputs you provide, the more types of issues <code>Datalab</code> can detect in your data. Using a better model to produce these inputs will ensure cleanlab more accurately estimates issues.",qt,le,Xt,ae,rl="The output would look like:",Lt,ne,Nt,ie,ol="After the audit is complete, review the findings using the <code>report</code> method:",Yt,re,zt,oe,dl=`Here is a summary of the different kinds of issues found in the data:

    issue_type  num_issues
       outlier          37
near_duplicate          14
         label          10
       non_iid           1

Dataset Information: num_examples: 1000, num_classes: 7


---------------------- outlier issues ----------------------

About this issue:
	Examples that are very different from the rest of the dataset 
    (i.e. potentially out-of-distribution or rare/anomalous instances).
    

Number of examples with this issue: 37
Overall dataset quality in terms of this issue: 0.3671

Examples representing most severe instances of this issue:
     is_outlier_issue  outlier_score
791              True       0.024866
601              True       0.031162
863              True       0.060738
355              True       0.064199
157              True       0.065075


------------------ near_duplicate issues -------------------

About this issue:
	A (near) duplicate issue refers to two or more examples in
    a dataset that are extremely similar to each other, relative
    to the rest of the dataset.  The examples flagged with this issue
    may be exactly duplicated, or lie atypically close together when
    represented as vectors (i.e. feature embeddings).
    

Number of examples with this issue: 14
Overall dataset quality in terms of this issue: 0.5961

Examples representing most severe instances of this issue:
     is_near_duplicate_issue  near_duplicate_score near_duplicate_sets  distance_to_nearest_neighbor
459                     True              0.009544               [429]                      0.000566
429                     True              0.009544               [459]                      0.000566
501                     True              0.046044          [412, 517]                      0.002781
412                     True              0.046044               [501]                      0.002781
698                     True              0.054626               [607]                      0.003314


----------------------- label issues -----------------------

About this issue:
	Examples whose given label is estimated to be potentially incorrect
    (e.g. due to annotation error) are flagged as having label issues.
    

Number of examples with this issue: 10
Overall dataset quality in terms of this issue: 0.9930

Examples representing most severe instances of this issue:
     is_label_issue  label_score  given_label  predicted_label
379           False     0.025486           32               11
100           False     0.032102           11               36
300           False     0.037742           32               46
485            True     0.057666           17               34
159            True     0.059408           13               11


---------------------- non_iid issues ----------------------

About this issue:
	Whether the dataset exhibits statistically significant
    violations of the IID assumption like:
    changepoints or shift, drift, autocorrelation, etc.
    The specific violation considered is whether the
    examples are ordered such that almost adjacent examples
    tend to have more similar feature values.
    

Number of examples with this issue: 1
Overall dataset quality in terms of this issue: 0.0000

Examples representing most severe instances of this issue:
     is_non_iid_issue  non_iid_score
988              True       0.563774
975             False       0.570179
997             False       0.571891
967             False       0.572357
956             False       0.577413

Additional Information: 
p-value: 0.0
`,Qt,de,Et,pe,pl="The report indicates that cleanlab identified many label issues in our dataset. We can see which examples are flagged as likely mislabeled and the label quality score for each example using the <code>get_issues</code> method, specifying <code>label</code> as an argument to focus on label issues in the data.",At,ue,Dt,me,ul="<thead><tr><th></th> <th>is_label_issue</th> <th>label_score</th> <th>given_label</th> <th>predicted_label</th></tr></thead> <tbody><tr><td>0</td> <td>False</td> <td>0.903926</td> <td>11</td> <td>11</td></tr> <tr><td>1</td> <td>False</td> <td>0.860544</td> <td>11</td> <td>11</td></tr> <tr><td>2</td> <td>False</td> <td>0.658309</td> <td>11</td> <td>11</td></tr> <tr><td>3</td> <td>False</td> <td>0.697085</td> <td>11</td> <td>11</td></tr> <tr><td>4</td> <td>False</td> <td>0.434934</td> <td>11</td> <td>11</td></tr></tbody>",Pt,ce,ml="This method returns a dataframe containing a label quality score for each example. These numeric scores lie between 0 and 1, where lower scores indicate examples more likely to be mislabeled. The dataframe also contains a boolean column specifying whether or not each example is identified to have a label issue (indicating it is likely mislabeled).",St,he,cl="We can get the subset of examples flagged with label issues, and also sort by label quality score to find the indices of the 5 most likely mislabeled examples in our dataset.",Kt,be,Ot,fe,hl=`cleanlab found 10 potential label errors in the dataset.
Here are indices of the top 5 most likely errors: 
 [379 100 300 485 159]
`,es,ye,bl="Let’s review some of the most likely label errors.",ts,we,fl="Here we display the top 5 examples identified as the most likely label errors in the dataset, together with their given (original) label and a suggested alternative label from cleanlab.",ss,Me,ls,ge,yl="The output to the above command would like below:",as,Te,wl="<thead><tr><th></th> <th>text</th> <th>given_label</th> <th>suggested_label</th></tr></thead> <tbody><tr><td>379</td> <td>Is there a specific source that the exchange rate for the transfer I’m planning on making is pulled from?</td> <td>32</td> <td>11</td></tr> <tr><td>100</td> <td>can you share card tracking number?</td> <td>11</td> <td>36</td></tr> <tr><td>300</td> <td>If I need to cash foreign transfers, how does that work?</td> <td>32</td> <td>46</td></tr> <tr><td>485</td> <td>Was I charged more than I should of been for a currency exchange?</td> <td>17</td> <td>34</td></tr> <tr><td>159</td> <td>Is there any way to see my card in the app?</td> <td>13</td> <td>11</td></tr></tbody>",ns,xe,Ml="These are very clear label errors that cleanlab has identified in this data! Note that the <code>given_label</code> does not correctly reflect the intent of these requests, whoever produced this dataset made many mistakes that are important to address before modeling the data.",is,$e,rs,ve,gl=`According to the report, our dataset contains some outliers.
We can see which examples are outliers (and a numeric quality score quantifying how typical each example appears to be) via <code>get_issues</code>. We sort the resulting DataFrame by cleanlab’s outlier quality score to see the most severe outliers in our dataset.`,os,Je,ds,je,Tl="Output would look like below:",ps,_e,xl="<thead><tr><th></th> <th>is_outlier_issue</th> <th>outlier_score</th></tr></thead> <tbody><tr><td>791</td> <td>True</td> <td>0.024866</td></tr> <tr><td>601</td> <td>True</td> <td>0.031162</td></tr> <tr><td>863</td> <td>True</td> <td>0.060738</td></tr> <tr><td>355</td> <td>True</td> <td>0.064199</td></tr> <tr><td>157</td> <td>True</td> <td>0.065075</td></tr></tbody>",us,Ce,ms,Ue,$l="A sample output for the lowest quality outliers would look like below:",cs,We,vl="<thead><tr><th>index</th> <th>text</th> <th>label</th></tr></thead> <tbody><tr><td>791</td> <td>withdrawal pending meaning?</td> <td>46</td></tr> <tr><td>601</td> <td>$1 charge in transaction.</td> <td>34</td></tr> <tr><td>863</td> <td>My atm withdraw is stillpending</td> <td>46</td></tr> <tr><td>355</td> <td>explain the interbank exchange rate</td> <td>32</td></tr> <tr><td>157</td> <td>lost card found, want to put it back in app</td> <td>13</td></tr></tbody>",hs,Ze,Jl="We see that cleanlab has identified entries in this dataset that do not appear to be proper customer requests. Outliers in this dataset appear to be out-of-scope customer requests and other nonsensical text which does not make sense for intent classification. Carefully consider whether such outliers may detrimentally affect your data modeling, and consider removing them from the dataset if so.",bs,ke,fs,Ge,jl=`According to the report, our dataset contains some sets of nearly duplicated examples.
We can see which examples are (nearly) duplicated (and a numeric quality score quantifying how dissimilar each example is from its nearest neighbor in the dataset) via <code>get_issues</code>. We sort the resulting DataFrame by cleanlab’s near-duplicate quality score to see the text examples in our dataset that are most nearly duplicated.`,ys,Fe,ws,Ie,_l="The results above show which examples cleanlab considers nearly duplicated (rows where <code>is_near_duplicate_issue == True</code>). Here, we see that example 459 and 429 are nearly duplicated, as are example 501 and 412.",Ms,Be,Cl="Let’s view these examples to see how similar they are.",gs,He,Ts,Ve,Ul="Sample output:",xs,Re,Wl="<thead><tr><th>index</th> <th>text</th> <th>label</th></tr></thead> <tbody><tr><td>459</td> <td>I purchased something abroad and the incorrect exchange rate was applied.</td> <td>17</td></tr> <tr><td>429</td> <td>I purchased something overseas and the incorrect exchange rate was applied.</td> <td>17</td></tr></tbody>",$s,qe,vs,Xe,Zl="Sample output:",Js,Le,kl="<thead><tr><th>index</th> <th>text</th> <th>label</th></tr></thead> <tbody><tr><td>501</td> <td>The exchange rate you are using is really bad.This can’t be the official interbank exchange rate.</td> <td>17</td></tr> <tr><td>412</td> <td>The exchange rate you are using is bad.This can’t be the official interbank exchange rate.</td> <td>17</td></tr></tbody>",js,Ne,Gl='We see that these two sets of request are indeed very similar to one another! Including near duplicates in a dataset may have unintended effects on models, and be wary about splitting them across training/test sets. Learn more about handling near duplicates in a dataset from <a href="../faq.html#How-to-handle-near-duplicate-data-identified-by-cleanlab?">the FAQ</a>.',_s,Ye,Cs,ze,Fl="According to the report, our dataset does not appear to be Independent and Identically Distributed (IID).  The overall non-iid score for the dataset (displayed below) corresponds to the <code>p-value</code> of a statistical test for whether the ordering of samples in the dataset appears related to the similarity between their feature values.  A low <code>p-value</code> strongly suggests that the dataset violates the IID assumption, which is a key assumption required for conclusions (models) produced from the dataset to generalize to a larger population.",Us,Qe,Ws,Ee,Il="Here, our dataset was flagged as non-IID because the rows happened to be sorted by class label in the original data. This may be benign if we remember to shuffle rows before model training and data splitting. But if you don’t know why your data was flagged as non-IID, then you should be worried about potential data drift or unexpected interactions between data points (their values may not be statistically independent). Think carefully about what future test data may look like (and whether your data is representative of the population you care about). You should not shuffle your data before the non-IID test runs (will invalidate its conclusions).",Zs,Ae,Bl="As demonstrated above, cleanlab can automatically shortlist the most likely issues in your dataset to help you better curate your dataset for subsequent modeling. With this shortlist, you can decide whether to fix these label issues or remove nonsensical or duplicated examples from your dataset to obtain a higher-quality dataset for training your next ML model. cleanlab’s issue detection can be run with outputs from <em>any</em> type of model you initially trained.",ks,De,Gs,Pe,Hl='<a href="https://github.com/cleanlab/cleanlab" rel="nofollow">Cleanlab</a> is a standard Data-centric AI package designed to address data quality issues for messy, real-world data.',Fs,Se,Vl='Do consider giving Cleanlab Github Repository a Star, and we welcome <a href="https://github.com/cleanlab/cleanlab/issues?q=is:issue+is:open+label:%22good+first+issue%22" rel="nofollow">contributions</a> to the project.',Is,Oe,Bs;return M=new El({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/issues_in_text_dataset.ipynb"}]}}),g=new f({props:{title:"Detecting Issues in a Text Dataset with Cleanlab",local:"detecting-issues-in-a-text-dataset-with-cleanlab",headingTag:"h1"}}),J=new f({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),C=new b({props:{code:"ZnJvbSUyMGNsZWFubGFiJTIwaW1wb3J0JTIwRGF0YWxhYiUwQSUwQWxhYiUyMCUzRCUyMERhdGFsYWIoZGF0YSUzRHlvdXJfZGF0YXNldCUyQyUyMGxhYmVsX25hbWUlM0QlMjJjb2x1bW5fbmFtZV9vZl9sYWJlbHMlMjIpJTBBbGFiLmZpbmRfaXNzdWVzKHByZWRfcHJvYnMlM0R5b3VyX3ByZWRfcHJvYnMlMkMlMjBmZWF0dXJlcyUzRHlvdXJfZmVhdHVyZXMpJTBBJTBBbGFiLnJlcG9ydCgpJTBBbGFiLmdldF9pc3N1ZXMoKQ==",highlighted:`<span class="hljs-keyword">from</span> cleanlab <span class="hljs-keyword">import</span> Datalab

lab = Datalab(data=your_dataset, label_name=<span class="hljs-string">&quot;column_name_of_labels&quot;</span>)
lab.find_issues(pred_probs=your_pred_probs, features=your_features)

lab.report()
lab.get_issues()`,wrap:!1}}),U=new f({props:{title:"Install required dependencies",local:"install-required-dependencies",headingTag:"h2"}}),Z=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtVSUyMHNjaWtpdC1sZWFybiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTBBIXBpcCUyMGluc3RhbGwlMjAtVSUyMCUyMmNsZWFubGFiJTVCZGF0YWxhYiU1RCUyMg==",highlighted:`!pip install -U scikit-learn sentence-transformers datasets
!pip install -U <span class="hljs-string">&quot;cleanlab[datalab]&quot;</span>`,wrap:!1}}),k=new b({props:{code:"aW1wb3J0JTIwcmUlMEFpbXBvcnQlMjBzdHJpbmclMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBZnJvbSUyMHNrbGVhcm4ubWV0cmljcyUyMGltcG9ydCUyMGFjY3VyYWN5X3Njb3JlJTJDJTIwbG9nX2xvc3MlMEFmcm9tJTIwc2tsZWFybi5tb2RlbF9zZWxlY3Rpb24lMjBpbXBvcnQlMjBjcm9zc192YWxfcHJlZGljdCUwQWZyb20lMjBza2xlYXJuLmxpbmVhcl9tb2RlbCUyMGltcG9ydCUyMExvZ2lzdGljUmVncmVzc2lvbiUwQWZyb20lMjBzZW50ZW5jZV90cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBTZW50ZW5jZVRyYW5zZm9ybWVyJTBBJTBBZnJvbSUyMGNsZWFubGFiJTIwaW1wb3J0JTIwRGF0YWxhYg==",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> string
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> sklearn.metrics <span class="hljs-keyword">import</span> accuracy_score, log_loss
<span class="hljs-keyword">from</span> sklearn.model_selection <span class="hljs-keyword">import</span> cross_val_predict
<span class="hljs-keyword">from</span> sklearn.linear_model <span class="hljs-keyword">import</span> LogisticRegression
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-keyword">from</span> cleanlab <span class="hljs-keyword">import</span> Datalab`,wrap:!1}}),G=new b({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGQuc2V0X29wdGlvbiglMjJkaXNwbGF5Lm1heF9jb2x3aWR0aCUyMiUyQyUyME5vbmUpJTBBJTBBU0VFRCUyMCUzRCUyMDEyMzQ1NiUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQW5wLnJhbmRvbS5zZWVkKFNFRUQpJTBBcmFuZG9tLnNlZWQoU0VFRCk=",highlighted:`<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)

SEED = <span class="hljs-number">123456</span>  <span class="hljs-comment"># for reproducibility</span>
np.random.seed(SEED)
random.seed(SEED)`,wrap:!1}}),F=new f({props:{title:"Load and format the text dataset",local:"load-and-format-the-text-dataset",headingTag:"h2"}}),I=new b({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZiYW5raW5nNzclMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWRhdGElMjAlM0QlMjBwZC5EYXRhRnJhbWUoZGF0YXNldCU1QiUzQTEwMDAlNUQpJTBBZGF0YS5oZWFkKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;PolyAI/banking77&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
data = pd.DataFrame(dataset[:<span class="hljs-number">1000</span>])
data.head()`,wrap:!1}}),B=new b({props:{code:"cmF3X3RleHRzJTJDJTIwbGFiZWxzJTIwJTNEJTIwZGF0YSU1QiUyMnRleHQlMjIlNUQudmFsdWVzJTJDJTIwZGF0YSU1QiUyMmxhYmVsJTIyJTVELnZhbHVlcyUwQW51bV9jbGFzc2VzJTIwJTNEJTIwbGVuKHNldChsYWJlbHMpKSUwQSUwQXByaW50KGYlMjJUaGlzJTIwZGF0YXNldCUyMGhhcyUyMCU3Qm51bV9jbGFzc2VzJTdEJTIwY2xhc3Nlcy4lMjIpJTBBcHJpbnQoZiUyMkNsYXNzZXMlM0ElMjAlN0JzZXQobGFiZWxzKSU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>raw_texts, labels = data[<span class="hljs-string">&quot;text&quot;</span>].values, data[<span class="hljs-string">&quot;label&quot;</span>].values
<span class="hljs-meta">&gt;&gt;&gt; </span>num_classes = <span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(labels))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;This dataset has <span class="hljs-subst">{num_classes}</span> classes.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Classes: <span class="hljs-subst">{<span class="hljs-built_in">set</span>(labels)}</span>&quot;</span>)`,wrap:!1}}),R=new b({props:{code:"aSUyMCUzRCUyMDElMjAlMjAlMjMlMjBjaGFuZ2UlMjB0aGlzJTIwdG8lMjB2aWV3JTIwb3RoZXIlMjBleGFtcGxlcyUyMGZyb20lMjB0aGUlMjBkYXRhc2V0JTBBcHJpbnQoZiUyMkV4YW1wbGUlMjBMYWJlbCUzQSUyMCU3QmxhYmVscyU1QmklNUQlN0QlMjIpJTBBcHJpbnQoZiUyMkV4YW1wbGUlMjBUZXh0JTNBJTIwJTdCcmF3X3RleHRzJTVCaSU1RCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>i = <span class="hljs-number">1</span>  <span class="hljs-comment"># change this to view other examples from the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Example Label: <span class="hljs-subst">{labels[i]}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Example Text: <span class="hljs-subst">{raw_texts[i]}</span>&quot;</span>)`,wrap:!1}}),z=new b({props:{code:"dHJhbnNmb3JtZXIlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCUyMmdvb2dsZSUyRmVsZWN0cmEtc21hbGwtZGlzY3JpbWluYXRvciUyMiklMEF0ZXh0X2VtYmVkZGluZ3MlMjAlM0QlMjB0cmFuc2Zvcm1lci5lbmNvZGUocmF3X3RleHRzKQ==",highlighted:`transformer = SentenceTransformer(<span class="hljs-string">&quot;google/electra-small-discriminator&quot;</span>)
text_embeddings = transformer.encode(raw_texts)`,wrap:!1}}),E=new f({props:{title:"Define a classification model and compute out-of-sample predicted probabilities",local:"define-a-classification-model-and-compute-out-of-sample-predicted-probabilities",headingTag:"h2"}}),S=new b({props:{code:"bW9kZWwlMjAlM0QlMjBMb2dpc3RpY1JlZ3Jlc3Npb24obWF4X2l0ZXIlM0Q0MDApJTBBJTBBcHJlZF9wcm9icyUyMCUzRCUyMGNyb3NzX3ZhbF9wcmVkaWN0KG1vZGVsJTJDJTIwdGV4dF9lbWJlZGRpbmdzJTJDJTIwbGFiZWxzJTJDJTIwbWV0aG9kJTNEJTIycHJlZGljdF9wcm9iYSUyMik=",highlighted:`model = LogisticRegression(max_iter=<span class="hljs-number">400</span>)

pred_probs = cross_val_predict(model, text_embeddings, labels, method=<span class="hljs-string">&quot;predict_proba&quot;</span>)`,wrap:!1}}),K=new f({props:{title:"Use Cleanlab to find issues in your dataset",local:"use-cleanlab-to-find-issues-in-your-dataset",headingTag:"h2"}}),te=new b({props:{code:"ZGF0YV9kaWN0JTIwJTNEJTIwJTdCJTIydGV4dHMlMjIlM0ElMjByYXdfdGV4dHMlMkMlMjAlMjJsYWJlbHMlMjIlM0ElMjBsYWJlbHMlN0Q=",highlighted:'data_dict = {<span class="hljs-string">&quot;texts&quot;</span>: raw_texts, <span class="hljs-string">&quot;labels&quot;</span>: labels}',wrap:!1}}),le=new b({props:{code:"bGFiJTIwJTNEJTIwRGF0YWxhYihkYXRhX2RpY3QlMkMlMjBsYWJlbF9uYW1lJTNEJTIybGFiZWxzJTIyKSUwQWxhYi5maW5kX2lzc3VlcyhwcmVkX3Byb2JzJTNEcHJlZF9wcm9icyUyQyUyMGZlYXR1cmVzJTNEdGV4dF9lbWJlZGRpbmdzKQ==",highlighted:`lab = Datalab(data_dict, label_name=<span class="hljs-string">&quot;labels&quot;</span>)
lab.find_issues(pred_probs=pred_probs, features=text_embeddings)`,wrap:!1}}),ne=new b({props:{code:"RmluZGluZyUyMG51bGwlMjBpc3N1ZXMlMjAuLi4lMEFGaW5kaW5nJTIwbGFiZWwlMjBpc3N1ZXMlMjAuLi4lMEFGaW5kaW5nJTIwb3V0bGllciUyMGlzc3VlcyUyMC4uLiUwQUZpdHRpbmclMjBPT0QlMjBlc3RpbWF0b3IlMjBiYXNlZCUyMG9uJTIwcHJvdmlkZWQlMjBmZWF0dXJlcyUyMC4uLiUwQUZpbmRpbmclMjBuZWFyX2R1cGxpY2F0ZSUyMGlzc3VlcyUyMC4uLiUwQUZpbmRpbmclMjBub25faWlkJTIwaXNzdWVzJTIwLi4uJTBBRmluZGluZyUyMGNsYXNzX2ltYmFsYW5jZSUyMGlzc3VlcyUyMC4uLiUwQUZpbmRpbmclMjB1bmRlcnBlcmZvcm1pbmdfZ3JvdXAlMjBpc3N1ZXMlMjAuLi4lMEElMEFBdWRpdCUyMGNvbXBsZXRlLiUyMDYyJTIwaXNzdWVzJTIwZm91bmQlMjBpbiUyMHRoZSUyMGRhdGFzZXQu",highlighted:`Finding null issues ...
Finding label issues ...
Finding outlier issues ...
Fitting OOD estimator based on provided features ...
Finding near_duplicate issues ...
Finding non_iid issues ...
Finding class_imbalance issues ...
Finding underperforming_group issues ...

Audit complete. 62 issues found <span class="hljs-keyword">in</span> the dataset.`,wrap:!1}}),re=new b({props:{code:"bGFiLnJlcG9ydCgp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>lab.report()',wrap:!1}}),de=new f({props:{title:"Label issues",local:"label-issues",headingTag:"h3"}}),ue=new b({props:{code:"bGFiZWxfaXNzdWVzJTIwJTNEJTIwbGFiLmdldF9pc3N1ZXMoJTIybGFiZWwlMjIpJTBBbGFiZWxfaXNzdWVzLmhlYWQoKQ==",highlighted:`label_issues = lab.get_issues(<span class="hljs-string">&quot;label&quot;</span>)
label_issues.head()`,wrap:!1}}),be=new b({props:{code:"aWRlbnRpZmllZF9sYWJlbF9pc3N1ZXMlMjAlM0QlMjBsYWJlbF9pc3N1ZXMlNUJsYWJlbF9pc3N1ZXMlNUIlMjJpc19sYWJlbF9pc3N1ZSUyMiU1RCUyMCUzRCUzRCUyMFRydWUlNUQlMEFsb3dlc3RfcXVhbGl0eV9sYWJlbHMlMjAlM0QlMjBsYWJlbF9pc3N1ZXMlNUIlMjJsYWJlbF9zY29yZSUyMiU1RC5hcmdzb3J0KCklNUIlM0E1JTVELnRvX251bXB5KCklMEElMEFwcmludCglMEElMjAlMjAlMjAlMjBmJTIyY2xlYW5sYWIlMjBmb3VuZCUyMCU3QmxlbihpZGVudGlmaWVkX2xhYmVsX2lzc3VlcyklN0QlMjBwb3RlbnRpYWwlMjBsYWJlbCUyMGVycm9ycyUyMGluJTIwdGhlJTIwZGF0YXNldC4lNUNuJTIyJTBBJTIwJTIwJTIwJTIwZiUyMkhlcmUlMjBhcmUlMjBpbmRpY2VzJTIwb2YlMjB0aGUlMjB0b3AlMjA1JTIwbW9zdCUyMGxpa2VseSUyMGVycm9ycyUzQSUyMCU1Q24lMjAlN0Jsb3dlc3RfcXVhbGl0eV9sYWJlbHMlN0QlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>identified_label_issues = label_issues[label_issues[<span class="hljs-string">&quot;is_label_issue&quot;</span>] == <span class="hljs-literal">True</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>lowest_quality_labels = label_issues[<span class="hljs-string">&quot;label_score&quot;</span>].argsort()[:<span class="hljs-number">5</span>].to_numpy()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;cleanlab found <span class="hljs-subst">{<span class="hljs-built_in">len</span>(identified_label_issues)}</span> potential label errors in the dataset.\\n&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;Here are indices of the top 5 most likely errors: \\n <span class="hljs-subst">{lowest_quality_labels}</span>&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Me=new b({props:{code:"ZGF0YV93aXRoX3N1Z2dlc3RlZF9sYWJlbHMlMjAlM0QlMjBwZC5EYXRhRnJhbWUoJTBBJTIwJTIwJTIwJTIwJTdCJTIydGV4dCUyMiUzQSUyMHJhd190ZXh0cyUyQyUyMCUyMmdpdmVuX2xhYmVsJTIyJTNBJTIwbGFiZWxzJTJDJTIwJTIyc3VnZ2VzdGVkX2xhYmVsJTIyJTNBJTIwbGFiZWxfaXNzdWVzJTVCJTIycHJlZGljdGVkX2xhYmVsJTIyJTVEJTdEJTBBKSUwQWRhdGFfd2l0aF9zdWdnZXN0ZWRfbGFiZWxzLmlsb2MlNUJsb3dlc3RfcXVhbGl0eV9sYWJlbHMlNUQ=",highlighted:`data_with_suggested_labels = pd.DataFrame(
    {<span class="hljs-string">&quot;text&quot;</span>: raw_texts, <span class="hljs-string">&quot;given_label&quot;</span>: labels, <span class="hljs-string">&quot;suggested_label&quot;</span>: label_issues[<span class="hljs-string">&quot;predicted_label&quot;</span>]}
)
data_with_suggested_labels.iloc[lowest_quality_labels]`,wrap:!1}}),$e=new f({props:{title:"Outlier issues",local:"outlier-issues",headingTag:"h3"}}),Je=new b({props:{code:"b3V0bGllcl9pc3N1ZXMlMjAlM0QlMjBsYWIuZ2V0X2lzc3VlcyglMjJvdXRsaWVyJTIyKSUwQW91dGxpZXJfaXNzdWVzLnNvcnRfdmFsdWVzKCUyMm91dGxpZXJfc2NvcmUlMjIpLmhlYWQoKQ==",highlighted:`outlier_issues = lab.get_issues(<span class="hljs-string">&quot;outlier&quot;</span>)
outlier_issues.sort_values(<span class="hljs-string">&quot;outlier_score&quot;</span>).head()`,wrap:!1}}),Ce=new b({props:{code:"bG93ZXN0X3F1YWxpdHlfb3V0bGllcnMlMjAlM0QlMjBvdXRsaWVyX2lzc3VlcyU1QiUyMm91dGxpZXJfc2NvcmUlMjIlNUQuYXJnc29ydCgpJTVCJTNBNSU1RCUwQSUwQWRhdGEuaWxvYyU1Qmxvd2VzdF9xdWFsaXR5X291dGxpZXJzJTVE",highlighted:`lowest_quality_outliers = outlier_issues[<span class="hljs-string">&quot;outlier_score&quot;</span>].argsort()[:<span class="hljs-number">5</span>]

data.iloc[lowest_quality_outliers]`,wrap:!1}}),ke=new f({props:{title:"Near-duplicate issues",local:"near-duplicate-issues",headingTag:"h3"}}),Fe=new b({props:{code:"ZHVwbGljYXRlX2lzc3VlcyUyMCUzRCUyMGxhYi5nZXRfaXNzdWVzKCUyMm5lYXJfZHVwbGljYXRlJTIyKSUwQWR1cGxpY2F0ZV9pc3N1ZXMuc29ydF92YWx1ZXMoJTIybmVhcl9kdXBsaWNhdGVfc2NvcmUlMjIpLmhlYWQoKQ==",highlighted:`duplicate_issues = lab.get_issues(<span class="hljs-string">&quot;near_duplicate&quot;</span>)
duplicate_issues.sort_values(<span class="hljs-string">&quot;near_duplicate_score&quot;</span>).head()`,wrap:!1}}),He=new b({props:{code:"ZGF0YS5pbG9jJTVCJTVCNDU5JTJDJTIwNDI5JTVEJTVE",highlighted:'data.iloc[[<span class="hljs-number">459</span>, <span class="hljs-number">429</span>]]',wrap:!1}}),qe=new b({props:{code:"ZGF0YS5pbG9jJTVCJTVCNTAxJTJDJTIwNDEyJTVEJTVE",highlighted:'data.iloc[[<span class="hljs-number">501</span>, <span class="hljs-number">412</span>]]',wrap:!1}}),Ye=new f({props:{title:"Non-IID issues (data drift)",local:"non-iid-issues-data-drift",headingTag:"h3"}}),Qe=new b({props:{code:"cF92YWx1ZSUyMCUzRCUyMGxhYi5nZXRfaW5mbyglMjJub25faWlkJTIyKSU1QiUyMnAtdmFsdWUlMjIlNUQlMEFwX3ZhbHVl",highlighted:`p_value = lab.get_info(<span class="hljs-string">&quot;non_iid&quot;</span>)[<span class="hljs-string">&quot;p-value&quot;</span>]
p_value`,wrap:!1}}),De=new f({props:{title:"Cleanlab Opensource Project",local:"cleanlab-opensource-project",headingTag:"h3"}}),{c(){y=i("meta"),et=a(),Ke=i("p"),tt=a(),d(M.$$.fragment),st=a(),d(g.$$.fragment),lt=a(),T=i("p"),T.innerHTML=Rs,at=a(),x=i("p"),x.innerHTML=qs,nt=a(),$=i("p"),$.innerHTML=Xs,it=a(),v=i("ul"),v.innerHTML=Ls,rt=a(),d(J.$$.fragment),ot=a(),j=i("p"),j.innerHTML=Ns,dt=a(),_=i("p"),_.innerHTML=Ys,pt=a(),d(C.$$.fragment),ut=a(),d(U.$$.fragment),mt=a(),W=i("p"),W.innerHTML=zs,ct=a(),d(Z.$$.fragment),ht=a(),d(k.$$.fragment),bt=a(),d(G.$$.fragment),ft=a(),d(F.$$.fragment),yt=a(),d(I.$$.fragment),wt=a(),d(B.$$.fragment),Mt=a(),H=i("pre"),H.textContent=Qs,gt=a(),V=i("p"),V.textContent=Es,Tt=a(),d(R.$$.fragment),xt=a(),q=i("pre"),q.textContent=As,$t=a(),X=i("p"),X.textContent=Ds,vt=a(),L=i("ol"),L.innerHTML=Ps,Jt=a(),w=i("div"),w.innerHTML=Ss,jt=a(),N=i("p"),N.textContent=Ks,_t=a(),Y=i("p"),Y.innerHTML=Os,Ct=a(),d(z.$$.fragment),Ut=a(),Q=i("p"),Q.innerHTML=el,Wt=a(),d(E.$$.fragment),Zt=a(),A=i("p"),A.textContent=tl,kt=a(),D=i("p"),D.innerHTML=sl,Gt=a(),P=i("p"),P.innerHTML=ll,Ft=a(),d(S.$$.fragment),It=a(),d(K.$$.fragment),Bt=a(),O=i("p"),O.textContent=al,Ht=a(),ee=i("p"),ee.innerHTML=nl,Vt=a(),d(te.$$.fragment),Rt=a(),se=i("p"),se.innerHTML=il,qt=a(),d(le.$$.fragment),Xt=a(),ae=i("p"),ae.textContent=rl,Lt=a(),d(ne.$$.fragment),Nt=a(),ie=i("p"),ie.innerHTML=ol,Yt=a(),d(re.$$.fragment),zt=a(),oe=i("pre"),oe.textContent=dl,Qt=a(),d(de.$$.fragment),Et=a(),pe=i("p"),pe.innerHTML=pl,At=a(),d(ue.$$.fragment),Dt=a(),me=i("table"),me.innerHTML=ul,Pt=a(),ce=i("p"),ce.textContent=ml,St=a(),he=i("p"),he.textContent=cl,Kt=a(),d(be.$$.fragment),Ot=a(),fe=i("pre"),fe.textContent=hl,es=a(),ye=i("p"),ye.textContent=bl,ts=a(),we=i("p"),we.textContent=fl,ss=a(),d(Me.$$.fragment),ls=a(),ge=i("p"),ge.textContent=yl,as=a(),Te=i("table"),Te.innerHTML=wl,ns=a(),xe=i("p"),xe.innerHTML=Ml,is=a(),d($e.$$.fragment),rs=a(),ve=i("p"),ve.innerHTML=gl,os=a(),d(Je.$$.fragment),ds=a(),je=i("p"),je.textContent=Tl,ps=a(),_e=i("table"),_e.innerHTML=xl,us=a(),d(Ce.$$.fragment),ms=a(),Ue=i("p"),Ue.textContent=$l,cs=a(),We=i("table"),We.innerHTML=vl,hs=a(),Ze=i("p"),Ze.textContent=Jl,bs=a(),d(ke.$$.fragment),fs=a(),Ge=i("p"),Ge.innerHTML=jl,ys=a(),d(Fe.$$.fragment),ws=a(),Ie=i("p"),Ie.innerHTML=_l,Ms=a(),Be=i("p"),Be.textContent=Cl,gs=a(),d(He.$$.fragment),Ts=a(),Ve=i("p"),Ve.textContent=Ul,xs=a(),Re=i("table"),Re.innerHTML=Wl,$s=a(),d(qe.$$.fragment),vs=a(),Xe=i("p"),Xe.textContent=Zl,Js=a(),Le=i("table"),Le.innerHTML=kl,js=a(),Ne=i("p"),Ne.innerHTML=Gl,_s=a(),d(Ye.$$.fragment),Cs=a(),ze=i("p"),ze.innerHTML=Fl,Us=a(),d(Qe.$$.fragment),Ws=a(),Ee=i("p"),Ee.textContent=Il,Zs=a(),Ae=i("p"),Ae.innerHTML=Bl,ks=a(),d(De.$$.fragment),Gs=a(),Pe=i("p"),Pe.innerHTML=Hl,Fs=a(),Se=i("p"),Se.innerHTML=Vl,Is=a(),Oe=i("p"),this.h()},l(e){const t=zl("svelte-u9bgzb",document.head);y=r(t,"META",{name:!0,content:!0}),t.forEach(s),et=n(e),Ke=r(e,"P",{}),Rl(Ke).forEach(s),tt=n(e),p(M.$$.fragment,e),st=n(e),p(g.$$.fragment,e),lt=n(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-7v4tto"&&(T.innerHTML=Rs),at=n(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-x4m7f1"&&(x.innerHTML=qs),nt=n(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-18jgjs2"&&($.innerHTML=Xs),it=n(e),v=r(e,"UL",{"data-svelte-h":!0}),o(v)!=="svelte-1a1fu53"&&(v.innerHTML=Ls),rt=n(e),p(J.$$.fragment,e),ot=n(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1fl5lu0"&&(j.innerHTML=Ns),dt=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1umjcr0"&&(_.innerHTML=Ys),pt=n(e),p(C.$$.fragment,e),ut=n(e),p(U.$$.fragment,e),mt=n(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1846b64"&&(W.innerHTML=zs),ct=n(e),p(Z.$$.fragment,e),ht=n(e),p(k.$$.fragment,e),bt=n(e),p(G.$$.fragment,e),ft=n(e),p(F.$$.fragment,e),yt=n(e),p(I.$$.fragment,e),wt=n(e),p(B.$$.fragment,e),Mt=n(e),H=r(e,"PRE",{"data-svelte-h":!0}),o(H)!=="svelte-1baoe44"&&(H.textContent=Qs),gt=n(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1u95mgp"&&(V.textContent=Es),Tt=n(e),p(R.$$.fragment,e),xt=n(e),q=r(e,"PRE",{"data-svelte-h":!0}),o(q)!=="svelte-17yipnq"&&(q.textContent=As),$t=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1l25yub"&&(X.textContent=Ds),vt=n(e),L=r(e,"OL",{"data-svelte-h":!0}),o(L)!=="svelte-1k1141k"&&(L.innerHTML=Ps),Jt=n(e),w=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-ulpodh"&&(w.innerHTML=Ss),jt=n(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-8ylgjr"&&(N.textContent=Ks),_t=n(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1m7xux2"&&(Y.innerHTML=Os),Ct=n(e),p(z.$$.fragment,e),Ut=n(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-j0bn03"&&(Q.innerHTML=el),Wt=n(e),p(E.$$.fragment,e),Zt=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-b7zzz7"&&(A.textContent=tl),kt=n(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1dj10dn"&&(D.innerHTML=sl),Gt=n(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-9of5yp"&&(P.innerHTML=ll),Ft=n(e),p(S.$$.fragment,e),It=n(e),p(K.$$.fragment,e),Bt=n(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-47pi87"&&(O.textContent=al),Ht=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-dexquy"&&(ee.innerHTML=nl),Vt=n(e),p(te.$$.fragment,e),Rt=n(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-tev5gw"&&(se.innerHTML=il),qt=n(e),p(le.$$.fragment,e),Xt=n(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1pktn7f"&&(ae.textContent=rl),Lt=n(e),p(ne.$$.fragment,e),Nt=n(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-gfwcwf"&&(ie.innerHTML=ol),Yt=n(e),p(re.$$.fragment,e),zt=n(e),oe=r(e,"PRE",{"data-svelte-h":!0}),o(oe)!=="svelte-1uushu"&&(oe.textContent=dl),Qt=n(e),p(de.$$.fragment,e),Et=n(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-15v82np"&&(pe.innerHTML=pl),At=n(e),p(ue.$$.fragment,e),Dt=n(e),me=r(e,"TABLE",{"data-svelte-h":!0}),o(me)!=="svelte-1xd6s59"&&(me.innerHTML=ul),Pt=n(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-19ub1nr"&&(ce.textContent=ml),St=n(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-15fxxfj"&&(he.textContent=cl),Kt=n(e),p(be.$$.fragment,e),Ot=n(e),fe=r(e,"PRE",{"data-svelte-h":!0}),o(fe)!=="svelte-ku705s"&&(fe.textContent=hl),es=n(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-xz6a83"&&(ye.textContent=bl),ts=n(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1q9yf95"&&(we.textContent=fl),ss=n(e),p(Me.$$.fragment,e),ls=n(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1ralv53"&&(ge.textContent=yl),as=n(e),Te=r(e,"TABLE",{"data-svelte-h":!0}),o(Te)!=="svelte-15w938v"&&(Te.innerHTML=wl),ns=n(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-19y4mu3"&&(xe.innerHTML=Ml),is=n(e),p($e.$$.fragment,e),rs=n(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1a5t0qg"&&(ve.innerHTML=gl),os=n(e),p(Je.$$.fragment,e),ds=n(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-f5s9jr"&&(je.textContent=Tl),ps=n(e),_e=r(e,"TABLE",{"data-svelte-h":!0}),o(_e)!=="svelte-1u55nqa"&&(_e.innerHTML=xl),us=n(e),p(Ce.$$.fragment,e),ms=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1plac8s"&&(Ue.textContent=$l),cs=n(e),We=r(e,"TABLE",{"data-svelte-h":!0}),o(We)!=="svelte-1n860xg"&&(We.innerHTML=vl),hs=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-warb6v"&&(Ze.textContent=Jl),bs=n(e),p(ke.$$.fragment,e),fs=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-ihtnsz"&&(Ge.innerHTML=jl),ys=n(e),p(Fe.$$.fragment,e),ws=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-vk8ovs"&&(Ie.innerHTML=_l),Ms=n(e),Be=r(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-zg7wj1"&&(Be.textContent=Cl),gs=n(e),p(He.$$.fragment,e),Ts=n(e),Ve=r(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-yqv5wp"&&(Ve.textContent=Ul),xs=n(e),Re=r(e,"TABLE",{"data-svelte-h":!0}),o(Re)!=="svelte-1hzopql"&&(Re.innerHTML=Wl),$s=n(e),p(qe.$$.fragment,e),vs=n(e),Xe=r(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-yqv5wp"&&(Xe.textContent=Zl),Js=n(e),Le=r(e,"TABLE",{"data-svelte-h":!0}),o(Le)!=="svelte-6cycax"&&(Le.innerHTML=kl),js=n(e),Ne=r(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-g4jcwm"&&(Ne.innerHTML=Gl),_s=n(e),p(Ye.$$.fragment,e),Cs=n(e),ze=r(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1sy4tkb"&&(ze.innerHTML=Fl),Us=n(e),p(Qe.$$.fragment,e),Ws=n(e),Ee=r(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1kc3doc"&&(Ee.textContent=Il),Zs=n(e),Ae=r(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-gmdkyh"&&(Ae.innerHTML=Bl),ks=n(e),p(De.$$.fragment,e),Gs=n(e),Pe=r(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-b286nf"&&(Pe.innerHTML=Hl),Fs=n(e),Se=r(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-ima2ho"&&(Se.innerHTML=Vl),Is=n(e),Oe=r(e,"P",{}),Rl(Oe).forEach(s),this.h()},h(){Hs(y,"name","hf:doc:metadata"),Hs(y,"content",Dl),Hs(w,"class","alert alert-info")},m(e,t){Ql(document.head,y),l(e,et,t),l(e,Ke,t),l(e,tt,t),u(M,e,t),l(e,st,t),u(g,e,t),l(e,lt,t),l(e,T,t),l(e,at,t),l(e,x,t),l(e,nt,t),l(e,$,t),l(e,it,t),l(e,v,t),l(e,rt,t),u(J,e,t),l(e,ot,t),l(e,j,t),l(e,dt,t),l(e,_,t),l(e,pt,t),u(C,e,t),l(e,ut,t),u(U,e,t),l(e,mt,t),l(e,W,t),l(e,ct,t),u(Z,e,t),l(e,ht,t),u(k,e,t),l(e,bt,t),u(G,e,t),l(e,ft,t),u(F,e,t),l(e,yt,t),u(I,e,t),l(e,wt,t),u(B,e,t),l(e,Mt,t),l(e,H,t),l(e,gt,t),l(e,V,t),l(e,Tt,t),u(R,e,t),l(e,xt,t),l(e,q,t),l(e,$t,t),l(e,X,t),l(e,vt,t),l(e,L,t),l(e,Jt,t),l(e,w,t),l(e,jt,t),l(e,N,t),l(e,_t,t),l(e,Y,t),l(e,Ct,t),u(z,e,t),l(e,Ut,t),l(e,Q,t),l(e,Wt,t),u(E,e,t),l(e,Zt,t),l(e,A,t),l(e,kt,t),l(e,D,t),l(e,Gt,t),l(e,P,t),l(e,Ft,t),u(S,e,t),l(e,It,t),u(K,e,t),l(e,Bt,t),l(e,O,t),l(e,Ht,t),l(e,ee,t),l(e,Vt,t),u(te,e,t),l(e,Rt,t),l(e,se,t),l(e,qt,t),u(le,e,t),l(e,Xt,t),l(e,ae,t),l(e,Lt,t),u(ne,e,t),l(e,Nt,t),l(e,ie,t),l(e,Yt,t),u(re,e,t),l(e,zt,t),l(e,oe,t),l(e,Qt,t),u(de,e,t),l(e,Et,t),l(e,pe,t),l(e,At,t),u(ue,e,t),l(e,Dt,t),l(e,me,t),l(e,Pt,t),l(e,ce,t),l(e,St,t),l(e,he,t),l(e,Kt,t),u(be,e,t),l(e,Ot,t),l(e,fe,t),l(e,es,t),l(e,ye,t),l(e,ts,t),l(e,we,t),l(e,ss,t),u(Me,e,t),l(e,ls,t),l(e,ge,t),l(e,as,t),l(e,Te,t),l(e,ns,t),l(e,xe,t),l(e,is,t),u($e,e,t),l(e,rs,t),l(e,ve,t),l(e,os,t),u(Je,e,t),l(e,ds,t),l(e,je,t),l(e,ps,t),l(e,_e,t),l(e,us,t),u(Ce,e,t),l(e,ms,t),l(e,Ue,t),l(e,cs,t),l(e,We,t),l(e,hs,t),l(e,Ze,t),l(e,bs,t),u(ke,e,t),l(e,fs,t),l(e,Ge,t),l(e,ys,t),u(Fe,e,t),l(e,ws,t),l(e,Ie,t),l(e,Ms,t),l(e,Be,t),l(e,gs,t),u(He,e,t),l(e,Ts,t),l(e,Ve,t),l(e,xs,t),l(e,Re,t),l(e,$s,t),u(qe,e,t),l(e,vs,t),l(e,Xe,t),l(e,Js,t),l(e,Le,t),l(e,js,t),l(e,Ne,t),l(e,_s,t),u(Ye,e,t),l(e,Cs,t),l(e,ze,t),l(e,Us,t),u(Qe,e,t),l(e,Ws,t),l(e,Ee,t),l(e,Zs,t),l(e,Ae,t),l(e,ks,t),u(De,e,t),l(e,Gs,t),l(e,Pe,t),l(e,Fs,t),l(e,Se,t),l(e,Is,t),l(e,Oe,t),Bs=!0},p:Xl,i(e){Bs||(m(M.$$.fragment,e),m(g.$$.fragment,e),m(J.$$.fragment,e),m(C.$$.fragment,e),m(U.$$.fragment,e),m(Z.$$.fragment,e),m(k.$$.fragment,e),m(G.$$.fragment,e),m(F.$$.fragment,e),m(I.$$.fragment,e),m(B.$$.fragment,e),m(R.$$.fragment,e),m(z.$$.fragment,e),m(E.$$.fragment,e),m(S.$$.fragment,e),m(K.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(be.$$.fragment,e),m(Me.$$.fragment,e),m($e.$$.fragment,e),m(Je.$$.fragment,e),m(Ce.$$.fragment,e),m(ke.$$.fragment,e),m(Fe.$$.fragment,e),m(He.$$.fragment,e),m(qe.$$.fragment,e),m(Ye.$$.fragment,e),m(Qe.$$.fragment,e),m(De.$$.fragment,e),Bs=!0)},o(e){c(M.$$.fragment,e),c(g.$$.fragment,e),c(J.$$.fragment,e),c(C.$$.fragment,e),c(U.$$.fragment,e),c(Z.$$.fragment,e),c(k.$$.fragment,e),c(G.$$.fragment,e),c(F.$$.fragment,e),c(I.$$.fragment,e),c(B.$$.fragment,e),c(R.$$.fragment,e),c(z.$$.fragment,e),c(E.$$.fragment,e),c(S.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(be.$$.fragment,e),c(Me.$$.fragment,e),c($e.$$.fragment,e),c(Je.$$.fragment,e),c(Ce.$$.fragment,e),c(ke.$$.fragment,e),c(Fe.$$.fragment,e),c(He.$$.fragment,e),c(qe.$$.fragment,e),c(Ye.$$.fragment,e),c(Qe.$$.fragment,e),c(De.$$.fragment,e),Bs=!1},d(e){e&&(s(et),s(Ke),s(tt),s(st),s(lt),s(T),s(at),s(x),s(nt),s($),s(it),s(v),s(rt),s(ot),s(j),s(dt),s(_),s(pt),s(ut),s(mt),s(W),s(ct),s(ht),s(bt),s(ft),s(yt),s(wt),s(Mt),s(H),s(gt),s(V),s(Tt),s(xt),s(q),s($t),s(X),s(vt),s(L),s(Jt),s(w),s(jt),s(N),s(_t),s(Y),s(Ct),s(Ut),s(Q),s(Wt),s(Zt),s(A),s(kt),s(D),s(Gt),s(P),s(Ft),s(It),s(Bt),s(O),s(Ht),s(ee),s(Vt),s(Rt),s(se),s(qt),s(Xt),s(ae),s(Lt),s(Nt),s(ie),s(Yt),s(zt),s(oe),s(Qt),s(Et),s(pe),s(At),s(Dt),s(me),s(Pt),s(ce),s(St),s(he),s(Kt),s(Ot),s(fe),s(es),s(ye),s(ts),s(we),s(ss),s(ls),s(ge),s(as),s(Te),s(ns),s(xe),s(is),s(rs),s(ve),s(os),s(ds),s(je),s(ps),s(_e),s(us),s(ms),s(Ue),s(cs),s(We),s(hs),s(Ze),s(bs),s(fs),s(Ge),s(ys),s(ws),s(Ie),s(Ms),s(Be),s(gs),s(Ts),s(Ve),s(xs),s(Re),s($s),s(vs),s(Xe),s(Js),s(Le),s(js),s(Ne),s(_s),s(Cs),s(ze),s(Us),s(Ws),s(Ee),s(Zs),s(Ae),s(ks),s(Gs),s(Pe),s(Fs),s(Se),s(Is),s(Oe)),s(y),h(M,e),h(g,e),h(J,e),h(C,e),h(U,e),h(Z,e),h(k,e),h(G,e),h(F,e),h(I,e),h(B,e),h(R,e),h(z,e),h(E,e),h(S,e),h(K,e),h(te,e),h(le,e),h(ne,e),h(re,e),h(de,e),h(ue,e),h(be,e),h(Me,e),h($e,e),h(Je,e),h(Ce,e),h(ke,e),h(Fe,e),h(He,e),h(qe,e),h(Ye,e),h(Qe,e),h(De,e)}}}const Dl='{"title":"Detecting Issues in a Text Dataset with Cleanlab","local":"detecting-issues-in-a-text-dataset-with-cleanlab","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Install required dependencies","local":"install-required-dependencies","sections":[],"depth":2},{"title":"Load and format the text dataset","local":"load-and-format-the-text-dataset","sections":[],"depth":2},{"title":"Define a classification model and compute out-of-sample predicted probabilities","local":"define-a-classification-model-and-compute-out-of-sample-predicted-probabilities","sections":[],"depth":2},{"title":"Use Cleanlab to find issues in your dataset","local":"use-cleanlab-to-find-issues-in-your-dataset","sections":[{"title":"Label issues","local":"label-issues","sections":[],"depth":3},{"title":"Outlier issues","local":"outlier-issues","sections":[],"depth":3},{"title":"Near-duplicate issues","local":"near-duplicate-issues","sections":[],"depth":3},{"title":"Non-IID issues (data drift)","local":"non-iid-issues-data-drift","sections":[],"depth":3},{"title":"Cleanlab Opensource Project","local":"cleanlab-opensource-project","sections":[],"depth":3}],"depth":2}],"depth":1}';function Pl(Vs){return Ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ta extends Nl{constructor(y){super(),Yl(this,y,Pl,Al,ql,{})}}export{ta as component};
