import{s as be,o as ve,n as Ie}from"../chunks/scheduler.9039eef2.js";import{S as $e,i as je,g as r,s as l,u as S,A as Ce,h as a,f as t,c as i,j as c,v as z,y as g,k as u,o as p,a as s,w as Z,d as E,t as L,x as X}from"../chunks/index.b9cfb1df.js";import{T as Ue}from"../chunks/Tip.b1721f66.js";import{D as ge}from"../chunks/Docstring.b6bea7fc.js";import{C as _e}from"../chunks/CodeBlock.ecee8caa.js";import{I as Je}from"../chunks/IconCopyLink.84ab4989.js";function Ne(R){let o,J='The <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> class is optimized for 🤗 Transformers models running on AWS Trainium.';return{c(){o=r("p"),o.innerHTML=J},l(m){o=a(m,"P",{"data-svelte-h":!0}),g(o)!=="svelte-95vt7d"&&(o.innerHTML=J)},m(m,B){s(m,o,B)},p:Ie,d(m){m&&t(o)}}}function Be(R){let o,J,m,B,h,w,V,b,ae,k,pe="NeuronTrainer",G,v,ue='The <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> class provides an extended API for the feature-complete <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Transformers Trainer</a>. It is used in all the <a href="https://github.com/huggingface/optimum-neuron/tree/main/examples" rel="nofollow">example scripts</a>.',q,M,Q,I,me='Here is an example of how to customize <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> to use a weighted loss (useful when you have an unbalanced training set):',Y,$,F,j,ce='Another way to customize the training loop behavior for the PyTorch <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> is to use <a href="https://huggingface.co/docs/transformers/main_classes/callback" rel="nofollow">callbacks</a> that can inspect the training loop state (for progress reporting, logging on TensorBoard or other ML platforms…) and take decisions (like early stopping).',D,f,y,W,C,oe,x,he="NeuronTrainer",K,d,U,le,H,fe="Trainer that is suited for performing training on AWS Tranium instances.",O,T,_,ie,A,de="Seq2SeqTrainer that is suited for performing training on AWS Tranium instances.",ee,P,te;return b=new Je({}),M=new Ue({props:{warning:!0,$$slots:{default:[Ne]},$$scope:{ctx:R}}}),$=new _e({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25UcmFpbmVyJTBBJTBBJTBBY2xhc3MlMjBDdXN0b21OZXVyb25UcmFpbmVyKE5ldXJvblRyYWluZXIpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwY29tcHV0ZV9sb3NzKHNlbGYlMkMlMjBtb2RlbCUyQyUyMGlucHV0cyUyQyUyMHJldHVybl9vdXRwdXRzJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwaW5wdXRzLmdldCglMjJsYWJlbHMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5nZXQoJTIybG9naXRzJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjBjdXN0b20lMjBsb3NzJTIwKHN1cHBvc2UlMjBvbmUlMjBoYXMlMjAzJTIwbGFiZWxzJTIwd2l0aCUyMGRpZmZlcmVudCUyMHdlaWdodHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zc19mY3QlMjAlM0QlMjBubi5Dcm9zc0VudHJvcHlMb3NzKHdlaWdodCUzRHRvcmNoLnRlbnNvciglNUIxLjAlMkMlMjAyLjAlMkMlMjAzLjAlNUQpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2ZjdChsb2dpdHMudmlldygtMSUyQyUyMHNlbGYubW9kZWwuY29uZmlnLm51bV9sYWJlbHMpJTJDJTIwbGFiZWxzLnZpZXcoLTEpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMChsb3NzJTJDJTIwb3V0cHV0cyklMjBpZiUyMHJldHVybl9vdXRwdXRzJTIwZWxzZSUyMGxvc3M=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer


<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomNeuronTrainer</span>(<span class="hljs-title class_ inherited__">NeuronTrainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, model, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        labels = inputs.get(<span class="hljs-string">&quot;labels&quot;</span>)
        <span class="hljs-comment"># forward pass</span>
        outputs = model(**inputs)
        logits = outputs.get(<span class="hljs-string">&quot;logits&quot;</span>)
        <span class="hljs-comment"># compute custom loss (suppose one has 3 labels with different weights)</span>
        loss_fct = nn.CrossEntropyLoss(weight=torch.tensor([<span class="hljs-number">1.0</span>, <span class="hljs-number">2.0</span>, <span class="hljs-number">3.0</span>]))
        loss = loss_fct(logits.view(-<span class="hljs-number">1</span>, self.model.config.num_labels), labels.view(-<span class="hljs-number">1</span>))
        <span class="hljs-keyword">return</span> (loss, outputs) <span class="hljs-keyword">if</span> return_outputs <span class="hljs-keyword">else</span> loss`,wrap:!1}}),C=new Je({}),U=new ge({props:{name:"class optimum.neuron.NeuronTrainer",anchor:"optimum.neuron.NeuronTrainer",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum.neuron/blob/main/optimum/neuron/trainers.py#L455"}}),_=new ge({props:{name:"class optimum.neuron.Seq2SeqNeuronTrainer",anchor:"optimum.neuron.Seq2SeqNeuronTrainer",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum.neuron/blob/main/optimum/neuron/trainers.py#L461"}}),{c(){o=r("meta"),J=l(),m=r("p"),B=l(),h=r("h1"),w=r("a"),V=r("span"),S(b.$$.fragment),ae=l(),k=r("span"),k.textContent=pe,G=l(),v=r("p"),v.innerHTML=ue,q=l(),S(M.$$.fragment),Q=l(),I=r("p"),I.innerHTML=me,Y=l(),S($.$$.fragment),F=l(),j=r("p"),j.innerHTML=ce,D=l(),f=r("h2"),y=r("a"),W=r("span"),S(C.$$.fragment),oe=l(),x=r("span"),x.textContent=he,K=l(),d=r("div"),S(U.$$.fragment),le=l(),H=r("p"),H.textContent=fe,O=l(),T=r("div"),S(_.$$.fragment),ie=l(),A=r("p"),A.textContent=de,ee=l(),P=r("p"),this.h()},l(e){const n=Ce("svelte-1phssyn",document.head);o=a(n,"META",{name:!0,content:!0}),n.forEach(t),J=i(e),m=a(e,"P",{}),c(m).forEach(t),B=i(e),h=a(e,"H1",{class:!0});var N=c(h);w=a(N,"A",{id:!0,class:!0,href:!0});var Te=c(w);V=a(Te,"SPAN",{});var we=c(V);z(b.$$.fragment,we),we.forEach(t),Te.forEach(t),ae=i(N),k=a(N,"SPAN",{"data-svelte-h":!0}),g(k)!=="svelte-1syzrd3"&&(k.textContent=pe),N.forEach(t),G=i(e),v=a(e,"P",{"data-svelte-h":!0}),g(v)!=="svelte-17t4iuq"&&(v.innerHTML=ue),q=i(e),z(M.$$.fragment,e),Q=i(e),I=a(e,"P",{"data-svelte-h":!0}),g(I)!=="svelte-6qwkss"&&(I.innerHTML=me),Y=i(e),z($.$$.fragment,e),F=i(e),j=a(e,"P",{"data-svelte-h":!0}),g(j)!=="svelte-1v1d9m6"&&(j.innerHTML=ce),D=i(e),f=a(e,"H2",{class:!0});var ne=c(f);y=a(ne,"A",{id:!0,class:!0,href:!0});var Me=c(y);W=a(Me,"SPAN",{});var ye=c(W);z(C.$$.fragment,ye),ye.forEach(t),Me.forEach(t),oe=i(ne),x=a(ne,"SPAN",{"data-svelte-h":!0}),g(x)!=="svelte-1syzrd3"&&(x.textContent=he),ne.forEach(t),K=i(e),d=a(e,"DIV",{class:!0});var se=c(d);z(U.$$.fragment,se),le=i(se),H=a(se,"P",{"data-svelte-h":!0}),g(H)!=="svelte-1l8fy86"&&(H.textContent=fe),se.forEach(t),O=i(e),T=a(e,"DIV",{class:!0});var re=c(T);z(_.$$.fragment,re),ie=i(re),A=a(re,"P",{"data-svelte-h":!0}),g(A)!=="svelte-1qxnatk"&&(A.textContent=de),re.forEach(t),ee=i(e),P=a(e,"P",{}),c(P).forEach(t),this.h()},h(){u(o,"name","hf:doc:metadata"),u(o,"content",JSON.stringify(ke)),u(w,"id","neurontrainer"),u(w,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(w,"href","#neurontrainer"),u(h,"class","relative group"),u(y,"id","optimum.neuron.NeuronTrainer"),u(y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(y,"href","#optimum.neuron.NeuronTrainer"),u(f,"class","relative group"),u(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){p(document.head,o),s(e,J,n),s(e,m,n),s(e,B,n),s(e,h,n),p(h,w),p(w,V),Z(b,V,null),p(h,ae),p(h,k),s(e,G,n),s(e,v,n),s(e,q,n),Z(M,e,n),s(e,Q,n),s(e,I,n),s(e,Y,n),Z($,e,n),s(e,F,n),s(e,j,n),s(e,D,n),s(e,f,n),p(f,y),p(y,W),Z(C,W,null),p(f,oe),p(f,x),s(e,K,n),s(e,d,n),Z(U,d,null),p(d,le),p(d,H),s(e,O,n),s(e,T,n),Z(_,T,null),p(T,ie),p(T,A),s(e,ee,n),s(e,P,n),te=!0},p(e,[n]){const N={};n&2&&(N.$$scope={dirty:n,ctx:e}),M.$set(N)},i(e){te||(E(b.$$.fragment,e),E(M.$$.fragment,e),E($.$$.fragment,e),E(C.$$.fragment,e),E(U.$$.fragment,e),E(_.$$.fragment,e),te=!0)},o(e){L(b.$$.fragment,e),L(M.$$.fragment,e),L($.$$.fragment,e),L(C.$$.fragment,e),L(U.$$.fragment,e),L(_.$$.fragment,e),te=!1},d(e){e&&(t(J),t(m),t(B),t(h),t(G),t(v),t(q),t(Q),t(I),t(Y),t(F),t(j),t(D),t(f),t(K),t(d),t(O),t(T),t(ee),t(P)),t(o),X(b),X(M,e),X($,e),X(C),X(U),X(_)}}}const ke={local:"neurontrainer",sections:[{local:"optimum.neuron.NeuronTrainer",title:"NeuronTrainer"}],title:"NeuronTrainer"};function xe(R){return ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Le extends $e{constructor(o){super(),je(this,o,xe,Be,be,{})}}export{Le as component};
