import{s as Sa,n as Ea,o as Va}from"../chunks/scheduler.9039eef2.js";import{S as Ya,i as La,g as l,s as i,u as h,A as Pa,h as s,f as e,c as r,j as d,v as u,y as o,k as p,o as c,a as n,w as m,d as M,t as w,x as y}from"../chunks/index.b9cfb1df.js";import{I as Rt}from"../chunks/IconCopyLink.84ab4989.js";import{C as f}from"../chunks/CodeBlock.ecee8caa.js";function qa(Le){let T,Xt,kt,Ht,U,C,Gt,k,Qe,Ct,Pe="Fine-tune BERT for Text Classification on AWS Trainium",At,G,qe='This tutorial will help you to get started with <a href="https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls" rel="nofollow">AWS Trainium</a> and Hugging Face Transformers. It will cover how to set up a Trainium instance on AWS, load &amp; fine-tune a transformers model for text-classification',zt,x,De="You will learn how to:",Nt,B,Ke='<li><a href="#1-setup-aws-environment">Setup AWS environment</a></li> <li><a href="#2-load-and-process-the-dataset">Load and process the dataset</a></li> <li><a href="#3-fine-tune-bert-using-hugging-face-transformers">Fine-tune BERT using Hugging Face Transformers and Optimum Neuron</a></li>',Qt,Z,Oe='Before we can start, make sure you have a <a href="https://huggingface.co/join" rel="nofollow">Hugging Face Account</a> to save artifacts and experiments.',St,J,j,xt,F,Se,jt,ta="Quick intro: AWS Trainium",Et,$,ea='<a href="https://aws.amazon.com/de/ec2/instance-types/trn1/" rel="nofollow">AWS Trainium (Trn1)</a> is a purpose-built EC2 for deep learning (DL) training workloads. Trainium is the successor of <a href="https://aws.amazon.com/ec2/instance-types/inf1/?nc1=h_ls" rel="nofollow">AWS Inferentia</a> focused on high-performance training workloads claiming up to 50% cost-to-train savings over comparable GPU-based instances.',Vt,R,aa="Trainium has been optimized for training natural language processing, computer vision, and recommender models used. The accelerator supports a wide range of data types, including FP32, TF32, BF16, FP16, UINT8, and configurable FP8.",Yt,X,na='The biggest Trainium instance, the <code>trn1.32xlarge</code> comes with over 500GB of memory, making it easy to fine-tune ~10B parameter models on a single instance. Below you will find an overview of the available instance types. More details <a href="https://aws.amazon.com/de/ec2/instance-types/trn1/#Product_details" rel="nofollow">here</a>:',Lt,H,la="<thead><tr><th>instance size</th> <th>accelerators</th> <th>accelerator memory</th> <th>vCPU</th> <th>CPU Memory</th> <th>price per hour</th></tr></thead> <tbody><tr><td>trn1.2xlarge</td> <td>1</td> <td>32</td> <td>8</td> <td>32</td> <td>$1.34</td></tr> <tr><td>trn1.32xlarge</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>$21.50</td></tr> <tr><td>trn1n.32xlarge (2x bandwidth)</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>$24.78</td></tr></tbody>",Pt,qt,Dt,A,sa="Now we know what Trainium offers, let’s get started. 🚀",Kt,z,ia="<em>Note: This tutorial was created on a trn1.2xlarge AWS EC2 Instance.</em>",Ot,g,I,Bt,N,Ee,It,ra="1. Setup AWS environment",te,Q,oa='In this example, we will use the <code>trn1.2xlarge</code> instance on AWS with 1 Accelerator, including two Neuron Cores and the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a>.',ee,S,pa='This blog post doesn’t cover how to create the instance in detail. You can check out my previous blog about <a href="https://www.philschmid.de/setup-aws-trainium" rel="nofollow">“Setting up AWS Trainium for Hugging Face Transformers”</a>, which includes a step-by-step guide on setting up the environment.',ae,E,ca="Once the instance is up and running, we can ssh into it. But instead of developing inside a terminal we want to use a <code>Jupyter</code> environment, which we can use for preparing our dataset and launching the training. For this, we need to add a port for forwarding in the <code>ssh</code> command, which will tunnel our localhost traffic to the Trainium instance.",ne,V,le,Y,da="We can now start our <strong><code>jupyter</code></strong> server.",se,L,ie,P,ha="You should see a familiar <strong><code>jupyter</code></strong> output with a URL to the notebook.",re,q,ua="<strong><code>http://localhost:8080/?token=8c1739aff1755bd7958c4cfccc8d08cb5da5234f61f129a9</code></strong>",oe,D,ma="We can click on it, and a <strong><code>jupyter</code></strong> environment opens in our local browser.",pe,K,Ma='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/optimum/neuron/tutorial-fine-tune-bert-jupyter.png" alt="jupyter.webp"/>',ce,O,wa="We are going to use the Jupyter environment only for preparing the dataset and then <code>torchrun</code> for launching our training script on both neuron cores for distributed training. Lets create a new notebook and get started.",de,b,_,Zt,tt,Ve,_t,ya="2. Load and process the dataset",he,et,fa='We are training a Text Classification model on the <a href="https://huggingface.co/datasets/philschmid/emotion" rel="nofollow">emotion</a> dataset to keep the example straightforward. The <code>emotion</code> is a dataset of English Twitter messages with six basic emotions: anger, fear, joy, love, sadness, and surprise.',ue,at,Ta='We will use the <code>load_dataset()</code> method from the <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">🤗 Datasets</a> library to load the <code>emotion</code>.',me,nt,Me,lt,Ua="Let’s check out an example of the dataset.",we,st,ye,it,Ja='We must convert our “Natural Language” to token IDs to train our model. This is done by a Tokenizer, which tokenizes the inputs (including converting the tokens to their corresponding IDs in the pre-trained vocabulary). if you want to learn more about this, out <a href="https://huggingface.co/course/chapter6/1?fw=pt" rel="nofollow">chapter 6</a> of the <a href="https://huggingface.co/course/chapter1/1" rel="nofollow">Hugging Face Course</a>.',fe,rt,ga="Our Neuron Accelerator expects a fixed shape of inputs. We need to truncate or pad all samples to the same length.",Te,ot,Ue,v,W,Ft,pt,Ye,Wt,ba="3. Fine-tune BERT using Hugging Face Transformers",Je,ct,va='Normally you would use the <a href="https://huggingface.co/docs/transformers/v4.19.4/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> and <a href="https://huggingface.co/docs/transformers/v4.19.4/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> to fine-tune PyTorch-based transformer models.',ge,dt,Ca='But together with AWS, we have developed a <code>NeuronTrainer</code> to improve performance, robustness, and safety when training on Trainium instances. The <code>NeuronTrainer</code> also comes with a <a href="https://www.notion.so/Getting-started-with-AWS-Trainium-and-Hugging-Face-Transformers-8428c72556194aed9c393de101229dcf" rel="nofollow">model cache</a>, which allows us to use precompiled models and configuration from Hugging Face Hub to skip the compilation step, which would be needed at the beginning of training. This can reduce the training time by ~3x.',be,ht,ja="The <code>NeuronTrainer</code> is part of the <code>optimum-neuron</code> library and can be used as a 1-to-1 replacement for the <code>Trainer</code>. You only have to adjust the import in your training script.",ve,ut,Ce,mt,Ia='We prepared a simple <a href="https://github.com/philschmid/aws-neuron-samples/blob/main/training/scripts/train.py" rel="nofollow">train.py</a> training script based on the <a href="https://www.philschmid.de/getting-started-pytorch-2-0-transformers#3-fine-tune--evaluate-bert-model-with-the-hugging-face-trainer" rel="nofollow">“Getting started with Pytorch 2.0 and Hugging Face Transformers”</a> blog post with the <code>NeuronTrainer</code>. Below is an excerpt',je,Mt,Ie,wt,_a='We can load the training script into our environment using the <code>wget</code> command or manually copy it into the notebook from <a href="https://github.com/huggingface/optimum-neuron/blob/notebooks/text-classification/scripts/train.py" rel="nofollow">here</a>.',_e,yt,We,ft,Wa="We will use <code>torchrun</code> to launch our training script on both neuron cores for distributed training. <code>torchrun</code> is a tool that automatically distributes a PyTorch model across multiple accelerators. We can pass the number of accelerators as <code>nproc_per_node</code> arguments alongside our hyperparameters.",ke,Tt,ka="We’ll use the following command to launch training:",Ge,Ut,xe,Jt,Ga="<em><strong>Note</strong>: If you see bad, bad accuracy, you might want to deactivate <code>bf16</code> for now.</em>",Be,gt,xa="After 9 minutes the training was completed and achieved an excellent f1 score of <code>0.914</code>.",Ze,bt,Fe,vt,Ba="Last but not least, terminate the EC2 instance to avoid unnecessary charges. Looking at the price-performance, our training only cost <strong><code>20ct</code></strong> (<strong><code>1.34$/h * 0.15h = 0.20$</code></strong>)",$e,$t,Re;return k=new Rt({}),F=new Rt({}),N=new Rt({}),V=new f({props:{code:"UFVCTElDX0ROUyUzRCUyMiUyMiUyMCUyMyUyMElQJTIwYWRkcmVzcyUyQyUyMGUuZy4lMjBlYzItMy04MC0uLi4uJTBBS0VZX1BBVEglM0QlMjIlMjIlMjAlMjMlMjBsb2NhbCUyMHBhdGglMjB0byUyMGtleSUyQyUyMGUuZy4lMjBzc2glMkZ0cm4ucGVtJTBBJTBBc3NoJTIwLUwlMjA4MDgwJTNBbG9jYWxob3N0JTNBODA4MCUyMC1pJTIwJTI0JTdCS0VZX05BTUUlN0QucGVtJTIwdWJ1bnR1JTQwJTI0UFVCTElDX0ROUw==",highlighted:`PUBLIC_DNS=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># IP address, e.g. ec2-3-80-....</span>
KEY_PATH=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># local path to key, e.g. ssh/trn.pem</span>

ssh -L 8080:localhost:8080 -i <span class="hljs-variable">\${KEY_NAME}</span>.pem ubuntu@<span class="hljs-variable">$PUBLIC_DNS</span>`,wrap:!1}}),L=new f({props:{code:"cHl0aG9uJTIwLW0lMjBub3RlYm9vayUyMC0tYWxsb3ctcm9vdCUyMC0tcG9ydCUzRDgwODA=",highlighted:"python -m notebook --allow-root --port=8080",wrap:!1}}),tt=new Rt({}),nt=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwRGF0YXNldCUyMGlkJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldCUwQWRhdGFzZXRfaWQlMjAlM0QlMjAlMjJwaGlsc2NobWlkJTJGZW1vdGlvbiUyMiUwQSUwQSUyMyUyMExvYWQlMjByYXclMjBkYXRhc2V0JTBBcmF3X2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9pZCklMEElMEFwcmludChmJTIyVHJhaW4lMjBkYXRhc2V0JTIwc2l6ZSUzQSUyMCU3QmxlbihyYXdfZGF0YXNldCU1Qid0cmFpbiclNUQpJTdEJTIyKSUwQXByaW50KGYlMjJUZXN0JTIwZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4ocmF3X2RhdGFzZXQlNUIndGVzdCclNUQpJTdEJTIyKSUwQSUwQSUyMyUyMFRyYWluJTIwZGF0YXNldCUyMHNpemUlM0ElMjAxNjAwMCUwQSUyMyUyMFRlc3QlMjBkYXRhc2V0JTIwc2l6ZSUzQSUyMDIwMDA=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Dataset id from huggingface.co/dataset</span>
dataset_id = <span class="hljs-string">&quot;philschmid/emotion&quot;</span>

<span class="hljs-comment"># Load raw dataset</span>
raw_dataset = load_dataset(dataset_id)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Train dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(raw_dataset[<span class="hljs-string">&#x27;train&#x27;</span>])}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Test dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(raw_dataset[<span class="hljs-string">&#x27;test&#x27;</span>])}</span>&quot;</span>)

<span class="hljs-comment"># Train dataset size: 16000</span>
<span class="hljs-comment"># Test dataset size: 2000</span>`,wrap:!1}}),st=new f({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQXJhbmRvbV9pZCUyMCUzRCUyMHJhbmRyYW5nZShsZW4ocmF3X2RhdGFzZXQlNUIndHJhaW4nJTVEKSklMEFyYXdfZGF0YXNldCU1Qid0cmFpbiclNUQlNUJyYW5kb21faWQlNUQlMEElMjMlMjAlN0IndGV4dCclM0ElMjAnaSUyMGZlZWwlMjBpc29sYXRlZCUyMGFuZCUyMGFsb25lJTIwaW4lMjBteSUyMHRyYWRlJyUyQyUyMCdsYWJlbCclM0ElMjAwJTdE",highlighted:`<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

random_id = randrange(<span class="hljs-built_in">len</span>(raw_dataset[<span class="hljs-string">&#x27;train&#x27;</span>]))
raw_dataset[<span class="hljs-string">&#x27;train&#x27;</span>][random_id]
<span class="hljs-comment"># {&#x27;text&#x27;: &#x27;i feel isolated and alone in my trade&#x27;, &#x27;label&#x27;: 0}</span>`,wrap:!1}}),ot=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFpbXBvcnQlMjBvcyUwQSUyMyUyME1vZGVsJTIwaWQlMjB0byUyMGxvYWQlMjB0aGUlMjB0b2tlbml6ZXIlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTBBc2F2ZV9kYXRhc2V0X3BhdGglMjAlM0QlMjAlMjJsbV9kYXRhc2V0JTIyJTBBJTIzJTIwTG9hZCUyMFRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQSUyMyUyMFRva2VuaXplJTIwaGVscGVyJTIwZnVuY3Rpb24lMEFkZWYlMjB0b2tlbml6ZShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoYmF0Y2glNUIndGV4dCclNUQlMkMlMjBwYWRkaW5nJTNEJ21heF9sZW5ndGgnJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkNyZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFRva2VuaXplJTIwZGF0YXNldCUwQXJhd19kYXRhc2V0JTIwJTNEJTIwJTIwcmF3X2RhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMjAlMjMlMjB0byUyMG1hdGNoJTIwVHJhaW5lciUwQXRva2VuaXplZF9kYXRhc2V0JTIwJTNEJTIwcmF3X2RhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzRFRydWUlMkMlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMnRleHQlMjIlNUQpJTBBdG9rZW5pemVkX2RhdGFzZXQlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldC53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEElMEElMjMlMjBzYXZlJTIwZGF0YXNldCUyMHRvJTIwZGlzayUwQXRva2VuaXplZF9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQuc2F2ZV90b19kaXNrKG9zLnBhdGguam9pbihzYXZlX2RhdGFzZXRfcGF0aCUyQyUyMnRyYWluJTIyKSklMEF0b2tlbml6ZWRfZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQuc2F2ZV90b19kaXNrKG9zLnBhdGguam9pbihzYXZlX2RhdGFzZXRfcGF0aCUyQyUyMmV2YWwlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">import</span> os
<span class="hljs-comment"># Model id to load the tokenizer</span>
model_id = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
save_dataset_path = <span class="hljs-string">&quot;lm_dataset&quot;</span>
<span class="hljs-comment"># Load Tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-comment"># Tokenize helper function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&#x27;text&#x27;</span>], padding=<span class="hljs-string">&#x27;max_length&#x27;</span>, truncation=<span class="hljs-literal">True</span>,return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># Tokenize dataset</span>
raw_dataset =  raw_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>) <span class="hljs-comment"># to match Trainer</span>
tokenized_dataset = raw_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&quot;text&quot;</span>])
tokenized_dataset = tokenized_dataset.with_format(<span class="hljs-string">&quot;torch&quot;</span>)

<span class="hljs-comment"># save dataset to disk</span>
tokenized_dataset[<span class="hljs-string">&quot;train&quot;</span>].save_to_disk(os.path.join(save_dataset_path,<span class="hljs-string">&quot;train&quot;</span>))
tokenized_dataset[<span class="hljs-string">&quot;test&quot;</span>].save_to_disk(os.path.join(save_dataset_path,<span class="hljs-string">&quot;eval&quot;</span>))`,wrap:!1}}),pt=new Rt({}),ut=new f({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTBBJTJCJTIwZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5lciUyMGFzJTIwVHJhaW5lcg==",highlighted:`<span class="hljs-deletion">- from transformers import Trainer</span>
<span class="hljs-addition">+ from optimum.neuron import NeuronTrainer as Trainer</span>`,wrap:!1}}),Mt=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5lciUyMGFzJTIwVHJhaW5lciUwQSUwQWRlZiUyMHBhcnNlX2FyZ3MoKSUzQSUwQSUwOS4uLiUwQSUwQWRlZiUyMHRyYWluaW5nX2Z1bmN0aW9uKGFyZ3MpJTNBJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbG9hZCUyMGRhdGFzZXQlMjBmcm9tJTIwZGlzayUyMGFuZCUyMHRva2VuaXplciUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2Zyb21fZGlzayhvcy5wYXRoLmpvaW4oYXJncy5kYXRhc2V0X3BhdGglMkMlMjAlMjJ0cmFpbiUyMikpJTBBJTA5JTA5Li4uJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRG93bmxvYWQlMjB0aGUlMjBtb2RlbCUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyRm1vZGVscyUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncy5tb2RlbF9pZCUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUwOSUwOSUwOS4uLiUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGUlMjBUcmFpbmVyJTIwaW5zdGFuY2UlMEElMjAlMjAlMjAlMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGV2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBTdGFydCUyMHRyYWluaW5nJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer <span class="hljs-keyword">as</span> Trainer

<span class="hljs-keyword">def</span> <span class="hljs-title function_">parse_args</span>():
	...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_function</span>(<span class="hljs-params">args</span>):

    <span class="hljs-comment"># load dataset from disk and tokenizer</span>
    train_dataset = load_from_disk(os.path.join(args.dataset_path, <span class="hljs-string">&quot;train&quot;</span>))
		...

    <span class="hljs-comment"># Download the model from huggingface.co/models</span>
    model = AutoModelForSequenceClassification.from_pretrained(
        args.model_id, num_labels=num_labels, label2id=label2id, id2label=id2label
    )

    training_args = TrainingArguments(
			...
    )

    <span class="hljs-comment"># Create Trainer instance</span>
    trainer = Trainer(
        model=model,
        args=training_args,
        train_dataset=train_dataset,
        eval_dataset=eval_dataset,
        compute_metrics=compute_metrics,
    )

    <span class="hljs-comment"># Start training</span>
    trainer.train()`,wrap:!1}}),yt=new f({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tbmV1cm9uJTJGbm90ZWJvb2tzJTJGdGV4dC1jbGFzc2lmaWNhdGlvbiUyRnNjcmlwdHMlMkZ0cmFpbi5weQ==",highlighted:"!wget https://raw.githubusercontent.com/huggingface/optimum-neuron/notebooks/text-classification/scripts/train.py",wrap:!1}}),Ut=new f({props:{code:"IXRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDIlMjBzY3JpcHRzJTJGdHJhaW4ucHklMjAlNUMlMEElMjAtLW1vZGVsX2lkJTIwYmVydC1iYXNlLXVuY2FzZWQlMjAlNUMlMEElMjAtLWRhdGFzZXRfcGF0aCUyMGxtX2RhdGFzZXQlMjAlNUMlMEElMjAtLWxyJTIwNWUtNSUyMCU1QyUwQSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMTYlMjAlNUMlMEElMjAtLWJmMTYlMjBUcnVlJTIwJTVDJTBBJTIwLS1lcG9jaHMlMjAz",highlighted:`!torchrun --nproc_per_node=2 scripts/train.py \\
 --model_id bert-base-uncased \\
 --dataset_path lm_dataset \\
 --lr 5e-5 \\
 --per_device_train_batch_size 16 \\
 --bf16 True \\
 --epochs 3`,wrap:!1}}),bt=new f({props:{code:"KioqKiolMjB0cmFpbiUyMG1ldHJpY3MlMjAqKioqKiUwQSUyMCUyMGVwb2NoJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMy4wJTBBJTIwJTIwdHJhaW5fcnVudGltZSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCUyMCUyMCUyMDAlM0EwOCUzQTMwJTBBJTIwJTIwdHJhaW5fc2FtcGxlcyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCUyMCUyMCUyMCUyMCUyMDE2MDAwJTBBJTIwJTIwdHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJTIwJTNEJTIwJTIwJTIwJTIwJTIwOTYuMzM3JTBBJTBBKioqKiolMjBldmFsJTIwbWV0cmljcyUyMCoqKioqJTBBJTIwJTIwZXZhbF9mMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCUyMCUyMCUyMCUyMCUyMDAuOTE0JTBBJTIwJTIwZXZhbF9ydW50aW1lJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTIwJTIwJTIwMCUzQTAwJTNBMDg=",highlighted:`***** train metrics *****
  epoch                    =        3.0
  train_runtime            =    0:08:30
  train_samples            =      16000
  train_samples_per_second =     96.337

***** <span class="hljs-built_in">eval</span> metrics *****
  eval_f1                  =      0.914
  eval_runtime             =    0:00:08`,wrap:!1}}),{c(){T=l("meta"),Xt=i(),kt=l("p"),Ht=i(),U=l("h1"),C=l("a"),Gt=l("span"),h(k.$$.fragment),Qe=i(),Ct=l("span"),Ct.textContent=Pe,At=i(),G=l("p"),G.innerHTML=qe,zt=i(),x=l("p"),x.textContent=De,Nt=i(),B=l("ol"),B.innerHTML=Ke,Qt=i(),Z=l("p"),Z.innerHTML=Oe,St=i(),J=l("h2"),j=l("a"),xt=l("span"),h(F.$$.fragment),Se=i(),jt=l("span"),jt.textContent=ta,Et=i(),$=l("p"),$.innerHTML=ea,Vt=i(),R=l("p"),R.textContent=aa,Yt=i(),X=l("p"),X.innerHTML=na,Lt=i(),H=l("table"),H.innerHTML=la,Pt=i(),qt=l("hr"),Dt=i(),A=l("p"),A.textContent=sa,Kt=i(),z=l("p"),z.innerHTML=ia,Ot=i(),g=l("h2"),I=l("a"),Bt=l("span"),h(N.$$.fragment),Ee=i(),It=l("span"),It.textContent=ra,te=i(),Q=l("p"),Q.innerHTML=oa,ee=i(),S=l("p"),S.innerHTML=pa,ae=i(),E=l("p"),E.innerHTML=ca,ne=i(),h(V.$$.fragment),le=i(),Y=l("p"),Y.innerHTML=da,se=i(),h(L.$$.fragment),ie=i(),P=l("p"),P.innerHTML=ha,re=i(),q=l("p"),q.innerHTML=ua,oe=i(),D=l("p"),D.innerHTML=ma,pe=i(),K=l("p"),K.innerHTML=Ma,ce=i(),O=l("p"),O.innerHTML=wa,de=i(),b=l("h2"),_=l("a"),Zt=l("span"),h(tt.$$.fragment),Ve=i(),_t=l("span"),_t.textContent=ya,he=i(),et=l("p"),et.innerHTML=fa,ue=i(),at=l("p"),at.innerHTML=Ta,me=i(),h(nt.$$.fragment),Me=i(),lt=l("p"),lt.textContent=Ua,we=i(),h(st.$$.fragment),ye=i(),it=l("p"),it.innerHTML=Ja,fe=i(),rt=l("p"),rt.textContent=ga,Te=i(),h(ot.$$.fragment),Ue=i(),v=l("h2"),W=l("a"),Ft=l("span"),h(pt.$$.fragment),Ye=i(),Wt=l("span"),Wt.textContent=ba,Je=i(),ct=l("p"),ct.innerHTML=va,ge=i(),dt=l("p"),dt.innerHTML=Ca,be=i(),ht=l("p"),ht.innerHTML=ja,ve=i(),h(ut.$$.fragment),Ce=i(),mt=l("p"),mt.innerHTML=Ia,je=i(),h(Mt.$$.fragment),Ie=i(),wt=l("p"),wt.innerHTML=_a,_e=i(),h(yt.$$.fragment),We=i(),ft=l("p"),ft.innerHTML=Wa,ke=i(),Tt=l("p"),Tt.textContent=ka,Ge=i(),h(Ut.$$.fragment),xe=i(),Jt=l("p"),Jt.innerHTML=Ga,Be=i(),gt=l("p"),gt.innerHTML=xa,Ze=i(),h(bt.$$.fragment),Fe=i(),vt=l("p"),vt.innerHTML=Ba,$e=i(),$t=l("p"),this.h()},l(t){const a=Pa("svelte-1phssyn",document.head);T=s(a,"META",{name:!0,content:!0}),a.forEach(e),Xt=r(t),kt=s(t,"P",{}),d(kt).forEach(e),Ht=r(t),U=s(t,"H1",{class:!0});var Xe=d(U);C=s(Xe,"A",{id:!0,class:!0,href:!0});var Za=d(C);Gt=s(Za,"SPAN",{});var Fa=d(Gt);u(k.$$.fragment,Fa),Fa.forEach(e),Za.forEach(e),Qe=r(Xe),Ct=s(Xe,"SPAN",{"data-svelte-h":!0}),o(Ct)!=="svelte-1sf0rwu"&&(Ct.textContent=Pe),Xe.forEach(e),At=r(t),G=s(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-fq2j94"&&(G.innerHTML=qe),zt=r(t),x=s(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1hahfn0"&&(x.textContent=De),Nt=r(t),B=s(t,"OL",{"data-svelte-h":!0}),o(B)!=="svelte-i2dg6s"&&(B.innerHTML=Ke),Qt=r(t),Z=s(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1dtnb6s"&&(Z.innerHTML=Oe),St=r(t),J=s(t,"H2",{class:!0});var He=d(J);j=s(He,"A",{id:!0,class:!0,href:!0});var $a=d(j);xt=s($a,"SPAN",{});var Ra=d(xt);u(F.$$.fragment,Ra),Ra.forEach(e),$a.forEach(e),Se=r(He),jt=s(He,"SPAN",{"data-svelte-h":!0}),o(jt)!=="svelte-f0n0ts"&&(jt.textContent=ta),He.forEach(e),Et=r(t),$=s(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-i1bq8"&&($.innerHTML=ea),Vt=r(t),R=s(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1xmmjdv"&&(R.textContent=aa),Yt=r(t),X=s(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-f3jgz1"&&(X.innerHTML=na),Lt=r(t),H=s(t,"TABLE",{"data-svelte-h":!0}),o(H)!=="svelte-1ch8aud"&&(H.innerHTML=la),Pt=r(t),qt=s(t,"HR",{}),Dt=r(t),A=s(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-6n93f4"&&(A.textContent=sa),Kt=r(t),z=s(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-xlynlq"&&(z.innerHTML=ia),Ot=r(t),g=s(t,"H2",{class:!0});var Ae=d(g);I=s(Ae,"A",{id:!0,class:!0,href:!0});var Xa=d(I);Bt=s(Xa,"SPAN",{});var Ha=d(Bt);u(N.$$.fragment,Ha),Ha.forEach(e),Xa.forEach(e),Ee=r(Ae),It=s(Ae,"SPAN",{"data-svelte-h":!0}),o(It)!=="svelte-qkctrb"&&(It.textContent=ra),Ae.forEach(e),te=r(t),Q=s(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-6ygvsn"&&(Q.innerHTML=oa),ee=r(t),S=s(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1p685c9"&&(S.innerHTML=pa),ae=r(t),E=s(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1w4fiht"&&(E.innerHTML=ca),ne=r(t),u(V.$$.fragment,t),le=r(t),Y=s(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-cmik5i"&&(Y.innerHTML=da),se=r(t),u(L.$$.fragment,t),ie=r(t),P=s(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-si97e0"&&(P.innerHTML=ha),re=r(t),q=s(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-7s5jat"&&(q.innerHTML=ua),oe=r(t),D=s(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-yorl3n"&&(D.innerHTML=ma),pe=r(t),K=s(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-krn90s"&&(K.innerHTML=Ma),ce=r(t),O=s(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1op3czr"&&(O.innerHTML=wa),de=r(t),b=s(t,"H2",{class:!0});var ze=d(b);_=s(ze,"A",{id:!0,class:!0,href:!0});var Aa=d(_);Zt=s(Aa,"SPAN",{});var za=d(Zt);u(tt.$$.fragment,za),za.forEach(e),Aa.forEach(e),Ve=r(ze),_t=s(ze,"SPAN",{"data-svelte-h":!0}),o(_t)!=="svelte-2rvjz4"&&(_t.textContent=ya),ze.forEach(e),he=r(t),et=s(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-nodub0"&&(et.innerHTML=fa),ue=r(t),at=s(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1ab0i1h"&&(at.innerHTML=Ta),me=r(t),u(nt.$$.fragment,t),Me=r(t),lt=s(t,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-udg7sq"&&(lt.textContent=Ua),we=r(t),u(st.$$.fragment,t),ye=r(t),it=s(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1vv5g70"&&(it.innerHTML=Ja),fe=r(t),rt=s(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-1iixhur"&&(rt.textContent=ga),Te=r(t),u(ot.$$.fragment,t),Ue=r(t),v=s(t,"H2",{class:!0});var Ne=d(v);W=s(Ne,"A",{id:!0,class:!0,href:!0});var Na=d(W);Ft=s(Na,"SPAN",{});var Qa=d(Ft);u(pt.$$.fragment,Qa),Qa.forEach(e),Na.forEach(e),Ye=r(Ne),Wt=s(Ne,"SPAN",{"data-svelte-h":!0}),o(Wt)!=="svelte-1uwbxuo"&&(Wt.textContent=ba),Ne.forEach(e),Je=r(t),ct=s(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-spmis1"&&(ct.innerHTML=va),ge=r(t),dt=s(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-iqzsb"&&(dt.innerHTML=Ca),be=r(t),ht=s(t,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-c0yi33"&&(ht.innerHTML=ja),ve=r(t),u(ut.$$.fragment,t),Ce=r(t),mt=s(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-9f48rl"&&(mt.innerHTML=Ia),je=r(t),u(Mt.$$.fragment,t),Ie=r(t),wt=s(t,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-z4rrh7"&&(wt.innerHTML=_a),_e=r(t),u(yt.$$.fragment,t),We=r(t),ft=s(t,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1tr68b8"&&(ft.innerHTML=Wa),ke=r(t),Tt=s(t,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-folbj9"&&(Tt.textContent=ka),Ge=r(t),u(Ut.$$.fragment,t),xe=r(t),Jt=s(t,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-161fdea"&&(Jt.innerHTML=Ga),Be=r(t),gt=s(t,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-dotc0h"&&(gt.innerHTML=xa),Ze=r(t),u(bt.$$.fragment,t),Fe=r(t),vt=s(t,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1iox2bz"&&(vt.innerHTML=Ba),$e=r(t),$t=s(t,"P",{}),d($t).forEach(e),this.h()},h(){p(T,"name","hf:doc:metadata"),p(T,"content",JSON.stringify(Da)),p(C,"id","finetune-bert-for-text-classification-on-aws-trainium"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#finetune-bert-for-text-classification-on-aws-trainium"),p(U,"class","relative group"),p(j,"id","quick-intro-aws-trainium"),p(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(j,"href","#quick-intro-aws-trainium"),p(J,"class","relative group"),p(I,"id","1-setup-aws-environment"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#1-setup-aws-environment"),p(g,"class","relative group"),p(_,"id","2-load-and-process-the-dataset"),p(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(_,"href","#2-load-and-process-the-dataset"),p(b,"class","relative group"),p(W,"id","3-finetune-bert-using-hugging-face-transformers"),p(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(W,"href","#3-finetune-bert-using-hugging-face-transformers"),p(v,"class","relative group")},m(t,a){c(document.head,T),n(t,Xt,a),n(t,kt,a),n(t,Ht,a),n(t,U,a),c(U,C),c(C,Gt),m(k,Gt,null),c(U,Qe),c(U,Ct),n(t,At,a),n(t,G,a),n(t,zt,a),n(t,x,a),n(t,Nt,a),n(t,B,a),n(t,Qt,a),n(t,Z,a),n(t,St,a),n(t,J,a),c(J,j),c(j,xt),m(F,xt,null),c(J,Se),c(J,jt),n(t,Et,a),n(t,$,a),n(t,Vt,a),n(t,R,a),n(t,Yt,a),n(t,X,a),n(t,Lt,a),n(t,H,a),n(t,Pt,a),n(t,qt,a),n(t,Dt,a),n(t,A,a),n(t,Kt,a),n(t,z,a),n(t,Ot,a),n(t,g,a),c(g,I),c(I,Bt),m(N,Bt,null),c(g,Ee),c(g,It),n(t,te,a),n(t,Q,a),n(t,ee,a),n(t,S,a),n(t,ae,a),n(t,E,a),n(t,ne,a),m(V,t,a),n(t,le,a),n(t,Y,a),n(t,se,a),m(L,t,a),n(t,ie,a),n(t,P,a),n(t,re,a),n(t,q,a),n(t,oe,a),n(t,D,a),n(t,pe,a),n(t,K,a),n(t,ce,a),n(t,O,a),n(t,de,a),n(t,b,a),c(b,_),c(_,Zt),m(tt,Zt,null),c(b,Ve),c(b,_t),n(t,he,a),n(t,et,a),n(t,ue,a),n(t,at,a),n(t,me,a),m(nt,t,a),n(t,Me,a),n(t,lt,a),n(t,we,a),m(st,t,a),n(t,ye,a),n(t,it,a),n(t,fe,a),n(t,rt,a),n(t,Te,a),m(ot,t,a),n(t,Ue,a),n(t,v,a),c(v,W),c(W,Ft),m(pt,Ft,null),c(v,Ye),c(v,Wt),n(t,Je,a),n(t,ct,a),n(t,ge,a),n(t,dt,a),n(t,be,a),n(t,ht,a),n(t,ve,a),m(ut,t,a),n(t,Ce,a),n(t,mt,a),n(t,je,a),m(Mt,t,a),n(t,Ie,a),n(t,wt,a),n(t,_e,a),m(yt,t,a),n(t,We,a),n(t,ft,a),n(t,ke,a),n(t,Tt,a),n(t,Ge,a),m(Ut,t,a),n(t,xe,a),n(t,Jt,a),n(t,Be,a),n(t,gt,a),n(t,Ze,a),m(bt,t,a),n(t,Fe,a),n(t,vt,a),n(t,$e,a),n(t,$t,a),Re=!0},p:Ea,i(t){Re||(M(k.$$.fragment,t),M(F.$$.fragment,t),M(N.$$.fragment,t),M(V.$$.fragment,t),M(L.$$.fragment,t),M(tt.$$.fragment,t),M(nt.$$.fragment,t),M(st.$$.fragment,t),M(ot.$$.fragment,t),M(pt.$$.fragment,t),M(ut.$$.fragment,t),M(Mt.$$.fragment,t),M(yt.$$.fragment,t),M(Ut.$$.fragment,t),M(bt.$$.fragment,t),Re=!0)},o(t){w(k.$$.fragment,t),w(F.$$.fragment,t),w(N.$$.fragment,t),w(V.$$.fragment,t),w(L.$$.fragment,t),w(tt.$$.fragment,t),w(nt.$$.fragment,t),w(st.$$.fragment,t),w(ot.$$.fragment,t),w(pt.$$.fragment,t),w(ut.$$.fragment,t),w(Mt.$$.fragment,t),w(yt.$$.fragment,t),w(Ut.$$.fragment,t),w(bt.$$.fragment,t),Re=!1},d(t){t&&(e(Xt),e(kt),e(Ht),e(U),e(At),e(G),e(zt),e(x),e(Nt),e(B),e(Qt),e(Z),e(St),e(J),e(Et),e($),e(Vt),e(R),e(Yt),e(X),e(Lt),e(H),e(Pt),e(qt),e(Dt),e(A),e(Kt),e(z),e(Ot),e(g),e(te),e(Q),e(ee),e(S),e(ae),e(E),e(ne),e(le),e(Y),e(se),e(ie),e(P),e(re),e(q),e(oe),e(D),e(pe),e(K),e(ce),e(O),e(de),e(b),e(he),e(et),e(ue),e(at),e(me),e(Me),e(lt),e(we),e(ye),e(it),e(fe),e(rt),e(Te),e(Ue),e(v),e(Je),e(ct),e(ge),e(dt),e(be),e(ht),e(ve),e(Ce),e(mt),e(je),e(Ie),e(wt),e(_e),e(We),e(ft),e(ke),e(Tt),e(Ge),e(xe),e(Jt),e(Be),e(gt),e(Ze),e(Fe),e(vt),e($e),e($t)),e(T),y(k),y(F),y(N),y(V,t),y(L,t),y(tt),y(nt,t),y(st,t),y(ot,t),y(pt),y(ut,t),y(Mt,t),y(yt,t),y(Ut,t),y(bt,t)}}}const Da={local:"finetune-bert-for-text-classification-on-aws-trainium",sections:[{local:"quick-intro-aws-trainium",title:"Quick intro: AWS Trainium"},{local:"1-setup-aws-environment",title:"1. Setup AWS environment"},{local:"2-load-and-process-the-dataset",title:"2. Load and process the dataset"},{local:"3-finetune-bert-using-hugging-face-transformers",title:"3. Fine-tune BERT using Hugging Face Transformers"}],title:"Fine-tune BERT for Text Classification on AWS Trainium"};function Ka(Le){return Va(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nn extends Ya{constructor(T){super(),La(this,T,Ka,qa,Sa,{})}}export{nn as component};
