import{s as nl,o as pl,n as il}from"../chunks/scheduler.182ea377.js";import{S as al,i as ol,g as a,s as i,r as c,A as dl,h as o,f as t,c as n,j as ll,u as m,x as d,k as tl,y as rl,a as s,v as u,d as f,t as w,w as y}from"../chunks/index.abf12888.js";import{T as sl}from"../chunks/Tip.230e2334.js";import{C as T}from"../chunks/CodeBlock.57fe6e13.js";import{H as le}from"../chunks/Heading.16916d63.js";function cl(O){let p,M='💡 Take a look at GitHub Issue <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">#841</a> for more context about why we’re adding community pipelines to help everyone easily share their work without being slowed down.';return{c(){p=a("p"),p.innerHTML=M},l(r){p=o(r,"P",{"data-svelte-h":!0}),d(p)!=="svelte-19wo1pm"&&(p.innerHTML=M)},m(r,J){s(r,p,J)},p:il,d(r){r&&t(p)}}}function ml(O){let p,M="💡 You can use whatever package you want in your community pipeline file - as long as the user has it installed, everything will work fine. Make sure you have one and only one pipeline class that inherits from <code>DiffusionPipeline</code> because this is automatically detected.";return{c(){p=a("p"),p.innerHTML=M},l(r){p=o(r,"P",{"data-svelte-h":!0}),d(p)!=="svelte-143wzg5"&&(p.innerHTML=M)},m(r,J){s(r,p,J)},p:il,d(r){r&&t(p)}}}function ul(O){let p,M,r,J,U,te,h,se,I,ke='Community pipelines allow you to add any additional features you’d like on top of the <a href="/docs/diffusers/v0.26.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. The main benefit of building on top of the <code>DiffusionPipeline</code> is anyone can load and use your pipeline by only adding one more argument, making it super easy for the community to access.',ie,Z,He="This guide will show you how to create a community pipeline and explain how they work. To keep things simple, you’ll create a “one-step” pipeline where the <code>UNet</code> does a single forward pass and calls the scheduler once.",ne,_,pe,j,Re='You should start by creating a <code>one_step_unet.py</code> file for your community pipeline. In this file, create a pipeline class that inherits from the <a href="/docs/diffusers/v0.26.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to be able to load model weights and the scheduler configuration from the Hub. The one-step pipeline needs a <code>UNet</code> and a scheduler, so you’ll need to add these as arguments to the <code>__init__</code> function:',ae,G,oe,V,Ne='To ensure your pipeline and its components (<code>unet</code> and <code>scheduler</code>) can be saved with <a href="/docs/diffusers/v0.26.1/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>, add them to the <code>register_modules</code> function:',de,B,re,$,xe="Cool, the <code>__init__</code> step is done and you can move to the forward pass now! 🔥",ce,g,me,C,Ee="In the forward pass, which we recommend defining as <code>__call__</code>, you have complete creative freedom to add whatever feature you’d like. For our amazing one-step pipeline, create a random image and only call the <code>unet</code> and <code>scheduler</code> once by setting <code>timestep=1</code>:",ue,v,fe,W,Qe="That’s it! 🚀 You can now run this pipeline by passing a <code>unet</code> and <code>scheduler</code> to it:",we,X,ye,k,Se='But what’s even better is you can load pre-existing weights into the pipeline if the pipeline structure is identical. For example, you can load the <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow"><code>google/ddpm-cifar10-32</code></a> weights into the one-step pipeline:',Me,H,Te,R,Je,N,ze='Open a Pull Request on the 🧨 Diffusers <a href="https://github.com/huggingface/diffusers" rel="nofollow">repository</a> to add your awesome pipeline in <code>one_step_unet.py</code> to the <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">examples/community</a> subfolder.',he,x,Pe="Once it is merged, anyone with <code>diffusers &gt;= 0.4.0</code> installed can use this pipeline magically 🪄 by specifying it in the <code>custom_pipeline</code> argument:",be,E,Ue,Q,Le='Another way to share your community pipeline is to upload the <code>one_step_unet.py</code> file directly to your preferred <a href="https://huggingface.co/docs/hub/models-uploading" rel="nofollow">model repository</a> on the Hub. Instead of specifying the <code>one_step_unet.py</code> file, pass the model repository id to the <code>custom_pipeline</code> argument:',Ie,S,Ze,z,Ae="Take a look at the following table to compare the two sharing workflows to help you decide the best option for you:",_e,P,Fe="<thead><tr><th></th> <th>GitHub community pipeline</th> <th>HF Hub community pipeline</th></tr></thead> <tbody><tr><td>usage</td> <td>same</td> <td>same</td></tr> <tr><td>review process</td> <td>open a Pull Request on GitHub and undergo a review process from the Diffusers team before merging; may be slower</td> <td>upload directly to a Hub repository without any review; this is the fastest workflow</td></tr> <tr><td>visibility</td> <td>included in the official Diffusers repository and documentation</td> <td>included on your HF Hub profile and relies on your own usage/promotion to gain visibility</td></tr></tbody>",je,b,Ge,L,Ve,A,Ye='A community pipeline is a class that inherits from <a href="/docs/diffusers/v0.26.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> which means:',Be,F,De="<li>It can be loaded with the <code>custom_pipeline</code> argument.</li> <li>The model weights and scheduler configuration are loaded from <code>pretrained_model_name_or_path</code>.</li> <li>The code that implements a feature in the community pipeline is defined in a <code>pipeline.py</code> file.</li>",$e,Y,qe="Sometimes you can’t load all the pipeline components weights from an official repository. In this case, the other components should be passed directly to the pipeline:",ge,D,Ce,q,Ke="The magic behind community pipelines is contained in the following code. It allows the community pipeline to be loaded from GitHub or the Hub, and it’ll be available to all 🧨 Diffusers packages.",ve,K,We,ee,Xe;return U=new le({props:{title:"Contribute a community pipeline",local:"contribute-a-community-pipeline",headingTag:"h1"}}),h=new sl({props:{$$slots:{default:[cl]},$$scope:{ctx:O}}}),_=new le({props:{title:"Initialize the pipeline",local:"initialize-the-pipeline",headingTag:"h2"}}),G=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">class</span> <span class="hljs-title class_">UnetSchedulerOneForwardPipeline</span>(<span class="hljs-title class_ inherited__">DiffusionPipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, unet, scheduler</span>):
        <span class="hljs-built_in">super</span>().__init__()`,wrap:!1}}),B=new T({props:{code:"JTIwJTIwZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKQ==",highlighted:`  from diffusers import DiffusionPipeline
  import torch

  class UnetSchedulerOneForwardPipeline(DiffusionPipeline):
      def __init__(self, unet, scheduler):
          super().__init__()

<span class="hljs-addition">+         self.register_modules(unet=unet, scheduler=scheduler)</span>`,wrap:!1}}),g=new le({props:{title:"Define the forward pass",local:"define-the-forward-pass",headingTag:"h2"}}),v=new T({props:{code:"JTIwJTIwZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQSUwQSUyQiUyMCUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYpJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB0b3JjaC5yYW5kbiglMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoMSUyQyUyMHNlbGYudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBzZWxmLnVuZXQuY29uZmlnLnNhbXBsZV9zaXplJTJDJTIwc2VsZi51bmV0LmNvbmZpZy5zYW1wbGVfc2l6ZSklMkMlMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGltZXN0ZXAlMjAlM0QlMjAxJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfb3V0cHV0JTIwJTNEJTIwc2VsZi51bmV0KGltYWdlJTJDJTIwdGltZXN0ZXApLnNhbXBsZSUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlcl9vdXRwdXQlMjAlM0QlMjBzZWxmLnNjaGVkdWxlci5zdGVwKG1vZGVsX291dHB1dCUyQyUyMHRpbWVzdGVwJTJDJTIwaW1hZ2UpLnByZXZfc2FtcGxlJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NoZWR1bGVyX291dHB1dA==",highlighted:`  from diffusers import DiffusionPipeline
  import torch

  class UnetSchedulerOneForwardPipeline(DiffusionPipeline):
      def __init__(self, unet, scheduler):
          super().__init__()

          self.register_modules(unet=unet, scheduler=scheduler)

<span class="hljs-addition">+     def __call__(self):</span>
<span class="hljs-addition">+         image = torch.randn(</span>
<span class="hljs-addition">+             (1, self.unet.config.in_channels, self.unet.config.sample_size, self.unet.config.sample_size),</span>
<span class="hljs-addition">+         )</span>
<span class="hljs-addition">+         timestep = 1</span>

<span class="hljs-addition">+         model_output = self.unet(image, timestep).sample</span>
<span class="hljs-addition">+         scheduler_output = self.scheduler.step(model_output, timestep, image).prev_sample</span>

<span class="hljs-addition">+         return scheduler_output</span>`,wrap:!1}}),X=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIoKSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRNb2RlbCgpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBVbmV0U2NoZWR1bGVyT25lRm9yd2FyZFBpcGVsaW5lKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

scheduler = DDPMScheduler()
unet = UNet2DModel()

pipeline = UnetSchedulerOneForwardPipeline(unet=unet, scheduler=scheduler)

output = pipeline()`,wrap:!1}}),H=new T({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBVbmV0U2NoZWR1bGVyT25lRm9yd2FyZFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCk=",highlighted:`pipeline = UnetSchedulerOneForwardPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)

output = pipeline()`,wrap:!1}}),R=new le({props:{title:"Share your pipeline",local:"share-your-pipeline",headingTag:"h2"}}),E=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMkMlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJvbmVfc3RlcF91bmV0JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;one_step_unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipe()`,wrap:!1}}),S=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyc3RldmhsaXUlMkZvbmVfc3RlcF91bmV0JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;stevhliu/one_step_unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),b=new sl({props:{$$slots:{default:[ml]},$$scope:{ctx:O}}}),L=new le({props:{title:"How do community pipelines work?",local:"how-do-community-pipelines-work",headingTag:"h2"}}),D=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

model_id = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id, torch_dtype=torch.float16)

pipeline = DiffusionPipeline.from_pretrained(
    model_id,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    scheduler=scheduler,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),K=new T({props:{code:"JTIzJTIwMi4lMjBMb2FkJTIwdGhlJTIwcGlwZWxpbmUlMjBjbGFzcyUyQyUyMGlmJTIwdXNpbmclMjBjdXN0b20lMjBtb2R1bGUlMjB0aGVuJTIwbG9hZCUyMGl0JTIwZnJvbSUyMHRoZSUyMEh1YiUwQSUyMyUyMGlmJTIwd2UlMjBsb2FkJTIwZnJvbSUyMGV4cGxpY2l0JTIwY2xhc3MlMkMlMjBsZXQncyUyMHVzZSUyMGl0JTBBaWYlMjBjdXN0b21fcGlwZWxpbmUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUyMCUzRCUyMGdldF9jbGFzc19mcm9tX2R5bmFtaWNfbW9kdWxlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUyQyUyMG1vZHVsZV9maWxlJTNEQ1VTVE9NX1BJUEVMSU5FX0ZJTEVfTkFNRSUyQyUyMGNhY2hlX2RpciUzRGN1c3RvbV9waXBlbGluZSUwQSUyMCUyMCUyMCUyMCklMEFlbGlmJTIwY2xzJTIwISUzRCUyMERpZmZ1c2lvblBpcGVsaW5lJTNBJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlMjAlM0QlMjBjbHMlMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzX21vZHVsZSUyMCUzRCUyMGltcG9ydGxpYi5pbXBvcnRfbW9kdWxlKGNscy5fX21vZHVsZV9fLnNwbGl0KCUyMi4lMjIpJTVCMCU1RCklMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUyMCUzRCUyMGdldGF0dHIoZGlmZnVzZXJzX21vZHVsZSUyQyUyMGNvbmZpZ19kaWN0JTVCJTIyX2NsYXNzX25hbWUlMjIlNUQp",highlighted:`<span class="hljs-comment"># 2. Load the pipeline class, if using custom module then load it from the Hub</span>
<span class="hljs-comment"># if we load from explicit class, let&#x27;s use it</span>
<span class="hljs-keyword">if</span> custom_pipeline <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    pipeline_class = get_class_from_dynamic_module(
        custom_pipeline, module_file=CUSTOM_PIPELINE_FILE_NAME, cache_dir=custom_pipeline
    )
<span class="hljs-keyword">elif</span> cls != DiffusionPipeline:
    pipeline_class = cls
<span class="hljs-keyword">else</span>:
    diffusers_module = importlib.import_module(cls.__module__.split(<span class="hljs-string">&quot;.&quot;</span>)[<span class="hljs-number">0</span>])
    pipeline_class = <span class="hljs-built_in">getattr</span>(diffusers_module, config_dict[<span class="hljs-string">&quot;_class_name&quot;</span>])`,wrap:!1}}),{c(){p=a("meta"),M=i(),r=a("p"),J=i(),c(U.$$.fragment),te=i(),c(h.$$.fragment),se=i(),I=a("p"),I.innerHTML=ke,ie=i(),Z=a("p"),Z.innerHTML=He,ne=i(),c(_.$$.fragment),pe=i(),j=a("p"),j.innerHTML=Re,ae=i(),c(G.$$.fragment),oe=i(),V=a("p"),V.innerHTML=Ne,de=i(),c(B.$$.fragment),re=i(),$=a("p"),$.innerHTML=xe,ce=i(),c(g.$$.fragment),me=i(),C=a("p"),C.innerHTML=Ee,ue=i(),c(v.$$.fragment),fe=i(),W=a("p"),W.innerHTML=Qe,we=i(),c(X.$$.fragment),ye=i(),k=a("p"),k.innerHTML=Se,Me=i(),c(H.$$.fragment),Te=i(),c(R.$$.fragment),Je=i(),N=a("p"),N.innerHTML=ze,he=i(),x=a("p"),x.innerHTML=Pe,be=i(),c(E.$$.fragment),Ue=i(),Q=a("p"),Q.innerHTML=Le,Ie=i(),c(S.$$.fragment),Ze=i(),z=a("p"),z.textContent=Ae,_e=i(),P=a("table"),P.innerHTML=Fe,je=i(),c(b.$$.fragment),Ge=i(),c(L.$$.fragment),Ve=i(),A=a("p"),A.innerHTML=Ye,Be=i(),F=a("ul"),F.innerHTML=De,$e=i(),Y=a("p"),Y.textContent=qe,ge=i(),c(D.$$.fragment),Ce=i(),q=a("p"),q.textContent=Ke,ve=i(),c(K.$$.fragment),We=i(),ee=a("p"),this.h()},l(e){const l=dl("svelte-u9bgzb",document.head);p=o(l,"META",{name:!0,content:!0}),l.forEach(t),M=n(e),r=o(e,"P",{}),ll(r).forEach(t),J=n(e),m(U.$$.fragment,e),te=n(e),m(h.$$.fragment,e),se=n(e),I=o(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-g4a90d"&&(I.innerHTML=ke),ie=n(e),Z=o(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-uyw7g0"&&(Z.innerHTML=He),ne=n(e),m(_.$$.fragment,e),pe=n(e),j=o(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-8od3ru"&&(j.innerHTML=Re),ae=n(e),m(G.$$.fragment,e),oe=n(e),V=o(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1nclh5x"&&(V.innerHTML=Ne),de=n(e),m(B.$$.fragment,e),re=n(e),$=o(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-jmgs1z"&&($.innerHTML=xe),ce=n(e),m(g.$$.fragment,e),me=n(e),C=o(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1l1aime"&&(C.innerHTML=Ee),ue=n(e),m(v.$$.fragment,e),fe=n(e),W=o(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1wqngql"&&(W.innerHTML=Qe),we=n(e),m(X.$$.fragment,e),ye=n(e),k=o(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-13itfz9"&&(k.innerHTML=Se),Me=n(e),m(H.$$.fragment,e),Te=n(e),m(R.$$.fragment,e),Je=n(e),N=o(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1okqb75"&&(N.innerHTML=ze),he=n(e),x=o(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-mmjniw"&&(x.innerHTML=Pe),be=n(e),m(E.$$.fragment,e),Ue=n(e),Q=o(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-hpyorm"&&(Q.innerHTML=Le),Ie=n(e),m(S.$$.fragment,e),Ze=n(e),z=o(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1wdgje4"&&(z.textContent=Ae),_e=n(e),P=o(e,"TABLE",{"data-svelte-h":!0}),d(P)!=="svelte-1tu2a4k"&&(P.innerHTML=Fe),je=n(e),m(b.$$.fragment,e),Ge=n(e),m(L.$$.fragment,e),Ve=n(e),A=o(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-13nym99"&&(A.innerHTML=Ye),Be=n(e),F=o(e,"UL",{"data-svelte-h":!0}),d(F)!=="svelte-185ii9u"&&(F.innerHTML=De),$e=n(e),Y=o(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-84chr9"&&(Y.textContent=qe),ge=n(e),m(D.$$.fragment,e),Ce=n(e),q=o(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-pfjr1e"&&(q.textContent=Ke),ve=n(e),m(K.$$.fragment,e),We=n(e),ee=o(e,"P",{}),ll(ee).forEach(t),this.h()},h(){tl(p,"name","hf:doc:metadata"),tl(p,"content",fl)},m(e,l){rl(document.head,p),s(e,M,l),s(e,r,l),s(e,J,l),u(U,e,l),s(e,te,l),u(h,e,l),s(e,se,l),s(e,I,l),s(e,ie,l),s(e,Z,l),s(e,ne,l),u(_,e,l),s(e,pe,l),s(e,j,l),s(e,ae,l),u(G,e,l),s(e,oe,l),s(e,V,l),s(e,de,l),u(B,e,l),s(e,re,l),s(e,$,l),s(e,ce,l),u(g,e,l),s(e,me,l),s(e,C,l),s(e,ue,l),u(v,e,l),s(e,fe,l),s(e,W,l),s(e,we,l),u(X,e,l),s(e,ye,l),s(e,k,l),s(e,Me,l),u(H,e,l),s(e,Te,l),u(R,e,l),s(e,Je,l),s(e,N,l),s(e,he,l),s(e,x,l),s(e,be,l),u(E,e,l),s(e,Ue,l),s(e,Q,l),s(e,Ie,l),u(S,e,l),s(e,Ze,l),s(e,z,l),s(e,_e,l),s(e,P,l),s(e,je,l),u(b,e,l),s(e,Ge,l),u(L,e,l),s(e,Ve,l),s(e,A,l),s(e,Be,l),s(e,F,l),s(e,$e,l),s(e,Y,l),s(e,ge,l),u(D,e,l),s(e,Ce,l),s(e,q,l),s(e,ve,l),u(K,e,l),s(e,We,l),s(e,ee,l),Xe=!0},p(e,[l]){const Oe={};l&2&&(Oe.$$scope={dirty:l,ctx:e}),h.$set(Oe);const el={};l&2&&(el.$$scope={dirty:l,ctx:e}),b.$set(el)},i(e){Xe||(f(U.$$.fragment,e),f(h.$$.fragment,e),f(_.$$.fragment,e),f(G.$$.fragment,e),f(B.$$.fragment,e),f(g.$$.fragment,e),f(v.$$.fragment,e),f(X.$$.fragment,e),f(H.$$.fragment,e),f(R.$$.fragment,e),f(E.$$.fragment,e),f(S.$$.fragment,e),f(b.$$.fragment,e),f(L.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),Xe=!0)},o(e){w(U.$$.fragment,e),w(h.$$.fragment,e),w(_.$$.fragment,e),w(G.$$.fragment,e),w(B.$$.fragment,e),w(g.$$.fragment,e),w(v.$$.fragment,e),w(X.$$.fragment,e),w(H.$$.fragment,e),w(R.$$.fragment,e),w(E.$$.fragment,e),w(S.$$.fragment,e),w(b.$$.fragment,e),w(L.$$.fragment,e),w(D.$$.fragment,e),w(K.$$.fragment,e),Xe=!1},d(e){e&&(t(M),t(r),t(J),t(te),t(se),t(I),t(ie),t(Z),t(ne),t(pe),t(j),t(ae),t(oe),t(V),t(de),t(re),t($),t(ce),t(me),t(C),t(ue),t(fe),t(W),t(we),t(ye),t(k),t(Me),t(Te),t(Je),t(N),t(he),t(x),t(be),t(Ue),t(Q),t(Ie),t(Ze),t(z),t(_e),t(P),t(je),t(Ge),t(Ve),t(A),t(Be),t(F),t($e),t(Y),t(ge),t(Ce),t(q),t(ve),t(We),t(ee)),t(p),y(U,e),y(h,e),y(_,e),y(G,e),y(B,e),y(g,e),y(v,e),y(X,e),y(H,e),y(R,e),y(E,e),y(S,e),y(b,e),y(L,e),y(D,e),y(K,e)}}}const fl='{"title":"Contribute a community pipeline","local":"contribute-a-community-pipeline","sections":[{"title":"Initialize the pipeline","local":"initialize-the-pipeline","sections":[],"depth":2},{"title":"Define the forward pass","local":"define-the-forward-pass","sections":[],"depth":2},{"title":"Share your pipeline","local":"share-your-pipeline","sections":[],"depth":2},{"title":"How do community pipelines work?","local":"how-do-community-pipelines-work","sections":[],"depth":2}],"depth":1}';function wl(O){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends al{constructor(p){super(),ol(this,p,wl,ul,nl,{})}}export{bl as component};
