import{s as bl,n as gl,o as Al}from"../chunks/scheduler.9039eef2.js";import{S as xl,i as vl,g as o,s as n,r as p,A as Bl,h as M,f as l,c as a,j as Cl,u as r,x as i,k as fl,y as Gl,a as s,v as m,d as y,t as w,w as h}from"../chunks/index.cdcc3d35.js";import{C as u}from"../chunks/CodeBlock.e3ac94d9.js";import{H as fe}from"../chunks/Heading.96ce3702.js";function Zl(kt){let J,be,Ie,ge,T,Ae,c,Wt='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/text-generation/llama2-13b-chatbot.ipynb" rel="nofollow">here</a></em>.',xe,j,$t="This guide will detail how to export, deploy and run a <strong>LLama-2 13B</strong> chat model on AWS inferentia.",ve,U,Ht="You will learn how to:",Be,d,_t="<li>export the Llama-2 model to the Neuron format,</li> <li>push the exported model to the Hugging Face Hub,</li> <li>deploy the model and use it in a chat application.</li>",Ge,I,Xt="Note: This tutorial was created on a inf2.48xlarge AWS EC2 Instance.",Ze,C,ke,f,Vt='For this guide, we will use the non-gated <a href="https://huggingface.co/NousResearch/Llama-2-13b-chat-hf" rel="nofollow">NousResearch/Llama-2-13b-chat-hf</a> model, which is functionally equivalent to the original <a href="https://huggingface.co/meta-llama/Llama-2-13b-chat-hf" rel="nofollow">meta-llama/Llama-2-13b-chat-hf</a>.',We,b,zt=`This model is part of the <strong>Llama 2</strong> family of models, and has been tuned to recognize chat interactions
between a <em>user</em> and an <em>assistant</em> (more on that later).`,$e,g,Nt=`As explained in the <a href="https://huggingface.co/docs/optimum-neuron/guides/export_model#why-compile-to-neuron-model" rel="nofollow">optimum-neuron documentation</a>
, models need to be compiled and exported to a serialized format before running them on Neuron devices.`,He,A,St=`Fortunately, 🤗 <strong>optimum-neuron</strong> offers a <a href="https://huggingface.co/docs/optimum-neuron/guides/models#configuring-the-export-of-a-generative-model" rel="nofollow">very simple API</a>
to export standard 🤗 <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">transformers models</a> to the Neuron format.`,_e,x,Qt="When exporting the model, we will specify two sets of parameters:",Xe,v,Et=`<li>using <em>compiler_args</em>, we specify on how many cores we want the model to be deployed (each neuron device has two cores), and with which precision (here <em>float16</em>),</li> <li>using <em>input_shapes</em>, we set the static input and output dimensions of the model. All model compilers require static shapes, and neuron makes no exception. Note that the
<em>sequence_length</em> not only constrains the length of the input context, but also the length of the Key/Value cache, and thus, the output length.</li>`,Ve,B,Yt="Depending on your choice of parameters and inferentia host, this may take from a few minutes to more than an hour.",ze,G,Rt="For your convenience, we host a pre-compiled version of that model on the Hugging Face hub, so you can skip the export and start using the model immediately in paragraph 2.",Ne,Z,Se,k,Lt="This will probably take a while.",Qe,W,Ft="Fortunately, you will need to do this only once because you can save your model and reload it later.",Ee,$,Ye,H,qt='Even better, you can push it to the <a href="https://huggingface.co/models" rel="nofollow">Hugging Face hub</a>.',Re,_,Pt='For that, you need to be logged in to a <a href="https://huggingface.co/join" rel="nofollow">HuggingFace account</a>.',Le,X,Kt="In the terminal, just type the following command and paste your Hugging Face token when requested:",Fe,V,qe,z,Dt="By default, the model will be uploaded to your account (organization equal to your user name).",Pe,N,Ot='Feel free to edit the code below if you want to upload the model to a specific <a href="https://huggingface.co/docs/hub/organizations" rel="nofollow">Hugging Face organization</a>.',Ke,S,De,Q,Oe,E,el="The minimum memory required to load a model can be computed with:",et,Y,tt,R,tl="The <strong>Llama 2 13B</strong> model uses <em>float16</em> weights (stored on 2 bytes) and has 13 billion parameters, which means it requires at least 2 * 13B or ~26GB of memory to store its weights.",lt,L,ll="Each NeuronCore has 16GB of memory which means that a 26GB model cannot fit on a single NeuronCore.",st,F,sl=`In reality, the total space required is much greater than just the number of parameters due to caching attention layer projections (KV caching).
This caching mechanism grows memory allocations linearly with sequence length and batch size.`,nt,q,nl="Here we set the <em>batch_size</em> to 1, meaning that we can only process one input prompt in parallel. We set the <em>sequence_length</em> to 2048, which corresponds to half the model maximum capacity (4096).",at,P,al="The formula to evaluate the size of the KV cache is more involved as it also depends on parameters related to the model architecture, such as the width of the embeddings and the number of decoder blocks.",ot,K,ol="Bottom-line is, to get very large language models to fit, tensor parallelism is used to split weights, data, and compute across multiple NeuronCores, keeping in mind that the memory on each core cannot exceed 16GB.",Mt,D,Ml=`Note that increasing the number of cores beyond the minimum requirement almost always results in a faster model.
Increasing the tensor parallelism degree improves memory bandwidth which improves model performance.`,it,O,il="To optimize performance it’s recommended to use all cores available on the instance.",pt,ee,pl=`In this guide we use all the 24 cores of the <em>inf2.48xlarge</em>, but this should be changed to 12 if you are
using a <em>inf2.24xlarge</em> instance.`,rt,te,mt,le,rl='Once your model has been exported, you can generate text using the transformers library, as it has been described in <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">detail in this post</a>.',yt,se,ml="If as suggested you skipped the first paragraph, don’t worry: we will use a precompiled model already present on the hub instead.",wt,ne,ht,ae,yl="We will need a <em>Llama 2</em> tokenizer to convert the prompt strings to text tokens.",ut,oe,Jt,Me,wl="The following generation strategies are supported:",Tt,ie,hl="<li>greedy search,</li> <li>multinomial sampling with top-k and top-p (with temperature).</li>",ct,pe,ul="Most logits pre-processing/filters (such as repetition penalty) are supported.",jt,re,Ut,me,dt,ye,Jl="We specifically selected a <strong>Llama 2</strong> chat variant to illustrate the excellent behaviour of the exported model when the length of the encoding context grows.",It,we,Tl="The model expects the prompts to be formatted following a specific template corresponding to the interactions between a <em>user</em> role and an <em>assistant</em> role.",Ct,he,cl='Each chat model has its own convention for encoding such contents, and we will not go into too much details in this guide, because we will directly use the <a href="https://huggingface.co/blog/chat-templates" rel="nofollow">Hugging Face chat templates</a> corresponding to our model.',ft,ue,jl="The utility function below converts a list of exchanges between the user and the model into a well-formatted chat prompt.",bt,Je,gt,Te,Ul="We are now equipped to build a simplistic chat application.",At,ce,dl=`We simply store the interactions between the user and the assistant in a list that we use to generate
the input prompt.`,xt,je,vt,Ue,Il="To test the chat application you can use for instance the following sequence of prompts:",Bt,de,Gt,Ce,Zt;return T=new fe({props:{title:"Create your own chatbot with llama-2-13B on AWS Inferentia",local:"create-your-own-chatbot-with-llama-2-13b-on-aws-inferentia",headingTag:"h1"}}),C=new fe({props:{title:"1. Export the Llama 2 model to Neuron",local:"1-export-the-llama-2-model-to-neuron",headingTag:"h2"}}),Z=new u({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJudW1fY29yZXMlMjIlM0ElMjAyNCUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJ2ZwMTYnJTdEJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJzZXF1ZW5jZV9sZW5ndGglMjIlM0ElMjAyMDQ4JTdEJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOb3VzUmVzZWFyY2glMkZMbGFtYS0yLTEzYi1jaGF0LWhmJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqY29tcGlsZXJfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqaW5wdXRfc2hhcGVzKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM

compiler_args = {<span class="hljs-string">&quot;num_cores&quot;</span>: <span class="hljs-number">24</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&#x27;fp16&#x27;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">2048</span>}
model = NeuronModelForCausalLM.from_pretrained(
        <span class="hljs-string">&quot;NousResearch/Llama-2-13b-chat-hf&quot;</span>,
        export=<span class="hljs-literal">True</span>,
        **compiler_args,
        **input_shapes)`,wrap:!1}}),$=new u({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMmxsYW1hLTItMTNiLWNoYXQtbmV1cm9uJTIyKQ==",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;llama-2-13b-chat-neuron&quot;</span>)',wrap:!1}}),V=new u({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),S=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdob2FtaSUwQSUwQW9yZyUyMCUzRCUyMHdob2FtaSgpJTVCJ25hbWUnJTVEJTBBJTBBcmVwb19pZCUyMCUzRCUyMGYlMjIlN0JvcmclN0QlMkZsbGFtYS0yLTEzYi1jaGF0LW5ldXJvbiUyMiUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMmxsYW1hLTItMTNiLWNoYXQtbmV1cm9uJTIyJTJDJTIwcmVwb3NpdG9yeV9pZCUzRHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> whoami

org = whoami()[<span class="hljs-string">&#x27;name&#x27;</span>]

repo_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{org}</span>/llama-2-13b-chat-neuron&quot;</span>

model.push_to_hub(<span class="hljs-string">&quot;llama-2-13b-chat-neuron&quot;</span>, repository_id=repo_id)`,wrap:!1}}),Q=new fe({props:{title:"A few more words about export parameters.",local:"a-few-more-words-about-export-parameters",headingTag:"h3"}}),Y=new u({props:{code:"JTIwJTIwJTIwbWVtb3J5JTIwJTNEJTIwYnl0ZXMlMjBwZXIlMjBwYXJhbWV0ZXIlMjAqJTIwbnVtYmVyJTIwb2YlMjBwYXJhbWV0ZXJz",highlighted:'   memory = bytes per <span class="hljs-keyword">parameter</span> * <span class="hljs-keyword">number</span> of parameters',wrap:!1}}),te=new fe({props:{title:"2. Generate text using Llama 2 on AWS Inferentia2",local:"2-generate-text-using-llama-2-on-aws-inferentia2",headingTag:"h2"}}),ne=new u({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsJTBBZXhjZXB0JTIwTmFtZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRWRpdCUyMHRoaXMlMjB0byUyMHVzZSUyMGFub3RoZXIlMjBiYXNlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCdhd3MtbmV1cm9uJTJGTGxhbWEtMi0xM2ItY2hhdC1oZi1uZXVyb24tbGF0ZW5jeScp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM

<span class="hljs-keyword">try</span>:
    model
<span class="hljs-keyword">except</span> NameError:
    <span class="hljs-comment"># Edit this to use another base model</span>
    model = NeuronModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;aws-neuron/Llama-2-13b-chat-hf-neuron-latency&#x27;</span>)`,wrap:!1}}),oe=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJOb3VzUmVzZWFyY2glMkZMbGFtYS0yLTEzYi1jaGF0LWhmJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;NousResearch/Llama-2-13b-chat-hf&quot;</span>)`,wrap:!1}}),re=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMldoYXQlMjBpcyUyMGRlZXAtbGVhcm5pbmclMjAlM0YlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTI4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC45JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9wX2slM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9wJTNEMC45KSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`inputs = tokenizer(<span class="hljs-string">&quot;What is deep-learning ?&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model.generate(**inputs,
                         max_new_tokens=<span class="hljs-number">128</span>,
                         do_sample=<span class="hljs-literal">True</span>,
                         temperature=<span class="hljs-number">0.9</span>,
                         top_k=<span class="hljs-number">50</span>,
                         top_p=<span class="hljs-number">0.9</span>)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),me=new fe({props:{title:"3. Create a chat application using llama on AWS Inferentia2",local:"3-create-a-chat-application-using-llama-on-aws-inferentia2",headingTag:"h2"}}),Je=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_chat_prompt</span>(<span class="hljs-params">message, history, max_tokens</span>):
    <span class="hljs-string">&quot;&quot;&quot; Convert a history of messages to a chat prompt


    Args:
        message(str): the new user message.
        history (List[str]): the list of user messages and assistant responses.
        max_tokens (int): the maximum number of input tokens accepted by the model.

    Returns:
        a \`str\` prompt.
    &quot;&quot;&quot;</span>
    chat = []
    <span class="hljs-comment"># Convert all messages in history to chat interactions</span>
    <span class="hljs-keyword">for</span> interaction <span class="hljs-keyword">in</span> history:
        chat.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span> : interaction[<span class="hljs-number">0</span>]})
        chat.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span> : interaction[<span class="hljs-number">1</span>]})
    <span class="hljs-comment"># Add the new message</span>
    chat.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span> : message})
    <span class="hljs-comment"># Generate the prompt, verifying that we don&#x27;t go beyond the maximum number of tokens</span>
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(chat), <span class="hljs-number">2</span>):
        <span class="hljs-comment"># Generate candidate prompt with the last n-i entries</span>
        prompt = tokenizer.apply_chat_template(chat[i:], tokenize=<span class="hljs-literal">False</span>)
        <span class="hljs-comment"># Tokenize to check if we&#x27;re over the limit</span>
        tokens = tokenizer(prompt)
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(tokens.input_ids) &lt;= max_tokens:
            <span class="hljs-comment"># We&#x27;re good, stop here</span>
            <span class="hljs-keyword">return</span> prompt
    <span class="hljs-comment"># We shall never reach this line</span>
    <span class="hljs-keyword">raise</span> SystemError`,wrap:!1}}),je=new u({props:{code:"aGlzdG9yeSUyMCUzRCUyMCU1QiU1RCUwQW1heF90b2tlbnMlMjAlM0QlMjAxMDI0JTBBJTBBZGVmJTIwY2hhdChtZXNzYWdlJTJDJTIwaGlzdG9yeSUyQyUyMG1heF90b2tlbnMpJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwZm9ybWF0X2NoYXRfcHJvbXB0KG1lc3NhZ2UlMkMlMjBoaXN0b3J5JTJDJTIwbWF4X3Rva2VucyklMEElMjAlMjAlMjAlMjAlMjMlMjBVbmNvbW1lbnQlMjB0aGUlMjBsaW5lJTIwYmVsb3clMjB0byUyMHNlZSUyMHdoYXQlMjB0aGUlMjBmb3JtYXR0ZWQlMjBwcm9tcHQlMjBsb29rcyUyMGxpa2UlMEElMjAlMjAlMjAlMjAlMjNwcmludChwcm9tcHQpJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRDIwNDglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3BfayUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNEMS4yKSUwQSUyMCUyMCUyMCUyMCUyMyUyMERvJTIwbm90JTIwaW5jbHVkZSUyMHRoZSUyMGlucHV0JTIwdG9rZW5zJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG91dHB1dHMlNUIwJTJDJTIwaW5wdXRzLmlucHV0X2lkcy5zaXplKC0xKSUzQSU1RCUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwaGlzdG9yeS5hcHBlbmQoJTVCbWVzc2FnZSUyQyUyMHJlc3BvbnNlJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNl",highlighted:`history = []
max_tokens = <span class="hljs-number">1024</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat</span>(<span class="hljs-params">message, history, max_tokens</span>):
    prompt = format_chat_prompt(message, history, max_tokens)
    <span class="hljs-comment"># Uncomment the line below to see what the formatted prompt looks like</span>
    <span class="hljs-comment">#print(prompt)</span>
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(**inputs,
                             max_length=<span class="hljs-number">2048</span>,
                             do_sample=<span class="hljs-literal">True</span>,
                             temperature=<span class="hljs-number">0.9</span>,
                             top_k=<span class="hljs-number">50</span>,
                             repetition_penalty=<span class="hljs-number">1.2</span>)
    <span class="hljs-comment"># Do not include the input tokens</span>
    outputs = outputs[<span class="hljs-number">0</span>, inputs.input_ids.size(-<span class="hljs-number">1</span>):]
    response = tokenizer.decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
    history.append([message, response])
    <span class="hljs-keyword">return</span> response`,wrap:!1}}),de=new u({props:{code:"cHJpbnQoY2hhdCglMjJNeSUyMGZhdm9yaXRlJTIwY29sb3IlMjBpcyUyMGJsdWUuJTIwTXklMjBmYXZvcml0ZSUyMGZydWl0JTIwaXMlMjBzdHJhd2JlcnJ5LiUyMiUyQyUyMGhpc3RvcnklMkMlMjBtYXhfdG9rZW5zKSklMEFwcmludChjaGF0KCUyMk5hbWUlMjBhJTIwZnJ1aXQlMjB0aGF0JTIwaXMlMjBvbiUyMG15JTIwZmF2b3JpdGUlMjBjb2xvdXIuJTIyJTJDJTIwaGlzdG9yeSUyQyUyMG1heF90b2tlbnMpKSUwQXByaW50KGNoYXQoJTIyV2hhdCUyMGlzJTIwdGhlJTIwY29sb3VyJTIwb2YlMjBteSUyMGZhdm9yaXRlJTIwZnJ1aXQlMjAlM0YlMjIlMkMlMjBoaXN0b3J5JTJDJTIwbWF4X3Rva2Vucykp",highlighted:`<span class="hljs-built_in">print</span>(chat(<span class="hljs-string">&quot;My favorite color is blue. My favorite fruit is strawberry.&quot;</span>, history, max_tokens))
<span class="hljs-built_in">print</span>(chat(<span class="hljs-string">&quot;Name a fruit that is on my favorite colour.&quot;</span>, history, max_tokens))
<span class="hljs-built_in">print</span>(chat(<span class="hljs-string">&quot;What is the colour of my favorite fruit ?&quot;</span>, history, max_tokens))`,wrap:!1}}),{c(){J=o("meta"),be=n(),Ie=o("p"),ge=n(),p(T.$$.fragment),Ae=n(),c=o("p"),c.innerHTML=Wt,xe=n(),j=o("p"),j.innerHTML=$t,ve=n(),U=o("p"),U.textContent=Ht,Be=n(),d=o("ul"),d.innerHTML=_t,Ge=n(),I=o("p"),I.textContent=Xt,Ze=n(),p(C.$$.fragment),ke=n(),f=o("p"),f.innerHTML=Vt,We=n(),b=o("p"),b.innerHTML=zt,$e=n(),g=o("p"),g.innerHTML=Nt,He=n(),A=o("p"),A.innerHTML=St,_e=n(),x=o("p"),x.textContent=Qt,Xe=n(),v=o("ul"),v.innerHTML=Et,Ve=n(),B=o("p"),B.textContent=Yt,ze=n(),G=o("p"),G.textContent=Rt,Ne=n(),p(Z.$$.fragment),Se=n(),k=o("p"),k.textContent=Lt,Qe=n(),W=o("p"),W.textContent=Ft,Ee=n(),p($.$$.fragment),Ye=n(),H=o("p"),H.innerHTML=qt,Re=n(),_=o("p"),_.innerHTML=Pt,Le=n(),X=o("p"),X.textContent=Kt,Fe=n(),p(V.$$.fragment),qe=n(),z=o("p"),z.textContent=Dt,Pe=n(),N=o("p"),N.innerHTML=Ot,Ke=n(),p(S.$$.fragment),De=n(),p(Q.$$.fragment),Oe=n(),E=o("p"),E.textContent=el,et=n(),p(Y.$$.fragment),tt=n(),R=o("p"),R.innerHTML=tl,lt=n(),L=o("p"),L.textContent=ll,st=n(),F=o("p"),F.textContent=sl,nt=n(),q=o("p"),q.innerHTML=nl,at=n(),P=o("p"),P.textContent=al,ot=n(),K=o("p"),K.textContent=ol,Mt=n(),D=o("p"),D.textContent=Ml,it=n(),O=o("p"),O.textContent=il,pt=n(),ee=o("p"),ee.innerHTML=pl,rt=n(),p(te.$$.fragment),mt=n(),le=o("p"),le.innerHTML=rl,yt=n(),se=o("p"),se.textContent=ml,wt=n(),p(ne.$$.fragment),ht=n(),ae=o("p"),ae.innerHTML=yl,ut=n(),p(oe.$$.fragment),Jt=n(),Me=o("p"),Me.textContent=wl,Tt=n(),ie=o("ul"),ie.innerHTML=hl,ct=n(),pe=o("p"),pe.textContent=ul,jt=n(),p(re.$$.fragment),Ut=n(),p(me.$$.fragment),dt=n(),ye=o("p"),ye.innerHTML=Jl,It=n(),we=o("p"),we.innerHTML=Tl,Ct=n(),he=o("p"),he.innerHTML=cl,ft=n(),ue=o("p"),ue.textContent=jl,bt=n(),p(Je.$$.fragment),gt=n(),Te=o("p"),Te.textContent=Ul,At=n(),ce=o("p"),ce.textContent=dl,xt=n(),p(je.$$.fragment),vt=n(),Ue=o("p"),Ue.textContent=Il,Bt=n(),p(de.$$.fragment),Gt=n(),Ce=o("p"),this.h()},l(e){const t=Bl("svelte-u9bgzb",document.head);J=M(t,"META",{name:!0,content:!0}),t.forEach(l),be=a(e),Ie=M(e,"P",{}),Cl(Ie).forEach(l),ge=a(e),r(T.$$.fragment,e),Ae=a(e),c=M(e,"P",{"data-svelte-h":!0}),i(c)!=="svelte-14mc9a1"&&(c.innerHTML=Wt),xe=a(e),j=M(e,"P",{"data-svelte-h":!0}),i(j)!=="svelte-1skq0wn"&&(j.innerHTML=$t),ve=a(e),U=M(e,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1hahfn0"&&(U.textContent=Ht),Be=a(e),d=M(e,"UL",{"data-svelte-h":!0}),i(d)!=="svelte-1ivcbtp"&&(d.innerHTML=_t),Ge=a(e),I=M(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1jogm5f"&&(I.textContent=Xt),Ze=a(e),r(C.$$.fragment,e),ke=a(e),f=M(e,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1hepwaf"&&(f.innerHTML=Vt),We=a(e),b=M(e,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1s9dc42"&&(b.innerHTML=zt),$e=a(e),g=M(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-mznum8"&&(g.innerHTML=Nt),He=a(e),A=M(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1infapy"&&(A.innerHTML=St),_e=a(e),x=M(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-vz83yd"&&(x.textContent=Qt),Xe=a(e),v=M(e,"UL",{"data-svelte-h":!0}),i(v)!=="svelte-1z4h5r"&&(v.innerHTML=Et),Ve=a(e),B=M(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-i8skpg"&&(B.textContent=Yt),ze=a(e),G=M(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-n2ig5w"&&(G.textContent=Rt),Ne=a(e),r(Z.$$.fragment,e),Se=a(e),k=M(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1j7pdia"&&(k.textContent=Lt),Qe=a(e),W=M(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-wxy07q"&&(W.textContent=Ft),Ee=a(e),r($.$$.fragment,e),Ye=a(e),H=M(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-16smhm8"&&(H.innerHTML=qt),Re=a(e),_=M(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1jkprhy"&&(_.innerHTML=Pt),Le=a(e),X=M(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1lo2b6p"&&(X.textContent=Kt),Fe=a(e),r(V.$$.fragment,e),qe=a(e),z=M(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-8c3of4"&&(z.textContent=Dt),Pe=a(e),N=M(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1kcpd2e"&&(N.innerHTML=Ot),Ke=a(e),r(S.$$.fragment,e),De=a(e),r(Q.$$.fragment,e),Oe=a(e),E=M(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-mi975y"&&(E.textContent=el),et=a(e),r(Y.$$.fragment,e),tt=a(e),R=M(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-zmj8oy"&&(R.innerHTML=tl),lt=a(e),L=M(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1hs4joy"&&(L.textContent=ll),st=a(e),F=M(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-13xxwf3"&&(F.textContent=sl),nt=a(e),q=M(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-13q3i6n"&&(q.innerHTML=nl),at=a(e),P=M(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-mdqsxr"&&(P.textContent=al),ot=a(e),K=M(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-12eo3v5"&&(K.textContent=ol),Mt=a(e),D=M(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-qqihmw"&&(D.textContent=Ml),it=a(e),O=M(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-13dz4vh"&&(O.textContent=il),pt=a(e),ee=M(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-exk3d9"&&(ee.innerHTML=pl),rt=a(e),r(te.$$.fragment,e),mt=a(e),le=M(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-a6bs6o"&&(le.innerHTML=rl),yt=a(e),se=M(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-1syw0h0"&&(se.textContent=ml),wt=a(e),r(ne.$$.fragment,e),ht=a(e),ae=M(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-1ps6mip"&&(ae.innerHTML=yl),ut=a(e),r(oe.$$.fragment,e),Jt=a(e),Me=M(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1y7mxpx"&&(Me.textContent=wl),Tt=a(e),ie=M(e,"UL",{"data-svelte-h":!0}),i(ie)!=="svelte-a4n5id"&&(ie.innerHTML=hl),ct=a(e),pe=M(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-k217aq"&&(pe.textContent=ul),jt=a(e),r(re.$$.fragment,e),Ut=a(e),r(me.$$.fragment,e),dt=a(e),ye=M(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-1ezk4g0"&&(ye.innerHTML=Jl),It=a(e),we=M(e,"P",{"data-svelte-h":!0}),i(we)!=="svelte-1e1yopm"&&(we.innerHTML=Tl),Ct=a(e),he=M(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-1xcz5ok"&&(he.innerHTML=cl),ft=a(e),ue=M(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-1v5xgsn"&&(ue.textContent=jl),bt=a(e),r(Je.$$.fragment,e),gt=a(e),Te=M(e,"P",{"data-svelte-h":!0}),i(Te)!=="svelte-1hfx6dq"&&(Te.textContent=Ul),At=a(e),ce=M(e,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-ffg1bu"&&(ce.textContent=dl),xt=a(e),r(je.$$.fragment,e),vt=a(e),Ue=M(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-hnyltz"&&(Ue.textContent=Il),Bt=a(e),r(de.$$.fragment,e),Gt=a(e),Ce=M(e,"P",{}),Cl(Ce).forEach(l),this.h()},h(){fl(J,"name","hf:doc:metadata"),fl(J,"content",kl)},m(e,t){Gl(document.head,J),s(e,be,t),s(e,Ie,t),s(e,ge,t),m(T,e,t),s(e,Ae,t),s(e,c,t),s(e,xe,t),s(e,j,t),s(e,ve,t),s(e,U,t),s(e,Be,t),s(e,d,t),s(e,Ge,t),s(e,I,t),s(e,Ze,t),m(C,e,t),s(e,ke,t),s(e,f,t),s(e,We,t),s(e,b,t),s(e,$e,t),s(e,g,t),s(e,He,t),s(e,A,t),s(e,_e,t),s(e,x,t),s(e,Xe,t),s(e,v,t),s(e,Ve,t),s(e,B,t),s(e,ze,t),s(e,G,t),s(e,Ne,t),m(Z,e,t),s(e,Se,t),s(e,k,t),s(e,Qe,t),s(e,W,t),s(e,Ee,t),m($,e,t),s(e,Ye,t),s(e,H,t),s(e,Re,t),s(e,_,t),s(e,Le,t),s(e,X,t),s(e,Fe,t),m(V,e,t),s(e,qe,t),s(e,z,t),s(e,Pe,t),s(e,N,t),s(e,Ke,t),m(S,e,t),s(e,De,t),m(Q,e,t),s(e,Oe,t),s(e,E,t),s(e,et,t),m(Y,e,t),s(e,tt,t),s(e,R,t),s(e,lt,t),s(e,L,t),s(e,st,t),s(e,F,t),s(e,nt,t),s(e,q,t),s(e,at,t),s(e,P,t),s(e,ot,t),s(e,K,t),s(e,Mt,t),s(e,D,t),s(e,it,t),s(e,O,t),s(e,pt,t),s(e,ee,t),s(e,rt,t),m(te,e,t),s(e,mt,t),s(e,le,t),s(e,yt,t),s(e,se,t),s(e,wt,t),m(ne,e,t),s(e,ht,t),s(e,ae,t),s(e,ut,t),m(oe,e,t),s(e,Jt,t),s(e,Me,t),s(e,Tt,t),s(e,ie,t),s(e,ct,t),s(e,pe,t),s(e,jt,t),m(re,e,t),s(e,Ut,t),m(me,e,t),s(e,dt,t),s(e,ye,t),s(e,It,t),s(e,we,t),s(e,Ct,t),s(e,he,t),s(e,ft,t),s(e,ue,t),s(e,bt,t),m(Je,e,t),s(e,gt,t),s(e,Te,t),s(e,At,t),s(e,ce,t),s(e,xt,t),m(je,e,t),s(e,vt,t),s(e,Ue,t),s(e,Bt,t),m(de,e,t),s(e,Gt,t),s(e,Ce,t),Zt=!0},p:gl,i(e){Zt||(y(T.$$.fragment,e),y(C.$$.fragment,e),y(Z.$$.fragment,e),y($.$$.fragment,e),y(V.$$.fragment,e),y(S.$$.fragment,e),y(Q.$$.fragment,e),y(Y.$$.fragment,e),y(te.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(me.$$.fragment,e),y(Je.$$.fragment,e),y(je.$$.fragment,e),y(de.$$.fragment,e),Zt=!0)},o(e){w(T.$$.fragment,e),w(C.$$.fragment,e),w(Z.$$.fragment,e),w($.$$.fragment,e),w(V.$$.fragment,e),w(S.$$.fragment,e),w(Q.$$.fragment,e),w(Y.$$.fragment,e),w(te.$$.fragment,e),w(ne.$$.fragment,e),w(oe.$$.fragment,e),w(re.$$.fragment,e),w(me.$$.fragment,e),w(Je.$$.fragment,e),w(je.$$.fragment,e),w(de.$$.fragment,e),Zt=!1},d(e){e&&(l(be),l(Ie),l(ge),l(Ae),l(c),l(xe),l(j),l(ve),l(U),l(Be),l(d),l(Ge),l(I),l(Ze),l(ke),l(f),l(We),l(b),l($e),l(g),l(He),l(A),l(_e),l(x),l(Xe),l(v),l(Ve),l(B),l(ze),l(G),l(Ne),l(Se),l(k),l(Qe),l(W),l(Ee),l(Ye),l(H),l(Re),l(_),l(Le),l(X),l(Fe),l(qe),l(z),l(Pe),l(N),l(Ke),l(De),l(Oe),l(E),l(et),l(tt),l(R),l(lt),l(L),l(st),l(F),l(nt),l(q),l(at),l(P),l(ot),l(K),l(Mt),l(D),l(it),l(O),l(pt),l(ee),l(rt),l(mt),l(le),l(yt),l(se),l(wt),l(ht),l(ae),l(ut),l(Jt),l(Me),l(Tt),l(ie),l(ct),l(pe),l(jt),l(Ut),l(dt),l(ye),l(It),l(we),l(Ct),l(he),l(ft),l(ue),l(bt),l(gt),l(Te),l(At),l(ce),l(xt),l(vt),l(Ue),l(Bt),l(Gt),l(Ce)),l(J),h(T,e),h(C,e),h(Z,e),h($,e),h(V,e),h(S,e),h(Q,e),h(Y,e),h(te,e),h(ne,e),h(oe,e),h(re,e),h(me,e),h(Je,e),h(je,e),h(de,e)}}}const kl='{"title":"Create your own chatbot with llama-2-13B on AWS Inferentia","local":"create-your-own-chatbot-with-llama-2-13b-on-aws-inferentia","sections":[{"title":"1. Export the Llama 2 model to Neuron","local":"1-export-the-llama-2-model-to-neuron","sections":[{"title":"A few more words about export parameters.","local":"a-few-more-words-about-export-parameters","sections":[],"depth":3}],"depth":2},{"title":"2. Generate text using Llama 2 on AWS Inferentia2","local":"2-generate-text-using-llama-2-on-aws-inferentia2","sections":[],"depth":2},{"title":"3. Create a chat application using llama on AWS Inferentia2","local":"3-create-a-chat-application-using-llama-on-aws-inferentia2","sections":[],"depth":2}],"depth":1}';function Wl(kt){return Al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vl extends xl{constructor(J){super(),vl(this,J,Wl,Zl,bl,{})}}export{Vl as component};
