import{s as Mt,o as bt,n as nt}from"../chunks/scheduler.8c3d61f6.js";import{S as Tt,i as wt,g as d,s as a,r as g,A as Jt,h as p,f as n,c as o,j as V,u,x as M,k,y as r,a as s,v as f,d as h,t as _,w as y}from"../chunks/index.da70eac4.js";import{T as vt}from"../chunks/Tip.1d9b8c37.js";import{D as ie}from"../chunks/Docstring.6b390b9a.js";import{C as Re}from"../chunks/CodeBlock.00a903b3.js";import{E as yt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as _e,E as Wt}from"../chunks/EditOnGithub.1e64e623.js";function jt(G){let l,v='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){l=d("p"),l.innerHTML=v},l(m){l=p(m,"P",{"data-svelte-h":!0}),M(l)!=="svelte-1qn15hi"&&(l.innerHTML=v)},m(m,c){s(m,l,c)},p:nt,d(m){m&&n(l)}}}function Ut(G){let l,v="Examples:",m,c,b;return c=new Re({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLWan, WanPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.schedulers.scheduling_unipc_multistep <span class="hljs-keyword">import</span> UniPCMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models: Wan-AI/Wan2.1-T2V-14B-Diffusers, Wan-AI/Wan2.1-T2V-1.3B-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-14B-Diffusers&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = WanPipeline.from_pretrained(model_id, vae=vae, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">5.0</span>  <span class="hljs-comment"># 5.0 for 720P, 3.0 for 480P</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Bright tones, overexposed, static, blurred details, subtitles, style, works, paintings, images, static, overall gray, worst quality, low quality, JPEG compression residue, ugly, incomplete, extra fingers, poorly drawn hands, poorly drawn faces, deformed, disfigured, misshapen limbs, fused fingers, still picture, messy background, three legs, many people in the background, walking backwards&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">720</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">1280</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">81</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">5.0</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">16</span>)`,wrap:!1}}),{c(){l=d("p"),l.textContent=v,m=a(),g(c.$$.fragment)},l(i){l=p(i,"P",{"data-svelte-h":!0}),M(l)!=="svelte-kvfsh7"&&(l.textContent=v),m=o(i),u(c.$$.fragment,i)},m(i,T){s(i,l,T),s(i,m,T),f(c,i,T),b=!0},p:nt,i(i){b||(h(c.$$.fragment,i),b=!0)},o(i){_(c.$$.fragment,i),b=!1},d(i){i&&(n(l),n(m)),y(c,i)}}}function Zt(G){let l,v="Examples:",m,c,b;return c=new Re({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLWan, WanImageToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models: Wan-AI/Wan2.1-I2V-14B-480P-Diffusers, Wan-AI/Wan2.1-I2V-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;Wan-AI/Wan2.1-I2V-14B-480P-Diffusers&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_encoder = CLIPVisionModel.from_pretrained(
<span class="hljs-meta">... </span>    model_id, subfolder=<span class="hljs-string">&quot;image_encoder&quot;</span>, torch_dtype=torch.float32
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = WanImageToVideoPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, vae=vae, image_encoder=image_encoder, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astronaut.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>max_area = <span class="hljs-number">480</span> * <span class="hljs-number">832</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>aspect_ratio = image.height / image.width
<span class="hljs-meta">&gt;&gt;&gt; </span>mod_value = pipe.vae_scale_factor_spatial * pipe.transformer.config.patch_size[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>height = <span class="hljs-built_in">round</span>(np.sqrt(max_area * aspect_ratio)) // mod_value * mod_value
<span class="hljs-meta">&gt;&gt;&gt; </span>width = <span class="hljs-built_in">round</span>(np.sqrt(max_area / aspect_ratio)) // mod_value * mod_value
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image.resize((width, height))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut hatching from an egg, on the surface of the moon, the darkness and depth of space realised in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the background. High quality, ultrarealistic detail and breath-taking movie-like camera shot.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Bright tones, overexposed, static, blurred details, subtitles, style, works, paintings, images, static, overall gray, worst quality, low quality, JPEG compression residue, ugly, incomplete, extra fingers, poorly drawn hands, poorly drawn faces, deformed, disfigured, misshapen limbs, fused fingers, still picture, messy background, three legs, many people in the background, walking backwards&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    height=height,
<span class="hljs-meta">... </span>    width=width,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">81</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">5.0</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">16</span>)`,wrap:!1}}),{c(){l=d("p"),l.textContent=v,m=a(),g(c.$$.fragment)},l(i){l=p(i,"P",{"data-svelte-h":!0}),M(l)!=="svelte-kvfsh7"&&(l.textContent=v),m=o(i),u(c.$$.fragment,i)},m(i,T){s(i,l,T),s(i,m,T),f(c,i,T),b=!0},p:nt,i(i){b||(h(c.$$.fragment,i),b=!0)},o(i){_(c.$$.fragment,i),b=!1},d(i){i&&(n(l),n(m)),y(c,i)}}}function kt(G){let l,v,m,c,b,i,T,at='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',Me,N,ot='<a href="https://github.com/Wan-Video/Wan2.1" rel="nofollow">Wan 2.1</a> by the Alibaba Wan Team.',be,B,Te,R,st="Recommendations for inference:",we,E,it='<li>VAE in <code>torch.float32</code> for better decoding quality.</li> <li><code>num_frames</code> should be of the form <code>4 * k + 1</code>, for example <code>49</code> or <code>81</code>.</li> <li>For smaller resolution videos, try lower values of <code>shift</code> (between <code>2.0</code> to <code>5.0</code>) in the <a href="https://huggingface.co/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler.shift" rel="nofollow">Scheduler</a>. For larger resolution videos, try higher values (between <code>7.0</code> and <code>12.0</code>). The default value is <code>3.0</code> for Wan.</li>',Je,Q,ve,F,lt="Wan can be used with many different schedulers, each with their own benefits regarding speed and generation quality. By default, Wan uses the <code>UniPCMultistepScheduler(prediction_type=&quot;flow_prediction&quot;, use_flow_sigmas=True, flow_shift=3.0)</code> scheduler. You can use a different scheduler as follows:",We,L,je,H,Ue,z,rt=`The <code>WanTransformer3DModel</code> and <code>AutoencoderKLWan</code> models support loading checkpoints in their original format via the <code>from_single_file</code> loading
method.`,Ze,A,ke,Y,Ie,w,D,Ee,le,dt="Pipeline for text-to-video generation using Wan.",Qe,re,pt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Fe,j,S,Le,de,ct="The call function to the pipeline for generation.",He,C,ze,$,q,Ae,pe,mt="Encodes the prompt into text encoder hidden states.",xe,O,Ve,J,K,Ye,ce,gt="Pipeline for image-to-video generation using Wan.",De,me,ut=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Se,U,ee,qe,ge,ft="The call function to the pipeline for generation.",Oe,P,Ke,X,te,et,ue,ht="Encodes the prompt into text encoder hidden states.",Ge,ne,Be,I,ae,tt,fe,_t="Output class for Wan pipelines.",Ce,oe,$e,ye,Pe;return b=new _e({props:{title:"Wan",local:"wan",headingTag:"h1"}}),B=new vt({props:{$$slots:{default:[jt]},$$scope:{ctx:G}}}),Q=new _e({props:{title:"Using a custom scheduler",local:"using-a-custom-scheduler",headingTag:"h3"}}),L=new Re({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsb3dNYXRjaEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUyMFdhblBpcGVsaW5lJTBBJTBBc2NoZWR1bGVyX2ElMjAlM0QlMjBGbG93TWF0Y2hFdWxlckRpc2NyZXRlU2NoZWR1bGVyKHNoaWZ0JTNENS4wKSUwQXNjaGVkdWxlcl9iJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIocHJlZGljdGlvbl90eXBlJTNEJTIyZmxvd19wcmVkaWN0aW9uJTIyJTJDJTIwdXNlX2Zsb3dfc2lnbWFzJTNEVHJ1ZSUyQyUyMGZsb3dfc2hpZnQlM0Q0LjApJTBBJTBBcGlwZSUyMCUzRCUyMFdhblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJXYW4tQUklMkZXYW4yLjEtVDJWLTEuM0ItRGlmZnVzZXJzJTIyJTJDJTIwc2NoZWR1bGVyJTNEJTNDQ1VTVE9NX1NDSEVEVUxFUl9IRVJFJTNFKSUwQSUwQSUyMyUyMG9yJTJDJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjAlM0NDVVNUT01fU0NIRURVTEVSX0hFUkUlM0U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlowMatchEulerDiscreteScheduler, UniPCMultistepScheduler, WanPipeline

scheduler_a = FlowMatchEulerDiscreteScheduler(shift=<span class="hljs-number">5.0</span>)
scheduler_b = UniPCMultistepScheduler(prediction_type=<span class="hljs-string">&quot;flow_prediction&quot;</span>, use_flow_sigmas=<span class="hljs-literal">True</span>, flow_shift=<span class="hljs-number">4.0</span>)

pipe = WanPipeline.from_pretrained(<span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-1.3B-Diffusers&quot;</span>, scheduler=&lt;CUSTOM_SCHEDULER_HERE&gt;)

<span class="hljs-comment"># or,</span>
pipe.scheduler = &lt;CUSTOM_SCHEDULER_HERE&gt;`,wrap:!1}}),H=new _e({props:{title:"Using single file loading with Wan",local:"using-single-file-loading-with-wan",headingTag:"h3"}}),A=new Re({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwV2FuUGlwZWxpbmUlMkMlMjBXYW5UcmFuc2Zvcm1lcjNETW9kZWwlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGQ29tZnktT3JnJTJGV2FuXzIuMV9Db21meVVJX3JlcGFja2FnZWQlMkZibG9iJTJGbWFpbiUyRnNwbGl0X2ZpbGVzJTJGZGlmZnVzaW9uX21vZGVscyUyRndhbjIuMV90MnZfMS4zQl9iZjE2LnNhZmV0ZW5zb3JzJTIyJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBXYW5UcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9zaW5nbGVfZmlsZShja3B0X3BhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQSUwQXBpcGUlMjAlM0QlMjBXYW5QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyV2FuLUFJJTJGV2FuMi4xLVQyVi0xLjNCLURpZmZ1c2VycyUyMiUyQyUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> WanPipeline, WanTransformer3DModel

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/Comfy-Org/Wan_2.1_ComfyUI_repackaged/blob/main/split_files/diffusion_models/wan2.1_t2v_1.3B_bf16.safetensors&quot;</span>
transformer = WanTransformer3DModel.from_single_file(ckpt_path, torch_dtype=torch.bfloat16)

pipe = WanPipeline.from_pretrained(<span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-1.3B-Diffusers&quot;</span>, transformer=transformer)`,wrap:!1}}),Y=new _e({props:{title:"WanPipeline",local:"diffusers.WanPipeline",headingTag:"h2"}}),D=new ie({props:{name:"class diffusers.WanPipeline",anchor:"diffusers.WanPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"transformer",val:": WanTransformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"}],parametersDescription:[{anchor:"diffusers.WanPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.WanPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.WanPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/wan_transformer_3d#diffusers.WanTransformer3DModel">WanTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the input latents.`,name:"transformer"},{anchor:"diffusers.WanPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.WanPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan.py#L93"}}),S=new ie({props:{name:"__call__",anchor:"diffusers.WanPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 480"},{name:"width",val:": int = 832"},{name:"num_frames",val:": int = 81"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.WanPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.WanPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>480</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.WanPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>832</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.WanPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>81</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.WanPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WanPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>5.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WanPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.WanPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WanPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.WanPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>WanPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WanPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.WanPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WanPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.WanPipeline.__call__.autocast_dtype",description:`<strong>autocast_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.bfloat16</code>) &#x2014;
The dtype to use for the torch.amp.autocast.`,name:"autocast_dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan.py#L359",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>WanPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~WanPipelineOutput</code> or <code>tuple</code></p>
`}}),C=new yt({props:{anchor:"diffusers.WanPipeline.__call__.example",$$slots:{default:[Ut]},$$scope:{ctx:G}}}),q=new ie({props:{name:"encode_prompt",anchor:"diffusers.WanPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.WanPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.WanPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WanPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.WanPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WanPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.WanPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan.py#L181"}}),O=new _e({props:{title:"WanImageToVideoPipeline",local:"diffusers.WanImageToVideoPipeline",headingTag:"h2"}}),K=new ie({props:{name:"class diffusers.WanImageToVideoPipeline",anchor:"diffusers.WanImageToVideoPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"image_encoder",val:": CLIPVisionModel"},{name:"image_processor",val:": CLIPImageProcessor"},{name:"transformer",val:": WanTransformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"}],parametersDescription:[{anchor:"diffusers.WanImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.WanImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.WanImageToVideoPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPVisionModel" rel="nofollow">CLIP</a>, specifically
the
<a href="https://github.com/mlfoundations/open_clip/blob/main/docs/PRETRAINED.md#vit-h14-xlm-roberta-large" rel="nofollow">clip-vit-huge-patch14</a>
variant.`,name:"image_encoder"},{anchor:"diffusers.WanImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/wan_transformer_3d#diffusers.WanTransformer3DModel">WanTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the input latents.`,name:"transformer"},{anchor:"diffusers.WanImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.WanImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan_i2v.py#L140"}}),ee=new ie({props:{name:"__call__",anchor:"diffusers.WanImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 480"},{name:"width",val:": int = 832"},{name:"num_frames",val:": int = 81"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.WanImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>480</code>) &#x2014;
The height of the generated video.`,name:"height"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>832</code>) &#x2014;
The width of the generated video.`,name:"width"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>81</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>5.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>WanPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length of the prompt.`,name:"max_sequence_length"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.shift",description:`<strong>shift</strong> (<code>float</code>, <em>optional</em>, defaults to <code>5.0</code>) &#x2014;
The shift of the flow.`,name:"shift"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.autocast_dtype",description:`<strong>autocast_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.bfloat16</code>) &#x2014;
The dtype to use for the torch.amp.autocast.`,name:"autocast_dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan_i2v.py#L457",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>WanPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~WanPipelineOutput</code> or <code>tuple</code></p>
`}}),P=new yt({props:{anchor:"diffusers.WanImageToVideoPipeline.__call__.example",$$slots:{default:[Zt]},$$scope:{ctx:G}}}),te=new ie({props:{name:"encode_prompt",anchor:"diffusers.WanImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan_i2v.py#L244"}}),ne=new _e({props:{title:"WanPipelineOutput",local:"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput",headingTag:"h2"}}),ae=new ie({props:{name:"class diffusers.pipelines.wan.pipeline_output.WanPipelineOutput",anchor:"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_output.py#L8"}}),oe=new Wt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/wan.md"}}),{c(){l=d("meta"),v=a(),m=d("p"),c=a(),g(b.$$.fragment),i=a(),T=d("div"),T.innerHTML=at,Me=a(),N=d("p"),N.innerHTML=ot,be=a(),g(B.$$.fragment),Te=a(),R=d("p"),R.textContent=st,we=a(),E=d("ul"),E.innerHTML=it,Je=a(),g(Q.$$.fragment),ve=a(),F=d("p"),F.innerHTML=lt,We=a(),g(L.$$.fragment),je=a(),g(H.$$.fragment),Ue=a(),z=d("p"),z.innerHTML=rt,Ze=a(),g(A.$$.fragment),ke=a(),g(Y.$$.fragment),Ie=a(),w=d("div"),g(D.$$.fragment),Ee=a(),le=d("p"),le.textContent=dt,Qe=a(),re=d("p"),re.innerHTML=pt,Fe=a(),j=d("div"),g(S.$$.fragment),Le=a(),de=d("p"),de.textContent=ct,He=a(),g(C.$$.fragment),ze=a(),$=d("div"),g(q.$$.fragment),Ae=a(),pe=d("p"),pe.textContent=mt,xe=a(),g(O.$$.fragment),Ve=a(),J=d("div"),g(K.$$.fragment),Ye=a(),ce=d("p"),ce.textContent=gt,De=a(),me=d("p"),me.innerHTML=ut,Se=a(),U=d("div"),g(ee.$$.fragment),qe=a(),ge=d("p"),ge.textContent=ft,Oe=a(),g(P.$$.fragment),Ke=a(),X=d("div"),g(te.$$.fragment),et=a(),ue=d("p"),ue.textContent=ht,Ge=a(),g(ne.$$.fragment),Be=a(),I=d("div"),g(ae.$$.fragment),tt=a(),fe=d("p"),fe.textContent=_t,Ce=a(),g(oe.$$.fragment),$e=a(),ye=d("p"),this.h()},l(e){const t=Jt("svelte-u9bgzb",document.head);l=p(t,"META",{name:!0,content:!0}),t.forEach(n),v=o(e),m=p(e,"P",{}),V(m).forEach(n),c=o(e),u(b.$$.fragment,e),i=o(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(T)!=="svelte-si9ct8"&&(T.innerHTML=at),Me=o(e),N=p(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-16y8q1j"&&(N.innerHTML=ot),be=o(e),u(B.$$.fragment,e),Te=o(e),R=p(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1bbhycm"&&(R.textContent=st),we=o(e),E=p(e,"UL",{"data-svelte-h":!0}),M(E)!=="svelte-1dpydlh"&&(E.innerHTML=it),Je=o(e),u(Q.$$.fragment,e),ve=o(e),F=p(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-c0om1t"&&(F.innerHTML=lt),We=o(e),u(L.$$.fragment,e),je=o(e),u(H.$$.fragment,e),Ue=o(e),z=p(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-19w1gpb"&&(z.innerHTML=rt),Ze=o(e),u(A.$$.fragment,e),ke=o(e),u(Y.$$.fragment,e),Ie=o(e),w=p(e,"DIV",{class:!0});var W=V(w);u(D.$$.fragment,W),Ee=o(W),le=p(W,"P",{"data-svelte-h":!0}),M(le)!=="svelte-cppop6"&&(le.textContent=dt),Qe=o(W),re=p(W,"P",{"data-svelte-h":!0}),M(re)!=="svelte-496sm0"&&(re.innerHTML=pt),Fe=o(W),j=p(W,"DIV",{class:!0});var x=V(j);u(S.$$.fragment,x),Le=o(x),de=p(x,"P",{"data-svelte-h":!0}),M(de)!=="svelte-50j04k"&&(de.textContent=ct),He=o(x),u(C.$$.fragment,x),x.forEach(n),ze=o(W),$=p(W,"DIV",{class:!0});var se=V($);u(q.$$.fragment,se),Ae=o(se),pe=p(se,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-16q0ax1"&&(pe.textContent=mt),se.forEach(n),W.forEach(n),xe=o(e),u(O.$$.fragment,e),Ve=o(e),J=p(e,"DIV",{class:!0});var Z=V(J);u(K.$$.fragment,Z),Ye=o(Z),ce=p(Z,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-1u5shki"&&(ce.textContent=gt),De=o(Z),me=p(Z,"P",{"data-svelte-h":!0}),M(me)!=="svelte-496sm0"&&(me.innerHTML=ut),Se=o(Z),U=p(Z,"DIV",{class:!0});var he=V(U);u(ee.$$.fragment,he),qe=o(he),ge=p(he,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-50j04k"&&(ge.textContent=ft),Oe=o(he),u(P.$$.fragment,he),he.forEach(n),Ke=o(Z),X=p(Z,"DIV",{class:!0});var Xe=V(X);u(te.$$.fragment,Xe),et=o(Xe),ue=p(Xe,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-16q0ax1"&&(ue.textContent=ht),Xe.forEach(n),Z.forEach(n),Ge=o(e),u(ne.$$.fragment,e),Be=o(e),I=p(e,"DIV",{class:!0});var Ne=V(I);u(ae.$$.fragment,Ne),tt=o(Ne),fe=p(Ne,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-fkhkmf"&&(fe.textContent=_t),Ne.forEach(n),Ce=o(e),u(oe.$$.fragment,e),$e=o(e),ye=p(e,"P",{}),V(ye).forEach(n),this.h()},h(){k(l,"name","hf:doc:metadata"),k(l,"content",It),k(T,"class","flex flex-wrap space-x-1"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,l),s(e,v,t),s(e,m,t),s(e,c,t),f(b,e,t),s(e,i,t),s(e,T,t),s(e,Me,t),s(e,N,t),s(e,be,t),f(B,e,t),s(e,Te,t),s(e,R,t),s(e,we,t),s(e,E,t),s(e,Je,t),f(Q,e,t),s(e,ve,t),s(e,F,t),s(e,We,t),f(L,e,t),s(e,je,t),f(H,e,t),s(e,Ue,t),s(e,z,t),s(e,Ze,t),f(A,e,t),s(e,ke,t),f(Y,e,t),s(e,Ie,t),s(e,w,t),f(D,w,null),r(w,Ee),r(w,le),r(w,Qe),r(w,re),r(w,Fe),r(w,j),f(S,j,null),r(j,Le),r(j,de),r(j,He),f(C,j,null),r(w,ze),r(w,$),f(q,$,null),r($,Ae),r($,pe),s(e,xe,t),f(O,e,t),s(e,Ve,t),s(e,J,t),f(K,J,null),r(J,Ye),r(J,ce),r(J,De),r(J,me),r(J,Se),r(J,U),f(ee,U,null),r(U,qe),r(U,ge),r(U,Oe),f(P,U,null),r(J,Ke),r(J,X),f(te,X,null),r(X,et),r(X,ue),s(e,Ge,t),f(ne,e,t),s(e,Be,t),s(e,I,t),f(ae,I,null),r(I,tt),r(I,fe),s(e,Ce,t),f(oe,e,t),s(e,$e,t),s(e,ye,t),Pe=!0},p(e,[t]){const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),B.$set(W);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),C.$set(x);const se={};t&2&&(se.$$scope={dirty:t,ctx:e}),P.$set(se)},i(e){Pe||(h(b.$$.fragment,e),h(B.$$.fragment,e),h(Q.$$.fragment,e),h(L.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(Y.$$.fragment,e),h(D.$$.fragment,e),h(S.$$.fragment,e),h(C.$$.fragment,e),h(q.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(P.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),Pe=!0)},o(e){_(b.$$.fragment,e),_(B.$$.fragment,e),_(Q.$$.fragment,e),_(L.$$.fragment,e),_(H.$$.fragment,e),_(A.$$.fragment,e),_(Y.$$.fragment,e),_(D.$$.fragment,e),_(S.$$.fragment,e),_(C.$$.fragment,e),_(q.$$.fragment,e),_(O.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(P.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(oe.$$.fragment,e),Pe=!1},d(e){e&&(n(v),n(m),n(c),n(i),n(T),n(Me),n(N),n(be),n(Te),n(R),n(we),n(E),n(Je),n(ve),n(F),n(We),n(je),n(Ue),n(z),n(Ze),n(ke),n(Ie),n(w),n(xe),n(Ve),n(J),n(Ge),n(Be),n(I),n(Ce),n($e),n(ye)),n(l),y(b,e),y(B,e),y(Q,e),y(L,e),y(H,e),y(A,e),y(Y,e),y(D),y(S),y(C),y(q),y(O,e),y(K),y(ee),y(P),y(te),y(ne,e),y(ae),y(oe,e)}}}const It='{"title":"Wan","local":"wan","sections":[{"title":"Using a custom scheduler","local":"using-a-custom-scheduler","sections":[],"depth":3},{"title":"Using single file loading with Wan","local":"using-single-file-loading-with-wan","sections":[],"depth":3},{"title":"WanPipeline","local":"diffusers.WanPipeline","sections":[],"depth":2},{"title":"WanImageToVideoPipeline","local":"diffusers.WanImageToVideoPipeline","sections":[],"depth":2},{"title":"WanPipelineOutput","local":"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput","sections":[],"depth":2}],"depth":1}';function xt(G){return bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends Tt{constructor(l){super(),wt(this,l,xt,kt,Mt,{})}}export{Nt as component};
