import{s as It,o as Bt,n as _e}from"../chunks/scheduler.8c3d61f6.js";import{S as gt,i as Gt,g as o,s as n,r as M,A as Ct,h as p,f as t,c as a,j as jt,u as d,x as m,k as Zt,y as _t,a as s,v as u,d as y,t as f,w as h}from"../chunks/index.da70eac4.js";import{T as Ce}from"../chunks/Tip.1d9b8c37.js";import{C as j}from"../chunks/CodeBlock.00a903b3.js";import{H as Z,E as Wt}from"../chunks/EditOnGithub.1e64e623.js";function vt(b){let i,J='In many cases, optimizing for memory or speed leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on minimizing memory usage, but you can also learn more about how to <a href="fp16">Speed up inference</a>.';return{c(){i=o("p"),i.innerHTML=J},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-15lbm2y"&&(i.innerHTML=J)},m(r,c){s(r,i,c)},p:_e,d(r){r&&t(i)}}}function Vt(b){let i,J='Consider using <a href="#model-offloading">model offloading</a> if you want to optimize for speed because it is much faster. The tradeoff is your memory savings won’t be as large.';return{c(){i=o("p"),i.innerHTML=J},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1yyrc0t"&&(i.innerHTML=J)},m(r,c){s(r,i,c)},p:_e,d(r){r&&t(i)}}}function kt(b){let i,J='When using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, don’t move the pipeline to CUDA beforehand or else the gain in memory consumption will only be minimal (see this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more information).',r,c,U='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> is a stateful operation that installs hooks on the models.';return{c(){i=o("p"),i.innerHTML=J,r=n(),c=o("p"),c.innerHTML=U},l(w){i=p(w,"P",{"data-svelte-h":!0}),m(i)!=="svelte-pysjic"&&(i.innerHTML=J),r=a(w),c=p(w,"P",{"data-svelte-h":!0}),m(c)!=="svelte-1zrt6x"&&(c.innerHTML=U)},m(w,T){s(w,i,T),s(w,r,T),s(w,c,T)},p:_e,d(w){w&&(t(i),t(r),t(c))}}}function Xt(b){let i,J="Model offloading requires 🤗 Accelerate version 0.17.0 or higher.";return{c(){i=o("p"),i.textContent=J},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1guxtqy"&&(i.textContent=J)},m(r,c){s(r,i,c)},p:_e,d(r){r&&t(i)}}}function Yt(b){let i,J='In order to properly offload models after they’re called, it is required to run the entire pipeline and models are called in the pipeline’s expected order. Exercise caution if models are reused outside the context of the pipeline after hooks have been installed. See <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a> for more information.',r,c,U='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> is a stateful operation that installs hooks on the models and state on the pipeline.';return{c(){i=o("p"),i.innerHTML=J,r=n(),c=o("p"),c.innerHTML=U},l(w){i=p(w,"P",{"data-svelte-h":!0}),m(i)!=="svelte-bljvwk"&&(i.innerHTML=J),r=a(w),c=p(w,"P",{"data-svelte-h":!0}),m(c)!=="svelte-1rrcfel"&&(c.innerHTML=U)},m(w,T){s(w,i,T),s(w,r,T),s(w,c,T)},p:_e,d(w){w&&(t(i),t(r),t(c))}}}function Rt(b){let i,J="If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling <code>xformers</code>.";return{c(){i=o("p"),i.innerHTML=J},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-17vr965"&&(i.innerHTML=J)},m(r,c){s(r,i,c)},p:_e,d(r){r&&t(i)}}}function $t(b){let i,J,r,c,U,w,T,$l="A barrier to using diffusion models is the large amount of memory required. To overcome this challenge, there are several memory-reducing techniques you can use to run even some of the largest models on free-tier or consumer GPUs. Some of these techniques can even be combined to further reduce memory usage.",ve,I,Ve,W,Sl="The results below are obtained from generating a single 512x512 image from the prompt a photo of an astronaut riding a horse on mars with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect as a result of reduced memory consumption.",ke,v,El="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory-efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",Xe,V,Ye,k,Nl='Sliced VAE enables decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time. You’ll likely want to couple this with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',Re,X,Hl='To use sliced VAE, call <a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_slicing">enable_vae_slicing()</a> on your pipeline before inference:',$e,Y,Se,R,Ql="You may see a small performance boost in VAE decoding on multi-image batches, and there should be no performance impact on single-image batches.",Ee,$,Ne,S,xl='Tiled VAE processing also enables working with large images on limited VRAM (for example, generating 4k images on 8GB of VRAM) by splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image. You should also used tiled VAE with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',He,E,Fl='To use tiled VAE processing, call <a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_tiling">enable_vae_tiling()</a> on your pipeline before inference:',Qe,N,xe,H,zl="The output image has some tile-to-tile tone variation because the tiles are decoded separately, but you shouldn’t see any sharp and obvious seams between the tiles. Tiling is turned off for images that are 512x512 or smaller.",Fe,Q,ze,x,Al="Offloading the weights to the CPU and only loading them on the GPU when performing the forward pass can also save memory. Often, this technique can reduce memory consumption to less than 3GB.",Ae,F,ql='To perform CPU offloading, call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>:',qe,z,Le,A,Ll="CPU offloading works on submodules rather than whole models. This is the best way to minimize memory consumption, but inference is much slower due to the iterative nature of the diffusion process. The UNet component of the pipeline runs several times (as many as <code>num_inference_steps</code>); each time, the different UNet submodules are sequentially onloaded and offloaded as needed, resulting in a large number of memory transfers.",Pe,B,De,g,Ke,q,Oe,G,el,L,Pl='<a href="#cpu-offloading">Sequential CPU offloading</a> preserves a lot of memory but it makes inference slower because submodules are moved to GPU as needed, and they’re immediately returned to the CPU when a new module runs.',ll,P,Dl="Full-model offloading is an alternative that moves whole models to the GPU, instead of handling each model’s constituent <em>submodules</em>. There is a negligible impact on inference time (compared with moving the pipeline to <code>cuda</code>), and it still provides some memory savings.",tl,D,Kl=`During model offloading, only one of the main components of the pipeline (typically the text encoder, UNet and VAE)
is placed on the GPU while the others wait on the CPU. Components like the UNet that run for multiple iterations stay on the GPU until they’re no longer needed.`,sl,K,Ol='Enable model offloading by calling <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on the pipeline:',nl,O,al,C,il,ee,ol,le,et="Group offloading is the middle ground between sequential and model offloading. It works by offloading groups of internal layers (either <code>torch.nn.ModuleList</code> or <code>torch.nn.Sequential</code>), which uses less memory than model-level offloading. It is also faster than sequential-level offloading because the number of device synchronizations is reduced.",pl,te,lt='To enable group offloading, call the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_group_offload">enable_group_offload()</a> method on the model if it is a Diffusers model implementation. For any other model implementation, use <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_group_offloading">apply_group_offloading()</a>:',ml,se,rl,ne,tt="Group offloading (for CUDA devices with support for asynchronous data transfer streams) overlaps data transfer and computation to reduce the overall execution time compared to sequential offloading. This is enabled using layer prefetching with CUDA streams. The next layer to be executed is loaded onto the accelerator device while the current layer is being executed - this increases the memory requirements slightly. Group offloading also supports leaf-level offloading (equivalent to sequential CPU offloading) but can be made much faster when using streams.",cl,ae,Ml,ie,st="PyTorch supports <code>torch.float8_e4m3fn</code> and <code>torch.float8_e5m2</code> as weight storage dtypes, but they can’t be used for computation in many different tensor operations due to unimplemented kernel support. However, you can use these dtypes to store model weights in fp8 precision and upcast them on-the-fly when the layers are used in the forward pass. This is known as layerwise weight-casting.",dl,oe,nt="Typically, inference on most models is done with <code>torch.float16</code> or <code>torch.bfloat16</code> weight/computation precision. Layerwise weight-casting cuts down the memory footprint of the model weights by approximately half.",ul,pe,yl,me,at="In the above example, layerwise casting is enabled on the transformer component of the pipeline. By default, certain layers are skipped from the FP8 weight casting because it can lead to significant degradation of generation quality. The normalization and modulation related weight parameters are also skipped by default.",fl,re,it='However, you gain more control and flexibility by directly utilizing the <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_layerwise_casting">apply_layerwise_casting()</a> function instead of <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_layerwise_casting">enable_layerwise_casting()</a>.',hl,ce,wl,Me,ot="The channels-last memory format is an alternative way of ordering NCHW tensors in memory to preserve dimension ordering. Channels-last tensors are ordered in such a way that the channels become the densest dimension (storing images pixel-per-pixel). Since not all operators currently support the channels-last format, it may result in worst performance but you should still try and see if it works for your model.",Jl,de,pt="For example, to set the pipeline’s UNet to use the channels-last format:",Tl,ue,bl,ye,Ul,fe,mt="Tracing runs an example input tensor through the model and captures the operations that are performed on it as that input makes its way through the model’s layers. The executable or <code>ScriptFunction</code> that is returned is optimized with just-in-time compilation.",jl,he,rt="To trace a UNet:",Zl,we,Il,Je,ct="Replace the <code>unet</code> attribute of the pipeline with the traced model:",Bl,Te,gl,be,Gl,Ue,Mt='Recent work on optimizing bandwidth in the attention block has generated huge speed-ups and reductions in GPU memory usage. The most recent type of memory-efficient attention is <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention</a> (you can check out the original code at <a href="https://github.com/HazyResearch/flash-attention" rel="nofollow">HazyResearch/flash-attention</a>).',Cl,_,_l,je,dt="To use Flash Attention, install the following:",Wl,Ze,ut='<li>PyTorch &gt; 1.12</li> <li>CUDA available</li> <li><a href="xformers">xFormers</a></li>',vl,Ie,yt='Then call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on the pipeline:',Vl,Be,kl,ge,ft='The iteration speed when using <code>xformers</code> should match the iteration speed of PyTorch 2.0 as described <a href="torch2.0">here</a>.',Xl,Ge,Yl,We,Rl;return U=new Z({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h1"}}),I=new Ce({props:{$$slots:{default:[vt]},$$scope:{ctx:b}}}),V=new Z({props:{title:"Sliced VAE",local:"sliced-vae",headingTag:"h2"}}),Y=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUyM3BpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyMColMjAzMikuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_vae_slicing()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>
images = pipe([prompt] * <span class="hljs-number">32</span>).images`,wrap:!1}}),$=new Z({props:{title:"Tiled VAE",local:"tiled-vae",headingTag:"h2"}}),N=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBiZWF1dGlmdWwlMjBsYW5kc2NhcGUlMjBwaG90b2dyYXBoJTIyJTBBcGlwZS5lbmFibGVfdmFlX3RpbGluZygpJTBBJTIzcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglNUJwcm9tcHQlNUQlMkMlMjB3aWR0aCUzRDM4NDAlMkMlMjBoZWlnaHQlM0QyMjI0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a beautiful landscape photograph&quot;</span>
pipe.enable_vae_tiling()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>

image = pipe([prompt], width=<span class="hljs-number">3840</span>, height=<span class="hljs-number">2224</span>, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Q=new Z({props:{title:"CPU offloading",local:"cpu-offloading",headingTag:"h2"}}),z=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX3NlcXVlbnRpYWxfY3B1X29mZmxvYWQoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_sequential_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),B=new Ce({props:{$$slots:{default:[Vt]},$$scope:{ctx:b}}}),g=new Ce({props:{warning:!0,$$slots:{default:[kt]},$$scope:{ctx:b}}}),q=new Z({props:{title:"Model offloading",local:"model-offloading",headingTag:"h2"}}),G=new Ce({props:{$$slots:{default:[Xt]},$$scope:{ctx:b}}}),O=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_model_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),C=new Ce({props:{warning:!0,$$slots:{default:[Yt]},$$scope:{ctx:b}}}),ee=new Z({props:{title:"Group offloading",local:"group-offloading",headingTag:"h2"}}),se=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_group_offloading
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-comment"># Load the pipeline</span>
onload_device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>)
offload_device = torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>, torch_dtype=torch.bfloat16)

<span class="hljs-comment"># We can utilize the enable_group_offload method for Diffusers model implementations</span>
pipe.transformer.enable_group_offload(onload_device=onload_device, offload_device=offload_device, offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>, use_stream=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># For any other model implementations, the apply_group_offloading function can be used</span>
apply_group_offloading(pipe.text_encoder, onload_device=onload_device, offload_type=<span class="hljs-string">&quot;block_level&quot;</span>, num_blocks_per_group=<span class="hljs-number">2</span>)
apply_group_offloading(pipe.vae, onload_device=onload_device, offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>)

prompt = (
    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
)
video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-comment"># This utilized about 14.79 GB. It can be further reduced by using tiling and using leaf_level offloading throughout the pipeline.</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),ae=new Z({props:{title:"FP8 layerwise weight-casting",local:"fp8-layerwise-weight-casting",headingTag:"h2"}}),pe=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline, CogVideoXTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>

<span class="hljs-comment"># Load the model in bfloat16 and enable layerwise casting</span>
transformer = CogVideoXTransformer3DModel.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16)
transformer.enable_layerwise_casting(storage_dtype=torch.float8_e4m3fn, compute_dtype=torch.bfloat16)

<span class="hljs-comment"># Load the pipeline</span>
pipe = CogVideoXPipeline.from_pretrained(model_id, transformer=transformer, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = (
    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
)
video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),ce=new Z({props:{title:"Channels-last memory format",local:"channels-last-memory-format",headingTag:"h2"}}),ue=new j({props:{code:"cHJpbnQocGlwZS51bmV0LmNvbnZfb3V0LnN0YXRlX2RpY3QoKSU1QiUyMndlaWdodCUyMiU1RC5zdHJpZGUoKSklMjAlMjAlMjMlMjAoMjg4MCUyQyUyMDklMkMlMjAzJTJDJTIwMSklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTIwJTIwJTIzJTIwaW4tcGxhY2UlMjBvcGVyYXRpb24lMEFwcmludCglMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipe.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`,wrap:!1}}),ye=new Z({props:{title:"Tracing",local:"tracing",headingTag:"h2"}}),we=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>


<span class="hljs-comment"># load inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    timestep = torch.rand(<span class="hljs-number">1</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16) * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipe.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)


<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)


<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`,wrap:!1}}),Te=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLlRlbnNvciUwQSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjB1c2UlMjBqaXR0ZWQlMjB1bmV0JTBBdW5ldF90cmFjZWQlMjAlM0QlMjB0b3JjaC5qaXQubG9hZCglMjJ1bmV0X3RyYWNlZC5wdCUyMiklMEElMEElMEElMjMlMjBkZWwlMjBwaXBlLnVuZXQlMEFjbGFzcyUyMFRyYWNlZFVOZXQodG9yY2gubm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pbl9jaGFubmVscyUyMCUzRCUyMHBpcGUudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmRldmljZSUyMCUzRCUyMHBpcGUudW5ldC5kZXZpY2UlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMHVuZXRfdHJhY2VkKGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHQlMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFVOZXQyRENvbmRpdGlvbk91dHB1dChzYW1wbGUlM0RzYW1wbGUpJTBBJTBBJTBBcGlwZS51bmV0JTIwJTNEJTIwVHJhY2VkVU5ldCgpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDElMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.Tensor


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)


<span class="hljs-comment"># del pipe.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.config.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)


pipe.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),be=new Z({props:{title:"Memory-efficient attention",local:"memory-efficient-attention",headingTag:"h2"}}),_=new Ce({props:{$$slots:{default:[Rt]},$$scope:{ctx:b}}}),Be=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwc2FtcGxlJTIwJTNEJTIwcGlwZSglMjJhJTIwc21hbGwlMjBjYXQlMjIpJTBBJTBBJTIzJTIwb3B0aW9uYWwlM0ElMjBZb3UlMjBjYW4lMjBkaXNhYmxlJTIwaXQlMjB2aWElMEElMjMlMjBwaXBlLmRpc2FibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-keyword">with</span> torch.inference_mode():
    sample = pipe(<span class="hljs-string">&quot;a small cat&quot;</span>)

<span class="hljs-comment"># optional: You can disable it via</span>
<span class="hljs-comment"># pipe.disable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),Ge=new Wt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/memory.md"}}),{c(){i=o("meta"),J=n(),r=o("p"),c=n(),M(U.$$.fragment),w=n(),T=o("p"),T.textContent=$l,ve=n(),M(I.$$.fragment),Ve=n(),W=o("p"),W.textContent=Sl,ke=n(),v=o("table"),v.innerHTML=El,Xe=n(),M(V.$$.fragment),Ye=n(),k=o("p"),k.innerHTML=Nl,Re=n(),X=o("p"),X.innerHTML=Hl,$e=n(),M(Y.$$.fragment),Se=n(),R=o("p"),R.textContent=Ql,Ee=n(),M($.$$.fragment),Ne=n(),S=o("p"),S.innerHTML=xl,He=n(),E=o("p"),E.innerHTML=Fl,Qe=n(),M(N.$$.fragment),xe=n(),H=o("p"),H.textContent=zl,Fe=n(),M(Q.$$.fragment),ze=n(),x=o("p"),x.textContent=Al,Ae=n(),F=o("p"),F.innerHTML=ql,qe=n(),M(z.$$.fragment),Le=n(),A=o("p"),A.innerHTML=Ll,Pe=n(),M(B.$$.fragment),De=n(),M(g.$$.fragment),Ke=n(),M(q.$$.fragment),Oe=n(),M(G.$$.fragment),el=n(),L=o("p"),L.innerHTML=Pl,ll=n(),P=o("p"),P.innerHTML=Dl,tl=n(),D=o("p"),D.textContent=Kl,sl=n(),K=o("p"),K.innerHTML=Ol,nl=n(),M(O.$$.fragment),al=n(),M(C.$$.fragment),il=n(),M(ee.$$.fragment),ol=n(),le=o("p"),le.innerHTML=et,pl=n(),te=o("p"),te.innerHTML=lt,ml=n(),M(se.$$.fragment),rl=n(),ne=o("p"),ne.textContent=tt,cl=n(),M(ae.$$.fragment),Ml=n(),ie=o("p"),ie.innerHTML=st,dl=n(),oe=o("p"),oe.innerHTML=nt,ul=n(),M(pe.$$.fragment),yl=n(),me=o("p"),me.textContent=at,fl=n(),re=o("p"),re.innerHTML=it,hl=n(),M(ce.$$.fragment),wl=n(),Me=o("p"),Me.textContent=ot,Jl=n(),de=o("p"),de.textContent=pt,Tl=n(),M(ue.$$.fragment),bl=n(),M(ye.$$.fragment),Ul=n(),fe=o("p"),fe.innerHTML=mt,jl=n(),he=o("p"),he.textContent=rt,Zl=n(),M(we.$$.fragment),Il=n(),Je=o("p"),Je.innerHTML=ct,Bl=n(),M(Te.$$.fragment),gl=n(),M(be.$$.fragment),Gl=n(),Ue=o("p"),Ue.innerHTML=Mt,Cl=n(),M(_.$$.fragment),_l=n(),je=o("p"),je.textContent=dt,Wl=n(),Ze=o("ul"),Ze.innerHTML=ut,vl=n(),Ie=o("p"),Ie.innerHTML=yt,Vl=n(),M(Be.$$.fragment),kl=n(),ge=o("p"),ge.innerHTML=ft,Xl=n(),M(Ge.$$.fragment),Yl=n(),We=o("p"),this.h()},l(e){const l=Ct("svelte-u9bgzb",document.head);i=p(l,"META",{name:!0,content:!0}),l.forEach(t),J=a(e),r=p(e,"P",{}),jt(r).forEach(t),c=a(e),d(U.$$.fragment,e),w=a(e),T=p(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-18ag1qn"&&(T.textContent=$l),ve=a(e),d(I.$$.fragment,e),Ve=a(e),W=p(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1nfsyhf"&&(W.textContent=Sl),ke=a(e),v=p(e,"TABLE",{"data-svelte-h":!0}),m(v)!=="svelte-qiiy0g"&&(v.innerHTML=El),Xe=a(e),d(V.$$.fragment,e),Ye=a(e),k=p(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-g37v30"&&(k.innerHTML=Nl),Re=a(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1nl6cpr"&&(X.innerHTML=Hl),$e=a(e),d(Y.$$.fragment,e),Se=a(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-fte8mn"&&(R.textContent=Ql),Ee=a(e),d($.$$.fragment,e),Ne=a(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1g0rx31"&&(S.innerHTML=xl),He=a(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1yciusa"&&(E.innerHTML=Fl),Qe=a(e),d(N.$$.fragment,e),xe=a(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-nyzaca"&&(H.textContent=zl),Fe=a(e),d(Q.$$.fragment,e),ze=a(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-435lli"&&(x.textContent=Al),Ae=a(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-z49dor"&&(F.innerHTML=ql),qe=a(e),d(z.$$.fragment,e),Le=a(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-153k8wf"&&(A.innerHTML=Ll),Pe=a(e),d(B.$$.fragment,e),De=a(e),d(g.$$.fragment,e),Ke=a(e),d(q.$$.fragment,e),Oe=a(e),d(G.$$.fragment,e),el=a(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1w0xgx8"&&(L.innerHTML=Pl),ll=a(e),P=p(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-nislc4"&&(P.innerHTML=Dl),tl=a(e),D=p(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-11gjm3"&&(D.textContent=Kl),sl=a(e),K=p(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-op610o"&&(K.innerHTML=Ol),nl=a(e),d(O.$$.fragment,e),al=a(e),d(C.$$.fragment,e),il=a(e),d(ee.$$.fragment,e),ol=a(e),le=p(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-n1o14o"&&(le.innerHTML=et),pl=a(e),te=p(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1pf7o6v"&&(te.innerHTML=lt),ml=a(e),d(se.$$.fragment,e),rl=a(e),ne=p(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-fe960w"&&(ne.textContent=tt),cl=a(e),d(ae.$$.fragment,e),Ml=a(e),ie=p(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-lwtukj"&&(ie.innerHTML=st),dl=a(e),oe=p(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-r2gdi7"&&(oe.innerHTML=nt),ul=a(e),d(pe.$$.fragment,e),yl=a(e),me=p(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-lgt48u"&&(me.textContent=at),fl=a(e),re=p(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-1fq2kcg"&&(re.innerHTML=it),hl=a(e),d(ce.$$.fragment,e),wl=a(e),Me=p(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-sky5la"&&(Me.textContent=ot),Jl=a(e),de=p(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-mhdc10"&&(de.textContent=pt),Tl=a(e),d(ue.$$.fragment,e),bl=a(e),d(ye.$$.fragment,e),Ul=a(e),fe=p(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1hj6sqj"&&(fe.innerHTML=mt),jl=a(e),he=p(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-1ca1ko1"&&(he.textContent=rt),Zl=a(e),d(we.$$.fragment,e),Il=a(e),Je=p(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-mpebhd"&&(Je.innerHTML=ct),Bl=a(e),d(Te.$$.fragment,e),gl=a(e),d(be.$$.fragment,e),Gl=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-1tu2ji2"&&(Ue.innerHTML=Mt),Cl=a(e),d(_.$$.fragment,e),_l=a(e),je=p(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-rpfoyf"&&(je.textContent=dt),Wl=a(e),Ze=p(e,"UL",{"data-svelte-h":!0}),m(Ze)!=="svelte-1q6gndt"&&(Ze.innerHTML=ut),vl=a(e),Ie=p(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-141yc6t"&&(Ie.innerHTML=yt),Vl=a(e),d(Be.$$.fragment,e),kl=a(e),ge=p(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-1nf2kxh"&&(ge.innerHTML=ft),Xl=a(e),d(Ge.$$.fragment,e),Yl=a(e),We=p(e,"P",{}),jt(We).forEach(t),this.h()},h(){Zt(i,"name","hf:doc:metadata"),Zt(i,"content",St)},m(e,l){_t(document.head,i),s(e,J,l),s(e,r,l),s(e,c,l),u(U,e,l),s(e,w,l),s(e,T,l),s(e,ve,l),u(I,e,l),s(e,Ve,l),s(e,W,l),s(e,ke,l),s(e,v,l),s(e,Xe,l),u(V,e,l),s(e,Ye,l),s(e,k,l),s(e,Re,l),s(e,X,l),s(e,$e,l),u(Y,e,l),s(e,Se,l),s(e,R,l),s(e,Ee,l),u($,e,l),s(e,Ne,l),s(e,S,l),s(e,He,l),s(e,E,l),s(e,Qe,l),u(N,e,l),s(e,xe,l),s(e,H,l),s(e,Fe,l),u(Q,e,l),s(e,ze,l),s(e,x,l),s(e,Ae,l),s(e,F,l),s(e,qe,l),u(z,e,l),s(e,Le,l),s(e,A,l),s(e,Pe,l),u(B,e,l),s(e,De,l),u(g,e,l),s(e,Ke,l),u(q,e,l),s(e,Oe,l),u(G,e,l),s(e,el,l),s(e,L,l),s(e,ll,l),s(e,P,l),s(e,tl,l),s(e,D,l),s(e,sl,l),s(e,K,l),s(e,nl,l),u(O,e,l),s(e,al,l),u(C,e,l),s(e,il,l),u(ee,e,l),s(e,ol,l),s(e,le,l),s(e,pl,l),s(e,te,l),s(e,ml,l),u(se,e,l),s(e,rl,l),s(e,ne,l),s(e,cl,l),u(ae,e,l),s(e,Ml,l),s(e,ie,l),s(e,dl,l),s(e,oe,l),s(e,ul,l),u(pe,e,l),s(e,yl,l),s(e,me,l),s(e,fl,l),s(e,re,l),s(e,hl,l),u(ce,e,l),s(e,wl,l),s(e,Me,l),s(e,Jl,l),s(e,de,l),s(e,Tl,l),u(ue,e,l),s(e,bl,l),u(ye,e,l),s(e,Ul,l),s(e,fe,l),s(e,jl,l),s(e,he,l),s(e,Zl,l),u(we,e,l),s(e,Il,l),s(e,Je,l),s(e,Bl,l),u(Te,e,l),s(e,gl,l),u(be,e,l),s(e,Gl,l),s(e,Ue,l),s(e,Cl,l),u(_,e,l),s(e,_l,l),s(e,je,l),s(e,Wl,l),s(e,Ze,l),s(e,vl,l),s(e,Ie,l),s(e,Vl,l),u(Be,e,l),s(e,kl,l),s(e,ge,l),s(e,Xl,l),u(Ge,e,l),s(e,Yl,l),s(e,We,l),Rl=!0},p(e,[l]){const ht={};l&2&&(ht.$$scope={dirty:l,ctx:e}),I.$set(ht);const wt={};l&2&&(wt.$$scope={dirty:l,ctx:e}),B.$set(wt);const Jt={};l&2&&(Jt.$$scope={dirty:l,ctx:e}),g.$set(Jt);const Tt={};l&2&&(Tt.$$scope={dirty:l,ctx:e}),G.$set(Tt);const bt={};l&2&&(bt.$$scope={dirty:l,ctx:e}),C.$set(bt);const Ut={};l&2&&(Ut.$$scope={dirty:l,ctx:e}),_.$set(Ut)},i(e){Rl||(y(U.$$.fragment,e),y(I.$$.fragment,e),y(V.$$.fragment,e),y(Y.$$.fragment,e),y($.$$.fragment,e),y(N.$$.fragment,e),y(Q.$$.fragment,e),y(z.$$.fragment,e),y(B.$$.fragment,e),y(g.$$.fragment,e),y(q.$$.fragment,e),y(G.$$.fragment,e),y(O.$$.fragment,e),y(C.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(ue.$$.fragment,e),y(ye.$$.fragment,e),y(we.$$.fragment,e),y(Te.$$.fragment,e),y(be.$$.fragment,e),y(_.$$.fragment,e),y(Be.$$.fragment,e),y(Ge.$$.fragment,e),Rl=!0)},o(e){f(U.$$.fragment,e),f(I.$$.fragment,e),f(V.$$.fragment,e),f(Y.$$.fragment,e),f($.$$.fragment,e),f(N.$$.fragment,e),f(Q.$$.fragment,e),f(z.$$.fragment,e),f(B.$$.fragment,e),f(g.$$.fragment,e),f(q.$$.fragment,e),f(G.$$.fragment,e),f(O.$$.fragment,e),f(C.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),f(ae.$$.fragment,e),f(pe.$$.fragment,e),f(ce.$$.fragment,e),f(ue.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(Te.$$.fragment,e),f(be.$$.fragment,e),f(_.$$.fragment,e),f(Be.$$.fragment,e),f(Ge.$$.fragment,e),Rl=!1},d(e){e&&(t(J),t(r),t(c),t(w),t(T),t(ve),t(Ve),t(W),t(ke),t(v),t(Xe),t(Ye),t(k),t(Re),t(X),t($e),t(Se),t(R),t(Ee),t(Ne),t(S),t(He),t(E),t(Qe),t(xe),t(H),t(Fe),t(ze),t(x),t(Ae),t(F),t(qe),t(Le),t(A),t(Pe),t(De),t(Ke),t(Oe),t(el),t(L),t(ll),t(P),t(tl),t(D),t(sl),t(K),t(nl),t(al),t(il),t(ol),t(le),t(pl),t(te),t(ml),t(rl),t(ne),t(cl),t(Ml),t(ie),t(dl),t(oe),t(ul),t(yl),t(me),t(fl),t(re),t(hl),t(wl),t(Me),t(Jl),t(de),t(Tl),t(bl),t(Ul),t(fe),t(jl),t(he),t(Zl),t(Il),t(Je),t(Bl),t(gl),t(Gl),t(Ue),t(Cl),t(_l),t(je),t(Wl),t(Ze),t(vl),t(Ie),t(Vl),t(kl),t(ge),t(Xl),t(Yl),t(We)),t(i),h(U,e),h(I,e),h(V,e),h(Y,e),h($,e),h(N,e),h(Q,e),h(z,e),h(B,e),h(g,e),h(q,e),h(G,e),h(O,e),h(C,e),h(ee,e),h(se,e),h(ae,e),h(pe,e),h(ce,e),h(ue,e),h(ye,e),h(we,e),h(Te,e),h(be,e),h(_,e),h(Be,e),h(Ge,e)}}}const St='{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[{"title":"Sliced VAE","local":"sliced-vae","sections":[],"depth":2},{"title":"Tiled VAE","local":"tiled-vae","sections":[],"depth":2},{"title":"CPU offloading","local":"cpu-offloading","sections":[],"depth":2},{"title":"Model offloading","local":"model-offloading","sections":[],"depth":2},{"title":"Group offloading","local":"group-offloading","sections":[],"depth":2},{"title":"FP8 layerwise weight-casting","local":"fp8-layerwise-weight-casting","sections":[],"depth":2},{"title":"Channels-last memory format","local":"channels-last-memory-format","sections":[],"depth":2},{"title":"Tracing","local":"tracing","sections":[],"depth":2},{"title":"Memory-efficient attention","local":"memory-efficient-attention","sections":[],"depth":2}],"depth":1}';function Et(b){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends gt{constructor(i){super(),Gt(this,i,Et,$t,It,{})}}export{zt as component};
