import{s as rs,o as ps,n as Yl}from"../chunks/scheduler.c57aa7ef.js";import{S as ds,i as ms,g as i,s as n,r as p,A as fs,h as o,f as a,c as s,j as os,u as d,x as r,k as El,y as hs,a as l,v as m,d as f,t as h,w as c}from"../chunks/index.394f8801.js";import{T as Fl}from"../chunks/Tip.23dfb1a9.js";import{C as M}from"../chunks/CodeBlock.5228ed01.js";import{H as y,E as cs}from"../chunks/EditOnGithub.157fddbf.js";function us(T){let u,b='For further instructions on using EVA, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/eva_finetuning" rel="nofollow">documentation</a>.';return{c(){u=i("p"),u.innerHTML=b},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-9hfq4t"&&(u.innerHTML=b)},m(w,g){l(w,u,g)},p:Yl,d(w){w&&a(u)}}}function Ms(T){let u,b='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){u=i("p"),u.innerHTML=b},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1nbpolx"&&(u.innerHTML=b)},m(w,g){l(w,u,g)},p:Yl,d(w){w&&a(u)}}}function ws(T){let u,b='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){u=i("p"),u.innerHTML=b},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-19y7vpj"&&(u.innerHTML=b)},m(w,g){l(w,u,g)},p:Yl,d(w){w&&a(u)}}}function ys(T){let u,b,w,g,v,Wt,$,ql='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Lt,k,Nl="This guide explores in more detail other options and features for using LoRA.",It,U,Gt,C,Sl='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',Vt,R,Pl='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',At,B,xt,W,Dl="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",Xt,L,Qt,I,zt,G,Kl='<a href="https://arxiv.org/abs/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',Ht,V,Ol="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",Et,A,Ft,x,en="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",Yt,X,qt,Q,tn='For detailed instruction on using PiSSA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',Nt,z,St,H,an=`<a href="https://arxiv.org/pdf/2406.05223" rel="nofollow">CorDA</a> builds task-aware LoRA adapters from weight decomposition oriented by the context of downstream task to learn (instruction-previewed mode, IPM) or world knowledge to maintain (knowledge-preserved mode, KPM).
The KPM not only achieves better performance than LoRA on fine-tuning tasks, but also mitigates the catastrophic forgetting of pre-trained world knowledge.
When preserving pre-trained knowledge is not a concern,
the IPM is favored because it can further accelerate convergence and enhance the fine-tuning performance.`,Pt,E,ln="You need to configure the initialization method to “corda”, and specify the mode of IPM or KPM and the dataset to collect covariance matrices.",Dt,F,Kt,Y,nn='For detailed instruction on using CorDA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/corda_finetuning" rel="nofollow">these instructions</a>.',Ot,q,ea,N,sn='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',ta,S,on="You just need to pass a single additional option to use OLoRA:",aa,P,la,D,rn='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',na,K,sa,O,pn='<a href="https://arxiv.org/pdf/2410.07170" rel="nofollow">EVA</a> performs SVD on the input activations of each layer and uses the right-singular vectors to initialize LoRA weights. It is therefore a data-driven initialization scheme. Furthermore EVA adaptively allocates ranks across layers based on their “explained variance ratio” - a metric derived from the SVD analysis.',ia,ee,dn='You can use EVA by setting <code>init_lora_weights=&quot;eva&quot;</code> and defining <a href="/docs/peft/main/en/package_reference/lora#peft.EvaConfig">EvaConfig</a> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>:',oa,te,ra,ae,mn="The parameter <code>rho</code> (≥ 1.0) determines how much redistribution is allowed. When <code>rho=1.0</code> and <code>r=16</code>, LoRA adapters are limited to exactly 16 ranks, preventing any redistribution from occurring. A recommended value for EVA with redistribution is 2.0, meaning the maximum rank allowed for a layer is 2r.",pa,le,fn='It is recommended to perform EVA initialization on a GPU as it is much faster. To optimize the amount of available memory for EVA, you can use the <code>low_cpu_mem_usage</code> flag in <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a>:',da,ne,ma,se,hn='Then, call <a href="/docs/peft/main/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> to initialize the EVA weights (in most cases the dataloader used for eva initialization can be the same as the one used for finetuning):',fa,ie,ha,oe,cn='EVA works out of the box with bitsandbytes. Simply initialize the model with <code>quantization_config</code> and call <a href="/docs/peft/main/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> as usual.',ca,J,ua,re,Ma,pe,wa,de,un='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',ya,me,Mn="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",ba,fe,ga,he,wn="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",Ta,ce,Ja,ue,yn='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',_a,Me,bn="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",ja,we,gn="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",Za,ye,Tn="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",va,_,$a,be,ka,ge,Jn='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Ua,Te,Ca,Je,Ra,_e,_n='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',Ba,je,Wa,Ze,jn="If parts of the model or the DoRA adapter are offloaded to CPU you can get a significant speedup at the cost of some temporary (ephemeral) VRAM overhead by using <code>ephemeral_gpu_offload=True</code> in <code>config.runtime_config</code>.",La,ve,Ia,$e,Zn="A <code>PeftModel</code> with a DoRA adapter can also be loaded with <code>ephemeral_gpu_offload=True</code> flag using the <code>from_pretrained</code> method as well as the <code>load_adapter</code> method.",Ga,ke,Va,Ue,vn=`DoRA is optimized (computes faster and takes less memory) for models in the evaluation mode, or when dropout is set to 0. We reuse the
base result at those times to get the speedup.
Running <a href="https://github.com/huggingface/peft/blob/main/examples/dora_finetuning/dora_finetuning.py" rel="nofollow">dora finetuning</a>
with <code>CUDA_VISIBLE_DEVICES=0 time python examples/dora_finetuning/dora_finetuning.py --quantize --lora_dropout 0 --batch_size 16 --eval_step 2 --use_dora</code>
on a 4090 with gradient accumulation set to 2 and max step to 20 resulted with the following observations:`,Aa,Ce,$n='<thead><tr><th align="center"></th> <th align="center">Without Optimization</th> <th align="center">With Optimization</th></tr></thead> <tbody><tr><td align="center">train_runtime</td> <td align="center">359.7298</td> <td align="center"><strong>279.2676</strong></td></tr> <tr><td align="center">train_samples_per_second</td> <td align="center">1.779</td> <td align="center"><strong>2.292</strong></td></tr> <tr><td align="center">train_steps_per_second</td> <td align="center">0.056</td> <td align="center"><strong>0.072</strong></td></tr></tbody>',xa,Re,Xa,Be,kn='<li>DoRA only supports embedding, linear, and Conv2d layers at the moment.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Qa,We,za,Le,Un='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Ha,Ie,Ea,Ge,Fa,Ve,Cn='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Ya,Ae,qa,xe,Rn='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adapters.',Na,Xe,Bn=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,Sa,Qe,Pa,ze,Wn="LoRA training can optionally include special purpose optimizers. Currently the only such optimizer is LoRA+.",Da,He,Ka,Ee,Ln='LoRA training can be optimized using <a href="https://arxiv.org/abs/2402.12354" rel="nofollow">LoRA+</a>, which uses different learning rates for the adapter matrices A and B, shown to increase finetuning speed by up to 2x and performance by 1-2%.',Oa,Fe,el,Ye,tl,qe,In='Sometimes it is necessary to not only change some layer’s weights but to add new tokens as well. With larger models this can be a memory-costly endeavour. PEFT LoRA adapters support the <code>trainable_token_indices</code> parameter which allows tuning of other tokens alongside fine-tuning of specific layers with LoRA. This method only trains the tokens you specify and leaves all other tokens untouched. This saves memory and doesn’t throw away learned context of existing token embeddings in contrast to when training the whole embedding matrix. Under the hood this method uses the layer of <a href="/docs/peft/main/en/package_reference/trainable_tokens#peft.TrainableTokensModel">TrainableTokensModel</a>.',al,Ne,ll,Se,Gn="In the snippet below we show how to add new tokens to the model and how to train it alongside the other layers in the model.",nl,Pe,sl,De,Vn=`The token weights are part of your adapter state dict and saved alongside the LoRA weights.
If we would have used full fine-tuning with <code>modules_to_save=[&#39;embed_tokens&#39;]</code> we would have stored the full embedding matrix in the checkpoint, leading to a much bigger file.`,il,Ke,An="To give a bit of an indication how much VRAM can be saved, a rudimentary comparison of the above example was made between training the embedding matrix fully (<code>modules_to_save=[&quot;embed_tokens&quot;]</code>), using a LoRA for the embedding matrix (<code>target_modules=[..., &quot;embed_tokens&quot;]</code>, rank 32) and trainable tokens (<code>trainable_token_indices=[...]</code>, 6 tokens). Trainable tokens used about as much VRAM (15,562MB vs. 15,581MB) as LoRA while being specific to the tokens and saved ~1GB of VRAM over fully training the embedding matrix.",ol,Oe,rl,et,xn='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',pl,tt,Xn="Below is a diagram that explains the intuition of LoRA adapter merging:",dl,j,Qn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',ml,at,zn="We show in the snippets below how to run that using PEFT.",fl,lt,hl,nt,Hn='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',cl,st,ul,it,En='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',Ml,ot,Fn="First load the base model:",wl,rt,yl,pt,Yn="Then we load the first adapter:",bl,dt,gl,mt,qn="Then load a different adapter and merge it with the first one:",Tl,ft,Jl,Z,_l,ht,Nn="Now, perform inference:",jl,ct,Zl,ut,vl,Mt,Sn='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',$l,wt,kl,yt,Pn='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',Ul,bt,Cl,gt,Rl,Tt,Dn="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",Bl,Jt,Kn="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an example of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",Wl,_t,Ll,jt,On="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",Il,Zt,Gl,vt,es="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",Vl,$t,ts="Additionally, the same approach also works with the <code>modules_to_save</code> feature, which allows for saving and reusing specific neural network layers, such as custom heads for classification tasks, across different LoRA adapters.",Al,kt,xl,Ut,as="Using this features has some drawbacks, namely:",Xl,Ct,ls='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>The <code>modules_to_save</code> feature is currently only supported for the layers of types <code>Linear</code>, <code>Embedding</code>, <code>Conv2d</code> and <code>Conv1d</code>.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',Ql,Rt,zl,Bt,Hl;return v=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),U=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),B=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),L=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),I=new y({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),A=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),X=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLik=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...)',wrap:!1}}),z=new y({props:{title:"CorDA",local:"corda",headingTag:"h3"}}),F=new M({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwcnVuX21vZGVsKCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBc3N1bWUlMjAlNjBtb2RlbCU2MCUyMGFuZCUyMCU2MGRhdGFzZXQlNjAlMjBpcyUyMGluJTIwY29udGV4dC4uLiUwQSUyMCUyMCUyMCUyMG1vZGVsLmV2YWwoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwoKipiYXRjaCklMEElMEElMEFjb3JkYV9jb25maWclMjAlM0QlMjBDb3JkYUNvbmZpZyglMEElMjAlMjAlMjAlMjBjb3JkYV9tZXRob2QlM0QlMjJrcG0lMjIlMkMlMEEpJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIyY29yZGElMjIlMkMlMEElMjAlMjAlMjAlMjBjb3JkYV9jb25maWclM0Rjb3JkYV9jb25maWclMkMlMEEpJTBBcHJlcHJvY2Vzc19jb3JkYShtb2RlbCUyQyUyMGxvcmFfY29uZmlnJTJDJTIwcnVuX21vZGVsJTNEcnVuX21vZGVsKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGxvcmFfY29uZmlnKQ==",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_model</span>():
    <span class="hljs-comment"># Assume \`model\` and \`dataset\` is in context...</span>
    model.<span class="hljs-built_in">eval</span>()
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataset:
        model(**batch)


corda_config = CordaConfig(
    corda_method=<span class="hljs-string">&quot;kpm&quot;</span>,
)
lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;corda&quot;</span>,
    corda_config=corda_config,
)
preprocess_corda(model, lora_config, run_model=run_model)
peft_model = get_peft_model(model, lora_config)`,wrap:!1}}),q=new y({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),P=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),K=new y({props:{title:"EVA",local:"eva",headingTag:"h3"}}),te=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwRXZhQ29uZmlnJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTIwJTNEJTIwJTIyZXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXZhX2NvbmZpZyUyMCUzRCUyMEV2YUNvbmZpZyhyaG8lMjAlM0QlMjAyLjApJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, EvaConfig
peft_config = LoraConfig(
    init_lora_weights = <span class="hljs-string">&quot;eva&quot;</span>,
    eva_config = EvaConfig(rho = <span class="hljs-number">2.0</span>),
    ...
)`,wrap:!1}}),ne=new M({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwcGVmdF9jb25maWclMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:'peft_model = get_peft_model(model, peft_config, low_cpu_mem_usage=<span class="hljs-literal">True</span>)',wrap:!1}}),ie=new M({props:{code:"aW5pdGlhbGl6ZV9sb3JhX2V2YV93ZWlnaHRzKHBlZnRfbW9kZWwlMkMlMjBkYXRhbG9hZGVyKQ==",highlighted:"initialize_lora_eva_weights(peft_model, dataloader)",wrap:!1}}),J=new Fl({props:{$$slots:{default:[us]},$$scope:{ctx:T}}}),re=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),pe=new y({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),fe=new y({props:{title:"A more convenient way",local:"a-more-convenient-way",headingTag:"h4"}}),ce=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),_=new Fl({props:{$$slots:{default:[Ms]},$$scope:{ctx:T}}}),be=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),Te=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),Je=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),je=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),ve=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwTG9yYVJ1bnRpbWVDb25maWclMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHVzZV9kb3JhJTNEVHJ1ZSUyQyUyMHJ1bnRpbWVfY29uZmlnJTNETG9yYVJ1bnRpbWVDb25maWcoZXBoZW1lcmFsX2dwdV9vZmZsb2FkJTNEVHJ1ZSklMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, LoraRuntimeConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, runtime_config=LoraRuntimeConfig(ephemeral_gpu_offload=<span class="hljs-literal">True</span>), ...)`,wrap:!1}}),ke=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQlMkMlMjBlcGhlbWVyYWxfZ3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model = PeftModel.from_pretrained(base_model, peft_model_id, ephemeral_gpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),Re=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),We=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),Ie=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),Ge=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),Ae=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),Qe=new y({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),He=new y({props:{title:"LoRA+ optimized LoRA",local:"lora-optimized-lora",headingTag:"h3"}}),Fe=new M({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_loraplus_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

base_model = ...
config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_loraplus_optimizer(
    model=model,
    optimizer_cls=bnb.optim.Adam8bit,
    lr=<span class="hljs-number">5e-5</span>,
    loraplus_lr_ratio=<span class="hljs-number">16</span>,
)
scheduler = <span class="hljs-literal">None</span>

...
trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),Ye=new y({props:{title:"Efficiently train tokens alongside LoRA",local:"efficiently-train-tokens-alongside-lora",headingTag:"h2"}}),Ne=new M({props:{code:"JTIzJTIwZm9yJTIwbGF5ZXIlMjAnZW1iZWRfdG9rZW5zJyUwQWNvbmZpZyUyMCUzRCUyMExvcmFDb25maWcodHJhaW5hYmxlX3Rva2VuX2luZGljZXMlM0QlNUJpZHhfMSUyQyUyMGlkeF8yJTJDJTIwLi4uJTVEJTJDJTIwLi4uKSUwQSUwQSUyMyUyMHNwZWNpZmljJTIwZW1iZWRkaW5nJTIwbGF5ZXIlMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTNEJTdCJ2VtYl90b2tlbnMnJTNBJTIwJTVCaWR4XzElMkMlMjBpZHhfMiUyQyUyMC4uLiU1RCU3RCUyQyUyMC4uLik=",highlighted:`<span class="hljs-comment"># for layer &#x27;embed_tokens&#x27;</span>
config = LoraConfig(trainable_token_indices=[idx_1, idx_2, ...], ...)

<span class="hljs-comment"># specific embedding layer</span>
config = LoraConfig(trainable_token_indices={<span class="hljs-string">&#x27;emb_tokens&#x27;</span>: [idx_1, idx_2, ...]}, ...)`,wrap:!1}}),Pe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQSUyMyUyMHdlJTIwZGVmaW5lJTIwb3VyJTIwbmV3JTIwdG9rZW5zJTIwYW5kJTIwYWRkJTIwdGhlbSUyMHRvJTIwdGhlJTIwdG9rZW5pemVyJTIwYXMlMjBzcGVjaWFsJTIwdG9rZW5zJTBBc3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUInJTNDJTdDc3RhcnRfdGhpbmslN0MlM0UnJTJDJTIwJyUzQyU3Q3N0b3BfdGhpbmslN0MlM0UnJTVEJTBBdG9rZW5pemVyLmFkZF9zcGVjaWFsX3Rva2VucyglN0InYWRkaXRpb25hbF9zcGVjaWFsX3Rva2VucyclM0ElMjBzcGVjaWFsX3Rva2VucyU3RCklMEElMEElMjMlMjBtYWtlJTIwcm9vbSUyMGZvciUyMG5ldyUyMHRva2VucyUyMGluJTIwdGhlJTIwZW1iZWRkaW5nJTIwbWF0cml4JTIwaWYlMjBpdCUyMGlzbid0JTIwYmlnJTIwZW5vdWdoJTIwYWxyZWFkeSUwQWJhc2VfbW9kZWwucmVzaXplX3Rva2VuX2VtYmVkZGluZ3MobWF4KGxlbih0b2tlbml6ZXIpJTJDJTIwYmFzZV9tb2RlbC5tb2RlbC5lbWJlZF90b2tlbnMubnVtX2VtYmVkZGluZ3MpJTBBJTBBJTIzJTIwdHlwaWNhbCUyMExvUkElMjBjb25maWclMjB3aXRoJTIwJTYwdHJhaW5hYmxlX3Rva2VuX2luZGljZXMlNjAlMjB0YXJnZXRpbmclMjBlbWJlZGRpbmclMjBsYXllciUyMCU2MGVtYmVkX3Rva2VucyU2MCUwQSUyMyUyMGFuZCUyMHNwZWNpZmljYWxseSUyMG91ciUyMG5ldyUyMHRva2VucyUyMHdlJTIwanVzdCUyMGFkZGVkJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJ2FsbC1saW5lYXInJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5hYmxlX3Rva2VuX2luZGljZXMlM0QlN0InZW1iZWRfdG9rZW5zJyUzQSUyMHRva2VuaXplci5jb252ZXJ0X3Rva2Vuc190b19pZHMoc3BlY2lhbF90b2tlbnMpJTdEJTJDJTBBKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwbG9yYV9jb25maWcpJTBBJTBBJTIzJTIwcHJvY2VlZCUyMHRvJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUyMGxpa2UlMjBub3JtYWwlMEElNUIuLi4lNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

<span class="hljs-comment"># we define our new tokens and add them to the tokenizer as special tokens</span>
special_tokens = [<span class="hljs-string">&#x27;&lt;|start_think|&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;|stop_think|&gt;&#x27;</span>]
tokenizer.add_special_tokens({<span class="hljs-string">&#x27;additional_special_tokens&#x27;</span>: special_tokens})

<span class="hljs-comment"># make room for new tokens in the embedding matrix if it isn&#x27;t big enough already</span>
base_model.resize_token_embeddings(<span class="hljs-built_in">max</span>(<span class="hljs-built_in">len</span>(tokenizer), base_model.model.embed_tokens.num_embeddings)

<span class="hljs-comment"># typical LoRA config with \`trainable_token_indices\` targeting embedding layer \`embed_tokens\`</span>
<span class="hljs-comment"># and specifically our new tokens we just added</span>
lora_config = LoraConfig(
    target_modules=<span class="hljs-string">&#x27;all-linear&#x27;</span>,
    trainable_token_indices={<span class="hljs-string">&#x27;embed_tokens&#x27;</span>: tokenizer.convert_tokens_to_ids(special_tokens)},
)
peft_model = get_peft_model(base_model, lora_config)

<span class="hljs-comment"># proceed to train the model like normal</span>
[...]`,wrap:!1}}),Oe=new y({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),lt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),st=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),rt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),dt=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),ft=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),Z=new Fl({props:{$$slots:{default:[ws]},$$scope:{ctx:T}}}),ct=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),ut=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),wt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),bt=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),gt=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),_t=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),Zt=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),kt=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),Rt=new cs({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){u=i("meta"),b=n(),w=i("p"),g=n(),p(v.$$.fragment),Wt=n(),$=i("p"),$.innerHTML=ql,Lt=n(),k=i("p"),k.textContent=Nl,It=n(),p(U.$$.fragment),Gt=n(),C=i("p"),C.innerHTML=Sl,Vt=n(),R=i("p"),R.innerHTML=Pl,At=n(),p(B.$$.fragment),xt=n(),W=i("p"),W.innerHTML=Dl,Xt=n(),p(L.$$.fragment),Qt=n(),p(I.$$.fragment),zt=n(),G=i("p"),G.innerHTML=Kl,Ht=n(),V=i("p"),V.textContent=Ol,Et=n(),p(A.$$.fragment),Ft=n(),x=i("p"),x.textContent=en,Yt=n(),p(X.$$.fragment),qt=n(),Q=i("p"),Q.innerHTML=tn,Nt=n(),p(z.$$.fragment),St=n(),H=i("p"),H.innerHTML=an,Pt=n(),E=i("p"),E.textContent=ln,Dt=n(),p(F.$$.fragment),Kt=n(),Y=i("p"),Y.innerHTML=nn,Ot=n(),p(q.$$.fragment),ea=n(),N=i("p"),N.innerHTML=sn,ta=n(),S=i("p"),S.textContent=on,aa=n(),p(P.$$.fragment),la=n(),D=i("p"),D.innerHTML=rn,na=n(),p(K.$$.fragment),sa=n(),O=i("p"),O.innerHTML=pn,ia=n(),ee=i("p"),ee.innerHTML=dn,oa=n(),p(te.$$.fragment),ra=n(),ae=i("p"),ae.innerHTML=mn,pa=n(),le=i("p"),le.innerHTML=fn,da=n(),p(ne.$$.fragment),ma=n(),se=i("p"),se.innerHTML=hn,fa=n(),p(ie.$$.fragment),ha=n(),oe=i("p"),oe.innerHTML=cn,ca=n(),p(J.$$.fragment),ua=n(),p(re.$$.fragment),Ma=n(),p(pe.$$.fragment),wa=n(),de=i("p"),de.innerHTML=un,ya=n(),me=i("p"),me.innerHTML=Mn,ba=n(),p(fe.$$.fragment),ga=n(),he=i("p"),he.innerHTML=wn,Ta=n(),p(ce.$$.fragment),Ja=n(),ue=i("p"),ue.innerHTML=yn,_a=n(),Me=i("p"),Me.innerHTML=bn,ja=n(),we=i("p"),we.innerHTML=gn,Za=n(),ye=i("ul"),ye.innerHTML=Tn,va=n(),p(_.$$.fragment),$a=n(),p(be.$$.fragment),ka=n(),ge=i("p"),ge.innerHTML=Jn,Ua=n(),p(Te.$$.fragment),Ca=n(),p(Je.$$.fragment),Ra=n(),_e=i("p"),_e.innerHTML=_n,Ba=n(),p(je.$$.fragment),Wa=n(),Ze=i("p"),Ze.innerHTML=jn,La=n(),p(ve.$$.fragment),Ia=n(),$e=i("p"),$e.innerHTML=Zn,Ga=n(),p(ke.$$.fragment),Va=n(),Ue=i("p"),Ue.innerHTML=vn,Aa=n(),Ce=i("table"),Ce.innerHTML=$n,xa=n(),p(Re.$$.fragment),Xa=n(),Be=i("ul"),Be.innerHTML=kn,Qa=n(),p(We.$$.fragment),za=n(),Le=i("p"),Le.innerHTML=Un,Ha=n(),p(Ie.$$.fragment),Ea=n(),p(Ge.$$.fragment),Fa=n(),Ve=i("p"),Ve.innerHTML=Cn,Ya=n(),p(Ae.$$.fragment),qa=n(),xe=i("p"),xe.innerHTML=Rn,Na=n(),Xe=i("p"),Xe.innerHTML=Bn,Sa=n(),p(Qe.$$.fragment),Pa=n(),ze=i("p"),ze.textContent=Wn,Da=n(),p(He.$$.fragment),Ka=n(),Ee=i("p"),Ee.innerHTML=Ln,Oa=n(),p(Fe.$$.fragment),el=n(),p(Ye.$$.fragment),tl=n(),qe=i("p"),qe.innerHTML=In,al=n(),p(Ne.$$.fragment),ll=n(),Se=i("p"),Se.textContent=Gn,nl=n(),p(Pe.$$.fragment),sl=n(),De=i("p"),De.innerHTML=Vn,il=n(),Ke=i("p"),Ke.innerHTML=An,ol=n(),p(Oe.$$.fragment),rl=n(),et=i("p"),et.innerHTML=xn,pl=n(),tt=i("p"),tt.textContent=Xn,dl=n(),j=i("div"),j.innerHTML=Qn,ml=n(),at=i("p"),at.textContent=zn,fl=n(),p(lt.$$.fragment),hl=n(),nt=i("p"),nt.innerHTML=Hn,cl=n(),p(st.$$.fragment),ul=n(),it=i("p"),it.innerHTML=En,Ml=n(),ot=i("p"),ot.textContent=Fn,wl=n(),p(rt.$$.fragment),yl=n(),pt=i("p"),pt.textContent=Yn,bl=n(),p(dt.$$.fragment),gl=n(),mt=i("p"),mt.textContent=qn,Tl=n(),p(ft.$$.fragment),Jl=n(),p(Z.$$.fragment),_l=n(),ht=i("p"),ht.textContent=Nn,jl=n(),p(ct.$$.fragment),Zl=n(),p(ut.$$.fragment),vl=n(),Mt=i("p"),Mt.innerHTML=Sn,$l=n(),p(wt.$$.fragment),kl=n(),yt=i("p"),yt.innerHTML=Pn,Ul=n(),p(bt.$$.fragment),Cl=n(),p(gt.$$.fragment),Rl=n(),Tt=i("p"),Tt.textContent=Dn,Bl=n(),Jt=i("p"),Jt.innerHTML=Kn,Wl=n(),p(_t.$$.fragment),Ll=n(),jt=i("p"),jt.innerHTML=On,Il=n(),p(Zt.$$.fragment),Gl=n(),vt=i("p"),vt.innerHTML=es,Vl=n(),$t=i("p"),$t.innerHTML=ts,Al=n(),p(kt.$$.fragment),xl=n(),Ut=i("p"),Ut.textContent=as,Xl=n(),Ct=i("ul"),Ct.innerHTML=ls,Ql=n(),p(Rt.$$.fragment),zl=n(),Bt=i("p"),this.h()},l(e){const t=fs("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(a),b=s(e),w=o(e,"P",{}),os(w).forEach(a),g=s(e),d(v.$$.fragment,e),Wt=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-38uxl6"&&($.innerHTML=ql),Lt=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-ovsn32"&&(k.textContent=Nl),It=s(e),d(U.$$.fragment,e),Gt=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-j883mf"&&(C.innerHTML=Sl),Vt=s(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1fujb7a"&&(R.innerHTML=Pl),At=s(e),d(B.$$.fragment,e),xt=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-mwvui1"&&(W.innerHTML=Dl),Xt=s(e),d(L.$$.fragment,e),Qt=s(e),d(I.$$.fragment,e),zt=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-p4dbd4"&&(G.innerHTML=Kl),Ht=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1hy0lgx"&&(V.textContent=Ol),Et=s(e),d(A.$$.fragment,e),Ft=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-auzrbb"&&(x.textContent=en),Yt=s(e),d(X.$$.fragment,e),qt=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-16k39wq"&&(Q.innerHTML=tn),Nt=s(e),d(z.$$.fragment,e),St=s(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-15qnrt6"&&(H.innerHTML=an),Pt=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1s3c5rd"&&(E.textContent=ln),Dt=s(e),d(F.$$.fragment,e),Kt=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-19qemwc"&&(Y.innerHTML=nn),Ot=s(e),d(q.$$.fragment,e),ea=s(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-17kc0j8"&&(N.innerHTML=sn),ta=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1j9g8qn"&&(S.textContent=on),aa=s(e),d(P.$$.fragment,e),la=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-sulxp4"&&(D.innerHTML=rn),na=s(e),d(K.$$.fragment,e),sa=s(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-jrbt6r"&&(O.innerHTML=pn),ia=s(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1gqkzq0"&&(ee.innerHTML=dn),oa=s(e),d(te.$$.fragment,e),ra=s(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-168zxvb"&&(ae.innerHTML=mn),pa=s(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-z4d0cr"&&(le.innerHTML=fn),da=s(e),d(ne.$$.fragment,e),ma=s(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-8ll8w8"&&(se.innerHTML=hn),fa=s(e),d(ie.$$.fragment,e),ha=s(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-ryiojp"&&(oe.innerHTML=cn),ca=s(e),d(J.$$.fragment,e),ua=s(e),d(re.$$.fragment,e),Ma=s(e),d(pe.$$.fragment,e),wa=s(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1ts8vpq"&&(de.innerHTML=un),ya=s(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-7f0aai"&&(me.innerHTML=Mn),ba=s(e),d(fe.$$.fragment,e),ga=s(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-14vtcq9"&&(he.innerHTML=wn),Ta=s(e),d(ce.$$.fragment,e),Ja=s(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1nywyxh"&&(ue.innerHTML=yn),_a=s(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1d2jix1"&&(Me.innerHTML=bn),ja=s(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-yl8kok"&&(we.innerHTML=gn),Za=s(e),ye=o(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-12tl4fy"&&(ye.innerHTML=Tn),va=s(e),d(_.$$.fragment,e),$a=s(e),d(be.$$.fragment,e),ka=s(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-omuw13"&&(ge.innerHTML=Jn),Ua=s(e),d(Te.$$.fragment,e),Ca=s(e),d(Je.$$.fragment,e),Ra=s(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1ukfkwt"&&(_e.innerHTML=_n),Ba=s(e),d(je.$$.fragment,e),Wa=s(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-8wzhde"&&(Ze.innerHTML=jn),La=s(e),d(ve.$$.fragment,e),Ia=s(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-16lyt50"&&($e.innerHTML=Zn),Ga=s(e),d(ke.$$.fragment,e),Va=s(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-zr3cxq"&&(Ue.innerHTML=vn),Aa=s(e),Ce=o(e,"TABLE",{"data-svelte-h":!0}),r(Ce)!=="svelte-1iyfgt7"&&(Ce.innerHTML=$n),xa=s(e),d(Re.$$.fragment,e),Xa=s(e),Be=o(e,"UL",{"data-svelte-h":!0}),r(Be)!=="svelte-1nce7z9"&&(Be.innerHTML=kn),Qa=s(e),d(We.$$.fragment,e),za=s(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-15vxux2"&&(Le.innerHTML=Un),Ha=s(e),d(Ie.$$.fragment,e),Ea=s(e),d(Ge.$$.fragment,e),Fa=s(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1mosto0"&&(Ve.innerHTML=Cn),Ya=s(e),d(Ae.$$.fragment,e),qa=s(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1ttqqw0"&&(xe.innerHTML=Rn),Na=s(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-foj0wd"&&(Xe.innerHTML=Bn),Sa=s(e),d(Qe.$$.fragment,e),Pa=s(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-rkzqzi"&&(ze.textContent=Wn),Da=s(e),d(He.$$.fragment,e),Ka=s(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-9dmo2s"&&(Ee.innerHTML=Ln),Oa=s(e),d(Fe.$$.fragment,e),el=s(e),d(Ye.$$.fragment,e),tl=s(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-iri31w"&&(qe.innerHTML=In),al=s(e),d(Ne.$$.fragment,e),ll=s(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-66nz7l"&&(Se.textContent=Gn),nl=s(e),d(Pe.$$.fragment,e),sl=s(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-32mf1g"&&(De.innerHTML=Vn),il=s(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-sspyjf"&&(Ke.innerHTML=An),ol=s(e),d(Oe.$$.fragment,e),rl=s(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1c3h9aa"&&(et.innerHTML=xn),pl=s(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1wwmf5r"&&(tt.textContent=Xn),dl=s(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1f6iuw5"&&(j.innerHTML=Qn),ml=s(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-hlzwis"&&(at.textContent=zn),fl=s(e),d(lt.$$.fragment,e),hl=s(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-m3cr6r"&&(nt.innerHTML=Hn),cl=s(e),d(st.$$.fragment,e),ul=s(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-kbqhpl"&&(it.innerHTML=En),Ml=s(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1mwdwt1"&&(ot.textContent=Fn),wl=s(e),d(rt.$$.fragment,e),yl=s(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1lnmg1d"&&(pt.textContent=Yn),bl=s(e),d(dt.$$.fragment,e),gl=s(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1n53hd9"&&(mt.textContent=qn),Tl=s(e),d(ft.$$.fragment,e),Jl=s(e),d(Z.$$.fragment,e),_l=s(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-qwbdkg"&&(ht.textContent=Nn),jl=s(e),d(ct.$$.fragment,e),Zl=s(e),d(ut.$$.fragment,e),vl=s(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-ke62q2"&&(Mt.innerHTML=Sn),$l=s(e),d(wt.$$.fragment,e),kl=s(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-cvmoj6"&&(yt.innerHTML=Pn),Ul=s(e),d(bt.$$.fragment,e),Cl=s(e),d(gt.$$.fragment,e),Rl=s(e),Tt=o(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1fq5tpu"&&(Tt.textContent=Dn),Bl=s(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-lcywla"&&(Jt.innerHTML=Kn),Wl=s(e),d(_t.$$.fragment,e),Ll=s(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-6wkyom"&&(jt.innerHTML=On),Il=s(e),d(Zt.$$.fragment,e),Gl=s(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1o40ch6"&&(vt.innerHTML=es),Vl=s(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-mqf2jo"&&($t.innerHTML=ts),Al=s(e),d(kt.$$.fragment,e),xl=s(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-fpz5mj"&&(Ut.textContent=as),Xl=s(e),Ct=o(e,"UL",{"data-svelte-h":!0}),r(Ct)!=="svelte-150o10n"&&(Ct.innerHTML=ls),Ql=s(e),d(Rt.$$.fragment,e),zl=s(e),Bt=o(e,"P",{}),os(Bt).forEach(a),this.h()},h(){El(u,"name","hf:doc:metadata"),El(u,"content",bs),El(j,"class","flex justify-center")},m(e,t){hs(document.head,u),l(e,b,t),l(e,w,t),l(e,g,t),m(v,e,t),l(e,Wt,t),l(e,$,t),l(e,Lt,t),l(e,k,t),l(e,It,t),m(U,e,t),l(e,Gt,t),l(e,C,t),l(e,Vt,t),l(e,R,t),l(e,At,t),m(B,e,t),l(e,xt,t),l(e,W,t),l(e,Xt,t),m(L,e,t),l(e,Qt,t),m(I,e,t),l(e,zt,t),l(e,G,t),l(e,Ht,t),l(e,V,t),l(e,Et,t),m(A,e,t),l(e,Ft,t),l(e,x,t),l(e,Yt,t),m(X,e,t),l(e,qt,t),l(e,Q,t),l(e,Nt,t),m(z,e,t),l(e,St,t),l(e,H,t),l(e,Pt,t),l(e,E,t),l(e,Dt,t),m(F,e,t),l(e,Kt,t),l(e,Y,t),l(e,Ot,t),m(q,e,t),l(e,ea,t),l(e,N,t),l(e,ta,t),l(e,S,t),l(e,aa,t),m(P,e,t),l(e,la,t),l(e,D,t),l(e,na,t),m(K,e,t),l(e,sa,t),l(e,O,t),l(e,ia,t),l(e,ee,t),l(e,oa,t),m(te,e,t),l(e,ra,t),l(e,ae,t),l(e,pa,t),l(e,le,t),l(e,da,t),m(ne,e,t),l(e,ma,t),l(e,se,t),l(e,fa,t),m(ie,e,t),l(e,ha,t),l(e,oe,t),l(e,ca,t),m(J,e,t),l(e,ua,t),m(re,e,t),l(e,Ma,t),m(pe,e,t),l(e,wa,t),l(e,de,t),l(e,ya,t),l(e,me,t),l(e,ba,t),m(fe,e,t),l(e,ga,t),l(e,he,t),l(e,Ta,t),m(ce,e,t),l(e,Ja,t),l(e,ue,t),l(e,_a,t),l(e,Me,t),l(e,ja,t),l(e,we,t),l(e,Za,t),l(e,ye,t),l(e,va,t),m(_,e,t),l(e,$a,t),m(be,e,t),l(e,ka,t),l(e,ge,t),l(e,Ua,t),m(Te,e,t),l(e,Ca,t),m(Je,e,t),l(e,Ra,t),l(e,_e,t),l(e,Ba,t),m(je,e,t),l(e,Wa,t),l(e,Ze,t),l(e,La,t),m(ve,e,t),l(e,Ia,t),l(e,$e,t),l(e,Ga,t),m(ke,e,t),l(e,Va,t),l(e,Ue,t),l(e,Aa,t),l(e,Ce,t),l(e,xa,t),m(Re,e,t),l(e,Xa,t),l(e,Be,t),l(e,Qa,t),m(We,e,t),l(e,za,t),l(e,Le,t),l(e,Ha,t),m(Ie,e,t),l(e,Ea,t),m(Ge,e,t),l(e,Fa,t),l(e,Ve,t),l(e,Ya,t),m(Ae,e,t),l(e,qa,t),l(e,xe,t),l(e,Na,t),l(e,Xe,t),l(e,Sa,t),m(Qe,e,t),l(e,Pa,t),l(e,ze,t),l(e,Da,t),m(He,e,t),l(e,Ka,t),l(e,Ee,t),l(e,Oa,t),m(Fe,e,t),l(e,el,t),m(Ye,e,t),l(e,tl,t),l(e,qe,t),l(e,al,t),m(Ne,e,t),l(e,ll,t),l(e,Se,t),l(e,nl,t),m(Pe,e,t),l(e,sl,t),l(e,De,t),l(e,il,t),l(e,Ke,t),l(e,ol,t),m(Oe,e,t),l(e,rl,t),l(e,et,t),l(e,pl,t),l(e,tt,t),l(e,dl,t),l(e,j,t),l(e,ml,t),l(e,at,t),l(e,fl,t),m(lt,e,t),l(e,hl,t),l(e,nt,t),l(e,cl,t),m(st,e,t),l(e,ul,t),l(e,it,t),l(e,Ml,t),l(e,ot,t),l(e,wl,t),m(rt,e,t),l(e,yl,t),l(e,pt,t),l(e,bl,t),m(dt,e,t),l(e,gl,t),l(e,mt,t),l(e,Tl,t),m(ft,e,t),l(e,Jl,t),m(Z,e,t),l(e,_l,t),l(e,ht,t),l(e,jl,t),m(ct,e,t),l(e,Zl,t),m(ut,e,t),l(e,vl,t),l(e,Mt,t),l(e,$l,t),m(wt,e,t),l(e,kl,t),l(e,yt,t),l(e,Ul,t),m(bt,e,t),l(e,Cl,t),m(gt,e,t),l(e,Rl,t),l(e,Tt,t),l(e,Bl,t),l(e,Jt,t),l(e,Wl,t),m(_t,e,t),l(e,Ll,t),l(e,jt,t),l(e,Il,t),m(Zt,e,t),l(e,Gl,t),l(e,vt,t),l(e,Vl,t),l(e,$t,t),l(e,Al,t),m(kt,e,t),l(e,xl,t),l(e,Ut,t),l(e,Xl,t),l(e,Ct,t),l(e,Ql,t),m(Rt,e,t),l(e,zl,t),l(e,Bt,t),Hl=!0},p(e,[t]){const ns={};t&2&&(ns.$$scope={dirty:t,ctx:e}),J.$set(ns);const ss={};t&2&&(ss.$$scope={dirty:t,ctx:e}),_.$set(ss);const is={};t&2&&(is.$$scope={dirty:t,ctx:e}),Z.$set(is)},i(e){Hl||(f(v.$$.fragment,e),f(U.$$.fragment,e),f(B.$$.fragment,e),f(L.$$.fragment,e),f(I.$$.fragment,e),f(A.$$.fragment,e),f(X.$$.fragment,e),f(z.$$.fragment,e),f(F.$$.fragment,e),f(q.$$.fragment,e),f(P.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(ie.$$.fragment,e),f(J.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(fe.$$.fragment,e),f(ce.$$.fragment,e),f(_.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(Je.$$.fragment,e),f(je.$$.fragment,e),f(ve.$$.fragment,e),f(ke.$$.fragment,e),f(Re.$$.fragment,e),f(We.$$.fragment,e),f(Ie.$$.fragment,e),f(Ge.$$.fragment,e),f(Ae.$$.fragment,e),f(Qe.$$.fragment,e),f(He.$$.fragment,e),f(Fe.$$.fragment,e),f(Ye.$$.fragment,e),f(Ne.$$.fragment,e),f(Pe.$$.fragment,e),f(Oe.$$.fragment,e),f(lt.$$.fragment,e),f(st.$$.fragment,e),f(rt.$$.fragment,e),f(dt.$$.fragment,e),f(ft.$$.fragment,e),f(Z.$$.fragment,e),f(ct.$$.fragment,e),f(ut.$$.fragment,e),f(wt.$$.fragment,e),f(bt.$$.fragment,e),f(gt.$$.fragment,e),f(_t.$$.fragment,e),f(Zt.$$.fragment,e),f(kt.$$.fragment,e),f(Rt.$$.fragment,e),Hl=!0)},o(e){h(v.$$.fragment,e),h(U.$$.fragment,e),h(B.$$.fragment,e),h(L.$$.fragment,e),h(I.$$.fragment,e),h(A.$$.fragment,e),h(X.$$.fragment,e),h(z.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(J.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(fe.$$.fragment,e),h(ce.$$.fragment,e),h(_.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(ve.$$.fragment,e),h(ke.$$.fragment,e),h(Re.$$.fragment,e),h(We.$$.fragment,e),h(Ie.$$.fragment,e),h(Ge.$$.fragment,e),h(Ae.$$.fragment,e),h(Qe.$$.fragment,e),h(He.$$.fragment,e),h(Fe.$$.fragment,e),h(Ye.$$.fragment,e),h(Ne.$$.fragment,e),h(Pe.$$.fragment,e),h(Oe.$$.fragment,e),h(lt.$$.fragment,e),h(st.$$.fragment,e),h(rt.$$.fragment,e),h(dt.$$.fragment,e),h(ft.$$.fragment,e),h(Z.$$.fragment,e),h(ct.$$.fragment,e),h(ut.$$.fragment,e),h(wt.$$.fragment,e),h(bt.$$.fragment,e),h(gt.$$.fragment,e),h(_t.$$.fragment,e),h(Zt.$$.fragment,e),h(kt.$$.fragment,e),h(Rt.$$.fragment,e),Hl=!1},d(e){e&&(a(b),a(w),a(g),a(Wt),a($),a(Lt),a(k),a(It),a(Gt),a(C),a(Vt),a(R),a(At),a(xt),a(W),a(Xt),a(Qt),a(zt),a(G),a(Ht),a(V),a(Et),a(Ft),a(x),a(Yt),a(qt),a(Q),a(Nt),a(St),a(H),a(Pt),a(E),a(Dt),a(Kt),a(Y),a(Ot),a(ea),a(N),a(ta),a(S),a(aa),a(la),a(D),a(na),a(sa),a(O),a(ia),a(ee),a(oa),a(ra),a(ae),a(pa),a(le),a(da),a(ma),a(se),a(fa),a(ha),a(oe),a(ca),a(ua),a(Ma),a(wa),a(de),a(ya),a(me),a(ba),a(ga),a(he),a(Ta),a(Ja),a(ue),a(_a),a(Me),a(ja),a(we),a(Za),a(ye),a(va),a($a),a(ka),a(ge),a(Ua),a(Ca),a(Ra),a(_e),a(Ba),a(Wa),a(Ze),a(La),a(Ia),a($e),a(Ga),a(Va),a(Ue),a(Aa),a(Ce),a(xa),a(Xa),a(Be),a(Qa),a(za),a(Le),a(Ha),a(Ea),a(Fa),a(Ve),a(Ya),a(qa),a(xe),a(Na),a(Xe),a(Sa),a(Pa),a(ze),a(Da),a(Ka),a(Ee),a(Oa),a(el),a(tl),a(qe),a(al),a(ll),a(Se),a(nl),a(sl),a(De),a(il),a(Ke),a(ol),a(rl),a(et),a(pl),a(tt),a(dl),a(j),a(ml),a(at),a(fl),a(hl),a(nt),a(cl),a(ul),a(it),a(Ml),a(ot),a(wl),a(yl),a(pt),a(bl),a(gl),a(mt),a(Tl),a(Jl),a(_l),a(ht),a(jl),a(Zl),a(vl),a(Mt),a($l),a(kl),a(yt),a(Ul),a(Cl),a(Rl),a(Tt),a(Bl),a(Jt),a(Wl),a(Ll),a(jt),a(Il),a(Gl),a(vt),a(Vl),a($t),a(Al),a(xl),a(Ut),a(Xl),a(Ct),a(Ql),a(zl),a(Bt)),a(u),c(v,e),c(U,e),c(B,e),c(L,e),c(I,e),c(A,e),c(X,e),c(z,e),c(F,e),c(q,e),c(P,e),c(K,e),c(te,e),c(ne,e),c(ie,e),c(J,e),c(re,e),c(pe,e),c(fe,e),c(ce,e),c(_,e),c(be,e),c(Te,e),c(Je,e),c(je,e),c(ve,e),c(ke,e),c(Re,e),c(We,e),c(Ie,e),c(Ge,e),c(Ae,e),c(Qe,e),c(He,e),c(Fe,e),c(Ye,e),c(Ne,e),c(Pe,e),c(Oe,e),c(lt,e),c(st,e),c(rt,e),c(dt,e),c(ft,e),c(Z,e),c(ct,e),c(ut,e),c(wt,e),c(bt,e),c(gt,e),c(_t,e),c(Zt,e),c(kt,e),c(Rt,e)}}}const bs='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"CorDA","local":"corda","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"EVA","local":"eva","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convenient way","local":"a-more-convenient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Optimizers","local":"optimizers","sections":[{"title":"LoRA+ optimized LoRA","local":"lora-optimized-lora","sections":[],"depth":3}],"depth":2},{"title":"Efficiently train tokens alongside LoRA","local":"efficiently-train-tokens-alongside-lora","sections":[],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function gs(T){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vs extends ds{constructor(u){super(),ms(this,u,gs,ys,rs,{})}}export{vs as component};
