import{s as gt,o as Gt,n as Bt}from"../chunks/scheduler.f7e1785c.js";import{S as Zt,i as $t,g as i,s as a,r,A as kt,h as o,f as l,c as n,j as jt,u as M,x as p,k as tt,y as xt,a as s,v as y,d as J,t as m,w as h,m as bt,n as Ct}from"../chunks/index.9f8f0838.js";import{T as Wt}from"../chunks/Tip.4575d9cf.js";import{C as w}from"../chunks/CodeBlock.b3510e34.js";import{H as et}from"../chunks/Heading.6643a2f7.js";function St(ye){let U,T,f="ASRDiarizationPipeline",u,c,b="<code>pipeline = ASRDiarizationPipeline.from_pretrained(&quot;openai/whisper-base&quot;)</code>";return{c(){U=bt("You can also instantiate the "),T=i("code"),T.textContent=f,u=bt(` directly from pre-trained by specifying the model id
    of an ASR model on the Hub:
    `),c=i("p"),c.innerHTML=b},l(d){U=Ct(d,"You can also instantiate the "),T=o(d,"CODE",{"data-svelte-h":!0}),p(T)!=="svelte-1613cio"&&(T.textContent=f),u=Ct(d,` directly from pre-trained by specifying the model id
    of an ASR model on the Hub:
    `),c=o(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-k598fh"&&(c.innerHTML=b)},m(d,C){s(d,U,C),s(d,T,C),s(d,u,C),s(d,c,C)},p:Bt,d(d){d&&(l(U),l(T),l(u),l(c))}}}function vt(ye){let U,T,f,u,c,b,d,C=`In this final section, we’ll use the Whisper model to generate a transcription for a conversation or meeting between
two or more speakers. We’ll then pair it with a <em>speaker diarization</em> model to predict “who spoke when”. By matching
the timestamps from the Whisper transcriptions with the timestamps from the speaker diarization model, we can predict an
end-to-end meeting transcription with fully formatted start / end times for each speaker. This is a basic version of
the meeting transcription services you might have seen online from the likes of <a href="https://otter.ai" rel="nofollow">Otter.ai</a> and co:`,Je,I,lt='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/diarization_transcription.png"/>',me,g,he,G,st=`Speaker diarization (or diarisation) is the task of taking an unlabelled audio input and predicting “who spoke when”.
In doing so, we can predict start / end timestamps for each speaker turn, corresponding to when each speaker starts
speaking and when they finish.`,de,B,at=`🤗 Transformers currently does not have a model for speaker diarization included in the library, but there are checkpoints
on the Hub that can be used with relative ease. In this example, we’ll use the pre-trained speaker diarization model from
<a href="https://github.com/pyannote/pyannote-audio" rel="nofollow">pyannote.audio</a>. Let’s get started and pip install the package:`,we,Z,ce,$,nt=`Great! The weights for this model are hosted on the Hugging Face Hub. To access them, we first have to agree to the speaker diarization model’s
terms of use: <a href="https://huggingface.co/pyannote/speaker-diarization" rel="nofollow">pyannote/speaker-diarization</a>. And subsequently the
segmentation model’s terms of use: <a href="https://huggingface.co/pyannote/segmentation" rel="nofollow">pyannote/segmentation</a>.`,Ue,k,it="Once complete, we can load the pre-trained speaker diarization pipeline locally on our device:",Te,x,ue,W,ot=`Let’s try it out on a sample audio file! For this, we’ll load a sample of the <a href="https://huggingface.co/datasets/librispeech_asr" rel="nofollow">LibriSpeech ASR</a>
dataset that consists of two different speakers that have been concatenated together to give a single audio file:`,fe,S,Ie,v,pt="We can listen to the audio to see what it sounds like:",je,Q,be,N,rt=`Cool! We can clearly hear two different speakers, with a transition roughly 15s of the way through. Let’s pass this audio
file to the diarization model to get the speaker start / end times. Note that pyannote.audio expects the audio input to be a
PyTorch tensor of shape <code>(channels, seq_len)</code>, so we need to perform this conversion prior to running the model:`,Ce,A,ge,R,Ge,X,Mt=`This looks pretty good! We can see that the first speaker is predicted as speaking up until the 14.5 second mark, and the
second speaker from 15.4s onwards. Now we need to get our transcription!`,Be,H,Ze,V,yt=`For the third time in this Unit, we’ll use the Whisper model for our speech transcription system. Specifically, we’ll load the
<a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> checkpoint, since it’s small enough to give good
inference speed with reasonable transcription accuracy. As before, feel free to use any speech recognition checkpoint
on <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;library=transformers&amp;sort=trending" rel="nofollow">the Hub</a>,
including Wav2Vec2, MMS ASR or other Whisper checkpoints:`,$e,E,ke,q,Jt=`Let’s get the transcription for our sample audio, returning the segment level timestamps as well so that we know the
start / end times for each segment. You’ll remember from Unit 5 that we need to pass the argument
<code>return_timestamps=True</code> to activate the timestamp prediction task for Whisper:`,xe,z,We,_,Se,F,mt=`Alright! We see that each segment of the transcript has a start and end time, with the speakers changing at the 15.48 second
mark. We can now pair this transcription with the speaker timestamps that we got from our diarization model to get our
final transcription.`,ve,Y,Qe,D,ht=`To get the final transcription, we’ll align the timestamps from the diarization model with those from the Whisper model.
The diarization model predicted the first speaker to end at 14.5 seconds, and the second speaker to start at 15.4s, whereas Whisper predicted segment boundaries at
13.88, 15.48 and 19.44 seconds respectively. Since the timestamps from Whisper don’t match perfectly with those from the
diarization model, we need to find which of these boundaries are closest to 14.5 and 15.4 seconds, and segment the transcription by
speakers accordingly. Specifically, we’ll find the closest alignment between diarization and transcription timestamps by
minimising the absolute distance between both.`,Ne,L,dt=`Luckily for us, we can use the 🤗 Speechbox package to perform this alignment. First, let’s pip install <code>speechbox</code> from
main:`,Ae,P,Re,K,wt=`We can now instantiate our combined diarization plus transcription pipeline, by passing the diarization model and
ASR model to the <a href="https://github.com/huggingface/speechbox/tree/main#asr-with-speaker-diarization" rel="nofollow"><code>ASRDiarizationPipeline</code></a> class:`,Xe,O,He,j,Ve,ee,ct="Let’s pass the audio file to the composite pipeline and see what we get out:",Ee,te,qe,le,ze,se,Ut=`Excellent! The first speaker is segmented as speaking from 0 to 15.48 seconds, and the second speaker from 15.48 to 21.28 seconds,
with the corresponding transcriptions for each.`,_e,ae,Tt=`We can format the timestamps a little more nicely by defining two helper functions. The first converts a tuple of
timestamps to a string, rounded to a set number of decimal places. The second combines the speaker id, timestamp and text
information onto one line, and splits each speaker onto their own line for ease of reading:`,Fe,ne,Ye,ie,ut="Let’s re-run the pipeline, this time formatting the transcription according to the function we’ve just defined:",De,oe,Le,pe,Pe,re,ft=`There we go! With that, we’ve both diarized and transcribe our input audio and returned speaker-segmented transcriptions.
While the minimum distance algoirthm to align the diarized timestamps and transcribed timestamps is simple, it
works well in practice. If you want to explore more advanced methods for combining the timestamps, the
source code for the <code>ASRDiarizationPipeline</code> is a good place to start: <a href="https://github.com/huggingface/speechbox/blob/96d2d1a180252d92263f862a1cd25a48860f1aed/src/speechbox/diarize.py#L12" rel="nofollow">speechbox/diarize.py</a>`,Ke,Me,Oe;return c=new et({props:{title:"Transcribe a meeting",local:"transcribe-a-meeting",headingTag:"h1"}}),g=new et({props:{title:"Speaker Diarization",local:"speaker-diarization",headingTag:"h2"}}),Z=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHB5YW5ub3RlLmF1ZGlv",highlighted:"pip install --upgrade pyannote.audio",wrap:!1}}),x=new w({props:{code:"ZnJvbSUyMHB5YW5ub3RlLmF1ZGlvJTIwaW1wb3J0JTIwUGlwZWxpbmUlMEElMEFkaWFyaXphdGlvbl9waXBlbGluZSUyMCUzRCUyMFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJweWFubm90ZSUyRnNwZWFrZXItZGlhcml6YXRpb24lNDAyLjElMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> pyannote.audio <span class="hljs-keyword">import</span> Pipeline

diarization_pipeline = Pipeline.from_pretrained(
    <span class="hljs-string">&quot;pyannote/speaker-diarization@2.1&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
)`,wrap:!1}}),S=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY29uY2F0ZW5hdGVkX2xpYnJpc3BlZWNoJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMnNhbmNoaXQtZ2FuZGhpJTJGY29uY2F0ZW5hdGVkX2xpYnJpc3BlZWNoJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUlMEEpJTBBc2FtcGxlJTIwJTNEJTIwbmV4dChpdGVyKGNvbmNhdGVuYXRlZF9saWJyaXNwZWVjaCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

concatenated_librispeech = load_dataset(
    <span class="hljs-string">&quot;sanchit-gandhi/concatenated_librispeech&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(concatenated_librispeech))`,wrap:!1}}),Q=new w({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJhdGUlM0RzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),A=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFpbnB1dF90ZW5zb3IlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlNUJOb25lJTJDJTIwJTNBJTVEKS5mbG9hdCgpJTBBb3V0cHV0cyUyMCUzRCUyMGRpYXJpemF0aW9uX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCU3QiUyMndhdmVmb3JtJTIyJTNBJTIwaW5wdXRfdGVuc29yJTJDJTIwJTIyc2FtcGxlX3JhdGUlMjIlM0ElMjBzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlN0QlMEEpJTBBJTBBb3V0cHV0cy5mb3JfanNvbigpJTVCJTIyY29udGVudCUyMiU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch

input_tensor = torch.from_numpy(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>][<span class="hljs-literal">None</span>, :]).<span class="hljs-built_in">float</span>()
outputs = diarization_pipeline(
    {<span class="hljs-string">&quot;waveform&quot;</span>: input_tensor, <span class="hljs-string">&quot;sample_rate&quot;</span>: sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]}
)

outputs.for_json()[<span class="hljs-string">&quot;content&quot;</span>]`,wrap:!1}}),R=new w({props:{code:"JTVCJTdCJ3NlZ21lbnQnJTNBJTIwJTdCJ3N0YXJ0JyUzQSUyMDAuNDk3ODEyNSUyQyUyMCdlbmQnJTNBJTIwMTQuNTIwOTM3NTAwMDAwMDAyJTdEJTJDJTBBJTIwJTIwJ3RyYWNrJyUzQSUyMCdCJyUyQyUwQSUyMCUyMCdsYWJlbCclM0ElMjAnU1BFQUtFUl8wMSclN0QlMkMlMEElMjAlN0Inc2VnbWVudCclM0ElMjAlN0Inc3RhcnQnJTNBJTIwMTUuMzY0Njg3NTAwMDAwMDAyJTJDJTIwJ2VuZCclM0ElMjAyMS4zNzIxODc1JTdEJTJDJTBBJTIwJTIwJ3RyYWNrJyUzQSUyMCdBJyUyQyUwQSUyMCUyMCdsYWJlbCclM0ElMjAnU1BFQUtFUl8wMCclN0QlNUQ=",highlighted:`[{&#x27;segment&#x27;: {&#x27;start&#x27;: 0.4978125, &#x27;end&#x27;: 14.520937500000002},
  &#x27;track&#x27;: &#x27;B&#x27;,
  &#x27;label&#x27;: &#x27;SPEAKER_01&#x27;},
 {&#x27;segment&#x27;: {&#x27;start&#x27;: 15.364687500000002, &#x27;end&#x27;: 21.3721875},
  &#x27;track&#x27;: &#x27;A&#x27;,
  &#x27;label&#x27;: &#x27;SPEAKER_00&#x27;}]`,wrap:!1}}),H=new et({props:{title:"Speech transcription",local:"speech-transcription",headingTag:"h2"}}),E=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXNyX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

asr_pipeline = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
    model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>,
)`,wrap:!1}}),z=new w({props:{code:"YXNyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMjU2JTdEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RpbWVzdGFtcHMlM0RUcnVlJTJDJTBBKQ==",highlighted:`asr_pipeline(
    sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(),
    generate_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">256</span>},
    return_timestamps=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),_=new w({props:{code:"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",highlighted:`{
    &quot;text&quot;: &quot; The second and importance is as follows. Sovereignty may be defined to be the right of making laws. In France, the king really exercises a portion of the sovereign power, since the laws have no weight. He was in a favored state of mind, owing to the blight his wife&#x27;s action threatened to cast upon his entire future.&quot;,
    &quot;chunks&quot;: [
        {&quot;timestamp&quot;: (0.0, 3.56), &quot;text&quot;: &quot; The second and importance is as follows.&quot;},
        {
            &quot;timestamp&quot;: (3.56, 7.84),
            &quot;text&quot;: &quot; Sovereignty may be defined to be the right of making laws.&quot;,
        },
        {
            &quot;timestamp&quot;: (7.84, 13.88),
            &quot;text&quot;: &quot; In France, the king really exercises a portion of the sovereign power, since the laws have&quot;,
        },
        {&quot;timestamp&quot;: (13.88, 15.48), &quot;text&quot;: &quot; no weight.&quot;},
        {
            &quot;timestamp&quot;: (15.48, 19.44),
            &quot;text&quot;: &quot; He was in a favored state of mind, owing to the blight his wife&#x27;s action threatened to&quot;,
        },
        {&quot;timestamp&quot;: (19.44, 21.28), &quot;text&quot;: &quot; cast upon his entire future.&quot;},
    ],
}`,wrap:!1}}),Y=new et({props:{title:"Speechbox",local:"speechbox",headingTag:"h2"}}),P=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGc3BlZWNoYm94",highlighted:"pip install git+https://github.com/huggingface/speechbox",wrap:!1}}),O=new w({props:{code:"ZnJvbSUyMHNwZWVjaGJveCUyMGltcG9ydCUyMEFTUkRpYXJpemF0aW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMEFTUkRpYXJpemF0aW9uUGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwYXNyX3BpcGVsaW5lJTNEYXNyX3BpcGVsaW5lJTJDJTIwZGlhcml6YXRpb25fcGlwZWxpbmUlM0RkaWFyaXphdGlvbl9waXBlbGluZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> speechbox <span class="hljs-keyword">import</span> ASRDiarizationPipeline

pipeline = ASRDiarizationPipeline(
    asr_pipeline=asr_pipeline, diarization_pipeline=diarization_pipeline
)`,wrap:!1}}),j=new Wt({props:{$$slots:{default:[St]},$$scope:{ctx:ye}}}),te=new w({props:{code:"cGlwZWxpbmUoc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQuY29weSgpKQ==",highlighted:'pipeline(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),le=new w({props:{code:"JTVCJTdCJ3NwZWFrZXInJTNBJTIwJ1NQRUFLRVJfMDEnJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMFRoZSUyMHNlY29uZCUyMGFuZCUyMGltcG9ydGFuY2UlMjBpcyUyMGFzJTIwZm9sbG93cy4lMjBTb3ZlcmVpZ250eSUyMG1heSUyMGJlJTIwZGVmaW5lZCUyMHRvJTIwYmUlMjB0aGUlMjByaWdodCUyMG9mJTIwbWFraW5nJTIwbGF3cy4lMjBJbiUyMEZyYW5jZSUyQyUyMHRoZSUyMGtpbmclMjByZWFsbHklMjBleGVyY2lzZXMlMjBhJTIwcG9ydGlvbiUyMG9mJTIwdGhlJTIwc292ZXJlaWduJTIwcG93ZXIlMkMlMjBzaW5jZSUyMHRoZSUyMGxhd3MlMjBoYXZlJTIwbm8lMjB3ZWlnaHQuJyUyQyUwQSUyMCUyMCd0aW1lc3RhbXAnJTNBJTIwKDAuMCUyQyUyMDE1LjQ4KSU3RCUyQyUwQSUyMCU3QidzcGVha2VyJyUzQSUyMCdTUEVBS0VSXzAwJyUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCUyMiUyMEhlJTIwd2FzJTIwaW4lMjBhJTIwZmF2b3JlZCUyMHN0YXRlJTIwb2YlMjBtaW5kJTJDJTIwb3dpbmclMjB0byUyMHRoZSUyMGJsaWdodCUyMGhpcyUyMHdpZmUncyUyMGFjdGlvbiUyMHRocmVhdGVuZWQlMjB0byUyMGNhc3QlMjB1cG9uJTIwaGlzJTIwZW50aXJlJTIwZnV0dXJlLiUyMiUyQyUwQSUyMCUyMCd0aW1lc3RhbXAnJTNBJTIwKDE1LjQ4JTJDJTIwMjEuMjgpJTdEJTVE",highlighted:`[{&#x27;speaker&#x27;: &#x27;SPEAKER_01&#x27;,
  &#x27;text&#x27;: &#x27; The second and importance is as follows. Sovereignty may be defined to be the right of making laws. In France, the king really exercises a portion of the sovereign power, since the laws have no weight.&#x27;,
  &#x27;timestamp&#x27;: (0.0, 15.48)},
 {&#x27;speaker&#x27;: &#x27;SPEAKER_00&#x27;,
  &#x27;text&#x27;: &quot; He was in a favored state of mind, owing to the blight his wife&#x27;s action threatened to cast upon his entire future.&quot;,
  &#x27;timestamp&#x27;: (15.48, 21.28)}]`,wrap:!1}}),ne=new w({props:{code:"ZGVmJTIwdHVwbGVfdG9fc3RyaW5nKHN0YXJ0X2VuZF90dXBsZSUyQyUyMG5kaWdpdHMlM0QxKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHN0cigocm91bmQoc3RhcnRfZW5kX3R1cGxlJTVCMCU1RCUyQyUyMG5kaWdpdHMpJTJDJTIwcm91bmQoc3RhcnRfZW5kX3R1cGxlJTVCMSU1RCUyQyUyMG5kaWdpdHMpKSklMEElMEElMEFkZWYlMjBmb3JtYXRfYXNfdHJhbnNjcmlwdGlvbihyYXdfc2VnbWVudHMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJTVDbiU1Q24lMjIuam9pbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaHVuayU1QiUyMnNwZWFrZXIlMjIlNUQlMjAlMkIlMjAlMjIlMjAlMjIlMjAlMkIlMjB0dXBsZV90b19zdHJpbmcoY2h1bmslNUIlMjJ0aW1lc3RhbXAlMjIlNUQpJTIwJTJCJTIwY2h1bmslNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwY2h1bmslMjBpbiUyMHJhd19zZWdtZW50cyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tuple_to_string</span>(<span class="hljs-params">start_end_tuple, ndigits=<span class="hljs-number">1</span></span>):
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>((<span class="hljs-built_in">round</span>(start_end_tuple[<span class="hljs-number">0</span>], ndigits), <span class="hljs-built_in">round</span>(start_end_tuple[<span class="hljs-number">1</span>], ndigits)))


<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_as_transcription</span>(<span class="hljs-params">raw_segments</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join(
        [
            chunk[<span class="hljs-string">&quot;speaker&quot;</span>] + <span class="hljs-string">&quot; &quot;</span> + tuple_to_string(chunk[<span class="hljs-string">&quot;timestamp&quot;</span>]) + chunk[<span class="hljs-string">&quot;text&quot;</span>]
            <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> raw_segments
        ]
    )`,wrap:!1}}),oe=new w({props:{code:"b3V0cHV0cyUyMCUzRCUyMHBpcGVsaW5lKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSklMEElMEFmb3JtYXRfYXNfdHJhbnNjcmlwdGlvbihvdXRwdXRzKQ==",highlighted:`outputs = pipeline(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())

format_as_transcription(outputs)`,wrap:!1}}),pe=new w({props:{code:"U1BFQUtFUl8wMSUyMCgwLjAlMkMlMjAxNS41KSUyMFRoZSUyMHNlY29uZCUyMGFuZCUyMGltcG9ydGFuY2UlMjBpcyUyMGFzJTIwZm9sbG93cy4lMjBTb3ZlcmVpZ250eSUyMG1heSUyMGJlJTIwZGVmaW5lZCUyMHRvJTIwYmUlMjB0aGUlMjByaWdodCUyMG9mJTIwbWFraW5nJTIwbGF3cy4lMEFJbiUyMEZyYW5jZSUyQyUyMHRoZSUyMGtpbmclMjByZWFsbHklMjBleGVyY2lzZXMlMjBhJTIwcG9ydGlvbiUyMG9mJTIwdGhlJTIwc292ZXJlaWduJTIwcG93ZXIlMkMlMjBzaW5jZSUyMHRoZSUyMGxhd3MlMjBoYXZlJTIwbm8lMjB3ZWlnaHQuJTBBJTBBU1BFQUtFUl8wMCUyMCgxNS41JTJDJTIwMjEuMyklMjBIZSUyMHdhcyUyMGluJTIwYSUyMGZhdm9yZWQlMjBzdGF0ZSUyMG9mJTIwbWluZCUyQyUyMG93aW5nJTIwdG8lMjB0aGUlMjBibGlnaHQlMjBoaXMlMjB3aWZlJ3MlMjBhY3Rpb24lMjB0aHJlYXRlbmVkJTIwdG8lMjBjYXN0JTIwdXBvbiUwQWhpcyUyMGVudGlyZSUyMGZ1dHVyZS4=",highlighted:`SPEAKER_01 (0.0, 15.5) The second and importance is as follows. Sovereignty may be defined to be the right of making laws.
In France, the king really exercises a portion of the sovereign power, since the laws have no weight.

SPEAKER_00 (15.5, 21.3) He was in a favored state of mind, owing to the blight his wife&#x27;s action threatened to cast upon
his entire future.`,wrap:!1}}),{c(){U=i("meta"),T=a(),f=i("p"),u=a(),r(c.$$.fragment),b=a(),d=i("p"),d.innerHTML=C,Je=a(),I=i("div"),I.innerHTML=lt,me=a(),r(g.$$.fragment),he=a(),G=i("p"),G.textContent=st,de=a(),B=i("p"),B.innerHTML=at,we=a(),r(Z.$$.fragment),ce=a(),$=i("p"),$.innerHTML=nt,Ue=a(),k=i("p"),k.textContent=it,Te=a(),r(x.$$.fragment),ue=a(),W=i("p"),W.innerHTML=ot,fe=a(),r(S.$$.fragment),Ie=a(),v=i("p"),v.textContent=pt,je=a(),r(Q.$$.fragment),be=a(),N=i("p"),N.innerHTML=rt,Ce=a(),r(A.$$.fragment),ge=a(),r(R.$$.fragment),Ge=a(),X=i("p"),X.textContent=Mt,Be=a(),r(H.$$.fragment),Ze=a(),V=i("p"),V.innerHTML=yt,$e=a(),r(E.$$.fragment),ke=a(),q=i("p"),q.innerHTML=Jt,xe=a(),r(z.$$.fragment),We=a(),r(_.$$.fragment),Se=a(),F=i("p"),F.textContent=mt,ve=a(),r(Y.$$.fragment),Qe=a(),D=i("p"),D.textContent=ht,Ne=a(),L=i("p"),L.innerHTML=dt,Ae=a(),r(P.$$.fragment),Re=a(),K=i("p"),K.innerHTML=wt,Xe=a(),r(O.$$.fragment),He=a(),r(j.$$.fragment),Ve=a(),ee=i("p"),ee.textContent=ct,Ee=a(),r(te.$$.fragment),qe=a(),r(le.$$.fragment),ze=a(),se=i("p"),se.textContent=Ut,_e=a(),ae=i("p"),ae.textContent=Tt,Fe=a(),r(ne.$$.fragment),Ye=a(),ie=i("p"),ie.textContent=ut,De=a(),r(oe.$$.fragment),Le=a(),r(pe.$$.fragment),Pe=a(),re=i("p"),re.innerHTML=ft,Ke=a(),Me=i("p"),this.h()},l(e){const t=kt("svelte-u9bgzb",document.head);U=o(t,"META",{name:!0,content:!0}),t.forEach(l),T=n(e),f=o(e,"P",{}),jt(f).forEach(l),u=n(e),M(c.$$.fragment,e),b=n(e),d=o(e,"P",{"data-svelte-h":!0}),p(d)!=="svelte-1tqqmqr"&&(d.innerHTML=C),Je=n(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-9us2ce"&&(I.innerHTML=lt),me=n(e),M(g.$$.fragment,e),he=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-t8p1z2"&&(G.textContent=st),de=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1kcbzau"&&(B.innerHTML=at),we=n(e),M(Z.$$.fragment,e),ce=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-5q49hx"&&($.innerHTML=nt),Ue=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-s5u7ly"&&(k.textContent=it),Te=n(e),M(x.$$.fragment,e),ue=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-150e6pp"&&(W.innerHTML=ot),fe=n(e),M(S.$$.fragment,e),Ie=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-qukzyh"&&(v.textContent=pt),je=n(e),M(Q.$$.fragment,e),be=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-cjssv6"&&(N.innerHTML=rt),Ce=n(e),M(A.$$.fragment,e),ge=n(e),M(R.$$.fragment,e),Ge=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-137vsmb"&&(X.textContent=Mt),Be=n(e),M(H.$$.fragment,e),Ze=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1p4vlmp"&&(V.innerHTML=yt),$e=n(e),M(E.$$.fragment,e),ke=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1ykatvd"&&(q.innerHTML=Jt),xe=n(e),M(z.$$.fragment,e),We=n(e),M(_.$$.fragment,e),Se=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-9e4lxz"&&(F.textContent=mt),ve=n(e),M(Y.$$.fragment,e),Qe=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-15wht1d"&&(D.textContent=ht),Ne=n(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1d1nesl"&&(L.innerHTML=dt),Ae=n(e),M(P.$$.fragment,e),Re=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1sqyg35"&&(K.innerHTML=wt),Xe=n(e),M(O.$$.fragment,e),He=n(e),M(j.$$.fragment,e),Ve=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1p2go7o"&&(ee.textContent=ct),Ee=n(e),M(te.$$.fragment,e),qe=n(e),M(le.$$.fragment,e),ze=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1uyv73y"&&(se.textContent=Ut),_e=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-yn88rk"&&(ae.textContent=Tt),Fe=n(e),M(ne.$$.fragment,e),Ye=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1hp60dp"&&(ie.textContent=ut),De=n(e),M(oe.$$.fragment,e),Le=n(e),M(pe.$$.fragment,e),Pe=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-19dux4l"&&(re.innerHTML=ft),Ke=n(e),Me=o(e,"P",{}),jt(Me).forEach(l),this.h()},h(){tt(U,"name","hf:doc:metadata"),tt(U,"content",Qt),tt(I,"class","flex justify-center")},m(e,t){xt(document.head,U),s(e,T,t),s(e,f,t),s(e,u,t),y(c,e,t),s(e,b,t),s(e,d,t),s(e,Je,t),s(e,I,t),s(e,me,t),y(g,e,t),s(e,he,t),s(e,G,t),s(e,de,t),s(e,B,t),s(e,we,t),y(Z,e,t),s(e,ce,t),s(e,$,t),s(e,Ue,t),s(e,k,t),s(e,Te,t),y(x,e,t),s(e,ue,t),s(e,W,t),s(e,fe,t),y(S,e,t),s(e,Ie,t),s(e,v,t),s(e,je,t),y(Q,e,t),s(e,be,t),s(e,N,t),s(e,Ce,t),y(A,e,t),s(e,ge,t),y(R,e,t),s(e,Ge,t),s(e,X,t),s(e,Be,t),y(H,e,t),s(e,Ze,t),s(e,V,t),s(e,$e,t),y(E,e,t),s(e,ke,t),s(e,q,t),s(e,xe,t),y(z,e,t),s(e,We,t),y(_,e,t),s(e,Se,t),s(e,F,t),s(e,ve,t),y(Y,e,t),s(e,Qe,t),s(e,D,t),s(e,Ne,t),s(e,L,t),s(e,Ae,t),y(P,e,t),s(e,Re,t),s(e,K,t),s(e,Xe,t),y(O,e,t),s(e,He,t),y(j,e,t),s(e,Ve,t),s(e,ee,t),s(e,Ee,t),y(te,e,t),s(e,qe,t),y(le,e,t),s(e,ze,t),s(e,se,t),s(e,_e,t),s(e,ae,t),s(e,Fe,t),y(ne,e,t),s(e,Ye,t),s(e,ie,t),s(e,De,t),y(oe,e,t),s(e,Le,t),y(pe,e,t),s(e,Pe,t),s(e,re,t),s(e,Ke,t),s(e,Me,t),Oe=!0},p(e,[t]){const It={};t&2&&(It.$$scope={dirty:t,ctx:e}),j.$set(It)},i(e){Oe||(J(c.$$.fragment,e),J(g.$$.fragment,e),J(Z.$$.fragment,e),J(x.$$.fragment,e),J(S.$$.fragment,e),J(Q.$$.fragment,e),J(A.$$.fragment,e),J(R.$$.fragment,e),J(H.$$.fragment,e),J(E.$$.fragment,e),J(z.$$.fragment,e),J(_.$$.fragment,e),J(Y.$$.fragment,e),J(P.$$.fragment,e),J(O.$$.fragment,e),J(j.$$.fragment,e),J(te.$$.fragment,e),J(le.$$.fragment,e),J(ne.$$.fragment,e),J(oe.$$.fragment,e),J(pe.$$.fragment,e),Oe=!0)},o(e){m(c.$$.fragment,e),m(g.$$.fragment,e),m(Z.$$.fragment,e),m(x.$$.fragment,e),m(S.$$.fragment,e),m(Q.$$.fragment,e),m(A.$$.fragment,e),m(R.$$.fragment,e),m(H.$$.fragment,e),m(E.$$.fragment,e),m(z.$$.fragment,e),m(_.$$.fragment,e),m(Y.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(j.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),Oe=!1},d(e){e&&(l(T),l(f),l(u),l(b),l(d),l(Je),l(I),l(me),l(he),l(G),l(de),l(B),l(we),l(ce),l($),l(Ue),l(k),l(Te),l(ue),l(W),l(fe),l(Ie),l(v),l(je),l(be),l(N),l(Ce),l(ge),l(Ge),l(X),l(Be),l(Ze),l(V),l($e),l(ke),l(q),l(xe),l(We),l(Se),l(F),l(ve),l(Qe),l(D),l(Ne),l(L),l(Ae),l(Re),l(K),l(Xe),l(He),l(Ve),l(ee),l(Ee),l(qe),l(ze),l(se),l(_e),l(ae),l(Fe),l(Ye),l(ie),l(De),l(Le),l(Pe),l(re),l(Ke),l(Me)),l(U),h(c,e),h(g,e),h(Z,e),h(x,e),h(S,e),h(Q,e),h(A,e),h(R,e),h(H,e),h(E,e),h(z,e),h(_,e),h(Y,e),h(P,e),h(O,e),h(j,e),h(te,e),h(le,e),h(ne,e),h(oe,e),h(pe,e)}}}const Qt='{"title":"Transcribe a meeting","local":"transcribe-a-meeting","sections":[{"title":"Speaker Diarization","local":"speaker-diarization","sections":[],"depth":2},{"title":"Speech transcription","local":"speech-transcription","sections":[],"depth":2},{"title":"Speechbox","local":"speechbox","sections":[],"depth":2}],"depth":1}';function Nt(ye){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends Zt{constructor(U){super(),$t(this,U,Nt,vt,gt,{})}}export{Et as component};
