import{s as Ss,f as Cn,n as Xs,o as Es}from"../chunks/scheduler.37c15a92.js";import{S as zs,i as Rs,g as i,s,r,A as Ns,h as o,f as l,c as a,j as Fs,u as m,x as p,k as y,y as Ps,a as n,v as u,d as h,t as M,w as c}from"../chunks/index.7cb9c9b8.js";import{C as d}from"../chunks/CodeBlock.a6d3f852.js";import{C as As}from"../chunks/CourseFloatingBanner.36c274d0.js";import{H as f}from"../chunks/Heading.d3928e2a.js";function qs(_n){let b,vt,gt,Ut,w,Jt,g,$t,T,Zn="Now that you’ve studied the theory behind Advantage Actor Critic (A2C), <strong>you’re ready to train your A2C agent</strong> using Stable-Baselines3 in a robotic environment. And train a:",jt,v,In="<li>A robotic arm 🦾 to move to the correct position.</li>",Ct,U,Wn="We’re going to use",_t,J,Bn='<li><a href="https://github.com/qgallouedec/panda-gym" rel="nofollow">panda-gym</a></li>',Zt,$,kn="To validate this hands-on for the certification process, you need to push your two trained models to the Hub and get the following results:",It,j,Gn="<li><code>PandaReachDense-v3</code> get a result of &gt;= -3.5.</li>",Wt,C,Vn='To find your result, <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">go to the leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',Bt,_,Hn='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',kt,Z,xn="<strong>To start the hands-on click on Open In Colab button</strong> 👇 :",Gt,I,Qn='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit6/unit6.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',Vt,W,Ht,B,xt,k,Ln='<li><a href="https://github.com/qgallouedec/panda-gym" rel="nofollow">Panda-Gym</a></li>',Qt,G,Lt,V,Yn='<li><a href="https://stable-baselines3.readthedocs.io/" rel="nofollow">Stable-Baselines3</a></li>',Yt,H,Fn='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the GitHub Repo</a>.',Ft,x,St,Q,Sn="At the end of the notebook, you will:",Xt,L,Xn="<li>Be able to use <strong>Panda-Gym</strong>, the environment library.</li> <li>Be able to <strong>train robots using A2C</strong>.</li> <li>Understand why <strong>we need to normalize the input</strong>.</li> <li>Be able to <strong>push your trained agent and the code to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",Et,Y,zt,F,En="Before diving into the notebook, you need to:",Rt,S,zn='🔲 📚 Study <a href="https://huggingface.co/deep-rl-course/unit6/introduction" rel="nofollow">Actor-Critic methods by reading Unit 6</a> 🤗',Nt,X,Pt,E,At,z,Rn="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",qt,R,Nn,Dt,N,Pn="<li><code>Hardware Accelerator &gt; GPU</code></li>",Kt,P,An,Ot,A,el,q,qn="During the notebook, we’ll need to generate a replay video. To do so, with colab, <strong>we need to have a virtual screen to be able to render the environment</strong> (and thus record the frames).",tl,D,Dn="The following cell will install the librairies and create and run a virtual screen 🖥",ll,K,nl,O,sl,ee,al,te,Kn="We’ll install multiple ones:",il,le,On="<li><code>gymnasium</code></li> <li><code>panda-gym</code>: Contains the robotics arm environments.</li> <li><code>stable-baselines3</code>: The SB3 deep reinforcement learning library.</li> <li><code>huggingface_sb3</code>: Additional code for Stable-baselines3 to load and upload models from the Hugging Face 🤗 Hub.</li> <li><code>huggingface_hub</code>: Library allowing anyone to work with the Hub repositories.</li>",ol,ne,pl,se,rl,ae,ml,ie,ul,oe,es="The agent we’re going to train is a robotic arm that needs to do controls (moving the arm and using the end-effector).",hl,pe,ts="In robotics, the <em>end-effector</em> is the device at the end of a robotic arm designed to interact with the environment.",Ml,re,ls="In <code>PandaReach</code>, the robot must place its end-effector at a target position (green ball).",cl,me,ns="We’re going to use the dense version of this environment. It means we’ll get a <em>dense reward function</em> that <strong>will provide a reward at each timestep</strong> (the closer the agent is to completing the task, the higher the reward). Contrary to a <em>sparse reward function</em> where the environment <strong>return a reward if and only if the task is completed</strong>.",fl,ue,ss="Also, we’re going to use the <em>End-effector displacement control</em>, it means the <strong>action corresponds to the displacement of the end-effector</strong>. We don’t control the individual motion of each joint (joint control).",dl,he,as,yl,Me,is="This way <strong>the training will be easier</strong>.",bl,ce,wl,fe,gl,de,os="In <code>PandaReachDense-v3</code> the robotic arm must place its end-effector at a target position (green ball).",Tl,ye,vl,be,Ul,we,ps="The observation space <strong>is a dictionary with 3 different elements</strong>:",Jl,ge,rs="<li><code>achieved_goal</code>: (x,y,z) position of the goal.</li> <li><code>desired_goal</code>: (x,y,z) distance between the goal position and the current object position.</li> <li><code>observation</code>: position (x,y,z) and velocity of the end-effector (vx, vy, vz).</li>",$l,Te,ms="Given it’s a dictionary as observation, <strong>we will need to use a MultiInputPolicy policy instead of MlpPolicy</strong>.",jl,ve,Cl,Ue,us="The action space is a vector with 3 values:",_l,Je,hs="<li>Control x, y, z movement</li>",Zl,$e,Il,je,Ms='A good practice in reinforcement learning is to <a href="https://stable-baselines3.readthedocs.io/en/master/guide/rl_tips.html" rel="nofollow">normalize input features</a>.',Wl,Ce,cs="For that purpose, there is a wrapper that will compute a running average and standard deviation of input features.",Bl,_e,fs="We also normalize rewards with this same wrapper by adding <code>norm_reward = True</code>",kl,Ze,ds='<a href="https://stable-baselines3.readthedocs.io/en/master/guide/vec_envs.html#vecnormalize" rel="nofollow">You should check the documentation to fill this cell</a>',Gl,Ie,Vl,We,Hl,Be,xl,ke,Ql,Ge,ys='For more information about A2C implementation with StableBaselines3 check: <a href="https://stable-baselines3.readthedocs.io/en/master/modules/a2c.html#notes" rel="nofollow">https://stable-baselines3.readthedocs.io/en/master/modules/a2c.html#notes</a>',Ll,Ve,bs='To find the best parameters I checked the <a href="https://huggingface.co/sb3" rel="nofollow">official trained agents by Stable-Baselines3 team</a>.',Yl,He,Fl,xe,Sl,Qe,Xl,Le,El,Ye,ws="<li>Let’s train our agent for 1,000,000 timesteps, don’t forget to use GPU on Colab. It will take approximately ~25-40min</li>",zl,Fe,Rl,Se,Nl,Xe,Pl,Ee,gs="<li>Now that’s our  agent is trained, we need to <strong>check its performance</strong>.</li> <li>Stable-Baselines3 provides a method to do that: <code>evaluate_policy</code></li>",Al,ze,ql,Re,Dl,Ne,Ts="Now that we saw we got good results after the training, we can publish our trained model on the Hub with one line of code.",Kl,Pe,vs='📚 The libraries documentation 👉 <a href="https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face--x-stable-baselines3-v20" rel="nofollow">https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face—x-stable-baselines3-v20</a>',Ol,Ae,Us="By using <code>package_to_hub</code>, as we already mentionned in the former units, <strong>you evaluate, record a replay, generate a model card of your agent and push it to the hub</strong>.",en,qe,Js="This way:",tn,De,$s='<li>You can <strong>showcase our work</strong> 🔥</li> <li>You can <strong>visualize your agent playing</strong> 👀</li> <li>You can <strong>share with the community an agent that others can use</strong> 💾</li> <li>You can <strong>access a leaderboard 🏆 to see how well your agent is performing compared to your classmates</strong> 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a></li>',ln,Ke,js="To be able to share your model with the community there are three more steps to follow:",nn,Oe,Cs='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',sn,et,_s="2️⃣ Sign in and then, you need to store your authentication token from the Hugging Face website.",an,tt,Zs='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',on,lt,Is,pn,nt,Ws="<li>Copy the token</li> <li>Run the cell below and paste the token</li>",rn,st,mn,at,Bs="If you don’t want to use a Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code>",un,it,ks=`3️⃣ We’re now ready to push our trained agent to the 🤗 Hub 🔥 using <code>package_to_hub()</code> function.
For this environment, <strong>running this cell can take approximately 10min</strong>`,hn,ot,Mn,pt,cn,rt,Gs="The best way to learn <strong>is to try things by your own</strong>! Why not trying  <code>PandaPickAndPlace-v3</code>?",fn,mt,Vs="If you want to try more advanced tasks for panda-gym, you need to check what was done using <strong>TQC or SAC</strong> (a more sample-efficient algorithm suited for robotics tasks). In real robotics, you’ll use a more sample-efficient algorithm for a simple reason: contrary to a simulation <strong>if you move your robotic arm too much, you have a risk of breaking it</strong>.",dn,ut,Hs='PandaPickAndPlace-v1 (this model uses the v1 version of the environment): <a href="https://huggingface.co/sb3/tqc-PandaPickAndPlace-v1" rel="nofollow">https://huggingface.co/sb3/tqc-PandaPickAndPlace-v1</a>',yn,ht,xs='And don’t hesitate to check panda-gym documentation here: <a href="https://panda-gym.readthedocs.io/en/latest/usage/train_with_sb3.html" rel="nofollow">https://panda-gym.readthedocs.io/en/latest/usage/train_with_sb3.html</a>',bn,Mt,Qs="We provide you the steps to train another agent (optional):",wn,ct,Ls='<li>Define the environment called “PandaPickAndPlace-v3”</li> <li>Make a vectorized environment</li> <li>Add a wrapper to normalize the observations and rewards. <a href="https://stable-baselines3.readthedocs.io/en/master/guide/vec_envs.html#vecnormalize" rel="nofollow">Check the documentation</a></li> <li>Create the A2C Model (don’t forget verbose=1 to print the training logs).</li> <li>Train it for 1M Timesteps</li> <li>Save the model and  VecNormalize statistics when saving the agent</li> <li>Evaluate your agent</li> <li>Publish your trained model on the Hub 🔥 with <code>package_to_hub</code></li>',gn,ft,Tn,dt,vn,yt,Un,bt,Ys="See you on Unit 7! 🔥",Jn,wt,$n,Tt,jn;return w=new f({props:{title:"Advantage Actor Critic (A2C) using Robotics Simulations with Panda-Gym 🤖",local:"hands-on",headingTag:"h1"}}),g=new As({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/main/notebooks/unit6/unit6.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),W=new f({props:{title:"Unit 6: Advantage Actor Critic (A2C) using Robotics Simulations with Panda-Gym 🤖",local:"unit-6-advantage-actor-critic-a2c-using-robotics-simulations-with-panda-gym-",headingTag:"h1"}}),B=new f({props:{title:"🎮 Environments:",local:"-environments",headingTag:"h3"}}),G=new f({props:{title:"📚 RL-Library:",local:"-rl-library",headingTag:"h3"}}),x=new f({props:{title:"Objectives of this notebook 🏆",local:"objectives-of-this-notebook-",headingTag:"h2"}}),Y=new f({props:{title:"Prerequisites 🏗️",local:"prerequisites-",headingTag:"h2"}}),X=new f({props:{title:"Let’s train our first robots 🤖",local:"lets-train-our-first-robots-",headingTag:"h1"}}),E=new f({props:{title:"Set the GPU 💪",local:"set-the-gpu-",headingTag:"h2"}}),A=new f({props:{title:"Create a virtual display 🔽",local:"create-a-virtual-display-",headingTag:"h2"}}),K=new d({props:{code:"JTI1JTI1Y2FwdHVyZSUwQSFhcHQlMjBpbnN0YWxsJTIwcHl0aG9uLW9wZW5nbCUwQSFhcHQlMjBpbnN0YWxsJTIwZmZtcGVnJTBBIWFwdCUyMGluc3RhbGwlMjB4dmZiJTBBIXBpcDMlMjBpbnN0YWxsJTIwcHl2aXJ0dWFsZGlzcGxheQ==",highlighted:`%%capture
!apt install python-opengl
!apt install ffmpeg
!apt install xvfb
!pip3 install pyvirtualdisplay`,wrap:!1}}),O=new d({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),ee=new f({props:{title:"Install dependencies 🔽",local:"install-dependencies-",headingTag:"h3"}}),ne=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzdGFibGUtYmFzZWxpbmVzMyU1QmV4dHJhJTVEJTBBIXBpcCUyMGluc3RhbGwlMjBneW1uYXNpdW0lMEEhcGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX3NiMyUwQSFwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHViJTBBIXBpcCUyMGluc3RhbGwlMjBwYW5kYV9neW0=",highlighted:`!pip install stable-baselines3[extra]
!pip install gymnasium
!pip install huggingface_sb3
!pip install huggingface_hub
!pip install panda_gym`,wrap:!1}}),se=new f({props:{title:"Import the packages 📦",local:"import-the-packages-",headingTag:"h2"}}),ae=new d({props:{code:"aW1wb3J0JTIwb3MlMEElMEFpbXBvcnQlMjBneW1uYXNpdW0lMjBhcyUyMGd5bSUwQWltcG9ydCUyMHBhbmRhX2d5bSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9zYjMlMjBpbXBvcnQlMjBsb2FkX2Zyb21faHViJTJDJTIwcGFja2FnZV90b19odWIlMEElMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMlMjBpbXBvcnQlMjBBMkMlMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMuY29tbW9uLmV2YWx1YXRpb24lMjBpbXBvcnQlMjBldmFsdWF0ZV9wb2xpY3klMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMuY29tbW9uLnZlY19lbnYlMjBpbXBvcnQlMjBEdW1teVZlY0VudiUyQyUyMFZlY05vcm1hbGl6ZSUwQWZyb20lMjBzdGFibGVfYmFzZWxpbmVzMy5jb21tb24uZW52X3V0aWwlMjBpbXBvcnQlMjBtYWtlX3ZlY19lbnYlMEElMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbm90ZWJvb2tfbG9naW4=",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym
<span class="hljs-keyword">import</span> panda_gym

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> load_from_hub, package_to_hub

<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> A2C
<span class="hljs-keyword">from</span> stable_baselines3.common.evaluation <span class="hljs-keyword">import</span> evaluate_policy
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv, VecNormalize
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login`,wrap:!1}}),ie=new f({props:{title:"PandaReachDense-v3 🦾",local:"pandareachdense-v3-",headingTag:"h2"}}),ce=new f({props:{title:"Create the environment",local:"create-the-environment",headingTag:"h3"}}),fe=new f({props:{title:"The environment 🎮",local:"the-environment-",headingTag:"h4"}}),ye=new d({props:{code:"ZW52X2lkJTIwJTNEJTIwJTIyUGFuZGFSZWFjaERlbnNlLXYzJTIyJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwZW52JTBBZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQSUwQSUyMyUyMEdldCUyMHRoZSUyMHN0YXRlJTIwc3BhY2UlMjBhbmQlMjBhY3Rpb24lMjBzcGFjZSUwQXNfc2l6ZSUyMCUzRCUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zaGFwZSUwQWFfc2l6ZSUyMCUzRCUyMGVudi5hY3Rpb25fc3BhY2U=",highlighted:`env_id = <span class="hljs-string">&quot;PandaReachDense-v3&quot;</span>

<span class="hljs-comment"># Create the env</span>
env = gym.make(env_id)

<span class="hljs-comment"># Get the state space and action space</span>
s_size = env.observation_space.shape
a_size = env.action_space`,wrap:!1}}),be=new d({props:{code:"cHJpbnQoJTIyX19fX19PQlNFUlZBVElPTiUyMFNQQUNFX19fX18lMjAlNUNuJTIyKSUwQXByaW50KCUyMlRoZSUyMFN0YXRlJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMHNfc2l6ZSklMEFwcmludCglMjJTYW1wbGUlMjBvYnNlcnZhdGlvbiUyMiUyQyUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zYW1wbGUoKSklMjAlMjMlMjBHZXQlMjBhJTIwcmFuZG9tJTIwb2JzZXJ2YXRpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The State Space is: &quot;</span>, s_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample()) <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),ve=new d({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyVGhlJTIwQWN0aW9uJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMGFfc2l6ZSklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The Action Space is: &quot;</span>, a_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample()) <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),$e=new f({props:{title:"Normalize observation and rewards",local:"normalize-observation-and-rewards",headingTag:"h3"}}),Ie=new d({props:{code:"ZW52JTIwJTNEJTIwbWFrZV92ZWNfZW52KGVudl9pZCUyQyUyMG5fZW52cyUzRDQpJTBBJTBBJTIzJTIwQWRkaW5nJTIwdGhpcyUyMHdyYXBwZXIlMjB0byUyMG5vcm1hbGl6ZSUyMHRoZSUyMG9ic2VydmF0aW9uJTIwYW5kJTIwdGhlJTIwcmV3YXJkJTBBZW52JTIwJTNEJTIwJTIzJTIwVE9ETyUzQSUyMEFkZCUyMHRoZSUyMHdyYXBwZXI=",highlighted:`env = make_vec_env(env_id, n_envs=<span class="hljs-number">4</span>)

<span class="hljs-comment"># Adding this wrapper to normalize the observation and the reward</span>
env = <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Add the wrapper</span>`,wrap:!1}}),We=new f({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Be=new d({props:{code:"ZW52JTIwJTNEJTIwbWFrZV92ZWNfZW52KGVudl9pZCUyQyUyMG5fZW52cyUzRDQpJTBBJTBBZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplKGVudiUyQyUyMG5vcm1fb2JzJTNEVHJ1ZSUyQyUyMG5vcm1fcmV3YXJkJTNEVHJ1ZSUyQyUyMGNsaXBfb2JzJTNEMTAuKQ==",highlighted:`env = make_vec_env(env_id, n_envs=<span class="hljs-number">4</span>)

env = VecNormalize(env, norm_obs=<span class="hljs-literal">True</span>, norm_reward=<span class="hljs-literal">True</span>, clip_obs=<span class="hljs-number">10.</span>)`,wrap:!1}}),ke=new f({props:{title:"Create the A2C Model 🤖",local:"create-the-a2c-model-",headingTag:"h3"}}),He=new d({props:{code:"bW9kZWwlMjAlM0QlMjAlMjMlMjBDcmVhdGUlMjB0aGUlMjBBMkMlMjBtb2RlbCUyMGFuZCUyMHRyeSUyMHRvJTIwZmluZCUyMHRoZSUyMGJlc3QlMjBwYXJhbWV0ZXJz",highlighted:'model = <span class="hljs-comment"># Create the A2C model and try to find the best parameters</span>',wrap:!1}}),xe=new f({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Qe=new d({props:{code:"bW9kZWwlMjAlM0QlMjBBMkMocG9saWN5JTIwJTNEJTIwJTIyTXVsdGlJbnB1dFBvbGljeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudiUyMCUzRCUyMGVudiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZlcmJvc2UlM0QxKQ==",highlighted:`model = A2C(policy = <span class="hljs-string">&quot;MultiInputPolicy&quot;</span>,
            env = env,
            verbose=<span class="hljs-number">1</span>)`,wrap:!1}}),Le=new f({props:{title:"Train the A2C agent 🏃",local:"train-the-a2c-agent-",headingTag:"h3"}}),Fe=new d({props:{code:"bW9kZWwubGVhcm4oMV8wMDBfMDAwKQ==",highlighted:'model.learn(<span class="hljs-number">1_000_000</span>)',wrap:!1}}),Se=new d({props:{code:"JTIzJTIwU2F2ZSUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwJTIwVmVjTm9ybWFsaXplJTIwc3RhdGlzdGljcyUyMHdoZW4lMjBzYXZpbmclMjB0aGUlMjBhZ2VudCUwQW1vZGVsLnNhdmUoJTIyYTJjLVBhbmRhUmVhY2hEZW5zZS12MyUyMiklMEFlbnYuc2F2ZSglMjJ2ZWNfbm9ybWFsaXplLnBrbCUyMik=",highlighted:`<span class="hljs-comment"># Save the model and  VecNormalize statistics when saving the agent</span>
model.save(<span class="hljs-string">&quot;a2c-PandaReachDense-v3&quot;</span>)
env.save(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>)`,wrap:!1}}),Xe=new f({props:{title:"Evaluate the agent 📈",local:"evaluate-the-agent-",headingTag:"h3"}}),ze=new d({props:{code:"ZnJvbSUyMHN0YWJsZV9iYXNlbGluZXMzLmNvbW1vbi52ZWNfZW52JTIwaW1wb3J0JTIwRHVtbXlWZWNFbnYlMkMlMjBWZWNOb3JtYWxpemUlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwc2F2ZWQlMjBzdGF0aXN0aWNzJTBBZXZhbF9lbnYlMjAlM0QlMjBEdW1teVZlY0VudiglNUJsYW1iZGElM0ElMjBneW0ubWFrZSglMjJQYW5kYVJlYWNoRGVuc2UtdjMlMjIpJTVEKSUwQWV2YWxfZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplLmxvYWQoJTIydmVjX25vcm1hbGl6ZS5wa2wlMjIlMkMlMjBldmFsX2VudiklMEElMEElMjMlMjBXZSUyMG5lZWQlMjB0byUyMG92ZXJyaWRlJTIwdGhlJTIwcmVuZGVyX21vZGUlMEFldmFsX2Vudi5yZW5kZXJfbW9kZSUyMCUzRCUyMCUyMnJnYl9hcnJheSUyMiUwQSUwQSUyMyUyMCUyMGRvJTIwbm90JTIwdXBkYXRlJTIwdGhlbSUyMGF0JTIwdGVzdCUyMHRpbWUlMEFldmFsX2Vudi50cmFpbmluZyUyMCUzRCUyMEZhbHNlJTBBJTIzJTIwcmV3YXJkJTIwbm9ybWFsaXphdGlvbiUyMGlzJTIwbm90JTIwbmVlZGVkJTIwYXQlMjB0ZXN0JTIwdGltZSUwQWV2YWxfZW52Lm5vcm1fcmV3YXJkJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwYWdlbnQlMEFtb2RlbCUyMCUzRCUyMEEyQy5sb2FkKCUyMmEyYy1QYW5kYVJlYWNoRGVuc2UtdjMlMjIpJTBBJTBBbWVhbl9yZXdhcmQlMkMlMjBzdGRfcmV3YXJkJTIwJTNEJTIwZXZhbHVhdGVfcG9saWN5KG1vZGVsJTJDJTIwZXZhbF9lbnYpJTBBJTBBcHJpbnQoZiUyMk1lYW4lMjByZXdhcmQlMjAlM0QlMjAlN0JtZWFuX3Jld2FyZCUzQS4yZiU3RCUyMCUyQiUyRi0lMjAlN0JzdGRfcmV3YXJkJTNBLjJmJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv, VecNormalize

<span class="hljs-comment"># Load the saved statistics</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: gym.make(<span class="hljs-string">&quot;PandaReachDense-v3&quot;</span>)])
eval_env = VecNormalize.load(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>, eval_env)

<span class="hljs-comment"># We need to override the render_mode</span>
eval_env.render_mode = <span class="hljs-string">&quot;rgb_array&quot;</span>

<span class="hljs-comment">#  do not update them at test time</span>
eval_env.training = <span class="hljs-literal">False</span>
<span class="hljs-comment"># reward normalization is not needed at test time</span>
eval_env.norm_reward = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the agent</span>
model = A2C.load(<span class="hljs-string">&quot;a2c-PandaReachDense-v3&quot;</span>)

mean_reward, std_reward = evaluate_policy(model, eval_env)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Mean reward = <span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),Re=new f({props:{title:"Publish your trained model on the Hub 🔥",local:"publish-your-trained-model-on-the-hub-",headingTag:"h3"}}),st=new d({props:{code:"bm90ZWJvb2tfbG9naW4oKSUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`notebook_login()
!git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),ot=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX3NiMyUyMGltcG9ydCUyMHBhY2thZ2VfdG9faHViJTBBJTBBcGFja2FnZV90b19odWIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RmJTIyYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2FyY2hpdGVjdHVyZSUzRCUyMkEyQyUyMiUyQyUwQSUyMCUyMCUyMCUyMGVudl9pZCUzRGVudl9pZCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZW52JTNEZXZhbF9lbnYlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEZiUyMlRob21hc1NpbW9uaW5pJTJGYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUyMCUyMyUyMENoYW5nZSUyMHRoZSUyMHVzZXJuYW1lJTBBJTIwJTIwJTIwJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJJbml0aWFsJTIwY29tbWl0JTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> package_to_hub

package_to_hub(
    model=model,
    model_name=<span class="hljs-string">f&quot;a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>,
    model_architecture=<span class="hljs-string">&quot;A2C&quot;</span>,
    env_id=env_id,
    eval_env=eval_env,
    repo_id=<span class="hljs-string">f&quot;ThomasSimonini/a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>, <span class="hljs-comment"># Change the username</span>
    commit_message=<span class="hljs-string">&quot;Initial commit&quot;</span>,
)`,wrap:!1}}),pt=new f({props:{title:"Some additional challenges 🏆",local:"some-additional-challenges-",headingTag:"h2"}}),ft=new f({props:{title:"Solution (optional)",local:"solution-optional",headingTag:"h3"}}),dt=new d({props:{code:"JTIzJTIwMSUyMC0lMjAyJTBBZW52X2lkJTIwJTNEJTIwJTIyUGFuZGFQaWNrQW5kUGxhY2UtdjMlMjIlMEFlbnYlMjAlM0QlMjBtYWtlX3ZlY19lbnYoZW52X2lkJTJDJTIwbl9lbnZzJTNENCklMEElMEElMjMlMjAzJTBBZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplKGVudiUyQyUyMG5vcm1fb2JzJTNEVHJ1ZSUyQyUyMG5vcm1fcmV3YXJkJTNEVHJ1ZSUyQyUyMGNsaXBfb2JzJTNEMTAuKSUwQSUwQSUyMyUyMDQlMEFtb2RlbCUyMCUzRCUyMEEyQyhwb2xpY3klMjAlM0QlMjAlMjJNdWx0aUlucHV0UG9saWN5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW52JTIwJTNEJTIwZW52JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmVyYm9zZSUzRDEpJTBBJTIzJTIwNSUwQW1vZGVsLmxlYXJuKDFfMDAwXzAwMCk=",highlighted:`<span class="hljs-comment"># 1 - 2</span>
env_id = <span class="hljs-string">&quot;PandaPickAndPlace-v3&quot;</span>
env = make_vec_env(env_id, n_envs=<span class="hljs-number">4</span>)

<span class="hljs-comment"># 3</span>
env = VecNormalize(env, norm_obs=<span class="hljs-literal">True</span>, norm_reward=<span class="hljs-literal">True</span>, clip_obs=<span class="hljs-number">10.</span>)

<span class="hljs-comment"># 4</span>
model = A2C(policy = <span class="hljs-string">&quot;MultiInputPolicy&quot;</span>,
            env = env,
            verbose=<span class="hljs-number">1</span>)
<span class="hljs-comment"># 5</span>
model.learn(<span class="hljs-number">1_000_000</span>)`,wrap:!1}}),yt=new d({props:{code:"JTIzJTIwNiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJhMmMtUGFuZGFQaWNrQW5kUGxhY2UtdjMlMjIlM0IlMEFtb2RlbC5zYXZlKG1vZGVsX25hbWUpJTBBZW52LnNhdmUoJTIydmVjX25vcm1hbGl6ZS5wa2wlMjIpJTBBJTBBJTIzJTIwNyUwQWZyb20lMjBzdGFibGVfYmFzZWxpbmVzMy5jb21tb24udmVjX2VudiUyMGltcG9ydCUyMER1bW15VmVjRW52JTJDJTIwVmVjTm9ybWFsaXplJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMHNhdmVkJTIwc3RhdGlzdGljcyUwQWV2YWxfZW52JTIwJTNEJTIwRHVtbXlWZWNFbnYoJTVCbGFtYmRhJTNBJTIwZ3ltLm1ha2UoJTIyUGFuZGFQaWNrQW5kUGxhY2UtdjMlMjIpJTVEKSUwQWV2YWxfZW52JTIwJTNEJTIwVmVjTm9ybWFsaXplLmxvYWQoJTIydmVjX25vcm1hbGl6ZS5wa2wlMjIlMkMlMjBldmFsX2VudiklMEElMEElMjMlMjAlMjBkbyUyMG5vdCUyMHVwZGF0ZSUyMHRoZW0lMjBhdCUyMHRlc3QlMjB0aW1lJTBBZXZhbF9lbnYudHJhaW5pbmclMjAlM0QlMjBGYWxzZSUwQSUyMyUyMHJld2FyZCUyMG5vcm1hbGl6YXRpb24lMjBpcyUyMG5vdCUyMG5lZWRlZCUyMGF0JTIwdGVzdCUyMHRpbWUlMEFldmFsX2Vudi5ub3JtX3Jld2FyZCUyMCUzRCUyMEZhbHNlJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMGFnZW50JTBBbW9kZWwlMjAlM0QlMjBBMkMubG9hZChtb2RlbF9uYW1lKSUwQSUwQW1lYW5fcmV3YXJkJTJDJTIwc3RkX3Jld2FyZCUyMCUzRCUyMGV2YWx1YXRlX3BvbGljeShtb2RlbCUyQyUyMGV2YWxfZW52KSUwQSUwQXByaW50KGYlMjJNZWFuJTIwcmV3YXJkJTIwJTNEJTIwJTdCbWVhbl9yZXdhcmQlM0EuMmYlN0QlMjAlMkIlMkYtJTIwJTdCc3RkX3Jld2FyZCUzQS4yZiU3RCUyMiklMEElMEElMjMlMjA4JTBBcGFja2FnZV90b19odWIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RmJTIyYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2FyY2hpdGVjdHVyZSUzRCUyMkEyQyUyMiUyQyUwQSUyMCUyMCUyMCUyMGVudl9pZCUzRGVudl9pZCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZW52JTNEZXZhbF9lbnYlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEZiUyMlRob21hc1NpbW9uaW5pJTJGYTJjLSU3QmVudl9pZCU3RCUyMiUyQyUyMCUyMyUyMFRPRE8lM0ElMjBDaGFuZ2UlMjB0aGUlMjB1c2VybmFtZSUwQSUyMCUyMCUyMCUyMGNvbW1pdF9tZXNzYWdlJTNEJTIySW5pdGlhbCUyMGNvbW1pdCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-comment"># 6</span>
model_name = <span class="hljs-string">&quot;a2c-PandaPickAndPlace-v3&quot;</span>;
model.save(model_name)
env.save(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>)

<span class="hljs-comment"># 7</span>
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv, VecNormalize

<span class="hljs-comment"># Load the saved statistics</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: gym.make(<span class="hljs-string">&quot;PandaPickAndPlace-v3&quot;</span>)])
eval_env = VecNormalize.load(<span class="hljs-string">&quot;vec_normalize.pkl&quot;</span>, eval_env)

<span class="hljs-comment">#  do not update them at test time</span>
eval_env.training = <span class="hljs-literal">False</span>
<span class="hljs-comment"># reward normalization is not needed at test time</span>
eval_env.norm_reward = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the agent</span>
model = A2C.load(model_name)

mean_reward, std_reward = evaluate_policy(model, eval_env)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Mean reward = <span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

<span class="hljs-comment"># 8</span>
package_to_hub(
    model=model,
    model_name=<span class="hljs-string">f&quot;a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>,
    model_architecture=<span class="hljs-string">&quot;A2C&quot;</span>,
    env_id=env_id,
    eval_env=eval_env,
    repo_id=<span class="hljs-string">f&quot;ThomasSimonini/a2c-<span class="hljs-subst">{env_id}</span>&quot;</span>, <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Change the username</span>
    commit_message=<span class="hljs-string">&quot;Initial commit&quot;</span>,
)`,wrap:!1}}),wt=new f({props:{title:"Keep learning, stay awesome 🤗",local:"keep-learning-stay-awesome-",headingTag:"h2"}}),{c(){b=i("meta"),vt=s(),gt=i("p"),Ut=s(),r(w.$$.fragment),Jt=s(),r(g.$$.fragment),$t=s(),T=i("p"),T.innerHTML=Zn,jt=s(),v=i("ul"),v.innerHTML=In,Ct=s(),U=i("p"),U.textContent=Wn,_t=s(),J=i("ul"),J.innerHTML=Bn,Zt=s(),$=i("p"),$.textContent=kn,It=s(),j=i("ul"),j.innerHTML=Gn,Wt=s(),C=i("p"),C.innerHTML=Vn,Bt=s(),_=i("p"),_.innerHTML=Hn,kt=s(),Z=i("p"),Z.innerHTML=xn,Gt=s(),I=i("p"),I.innerHTML=Qn,Vt=s(),r(W.$$.fragment),Ht=s(),r(B.$$.fragment),xt=s(),k=i("ul"),k.innerHTML=Ln,Qt=s(),r(G.$$.fragment),Lt=s(),V=i("ul"),V.innerHTML=Yn,Yt=s(),H=i("p"),H.innerHTML=Fn,Ft=s(),r(x.$$.fragment),St=s(),Q=i("p"),Q.textContent=Sn,Xt=s(),L=i("ul"),L.innerHTML=Xn,Et=s(),r(Y.$$.fragment),zt=s(),F=i("p"),F.textContent=En,Rt=s(),S=i("p"),S.innerHTML=zn,Nt=s(),r(X.$$.fragment),Pt=s(),r(E.$$.fragment),At=s(),z=i("ul"),z.innerHTML=Rn,qt=s(),R=i("img"),Dt=s(),N=i("ul"),N.innerHTML=Pn,Kt=s(),P=i("img"),Ot=s(),r(A.$$.fragment),el=s(),q=i("p"),q.innerHTML=qn,tl=s(),D=i("p"),D.textContent=Dn,ll=s(),r(K.$$.fragment),nl=s(),r(O.$$.fragment),sl=s(),r(ee.$$.fragment),al=s(),te=i("p"),te.textContent=Kn,il=s(),le=i("ul"),le.innerHTML=On,ol=s(),r(ne.$$.fragment),pl=s(),r(se.$$.fragment),rl=s(),r(ae.$$.fragment),ml=s(),r(ie.$$.fragment),ul=s(),oe=i("p"),oe.textContent=es,hl=s(),pe=i("p"),pe.innerHTML=ts,Ml=s(),re=i("p"),re.innerHTML=ls,cl=s(),me=i("p"),me.innerHTML=ns,fl=s(),ue=i("p"),ue.innerHTML=ss,dl=s(),he=i("img"),yl=s(),Me=i("p"),Me.innerHTML=is,bl=s(),r(ce.$$.fragment),wl=s(),r(fe.$$.fragment),gl=s(),de=i("p"),de.innerHTML=os,Tl=s(),r(ye.$$.fragment),vl=s(),r(be.$$.fragment),Ul=s(),we=i("p"),we.innerHTML=ps,Jl=s(),ge=i("ul"),ge.innerHTML=rs,$l=s(),Te=i("p"),Te.innerHTML=ms,jl=s(),r(ve.$$.fragment),Cl=s(),Ue=i("p"),Ue.textContent=us,_l=s(),Je=i("ul"),Je.innerHTML=hs,Zl=s(),r($e.$$.fragment),Il=s(),je=i("p"),je.innerHTML=Ms,Wl=s(),Ce=i("p"),Ce.textContent=cs,Bl=s(),_e=i("p"),_e.innerHTML=fs,kl=s(),Ze=i("p"),Ze.innerHTML=ds,Gl=s(),r(Ie.$$.fragment),Vl=s(),r(We.$$.fragment),Hl=s(),r(Be.$$.fragment),xl=s(),r(ke.$$.fragment),Ql=s(),Ge=i("p"),Ge.innerHTML=ys,Ll=s(),Ve=i("p"),Ve.innerHTML=bs,Yl=s(),r(He.$$.fragment),Fl=s(),r(xe.$$.fragment),Sl=s(),r(Qe.$$.fragment),Xl=s(),r(Le.$$.fragment),El=s(),Ye=i("ul"),Ye.innerHTML=ws,zl=s(),r(Fe.$$.fragment),Rl=s(),r(Se.$$.fragment),Nl=s(),r(Xe.$$.fragment),Pl=s(),Ee=i("ul"),Ee.innerHTML=gs,Al=s(),r(ze.$$.fragment),ql=s(),r(Re.$$.fragment),Dl=s(),Ne=i("p"),Ne.textContent=Ts,Kl=s(),Pe=i("p"),Pe.innerHTML=vs,Ol=s(),Ae=i("p"),Ae.innerHTML=Us,en=s(),qe=i("p"),qe.textContent=Js,tn=s(),De=i("ul"),De.innerHTML=$s,ln=s(),Ke=i("p"),Ke.textContent=js,nn=s(),Oe=i("p"),Oe.innerHTML=Cs,sn=s(),et=i("p"),et.textContent=_s,an=s(),tt=i("ul"),tt.innerHTML=Zs,on=s(),lt=i("img"),pn=s(),nt=i("ul"),nt.innerHTML=Ws,rn=s(),r(st.$$.fragment),mn=s(),at=i("p"),at.innerHTML=Bs,un=s(),it=i("p"),it.innerHTML=ks,hn=s(),r(ot.$$.fragment),Mn=s(),r(pt.$$.fragment),cn=s(),rt=i("p"),rt.innerHTML=Gs,fn=s(),mt=i("p"),mt.innerHTML=Vs,dn=s(),ut=i("p"),ut.innerHTML=Hs,yn=s(),ht=i("p"),ht.innerHTML=xs,bn=s(),Mt=i("p"),Mt.textContent=Qs,wn=s(),ct=i("ol"),ct.innerHTML=Ls,gn=s(),r(ft.$$.fragment),Tn=s(),r(dt.$$.fragment),vn=s(),r(yt.$$.fragment),Un=s(),bt=i("p"),bt.textContent=Ys,Jn=s(),r(wt.$$.fragment),$n=s(),Tt=i("p"),this.h()},l(e){const t=Ns("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),vt=a(e),gt=o(e,"P",{}),Fs(gt).forEach(l),Ut=a(e),m(w.$$.fragment,e),Jt=a(e),m(g.$$.fragment,e),$t=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1v5g4pl"&&(T.innerHTML=Zn),jt=a(e),v=o(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-10o7xql"&&(v.innerHTML=In),Ct=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-f6gxjq"&&(U.textContent=Wn),_t=a(e),J=o(e,"UL",{"data-svelte-h":!0}),p(J)!=="svelte-1sbq1c5"&&(J.innerHTML=Bn),Zt=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-30j4nk"&&($.textContent=kn),It=a(e),j=o(e,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-1f7nbkh"&&(j.innerHTML=Gn),Wt=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-13r3vs2"&&(C.innerHTML=Vn),Bt=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1qkxyrx"&&(_.innerHTML=Hn),kt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-10pdw2g"&&(Z.innerHTML=xn),Gt=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-t0f4sr"&&(I.innerHTML=Qn),Vt=a(e),m(W.$$.fragment,e),Ht=a(e),m(B.$$.fragment,e),xt=a(e),k=o(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-w3db45"&&(k.innerHTML=Ln),Qt=a(e),m(G.$$.fragment,e),Lt=a(e),V=o(e,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-11wwfn0"&&(V.innerHTML=Yn),Yt=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-qqj2y4"&&(H.innerHTML=Fn),Ft=a(e),m(x.$$.fragment,e),St=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-nsjs09"&&(Q.textContent=Sn),Xt=a(e),L=o(e,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-1eap3pb"&&(L.innerHTML=Xn),Et=a(e),m(Y.$$.fragment,e),zt=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1v25wk6"&&(F.textContent=En),Rt=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-rlt93v"&&(S.innerHTML=zn),Nt=a(e),m(X.$$.fragment,e),Pt=a(e),m(E.$$.fragment,e),At=a(e),z=o(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1funvfi"&&(z.innerHTML=Rn),qt=a(e),R=o(e,"IMG",{src:!0,alt:!0}),Dt=a(e),N=o(e,"UL",{"data-svelte-h":!0}),p(N)!=="svelte-1cge6gn"&&(N.innerHTML=Pn),Kt=a(e),P=o(e,"IMG",{src:!0,alt:!0}),Ot=a(e),m(A.$$.fragment,e),el=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-pdx5k3"&&(q.innerHTML=qn),tl=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-tsd2zd"&&(D.textContent=Dn),ll=a(e),m(K.$$.fragment,e),nl=a(e),m(O.$$.fragment,e),sl=a(e),m(ee.$$.fragment,e),al=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-p5tnmj"&&(te.textContent=Kn),il=a(e),le=o(e,"UL",{"data-svelte-h":!0}),p(le)!=="svelte-homj1k"&&(le.innerHTML=On),ol=a(e),m(ne.$$.fragment,e),pl=a(e),m(se.$$.fragment,e),rl=a(e),m(ae.$$.fragment,e),ml=a(e),m(ie.$$.fragment,e),ul=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-e8xztq"&&(oe.textContent=es),hl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1ahmo9k"&&(pe.innerHTML=ts),Ml=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1xkj275"&&(re.innerHTML=ls),cl=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1lvp1mx"&&(me.innerHTML=ns),fl=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1eh1xh8"&&(ue.innerHTML=ss),dl=a(e),he=o(e,"IMG",{src:!0,alt:!0}),yl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1wf8xm5"&&(Me.innerHTML=is),bl=a(e),m(ce.$$.fragment,e),wl=a(e),m(fe.$$.fragment,e),gl=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-xvsrum"&&(de.innerHTML=os),Tl=a(e),m(ye.$$.fragment,e),vl=a(e),m(be.$$.fragment,e),Ul=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-33hohs"&&(we.innerHTML=ps),Jl=a(e),ge=o(e,"UL",{"data-svelte-h":!0}),p(ge)!=="svelte-1lszzw1"&&(ge.innerHTML=rs),$l=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-27bxb4"&&(Te.innerHTML=ms),jl=a(e),m(ve.$$.fragment,e),Cl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1o9n9bc"&&(Ue.textContent=us),_l=a(e),Je=o(e,"UL",{"data-svelte-h":!0}),p(Je)!=="svelte-pf09j6"&&(Je.innerHTML=hs),Zl=a(e),m($e.$$.fragment,e),Il=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-to6bf0"&&(je.innerHTML=Ms),Wl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1tj0ynw"&&(Ce.textContent=cs),Bl=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1a42rkj"&&(_e.innerHTML=fs),kl=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-e6bsr5"&&(Ze.innerHTML=ds),Gl=a(e),m(Ie.$$.fragment,e),Vl=a(e),m(We.$$.fragment,e),Hl=a(e),m(Be.$$.fragment,e),xl=a(e),m(ke.$$.fragment,e),Ql=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-15t97zk"&&(Ge.innerHTML=ys),Ll=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1n4jzw0"&&(Ve.innerHTML=bs),Yl=a(e),m(He.$$.fragment,e),Fl=a(e),m(xe.$$.fragment,e),Sl=a(e),m(Qe.$$.fragment,e),Xl=a(e),m(Le.$$.fragment,e),El=a(e),Ye=o(e,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-f47qdr"&&(Ye.innerHTML=ws),zl=a(e),m(Fe.$$.fragment,e),Rl=a(e),m(Se.$$.fragment,e),Nl=a(e),m(Xe.$$.fragment,e),Pl=a(e),Ee=o(e,"UL",{"data-svelte-h":!0}),p(Ee)!=="svelte-bfd0w6"&&(Ee.innerHTML=gs),Al=a(e),m(ze.$$.fragment,e),ql=a(e),m(Re.$$.fragment,e),Dl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1hqv8cs"&&(Ne.textContent=Ts),Kl=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1vcevn6"&&(Pe.innerHTML=vs),Ol=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1j3gce8"&&(Ae.innerHTML=Us),en=a(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-vgzxi7"&&(qe.textContent=Js),tn=a(e),De=o(e,"UL",{"data-svelte-h":!0}),p(De)!=="svelte-19ddql5"&&(De.innerHTML=$s),ln=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-6k9qpu"&&(Ke.textContent=js),nn=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-932u9c"&&(Oe.innerHTML=Cs),sn=a(e),et=o(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1cn3tld"&&(et.textContent=_s),an=a(e),tt=o(e,"UL",{"data-svelte-h":!0}),p(tt)!=="svelte-19b5tev"&&(tt.innerHTML=Zs),on=a(e),lt=o(e,"IMG",{src:!0,alt:!0}),pn=a(e),nt=o(e,"UL",{"data-svelte-h":!0}),p(nt)!=="svelte-mbo7r4"&&(nt.innerHTML=Ws),rn=a(e),m(st.$$.fragment,e),mn=a(e),at=o(e,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1g9v6di"&&(at.innerHTML=Bs),un=a(e),it=o(e,"P",{"data-svelte-h":!0}),p(it)!=="svelte-13wg35g"&&(it.innerHTML=ks),hn=a(e),m(ot.$$.fragment,e),Mn=a(e),m(pt.$$.fragment,e),cn=a(e),rt=o(e,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-o2mw87"&&(rt.innerHTML=Gs),fn=a(e),mt=o(e,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-10ft4lt"&&(mt.innerHTML=Vs),dn=a(e),ut=o(e,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-11q3awl"&&(ut.innerHTML=Hs),yn=a(e),ht=o(e,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-orosy6"&&(ht.innerHTML=xs),bn=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-75fqx0"&&(Mt.textContent=Qs),wn=a(e),ct=o(e,"OL",{"data-svelte-h":!0}),p(ct)!=="svelte-k2am8z"&&(ct.innerHTML=Ls),gn=a(e),m(ft.$$.fragment,e),Tn=a(e),m(dt.$$.fragment,e),vn=a(e),m(yt.$$.fragment,e),Un=a(e),bt=o(e,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-1szhxef"&&(bt.textContent=Ys),Jn=a(e),m(wt.$$.fragment,e),$n=a(e),Tt=o(e,"P",{}),Fs(Tt).forEach(l),this.h()},h(){y(b,"name","hf:doc:metadata"),y(b,"content",Ds),Cn(R.src,Nn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||y(R,"src",Nn),y(R,"alt","GPU Step 1"),Cn(P.src,An="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||y(P,"src",An),y(P,"alt","GPU Step 2"),Cn(he.src,as="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit8/robotics.jpg")||y(he,"src",as),y(he,"alt","Robotics"),Cn(lt.src,Is="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||y(lt,"src",Is),y(lt,"alt","Create HF Token")},m(e,t){Ps(document.head,b),n(e,vt,t),n(e,gt,t),n(e,Ut,t),u(w,e,t),n(e,Jt,t),u(g,e,t),n(e,$t,t),n(e,T,t),n(e,jt,t),n(e,v,t),n(e,Ct,t),n(e,U,t),n(e,_t,t),n(e,J,t),n(e,Zt,t),n(e,$,t),n(e,It,t),n(e,j,t),n(e,Wt,t),n(e,C,t),n(e,Bt,t),n(e,_,t),n(e,kt,t),n(e,Z,t),n(e,Gt,t),n(e,I,t),n(e,Vt,t),u(W,e,t),n(e,Ht,t),u(B,e,t),n(e,xt,t),n(e,k,t),n(e,Qt,t),u(G,e,t),n(e,Lt,t),n(e,V,t),n(e,Yt,t),n(e,H,t),n(e,Ft,t),u(x,e,t),n(e,St,t),n(e,Q,t),n(e,Xt,t),n(e,L,t),n(e,Et,t),u(Y,e,t),n(e,zt,t),n(e,F,t),n(e,Rt,t),n(e,S,t),n(e,Nt,t),u(X,e,t),n(e,Pt,t),u(E,e,t),n(e,At,t),n(e,z,t),n(e,qt,t),n(e,R,t),n(e,Dt,t),n(e,N,t),n(e,Kt,t),n(e,P,t),n(e,Ot,t),u(A,e,t),n(e,el,t),n(e,q,t),n(e,tl,t),n(e,D,t),n(e,ll,t),u(K,e,t),n(e,nl,t),u(O,e,t),n(e,sl,t),u(ee,e,t),n(e,al,t),n(e,te,t),n(e,il,t),n(e,le,t),n(e,ol,t),u(ne,e,t),n(e,pl,t),u(se,e,t),n(e,rl,t),u(ae,e,t),n(e,ml,t),u(ie,e,t),n(e,ul,t),n(e,oe,t),n(e,hl,t),n(e,pe,t),n(e,Ml,t),n(e,re,t),n(e,cl,t),n(e,me,t),n(e,fl,t),n(e,ue,t),n(e,dl,t),n(e,he,t),n(e,yl,t),n(e,Me,t),n(e,bl,t),u(ce,e,t),n(e,wl,t),u(fe,e,t),n(e,gl,t),n(e,de,t),n(e,Tl,t),u(ye,e,t),n(e,vl,t),u(be,e,t),n(e,Ul,t),n(e,we,t),n(e,Jl,t),n(e,ge,t),n(e,$l,t),n(e,Te,t),n(e,jl,t),u(ve,e,t),n(e,Cl,t),n(e,Ue,t),n(e,_l,t),n(e,Je,t),n(e,Zl,t),u($e,e,t),n(e,Il,t),n(e,je,t),n(e,Wl,t),n(e,Ce,t),n(e,Bl,t),n(e,_e,t),n(e,kl,t),n(e,Ze,t),n(e,Gl,t),u(Ie,e,t),n(e,Vl,t),u(We,e,t),n(e,Hl,t),u(Be,e,t),n(e,xl,t),u(ke,e,t),n(e,Ql,t),n(e,Ge,t),n(e,Ll,t),n(e,Ve,t),n(e,Yl,t),u(He,e,t),n(e,Fl,t),u(xe,e,t),n(e,Sl,t),u(Qe,e,t),n(e,Xl,t),u(Le,e,t),n(e,El,t),n(e,Ye,t),n(e,zl,t),u(Fe,e,t),n(e,Rl,t),u(Se,e,t),n(e,Nl,t),u(Xe,e,t),n(e,Pl,t),n(e,Ee,t),n(e,Al,t),u(ze,e,t),n(e,ql,t),u(Re,e,t),n(e,Dl,t),n(e,Ne,t),n(e,Kl,t),n(e,Pe,t),n(e,Ol,t),n(e,Ae,t),n(e,en,t),n(e,qe,t),n(e,tn,t),n(e,De,t),n(e,ln,t),n(e,Ke,t),n(e,nn,t),n(e,Oe,t),n(e,sn,t),n(e,et,t),n(e,an,t),n(e,tt,t),n(e,on,t),n(e,lt,t),n(e,pn,t),n(e,nt,t),n(e,rn,t),u(st,e,t),n(e,mn,t),n(e,at,t),n(e,un,t),n(e,it,t),n(e,hn,t),u(ot,e,t),n(e,Mn,t),u(pt,e,t),n(e,cn,t),n(e,rt,t),n(e,fn,t),n(e,mt,t),n(e,dn,t),n(e,ut,t),n(e,yn,t),n(e,ht,t),n(e,bn,t),n(e,Mt,t),n(e,wn,t),n(e,ct,t),n(e,gn,t),u(ft,e,t),n(e,Tn,t),u(dt,e,t),n(e,vn,t),u(yt,e,t),n(e,Un,t),n(e,bt,t),n(e,Jn,t),u(wt,e,t),n(e,$n,t),n(e,Tt,t),jn=!0},p:Xs,i(e){jn||(h(w.$$.fragment,e),h(g.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(x.$$.fragment,e),h(Y.$$.fragment,e),h(X.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),h(fe.$$.fragment,e),h(ye.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h($e.$$.fragment,e),h(Ie.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(ke.$$.fragment,e),h(He.$$.fragment,e),h(xe.$$.fragment,e),h(Qe.$$.fragment,e),h(Le.$$.fragment,e),h(Fe.$$.fragment,e),h(Se.$$.fragment,e),h(Xe.$$.fragment,e),h(ze.$$.fragment,e),h(Re.$$.fragment,e),h(st.$$.fragment,e),h(ot.$$.fragment,e),h(pt.$$.fragment,e),h(ft.$$.fragment,e),h(dt.$$.fragment,e),h(yt.$$.fragment,e),h(wt.$$.fragment,e),jn=!0)},o(e){M(w.$$.fragment,e),M(g.$$.fragment,e),M(W.$$.fragment,e),M(B.$$.fragment,e),M(G.$$.fragment,e),M(x.$$.fragment,e),M(Y.$$.fragment,e),M(X.$$.fragment,e),M(E.$$.fragment,e),M(A.$$.fragment,e),M(K.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(ne.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(ce.$$.fragment,e),M(fe.$$.fragment,e),M(ye.$$.fragment,e),M(be.$$.fragment,e),M(ve.$$.fragment,e),M($e.$$.fragment,e),M(Ie.$$.fragment,e),M(We.$$.fragment,e),M(Be.$$.fragment,e),M(ke.$$.fragment,e),M(He.$$.fragment,e),M(xe.$$.fragment,e),M(Qe.$$.fragment,e),M(Le.$$.fragment,e),M(Fe.$$.fragment,e),M(Se.$$.fragment,e),M(Xe.$$.fragment,e),M(ze.$$.fragment,e),M(Re.$$.fragment,e),M(st.$$.fragment,e),M(ot.$$.fragment,e),M(pt.$$.fragment,e),M(ft.$$.fragment,e),M(dt.$$.fragment,e),M(yt.$$.fragment,e),M(wt.$$.fragment,e),jn=!1},d(e){e&&(l(vt),l(gt),l(Ut),l(Jt),l($t),l(T),l(jt),l(v),l(Ct),l(U),l(_t),l(J),l(Zt),l($),l(It),l(j),l(Wt),l(C),l(Bt),l(_),l(kt),l(Z),l(Gt),l(I),l(Vt),l(Ht),l(xt),l(k),l(Qt),l(Lt),l(V),l(Yt),l(H),l(Ft),l(St),l(Q),l(Xt),l(L),l(Et),l(zt),l(F),l(Rt),l(S),l(Nt),l(Pt),l(At),l(z),l(qt),l(R),l(Dt),l(N),l(Kt),l(P),l(Ot),l(el),l(q),l(tl),l(D),l(ll),l(nl),l(sl),l(al),l(te),l(il),l(le),l(ol),l(pl),l(rl),l(ml),l(ul),l(oe),l(hl),l(pe),l(Ml),l(re),l(cl),l(me),l(fl),l(ue),l(dl),l(he),l(yl),l(Me),l(bl),l(wl),l(gl),l(de),l(Tl),l(vl),l(Ul),l(we),l(Jl),l(ge),l($l),l(Te),l(jl),l(Cl),l(Ue),l(_l),l(Je),l(Zl),l(Il),l(je),l(Wl),l(Ce),l(Bl),l(_e),l(kl),l(Ze),l(Gl),l(Vl),l(Hl),l(xl),l(Ql),l(Ge),l(Ll),l(Ve),l(Yl),l(Fl),l(Sl),l(Xl),l(El),l(Ye),l(zl),l(Rl),l(Nl),l(Pl),l(Ee),l(Al),l(ql),l(Dl),l(Ne),l(Kl),l(Pe),l(Ol),l(Ae),l(en),l(qe),l(tn),l(De),l(ln),l(Ke),l(nn),l(Oe),l(sn),l(et),l(an),l(tt),l(on),l(lt),l(pn),l(nt),l(rn),l(mn),l(at),l(un),l(it),l(hn),l(Mn),l(cn),l(rt),l(fn),l(mt),l(dn),l(ut),l(yn),l(ht),l(bn),l(Mt),l(wn),l(ct),l(gn),l(Tn),l(vn),l(Un),l(bt),l(Jn),l($n),l(Tt)),l(b),c(w,e),c(g,e),c(W,e),c(B,e),c(G,e),c(x,e),c(Y,e),c(X,e),c(E,e),c(A,e),c(K,e),c(O,e),c(ee,e),c(ne,e),c(se,e),c(ae,e),c(ie,e),c(ce,e),c(fe,e),c(ye,e),c(be,e),c(ve,e),c($e,e),c(Ie,e),c(We,e),c(Be,e),c(ke,e),c(He,e),c(xe,e),c(Qe,e),c(Le,e),c(Fe,e),c(Se,e),c(Xe,e),c(ze,e),c(Re,e),c(st,e),c(ot,e),c(pt,e),c(ft,e),c(dt,e),c(yt,e),c(wt,e)}}}const Ds='{"title":"Advantage Actor Critic (A2C) using Robotics Simulations with Panda-Gym 🤖","local":"hands-on","sections":[],"depth":1}';function Ks(_n){return Es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sa extends zs{constructor(b){super(),Rs(this,b,Ks,qs,Ss,{})}}export{sa as component};
