import{s as ic,n as rc,o as dc}from"../chunks/scheduler.b108d059.js";import{S as ac,i as uc,g as i,s as n,r as u,A as mc,h as r,f as l,c as o,j as h,u as m,x as d,k as a,y as pc,a as s,v as p,d as c,t as f,w as T}from"../chunks/index.008de539.js";import{C as Uu}from"../chunks/CodeBlock.3968c746.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function cc(zu){let $,Gs,Fs,Zs,y,Xs,v,en,b,Pu="Helper module for <code>Tensor</code> processing.",tn,M,Ru=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,ln,x,Ju='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.transpose"><code>.transpose(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.dynamicTimeWarping"><code>.dynamicTimeWarping(matrix)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒</li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor..args%5B1%5D"><code>~args[1]</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',sn,nn,on,C,rn,H,dn,L,ju='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',an,w,Eu='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li>',un,mn,pn,A,cn,g,fn,U,ku="Create a new Tensor or copy an existing Tensor.",Tn,z,Du="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",hn,_n,$n,P,yn,R,vn,J,Iu="Dimensions of the tensor.",bn,j,qu='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Mn,xn,Cn,E,Hn,k,Ln,D,Ku="Type of the tensor.",wn,I,Nu='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',An,gn,Un,q,zn,K,Pn,N,Bu="The data stored in the tensor.",Rn,B,Vu='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Jn,jn,En,V,kn,Q,Dn,S,Qu="The number of elements in the tensor.",In,W,Su='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',qn,Kn,Nn,Y,Bn,F,Vn,O,Wu=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,Qn,G,Yu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',Sn,Wn,Yn,Z,Fn,X,On,ee,Fu="Index into a Tensor object.",Gn,te,Ou='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',Zn,le,Gu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",Xn,eo,to,se,lo,ne,so,oe,Zu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',no,ie,Xu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",oo,io,ro,re,ao,de,uo,ae,em='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',mo,ue,tm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",po,co,fo,me,To,pe,ho,ce,lm=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,_o,fe,sm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',$o,Te,nm="<li><code>Error</code> If the tensor has more than one element.</li>",yo,vo,bo,he,Mo,_e,xo,$e,om="Convert tensor data to a n-dimensional JS list",Co,ye,im='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ho,Lo,wo,ve,Ao,be,go,Me,rm="Return a new Tensor with the sigmoid function applied to each element.",Uo,xe,dm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',zo,Po,Ro,Ce,Jo,He,jo,Le,am="Applies the sigmoid function to the tensor in place.",Eo,we,um='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',ko,Do,Io,Ae,qo,ge,Ko,Ue,mm="Return a new Tensor with every element multiplied by a constant.",No,ze,pm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Bo,Pe,cm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Vo,Qo,So,Re,Wo,Je,Yo,je,fm="Multiply the tensor by a constant in place.",Fo,Ee,Tm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Oo,ke,hm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Go,Zo,Xo,De,ei,Ie,ti,qe,_m="Return a new Tensor with every element added by a constant.",li,Ke,$m='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',si,Ne,ym="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",ni,oi,ii,Be,ri,Ve,di,Qe,vm="Add the tensor by a constant in place.",ai,Se,bm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',ui,We,Mm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",mi,pi,ci,Ye,fi,Fe,Ti,Oe,xm="Return a transposed version of this Tensor, according to the provided dimensions.",hi,Ge,Cm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',_i,Ze,Hm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to transpose.</p></td></tr></tbody>",$i,yi,vi,Xe,bi,et,Mi,tt,Lm="Returns the sum of each row of the input tensor in the given dimension dim.",xi,lt,wm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',Ci,st,Am="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",Hi,Li,wi,nt,Ai,ot,gi,it,gm="Returns the matrix norm or vector norm of a given tensor.",Ui,rt,Um='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',zi,dt,zm=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,Pi,Ri,Ji,at,ji,ut,Ei,mt,Pm="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",ki,pt,Rm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',Di,ct,Jm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Ii,qi,Ki,ft,Ni,Tt,Bi,ht,jm="Performs <code>L_p</code> normalization of inputs over specified dimension.",Vi,_t,Em='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',Qi,$t,km="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Si,Wi,Yi,yt,Fi,vt,Oi,bt,Dm=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,Gi,Mt,Im='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',Zi,Xi,er,xt,tr,Ct,lr,Ht,qm="Returns a tensor with all specified dimensions of input of size 1 removed.",sr,Lt,Km=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,nr,wt,Nm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The squeezed tensor',or,At,Bm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",ir,rr,dr,gt,ar,Ut,ur,zt,Vm='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',mr,Pt,Qm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',pr,cr,fr,Rt,Tr,Jt,hr,jt,Sm="Returns a new tensor with a dimension of size one inserted at the specified position.",_r,Et,Wm="NOTE: The returned tensor shares the same underlying data with this tensor.",$r,kt,Ym='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The unsqueezed tensor',yr,Dt,Fm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",vr,br,Mr,It,xr,qt,Cr,Kt,Om='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',Hr,Nt,Gm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Lr,wr,Ar,Bt,gr,Vt,Ur,Qt,Zm='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',zr,St,Xm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Pr,Rr,Jr,Wt,jr,Yt,Er,Ft,ep=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,kr,Ot,tp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The flattened tensor.',Dr,Gt,lp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",Ir,qr,Kr,Zt,Nr,Xt,Br,el,sp="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",Vr,tl,np='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',Qr,ll,op="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",Sr,Wr,Yr,sl,Fr,nl,Or,ol,ip='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',Gr,il,rp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Zr,Xr,ed,rl,td,dl,ld,al,dp="Clamps all elements in input into the range [ min, max ]",sd,ul,ap='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',nd,ml,up="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",od,id,rd,pl,dd,cl,ad,fl,mp='In-place version of @see <a href="Tensor.round">Tensor.round</a>',ud,Tl,pp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',md,pd,cd,hl,fd,_l,Td,$l,cp="Rounds elements of input to the nearest integer.",hd,yl,fp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',_d,$d,yd,vl,vd,bl,bd,Ml,Tp="Performs Tensor dtype conversion.",Md,xl,hp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The converted tensor.',xd,Cl,_p="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code>DataType</code></td><td><p>The desired data type.</p></td></tr></tbody>",Cd,Hd,Ld,Hl,wd,Ll,Ad,wl,$p="Transposes a tensor according to the provided axes.",gd,Al,yp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',Ud,gl,vp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to transpose.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to transpose the tensor along.</p></td></tr></tbody>",zd,Pd,Rd,Ul,Jd,zl,jd,Pl,bp="Interpolates an Tensor to the given size.",Ed,Rl,Mp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',kd,Jl,xp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",Dd,Id,qd,jl,Kd,El,Nd,kl,Cp="Perform mean pooling of the last hidden state followed by a normalization step.",Bd,Dl,Hp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',Vd,Il,Lp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",Qd,Sd,Wd,ql,Yd,Kl,Fd,Nl,wp="Concatenates an array of tensors along a specified dimension.",Od,Bl,Ap='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',Gd,Vl,gp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",Zd,Xd,ea,Ql,ta,Sl,la,Wl,Up="Stack an array of tensors along a specified dimension.",sa,Yl,zp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',na,Fl,Pp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",oa,ia,ra,Ol,da,Gl,aa,Zl,Rp="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",ua,Xl,Jp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',ma,es,jp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",pa,ca,fa,ts,Ta,ls,ha,ss,Ep="Returns the mean value of each row of the input tensor in the given dimension dim.",_a,ns,kp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: A new tensor with means taken along the specified dimension.',$a,os,Dp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",ya,va,ba,is,Ma,rs,xa,ds,Ip=`Measures similarity between two temporal sequences (e.g., input audio and output tokens
to generate token-level timestamps).`,Ca,as,qp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Ha,us,Kp="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>matrix</td><td><code>Tensor</code></td></tr></tbody>",La,wa,Aa,ms,ga,ps,Ua,cs,Np="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",za,fs,Bp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Pa,Ts,Vp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Ra,Ja,ja,hs,Ea,_s,ka,$s,Qp="Returns a tensor filled with the scalar value 1, with the same size as input.",Da,ys,Sp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: The ones tensor.',Ia,vs,Wp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",qa,Ka,Na,bs,Ba,Ms,Va,xs,Yp='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Qa,Sa,Wa,Cs,Ya,Hs,Fa,Ls,Fp='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Oa,Ga,Za,ws,Xa,As,eu,gs,Op="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",tu,Us,Gp='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',lu,zs,Zp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",su,Ps,Xp="<strong>Example</strong>",nu,Rs,ou,iu,ru,Js,du,js,au,Es,ec='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',uu,mu,pu,ks,cu,Ds,fu,Is,tc='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Tu,hu,_u,qs,$u,Ks,yu,Ns,lc="This creates a nested array of a given type and depth (see examples).",vu,Bs,sc='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',bu,Vs,Mu,Qs,nc="<strong>Example</strong>",xu,Ss,Cu,Ws,oc="<strong>Example</strong>",Hu,Ys,Lu,wu,Au,Os,gu;return v=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),g=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),R=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),k=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),Q=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),F=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),X=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),ne=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),de=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),_e=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),be=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ge=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Je=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ie=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Ve=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.transpose(...dims) ⇒ <code> Tensor </code>",local:"tensortransposedims--code-tensor-code",headingTag:"h3"}}),et=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),ot=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),ut=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),Tt=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),vt=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.squeeze([dim]) ⇒",local:"tensorsqueezedim-",headingTag:"h3"}}),Ut=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),Jt=new _({props:{title:"tensor.unsqueeze(dim) ⇒",local:"tensorunsqueezedim-",headingTag:"h3"}}),qt=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),Vt=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Yt=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒",local:"tensorflattenstartdim-enddim-",headingTag:"h3"}}),Xt=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),nl=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),dl=new _({props:{title:"tensor.clamp(min, max) ⇒",local:"tensorclampmin-max-",headingTag:"h3"}}),cl=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),_l=new _({props:{title:"tensor.round() ⇒",local:"tensorround-",headingTag:"h3"}}),bl=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Ll=new _({props:{title:"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensortransposetensor-axes--code-tensor-code",headingTag:"h2"}}),zl=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),El=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Kl=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),Sl=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),Gl=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),ls=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒",local:"utilstensormeaninput-dim-keepdim-",headingTag:"h2"}}),rs=new _({props:{title:"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>",local:"utilstensordynamictimewarpingmatrix--code-array--array--number---code",headingTag:"h2"}}),ps=new _({props:{title:"utils/tensor.ones(size)",local:"utilstensoronessize",headingTag:"h2"}}),_s=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒",local:"utilstensoronesliketensor-",headingTag:"h2"}}),Ms=new _({props:{title:"utils/tensor~args[0] : <code> DataType </code>",local:"utilstensorargs0--code-datatype-code",headingTag:"h2"}}),Hs=new _({props:{title:"utils/tensor~args[1] : <code> * </code>",local:"utilstensorargs1--code--code",headingTag:"h2"}}),As=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Rs=new Uu({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),js=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),Ds=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Ks=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),Vs=new Uu({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),Ss=new Uu({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),Ys=new Uu({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),{c(){$=i("meta"),Gs=n(),Fs=i("p"),Zs=n(),y=i("a"),Xs=n(),u(v.$$.fragment),en=n(),b=i("p"),b.innerHTML=Pu,tn=n(),M=i("p"),M.textContent=Ru,ln=n(),x=i("ul"),x.innerHTML=Ju,sn=n(),nn=i("hr"),on=n(),C=i("a"),rn=n(),u(H.$$.fragment),dn=n(),L=i("p"),L.innerHTML=ju,an=n(),w=i("ul"),w.innerHTML=Eu,un=n(),mn=i("hr"),pn=n(),A=i("a"),cn=n(),u(g.$$.fragment),fn=n(),U=i("p"),U.textContent=ku,Tn=n(),z=i("table"),z.innerHTML=Du,hn=n(),_n=i("hr"),$n=n(),P=i("a"),yn=n(),u(R.$$.fragment),vn=n(),J=i("p"),J.textContent=Iu,bn=n(),j=i("p"),j.innerHTML=qu,Mn=n(),xn=i("hr"),Cn=n(),E=i("a"),Hn=n(),u(k.$$.fragment),Ln=n(),D=i("p"),D.textContent=Ku,wn=n(),I=i("p"),I.innerHTML=Nu,An=n(),gn=i("hr"),Un=n(),q=i("a"),zn=n(),u(K.$$.fragment),Pn=n(),N=i("p"),N.textContent=Bu,Rn=n(),B=i("p"),B.innerHTML=Vu,Jn=n(),jn=i("hr"),En=n(),V=i("a"),kn=n(),u(Q.$$.fragment),Dn=n(),S=i("p"),S.textContent=Qu,In=n(),W=i("p"),W.innerHTML=Su,qn=n(),Kn=i("hr"),Nn=n(),Y=i("a"),Bn=n(),u(F.$$.fragment),Vn=n(),O=i("p"),O.textContent=Wu,Qn=n(),G=i("p"),G.innerHTML=Yu,Sn=n(),Wn=i("hr"),Yn=n(),Z=i("a"),Fn=n(),u(X.$$.fragment),On=n(),ee=i("p"),ee.textContent=Fu,Gn=n(),te=i("p"),te.innerHTML=Ou,Zn=n(),le=i("table"),le.innerHTML=Gu,Xn=n(),eo=i("hr"),to=n(),se=i("a"),lo=n(),u(ne.$$.fragment),so=n(),oe=i("p"),oe.innerHTML=Zu,no=n(),ie=i("table"),ie.innerHTML=Xu,oo=n(),io=i("hr"),ro=n(),re=i("a"),ao=n(),u(de.$$.fragment),uo=n(),ae=i("p"),ae.innerHTML=em,mo=n(),ue=i("table"),ue.innerHTML=tm,po=n(),co=i("hr"),fo=n(),me=i("a"),To=n(),u(pe.$$.fragment),ho=n(),ce=i("p"),ce.innerHTML=lm,_o=n(),fe=i("p"),fe.innerHTML=sm,$o=n(),Te=i("ul"),Te.innerHTML=nm,yo=n(),vo=i("hr"),bo=n(),he=i("a"),Mo=n(),u(_e.$$.fragment),xo=n(),$e=i("p"),$e.textContent=om,Co=n(),ye=i("p"),ye.innerHTML=im,Ho=n(),Lo=i("hr"),wo=n(),ve=i("a"),Ao=n(),u(be.$$.fragment),go=n(),Me=i("p"),Me.textContent=rm,Uo=n(),xe=i("p"),xe.innerHTML=dm,zo=n(),Po=i("hr"),Ro=n(),Ce=i("a"),Jo=n(),u(He.$$.fragment),jo=n(),Le=i("p"),Le.textContent=am,Eo=n(),we=i("p"),we.innerHTML=um,ko=n(),Do=i("hr"),Io=n(),Ae=i("a"),qo=n(),u(ge.$$.fragment),Ko=n(),Ue=i("p"),Ue.textContent=mm,No=n(),ze=i("p"),ze.innerHTML=pm,Bo=n(),Pe=i("table"),Pe.innerHTML=cm,Vo=n(),Qo=i("hr"),So=n(),Re=i("a"),Wo=n(),u(Je.$$.fragment),Yo=n(),je=i("p"),je.textContent=fm,Fo=n(),Ee=i("p"),Ee.innerHTML=Tm,Oo=n(),ke=i("table"),ke.innerHTML=hm,Go=n(),Zo=i("hr"),Xo=n(),De=i("a"),ei=n(),u(Ie.$$.fragment),ti=n(),qe=i("p"),qe.textContent=_m,li=n(),Ke=i("p"),Ke.innerHTML=$m,si=n(),Ne=i("table"),Ne.innerHTML=ym,ni=n(),oi=i("hr"),ii=n(),Be=i("a"),ri=n(),u(Ve.$$.fragment),di=n(),Qe=i("p"),Qe.textContent=vm,ai=n(),Se=i("p"),Se.innerHTML=bm,ui=n(),We=i("table"),We.innerHTML=Mm,mi=n(),pi=i("hr"),ci=n(),Ye=i("a"),fi=n(),u(Fe.$$.fragment),Ti=n(),Oe=i("p"),Oe.textContent=xm,hi=n(),Ge=i("p"),Ge.innerHTML=Cm,_i=n(),Ze=i("table"),Ze.innerHTML=Hm,$i=n(),yi=i("hr"),vi=n(),Xe=i("a"),bi=n(),u(et.$$.fragment),Mi=n(),tt=i("p"),tt.textContent=Lm,xi=n(),lt=i("p"),lt.innerHTML=wm,Ci=n(),st=i("table"),st.innerHTML=Am,Hi=n(),Li=i("hr"),wi=n(),nt=i("a"),Ai=n(),u(ot.$$.fragment),gi=n(),it=i("p"),it.textContent=gm,Ui=n(),rt=i("p"),rt.innerHTML=Um,zi=n(),dt=i("table"),dt.innerHTML=zm,Pi=n(),Ri=i("hr"),Ji=n(),at=i("a"),ji=n(),u(ut.$$.fragment),Ei=n(),mt=i("p"),mt.innerHTML=Pm,ki=n(),pt=i("p"),pt.innerHTML=Rm,Di=n(),ct=i("table"),ct.innerHTML=Jm,Ii=n(),qi=i("hr"),Ki=n(),ft=i("a"),Ni=n(),u(Tt.$$.fragment),Bi=n(),ht=i("p"),ht.innerHTML=jm,Vi=n(),_t=i("p"),_t.innerHTML=Em,Qi=n(),$t=i("table"),$t.innerHTML=km,Si=n(),Wi=i("hr"),Yi=n(),yt=i("a"),Fi=n(),u(vt.$$.fragment),Oi=n(),bt=i("p"),bt.textContent=Dm,Gi=n(),Mt=i("p"),Mt.innerHTML=Im,Zi=n(),Xi=i("hr"),er=n(),xt=i("a"),tr=n(),u(Ct.$$.fragment),lr=n(),Ht=i("p"),Ht.textContent=qm,sr=n(),Lt=i("p"),Lt.innerHTML=Km,nr=n(),wt=i("p"),wt.innerHTML=Nm,or=n(),At=i("table"),At.innerHTML=Bm,ir=n(),rr=i("hr"),dr=n(),gt=i("a"),ar=n(),u(Ut.$$.fragment),ur=n(),zt=i("p"),zt.innerHTML=Vm,mr=n(),Pt=i("p"),Pt.innerHTML=Qm,pr=n(),cr=i("hr"),fr=n(),Rt=i("a"),Tr=n(),u(Jt.$$.fragment),hr=n(),jt=i("p"),jt.textContent=Sm,_r=n(),Et=i("p"),Et.textContent=Wm,$r=n(),kt=i("p"),kt.innerHTML=Ym,yr=n(),Dt=i("table"),Dt.innerHTML=Fm,vr=n(),br=i("hr"),Mr=n(),It=i("a"),xr=n(),u(qt.$$.fragment),Cr=n(),Kt=i("p"),Kt.innerHTML=Om,Hr=n(),Nt=i("p"),Nt.innerHTML=Gm,Lr=n(),wr=i("hr"),Ar=n(),Bt=i("a"),gr=n(),u(Vt.$$.fragment),Ur=n(),Qt=i("p"),Qt.innerHTML=Zm,zr=n(),St=i("p"),St.innerHTML=Xm,Pr=n(),Rr=i("hr"),Jr=n(),Wt=i("a"),jr=n(),u(Yt.$$.fragment),Er=n(),Ft=i("p"),Ft.innerHTML=ep,kr=n(),Ot=i("p"),Ot.innerHTML=tp,Dr=n(),Gt=i("table"),Gt.innerHTML=lp,Ir=n(),qr=i("hr"),Kr=n(),Zt=i("a"),Nr=n(),u(Xt.$$.fragment),Br=n(),el=i("p"),el.innerHTML=sp,Vr=n(),tl=i("p"),tl.innerHTML=np,Qr=n(),ll=i("table"),ll.innerHTML=op,Sr=n(),Wr=i("hr"),Yr=n(),sl=i("a"),Fr=n(),u(nl.$$.fragment),Or=n(),ol=i("p"),ol.innerHTML=ip,Gr=n(),il=i("p"),il.innerHTML=rp,Zr=n(),Xr=i("hr"),ed=n(),rl=i("a"),td=n(),u(dl.$$.fragment),ld=n(),al=i("p"),al.textContent=dp,sd=n(),ul=i("p"),ul.innerHTML=ap,nd=n(),ml=i("table"),ml.innerHTML=up,od=n(),id=i("hr"),rd=n(),pl=i("a"),dd=n(),u(cl.$$.fragment),ad=n(),fl=i("p"),fl.innerHTML=mp,ud=n(),Tl=i("p"),Tl.innerHTML=pp,md=n(),pd=i("hr"),cd=n(),hl=i("a"),fd=n(),u(_l.$$.fragment),Td=n(),$l=i("p"),$l.textContent=cp,hd=n(),yl=i("p"),yl.innerHTML=fp,_d=n(),$d=i("hr"),yd=n(),vl=i("a"),vd=n(),u(bl.$$.fragment),bd=n(),Ml=i("p"),Ml.textContent=Tp,Md=n(),xl=i("p"),xl.innerHTML=hp,xd=n(),Cl=i("table"),Cl.innerHTML=_p,Cd=n(),Hd=i("hr"),Ld=n(),Hl=i("a"),wd=n(),u(Ll.$$.fragment),Ad=n(),wl=i("p"),wl.textContent=$p,gd=n(),Al=i("p"),Al.innerHTML=yp,Ud=n(),gl=i("table"),gl.innerHTML=vp,zd=n(),Pd=i("hr"),Rd=n(),Ul=i("a"),Jd=n(),u(zl.$$.fragment),jd=n(),Pl=i("p"),Pl.textContent=bp,Ed=n(),Rl=i("p"),Rl.innerHTML=Mp,kd=n(),Jl=i("table"),Jl.innerHTML=xp,Dd=n(),Id=i("hr"),qd=n(),jl=i("a"),Kd=n(),u(El.$$.fragment),Nd=n(),kl=i("p"),kl.textContent=Cp,Bd=n(),Dl=i("p"),Dl.innerHTML=Hp,Vd=n(),Il=i("table"),Il.innerHTML=Lp,Qd=n(),Sd=i("hr"),Wd=n(),ql=i("a"),Yd=n(),u(Kl.$$.fragment),Fd=n(),Nl=i("p"),Nl.textContent=wp,Od=n(),Bl=i("p"),Bl.innerHTML=Ap,Gd=n(),Vl=i("table"),Vl.innerHTML=gp,Zd=n(),Xd=i("hr"),ea=n(),Ql=i("a"),ta=n(),u(Sl.$$.fragment),la=n(),Wl=i("p"),Wl.textContent=Up,sa=n(),Yl=i("p"),Yl.innerHTML=zp,na=n(),Fl=i("table"),Fl.innerHTML=Pp,oa=n(),ia=i("hr"),ra=n(),Ol=i("a"),da=n(),u(Gl.$$.fragment),aa=n(),Zl=i("p"),Zl.innerHTML=Rp,ua=n(),Xl=i("p"),Xl.innerHTML=Jp,ma=n(),es=i("table"),es.innerHTML=jp,pa=n(),ca=i("hr"),fa=n(),ts=i("a"),Ta=n(),u(ls.$$.fragment),ha=n(),ss=i("p"),ss.textContent=Ep,_a=n(),ns=i("p"),ns.innerHTML=kp,$a=n(),os=i("table"),os.innerHTML=Dp,ya=n(),va=i("hr"),ba=n(),is=i("a"),Ma=n(),u(rs.$$.fragment),xa=n(),ds=i("p"),ds.textContent=Ip,Ca=n(),as=i("p"),as.innerHTML=qp,Ha=n(),us=i("table"),us.innerHTML=Kp,La=n(),wa=i("hr"),Aa=n(),ms=i("a"),ga=n(),u(ps.$$.fragment),Ua=n(),cs=i("p"),cs.textContent=Np,za=n(),fs=i("p"),fs.innerHTML=Bp,Pa=n(),Ts=i("table"),Ts.innerHTML=Vp,Ra=n(),Ja=i("hr"),ja=n(),hs=i("a"),Ea=n(),u(_s.$$.fragment),ka=n(),$s=i("p"),$s.textContent=Qp,Da=n(),ys=i("p"),ys.innerHTML=Sp,Ia=n(),vs=i("table"),vs.innerHTML=Wp,qa=n(),Ka=i("hr"),Na=n(),bs=i("a"),Ba=n(),u(Ms.$$.fragment),Va=n(),xs=i("p"),xs.innerHTML=Yp,Qa=n(),Sa=i("hr"),Wa=n(),Cs=i("a"),Ya=n(),u(Hs.$$.fragment),Fa=n(),Ls=i("p"),Ls.innerHTML=Fp,Oa=n(),Ga=i("hr"),Za=n(),ws=i("a"),Xa=n(),u(As.$$.fragment),eu=n(),gs=i("p"),gs.textContent=Op,tu=n(),Us=i("p"),Us.innerHTML=Gp,lu=n(),zs=i("table"),zs.innerHTML=Zp,su=n(),Ps=i("p"),Ps.innerHTML=Xp,nu=n(),u(Rs.$$.fragment),ou=n(),iu=i("hr"),ru=n(),Js=i("a"),du=n(),u(js.$$.fragment),au=n(),Es=i("p"),Es.innerHTML=ec,uu=n(),mu=i("hr"),pu=n(),ks=i("a"),cu=n(),u(Ds.$$.fragment),fu=n(),Is=i("p"),Is.innerHTML=tc,Tu=n(),hu=i("hr"),_u=n(),qs=i("a"),$u=n(),u(Ks.$$.fragment),yu=n(),Ns=i("p"),Ns.textContent=lc,vu=n(),Bs=i("p"),Bs.innerHTML=sc,bu=n(),u(Vs.$$.fragment),Mu=n(),Qs=i("p"),Qs.innerHTML=nc,xu=n(),u(Ss.$$.fragment),Cu=n(),Ws=i("p"),Ws.innerHTML=oc,Hu=n(),u(Ys.$$.fragment),Lu=n(),wu=i("hr"),Au=n(),Os=i("p"),this.h()},l(e){const t=mc("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(l),Gs=o(e),Fs=r(e,"P",{}),h(Fs).forEach(l),Zs=o(e),y=r(e,"A",{id:!0,class:!0}),h(y).forEach(l),Xs=o(e),m(v.$$.fragment,e),en=o(e),b=r(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-uw4y1m"&&(b.innerHTML=Pu),tn=o(e),M=r(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-il3kl8"&&(M.textContent=Ru),ln=o(e),x=r(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-tzsc4"&&(x.innerHTML=Ju),sn=o(e),nn=r(e,"HR",{}),on=o(e),C=r(e,"A",{id:!0,class:!0}),h(C).forEach(l),rn=o(e),m(H.$$.fragment,e),dn=o(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=ju),an=o(e),w=r(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-bidd2"&&(w.innerHTML=Eu),un=o(e),mn=r(e,"HR",{}),pn=o(e),A=r(e,"A",{id:!0,class:!0}),h(A).forEach(l),cn=o(e),m(g.$$.fragment,e),fn=o(e),U=r(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-55wecd"&&(U.textContent=ku),Tn=o(e),z=r(e,"TABLE",{"data-svelte-h":!0}),d(z)!=="svelte-ee7emz"&&(z.innerHTML=Du),hn=o(e),_n=r(e,"HR",{}),$n=o(e),P=r(e,"A",{id:!0,class:!0}),h(P).forEach(l),yn=o(e),m(R.$$.fragment,e),vn=o(e),J=r(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-1gc2rt4"&&(J.textContent=Iu),bn=o(e),j=r(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-10qzguj"&&(j.innerHTML=qu),Mn=o(e),xn=r(e,"HR",{}),Cn=o(e),E=r(e,"A",{id:!0,class:!0}),h(E).forEach(l),Hn=o(e),m(k.$$.fragment,e),Ln=o(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-81y0bb"&&(D.textContent=Ku),wn=o(e),I=r(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-10qzguj"&&(I.innerHTML=Nu),An=o(e),gn=r(e,"HR",{}),Un=o(e),q=r(e,"A",{id:!0,class:!0}),h(q).forEach(l),zn=o(e),m(K.$$.fragment,e),Pn=o(e),N=r(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1eqabt7"&&(N.textContent=Bu),Rn=o(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-10qzguj"&&(B.innerHTML=Vu),Jn=o(e),jn=r(e,"HR",{}),En=o(e),V=r(e,"A",{id:!0,class:!0}),h(V).forEach(l),kn=o(e),m(Q.$$.fragment,e),Dn=o(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-krrt97"&&(S.textContent=Qu),In=o(e),W=r(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-10qzguj"&&(W.innerHTML=Su),qn=o(e),Kn=r(e,"HR",{}),Nn=o(e),Y=r(e,"A",{id:!0,class:!0}),h(Y).forEach(l),Bn=o(e),m(F.$$.fragment,e),Vn=o(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1adn56z"&&(O.textContent=Wu),Qn=o(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1gxgvk6"&&(G.innerHTML=Yu),Sn=o(e),Wn=r(e,"HR",{}),Yn=o(e),Z=r(e,"A",{id:!0,class:!0}),h(Z).forEach(l),Fn=o(e),m(X.$$.fragment,e),On=o(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1u97xg1"&&(ee.textContent=Fu),Gn=o(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1afa2dz"&&(te.innerHTML=Ou),Zn=o(e),le=r(e,"TABLE",{"data-svelte-h":!0}),d(le)!=="svelte-1kq04ga"&&(le.innerHTML=Gu),Xn=o(e),eo=r(e,"HR",{}),to=o(e),se=r(e,"A",{id:!0,class:!0}),h(se).forEach(l),lo=o(e),m(ne.$$.fragment,e),so=o(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1cg22af"&&(oe.innerHTML=Zu),no=o(e),ie=r(e,"TABLE",{"data-svelte-h":!0}),d(ie)!=="svelte-1hful42"&&(ie.innerHTML=Xu),oo=o(e),io=r(e,"HR",{}),ro=o(e),re=r(e,"A",{id:!0,class:!0}),h(re).forEach(l),ao=o(e),m(de.$$.fragment,e),uo=o(e),ae=r(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1mr58c3"&&(ae.innerHTML=em),mo=o(e),ue=r(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-153ftfy"&&(ue.innerHTML=tm),po=o(e),co=r(e,"HR",{}),fo=o(e),me=r(e,"A",{id:!0,class:!0}),h(me).forEach(l),To=o(e),m(pe.$$.fragment,e),ho=o(e),ce=r(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-13nzfs3"&&(ce.innerHTML=lm),_o=o(e),fe=r(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-11rv1mu"&&(fe.innerHTML=sm),$o=o(e),Te=r(e,"UL",{"data-svelte-h":!0}),d(Te)!=="svelte-5t2sg3"&&(Te.innerHTML=nm),yo=o(e),vo=r(e,"HR",{}),bo=o(e),he=r(e,"A",{id:!0,class:!0}),h(he).forEach(l),Mo=o(e),m(_e.$$.fragment,e),xo=o(e),$e=r(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-87xdyr"&&($e.textContent=om),Co=o(e),ye=r(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1mr58c3"&&(ye.innerHTML=im),Ho=o(e),Lo=r(e,"HR",{}),wo=o(e),ve=r(e,"A",{id:!0,class:!0}),h(ve).forEach(l),Ao=o(e),m(be.$$.fragment,e),go=o(e),Me=r(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-2wti2w"&&(Me.textContent=rm),Uo=o(e),xe=r(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-kpq7mo"&&(xe.innerHTML=dm),zo=o(e),Po=r(e,"HR",{}),Ro=o(e),Ce=r(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),Jo=o(e),m(He.$$.fragment,e),jo=o(e),Le=r(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1edu6c8"&&(Le.textContent=am),Eo=o(e),we=r(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1hc4oxa"&&(we.innerHTML=um),ko=o(e),Do=r(e,"HR",{}),Io=o(e),Ae=r(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),qo=o(e),m(ge.$$.fragment,e),Ko=o(e),Ue=r(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-xg80lg"&&(Ue.textContent=mm),No=o(e),ze=r(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1aygav2"&&(ze.innerHTML=pm),Bo=o(e),Pe=r(e,"TABLE",{"data-svelte-h":!0}),d(Pe)!=="svelte-1tbtmqd"&&(Pe.innerHTML=cm),Vo=o(e),Qo=r(e,"HR",{}),So=o(e),Re=r(e,"A",{id:!0,class:!0}),h(Re).forEach(l),Wo=o(e),m(Je.$$.fragment,e),Yo=o(e),je=r(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1i12x1s"&&(je.textContent=fm),Fo=o(e),Ee=r(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1hc4oxa"&&(Ee.innerHTML=Tm),Oo=o(e),ke=r(e,"TABLE",{"data-svelte-h":!0}),d(ke)!=="svelte-1tbtmqd"&&(ke.innerHTML=hm),Go=o(e),Zo=r(e,"HR",{}),Xo=o(e),De=r(e,"A",{id:!0,class:!0}),h(De).forEach(l),ei=o(e),m(Ie.$$.fragment,e),ti=o(e),qe=r(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1hl64jn"&&(qe.textContent=_m),li=o(e),Ke=r(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1aygav2"&&(Ke.innerHTML=$m),si=o(e),Ne=r(e,"TABLE",{"data-svelte-h":!0}),d(Ne)!=="svelte-1p5444"&&(Ne.innerHTML=ym),ni=o(e),oi=r(e,"HR",{}),ii=o(e),Be=r(e,"A",{id:!0,class:!0}),h(Be).forEach(l),ri=o(e),m(Ve.$$.fragment,e),di=o(e),Qe=r(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-bbf4x3"&&(Qe.textContent=vm),ai=o(e),Se=r(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1hc4oxa"&&(Se.innerHTML=bm),ui=o(e),We=r(e,"TABLE",{"data-svelte-h":!0}),d(We)!=="svelte-1p5444"&&(We.innerHTML=Mm),mi=o(e),pi=r(e,"HR",{}),ci=o(e),Ye=r(e,"A",{id:!0,class:!0}),h(Ye).forEach(l),fi=o(e),m(Fe.$$.fragment,e),Ti=o(e),Oe=r(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-lesh1u"&&(Oe.textContent=xm),hi=o(e),Ge=r(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-rvzl1t"&&(Ge.innerHTML=Cm),_i=o(e),Ze=r(e,"TABLE",{"data-svelte-h":!0}),d(Ze)!=="svelte-onq75m"&&(Ze.innerHTML=Hm),$i=o(e),yi=r(e,"HR",{}),vi=o(e),Xe=r(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),bi=o(e),m(et.$$.fragment,e),Mi=o(e),tt=r(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-yjryb1"&&(tt.textContent=Lm),xi=o(e),lt=r(e,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-xtr8tc"&&(lt.innerHTML=wm),Ci=o(e),st=r(e,"TABLE",{"data-svelte-h":!0}),d(st)!=="svelte-6xvdso"&&(st.innerHTML=Am),Hi=o(e),Li=r(e,"HR",{}),wi=o(e),nt=r(e,"A",{id:!0,class:!0}),h(nt).forEach(l),Ai=o(e),m(ot.$$.fragment,e),gi=o(e),it=r(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1okfsqx"&&(it.textContent=gm),Ui=o(e),rt=r(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1t556pk"&&(rt.innerHTML=Um),zi=o(e),dt=r(e,"TABLE",{"data-svelte-h":!0}),d(dt)!=="svelte-13m2wni"&&(dt.innerHTML=zm),Pi=o(e),Ri=r(e,"HR",{}),Ji=o(e),at=r(e,"A",{id:!0,class:!0}),h(at).forEach(l),ji=o(e),m(ut.$$.fragment,e),Ei=o(e),mt=r(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-1htpbrk"&&(mt.innerHTML=Pm),ki=o(e),pt=r(e,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-1t0m8l6"&&(pt.innerHTML=Rm),Di=o(e),ct=r(e,"TABLE",{"data-svelte-h":!0}),d(ct)!=="svelte-1qi99pl"&&(ct.innerHTML=Jm),Ii=o(e),qi=r(e,"HR",{}),Ki=o(e),ft=r(e,"A",{id:!0,class:!0}),h(ft).forEach(l),Ni=o(e),m(Tt.$$.fragment,e),Bi=o(e),ht=r(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1ztgqp"&&(ht.innerHTML=jm),Vi=o(e),_t=r(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-mvb39p"&&(_t.innerHTML=Em),Qi=o(e),$t=r(e,"TABLE",{"data-svelte-h":!0}),d($t)!=="svelte-1qi99pl"&&($t.innerHTML=km),Si=o(e),Wi=r(e,"HR",{}),Yi=o(e),yt=r(e,"A",{id:!0,class:!0}),h(yt).forEach(l),Fi=o(e),m(vt.$$.fragment,e),Oi=o(e),bt=r(e,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-1a7u185"&&(bt.textContent=Dm),Gi=o(e),Mt=r(e,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1eu3doh"&&(Mt.innerHTML=Im),Zi=o(e),Xi=r(e,"HR",{}),er=o(e),xt=r(e,"A",{id:!0,class:!0}),h(xt).forEach(l),tr=o(e),m(Ct.$$.fragment,e),lr=o(e),Ht=r(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-qls17b"&&(Ht.textContent=qm),sr=o(e),Lt=r(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-5nabmy"&&(Lt.innerHTML=Km),nr=o(e),wt=r(e,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1skbfxl"&&(wt.innerHTML=Nm),or=o(e),At=r(e,"TABLE",{"data-svelte-h":!0}),d(At)!=="svelte-52pnzr"&&(At.innerHTML=Bm),ir=o(e),rr=r(e,"HR",{}),dr=o(e),gt=r(e,"A",{id:!0,class:!0}),h(gt).forEach(l),ar=o(e),m(Ut.$$.fragment,e),ur=o(e),zt=r(e,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-19w0pic"&&(zt.innerHTML=Vm),mr=o(e),Pt=r(e,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-1mr58c3"&&(Pt.innerHTML=Qm),pr=o(e),cr=r(e,"HR",{}),fr=o(e),Rt=r(e,"A",{id:!0,class:!0}),h(Rt).forEach(l),Tr=o(e),m(Jt.$$.fragment,e),hr=o(e),jt=r(e,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-18ws76n"&&(jt.textContent=Sm),_r=o(e),Et=r(e,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-1tnr5gm"&&(Et.textContent=Wm),$r=o(e),kt=r(e,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1aoa5jo"&&(kt.innerHTML=Ym),yr=o(e),Dt=r(e,"TABLE",{"data-svelte-h":!0}),d(Dt)!=="svelte-1u9lyxp"&&(Dt.innerHTML=Fm),vr=o(e),br=r(e,"HR",{}),Mr=o(e),It=r(e,"A",{id:!0,class:!0}),h(It).forEach(l),xr=o(e),m(qt.$$.fragment,e),Cr=o(e),Kt=r(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-1b9ygao"&&(Kt.innerHTML=Om),Hr=o(e),Nt=r(e,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-1mr58c3"&&(Nt.innerHTML=Gm),Lr=o(e),wr=r(e,"HR",{}),Ar=o(e),Bt=r(e,"A",{id:!0,class:!0}),h(Bt).forEach(l),gr=o(e),m(Vt.$$.fragment,e),Ur=o(e),Qt=r(e,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-1vkr5xo"&&(Qt.innerHTML=Zm),zr=o(e),St=r(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1mr58c3"&&(St.innerHTML=Xm),Pr=o(e),Rr=r(e,"HR",{}),Jr=o(e),Wt=r(e,"A",{id:!0,class:!0}),h(Wt).forEach(l),jr=o(e),m(Yt.$$.fragment,e),Er=o(e),Ft=r(e,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-1gguudf"&&(Ft.innerHTML=ep),kr=o(e),Ot=r(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-9ffe42"&&(Ot.innerHTML=tp),Dr=o(e),Gt=r(e,"TABLE",{"data-svelte-h":!0}),d(Gt)!=="svelte-z6whez"&&(Gt.innerHTML=lp),Ir=o(e),qr=r(e,"HR",{}),Kr=o(e),Zt=r(e,"A",{id:!0,class:!0}),h(Zt).forEach(l),Nr=o(e),m(Xt.$$.fragment,e),Br=o(e),el=r(e,"P",{"data-svelte-h":!0}),d(el)!=="svelte-d6gvut"&&(el.innerHTML=sp),Vr=o(e),tl=r(e,"P",{"data-svelte-h":!0}),d(tl)!=="svelte-18n9ux4"&&(tl.innerHTML=np),Qr=o(e),ll=r(e,"TABLE",{"data-svelte-h":!0}),d(ll)!=="svelte-jj58dd"&&(ll.innerHTML=op),Sr=o(e),Wr=r(e,"HR",{}),Yr=o(e),sl=r(e,"A",{id:!0,class:!0}),h(sl).forEach(l),Fr=o(e),m(nl.$$.fragment,e),Or=o(e),ol=r(e,"P",{"data-svelte-h":!0}),d(ol)!=="svelte-1adolpg"&&(ol.innerHTML=ip),Gr=o(e),il=r(e,"P",{"data-svelte-h":!0}),d(il)!=="svelte-1mr58c3"&&(il.innerHTML=rp),Zr=o(e),Xr=r(e,"HR",{}),ed=o(e),rl=r(e,"A",{id:!0,class:!0}),h(rl).forEach(l),td=o(e),m(dl.$$.fragment,e),ld=o(e),al=r(e,"P",{"data-svelte-h":!0}),d(al)!=="svelte-1hm8vtj"&&(al.textContent=dp),sd=o(e),ul=r(e,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-106ei5g"&&(ul.innerHTML=ap),nd=o(e),ml=r(e,"TABLE",{"data-svelte-h":!0}),d(ml)!=="svelte-9ff0sy"&&(ml.innerHTML=up),od=o(e),id=r(e,"HR",{}),rd=o(e),pl=r(e,"A",{id:!0,class:!0}),h(pl).forEach(l),dd=o(e),m(cl.$$.fragment,e),ad=o(e),fl=r(e,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-1e6kzks"&&(fl.innerHTML=mp),ud=o(e),Tl=r(e,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-1mr58c3"&&(Tl.innerHTML=pp),md=o(e),pd=r(e,"HR",{}),cd=o(e),hl=r(e,"A",{id:!0,class:!0}),h(hl).forEach(l),fd=o(e),m(_l.$$.fragment,e),Td=o(e),$l=r(e,"P",{"data-svelte-h":!0}),d($l)!=="svelte-t5k6jp"&&($l.textContent=cp),hd=o(e),yl=r(e,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-106ei5g"&&(yl.innerHTML=fp),_d=o(e),$d=r(e,"HR",{}),yd=o(e),vl=r(e,"A",{id:!0,class:!0}),h(vl).forEach(l),vd=o(e),m(bl.$$.fragment,e),bd=o(e),Ml=r(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-avw2a1"&&(Ml.textContent=Tp),Md=o(e),xl=r(e,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-16q99cu"&&(xl.innerHTML=hp),xd=o(e),Cl=r(e,"TABLE",{"data-svelte-h":!0}),d(Cl)!=="svelte-zy0eig"&&(Cl.innerHTML=_p),Cd=o(e),Hd=r(e,"HR",{}),Ld=o(e),Hl=r(e,"A",{id:!0,class:!0}),h(Hl).forEach(l),wd=o(e),m(Ll.$$.fragment,e),Ad=o(e),wl=r(e,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-15z3tv8"&&(wl.textContent=$p),gd=o(e),Al=r(e,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-sv4gxb"&&(Al.innerHTML=yp),Ud=o(e),gl=r(e,"TABLE",{"data-svelte-h":!0}),d(gl)!=="svelte-q8pfpb"&&(gl.innerHTML=vp),zd=o(e),Pd=r(e,"HR",{}),Rd=o(e),Ul=r(e,"A",{id:!0,class:!0}),h(Ul).forEach(l),Jd=o(e),m(zl.$$.fragment,e),jd=o(e),Pl=r(e,"P",{"data-svelte-h":!0}),d(Pl)!=="svelte-fju8tm"&&(Pl.textContent=bp),Ed=o(e),Rl=r(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-13s6o0v"&&(Rl.innerHTML=Mp),kd=o(e),Jl=r(e,"TABLE",{"data-svelte-h":!0}),d(Jl)!=="svelte-8i278m"&&(Jl.innerHTML=xp),Dd=o(e),Id=r(e,"HR",{}),qd=o(e),jl=r(e,"A",{id:!0,class:!0}),h(jl).forEach(l),Kd=o(e),m(El.$$.fragment,e),Nd=o(e),kl=r(e,"P",{"data-svelte-h":!0}),d(kl)!=="svelte-11ei68w"&&(kl.textContent=Cp),Bd=o(e),Dl=r(e,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-1p3llh"&&(Dl.innerHTML=Hp),Vd=o(e),Il=r(e,"TABLE",{"data-svelte-h":!0}),d(Il)!=="svelte-1xe0vb8"&&(Il.innerHTML=Lp),Qd=o(e),Sd=r(e,"HR",{}),Wd=o(e),ql=r(e,"A",{id:!0,class:!0}),h(ql).forEach(l),Yd=o(e),m(Kl.$$.fragment,e),Fd=o(e),Nl=r(e,"P",{"data-svelte-h":!0}),d(Nl)!=="svelte-k6p1db"&&(Nl.textContent=wp),Od=o(e),Bl=r(e,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-1o30xnd"&&(Bl.innerHTML=Ap),Gd=o(e),Vl=r(e,"TABLE",{"data-svelte-h":!0}),d(Vl)!=="svelte-101obk2"&&(Vl.innerHTML=gp),Zd=o(e),Xd=r(e,"HR",{}),ea=o(e),Ql=r(e,"A",{id:!0,class:!0}),h(Ql).forEach(l),ta=o(e),m(Sl.$$.fragment,e),la=o(e),Wl=r(e,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-8afo9v"&&(Wl.textContent=Up),sa=o(e),Yl=r(e,"P",{"data-svelte-h":!0}),d(Yl)!=="svelte-1vvmhgz"&&(Yl.innerHTML=zp),na=o(e),Fl=r(e,"TABLE",{"data-svelte-h":!0}),d(Fl)!=="svelte-wz2jkw"&&(Fl.innerHTML=Pp),oa=o(e),ia=r(e,"HR",{}),ra=o(e),Ol=r(e,"A",{id:!0,class:!0}),h(Ol).forEach(l),da=o(e),m(Gl.$$.fragment,e),aa=o(e),Zl=r(e,"P",{"data-svelte-h":!0}),d(Zl)!=="svelte-11plveb"&&(Zl.innerHTML=Rp),ua=o(e),Xl=r(e,"P",{"data-svelte-h":!0}),d(Xl)!=="svelte-1wu8g4g"&&(Xl.innerHTML=Jp),ma=o(e),es=r(e,"TABLE",{"data-svelte-h":!0}),d(es)!=="svelte-1vsvca3"&&(es.innerHTML=jp),pa=o(e),ca=r(e,"HR",{}),fa=o(e),ts=r(e,"A",{id:!0,class:!0}),h(ts).forEach(l),Ta=o(e),m(ls.$$.fragment,e),ha=o(e),ss=r(e,"P",{"data-svelte-h":!0}),d(ss)!=="svelte-17f4oxi"&&(ss.textContent=Ep),_a=o(e),ns=r(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-1lh8r1a"&&(ns.innerHTML=kp),$a=o(e),os=r(e,"TABLE",{"data-svelte-h":!0}),d(os)!=="svelte-m4z8c4"&&(os.innerHTML=Dp),ya=o(e),va=r(e,"HR",{}),ba=o(e),is=r(e,"A",{id:!0,class:!0}),h(is).forEach(l),Ma=o(e),m(rs.$$.fragment,e),xa=o(e),ds=r(e,"P",{"data-svelte-h":!0}),d(ds)!=="svelte-kcewlk"&&(ds.textContent=Ip),Ca=o(e),as=r(e,"P",{"data-svelte-h":!0}),d(as)!=="svelte-17f480h"&&(as.innerHTML=qp),Ha=o(e),us=r(e,"TABLE",{"data-svelte-h":!0}),d(us)!=="svelte-1to7jw8"&&(us.innerHTML=Kp),La=o(e),wa=r(e,"HR",{}),Aa=o(e),ms=r(e,"A",{id:!0,class:!0}),h(ms).forEach(l),ga=o(e),m(ps.$$.fragment,e),Ua=o(e),cs=r(e,"P",{"data-svelte-h":!0}),d(cs)!=="svelte-1ayje0f"&&(cs.textContent=Np),za=o(e),fs=r(e,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-17f480h"&&(fs.innerHTML=Bp),Pa=o(e),Ts=r(e,"TABLE",{"data-svelte-h":!0}),d(Ts)!=="svelte-gyxne1"&&(Ts.innerHTML=Vp),Ra=o(e),Ja=r(e,"HR",{}),ja=o(e),hs=r(e,"A",{id:!0,class:!0}),h(hs).forEach(l),Ea=o(e),m(_s.$$.fragment,e),ka=o(e),$s=r(e,"P",{"data-svelte-h":!0}),d($s)!=="svelte-1wvb8sq"&&($s.textContent=Qp),Da=o(e),ys=r(e,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-154yhp4"&&(ys.innerHTML=Sp),Ia=o(e),vs=r(e,"TABLE",{"data-svelte-h":!0}),d(vs)!=="svelte-1fk5fng"&&(vs.innerHTML=Wp),qa=o(e),Ka=r(e,"HR",{}),Na=o(e),bs=r(e,"A",{id:!0,class:!0}),h(bs).forEach(l),Ba=o(e),m(Ms.$$.fragment,e),Va=o(e),xs=r(e,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-12loz97"&&(xs.innerHTML=Yp),Qa=o(e),Sa=r(e,"HR",{}),Wa=o(e),Cs=r(e,"A",{id:!0,class:!0}),h(Cs).forEach(l),Ya=o(e),m(Hs.$$.fragment,e),Fa=o(e),Ls=r(e,"P",{"data-svelte-h":!0}),d(Ls)!=="svelte-12loz97"&&(Ls.innerHTML=Fp),Oa=o(e),Ga=r(e,"HR",{}),Za=o(e),ws=r(e,"A",{id:!0,class:!0}),h(ws).forEach(l),Xa=o(e),m(As.$$.fragment,e),eu=o(e),gs=r(e,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-40isdg"&&(gs.textContent=Op),tu=o(e),Us=r(e,"P",{"data-svelte-h":!0}),d(Us)!=="svelte-tlsa2h"&&(Us.innerHTML=Gp),lu=o(e),zs=r(e,"TABLE",{"data-svelte-h":!0}),d(zs)!=="svelte-17343p6"&&(zs.innerHTML=Zp),su=o(e),Ps=r(e,"P",{"data-svelte-h":!0}),d(Ps)!=="svelte-1aswmub"&&(Ps.innerHTML=Xp),nu=o(e),m(Rs.$$.fragment,e),ou=o(e),iu=r(e,"HR",{}),ru=o(e),Js=r(e,"A",{id:!0,class:!0}),h(Js).forEach(l),du=o(e),m(js.$$.fragment,e),au=o(e),Es=r(e,"P",{"data-svelte-h":!0}),d(Es)!=="svelte-kp31r8"&&(Es.innerHTML=ec),uu=o(e),mu=r(e,"HR",{}),pu=o(e),ks=r(e,"A",{id:!0,class:!0}),h(ks).forEach(l),cu=o(e),m(Ds.$$.fragment,e),fu=o(e),Is=r(e,"P",{"data-svelte-h":!0}),d(Is)!=="svelte-1fs9no9"&&(Is.innerHTML=tc),Tu=o(e),hu=r(e,"HR",{}),_u=o(e),qs=r(e,"A",{id:!0,class:!0}),h(qs).forEach(l),$u=o(e),m(Ks.$$.fragment,e),yu=o(e),Ns=r(e,"P",{"data-svelte-h":!0}),d(Ns)!=="svelte-2mif9c"&&(Ns.textContent=lc),vu=o(e),Bs=r(e,"P",{"data-svelte-h":!0}),d(Bs)!=="svelte-1jas2kw"&&(Bs.innerHTML=sc),bu=o(e),m(Vs.$$.fragment,e),Mu=o(e),Qs=r(e,"P",{"data-svelte-h":!0}),d(Qs)!=="svelte-1aswmub"&&(Qs.innerHTML=nc),xu=o(e),m(Ss.$$.fragment,e),Cu=o(e),Ws=r(e,"P",{"data-svelte-h":!0}),d(Ws)!=="svelte-1aswmub"&&(Ws.innerHTML=oc),Hu=o(e),m(Ys.$$.fragment,e),Lu=o(e),wu=r(e,"HR",{}),Au=o(e),Os=r(e,"P",{}),h(Os).forEach(l),this.h()},h(){a($,"name","hf:doc:metadata"),a($,"content",fc),a(y,"id","module_utils/tensor"),a(y,"class","group"),a(C,"id","module_utils/tensor.Tensor"),a(C,"class","group"),a(A,"id","new_module_utils/tensor.Tensor_new"),a(A,"class","group"),a(P,"id","module_utils/tensor.Tensor+dims"),a(P,"class","group"),a(E,"id","module_utils/tensor.Tensor+type"),a(E,"class","group"),a(q,"id","module_utils/tensor.Tensor+data"),a(q,"class","group"),a(V,"id","module_utils/tensor.Tensor+size"),a(V,"class","group"),a(Y,"id","module_utils/tensor.Tensor+Symbol.iterator"),a(Y,"class","group"),a(Z,"id","module_utils/tensor.Tensor+_getitem"),a(Z,"class","group"),a(se,"id","module_utils/tensor.Tensor+indexOf"),a(se,"class","group"),a(re,"id","module_utils/tensor.Tensor+_subarray"),a(re,"class","group"),a(me,"id","module_utils/tensor.Tensor+item"),a(me,"class","group"),a(he,"id","module_utils/tensor.Tensor+tolist"),a(he,"class","group"),a(ve,"id","module_utils/tensor.Tensor+sigmoid"),a(ve,"class","group"),a(Ce,"id","module_utils/tensor.Tensor+sigmoid_"),a(Ce,"class","group"),a(Ae,"id","module_utils/tensor.Tensor+mul"),a(Ae,"class","group"),a(Re,"id","module_utils/tensor.Tensor+mul_"),a(Re,"class","group"),a(De,"id","module_utils/tensor.Tensor+add"),a(De,"class","group"),a(Be,"id","module_utils/tensor.Tensor+add_"),a(Be,"class","group"),a(Ye,"id","module_utils/tensor.Tensor+transpose"),a(Ye,"class","group"),a(Xe,"id","module_utils/tensor.Tensor+sum"),a(Xe,"class","group"),a(nt,"id","module_utils/tensor.Tensor+norm"),a(nt,"class","group"),a(at,"id","module_utils/tensor.Tensor+normalize_"),a(at,"class","group"),a(ft,"id","module_utils/tensor.Tensor+normalize"),a(ft,"class","group"),a(yt,"id","module_utils/tensor.Tensor+stride"),a(yt,"class","group"),a(xt,"id","module_utils/tensor.Tensor+squeeze"),a(xt,"class","group"),a(gt,"id","module_utils/tensor.Tensor+squeeze_"),a(gt,"class","group"),a(Rt,"id","module_utils/tensor.Tensor+unsqueeze"),a(Rt,"class","group"),a(It,"id","module_utils/tensor.Tensor+unsqueeze_"),a(It,"class","group"),a(Bt,"id","module_utils/tensor.Tensor+flatten_"),a(Bt,"class","group"),a(Wt,"id","module_utils/tensor.Tensor+flatten"),a(Wt,"class","group"),a(Zt,"id","module_utils/tensor.Tensor+view"),a(Zt,"class","group"),a(sl,"id","module_utils/tensor.Tensor+clamp_"),a(sl,"class","group"),a(rl,"id","module_utils/tensor.Tensor+clamp"),a(rl,"class","group"),a(pl,"id","module_utils/tensor.Tensor+round_"),a(pl,"class","group"),a(hl,"id","module_utils/tensor.Tensor+round"),a(hl,"class","group"),a(vl,"id","module_utils/tensor.Tensor+to"),a(vl,"class","group"),a(Hl,"id","module_utils/tensor.transpose"),a(Hl,"class","group"),a(Ul,"id","module_utils/tensor.interpolate"),a(Ul,"class","group"),a(jl,"id","module_utils/tensor.mean_pooling"),a(jl,"class","group"),a(ql,"id","module_utils/tensor.cat"),a(ql,"class","group"),a(Ql,"id","module_utils/tensor.stack"),a(Ql,"class","group"),a(Ol,"id","module_utils/tensor.std_mean"),a(Ol,"class","group"),a(ts,"id","module_utils/tensor.mean"),a(ts,"class","group"),a(is,"id","module_utils/tensor.dynamicTimeWarping"),a(is,"class","group"),a(ms,"id","module_utils/tensor.ones"),a(ms,"class","group"),a(hs,"id","module_utils/tensor.ones_like"),a(hs,"class","group"),a(bs,"id","module_utils/tensor..args[0]"),a(bs,"class","group"),a(Cs,"id","module_utils/tensor..args[1]"),a(Cs,"class","group"),a(ws,"id","module_utils/tensor..reshape"),a(ws,"class","group"),a(Js,"id","module_utils/tensor..reshape..reshapedArray"),a(Js,"class","group"),a(ks,"id","module_utils/tensor..DataArray"),a(ks,"class","group"),a(qs,"id","module_utils/tensor..NestArray"),a(qs,"class","group")},m(e,t){pc(document.head,$),s(e,Gs,t),s(e,Fs,t),s(e,Zs,t),s(e,y,t),s(e,Xs,t),p(v,e,t),s(e,en,t),s(e,b,t),s(e,tn,t),s(e,M,t),s(e,ln,t),s(e,x,t),s(e,sn,t),s(e,nn,t),s(e,on,t),s(e,C,t),s(e,rn,t),p(H,e,t),s(e,dn,t),s(e,L,t),s(e,an,t),s(e,w,t),s(e,un,t),s(e,mn,t),s(e,pn,t),s(e,A,t),s(e,cn,t),p(g,e,t),s(e,fn,t),s(e,U,t),s(e,Tn,t),s(e,z,t),s(e,hn,t),s(e,_n,t),s(e,$n,t),s(e,P,t),s(e,yn,t),p(R,e,t),s(e,vn,t),s(e,J,t),s(e,bn,t),s(e,j,t),s(e,Mn,t),s(e,xn,t),s(e,Cn,t),s(e,E,t),s(e,Hn,t),p(k,e,t),s(e,Ln,t),s(e,D,t),s(e,wn,t),s(e,I,t),s(e,An,t),s(e,gn,t),s(e,Un,t),s(e,q,t),s(e,zn,t),p(K,e,t),s(e,Pn,t),s(e,N,t),s(e,Rn,t),s(e,B,t),s(e,Jn,t),s(e,jn,t),s(e,En,t),s(e,V,t),s(e,kn,t),p(Q,e,t),s(e,Dn,t),s(e,S,t),s(e,In,t),s(e,W,t),s(e,qn,t),s(e,Kn,t),s(e,Nn,t),s(e,Y,t),s(e,Bn,t),p(F,e,t),s(e,Vn,t),s(e,O,t),s(e,Qn,t),s(e,G,t),s(e,Sn,t),s(e,Wn,t),s(e,Yn,t),s(e,Z,t),s(e,Fn,t),p(X,e,t),s(e,On,t),s(e,ee,t),s(e,Gn,t),s(e,te,t),s(e,Zn,t),s(e,le,t),s(e,Xn,t),s(e,eo,t),s(e,to,t),s(e,se,t),s(e,lo,t),p(ne,e,t),s(e,so,t),s(e,oe,t),s(e,no,t),s(e,ie,t),s(e,oo,t),s(e,io,t),s(e,ro,t),s(e,re,t),s(e,ao,t),p(de,e,t),s(e,uo,t),s(e,ae,t),s(e,mo,t),s(e,ue,t),s(e,po,t),s(e,co,t),s(e,fo,t),s(e,me,t),s(e,To,t),p(pe,e,t),s(e,ho,t),s(e,ce,t),s(e,_o,t),s(e,fe,t),s(e,$o,t),s(e,Te,t),s(e,yo,t),s(e,vo,t),s(e,bo,t),s(e,he,t),s(e,Mo,t),p(_e,e,t),s(e,xo,t),s(e,$e,t),s(e,Co,t),s(e,ye,t),s(e,Ho,t),s(e,Lo,t),s(e,wo,t),s(e,ve,t),s(e,Ao,t),p(be,e,t),s(e,go,t),s(e,Me,t),s(e,Uo,t),s(e,xe,t),s(e,zo,t),s(e,Po,t),s(e,Ro,t),s(e,Ce,t),s(e,Jo,t),p(He,e,t),s(e,jo,t),s(e,Le,t),s(e,Eo,t),s(e,we,t),s(e,ko,t),s(e,Do,t),s(e,Io,t),s(e,Ae,t),s(e,qo,t),p(ge,e,t),s(e,Ko,t),s(e,Ue,t),s(e,No,t),s(e,ze,t),s(e,Bo,t),s(e,Pe,t),s(e,Vo,t),s(e,Qo,t),s(e,So,t),s(e,Re,t),s(e,Wo,t),p(Je,e,t),s(e,Yo,t),s(e,je,t),s(e,Fo,t),s(e,Ee,t),s(e,Oo,t),s(e,ke,t),s(e,Go,t),s(e,Zo,t),s(e,Xo,t),s(e,De,t),s(e,ei,t),p(Ie,e,t),s(e,ti,t),s(e,qe,t),s(e,li,t),s(e,Ke,t),s(e,si,t),s(e,Ne,t),s(e,ni,t),s(e,oi,t),s(e,ii,t),s(e,Be,t),s(e,ri,t),p(Ve,e,t),s(e,di,t),s(e,Qe,t),s(e,ai,t),s(e,Se,t),s(e,ui,t),s(e,We,t),s(e,mi,t),s(e,pi,t),s(e,ci,t),s(e,Ye,t),s(e,fi,t),p(Fe,e,t),s(e,Ti,t),s(e,Oe,t),s(e,hi,t),s(e,Ge,t),s(e,_i,t),s(e,Ze,t),s(e,$i,t),s(e,yi,t),s(e,vi,t),s(e,Xe,t),s(e,bi,t),p(et,e,t),s(e,Mi,t),s(e,tt,t),s(e,xi,t),s(e,lt,t),s(e,Ci,t),s(e,st,t),s(e,Hi,t),s(e,Li,t),s(e,wi,t),s(e,nt,t),s(e,Ai,t),p(ot,e,t),s(e,gi,t),s(e,it,t),s(e,Ui,t),s(e,rt,t),s(e,zi,t),s(e,dt,t),s(e,Pi,t),s(e,Ri,t),s(e,Ji,t),s(e,at,t),s(e,ji,t),p(ut,e,t),s(e,Ei,t),s(e,mt,t),s(e,ki,t),s(e,pt,t),s(e,Di,t),s(e,ct,t),s(e,Ii,t),s(e,qi,t),s(e,Ki,t),s(e,ft,t),s(e,Ni,t),p(Tt,e,t),s(e,Bi,t),s(e,ht,t),s(e,Vi,t),s(e,_t,t),s(e,Qi,t),s(e,$t,t),s(e,Si,t),s(e,Wi,t),s(e,Yi,t),s(e,yt,t),s(e,Fi,t),p(vt,e,t),s(e,Oi,t),s(e,bt,t),s(e,Gi,t),s(e,Mt,t),s(e,Zi,t),s(e,Xi,t),s(e,er,t),s(e,xt,t),s(e,tr,t),p(Ct,e,t),s(e,lr,t),s(e,Ht,t),s(e,sr,t),s(e,Lt,t),s(e,nr,t),s(e,wt,t),s(e,or,t),s(e,At,t),s(e,ir,t),s(e,rr,t),s(e,dr,t),s(e,gt,t),s(e,ar,t),p(Ut,e,t),s(e,ur,t),s(e,zt,t),s(e,mr,t),s(e,Pt,t),s(e,pr,t),s(e,cr,t),s(e,fr,t),s(e,Rt,t),s(e,Tr,t),p(Jt,e,t),s(e,hr,t),s(e,jt,t),s(e,_r,t),s(e,Et,t),s(e,$r,t),s(e,kt,t),s(e,yr,t),s(e,Dt,t),s(e,vr,t),s(e,br,t),s(e,Mr,t),s(e,It,t),s(e,xr,t),p(qt,e,t),s(e,Cr,t),s(e,Kt,t),s(e,Hr,t),s(e,Nt,t),s(e,Lr,t),s(e,wr,t),s(e,Ar,t),s(e,Bt,t),s(e,gr,t),p(Vt,e,t),s(e,Ur,t),s(e,Qt,t),s(e,zr,t),s(e,St,t),s(e,Pr,t),s(e,Rr,t),s(e,Jr,t),s(e,Wt,t),s(e,jr,t),p(Yt,e,t),s(e,Er,t),s(e,Ft,t),s(e,kr,t),s(e,Ot,t),s(e,Dr,t),s(e,Gt,t),s(e,Ir,t),s(e,qr,t),s(e,Kr,t),s(e,Zt,t),s(e,Nr,t),p(Xt,e,t),s(e,Br,t),s(e,el,t),s(e,Vr,t),s(e,tl,t),s(e,Qr,t),s(e,ll,t),s(e,Sr,t),s(e,Wr,t),s(e,Yr,t),s(e,sl,t),s(e,Fr,t),p(nl,e,t),s(e,Or,t),s(e,ol,t),s(e,Gr,t),s(e,il,t),s(e,Zr,t),s(e,Xr,t),s(e,ed,t),s(e,rl,t),s(e,td,t),p(dl,e,t),s(e,ld,t),s(e,al,t),s(e,sd,t),s(e,ul,t),s(e,nd,t),s(e,ml,t),s(e,od,t),s(e,id,t),s(e,rd,t),s(e,pl,t),s(e,dd,t),p(cl,e,t),s(e,ad,t),s(e,fl,t),s(e,ud,t),s(e,Tl,t),s(e,md,t),s(e,pd,t),s(e,cd,t),s(e,hl,t),s(e,fd,t),p(_l,e,t),s(e,Td,t),s(e,$l,t),s(e,hd,t),s(e,yl,t),s(e,_d,t),s(e,$d,t),s(e,yd,t),s(e,vl,t),s(e,vd,t),p(bl,e,t),s(e,bd,t),s(e,Ml,t),s(e,Md,t),s(e,xl,t),s(e,xd,t),s(e,Cl,t),s(e,Cd,t),s(e,Hd,t),s(e,Ld,t),s(e,Hl,t),s(e,wd,t),p(Ll,e,t),s(e,Ad,t),s(e,wl,t),s(e,gd,t),s(e,Al,t),s(e,Ud,t),s(e,gl,t),s(e,zd,t),s(e,Pd,t),s(e,Rd,t),s(e,Ul,t),s(e,Jd,t),p(zl,e,t),s(e,jd,t),s(e,Pl,t),s(e,Ed,t),s(e,Rl,t),s(e,kd,t),s(e,Jl,t),s(e,Dd,t),s(e,Id,t),s(e,qd,t),s(e,jl,t),s(e,Kd,t),p(El,e,t),s(e,Nd,t),s(e,kl,t),s(e,Bd,t),s(e,Dl,t),s(e,Vd,t),s(e,Il,t),s(e,Qd,t),s(e,Sd,t),s(e,Wd,t),s(e,ql,t),s(e,Yd,t),p(Kl,e,t),s(e,Fd,t),s(e,Nl,t),s(e,Od,t),s(e,Bl,t),s(e,Gd,t),s(e,Vl,t),s(e,Zd,t),s(e,Xd,t),s(e,ea,t),s(e,Ql,t),s(e,ta,t),p(Sl,e,t),s(e,la,t),s(e,Wl,t),s(e,sa,t),s(e,Yl,t),s(e,na,t),s(e,Fl,t),s(e,oa,t),s(e,ia,t),s(e,ra,t),s(e,Ol,t),s(e,da,t),p(Gl,e,t),s(e,aa,t),s(e,Zl,t),s(e,ua,t),s(e,Xl,t),s(e,ma,t),s(e,es,t),s(e,pa,t),s(e,ca,t),s(e,fa,t),s(e,ts,t),s(e,Ta,t),p(ls,e,t),s(e,ha,t),s(e,ss,t),s(e,_a,t),s(e,ns,t),s(e,$a,t),s(e,os,t),s(e,ya,t),s(e,va,t),s(e,ba,t),s(e,is,t),s(e,Ma,t),p(rs,e,t),s(e,xa,t),s(e,ds,t),s(e,Ca,t),s(e,as,t),s(e,Ha,t),s(e,us,t),s(e,La,t),s(e,wa,t),s(e,Aa,t),s(e,ms,t),s(e,ga,t),p(ps,e,t),s(e,Ua,t),s(e,cs,t),s(e,za,t),s(e,fs,t),s(e,Pa,t),s(e,Ts,t),s(e,Ra,t),s(e,Ja,t),s(e,ja,t),s(e,hs,t),s(e,Ea,t),p(_s,e,t),s(e,ka,t),s(e,$s,t),s(e,Da,t),s(e,ys,t),s(e,Ia,t),s(e,vs,t),s(e,qa,t),s(e,Ka,t),s(e,Na,t),s(e,bs,t),s(e,Ba,t),p(Ms,e,t),s(e,Va,t),s(e,xs,t),s(e,Qa,t),s(e,Sa,t),s(e,Wa,t),s(e,Cs,t),s(e,Ya,t),p(Hs,e,t),s(e,Fa,t),s(e,Ls,t),s(e,Oa,t),s(e,Ga,t),s(e,Za,t),s(e,ws,t),s(e,Xa,t),p(As,e,t),s(e,eu,t),s(e,gs,t),s(e,tu,t),s(e,Us,t),s(e,lu,t),s(e,zs,t),s(e,su,t),s(e,Ps,t),s(e,nu,t),p(Rs,e,t),s(e,ou,t),s(e,iu,t),s(e,ru,t),s(e,Js,t),s(e,du,t),p(js,e,t),s(e,au,t),s(e,Es,t),s(e,uu,t),s(e,mu,t),s(e,pu,t),s(e,ks,t),s(e,cu,t),p(Ds,e,t),s(e,fu,t),s(e,Is,t),s(e,Tu,t),s(e,hu,t),s(e,_u,t),s(e,qs,t),s(e,$u,t),p(Ks,e,t),s(e,yu,t),s(e,Ns,t),s(e,vu,t),s(e,Bs,t),s(e,bu,t),p(Vs,e,t),s(e,Mu,t),s(e,Qs,t),s(e,xu,t),p(Ss,e,t),s(e,Cu,t),s(e,Ws,t),s(e,Hu,t),p(Ys,e,t),s(e,Lu,t),s(e,wu,t),s(e,Au,t),s(e,Os,t),gu=!0},p:rc,i(e){gu||(c(v.$$.fragment,e),c(H.$$.fragment,e),c(g.$$.fragment,e),c(R.$$.fragment,e),c(k.$$.fragment,e),c(K.$$.fragment,e),c(Q.$$.fragment,e),c(F.$$.fragment,e),c(X.$$.fragment,e),c(ne.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(_e.$$.fragment,e),c(be.$$.fragment,e),c(He.$$.fragment,e),c(ge.$$.fragment,e),c(Je.$$.fragment,e),c(Ie.$$.fragment,e),c(Ve.$$.fragment,e),c(Fe.$$.fragment,e),c(et.$$.fragment,e),c(ot.$$.fragment,e),c(ut.$$.fragment,e),c(Tt.$$.fragment,e),c(vt.$$.fragment,e),c(Ct.$$.fragment,e),c(Ut.$$.fragment,e),c(Jt.$$.fragment,e),c(qt.$$.fragment,e),c(Vt.$$.fragment,e),c(Yt.$$.fragment,e),c(Xt.$$.fragment,e),c(nl.$$.fragment,e),c(dl.$$.fragment,e),c(cl.$$.fragment,e),c(_l.$$.fragment,e),c(bl.$$.fragment,e),c(Ll.$$.fragment,e),c(zl.$$.fragment,e),c(El.$$.fragment,e),c(Kl.$$.fragment,e),c(Sl.$$.fragment,e),c(Gl.$$.fragment,e),c(ls.$$.fragment,e),c(rs.$$.fragment,e),c(ps.$$.fragment,e),c(_s.$$.fragment,e),c(Ms.$$.fragment,e),c(Hs.$$.fragment,e),c(As.$$.fragment,e),c(Rs.$$.fragment,e),c(js.$$.fragment,e),c(Ds.$$.fragment,e),c(Ks.$$.fragment,e),c(Vs.$$.fragment,e),c(Ss.$$.fragment,e),c(Ys.$$.fragment,e),gu=!0)},o(e){f(v.$$.fragment,e),f(H.$$.fragment,e),f(g.$$.fragment,e),f(R.$$.fragment,e),f(k.$$.fragment,e),f(K.$$.fragment,e),f(Q.$$.fragment,e),f(F.$$.fragment,e),f(X.$$.fragment,e),f(ne.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(He.$$.fragment,e),f(ge.$$.fragment,e),f(Je.$$.fragment,e),f(Ie.$$.fragment,e),f(Ve.$$.fragment,e),f(Fe.$$.fragment,e),f(et.$$.fragment,e),f(ot.$$.fragment,e),f(ut.$$.fragment,e),f(Tt.$$.fragment,e),f(vt.$$.fragment,e),f(Ct.$$.fragment,e),f(Ut.$$.fragment,e),f(Jt.$$.fragment,e),f(qt.$$.fragment,e),f(Vt.$$.fragment,e),f(Yt.$$.fragment,e),f(Xt.$$.fragment,e),f(nl.$$.fragment,e),f(dl.$$.fragment,e),f(cl.$$.fragment,e),f(_l.$$.fragment,e),f(bl.$$.fragment,e),f(Ll.$$.fragment,e),f(zl.$$.fragment,e),f(El.$$.fragment,e),f(Kl.$$.fragment,e),f(Sl.$$.fragment,e),f(Gl.$$.fragment,e),f(ls.$$.fragment,e),f(rs.$$.fragment,e),f(ps.$$.fragment,e),f(_s.$$.fragment,e),f(Ms.$$.fragment,e),f(Hs.$$.fragment,e),f(As.$$.fragment,e),f(Rs.$$.fragment,e),f(js.$$.fragment,e),f(Ds.$$.fragment,e),f(Ks.$$.fragment,e),f(Vs.$$.fragment,e),f(Ss.$$.fragment,e),f(Ys.$$.fragment,e),gu=!1},d(e){e&&(l(Gs),l(Fs),l(Zs),l(y),l(Xs),l(en),l(b),l(tn),l(M),l(ln),l(x),l(sn),l(nn),l(on),l(C),l(rn),l(dn),l(L),l(an),l(w),l(un),l(mn),l(pn),l(A),l(cn),l(fn),l(U),l(Tn),l(z),l(hn),l(_n),l($n),l(P),l(yn),l(vn),l(J),l(bn),l(j),l(Mn),l(xn),l(Cn),l(E),l(Hn),l(Ln),l(D),l(wn),l(I),l(An),l(gn),l(Un),l(q),l(zn),l(Pn),l(N),l(Rn),l(B),l(Jn),l(jn),l(En),l(V),l(kn),l(Dn),l(S),l(In),l(W),l(qn),l(Kn),l(Nn),l(Y),l(Bn),l(Vn),l(O),l(Qn),l(G),l(Sn),l(Wn),l(Yn),l(Z),l(Fn),l(On),l(ee),l(Gn),l(te),l(Zn),l(le),l(Xn),l(eo),l(to),l(se),l(lo),l(so),l(oe),l(no),l(ie),l(oo),l(io),l(ro),l(re),l(ao),l(uo),l(ae),l(mo),l(ue),l(po),l(co),l(fo),l(me),l(To),l(ho),l(ce),l(_o),l(fe),l($o),l(Te),l(yo),l(vo),l(bo),l(he),l(Mo),l(xo),l($e),l(Co),l(ye),l(Ho),l(Lo),l(wo),l(ve),l(Ao),l(go),l(Me),l(Uo),l(xe),l(zo),l(Po),l(Ro),l(Ce),l(Jo),l(jo),l(Le),l(Eo),l(we),l(ko),l(Do),l(Io),l(Ae),l(qo),l(Ko),l(Ue),l(No),l(ze),l(Bo),l(Pe),l(Vo),l(Qo),l(So),l(Re),l(Wo),l(Yo),l(je),l(Fo),l(Ee),l(Oo),l(ke),l(Go),l(Zo),l(Xo),l(De),l(ei),l(ti),l(qe),l(li),l(Ke),l(si),l(Ne),l(ni),l(oi),l(ii),l(Be),l(ri),l(di),l(Qe),l(ai),l(Se),l(ui),l(We),l(mi),l(pi),l(ci),l(Ye),l(fi),l(Ti),l(Oe),l(hi),l(Ge),l(_i),l(Ze),l($i),l(yi),l(vi),l(Xe),l(bi),l(Mi),l(tt),l(xi),l(lt),l(Ci),l(st),l(Hi),l(Li),l(wi),l(nt),l(Ai),l(gi),l(it),l(Ui),l(rt),l(zi),l(dt),l(Pi),l(Ri),l(Ji),l(at),l(ji),l(Ei),l(mt),l(ki),l(pt),l(Di),l(ct),l(Ii),l(qi),l(Ki),l(ft),l(Ni),l(Bi),l(ht),l(Vi),l(_t),l(Qi),l($t),l(Si),l(Wi),l(Yi),l(yt),l(Fi),l(Oi),l(bt),l(Gi),l(Mt),l(Zi),l(Xi),l(er),l(xt),l(tr),l(lr),l(Ht),l(sr),l(Lt),l(nr),l(wt),l(or),l(At),l(ir),l(rr),l(dr),l(gt),l(ar),l(ur),l(zt),l(mr),l(Pt),l(pr),l(cr),l(fr),l(Rt),l(Tr),l(hr),l(jt),l(_r),l(Et),l($r),l(kt),l(yr),l(Dt),l(vr),l(br),l(Mr),l(It),l(xr),l(Cr),l(Kt),l(Hr),l(Nt),l(Lr),l(wr),l(Ar),l(Bt),l(gr),l(Ur),l(Qt),l(zr),l(St),l(Pr),l(Rr),l(Jr),l(Wt),l(jr),l(Er),l(Ft),l(kr),l(Ot),l(Dr),l(Gt),l(Ir),l(qr),l(Kr),l(Zt),l(Nr),l(Br),l(el),l(Vr),l(tl),l(Qr),l(ll),l(Sr),l(Wr),l(Yr),l(sl),l(Fr),l(Or),l(ol),l(Gr),l(il),l(Zr),l(Xr),l(ed),l(rl),l(td),l(ld),l(al),l(sd),l(ul),l(nd),l(ml),l(od),l(id),l(rd),l(pl),l(dd),l(ad),l(fl),l(ud),l(Tl),l(md),l(pd),l(cd),l(hl),l(fd),l(Td),l($l),l(hd),l(yl),l(_d),l($d),l(yd),l(vl),l(vd),l(bd),l(Ml),l(Md),l(xl),l(xd),l(Cl),l(Cd),l(Hd),l(Ld),l(Hl),l(wd),l(Ad),l(wl),l(gd),l(Al),l(Ud),l(gl),l(zd),l(Pd),l(Rd),l(Ul),l(Jd),l(jd),l(Pl),l(Ed),l(Rl),l(kd),l(Jl),l(Dd),l(Id),l(qd),l(jl),l(Kd),l(Nd),l(kl),l(Bd),l(Dl),l(Vd),l(Il),l(Qd),l(Sd),l(Wd),l(ql),l(Yd),l(Fd),l(Nl),l(Od),l(Bl),l(Gd),l(Vl),l(Zd),l(Xd),l(ea),l(Ql),l(ta),l(la),l(Wl),l(sa),l(Yl),l(na),l(Fl),l(oa),l(ia),l(ra),l(Ol),l(da),l(aa),l(Zl),l(ua),l(Xl),l(ma),l(es),l(pa),l(ca),l(fa),l(ts),l(Ta),l(ha),l(ss),l(_a),l(ns),l($a),l(os),l(ya),l(va),l(ba),l(is),l(Ma),l(xa),l(ds),l(Ca),l(as),l(Ha),l(us),l(La),l(wa),l(Aa),l(ms),l(ga),l(Ua),l(cs),l(za),l(fs),l(Pa),l(Ts),l(Ra),l(Ja),l(ja),l(hs),l(Ea),l(ka),l($s),l(Da),l(ys),l(Ia),l(vs),l(qa),l(Ka),l(Na),l(bs),l(Ba),l(Va),l(xs),l(Qa),l(Sa),l(Wa),l(Cs),l(Ya),l(Fa),l(Ls),l(Oa),l(Ga),l(Za),l(ws),l(Xa),l(eu),l(gs),l(tu),l(Us),l(lu),l(zs),l(su),l(Ps),l(nu),l(ou),l(iu),l(ru),l(Js),l(du),l(au),l(Es),l(uu),l(mu),l(pu),l(ks),l(cu),l(fu),l(Is),l(Tu),l(hu),l(_u),l(qs),l($u),l(yu),l(Ns),l(vu),l(Bs),l(bu),l(Mu),l(Qs),l(xu),l(Cu),l(Ws),l(Hu),l(Lu),l(wu),l(Au),l(Os)),l($),T(v,e),T(H,e),T(g,e),T(R,e),T(k,e),T(K,e),T(Q,e),T(F,e),T(X,e),T(ne,e),T(de,e),T(pe,e),T(_e,e),T(be,e),T(He,e),T(ge,e),T(Je,e),T(Ie,e),T(Ve,e),T(Fe,e),T(et,e),T(ot,e),T(ut,e),T(Tt,e),T(vt,e),T(Ct,e),T(Ut,e),T(Jt,e),T(qt,e),T(Vt,e),T(Yt,e),T(Xt,e),T(nl,e),T(dl,e),T(cl,e),T(_l,e),T(bl,e),T(Ll,e),T(zl,e),T(El,e),T(Kl,e),T(Sl,e),T(Gl,e),T(ls,e),T(rs,e),T(ps,e),T(_s,e),T(Ms,e),T(Hs,e),T(As,e),T(Rs,e),T(js,e),T(Ds,e),T(Ks,e),T(Vs,e),T(Ss,e),T(Ys,e)}}}const fc='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.transpose(...dims) ⇒ <code> Tensor </code>","local":"tensortransposedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒","local":"tensorsqueezedim-","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒","local":"tensorunsqueezedim-","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒","local":"tensorflattenstartdim-enddim-","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒","local":"tensorclampmin-max-","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒","local":"tensorround-","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensortransposetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒","local":"utilstensormeaninput-dim-keepdim-","sections":[],"depth":2},{"title":"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>","local":"utilstensordynamictimewarpingmatrix--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/tensor.ones(size)","local":"utilstensoronessize","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒","local":"utilstensoronesliketensor-","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> DataType </code>","local":"utilstensorargs0--code-datatype-code","sections":[],"depth":2},{"title":"utils/tensor~args[1] : <code> * </code>","local":"utilstensorargs1--code--code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function Tc(zu){return dc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vc extends ac{constructor($){super(),uc(this,$,Tc,cc,ic,{})}}export{vc as component};
