import{s as Ca,f as Ja,n as xa,o as Ua}from"../chunks/scheduler.85c25b89.js";import{S as Fa,i as Da,g as i,s as l,r as s,A as ja,h as r,f as t,c as o,j as pe,u as m,x as d,k as M,y as le,a as n,v as p,d as c,t as h,w as f}from"../chunks/index.c142fe32.js";import{D as ka}from"../chunks/Docstring.e6639b56.js";import{C as ce}from"../chunks/CodeBlock.a5e95a57.js";import{H as _,E as La}from"../chunks/EditOnGithub.a592e7aa.js";function Ia(la){let v,he,me,fe,w,_e,T,ue,y,oa='Nash-MD was proposed in the paper <a href="https://huggingface.co/papers/2312.00886" rel="nofollow">Nash Learning from Human Feedback</a> by Rémi Munos, <a href="https://huggingface.co/misovalko" rel="nofollow">Michal Valko</a>, Daniele Calandriello, Mohammad Gheshlaghi Azar, Mark Rowland, Daniel Guo, Yunhao Tang, Matthieu Geist, Thomas Mésnard, and Andrea Michi.',ge,N,ia="The abstract from the paper is the following:",ve,$,ra="<p>Reinforcement learning from human feedback (RLHF) has emerged as the main paradigm for aligning large language models (LLMs) with human preferences. Typically, RLHF involves the initial step of learning a reward model from human feedback, often expressed as preferences between pairs of text generations produced by a pre-trained LLM. Subsequently, the LLM’s policy is fine-tuned by optimizing it to maximize the reward model through a reinforcement learning algorithm. However, an inherent limitation of current reward models is their inability to fully represent the richness of human preferences and their dependency on the sampling distribution. In this study, we introduce an alternative pipeline for the fine-tuning of LLMs using pairwise human feedback. Our approach entails the initial learning of a preference model, which is conditioned on two inputs given a prompt, followed by the pursuit of a policy that consistently generates responses preferred over those generated by any competing policy, thus defining the Nash equilibrium of this preference model. We term this approach Nash learning from human feedback (NLHF). In the context of a tabular policy representation, we present a novel algorithmic solution, Nash-MD, founded on the principles of mirror descent. This algorithm produces a sequence of policies, with the last iteration converging to the regularized Nash equilibrium. Additionally, we explore parametric representations of policies and introduce gradient descent algorithms for deep-learning architectures. To demonstrate the effectiveness of our approach, we present experimental results involving the fine-tuning of a LLM for a text summarization task. We believe NLHF offers a compelling avenue for preference learning and policy optimization with the potential of advancing the field of aligning LLMs with human preferences.</p>",be,k,sa='This post-training method was contributed by <a href="https://huggingface.co/kashif" rel="nofollow">Kashif Rasul</a> and <a href="https://huggingface.co/dtiapkin" rel="nofollow">Daniil Tiapkin</a>, <a href="https://huggingface.co/menardprr" rel="nofollow">Pierre Ménard</a>, Daniele Calandriello and <a href="https://huggingface.co/qgallouedec" rel="nofollow">Quentin Gallouédec</a>.',Me,C,we,J,ma='This example demonstrates how to train a model using the Nash-MD method. We use the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen 0.5B model</a> as the base model and the <a href="https://huggingface.co/trl-lib/Qwen2-0.5B-Reward" rel="nofollow">Qwen 0.5B reward model</a> as the reward model. We use the prompts from the <a href="https://huggingface.co/datasets/openbmb/UltraFeedback" rel="nofollow">UltraFeedback dataset</a>. You can view the prompts in the dataset here:',Te,g,da,ye,x,pa="Below is the script to train the model:",Ne,U,$e,F,ca="Execute the script using the following command:",ke,D,Ce,j,Je,L,ha='Nash-MD requires a <a href="dataset_format#preference">prompt-only dataset</a>. The <a href="/docs/trl/v0.11.3/en/nash_md_trainer#trl.NashMDTrainer">NashMDTrainer</a> supports both <a href="dataset_format#conversational-dataset-format">conversational</a> and <a href="dataset_format#standard-dataset-format">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.',xe,I,Ue,O,Fe,X,fa="Make sure that the SFT model and reward model use the <em>same</em> chat template. Otherwise, you may find the model completions are scored incorrectly during training.",De,R,je,Z,_a='We can want the model to generate completion within a given length. During the learning, the model will generate completion up to the maximum completion length specified in the <code>max_new_tokens</code> argument of <a href="/docs/trl/v0.11.3/en/nash_md_trainer#trl.NashMDConfig">NashMDConfig</a>. I you want to penalize for not generating an EOS token before the maximum completion length, you can use the <code>missing_eos_penalty</code> argument of <a href="/docs/trl/v0.11.3/en/nash_md_trainer#trl.NashMDConfig">NashMDConfig</a>:',Le,W,Ie,E,Oe,z,ua='To better understand your model’s behavior during training, you can log sample completions periodically using the <a href="/docs/trl/v0.11.3/en/callbacks#trl.LogCompletionsCallback">LogCompletionsCallback</a>.',Xe,H,Re,B,ga="This callback logs the model’s generated completions directly to Weights & Biases.",Ze,G,va='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/wandb_completions.png" alt="Logged Completions"/>',We,A,Ee,Y,ba='We provide an example script to train a model using the Nash-MD method. The script is available in <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/nash_md.py" rel="nofollow"><code>examples/scripts/nash_md.py</code></a>',ze,Q,Ma='To test the Nash-MD script with the <a href="https://huggingface.co/EleutherAI/pythia-14m" rel="nofollow">Pythia 14M model</a> on the TL;DR summarization task, run the following command:',He,V,Be,S,Ge,P,wa="The logged metrics are as follows:",Ae,q,Ta='<li><code>loss/kl</code>: The mean KL divergence between the model and reference data.</li> <li><code>objective/entropy</code>: The mean entropy of the model and reference data.</li> <li><code>loss/score</code>: The mean reinforce score loss.</li> <li><code>rewards/chosen</code>: The mean scores (according to the reward model) of the model completions.</li> <li><code>rewards/rejected</code>: The mean scores (according to the reward model) of the mixture completions.</li> <li><code>rewards/accuracies</code>: The accuracies of the Nash-MD’s implicit reward model.</li> <li><code>rewards/margins</code>: The mean reward margin (according to reward model) between the chosen and mixture completions.</li> <li><code>logps/chosen</code>: The mean log probabilities of the chosen completions.</li> <li><code>logps/rejected</code>: The mean log probabilities of the reference completions.</li> <li><code>val/model_contain_eos_token</code>: The amount of times the model’s output contains the eos token.</li> <li><code>val/ref_contain_eos_token</code>: The amount of times the mixture’s output contains the eos token.</li> <li><code>beta</code>: The parameter that controls the weight of the loss term representing the deviation from the reference model. Typically fixed, but can be made dynamic by passing a list to <a href="/docs/trl/v0.11.3/en/nash_md_trainer#trl.NashMDConfig">NashMDConfig</a>.</li> <li><code>mixture_coef</code>: Logit mixture coefficient for the model and reference model. Typically fixed, but can be made dynamic by passing a list to <a href="/docs/trl/v0.11.3/en/nash_md_trainer#trl.NashMDConfig">NashMDConfig</a>.</li>',Ye,K,Qe,b,ee,aa,oe,ya='Initialize NashMDTrainer as a subclass of <a href="/docs/trl/v0.11.3/en/online_dpo_trainer#trl.OnlineDPOConfig">OnlineDPOConfig</a>.',Ve,ae,Se,u,te,ta,ie,Na='Configuration class for the <a href="/docs/trl/v0.11.3/en/nash_md_trainer#trl.NashMDTrainer">NashMDTrainer</a>.',na,re,$a='Subclass of <a href="/docs/trl/v0.11.3/en/online_dpo_trainer#trl.OnlineDPOConfig">OnlineDPOConfig</a> we can use all its arguments and add the following:',Pe,ne,qe,de,Ke;return w=new _({props:{title:"Nash-MD Trainer",local:"nash-md-trainer",headingTag:"h1"}}),T=new _({props:{title:"Overview",local:"overview",headingTag:"h2"}}),C=new _({props:{title:"Quick start",local:"quick-start",headingTag:"h2"}}),U=new ce({props:{code:"JTIzJTIwdHJhaW5fbmFzaF9tZC5weSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBOYXNoTURDb25maWclMkMlMjBOYXNoTURUcmFpbmVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjItMC41Qi1JbnN0cnVjdCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjItMC41Qi1JbnN0cnVjdCUyMiklMEFyZXdhcmRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJ0cmwtbGliJTJGUXdlbjItMC41Qi1SZXdhcmQlMjIlMkMlMjBudW1fbGFiZWxzJTNEMSklMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnRybC1saWIlMkZ1bHRyYWZlZWRiYWNrLXByb21wdCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBYXJncyUyMCUzRCUyME5hc2hNRENvbmZpZyhvdXRwdXRfZGlyJTNEJTIybmFzaC1tZC1xd2VuMiUyMiUyQyUyMGxvZ2dpbmdfc3RlcHMlM0QxMCklMEF0cmFpbmVyJTIwJTNEJTIwTmFzaE1EVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwcmV3YXJkX21vZGVsJTNEcmV3YXJkX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># train_nash_md.py</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> NashMDConfig, NashMDTrainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoModelForSequenceClassification, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
reward_model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;trl-lib/Qwen2-0.5B-Reward&quot;</span>, num_labels=<span class="hljs-number">1</span>)
train_dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback-prompt&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

args = NashMDConfig(output_dir=<span class="hljs-string">&quot;nash-md-qwen2&quot;</span>, logging_steps=<span class="hljs-number">10</span>)
trainer = NashMDTrainer(
    model=model,
    reward_model=reward_model,
    args=args,
    tokenizer=tokenizer,
    train_dataset=train_dataset,
)
trainer.train()`,wrap:!1}}),D=new ce({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX25hc2hfbWQucHk=",highlighted:"accelerate launch train_nash_md.py",wrap:!1}}),j=new _({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),I=new _({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),O=new _({props:{title:"⚠️ Use the same chat template",local:"-use-the-same-chat-template",headingTag:"h3"}}),R=new _({props:{title:"Encourage EOS token generation",local:"encourage-eos-token-generation",headingTag:"h3"}}),W=new ce({props:{code:"YXJncyUyMCUzRCUyME5hc2hNRENvbmZpZyguLi4lMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCUyQyUyMG1pc3NpbmdfZW9zX3BlbmFsdHklM0QxLjAp",highlighted:'args = NashMDConfig(..., max_new_tokens=<span class="hljs-number">128</span>, missing_eos_penalty=<span class="hljs-number">1.0</span>)',wrap:!1}}),E=new _({props:{title:"Logging Completions",local:"logging-completions",headingTag:"h3"}}),H=new ce({props:{code:"dHJhaW5lciUyMCUzRCUyME5hc2hNRFRyYWluZXIoLi4uJTJDJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0KSUwQWNvbXBsZXRpb25zX2NhbGxiYWNrJTIwJTNEJTIwTG9nQ29tcGxldGlvbnNDYWxsYmFjayh0cmFpbmVyJTJDJTIwbnVtX3Byb21wdHMlM0Q4KSUwQXRyYWluZXIuYWRkX2NhbGxiYWNrKGNvbXBsZXRpb25zX2NhbGxiYWNrKQ==",highlighted:`trainer = NashMDTrainer(..., eval_dataset=eval_dataset)
completions_callback = LogCompletionsCallback(trainer, num_prompts=<span class="hljs-number">8</span>)
trainer.add_callback(completions_callback)`,wrap:!1}}),A=new _({props:{title:"Example script",local:"example-script",headingTag:"h2"}}),V=new ce({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGbmFzaF9tZC5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwRWxldXRoZXJBSSUyRnB5dGhpYS0xNG0lMjAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJld2FyZF9tb2RlbF9wYXRoJTIwRWxldXRoZXJBSSUyRnB5dGhpYS0xNG0lMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHRybC1saWIlMkZ0bGRyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTIwNS4wZS03JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXRfZGlyJTIwcHl0aGlhLTE0bS10bGRyLW5hc2gtbWQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDMyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X25ld190b2tlbnMlMjA2NCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0td2FybXVwX3JhdGlvJTIwMC4xJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1taXNzaW5nX2Vvc19wZW5hbHR5JTIwMS4wJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`python examples/scripts/nash_md.py \\
    --model_name_or_path EleutherAI/pythia-14m  \\
    --reward_model_path EleutherAI/pythia-14m \\
    --dataset_name trl-lib/tldr \\
    --learning_rate 5.0e-7 \\
    --output_dir pythia-14m-tldr-nash-md \\
    --per_device_train_batch_size 4 \\
    --gradient_accumulation_steps 32 \\
    --num_train_epochs 3 \\
    --max_new_tokens 64 \\
    --warmup_ratio 0.1 \\
    --missing_eos_penalty 1.0 \\
    --push_to_hub`,wrap:!1}}),S=new _({props:{title:"Logged metrics",local:"logged-metrics",headingTag:"h2"}}),K=new _({props:{title:"NashMDTrainer",local:"trl.NashMDTrainer",headingTag:"h2"}}),ee=new ka({props:{name:"class trl.NashMDTrainer",anchor:"trl.NashMDTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"reward_model",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Union = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.NashMDTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForCausalLM</code>.`,name:"model"},{anchor:"trl.NashMDTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.NashMDTrainer.reward_model",description:`<strong>reward_model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The reward model to score completions with, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"reward_model"},{anchor:"trl.NashMDTrainer.judge",description:`<strong>judge</strong> (<code>BasePairwiseJudge</code>) &#x2014;
The judge to use for pairwise comparison of model completions.`,name:"judge"},{anchor:"trl.NashMDTrainer.args",description:`<strong>args</strong> (<code>NashMDConfig</code>) &#x2014;
The NashMD config arguments to use for training.`,name:"args"},{anchor:"trl.NashMDTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.NashMDTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.NashMDTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.NashMDTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.NashMDTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>) &#x2014;
The peft config to use for training.`,name:"peft_config"},{anchor:"trl.NashMDTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.NashMDTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.NashMDTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.NashMDTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.11.3/trl/trainer/nash_md_trainer.py#L38"}}),ae=new _({props:{title:"NashMDConfig",local:"trl.NashMDConfig",headingTag:"h2"}}),te=new ka({props:{name:"class trl.NashMDConfig",anchor:"trl.NashMDConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-07"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": List = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"reward_model_path",val:": Optional = None"},{name:"max_new_tokens",val:": int = 64"},{name:"temperature",val:": float = 0.9"},{name:"missing_eos_penalty",val:": Optional = None"},{name:"beta",val:": List = <factory>"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"dataset_num_proc",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"mixture_coef",val:": List = <factory>"}],parametersDescription:[{anchor:"trl.NashMDConfig.mixture_coef",description:`<strong>mixture_coef</strong> (<code>float</code> or <code>list[float]</code>, <em>optional</em>, defaults to <code>0.5</code>) &#x2014;
Logit mixture coefficient for the model and reference model. If a list of floats is provided then the
mixture coefficient is selected for each new epoch and the last coefficient is used for the rest of the
epochs.`,name:"mixture_coef"}],source:"https://github.com/huggingface/trl/blob/v0.11.3/trl/trainer/nash_md_config.py#L21"}}),ne=new La({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/nash_md_trainer.md"}}),{c(){v=i("meta"),he=l(),me=i("p"),fe=l(),s(w.$$.fragment),_e=l(),s(T.$$.fragment),ue=l(),y=i("p"),y.innerHTML=oa,ge=l(),N=i("p"),N.textContent=ia,ve=l(),$=i("blockquote"),$.innerHTML=ra,be=l(),k=i("p"),k.innerHTML=sa,Me=l(),s(C.$$.fragment),we=l(),J=i("p"),J.innerHTML=ma,Te=l(),g=i("iframe"),ye=l(),x=i("p"),x.textContent=pa,Ne=l(),s(U.$$.fragment),$e=l(),F=i("p"),F.textContent=ca,ke=l(),s(D.$$.fragment),Ce=l(),s(j.$$.fragment),Je=l(),L=i("p"),L.innerHTML=ha,xe=l(),s(I.$$.fragment),Ue=l(),s(O.$$.fragment),Fe=l(),X=i("p"),X.innerHTML=fa,De=l(),s(R.$$.fragment),je=l(),Z=i("p"),Z.innerHTML=_a,Le=l(),s(W.$$.fragment),Ie=l(),s(E.$$.fragment),Oe=l(),z=i("p"),z.innerHTML=ua,Xe=l(),s(H.$$.fragment),Re=l(),B=i("p"),B.textContent=ga,Ze=l(),G=i("p"),G.innerHTML=va,We=l(),s(A.$$.fragment),Ee=l(),Y=i("p"),Y.innerHTML=ba,ze=l(),Q=i("p"),Q.innerHTML=Ma,He=l(),s(V.$$.fragment),Be=l(),s(S.$$.fragment),Ge=l(),P=i("p"),P.textContent=wa,Ae=l(),q=i("ul"),q.innerHTML=Ta,Ye=l(),s(K.$$.fragment),Qe=l(),b=i("div"),s(ee.$$.fragment),aa=l(),oe=i("p"),oe.innerHTML=ya,Ve=l(),s(ae.$$.fragment),Se=l(),u=i("div"),s(te.$$.fragment),ta=l(),ie=i("p"),ie.innerHTML=Na,na=l(),re=i("p"),re.innerHTML=$a,Pe=l(),s(ne.$$.fragment),qe=l(),de=i("p"),this.h()},l(e){const a=ja("svelte-u9bgzb",document.head);v=r(a,"META",{name:!0,content:!0}),a.forEach(t),he=o(e),me=r(e,"P",{}),pe(me).forEach(t),fe=o(e),m(w.$$.fragment,e),_e=o(e),m(T.$$.fragment,e),ue=o(e),y=r(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-13k3dxs"&&(y.innerHTML=oa),ge=o(e),N=r(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-vfdo9a"&&(N.textContent=ia),ve=o(e),$=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),d($)!=="svelte-g2berh"&&($.innerHTML=ra),be=o(e),k=r(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-73d64t"&&(k.innerHTML=sa),Me=o(e),m(C.$$.fragment,e),we=o(e),J=r(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-2ijvpa"&&(J.innerHTML=ma),Te=o(e),g=r(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),pe(g).forEach(t),ye=o(e),x=r(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-uqytq6"&&(x.textContent=pa),Ne=o(e),m(U.$$.fragment,e),$e=o(e),F=r(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-15hino8"&&(F.textContent=ca),ke=o(e),m(D.$$.fragment,e),Ce=o(e),m(j.$$.fragment,e),Je=o(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1sp6zad"&&(L.innerHTML=ha),xe=o(e),m(I.$$.fragment,e),Ue=o(e),m(O.$$.fragment,e),Fe=o(e),X=r(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1kgiyxw"&&(X.innerHTML=fa),De=o(e),m(R.$$.fragment,e),je=o(e),Z=r(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-z8sxzo"&&(Z.innerHTML=_a),Le=o(e),m(W.$$.fragment,e),Ie=o(e),m(E.$$.fragment,e),Oe=o(e),z=r(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1ujz5i6"&&(z.innerHTML=ua),Xe=o(e),m(H.$$.fragment,e),Re=o(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1hvqa3l"&&(B.textContent=ga),Ze=o(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-azj40q"&&(G.innerHTML=va),We=o(e),m(A.$$.fragment,e),Ee=o(e),Y=r(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1vqf8nm"&&(Y.innerHTML=ba),ze=o(e),Q=r(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-ut05fh"&&(Q.innerHTML=Ma),He=o(e),m(V.$$.fragment,e),Be=o(e),m(S.$$.fragment,e),Ge=o(e),P=r(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1rzdw7s"&&(P.textContent=wa),Ae=o(e),q=r(e,"UL",{"data-svelte-h":!0}),d(q)!=="svelte-1ki1ued"&&(q.innerHTML=Ta),Ye=o(e),m(K.$$.fragment,e),Qe=o(e),b=r(e,"DIV",{class:!0});var ea=pe(b);m(ee.$$.fragment,ea),aa=o(ea),oe=r(ea,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-jz6mbf"&&(oe.innerHTML=ya),ea.forEach(t),Ve=o(e),m(ae.$$.fragment,e),Se=o(e),u=r(e,"DIV",{class:!0});var se=pe(u);m(te.$$.fragment,se),ta=o(se),ie=r(se,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-k3t2aw"&&(ie.innerHTML=Na),na=o(se),re=r(se,"P",{"data-svelte-h":!0}),d(re)!=="svelte-xls38s"&&(re.innerHTML=$a),se.forEach(t),Pe=o(e),m(ne.$$.fragment,e),qe=o(e),de=r(e,"P",{}),pe(de).forEach(t),this.h()},h(){M(v,"name","hf:doc:metadata"),M(v,"content",Oa),Ja(g.src,da="https://huggingface.co/datasets/trl-lib/ultrafeedback-prompt/embed/viewer/default/train?row=0")||M(g,"src",da),M(g,"frameborder","0"),M(g,"width","100%"),M(g,"height","560px"),M(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){le(document.head,v),n(e,he,a),n(e,me,a),n(e,fe,a),p(w,e,a),n(e,_e,a),p(T,e,a),n(e,ue,a),n(e,y,a),n(e,ge,a),n(e,N,a),n(e,ve,a),n(e,$,a),n(e,be,a),n(e,k,a),n(e,Me,a),p(C,e,a),n(e,we,a),n(e,J,a),n(e,Te,a),n(e,g,a),n(e,ye,a),n(e,x,a),n(e,Ne,a),p(U,e,a),n(e,$e,a),n(e,F,a),n(e,ke,a),p(D,e,a),n(e,Ce,a),p(j,e,a),n(e,Je,a),n(e,L,a),n(e,xe,a),p(I,e,a),n(e,Ue,a),p(O,e,a),n(e,Fe,a),n(e,X,a),n(e,De,a),p(R,e,a),n(e,je,a),n(e,Z,a),n(e,Le,a),p(W,e,a),n(e,Ie,a),p(E,e,a),n(e,Oe,a),n(e,z,a),n(e,Xe,a),p(H,e,a),n(e,Re,a),n(e,B,a),n(e,Ze,a),n(e,G,a),n(e,We,a),p(A,e,a),n(e,Ee,a),n(e,Y,a),n(e,ze,a),n(e,Q,a),n(e,He,a),p(V,e,a),n(e,Be,a),p(S,e,a),n(e,Ge,a),n(e,P,a),n(e,Ae,a),n(e,q,a),n(e,Ye,a),p(K,e,a),n(e,Qe,a),n(e,b,a),p(ee,b,null),le(b,aa),le(b,oe),n(e,Ve,a),p(ae,e,a),n(e,Se,a),n(e,u,a),p(te,u,null),le(u,ta),le(u,ie),le(u,na),le(u,re),n(e,Pe,a),p(ne,e,a),n(e,qe,a),n(e,de,a),Ke=!0},p:xa,i(e){Ke||(c(w.$$.fragment,e),c(T.$$.fragment,e),c(C.$$.fragment,e),c(U.$$.fragment,e),c(D.$$.fragment,e),c(j.$$.fragment,e),c(I.$$.fragment,e),c(O.$$.fragment,e),c(R.$$.fragment,e),c(W.$$.fragment,e),c(E.$$.fragment,e),c(H.$$.fragment,e),c(A.$$.fragment,e),c(V.$$.fragment,e),c(S.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(ae.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),Ke=!0)},o(e){h(w.$$.fragment,e),h(T.$$.fragment,e),h(C.$$.fragment,e),h(U.$$.fragment,e),h(D.$$.fragment,e),h(j.$$.fragment,e),h(I.$$.fragment,e),h(O.$$.fragment,e),h(R.$$.fragment,e),h(W.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(V.$$.fragment,e),h(S.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),Ke=!1},d(e){e&&(t(he),t(me),t(fe),t(_e),t(ue),t(y),t(ge),t(N),t(ve),t($),t(be),t(k),t(Me),t(we),t(J),t(Te),t(g),t(ye),t(x),t(Ne),t($e),t(F),t(ke),t(Ce),t(Je),t(L),t(xe),t(Ue),t(Fe),t(X),t(De),t(je),t(Z),t(Le),t(Ie),t(Oe),t(z),t(Xe),t(Re),t(B),t(Ze),t(G),t(We),t(Ee),t(Y),t(ze),t(Q),t(He),t(Be),t(Ge),t(P),t(Ae),t(q),t(Ye),t(Qe),t(b),t(Ve),t(Se),t(u),t(Pe),t(qe),t(de)),t(v),f(w,e),f(T,e),f(C,e),f(U,e),f(D,e),f(j,e),f(I,e),f(O,e),f(R,e),f(W,e),f(E,e),f(H,e),f(A,e),f(V,e),f(S,e),f(K,e),f(ee),f(ae,e),f(te),f(ne,e)}}}const Oa='{"title":"Nash-MD Trainer","local":"nash-md-trainer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Quick start","local":"quick-start","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"⚠️ Use the same chat template","local":"-use-the-same-chat-template","sections":[],"depth":3},{"title":"Encourage EOS token generation","local":"encourage-eos-token-generation","sections":[],"depth":3},{"title":"Logging Completions","local":"logging-completions","sections":[],"depth":3}],"depth":2},{"title":"Example script","local":"example-script","sections":[],"depth":2},{"title":"Logged metrics","local":"logged-metrics","sections":[],"depth":2},{"title":"NashMDTrainer","local":"trl.NashMDTrainer","sections":[],"depth":2},{"title":"NashMDConfig","local":"trl.NashMDConfig","sections":[],"depth":2}],"depth":1}';function Xa(la){return Ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ha extends Fa{constructor(v){super(),Da(this,v,Xa,Ia,Ca,{})}}export{Ha as component};
