import{s as _a,n as ga,o as ha}from"../chunks/scheduler.9039eef2.js";import{S as ua,i as fa,g as r,s as o,r as p,A as va,h as i,f as t,c as l,j as v,u as _,x as m,k as T,y as a,a as s,v as g,d as h,t as u,w as f}from"../chunks/index.ded8f90d.js";import{D as b}from"../chunks/Docstring.a2ba2b54.js";import{C as Lt}from"../chunks/CodeBlock.8580f3e8.js";import{H as Ie}from"../chunks/Heading.f027f30d.js";function Ta(Dt){let C,Ae,ke,Ke,N,Fe,A,qt=`TRL supports the Kahneman-Tversky Optimization (KTO) Trainer for aligning language models with binary feedback data (e.g., upvote/downvote), as described in the <a href="https://arxiv.org/abs/2402.01306" rel="nofollow">paper</a> by Kawin Ethayarajh, Winnie Xu, Niklas Muennighoff, Dan Jurafsky, and Douwe Kiela.
For a full example have a look at  <code>examples/scripts/kto.py</code>.`,Ee,K,Ht=`Depending on how good your base model is, you may or may not need to do SFT before KTO.
This is different from standard RLHF and DPO, which always require SFT.`,Le,F,De,E,zt="The KTO trainer expects a very specific format for the dataset as it does not require pairwise preferences. Since the model will be trained to directly optimize examples that consist of a prompt, model completion, and a label to indicate whether the completion is “good” or “bad”, we expect a dataset with the following columns:",qe,L,Pt="<li><code>prompt</code></li> <li><code>completion</code></li> <li><code>label</code></li>",He,D,Bt="for example:",ze,q,Pe,H,Wt=`where the <code>prompt</code> contains the context inputs, <code>completion</code> contains the corresponding responses and <code>label</code> contains the corresponding flag that indicates if the generated completion is desired (<code>True</code>) or undesired (<code>False</code>).
A prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.`,Be,z,We,P,Qt="The KTO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Qe,B,Se,W,St="For a detailed example have a look at the <code>examples/scripts/kto.py</code> script. At a high level we need to initialize the <code>KTOTrainer</code> with a <code>model</code> we wish to train and a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response.",Re,Q,Rt="The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",Ze,S,Zt=`The <code>desirable_weight</code> and <code>undesirable_weight</code> refer to the weights placed on the losses for desirable/positive and undesirable/negative examples.
By default, they are both 1. However, if you have more of one or the other, then you should upweight the less common type such that the ratio of (<code>desirable_weight</code> <em>number of positives) to (<code>undesirable_weight</code></em> number of negatives) is in the range 1:1 to 4:3.`,Xe,R,Ve,Z,Xt="After this one can then call:",Ge,X,Ye,V,et,d,G,pt,ce,Vt="Initialize KTOTrainer.",_t,$,Y,gt,pe,Gt="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",ht,y,ee,ut,_e,Yt=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,ft,ge,ea="Works both with or without labels.",vt,x,te,Tt,he,ta="Compute the log probabilities of the given labels under the given logits.",bt,J,ae,Mt,ue,aa="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",yt,O,ne,wt,fe,na="Generate samples from the model and reference model for the given batch of inputs.",Ut,w,oe,Ct,ve,oa="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",$t,Te,la="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",xt,U,le,Jt,be,ra="Returns the training <code>~torch.utils.data.DataLoader</code>.",Ot,Me,ia="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",jt,j,re,It,ye,sa="Compute the KTO loss for a batch of policy and reference model log probabilities.",kt,I,ie,Nt,we,da="Log <code>logs</code> on the various objects watching training, including stored metrics.",At,k,se,Kt,Ue,ma="Context manager for handling null reference model (that is, peft adapter manipulation).",tt,de,at,M,me,Ft,Ce,ca='KTOConfig collects all training arguments related to the <a href="/docs/trl/main/en/trainer#trl.KTOTrainer">KTOTrainer</a> class.',Et,$e,pa=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,nt,Ne,ot;return N=new Ie({props:{title:"KTO Trainer",local:"kto-trainer",headingTag:"h1"}}),F=new Ie({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),q=new Lt({props:{code:"a3RvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhleSUyQyUyMGhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaSUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`kto_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;Hey, hello&quot;</span>,
        <span class="hljs-string">&quot;How are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;completion&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I don&#x27;t have a name&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;label&quot;</span>: [
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
    ],
}`,wrap:!1}}),z=new Ie({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),B=new Ie({props:{title:"Using the KTOTrainer",local:"using-the-ktotrainer",headingTag:"h2"}}),R=new Lt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEtUT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSUyMCUyMCUyMCUyMHVuZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSklMEElMEFrdG9fdHJhaW5lciUyMCUzRCUyMEtUT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9yZWYlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`training_args = KTOConfig(
    beta=<span class="hljs-number">0.1</span>,
    desirable_weight=<span class="hljs-number">1.0</span>,
    undesirable_weight=<span class="hljs-number">1.0</span>,
)

kto_trainer = KTOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),X=new Lt({props:{code:"a3RvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"kto_trainer.train()",wrap:!1}}),V=new Ie({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),G=new b({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.KTOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.KTOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L224"}}),Y=new b({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L794"}}),ee=new b({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1217"}}),te=new b({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L866",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ae=new b({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1022"}}),ne=new b({props:{name:"get_batch_samples",anchor:"trl.KTOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1131"}}),oe=new b({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L741"}}),le=new b({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L700"}}),re=new b({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L969",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),ie=new b({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1273"}}),se=new b({props:{name:"null_ref_context",anchor:"trl.KTOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L688"}}),de=new Ie({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),me=new b({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"desirable_weight",val:": Optional = 1.0"},{name:"undesirable_weight",val:": Optional = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in KTO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.
dataset_num_proc &#x2014; (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>):
Number of processes to use for processing the datasets.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_config.py#L20"}}),{c(){C=r("meta"),Ae=o(),ke=r("p"),Ke=o(),p(N.$$.fragment),Fe=o(),A=r("p"),A.innerHTML=qt,Ee=o(),K=r("p"),K.textContent=Ht,Le=o(),p(F.$$.fragment),De=o(),E=r("p"),E.textContent=zt,qe=o(),L=r("ul"),L.innerHTML=Pt,He=o(),D=r("p"),D.textContent=Bt,ze=o(),p(q.$$.fragment),Pe=o(),H=r("p"),H.innerHTML=Wt,Be=o(),p(z.$$.fragment),We=o(),P=r("p"),P.innerHTML=Qt,Qe=o(),p(B.$$.fragment),Se=o(),W=r("p"),W.innerHTML=St,Re=o(),Q=r("p"),Q.innerHTML=Rt,Ze=o(),S=r("p"),S.innerHTML=Zt,Xe=o(),p(R.$$.fragment),Ve=o(),Z=r("p"),Z.textContent=Xt,Ge=o(),p(X.$$.fragment),Ye=o(),p(V.$$.fragment),et=o(),d=r("div"),p(G.$$.fragment),pt=o(),ce=r("p"),ce.textContent=Vt,_t=o(),$=r("div"),p(Y.$$.fragment),gt=o(),pe=r("p"),pe.textContent=Gt,ht=o(),y=r("div"),p(ee.$$.fragment),ut=o(),_e=r("p"),_e.innerHTML=Yt,ft=o(),ge=r("p"),ge.textContent=ea,vt=o(),x=r("div"),p(te.$$.fragment),Tt=o(),he=r("p"),he.textContent=ta,bt=o(),J=r("div"),p(ae.$$.fragment),Mt=o(),ue=r("p"),ue.textContent=aa,yt=o(),O=r("div"),p(ne.$$.fragment),wt=o(),fe=r("p"),fe.textContent=na,Ut=o(),w=r("div"),p(oe.$$.fragment),Ct=o(),ve=r("p"),ve.innerHTML=oa,$t=o(),Te=r("p"),Te.innerHTML=la,xt=o(),U=r("div"),p(le.$$.fragment),Jt=o(),be=r("p"),be.innerHTML=ra,Ot=o(),Me=r("p"),Me.innerHTML=ia,jt=o(),j=r("div"),p(re.$$.fragment),It=o(),ye=r("p"),ye.textContent=sa,kt=o(),I=r("div"),p(ie.$$.fragment),Nt=o(),we=r("p"),we.innerHTML=da,At=o(),k=r("div"),p(se.$$.fragment),Kt=o(),Ue=r("p"),Ue.textContent=ma,tt=o(),p(de.$$.fragment),at=o(),M=r("div"),p(me.$$.fragment),Ft=o(),Ce=r("p"),Ce.innerHTML=ca,Et=o(),$e=r("p"),$e.innerHTML=pa,nt=o(),Ne=r("p"),this.h()},l(e){const n=va("svelte-u9bgzb",document.head);C=i(n,"META",{name:!0,content:!0}),n.forEach(t),Ae=l(e),ke=i(e,"P",{}),v(ke).forEach(t),Ke=l(e),_(N.$$.fragment,e),Fe=l(e),A=i(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-171dbf3"&&(A.innerHTML=qt),Ee=l(e),K=i(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-z1e9ri"&&(K.textContent=Ht),Le=l(e),_(F.$$.fragment,e),De=l(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1792bye"&&(E.textContent=zt),qe=l(e),L=i(e,"UL",{"data-svelte-h":!0}),m(L)!=="svelte-1bk1n3o"&&(L.innerHTML=Pt),He=l(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1gl9mvz"&&(D.textContent=Bt),ze=l(e),_(q.$$.fragment,e),Pe=l(e),H=i(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-109yt43"&&(H.innerHTML=Wt),Be=l(e),_(z.$$.fragment,e),We=l(e),P=i(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-znx0uh"&&(P.innerHTML=Qt),Qe=l(e),_(B.$$.fragment,e),Se=l(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-6k9bp8"&&(W.innerHTML=St),Re=l(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1eil2tw"&&(Q.innerHTML=Rt),Ze=l(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-ad0vsu"&&(S.innerHTML=Zt),Xe=l(e),_(R.$$.fragment,e),Ve=l(e),Z=i(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1lg6q1l"&&(Z.textContent=Xt),Ge=l(e),_(X.$$.fragment,e),Ye=l(e),_(V.$$.fragment,e),et=l(e),d=i(e,"DIV",{class:!0});var c=v(d);_(G.$$.fragment,c),pt=l(c),ce=i(c,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-hyhzxp"&&(ce.textContent=Vt),_t=l(c),$=i(c,"DIV",{class:!0});var lt=v($);_(Y.$$.fragment,lt),gt=l(lt),pe=i(lt,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-pt6g01"&&(pe.textContent=Gt),lt.forEach(t),ht=l(c),y=i(c,"DIV",{class:!0});var xe=v(y);_(ee.$$.fragment,xe),ut=l(xe),_e=i(xe,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-8qlty5"&&(_e.innerHTML=Yt),ft=l(xe),ge=i(xe,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-1tyo99t"&&(ge.textContent=ea),xe.forEach(t),vt=l(c),x=i(c,"DIV",{class:!0});var rt=v(x);_(te.$$.fragment,rt),Tt=l(rt),he=i(rt,"P",{"data-svelte-h":!0}),m(he)!=="svelte-4nmimv"&&(he.textContent=ta),rt.forEach(t),bt=l(c),J=i(c,"DIV",{class:!0});var it=v(J);_(ae.$$.fragment,it),Mt=l(it),ue=i(it,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-db7iek"&&(ue.textContent=aa),it.forEach(t),yt=l(c),O=i(c,"DIV",{class:!0});var st=v(O);_(ne.$$.fragment,st),wt=l(st),fe=i(st,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-18uwvbi"&&(fe.textContent=na),st.forEach(t),Ut=l(c),w=i(c,"DIV",{class:!0});var Je=v(w);_(oe.$$.fragment,Je),Ct=l(Je),ve=i(Je,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-xesobz"&&(ve.innerHTML=oa),$t=l(Je),Te=i(Je,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-qg43tm"&&(Te.innerHTML=la),Je.forEach(t),xt=l(c),U=i(c,"DIV",{class:!0});var Oe=v(U);_(le.$$.fragment,Oe),Jt=l(Oe),be=i(Oe,"P",{"data-svelte-h":!0}),m(be)!=="svelte-dkae9b"&&(be.innerHTML=ra),Ot=l(Oe),Me=i(Oe,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-hmd5cw"&&(Me.innerHTML=ia),Oe.forEach(t),jt=l(c),j=i(c,"DIV",{class:!0});var dt=v(j);_(re.$$.fragment,dt),It=l(dt),ye=i(dt,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-svckwe"&&(ye.textContent=sa),dt.forEach(t),kt=l(c),I=i(c,"DIV",{class:!0});var mt=v(I);_(ie.$$.fragment,mt),Nt=l(mt),we=i(mt,"P",{"data-svelte-h":!0}),m(we)!=="svelte-nqksfz"&&(we.innerHTML=da),mt.forEach(t),At=l(c),k=i(c,"DIV",{class:!0});var ct=v(k);_(se.$$.fragment,ct),Kt=l(ct),Ue=i(ct,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-17kjsy4"&&(Ue.textContent=ma),ct.forEach(t),c.forEach(t),tt=l(e),_(de.$$.fragment,e),at=l(e),M=i(e,"DIV",{class:!0});var je=v(M);_(me.$$.fragment,je),Ft=l(je),Ce=i(je,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1anbnaa"&&(Ce.innerHTML=ca),Et=l(je),$e=i(je,"P",{"data-svelte-h":!0}),m($e)!=="svelte-1xl7jqc"&&($e.innerHTML=pa),je.forEach(t),nt=l(e),Ne=i(e,"P",{}),v(Ne).forEach(t),this.h()},h(){T(C,"name","hf:doc:metadata"),T(C,"content",ba),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){a(document.head,C),s(e,Ae,n),s(e,ke,n),s(e,Ke,n),g(N,e,n),s(e,Fe,n),s(e,A,n),s(e,Ee,n),s(e,K,n),s(e,Le,n),g(F,e,n),s(e,De,n),s(e,E,n),s(e,qe,n),s(e,L,n),s(e,He,n),s(e,D,n),s(e,ze,n),g(q,e,n),s(e,Pe,n),s(e,H,n),s(e,Be,n),g(z,e,n),s(e,We,n),s(e,P,n),s(e,Qe,n),g(B,e,n),s(e,Se,n),s(e,W,n),s(e,Re,n),s(e,Q,n),s(e,Ze,n),s(e,S,n),s(e,Xe,n),g(R,e,n),s(e,Ve,n),s(e,Z,n),s(e,Ge,n),g(X,e,n),s(e,Ye,n),g(V,e,n),s(e,et,n),s(e,d,n),g(G,d,null),a(d,pt),a(d,ce),a(d,_t),a(d,$),g(Y,$,null),a($,gt),a($,pe),a(d,ht),a(d,y),g(ee,y,null),a(y,ut),a(y,_e),a(y,ft),a(y,ge),a(d,vt),a(d,x),g(te,x,null),a(x,Tt),a(x,he),a(d,bt),a(d,J),g(ae,J,null),a(J,Mt),a(J,ue),a(d,yt),a(d,O),g(ne,O,null),a(O,wt),a(O,fe),a(d,Ut),a(d,w),g(oe,w,null),a(w,Ct),a(w,ve),a(w,$t),a(w,Te),a(d,xt),a(d,U),g(le,U,null),a(U,Jt),a(U,be),a(U,Ot),a(U,Me),a(d,jt),a(d,j),g(re,j,null),a(j,It),a(j,ye),a(d,kt),a(d,I),g(ie,I,null),a(I,Nt),a(I,we),a(d,At),a(d,k),g(se,k,null),a(k,Kt),a(k,Ue),s(e,tt,n),g(de,e,n),s(e,at,n),s(e,M,n),g(me,M,null),a(M,Ft),a(M,Ce),a(M,Et),a(M,$e),s(e,nt,n),s(e,Ne,n),ot=!0},p:ga,i(e){ot||(h(N.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(z.$$.fragment,e),h(B.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(V.$$.fragment,e),h(G.$$.fragment,e),h(Y.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),ot=!0)},o(e){u(N.$$.fragment,e),u(F.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(B.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(V.$$.fragment,e),u(G.$$.fragment,e),u(Y.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),ot=!1},d(e){e&&(t(Ae),t(ke),t(Ke),t(Fe),t(A),t(Ee),t(K),t(Le),t(De),t(E),t(qe),t(L),t(He),t(D),t(ze),t(Pe),t(H),t(Be),t(We),t(P),t(Qe),t(Se),t(W),t(Re),t(Q),t(Ze),t(S),t(Xe),t(Ve),t(Z),t(Ge),t(Ye),t(et),t(d),t(tt),t(at),t(M),t(nt),t(Ne)),t(C),f(N,e),f(F,e),f(q,e),f(z,e),f(B,e),f(R,e),f(X,e),f(V,e),f(G),f(Y),f(ee),f(te),f(ae),f(ne),f(oe),f(le),f(re),f(ie),f(se),f(de,e),f(me)}}}const ba='{"title":"KTO Trainer","local":"kto-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the KTOTrainer","local":"using-the-ktotrainer","sections":[],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2}],"depth":1}';function Ma(Dt){return ha(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xa extends ua{constructor(C){super(),fa(this,C,Ma,Ta,_a,{})}}export{xa as component};
