import{s as ue,n as we,o as ye}from"../chunks/scheduler.85c25b89.js";import{S as je,i as fe,g as a,s as i,u as c,A as Je,h as n,f as e,c as o,j as m,v as M,y as h,k as p,o as r,a as l,w as d,d as g,t as u,x as w}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(Yt){let y,mt,st,ht,j,v,lt,k,Qt,D,Ht="MixNet",ct,I,zt='<strong>MixNet</strong> is a type of convolutional neural network discovered via AutoML that utilises <a href="https://paperswithcode.com/method/mixconv" rel="nofollow">MixConvs</a> instead of regular <a href="https://paperswithcode.com/method/depthwise-convolution" rel="nofollow">depthwise convolutions</a>.',Mt,f,U,at,Z,Vt,q,Ft="How do I use this model on an image?",dt,N,Pt="To load a pretrained model:",gt,_,ut,W,Lt="To load and preprocess the image:",wt,E,yt,G,Dt="To get the model predictions:",jt,B,ft,A,qt="To get the top-5 predictions class names:",Jt,Q,Tt,V,Kt="Replace the model name with the variant you want to use, e.g. <code>mixnet_l</code>. You can find the IDs in the model summaries at the top of this page.",bt,S,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,J,x,nt,R,St,K,te="How do I finetune this model?",Ut,X,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",xt,Y,Ct,H,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,$t,T,C,it,z,Rt,O,le="How do I train this model?",kt,F,ae='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',It,b,$,ot,P,Xt,tt,ne="Citation",Zt,L,Nt,pt,_t;return k=new rt({}),Z=new rt({}),_=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21peG5ldF9sJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),E=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),B=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Q=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),R=new rt({}),Y=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbWl4bmV0X2wnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3QnRhbjIwMTltaXhjb252JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JNaXhDb252JTNBJTIwTWl4ZWQlMjBEZXB0aHdpc2UlMjBDb252b2x1dGlvbmFsJTIwS2VybmVscyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qk1pbmd4aW5nJTIwVGFuJTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MDcuMDk1OTUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2019mixconv,
      title={MixConv: Mixed Depthwise Convolutional Kernels}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1907.09595}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`}}),{c(){y=a("meta"),mt=i(),st=a("p"),ht=i(),j=a("h1"),v=a("a"),lt=a("span"),c(k.$$.fragment),Qt=i(),D=a("span"),D.textContent=Ht,ct=i(),I=a("p"),I.innerHTML=zt,Mt=i(),f=a("h2"),U=a("a"),at=a("span"),c(Z.$$.fragment),Vt=i(),q=a("span"),q.textContent=Ft,dt=i(),N=a("p"),N.textContent=Pt,gt=i(),c(_.$$.fragment),ut=i(),W=a("p"),W.textContent=Lt,wt=i(),c(E.$$.fragment),yt=i(),G=a("p"),G.textContent=Dt,jt=i(),c(B.$$.fragment),ft=i(),A=a("p"),A.textContent=qt,Jt=i(),c(Q.$$.fragment),Tt=i(),V=a("p"),V.innerHTML=Kt,bt=i(),S=a("p"),S.innerHTML=Ot,vt=i(),J=a("h2"),x=a("a"),nt=a("span"),c(R.$$.fragment),St=i(),K=a("span"),K.textContent=te,Ut=i(),X=a("p"),X.textContent=ee,xt=i(),c(Y.$$.fragment),Ct=i(),H=a("p"),H.innerHTML=se,$t=i(),T=a("h2"),C=a("a"),it=a("span"),c(z.$$.fragment),Rt=i(),O=a("span"),O.textContent=le,kt=i(),F=a("p"),F.innerHTML=ae,It=i(),b=a("h2"),$=a("a"),ot=a("span"),c(P.$$.fragment),Xt=i(),tt=a("span"),tt.textContent=ne,Zt=i(),c(L.$$.fragment),Nt=i(),pt=a("p"),this.h()},l(t){const s=Je("svelte-1phssyn",document.head);y=n(s,"META",{name:!0,content:!0}),s.forEach(e),mt=o(t),st=n(t,"P",{}),m(st).forEach(e),ht=o(t),j=n(t,"H1",{class:!0});var Wt=m(j);v=n(Wt,"A",{id:!0,class:!0,href:!0});var ie=m(v);lt=n(ie,"SPAN",{});var oe=m(lt);M(k.$$.fragment,oe),oe.forEach(e),ie.forEach(e),Qt=o(Wt),D=n(Wt,"SPAN",{"data-svelte-h":!0}),h(D)!=="svelte-1vzvdoa"&&(D.textContent=Ht),Wt.forEach(e),ct=o(t),I=n(t,"P",{"data-svelte-h":!0}),h(I)!=="svelte-ipcg9j"&&(I.innerHTML=zt),Mt=o(t),f=n(t,"H2",{class:!0});var Et=m(f);U=n(Et,"A",{id:!0,class:!0,href:!0});var pe=m(U);at=n(pe,"SPAN",{});var re=m(at);M(Z.$$.fragment,re),re.forEach(e),pe.forEach(e),Vt=o(Et),q=n(Et,"SPAN",{"data-svelte-h":!0}),h(q)!=="svelte-1c1hspn"&&(q.textContent=Ft),Et.forEach(e),dt=o(t),N=n(t,"P",{"data-svelte-h":!0}),h(N)!=="svelte-18ywhxh"&&(N.textContent=Pt),gt=o(t),M(_.$$.fragment,t),ut=o(t),W=n(t,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1c2ipa8"&&(W.textContent=Lt),wt=o(t),M(E.$$.fragment,t),yt=o(t),G=n(t,"P",{"data-svelte-h":!0}),h(G)!=="svelte-1n9qsq1"&&(G.textContent=Dt),jt=o(t),M(B.$$.fragment,t),ft=o(t),A=n(t,"P",{"data-svelte-h":!0}),h(A)!=="svelte-19cnvx1"&&(A.textContent=qt),Jt=o(t),M(Q.$$.fragment,t),Tt=o(t),V=n(t,"P",{"data-svelte-h":!0}),h(V)!=="svelte-o2qdri"&&(V.innerHTML=Kt),bt=o(t),S=n(t,"P",{"data-svelte-h":!0}),h(S)!=="svelte-1wmi3ea"&&(S.innerHTML=Ot),vt=o(t),J=n(t,"H2",{class:!0});var Gt=m(J);x=n(Gt,"A",{id:!0,class:!0,href:!0});var me=m(x);nt=n(me,"SPAN",{});var he=m(nt);M(R.$$.fragment,he),he.forEach(e),me.forEach(e),St=o(Gt),K=n(Gt,"SPAN",{"data-svelte-h":!0}),h(K)!=="svelte-1viv4qv"&&(K.textContent=te),Gt.forEach(e),Ut=o(t),X=n(t,"P",{"data-svelte-h":!0}),h(X)!=="svelte-9sr7nh"&&(X.textContent=ee),xt=o(t),M(Y.$$.fragment,t),Ct=o(t),H=n(t,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1kguc51"&&(H.innerHTML=se),$t=o(t),T=n(t,"H2",{class:!0});var Bt=m(T);C=n(Bt,"A",{id:!0,class:!0,href:!0});var ce=m(C);it=n(ce,"SPAN",{});var Me=m(it);M(z.$$.fragment,Me),Me.forEach(e),ce.forEach(e),Rt=o(Bt),O=n(Bt,"SPAN",{"data-svelte-h":!0}),h(O)!=="svelte-1ce591d"&&(O.textContent=le),Bt.forEach(e),kt=o(t),F=n(t,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1n0coha"&&(F.innerHTML=ae),It=o(t),b=n(t,"H2",{class:!0});var At=m(b);$=n(At,"A",{id:!0,class:!0,href:!0});var de=m($);ot=n(de,"SPAN",{});var ge=m(ot);M(P.$$.fragment,ge),ge.forEach(e),de.forEach(e),Xt=o(At),tt=n(At,"SPAN",{"data-svelte-h":!0}),h(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),At.forEach(e),Zt=o(t),M(L.$$.fragment,t),Nt=o(t),pt=n(t,"P",{}),m(pt).forEach(e),this.h()},h(){p(y,"name","hf:doc:metadata"),p(y,"content",JSON.stringify(be)),p(v,"id","mixnet"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#mixnet"),p(j,"class","relative group"),p(U,"id","how-do-i-use-this-model-on-an-image"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#how-do-i-use-this-model-on-an-image"),p(f,"class","relative group"),p(x,"id","how-do-i-finetune-this-model"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#how-do-i-finetune-this-model"),p(J,"class","relative group"),p(C,"id","how-do-i-train-this-model"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#how-do-i-train-this-model"),p(T,"class","relative group"),p($,"id","citation"),p($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($,"href","#citation"),p(b,"class","relative group")},m(t,s){r(document.head,y),l(t,mt,s),l(t,st,s),l(t,ht,s),l(t,j,s),r(j,v),r(v,lt),d(k,lt,null),r(j,Qt),r(j,D),l(t,ct,s),l(t,I,s),l(t,Mt,s),l(t,f,s),r(f,U),r(U,at),d(Z,at,null),r(f,Vt),r(f,q),l(t,dt,s),l(t,N,s),l(t,gt,s),d(_,t,s),l(t,ut,s),l(t,W,s),l(t,wt,s),d(E,t,s),l(t,yt,s),l(t,G,s),l(t,jt,s),d(B,t,s),l(t,ft,s),l(t,A,s),l(t,Jt,s),d(Q,t,s),l(t,Tt,s),l(t,V,s),l(t,bt,s),l(t,S,s),l(t,vt,s),l(t,J,s),r(J,x),r(x,nt),d(R,nt,null),r(J,St),r(J,K),l(t,Ut,s),l(t,X,s),l(t,xt,s),d(Y,t,s),l(t,Ct,s),l(t,H,s),l(t,$t,s),l(t,T,s),r(T,C),r(C,it),d(z,it,null),r(T,Rt),r(T,O),l(t,kt,s),l(t,F,s),l(t,It,s),l(t,b,s),r(b,$),r($,ot),d(P,ot,null),r(b,Xt),r(b,tt),l(t,Zt,s),d(L,t,s),l(t,Nt,s),l(t,pt,s),_t=!0},p:we,i(t){_t||(g(k.$$.fragment,t),g(Z.$$.fragment,t),g(_.$$.fragment,t),g(E.$$.fragment,t),g(B.$$.fragment,t),g(Q.$$.fragment,t),g(R.$$.fragment,t),g(Y.$$.fragment,t),g(z.$$.fragment,t),g(P.$$.fragment,t),g(L.$$.fragment,t),_t=!0)},o(t){u(k.$$.fragment,t),u(Z.$$.fragment,t),u(_.$$.fragment,t),u(E.$$.fragment,t),u(B.$$.fragment,t),u(Q.$$.fragment,t),u(R.$$.fragment,t),u(Y.$$.fragment,t),u(z.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),_t=!1},d(t){t&&(e(mt),e(st),e(ht),e(j),e(ct),e(I),e(Mt),e(f),e(dt),e(N),e(gt),e(ut),e(W),e(wt),e(yt),e(G),e(jt),e(ft),e(A),e(Jt),e(Tt),e(V),e(bt),e(S),e(vt),e(J),e(Ut),e(X),e(xt),e(Ct),e(H),e($t),e(T),e(kt),e(F),e(It),e(b),e(Zt),e(Nt),e(pt)),e(y),w(k),w(Z),w(_,t),w(E,t),w(B,t),w(Q,t),w(R),w(Y,t),w(z),w(P),w(L,t)}}}const be={local:"mixnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"MixNet"};function ve(Yt){return ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ke extends je{constructor(y){super(),fe(this,y,ve,Te,ue,{})}}export{ke as component};
