import{s as js,n as gs,o as ys}from"../chunks/scheduler.85c25b89.js";import{S as ws,i as Js,g as a,s as o,u as c,A as fs,h as n,f as s,c as p,j as h,v as M,y as m,k as i,o as r,a as l,w as d,d as u,t as j,x as g}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as st}from"../chunks/CodeBlock.00597c71.js";function bs(Rt){let y,ht,et,mt,w,v,lt,N,St,q,Ht="PNASNet",ct,Z,Ft="<strong>Progressive Neural Architecture Search</strong>, or <strong>PNAS</strong>, is a method for learning the structure of convolutional neural networks (CNNs). It uses a sequential model-based optimization (SMBO) strategy, where we search the space of cell structures, starting with simple (shallow) models and progressing to complex ones, pruning out unpromising structures as we go.",Mt,J,U,at,$,Qt,D,zt="How do I use this model on an image?",dt,B,Pt="To load a pretrained model:",ut,I,jt,W,Lt="To load and preprocess the image:",gt,E,yt,A,qt="To get the model predictions:",wt,_,Jt,G,Dt="To get the top-5 predictions class names:",ft,S,bt,Q,Kt="Replace the model name with the variant you want to use, e.g. <code>pnasnet5large</code>. You can find the IDs in the model summaries at the top of this page.",Tt,X,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,f,k,nt,V,Xt,K,ts="How do I finetune this model?",Ut,Y,ss="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",kt,R,Ct,H,es=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,xt,b,C,ot,F,Vt,O,ls="How do I train this model?",Nt,z,as='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Zt,T,x,pt,P,Yt,tt,ns="Citation",$t,L,Bt,it,It;return N=new rt({}),$=new rt({}),I=new st({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3BuYXNuZXQ1bGFyZ2UnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;pnasnet5large&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),E=new st({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),_=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),S=new st({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),V=new rt({}),R=new st({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncG5hc25ldDVsYXJnZSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;pnasnet5large&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),F=new rt({}),P=new rt({}),L=new st({props:{code:"JTQwbWlzYyU3QmxpdTIwMThwcm9ncmVzc2l2ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCUHJvZ3Jlc3NpdmUlMjBOZXVyYWwlMjBBcmNoaXRlY3R1cmUlMjBTZWFyY2glN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JDaGVueGklMjBMaXUlMjBhbmQlMjBCYXJyZXQlMjBab3BoJTIwYW5kJTIwTWF4aW0lMjBOZXVtYW5uJTIwYW5kJTIwSm9uYXRob24lMjBTaGxlbnMlMjBhbmQlMjBXZWklMjBIdWElMjBhbmQlMjBMaS1KaWElMjBMaSUyMGFuZCUyMExpJTIwRmVpLUZlaSUyMGFuZCUyMEFsYW4lMjBZdWlsbGUlMjBhbmQlMjBKb25hdGhhbiUyMEh1YW5nJTIwYW5kJTIwS2V2aW4lMjBNdXJwaHklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MTIuMDA1NTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{liu2018progressive,
      title={Progressive Neural Architecture Search}, 
      author={Chenxi Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Barret </span>Zoph <span class="hljs-keyword">and </span>Maxim Neumann <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathon </span><span class="hljs-keyword">Shlens </span><span class="hljs-keyword">and </span>Wei Hua <span class="hljs-keyword">and </span>Li-<span class="hljs-keyword">Jia </span>Li <span class="hljs-keyword">and </span>Li Fei-Fei <span class="hljs-keyword">and </span>Alan Yuille <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathan </span>Huang <span class="hljs-keyword">and </span>Kevin Murphy},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1712</span>.<span class="hljs-number">00559</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){y=a("meta"),ht=o(),et=a("p"),mt=o(),w=a("h1"),v=a("a"),lt=a("span"),c(N.$$.fragment),St=o(),q=a("span"),q.textContent=Ht,ct=o(),Z=a("p"),Z.innerHTML=Ft,Mt=o(),J=a("h2"),U=a("a"),at=a("span"),c($.$$.fragment),Qt=o(),D=a("span"),D.textContent=zt,dt=o(),B=a("p"),B.textContent=Pt,ut=o(),c(I.$$.fragment),jt=o(),W=a("p"),W.textContent=Lt,gt=o(),c(E.$$.fragment),yt=o(),A=a("p"),A.textContent=qt,wt=o(),c(_.$$.fragment),Jt=o(),G=a("p"),G.textContent=Dt,ft=o(),c(S.$$.fragment),bt=o(),Q=a("p"),Q.innerHTML=Kt,Tt=o(),X=a("p"),X.innerHTML=Ot,vt=o(),f=a("h2"),k=a("a"),nt=a("span"),c(V.$$.fragment),Xt=o(),K=a("span"),K.textContent=ts,Ut=o(),Y=a("p"),Y.textContent=ss,kt=o(),c(R.$$.fragment),Ct=o(),H=a("p"),H.innerHTML=es,xt=o(),b=a("h2"),C=a("a"),ot=a("span"),c(F.$$.fragment),Vt=o(),O=a("span"),O.textContent=ls,Nt=o(),z=a("p"),z.innerHTML=as,Zt=o(),T=a("h2"),x=a("a"),pt=a("span"),c(P.$$.fragment),Yt=o(),tt=a("span"),tt.textContent=ns,$t=o(),c(L.$$.fragment),Bt=o(),it=a("p"),this.h()},l(t){const e=fs("svelte-1phssyn",document.head);y=n(e,"META",{name:!0,content:!0}),e.forEach(s),ht=p(t),et=n(t,"P",{}),h(et).forEach(s),mt=p(t),w=n(t,"H1",{class:!0});var Wt=h(w);v=n(Wt,"A",{id:!0,class:!0,href:!0});var os=h(v);lt=n(os,"SPAN",{});var ps=h(lt);M(N.$$.fragment,ps),ps.forEach(s),os.forEach(s),St=p(Wt),q=n(Wt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-tewqxu"&&(q.textContent=Ht),Wt.forEach(s),ct=p(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1wxq1ps"&&(Z.innerHTML=Ft),Mt=p(t),J=n(t,"H2",{class:!0});var Et=h(J);U=n(Et,"A",{id:!0,class:!0,href:!0});var is=h(U);at=n(is,"SPAN",{});var rs=h(at);M($.$$.fragment,rs),rs.forEach(s),is.forEach(s),Qt=p(Et),D=n(Et,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-1c1hspn"&&(D.textContent=zt),Et.forEach(s),dt=p(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-18ywhxh"&&(B.textContent=Pt),ut=p(t),M(I.$$.fragment,t),jt=p(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1c2ipa8"&&(W.textContent=Lt),gt=p(t),M(E.$$.fragment,t),yt=p(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1n9qsq1"&&(A.textContent=qt),wt=p(t),M(_.$$.fragment,t),Jt=p(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-19cnvx1"&&(G.textContent=Dt),ft=p(t),M(S.$$.fragment,t),bt=p(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1ym24x9"&&(Q.innerHTML=Kt),Tt=p(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1wmi3ea"&&(X.innerHTML=Ot),vt=p(t),f=n(t,"H2",{class:!0});var At=h(f);k=n(At,"A",{id:!0,class:!0,href:!0});var hs=h(k);nt=n(hs,"SPAN",{});var ms=h(nt);M(V.$$.fragment,ms),ms.forEach(s),hs.forEach(s),Xt=p(At),K=n(At,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=ts),At.forEach(s),Ut=p(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=ss),kt=p(t),M(R.$$.fragment,t),Ct=p(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=es),xt=p(t),b=n(t,"H2",{class:!0});var _t=h(b);C=n(_t,"A",{id:!0,class:!0,href:!0});var cs=h(C);ot=n(cs,"SPAN",{});var Ms=h(ot);M(F.$$.fragment,Ms),Ms.forEach(s),cs.forEach(s),Vt=p(_t),O=n(_t,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ls),_t.forEach(s),Nt=p(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1n0coha"&&(z.innerHTML=as),Zt=p(t),T=n(t,"H2",{class:!0});var Gt=h(T);x=n(Gt,"A",{id:!0,class:!0,href:!0});var ds=h(x);pt=n(ds,"SPAN",{});var us=h(pt);M(P.$$.fragment,us),us.forEach(s),ds.forEach(s),Yt=p(Gt),tt=n(Gt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ns),Gt.forEach(s),$t=p(t),M(L.$$.fragment,t),Bt=p(t),it=n(t,"P",{}),h(it).forEach(s),this.h()},h(){i(y,"name","hf:doc:metadata"),i(y,"content",JSON.stringify(Ts)),i(v,"id","pnasnet"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#pnasnet"),i(w,"class","relative group"),i(U,"id","how-do-i-use-this-model-on-an-image"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#how-do-i-use-this-model-on-an-image"),i(J,"class","relative group"),i(k,"id","how-do-i-finetune-this-model"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#how-do-i-finetune-this-model"),i(f,"class","relative group"),i(C,"id","how-do-i-train-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-train-this-model"),i(b,"class","relative group"),i(x,"id","citation"),i(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(x,"href","#citation"),i(T,"class","relative group")},m(t,e){r(document.head,y),l(t,ht,e),l(t,et,e),l(t,mt,e),l(t,w,e),r(w,v),r(v,lt),d(N,lt,null),r(w,St),r(w,q),l(t,ct,e),l(t,Z,e),l(t,Mt,e),l(t,J,e),r(J,U),r(U,at),d($,at,null),r(J,Qt),r(J,D),l(t,dt,e),l(t,B,e),l(t,ut,e),d(I,t,e),l(t,jt,e),l(t,W,e),l(t,gt,e),d(E,t,e),l(t,yt,e),l(t,A,e),l(t,wt,e),d(_,t,e),l(t,Jt,e),l(t,G,e),l(t,ft,e),d(S,t,e),l(t,bt,e),l(t,Q,e),l(t,Tt,e),l(t,X,e),l(t,vt,e),l(t,f,e),r(f,k),r(k,nt),d(V,nt,null),r(f,Xt),r(f,K),l(t,Ut,e),l(t,Y,e),l(t,kt,e),d(R,t,e),l(t,Ct,e),l(t,H,e),l(t,xt,e),l(t,b,e),r(b,C),r(C,ot),d(F,ot,null),r(b,Vt),r(b,O),l(t,Nt,e),l(t,z,e),l(t,Zt,e),l(t,T,e),r(T,x),r(x,pt),d(P,pt,null),r(T,Yt),r(T,tt),l(t,$t,e),d(L,t,e),l(t,Bt,e),l(t,it,e),It=!0},p:gs,i(t){It||(u(N.$$.fragment,t),u($.$$.fragment,t),u(I.$$.fragment,t),u(E.$$.fragment,t),u(_.$$.fragment,t),u(S.$$.fragment,t),u(V.$$.fragment,t),u(R.$$.fragment,t),u(F.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),It=!0)},o(t){j(N.$$.fragment,t),j($.$$.fragment,t),j(I.$$.fragment,t),j(E.$$.fragment,t),j(_.$$.fragment,t),j(S.$$.fragment,t),j(V.$$.fragment,t),j(R.$$.fragment,t),j(F.$$.fragment,t),j(P.$$.fragment,t),j(L.$$.fragment,t),It=!1},d(t){t&&(s(ht),s(et),s(mt),s(w),s(ct),s(Z),s(Mt),s(J),s(dt),s(B),s(ut),s(jt),s(W),s(gt),s(yt),s(A),s(wt),s(Jt),s(G),s(ft),s(bt),s(Q),s(Tt),s(X),s(vt),s(f),s(Ut),s(Y),s(kt),s(Ct),s(H),s(xt),s(b),s(Nt),s(z),s(Zt),s(T),s($t),s(Bt),s(it)),s(y),g(N),g($),g(I,t),g(E,t),g(_,t),g(S,t),g(V),g(R,t),g(F),g(P),g(L,t)}}}const Ts={local:"pnasnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"PNASNet"};function vs(Rt){return ys(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ns extends ws{constructor(y){super(),Js(this,y,vs,bs,js,{})}}export{Ns as component};
