import{s as ye,n as je,o as Je}from"../chunks/scheduler.85c25b89.js";import{S as Te,i as be,g as a,s as o,u as c,A as ve,h as n,f as e,c as i,j as m,v as M,y as h,k as p,o as r,a as l,w as d,d as u,t as g,x as w}from"../chunks/index.9633332f.js";import{I as mt}from"../chunks/IconCopyLink.a4acffac.js";import{C as st}from"../chunks/CodeBlock.00597c71.js";function Ue(zt){let f,ht,lt,ct,y,v,at,k,Rt,q,Ft="(Tensorflow) MixNet",Mt,I,Pt='<strong>MixNet</strong> is a type of convolutional neural network discovered via AutoML that utilises <a href="https://paperswithcode.com/method/mixconv" rel="nofollow">MixConvs</a> instead of regular <a href="https://paperswithcode.com/method/depthwise-convolution" rel="nofollow">depthwise convolutions</a>.',dt,_,Lt='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',ut,j,U,nt,Z,St,K,Dt="How do I use this model on an image?",gt,N,qt="To load a pretrained model:",wt,W,ft,E,Kt="To load and preprocess the image:",yt,G,jt,B,Ot="To get the model predictions:",Jt,A,Tt,Q,te="To get the top-5 predictions class names:",bt,V,vt,R,ee="Replace the model name with the variant you want to use, e.g. <code>tf_mixnet_l</code>. You can find the IDs in the model summaries at the top of this page.",Ut,S,se='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',xt,J,x,ot,X,Xt,O,le="How do I finetune this model?",Ct,Y,ae="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",$t,H,kt,z,ne=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,It,T,C,it,F,Yt,tt,oe="How do I train this model?",_t,P,ie='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Zt,b,$,pt,L,Ht,et,pe="Citation",Nt,D,Wt,rt,Et;return k=new mt({}),Z=new mt({}),W=new st({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX21peG5ldF9sJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),G=new st({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),A=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),V=new st({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),X=new mt({}),H=new st({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfbWl4bmV0X2wnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),F=new mt({}),L=new mt({}),D=new st({props:{code:"JTQwbWlzYyU3QnRhbjIwMTltaXhjb252JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JNaXhDb252JTNBJTIwTWl4ZWQlMjBEZXB0aHdpc2UlMjBDb252b2x1dGlvbmFsJTIwS2VybmVscyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qk1pbmd4aW5nJTIwVGFuJTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MDcuMDk1OTUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2019mixconv,
      title={MixConv: Mixed Depthwise Convolutional Kernels}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1907.09595}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`}}),{c(){f=a("meta"),ht=o(),lt=a("p"),ct=o(),y=a("h1"),v=a("a"),at=a("span"),c(k.$$.fragment),Rt=o(),q=a("span"),q.textContent=Ft,Mt=o(),I=a("p"),I.innerHTML=Pt,dt=o(),_=a("p"),_.innerHTML=Lt,ut=o(),j=a("h2"),U=a("a"),nt=a("span"),c(Z.$$.fragment),St=o(),K=a("span"),K.textContent=Dt,gt=o(),N=a("p"),N.textContent=qt,wt=o(),c(W.$$.fragment),ft=o(),E=a("p"),E.textContent=Kt,yt=o(),c(G.$$.fragment),jt=o(),B=a("p"),B.textContent=Ot,Jt=o(),c(A.$$.fragment),Tt=o(),Q=a("p"),Q.textContent=te,bt=o(),c(V.$$.fragment),vt=o(),R=a("p"),R.innerHTML=ee,Ut=o(),S=a("p"),S.innerHTML=se,xt=o(),J=a("h2"),x=a("a"),ot=a("span"),c(X.$$.fragment),Xt=o(),O=a("span"),O.textContent=le,Ct=o(),Y=a("p"),Y.textContent=ae,$t=o(),c(H.$$.fragment),kt=o(),z=a("p"),z.innerHTML=ne,It=o(),T=a("h2"),C=a("a"),it=a("span"),c(F.$$.fragment),Yt=o(),tt=a("span"),tt.textContent=oe,_t=o(),P=a("p"),P.innerHTML=ie,Zt=o(),b=a("h2"),$=a("a"),pt=a("span"),c(L.$$.fragment),Ht=o(),et=a("span"),et.textContent=pe,Nt=o(),c(D.$$.fragment),Wt=o(),rt=a("p"),this.h()},l(t){const s=ve("svelte-1phssyn",document.head);f=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=i(t),lt=n(t,"P",{}),m(lt).forEach(e),ct=i(t),y=n(t,"H1",{class:!0});var Gt=m(y);v=n(Gt,"A",{id:!0,class:!0,href:!0});var re=m(v);at=n(re,"SPAN",{});var me=m(at);M(k.$$.fragment,me),me.forEach(e),re.forEach(e),Rt=i(Gt),q=n(Gt,"SPAN",{"data-svelte-h":!0}),h(q)!=="svelte-c6h7eu"&&(q.textContent=Ft),Gt.forEach(e),Mt=i(t),I=n(t,"P",{"data-svelte-h":!0}),h(I)!=="svelte-ipcg9j"&&(I.innerHTML=Pt),dt=i(t),_=n(t,"P",{"data-svelte-h":!0}),h(_)!=="svelte-k8hpf1"&&(_.innerHTML=Lt),ut=i(t),j=n(t,"H2",{class:!0});var Bt=m(j);U=n(Bt,"A",{id:!0,class:!0,href:!0});var he=m(U);nt=n(he,"SPAN",{});var ce=m(nt);M(Z.$$.fragment,ce),ce.forEach(e),he.forEach(e),St=i(Bt),K=n(Bt,"SPAN",{"data-svelte-h":!0}),h(K)!=="svelte-1c1hspn"&&(K.textContent=Dt),Bt.forEach(e),gt=i(t),N=n(t,"P",{"data-svelte-h":!0}),h(N)!=="svelte-18ywhxh"&&(N.textContent=qt),wt=i(t),M(W.$$.fragment,t),ft=i(t),E=n(t,"P",{"data-svelte-h":!0}),h(E)!=="svelte-1c2ipa8"&&(E.textContent=Kt),yt=i(t),M(G.$$.fragment,t),jt=i(t),B=n(t,"P",{"data-svelte-h":!0}),h(B)!=="svelte-1n9qsq1"&&(B.textContent=Ot),Jt=i(t),M(A.$$.fragment,t),Tt=i(t),Q=n(t,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-19cnvx1"&&(Q.textContent=te),bt=i(t),M(V.$$.fragment,t),vt=i(t),R=n(t,"P",{"data-svelte-h":!0}),h(R)!=="svelte-148p09n"&&(R.innerHTML=ee),Ut=i(t),S=n(t,"P",{"data-svelte-h":!0}),h(S)!=="svelte-1wmi3ea"&&(S.innerHTML=se),xt=i(t),J=n(t,"H2",{class:!0});var At=m(J);x=n(At,"A",{id:!0,class:!0,href:!0});var Me=m(x);ot=n(Me,"SPAN",{});var de=m(ot);M(X.$$.fragment,de),de.forEach(e),Me.forEach(e),Xt=i(At),O=n(At,"SPAN",{"data-svelte-h":!0}),h(O)!=="svelte-1viv4qv"&&(O.textContent=le),At.forEach(e),Ct=i(t),Y=n(t,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-9sr7nh"&&(Y.textContent=ae),$t=i(t),M(H.$$.fragment,t),kt=i(t),z=n(t,"P",{"data-svelte-h":!0}),h(z)!=="svelte-1kguc51"&&(z.innerHTML=ne),It=i(t),T=n(t,"H2",{class:!0});var Qt=m(T);C=n(Qt,"A",{id:!0,class:!0,href:!0});var ue=m(C);it=n(ue,"SPAN",{});var ge=m(it);M(F.$$.fragment,ge),ge.forEach(e),ue.forEach(e),Yt=i(Qt),tt=n(Qt,"SPAN",{"data-svelte-h":!0}),h(tt)!=="svelte-1ce591d"&&(tt.textContent=oe),Qt.forEach(e),_t=i(t),P=n(t,"P",{"data-svelte-h":!0}),h(P)!=="svelte-1n0coha"&&(P.innerHTML=ie),Zt=i(t),b=n(t,"H2",{class:!0});var Vt=m(b);$=n(Vt,"A",{id:!0,class:!0,href:!0});var we=m($);pt=n(we,"SPAN",{});var fe=m(pt);M(L.$$.fragment,fe),fe.forEach(e),we.forEach(e),Ht=i(Vt),et=n(Vt,"SPAN",{"data-svelte-h":!0}),h(et)!=="svelte-15mb3gy"&&(et.textContent=pe),Vt.forEach(e),Nt=i(t),M(D.$$.fragment,t),Wt=i(t),rt=n(t,"P",{}),m(rt).forEach(e),this.h()},h(){p(f,"name","hf:doc:metadata"),p(f,"content",JSON.stringify(xe)),p(v,"id","tensorflow-mixnet"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#tensorflow-mixnet"),p(y,"class","relative group"),p(U,"id","how-do-i-use-this-model-on-an-image"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#how-do-i-use-this-model-on-an-image"),p(j,"class","relative group"),p(x,"id","how-do-i-finetune-this-model"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#how-do-i-finetune-this-model"),p(J,"class","relative group"),p(C,"id","how-do-i-train-this-model"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#how-do-i-train-this-model"),p(T,"class","relative group"),p($,"id","citation"),p($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($,"href","#citation"),p(b,"class","relative group")},m(t,s){r(document.head,f),l(t,ht,s),l(t,lt,s),l(t,ct,s),l(t,y,s),r(y,v),r(v,at),d(k,at,null),r(y,Rt),r(y,q),l(t,Mt,s),l(t,I,s),l(t,dt,s),l(t,_,s),l(t,ut,s),l(t,j,s),r(j,U),r(U,nt),d(Z,nt,null),r(j,St),r(j,K),l(t,gt,s),l(t,N,s),l(t,wt,s),d(W,t,s),l(t,ft,s),l(t,E,s),l(t,yt,s),d(G,t,s),l(t,jt,s),l(t,B,s),l(t,Jt,s),d(A,t,s),l(t,Tt,s),l(t,Q,s),l(t,bt,s),d(V,t,s),l(t,vt,s),l(t,R,s),l(t,Ut,s),l(t,S,s),l(t,xt,s),l(t,J,s),r(J,x),r(x,ot),d(X,ot,null),r(J,Xt),r(J,O),l(t,Ct,s),l(t,Y,s),l(t,$t,s),d(H,t,s),l(t,kt,s),l(t,z,s),l(t,It,s),l(t,T,s),r(T,C),r(C,it),d(F,it,null),r(T,Yt),r(T,tt),l(t,_t,s),l(t,P,s),l(t,Zt,s),l(t,b,s),r(b,$),r($,pt),d(L,pt,null),r(b,Ht),r(b,et),l(t,Nt,s),d(D,t,s),l(t,Wt,s),l(t,rt,s),Et=!0},p:je,i(t){Et||(u(k.$$.fragment,t),u(Z.$$.fragment,t),u(W.$$.fragment,t),u(G.$$.fragment,t),u(A.$$.fragment,t),u(V.$$.fragment,t),u(X.$$.fragment,t),u(H.$$.fragment,t),u(F.$$.fragment,t),u(L.$$.fragment,t),u(D.$$.fragment,t),Et=!0)},o(t){g(k.$$.fragment,t),g(Z.$$.fragment,t),g(W.$$.fragment,t),g(G.$$.fragment,t),g(A.$$.fragment,t),g(V.$$.fragment,t),g(X.$$.fragment,t),g(H.$$.fragment,t),g(F.$$.fragment,t),g(L.$$.fragment,t),g(D.$$.fragment,t),Et=!1},d(t){t&&(e(ht),e(lt),e(ct),e(y),e(Mt),e(I),e(dt),e(_),e(ut),e(j),e(gt),e(N),e(wt),e(ft),e(E),e(yt),e(jt),e(B),e(Jt),e(Tt),e(Q),e(bt),e(vt),e(R),e(Ut),e(S),e(xt),e(J),e(Ct),e(Y),e($t),e(kt),e(z),e(It),e(T),e(_t),e(P),e(Zt),e(b),e(Nt),e(Wt),e(rt)),e(f),w(k),w(Z),w(W,t),w(G,t),w(A,t),w(V,t),w(X),w(H,t),w(F),w(L),w(D,t)}}}const xe={local:"tensorflow-mixnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"(Tensorflow) MixNet"};function Ce(zt){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends Te{constructor(f){super(),be(this,f,Ce,Ue,ye,{})}}export{Ze as component};
