import{s as pn,n as Mn,o as on}from"../chunks/scheduler.0219f8bd.js";import{S as rn,i as cn,g as h,s as a,r as i,A as hn,h as j,f as l,c as n,j as an,u as p,x as m,k as nn,y as jn,a as e,v as M,d as o,t as r,w as c}from"../chunks/index.f61edf3b.js";import{C as u}from"../chunks/CodeBlock.38e566ae.js";import{H as J,E as mn}from"../chunks/EditOnGithub.48fa589f.js";function Jn(oa){let y,Yt,Xt,St,g,Vt,f,ra=`A Typescript powered wrapper for the Hugging Face Inference Endpoints API. Learn more about Inference Endpoints at <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Hugging Face</a>.
It works with both <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API (serverless)</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints (dedicated)</a>.`,Rt,T,ca='You can also try out a live <a href="https://observablehq.com/@huggingface/hello-huggingface-js-inference" rel="nofollow">interactive notebook</a>, see some demos on <a href="https://huggingface.co/huggingfacejs" rel="nofollow">hf.co/huggingfacejs</a>, or watch a <a href="https://scrimba.com/scrim/cod8248f5adfd6e129582c523" rel="nofollow">Scrimba tutorial that explains how Inference Endpoints works</a>.',qt,w,zt,d,Ht,U,_t,$,Ft,I,Lt,b,Dt,C,Pt,x,Kt,B,ha='❗<strong>Important note:</strong> Using an access token is optional to get started, however you will be rate limited eventually. Join <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a> and then visit <a href="https://huggingface.co/settings/tokens" rel="nofollow">access tokens</a> to generate your access token for <strong>free</strong>.',Ot,Z,ja="Your access token should be kept private. If you need to protect it in front-end applications, we suggest setting up a proxy server that stores the access token.",sl,k,tl,Q,ma="You can import the functions you need directly from the module instead of using the <code>HfInference</code> class.",ll,G,el,N,Ja="This will enable tree-shaking by your bundler.",al,E,nl,v,il,W,ua="Tries to fill in a hole with a missing word (token to be precise).",pl,X,Ml,A,ol,Y,ya="Summarizes longer text into shorter text. Be careful, some models have a maximum length of input.",rl,S,cl,V,hl,R,ga="Answers questions based on the context you provide.",jl,q,ml,z,Jl,H,ul,_,yl,F,fa="Often used for sentiment analysis, this method will assign labels to the given text along with a probability score of that label.",gl,L,fl,D,Tl,P,Ta="Generates text from an input prompt.",wl,K,wa='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-text-generation" rel="nofollow">Demo</a>',dl,O,Ul,ss,$l,ts,da="Used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.",Il,ls,bl,es,Cl,as,Ua="Converts text from one language to another.",xl,ns,Bl,is,Zl,ps,$a="Checks how well an input text fits into a set of labels you provide.",kl,Ms,Ql,os,Gl,rs,Ia="This task corresponds to any chatbot-like structure. Models tend to have shorter max_length, so please check with caution when using a given model if you need long-range dependency or not.",Nl,cs,El,hs,vl,js,ba="Calculate the semantic similarity between one text and a list of other sentences.",Wl,ms,Xl,Js,Al,us,Yl,ys,Ca="Transcribes speech from an audio file.",Sl,gs,xa='<a href="https://huggingface.co/spaces/huggingfacejs/speech-recognition-vue" rel="nofollow">Demo</a>',Vl,fs,Rl,Ts,ql,ws,Ba="Assigns labels to the given audio along with a probability score of that label.",zl,ds,Za='<a href="https://huggingface.co/spaces/huggingfacejs/audio-classification-vue" rel="nofollow">Demo</a>',Hl,Us,_l,$s,Fl,Is,ka="Generates natural-sounding speech from text input.",Ll,bs,Qa='<a href="https://scrimba.com/scrim/co8da4d23b49b648f77f4848a?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',Dl,Cs,Pl,xs,Kl,Bs,Ga="Outputs one or multiple generated audios from an input audio, commonly used for speech enhancement and source separation.",Ol,Zs,se,ks,te,Qs,le,Gs,Na="Assigns labels to a given image along with a probability score of that label.",ee,Ns,Ea='<a href="https://huggingface.co/spaces/huggingfacejs/image-classification-vue" rel="nofollow">Demo</a>',ae,Es,ne,vs,ie,Ws,va="Detects objects within an image and returns labels with corresponding bounding boxes and probability scores.",pe,Xs,Wa='<a href="https://huggingface.co/spaces/huggingfacejs/object-detection-vue" rel="nofollow">Demo</a>',Me,As,oe,Ys,re,Ss,Xa="Detects segments within an image and returns labels with corresponding bounding boxes and probability scores.",ce,Vs,he,Rs,je,qs,Aa="Outputs text from a given image, commonly used for captioning or optical character recognition.",me,zs,Je,Hs,ue,_s,Ya="Creates an image from a text prompt.",ye,Fs,Sa='<a href="https://huggingface.co/spaces/huggingfacejs/image-to-text" rel="nofollow">Demo</a>',ge,Ls,fe,Ds,Te,Ps,Va="Image-to-image is the task of transforming a source image to match the characteristics of a target image or a target image domain.",we,Ks,Ra='<a href="https://scrimba.com/scrim/co4834bf9a91cc81cfab07969?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',de,Os,Ue,st,$e,tt,qa="Checks how well an input image fits into a set of labels you provide.",Ie,lt,be,et,Ce,at,xe,nt,za="This task reads some text and outputs raw float values, that are usually consumed as part of a semantic database/semantic search.",Be,it,Ze,pt,ke,Mt,Ha="Visual Question Answering is the task of answering open-ended questions based on an image. They output natural language responses to natural language questions.",Qe,ot,_a='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',Ge,rt,Ne,ct,Ee,ht,Fa="Document question answering models take a (document, question) pair as input and return an answer in natural language.",ve,jt,La='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',We,mt,Xe,Jt,Ae,ut,Ye,yt,Da="Tabular regression is the task of predicting a numerical value given a set of attributes.",Se,gt,Ve,ft,Re,Tt,Pa="Tabular classification is the task of classifying a target category (a group) based on set of attributes.",qe,wt,ze,dt,He,Ut,Ka="For models with custom parameters / outputs.",_e,$t,Fe,It,Le,bt,Oa='Learn more about using your own inference endpoints <a href="https://hf.co/docs/inference-endpoints/" rel="nofollow">here</a>',De,Ct,Pe,xt,sn=`By default, all calls to the inference endpoint will wait until the model is
loaded. When <a href="https://huggingface.co/docs/inference-endpoints/en/autoscaling#scaling-to-0" rel="nofollow">scaling to
0</a>
is enabled on the endpoint, this can result in non-trivial waiting time. If
you’d rather disable this behavior and handle the endpoint’s returned 500 HTTP
errors yourself, you can do so like so:`,Ke,Bt,Oe,Zt,sa,kt,ta,Qt,la,Gt,tn='We have an informative documentation project called <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> to list available models for each task and explain how each task works in detail.',ea,Nt,ln="It also contains demos, example outputs, and other resources should you want to dig deeper into the ML side of things.",aa,Et,na,vt,en="<li><code>@huggingface/tasks</code> : Typings only</li>",ia,Wt,pa,At,Ma;return g=new J({props:{title:"🤗 Hugging Face Inference Endpoints",local:"-hugging-face-inference-endpoints",headingTag:"h1"}}),w=new J({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),d=new J({props:{title:"Install",local:"install",headingTag:"h3"}}),U=new J({props:{title:"Node",local:"node",headingTag:"h4"}}),$=new u({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBcG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBeWFybiUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:`npm install @huggingface/inference

pnpm add @huggingface/inference

yarn add @huggingface/inference`,wrap:!1}}),I=new J({props:{title:"Deno",local:"deno",headingTag:"h4"}}),b=new u({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQSUyRiUyRiUyMG9yJTIwbnBtJTNBJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjI=",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>`,wrap:!1}}),C=new J({props:{title:"Initialize",local:"initialize",headingTag:"h3"}}),x=new u({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJyUwQSUwQWNvbnN0JTIwaGYlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZSgneW91ciUyMGFjY2VzcyUyMHRva2VuJyk=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-string">&#x27;your access token&#x27;</span>)`,wrap:!1}}),k=new J({props:{title:"Tree-shaking",local:"tree-shaking",headingTag:"h4"}}),G=new u({props:{code:"aW1wb3J0JTIwJTdCJTIwdGV4dEdlbmVyYXRpb24lMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFhd2FpdCUyMHRleHRHZW5lcmF0aW9uKCU3QiUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwJTIyaGZfLi4uJTIyJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtb2RlbF9vcl9lbmRwb2ludCUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMC4uLiUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAuLi4lMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> { textGeneration } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;model_or_endpoint&quot;</span>,
  <span class="hljs-attr">inputs</span>: ...,
  <span class="hljs-attr">parameters</span>: ...
})`,wrap:!1}}),E=new J({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),v=new J({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h3"}}),X=new u({props:{code:"YXdhaXQlMjBoZi5maWxsTWFzayglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnJTVCTUFTSyU1RCUyMHdvcmxkISclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">fillMask</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;bert-base-uncased&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;[MASK] world!&#x27;</span>
})`,wrap:!1}}),A=new J({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),S=new u({props:{code:"YXdhaXQlMjBoZi5zdW1tYXJpemF0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1jbm4nJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwJ1RoZSUyMHRvd2VyJTIwaXMlMjAzMjQlMjBtZXRyZXMlMjAoMSUyQzA2MyUyMGZ0KSUyMHRhbGwlMkMlMjBhYm91dCUyMHRoZSUyMHNhbWUlMjBoZWlnaHQlMjBhcyUyMGFuJTIwODEtc3RvcmV5JTIwYnVpbGRpbmclMkMlMjBhbmQlMjB0aGUlMjB0YWxsZXN0JTIwc3RydWN0dXJlJTIwaW4lMjBQYXJpcy4lMjBJdHMlMjBiYXNlJTIwaXMlMjBzcXVhcmUlMkMlMjBtZWFzdXJpbmclMjAxMjUlMjBtZXRyZXMlMjAoNDEwJTIwZnQpJTIwb24lMjBlYWNoJTIwc2lkZS4lMjBEdXJpbmclMjBpdHMlMjBjb25zdHJ1Y3Rpb24lMkMlMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMHN1cnBhc3NlZCUyMHRoZSUyMFdhc2hpbmd0b24lMjBNb251bWVudCUyMHRvJTIwYmVjb21lJTIwdGhlJTIwdGFsbGVzdCUyMG1hbi1tYWRlJTIwc3RydWN0dXJlJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGElMjB0aXRsZSUyMGl0JTIwaGVsZCUyMGZvciUyMDQxJTIweWVhcnMlMjB1bnRpbCUyMHRoZSUyMENocnlzbGVyJTIwQnVpbGRpbmclMjBpbiUyME5ldyUyMFlvcmslMjBDaXR5JTIwd2FzJTIwZmluaXNoZWQlMjBpbiUyMDE5MzAuJyUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNBJTIwMTAwJTBBJTIwJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">summarization</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-cnn&#x27;</span>,
  <span class="hljs-attr">inputs</span>:
    <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest man-made structure in the world, a title it held for 41 years until the Chrysler Building in New York City was finished in 1930.&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">max_length</span>: <span class="hljs-number">100</span>
  }
})`,wrap:!1}}),V=new J({props:{title:"Question Answering",local:"question-answering",headingTag:"h3"}}),q=new u({props:{code:"YXdhaXQlMjBoZi5xdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkZWVwc2V0JTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzQSUyMCdXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YnJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzQSUyMCdUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">questionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;deepset/roberta-base-squad2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;What is the capital of France?&#x27;</span>,
    <span class="hljs-attr">context</span>: <span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>
  }
})`,wrap:!1}}),z=new J({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h3"}}),H=new u({props:{code:"YXdhaXQlMjBoZi50YWJsZVF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2dvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVyeSUzQSUyMCdIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YnJTJDJTBBJTIwJTIwJTIwJTIwdGFibGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjBSZXBvc2l0b3J5JTNBJTIwJTVCJ1RyYW5zZm9ybWVycyclMkMlMjAnRGF0YXNldHMnJTJDJTIwJ1Rva2VuaXplcnMnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwU3RhcnMlM0ElMjAlNUInMzY1NDInJTJDJTIwJzQ1MTInJTJDJTIwJzM5MzQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwQ29udHJpYnV0b3JzJTNBJTIwJTVCJzY1MSclMkMlMjAnNzcnJTJDJTIwJzM0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdQcm9ncmFtbWluZyUyMGxhbmd1YWdlJyUzQSUyMCU1QidQeXRob24nJTJDJTIwJ1B5dGhvbiclMkMlMjAnUnVzdCUyQyUyMFB5dGhvbiUyMGFuZCUyME5vZGVKUyclNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tableQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/tapas-base-finetuned-wtq&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">query</span>: <span class="hljs-string">&#x27;How many stars does the transformers repository have?&#x27;</span>,
    <span class="hljs-attr">table</span>: {
      <span class="hljs-title class_">Repository</span>: [<span class="hljs-string">&#x27;Transformers&#x27;</span>, <span class="hljs-string">&#x27;Datasets&#x27;</span>, <span class="hljs-string">&#x27;Tokenizers&#x27;</span>],
      <span class="hljs-title class_">Stars</span>: [<span class="hljs-string">&#x27;36542&#x27;</span>, <span class="hljs-string">&#x27;4512&#x27;</span>, <span class="hljs-string">&#x27;3934&#x27;</span>],
      <span class="hljs-title class_">Contributors</span>: [<span class="hljs-string">&#x27;651&#x27;</span>, <span class="hljs-string">&#x27;77&#x27;</span>, <span class="hljs-string">&#x27;34&#x27;</span>],
      <span class="hljs-string">&#x27;Programming language&#x27;</span>: [<span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Rust, Python and NodeJS&#x27;</span>]
    }
  }
})`,wrap:!1}}),_=new J({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),L=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0Q2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ0klMjBsaWtlJTIweW91LiUyMEklMjBsb3ZlJTIweW91LiclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;I like you. I love you.&#x27;</span>
})`,wrap:!1}}),D=new J({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),O=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0R2VuZXJhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdncHQyJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdUaGUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHVuaXZlcnNlJTIwaXMnJTBBJTdEKSUwQSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi50ZXh0R2VuZXJhdGlvblN0cmVhbSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmdvb2dsZSUyRmZsYW4tdDUteHhsJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ3JlcGVhdCUyMCUyMm9uZSUyMHR3byUyMHRocmVlJTIwZm91ciUyMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTIwbWF4X25ld190b2tlbnMlM0ElMjAyNTAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGNvbnNvbGUubG9nKG91dHB1dC50b2tlbi50ZXh0JTJDJTIwb3V0cHV0LmdlbmVyYXRlZF90ZXh0KSUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;gpt2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>
})

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;google/flan-t5-xxl&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;repeat &quot;one two three four&quot;&#x27;</span>,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">250</span> }
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>, output.<span class="hljs-property">generated_text</span>);
}`,wrap:!1}}),ss=new J({props:{title:"Token Classification",local:"token-classification",headingTag:"h3"}}),ls=new u({props:{code:"YXdhaXQlMjBoZi50b2tlbkNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2RibWR6JTJGYmVydC1sYXJnZS1jYXNlZC1maW5ldHVuZWQtY29ubGwwMy1lbmdsaXNoJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwSmVzc2ljYSUyMFBhcmtlciUyMGJ1dCUyMHlvdSUyMGNhbiUyMGNhbGwlMjBtZSUyMEplc3NpY2EnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tokenClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dbmdz/bert-large-cased-finetuned-conll03-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Sarah Jessica Parker but you can call me Jessica&#x27;</span>
})`,wrap:!1}}),es=new J({props:{title:"Translation",local:"translation",headingTag:"h3"}}),ns=new u({props:{code:"YXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCd0NS1iYXNlJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiclMEElN0QpJTBBJTBBYXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRm1iYXJ0LWxhcmdlLTUwLW1hbnktdG8tbWFueS1tbXQnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwdGV4dFRvVHJhbnNsYXRlJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUwOSUwOSUyMnNyY19sYW5nJTIyJTNBJTIwJTIyZW5fWFglMjIlMkMlMEElMDklMDklMjJ0Z3RfbGFuZyUyMiUzQSUyMCUyMmZyX1hYJTIyJTBBJTA5JTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/mbart-large-50-many-to-many-mmt&#x27;</span>,
  <span class="hljs-attr">inputs</span>: textToTranslate,
  <span class="hljs-attr">parameters</span>: {
		<span class="hljs-string">&quot;src_lang&quot;</span>: <span class="hljs-string">&quot;en_XX&quot;</span>,
		<span class="hljs-string">&quot;tgt_lang&quot;</span>: <span class="hljs-string">&quot;fr_XX&quot;</span>
	}
})`,wrap:!1}}),is=new J({props:{title:"Zero-Shot Classification",local:"zero-shot-classification",headingTag:"h3"}}),Ms=new u({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdENsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1tbmxpJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCdIaSUyQyUyMEklMjByZWNlbnRseSUyMGJvdWdodCUyMGElMjBkZXZpY2UlMjBmcm9tJTIweW91ciUyMGNvbXBhbnklMjBidXQlMjBpdCUyMGlzJTIwbm90JTIwd29ya2luZyUyMGFzJTIwYWR2ZXJ0aXNlZCUyMGFuZCUyMEklMjB3b3VsZCUyMGxpa2UlMjB0byUyMGdldCUyMHJlaW1idXJzZWQhJyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMjBjYW5kaWRhdGVfbGFiZWxzJTNBJTIwJTVCJ3JlZnVuZCclMkMlMjAnbGVnYWwnJTJDJTIwJ2ZhcSclNUQlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>,
  <span class="hljs-attr">inputs</span>: [
    <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>
  ],
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>] }
})`,wrap:!1}}),os=new J({props:{title:"Conversational",local:"conversational",headingTag:"h3"}}),cs=new u({props:{code:"YXdhaXQlMjBoZi5jb252ZXJzYXRpb25hbCglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdtaWNyb3NvZnQlMkZEaWFsb0dQVC1sYXJnZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwYXN0X3VzZXJfaW5wdXRzJTNBJTIwJTVCJ1doaWNoJTIwbW92aWUlMjBpcyUyMHRoZSUyMGJlc3QlMjAlM0YnJTVEJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Jlc3BvbnNlcyUzQSUyMCU1QidJdCUyMGlzJTIwRGllJTIwSGFyZCUyMGZvciUyMHN1cmUuJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0ElMjAnQ2FuJTIweW91JTIwZXhwbGFpbiUyMHdoeSUyMCUzRiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">conversational</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;microsoft/DialoGPT-large&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">past_user_inputs</span>: [<span class="hljs-string">&#x27;Which movie is the best ?&#x27;</span>],
    <span class="hljs-attr">generated_responses</span>: [<span class="hljs-string">&#x27;It is Die Hard for sure.&#x27;</span>],
    <span class="hljs-attr">text</span>: <span class="hljs-string">&#x27;Can you explain why ?&#x27;</span>
  }
})`,wrap:!1}}),hs=new J({props:{title:"Sentence Similarity",local:"sentence-similarity",headingTag:"h3"}}),ms=new u({props:{code:"YXdhaXQlMjBoZi5zZW50ZW5jZVNpbWlsYXJpdHkoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGcGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwc291cmNlX3NlbnRlbmNlJTNBJTIwJ1RoYXQlMjBpcyUyMGElMjBoYXBweSUyMHBlcnNvbiclMkMlMEElMjAlMjAlMjAlMjBzZW50ZW5jZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAnVGhhdCUyMGlzJTIwYSUyMGhhcHB5JTIwZG9nJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUaGF0JTIwaXMlMjBhJTIwdmVyeSUyMGhhcHB5JTIwcGVyc29uJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUb2RheSUyMGlzJTIwYSUyMHN1bm55JTIwZGF5JyUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">sentenceSimilarity</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;sentence-transformers/paraphrase-xlm-r-multilingual-v1&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">source_sentence</span>: <span class="hljs-string">&#x27;That is a happy person&#x27;</span>,
    <span class="hljs-attr">sentences</span>: [
      <span class="hljs-string">&#x27;That is a happy dog&#x27;</span>,
      <span class="hljs-string">&#x27;That is a very happy person&#x27;</span>,
      <span class="hljs-string">&#x27;Today is a sunny day&#x27;</span>
    ]
  }
})`,wrap:!1}}),Js=new J({props:{title:"Audio",local:"audio",headingTag:"h2"}}),us=new J({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),fs=new u({props:{code:"YXdhaXQlMjBoZi5hdXRvbWF0aWNTcGVlY2hSZWNvZ25pdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmJyUyQyUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZzYW1wbGUxLmZsYWMnKSUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">automaticSpeechRecognition</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/wav2vec2-large-960h-lv60-self&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),Ts=new J({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h3"}}),Us=new u({props:{code:"YXdhaXQlMjBoZi5hdWRpb0NsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3N1cGVyYiUyRmh1YmVydC1sYXJnZS1zdXBlcmItZXInJTJDJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRnNhbXBsZTEuZmxhYycpJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;superb/hubert-large-superb-er&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),$s=new J({props:{title:"Text To Speech",local:"text-to-speech",headingTag:"h3"}}),Cs=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9TcGVlY2goJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZXNwbmV0JTJGa2FuLWJheWFzaGlfbGpzcGVlY2hfdml0cyclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnSGVsbG8lMjB3b3JsZCEnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToSpeech</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;espnet/kan-bayashi_ljspeech_vits&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;Hello world!&#x27;</span>
})`,wrap:!1}}),xs=new J({props:{title:"Audio To Audio",local:"audio-to-audio",headingTag:"h3"}}),Zs=new u({props:{code:"YXdhaXQlMjBoZi5hdWRpb1RvQXVkaW8oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3BlZWNoYnJhaW4lMkZzZXBmb3JtZXItd2hhbSclMkMlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGc2FtcGxlMS5mbGFjJyklMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioToAudio</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;speechbrain/sepformer-wham&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),ks=new J({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h2"}}),Qs=new J({props:{title:"Image Classification",local:"image-classification",headingTag:"h3"}}),Es=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZUNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZjaGVldGFoLnBuZycpJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAnZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageClassification</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cheetah.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/vit-base-patch16-224&#x27;</span>
})`,wrap:!1}}),vs=new J({props:{title:"Object Detection",local:"object-detection",headingTag:"h3"}}),As=new u({props:{code:"YXdhaXQlMjBoZi5vYmplY3REZXRlY3Rpb24oJTdCJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRmNhdHMucG5nJyklMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">objectDetection</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50&#x27;</span>
})`,wrap:!1}}),Ys=new J({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h3"}}),Vs=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZVNlZ21lbnRhdGlvbiglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAtcGFub3B0aWMnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageSegmentation</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50-panoptic&#x27;</span>
})`,wrap:!1}}),Rs=new J({props:{title:"Image To Text",local:"image-to-text",headingTag:"h3"}}),zs=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvVGV4dCglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ25scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>
})`,wrap:!1}}),Hs=new J({props:{title:"Text To Image",local:"text-to-image",headingTag:"h3"}}),Ls=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBpbnB1dHMlM0ElMjAnYXdhcmQlMjB3aW5uaW5nJTIwaGlnaCUyMHJlc29sdXRpb24lMjBwaG90byUyMG9mJTIwYSUyMGdpYW50JTIwdG9ydG9pc2UlMkYoKGxhZHliaXJkKSklMjBoeWJyaWQlMkMlMjAlNUJ0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiU1RCclMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNBJTIwJ2JsdXJyeSclMkMlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})`,wrap:!1}}),Ds=new J({props:{title:"Image To Image",local:"image-to-image",headingTag:"h3"}}),Os=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvSW1hZ2UoJTdCJTBBJTIwJTIwaW5wdXRzJTNBJTIwbmV3JTIwQmxvYiglNUJyZWFkRmlsZVN5bmMoJTIydGVzdCUyRnN0b3JtdHJvb3Blcl9kZXB0aC5wbmclMjIpJTVEKSUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0ElMjAlMjJlbG1vJ3MlMjBsZWN0dXJlJTIyJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1kZXB0aCUyMiUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&quot;test/stormtrooper_depth.png&quot;</span>)]),
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">prompt</span>: <span class="hljs-string">&quot;elmo&#x27;s lecture&quot;</span>,
  },
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;lllyasviel/sd-controlnet-depth&quot;</span>,
});`,wrap:!1}}),st=new J({props:{title:"Zero Shot Image Classification",local:"zero-shot-image-classification",headingTag:"h3"}}),lt=new u({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnb3BlbmFpJTJGY2xpcC12aXQtbGFyZ2UtcGF0Y2gxNC0zMzYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMkMlMjAlMjAlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2xhYmVscyUzQSUyMCU1QidjYXQnJTJDJTIwJ2RvZyclNUQlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotImageClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;openai/clip-vit-large-patch14-336&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  },  
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]
  }
})`,wrap:!1}}),et=new J({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),at=new J({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h3"}}),it=new u({props:{code:"YXdhaXQlMjBoZi5mZWF0dXJlRXh0cmFjdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmRpc3RpbGJlcnQtYmFzZS1ubGktbWVhbi10b2tlbnMlMjIlMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlMjJUaGF0JTIwaXMlMjBhJTIwaGFwcHklMjBwZXJzb24lMjIlMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">featureExtraction</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;sentence-transformers/distilbert-base-nli-mean-tokens&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;That is a happy person&quot;</span>,
});`,wrap:!1}}),pt=new J({props:{title:"Visual Question Answering",local:"visual-question-answering",headingTag:"h3"}}),rt=new u({props:{code:"YXdhaXQlMjBoZi52aXN1YWxRdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkYW5kZWxpbiUyRnZpbHQtYjMyLWZpbmV0dW5lZC12cWEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0ElMjAnSG93JTIwbWFueSUyMGNhdHMlMjBhcmUlMjBseWluZyUyMGRvd24lM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">visualQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dandelin/vilt-b32-finetuned-vqa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;How many cats are lying down?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  }
})`,wrap:!1}}),ct=new J({props:{title:"Document Question Answering",local:"document-question-answering",headingTag:"h3"}}),mt=new u({props:{code:"YXdhaXQlMjBoZi5kb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwJ0ludm9pY2UlMjBudW1iZXIlM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJykpLmJsb2IoKSUyQyUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">documentQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;impira/layoutlm-document-qa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;Invoice number?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  }
})`,wrap:!1}}),Jt=new J({props:{title:"Tabular",local:"tabular",headingTag:"h2"}}),ut=new J({props:{title:"Tabular Regression",local:"tabular-regression",headingTag:"h3"}}),gt=new u({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyUmVncmVzc2lvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGF0YSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlaWdodCUyMiUzQSUyMCU1QiUyMjExLjUyJTIyJTJDJTIwJTIyMTIuNDglMjIlMkMlMjAlMjIxMi4zNzc4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMSUyMiUzQSUyMCU1QiUyMjIzLjIlMjIlMkMlMjAlMjIyNCUyMiUyQyUyMCUyMjIzLjklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJMZW5ndGgyJTIyJTNBJTIwJTVCJTIyMjUuNCUyMiUyQyUyMCUyMjI2LjMlMjIlMkMlMjAlMjIyNi41JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMyUyMiUzQSUyMCU1QiUyMjMwJTIyJTJDJTIwJTIyMzEuMiUyMiUyQyUyMCUyMjMxLjElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTcGVjaWVzJTIyJTNBJTIwJTVCJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2lkdGglMjIlM0ElMjAlNUIlMjI0LjAyJTIyJTJDJTIwJTIyNC4zMDU2JTIyJTJDJTIwJTIyNC42OTYxJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularRegression</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
      <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
      <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
      <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
      <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
      <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>]
    },
  },
})`,wrap:!1}}),ft=new J({props:{title:"Tabular Classification",local:"tabular-classification",headingTag:"h3"}}),wt=new u({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJ2dm1ubm5rdiUyRndpbmUtcXVhbGl0eSUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMGRhdGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlN0QlMkMlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;vvmnnnkv/wine-quality&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
      <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
      <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
      <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
      <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
      <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
      <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
      <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
      <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
      <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
      <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>]
    },
  },
})`,wrap:!1}}),dt=new J({props:{title:"Custom Calls",local:"custom-calls",headingTag:"h2"}}),$t=new u({props:{code:"YXdhaXQlMjBoZi5yZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpJTBBJTBBJTJGJTJGJTIwQ3VzdG9tJTIwc3RyZWFtaW5nJTIwY2FsbCUyQyUyMGZvciUyMG1vZGVscyUyMHdpdGglMjBjdXN0b20lMjBwYXJhbWV0ZXJzJTIwJTJGJTIwb3V0cHV0cyUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi5zdHJlYW1pbmdSZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMC4uLiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">request</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})

<span class="hljs-comment">// Custom streaming call, for models with custom parameters / outputs</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">streamingRequest</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})) {
  ...
}`,wrap:!1}}),It=new J({props:{title:"Custom Inference Endpoints",local:"custom-inference-endpoints",headingTag:"h2"}}),Ct=new u({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCklM0I=",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});`,wrap:!1}}),Bt=new u({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglMEElMjAlMjAlN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCUyQyUwQSUyMCUyMCU3QnJldHJ5X29uX2Vycm9yJTNBJTIwZmFsc2UlN0QlMkMlMEEpJTNC",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>(
  {<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>},
  {<span class="hljs-attr">retry_on_error</span>: <span class="hljs-literal">false</span>},
);`,wrap:!1}}),Zt=new J({props:{title:"Running tests",local:"running-tests",headingTag:"h2"}}),kt=new u({props:{code:"SEZfVE9LRU4lM0QlMjJ5b3VyJTIwYWNjZXNzJTIwdG9rZW4lMjIlMjBwbnBtJTIwcnVuJTIwdGVzdA==",highlighted:"HF_TOKEN=&quot;your access token&quot; pnpm run test",wrap:!1}}),Qt=new J({props:{title:"Finding appropriate models",local:"finding-appropriate-models",headingTag:"h2"}}),Et=new J({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),Wt=new mn({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/inference/README.md"}}),{c(){y=h("meta"),Yt=a(),Xt=h("p"),St=a(),i(g.$$.fragment),Vt=a(),f=h("p"),f.innerHTML=ra,Rt=a(),T=h("p"),T.innerHTML=ca,qt=a(),i(w.$$.fragment),zt=a(),i(d.$$.fragment),Ht=a(),i(U.$$.fragment),_t=a(),i($.$$.fragment),Ft=a(),i(I.$$.fragment),Lt=a(),i(b.$$.fragment),Dt=a(),i(C.$$.fragment),Pt=a(),i(x.$$.fragment),Kt=a(),B=h("p"),B.innerHTML=ha,Ot=a(),Z=h("p"),Z.textContent=ja,sl=a(),i(k.$$.fragment),tl=a(),Q=h("p"),Q.innerHTML=ma,ll=a(),i(G.$$.fragment),el=a(),N=h("p"),N.textContent=Ja,al=a(),i(E.$$.fragment),nl=a(),i(v.$$.fragment),il=a(),W=h("p"),W.textContent=ua,pl=a(),i(X.$$.fragment),Ml=a(),i(A.$$.fragment),ol=a(),Y=h("p"),Y.textContent=ya,rl=a(),i(S.$$.fragment),cl=a(),i(V.$$.fragment),hl=a(),R=h("p"),R.textContent=ga,jl=a(),i(q.$$.fragment),ml=a(),i(z.$$.fragment),Jl=a(),i(H.$$.fragment),ul=a(),i(_.$$.fragment),yl=a(),F=h("p"),F.textContent=fa,gl=a(),i(L.$$.fragment),fl=a(),i(D.$$.fragment),Tl=a(),P=h("p"),P.textContent=Ta,wl=a(),K=h("p"),K.innerHTML=wa,dl=a(),i(O.$$.fragment),Ul=a(),i(ss.$$.fragment),$l=a(),ts=h("p"),ts.textContent=da,Il=a(),i(ls.$$.fragment),bl=a(),i(es.$$.fragment),Cl=a(),as=h("p"),as.textContent=Ua,xl=a(),i(ns.$$.fragment),Bl=a(),i(is.$$.fragment),Zl=a(),ps=h("p"),ps.textContent=$a,kl=a(),i(Ms.$$.fragment),Ql=a(),i(os.$$.fragment),Gl=a(),rs=h("p"),rs.textContent=Ia,Nl=a(),i(cs.$$.fragment),El=a(),i(hs.$$.fragment),vl=a(),js=h("p"),js.textContent=ba,Wl=a(),i(ms.$$.fragment),Xl=a(),i(Js.$$.fragment),Al=a(),i(us.$$.fragment),Yl=a(),ys=h("p"),ys.textContent=Ca,Sl=a(),gs=h("p"),gs.innerHTML=xa,Vl=a(),i(fs.$$.fragment),Rl=a(),i(Ts.$$.fragment),ql=a(),ws=h("p"),ws.textContent=Ba,zl=a(),ds=h("p"),ds.innerHTML=Za,Hl=a(),i(Us.$$.fragment),_l=a(),i($s.$$.fragment),Fl=a(),Is=h("p"),Is.textContent=ka,Ll=a(),bs=h("p"),bs.innerHTML=Qa,Dl=a(),i(Cs.$$.fragment),Pl=a(),i(xs.$$.fragment),Kl=a(),Bs=h("p"),Bs.textContent=Ga,Ol=a(),i(Zs.$$.fragment),se=a(),i(ks.$$.fragment),te=a(),i(Qs.$$.fragment),le=a(),Gs=h("p"),Gs.textContent=Na,ee=a(),Ns=h("p"),Ns.innerHTML=Ea,ae=a(),i(Es.$$.fragment),ne=a(),i(vs.$$.fragment),ie=a(),Ws=h("p"),Ws.textContent=va,pe=a(),Xs=h("p"),Xs.innerHTML=Wa,Me=a(),i(As.$$.fragment),oe=a(),i(Ys.$$.fragment),re=a(),Ss=h("p"),Ss.textContent=Xa,ce=a(),i(Vs.$$.fragment),he=a(),i(Rs.$$.fragment),je=a(),qs=h("p"),qs.textContent=Aa,me=a(),i(zs.$$.fragment),Je=a(),i(Hs.$$.fragment),ue=a(),_s=h("p"),_s.textContent=Ya,ye=a(),Fs=h("p"),Fs.innerHTML=Sa,ge=a(),i(Ls.$$.fragment),fe=a(),i(Ds.$$.fragment),Te=a(),Ps=h("p"),Ps.textContent=Va,we=a(),Ks=h("p"),Ks.innerHTML=Ra,de=a(),i(Os.$$.fragment),Ue=a(),i(st.$$.fragment),$e=a(),tt=h("p"),tt.textContent=qa,Ie=a(),i(lt.$$.fragment),be=a(),i(et.$$.fragment),Ce=a(),i(at.$$.fragment),xe=a(),nt=h("p"),nt.textContent=za,Be=a(),i(it.$$.fragment),Ze=a(),i(pt.$$.fragment),ke=a(),Mt=h("p"),Mt.textContent=Ha,Qe=a(),ot=h("p"),ot.innerHTML=_a,Ge=a(),i(rt.$$.fragment),Ne=a(),i(ct.$$.fragment),Ee=a(),ht=h("p"),ht.textContent=Fa,ve=a(),jt=h("p"),jt.innerHTML=La,We=a(),i(mt.$$.fragment),Xe=a(),i(Jt.$$.fragment),Ae=a(),i(ut.$$.fragment),Ye=a(),yt=h("p"),yt.textContent=Da,Se=a(),i(gt.$$.fragment),Ve=a(),i(ft.$$.fragment),Re=a(),Tt=h("p"),Tt.textContent=Pa,qe=a(),i(wt.$$.fragment),ze=a(),i(dt.$$.fragment),He=a(),Ut=h("p"),Ut.textContent=Ka,_e=a(),i($t.$$.fragment),Fe=a(),i(It.$$.fragment),Le=a(),bt=h("p"),bt.innerHTML=Oa,De=a(),i(Ct.$$.fragment),Pe=a(),xt=h("p"),xt.innerHTML=sn,Ke=a(),i(Bt.$$.fragment),Oe=a(),i(Zt.$$.fragment),sa=a(),i(kt.$$.fragment),ta=a(),i(Qt.$$.fragment),la=a(),Gt=h("p"),Gt.innerHTML=tn,ea=a(),Nt=h("p"),Nt.textContent=ln,aa=a(),i(Et.$$.fragment),na=a(),vt=h("ul"),vt.innerHTML=en,ia=a(),i(Wt.$$.fragment),pa=a(),At=h("p"),this.h()},l(s){const t=hn("svelte-u9bgzb",document.head);y=j(t,"META",{name:!0,content:!0}),t.forEach(l),Yt=n(s),Xt=j(s,"P",{}),an(Xt).forEach(l),St=n(s),p(g.$$.fragment,s),Vt=n(s),f=j(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-6gwev"&&(f.innerHTML=ra),Rt=n(s),T=j(s,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1pkj38e"&&(T.innerHTML=ca),qt=n(s),p(w.$$.fragment,s),zt=n(s),p(d.$$.fragment,s),Ht=n(s),p(U.$$.fragment,s),_t=n(s),p($.$$.fragment,s),Ft=n(s),p(I.$$.fragment,s),Lt=n(s),p(b.$$.fragment,s),Dt=n(s),p(C.$$.fragment,s),Pt=n(s),p(x.$$.fragment,s),Kt=n(s),B=j(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-ys53zo"&&(B.innerHTML=ha),Ot=n(s),Z=j(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-2l8ybr"&&(Z.textContent=ja),sl=n(s),p(k.$$.fragment,s),tl=n(s),Q=j(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-62skcu"&&(Q.innerHTML=ma),ll=n(s),p(G.$$.fragment,s),el=n(s),N=j(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-88xj6h"&&(N.textContent=Ja),al=n(s),p(E.$$.fragment,s),nl=n(s),p(v.$$.fragment,s),il=n(s),W=j(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1mnrr3b"&&(W.textContent=ua),pl=n(s),p(X.$$.fragment,s),Ml=n(s),p(A.$$.fragment,s),ol=n(s),Y=j(s,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-4s1xv3"&&(Y.textContent=ya),rl=n(s),p(S.$$.fragment,s),cl=n(s),p(V.$$.fragment,s),hl=n(s),R=j(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-vnhv92"&&(R.textContent=ga),jl=n(s),p(q.$$.fragment,s),ml=n(s),p(z.$$.fragment,s),Jl=n(s),p(H.$$.fragment,s),ul=n(s),p(_.$$.fragment,s),yl=n(s),F=j(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-vlz10z"&&(F.textContent=fa),gl=n(s),p(L.$$.fragment,s),fl=n(s),p(D.$$.fragment,s),Tl=n(s),P=j(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-18cimv4"&&(P.textContent=Ta),wl=n(s),K=j(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-kjz90x"&&(K.innerHTML=wa),dl=n(s),p(O.$$.fragment,s),Ul=n(s),p(ss.$$.fragment,s),$l=n(s),ts=j(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-qln4hq"&&(ts.textContent=da),Il=n(s),p(ls.$$.fragment,s),bl=n(s),p(es.$$.fragment,s),Cl=n(s),as=j(s,"P",{"data-svelte-h":!0}),m(as)!=="svelte-yinzpl"&&(as.textContent=Ua),xl=n(s),p(ns.$$.fragment,s),Bl=n(s),p(is.$$.fragment,s),Zl=n(s),ps=j(s,"P",{"data-svelte-h":!0}),m(ps)!=="svelte-mqluby"&&(ps.textContent=$a),kl=n(s),p(Ms.$$.fragment,s),Ql=n(s),p(os.$$.fragment,s),Gl=n(s),rs=j(s,"P",{"data-svelte-h":!0}),m(rs)!=="svelte-1wq8md5"&&(rs.textContent=Ia),Nl=n(s),p(cs.$$.fragment,s),El=n(s),p(hs.$$.fragment,s),vl=n(s),js=j(s,"P",{"data-svelte-h":!0}),m(js)!=="svelte-tf7teq"&&(js.textContent=ba),Wl=n(s),p(ms.$$.fragment,s),Xl=n(s),p(Js.$$.fragment,s),Al=n(s),p(us.$$.fragment,s),Yl=n(s),ys=j(s,"P",{"data-svelte-h":!0}),m(ys)!=="svelte-1in7idl"&&(ys.textContent=Ca),Sl=n(s),gs=j(s,"P",{"data-svelte-h":!0}),m(gs)!=="svelte-18afluh"&&(gs.innerHTML=xa),Vl=n(s),p(fs.$$.fragment,s),Rl=n(s),p(Ts.$$.fragment,s),ql=n(s),ws=j(s,"P",{"data-svelte-h":!0}),m(ws)!=="svelte-12s1din"&&(ws.textContent=Ba),zl=n(s),ds=j(s,"P",{"data-svelte-h":!0}),m(ds)!=="svelte-1jpdfy8"&&(ds.innerHTML=Za),Hl=n(s),p(Us.$$.fragment,s),_l=n(s),p($s.$$.fragment,s),Fl=n(s),Is=j(s,"P",{"data-svelte-h":!0}),m(Is)!=="svelte-1h8ubig"&&(Is.textContent=ka),Ll=n(s),bs=j(s,"P",{"data-svelte-h":!0}),m(bs)!=="svelte-1edrfzt"&&(bs.innerHTML=Qa),Dl=n(s),p(Cs.$$.fragment,s),Pl=n(s),p(xs.$$.fragment,s),Kl=n(s),Bs=j(s,"P",{"data-svelte-h":!0}),m(Bs)!=="svelte-zj5o06"&&(Bs.textContent=Ga),Ol=n(s),p(Zs.$$.fragment,s),se=n(s),p(ks.$$.fragment,s),te=n(s),p(Qs.$$.fragment,s),le=n(s),Gs=j(s,"P",{"data-svelte-h":!0}),m(Gs)!=="svelte-1nlp89w"&&(Gs.textContent=Na),ee=n(s),Ns=j(s,"P",{"data-svelte-h":!0}),m(Ns)!=="svelte-10vvvxx"&&(Ns.innerHTML=Ea),ae=n(s),p(Es.$$.fragment,s),ne=n(s),p(vs.$$.fragment,s),ie=n(s),Ws=j(s,"P",{"data-svelte-h":!0}),m(Ws)!=="svelte-d15mev"&&(Ws.textContent=va),pe=n(s),Xs=j(s,"P",{"data-svelte-h":!0}),m(Xs)!=="svelte-pxrbuw"&&(Xs.innerHTML=Wa),Me=n(s),p(As.$$.fragment,s),oe=n(s),p(Ys.$$.fragment,s),re=n(s),Ss=j(s,"P",{"data-svelte-h":!0}),m(Ss)!=="svelte-1oenl8f"&&(Ss.textContent=Xa),ce=n(s),p(Vs.$$.fragment,s),he=n(s),p(Rs.$$.fragment,s),je=n(s),qs=j(s,"P",{"data-svelte-h":!0}),m(qs)!=="svelte-66badz"&&(qs.textContent=Aa),me=n(s),p(zs.$$.fragment,s),Je=n(s),p(Hs.$$.fragment,s),ue=n(s),_s=j(s,"P",{"data-svelte-h":!0}),m(_s)!=="svelte-13iv3hh"&&(_s.textContent=Ya),ye=n(s),Fs=j(s,"P",{"data-svelte-h":!0}),m(Fs)!=="svelte-1mgyz4r"&&(Fs.innerHTML=Sa),ge=n(s),p(Ls.$$.fragment,s),fe=n(s),p(Ds.$$.fragment,s),Te=n(s),Ps=j(s,"P",{"data-svelte-h":!0}),m(Ps)!=="svelte-1y7kqaa"&&(Ps.textContent=Va),we=n(s),Ks=j(s,"P",{"data-svelte-h":!0}),m(Ks)!=="svelte-m8xmew"&&(Ks.innerHTML=Ra),de=n(s),p(Os.$$.fragment,s),Ue=n(s),p(st.$$.fragment,s),$e=n(s),tt=j(s,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-m7q2yg"&&(tt.textContent=qa),Ie=n(s),p(lt.$$.fragment,s),be=n(s),p(et.$$.fragment,s),Ce=n(s),p(at.$$.fragment,s),xe=n(s),nt=j(s,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-174b8m1"&&(nt.textContent=za),Be=n(s),p(it.$$.fragment,s),Ze=n(s),p(pt.$$.fragment,s),ke=n(s),Mt=j(s,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-cnruui"&&(Mt.textContent=Ha),Qe=n(s),ot=j(s,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-hwgezm"&&(ot.innerHTML=_a),Ge=n(s),p(rt.$$.fragment,s),Ne=n(s),p(ct.$$.fragment,s),Ee=n(s),ht=j(s,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-1tpexz3"&&(ht.textContent=Fa),ve=n(s),jt=j(s,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-hwgezm"&&(jt.innerHTML=La),We=n(s),p(mt.$$.fragment,s),Xe=n(s),p(Jt.$$.fragment,s),Ae=n(s),p(ut.$$.fragment,s),Ye=n(s),yt=j(s,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-1js246c"&&(yt.textContent=Da),Se=n(s),p(gt.$$.fragment,s),Ve=n(s),p(ft.$$.fragment,s),Re=n(s),Tt=j(s,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-7l7zu1"&&(Tt.textContent=Pa),qe=n(s),p(wt.$$.fragment,s),ze=n(s),p(dt.$$.fragment,s),He=n(s),Ut=j(s,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-1uv5lul"&&(Ut.textContent=Ka),_e=n(s),p($t.$$.fragment,s),Fe=n(s),p(It.$$.fragment,s),Le=n(s),bt=j(s,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-14q869u"&&(bt.innerHTML=Oa),De=n(s),p(Ct.$$.fragment,s),Pe=n(s),xt=j(s,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-16znzc1"&&(xt.innerHTML=sn),Ke=n(s),p(Bt.$$.fragment,s),Oe=n(s),p(Zt.$$.fragment,s),sa=n(s),p(kt.$$.fragment,s),ta=n(s),p(Qt.$$.fragment,s),la=n(s),Gt=j(s,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-62a9et"&&(Gt.innerHTML=tn),ea=n(s),Nt=j(s,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-1yyf4wc"&&(Nt.textContent=ln),aa=n(s),p(Et.$$.fragment,s),na=n(s),vt=j(s,"UL",{"data-svelte-h":!0}),m(vt)!=="svelte-mopwlb"&&(vt.innerHTML=en),ia=n(s),p(Wt.$$.fragment,s),pa=n(s),At=j(s,"P",{}),an(At).forEach(l),this.h()},h(){nn(y,"name","hf:doc:metadata"),nn(y,"content",un)},m(s,t){jn(document.head,y),e(s,Yt,t),e(s,Xt,t),e(s,St,t),M(g,s,t),e(s,Vt,t),e(s,f,t),e(s,Rt,t),e(s,T,t),e(s,qt,t),M(w,s,t),e(s,zt,t),M(d,s,t),e(s,Ht,t),M(U,s,t),e(s,_t,t),M($,s,t),e(s,Ft,t),M(I,s,t),e(s,Lt,t),M(b,s,t),e(s,Dt,t),M(C,s,t),e(s,Pt,t),M(x,s,t),e(s,Kt,t),e(s,B,t),e(s,Ot,t),e(s,Z,t),e(s,sl,t),M(k,s,t),e(s,tl,t),e(s,Q,t),e(s,ll,t),M(G,s,t),e(s,el,t),e(s,N,t),e(s,al,t),M(E,s,t),e(s,nl,t),M(v,s,t),e(s,il,t),e(s,W,t),e(s,pl,t),M(X,s,t),e(s,Ml,t),M(A,s,t),e(s,ol,t),e(s,Y,t),e(s,rl,t),M(S,s,t),e(s,cl,t),M(V,s,t),e(s,hl,t),e(s,R,t),e(s,jl,t),M(q,s,t),e(s,ml,t),M(z,s,t),e(s,Jl,t),M(H,s,t),e(s,ul,t),M(_,s,t),e(s,yl,t),e(s,F,t),e(s,gl,t),M(L,s,t),e(s,fl,t),M(D,s,t),e(s,Tl,t),e(s,P,t),e(s,wl,t),e(s,K,t),e(s,dl,t),M(O,s,t),e(s,Ul,t),M(ss,s,t),e(s,$l,t),e(s,ts,t),e(s,Il,t),M(ls,s,t),e(s,bl,t),M(es,s,t),e(s,Cl,t),e(s,as,t),e(s,xl,t),M(ns,s,t),e(s,Bl,t),M(is,s,t),e(s,Zl,t),e(s,ps,t),e(s,kl,t),M(Ms,s,t),e(s,Ql,t),M(os,s,t),e(s,Gl,t),e(s,rs,t),e(s,Nl,t),M(cs,s,t),e(s,El,t),M(hs,s,t),e(s,vl,t),e(s,js,t),e(s,Wl,t),M(ms,s,t),e(s,Xl,t),M(Js,s,t),e(s,Al,t),M(us,s,t),e(s,Yl,t),e(s,ys,t),e(s,Sl,t),e(s,gs,t),e(s,Vl,t),M(fs,s,t),e(s,Rl,t),M(Ts,s,t),e(s,ql,t),e(s,ws,t),e(s,zl,t),e(s,ds,t),e(s,Hl,t),M(Us,s,t),e(s,_l,t),M($s,s,t),e(s,Fl,t),e(s,Is,t),e(s,Ll,t),e(s,bs,t),e(s,Dl,t),M(Cs,s,t),e(s,Pl,t),M(xs,s,t),e(s,Kl,t),e(s,Bs,t),e(s,Ol,t),M(Zs,s,t),e(s,se,t),M(ks,s,t),e(s,te,t),M(Qs,s,t),e(s,le,t),e(s,Gs,t),e(s,ee,t),e(s,Ns,t),e(s,ae,t),M(Es,s,t),e(s,ne,t),M(vs,s,t),e(s,ie,t),e(s,Ws,t),e(s,pe,t),e(s,Xs,t),e(s,Me,t),M(As,s,t),e(s,oe,t),M(Ys,s,t),e(s,re,t),e(s,Ss,t),e(s,ce,t),M(Vs,s,t),e(s,he,t),M(Rs,s,t),e(s,je,t),e(s,qs,t),e(s,me,t),M(zs,s,t),e(s,Je,t),M(Hs,s,t),e(s,ue,t),e(s,_s,t),e(s,ye,t),e(s,Fs,t),e(s,ge,t),M(Ls,s,t),e(s,fe,t),M(Ds,s,t),e(s,Te,t),e(s,Ps,t),e(s,we,t),e(s,Ks,t),e(s,de,t),M(Os,s,t),e(s,Ue,t),M(st,s,t),e(s,$e,t),e(s,tt,t),e(s,Ie,t),M(lt,s,t),e(s,be,t),M(et,s,t),e(s,Ce,t),M(at,s,t),e(s,xe,t),e(s,nt,t),e(s,Be,t),M(it,s,t),e(s,Ze,t),M(pt,s,t),e(s,ke,t),e(s,Mt,t),e(s,Qe,t),e(s,ot,t),e(s,Ge,t),M(rt,s,t),e(s,Ne,t),M(ct,s,t),e(s,Ee,t),e(s,ht,t),e(s,ve,t),e(s,jt,t),e(s,We,t),M(mt,s,t),e(s,Xe,t),M(Jt,s,t),e(s,Ae,t),M(ut,s,t),e(s,Ye,t),e(s,yt,t),e(s,Se,t),M(gt,s,t),e(s,Ve,t),M(ft,s,t),e(s,Re,t),e(s,Tt,t),e(s,qe,t),M(wt,s,t),e(s,ze,t),M(dt,s,t),e(s,He,t),e(s,Ut,t),e(s,_e,t),M($t,s,t),e(s,Fe,t),M(It,s,t),e(s,Le,t),e(s,bt,t),e(s,De,t),M(Ct,s,t),e(s,Pe,t),e(s,xt,t),e(s,Ke,t),M(Bt,s,t),e(s,Oe,t),M(Zt,s,t),e(s,sa,t),M(kt,s,t),e(s,ta,t),M(Qt,s,t),e(s,la,t),e(s,Gt,t),e(s,ea,t),e(s,Nt,t),e(s,aa,t),M(Et,s,t),e(s,na,t),e(s,vt,t),e(s,ia,t),M(Wt,s,t),e(s,pa,t),e(s,At,t),Ma=!0},p:Mn,i(s){Ma||(o(g.$$.fragment,s),o(w.$$.fragment,s),o(d.$$.fragment,s),o(U.$$.fragment,s),o($.$$.fragment,s),o(I.$$.fragment,s),o(b.$$.fragment,s),o(C.$$.fragment,s),o(x.$$.fragment,s),o(k.$$.fragment,s),o(G.$$.fragment,s),o(E.$$.fragment,s),o(v.$$.fragment,s),o(X.$$.fragment,s),o(A.$$.fragment,s),o(S.$$.fragment,s),o(V.$$.fragment,s),o(q.$$.fragment,s),o(z.$$.fragment,s),o(H.$$.fragment,s),o(_.$$.fragment,s),o(L.$$.fragment,s),o(D.$$.fragment,s),o(O.$$.fragment,s),o(ss.$$.fragment,s),o(ls.$$.fragment,s),o(es.$$.fragment,s),o(ns.$$.fragment,s),o(is.$$.fragment,s),o(Ms.$$.fragment,s),o(os.$$.fragment,s),o(cs.$$.fragment,s),o(hs.$$.fragment,s),o(ms.$$.fragment,s),o(Js.$$.fragment,s),o(us.$$.fragment,s),o(fs.$$.fragment,s),o(Ts.$$.fragment,s),o(Us.$$.fragment,s),o($s.$$.fragment,s),o(Cs.$$.fragment,s),o(xs.$$.fragment,s),o(Zs.$$.fragment,s),o(ks.$$.fragment,s),o(Qs.$$.fragment,s),o(Es.$$.fragment,s),o(vs.$$.fragment,s),o(As.$$.fragment,s),o(Ys.$$.fragment,s),o(Vs.$$.fragment,s),o(Rs.$$.fragment,s),o(zs.$$.fragment,s),o(Hs.$$.fragment,s),o(Ls.$$.fragment,s),o(Ds.$$.fragment,s),o(Os.$$.fragment,s),o(st.$$.fragment,s),o(lt.$$.fragment,s),o(et.$$.fragment,s),o(at.$$.fragment,s),o(it.$$.fragment,s),o(pt.$$.fragment,s),o(rt.$$.fragment,s),o(ct.$$.fragment,s),o(mt.$$.fragment,s),o(Jt.$$.fragment,s),o(ut.$$.fragment,s),o(gt.$$.fragment,s),o(ft.$$.fragment,s),o(wt.$$.fragment,s),o(dt.$$.fragment,s),o($t.$$.fragment,s),o(It.$$.fragment,s),o(Ct.$$.fragment,s),o(Bt.$$.fragment,s),o(Zt.$$.fragment,s),o(kt.$$.fragment,s),o(Qt.$$.fragment,s),o(Et.$$.fragment,s),o(Wt.$$.fragment,s),Ma=!0)},o(s){r(g.$$.fragment,s),r(w.$$.fragment,s),r(d.$$.fragment,s),r(U.$$.fragment,s),r($.$$.fragment,s),r(I.$$.fragment,s),r(b.$$.fragment,s),r(C.$$.fragment,s),r(x.$$.fragment,s),r(k.$$.fragment,s),r(G.$$.fragment,s),r(E.$$.fragment,s),r(v.$$.fragment,s),r(X.$$.fragment,s),r(A.$$.fragment,s),r(S.$$.fragment,s),r(V.$$.fragment,s),r(q.$$.fragment,s),r(z.$$.fragment,s),r(H.$$.fragment,s),r(_.$$.fragment,s),r(L.$$.fragment,s),r(D.$$.fragment,s),r(O.$$.fragment,s),r(ss.$$.fragment,s),r(ls.$$.fragment,s),r(es.$$.fragment,s),r(ns.$$.fragment,s),r(is.$$.fragment,s),r(Ms.$$.fragment,s),r(os.$$.fragment,s),r(cs.$$.fragment,s),r(hs.$$.fragment,s),r(ms.$$.fragment,s),r(Js.$$.fragment,s),r(us.$$.fragment,s),r(fs.$$.fragment,s),r(Ts.$$.fragment,s),r(Us.$$.fragment,s),r($s.$$.fragment,s),r(Cs.$$.fragment,s),r(xs.$$.fragment,s),r(Zs.$$.fragment,s),r(ks.$$.fragment,s),r(Qs.$$.fragment,s),r(Es.$$.fragment,s),r(vs.$$.fragment,s),r(As.$$.fragment,s),r(Ys.$$.fragment,s),r(Vs.$$.fragment,s),r(Rs.$$.fragment,s),r(zs.$$.fragment,s),r(Hs.$$.fragment,s),r(Ls.$$.fragment,s),r(Ds.$$.fragment,s),r(Os.$$.fragment,s),r(st.$$.fragment,s),r(lt.$$.fragment,s),r(et.$$.fragment,s),r(at.$$.fragment,s),r(it.$$.fragment,s),r(pt.$$.fragment,s),r(rt.$$.fragment,s),r(ct.$$.fragment,s),r(mt.$$.fragment,s),r(Jt.$$.fragment,s),r(ut.$$.fragment,s),r(gt.$$.fragment,s),r(ft.$$.fragment,s),r(wt.$$.fragment,s),r(dt.$$.fragment,s),r($t.$$.fragment,s),r(It.$$.fragment,s),r(Ct.$$.fragment,s),r(Bt.$$.fragment,s),r(Zt.$$.fragment,s),r(kt.$$.fragment,s),r(Qt.$$.fragment,s),r(Et.$$.fragment,s),r(Wt.$$.fragment,s),Ma=!1},d(s){s&&(l(Yt),l(Xt),l(St),l(Vt),l(f),l(Rt),l(T),l(qt),l(zt),l(Ht),l(_t),l(Ft),l(Lt),l(Dt),l(Pt),l(Kt),l(B),l(Ot),l(Z),l(sl),l(tl),l(Q),l(ll),l(el),l(N),l(al),l(nl),l(il),l(W),l(pl),l(Ml),l(ol),l(Y),l(rl),l(cl),l(hl),l(R),l(jl),l(ml),l(Jl),l(ul),l(yl),l(F),l(gl),l(fl),l(Tl),l(P),l(wl),l(K),l(dl),l(Ul),l($l),l(ts),l(Il),l(bl),l(Cl),l(as),l(xl),l(Bl),l(Zl),l(ps),l(kl),l(Ql),l(Gl),l(rs),l(Nl),l(El),l(vl),l(js),l(Wl),l(Xl),l(Al),l(Yl),l(ys),l(Sl),l(gs),l(Vl),l(Rl),l(ql),l(ws),l(zl),l(ds),l(Hl),l(_l),l(Fl),l(Is),l(Ll),l(bs),l(Dl),l(Pl),l(Kl),l(Bs),l(Ol),l(se),l(te),l(le),l(Gs),l(ee),l(Ns),l(ae),l(ne),l(ie),l(Ws),l(pe),l(Xs),l(Me),l(oe),l(re),l(Ss),l(ce),l(he),l(je),l(qs),l(me),l(Je),l(ue),l(_s),l(ye),l(Fs),l(ge),l(fe),l(Te),l(Ps),l(we),l(Ks),l(de),l(Ue),l($e),l(tt),l(Ie),l(be),l(Ce),l(xe),l(nt),l(Be),l(Ze),l(ke),l(Mt),l(Qe),l(ot),l(Ge),l(Ne),l(Ee),l(ht),l(ve),l(jt),l(We),l(Xe),l(Ae),l(Ye),l(yt),l(Se),l(Ve),l(Re),l(Tt),l(qe),l(ze),l(He),l(Ut),l(_e),l(Fe),l(Le),l(bt),l(De),l(Pe),l(xt),l(Ke),l(Oe),l(sa),l(ta),l(la),l(Gt),l(ea),l(Nt),l(aa),l(na),l(vt),l(ia),l(pa),l(At)),l(y),c(g,s),c(w,s),c(d,s),c(U,s),c($,s),c(I,s),c(b,s),c(C,s),c(x,s),c(k,s),c(G,s),c(E,s),c(v,s),c(X,s),c(A,s),c(S,s),c(V,s),c(q,s),c(z,s),c(H,s),c(_,s),c(L,s),c(D,s),c(O,s),c(ss,s),c(ls,s),c(es,s),c(ns,s),c(is,s),c(Ms,s),c(os,s),c(cs,s),c(hs,s),c(ms,s),c(Js,s),c(us,s),c(fs,s),c(Ts,s),c(Us,s),c($s,s),c(Cs,s),c(xs,s),c(Zs,s),c(ks,s),c(Qs,s),c(Es,s),c(vs,s),c(As,s),c(Ys,s),c(Vs,s),c(Rs,s),c(zs,s),c(Hs,s),c(Ls,s),c(Ds,s),c(Os,s),c(st,s),c(lt,s),c(et,s),c(at,s),c(it,s),c(pt,s),c(rt,s),c(ct,s),c(mt,s),c(Jt,s),c(ut,s),c(gt,s),c(ft,s),c(wt,s),c(dt,s),c($t,s),c(It,s),c(Ct,s),c(Bt,s),c(Zt,s),c(kt,s),c(Qt,s),c(Et,s),c(Wt,s)}}}const un='{"title":"🤗 Hugging Face Inference Endpoints","local":"-hugging-face-inference-endpoints","sections":[{"title":"Getting Started","local":"getting-started","sections":[{"title":"Install","local":"install","sections":[{"title":"Node","local":"node","sections":[],"depth":4},{"title":"Deno","local":"deno","sections":[],"depth":4}],"depth":3},{"title":"Initialize","local":"initialize","sections":[{"title":"Tree-shaking","local":"tree-shaking","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Question Answering","local":"question-answering","sections":[],"depth":3},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":3},{"title":"Text Classification","local":"text-classification","sections":[],"depth":3},{"title":"Text Generation","local":"text-generation","sections":[],"depth":3},{"title":"Token Classification","local":"token-classification","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Zero-Shot Classification","local":"zero-shot-classification","sections":[],"depth":3},{"title":"Conversational","local":"conversational","sections":[],"depth":3},{"title":"Sentence Similarity","local":"sentence-similarity","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":3},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":3},{"title":"Text To Speech","local":"text-to-speech","sections":[],"depth":3},{"title":"Audio To Audio","local":"audio-to-audio","sections":[],"depth":3}],"depth":2},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"Image Classification","local":"image-classification","sections":[],"depth":3},{"title":"Object Detection","local":"object-detection","sections":[],"depth":3},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Image To Text","local":"image-to-text","sections":[],"depth":3},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image To Image","local":"image-to-image","sections":[],"depth":3},{"title":"Zero Shot Image Classification","local":"zero-shot-image-classification","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"Visual Question Answering","local":"visual-question-answering","sections":[],"depth":3},{"title":"Document Question Answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2},{"title":"Tabular","local":"tabular","sections":[{"title":"Tabular Regression","local":"tabular-regression","sections":[],"depth":3},{"title":"Tabular Classification","local":"tabular-classification","sections":[],"depth":3}],"depth":2},{"title":"Custom Calls","local":"custom-calls","sections":[],"depth":2},{"title":"Custom Inference Endpoints","local":"custom-inference-endpoints","sections":[],"depth":2},{"title":"Running tests","local":"running-tests","sections":[],"depth":2},{"title":"Finding appropriate models","local":"finding-appropriate-models","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function yn(oa){return on(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dn extends rn{constructor(y){super(),cn(this,y,yn,Jn,pn,{})}}export{dn as component};
