import{s as bl,n as Il,o as _l}from"../chunks/scheduler.b108d059.js";import{S as fl,i as Cl,g as n,s as a,r as o,A as hl,h as M,f as t,c as i,j as rl,u as J,x as p,k as Ul,y as Bl,a as e,v as m,d as T,t as u,w}from"../chunks/index.008de539.js";import{C as R}from"../chunks/CodeBlock.3968c746.js";import{H as nl}from"../chunks/Heading.88bfeb84.js";function Xl(Ml){let c,V,E,k,y,G,d,pl="In case you don’t settle for the default scikit-learn metrics, you can define your own metric.",Y,j,cl="Here, we expect the organizer to know python.",Q,r,F,U,ol="To define a custom metric, change <code>EVAL_METRIC</code> in <code>conf.json</code> to <code>custom</code>. You must also make sure that <code>EVAL_HIGHER_IS_BETTER</code> is set to <code>1</code> or <code>0</code> depending on whether a higher value of the metric is better or not.",x,b,Jl=`The second step is to create a file <code>metric.py</code> in the private competition repo.
The file should contain a <code>compute</code> function that takes competition params as input.`,$,I,ml="Here is the part where we check if metric is custom and calculate the metric value:",g,_,S,f,Tl="You can find the above part in competitions github repo <code>compute_metrics.py</code>",q,C,ul="<code>params</code> is defined as:",L,h,P,B,wl=`You are free to do whatever you want to in the <code>compute</code> function.
In the end it must return a dictionary with the following keys:`,K,X,D,W,yl=`public and private scores can be floats or can also be dictionaries in case you want to use multiple metrics.
Example for multiple metrics:`,O,A,ll,v,dl="Note: When using multiple metrics, a base metric (the first one) will be used to rank the participants in the competition.",sl,N,tl,Z,el,z,jl=`Take a careful look at the above code.
You can see that we are downloading the solution file and the submission file from the dataset repo.
We are then calculating the metric on the public and private splits of the solution and submission files.
Finally, we are returning the metric values in a dictionary.`,al,H,il;return y=new nl({props:{title:"Custom metric",local:"custom-metric",headingTag:"h1"}}),r=new nl({props:{title:"How to define a custom metric",local:"how-to-define-a-custom-metric",headingTag:"h3"}}),_=new R({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKHBhcmFtcyklM0ElMEElMjAlMjAlMjAlMjBpZiUyMHBhcmFtcy5tZXRyaWMlMjAlM0QlM0QlMjAlMjJjdXN0b20lMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfZmlsZSUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcGFyYW1zLmNvbXBldGl0aW9uX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJtZXRyaWMucHklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbiUzRHBhcmFtcy50b2tlbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3lzLnBhdGguYXBwZW5kKG9zLnBhdGguZGlybmFtZShtZXRyaWNfZmlsZSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwaW1wb3J0bGliLmltcG9ydF9tb2R1bGUoJTIybWV0cmljJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV2YWx1YXRpb24lMjAlM0QlMjBtZXRyaWMuY29tcHV0ZShwYXJhbXMpJTBBJTIwJTIwJTIwJTIwLiUwQSUyMCUyMCUyMCUyMC4lMEElMjAlMjAlMjAlMjAu",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">params</span>):
    <span class="hljs-keyword">if</span> params.metric == <span class="hljs-string">&quot;custom&quot;</span>:
        metric_file = hf_hub_download(
            repo_id=params.competition_id,
            filename=<span class="hljs-string">&quot;metric.py&quot;</span>,
            token=params.token,
            repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
        )
        sys.path.append(os.path.dirname(metric_file))
        metric = importlib.import_module(<span class="hljs-string">&quot;metric&quot;</span>)
        evaluation = metric.compute(params)
    .
    .
    .`,wrap:!1}}),h=new R({props:{code:"Y2xhc3MlMjBFdmFsUGFyYW1zKEJhc2VNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb21wZXRpdGlvbl9pZCUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMGNvbXBldGl0aW9uX3R5cGUlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBtZXRyaWMlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjB0b2tlbiUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMHRlYW1faWQlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBzdWJtaXNzaW9uX2lkJTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwc3VibWlzc2lvbl9pZF9jb2wlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBzdWJtaXNzaW9uX2NvbHMlM0ElMjBMaXN0JTVCc3RyJTVEJTBBJTIwJTIwJTIwJTIwc3VibWlzc2lvbl9yb3dzJTNBJTIwaW50JTBBJTIwJTIwJTIwJTIwb3V0cHV0X3BhdGglM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBzdWJtaXNzaW9uX3JlcG8lM0ElMjBzdHIlMEElMjAlMjAlMjAlMjB0aW1lX2xpbWl0JTNBJTIwaW50JTBBJTIwJTIwJTIwJTIwZGF0YXNldCUzQSUyMHN0ciUyMCUyMCUyMyUyMHByaXZhdGUlMjB0ZXN0JTIwZGF0YXNldCUyQyUyMHVzZWQlMjBvbmx5JTIwZm9yJTIwc2NyaXB0JTIwY29tcGV0aXRpb25z",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">EvalParams</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    competition_id: <span class="hljs-built_in">str</span>
    competition_type: <span class="hljs-built_in">str</span>
    metric: <span class="hljs-built_in">str</span>
    token: <span class="hljs-built_in">str</span>
    team_id: <span class="hljs-built_in">str</span>
    submission_id: <span class="hljs-built_in">str</span>
    submission_id_col: <span class="hljs-built_in">str</span>
    submission_cols: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]
    submission_rows: <span class="hljs-built_in">int</span>
    output_path: <span class="hljs-built_in">str</span>
    submission_repo: <span class="hljs-built_in">str</span>
    time_limit: <span class="hljs-built_in">int</span>
    dataset: <span class="hljs-built_in">str</span>  <span class="hljs-comment"># private test dataset, used only for script competitions</span>`,wrap:!1}}),X=new R({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycHVibGljX3Njb3JlJTIyJTNBJTIwbWV0cmljX3ZhbHVlJTJDJTBBJTIwJTIwJTIwJTIwJTIycHJpdmF0ZV9zY29yZSUyMiUzQSUyMG1ldHJpY192YWx1ZSUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-string">&quot;public_score&quot;</span>: metric_value,
    <span class="hljs-string">&quot;private_score&quot;</span>: metric_value,
}`,wrap:!1}}),A=new R({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycHVibGljX3Njb3JlJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljMSUyMiUzQSUyMG1ldHJpY192YWx1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1ldHJpYzIlMjIlM0ElMjBtZXRyaWNfdmFsdWUlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJwcml2YXRlX3Njb3JlJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljMSUyMiUzQSUyMG1ldHJpY192YWx1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1ldHJpYzIlMjIlM0ElMjBtZXRyaWNfdmFsdWUlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElN0Q=",highlighted:`{
    <span class="hljs-string">&quot;public_score&quot;</span>: {
        <span class="hljs-string">&quot;metric1&quot;</span>: metric_value,
        <span class="hljs-string">&quot;metric2&quot;</span>: metric_value,
    },
    <span class="hljs-string">&quot;private_score&quot;</span>: {
        <span class="hljs-string">&quot;metric1&quot;</span>: metric_value,
        <span class="hljs-string">&quot;metric2&quot;</span>: metric_value,
    },
}`,wrap:!1}}),N=new nl({props:{title:"Example of a custom metric",local:"example-of-a-custom-metric",headingTag:"h3"}}),Z=new R({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute</span>(<span class="hljs-params">params</span>):
    solution_file = hf_hub_download(
        repo_id=params.competition_id,
        filename=<span class="hljs-string">&quot;solution.csv&quot;</span>,
        token=params.token,
        repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
    )

    solution_df = pd.read_csv(solution_file)

    submission_filename = <span class="hljs-string">f&quot;submissions/<span class="hljs-subst">{params.team_id}</span>-<span class="hljs-subst">{params.submission_id}</span>.csv&quot;</span>
    submission_file = hf_hub_download(
        repo_id=params.competition_id,
        filename=submission_filename,
        token=params.token,
        repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
    )
    submission_df = pd.read_csv(submission_file)

    public_ids = solution_df[solution_df.split == <span class="hljs-string">&quot;public&quot;</span>][params.submission_id_col].values
    private_ids = solution_df[solution_df.split == <span class="hljs-string">&quot;private&quot;</span>][params.submission_id_col].values

    public_solution_df = solution_df[solution_df[params.submission_id_col].isin(public_ids)]
    public_submission_df = submission_df[submission_df[params.submission_id_col].isin(public_ids)]

    private_solution_df = solution_df[solution_df[params.submission_id_col].isin(private_ids)]
    private_submission_df = submission_df[submission_df[params.submission_id_col].isin(private_ids)]

    public_solution_df = public_solution_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)
    public_submission_df = public_submission_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)

    private_solution_df = private_solution_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)
    private_submission_df = private_submission_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># CALCULATE METRICS HERE.......</span>
    <span class="hljs-comment"># _metric = SOME METRIC FUNCTION</span>
    target_cols = [col <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> solution_df.columns <span class="hljs-keyword">if</span> col <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [params.submission_id_col, <span class="hljs-string">&quot;split&quot;</span>]]
    public_score = _metric(public_solution_df[target_cols], public_submission_df[target_cols])
    private_score = _metric(private_solution_df[target_cols], private_submission_df[target_cols])

    evaluation = {
        <span class="hljs-string">&quot;public_score&quot;</span>: public_score,
        <span class="hljs-string">&quot;private_score&quot;</span>: private_score,
    }
    <span class="hljs-keyword">return</span> evaluation`,wrap:!1}}),{c(){c=n("meta"),V=a(),E=n("p"),k=a(),o(y.$$.fragment),G=a(),d=n("p"),d.textContent=pl,Y=a(),j=n("p"),j.textContent=cl,Q=a(),o(r.$$.fragment),F=a(),U=n("p"),U.innerHTML=ol,x=a(),b=n("p"),b.innerHTML=Jl,$=a(),I=n("p"),I.textContent=ml,g=a(),o(_.$$.fragment),S=a(),f=n("p"),f.innerHTML=Tl,q=a(),C=n("p"),C.innerHTML=ul,L=a(),o(h.$$.fragment),P=a(),B=n("p"),B.innerHTML=wl,K=a(),o(X.$$.fragment),D=a(),W=n("p"),W.textContent=yl,O=a(),o(A.$$.fragment),ll=a(),v=n("p"),v.textContent=dl,sl=a(),o(N.$$.fragment),tl=a(),o(Z.$$.fragment),el=a(),z=n("p"),z.textContent=jl,al=a(),H=n("p"),this.h()},l(l){const s=hl("svelte-u9bgzb",document.head);c=M(s,"META",{name:!0,content:!0}),s.forEach(t),V=i(l),E=M(l,"P",{}),rl(E).forEach(t),k=i(l),J(y.$$.fragment,l),G=i(l),d=M(l,"P",{"data-svelte-h":!0}),p(d)!=="svelte-thew86"&&(d.textContent=pl),Y=i(l),j=M(l,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1bv7n2t"&&(j.textContent=cl),Q=i(l),J(r.$$.fragment,l),F=i(l),U=M(l,"P",{"data-svelte-h":!0}),p(U)!=="svelte-x1ibbx"&&(U.innerHTML=ol),x=i(l),b=M(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-otcxp4"&&(b.innerHTML=Jl),$=i(l),I=M(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1g3svse"&&(I.textContent=ml),g=i(l),J(_.$$.fragment,l),S=i(l),f=M(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-14x4oq"&&(f.innerHTML=Tl),q=i(l),C=M(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1icqugy"&&(C.innerHTML=ul),L=i(l),J(h.$$.fragment,l),P=i(l),B=M(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1o6b4b1"&&(B.innerHTML=wl),K=i(l),J(X.$$.fragment,l),D=i(l),W=M(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1lswa00"&&(W.textContent=yl),O=i(l),J(A.$$.fragment,l),ll=i(l),v=M(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-18x004c"&&(v.textContent=dl),sl=i(l),J(N.$$.fragment,l),tl=i(l),J(Z.$$.fragment,l),el=i(l),z=M(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-mlly83"&&(z.textContent=jl),al=i(l),H=M(l,"P",{}),rl(H).forEach(t),this.h()},h(){Ul(c,"name","hf:doc:metadata"),Ul(c,"content",Wl)},m(l,s){Bl(document.head,c),e(l,V,s),e(l,E,s),e(l,k,s),m(y,l,s),e(l,G,s),e(l,d,s),e(l,Y,s),e(l,j,s),e(l,Q,s),m(r,l,s),e(l,F,s),e(l,U,s),e(l,x,s),e(l,b,s),e(l,$,s),e(l,I,s),e(l,g,s),m(_,l,s),e(l,S,s),e(l,f,s),e(l,q,s),e(l,C,s),e(l,L,s),m(h,l,s),e(l,P,s),e(l,B,s),e(l,K,s),m(X,l,s),e(l,D,s),e(l,W,s),e(l,O,s),m(A,l,s),e(l,ll,s),e(l,v,s),e(l,sl,s),m(N,l,s),e(l,tl,s),m(Z,l,s),e(l,el,s),e(l,z,s),e(l,al,s),e(l,H,s),il=!0},p:Il,i(l){il||(T(y.$$.fragment,l),T(r.$$.fragment,l),T(_.$$.fragment,l),T(h.$$.fragment,l),T(X.$$.fragment,l),T(A.$$.fragment,l),T(N.$$.fragment,l),T(Z.$$.fragment,l),il=!0)},o(l){u(y.$$.fragment,l),u(r.$$.fragment,l),u(_.$$.fragment,l),u(h.$$.fragment,l),u(X.$$.fragment,l),u(A.$$.fragment,l),u(N.$$.fragment,l),u(Z.$$.fragment,l),il=!1},d(l){l&&(t(V),t(E),t(k),t(G),t(d),t(Y),t(j),t(Q),t(F),t(U),t(x),t(b),t($),t(I),t(g),t(S),t(f),t(q),t(C),t(L),t(P),t(B),t(K),t(D),t(W),t(O),t(ll),t(v),t(sl),t(tl),t(el),t(z),t(al),t(H)),t(c),w(y,l),w(r,l),w(_,l),w(h,l),w(X,l),w(A,l),w(N,l),w(Z,l)}}}const Wl='{"title":"Custom metric","local":"custom-metric","sections":[{"title":"How to define a custom metric","local":"how-to-define-a-custom-metric","sections":[],"depth":3},{"title":"Example of a custom metric","local":"example-of-a-custom-metric","sections":[],"depth":3}],"depth":1}';function Al(Ml){return _l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends fl{constructor(c){super(),Cl(this,c,Al,Xl,bl,{})}}export{El as component};
