import{s as Le,n as He,o as xe}from"../chunks/scheduler.9bc65507.js";import{S as ke,i as $e,g as s,s as a,r as te,A as Ue,h as l,f as i,c as o,j as ve,u as ie,x as r,k as Ce,y as Pe,a as n,v as ne,d as ae,t as oe,w as se}from"../chunks/index.707bf1b6.js";import{C as je}from"../chunks/CodeBlock.54a9f38d.js";import{H as le}from"../chunks/Heading.342b1fa6.js";function Je(re){let d,U,k,P,u,j,h,de="Transformers supports and integrates many quantization methods such as QLoRA, GPTQ, LLM.int8, and AWQ. However, there are other quantization approaches that are not yet integrated. To make adding and using these quantization methods with Transformers models easier, you should use the <code>HfQuantizer</code> class. The <code>HfQuantizer</code> is designed as an internal helper class for adding a quantization method instead of something you apply to every PyTorch module.",J,c,ue="This guide will show you how to integrate a new quantization method with the <code>HfQuantizer</code> class.",Q,m,I,p,he="Before integrating a new quantization method into Transformers, ensure the method you are trying to add meets the following prerequisites. Only quantization methods that can be run with PyTorch modules are currently supported.",A,f,ce="<li>The quantization method is available through a Python package that is pip-installable by anyone (it is also fine if you can only install the package from source). Ideally, pre-compiled kernels are included in the pip package.</li> <li>The method can run on commonly-used hardware (CPU, GPU, …).</li> <li>The method is wrapped in a <code>nn.Module</code> (e.g., <code>Linear8bitLt</code>, <code>Linear4bit</code>), and the quantized linear layer should have the following definition:</li>",W,y,Z,w,me="This way, Transformers models can be easily quantized by replacing some instances of <code>nn.Linear</code> with a target class.",B,_,pe="<li>The quantization method should be serializable. You can save the quantized weights locally or push them to the Hub.</li> <li>Make sure the package that contains the quantization kernels/primitive is stable (no frequent breaking changes).</li>",Y,q,fe="For some quantization methods, they may require “pre-quantizing” the models through data calibration (e.g., AWQ). In this case, we prefer to only support inference in Transformers and let the third-party library maintained by the ML community deal with the model quantization itself.",F,z,S,T,ye="<li>📕 Create a new quantization config class inside <code>src/transformers/utils/quantization_config.py</code> and make sure to expose the new quantization config inside Transformers main <code>init</code> by adding it to the <code>_import_structure</code> object of <code>src/transformers/__init__.py</code>.</li>",E,g,we="2-  🗃 Create a new file inside <code>src/transformers/quantizers/</code> named <code>quantizer_your_method.py</code>, and make it inherit from <code>src/transformers/quantizers/base.py::HfQuantizer</code>. Make sure to add the new quantizer and quantization config in the quantization auto-mapping in <code>src/transformers/quantizers/auto.py</code>",G,M,_e="3- 🔩 Define the following class attributes/property methods for your quantization method:",X,b,qe="<li><code>requires_calibration</code>: Whether the quantization method requires a data calibration process. If set to <code>True</code>, you can only support inference (with quantized weights) and not inference and quantization.</li> <li><code>required_packages</code>: A list of strings of the required packages to use the quantized weights. You might need to define some new utility methods such as <code>is_auto_awq_available</code> in <code>transformers/src/utils/import_utils.py</code>.</li> <li><code>requires_parameters_quantization</code>: Only required if your quantization method requires extra attention to the underlying <code>nn.Parameter</code> object. For example, bitsandbytes uses <code>Params4bit</code> and <code>Int8Param</code>, which requires some extra attention when quantizing the model. Most of the recent quantization method packs int2/int4 weights inside <code>torch.uint8</code> weights, so this flag should not be really required (set to <code>False</code> by default).</li> <li><code>is_serializable</code>: A property method to determine whether the method is serializable or not.</li> <li><code>is_trainable</code>:  A property method to determine whether you can fine-tune models on top of the quantization method (with or without PEFT approaches).</li>",R,v,ze="4- 🪛 Write the <code>validate_environment</code> and <code>update_torch_dtype</code> methods. These methods are called before creating the quantized model to ensure users use the right configuration. You can have a look at how this is done on other quantizers.",D,C,Te="5- 🖋 Write the <code>_process_model_before_weight_loading</code> method. In Transformers, the quantized models are initialized first on the <code>&quot;meta&quot;</code> device before loading the weights. This means the <code>_process_model_before_weight_loading</code> method takes care of manipulating the model skeleton to replace some modules (e.g., <code>nn.Linear</code>) with the target modules (quantization modules). You can define a module replacement logic or any other utility method by creating a new file in <code>transformers/src/integrations/</code> and exposing the relevant methods in that folder’s <code>__init__.py</code> file. The best starting point would be to have a look at another quantization methods such as <code>quantizer_awq.py</code>",V,L,ge="6- 🖊 Write the <code>_process_model_after_weight_loading</code> method. This method enables implementing additional features that require manipulating the model after loading the weights.",K,H,Me="7- 📖 Document everything! Make sure your quantization method is documented in the <code>docs/source/en/quantization.md</code> file.",N,x,be="8- 🟢 Add tests! You should add tests by first adding the package in our nightly Dockerfile inside <code>docker/transformers-all-latest-gpu</code> and then adding a new test file in <code>tests/quantization/xxx</code>. Feel free to check out how it is implemented for other quantization methods.",O,$,ee;return u=new le({props:{title:"Contribute new quantization method",local:"contribute-new-quantization-method",headingTag:"h1"}}),m=new le({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),y=new je({props:{code:"Y2xhc3MlMjBMaW5lYXI0Yml0KG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwLi4uKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbXlfNGJpdF9rZXJuZWwoeCUyQyUyMHNlbGYud2VpZ2h0JTJDJTIwc2VsZi5iaWFzKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Linear4bit</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, ...</span>):
        ...
    
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> my_4bit_kernel(x, self.weight, self.bias)`,wrap:!1}}),z=new le({props:{title:"Build a new HFQuantizer class",local:"build-a-new-hfquantizer-class",headingTag:"h2"}}),{c(){d=s("meta"),U=a(),k=s("p"),P=a(),te(u.$$.fragment),j=a(),h=s("p"),h.innerHTML=de,J=a(),c=s("p"),c.innerHTML=ue,Q=a(),te(m.$$.fragment),I=a(),p=s("p"),p.textContent=he,A=a(),f=s("ul"),f.innerHTML=ce,W=a(),te(y.$$.fragment),Z=a(),w=s("p"),w.innerHTML=me,B=a(),_=s("ul"),_.innerHTML=pe,Y=a(),q=s("p"),q.textContent=fe,F=a(),te(z.$$.fragment),S=a(),T=s("ol"),T.innerHTML=ye,E=a(),g=s("p"),g.innerHTML=we,G=a(),M=s("p"),M.textContent=_e,X=a(),b=s("ul"),b.innerHTML=qe,R=a(),v=s("p"),v.innerHTML=ze,D=a(),C=s("p"),C.innerHTML=Te,V=a(),L=s("p"),L.innerHTML=ge,K=a(),H=s("p"),H.innerHTML=Me,N=a(),x=s("p"),x.innerHTML=be,O=a(),$=s("p"),this.h()},l(e){const t=Ue("svelte-u9bgzb",document.head);d=l(t,"META",{name:!0,content:!0}),t.forEach(i),U=o(e),k=l(e,"P",{}),ve(k).forEach(i),P=o(e),ie(u.$$.fragment,e),j=o(e),h=l(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1pq1qlp"&&(h.innerHTML=de),J=o(e),c=l(e,"P",{"data-svelte-h":!0}),r(c)!=="svelte-z2f8d2"&&(c.innerHTML=ue),Q=o(e),ie(m.$$.fragment,e),I=o(e),p=l(e,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1r9sp5d"&&(p.textContent=he),A=o(e),f=l(e,"UL",{"data-svelte-h":!0}),r(f)!=="svelte-6z9s8p"&&(f.innerHTML=ce),W=o(e),ie(y.$$.fragment,e),Z=o(e),w=l(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-e9o9mb"&&(w.innerHTML=me),B=o(e),_=l(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-yqp59g"&&(_.innerHTML=pe),Y=o(e),q=l(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1e8yc6a"&&(q.textContent=fe),F=o(e),ie(z.$$.fragment,e),S=o(e),T=l(e,"OL",{"data-svelte-h":!0}),r(T)!=="svelte-1mpvy66"&&(T.innerHTML=ye),E=o(e),g=l(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1bwn5fn"&&(g.innerHTML=we),G=o(e),M=l(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1jrokjm"&&(M.textContent=_e),X=o(e),b=l(e,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-10zphqj"&&(b.innerHTML=qe),R=o(e),v=l(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-andb8l"&&(v.innerHTML=ze),D=o(e),C=l(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1ttt0gz"&&(C.innerHTML=Te),V=o(e),L=l(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-mcchvm"&&(L.innerHTML=ge),K=o(e),H=l(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-10a1t71"&&(H.innerHTML=Me),N=o(e),x=l(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1sdyw3f"&&(x.innerHTML=be),O=o(e),$=l(e,"P",{}),ve($).forEach(i),this.h()},h(){Ce(d,"name","hf:doc:metadata"),Ce(d,"content",Qe)},m(e,t){Pe(document.head,d),n(e,U,t),n(e,k,t),n(e,P,t),ne(u,e,t),n(e,j,t),n(e,h,t),n(e,J,t),n(e,c,t),n(e,Q,t),ne(m,e,t),n(e,I,t),n(e,p,t),n(e,A,t),n(e,f,t),n(e,W,t),ne(y,e,t),n(e,Z,t),n(e,w,t),n(e,B,t),n(e,_,t),n(e,Y,t),n(e,q,t),n(e,F,t),ne(z,e,t),n(e,S,t),n(e,T,t),n(e,E,t),n(e,g,t),n(e,G,t),n(e,M,t),n(e,X,t),n(e,b,t),n(e,R,t),n(e,v,t),n(e,D,t),n(e,C,t),n(e,V,t),n(e,L,t),n(e,K,t),n(e,H,t),n(e,N,t),n(e,x,t),n(e,O,t),n(e,$,t),ee=!0},p:He,i(e){ee||(ae(u.$$.fragment,e),ae(m.$$.fragment,e),ae(y.$$.fragment,e),ae(z.$$.fragment,e),ee=!0)},o(e){oe(u.$$.fragment,e),oe(m.$$.fragment,e),oe(y.$$.fragment,e),oe(z.$$.fragment,e),ee=!1},d(e){e&&(i(U),i(k),i(P),i(j),i(h),i(J),i(c),i(Q),i(I),i(p),i(A),i(f),i(W),i(Z),i(w),i(B),i(_),i(Y),i(q),i(F),i(S),i(T),i(E),i(g),i(G),i(M),i(X),i(b),i(R),i(v),i(D),i(C),i(V),i(L),i(K),i(H),i(N),i(x),i(O),i($)),i(d),se(u,e),se(m,e),se(y,e),se(z,e)}}}const Qe='{"title":"Contribute new quantization method","local":"contribute-new-quantization-method","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Build a new HFQuantizer class","local":"build-a-new-hfquantizer-class","sections":[],"depth":2}],"depth":1}';function Ie(re){return xe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ye extends ke{constructor(d){super(),$e(this,d,Ie,Je,Le,{})}}export{Ye as component};
