import{s as zl,n as Bl,o as Vl}from"../chunks/scheduler.9bc65507.js";import{S as Wl,i as Rl,g as p,s as e,r as m,A as El,h as i,f as a,c as n,j as _l,u as j,x as M,k as vl,y as ql,a as t,v as c,d as o,t as U,w as h}from"../chunks/index.707bf1b6.js";import{C as r}from"../chunks/CodeBlock.54a9f38d.js";import{H as ms}from"../chunks/Heading.342b1fa6.js";function Hl(il){let J,os,js,Us,y,hs,T,rs,g,Ml=`LLM（Language Model）のますます一般的な使用事例の1つは「チャット」です。
チャットのコンテキストでは、通常の言語モデルのように単一のテキストストリングを継続するのではなく、モデルは1つ以上の「メッセージ」からなる会話を継続します。
各メッセージには「ロール」とメッセージテキストが含まれます。`,Js,w,ml=`最も一般的に、これらのロールはユーザーからのメッセージには「ユーザー」、モデルからのメッセージには「アシスタント」が割り当てられます。
一部のモデルは「システム」ロールもサポートしています。
システムメッセージは通常会話の開始時に送信され、モデルの動作方法に関する指示が含まれます。`,ys,d,jl=`すべての言語モデル、チャット用に微調整されたモデルを含むすべてのモデルは、トークンのリニアシーケンスで動作し、ロールに特有の特別な処理を持ちません。
つまり、ロール情報は通常、メッセージ間に制御トークンを追加して注入され、メッセージの境界と関連するロールを示すことで提供されます。`,Ts,I,cl=`残念ながら、トークンの使用方法については（まだ！）標準が存在せず、異なるモデルはチャット用のフォーマットや制御トークンが大きく異なる形式でトレーニングされています。
これはユーザーにとって実際の問題になる可能性があります。正しいフォーマットを使用しないと、モデルは入力に混乱し、パフォーマンスが本来よりも遥かに低下します。
これが「チャットテンプレート」が解決しようとする問題です。`,gs,u,ol=`チャット会話は通常、各辞書が「ロール」と「コンテンツ」のキーを含み、単一のチャットメッセージを表すリストとして表現されます。
チャットテンプレートは、指定されたモデルの会話を単一のトークン化可能なシーケンスにどのようにフォーマットするかを指定するJinjaテンプレートを含む文字列です。
トークナイザとこの情報を保存することにより、モデルが期待する形式の入力データを取得できるようになります。`,ws,C,Ul="さっそく、<code>BlenderBot</code> モデルを使用した例を示して具体的にしましょう。<code>BlenderBot</code> のデフォルトテンプレートは非常にシンプルで、ほとんどが対話のラウンド間に空白を追加するだけです。",ds,f,Is,x,hl=`指定された通り、チャット全体が単一の文字列にまとめられています。デフォルトの設定である「tokenize=True」を使用すると、
その文字列もトークン化されます。しかし、より複雑なテンプレートが実際にどのように機能するかを確認するために、
「meta-llama/Llama-2-7b-chat-hf」モデルを使用してみましょう。ただし、このモデルはゲート付きアクセスを持っており、
このコードを実行する場合は<a href="https://huggingface.co/meta-llama/Llama-2-7b-chat-hf" rel="nofollow">リポジトリでアクセスをリクエスト</a>する必要があります。`,us,b,Cs,N,rl="今回、トークナイザは制御トークン [INST] と [/INST] を追加しました。これらはユーザーメッセージの開始と終了を示すためのものです（ただし、アシスタントメッセージには適用されません！）",fs,Q,xs,A,Jl="モデルのチャットテンプレートは、<code>tokenizer.chat_template</code>属性に格納されています。チャットテンプレートが設定されていない場合、そのモデルクラスのデフォルトテンプレートが代わりに使用されます。<code>BlenderBot</code>のテンプレートを見てみましょう:",bs,$,Ns,Z,yl=`これは少し抑圧的ですね。可読性を高めるために、新しい行とインデントを追加しましょう。
各ブロックの直前の空白と、ブロックの直後の最初の改行は、デフォルトでJinjaの <code>trim_blocks</code> および <code>lstrip_blocks</code> フラグを使用して削除します。
これにより、インデントと改行を含むテンプレートを書いても正常に機能することができます。`,Qs,k,As,S,Tl=`これが初めて見る方へ、これは<a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinjaテンプレート</a>です。
Jinjaはテキストを生成するためのシンプルなコードを記述できるテンプレート言語です。多くの点で、コードと
構文はPythonに似ています。純粋なPythonでは、このテンプレートは次のようになるでしょう：`,$s,G,Zs,_,gl="実際に、このテンプレートは次の3つのことを行います：",ks,v,wl="<li>各メッセージに対して、メッセージがユーザーメッセージである場合、それの前に空白を追加し、それ以外の場合は何も表示しません。</li> <li>メッセージの内容を追加します。</li> <li>メッセージが最後のメッセージでない場合、その後に2つのスペースを追加します。最後のメッセージの後にはEOSトークンを表示します。</li>",Ss,z,dl=`これは非常にシンプルなテンプレートです。制御トークンを追加しないし、モデルに対する指示を伝える一般的な方法である「システム」メッセージをサポートしていません。
ただし、Jinjaはこれらのことを行うための多くの柔軟性を提供しています！
LLaMAがフォーマットする方法に類似した入力をフォーマットするためのJinjaテンプレートを見てみましょう
（実際のLLaMAテンプレートはデフォルトのシステムメッセージの処理や、一般的なシステムメッセージの処理が若干異なるため、
実際のコードではこのテンプレートを使用しないでください！）`,Gs,B,_s,V,Il=`願わくば、少し見つめていただければ、このテンプレートが何を行っているかがわかるかもしれません。
このテンプレートは、各メッセージの「役割」に基づいて特定のトークンを追加します。これらのトークンは、メッセージを送信した人を表すものです。
ユーザー、アシスタント、およびシステムメッセージは、それらが含まれるトークンによってモデルによって明確に区別されます。`,vs,W,zs,R,ul=`簡単です。単純にJinjaテンプレートを書いて、<code>tokenizer.chat_template</code>を設定します。
他のモデルから既存のテンプレートを始点にして、必要に応じて編集すると便利かもしれません！
例えば、上記のLLaMAテンプレートを取って、アシスタントメッセージに”[ASST]“と”[/ASST]“を追加できます。`,Bs,E,Vs,q,Cl=`次に、単に<code>tokenizer.chat_template</code>属性を設定してください。
次回、<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>を使用する際に、新しいテンプレートが使用されます！
この属性は<code>tokenizer_config.json</code>ファイルに保存されるため、<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a>を使用して
新しいテンプレートをHubにアップロードし、みんなが正しいテンプレートを使用していることを確認できます！`,Ws,H,Rs,X,fl=`<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> メソッドは、あなたのチャットテンプレートを使用するために <a href="/docs/transformers/main/ja/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a> クラスによって呼び出されます。
したがって、正しいチャットテンプレートを設定すると、あなたのモデルは自動的に <a href="/docs/transformers/main/ja/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a> と互換性があるようになります。`,Es,F,qs,Y,xl=`チャットテンプレートの導入前に、チャットの処理はモデルクラスレベルでハードコードされていました。
後方互換性のために、このクラス固有の処理をデフォルトテンプレートとして保持し、クラスレベルで設定されています。
モデルにチャットテンプレートが設定されていない場合、ただしモデルクラスのデフォルトテンプレートがある場合、
<code>ConversationalPipeline</code>クラスや<code>apply_chat_template</code>などのメソッドはクラステンプレートを使用します。
トークナイザのデフォルトのチャットテンプレートを確認するには、<code>tokenizer.default_chat_template</code>属性をチェックしてください。`,Hs,L,bl=`これは、後方互換性のために純粋に行っていることで、既存のワークフローを壊さないようにしています。
モデルにとってクラステンプレートが適切である場合でも、デフォルトテンプレートをオーバーライドして
<code>chat_template</code>属性を明示的に設定することを強くお勧めします。これにより、ユーザーにとって
モデルがチャット用に正しく構成されていることが明確になり、デフォルトテンプレートが変更されたり廃止された場合に備えることができます。`,Xs,P,Fs,D,Nl=`すでにチャットのトレーニングを受けたモデルのテンプレートを設定する場合、テンプレートがトレーニング中にモデルが見たメッセージのフォーマットとまったく一致することを確認する必要があります。
そうでない場合、性能の低下を経験する可能性が高いです。これはモデルをさらにトレーニングしている場合でも同様です - チャットトークンを一定に保つと、おそらく最高の性能が得られます。
これはトークン化と非常に類似しており、通常はトレーニング中に使用されたトークン化と正確に一致する場合に、推論またはファインチューニングの際に最良の性能が得られます。`,Ys,K,Ql=`一方、ゼロからモデルをトレーニングするか、チャットのためにベース言語モデルをファインチューニングする場合、適切なテンプレートを選択する自由度があります。
LLM（Language Model）はさまざまな入力形式を処理できるほどスマートです。クラス固有のテンプレートがないモデル用のデフォルトテンプレートは、一般的なユースケースに対して良い柔軟な選択肢です。
これは、<a href="https://github.com/openai/openai-python/blob/main/chatml.md" rel="nofollow">ChatMLフォーマット</a>に従ったもので、多くのユースケースに適しています。次のようになります：`,Ls,O,Ps,ss,Al="If you like this one, here it is in one-liner form, ready to copy into your code:",Ds,ls,Ks,as,$l=`このテンプレートは、各メッセージを「“」トークンで囲み、役割を文字列として単純に記述します。
これにより、トレーニングで使用する役割に対する柔軟性が得られます。出力は以下のようになります：`,Os,ts,sl,es,Zl=`「ユーザー」、「システム」、および「アシスタント」の役割は、チャットの標準です。
特に、<a href="/docs/transformers/main/ja/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>との連携をスムーズに行う場合には、これらの役割を使用することをお勧めします。ただし、これらの役割に制約はありません。テンプレートは非常に柔軟で、任意の文字列を役割として使用できます。`,ll,ns,al,ps,kl=`チャットモデルを持っている場合、そのモデルの<code>tokenizer.chat_template</code>属性を設定し、<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>を使用してテストする必要があります。
これはモデルの所有者でない場合でも適用されます。モデルのリポジトリが空のチャットテンプレートを使用している場合、またはデフォルトのクラステンプレートを使用している場合でも、
この属性を適切に設定できるように<a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">プルリクエスト</a>を開いてください。`,tl,is,Sl=`一度属性が設定されれば、それで完了です！ <code>tokenizer.apply_chat_template</code>は、そのモデルに対して正しく動作するようになります。これは、
<code>ConversationalPipeline</code>などの場所でも自動的にサポートされます。`,el,Ms,Gl=`モデルがこの属性を持つことを確認することで、オープンソースモデルの全コミュニティがそのフルパワーを使用できるようになります。
フォーマットの不一致はこの分野に悩み続け、パフォーマンスに黙って影響を与えてきました。それを終わらせる時が来ました！`,nl,cs,pl;return y=new ms({props:{title:"Templates for Chat Models",local:"templates-for-chat-models",headingTag:"h1"}}),T=new ms({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),f=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),b=new r({props:{code:"JTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGVsbG8lMkMlMjBob3clMjBhcmUlMjB5b3UlM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknZCUyMGxpa2UlMjB0byUyMHNob3clMjBvZmYlMjBob3clMjBjaGF0JTIwdGVtcGxhdGluZyUyMHdvcmtzISUyMiU3RCUyQyUwQSU1RCUwQQ==",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

&gt;&gt; chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

&gt;&gt; tokenizer.use_default_system_prompt = <span class="hljs-literal">False</span>
&gt;&gt; tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST] I&#x27;m doing great. How can I help you today? &lt;/s&gt;&lt;s&gt;[INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),Q=new ms({props:{title:"How do chat templates work?",local:"how-do-chat-templates-work",headingTag:"h2"}}),$=new r({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),k=new r({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),G=new r({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),B=new r({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),W=new ms({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h2"}}),E=new r({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),H=new r({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),F=new ms({props:{title:"What are “default” templates?",local:"what-are-default-templates",headingTag:"h2"}}),P=new ms({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h2"}}),O=new r({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),ls=new r({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTIy",highlighted:'<span class="language-xml">tokenizer.chat_template = &quot;</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">&quot;</span>',wrap:!1}}),ts=new r({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|<span class="hljs-type">im_start</span>|<span class="hljs-type">&gt;system</span>
You are a helpful chatbot that will <span class="hljs-built_in">do</span> its best not to say anything so stupid that people tweet about it.&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;user</span>
How are you?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>
I&#x27;m doing great!&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),ns=new ms({props:{title:"I want to use chat templates! How should I get started?",local:"i-want-to-use-chat-templates-how-should-i-get-started",headingTag:"h2"}}),{c(){J=p("meta"),os=e(),js=p("p"),Us=e(),m(y.$$.fragment),hs=e(),m(T.$$.fragment),rs=e(),g=p("p"),g.textContent=Ml,Js=e(),w=p("p"),w.textContent=ml,ys=e(),d=p("p"),d.textContent=jl,Ts=e(),I=p("p"),I.textContent=cl,gs=e(),u=p("p"),u.textContent=ol,ws=e(),C=p("p"),C.innerHTML=Ul,ds=e(),m(f.$$.fragment),Is=e(),x=p("p"),x.innerHTML=hl,us=e(),m(b.$$.fragment),Cs=e(),N=p("p"),N.textContent=rl,fs=e(),m(Q.$$.fragment),xs=e(),A=p("p"),A.innerHTML=Jl,bs=e(),m($.$$.fragment),Ns=e(),Z=p("p"),Z.innerHTML=yl,Qs=e(),m(k.$$.fragment),As=e(),S=p("p"),S.innerHTML=Tl,$s=e(),m(G.$$.fragment),Zs=e(),_=p("p"),_.textContent=gl,ks=e(),v=p("ol"),v.innerHTML=wl,Ss=e(),z=p("p"),z.textContent=dl,Gs=e(),m(B.$$.fragment),_s=e(),V=p("p"),V.textContent=Il,vs=e(),m(W.$$.fragment),zs=e(),R=p("p"),R.innerHTML=ul,Bs=e(),m(E.$$.fragment),Vs=e(),q=p("p"),q.innerHTML=Cl,Ws=e(),m(H.$$.fragment),Rs=e(),X=p("p"),X.innerHTML=fl,Es=e(),m(F.$$.fragment),qs=e(),Y=p("p"),Y.innerHTML=xl,Hs=e(),L=p("p"),L.innerHTML=bl,Xs=e(),m(P.$$.fragment),Fs=e(),D=p("p"),D.textContent=Nl,Ys=e(),K=p("p"),K.innerHTML=Ql,Ls=e(),m(O.$$.fragment),Ps=e(),ss=p("p"),ss.textContent=Al,Ds=e(),m(ls.$$.fragment),Ks=e(),as=p("p"),as.textContent=$l,Os=e(),m(ts.$$.fragment),sl=e(),es=p("p"),es.innerHTML=Zl,ll=e(),m(ns.$$.fragment),al=e(),ps=p("p"),ps.innerHTML=kl,tl=e(),is=p("p"),is.innerHTML=Sl,el=e(),Ms=p("p"),Ms.textContent=Gl,nl=e(),cs=p("p"),this.h()},l(s){const l=El("svelte-u9bgzb",document.head);J=i(l,"META",{name:!0,content:!0}),l.forEach(a),os=n(s),js=i(s,"P",{}),_l(js).forEach(a),Us=n(s),j(y.$$.fragment,s),hs=n(s),j(T.$$.fragment,s),rs=n(s),g=i(s,"P",{"data-svelte-h":!0}),M(g)!=="svelte-jcsv73"&&(g.textContent=Ml),Js=n(s),w=i(s,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1mxrdfa"&&(w.textContent=ml),ys=n(s),d=i(s,"P",{"data-svelte-h":!0}),M(d)!=="svelte-cfkcz6"&&(d.textContent=jl),Ts=n(s),I=i(s,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1bxzw8o"&&(I.textContent=cl),gs=n(s),u=i(s,"P",{"data-svelte-h":!0}),M(u)!=="svelte-s4iwrm"&&(u.textContent=ol),ws=n(s),C=i(s,"P",{"data-svelte-h":!0}),M(C)!=="svelte-16z6my6"&&(C.innerHTML=Ul),ds=n(s),j(f.$$.fragment,s),Is=n(s),x=i(s,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1fy4nei"&&(x.innerHTML=hl),us=n(s),j(b.$$.fragment,s),Cs=n(s),N=i(s,"P",{"data-svelte-h":!0}),M(N)!=="svelte-5sqrb2"&&(N.textContent=rl),fs=n(s),j(Q.$$.fragment,s),xs=n(s),A=i(s,"P",{"data-svelte-h":!0}),M(A)!=="svelte-pa95ib"&&(A.innerHTML=Jl),bs=n(s),j($.$$.fragment,s),Ns=n(s),Z=i(s,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-nbi27v"&&(Z.innerHTML=yl),Qs=n(s),j(k.$$.fragment,s),As=n(s),S=i(s,"P",{"data-svelte-h":!0}),M(S)!=="svelte-2fl0dp"&&(S.innerHTML=Tl),$s=n(s),j(G.$$.fragment,s),Zs=n(s),_=i(s,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1gikd0q"&&(_.textContent=gl),ks=n(s),v=i(s,"OL",{"data-svelte-h":!0}),M(v)!=="svelte-13hrl3j"&&(v.innerHTML=wl),Ss=n(s),z=i(s,"P",{"data-svelte-h":!0}),M(z)!=="svelte-7a7s95"&&(z.textContent=dl),Gs=n(s),j(B.$$.fragment,s),_s=n(s),V=i(s,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1sw12sq"&&(V.textContent=Il),vs=n(s),j(W.$$.fragment,s),zs=n(s),R=i(s,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1706a1k"&&(R.innerHTML=ul),Bs=n(s),j(E.$$.fragment,s),Vs=n(s),q=i(s,"P",{"data-svelte-h":!0}),M(q)!=="svelte-5f4e0f"&&(q.innerHTML=Cl),Ws=n(s),j(H.$$.fragment,s),Rs=n(s),X=i(s,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1a90mho"&&(X.innerHTML=fl),Es=n(s),j(F.$$.fragment,s),qs=n(s),Y=i(s,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-tbutjc"&&(Y.innerHTML=xl),Hs=n(s),L=i(s,"P",{"data-svelte-h":!0}),M(L)!=="svelte-t6wo99"&&(L.innerHTML=bl),Xs=n(s),j(P.$$.fragment,s),Fs=n(s),D=i(s,"P",{"data-svelte-h":!0}),M(D)!=="svelte-ixwipa"&&(D.textContent=Nl),Ys=n(s),K=i(s,"P",{"data-svelte-h":!0}),M(K)!=="svelte-rms13q"&&(K.innerHTML=Ql),Ls=n(s),j(O.$$.fragment,s),Ps=n(s),ss=i(s,"P",{"data-svelte-h":!0}),M(ss)!=="svelte-33pzk5"&&(ss.textContent=Al),Ds=n(s),j(ls.$$.fragment,s),Ks=n(s),as=i(s,"P",{"data-svelte-h":!0}),M(as)!=="svelte-14x3uea"&&(as.textContent=$l),Os=n(s),j(ts.$$.fragment,s),sl=n(s),es=i(s,"P",{"data-svelte-h":!0}),M(es)!=="svelte-1fdadrb"&&(es.innerHTML=Zl),ll=n(s),j(ns.$$.fragment,s),al=n(s),ps=i(s,"P",{"data-svelte-h":!0}),M(ps)!=="svelte-107rof1"&&(ps.innerHTML=kl),tl=n(s),is=i(s,"P",{"data-svelte-h":!0}),M(is)!=="svelte-1ufv0c0"&&(is.innerHTML=Sl),el=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),M(Ms)!=="svelte-16sk2j3"&&(Ms.textContent=Gl),nl=n(s),cs=i(s,"P",{}),_l(cs).forEach(a),this.h()},h(){vl(J,"name","hf:doc:metadata"),vl(J,"content",Xl)},m(s,l){ql(document.head,J),t(s,os,l),t(s,js,l),t(s,Us,l),c(y,s,l),t(s,hs,l),c(T,s,l),t(s,rs,l),t(s,g,l),t(s,Js,l),t(s,w,l),t(s,ys,l),t(s,d,l),t(s,Ts,l),t(s,I,l),t(s,gs,l),t(s,u,l),t(s,ws,l),t(s,C,l),t(s,ds,l),c(f,s,l),t(s,Is,l),t(s,x,l),t(s,us,l),c(b,s,l),t(s,Cs,l),t(s,N,l),t(s,fs,l),c(Q,s,l),t(s,xs,l),t(s,A,l),t(s,bs,l),c($,s,l),t(s,Ns,l),t(s,Z,l),t(s,Qs,l),c(k,s,l),t(s,As,l),t(s,S,l),t(s,$s,l),c(G,s,l),t(s,Zs,l),t(s,_,l),t(s,ks,l),t(s,v,l),t(s,Ss,l),t(s,z,l),t(s,Gs,l),c(B,s,l),t(s,_s,l),t(s,V,l),t(s,vs,l),c(W,s,l),t(s,zs,l),t(s,R,l),t(s,Bs,l),c(E,s,l),t(s,Vs,l),t(s,q,l),t(s,Ws,l),c(H,s,l),t(s,Rs,l),t(s,X,l),t(s,Es,l),c(F,s,l),t(s,qs,l),t(s,Y,l),t(s,Hs,l),t(s,L,l),t(s,Xs,l),c(P,s,l),t(s,Fs,l),t(s,D,l),t(s,Ys,l),t(s,K,l),t(s,Ls,l),c(O,s,l),t(s,Ps,l),t(s,ss,l),t(s,Ds,l),c(ls,s,l),t(s,Ks,l),t(s,as,l),t(s,Os,l),c(ts,s,l),t(s,sl,l),t(s,es,l),t(s,ll,l),c(ns,s,l),t(s,al,l),t(s,ps,l),t(s,tl,l),t(s,is,l),t(s,el,l),t(s,Ms,l),t(s,nl,l),t(s,cs,l),pl=!0},p:Bl,i(s){pl||(o(y.$$.fragment,s),o(T.$$.fragment,s),o(f.$$.fragment,s),o(b.$$.fragment,s),o(Q.$$.fragment,s),o($.$$.fragment,s),o(k.$$.fragment,s),o(G.$$.fragment,s),o(B.$$.fragment,s),o(W.$$.fragment,s),o(E.$$.fragment,s),o(H.$$.fragment,s),o(F.$$.fragment,s),o(P.$$.fragment,s),o(O.$$.fragment,s),o(ls.$$.fragment,s),o(ts.$$.fragment,s),o(ns.$$.fragment,s),pl=!0)},o(s){U(y.$$.fragment,s),U(T.$$.fragment,s),U(f.$$.fragment,s),U(b.$$.fragment,s),U(Q.$$.fragment,s),U($.$$.fragment,s),U(k.$$.fragment,s),U(G.$$.fragment,s),U(B.$$.fragment,s),U(W.$$.fragment,s),U(E.$$.fragment,s),U(H.$$.fragment,s),U(F.$$.fragment,s),U(P.$$.fragment,s),U(O.$$.fragment,s),U(ls.$$.fragment,s),U(ts.$$.fragment,s),U(ns.$$.fragment,s),pl=!1},d(s){s&&(a(os),a(js),a(Us),a(hs),a(rs),a(g),a(Js),a(w),a(ys),a(d),a(Ts),a(I),a(gs),a(u),a(ws),a(C),a(ds),a(Is),a(x),a(us),a(Cs),a(N),a(fs),a(xs),a(A),a(bs),a(Ns),a(Z),a(Qs),a(As),a(S),a($s),a(Zs),a(_),a(ks),a(v),a(Ss),a(z),a(Gs),a(_s),a(V),a(vs),a(zs),a(R),a(Bs),a(Vs),a(q),a(Ws),a(Rs),a(X),a(Es),a(qs),a(Y),a(Hs),a(L),a(Xs),a(Fs),a(D),a(Ys),a(K),a(Ls),a(Ps),a(ss),a(Ds),a(Ks),a(as),a(Os),a(sl),a(es),a(ll),a(al),a(ps),a(tl),a(is),a(el),a(Ms),a(nl),a(cs)),a(J),h(y,s),h(T,s),h(f,s),h(b,s),h(Q,s),h($,s),h(k,s),h(G,s),h(B,s),h(W,s),h(E,s),h(H,s),h(F,s),h(P,s),h(O,s),h(ls,s),h(ts,s),h(ns,s)}}}const Xl='{"title":"Templates for Chat Models","local":"templates-for-chat-models","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do chat templates work?","local":"how-do-chat-templates-work","sections":[],"depth":2},{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":2},{"title":"What are “default” templates?","local":"what-are-default-templates","sections":[],"depth":2},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":2},{"title":"I want to use chat templates! How should I get started?","local":"i-want-to-use-chat-templates-how-should-i-get-started","sections":[],"depth":2}],"depth":1}';function Fl(il){return Vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kl extends Wl{constructor(J){super(),Rl(this,J,Fl,Hl,zl,{})}}export{Kl as component};
