import{s as il,n as rl,o as pl}from"../chunks/scheduler.9039eef2.js";import{S as cl,i as dl,g as o,s as n,r as p,A as ml,h as i,f as a,c as l,j as $e,u as c,x as r,k as Ge,l as ol,y as ke,a as s,v as d,d as m,t as u,w as M}from"../chunks/index.ded8f90d.js";import{D as Ys}from"../chunks/Docstring.a2ba2b54.js";import{C as h}from"../chunks/CodeBlock.8580f3e8.js";import{H as y}from"../chunks/Heading.f027f30d.js";function ul(Ls){let f,Ze,xe,Re,b,Be,J,Ds="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",qe,_,Ps='Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.',Xe,k,ze,C,Os=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,Qe,I,We,v,Ks="Make sure to pass a correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",Ee,x,tn="You can also construct a model outside of the trainer and pass it as follows:",Ve,F,Ne,$,en='The above snippets will use the default training arguments from the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow"><code>transformers.TrainingArguments</code></a> class. If you want to modify that, make sure to create your own <code>TrainingArguments</code> object and pass it to the <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> constructor as it is done on the <a href="https://github.com/huggingface/trl/blob/main/examples/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>supervised_finetuning.py</code> script</a> on the stack-llama example.',Se,G,Ae,Z,He,R,an=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,Ye,B,Le,q,sn="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",De,X,Pe,z,nn="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",Oe,Q,Ke,W,ln="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending whether they have context or not. For example:",ta,E,ea,V,on="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",aa,N,rn="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",sa,S,pn="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",na,A,la,H,cn="To solve this, you can tokenize the <code>response_template</code> with the same context than in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",oa,Y,ia,L,ra,D,dn=`Adding special tokens to a language model is crucial for training chat models. These tokens are added between the different roles in a conversation, such as the user, assistant, and system and help the model recognize the structure and flow of a conversation. This setup is essential for enabling the model to generate coherent and contextually appropriate responses in a chat environment.
The <code>setup_chat_format()</code> function in <code>trl</code> easily sets up a model and tokenizer for conversational AI tasks. This function:`,pa,P,mn='<li>Adds special tokens to the tokenizer, e.g. <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code>, to indicate the start and end of a conversation.</li> <li>Resizes the model’s embedding layer to accommodate the new tokens.</li> <li>Sets the <code>chat_template</code> of the tokenizer, which is used to format the input data into a chat-like format. The default is <code>chatml</code> from OpenAI.</li> <li><em>optionally</em> you can pass <code>resize_to_multiple_of</code> to resize the embedding layer to a multiple of the <code>resize_to_multiple_of</code> argument, e.g. 64. If you want to see more formats being supported in the future, please open a GitHub issue on <a href="https://github.com/huggingface/trl" rel="nofollow">trl</a></li>',ca,O,da,K,un="With our model and tokenizer set up, we can now fine-tune our model on a conversational dataset. Below is an example of how a dataset can be formatted for fine-tuning.",ma,tt,ua,et,Mn='The <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports popular dataset formats. This allows you to pass the dataset to the trainer without any pre-processing directly. The following formats are supported:',Ma,at,hn="<li>conversational format</li>",ha,st,ya,nt,yn="<li>instruction format</li>",fa,lt,Ta,ot,fn='If your dataset uses one of the above formats, you can directly pass it to the trainer without pre-processing. The <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> will then format the dataset for you using the defined format from the model’s tokenizer with the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#templates-for-chat-models" rel="nofollow">apply_chat_template</a> method.',ga,it,Ua,rt,Tn="If the dataset is not in one those format you can either preprocess the dataset to match the formatting or pass a formatting function to the SFTTrainer to do it for you. Let’s have a look.",ja,pt,wa,ct,gn=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,ba,dt,Ja,mt,Un="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",_a,ut,ka,Mt,jn='To properly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example on how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',Ca,ht,Ia,yt,wn='<a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> constructor.',va,ft,xa,Tt,bn="Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.",Fa,gt,$a,Ut,Jn="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",Ga,jt,Za,wt,_n='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> constructor. Please refer to that class’ signature for more information.',Ra,bt,Ba,Jt,kn='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>. For example, if you want to load a model in a different precision, analogous to',qa,_t,Xa,kt,za,Ct,Cn="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",Qa,It,Wa,vt,In="We also support a tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",Ea,xt,Va,Ft,vn="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",Na,$t,Sa,Gt,xn="For that you need to first load your 8bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",Aa,Zt,Ha,Rt,Ya,Bt,Fn=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,La,qt,Da,Xt,$n=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,Pa,zt,Oa,Qt,Gn="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",Ka,Wt,ts,Et,Zn="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",es,Vt,as,Nt,Rn="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",ss,St,Bn="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",ns,At,qn="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",ls,Ht,os,Yt,Xn="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",is,Lt,rs,Dt,zn="And add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when calling <code>from_pretrained</code>:",ps,Pt,cs,Ot,Qn=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,ds,Kt,Wn="In contrary to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",ms,te,us,ee,En="We included a utility function to create your model.",Ms,T,ae,Ss,Ce,Vn="Arguments which define the model and tokenizer to load.",hs,se,ys,ne,fs,le,Nn='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',Ts,oe,Sn="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",gs,j,An='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',Us,ie,Hn="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTTrainer</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",js,re,ws,pe,Yn='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',bs,w,Ln='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',Js,ce,Dn='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',_s,de,ks,me,Pn='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks on 1x A100 listed below:',Cs,ue,On="<thead><tr><th>1 A100 40GB</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>Code Llama 34b</td> <td>Slim Orca</td> <td>1x</td> <td>1.01x</td> <td><strong>1.94x</strong></td> <td>-22.7%</td></tr> <tr><td>Llama-2 7b</td> <td>Slim Orca</td> <td>1x</td> <td>0.96x</td> <td><strong>1.87x</strong></td> <td>-39.3%</td></tr> <tr><td>Mistral 7b</td> <td>Slim Orca</td> <td>1x</td> <td>1.17x</td> <td><strong>1.88x</strong></td> <td>-65.9%</td></tr> <tr><td>Tiny Llama 1.1b</td> <td>Alpaca</td> <td>1x</td> <td>1.55x</td> <td><strong>2.74x</strong></td> <td>-57.8%</td></tr></tbody>",Is,Me,Kn='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',vs,he,xs,ye,tl='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',Fs,fe,$s,Te,el="Pay attention to the following best practices when training a model with that trainer:",Gs,ge,al='<li><a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',Zs,Ue,Rs,je,sl="You may experience some issues with GPTQ Quantization after completing training. Lowering <code>gradient_accumulation_steps</code> to <code>4</code> will resolve most issues during the quantization process to GPTQ format.",Bs,we,qs,g,be,As,Ie,nl=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Xs,Je,zs,U,_e,Hs,ve,ll=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,Qs,Fe,Ws;return b=new y({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),k=new y({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),I=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)
trainer.train()`,wrap:!1}}),F=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)

trainer.train()`,wrap:!1}}),G=new y({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),Z=new y({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),B=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBmb3JtYXR0aW5nX2Z1bmMlM0Rmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),X=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),Q=new y({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),E=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),A=new h({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCk=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)',wrap:!1}}),Y=new h({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),L=new y({props:{title:"Add Special Tokens for Chat Format",local:"add-special-tokens-for-chat-format",headingTag:"h3"}}),O=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMGNoYXQlMjBmb3JtYXQlMjB3aXRoJTIwZGVmYXVsdCUyMCdjaGF0bWwnJTIwZm9ybWF0JTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBzZXR1cF9jaGF0X2Zvcm1hdChtb2RlbCUyQyUyMHRva2VuaXplciklMEE=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-comment"># Set up the chat format with default &#x27;chatml&#x27; format</span>
model, tokenizer = setup_chat_format(model, tokenizer)
`,wrap:!1}}),tt=new y({props:{title:"Dataset format support",local:"dataset-format-support",headingTag:"h3"}}),st=new h({props:{code:"JTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGhlbHBmdWwlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMi4uLiUyMiU3RCU1RCU3RCUwQSU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBoZWxwZnVsJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwd3JvdGUlMjAnUm9tZW8lMjBhbmQlMjBKdWxpZXQnJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIuLi4lMjIlN0QlNUQlN0QlMEElN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwaGVscGZ1bCUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGZhciUyMGlzJTIwdGhlJTIwTW9vbiUyMGZyb20lMjBFYXJ0aCUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyLi4uJTIyJTdEJTVEJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Who wrote &#x27;Romeo and Juliet&#x27;?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How far is the Moon from Earth?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),lt=new h({props:{code:"JTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyJTNDcHJvbXB0JTIwdGV4dCUzRSUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlM0NpZGVhbCUyMGdlbmVyYXRlZCUyMHRleHQlM0UlMjIlN0QlMEElN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjIlM0Nwcm9tcHQlMjB0ZXh0JTNFJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUzQ2lkZWFsJTIwZ2VuZXJhdGVkJTIwdGV4dCUzRSUyMiU3RCUwQSU3QiUyMnByb21wdCUyMiUzQSUyMCUyMiUzQ3Byb21wdCUyMHRleHQlM0UlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTNDaWRlYWwlMjBnZW5lcmF0ZWQlMjB0ZXh0JTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),it=new h({props:{code:"JTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

...

<span class="hljs-comment"># load jsonl dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=<span class="hljs-string">&quot;path/to/dataset.jsonl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># load dataset from the HuggingFace Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/dolly-15k-oai-style&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    args=training_args,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),pt=new y({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),dt=new h({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),ut=new h({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),ht=new y({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),ft=new h({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    packing=<span class="hljs-literal">True</span>
)

trainer.train()`,wrap:!1}}),gt=new y({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),jt=new h({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwYWNraW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),bt=new y({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),_t=new h({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYp",highlighted:'model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)',wrap:!1}}),kt=new h({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16,
    },
)

trainer.train()`,wrap:!1}}),It=new y({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),xt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),$t=new y({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),Zt=new h({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Rt=new y({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),qt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),zt=new y({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),Wt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),Vt=new h({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),Ht=new y({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),Lt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),Pt=new h({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>
)`,wrap:!1}}),te=new y({props:{title:"Using model creation utility",local:"trl.ModelConfig",headingTag:"h3"}}),ae=new Ys({props:{name:"class trl.ModelConfig",anchor:"trl.ModelConfig",parameters:[{name:"model_name_or_path",val:": Optional = None"},{name:"model_revision",val:": str = 'main'"},{name:"torch_dtype",val:": Optional = None"},{name:"trust_remote_code",val:": bool = False"},{name:"attn_implementation",val:": Optional = None"},{name:"use_peft",val:": bool = False"},{name:"lora_r",val:": Optional = 16"},{name:"lora_alpha",val:": Optional = 32"},{name:"lora_dropout",val:": Optional = 0.05"},{name:"lora_target_modules",val:": Optional = None"},{name:"lora_modules_to_save",val:": Optional = None"},{name:"load_in_8bit",val:": bool = False"},{name:"load_in_4bit",val:": bool = False"},{name:"bnb_4bit_quant_type",val:": Optional = 'nf4'"},{name:"use_bnb_nested_quant",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/model_config.py#L7"}}),se=new h({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyME1vZGVsQ29uZmlnJTJDJTIwU0ZUVHJhaW5lciUyQyUyMGdldF9rYml0X2RldmljZV9tYXAlMkMlMjBnZXRfcGVmdF9jb25maWclMkMlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyME1vZGVsQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWVfb3JfcGF0aCUzRCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMEElMjAlMjAlMjAlMjBhdHRuX2ltcGxlbWVudGF0aW9uJTNETm9uZSUyQyUyMCUyMyUyMG9yJTIwJTIyZmxhc2hfYXR0ZW50aW9uXzIlMjIlMEEpJTBBdG9yY2hfZHR5cGUlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnLnRvcmNoX2R0eXBlJTBBJTIwJTIwJTIwJTIwaWYlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUlMjBpbiUyMCU1QiUyMmF1dG8lMjIlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwZWxzZSUyMGdldGF0dHIodG9yY2glMkMlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUpJTBBKSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyhtb2RlbF9jb25maWcpJTBBbW9kZWxfa3dhcmdzJTIwJTNEJTIwZGljdCglMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzRG1vZGVsX2NvbmZpZy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEbW9kZWxfY29uZmlnLnRydXN0X3JlbW90ZV9jb2RlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRG1vZGVsX2NvbmZpZy5hdHRuX2ltcGxlbWVudGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaF9kdHlwZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTIwaWYlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjBlbHNlJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RnZXRfa2JpdF9kZXZpY2VfbWFwKCklMjBpZiUyMHF1YW50aXphdGlvbl9jb25maWclMjBpcyUyMG5vdCUyME5vbmUlMjBlbHNlJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMjAqKm1vZGVsX2t3YXJncyklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGdldF9wZWZ0X2NvbmZpZyhtb2RlbF9jb25maWcpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> ModelConfig, SFTTrainer, get_kbit_device_map, get_peft_config, get_quantization_config
model_config = ModelConfig(
    model_name_or_path=<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
    attn_implementation=<span class="hljs-literal">None</span>, <span class="hljs-comment"># or &quot;flash_attention_2&quot;</span>
)
torch_dtype = (
    model_config.torch_dtype
    <span class="hljs-keyword">if</span> model_config.torch_dtype <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;auto&quot;</span>, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">else</span> <span class="hljs-built_in">getattr</span>(torch, model_config.torch_dtype)
)
quantization_config = get_quantization_config(model_config)
model_kwargs = <span class="hljs-built_in">dict</span>(
    revision=model_config.model_revision,
    trust_remote_code=model_config.trust_remote_code,
    attn_implementation=model_config.attn_implementation,
    torch_dtype=torch_dtype,
    use_cache=<span class="hljs-literal">False</span> <span class="hljs-keyword">if</span> training_args.gradient_checkpointing <span class="hljs-keyword">else</span> <span class="hljs-literal">True</span>,
    device_map=get_kbit_device_map() <span class="hljs-keyword">if</span> quantization_config <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
    quantization_config=quantization_config,
)
model = AutoModelForCausalLM.from_pretrained(model_config.model_name_or_path, **model_kwargs)
trainer = SFTTrainer(
    ...,
    model=model_config.model_name_or_path,
    peft_config=get_peft_config(model_config),
)`,wrap:!1}}),ne=new y({props:{title:"Enhance model’s performances using NEFTune",local:"enhance-models-performances-using-neftune",headingTag:"h3"}}),re=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG5lZnR1bmVfbm9pc2VfYWxwaGElM0Q1JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer.train()`,wrap:!1}}),de=new y({props:{title:"Accelerate fine-tuning 2x using unsloth",local:"accelerate-fine-tuning-2x-using-unsloth",headingTag:"h3"}}),he=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/mistral-7b&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

args = TrainingArguments(output_dir = <span class="hljs-string">&quot;./output&quot;</span>)

trainer = SFTTrainer(
    model = model,
    args = args,
    train_dataset = dataset,
    dataset_text_field = <span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length = max_seq_length,
)
trainer.train()`,wrap:!1}}),fe=new y({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),Ue=new y({props:{title:"GPTQ Conversion",local:"gptq-conversion",headingTag:"h2"}}),we=new y({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),be=new Ys({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"formatting_func",val:": Optional = None"},{name:"max_seq_length",val:": Optional = None"},{name:"infinite",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = 1024"},{name:"chars_per_token",val:": Optional = 3.6"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automatically creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instruction
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L55"}}),Je=new y({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h2"}}),_e=new Ys({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"tokenizer",val:""},{name:"dataset",val:""},{name:"dataset_text_field",val:" = None"},{name:"formatting_func",val:" = None"},{name:"infinite",val:" = False"},{name:"seq_length",val:" = 1024"},{name:"num_of_sequences",val:" = 1024"},{name:"chars_per_token",val:" = 3.6"},{name:"eos_token_id",val:" = 0"},{name:"shuffle",val:" = True"},{name:"append_concat_token",val:" = True"},{name:"add_special_tokens",val:" = True"}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as <code>&quot;### Question: {question} ### Answer: {answer}&quot;</code>`,name:"formatting_func"},{anchor:"trl.trainer.ConstantLengthDataset.infinite",description:`<strong>infinite</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True the iterator is reset after dataset reaches end else stops.`,name:"infinite"},{anchor:"trl.trainer.ConstantLengthDataset.seq_length",description:`<strong>seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Length of token sequences to return.`,name:"seq_length"},{anchor:"trl.trainer.ConstantLengthDataset.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of token sequences to keep in buffer.`,name:"num_of_sequences"},{anchor:"trl.trainer.ConstantLengthDataset.chars_per_token",description:`<strong>chars_per_token</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3.6</code>) &#x2014;
Number of characters per token used to estimate number of tokens in text buffer.`,name:"chars_per_token"},{anchor:"trl.trainer.ConstantLengthDataset.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Id of the end of sequence token if the passed tokenizer does not have an EOS token.`,name:"eos_token_id"},{anchor:"trl.trainer.ConstantLengthDataset.shuffle",description:`<strong>shuffle</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
Shuffle the examples before they are returned`,name:"shuffle"},{anchor:"trl.trainer.ConstantLengthDataset.append_concat_token",description:`<strong>append_concat_token</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
If true, appends <code>eos_token_id</code> at the end of each sample being packed.`,name:"append_concat_token"},{anchor:"trl.trainer.ConstantLengthDataset.add_special_tokens",description:`<strong>add_special_tokens</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
If true, tokenizers adds special tokens to each sample being packed.`,name:"add_special_tokens"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/utils.py#L361"}}),{c(){f=o("meta"),Ze=n(),xe=o("p"),Re=n(),p(b.$$.fragment),Be=n(),J=o("p"),J.textContent=Ds,qe=n(),_=o("p"),_.innerHTML=Ps,Xe=n(),p(k.$$.fragment),ze=n(),C=o("p"),C.innerHTML=Os,Qe=n(),p(I.$$.fragment),We=n(),v=o("p"),v.innerHTML=Ks,Ee=n(),x=o("p"),x.textContent=tn,Ve=n(),p(F.$$.fragment),Ne=n(),$=o("p"),$.innerHTML=en,Se=n(),p(G.$$.fragment),Ae=n(),p(Z.$$.fragment),He=n(),R=o("p"),R.innerHTML=an,Ye=n(),p(B.$$.fragment),Le=n(),q=o("p"),q.innerHTML=sn,De=n(),p(X.$$.fragment),Pe=n(),z=o("p"),z.innerHTML=nn,Oe=n(),p(Q.$$.fragment),Ke=n(),W=o("p"),W.innerHTML=ln,ta=n(),p(E.$$.fragment),ea=n(),V=o("p"),V.innerHTML=on,aa=n(),N=o("ul"),N.innerHTML=rn,sa=n(),S=o("p"),S.innerHTML=pn,na=n(),p(A.$$.fragment),la=n(),H=o("p"),H.innerHTML=cn,oa=n(),p(Y.$$.fragment),ia=n(),p(L.$$.fragment),ra=n(),D=o("p"),D.innerHTML=dn,pa=n(),P=o("ul"),P.innerHTML=mn,ca=n(),p(O.$$.fragment),da=n(),K=o("p"),K.textContent=un,ma=n(),p(tt.$$.fragment),ua=n(),et=o("p"),et.innerHTML=Mn,Ma=n(),at=o("ul"),at.innerHTML=hn,ha=n(),p(st.$$.fragment),ya=n(),nt=o("ul"),nt.innerHTML=yn,fa=n(),p(lt.$$.fragment),Ta=n(),ot=o("p"),ot.innerHTML=fn,ga=n(),p(it.$$.fragment),Ua=n(),rt=o("p"),rt.textContent=Tn,ja=n(),p(pt.$$.fragment),wa=n(),ct=o("p"),ct.innerHTML=gn,ba=n(),p(dt.$$.fragment),Ja=n(),mt=o("p"),mt.innerHTML=Un,_a=n(),p(ut.$$.fragment),ka=n(),Mt=o("p"),Mt.innerHTML=jn,Ca=n(),p(ht.$$.fragment),Ia=n(),yt=o("p"),yt.innerHTML=wn,va=n(),p(ft.$$.fragment),xa=n(),Tt=o("p"),Tt.innerHTML=bn,Fa=n(),p(gt.$$.fragment),$a=n(),Ut=o("p"),Ut.innerHTML=Jn,Ga=n(),p(jt.$$.fragment),Za=n(),wt=o("p"),wt.innerHTML=_n,Ra=n(),p(bt.$$.fragment),Ba=n(),Jt=o("p"),Jt.innerHTML=kn,qa=n(),p(_t.$$.fragment),Xa=n(),p(kt.$$.fragment),za=n(),Ct=o("p"),Ct.innerHTML=Cn,Qa=n(),p(It.$$.fragment),Wa=n(),vt=o("p"),vt.textContent=In,Ea=n(),p(xt.$$.fragment),Va=n(),Ft=o("p"),Ft.innerHTML=vn,Na=n(),p($t.$$.fragment),Sa=n(),Gt=o("p"),Gt.innerHTML=xn,Aa=n(),p(Zt.$$.fragment),Ha=n(),p(Rt.$$.fragment),Ya=n(),Bt=o("p"),Bt.textContent=Fn,La=n(),p(qt.$$.fragment),Da=n(),Xt=o("p"),Xt.textContent=$n,Pa=n(),p(zt.$$.fragment),Oa=n(),Qt=o("p"),Qt.innerHTML=Gn,Ka=n(),p(Wt.$$.fragment),ts=n(),Et=o("p"),Et.innerHTML=Zn,es=n(),p(Vt.$$.fragment),as=n(),Nt=o("p"),Nt.innerHTML=Rn,ss=n(),St=o("p"),St.textContent=Bn,ns=n(),At=o("table"),At.innerHTML=qn,ls=n(),p(Ht.$$.fragment),os=n(),Yt=o("p"),Yt.innerHTML=Xn,is=n(),p(Lt.$$.fragment),rs=n(),Dt=o("p"),Dt.innerHTML=zn,ps=n(),p(Pt.$$.fragment),cs=n(),Ot=o("p"),Ot.textContent=Qn,ds=n(),Kt=o("p"),Kt.textContent=Wn,ms=n(),p(te.$$.fragment),us=n(),ee=o("p"),ee.textContent=En,Ms=n(),T=o("div"),p(ae.$$.fragment),Ss=n(),Ce=o("p"),Ce.textContent=Vn,hs=n(),p(se.$$.fragment),ys=n(),p(ne.$$.fragment),fs=n(),le=o("p"),le.innerHTML=Nn,Ts=n(),oe=o("blockquote"),oe.innerHTML=Sn,gs=n(),j=o("div"),j.innerHTML=An,Us=n(),ie=o("p"),ie.innerHTML=Hn,js=n(),p(re.$$.fragment),ws=n(),pe=o("p"),pe.innerHTML=Yn,bs=n(),w=o("div"),w.innerHTML=Ln,Js=n(),ce=o("p"),ce.innerHTML=Dn,_s=n(),p(de.$$.fragment),ks=n(),me=o("p"),me.innerHTML=Pn,Cs=n(),ue=o("table"),ue.innerHTML=On,Is=n(),Me=o("p"),Me.innerHTML=Kn,vs=n(),p(he.$$.fragment),xs=n(),ye=o("p"),ye.innerHTML=tl,Fs=n(),p(fe.$$.fragment),$s=n(),Te=o("p"),Te.textContent=el,Gs=n(),ge=o("ul"),ge.innerHTML=al,Zs=n(),p(Ue.$$.fragment),Rs=n(),je=o("p"),je.innerHTML=sl,Bs=n(),p(we.$$.fragment),qs=n(),g=o("div"),p(be.$$.fragment),As=n(),Ie=o("p"),Ie.innerHTML=nl,Xs=n(),p(Je.$$.fragment),zs=n(),U=o("div"),p(_e.$$.fragment),Hs=n(),ve=o("p"),ve.textContent=ll,Qs=n(),Fe=o("p"),this.h()},l(t){const e=ml("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(a),Ze=l(t),xe=i(t,"P",{}),$e(xe).forEach(a),Re=l(t),c(b.$$.fragment,t),Be=l(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-o839x3"&&(J.textContent=Ds),qe=l(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-exgkch"&&(_.innerHTML=Ps),Xe=l(t),c(k.$$.fragment,t),ze=l(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-anzvl4"&&(C.innerHTML=Os),Qe=l(t),c(I.$$.fragment,t),We=l(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1gbidw"&&(v.innerHTML=Ks),Ee=l(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-ulikv8"&&(x.textContent=tn),Ve=l(t),c(F.$$.fragment,t),Ne=l(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1tcj92l"&&($.innerHTML=en),Se=l(t),c(G.$$.fragment,t),Ae=l(t),c(Z.$$.fragment,t),He=l(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-13sbeoj"&&(R.innerHTML=an),Ye=l(t),c(B.$$.fragment,t),Le=l(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1a743rp"&&(q.innerHTML=sn),De=l(t),c(X.$$.fragment,t),Pe=l(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-rjhq4r"&&(z.innerHTML=nn),Oe=l(t),c(Q.$$.fragment,t),Ke=l(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-dfggk8"&&(W.innerHTML=ln),ta=l(t),c(E.$$.fragment,t),ea=l(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-xlwe87"&&(V.innerHTML=on),aa=l(t),N=i(t,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-1enki0k"&&(N.innerHTML=rn),sa=l(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-14yxh0m"&&(S.innerHTML=pn),na=l(t),c(A.$$.fragment,t),la=l(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-13h81gp"&&(H.innerHTML=cn),oa=l(t),c(Y.$$.fragment,t),ia=l(t),c(L.$$.fragment,t),ra=l(t),D=i(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1ccg0zx"&&(D.innerHTML=dn),pa=l(t),P=i(t,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-ebt5re"&&(P.innerHTML=mn),ca=l(t),c(O.$$.fragment,t),da=l(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1hmfl2q"&&(K.textContent=un),ma=l(t),c(tt.$$.fragment,t),ua=l(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1d09r79"&&(et.innerHTML=Mn),Ma=l(t),at=i(t,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-5iwuvk"&&(at.innerHTML=hn),ha=l(t),c(st.$$.fragment,t),ya=l(t),nt=i(t,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-23l1e6"&&(nt.innerHTML=yn),fa=l(t),c(lt.$$.fragment,t),Ta=l(t),ot=i(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1qd8v57"&&(ot.innerHTML=fn),ga=l(t),c(it.$$.fragment,t),Ua=l(t),rt=i(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1da8xo3"&&(rt.textContent=Tn),ja=l(t),c(pt.$$.fragment,t),wa=l(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-cqsf2h"&&(ct.innerHTML=gn),ba=l(t),c(dt.$$.fragment,t),Ja=l(t),mt=i(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-l25vq0"&&(mt.innerHTML=Un),_a=l(t),c(ut.$$.fragment,t),ka=l(t),Mt=i(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1tv1he7"&&(Mt.innerHTML=jn),Ca=l(t),c(ht.$$.fragment,t),Ia=l(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1gq90k4"&&(yt.innerHTML=wn),va=l(t),c(ft.$$.fragment,t),xa=l(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-5wxaqa"&&(Tt.innerHTML=bn),Fa=l(t),c(gt.$$.fragment,t),$a=l(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-iejqw3"&&(Ut.innerHTML=Jn),Ga=l(t),c(jt.$$.fragment,t),Za=l(t),wt=i(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1ns807a"&&(wt.innerHTML=_n),Ra=l(t),c(bt.$$.fragment,t),Ba=l(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1rbzvkg"&&(Jt.innerHTML=kn),qa=l(t),c(_t.$$.fragment,t),Xa=l(t),c(kt.$$.fragment,t),za=l(t),Ct=i(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1su7aih"&&(Ct.innerHTML=Cn),Qa=l(t),c(It.$$.fragment,t),Wa=l(t),vt=i(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-11jfbzz"&&(vt.textContent=In),Ea=l(t),c(xt.$$.fragment,t),Va=l(t),Ft=i(t,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-pwdaav"&&(Ft.innerHTML=vn),Na=l(t),c($t.$$.fragment,t),Sa=l(t),Gt=i(t,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-zbh7v5"&&(Gt.innerHTML=xn),Aa=l(t),c(Zt.$$.fragment,t),Ha=l(t),c(Rt.$$.fragment,t),Ya=l(t),Bt=i(t,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-fyvvsj"&&(Bt.textContent=Fn),La=l(t),c(qt.$$.fragment,t),Da=l(t),Xt=i(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-yypgof"&&(Xt.textContent=$n),Pa=l(t),c(zt.$$.fragment,t),Oa=l(t),Qt=i(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-yugu96"&&(Qt.innerHTML=Gn),Ka=l(t),c(Wt.$$.fragment,t),ts=l(t),Et=i(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1qms4cl"&&(Et.innerHTML=Zn),es=l(t),c(Vt.$$.fragment,t),as=l(t),Nt=i(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-qe5zfz"&&(Nt.innerHTML=Rn),ss=l(t),St=i(t,"P",{"data-svelte-h":!0}),r(St)!=="svelte-69u1rz"&&(St.textContent=Bn),ns=l(t),At=i(t,"TABLE",{"data-svelte-h":!0}),r(At)!=="svelte-8fq96j"&&(At.innerHTML=qn),ls=l(t),c(Ht.$$.fragment,t),os=l(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-1rqlm78"&&(Yt.innerHTML=Xn),is=l(t),c(Lt.$$.fragment,t),rs=l(t),Dt=i(t,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-14s96xo"&&(Dt.innerHTML=zn),ps=l(t),c(Pt.$$.fragment,t),cs=l(t),Ot=i(t,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-vfpk19"&&(Ot.textContent=Qn),ds=l(t),Kt=i(t,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-zatc00"&&(Kt.textContent=Wn),ms=l(t),c(te.$$.fragment,t),us=l(t),ee=i(t,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-u9yx96"&&(ee.textContent=En),Ms=l(t),T=i(t,"DIV",{class:!0});var Es=$e(T);c(ae.$$.fragment,Es),Ss=l(Es),Ce=i(Es,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-fghgxx"&&(Ce.textContent=Vn),Es.forEach(a),hs=l(t),c(se.$$.fragment,t),ys=l(t),c(ne.$$.fragment,t),fs=l(t),le=i(t,"P",{"data-svelte-h":!0}),r(le)!=="svelte-6trhkk"&&(le.innerHTML=Nn),Ts=l(t),oe=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(oe)!=="svelte-1ejl1pl"&&(oe.innerHTML=Sn),gs=l(t),j=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(j)!=="svelte-1wkjgyb"&&(j.innerHTML=An),Us=l(t),ie=i(t,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-7jwpzy"&&(ie.innerHTML=Hn),js=l(t),c(re.$$.fragment,t),ws=l(t),pe=i(t,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-sqj12"&&(pe.innerHTML=Yn),bs=l(t),w=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(w)!=="svelte-a1m5gi"&&(w.innerHTML=Ln),Js=l(t),ce=i(t,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-rwofnh"&&(ce.innerHTML=Dn),_s=l(t),c(de.$$.fragment,t),ks=l(t),me=i(t,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1q1m1nw"&&(me.innerHTML=Pn),Cs=l(t),ue=i(t,"TABLE",{"data-svelte-h":!0}),r(ue)!=="svelte-lj2wpp"&&(ue.innerHTML=On),Is=l(t),Me=i(t,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1p74c9x"&&(Me.innerHTML=Kn),vs=l(t),c(he.$$.fragment,t),xs=l(t),ye=i(t,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1o18rwj"&&(ye.innerHTML=tl),Fs=l(t),c(fe.$$.fragment,t),$s=l(t),Te=i(t,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-g801h1"&&(Te.textContent=el),Gs=l(t),ge=i(t,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-sepwt4"&&(ge.innerHTML=al),Zs=l(t),c(Ue.$$.fragment,t),Rs=l(t),je=i(t,"P",{"data-svelte-h":!0}),r(je)!=="svelte-xofzi2"&&(je.innerHTML=sl),Bs=l(t),c(we.$$.fragment,t),qs=l(t),g=i(t,"DIV",{class:!0});var Vs=$e(g);c(be.$$.fragment,Vs),As=l(Vs),Ie=i(Vs,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-14oyph8"&&(Ie.innerHTML=nl),Vs.forEach(a),Xs=l(t),c(Je.$$.fragment,t),zs=l(t),U=i(t,"DIV",{class:!0});var Ns=$e(U);c(_e.$$.fragment,Ns),Hs=l(Ns),ve=i(Ns,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1dlriq1"&&(ve.textContent=ll),Ns.forEach(a),Qs=l(t),Fe=i(t,"P",{}),$e(Fe).forEach(a),this.h()},h(){Ge(f,"name","hf:doc:metadata"),Ge(f,"content",Ml),Ge(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ol(j,"text-align","center"),ol(w,"text-align","center"),Ge(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ge(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){ke(document.head,f),s(t,Ze,e),s(t,xe,e),s(t,Re,e),d(b,t,e),s(t,Be,e),s(t,J,e),s(t,qe,e),s(t,_,e),s(t,Xe,e),d(k,t,e),s(t,ze,e),s(t,C,e),s(t,Qe,e),d(I,t,e),s(t,We,e),s(t,v,e),s(t,Ee,e),s(t,x,e),s(t,Ve,e),d(F,t,e),s(t,Ne,e),s(t,$,e),s(t,Se,e),d(G,t,e),s(t,Ae,e),d(Z,t,e),s(t,He,e),s(t,R,e),s(t,Ye,e),d(B,t,e),s(t,Le,e),s(t,q,e),s(t,De,e),d(X,t,e),s(t,Pe,e),s(t,z,e),s(t,Oe,e),d(Q,t,e),s(t,Ke,e),s(t,W,e),s(t,ta,e),d(E,t,e),s(t,ea,e),s(t,V,e),s(t,aa,e),s(t,N,e),s(t,sa,e),s(t,S,e),s(t,na,e),d(A,t,e),s(t,la,e),s(t,H,e),s(t,oa,e),d(Y,t,e),s(t,ia,e),d(L,t,e),s(t,ra,e),s(t,D,e),s(t,pa,e),s(t,P,e),s(t,ca,e),d(O,t,e),s(t,da,e),s(t,K,e),s(t,ma,e),d(tt,t,e),s(t,ua,e),s(t,et,e),s(t,Ma,e),s(t,at,e),s(t,ha,e),d(st,t,e),s(t,ya,e),s(t,nt,e),s(t,fa,e),d(lt,t,e),s(t,Ta,e),s(t,ot,e),s(t,ga,e),d(it,t,e),s(t,Ua,e),s(t,rt,e),s(t,ja,e),d(pt,t,e),s(t,wa,e),s(t,ct,e),s(t,ba,e),d(dt,t,e),s(t,Ja,e),s(t,mt,e),s(t,_a,e),d(ut,t,e),s(t,ka,e),s(t,Mt,e),s(t,Ca,e),d(ht,t,e),s(t,Ia,e),s(t,yt,e),s(t,va,e),d(ft,t,e),s(t,xa,e),s(t,Tt,e),s(t,Fa,e),d(gt,t,e),s(t,$a,e),s(t,Ut,e),s(t,Ga,e),d(jt,t,e),s(t,Za,e),s(t,wt,e),s(t,Ra,e),d(bt,t,e),s(t,Ba,e),s(t,Jt,e),s(t,qa,e),d(_t,t,e),s(t,Xa,e),d(kt,t,e),s(t,za,e),s(t,Ct,e),s(t,Qa,e),d(It,t,e),s(t,Wa,e),s(t,vt,e),s(t,Ea,e),d(xt,t,e),s(t,Va,e),s(t,Ft,e),s(t,Na,e),d($t,t,e),s(t,Sa,e),s(t,Gt,e),s(t,Aa,e),d(Zt,t,e),s(t,Ha,e),d(Rt,t,e),s(t,Ya,e),s(t,Bt,e),s(t,La,e),d(qt,t,e),s(t,Da,e),s(t,Xt,e),s(t,Pa,e),d(zt,t,e),s(t,Oa,e),s(t,Qt,e),s(t,Ka,e),d(Wt,t,e),s(t,ts,e),s(t,Et,e),s(t,es,e),d(Vt,t,e),s(t,as,e),s(t,Nt,e),s(t,ss,e),s(t,St,e),s(t,ns,e),s(t,At,e),s(t,ls,e),d(Ht,t,e),s(t,os,e),s(t,Yt,e),s(t,is,e),d(Lt,t,e),s(t,rs,e),s(t,Dt,e),s(t,ps,e),d(Pt,t,e),s(t,cs,e),s(t,Ot,e),s(t,ds,e),s(t,Kt,e),s(t,ms,e),d(te,t,e),s(t,us,e),s(t,ee,e),s(t,Ms,e),s(t,T,e),d(ae,T,null),ke(T,Ss),ke(T,Ce),s(t,hs,e),d(se,t,e),s(t,ys,e),d(ne,t,e),s(t,fs,e),s(t,le,e),s(t,Ts,e),s(t,oe,e),s(t,gs,e),s(t,j,e),s(t,Us,e),s(t,ie,e),s(t,js,e),d(re,t,e),s(t,ws,e),s(t,pe,e),s(t,bs,e),s(t,w,e),s(t,Js,e),s(t,ce,e),s(t,_s,e),d(de,t,e),s(t,ks,e),s(t,me,e),s(t,Cs,e),s(t,ue,e),s(t,Is,e),s(t,Me,e),s(t,vs,e),d(he,t,e),s(t,xs,e),s(t,ye,e),s(t,Fs,e),d(fe,t,e),s(t,$s,e),s(t,Te,e),s(t,Gs,e),s(t,ge,e),s(t,Zs,e),d(Ue,t,e),s(t,Rs,e),s(t,je,e),s(t,Bs,e),d(we,t,e),s(t,qs,e),s(t,g,e),d(be,g,null),ke(g,As),ke(g,Ie),s(t,Xs,e),d(Je,t,e),s(t,zs,e),s(t,U,e),d(_e,U,null),ke(U,Hs),ke(U,ve),s(t,Qs,e),s(t,Fe,e),Ws=!0},p:rl,i(t){Ws||(m(b.$$.fragment,t),m(k.$$.fragment,t),m(I.$$.fragment,t),m(F.$$.fragment,t),m(G.$$.fragment,t),m(Z.$$.fragment,t),m(B.$$.fragment,t),m(X.$$.fragment,t),m(Q.$$.fragment,t),m(E.$$.fragment,t),m(A.$$.fragment,t),m(Y.$$.fragment,t),m(L.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(st.$$.fragment,t),m(lt.$$.fragment,t),m(it.$$.fragment,t),m(pt.$$.fragment,t),m(dt.$$.fragment,t),m(ut.$$.fragment,t),m(ht.$$.fragment,t),m(ft.$$.fragment,t),m(gt.$$.fragment,t),m(jt.$$.fragment,t),m(bt.$$.fragment,t),m(_t.$$.fragment,t),m(kt.$$.fragment,t),m(It.$$.fragment,t),m(xt.$$.fragment,t),m($t.$$.fragment,t),m(Zt.$$.fragment,t),m(Rt.$$.fragment,t),m(qt.$$.fragment,t),m(zt.$$.fragment,t),m(Wt.$$.fragment,t),m(Vt.$$.fragment,t),m(Ht.$$.fragment,t),m(Lt.$$.fragment,t),m(Pt.$$.fragment,t),m(te.$$.fragment,t),m(ae.$$.fragment,t),m(se.$$.fragment,t),m(ne.$$.fragment,t),m(re.$$.fragment,t),m(de.$$.fragment,t),m(he.$$.fragment,t),m(fe.$$.fragment,t),m(Ue.$$.fragment,t),m(we.$$.fragment,t),m(be.$$.fragment,t),m(Je.$$.fragment,t),m(_e.$$.fragment,t),Ws=!0)},o(t){u(b.$$.fragment,t),u(k.$$.fragment,t),u(I.$$.fragment,t),u(F.$$.fragment,t),u(G.$$.fragment,t),u(Z.$$.fragment,t),u(B.$$.fragment,t),u(X.$$.fragment,t),u(Q.$$.fragment,t),u(E.$$.fragment,t),u(A.$$.fragment,t),u(Y.$$.fragment,t),u(L.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(st.$$.fragment,t),u(lt.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(dt.$$.fragment,t),u(ut.$$.fragment,t),u(ht.$$.fragment,t),u(ft.$$.fragment,t),u(gt.$$.fragment,t),u(jt.$$.fragment,t),u(bt.$$.fragment,t),u(_t.$$.fragment,t),u(kt.$$.fragment,t),u(It.$$.fragment,t),u(xt.$$.fragment,t),u($t.$$.fragment,t),u(Zt.$$.fragment,t),u(Rt.$$.fragment,t),u(qt.$$.fragment,t),u(zt.$$.fragment,t),u(Wt.$$.fragment,t),u(Vt.$$.fragment,t),u(Ht.$$.fragment,t),u(Lt.$$.fragment,t),u(Pt.$$.fragment,t),u(te.$$.fragment,t),u(ae.$$.fragment,t),u(se.$$.fragment,t),u(ne.$$.fragment,t),u(re.$$.fragment,t),u(de.$$.fragment,t),u(he.$$.fragment,t),u(fe.$$.fragment,t),u(Ue.$$.fragment,t),u(we.$$.fragment,t),u(be.$$.fragment,t),u(Je.$$.fragment,t),u(_e.$$.fragment,t),Ws=!1},d(t){t&&(a(Ze),a(xe),a(Re),a(Be),a(J),a(qe),a(_),a(Xe),a(ze),a(C),a(Qe),a(We),a(v),a(Ee),a(x),a(Ve),a(Ne),a($),a(Se),a(Ae),a(He),a(R),a(Ye),a(Le),a(q),a(De),a(Pe),a(z),a(Oe),a(Ke),a(W),a(ta),a(ea),a(V),a(aa),a(N),a(sa),a(S),a(na),a(la),a(H),a(oa),a(ia),a(ra),a(D),a(pa),a(P),a(ca),a(da),a(K),a(ma),a(ua),a(et),a(Ma),a(at),a(ha),a(ya),a(nt),a(fa),a(Ta),a(ot),a(ga),a(Ua),a(rt),a(ja),a(wa),a(ct),a(ba),a(Ja),a(mt),a(_a),a(ka),a(Mt),a(Ca),a(Ia),a(yt),a(va),a(xa),a(Tt),a(Fa),a($a),a(Ut),a(Ga),a(Za),a(wt),a(Ra),a(Ba),a(Jt),a(qa),a(Xa),a(za),a(Ct),a(Qa),a(Wa),a(vt),a(Ea),a(Va),a(Ft),a(Na),a(Sa),a(Gt),a(Aa),a(Ha),a(Ya),a(Bt),a(La),a(Da),a(Xt),a(Pa),a(Oa),a(Qt),a(Ka),a(ts),a(Et),a(es),a(as),a(Nt),a(ss),a(St),a(ns),a(At),a(ls),a(os),a(Yt),a(is),a(rs),a(Dt),a(ps),a(cs),a(Ot),a(ds),a(Kt),a(ms),a(us),a(ee),a(Ms),a(T),a(hs),a(ys),a(fs),a(le),a(Ts),a(oe),a(gs),a(j),a(Us),a(ie),a(js),a(ws),a(pe),a(bs),a(w),a(Js),a(ce),a(_s),a(ks),a(me),a(Cs),a(ue),a(Is),a(Me),a(vs),a(xs),a(ye),a(Fs),a($s),a(Te),a(Gs),a(ge),a(Zs),a(Rs),a(je),a(Bs),a(qs),a(g),a(Xs),a(zs),a(U),a(Qs),a(Fe)),a(f),M(b,t),M(k,t),M(I,t),M(F,t),M(G,t),M(Z,t),M(B,t),M(X,t),M(Q,t),M(E,t),M(A,t),M(Y,t),M(L,t),M(O,t),M(tt,t),M(st,t),M(lt,t),M(it,t),M(pt,t),M(dt,t),M(ut,t),M(ht,t),M(ft,t),M(gt,t),M(jt,t),M(bt,t),M(_t,t),M(kt,t),M(It,t),M(xt,t),M($t,t),M(Zt,t),M(Rt,t),M(qt,t),M(zt,t),M(Wt,t),M(Vt,t),M(Ht,t),M(Lt,t),M(Pt,t),M(te,t),M(ae),M(se,t),M(ne,t),M(re,t),M(de,t),M(he,t),M(fe,t),M(Ue,t),M(we,t),M(be),M(Je,t),M(_e)}}}const Ml='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Add Special Tokens for Chat Format","local":"add-special-tokens-for-chat-format","sections":[],"depth":3},{"title":"Dataset format support","local":"dataset-format-support","sections":[],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Using model creation utility","local":"trl.ModelConfig","sections":[],"depth":3},{"title":"Enhance model’s performances using NEFTune","local":"enhance-models-performances-using-neftune","sections":[],"depth":3},{"title":"Accelerate fine-tuning 2x using unsloth","local":"accelerate-fine-tuning-2x-using-unsloth","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"GPTQ Conversion","local":"gptq-conversion","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[],"depth":2}],"depth":1}';function hl(Ls){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends cl{constructor(f){super(),dl(this,f,hl,ul,il,{})}}export{jl as component};
