import{s as Gs,n as Ns,o as Qs}from"../chunks/scheduler.85c25b89.js";import{S as Rs,i as Es,g as p,s as l,r as o,H as Ys,A as Vs,h as m,f as t,c as n,j as js,u as r,x as i,E as Hs,k as Bs,y as zs,a as e,v as c,d as h,t as g,w as d}from"../chunks/index.c9bcf812.js";import{C as Y}from"../chunks/CodeBlock.94efc595.js";import{H as z}from"../chunks/Heading.3c6e5b17.js";function Xs(Js){let M,X,V,S,y,A,w,us="<strong>RegNetY</strong> is a convolutional network design space with simple, regular models with parameters: depth $d$, initial width $w_{0} &gt; 0$, and slope $w_{a} &gt; 0$, and generates a different block width $u_{j}$ for each block $j &lt; d$. The key restriction for the RegNet types of model is that there is a linear parameterisation of block widths (the design space only contains models with this linear structure):",F,E,L,_s='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>j</mi><mo>=</mo><mi>w</mi><mi mathvariant="normal">_</mi><mn>0</mn><mo>+</mo><mi>w</mi><mi mathvariant="normal">_</mi><mi>a</mi><mo>⋅</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> u\\_{j} = w\\_{0} + w\\_{a}\\cdot{j} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9695em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9544em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord">0</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.7545em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord mathnormal">a</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">⋅</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span></span></span>',D,j,Ts="For <strong>RegNetX</strong> authors have additional restrictions: we set $b = 1$ (the bottleneck ratio), $12 \\leq d \\leq 28$, and $w_{m} \\geq 2$ (the width multiplier).",q,J,bs='For <strong>RegNetY</strong> authors make one change, which is to include <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">Squeeze-and-Excitation blocks</a>.',P,u,K,T,fs="To load a pretrained model:",O,b,ss,f,Us="To load and preprocess the image:",as,U,ts,$,$s="To get the model predictions:",es,I,ls,C,Is="To get the top-5 predictions class names:",ns,v,ps,k,Cs="Replace the model name with the variant you want to use, e.g. <code>regnety_002</code>. You can find the IDs in the model summaries at the top of this page.",ms,x,vs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',is,W,os,Z,ks="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",rs,B,cs,_,xs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,hs,G,gs,N,Ws='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ds,Q,Ms,R,ys,H,ws;return y=new z({props:{title:"RegNetY",local:"regnety",headingTag:"h1"}}),u=new z({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JlZ25ldHlfMDAyJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;regnety_002&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),v=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new z({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVnbmV0eV8wMDInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;regnety_002&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new z({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new z({props:{title:"Citation",local:"citation",headingTag:"h2"}}),R=new Y({props:{code:"JTQwbWlzYyU3QnJhZG9zYXZvdmljMjAyMGRlc2lnbmluZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCRGVzaWduaW5nJTIwTmV0d29yayUyMERlc2lnbiUyMFNwYWNlcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QklsaWphJTIwUmFkb3Nhdm92aWMlMjBhbmQlMjBSYWolMjBQcmF0ZWVrJTIwS29zYXJhanUlMjBhbmQlMjBSb3NzJTIwR2lyc2hpY2slMjBhbmQlMjBLYWltaW5nJTIwSGUlMjBhbmQlMjBQaW90ciUyMERvbGwlQzMlQTFyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDAzLjEzNjc4JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{radosavovic2020designing,
      title={Designing Network Design Spaces}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Ilija Radosavovic and Raj Prateek Kosaraju and Ross Girshick and Kaiming He and Piotr Dollár}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2003.13678}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){M=p("meta"),X=l(),V=p("p"),S=l(),o(y.$$.fragment),A=l(),w=p("p"),w.innerHTML=us,F=l(),E=p("p"),L=new Ys(!1),D=l(),j=p("p"),j.innerHTML=Ts,q=l(),J=p("p"),J.innerHTML=bs,P=l(),o(u.$$.fragment),K=l(),T=p("p"),T.textContent=fs,O=l(),o(b.$$.fragment),ss=l(),f=p("p"),f.textContent=Us,as=l(),o(U.$$.fragment),ts=l(),$=p("p"),$.textContent=$s,es=l(),o(I.$$.fragment),ls=l(),C=p("p"),C.textContent=Is,ns=l(),o(v.$$.fragment),ps=l(),k=p("p"),k.innerHTML=Cs,ms=l(),x=p("p"),x.innerHTML=vs,is=l(),o(W.$$.fragment),os=l(),Z=p("p"),Z.textContent=ks,rs=l(),o(B.$$.fragment),cs=l(),_=p("p"),_.innerHTML=xs,hs=l(),o(G.$$.fragment),gs=l(),N=p("p"),N.innerHTML=Ws,ds=l(),o(Q.$$.fragment),Ms=l(),o(R.$$.fragment),ys=l(),H=p("p"),this.h()},l(s){const a=Vs("svelte-u9bgzb",document.head);M=m(a,"META",{name:!0,content:!0}),a.forEach(t),X=n(s),V=m(s,"P",{}),js(V).forEach(t),S=n(s),r(y.$$.fragment,s),A=n(s),w=m(s,"P",{"data-svelte-h":!0}),i(w)!=="svelte-11eu1tk"&&(w.innerHTML=us),F=n(s),E=m(s,"P",{});var Zs=js(E);L=Hs(Zs,!1),Zs.forEach(t),D=n(s),j=m(s,"P",{"data-svelte-h":!0}),i(j)!=="svelte-h18xod"&&(j.innerHTML=Ts),q=n(s),J=m(s,"P",{"data-svelte-h":!0}),i(J)!=="svelte-q463eg"&&(J.innerHTML=bs),P=n(s),r(u.$$.fragment,s),K=n(s),T=m(s,"P",{"data-svelte-h":!0}),i(T)!=="svelte-18ywhxh"&&(T.textContent=fs),O=n(s),r(b.$$.fragment,s),ss=n(s),f=m(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1c2ipa8"&&(f.textContent=Us),as=n(s),r(U.$$.fragment,s),ts=n(s),$=m(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1n9qsq1"&&($.textContent=$s),es=n(s),r(I.$$.fragment,s),ls=n(s),C=m(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-19cnvx1"&&(C.textContent=Is),ns=n(s),r(v.$$.fragment,s),ps=n(s),k=m(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-157wccv"&&(k.innerHTML=Cs),ms=n(s),x=m(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1wmi3ea"&&(x.innerHTML=vs),is=n(s),r(W.$$.fragment,s),os=n(s),Z=m(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-9sr7nh"&&(Z.textContent=ks),rs=n(s),r(B.$$.fragment,s),cs=n(s),_=m(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1kguc51"&&(_.innerHTML=xs),hs=n(s),r(G.$$.fragment,s),gs=n(s),N=m(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1n0coha"&&(N.innerHTML=Ws),ds=n(s),r(Q.$$.fragment,s),Ms=n(s),r(R.$$.fragment,s),ys=n(s),H=m(s,"P",{}),js(H).forEach(t),this.h()},h(){Bs(M,"name","hf:doc:metadata"),Bs(M,"content",Ss),L.a=null},m(s,a){zs(document.head,M),e(s,X,a),e(s,V,a),e(s,S,a),c(y,s,a),e(s,A,a),e(s,w,a),e(s,F,a),e(s,E,a),L.m(_s,E),e(s,D,a),e(s,j,a),e(s,q,a),e(s,J,a),e(s,P,a),c(u,s,a),e(s,K,a),e(s,T,a),e(s,O,a),c(b,s,a),e(s,ss,a),e(s,f,a),e(s,as,a),c(U,s,a),e(s,ts,a),e(s,$,a),e(s,es,a),c(I,s,a),e(s,ls,a),e(s,C,a),e(s,ns,a),c(v,s,a),e(s,ps,a),e(s,k,a),e(s,ms,a),e(s,x,a),e(s,is,a),c(W,s,a),e(s,os,a),e(s,Z,a),e(s,rs,a),c(B,s,a),e(s,cs,a),e(s,_,a),e(s,hs,a),c(G,s,a),e(s,gs,a),e(s,N,a),e(s,ds,a),c(Q,s,a),e(s,Ms,a),c(R,s,a),e(s,ys,a),e(s,H,a),ws=!0},p:Ns,i(s){ws||(h(y.$$.fragment,s),h(u.$$.fragment,s),h(b.$$.fragment,s),h(U.$$.fragment,s),h(I.$$.fragment,s),h(v.$$.fragment,s),h(W.$$.fragment,s),h(B.$$.fragment,s),h(G.$$.fragment,s),h(Q.$$.fragment,s),h(R.$$.fragment,s),ws=!0)},o(s){g(y.$$.fragment,s),g(u.$$.fragment,s),g(b.$$.fragment,s),g(U.$$.fragment,s),g(I.$$.fragment,s),g(v.$$.fragment,s),g(W.$$.fragment,s),g(B.$$.fragment,s),g(G.$$.fragment,s),g(Q.$$.fragment,s),g(R.$$.fragment,s),ws=!1},d(s){s&&(t(X),t(V),t(S),t(A),t(w),t(F),t(E),t(D),t(j),t(q),t(J),t(P),t(K),t(T),t(O),t(ss),t(f),t(as),t(ts),t($),t(es),t(ls),t(C),t(ns),t(ps),t(k),t(ms),t(x),t(is),t(os),t(Z),t(rs),t(cs),t(_),t(hs),t(gs),t(N),t(ds),t(Ms),t(ys),t(H)),t(M),d(y,s),d(u,s),d(b,s),d(U,s),d(I,s),d(v,s),d(W,s),d(B,s),d(G,s),d(Q,s),d(R,s)}}}const Ss='{"title":"RegNetY","local":"regnety","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function As(Js){return Qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ps extends Rs{constructor(M){super(),Es(this,M,As,Xs,Gs,{})}}export{Ps as component};
