import{s as fa,f as Ua,o as ga,n as dl}from"../chunks/scheduler.f7e1785c.js";import{S as Ca,i as Ia,g as i,s as a,r as p,A as ba,h as M,f as s,c as n,j as ml,u as o,x as r,k as J,y as Aa,a as l,v as u,d as y,t as c,w as m,m as $a,n as ka}from"../chunks/index.9f8f0838.js";import{T as Tt}from"../chunks/Tip.4575d9cf.js";import{C as h}from"../chunks/CodeBlock.b3510e34.js";import{H as k}from"../chunks/Heading.6643a2f7.js";function va(f){let d,T=`One of the recordings in GTZAN is corrupted, so it’s been removed from the dataset. That’s why we have 999 examples
instead of 1,000.`;return{c(){d=i("p"),d.textContent=T},l(w){d=M(w,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1nwrvx0"&&(d.textContent=T)},m(w,g){l(w,d,g)},p:dl,d(w){w&&s(d)}}}function Za(f){let d,T=`Note how we’ve passed the sampling rate of our audio data to our feature extractor. This is good practice, as the feature
extractor performs a check under-the-hood to make sure the sampling rate of our audio data matches the sampling rate
expected by the model. If the sampling rate of our audio data did not match the sampling rate of our model, we’d need to
up-sample or down-sample the audio data to the correct sampling rate.`;return{c(){d=i("p"),d.textContent=T},l(w){d=M(w,"P",{"data-svelte-h":!0}),r(d)!=="svelte-rzi9hx"&&(d.textContent=T)},m(w,g){l(w,d,g)},p:dl,d(w){w&&s(d)}}}function xa(f){let d;return{c(){d=$a("If you exhaust your device's RAM executing the above code, you can adjust the batch parameters to reduce the peak\n    RAM usage. In particular, the following two arguments can be modified:\n    * `batch_size`: defaults to 1000, but set to 100 above. Try reducing by a factor of 2 again to 50\n    * `writer_batch_size`: defaults to 1000. Try reducing it to 500, and if that doesn't work, then reduce it by a factor of 2 again to 250")},l(T){d=ka(T,"If you exhaust your device's RAM executing the above code, you can adjust the batch parameters to reduce the peak\n    RAM usage. In particular, the following two arguments can be modified:\n    * `batch_size`: defaults to 1000, but set to 100 above. Try reducing by a factor of 2 again to 50\n    * `writer_batch_size`: defaults to 1000. Try reducing it to 500, and if that doesn't work, then reduce it by a factor of 2 again to 250")},m(T,w){l(T,d,w)},d(T){T&&s(d)}}}function Wa(f){let d,T=`Here we have set <code>push_to_hub=True</code> to enable automatic upload of our fine-tuned checkpoints during training. Should you
not wish for your checkpoints to be uploaded to the Hub, you can set this to <code>False</code>.`;return{c(){d=i("p"),d.innerHTML=T},l(w){d=M(w,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1ts6au6"&&(d.innerHTML=T)},m(w,g){l(w,d,g)},p:dl,d(w){w&&s(d)}}}function _a(f){let d,T=`Depending on your GPU, it is possible that you will encounter a CUDA <code>&quot;out-of-memory&quot;</code> error when you start training.
In this case, you can reduce the <code>batch_size</code> incrementally by factors of 2 and employ <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments.gradient_accumulation_steps" rel="nofollow"><code>gradient_accumulation_steps</code></a>
to compensate.`;return{c(){d=i("p"),d.innerHTML=T},l(w){d=M(w,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1icakx9"&&(d.innerHTML=T)},m(w,g){l(w,d,g)},p:dl,d(w){w&&s(d)}}}function Ba(f){let d,T,w,g,v,Jt,Z,hl=`In this section, we’ll present a step-by-step guide on fine-tuning an encoder-only transformer model for music classification.
We’ll use a lightweight model for this demonstration and fairly small dataset, meaning the code is runnable end-to-end
on any consumer grade GPU, including the T4 16GB GPU provided in the Google Colab free tier. The section includes various
tips that you can try should you have a smaller GPU and encounter memory issues along the way.`,jt,x,Ut,W,wl=`To train our model, we’ll use the <a href="https://huggingface.co/datasets/marsyas/gtzan" rel="nofollow">GTZAN</a> dataset, which is a popular
dataset of 1,000 songs for music genre classification. Each song is a 30-second clip from one of 10 genres of music,
spanning disco to metal. We can get the audio files and their corresponding labels from the Hugging Face Hub with the
<code>load_dataset()</code> function from 🤗 Datasets:`,ft,_,gt,B,Tl="<strong>Output:</strong>",Ct,N,It,C,bt,Q,Jl=`GTZAN doesn’t provide a predefined validation set, so we’ll have to create one ourselves. The dataset is balanced across
genres, so we can use the <code>train_test_split()</code> method to quickly create a 90/10 split as follows:`,At,E,$t,R,jl="<strong>Output:</strong>",kt,G,vt,Y,Ul="Great, now that we’ve got our training and validation sets, let’s take a look at one of the audio files:",Zt,z,xt,F,fl="<strong>Output:</strong>",Wt,V,_t,X,gl=`As we saw in <a href="../chapter1/audio_data">Unit 1</a>, the audio files are represented as 1-dimensional NumPy arrays,
where the value of the array represents the amplitude at that timestep. For these songs, the sampling rate is 22,050 Hz,
meaning there are 22,050 amplitude values sampled per second. We’ll have to keep this in mind when using a pretrained model
with a different sampling rate, converting the sampling rates ourselves to ensure they match. We can also see the genre
is represented as an integer, or <em>class label</em>, which is the format the model will make it’s predictions in. Let’s use the
<code>int2str()</code> method of the <code>genre</code> feature to map these integers to human-readable names:`,Bt,H,Nt,D,Cl="<strong>Output:</strong>",Qt,S,Et,q,Il=`This label looks correct, since it matches the filename of the audio file. Let’s now listen to a few more examples by
using Gradio to create a simple interface with the <code>Blocks</code> API:`,Rt,L,Gt,j,bl,Yt,P,Al=`From these samples we can certainly hear the difference between genres, but can a transformer do this too? Let’s train a
model to find out! First, we’ll need to find a suitable pretrained model for this task. Let’s see how we can do that.`,zt,O,Ft,K,$l=`To get started, let’s pick a suitable pretrained model for audio classification. In this domain, pretraining is typically
carried out on large amounts of unlabeled audio data, using datasets like <a href="https://huggingface.co/datasets/librispeech_asr" rel="nofollow">LibriSpeech</a>
and <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">Voxpopuli</a>. The best way to find these models on the Hugging
Face Hub is to use the “Audio Classification” filter, as described in the previous section. Although models like Wav2Vec2 and
HuBERT are very popular, we’ll use a model called <em>DistilHuBERT</em>. This is a much smaller (or <em>distilled</em>) version of the <a href="https://huggingface.co/docs/transformers/model_doc/hubert" rel="nofollow">HuBERT</a>
model, which trains around 73% faster, yet preserves most of the performance.`,Vt,U,kl,Xt,ee,Ht,te,Dt,se,vl=`Similar to tokenization in NLP, audio and speech models require the input to be encoded in a format that the model
can process. In 🤗 Transformers, the conversion from audio to the input format is handled by the <em>feature extractor</em> of
the model. Similar to tokenizers, 🤗 Transformers provides a convenient <code>AutoFeatureExtractor</code> class that can automatically
select the correct feature extractor for a given model. To see how we can process our audio files, let’s begin by instantiating
the feature extractor for DistilHuBERT from the pre-trained checkpoint:`,St,le,qt,ae,Zl=`Since the sampling rate of the model and the dataset are different, we’ll have to resample the audio file to 16,000
Hz before passing it to the feature extractor. We can do this by first obtaining the model’s sample rate from the feature
extractor:`,Lt,ne,Pt,ie,xl="<strong>Output:</strong>",Ot,Me,Kt,re,Wl="Next, we resample the dataset using the <code>cast_column()</code> method and <code>Audio</code> feature from 🤗 Datasets:",es,pe,ts,oe,_l=`We can now check the first sample of the train-split of our dataset to verify that it is indeed at 16,000 Hz. 🤗 Datasets
will resample the audio file <em>on-the-fly</em> when we load each audio sample:`,ss,ue,ls,ye,Bl="<strong>Output:</strong>",as,ce,ns,me,Nl=`Great! We can see that the sampling rate has been downsampled to 16kHz. The array values are also different, as we’ve
now only got approximately one amplitude value for every 1.5 that we had before.`,is,de,Ql=`A defining feature of Wav2Vec2 and HuBERT like models is that they accept a float array corresponding to the raw waveform
of the speech signal as an input. This is in contrast to other models, like Whisper, where we pre-process the raw audio waveform
to spectrogram format.`,Ms,he,El=`We mentioned that the audio data is represented as a 1-dimensional array, so it’s already in the right format to be read
by the model (a set of continuous inputs at discrete time steps). So, what exactly does the feature extractor do?`,rs,we,Rl=`Well, the audio data is in the right format, but we’ve imposed no restrictions on the values it can take. For our model to
work optimally, we want to keep all the inputs within the same dynamic range. This is going to make sure we get a similar
range of activations and gradients for our samples, helping with stability and convergence during training.`,ps,Te,Gl=`To do this, we <em>normalise</em> our audio data, by rescaling each sample to zero mean and unit variance, a process called
<em>feature scaling</em>. It’s exactly this feature normalisation that our feature extractor performs!`,os,Je,Yl=`We can take a look at the feature extractor in operation by applying it to our first audio sample. First, let’s compute
the mean and variance of our raw audio data:`,us,je,ys,Ue,zl="<strong>Output:</strong>",cs,fe,ms,ge,Fl=`We can see that the mean is close to zero already, but the variance is closer to 0.05. If the variance for the sample was
larger, it could cause our model problems, since the dynamic range of the audio data would be very small and thus difficult to
separate. Let’s apply the feature extractor and see what the outputs look like:`,ds,Ce,hs,Ie,Vl="<strong>Output:</strong>",ws,be,Ts,Ae,Xl=`Alright! Our feature extractor returns a dictionary of two arrays: <code>input_values</code> and <code>attention_mask</code>. The <code>input_values</code>
are the preprocessed audio inputs that we’d pass to the HuBERT model. The <a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow"><code>attention_mask</code></a>
is used when we process a <em>batch</em> of audio inputs at once - it is used to tell the model where we have padded inputs of
different lengths.`,Js,$e,Hl=`We can see that the mean value is now very much closer to zero, and the variance bang-on one! This is exactly the form we
want our audio samples in prior to feeding them to the HuBERT model.`,js,I,Us,ke,Dl=`Great, so now we know how to process our resampled audio files, the last thing to do is define a function that we can
apply to all the examples in the dataset. Since we expect the audio clips to be 30 seconds in length, we’ll also
truncate any longer clips by using the <code>max_length</code> and <code>truncation</code> arguments of the feature extractor as follows:`,fs,ve,gs,Ze,Sl=`With this function defined, we can now apply it to the dataset using the <a href="https://huggingface.co/docs/datasets/v2.14.0/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow"><code>map()</code></a>
method. The <code>.map()</code> method supports working with batches of examples, which we’ll enable by setting <code>batched=True</code>.
The default batch size is 1000, but we’ll reduce it to 100 to ensure the peak RAM stays within a sensible range for
Google Colab’s free tier:`,Cs,xe,Is,We,ql="<strong>Output:</strong>",bs,_e,As,b,$s,Be,Ll=`To simplify the training, we’ve removed the <code>audio</code> and <code>file</code> columns from the dataset. The <code>input_values</code> column contains
the encoded audio files, the <code>attention_mask</code> a binary mask of 0/1 values that indicate where we have padded the audio input,
and the <code>genre</code> column contains the corresponding labels (or targets). To enable the <code>Trainer</code> to process the class labels,
we need to rename the <code>genre</code> column to <code>label</code>:`,ks,Ne,vs,Qe,Pl=`Finally, we need to obtain the label mappings from the dataset. This mapping will take us from integer ids (e.g. <code>7</code>) to
human-readable class labels (e.g. <code>&quot;pop&quot;</code>) and back again. In doing so, we can convert our model’s integer id prediction
into human-readable format, enabling us to use the model in any downstream application. We can do this by using the <code>int2str()</code>
method as follows:`,Zs,Ee,xs,Re,Ws,Ge,Ol="OK, we’ve now got a dataset that’s ready for training! Let’s take a look at how we can train a model on this dataset.",_s,Ye,Bs,ze,Kl=`To fine-tune the model, we’ll use the <code>Trainer</code> class from 🤗 Transformers. As we’ve seen in other chapters, the <code>Trainer</code>
is a high-level API that is designed to handle the most common training scenarios. In this case, we’ll use the <code>Trainer</code>
to fine-tune the model on GTZAN. To do this, we’ll first need to load a model for this task. We can do this by using the
<code>AutoModelForAudioClassification</code> class, which will automatically add the appropriate classification head to our pretrained
DistilHuBERT model. Let’s go ahead and instantiate the model:`,Ns,Fe,Qs,Ve,ea=`We strongly advise you to upload model checkpoints directly the <a href="https://huggingface.co/" rel="nofollow">Hugging Face Hub</a> while training.
The Hub provides:`,Es,Xe,ta="<li>Integrated version control: you can be sure that no model checkpoint is lost during training.</li> <li>Tensorboard logs: track important metrics over the course of training.</li> <li>Model cards: document what a model does and its intended use cases.</li> <li>Community: an easy way to share and collaborate with the community! 🤗</li>",Rs,He,sa=`Linking the notebook to the Hub is straightforward - it simply requires entering your Hub authentication token when prompted.
Find your Hub authentication token <a href="https://huggingface.co/settings/tokens" rel="nofollow">here</a>:`,Gs,De,Ys,Se,la="<strong>Output:</strong>",zs,qe,Fs,Le,aa=`The next step is to define the training arguments, including the batch size, gradient accumulation steps, number of
training epochs and learning rate:`,Vs,Pe,Xs,A,Hs,Oe,na=`The last thing we need to do is define the metrics. Since the dataset is balanced, we’ll use accuracy as our metric and
load it using the 🤗 Evaluate library:`,Ds,Ke,Ss,et,ia="We’ve now got all the pieces! Let’s instantiate the <code>Trainer</code> and train the model:",qs,tt,Ls,$,Ps,st,Ma="<strong>Output:</strong>",Os,lt,Ks,at,ra=`Training will take approximately 1 hour depending on your GPU or the one allocated to the Google Colab. Our best
evaluation accuracy is 83% - not bad for just 10 epochs with 899 examples of training data! We could certainly improve
upon this result by training for more epochs, using regularisation techniques such as <em>dropout</em>, or sub-diving each
audio example from 30s into 15s segments to use a more efficient data pre-processing strategy.`,el,nt,pa=`The big question is how this compares to other music classification systems 🤔
For that, we can view the <a href="https://huggingface.co/spaces/autoevaluate/leaderboards?dataset=marsyas%2Fgtzan&amp;only_verified=0&amp;task=audio-classification&amp;config=all&amp;split=train&amp;metric=accuracy" rel="nofollow">autoevaluate leaderboard</a>,
a leaderboard that categorises models by language and dataset, and subsequently ranks them according to their accuracy.`,tl,it,oa=`We can automatically submit our checkpoint to the leaderboard when we push the training results to the Hub - we simply have
to set the appropriate key-word arguments (kwargs). You can change these values to match your dataset, language and model name
accordingly:`,sl,Mt,ll,rt,ua="The training results can now be uploaded to the Hub. To do so, execute the <code>.push_to_hub</code> command:",al,pt,nl,ot,ya=`This will save the training logs and model weights under <code>&quot;your-username/distilhubert-finetuned-gtzan&quot;</code>. For this example,
check out the upload at <a href="https://huggingface.co/sanchit-gandhi/distilhubert-finetuned-gtzan" rel="nofollow"><code>&quot;sanchit-gandhi/distilhubert-finetuned-gtzan&quot;</code></a>.`,il,ut,Ml,yt,ca=`You can now share this model with anyone using the link on the Hub. They can load it with the identifier <code>&quot;your-username/distilhubert-finetuned-gtzan&quot;</code>
directly into the <code>pipeline()</code> class. For instance, to load the fine-tuned checkpoint <a href="https://huggingface.co/sanchit-gandhi/distilhubert-finetuned-gtzan" rel="nofollow"><code>&quot;sanchit-gandhi/distilhubert-finetuned-gtzan&quot;</code></a>:`,rl,ct,pl,mt,ol,dt,ma=`In this section, we’ve covered a step-by-step guide for fine-tuning the DistilHuBERT model for music classification. While
we focussed on the task of music classification and the GTZAN dataset, the steps presented here apply more generally to any
audio classification task - the same script can be used for spoken language audio classification tasks like keyword spotting
or language identification. You just need to swap out the dataset for one that corresponds to your task of interest! If
you’re interested in fine-tuning other Hugging Face Hub models for audio classification, we encourage you to check out the
other <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/audio-classification" rel="nofollow">examples</a> in the 🤗
Transformers repository.`,ul,ht,da=`In the next section, we’ll take the model that you just fine-tuned and build a music classification demo that you can share
on the Hugging Face Hub.`,yl,wt,cl;return v=new k({props:{title:"Fine-tuning a model for music classification",local:"fine-tuning-a-model-for-music-classification",headingTag:"h1"}}),x=new k({props:{title:"The Dataset",local:"the-dataset",headingTag:"h2"}}),_=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZ3R6YW4lMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybWFyc3lhcyUyRmd0emFuJTIyJTJDJTIwJTIyYWxsJTIyKSUwQWd0emFu",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

gtzan = load_dataset(<span class="hljs-string">&quot;marsyas/gtzan&quot;</span>, <span class="hljs-string">&quot;all&quot;</span>)
gtzan`,wrap:!1}}),N=new h({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAnZ2VucmUnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA5OTklMEElN0Qp",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;genre&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">999</span>
})`,wrap:!1}}),C=new Tt({props:{warning:!0,$$slots:{default:[va]},$$scope:{ctx:f}}}),E=new h({props:{code:"Z3R6YW4lMjAlM0QlMjBndHphbiU1QiUyMnRyYWluJTIyJTVELnRyYWluX3Rlc3Rfc3BsaXQoc2VlZCUzRDQyJTJDJTIwc2h1ZmZsZSUzRFRydWUlMkMlMjB0ZXN0X3NpemUlM0QwLjEpJTBBZ3R6YW4=",highlighted:`gtzan = gtzan[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(seed=<span class="hljs-number">42</span>, shuffle=<span class="hljs-literal">True</span>, test_size=<span class="hljs-number">0.1</span>)
gtzan`,wrap:!1}}),G=new h({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2ZpbGUnJTJDJTIwJ2F1ZGlvJyUyQyUyMCdnZW5yZSclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDg5OSUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB0ZXN0JTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAnZ2VucmUnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjAxMDAlMEElMjAlMjAlMjAlMjAlN0QpJTBBJTdEKQ==",highlighted:`DatasetDict({
    train: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;genre&#x27;</span>],
        num_rows: <span class="hljs-number">899</span>
    })
    test: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;genre&#x27;</span>],
        num_rows: <span class="hljs-number">100</span>
    })
})`,wrap:!1}}),z=new h({props:{code:"Z3R6YW4lNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:'gtzan[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]',wrap:!1}}),V=new h({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZmlsZSUyMiUzQSUyMCUyMn4lMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZmEwNmNlNDYxMzBkMzQ2NzY4MzEwMGFjYTk0NWQ2ZGVhZmI2NDIzMTU3NjVhNzg0NDU2ZTFkODFjOTQ3MTVhOCUyRmdlbnJlcyUyRnBvcCUyRnBvcC4wMDA5OC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjJ+JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmZhMDZjZTQ2MTMwZDM0Njc2ODMxMDBhY2E5NDVkNmRlYWZiNjQyMzE1NzY1YTc4NDQ1NmUxZDgxYzk0NzE1YTglMkZnZW5yZXMlMkZwb3AlMkZwb3AuMDAwOTgud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwLjEwNzIwODI1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMC4xNjEyMjQzNyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDAuMjg1ODU4MTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtMC4yMjkyNDgwNSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0wLjIwNjI5ODgzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLTAuMTEzMzQyMjklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDIyMDUwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2VucmUlMjIlM0ElMjA3JTJDJTBBJTdE",highlighted:`{
    <span class="hljs-string">&quot;file&quot;</span>: <span class="hljs-string">&quot;~/.cache/huggingface/datasets/downloads/extracted/fa06ce46130d3467683100aca945d6deafb642315765a784456e1d81c94715a8/genres/pop/pop.00098.wav&quot;</span>,
    <span class="hljs-string">&quot;audio&quot;</span>: {
        <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;~/.cache/huggingface/datasets/downloads/extracted/fa06ce46130d3467683100aca945d6deafb642315765a784456e1d81c94715a8/genres/pop/pop.00098.wav&quot;</span>,
        <span class="hljs-string">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">0.10720825</span>,
                <span class="hljs-number">0.16122437</span>,
                <span class="hljs-number">0.28585815</span>,
                ...,
                <span class="hljs-number">-0.22924805</span>,
                <span class="hljs-number">-0.20629883</span>,
                <span class="hljs-number">-0.11334229</span>,
            ],
            d<span class="hljs-keyword">type</span>=float32,
        ),
        <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">22050</span>,
    },
    <span class="hljs-string">&quot;genre&quot;</span>: <span class="hljs-number">7</span>,
}`,wrap:!1}}),H=new h({props:{code:"aWQybGFiZWxfZm4lMjAlM0QlMjBndHphbiU1QiUyMnRyYWluJTIyJTVELmZlYXR1cmVzJTVCJTIyZ2VucmUlMjIlNUQuaW50MnN0ciUwQWlkMmxhYmVsX2ZuKGd0emFuJTVCJTIydHJhaW4lMjIlNUQlNUIwJTVEJTVCJTIyZ2VucmUlMjIlNUQp",highlighted:`id2label_fn = gtzan[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;genre&quot;</span>].int2str
id2label_fn(gtzan[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;genre&quot;</span>])`,wrap:!1}}),S=new h({props:{code:"J3BvcCc=",highlighted:'<span class="hljs-symbol">&#x27;pop</span>&#x27;',wrap:!1}}),L=new h({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwZ3R6YW4lNUIlMjJ0cmFpbiUyMiU1RC5zaHVmZmxlKCklNUIwJTVEJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMjBpZDJsYWJlbF9mbihleGFtcGxlJTVCJTIyZ2VucmUlMjIlNUQpJTBBJTBBJTBBd2l0aCUyMGdyLkJsb2NrcygpJTIwYXMlMjBkZW1vJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGdyLkNvbHVtbigpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwXyUyMGluJTIwcmFuZ2UoNCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyQyUyMGxhYmVsJTIwJTNEJTIwZ2VuZXJhdGVfYXVkaW8oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMGdyLkF1ZGlvKGF1ZGlvJTJDJTIwbGFiZWwlM0RsYWJlbCklMEElMEFkZW1vLmxhdW5jaChkZWJ1ZyUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = gtzan[<span class="hljs-string">&quot;train&quot;</span>].shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label_fn(example[<span class="hljs-string">&quot;genre&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),O=new k({props:{title:"Picking a pretrained model for audio classification",local:"picking-a-pretrained-model-for-audio-classification",headingTag:"h2"}}),ee=new k({props:{title:"From audio to machine learning features",local:"from-audio-to-machine-learning-features",headingTag:"h2"}}),te=new k({props:{title:"Preprocessing the data",local:"preprocessing-the-data",headingTag:"h2"}}),le=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJudHUtc3BtbCUyRmRpc3RpbGh1YmVydCUyMiUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwZG9fbm9ybWFsaXplJTNEVHJ1ZSUyQyUyMHJldHVybl9hdHRlbnRpb25fbWFzayUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

model_id = <span class="hljs-string">&quot;ntu-spml/distilhubert&quot;</span>
feature_extractor = AutoFeatureExtractor.from_pretrained(
    model_id, do_normalize=<span class="hljs-literal">True</span>, return_attention_mask=<span class="hljs-literal">True</span>
)`,wrap:!1}}),ne=new h({props:{code:"c2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMEFzYW1wbGluZ19yYXRl",highlighted:`sampling_rate = feature_extractor.sampling_rate
sampling_rate`,wrap:!1}}),Me=new h({props:{code:"MTYwMDA=",highlighted:"16000",wrap:!1}}),pe=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFndHphbiUyMCUzRCUyMGd0emFuLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUpKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

gtzan = gtzan.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=sampling_rate))`,wrap:!1}}),ue=new h({props:{code:"Z3R6YW4lNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:'gtzan[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]',wrap:!1}}),ce=new h({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZmlsZSUyMiUzQSUyMCUyMn4lMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZmEwNmNlNDYxMzBkMzQ2NzY4MzEwMGFjYTk0NWQ2ZGVhZmI2NDIzMTU3NjVhNzg0NDU2ZTFkODFjOTQ3MTVhOCUyRmdlbnJlcyUyRnBvcCUyRnBvcC4wMDA5OC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjJ+JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmZhMDZjZTQ2MTMwZDM0Njc2ODMxMDBhY2E5NDVkNmRlYWZiNjQyMzE1NzY1YTc4NDQ1NmUxZDgxYzk0NzE1YTglMkZnZW5yZXMlMkZwb3AlMkZwb3AuMDAwOTgud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwLjA4NzM1MDklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwLjIwMTgzMzg0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMC40NzkwODY3JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLTAuMTg3NDMxNzglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtMC4yMzI5NDQwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0wLjEzNTE3NDI3JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHR5cGUlM0RmbG9hdDMyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNhbXBsaW5nX3JhdGUlMjIlM0ElMjAxNjAwMCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmdlbnJlJTIyJTNBJTIwNyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-string">&quot;file&quot;</span>: <span class="hljs-string">&quot;~/.cache/huggingface/datasets/downloads/extracted/fa06ce46130d3467683100aca945d6deafb642315765a784456e1d81c94715a8/genres/pop/pop.00098.wav&quot;</span>,
    <span class="hljs-string">&quot;audio&quot;</span>: {
        <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;~/.cache/huggingface/datasets/downloads/extracted/fa06ce46130d3467683100aca945d6deafb642315765a784456e1d81c94715a8/genres/pop/pop.00098.wav&quot;</span>,
        <span class="hljs-string">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">0.0873509</span>,
                <span class="hljs-number">0.20183384</span>,
                <span class="hljs-number">0.4790867</span>,
                ...,
                <span class="hljs-number">-0.18743178</span>,
                <span class="hljs-number">-0.23294401</span>,
                <span class="hljs-number">-0.13517427</span>,
            ],
            d<span class="hljs-keyword">type</span>=float32,
        ),
        <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-string">&quot;genre&quot;</span>: <span class="hljs-number">7</span>,
}`,wrap:!1}}),je=new h({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBc2FtcGxlJTIwJTNEJTIwZ3R6YW4lNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCUwQSUwQXByaW50KGYlMjJNZWFuJTNBJTIwJTdCbnAubWVhbihzYW1wbGUlNUInYXJyYXknJTVEKSUzQS4zJTdEJTJDJTIwVmFyaWFuY2UlM0ElMjAlN0JucC52YXIoc2FtcGxlJTVCJ2FycmF5JyU1RCklM0EuMyU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

sample = gtzan[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Mean: <span class="hljs-subst">{np.mean(sample[<span class="hljs-string">&#x27;array&#x27;</span>]):<span class="hljs-number">.3</span>}</span>, Variance: <span class="hljs-subst">{np.var(sample[<span class="hljs-string">&#x27;array&#x27;</span>]):<span class="hljs-number">.3</span>}</span>&quot;</span>)`,wrap:!1}}),fe=new h({props:{code:"TWVhbiUzQSUyMDAuMDAwMTg1JTJDJTIwVmFyaWFuY2UlM0ElMjAwLjA0OTM=",highlighted:'<span class="hljs-attribute">Mean</span>: <span class="hljs-number">0</span>.<span class="hljs-number">000185</span>, Variance: <span class="hljs-number">0</span>.<span class="hljs-number">0493</span>',wrap:!1}}),Ce=new h({props:{code:"aW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3Ioc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxlJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCklMEElMEFwcmludChmJTIyaW5wdXRzJTIwa2V5cyUzQSUyMCU3Qmxpc3QoaW5wdXRzLmtleXMoKSklN0QlMjIpJTBBJTBBcHJpbnQoJTBBJTIwJTIwJTIwJTIwZiUyMk1lYW4lM0ElMjAlN0JucC5tZWFuKGlucHV0cyU1QidpbnB1dF92YWx1ZXMnJTVEKSUzQS4zJTdEJTJDJTIwVmFyaWFuY2UlM0ElMjAlN0JucC52YXIoaW5wdXRzJTVCJ2lucHV0X3ZhbHVlcyclNUQpJTNBLjMlN0QlMjIlMEEp",highlighted:`inputs = feature_extractor(sample[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>])

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;inputs keys: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(inputs.keys())}</span>&quot;</span>)

<span class="hljs-built_in">print</span>(
    <span class="hljs-string">f&quot;Mean: <span class="hljs-subst">{np.mean(inputs[<span class="hljs-string">&#x27;input_values&#x27;</span>]):<span class="hljs-number">.3</span>}</span>, Variance: <span class="hljs-subst">{np.var(inputs[<span class="hljs-string">&#x27;input_values&#x27;</span>]):<span class="hljs-number">.3</span>}</span>&quot;</span>
)`,wrap:!1}}),be=new h({props:{code:"aW5wdXRzJTIwa2V5cyUzQSUyMCU1QidpbnB1dF92YWx1ZXMnJTJDJTIwJ2F0dGVudGlvbl9tYXNrJyU1RCUwQU1lYW4lM0ElMjAtNC41M2UtMDklMkMlMjBWYXJpYW5jZSUzQSUyMDEuMA==",highlighted:`<span class="hljs-attribute">inputs</span> keys:<span class="hljs-meta"> [&#x27;input_values&#x27;, &#x27;attention_mask&#x27;]</span>
<span class="hljs-attribute">Mean</span>: -<span class="hljs-number">4</span>.<span class="hljs-number">53</span>e-<span class="hljs-number">09</span>, Variance: <span class="hljs-number">1</span>.<span class="hljs-number">0</span>`,wrap:!1}}),I=new Tt({props:{warning:!0,$$slots:{default:[Za]},$$scope:{ctx:f}}}),ve=new h({props:{code:"bWF4X2R1cmF0aW9uJTIwJTNEJTIwMzAuMCUwQSUwQSUwQWRlZiUyMHByZXByb2Nlc3NfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW9fYXJyYXlzJTIwJTNEJTIwJTVCeCU1QiUyMmFycmF5JTIyJTVEJTIwZm9yJTIweCUyMGluJTIwZXhhbXBsZXMlNUIlMjJhdWRpbyUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvX2FycmF5cyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RmZWF0dXJlX2V4dHJhY3Rvci5zYW1wbGluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRGludChmZWF0dXJlX2V4dHJhY3Rvci5zYW1wbGluZ19yYXRlJTIwKiUyMG1heF9kdXJhdGlvbiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9hdHRlbnRpb25fbWFzayUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW5wdXRz",highlighted:`max_duration = <span class="hljs-number">30.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    audio_arrays = [x[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;audio&quot;</span>]]
    inputs = feature_extractor(
        audio_arrays,
        sampling_rate=feature_extractor.sampling_rate,
        max_length=<span class="hljs-built_in">int</span>(feature_extractor.sampling_rate * max_duration),
        truncation=<span class="hljs-literal">True</span>,
        return_attention_mask=<span class="hljs-literal">True</span>,
    )
    <span class="hljs-keyword">return</span> inputs`,wrap:!1}}),xe=new h({props:{code:"Z3R6YW5fZW5jb2RlZCUyMCUzRCUyMGd0emFuLm1hcCglMEElMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2Z1bmN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIlMjJhdWRpbyUyMiUyQyUyMCUyMmZpbGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjBudW1fcHJvYyUzRDElMkMlMEEpJTBBZ3R6YW5fZW5jb2RlZA==",highlighted:`gtzan_encoded = gtzan.<span class="hljs-built_in">map</span>(
    preprocess_function,
    remove_columns=[<span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;file&quot;</span>],
    batched=<span class="hljs-literal">True</span>,
    batch_size=<span class="hljs-number">100</span>,
    num_proc=<span class="hljs-number">1</span>,
)
gtzan_encoded`,wrap:!1}}),_e=new h({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2dlbnJlJyUyQyUyMCdpbnB1dF92YWx1ZXMnJTJDJ2F0dGVudGlvbl9tYXNrJyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwODk5JTBBJTIwJTIwJTIwJTIwJTdEKSUwQSUyMCUyMCUyMCUyMHRlc3QlM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2dlbnJlJyUyQyUyMCdpbnB1dF92YWx1ZXMnJTJDJ2F0dGVudGlvbl9tYXNrJyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMTAwJTBBJTIwJTIwJTIwJTIwJTdEKSUwQSU3RCk=",highlighted:`DatasetDict({
    train: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;genre&#x27;</span>, <span class="hljs-string">&#x27;input_values&#x27;</span>,<span class="hljs-string">&#x27;attention_mask&#x27;</span>],
        num_rows: <span class="hljs-number">899</span>
    })
    test: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;genre&#x27;</span>, <span class="hljs-string">&#x27;input_values&#x27;</span>,<span class="hljs-string">&#x27;attention_mask&#x27;</span>],
        num_rows: <span class="hljs-number">100</span>
    })
})`,wrap:!1}}),b=new Tt({props:{warning:!0,$$slots:{default:[xa]},$$scope:{ctx:f}}}),Ne=new h({props:{code:"Z3R6YW5fZW5jb2RlZCUyMCUzRCUyMGd0emFuX2VuY29kZWQucmVuYW1lX2NvbHVtbiglMjJnZW5yZSUyMiUyQyUyMCUyMmxhYmVsJTIyKQ==",highlighted:'gtzan_encoded = gtzan_encoded.rename_column(<span class="hljs-string">&quot;genre&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>)',wrap:!1}}),Ee=new h({props:{code:"aWQybGFiZWwlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBzdHIoaSklM0ElMjBpZDJsYWJlbF9mbihpKSUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihndHphbl9lbmNvZGVkJTVCJTIydHJhaW4lMjIlNUQuZmVhdHVyZXMlNUIlMjJsYWJlbCUyMiU1RC5uYW1lcykpJTBBJTdEJTBBbGFiZWwyaWQlMjAlM0QlMjAlN0J2JTNBJTIwayUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpZDJsYWJlbC5pdGVtcygpJTdEJTBBJTBBaWQybGFiZWwlNUIlMjI3JTIyJTVE",highlighted:`id2label = {
    <span class="hljs-built_in">str</span>(i): id2label_fn(i)
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(gtzan_encoded[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names))
}
label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}

id2label[<span class="hljs-string">&quot;7&quot;</span>]`,wrap:!1}}),Re=new h({props:{code:"J3BvcCc=",highlighted:'<span class="hljs-symbol">&#x27;pop</span>&#x27;',wrap:!1}}),Ye=new k({props:{title:"Fine-tuning the model",local:"fine-tuning-the-model",headingTag:"h2"}}),Fe=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEElMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKGlkMmxhYmVsKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsMmlkJTNEbGFiZWwyaWQlMkMlMEElMjAlMjAlMjAlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForAudioClassification

num_labels = <span class="hljs-built_in">len</span>(id2label)

model = AutoModelForAudioClassification.from_pretrained(
    model_id,
    num_labels=num_labels,
    label2id=label2id,
    id2label=id2label,
)`,wrap:!1}}),De=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),qe=new h({props:{code:"TG9naW4lMjBzdWNjZXNzZnVsJTBBWW91ciUyMHRva2VuJTIwaGFzJTIwYmVlbiUyMHNhdmVkJTIwdG8lMjAlMkZyb290JTJGLmh1Z2dpbmdmYWNlJTJGdG9rZW4=",highlighted:`Login successful
Your token has been saved to /root/.huggingface/token`,wrap:!1}}),Pe=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX2lkLnNwbGl0KCUyMiUyRiUyMiklNUItMSU1RCUwQWJhdGNoX3NpemUlMjAlM0QlMjA4JTBBZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwJTNEJTIwMSUwQW51bV90cmFpbl9lcG9jaHMlMjAlM0QlMjAxMCUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBmJTIyJTdCbW9kZWxfbmFtZSU3RC1maW5ldHVuZWQtZ3R6YW4lMjIlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNENWUtNSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0RncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEbnVtX3RyYWluX2Vwb2NocyUyQyUwQSUyMCUyMCUyMCUyMHdhcm11cF9yYXRpbyUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RlcHMlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBtZXRyaWNfZm9yX2Jlc3RfbW9kZWwlM0QlMjJhY2N1cmFjeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

model_name = model_id.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>]
batch_size = <span class="hljs-number">8</span>
gradient_accumulation_steps = <span class="hljs-number">1</span>
num_train_epochs = <span class="hljs-number">10</span>

training_args = TrainingArguments(
    <span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>-finetuned-gtzan&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">5e-5</span>,
    per_device_train_batch_size=batch_size,
    gradient_accumulation_steps=gradient_accumulation_steps,
    per_device_eval_batch_size=batch_size,
    num_train_epochs=num_train_epochs,
    warmup_ratio=<span class="hljs-number">0.1</span>,
    logging_steps=<span class="hljs-number">5</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;accuracy&quot;</span>,
    fp16=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),A=new Tt({props:{warning:!0,$$slots:{default:[Wa]},$$scope:{ctx:f}}}),Ke=new h({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmFjY3VyYWN5JTIyKSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ29tcHV0ZXMlMjBhY2N1cmFjeSUyMG9uJTIwYSUyMGJhdGNoJTIwb2YlMjBwcmVkaWN0aW9ucyUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KGV2YWxfcHJlZC5wcmVkaWN0aW9ucyUyQyUyMGF4aXMlM0QxKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEZXZhbF9wcmVkLmxhYmVsX2lkcyk=",highlighted:`<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    <span class="hljs-string">&quot;&quot;&quot;Computes accuracy on a batch of predictions&quot;&quot;&quot;</span>
    predictions = np.argmax(eval_pred.predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=eval_pred.label_ids)`,wrap:!1}}),tt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZ3R6YW5fZW5jb2RlZCU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZ3R6YW5fZW5jb2RlZCU1QiUyMnRlc3QlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=gtzan_encoded[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=gtzan_encoded[<span class="hljs-string">&quot;test&quot;</span>],
    tokenizer=feature_extractor,
    compute_metrics=compute_metrics,
)

trainer.train()`,wrap:!1}}),$=new Tt({props:{warning:!0,$$slots:{default:[_a]},$$scope:{ctx:f}}}),lt=new h({props:{code:"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",highlighted:`|<span class="hljs-string"> Training Loss </span>|<span class="hljs-string"> Epoch </span>|<span class="hljs-string"> Step </span>|<span class="hljs-string"> Validation Loss </span>|<span class="hljs-string"> Accuracy </span>|
|<span class="hljs-string">:-------------:</span>|<span class="hljs-string">:-----:</span>|<span class="hljs-string">:----:</span>|<span class="hljs-string">:---------------:</span>|<span class="hljs-string">:--------:</span>|
|<span class="hljs-string"> 1.7297        </span>|<span class="hljs-string"> 1.0   </span>|<span class="hljs-string"> 113  </span>|<span class="hljs-string"> 1.8011          </span>|<span class="hljs-string"> 0.44     </span>|
|<span class="hljs-string"> 1.24          </span>|<span class="hljs-string"> 2.0   </span>|<span class="hljs-string"> 226  </span>|<span class="hljs-string"> 1.3045          </span>|<span class="hljs-string"> 0.64     </span>|
|<span class="hljs-string"> 0.9805        </span>|<span class="hljs-string"> 3.0   </span>|<span class="hljs-string"> 339  </span>|<span class="hljs-string"> 0.9888          </span>|<span class="hljs-string"> 0.7      </span>|
|<span class="hljs-string"> 0.6853        </span>|<span class="hljs-string"> 4.0   </span>|<span class="hljs-string"> 452  </span>|<span class="hljs-string"> 0.7508          </span>|<span class="hljs-string"> 0.79     </span>|
|<span class="hljs-string"> 0.4502        </span>|<span class="hljs-string"> 5.0   </span>|<span class="hljs-string"> 565  </span>|<span class="hljs-string"> 0.6224          </span>|<span class="hljs-string"> 0.81     </span>|
|<span class="hljs-string"> 0.3015        </span>|<span class="hljs-string"> 6.0   </span>|<span class="hljs-string"> 678  </span>|<span class="hljs-string"> 0.5411          </span>|<span class="hljs-string"> 0.83     </span>|
|<span class="hljs-string"> 0.2244        </span>|<span class="hljs-string"> 7.0   </span>|<span class="hljs-string"> 791  </span>|<span class="hljs-string"> 0.6293          </span>|<span class="hljs-string"> 0.78     </span>|
|<span class="hljs-string"> 0.3108        </span>|<span class="hljs-string"> 8.0   </span>|<span class="hljs-string"> 904  </span>|<span class="hljs-string"> 0.5857          </span>|<span class="hljs-string"> 0.81     </span>|
|<span class="hljs-string"> 0.1644        </span>|<span class="hljs-string"> 9.0   </span>|<span class="hljs-string"> 1017 </span>|<span class="hljs-string"> 0.5355          </span>|<span class="hljs-string"> 0.83     </span>|
|<span class="hljs-string"> 0.1198        </span>|<span class="hljs-string"> 10.0  </span>|<span class="hljs-string"> 1130 </span>|<span class="hljs-string"> 0.5716          </span>|<span class="hljs-string"> 0.82     </span>|`,wrap:!1}}),Mt=new h({props:{code:"a3dhcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZGF0YXNldF90YWdzJTIyJTNBJTIwJTIybWFyc3lhcyUyRmd0emFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGF0YXNldCUyMiUzQSUyMCUyMkdUWkFOJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMGYlMjIlN0Jtb2RlbF9uYW1lJTdELWZpbmV0dW5lZC1ndHphbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmZpbmV0dW5lZF9mcm9tJTIyJTNBJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjJ0YXNrcyUyMiUzQSUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTdE",highlighted:`kwargs = {
    <span class="hljs-string">&quot;dataset_tags&quot;</span>: <span class="hljs-string">&quot;marsyas/gtzan&quot;</span>,
    <span class="hljs-string">&quot;dataset&quot;</span>: <span class="hljs-string">&quot;GTZAN&quot;</span>,
    <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>-finetuned-gtzan&quot;</span>,
    <span class="hljs-string">&quot;finetuned_from&quot;</span>: model_id,
    <span class="hljs-string">&quot;tasks&quot;</span>: <span class="hljs-string">&quot;audio-classification&quot;</span>,
}`,wrap:!1}}),pt=new h({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1YigqKmt3YXJncyk=",highlighted:"trainer.push_to_hub(**kwargs)",wrap:!1}}),ut=new k({props:{title:"Share Model",local:"share-model",headingTag:"h2"}}),ct=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzYW5jaGl0LWdhbmRoaSUyRmRpc3RpbGh1YmVydC1maW5ldHVuZWQtZ3R6YW4lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/distilhubert-finetuned-gtzan&quot;</span>
)`,wrap:!1}}),mt=new k({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),{c(){d=i("meta"),T=a(),w=i("p"),g=a(),p(v.$$.fragment),Jt=a(),Z=i("p"),Z.textContent=hl,jt=a(),p(x.$$.fragment),Ut=a(),W=i("p"),W.innerHTML=wl,ft=a(),p(_.$$.fragment),gt=a(),B=i("p"),B.innerHTML=Tl,Ct=a(),p(N.$$.fragment),It=a(),p(C.$$.fragment),bt=a(),Q=i("p"),Q.innerHTML=Jl,At=a(),p(E.$$.fragment),$t=a(),R=i("p"),R.innerHTML=jl,kt=a(),p(G.$$.fragment),vt=a(),Y=i("p"),Y.textContent=Ul,Zt=a(),p(z.$$.fragment),xt=a(),F=i("p"),F.innerHTML=fl,Wt=a(),p(V.$$.fragment),_t=a(),X=i("p"),X.innerHTML=gl,Bt=a(),p(H.$$.fragment),Nt=a(),D=i("p"),D.innerHTML=Cl,Qt=a(),p(S.$$.fragment),Et=a(),q=i("p"),q.innerHTML=Il,Rt=a(),p(L.$$.fragment),Gt=a(),j=i("iframe"),Yt=a(),P=i("p"),P.textContent=Al,zt=a(),p(O.$$.fragment),Ft=a(),K=i("p"),K.innerHTML=$l,Vt=a(),U=i("iframe"),Xt=a(),p(ee.$$.fragment),Ht=a(),p(te.$$.fragment),Dt=a(),se=i("p"),se.innerHTML=vl,St=a(),p(le.$$.fragment),qt=a(),ae=i("p"),ae.textContent=Zl,Lt=a(),p(ne.$$.fragment),Pt=a(),ie=i("p"),ie.innerHTML=xl,Ot=a(),p(Me.$$.fragment),Kt=a(),re=i("p"),re.innerHTML=Wl,es=a(),p(pe.$$.fragment),ts=a(),oe=i("p"),oe.innerHTML=_l,ss=a(),p(ue.$$.fragment),ls=a(),ye=i("p"),ye.innerHTML=Bl,as=a(),p(ce.$$.fragment),ns=a(),me=i("p"),me.textContent=Nl,is=a(),de=i("p"),de.textContent=Ql,Ms=a(),he=i("p"),he.textContent=El,rs=a(),we=i("p"),we.textContent=Rl,ps=a(),Te=i("p"),Te.innerHTML=Gl,os=a(),Je=i("p"),Je.textContent=Yl,us=a(),p(je.$$.fragment),ys=a(),Ue=i("p"),Ue.innerHTML=zl,cs=a(),p(fe.$$.fragment),ms=a(),ge=i("p"),ge.textContent=Fl,ds=a(),p(Ce.$$.fragment),hs=a(),Ie=i("p"),Ie.innerHTML=Vl,ws=a(),p(be.$$.fragment),Ts=a(),Ae=i("p"),Ae.innerHTML=Xl,Js=a(),$e=i("p"),$e.textContent=Hl,js=a(),p(I.$$.fragment),Us=a(),ke=i("p"),ke.innerHTML=Dl,fs=a(),p(ve.$$.fragment),gs=a(),Ze=i("p"),Ze.innerHTML=Sl,Cs=a(),p(xe.$$.fragment),Is=a(),We=i("p"),We.innerHTML=ql,bs=a(),p(_e.$$.fragment),As=a(),p(b.$$.fragment),$s=a(),Be=i("p"),Be.innerHTML=Ll,ks=a(),p(Ne.$$.fragment),vs=a(),Qe=i("p"),Qe.innerHTML=Pl,Zs=a(),p(Ee.$$.fragment),xs=a(),p(Re.$$.fragment),Ws=a(),Ge=i("p"),Ge.textContent=Ol,_s=a(),p(Ye.$$.fragment),Bs=a(),ze=i("p"),ze.innerHTML=Kl,Ns=a(),p(Fe.$$.fragment),Qs=a(),Ve=i("p"),Ve.innerHTML=ea,Es=a(),Xe=i("ul"),Xe.innerHTML=ta,Rs=a(),He=i("p"),He.innerHTML=sa,Gs=a(),p(De.$$.fragment),Ys=a(),Se=i("p"),Se.innerHTML=la,zs=a(),p(qe.$$.fragment),Fs=a(),Le=i("p"),Le.textContent=aa,Vs=a(),p(Pe.$$.fragment),Xs=a(),p(A.$$.fragment),Hs=a(),Oe=i("p"),Oe.textContent=na,Ds=a(),p(Ke.$$.fragment),Ss=a(),et=i("p"),et.innerHTML=ia,qs=a(),p(tt.$$.fragment),Ls=a(),p($.$$.fragment),Ps=a(),st=i("p"),st.innerHTML=Ma,Os=a(),p(lt.$$.fragment),Ks=a(),at=i("p"),at.innerHTML=ra,el=a(),nt=i("p"),nt.innerHTML=pa,tl=a(),it=i("p"),it.textContent=oa,sl=a(),p(Mt.$$.fragment),ll=a(),rt=i("p"),rt.innerHTML=ua,al=a(),p(pt.$$.fragment),nl=a(),ot=i("p"),ot.innerHTML=ya,il=a(),p(ut.$$.fragment),Ml=a(),yt=i("p"),yt.innerHTML=ca,rl=a(),p(ct.$$.fragment),pl=a(),p(mt.$$.fragment),ol=a(),dt=i("p"),dt.innerHTML=ma,ul=a(),ht=i("p"),ht.textContent=da,yl=a(),wt=i("p"),this.h()},l(e){const t=ba("svelte-u9bgzb",document.head);d=M(t,"META",{name:!0,content:!0}),t.forEach(s),T=n(e),w=M(e,"P",{}),ml(w).forEach(s),g=n(e),o(v.$$.fragment,e),Jt=n(e),Z=M(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1leazec"&&(Z.textContent=hl),jt=n(e),o(x.$$.fragment,e),Ut=n(e),W=M(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-rk5isb"&&(W.innerHTML=wl),ft=n(e),o(_.$$.fragment,e),gt=n(e),B=M(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1mvdyro"&&(B.innerHTML=Tl),Ct=n(e),o(N.$$.fragment,e),It=n(e),o(C.$$.fragment,e),bt=n(e),Q=M(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1eeg74r"&&(Q.innerHTML=Jl),At=n(e),o(E.$$.fragment,e),$t=n(e),R=M(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1mvdyro"&&(R.innerHTML=jl),kt=n(e),o(G.$$.fragment,e),vt=n(e),Y=M(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-a6sfr7"&&(Y.textContent=Ul),Zt=n(e),o(z.$$.fragment,e),xt=n(e),F=M(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1mvdyro"&&(F.innerHTML=fl),Wt=n(e),o(V.$$.fragment,e),_t=n(e),X=M(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-13jeh9r"&&(X.innerHTML=gl),Bt=n(e),o(H.$$.fragment,e),Nt=n(e),D=M(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1mvdyro"&&(D.innerHTML=Cl),Qt=n(e),o(S.$$.fragment,e),Et=n(e),q=M(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ewk6mi"&&(q.innerHTML=Il),Rt=n(e),o(L.$$.fragment,e),Gt=n(e),j=M(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ml(j).forEach(s),Yt=n(e),P=M(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1o9i97o"&&(P.textContent=Al),zt=n(e),o(O.$$.fragment,e),Ft=n(e),K=M(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-iivxt"&&(K.innerHTML=$l),Vt=n(e),U=M(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ml(U).forEach(s),Xt=n(e),o(ee.$$.fragment,e),Ht=n(e),o(te.$$.fragment,e),Dt=n(e),se=M(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-rlkncr"&&(se.innerHTML=vl),St=n(e),o(le.$$.fragment,e),qt=n(e),ae=M(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-c2frcd"&&(ae.textContent=Zl),Lt=n(e),o(ne.$$.fragment,e),Pt=n(e),ie=M(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1mvdyro"&&(ie.innerHTML=xl),Ot=n(e),o(Me.$$.fragment,e),Kt=n(e),re=M(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1rpvjq7"&&(re.innerHTML=Wl),es=n(e),o(pe.$$.fragment,e),ts=n(e),oe=M(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1tkp903"&&(oe.innerHTML=_l),ss=n(e),o(ue.$$.fragment,e),ls=n(e),ye=M(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1mvdyro"&&(ye.innerHTML=Bl),as=n(e),o(ce.$$.fragment,e),ns=n(e),me=M(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-7uqj3l"&&(me.textContent=Nl),is=n(e),de=M(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1azahu4"&&(de.textContent=Ql),Ms=n(e),he=M(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-3gbyxr"&&(he.textContent=El),rs=n(e),we=M(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1xxbe6o"&&(we.textContent=Rl),ps=n(e),Te=M(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1oai2nn"&&(Te.innerHTML=Gl),os=n(e),Je=M(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-2wrc8b"&&(Je.textContent=Yl),us=n(e),o(je.$$.fragment,e),ys=n(e),Ue=M(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1mvdyro"&&(Ue.innerHTML=zl),cs=n(e),o(fe.$$.fragment,e),ms=n(e),ge=M(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-vl18rt"&&(ge.textContent=Fl),ds=n(e),o(Ce.$$.fragment,e),hs=n(e),Ie=M(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1mvdyro"&&(Ie.innerHTML=Vl),ws=n(e),o(be.$$.fragment,e),Ts=n(e),Ae=M(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1g6lntp"&&(Ae.innerHTML=Xl),Js=n(e),$e=M(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-jbcmza"&&($e.textContent=Hl),js=n(e),o(I.$$.fragment,e),Us=n(e),ke=M(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-fnovuz"&&(ke.innerHTML=Dl),fs=n(e),o(ve.$$.fragment,e),gs=n(e),Ze=M(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1bmnpnl"&&(Ze.innerHTML=Sl),Cs=n(e),o(xe.$$.fragment,e),Is=n(e),We=M(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1mvdyro"&&(We.innerHTML=ql),bs=n(e),o(_e.$$.fragment,e),As=n(e),o(b.$$.fragment,e),$s=n(e),Be=M(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1r54nk8"&&(Be.innerHTML=Ll),ks=n(e),o(Ne.$$.fragment,e),vs=n(e),Qe=M(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-9mel5l"&&(Qe.innerHTML=Pl),Zs=n(e),o(Ee.$$.fragment,e),xs=n(e),o(Re.$$.fragment,e),Ws=n(e),Ge=M(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1yt0a8x"&&(Ge.textContent=Ol),_s=n(e),o(Ye.$$.fragment,e),Bs=n(e),ze=M(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-fhl4ex"&&(ze.innerHTML=Kl),Ns=n(e),o(Fe.$$.fragment,e),Qs=n(e),Ve=M(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-lavash"&&(Ve.innerHTML=ea),Es=n(e),Xe=M(e,"UL",{"data-svelte-h":!0}),r(Xe)!=="svelte-1vhmuwk"&&(Xe.innerHTML=ta),Rs=n(e),He=M(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-14s52of"&&(He.innerHTML=sa),Gs=n(e),o(De.$$.fragment,e),Ys=n(e),Se=M(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1mvdyro"&&(Se.innerHTML=la),zs=n(e),o(qe.$$.fragment,e),Fs=n(e),Le=M(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-50ips3"&&(Le.textContent=aa),Vs=n(e),o(Pe.$$.fragment,e),Xs=n(e),o(A.$$.fragment,e),Hs=n(e),Oe=M(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-ptp3v8"&&(Oe.textContent=na),Ds=n(e),o(Ke.$$.fragment,e),Ss=n(e),et=M(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1lpo0k9"&&(et.innerHTML=ia),qs=n(e),o(tt.$$.fragment,e),Ls=n(e),o($.$$.fragment,e),Ps=n(e),st=M(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1mvdyro"&&(st.innerHTML=Ma),Os=n(e),o(lt.$$.fragment,e),Ks=n(e),at=M(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-k6is36"&&(at.innerHTML=ra),el=n(e),nt=M(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1wkhb5r"&&(nt.innerHTML=pa),tl=n(e),it=M(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-ctyspf"&&(it.textContent=oa),sl=n(e),o(Mt.$$.fragment,e),ll=n(e),rt=M(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1d7zqbn"&&(rt.innerHTML=ua),al=n(e),o(pt.$$.fragment,e),nl=n(e),ot=M(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-97i0fv"&&(ot.innerHTML=ya),il=n(e),o(ut.$$.fragment,e),Ml=n(e),yt=M(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-8fi8q3"&&(yt.innerHTML=ca),rl=n(e),o(ct.$$.fragment,e),pl=n(e),o(mt.$$.fragment,e),ol=n(e),dt=M(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-zl8n4l"&&(dt.innerHTML=ma),ul=n(e),ht=M(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1d2pb2r"&&(ht.textContent=da),yl=n(e),wt=M(e,"P",{}),ml(wt).forEach(s),this.h()},h(){J(d,"name","hf:doc:metadata"),J(d,"content",Na),Ua(j.src,bl="https://course-demos-gtzan-samples.hf.space")||J(j,"src",bl),J(j,"frameborder","0"),J(j,"height","450"),J(j,"title","Gradio app"),J(j,"class","container p-0 flex-grow space-iframe"),J(j,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),J(j,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),Ua(U.src,kl="https://autoevaluate-leaderboards.hf.space")||J(U,"src",kl),J(U,"frameborder","0"),J(U,"height","450"),J(U,"title","Gradio app"),J(U,"class","container p-0 flex-grow space-iframe"),J(U,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),J(U,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Aa(document.head,d),l(e,T,t),l(e,w,t),l(e,g,t),u(v,e,t),l(e,Jt,t),l(e,Z,t),l(e,jt,t),u(x,e,t),l(e,Ut,t),l(e,W,t),l(e,ft,t),u(_,e,t),l(e,gt,t),l(e,B,t),l(e,Ct,t),u(N,e,t),l(e,It,t),u(C,e,t),l(e,bt,t),l(e,Q,t),l(e,At,t),u(E,e,t),l(e,$t,t),l(e,R,t),l(e,kt,t),u(G,e,t),l(e,vt,t),l(e,Y,t),l(e,Zt,t),u(z,e,t),l(e,xt,t),l(e,F,t),l(e,Wt,t),u(V,e,t),l(e,_t,t),l(e,X,t),l(e,Bt,t),u(H,e,t),l(e,Nt,t),l(e,D,t),l(e,Qt,t),u(S,e,t),l(e,Et,t),l(e,q,t),l(e,Rt,t),u(L,e,t),l(e,Gt,t),l(e,j,t),l(e,Yt,t),l(e,P,t),l(e,zt,t),u(O,e,t),l(e,Ft,t),l(e,K,t),l(e,Vt,t),l(e,U,t),l(e,Xt,t),u(ee,e,t),l(e,Ht,t),u(te,e,t),l(e,Dt,t),l(e,se,t),l(e,St,t),u(le,e,t),l(e,qt,t),l(e,ae,t),l(e,Lt,t),u(ne,e,t),l(e,Pt,t),l(e,ie,t),l(e,Ot,t),u(Me,e,t),l(e,Kt,t),l(e,re,t),l(e,es,t),u(pe,e,t),l(e,ts,t),l(e,oe,t),l(e,ss,t),u(ue,e,t),l(e,ls,t),l(e,ye,t),l(e,as,t),u(ce,e,t),l(e,ns,t),l(e,me,t),l(e,is,t),l(e,de,t),l(e,Ms,t),l(e,he,t),l(e,rs,t),l(e,we,t),l(e,ps,t),l(e,Te,t),l(e,os,t),l(e,Je,t),l(e,us,t),u(je,e,t),l(e,ys,t),l(e,Ue,t),l(e,cs,t),u(fe,e,t),l(e,ms,t),l(e,ge,t),l(e,ds,t),u(Ce,e,t),l(e,hs,t),l(e,Ie,t),l(e,ws,t),u(be,e,t),l(e,Ts,t),l(e,Ae,t),l(e,Js,t),l(e,$e,t),l(e,js,t),u(I,e,t),l(e,Us,t),l(e,ke,t),l(e,fs,t),u(ve,e,t),l(e,gs,t),l(e,Ze,t),l(e,Cs,t),u(xe,e,t),l(e,Is,t),l(e,We,t),l(e,bs,t),u(_e,e,t),l(e,As,t),u(b,e,t),l(e,$s,t),l(e,Be,t),l(e,ks,t),u(Ne,e,t),l(e,vs,t),l(e,Qe,t),l(e,Zs,t),u(Ee,e,t),l(e,xs,t),u(Re,e,t),l(e,Ws,t),l(e,Ge,t),l(e,_s,t),u(Ye,e,t),l(e,Bs,t),l(e,ze,t),l(e,Ns,t),u(Fe,e,t),l(e,Qs,t),l(e,Ve,t),l(e,Es,t),l(e,Xe,t),l(e,Rs,t),l(e,He,t),l(e,Gs,t),u(De,e,t),l(e,Ys,t),l(e,Se,t),l(e,zs,t),u(qe,e,t),l(e,Fs,t),l(e,Le,t),l(e,Vs,t),u(Pe,e,t),l(e,Xs,t),u(A,e,t),l(e,Hs,t),l(e,Oe,t),l(e,Ds,t),u(Ke,e,t),l(e,Ss,t),l(e,et,t),l(e,qs,t),u(tt,e,t),l(e,Ls,t),u($,e,t),l(e,Ps,t),l(e,st,t),l(e,Os,t),u(lt,e,t),l(e,Ks,t),l(e,at,t),l(e,el,t),l(e,nt,t),l(e,tl,t),l(e,it,t),l(e,sl,t),u(Mt,e,t),l(e,ll,t),l(e,rt,t),l(e,al,t),u(pt,e,t),l(e,nl,t),l(e,ot,t),l(e,il,t),u(ut,e,t),l(e,Ml,t),l(e,yt,t),l(e,rl,t),u(ct,e,t),l(e,pl,t),u(mt,e,t),l(e,ol,t),l(e,dt,t),l(e,ul,t),l(e,ht,t),l(e,yl,t),l(e,wt,t),cl=!0},p(e,[t]){const ha={};t&2&&(ha.$$scope={dirty:t,ctx:e}),C.$set(ha);const wa={};t&2&&(wa.$$scope={dirty:t,ctx:e}),I.$set(wa);const Ta={};t&2&&(Ta.$$scope={dirty:t,ctx:e}),b.$set(Ta);const Ja={};t&2&&(Ja.$$scope={dirty:t,ctx:e}),A.$set(Ja);const ja={};t&2&&(ja.$$scope={dirty:t,ctx:e}),$.$set(ja)},i(e){cl||(y(v.$$.fragment,e),y(x.$$.fragment,e),y(_.$$.fragment,e),y(N.$$.fragment,e),y(C.$$.fragment,e),y(E.$$.fragment,e),y(G.$$.fragment,e),y(z.$$.fragment,e),y(V.$$.fragment,e),y(H.$$.fragment,e),y(S.$$.fragment,e),y(L.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(Me.$$.fragment,e),y(pe.$$.fragment,e),y(ue.$$.fragment,e),y(ce.$$.fragment,e),y(je.$$.fragment,e),y(fe.$$.fragment,e),y(Ce.$$.fragment,e),y(be.$$.fragment,e),y(I.$$.fragment,e),y(ve.$$.fragment,e),y(xe.$$.fragment,e),y(_e.$$.fragment,e),y(b.$$.fragment,e),y(Ne.$$.fragment,e),y(Ee.$$.fragment,e),y(Re.$$.fragment,e),y(Ye.$$.fragment,e),y(Fe.$$.fragment,e),y(De.$$.fragment,e),y(qe.$$.fragment,e),y(Pe.$$.fragment,e),y(A.$$.fragment,e),y(Ke.$$.fragment,e),y(tt.$$.fragment,e),y($.$$.fragment,e),y(lt.$$.fragment,e),y(Mt.$$.fragment,e),y(pt.$$.fragment,e),y(ut.$$.fragment,e),y(ct.$$.fragment,e),y(mt.$$.fragment,e),cl=!0)},o(e){c(v.$$.fragment,e),c(x.$$.fragment,e),c(_.$$.fragment,e),c(N.$$.fragment,e),c(C.$$.fragment,e),c(E.$$.fragment,e),c(G.$$.fragment,e),c(z.$$.fragment,e),c(V.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(L.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(Me.$$.fragment,e),c(pe.$$.fragment,e),c(ue.$$.fragment,e),c(ce.$$.fragment,e),c(je.$$.fragment,e),c(fe.$$.fragment,e),c(Ce.$$.fragment,e),c(be.$$.fragment,e),c(I.$$.fragment,e),c(ve.$$.fragment,e),c(xe.$$.fragment,e),c(_e.$$.fragment,e),c(b.$$.fragment,e),c(Ne.$$.fragment,e),c(Ee.$$.fragment,e),c(Re.$$.fragment,e),c(Ye.$$.fragment,e),c(Fe.$$.fragment,e),c(De.$$.fragment,e),c(qe.$$.fragment,e),c(Pe.$$.fragment,e),c(A.$$.fragment,e),c(Ke.$$.fragment,e),c(tt.$$.fragment,e),c($.$$.fragment,e),c(lt.$$.fragment,e),c(Mt.$$.fragment,e),c(pt.$$.fragment,e),c(ut.$$.fragment,e),c(ct.$$.fragment,e),c(mt.$$.fragment,e),cl=!1},d(e){e&&(s(T),s(w),s(g),s(Jt),s(Z),s(jt),s(Ut),s(W),s(ft),s(gt),s(B),s(Ct),s(It),s(bt),s(Q),s(At),s($t),s(R),s(kt),s(vt),s(Y),s(Zt),s(xt),s(F),s(Wt),s(_t),s(X),s(Bt),s(Nt),s(D),s(Qt),s(Et),s(q),s(Rt),s(Gt),s(j),s(Yt),s(P),s(zt),s(Ft),s(K),s(Vt),s(U),s(Xt),s(Ht),s(Dt),s(se),s(St),s(qt),s(ae),s(Lt),s(Pt),s(ie),s(Ot),s(Kt),s(re),s(es),s(ts),s(oe),s(ss),s(ls),s(ye),s(as),s(ns),s(me),s(is),s(de),s(Ms),s(he),s(rs),s(we),s(ps),s(Te),s(os),s(Je),s(us),s(ys),s(Ue),s(cs),s(ms),s(ge),s(ds),s(hs),s(Ie),s(ws),s(Ts),s(Ae),s(Js),s($e),s(js),s(Us),s(ke),s(fs),s(gs),s(Ze),s(Cs),s(Is),s(We),s(bs),s(As),s($s),s(Be),s(ks),s(vs),s(Qe),s(Zs),s(xs),s(Ws),s(Ge),s(_s),s(Bs),s(ze),s(Ns),s(Qs),s(Ve),s(Es),s(Xe),s(Rs),s(He),s(Gs),s(Ys),s(Se),s(zs),s(Fs),s(Le),s(Vs),s(Xs),s(Hs),s(Oe),s(Ds),s(Ss),s(et),s(qs),s(Ls),s(Ps),s(st),s(Os),s(Ks),s(at),s(el),s(nt),s(tl),s(it),s(sl),s(ll),s(rt),s(al),s(nl),s(ot),s(il),s(Ml),s(yt),s(rl),s(pl),s(ol),s(dt),s(ul),s(ht),s(yl),s(wt)),s(d),m(v,e),m(x,e),m(_,e),m(N,e),m(C,e),m(E,e),m(G,e),m(z,e),m(V,e),m(H,e),m(S,e),m(L,e),m(O,e),m(ee,e),m(te,e),m(le,e),m(ne,e),m(Me,e),m(pe,e),m(ue,e),m(ce,e),m(je,e),m(fe,e),m(Ce,e),m(be,e),m(I,e),m(ve,e),m(xe,e),m(_e,e),m(b,e),m(Ne,e),m(Ee,e),m(Re,e),m(Ye,e),m(Fe,e),m(De,e),m(qe,e),m(Pe,e),m(A,e),m(Ke,e),m(tt,e),m($,e),m(lt,e),m(Mt,e),m(pt,e),m(ut,e),m(ct,e),m(mt,e)}}}const Na='{"title":"Fine-tuning a model for music classification","local":"fine-tuning-a-model-for-music-classification","sections":[{"title":"The Dataset","local":"the-dataset","sections":[],"depth":2},{"title":"Picking a pretrained model for audio classification","local":"picking-a-pretrained-model-for-audio-classification","sections":[],"depth":2},{"title":"From audio to machine learning features","local":"from-audio-to-machine-learning-features","sections":[],"depth":2},{"title":"Preprocessing the data","local":"preprocessing-the-data","sections":[],"depth":2},{"title":"Fine-tuning the model","local":"fine-tuning-the-model","sections":[],"depth":2},{"title":"Share Model","local":"share-model","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Qa(f){return ga(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fa extends Ca{constructor(d){super(),Ia(this,d,Qa,Ba,fa,{})}}export{Fa as component};
