import{s as Ge,o as Ze,n as _e}from"../chunks/scheduler.37c15a92.js";import{S as ve,i as Re,g as a,s as n,r as m,A as Ce,h as i,f as l,c as r,j as we,u as M,x as o,k as Ue,y as We,a as s,v as g,d as c,t as u,w as f}from"../chunks/index.2bf4358c.js";import{T as ke}from"../chunks/Tip.363c041f.js";import{Y as He}from"../chunks/Youtube.1e50a667.js";import{C as b}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Ie}from"../chunks/CourseFloatingBanner.06521e8b.js";import{F as Fe}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as Ot}from"../chunks/Heading.8ada512a.js";function Xe(h){let p,d='💡 如果您想在训练期间自动将模型上传到 Hub，请将push_to_hub=True添加到TrainingArguments之中. 我们将在<a href="/course/chapter4/3">第四章</a>中详细介绍这部分。';return{c(){p=a("p"),p.innerHTML=d},l(T){p=i(T,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1ef1n6h"&&(p.innerHTML=d)},m(T,$){s(T,p,$)},p:_e,d(T){T&&l(p)}}}function Ee(h){let p,d="✏️ <strong>试试看!</strong> 使用您在第 2 节中进行的数据处理，在 GLUE SST-2 数据集上微调模型。";return{c(){p=a("p"),p.innerHTML=d},l(T){p=i(T,"P",{"data-svelte-h":!0}),o(p)!=="svelte-jriyod"&&(p.innerHTML=d)},m(T,$){s(T,p,$)},p:_e,d(T){T&&l(p)}}}function ze(h){let p,d,T,$,y,mt,w,Mt,U,gt,k,ct,_,te='🤗 Transformers提供了一个 <strong>Trainer</strong> 类来帮助您在自己的数据集上微调任何预训练模型。完成上一节中的所有数据预处理工作后，您只需要执行几个步骤来创建 <strong>Trainer</strong> .最难的部分可能是为 <strong>Trainer.train()</strong>配置运行环境，因为它在 CPU 上运行速度会非常慢。如果您没有设置 GPU，您可以访问免费的 GPU 或 TPU<a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',ut,G,ee="下面的示例假设您已经执行了上一节中的示例。下面这段代码，概括了您需要提前运行的代码：",ft,Z,Tt,v,bt,R,le="在我们定义我们的 <strong>Trainer</strong> 之前首先要定义一个 <strong>TrainingArguments</strong> 类，它将包含 <strong>Trainer</strong>用于训练和评估的所有超参数。您唯一必须提供的参数是保存训练模型的目录，以及训练过程中的检查点。对于其余的参数，您可以保留默认值，这对于基本微调应该非常有效。",dt,C,$t,j,yt,W,se="第二步是定义我们的模型。正如在[之前的章节](/2_Using Transformers/Introduction)一样，我们将使用 <strong>AutoModelForSequenceClassification</strong> 类，它有两个参数：",jt,H,Jt,I,ne='你会注意到，和<a href="/course/chapter2">第二章</a>不一样的是，在实例化此预训练模型后会收到警告。这是因为 BERT 没有在句子对分类方面进行过预训练，所以预训练模型的头部已经被丢弃，而是添加了一个适合句子序列分类的新头部。警告表明一些权重没有使用（对应于丢弃的预训练头的那些），而其他一些权重被随机初始化（新头的那些）。最后鼓励您训练模型，这正是我们现在要做的。',ht,F,re="一旦我们有了我们的模型，我们就可以定义一个 <strong>Trainer</strong> 通过将之前构造的所有对象传递给它——我们的<strong>model</strong> 、<strong>training_args</strong> ，训练和验证数据集，<strong>data_collator</strong> ，和 <strong>tokenizer</strong> ：",wt,X,Ut,E,ae="请注意，当您在这里完成<strong>tokenizer</strong>后，默认 <strong>Trainer</strong>使用 的<strong>data_collator</strong>会使用之前预定义的 <strong>DataCollatorWithPadding</strong> ，因此您可以在这个例子中跳过 <strong>data_collator=data_collator</strong>。在第 2 节中向您展示这部分处理仍然很重要！",kt,z,ie="为了让预训练模型在在我们的数据集上微调，我们只需要调用<strong>Trainer</strong>的<strong>train()</strong> 方法 ：",_t,V,Gt,B,pe="这将开始微调（在GPU上应该需要几分钟），并每500步报告一次训练损失。但是，它不会告诉您模型的性能如何（或质量如何）。这是因为:",Zt,Y,oe="<li>我们没有通过将<strong>evaluation_strategy</strong>设置为“<strong>steps</strong>”(在每次更新参数的时候评估)或“<strong>epoch</strong>”(在每个epoch结束时评估)来告诉<strong>Trainer</strong>在训练期间进行评估。</li> <li>我们没有为<strong>Trainer</strong>提供一个<strong>compute_metrics()</strong>函数来直接计算模型的好坏(否则评估将只输出loss，这不是一个非常直观的数字)。</li>",vt,x,Rt,A,me="让我们看看如何构建一个有用的 <strong>compute_metrics()</strong> 函数并在我们下次训练时使用它。该函数必须采用 <strong>EvalPrediction</strong> 对象（带有 <strong>predictions</strong> 和 <strong>label_ids</strong> 字段的参数元组）并将返回一个字符串到浮点数的字典（字符串是返回的指标的名称，而浮点数是它们的值）。我们可以使用 <strong>Trainer.predict()</strong> 命令来使用我们的模型进行预测：",Ct,N,Wt,Q,Ht,L,Me="<strong>predict()</strong> 的输出结果是具有三个字段的命名元组： <strong>predictions</strong> , <strong>label_ids</strong> ， 和 <strong>metrics</strong> .这 <strong>metrics</strong> 字段将只包含传递的数据集的loss，以及一些运行时间（预测所需的总时间和平均时间）。如果我们定义了自己的 <strong>compute_metrics()</strong> 函数并将其传递给 <strong>Trainer</strong> ，该字段还将包含<strong>compute_metrics()</strong>的结果。",It,P,ge='<strong>predict()</strong> 方法是具有三个字段的命名元组： <strong>predictions</strong> , <strong>label_ids</strong> ， 和 <strong>metrics</strong> .这 <strong>metrics</strong> 字段将只包含传递的数据集的loss，以及一些运行时间（预测所需的总时间和平均时间）。如果我们定义了自己的 <strong>compute_metrics()</strong> 函数并将其传递给 <strong>Trainer</strong> ，该字段还将包含<strong>compute_metrics()</strong> 的结果。如你看到的， <strong>predictions</strong> 是一个形状为 408 x 2 的二维数组（408 是我们使用的数据集中元素的数量）。这些是我们传递给<strong>predict()</strong>的数据集的每个元素的结果(logits)（正如你在<a href="/course/chapter2">之前的章节</a>看到的情况）。要将我们的预测的可以与真正的标签进行比较，我们需要在第二个轴上取最大值的索引：',Ft,q,Xt,S,ce='现在建立我们的 <strong>compute_metric()</strong> 函数来较为直观地评估模型的好坏，我们将使用 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a> 库中的指标。我们可以像加载数据集一样轻松加载与 MRPC 数据集关联的指标，这次使用 <strong>evaluate.load()</strong> 函数。返回的对象有一个 <strong>compute()</strong>方法我们可以用来进行度量计算的方法：',Et,K,zt,D,Vt,O,ue='您获得的确切结果可能会有所不同，因为模型头的随机初始化可能会影响最终建立的模型。在这里，我们可以看到我们的模型在验证集上的准确率为 85.78%，F1 分数为 89.97。这是用于评估 GLUE 基准的 MRPC 数据集结果的两个指标。而在<a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT 论文</a>中展示的基础模型的 F1 分数为 88.9。那是 <strong>uncased</strong> 模型，而我们目前正在使用 <strong>cased</strong> 模型，通过改进得到了更好的结果。',Bt,tt,fe="最后将所有东西打包在一起，我们得到了我们的 <strong>compute_metrics()</strong> 函数：",Yt,et,xt,lt,Te="为了查看模型在每个训练周期结束的好坏，下面是我们如何使用<strong>compute_metrics()</strong>函数定义一个新的 <strong>Trainer</strong> ：",At,st,Nt,nt,be="请注意，我们设置了了一个新的 <strong>TrainingArguments</strong> 它的<strong>evaluation_strategy</strong> 设置为 <strong>epoch</strong> 并创建了一个新模型。如果不创建新的模型就直接训练，就只会继续训练之前我们已经训练过的模型。要启动新的训练运行，我们执行：",Qt,rt,Lt,at,de="这一次，它将在训练loss之外，还会输出每个 epoch 结束时的验证loss和指标。同样，由于模型的随机头部初始化，您达到的准确率/F1 分数可能与我们发现的略有不同，但它应该在同一范围内。",Pt,it,$e="这 <strong>Trainer</strong> 将在多个 GPU 或 TPU 上开箱即用，并提供许多选项，例如混合精度训练（在训练的参数中使用 <strong>fp16 = True</strong> ）。我们将在第 10 章讨论它支持的所有内容。",qt,pt,ye='使用<strong>Trainer</strong> API微调的介绍到此结束。对最常见的 NLP 任务执行此操作的示例将在<a href="/course/chapter7">第 7 章</a>中给出，但现在让我们看看如何在纯 PyTorch 中执行相同的操作。',St,J,Kt,ot,Dt;return y=new Fe({props:{fw:h[0]}}),w=new Ot({props:{title:"使用 Trainer API 微调模型",local:"使用 Trainer API 微调模型",headingTag:"h1"}}),U=new Ie({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter3/section3.ipynb"}]}}),k=new He({props:{id:"nvBXf7s7vTI"}}),Z=new b({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),v=new Ot({props:{title:"Training",local:"Training",headingTag:"h3"}}),C=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),j=new ke({props:{$$slots:{default:[Xe]},$$scope:{ctx:h}}}),H=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),X=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),V=new b({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),x=new Ot({props:{title:"评估",local:"评估",headingTag:"h3"}}),N=new b({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),Q=new b({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),q=new b({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),K=new b({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),D=new b({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),et=new b({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),st=new b({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),rt=new b({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),J=new ke({props:{$$slots:{default:[Ee]},$$scope:{ctx:h}}}),{c(){p=a("meta"),d=n(),T=a("p"),$=n(),m(y.$$.fragment),mt=n(),m(w.$$.fragment),Mt=n(),m(U.$$.fragment),gt=n(),m(k.$$.fragment),ct=n(),_=a("p"),_.innerHTML=te,ut=n(),G=a("p"),G.textContent=ee,ft=n(),m(Z.$$.fragment),Tt=n(),m(v.$$.fragment),bt=n(),R=a("p"),R.innerHTML=le,dt=n(),m(C.$$.fragment),$t=n(),m(j.$$.fragment),yt=n(),W=a("p"),W.innerHTML=se,jt=n(),m(H.$$.fragment),Jt=n(),I=a("p"),I.innerHTML=ne,ht=n(),F=a("p"),F.innerHTML=re,wt=n(),m(X.$$.fragment),Ut=n(),E=a("p"),E.innerHTML=ae,kt=n(),z=a("p"),z.innerHTML=ie,_t=n(),m(V.$$.fragment),Gt=n(),B=a("p"),B.textContent=pe,Zt=n(),Y=a("ol"),Y.innerHTML=oe,vt=n(),m(x.$$.fragment),Rt=n(),A=a("p"),A.innerHTML=me,Ct=n(),m(N.$$.fragment),Wt=n(),m(Q.$$.fragment),Ht=n(),L=a("p"),L.innerHTML=Me,It=n(),P=a("p"),P.innerHTML=ge,Ft=n(),m(q.$$.fragment),Xt=n(),S=a("p"),S.innerHTML=ce,Et=n(),m(K.$$.fragment),zt=n(),m(D.$$.fragment),Vt=n(),O=a("p"),O.innerHTML=ue,Bt=n(),tt=a("p"),tt.innerHTML=fe,Yt=n(),m(et.$$.fragment),xt=n(),lt=a("p"),lt.innerHTML=Te,At=n(),m(st.$$.fragment),Nt=n(),nt=a("p"),nt.innerHTML=be,Qt=n(),m(rt.$$.fragment),Lt=n(),at=a("p"),at.textContent=de,Pt=n(),it=a("p"),it.innerHTML=$e,qt=n(),pt=a("p"),pt.innerHTML=ye,St=n(),m(J.$$.fragment),Kt=n(),ot=a("p"),this.h()},l(t){const e=Ce("svelte-u9bgzb",document.head);p=i(e,"META",{name:!0,content:!0}),e.forEach(l),d=r(t),T=i(t,"P",{}),we(T).forEach(l),$=r(t),M(y.$$.fragment,t),mt=r(t),M(w.$$.fragment,t),Mt=r(t),M(U.$$.fragment,t),gt=r(t),M(k.$$.fragment,t),ct=r(t),_=i(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-ufvylh"&&(_.innerHTML=te),ut=r(t),G=i(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-plcive"&&(G.textContent=ee),ft=r(t),M(Z.$$.fragment,t),Tt=r(t),M(v.$$.fragment,t),bt=r(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1sbiqgc"&&(R.innerHTML=le),dt=r(t),M(C.$$.fragment,t),$t=r(t),M(j.$$.fragment,t),yt=r(t),W=i(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-oh4nya"&&(W.innerHTML=se),jt=r(t),M(H.$$.fragment,t),Jt=r(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-8phydx"&&(I.innerHTML=ne),ht=r(t),F=i(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-btlcha"&&(F.innerHTML=re),wt=r(t),M(X.$$.fragment,t),Ut=r(t),E=i(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-744qtc"&&(E.innerHTML=ae),kt=r(t),z=i(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-ygtelo"&&(z.innerHTML=ie),_t=r(t),M(V.$$.fragment,t),Gt=r(t),B=i(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-thj21i"&&(B.textContent=pe),Zt=r(t),Y=i(t,"OL",{"data-svelte-h":!0}),o(Y)!=="svelte-24ojay"&&(Y.innerHTML=oe),vt=r(t),M(x.$$.fragment,t),Rt=r(t),A=i(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1bb1wl0"&&(A.innerHTML=me),Ct=r(t),M(N.$$.fragment,t),Wt=r(t),M(Q.$$.fragment,t),Ht=r(t),L=i(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1whbur"&&(L.innerHTML=Me),It=r(t),P=i(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1pskmbr"&&(P.innerHTML=ge),Ft=r(t),M(q.$$.fragment,t),Xt=r(t),S=i(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1cx55xv"&&(S.innerHTML=ce),Et=r(t),M(K.$$.fragment,t),zt=r(t),M(D.$$.fragment,t),Vt=r(t),O=i(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-lbv83p"&&(O.innerHTML=ue),Bt=r(t),tt=i(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1i4nzwc"&&(tt.innerHTML=fe),Yt=r(t),M(et.$$.fragment,t),xt=r(t),lt=i(t,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-17oao7o"&&(lt.innerHTML=Te),At=r(t),M(st.$$.fragment,t),Nt=r(t),nt=i(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-9qu831"&&(nt.innerHTML=be),Qt=r(t),M(rt.$$.fragment,t),Lt=r(t),at=i(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1p79gpj"&&(at.textContent=de),Pt=r(t),it=i(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-6ifubr"&&(it.innerHTML=$e),qt=r(t),pt=i(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1yzj7l2"&&(pt.innerHTML=ye),St=r(t),M(J.$$.fragment,t),Kt=r(t),ot=i(t,"P",{}),we(ot).forEach(l),this.h()},h(){Ue(p,"name","hf:doc:metadata"),Ue(p,"content",Ve)},m(t,e){We(document.head,p),s(t,d,e),s(t,T,e),s(t,$,e),g(y,t,e),s(t,mt,e),g(w,t,e),s(t,Mt,e),g(U,t,e),s(t,gt,e),g(k,t,e),s(t,ct,e),s(t,_,e),s(t,ut,e),s(t,G,e),s(t,ft,e),g(Z,t,e),s(t,Tt,e),g(v,t,e),s(t,bt,e),s(t,R,e),s(t,dt,e),g(C,t,e),s(t,$t,e),g(j,t,e),s(t,yt,e),s(t,W,e),s(t,jt,e),g(H,t,e),s(t,Jt,e),s(t,I,e),s(t,ht,e),s(t,F,e),s(t,wt,e),g(X,t,e),s(t,Ut,e),s(t,E,e),s(t,kt,e),s(t,z,e),s(t,_t,e),g(V,t,e),s(t,Gt,e),s(t,B,e),s(t,Zt,e),s(t,Y,e),s(t,vt,e),g(x,t,e),s(t,Rt,e),s(t,A,e),s(t,Ct,e),g(N,t,e),s(t,Wt,e),g(Q,t,e),s(t,Ht,e),s(t,L,e),s(t,It,e),s(t,P,e),s(t,Ft,e),g(q,t,e),s(t,Xt,e),s(t,S,e),s(t,Et,e),g(K,t,e),s(t,zt,e),g(D,t,e),s(t,Vt,e),s(t,O,e),s(t,Bt,e),s(t,tt,e),s(t,Yt,e),g(et,t,e),s(t,xt,e),s(t,lt,e),s(t,At,e),g(st,t,e),s(t,Nt,e),s(t,nt,e),s(t,Qt,e),g(rt,t,e),s(t,Lt,e),s(t,at,e),s(t,Pt,e),s(t,it,e),s(t,qt,e),s(t,pt,e),s(t,St,e),g(J,t,e),s(t,Kt,e),s(t,ot,e),Dt=!0},p(t,[e]){const je={};e&1&&(je.fw=t[0]),y.$set(je);const Je={};e&2&&(Je.$$scope={dirty:e,ctx:t}),j.$set(Je);const he={};e&2&&(he.$$scope={dirty:e,ctx:t}),J.$set(he)},i(t){Dt||(c(y.$$.fragment,t),c(w.$$.fragment,t),c(U.$$.fragment,t),c(k.$$.fragment,t),c(Z.$$.fragment,t),c(v.$$.fragment,t),c(C.$$.fragment,t),c(j.$$.fragment,t),c(H.$$.fragment,t),c(X.$$.fragment,t),c(V.$$.fragment,t),c(x.$$.fragment,t),c(N.$$.fragment,t),c(Q.$$.fragment,t),c(q.$$.fragment,t),c(K.$$.fragment,t),c(D.$$.fragment,t),c(et.$$.fragment,t),c(st.$$.fragment,t),c(rt.$$.fragment,t),c(J.$$.fragment,t),Dt=!0)},o(t){u(y.$$.fragment,t),u(w.$$.fragment,t),u(U.$$.fragment,t),u(k.$$.fragment,t),u(Z.$$.fragment,t),u(v.$$.fragment,t),u(C.$$.fragment,t),u(j.$$.fragment,t),u(H.$$.fragment,t),u(X.$$.fragment,t),u(V.$$.fragment,t),u(x.$$.fragment,t),u(N.$$.fragment,t),u(Q.$$.fragment,t),u(q.$$.fragment,t),u(K.$$.fragment,t),u(D.$$.fragment,t),u(et.$$.fragment,t),u(st.$$.fragment,t),u(rt.$$.fragment,t),u(J.$$.fragment,t),Dt=!1},d(t){t&&(l(d),l(T),l($),l(mt),l(Mt),l(gt),l(ct),l(_),l(ut),l(G),l(ft),l(Tt),l(bt),l(R),l(dt),l($t),l(yt),l(W),l(jt),l(Jt),l(I),l(ht),l(F),l(wt),l(Ut),l(E),l(kt),l(z),l(_t),l(Gt),l(B),l(Zt),l(Y),l(vt),l(Rt),l(A),l(Ct),l(Wt),l(Ht),l(L),l(It),l(P),l(Ft),l(Xt),l(S),l(Et),l(zt),l(Vt),l(O),l(Bt),l(tt),l(Yt),l(xt),l(lt),l(At),l(Nt),l(nt),l(Qt),l(Lt),l(at),l(Pt),l(it),l(qt),l(pt),l(St),l(Kt),l(ot)),l(p),f(y,t),f(w,t),f(U,t),f(k,t),f(Z,t),f(v,t),f(C,t),f(j,t),f(H,t),f(X,t),f(V,t),f(x,t),f(N,t),f(Q,t),f(q,t),f(K,t),f(D,t),f(et,t),f(st,t),f(rt,t),f(J,t)}}}const Ve='{"title":"使用 Trainer API 微调模型","local":"使用 Trainer API 微调模型","sections":[{"title":"Training","local":"Training","sections":[],"depth":3},{"title":"评估","local":"评估","sections":[],"depth":3}],"depth":1}';function Be(h,p,d){let T="pt";return Ze(()=>{const $=new URLSearchParams(window.location.search);d(0,T=$.get("fw")||"pt")}),[T]}class Se extends ve{constructor(p){super(),Re(this,p,Be,ze,Ge,{})}}export{Se as component};
